package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import androidx.room.Dao
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.PersonPicture
import kotlin.Long
import kotlin.Unit

@Dao
public actual abstract class PersonPictureDao : BaseDao<PersonPicture> {
  @Query(`value` =
      "\n     REPLACE INTO PersonPictureReplicate(ppPk, ppDestination)\n      SELECT DISTINCT PersonPicture.personPictureUid AS ppPk,\n             :newNodeId AS ppDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  1048576\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN PersonPicture\n                  ON PersonPicture.personPicturePersonUid = Person.personUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND PersonPicture.personPictureLct != COALESCE(\n             (SELECT ppVersionId\n                FROM PersonPictureReplicate\n               WHERE ppPk = PersonPicture.personPictureUid\n                 AND ppDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ppPk, ppDestination) DO UPDATE\n             SET ppPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO PersonPictureReplicate(ppPk, ppDestination)\n  SELECT DISTINCT PersonPicture.personPictureUid AS ppUid,\n         UserSession.usClientNodeId AS ppDestination\n    FROM ChangeLog\n         JOIN PersonPicture\n              ON ChangeLog.chTableId = 50\n                 AND ChangeLog.chEntityPk = PersonPicture.personPictureUid\n         JOIN Person\n              ON Person.personUid = PersonPicture.personPicturePersonUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              1048576\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND PersonPicture.personPictureLct != COALESCE(\n         (SELECT ppVersionId\n            FROM PersonPictureReplicate\n           WHERE ppPk = PersonPicture.personPictureUid\n             AND ppDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ppPk, ppDestination) DO UPDATE\n     SET ppPending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Query(`value` =
      "SELECT * FROM PersonPicture \n        WHERE personPicturePersonUid = :personUid\n        AND CAST(personPictureActive AS INTEGER) = 1\n        ORDER BY picTimestamp DESC LIMIT 1")
  public actual abstract suspend fun findByPersonUidAsync(personUid: Long): PersonPicture?

  @Query(`value` =
      "SELECT * FROM PersonPicture where personPicturePersonUid = :personUid ORDER BY  picTimestamp DESC LIMIT 1")
  public actual abstract fun findByPersonUidLive(personUid: Long): LiveData<PersonPicture?>

  @Update(onConflict = 3)
  public actual abstract suspend fun updateAsync(personPicture: PersonPicture): Unit
}
