/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.util;

import com.ustadmobile.lib.util.RangeResponse;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\r"}, d2={"RANGE_CONTENT_ACCEPT_RANGE_HEADER", "", "getRANGE_CONTENT_ACCEPT_RANGE_HEADER", "()Ljava/lang/String;", "RANGE_CONTENT_LENGTH_HEADER", "getRANGE_CONTENT_LENGTH_HEADER", "RANGE_CONTENT_RANGE_HEADER", "getRANGE_CONTENT_RANGE_HEADER", "parseRangeRequestHeader", "Lcom/ustadmobile/lib/util/RangeResponse;", "rangeHeader", "totalLength", "", "lib-util_release"})
public final class RangeUtilKt {
    @NotNull
    private static final String RANGE_CONTENT_LENGTH_HEADER = "Content-Length";
    @NotNull
    private static final String RANGE_CONTENT_RANGE_HEADER = "Content-Range";
    @NotNull
    private static final String RANGE_CONTENT_ACCEPT_RANGE_HEADER = "Accept-Ranges";

    @NotNull
    public static final String getRANGE_CONTENT_LENGTH_HEADER() {
        return RANGE_CONTENT_LENGTH_HEADER;
    }

    @NotNull
    public static final String getRANGE_CONTENT_RANGE_HEADER() {
        return RANGE_CONTENT_RANGE_HEADER;
    }

    @NotNull
    public static final String getRANGE_CONTENT_ACCEPT_RANGE_HEADER() {
        return RANGE_CONTENT_ACCEPT_RANGE_HEADER;
    }

    @NotNull
    public static final RangeResponse parseRangeRequestHeader(@NotNull String rangeHeader, long totalLength) {
        Intrinsics.checkNotNullParameter((Object)rangeHeader, (String)"rangeHeader");
        long fromByte = -1L;
        long toByte = -1L;
        int statusCode = 0;
        Map responseHeaders = MapsKt.emptyMap();
        long actualContentLength = 0L;
        try {
            String string2 = rangeHeader.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String header = string2;
            int dashPos = StringsKt.indexOf$default((CharSequence)header, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (dashPos > 0) {
                String string3 = header.substring(0, dashPos);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                fromByte = Long.parseLong(string3);
            }
            if (dashPos == header.length() - 1) {
                toByte = totalLength - 1L;
            } else if (dashPos > 0) {
                String string4 = header.substring(dashPos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                toByte = Long.parseLong(string4);
            }
            if (fromByte == -1L || toByte == -1L) {
                statusCode = 400;
            } else if (fromByte >= 0L && fromByte < totalLength && toByte > 0L && toByte <= totalLength) {
                actualContentLength = toByte + 1L - fromByte;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RANGE_CONTENT_LENGTH_HEADER, (Object)String.valueOf(actualContentLength)), TuplesKt.to((Object)RANGE_CONTENT_RANGE_HEADER, (Object)("bytes " + fromByte + '-' + toByte + '/' + totalLength)), TuplesKt.to((Object)RANGE_CONTENT_ACCEPT_RANGE_HEADER, (Object)"bytes")};
                responseHeaders = MapsKt.mapOf((Pair[])pairArray);
                statusCode = 206;
            } else {
                statusCode = 416;
            }
        }
        catch (Exception e) {
            statusCode = 400;
        }
        return new RangeResponse(statusCode, fromByte, toByte, actualContentLength, responseHeaders);
    }
}

