
/**
 * Simple Javascript to handle making an Experience API statement for Lamsustad content.
 * The content calls console.log(n) where n is the page number. We get endpoint and auth 
 * params using the Rustici launch method.
 *
 * We expect a page_count.json file to provide the page count for each book.
 */

//eg ?endpoint=http%3A%2F%2Flocalhost%2Fxapi&auth=OjFjMGY4NTYxNzUwOGI4YWY0NjFkNzU5MWUxMzE1ZGQ1&actor=%7B%20"name"%20%3A%20%5B"Project%20Tin%20Can"%5D%2C%20"mbox"%20%3A%20%5B"mailto%3Atincan%40scorm.com"%5D%20%7D

var _lrs = null;

var _actor = null;

var _activityId = "http://demo.com/";

var pageStartTime = new Date().getTime();

function setupFromLaunchParams() {
     var params = new URLSearchParams(location.search.substring(1));
     if(params.get("actor")) {
         _actor = TinCan.Agent.fromJSON(params.get("actor"));
     }
     
     if(params.get("activity_id")) {
         _activityId = params.get("activity_id")
     }
     
     _lrs = new TinCan.LRS({
         "endpoint": params.get("endpoint"),
         "auth": params.get("auth"),
         "user": _actor,
         "allowFail" : false
     });
     
   
}


function format8601Duration(durationInMs) {
        var msPerHour = 1000 * 60 * 60;
        var hours = Math.floor(durationInMs / msPerHour);
        var durationRemaining = durationInMs % msPerHour;

        var msPerMin = 60 * 1000;
        var mins = Math.floor(durationRemaining / msPerMin);
        durationRemaining %= msPerMin;

        var msPerS = 1000;
        var secs = Math.floor(durationRemaining / msPerS);

        return "PT" + hours + "H" + mins + "M" + secs + "S";
}

function sendStatement(verbId, progress, completion) {
    
    var timeNow = new Date().getTime();
    var durationFormatted = format8601Duration(timeNow - pageStartTime);
    pageStartTime = new Date().getTime();
    
    var result = {
         duration: durationFormatted,
         extensions: {}
    };

    if(progress > 0 && progress <= 100) {
        result.extensions["https://w3id.org/xapi/cmi5/result/extensions/progress"] = progress
    }
    
    if(completion) {
        result['completion'] = true;
    }

    var stmt = new TinCan.Statement({
        actor: _actor,
        verb: {
             "id" : verbId
        },
        target: {
             "id": _activityId
        },
        result: result
    }); 

    _lrs.saveStatement(stmt, {
        callback: function(err,xhr) {
            if(err != null) {
                 console.log("Failed to save statement: " + err);
            }else {
                 console.log("Saved OK");
            }
        }
    });
}

setupFromLaunchParams();


