KAdefine("javascript/shared-components-package/deprecated-modal.jsx", function(require, module, exports) {
var _fullScreenOnMobile
var React=require("react")
var classNames=require("classnames")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var constants=require("../shared-styles-package/constants.js")
var Icon=require("../shared-styles-package/icon.jsx")
var mediaQueries=require("../shared-styles-package/media-queries.js")
var closeIcon="\nM6.26353762,4.99851587 L9.73097464,1.53107884 C10.0836373,1.17841618\n10.0842213,0.612127047 9.73530496,0.263210718 C9.38395604,-0.0881381913\n8.81874474,-0.0837668714 8.46743686,0.267541014 L4.99999981,3.73497806\nL1.5325628,0.267541051 C1.1812549,-0.0837668481 0.616043606,\n-0.0881381955 0.264694717,0.263210694 C-0.0842215912,0.612127004\n-0.0836375768,1.17841613 0.269025093,1.5310788 L3.73646206,4.9985158\nL0.269025109,8.46595276 C-0.083637537,8.81861541 -0.0842215923,\n9.38490462 0.264694642,9.73382106 C0.616043456,10.0851701 1.18125469,\n10.0807988 1.53256259,9.72949093 L4.99999988,6.26205363 L8.46743739,\n9.72949117 C8.8187453,10.0807991 9.38395655,10.0851704 9.73530537,\n9.73382138 C10.0842216,9.38490498 10.0836375,8.81861579 9.73097488,\n8.46595313 L6.26353762,4.99851587 Z"
var Modal=function(e){babelHelpers.inherits(t,e)
function t(){var o,s,i
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,r=Array(n),a=0;a<n;a++){r[a]=arguments[a]}return i=(o=(s=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(r))),s),s.state={visible:true,activeElement:null},s.handleEsc=function(e){if(e.keyCode===27){s.handleClose()}},o),babelHelpers.possibleConstructorReturn(s,i)}t.width=function e(t){return{margin:"0 0 0 "+-t/2+"px",width:t,maxWidth:t}}
t.prototype.UNSAFE_componentWillMount=function e(){this.setState({activeElement:document.activeElement})}
t.prototype.componentDidMount=function e(){var t=this
if(this.shouldRestrictTabbing()){this._restrictedFocusHandler=function(e){return t._restrictedFocus(e)}
document.addEventListener("focus",this._restrictedFocusHandler,true)}if(this.props.keyboard){window.addEventListener("keydown",this.handleEsc,true)}this.oldOverflow=document.body.style.overflow
if(this.props.preventBodyScroll&&this.state.visible){document.body.style.overflow="hidden"}if(this.props.elementToFocus){var o=this.props.elementToFocus()
if(o){setTimeout(function(){return o.focus()},100)}}}
t.prototype.componentDidUpdate=function e(t,o){if(this.state.visible!==o.visible&&this.props.preventBodyScroll){document.body.style.overflow=this.state.visible?"hidden":this.oldOverflow}}
t.prototype.componentWillUnmount=function e(){if(this.props.keyboard){window.removeEventListener("keydown",this.handleEsc,true)}if(this.props.preventBodyScroll){document.body.style.overflow=this.oldOverflow}if(this.state.activeElement&&this.props.refocusActiveElement){this.state.activeElement.focus()}if(this.shouldRestrictTabbing()){document.removeEventListener("focus",this._restrictedFocusHandler,true)}}
t.prototype.shouldRestrictTabbing=function e(){return!this.props.inline&&this.props.restrictTabbing}
t.prototype._restrictedFocus=function e(t){if(t.target instanceof HTMLElement&&this.modal&&!this.modal.contains(t.target)){this.modal.focus()}}
t.prototype.handleClose=function e(){this.setState({visible:false})
this.props.onClose()
if(this.state.activeElement&&this.props.refocusActiveElement){this.state.activeElement.focus()}if(this.props.restrictTabbing){document.removeEventListener("focus",this._restrictedFocusHandler,true)}}
t.prototype.render=function e(){var t=this
if(!this.state.visible&&this.props.shouldHandleClose){return React.createElement("div",null)}var o=this.props,s=o.showCloseButton,i=o.showCloseButtonAbsolute
var n=(s||i)&&React.createElement("a",{"aria-label":this.props.ariaCloseLabel,className:css(styles.close,i&&styles.closeAbsolute),href:"javascript: void 0",onClick:function e(){return t.handleClose()}},React.createElement(Icon,{icon:closeIcon,size:14}))
var r=this.props.children
if(this.props.title||this.props.footer){r=React.createElement("div",null,this.props.title&&React.createElement("div",{className:css(styles.header)},React.createElement("h2",{id:"modalTitle",className:css(styles.heading)},this.props.title)),React.createElement("div",{className:css(styles.body)},this.props.children),this.props.footer&&React.createElement("div",{className:css(styles.footer)},this.props.footer))}return React.createElement("div",{className:css(styles.wrap,this.props.inline&&styles.inlineWrap)},React.createElement("div",{tabIndex:"-1",className:classNames(css.apply(undefined,[styles.modal,this.props.padded&&styles.padded,this.props.forceTop&&styles.forceTop,this.props.wide&&styles.wide,this.props.extraWide&&styles.extraWide,this.props.fullScreen&&styles.fullScreen,this.props.fullScreenOnMobile&&styles.fullScreenOnMobile,this.props.inline&&styles.inlineModal,this.props.responsive&&styles.responsiveModal,this.props.responsive&&this.props.responsiveHeight&&styles.responsiveHeight].concat(this.props.extraStyles)),this.props.className),ref:function e(o){if(o&&t.props.preventScrollOnShow){o.style.top=window.scrollY+"px"}t.modal=o},role:this.props.alert?"alertdialog":"dialog","aria-labelledby":"modalTitle"},n,r),!!this.props.backdrop&&React.createElement("div",{className:css(styles.backdrop,this.props.inline&&styles.inlineBackdrop,this.props.forceTop&&styles.forceTopBackdrop),onClick:this.props.backdrop!=="static"?function(){return t.handleClose()}:null}))}
return t}(React.Component)
Modal.defaultProps={ariaCloseLabel:"Close",alert:false,backdrop:true,className:"",extraStyles:[],extraWide:false,forceTop:false,fullScreen:false,fullScreenOnMobile:false,inline:false,keyboard:true,onClose:function e(){},padded:true,preventBodyScroll:false,preventScrollOnShow:false,refocusActiveElement:true,responsive:false,responsiveHeight:true,restrictTabbing:true,showCloseButton:false,shouldHandleClose:true,showCloseButtonAbsolute:false,title:"",wide:false}
var defaultWidth=560
var wideWidth=700
var extraWideWidth=1e3
var margin=30
var styles=StyleSheet.create({wrap:{display:"inline-block"},inlineWrap:{display:"block",overflow:"auto",position:"relative"},modal:babelHelpers.extends({},Modal.width(defaultWidth),{backgroundColor:constants.white,backgroundClip:"padding-box",border:"1px solid rgba(0, 0, 0, 0.3)",borderRadius:constants.borderRadiusLarge,boxShadow:"0 3px 7px rgba(0, 0, 0, 0.3)",color:constants.textColor,left:"50%",outline:"none",position:"fixed",top:"10%",zIndex:constants.zindexModal}),padded:{padding:constants.modalDialogPadding},inlineModal:{marginBottom:10,marginTop:10,position:"relative"},responsiveModal:{overflow:"auto",width:"75%",marginLeft:0,transform:"translate(-50%, 0)"},responsiveHeight:{bottom:"10%"},forceTop:{zIndex:2147000001},wide:Modal.width(wideWidth),extraWide:Modal.width(extraWideWidth),fullScreen:{bottom:margin,left:margin,minHeight:500-2*margin,minWidth:parseFloat(constants.minContainerWidth)-2*margin,position:"fixed",right:margin,top:margin,width:"auto"},fullScreenOnMobile:(_fullScreenOnMobile={},_fullScreenOnMobile[mediaQueries.smOrSmaller]={border:"none",borderRadius:0,boxSizing:"border-box",height:"100%",left:0,margin:0,maxWidth:"none",position:"fixed",top:0,width:"100%"},_fullScreenOnMobile),backdrop:{backgroundColor:constants.dark,bottom:0,left:0,opacity:.72,position:"fixed",right:0,top:0,zIndex:constants.zindexModalBackdrop},forceTopBackdrop:{zIndex:2147e6},inlineBackdrop:{position:"absolute"},close:{color:constants.black,cursor:"pointer",float:"right",fontSize:constants.baseLineHeight,fontWeight:"bold",lineHeight:constants.baseLineHeight,opacity:.2,textShadow:"0 1px 0 "+constants.white,textDecoration:"none",":hover":{opacity:.41},":focus":{opacity:.41}},closeAbsolute:{position:"absolute",fontSize:28,lineHeight:"28px",right:0,top:0,paddingLeft:8,paddingRight:8,zIndex:constants.zindexAboveModal},header:{borderBottom:"1px solid "+constants.grayLighter,padding:"0 0 "+constants.modalSectionPadding+" 0"},heading:{color:constants.grayDark,fontFamily:"inherit",fontWeight:"bold",marginBottom:0,paddingTop:constants.modalSectionPadding},body:{margin:0,maxHeight:"none",padding:constants.contentPadding+" 0 "+(constants.modalSectionPadding+" 0"),position:"relative"},footer:{backgroundColor:constants.white,borderTop:"1px solid "+constants.grayLighter,marginBottom:0,padding:constants.modalDialogPadding+" 0 0 0",overflow:"hidden",textAlign:"right"}})
module.exports=Modal

});
KAdefine("javascript/shared-components-package/labeled-field.jsx", function(require, module, exports) {
var _icon=require("../shared-styles-package/icon.jsx")
var _icon2=babelHelpers.interopRequireDefault(_icon)
var React=require("react")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var uniqueIdCounter=0
var warningSign={path:"M57.379 77.077l0-10.633q0-.784-.539-1.323t-1.225-.539l-10.78 0q-.784 0-1.274.539t-.49 1.323l0 10.633q0 .784.539 1.323t1.225.539l10.78 0q.784 0 1.274-.539t.49-1.323zm-2.009-19.649q1.813 0 1.911-1.274l1.029-25.725q.049-.686-.637-1.176t-1.274-.49l-12.348 0q-.686 0-1.274.49t-.637 1.274l.98 25.627q0 1.176 1.911 1.274l10.339 0zm37.877 35.819l-86.044 0q-4.165 0-6.174-3.528t-.098-7.056l43.022-78.841q.98-1.715 2.646-2.744 3.577-2.156 7.252 0 1.715 1.029 2.646 2.744l43.022 78.841q1.96 3.528-.147 7.056-.931 1.568-2.597 2.548t-3.528.98z",width:100,height:92.816}
var KUILabeledField=function(e){babelHelpers.inherits(t,e)
function t(r){babelHelpers.classCallCheck(this,t)
var s=babelHelpers.possibleConstructorReturn(this,e.call(this,r))
s.id="kui_labeled_field_"+(r.id||uniqueIdCounter++)
return s}t.prototype.getInputElem=function e(){return this.input}
t.prototype.handleTitleClick=function e(){this.input.focus()}
t.prototype.render=function e(){var t=this
var r=this.props.warning!=null
var s=this.props.hasError===undefined?this.props.error:this.props.hasError
var i=null
if(s){i=React.createElement("div",{id:this.id+"-error",className:css(styles.error)},this.props.error)}else if(!this.props.showTitle){i=React.createElement("div",{id:this.id,className:"sr-only"},this.props.placeholder)}return React.createElement("div",{className:"kui-labeledfield "+css(styles.base)},this.props.showTitle&&React.createElement("div",{className:css(styles.title),onClick:function e(){return t.handleTitleClick()},id:this.id,style:this.props.titleStyle},this.props.title,this.props.warning&&React.createElement("span",{title:this.props.warning},React.createElement(_icon2.default,{color:"#ffCC00",className:css(styles.warningIcon),icon:warningSign}))),i,React.createElement("input",{ref:function e(r){return t.input=r},"aria-invalid":!!this.props.error,"aria-labelledby":this.id+(this.props.error?"-error":""),autoFocus:this.props.autoFocus,className:css(styles.input,r&&styles.inputWarning,s&&styles.inputError,this.props.transparent&&styles.inputTransparent),"data-test-id":this.props.testId,defaultValue:this.props.defaultValue,disabled:this.props.disabled,name:this.props.name,placeholder:this.props.placeholder,pattern:this.props.pattern,type:this.props.type,value:this.props.value,onBlur:this.props.onBlur,onFocus:this.props.onFocus,onChange:this.props.onChange,onClick:this.props.onClick,onKeyPress:this.props.onKeyPress}),this.props.caption&&React.createElement("div",{className:css(styles.caption)},this.props.caption))}
return t}(React.Component)
KUILabeledField.defaultProps={type:"text",showTitle:true,transparent:false}
var errorColor="#c52717"
var styles=StyleSheet.create({base:{lineHeight:1.4,marginBottom:20},title:{color:"#777",cursor:"default",float:"left",fontSize:14,fontWeight:"bold",textTransform:"uppercase"},error:{color:errorColor,float:"right",marginLeft:20,textAlign:"right"},input:{background:"#fcfcfc",border:"1px solid #ccc",boxSizing:"border-box",clear:"both",font:"inherit",padding:"8px 10px",margin:"5px 0 0",verticalAlign:"baseline",width:"100%",":focus":{outline:"none",boxShadow:"0px 0px 10px rgba(99, 155, 36, 0.8)"}},inputError:{background:"#fbe2e0",borderColor:errorColor,":focus":{boxShadow:"0px 0px 10px rgba(197, 39, 23, 0.4)"}},inputWarning:{background:"#ffEECC",borderColor:"#ffCC00"},inputTransparent:{background:"transparent",color:"#fff"},caption:{color:"#999",marginTop:5,textAlign:"right"},warningIcon:{marginLeft:4,position:"relative",top:1}})
module.exports=KUILabeledField

});
KAdefine("javascript/shared-components-package/scroll-tracking.jsx", function(require, module, exports) {
var React=require("react")
var _=require("../../third_party/javascript-khansrc/lodash/lodash.js")
var ScrollTracking=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.componentDidMount=function e(){if(this.props.children==null){this.trackNode(window)}}
t.prototype.componentWillUnmount=function e(){this.reset()}
t.prototype.reset=function e(){this.node.removeEventListener("scroll",this.boundHandler)}
t.prototype.trackNode=function e(t){if(this.boundHandler!=null){this.reset()}var r=this.props,n=r.debounce,o=r.delayMs,l=r.onScroll
var i=n?_.debounce:_.throttle
this.boundHandler=i(function(e){var r=t===window?window.pageYOffset:e.target.scrollTop
l(r,e)},o)
this.node=t
this.node.addEventListener("scroll",this.boundHandler)}
t.prototype.render=function e(){var t=this
if(this.props.children){return React.cloneElement(React.Children.only(this.props.children),{ref:function e(r){return r&&t.trackNode(r)}})}else{return null}}
return t}(React.Component)
ScrollTracking.defaultProps={debounce:false,delayMs:250}
module.exports=ScrollTracking

});
KAdefine("javascript/shared-components-package/spinner.jsx", function(require, module, exports) {
var React=require("react")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var i18n=require("../shared-package/i18n.js")
var Spinner=function(t){babelHelpers.inherits(a,t)
function a(){babelHelpers.classCallCheck(this,a)
return babelHelpers.possibleConstructorReturn(this,t.apply(this,arguments))}a.prototype.render=function t(){var a=this.props,r=a.size,l=a.theme,o=a.inline
var h="data:image/svg+xml;base64,"+(l==="dark"?spinnerDark:spinnerLight)
var f=void 0
switch(r){case"small":f=48
break
case"xsmall":f=16
break
default:f=96}return React.createElement("div",{className:css(styles.spinnerContainer,o&&styles.inlineSpinnerContainer)},React.createElement("img",{src:h,alt:i18n._("Loading"),className:css(styles.loadingSpinner),style:{height:f,width:f}}))}
return a}(React.Component)
Spinner.defaultProps={size:"default",theme:"dark"}
var rotateKeyFrames={"0%":{transform:"rotate(0deg)"},"50%":{transform:"rotate(180deg)"},"100%":{transform:"rotate(360deg)"}}
var styles=StyleSheet.create({spinnerContainer:{display:"flex",justifyContent:"center"},inlineSpinnerContainer:{display:"inline"},loadingSpinner:{animationName:rotateKeyFrames,animationDuration:"1.1s",animationIterationCount:"infinite",animationTimingFunction:"linear"}})
var spinnerDark=btoa('<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" viewBox="0 0 250 250" fill="red"><defs><clipPath id="a"><path d="M0 1000h2000v2000H0z"/></clipPath><mask id="b"><path fill="none" d="M0 0h2000v2000H0z"/><path fill="rgba(1,1,1,1)" transform="rotate(1 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(2,2,2,1)" transform="rotate(2 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(3,3,3,1)" transform="rotate(3 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(3,3,3,1)" transform="rotate(4 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(4,4,4,1)" transform="rotate(5 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(5,5,5,1)" transform="rotate(6 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(5,5,5,1)" transform="rotate(7 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(6,6,6,1)" transform="rotate(8 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(7,7,7,1)" transform="rotate(9 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(8,8,8,1)" transform="rotate(10 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(8,8,8,1)" transform="rotate(11 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(9,9,9,1)" transform="rotate(12 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(10,10,10,1)" transform="rotate(13 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(10,10,10,1)" transform="rotate(14 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(11,11,11,1)" transform="rotate(15 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(12,12,12,1)" transform="rotate(16 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(13,13,13,1)" transform="rotate(17 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(13,13,13,1)" transform="rotate(18 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(14,14,14,1)" transform="rotate(19 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(15,15,15,1)" transform="rotate(20 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(15,15,15,1)" transform="rotate(21 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(16,16,16,1)" transform="rotate(22 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(17,17,17,1)" transform="rotate(23 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(17,17,17,1)" transform="rotate(24 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(18,18,18,1)" transform="rotate(25 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(19,19,19,1)" transform="rotate(26 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(20,20,20,1)" transform="rotate(27 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(20,20,20,1)" transform="rotate(28 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(21,21,21,1)" transform="rotate(29 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(22,22,22,1)" transform="rotate(30 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(22,22,22,1)" transform="rotate(31 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(23,23,23,1)" transform="rotate(32 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(24,24,24,1)" transform="rotate(33 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(25,25,25,1)" transform="rotate(34 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(25,25,25,1)" transform="rotate(35 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(26,26,26,1)" transform="rotate(36 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(27,27,27,1)" transform="rotate(37 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(27,27,27,1)" transform="rotate(38 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(28,28,28,1)" transform="rotate(39 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(29,29,29,1)" transform="rotate(40 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(30,30,30,1)" transform="rotate(41 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(30,30,30,1)" transform="rotate(42 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(31,31,31,1)" transform="rotate(43 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(32,32,32,1)" transform="rotate(44 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(32,32,32,1)" transform="rotate(45 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(33,33,33,1)" transform="rotate(46 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(34,34,34,1)" transform="rotate(47 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(34,34,34,1)" transform="rotate(48 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(35,35,35,1)" transform="rotate(49 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(36,36,36,1)" transform="rotate(50 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(37,37,37,1)" transform="rotate(51 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(37,37,37,1)" transform="rotate(52 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(38,38,38,1)" transform="rotate(53 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(39,39,39,1)" transform="rotate(54 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(39,39,39,1)" transform="rotate(55 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(40,40,40,1)" transform="rotate(56 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(41,41,41,1)" transform="rotate(57 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(42,42,42,1)" transform="rotate(58 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(42,42,42,1)" transform="rotate(59 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(43,43,43,1)" transform="rotate(60 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(44,44,44,1)" transform="rotate(61 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(44,44,44,1)" transform="rotate(62 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(45,45,45,1)" transform="rotate(63 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(46,46,46,1)" transform="rotate(64 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(47,47,47,1)" transform="rotate(65 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(47,47,47,1)" transform="rotate(66 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(48,48,48,1)" transform="rotate(67 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(49,49,49,1)" transform="rotate(68 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(49,49,49,1)" transform="rotate(69 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(50,50,50,1)" transform="rotate(70 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(51,51,51,1)" transform="rotate(71 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(51,51,51,1)" transform="rotate(72 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(52,52,52,1)" transform="rotate(73 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(53,53,53,1)" transform="rotate(74 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(54,54,54,1)" transform="rotate(75 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(54,54,54,1)" transform="rotate(76 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(55,55,55,1)" transform="rotate(77 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(56,56,56,1)" transform="rotate(78 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(56,56,56,1)" transform="rotate(79 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(57,57,57,1)" transform="rotate(80 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(58,58,58,1)" transform="rotate(81 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(59,59,59,1)" transform="rotate(82 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(59,59,59,1)" transform="rotate(83 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(60,60,60,1)" transform="rotate(84 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(61,61,61,1)" transform="rotate(85 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(61,61,61,1)" transform="rotate(86 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(62,62,62,1)" transform="rotate(87 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(63,63,63,1)" transform="rotate(88 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(64,64,64,1)" transform="rotate(89 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(64,64,64,1)" transform="rotate(90 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(65,65,65,1)" transform="rotate(91 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(66,66,66,1)" transform="rotate(92 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(66,66,66,1)" transform="rotate(93 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(67,67,67,1)" transform="rotate(94 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(68,68,68,1)" transform="rotate(95 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(68,68,68,1)" transform="rotate(96 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(69,69,69,1)" transform="rotate(97 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(70,70,70,1)" transform="rotate(98 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(71,71,71,1)" transform="rotate(99 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(71,71,71,1)" transform="rotate(100 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(72,72,72,1)" transform="rotate(101 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(73,73,73,1)" transform="rotate(102 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(73,73,73,1)" transform="rotate(103 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(74,74,74,1)" transform="rotate(104 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(75,75,75,1)" transform="rotate(105 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(76,76,76,1)" transform="rotate(106 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(76,76,76,1)" transform="rotate(107 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(77,77,77,1)" transform="rotate(108 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(78,78,78,1)" transform="rotate(109 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(78,78,78,1)" transform="rotate(110 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(79,79,79,1)" transform="rotate(111 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(80,80,80,1)" transform="rotate(112 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(81,81,81,1)" transform="rotate(113 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(81,81,81,1)" transform="rotate(114 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(82,82,82,1)" transform="rotate(115 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(83,83,83,1)" transform="rotate(116 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(83,83,83,1)" transform="rotate(117 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(84,84,84,1)" transform="rotate(118 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(85,85,85,1)" transform="rotate(119 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(85,85,85,1)" transform="rotate(120 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(86,86,86,1)" transform="rotate(121 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(87,87,87,1)" transform="rotate(122 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(88,88,88,1)" transform="rotate(123 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(88,88,88,1)" transform="rotate(124 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(89,89,89,1)" transform="rotate(125 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(90,90,90,1)" transform="rotate(126 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(90,90,90,1)" transform="rotate(127 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(91,91,91,1)" transform="rotate(128 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(92,92,92,1)" transform="rotate(129 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(93,93,93,1)" transform="rotate(130 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(93,93,93,1)" transform="rotate(131 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(94,94,94,1)" transform="rotate(132 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(95,95,95,1)" transform="rotate(133 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(95,95,95,1)" transform="rotate(134 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(96,96,96,1)" transform="rotate(135 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(97,97,97,1)" transform="rotate(136 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(98,98,98,1)" transform="rotate(137 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(98,98,98,1)" transform="rotate(138 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(99,99,99,1)" transform="rotate(139 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(100,100,100,1)" transform="rotate(140 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(100,100,100,1)" transform="rotate(141 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(101,101,101,1)" transform="rotate(142 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(102,102,102,1)" transform="rotate(143 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(102,102,102,1)" transform="rotate(144 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(103,103,103,1)" transform="rotate(145 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(104,104,104,1)" transform="rotate(146 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(105,105,105,1)" transform="rotate(147 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(105,105,105,1)" transform="rotate(148 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(106,106,106,1)" transform="rotate(149 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(107,107,107,1)" transform="rotate(150 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(107,107,107,1)" transform="rotate(151 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(108,108,108,1)" transform="rotate(152 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(109,109,109,1)" transform="rotate(153 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(110,110,110,1)" transform="rotate(154 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(110,110,110,1)" transform="rotate(155 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(111,111,111,1)" transform="rotate(156 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(112,112,112,1)" transform="rotate(157 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(112,112,112,1)" transform="rotate(158 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(113,113,113,1)" transform="rotate(159 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(114,114,114,1)" transform="rotate(160 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(115,115,115,1)" transform="rotate(161 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(115,115,115,1)" transform="rotate(162 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(116,116,116,1)" transform="rotate(163 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(117,117,117,1)" transform="rotate(164 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(117,117,117,1)" transform="rotate(165 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(118,118,118,1)" transform="rotate(166 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(119,119,119,1)" transform="rotate(167 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(119,119,119,1)" transform="rotate(168 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(120,120,120,1)" transform="rotate(169 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(121,121,121,1)" transform="rotate(170 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(122,122,122,1)" transform="rotate(171 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(122,122,122,1)" transform="rotate(172 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(123,123,123,1)" transform="rotate(173 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(124,124,124,1)" transform="rotate(174 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(124,124,124,1)" transform="rotate(175 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(125,125,125,1)" transform="rotate(176 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(126,126,126,1)" transform="rotate(177 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(127,127,127,1)" transform="rotate(178 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(127,127,127,1)" transform="rotate(179 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(128,128,128,1)" transform="rotate(180 1500 1500)" d="M0 0h1000v1000H0z"/><g clip-path="url(#a)"><path fill="rgba(129,129,129,1)" transform="rotate(181 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(129,129,129,1)" transform="rotate(182 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(130,130,130,1)" transform="rotate(183 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(131,131,131,1)" transform="rotate(184 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(132,132,132,1)" transform="rotate(185 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(132,132,132,1)" transform="rotate(186 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(133,133,133,1)" transform="rotate(187 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(134,134,134,1)" transform="rotate(188 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(134,134,134,1)" transform="rotate(189 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(135,135,135,1)" transform="rotate(190 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(136,136,136,1)" transform="rotate(191 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(136,136,136,1)" transform="rotate(192 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(137,137,137,1)" transform="rotate(193 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(138,138,138,1)" transform="rotate(194 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(139,139,139,1)" transform="rotate(195 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(139,139,139,1)" transform="rotate(196 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(140,140,140,1)" transform="rotate(197 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(141,141,141,1)" transform="rotate(198 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(141,141,141,1)" transform="rotate(199 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(142,142,142,1)" transform="rotate(200 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(143,143,143,1)" transform="rotate(201 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(144,144,144,1)" transform="rotate(202 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(144,144,144,1)" transform="rotate(203 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(145,145,145,1)" transform="rotate(204 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(146,146,146,1)" transform="rotate(205 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(146,146,146,1)" transform="rotate(206 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(147,147,147,1)" transform="rotate(207 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(148,148,148,1)" transform="rotate(208 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(149,149,149,1)" transform="rotate(209 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(149,149,149,1)" transform="rotate(210 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(150,150,150,1)" transform="rotate(211 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(151,151,151,1)" transform="rotate(212 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(151,151,151,1)" transform="rotate(213 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(152,152,152,1)" transform="rotate(214 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(153,153,153,1)" transform="rotate(215 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(153,153,153,1)" transform="rotate(216 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(154,154,154,1)" transform="rotate(217 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(155,155,155,1)" transform="rotate(218 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(156,156,156,1)" transform="rotate(219 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(156,156,156,1)" transform="rotate(220 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(157,157,157,1)" transform="rotate(221 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(158,158,158,1)" transform="rotate(222 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(158,158,158,1)" transform="rotate(223 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(159,159,159,1)" transform="rotate(224 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(160,160,160,1)" transform="rotate(225 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(161,161,161,1)" transform="rotate(226 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(161,161,161,1)" transform="rotate(227 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(162,162,162,1)" transform="rotate(228 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(163,163,163,1)" transform="rotate(229 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(163,163,163,1)" transform="rotate(230 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(164,164,164,1)" transform="rotate(231 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(165,165,165,1)" transform="rotate(232 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(166,166,166,1)" transform="rotate(233 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(166,166,166,1)" transform="rotate(234 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(167,167,167,1)" transform="rotate(235 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(168,168,168,1)" transform="rotate(236 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(168,168,168,1)" transform="rotate(237 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(169,169,169,1)" transform="rotate(238 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(170,170,170,1)" transform="rotate(239 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(170,170,170,1)" transform="rotate(240 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(171,171,171,1)" transform="rotate(241 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(172,172,172,1)" transform="rotate(242 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(173,173,173,1)" transform="rotate(243 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(173,173,173,1)" transform="rotate(244 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(174,174,174,1)" transform="rotate(245 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(175,175,175,1)" transform="rotate(246 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(175,175,175,1)" transform="rotate(247 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(176,176,176,1)" transform="rotate(248 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(177,177,177,1)" transform="rotate(249 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(178,178,178,1)" transform="rotate(250 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(178,178,178,1)" transform="rotate(251 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(179,179,179,1)" transform="rotate(252 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(180,180,180,1)" transform="rotate(253 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(180,180,180,1)" transform="rotate(254 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(181,181,181,1)" transform="rotate(255 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(182,182,182,1)" transform="rotate(256 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(183,183,183,1)" transform="rotate(257 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(183,183,183,1)" transform="rotate(258 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(184,184,184,1)" transform="rotate(259 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(185,185,185,1)" transform="rotate(260 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(185,185,185,1)" transform="rotate(261 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(186,186,186,1)" transform="rotate(262 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(187,187,187,1)" transform="rotate(263 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(187,187,187,1)" transform="rotate(264 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(188,188,188,1)" transform="rotate(265 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(189,189,189,1)" transform="rotate(266 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(190,190,190,1)" transform="rotate(267 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(190,190,190,1)" transform="rotate(268 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(191,191,191,1)" transform="rotate(269 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(192,192,192,1)" transform="rotate(270 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(192,192,192,1)" transform="rotate(271 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(193,193,193,1)" transform="rotate(272 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(194,194,194,1)" transform="rotate(273 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(195,195,195,1)" transform="rotate(274 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(195,195,195,1)" transform="rotate(275 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(196,196,196,1)" transform="rotate(276 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(197,197,197,1)" transform="rotate(277 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(197,197,197,1)" transform="rotate(278 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(198,198,198,1)" transform="rotate(279 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(199,199,199,1)" transform="rotate(280 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(200,200,200,1)" transform="rotate(281 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(200,200,200,1)" transform="rotate(282 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(201,201,201,1)" transform="rotate(283 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(202,202,202,1)" transform="rotate(284 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(202,202,202,1)" transform="rotate(285 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(203,203,203,1)" transform="rotate(286 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(204,204,204,1)" transform="rotate(287 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(205,205,205,1)" transform="rotate(288 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(205,205,205,1)" transform="rotate(289 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(206,206,206,1)" transform="rotate(290 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(207,207,207,1)" transform="rotate(291 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(207,207,207,1)" transform="rotate(292 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(208,208,208,1)" transform="rotate(293 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(209,209,209,1)" transform="rotate(294 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(209,209,209,1)" transform="rotate(295 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(210,210,210,1)" transform="rotate(296 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(211,211,211,1)" transform="rotate(297 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(212,212,212,1)" transform="rotate(298 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(212,212,212,1)" transform="rotate(299 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(213,213,213,1)" transform="rotate(300 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(214,214,214,1)" transform="rotate(301 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(214,214,214,1)" transform="rotate(302 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(215,215,215,1)" transform="rotate(303 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(216,216,216,1)" transform="rotate(304 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(217,217,217,1)" transform="rotate(305 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(217,217,217,1)" transform="rotate(306 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(218,218,218,1)" transform="rotate(307 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(219,219,219,1)" transform="rotate(308 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(219,219,219,1)" transform="rotate(309 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(220,220,220,1)" transform="rotate(310 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(221,221,221,1)" transform="rotate(311 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(222,222,222,1)" transform="rotate(312 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(222,222,222,1)" transform="rotate(313 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(223,223,223,1)" transform="rotate(314 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(224,224,224,1)" transform="rotate(315 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(224,224,224,1)" transform="rotate(316 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(225,225,225,1)" transform="rotate(317 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(226,226,226,1)" transform="rotate(318 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(226,226,226,1)" transform="rotate(319 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(227,227,227,1)" transform="rotate(320 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(228,228,228,1)" transform="rotate(321 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(229,229,229,1)" transform="rotate(322 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(229,229,229,1)" transform="rotate(323 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(230,230,230,1)" transform="rotate(324 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(231,231,231,1)" transform="rotate(325 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(231,231,231,1)" transform="rotate(326 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(232,232,232,1)" transform="rotate(327 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(233,233,233,1)" transform="rotate(328 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(234,234,234,1)" transform="rotate(329 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(234,234,234,1)" transform="rotate(330 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(235,235,235,1)" transform="rotate(331 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(236,236,236,1)" transform="rotate(332 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(236,236,236,1)" transform="rotate(333 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(237,237,237,1)" transform="rotate(334 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(238,238,238,1)" transform="rotate(335 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(239,239,239,1)" transform="rotate(336 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(239,239,239,1)" transform="rotate(337 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(240,240,240,1)" transform="rotate(338 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(241,241,241,1)" transform="rotate(339 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(241,241,241,1)" transform="rotate(340 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(242,242,242,1)" transform="rotate(341 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(243,243,243,1)" transform="rotate(342 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(243,243,243,1)" transform="rotate(343 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(244,244,244,1)" transform="rotate(344 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(245,245,245,1)" transform="rotate(345 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(246,246,246,1)" transform="rotate(346 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(246,246,246,1)" transform="rotate(347 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(247,247,247,1)" transform="rotate(348 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(248,248,248,1)" transform="rotate(349 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(248,248,248,1)" transform="rotate(350 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(249,249,249,1)" transform="rotate(-9 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(250,250,250,1)" transform="rotate(-8 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(251,251,251,1)" transform="rotate(-7 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(251,251,251,1)" transform="rotate(-6 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(252,252,252,1)" transform="rotate(-5 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(253,253,253,1)" transform="rotate(-4 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(253,253,253,1)" transform="rotate(-3 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(254,254,254,1)" transform="rotate(-2 1500 1500)" d="M0 0h1000v1000H0z"/><path fill="rgba(255,255,255,1)" transform="rotate(-1 1500 1500)" d="M0 0h1000v1000H0z"/></g></mask></defs><g mask="url(#b)" transform="matrix(-.1 0 0 -.1 251 251)" fill="#888D93"><path d="M1015 2450c-105-22-215-60-300-102-181-91-381-275-487-448-65-106-136-277-145-350-5-43-2-54 21-85 21-27 34-35 59-35 52 0 94 32 107 82 16 64 39 126 75 199 135 275 362 469 650 556 84 25 103 27 275 27s191-2 275-27c373-112 647-411 726-792 25-122 25-318 0-440-79-381-353-680-726-792-84-25-103-27-275-27s-191 2-275 27c-297 89-536 300-665 587l-25 55-102-5-102-5 38-93c57-137 133-252 244-368C625 161 908 40 1260 40c345 0 628 118 866 362 190 193 294 408 339 695 30 192-7 451-92 648-129 298-395 549-701 659-189 67-462 87-657 46z"/></g></svg>')

var spinnerLight=btoa('<svg width="48" height="48" viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><title>activity-large</title><defs><path d="M24 48c13.255 0 24-10.745 24-24S37.255 0 24 0 0 10.745 0 24a1.5 1.5 0 0 0 3 0C3 12.402 12.402 3 24 3s21 9.402 21 21-9.402 21-21 21a1.5 1.5 0 0 0 0 3z" id="a"/><path id="c" d="M0 0h48v48H0z"/></defs><g fill="none" fill-rule="evenodd"><path fill="none" d="M0 0h48v48H0z"/><g transform="rotate(180 24 24)"><mask id="b" fill="#fff"><use xlink:href="#a"/></mask><g mask="url(#b)"><mask id="d" fill="#fff"><use xlink:href="#c"/></mask><use xlink:href="#c"/><g mask="url(#d)" fill="#FFF"><path d="M0 0h48v48H0z"/></g></g></g></g></svg>')
module.exports=Spinner

});
KAdefine("javascript/shared-components-package/timeout-spinner.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _ka=require("../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _console=require("../shared-package/console.js")
var _console2=babelHelpers.interopRequireDefault(_console)
var _absoluteLinks=require("../shared-package/absolute-links.js")
var _absoluteLinks2=babelHelpers.interopRequireDefault(_absoluteLinks)
var _ravenJs=require("raven-js")
var _ravenJs2=babelHelpers.interopRequireDefault(_ravenJs)
var _wonderBlocksProgressSpinnerV=require("@khanacademy/wonder-blocks-progress-spinner-v1")
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _wonderBlocksColorV=require("@khanacademy/wonder-blocks-color-v1")
var _wonderBlocksColorV2=babelHelpers.interopRequireDefault(_wonderBlocksColorV)
var _wonderBlocksSpacingV=require("@khanacademy/wonder-blocks-spacing-v2")
var _wonderBlocksSpacingV2=babelHelpers.interopRequireDefault(_wonderBlocksSpacingV)
var _wonderBlocksLinkV=require("@khanacademy/wonder-blocks-link-v3")
var _wonderBlocksLinkV2=babelHelpers.interopRequireDefault(_wonderBlocksLinkV)
var i18n=require("../shared-package/i18n.js")
var strings={timedOut:i18n._("We're sorry this is taking so long...")}
var SECOND_TIMEOUT_MULTIPLIER=2
var TimeoutSpinner=function(e){babelHelpers.inherits(r,e)
function r(){var t,o,a
babelHelpers.classCallCheck(this,r)
for(var n=arguments.length,i=Array(n),s=0;s<n;s++){i[s]=arguments[s]}return a=(t=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),o),o.state={firstTimeoutHit:false,secondTimeoutHit:false},t),babelHelpers.possibleConstructorReturn(o,a)}r.prototype.componentDidMount=function e(){var r=this
var t=this.props,o=t.sentryId,a=t.sentryTeam,n=t.timeoutSeconds
var i=o+"|"+Date.now()+"|"+Math.floor(Math.random()*1e5)
var s=function e(){r.setState({firstTimeoutHit:true})
r.logTimeout("Spinner timeout: first ("+a+")",n,i)
r.timeoutId=setTimeout(l,n*1e3)}
var l=function e(){r.setState({secondTimeoutHit:true})
r.logTimeout("Spinner timeout: second ("+a+")",n*SECOND_TIMEOUT_MULTIPLIER,i)}
this.timeoutId=setTimeout(s,n*1e3)}
r.prototype.componentWillUnmount=function e(){clearTimeout(this.timeoutId)}
r.prototype.logTimeout=function e(r,t,o){var a=this.props,n=a.sentryId,i=a.description,s=a.sentryExtras
var l=_ka2.default.featureFlag("LP_LOG_SPINNER_FAILURES")
var u=_ka2.default.getUserProfile()
var c=u&&u.get("nickname")
_console2.default.log(r,n,i,t,c,l?"REPORT":"NO_REPORT",o)
if(_ravenJs2.default&&l){_ravenJs2.default.captureMessage(r,{extra:babelHelpers.extends({sentryId:n,description:i,timeoutSeconds:t,user:c,timeoutId:o},s)})}}
r.prototype.render=function e(){var r=this.props,t=r.notifyUser,o=r.size,a=r.light,n=r.style
var i=this.state,s=i.firstTimeoutHit,l=i.secondTimeoutHit
var u=a?_wonderBlocksColorV2.default.white64:_wonderBlocksColorV2.default.offBlack
var c=function e(){var r=_absoluteLinks2.default.safeLinkTo("https://www.khanacademy.org/reportissue?type=Defect")
var t=React.createElement(_wonderBlocksLinkV2.default,{href:r,skipClientNav:true,light:a},i18n._("tell us"))
var o=React.createElement(_wonderBlocksLinkV2.default,{onClick:function e(){return window.location.reload()},skipClientNav:true,light:a},i18n._("refresh"))
return i18n.$_("Uh oh, it looks like we ran into an error. You need to %(refresh)s. If this problem persists, %(tellUs)s.",{refresh:o,tellUs:t})}
return React.createElement(_wonderBlocksCoreV.View,{style:[styles.containerDefault,n]},React.createElement(_wonderBlocksProgressSpinnerV.CircularSpinner,{size:o,light:a}),s&&t&&React.createElement(_wonderBlocksCoreV.Text,{style:[styles.userNotification,{color:u}]},l?c():strings.timedOut))}
return r}(React.Component)
TimeoutSpinner.defaultProps={size:"large",light:false,timeoutSeconds:15}
exports.default=TimeoutSpinner
var styles=_aphrodite.StyleSheet.create({containerDefault:{alignItems:"center"},userNotification:{marginTop:_wonderBlocksSpacingV2.default.xSmall,marginBottom:_wonderBlocksSpacingV2.default.xSmall,fontSize:16}})

});
KAdefine("javascript/shared-components-package/checkbox.jsx", function(require, module, exports) {
var React=require("react")
var _require=require("aphrodite"),css=_require.css,StyleSheet=_require.StyleSheet
var styleConstants=require("../shared-styles-package/constants.js")
var color=require("../shared-styles-package/color.js")
var Icon=require("../shared-styles-package/icon.jsx")
var KUICheckbox=function(e){babelHelpers.inherits(s,e)
function s(){var t,r,o
babelHelpers.classCallCheck(this,s)
for(var a=arguments.length,c=Array(a),i=0;i<a;i++){c[i]=arguments[i]}return o=(t=(r=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(c))),r),r.state={focused:false},t),babelHelpers.possibleConstructorReturn(r,o)}s.prototype.handleFocus=function e(s){this.setState({focused:true})
if(this.props.onFocus){return this.props.onFocus(s)}}
s.prototype.handleBlur=function e(s){this.setState({focused:false})
if(this.props.onBlur){return this.props.onBlur(s)}}
s.prototype.render=function e(){var s=this
return React.createElement("div",{className:css(styles.checkbox,this.props.checked&&!this.props.disabled&&styles.checked,this.props.disabled&&styles.disabled,this.state.focused&&styles.focused)},this.props.checked&&React.createElement(Icon,{icon:okIcon,size:9,className:css(styles.checkboxIcon)}),React.createElement("input",{type:"checkbox","aria-label":this.props.ariaLabel,className:css(styles.input,this.props.disabled&&styles.inputDisabled),name:this.props.name,checked:this.props.checked,disabled:this.props.disabled,onChange:this.props.onChange,onFocus:function e(t){return s.handleFocus(t)},onBlur:function e(t){return s.handleBlur(t)}}))}
return s}(React.Component)
var okIcon={path:"M37.964 76.048q-2.576 0-4.368-1.792l-31.864-31.864q-1.792-1.792-1.792-4.368t1.792-4.368l8.736-8.68q1.792-1.792 4.368-1.792t4.312 1.792l18.816 18.872 42-42.056q1.792-1.792 4.368-1.792t4.312 1.792l8.736 8.736q1.792 1.792 1.792 4.368t-1.792 4.312l-55.048 55.048q-1.792 1.792-4.368 1.792z",width:100,height:76.637}
var kaGreen=color.parse(styleConstants.kaGreen)
var styles=StyleSheet.create({checkbox:{backgroundImage:"linear-gradient(#fff, #ddd)",border:"1px solid #aaa",borderRadius:3,boxSizing:"border-box",display:"inline-block",height:16,margin:3,marginTop:1.5,overflow:"hidden",position:"relative",verticalAlign:"top",width:16},checked:{background:color.format(color.darken(kaGreen,.1)),color:"#fff"},disabled:{color:"#999",opacity:.4},focused:{boxShadow:"0px 0px 3px "+color.format(color.fade(kaGreen,.8))},checkboxIcon:{display:"block",margin:"2px 0 0 1px"},input:{cursor:"pointer",height:"100%",left:0,margin:0,opacity:0,position:"absolute",top:0,width:"100%"},inputDisabled:{cursor:"default"}})
module.exports=KUICheckbox

});
KAdefine("javascript/shared-components-package/select.jsx", function(require, module, exports) {
var React=require("react")
var _require=require("aphrodite"),css=_require.css,StyleSheet=_require.StyleSheet
var i18n=require("../shared-package/i18n.js")
var Select=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.onChange=function e(t){if(this.props.onChange){this.props.onChange(t.target.value)}}
t.prototype.render=function e(){var t=this
var a=this.props,r=a.blankText,n=a.blankValue,o=a.hideBlank,l=a.className,i=a.options,s=babelHelpers.objectWithoutProperties(a,["blankText","blankValue","hideBlank","className","options"])
var u=i
var c={paddingTop:0,paddingBottom:0}
if(!o&&n!==undefined&&r!==undefined){u=[[n,r]].concat(u)}var p=[css(styles.default),l].filter(function(e){return e}).join(" ")
return React.createElement("select",babelHelpers.extends({},s,{style:c,onChange:function e(a){return t.onChange(a)},className:p}),u.map(function(e){return React.createElement("option",{value:e[0],key:e[0]},e[1])}))}
return t}(React.Component)
Select.defaultProps={blankText:i18n._("Unspecified"),blankValue:"unspecified",disabled:false}
var styles=StyleSheet.create({default:{backgroundColor:"#fafafa",border:"1px solid #C6D1AD",borderRadius:4,fontSize:10,padding:0,height:24,width:160,outline:"none",":focus":{boxShadow:"0 0 5px 1px rgba(115, 152, 44, .5)",borderColor:"rgba(100, 140, 30, .5)"},":disabled":{color:"#999"}}})
module.exports=Select

});
KAdefine("javascript/shared-components-package/labeled-textarea.jsx", function(require, module, exports) {
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var React=require("react")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var classNames=require("classnames")
var styleConstants=require("../shared-styles-package/constants.js")
var color=require("../shared-styles-package/color.js")
var KUITextArea=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype._renderTextArea=function e(r){var o=r.get("")
var t=r.get("label")
return React.createElement("div",{className:classNames(css(styles.default),this.props.className)},React.createElement("label",{id:t,htmlFor:o,className:css(styles.title)},this.props.title),this.props.error&&React.createElement("div",{className:css(styles.error)},this.props.error),React.createElement("textarea",{id:o,"aria-labelledby":t,autoFocus:this.props.autoFocus,className:css(styles.input,this.props.error&&styles.inputError),disabled:this.props.disabled,defaultValue:this.props.defaultValue,placeholder:this.props.placeholder,value:this.props.value,rows:this.props.rows,onChange:this.props.onChange,onClick:this.props.onClick,onKeyDown:this.props.onKeyDown,style:{height:this.props.height}}),this.props.caption&&React.createElement("div",{className:css(styles.caption)},this.props.caption))}
r.prototype.render=function e(){var r=this
return React.createElement(_wonderBlocksCoreV.UniqueIDProvider,{mockOnFirstRender:false,scope:"kui-textarea"},function(e){return r._renderTextArea(e)})}
return r}(React.Component)
var errorColor=color.parse("#c52717")
var kaGreen=color.parse(styleConstants.kaGreen)
var styles=StyleSheet.create({default:{lineHeight:1.4,marginBottom:20},title:{color:"#777",cursor:"default",float:"left",fontSize:14,fontWeight:"bold",textTransform:"uppercase"},error:{color:color.format(errorColor),float:"right",marginLeft:20,textAlign:"right"},input:{background:"#fcfcfc",border:"1px solid #ccc",boxSizing:"border-box",clear:"both",font:"inherit",padding:"8px 10px",margin:"5px 0 0",verticalAlign:"baseline",width:"100%",":focus":{outline:"none",boxShadow:"0px 0px 10px "+color.format(color.fade(kaGreen,.8))}},inputError:{background:color.format(color.lighten(errorColor,.5)),borderColor:color.format(errorColor),":focus":{boxShadow:"0px 0px 10px "+color.format(color.fade(errorColor,.4))}},caption:{color:"#999",marginTop:5,textAlign:"right"}})
module.exports=KUITextArea

});

//# sourceMappingURL=/genfiles/compressed_js_packages_prod/en/shared-components-package.js.map 