package com.ustadmobile.core.db.dao

import com.google.gson.Gson
import com.ustadmobile.door.DoorDatabase
import com.ustadmobile.door.ext.unwrappedDbOnCall
import io.ktor.application.call
import io.ktor.http.HttpStatusCode
import io.ktor.response.respond
import io.ktor.routing.Route
import io.ktor.routing.`get`
import io.ktor.routing.route
import kotlin.Long
import kotlin.Unit
import org.kodein.di.instance
import org.kodein.di.ktor.closestDI
import org.kodein.type.TypeToken

public fun <T : DoorDatabase> Route.ContentEntryDao_KtorRoute(_typeToken: TypeToken<T>,
    _daoFn: (T) -> ContentEntryDao): Unit {
  route("ContentEntryDao") {
    `get`("findListOfCategoriesAsync") {
      val _di = closestDI()
      val _db : T = unwrappedDbOnCall(_typeToken)
      val _dao = _daoFn(_db)
      val _gson: Gson by _di.instance()
      val __parentUid : Long = call.request.queryParameters["parentUid"]?.toLong() ?: 0L
      val _result = _dao.findListOfCategoriesAsync(__parentUid)
      call.respond(_result)
    }
    `get`("findUniqueLanguagesInListAsync") {
      val _di = closestDI()
      val _db : T = unwrappedDbOnCall(_typeToken)
      val _dao = _daoFn(_db)
      val _gson: Gson by _di.instance()
      val __parentUid : Long = call.request.queryParameters["parentUid"]?.toLong() ?: 0L
      val _result = _dao.findUniqueLanguagesInListAsync(__parentUid)
      call.respond(_result)
    }
    `get`("findUniqueLanguageWithParentUid") {
      val _di = closestDI()
      val _db : T = unwrappedDbOnCall(_typeToken)
      val _dao = _daoFn(_db)
      val _gson: Gson by _di.instance()
      val __parentUid : Long = call.request.queryParameters["parentUid"]?.toLong() ?: 0L
      val _result = _dao.findUniqueLanguageWithParentUid(__parentUid)
      call.respond(_result)
    }
    `get`("getRecursiveDownloadTotals") {
      val _di = closestDI()
      val _db : T = unwrappedDbOnCall(_typeToken)
      val _dao = _daoFn(_db)
      val _gson: Gson by _di.instance()
      val __contentEntryUid : Long = call.request.queryParameters["contentEntryUid"]?.toLong() ?: 0L
      val _result = _dao.getRecursiveDownloadTotals(__contentEntryUid)
      if(_result != null) {
        call.respond(_result)
      } else {
        call.respond(HttpStatusCode.NoContent, "")
      }
    }
  }
}
