"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mergeSlotProps;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _clsx = _interopRequireDefault(require("clsx"));

var _extractEventHandlers = _interopRequireDefault(require("./extractEventHandlers"));

var _omitEventHandlers = _interopRequireDefault(require("./omitEventHandlers"));

/**
 * Merges the slot component internal props (usually coming from a hook)
 * with the externally provided ones.
 *
 * The merge order is (the latter overrides the former):
 * 1. The internal props (specified as a getter function to work with get*Props hook result)
 * 2. Additional props (specified internally on an unstyled component)
 * 3. External props specified on the owner component. These should only be used on a root slot.
 * 4. External props specified in the `componentsProps.*` prop.
 * 5. The `className` prop - combined from all the above.
 * @param parameters
 * @returns
 */
function mergeSlotProps(parameters) {
  const {
    getSlotProps,
    additionalProps,
    externalSlotProps,
    externalForwardedProps,
    className
  } = parameters;

  if (!getSlotProps) {
    // The simpler case - getSlotProps is not defined, so no internal event handlers are defined,
    // so we can simply merge all the props without having to worry about extracting event handlers.
    const joinedClasses = (0, _clsx.default)(externalForwardedProps == null ? void 0 : externalForwardedProps.className, externalSlotProps == null ? void 0 : externalSlotProps.className, className, additionalProps == null ? void 0 : additionalProps.className);
    const props = (0, _extends2.default)({}, additionalProps, externalForwardedProps, externalSlotProps, {
      className: joinedClasses
    });

    if (joinedClasses.length === 0) {
      delete props.className;
    }

    return {
      props,
      internalRef: undefined
    };
  } // In this case, getSlotProps is responsible for calling the external event handlers.
  // We don't need to include them in the merged props because of this.


  const eventHandlers = (0, _extractEventHandlers.default)((0, _extends2.default)({}, externalForwardedProps, externalSlotProps));
  const componentsPropsWithoutEventHandlers = (0, _omitEventHandlers.default)(externalSlotProps);
  const otherPropsWithoutEventHandlers = (0, _omitEventHandlers.default)(externalForwardedProps);
  const internalSlotProps = getSlotProps(eventHandlers);
  const joinedClasses = (0, _clsx.default)(externalForwardedProps == null ? void 0 : externalForwardedProps.className, externalSlotProps == null ? void 0 : externalSlotProps.className, className, additionalProps == null ? void 0 : additionalProps.className, internalSlotProps == null ? void 0 : internalSlotProps.className);
  const props = (0, _extends2.default)({}, internalSlotProps, additionalProps, otherPropsWithoutEventHandlers, componentsPropsWithoutEventHandlers, {
    className: joinedClasses
  });

  if (joinedClasses.length === 0) {
    delete props.className;
  }

  return {
    props,
    internalRef: internalSlotProps.ref
  };
}