"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.calendarPickerSkeletonClasses = void 0;
exports.getCalendarPickerSkeletonUtilityClass = getCalendarPickerSkeletonUtilityClass;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _Skeleton = _interopRequireDefault(require("@mui/material/Skeleton"));

var _styles = require("@mui/material/styles");

var _base = require("@mui/base");

var _dimensions = require("../internal/pickers/constants/dimensions");

var _jsxRuntime = require("react/jsx-runtime");

const _excluded = ["className"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function getCalendarPickerSkeletonUtilityClass(slot) {
  return (0, _base.generateUtilityClass)('MuiCalendarPickerSkeleton', slot);
}

const calendarPickerSkeletonClasses = (0, _base.generateUtilityClasses)('MuiCalendarPickerSkeleton', ['root', 'week', 'daySkeleton']);
exports.calendarPickerSkeletonClasses = calendarPickerSkeletonClasses;

const useUtilityClasses = ownerState => {
  const {
    classes
  } = ownerState;
  const slots = {
    root: ['root'],
    week: ['week'],
    daySkeleton: ['daySkeleton']
  };
  return (0, _base.unstable_composeClasses)(slots, getCalendarPickerSkeletonUtilityClass, classes);
};

const CalendarPickerSkeletonRoot = (0, _styles.styled)('div', {
  name: 'MuiCalendarPickerSkeleton',
  slot: 'Root',
  overridesResolver: (props, styles) => styles.root
})({
  alignSelf: 'start'
});
const CalendarPickerSkeletonWeek = (0, _styles.styled)('div', {
  name: 'MuiCalendarPickerSkeleton',
  slot: 'Week',
  overridesResolver: (props, styles) => styles.week
})({
  margin: `${_dimensions.DAY_MARGIN}px 0`,
  display: 'flex',
  justifyContent: 'center'
});
const CalendarPickerSkeletonDay = (0, _styles.styled)(_Skeleton.default, {
  name: 'MuiCalendarPickerSkeleton',
  slot: 'Day',
  overridesResolver: (props, styles) => styles.daySkeleton
})(({
  ownerState
}) => (0, _extends2.default)({
  margin: `0 ${_dimensions.DAY_MARGIN}px`
}, ownerState.day === 0 && {
  visibility: 'hidden'
}));
process.env.NODE_ENV !== "production" ? CalendarPickerSkeletonDay.propTypes
/* remove-proptypes */
= {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit TypeScript types and run "yarn proptypes"  |
  // ----------------------------------------------------------------------

  /**
   * Optional children to infer width and height from.
   */
  children: _propTypes.default.node,

  /**
   * @ignore
   */
  ownerState: _propTypes.default.object
} : void 0;
const monthMap = [[0, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 0, 0, 0]];
/**
 *
 * Demos:
 *
 * - [Date Picker](https://mui.com/components/date-picker/)
 *
 * API:
 *
 * - [CalendarPickerSkeleton API](https://mui.com/api/calendar-picker-skeleton/)
 */

function CalendarPickerSkeleton(props) {
  const _useThemeProps = (0, _styles.useThemeProps)({
    props,
    name: 'MuiCalendarPickerSkeleton'
  }),
        {
    className
  } = _useThemeProps,
        other = (0, _objectWithoutPropertiesLoose2.default)(_useThemeProps, _excluded);

  const classes = useUtilityClasses(props);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(CalendarPickerSkeletonRoot, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className)
  }, other, {
    children: monthMap.map((week, index) => /*#__PURE__*/(0, _jsxRuntime.jsx)(CalendarPickerSkeletonWeek, {
      className: classes.week,
      children: week.map((day, index2) => /*#__PURE__*/(0, _jsxRuntime.jsx)(CalendarPickerSkeletonDay, {
        variant: "circular",
        width: _dimensions.DAY_SIZE,
        height: _dimensions.DAY_SIZE,
        className: classes.daySkeleton,
        ownerState: {
          day
        }
      }, index2))
    }, index))
  }));
}
/**
 *
 * Demos:
 *
 * - [Date Picker](https://mui.com/components/date-picker/)
 *
 * API:
 *
 * - [CalendarPickerSkeleton API](https://mui.com/api/calendar-picker-skeleton/)
 */


process.env.NODE_ENV !== "production" ? CalendarPickerSkeleton.propTypes
/* remove-proptypes */
= {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit TypeScript types and run "yarn proptypes"  |
  // ----------------------------------------------------------------------

  /**
   * @ignore
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   */
  classes: _propTypes.default.object,

  /**
   * The system prop that allows defining system overrides as well as additional CSS styles.
   */
  sx: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object])), _propTypes.default.func, _propTypes.default.object])
} : void 0;
var _default = CalendarPickerSkeleton;
exports.default = _default;