"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.dateRangePickerDayClasses = void 0;
exports.getDateRangePickerDayUtilityClass = getDateRangePickerDayUtilityClass;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _styles = require("@mui/material/styles");

var _base = require("@mui/base");

var _dimensions = require("../internal/pickers/constants/dimensions");

var _useUtils = require("../internal/pickers/hooks/useUtils");

var _PickersDay = _interopRequireWildcard(require("../PickersDay/PickersDay"));

var _jsxRuntime = require("react/jsx-runtime");

const _excluded = ["className", "day", "outsideCurrentMonth", "isEndOfHighlighting", "isEndOfPreviewing", "isHighlighting", "isPreviewing", "isStartOfHighlighting", "isStartOfPreviewing", "selected"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function getDateRangePickerDayUtilityClass(slot) {
  return (0, _base.generateUtilityClass)('MuiDateRangePickerDay', slot);
}

const dateRangePickerDayClasses = (0, _base.generateUtilityClasses)('MuiDateRangePickerDay', ['root', 'rangeIntervalDayHighlight', 'rangeIntervalDayHighlightStart', 'rangeIntervalDayHighlightEnd', 'rangeIntervalPreview', 'rangeIntervalDayPreview', 'rangeIntervalDayPreviewStart', 'rangeIntervalDayPreviewEnd', 'day', 'dayOutsideRangeInterval', 'dayInsideRangeInterval', 'notSelectedDate']);
exports.dateRangePickerDayClasses = dateRangePickerDayClasses;

const useUtilityClasses = ownerState => {
  const {
    isHighlighting,
    outsideCurrentMonth,
    isStartOfHighlighting,
    isStartOfMonth,
    isEndOfHighlighting,
    isEndOfMonth,
    isPreviewing,
    isStartOfPreviewing,
    isEndOfPreviewing,
    selected,
    classes
  } = ownerState;
  const slots = {
    root: ['root', isHighlighting && !outsideCurrentMonth && 'rangeIntervalDayHighlight', (isStartOfHighlighting || isStartOfMonth) && 'rangeIntervalDayHighlightStart', (isEndOfHighlighting || isEndOfMonth) && 'rangeIntervalDayHighlightEnd'],
    rangeIntervalPreview: ['rangeIntervalPreview', isPreviewing && !outsideCurrentMonth && 'rangeIntervalDayPreview', (isStartOfPreviewing || isStartOfMonth) && 'rangeIntervalDayPreviewStart', (isEndOfPreviewing || isEndOfMonth) && 'rangeIntervalDayPreviewEnd'],
    day: ['day', !selected && 'notSelectedDate', !isHighlighting && 'dayOutsideRangeInterval', !selected && isHighlighting && 'dayInsideRangeInterval']
  };
  return (0, _base.unstable_composeClasses)(slots, getDateRangePickerDayUtilityClass, classes);
};

const endBorderStyle = {
  borderTopRightRadius: '50%',
  borderBottomRightRadius: '50%'
};
const startBorderStyle = {
  borderTopLeftRadius: '50%',
  borderBottomLeftRadius: '50%'
};
const DateRangePickerDayRoot = (0, _styles.styled)('div', {
  name: 'MuiDateRangePickerDay',
  slot: 'Root',
  overridesResolver: (props, styles) => styles.root
})(({
  theme,
  ownerState
}) => (0, _extends2.default)({
  [`&:first-of-type .${dateRangePickerDayClasses.rangeIntervalDayPreview}`]: (0, _extends2.default)({}, startBorderStyle, {
    borderLeftColor: theme.palette.divider
  }),
  [`&:last-of-type .${dateRangePickerDayClasses.rangeIntervalDayPreview}`]: (0, _extends2.default)({}, endBorderStyle, {
    borderRightColor: theme.palette.divider
  })
}, ownerState.isHighlighting && !ownerState.outsideCurrentMonth && {
  borderRadius: 0,
  color: theme.palette.primary.contrastText,
  backgroundColor: (0, _styles.alpha)(theme.palette.primary.light, 0.6),
  '&:first-of-type': startBorderStyle,
  '&:last-of-type': endBorderStyle
}, (ownerState.isStartOfHighlighting || ownerState.isStartOfMonth) && (0, _extends2.default)({}, startBorderStyle, {
  paddingLeft: 0,
  marginLeft: _dimensions.DAY_MARGIN / 2
}), (ownerState.isEndOfHighlighting || ownerState.isEndOfMonth) && (0, _extends2.default)({}, endBorderStyle, {
  paddingRight: 0,
  marginRight: _dimensions.DAY_MARGIN / 2
})));
const DateRangePickerDayRangeIntervalPreview = (0, _styles.styled)('div', {
  name: 'MuiDateRangePickerDay',
  slot: 'RangeIntervalPreview'
})(({
  theme,
  ownerState
}) => (0, _extends2.default)({
  // replace default day component margin with transparent border to avoid jumping on preview
  border: '2px solid transparent'
}, ownerState.isPreviewing && !ownerState.outsideCurrentMonth && (0, _extends2.default)({
  borderRadius: 0,
  border: `2px dashed ${theme.palette.divider}`,
  borderLeftColor: 'transparent',
  borderRightColor: 'transparent'
}, (ownerState.isStartOfPreviewing || ownerState.isStartOfMonth) && (0, _extends2.default)({
  borderLeftColor: theme.palette.divider
}, startBorderStyle), (ownerState.isEndOfPreviewing || ownerState.isEndOfMonth) && (0, _extends2.default)({
  borderRightColor: theme.palette.divider
}, endBorderStyle))));
const DateRangePickerDayDay = (0, _styles.styled)(_PickersDay.default, {
  name: 'MuiDateRangePickerDay',
  slot: 'Day'
})(({
  theme,
  ownerState
}) => (0, _extends2.default)({
  // Required to overlap preview border
  transform: 'scale(1.1)',
  '& > *': {
    transform: 'scale(0.9)'
  }
}, !ownerState.selected && {
  backgroundColor: 'transparent'
}, !ownerState.isHighlighting && {
  '&:hover': {
    border: `1px solid ${theme.palette.grey[500]}`
  }
}, !ownerState.selected && ownerState.isHighlighting && {
  color: theme.palette.getContrastText((0, _styles.alpha)(theme.palette.primary.light, 0.6))
}));
const DateRangePickerDay = /*#__PURE__*/React.forwardRef(function DateRangePickerDay(props, ref) {
  const {
    className,
    day,
    outsideCurrentMonth,
    isHighlighting,
    isPreviewing,
    selected = false
  } = props,
        other = (0, _objectWithoutPropertiesLoose2.default)(props, _excluded);
  const utils = (0, _useUtils.useUtils)();
  const isEndOfMonth = utils.isSameDay(day, utils.endOfMonth(day));
  const isStartOfMonth = utils.isSameDay(day, utils.startOfMonth(day));
  const shouldRenderHighlight = isHighlighting && !outsideCurrentMonth;
  const shouldRenderPreview = isPreviewing && !outsideCurrentMonth;
  const ownerState = (0, _extends2.default)({}, props, {
    selected,
    isStartOfMonth,
    isEndOfMonth
  });
  const classes = useUtilityClasses(ownerState);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(DateRangePickerDayRoot, {
    className: (0, _clsx.default)(classes.root, className),
    ownerState: ownerState,
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(DateRangePickerDayRangeIntervalPreview, {
      role: "cell",
      className: classes.rangeIntervalPreview,
      ownerState: ownerState,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(DateRangePickerDayDay, (0, _extends2.default)({}, other, {
        ref: ref,
        disableMargin: true,
        allowSameDateSelection: true,
        day: day,
        selected: selected,
        outsideCurrentMonth: outsideCurrentMonth,
        className: classes.day,
        ownerState: ownerState
      }))
    })
  });
});
process.env.NODE_ENV !== "production" ? DateRangePickerDay.propTypes
/* remove-proptypes */
= {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit TypeScript types and run "yarn proptypes"  |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The date to show.
   */
  day: _propTypes.default.any.isRequired,

  /**
   * Set to `true` if the `day` is the end of a highlighted date range.
   */
  isEndOfHighlighting: _propTypes.default.bool.isRequired,

  /**
   * Set to `true` if the `day` is the start of a highlighted date range.
   */
  isEndOfPreviewing: _propTypes.default.bool.isRequired,

  /**
   * Set to `true` if the `day` is in a highlighted date range.
   */
  isHighlighting: _propTypes.default.bool.isRequired,

  /**
   * Set to `true` if the `day` is in a preview date range.
   */
  isPreviewing: _propTypes.default.bool.isRequired,

  /**
   * Set to `true` if the `day` is the start of a highlighted date range.
   */
  isStartOfHighlighting: _propTypes.default.bool.isRequired,

  /**
   * Set to `true` if the `day` is the end of a highlighted date range.
   */
  isStartOfPreviewing: _propTypes.default.bool.isRequired,

  /**
   * If `true`, day is outside of month and will be hidden.
   */
  outsideCurrentMonth: _propTypes.default.bool.isRequired,

  /**
   * If `true`, renders as selected.
   * @default false
   */
  selected: _propTypes.default.bool,

  /**
   * The system prop that allows defining system overrides as well as additional CSS styles.
   */
  sx: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object])), _propTypes.default.func, _propTypes.default.object])
} : void 0;
/**
 *
 * Demos:
 *
 * - [Date Range Picker](https://mui.com/components/date-range-picker/)
 *
 * API:
 *
 * - [DateRangePickerDay API](https://mui.com/api/date-range-picker-day/)
 */

var _default = /*#__PURE__*/React.memo(DateRangePickerDay, (prevProps, nextProps) => {
  return prevProps.isHighlighting === nextProps.isHighlighting && prevProps.isEndOfHighlighting === nextProps.isEndOfHighlighting && prevProps.isStartOfHighlighting === nextProps.isStartOfHighlighting && prevProps.isPreviewing === nextProps.isPreviewing && prevProps.isEndOfPreviewing === nextProps.isEndOfPreviewing && prevProps.isStartOfPreviewing === nextProps.isStartOfPreviewing && (0, _PickersDay.areDayPropsEqual)(prevProps, nextProps);
});

exports.default = _default;