"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MobileKeyboardInputView = void 0;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _styles = require("@mui/material/styles");

var _useViews = require("../hooks/useViews");

var _ClockPicker = _interopRequireDefault(require("../../../ClockPicker/ClockPicker"));

var _CalendarPicker = _interopRequireDefault(require("../../../CalendarPicker"));

var _KeyboardDateInput = require("../KeyboardDateInput");

var _useIsLandscape = require("../hooks/useIsLandscape");

var _WrapperVariantContext = require("../wrappers/WrapperVariantContext");

var _PickerView = _interopRequireDefault(require("./PickerView"));

var _jsxRuntime = require("react/jsx-runtime");

const _excluded = ["autoFocus", "className", "date", "DateInputProps", "isMobileKeyboardViewOpen", "onDateChange", "onViewChange", "openTo", "orientation", "showToolbar", "toggleMobileKeyboardView", "ToolbarComponent", "toolbarFormat", "toolbarPlaceholder", "toolbarTitle", "views"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const MobileKeyboardInputView = (0, _styles.styled)('div')({
  padding: '16px 24px'
});
exports.MobileKeyboardInputView = MobileKeyboardInputView;
const PickerRoot = (0, _styles.styled)('div', {
  skipSx: true
})(({
  ownerState
}) => (0, _extends2.default)({
  display: 'flex',
  flexDirection: 'column'
}, ownerState.isLandscape && {
  flexDirection: 'row'
}));
const MobileKeyboardTextFieldProps = {
  fullWidth: true
};

const isDatePickerView = view => view === 'year' || view === 'month' || view === 'day';

const isTimePickerView = view => view === 'hours' || view === 'minutes' || view === 'seconds';

function Picker(props) {
  const {
    autoFocus,
    date,
    DateInputProps,
    isMobileKeyboardViewOpen,
    onDateChange,
    onViewChange,
    openTo,
    orientation,
    showToolbar,
    toggleMobileKeyboardView,
    ToolbarComponent = () => null,
    toolbarFormat,
    toolbarPlaceholder,
    toolbarTitle,
    views
  } = props,
        other = (0, _objectWithoutPropertiesLoose2.default)(props, _excluded);
  const isLandscape = (0, _useIsLandscape.useIsLandscape)(views, orientation);
  const wrapperVariant = React.useContext(_WrapperVariantContext.WrapperVariantContext);
  const toShowToolbar = typeof showToolbar === 'undefined' ? wrapperVariant !== 'desktop' : showToolbar;
  const handleDateChange = React.useCallback((newDate, selectionState) => {
    onDateChange(newDate, wrapperVariant, selectionState);
  }, [onDateChange, wrapperVariant]);
  const handleViewChange = React.useCallback(newView => {
    if (isMobileKeyboardViewOpen) {
      toggleMobileKeyboardView();
    }

    if (onViewChange) {
      onViewChange(newView);
    }
  }, [isMobileKeyboardViewOpen, onViewChange, toggleMobileKeyboardView]);
  const {
    openView,
    nextView,
    previousView,
    setOpenView,
    handleChangeAndOpenNext
  } = (0, _useViews.useViews)({
    view: undefined,
    views,
    openTo,
    onChange: handleDateChange,
    onViewChange: handleViewChange
  });
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(PickerRoot, {
    ownerState: {
      isLandscape
    },
    children: [toShowToolbar && /*#__PURE__*/(0, _jsxRuntime.jsx)(ToolbarComponent, (0, _extends2.default)({}, other, {
      views: views,
      isLandscape: isLandscape,
      date: date,
      onChange: handleDateChange,
      setOpenView: setOpenView,
      openView: openView,
      toolbarTitle: toolbarTitle,
      toolbarFormat: toolbarFormat,
      toolbarPlaceholder: toolbarPlaceholder,
      isMobileKeyboardViewOpen: isMobileKeyboardViewOpen,
      toggleMobileKeyboardView: toggleMobileKeyboardView
    })), /*#__PURE__*/(0, _jsxRuntime.jsx)(_PickerView.default, {
      children: isMobileKeyboardViewOpen ? /*#__PURE__*/(0, _jsxRuntime.jsx)(MobileKeyboardInputView, {
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_KeyboardDateInput.KeyboardDateInput, (0, _extends2.default)({}, DateInputProps, {
          ignoreInvalidInputs: true,
          disableOpenPicker: true,
          TextFieldProps: MobileKeyboardTextFieldProps
        }))
      }) : /*#__PURE__*/(0, _jsxRuntime.jsxs)(React.Fragment, {
        children: [isDatePickerView(openView) && /*#__PURE__*/(0, _jsxRuntime.jsx)(_CalendarPicker.default, (0, _extends2.default)({
          autoFocus: autoFocus,
          date: date,
          onViewChange: setOpenView,
          onChange: handleChangeAndOpenNext,
          view: openView // Unclear why the predicate `isDatePickerView` does not imply the casted type
          ,
          views: views.filter(isDatePickerView)
        }, other)), isTimePickerView(openView) && /*#__PURE__*/(0, _jsxRuntime.jsx)(_ClockPicker.default, (0, _extends2.default)({}, other, {
          autoFocus: autoFocus,
          date: date,
          view: openView,
          onChange: handleChangeAndOpenNext,
          openNextView: () => setOpenView(nextView),
          openPreviousView: () => setOpenView(previousView),
          nextViewAvailable: !nextView,
          previousViewAvailable: !previousView || isDatePickerView(previousView),
          showViewSwitcher: wrapperVariant === 'desktop'
        }))]
      })
    })]
  });
}

var _default = Picker;
exports.default = _default;