/// <reference types="react" />
import { chartDefaultProps } from "./default-props";
export declare type ReactGoogleChartPropsWithDefaults = typeof chartDefaultProps & ReactGoogleChartProps;
export declare type GoogleVizDrawToolbar = (toolbarContainer: HTMLDivElement, components: GoogleChartToolbarItem[]) => any;
export declare type GoogleViz = {
    charts: GoogleChartLoader;
    visualization: {
        ChartWrapper: GoogleChartWrapper;
        ChartEditor: GoogleChartEditor;
        DataTable: GoogleDataTable;
        events: GoogleVizEvents;
        arrayToDataTable: GoogleArrayToDataTable;
        drawToolbar: GoogleVizDrawToolbar;
        [otherKeys: string]: any;
    };
};
export declare type GoogleChartTicks = (number | Date)[];
export declare type GoogleChartEditor = {
    new (): GoogleChartEditor;
    openDialog: (chartWrapper: GoogleChartWrapper, chartEditorOptions?: {
        dataSourceInput?: any;
        [otherKeyMaybe: string]: any;
    }) => null;
    getChartWrapper: () => GoogleChartWrapper;
    setChartWrapper: (chartWrapper: GoogleChartWrapper) => GoogleChartWrapper;
    closeDialog: () => null;
};
export declare type GoogleChartLoaderOptions = {
    packages?: GoogleChartPackages[];
    language?: string;
    mapsApiKey?: string;
};
export declare type GoogleChartLoader = {
    load: (version: GoogleChartVersion, googleChartOptions: GoogleChartLoaderOptions) => void;
    setOnLoadCallback: (callback: () => void) => void;
};
export interface ChartWrapperProps {
    chartType: GoogleChartWrapperChartType;
    containerId?: string;
    options?: {
        width?: number;
        height?: number;
        is3D?: boolean;
        title?: string;
        backgroundColor: string;
    };
    dataTable?: {};
    dataSourceUrl?: string;
    query?: string;
    refreshInterval?: number;
    view?: any[] | {};
    render?: (props: ChartWrapperProps, chartWrapper: GoogleChartWrapper) => any;
    children?: (props: ChartWrapperProps, chartWrapper: GoogleChartWrapper) => any;
}
export declare type VizEventsProps = {
    chartWrapper: GoogleChartWrapper;
    onReady?: (chartWrapper: GoogleChartWrapper) => any;
    onError?: (chartWrapper: GoogleChartWrapper) => any;
    onSelect?: (selection: Array<{
        row?: any;
        column?: any;
    }>) => any;
    render?: (props: VizEventsProps, chartWrapper: GoogleChartWrapper) => any;
    children?: (props: VizEventsProps, chartWrapper: GoogleChartWrapper) => any;
};
export declare type GoogleChartWrapperChartType = "AnnotationChart" | "AreaChart" | "BarChart" | "BubbleChart" | "Calendar" | "CandlestickChart" | "ColumnChart" | "ComboChart" | "DiffChart" | "DonutChart" | "Gantt" | "Gauge" | "GeoChart" | "Histogram" | "LineChart" | "Line" | "Bar" | "Map" | "OrgChart" | "PieChart" | "Sankey" | "ScatterChart" | "SteppedAreaChart" | "Table" | "Timeline" | "TreeMap" | "WaterfallChart" | "WordTree";
export interface ChartWrapperOptions {
    chartType: string;
    containerId: string;
    options: Partial<{
        width: number;
        height: number;
        is3D: boolean;
        title: string;
        backgroundColor: string;
        hAxis?: {
            minValue?: any;
            maxValue?: any;
            ticks?: GoogleChartTicks;
            title?: string;
            viewWindow?: {
                max?: any;
                min?: any;
            };
            [otherOptionKey: string]: any;
        };
        vAxis?: {
            minValue?: any;
            maxValue?: any;
            ticks?: GoogleChartTicks;
            title?: string;
            viewWindow?: {
                max?: any;
                min?: any;
            };
            [otherOptionKey: string]: any;
        };
        legend: any;
        colors: string[];
        [otherOptionKey: string]: any;
    }>;
    dataTable?: GoogleDataTable;
    dataSourceUrl?: string;
    query?: string;
    refreshInterval?: number;
    view: any[] | {};
    [otherOptionKey: string]: any;
}
export declare type GoogleChartAction = {
    id: string;
    text: string;
    action: (chartWrapper: GoogleChartWrapper) => void;
};
export declare type GoogleChartControlProp = {
    controlType: "CategoryFilter" | "ChartRangeFilter" | "DateRangeFilter" | "NumberRangeFilter" | "StringFilter";
    options: {};
    controlWrapperParams?: {};
    controlID?: string;
    controlPosition?: "top" | "bottom";
    controlEvents?: ReactGoogleChartEvent[];
};
export declare type GoogleChartWrapper = {
    new (chartWrapperOptions: Partial<ChartWrapperOptions>): GoogleChartWrapper;
    draw: (chartArgs?: ChartWrapperProps) => any;
    toJSON: () => string;
    clone: () => GoogleChartWrapper;
    getDataSourceUrl: () => string;
    getDataTable: () => GoogleDataTable | null;
    getChartType: () => GoogleChartWrapperChartType;
    getChartName: () => string;
    getChart: () => {
        removeAction: (actionID: string) => void;
        getSelection: () => {
            row?: any;
            column?: any;
        }[];
        setAction: (ChartAction: GoogleChartAction) => void;
        getImageURI: () => void;
        clearChart: () => void;
    };
    getContainerId: () => string;
    getQuery: () => string;
    getRefreshInterval: () => number;
    getOption: (key: string, opt_default_value?: any) => any;
    getOptions: () => {};
    getSelection: () => {
        row?: any;
        column?: any;
    }[];
    getView: () => {} | any[];
    setDataSourceUrl: (url: string) => void;
    setDataTable: (table: any) => void;
    setChartType: (chartType: GoogleChartWrapperChartType) => void;
    setChartName: (name: string) => void;
    setContainerId: (id: string) => void;
    setQuery: (query_string: string) => void;
    setRefreshInterval: (interval: number) => void;
    setOption: (key: string, value: any) => void;
    setOptions: (options_obj: Partial<ChartWrapperOptions["options"]>) => void;
};
export declare type GoogleVizEventName = "ready" | "error" | "select" | "animationfinish" | "statechange" | "ok" | "cancel" | "animationstart";
export declare type GoogleVizEvents = {
    addListener: (chartWrapper: GoogleChartWrapper | GoogleChartControl | GoogleChartEditor, name: GoogleVizEventName, onEvent: (chartWrapper: GoogleChartWrapper) => any) => any;
    removeListener: (chartWrapper: GoogleChartWrapper, name: GoogleVizEventName, callback: Function) => any;
    removeAllListeners: (chartWrapper: GoogleChartWrapper) => any;
};
export declare type GoogleChartPackages = "corechart" | "charteditor" | "controls" | "calendar" | "gantt" | "gauge" | "geochart" | "map" | "orgchart" | "sankey" | "table" | "timeline" | "treemap" | "wordtree";
export declare type GoogleChartVersion = "current" | "upcoming";
export declare type GoogleDataTableColumnType = "string" | "number" | "boolean" | "date" | "datetime" | "timeofday";
export declare enum GoogleDataTableColumnRoleType {
    annotation = "annotation",
    annotationText = "annotationText",
    certainty = "certainty",
    emphasis = "emphasis",
    interval = "interval",
    scope = "scope",
    style = "style",
    tooltip = "tooltip",
    domain = "domain"
}
export declare type GoogleDataTableColumn = {
    type: GoogleDataTableColumnType;
    label?: string;
    role?: GoogleDataTableColumnRoleType;
    pattern?: string;
    p?: {};
    id?: string;
} | string;
export declare type GoogleDataTableCell = {
    v?: any;
    f?: string;
    p?: {};
} | string | number | boolean | Date;
export declare type GoogleDataTableRow = GoogleDataTableCell[];
export declare type GoogleDataTableJS = {
    cols: GoogleDataTableColumn[];
    rows: {
        c: GoogleDataTableRow;
    }[];
    p?: {};
};
export declare type GoogleDataTableRowFilter = {
    column: number;
    value: any;
    minValue?: any;
    maxValue?: any;
};
export declare type GoogleDataTableSortColumns = number | {
    column: number;
    desc: boolean;
} | number[] | {
    column: number;
    desc: boolean;
}[];
export declare type GoogleDataTable = {
    new (dataParam: any): GoogleDataTable;
    addColumn: (column: GoogleDataTableColumn) => number;
    addRow: (row?: GoogleDataTableRow) => number;
    addRows: (rows?: GoogleDataTableRow[] | number[] | any[]) => number;
    clone: () => GoogleDataTable;
    getColumnId: (columnIndex: number) => string;
    getColumnLabel: (columnIndex: number) => string;
    getColumnPattern: (columnIndex: number) => string;
    getColumnProperties: (columnIndex: number) => {};
    getColumnProperty: (columnIndex: number, name: string) => any;
    getColumnRange: (columnIndex: number) => {
        min: number | null;
        max: number | null;
    };
    getColumnRole: (columnIndex: number) => GoogleDataTableColumnRoleType;
    getColumnType: (columnIndex: number) => GoogleDataTableColumnType;
    getDistinctValues: (columnIndex: number) => any[];
    getFilteredRows: (filters: GoogleDataTableRowFilter[]) => number[];
    getFormattedValue: (rowIndex: number, columnIndex: number) => string;
    getNumberOfColumns: () => number;
    getNumberOfRows: () => number;
    getProperties: (rowIndex: number, columnIndex: number) => {};
    getProperty: (rowIndex: number, columnIndex: number, name: string) => any;
    getRowProperties: (rowIndex: number) => {};
    getRowProperty: (rowIndex: number, name: string) => any;
    getSortedRows: (sortColumns: GoogleDataTableSortColumns) => number[];
    getTableProperties: () => {};
    getTableProperty: (name: string) => any;
    getValue: (rowIndex: number, columnIndex: number) => boolean | string | number | Date | number[] | null;
    insertColumn: (columnIndex: number, type: GoogleDataTableColumnType, label?: string, id?: string) => void;
    insertRows: (rowIndex: number, numberOrArray: GoogleDataTableRow[] | number) => void;
    removeColumn: (columnIndex: number) => void;
    removeColumns: (columnIndex: number, numberOfColumns: number) => void;
    removeRow: (rowIndex: number) => void;
    removeRows: (rowIndex: number, numberOfColumns: number) => void;
    setCell: (rowIndex: number, columnIndex: number, value?: any, formattedValue?: string, properties?: {}) => {};
    setColumnLabel: (columnIndex: number, label: string) => void;
    setColumnProperty: (columnIndex: number, name: string, value: any) => void;
    setColumnProperties: (columnIndex: number, properties: {} | null) => void;
    setFormattedValue: (rowIndex: number, columnIndex: number, formattedValue: string) => void;
    setProperty: (rowIndex: number, columnIndex: number, name: string, value: any) => void;
    setProperties: (rowIndex: number, columnIndex: number, properties: {} | null) => void;
    setRowProperty: (rowIndex: number, name: string, value: any) => void;
    setRowProperties: (rowIndex: number, properties: {} | null) => void;
    setTableProperties: (properties: {} | null) => void;
    setValue: (rowIndex: number, columnIndex: number, value: string) => void;
    sort: (sortColumns: GoogleDataTableSortColumns) => void;
    toJSON: () => string;
};
export declare type GoogleArrayToDataTable = (data: any[][], isFirstRowLabels?: boolean) => GoogleDataTable;
export declare type GoogleChartOptions = {
    width?: number;
    height?: number;
    is3D?: boolean;
    backgroundColor: string;
    title?: string;
    hAxis?: {
        minValue?: any;
        maxValue?: any;
        ticks?: GoogleChartTicks;
        title?: string;
        viewWindow?: {
            max?: any;
            min?: any;
            [otherOptionKey: string]: any;
        };
        [otherOptionKey: string]: any;
    };
    vAxis?: {
        minValue?: any;
        maxValue?: any;
        ticks?: GoogleChartTicks;
        title?: string;
        viewWindow?: {
            max?: any;
            min?: any;
            [otherOptionKey: string]: any;
        };
        [otherOptionKey: string]: any;
    };
    bubble?: {};
    pieHole?: number;
    redFrom?: number;
    redTo?: number;
    yellowFrom?: number;
    yellowTo?: number;
    minorTicks?: number;
    legend?: string | {
        position?: string;
        maxLines?: number;
        [otherOptionKey: string]: any;
    };
    curveType?: string;
    showTooltip?: boolean;
    showInfoWindow?: boolean;
    allowHtml?: boolean;
    isStacked?: string | boolean;
    minColor?: string;
    midColor?: string;
    maxColor?: string;
    headerHeight?: number;
    fontColor?: string;
    showScale?: boolean;
    bar?: {
        groupWidth?: string;
    };
    candlestick?: {
        fallingColor?: {
            strokeWidth?: number;
            fill?: string;
        };
        risingColor?: {
            strokeWidth?: number;
            fill?: string;
        };
        [otherOptionKey: string]: any;
    };
    wordtree?: {
        format?: string;
        word?: string;
        [otherOptionKey: string]: any;
    };
    [otherOptionKey: string]: any;
};
export declare type WindowWithMaybeGoogle = Window & {
    google?: any;
};
export declare type ReactGoogleChartEvent = {
    eventName: GoogleVizEventName;
    callback: (eventCallbackArgs: {
        chartWrapper: GoogleChartWrapper;
        controlWrapper?: GoogleChartControl;
        props: ReactGoogleChartProps;
        google: GoogleViz;
        eventArgs: any;
    }) => void;
};
export declare type GoogleChartToolbarItem = {
    type: "igoogle" | "html" | "csv" | "htmlcode";
    datasource: string;
    gadget?: string;
    userPrefs?: {
        "3d": number;
        [otherKeyMaybe: string]: any;
    };
};
export declare type ReactGoogleChartProps = {
    height?: string | number;
    width?: string | number;
    graphID?: string;
    chartType: GoogleChartWrapperChartType;
    diffdata?: {
        old: any;
        new: any;
    };
    options?: ChartWrapperOptions["options"];
    loader?: JSX.Element;
    errorElement?: JSX.Element;
    data?: any[] | {};
    rows?: GoogleDataTableRow[];
    columns?: GoogleDataTableColumn[];
    chartActions?: GoogleChartAction[];
    chartEvents?: ReactGoogleChartEvent[];
    chartVersion?: GoogleChartVersion;
    chartPackages?: GoogleChartPackages[];
    chartLanguage?: string;
    mapsApiKey?: string;
    graph_id?: string;
    legendToggle?: boolean;
    legend_toggle?: boolean;
    getChartWrapper?: (chartWrapper: GoogleChartWrapper, google: GoogleViz) => void;
    getChartEditor?: (args: {
        chartEditor: GoogleChartEditor;
        chartWrapper: GoogleChartWrapper;
        google: GoogleViz;
    }) => void;
    className?: string;
    style?: React.CSSProperties;
    formatters?: {
        column: number;
        type: "ArrowFormat" | "BarFormat" | "ColorFormat" | "DateFormat" | "NumberFormat" | "PatternFormat";
        options?: {};
    }[];
    spreadSheetUrl?: string;
    spreadSheetQueryParameters?: {
        headers: number;
        gid?: number | string;
        sheet?: string;
        query?: string;
        access_token?: string;
    };
    rootProps?: any;
    controls?: GoogleChartControlProp[];
    render?: ReactGoogleChartDashboardRender;
    toolbarItems?: GoogleChartToolbarItem[];
    toolbarID?: string;
};
export declare type GoogleChartDashboard = {
    draw: (data: GoogleDataTable) => void;
    bind: (controlWrapperOrWrappers: GoogleChartControl | GoogleChartControl[], chartWrapper: GoogleChartWrapper) => void;
};
export declare type ReactGoogleChartDashboardRender = ({ renderControl, renderChart, renderToolbar }: {
    renderControl: (filter: ({ control, controlProp }: {
        control: GoogleChartControl;
        controlProp: GoogleChartControlProp;
    }) => boolean) => any;
    renderChart: () => any;
    renderToolbar: () => any;
}) => any;
export declare type GoogleChartControlOptions = any;
export declare type GoogleChartControl = {
    getContainerId: () => string;
    getOptions: () => GoogleChartControlOptions;
    getState: () => any;
    setState: (state: any) => void;
    setOptions: (options: GoogleChartControlOptions) => void;
    setControlType: (controlType: string) => void;
};
export declare type ReactGoogleChartState = {
    loadingStatus: "loading" | "errored" | "ready";
    google: null | GoogleViz;
};
export declare type ReactGoogleChartContext = {
    data: ReactGoogleChartProps["data"];
    rows: ReactGoogleChartProps["rows"] | null;
    columns: ReactGoogleChartProps["columns"] | null;
    diffdata: ReactGoogleChartProps["diffdata"] | null;
    options: ReactGoogleChartProps["options"] | null;
    legend_toggle: ReactGoogleChartProps["legend_toggle"] | null;
    legendToggle: ReactGoogleChartProps["legendToggle"] | null;
    chartType: ReactGoogleChartProps["chartType"] | null;
    formatters: ReactGoogleChartProps["formatters"] | null;
    spreadSheetUrl: ReactGoogleChartProps["spreadSheetUrl"] | null;
    spreadSheetQueryParameters: ReactGoogleChartProps["spreadSheetQueryParameters"] | null;
};
