(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'Napier-napier-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'Napier-napier-js-legacy'.");
    }root['Napier-napier-js-legacy'] = factory(typeof this['Napier-napier-js-legacy'] === 'undefined' ? {} : this['Napier-napier-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Collection = Kotlin.kotlin.collections.Collection;
  var Unit = Kotlin.kotlin.Unit;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var AbstractList = Kotlin.kotlin.collections.AbstractList;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toString = Kotlin.toString;
  LogLevel.prototype = Object.create(Enum.prototype);
  LogLevel.prototype.constructor = LogLevel;
  AtomicMutableList.prototype = Object.create(AbstractList.prototype);
  AtomicMutableList.prototype.constructor = AtomicMutableList;
  function Antilog() {
  }
  Antilog.prototype.isEnable_flj0vq$ = function (priority, tag) {
    return true;
  };
  Antilog.prototype.log_9kjzw7$ = function (priority, tag, throwable, message) {
    if (this.isEnable_flj0vq$(priority, tag)) {
      this.performLog_9kjzw7$(priority, tag, throwable, message);
    }};
  Antilog.prototype.rawLog_rg4978$ = function (priority, tag, throwable, message) {
    this.performLog_9kjzw7$(priority, tag, throwable, message);
  };
  Antilog.$metadata$ = {kind: Kind_CLASS, simpleName: 'Antilog', interfaces: []};
  function LogLevel(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function LogLevel_initFields() {
    LogLevel_initFields = function () {
    };
    LogLevel$VERBOSE_instance = new LogLevel('VERBOSE', 0);
    LogLevel$DEBUG_instance = new LogLevel('DEBUG', 1);
    LogLevel$INFO_instance = new LogLevel('INFO', 2);
    LogLevel$WARNING_instance = new LogLevel('WARNING', 3);
    LogLevel$ERROR_instance = new LogLevel('ERROR', 4);
    LogLevel$ASSERT_instance = new LogLevel('ASSERT', 5);
  }
  var LogLevel$VERBOSE_instance;
  function LogLevel$VERBOSE_getInstance() {
    LogLevel_initFields();
    return LogLevel$VERBOSE_instance;
  }
  var LogLevel$DEBUG_instance;
  function LogLevel$DEBUG_getInstance() {
    LogLevel_initFields();
    return LogLevel$DEBUG_instance;
  }
  var LogLevel$INFO_instance;
  function LogLevel$INFO_getInstance() {
    LogLevel_initFields();
    return LogLevel$INFO_instance;
  }
  var LogLevel$WARNING_instance;
  function LogLevel$WARNING_getInstance() {
    LogLevel_initFields();
    return LogLevel$WARNING_instance;
  }
  var LogLevel$ERROR_instance;
  function LogLevel$ERROR_getInstance() {
    LogLevel_initFields();
    return LogLevel$ERROR_instance;
  }
  var LogLevel$ASSERT_instance;
  function LogLevel$ASSERT_getInstance() {
    LogLevel_initFields();
    return LogLevel$ASSERT_instance;
  }
  LogLevel.$metadata$ = {kind: Kind_CLASS, simpleName: 'LogLevel', interfaces: [Enum]};
  function LogLevel$values() {
    return [LogLevel$VERBOSE_getInstance(), LogLevel$DEBUG_getInstance(), LogLevel$INFO_getInstance(), LogLevel$WARNING_getInstance(), LogLevel$ERROR_getInstance(), LogLevel$ASSERT_getInstance()];
  }
  LogLevel.values = LogLevel$values;
  function LogLevel$valueOf(name) {
    switch (name) {
      case 'VERBOSE':
        return LogLevel$VERBOSE_getInstance();
      case 'DEBUG':
        return LogLevel$DEBUG_getInstance();
      case 'INFO':
        return LogLevel$INFO_getInstance();
      case 'WARNING':
        return LogLevel$WARNING_getInstance();
      case 'ERROR':
        return LogLevel$ERROR_getInstance();
      case 'ASSERT':
        return LogLevel$ASSERT_getInstance();
      default:throwISE('No enum constant io.github.aakira.napier.LogLevel.' + name);
    }
  }
  LogLevel.valueOf_61zpoe$ = LogLevel$valueOf;
  function Napier() {
    Napier_instance = this;
    this.baseArray_0 = AtomicMutableList_init();
  }
  Napier.prototype.base_gqnbhx$ = function (antilog) {
    this.baseArray_0.add_dpg1yx$(antilog);
  };
  Napier.prototype.isEnable_flj0vq$ = function (priority, tag) {
    var $receiver = this.baseArray_0;
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (element.isEnable_flj0vq$(priority, tag)) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  };
  Napier.prototype.rawLog_9kjzw7$ = function (priority, tag, throwable, message) {
    var tmp$;
    tmp$ = this.baseArray_0.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      element.rawLog_rg4978$(priority, tag, throwable, message);
    }
  };
  Napier.prototype.v_82mfvz$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$VERBOSE_getInstance(), tag, throwable, message);
  };
  Napier.prototype.v_9h2hdn$ = function (throwable, tag, message) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$VERBOSE_getInstance(), tag, throwable, message());
  };
  Napier.prototype.i_82mfvz$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$INFO_getInstance(), tag, throwable, message);
  };
  Napier.prototype.i_9h2hdn$ = function (throwable, tag, message) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$INFO_getInstance(), tag, throwable, message());
  };
  Napier.prototype.d_82mfvz$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$DEBUG_getInstance(), tag, throwable, message);
  };
  Napier.prototype.d_9h2hdn$ = function (throwable, tag, message) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$DEBUG_getInstance(), tag, throwable, message());
  };
  Napier.prototype.w_82mfvz$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$WARNING_getInstance(), tag, throwable, message);
  };
  Napier.prototype.w_9h2hdn$ = function (throwable, tag, message) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$WARNING_getInstance(), tag, throwable, message());
  };
  Napier.prototype.e_82mfvz$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$ERROR_getInstance(), tag, throwable, message);
  };
  Napier.prototype.e_9h2hdn$ = function (throwable, tag, message) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$ERROR_getInstance(), tag, throwable, message());
  };
  Napier.prototype.wtf_82mfvz$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$ASSERT_getInstance(), tag, throwable, message);
  };
  Napier.prototype.wtf_9h2hdn$ = function (throwable, tag, message) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = null;
    this.log_th80u0$(LogLevel$ASSERT_getInstance(), tag, throwable, message());
  };
  Napier.prototype.log_th80u0$ = function (priority, tag, throwable, message) {
    if (tag === void 0)
      tag = null;
    if (throwable === void 0)
      throwable = null;
    if (this.isEnable_flj0vq$(priority, tag)) {
      this.rawLog_9kjzw7$(priority, tag, throwable, message);
    }};
  Napier.prototype.takeLogarithm_gqnbhx$ = function (antilog) {
    this.baseArray_0.remove_11rb$(antilog);
  };
  Napier.prototype.takeLogarithm = function () {
    this.baseArray_0.clear();
  };
  Napier.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Napier', interfaces: []};
  var Napier_instance = null;
  function Napier_getInstance() {
    if (Napier_instance === null) {
      new Napier();
    }return Napier_instance;
  }
  function AtomicMutableList(value) {
    AbstractList.call(this);
    this.atomicReference_0 = new AtomicRef(value);
  }
  function AtomicMutableList$add$lambda(closure$index, closure$element) {
    return function ($receiver) {
      $receiver.add_wxm5ur$(closure$index, closure$element);
      return Unit;
    };
  }
  AtomicMutableList.prototype.add_dpg1yx$ = function (element, index) {
    if (index === void 0) {
      index = this.size;
    }this.modify_0(1, AtomicMutableList$add$lambda(index, element));
  };
  function AtomicMutableList$remove$lambda(closure$t) {
    return function ($receiver) {
      return $receiver.remove_11rb$(closure$t);
    };
  }
  AtomicMutableList.prototype.remove_11rb$ = function (t) {
    return this.modify_0(-1, AtomicMutableList$remove$lambda(t));
  };
  function AtomicMutableList$clear$lambda($receiver) {
    $receiver.clear();
    return Unit;
  }
  AtomicMutableList.prototype.clear = function () {
    this.modify_0(-this.size | 0, AtomicMutableList$clear$lambda);
  };
  function AtomicMutableList$removeAt$lambda(closure$index) {
    return function ($receiver) {
      return $receiver.removeAt_za3lpa$(closure$index);
    };
  }
  AtomicMutableList.prototype.removeAt_za3lpa$ = function (index) {
    return this.modify_0(-1, AtomicMutableList$removeAt$lambda(index));
  };
  function AtomicMutableList$set$lambda(closure$index, closure$element) {
    return function ($receiver) {
      return $receiver.set_wxm5ur$(closure$index, closure$element);
    };
  }
  AtomicMutableList.prototype.set_wxm5ur$ = function (index, element) {
    return this.modify_0(0, AtomicMutableList$set$lambda(index, element));
  };
  AtomicMutableList.prototype.dropAll = function () {
    var result = this.atomicReference_0.value;
    this.atomicReference_0.value = emptyList();
    return result;
  };
  Object.defineProperty(AtomicMutableList.prototype, 'size', {configurable: true, get: function () {
    return this.atomicReference_0.value.size;
  }});
  AtomicMutableList.prototype.isEmpty = function () {
    return this.atomicReference_0.value.isEmpty();
  };
  AtomicMutableList.prototype.contains_11rb$ = function (element) {
    return this.atomicReference_0.value.contains_11rb$(element);
  };
  AtomicMutableList.prototype.get_za3lpa$ = function (index) {
    return this.atomicReference_0.value.get_za3lpa$(index);
  };
  AtomicMutableList.prototype.indexOf_11rb$ = function (element) {
    return this.atomicReference_0.value.indexOf_11rb$(element);
  };
  AtomicMutableList.prototype.lastIndexOf_11rb$ = function (element) {
    return this.atomicReference_0.value.lastIndexOf_11rb$(element);
  };
  AtomicMutableList.prototype.iterator = function () {
    return this.atomicReference_0.value.iterator();
  };
  AtomicMutableList.prototype.modify_0 = function (capacityDiff, block) {
    var newValue = ArrayList_init(this.size + capacityDiff | 0);
    newValue.addAll_brywnq$(this);
    var result = block(newValue);
    this.atomicReference_0.value = newValue;
    return result;
  };
  AtomicMutableList.$metadata$ = {kind: Kind_CLASS, simpleName: 'AtomicMutableList', interfaces: [AbstractList]};
  function AtomicMutableList_init($this) {
    $this = $this || Object.create(AtomicMutableList.prototype);
    AtomicMutableList.call($this, emptyList());
    return $this;
  }
  function AtomicRef(value) {
    this.value = value;
  }
  AtomicRef.$metadata$ = {kind: Kind_CLASS, simpleName: 'AtomicRef', interfaces: []};
  var package$io = _.io || (_.io = {});
  var package$github = package$io.github || (package$io.github = {});
  var package$aakira = package$github.aakira || (package$github.aakira = {});
  var package$napier = package$aakira.napier || (package$aakira.napier = {});
  package$napier.Antilog = Antilog;
  Object.defineProperty(LogLevel, 'VERBOSE', {get: LogLevel$VERBOSE_getInstance});
  Object.defineProperty(LogLevel, 'DEBUG', {get: LogLevel$DEBUG_getInstance});
  Object.defineProperty(LogLevel, 'INFO', {get: LogLevel$INFO_getInstance});
  Object.defineProperty(LogLevel, 'WARNING', {get: LogLevel$WARNING_getInstance});
  Object.defineProperty(LogLevel, 'ERROR', {get: LogLevel$ERROR_getInstance});
  Object.defineProperty(LogLevel, 'ASSERT', {get: LogLevel$ASSERT_getInstance});
  package$napier.LogLevel = LogLevel;
  Object.defineProperty(package$napier, 'Napier', {get: Napier_getInstance});
  var package$atomic = package$napier.atomic || (package$napier.atomic = {});
  package$atomic.AtomicMutableList_init_287e2$ = AtomicMutableList_init;
  package$atomic.AtomicMutableList = AtomicMutableList;
  package$atomic.AtomicRef = AtomicRef;
  return _;
}));

//# sourceMappingURL=Napier-napier-js-legacy.js.map
