(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'door-door-runtime', 'UstadMobile-lib-util', 'UstadMobile-lib-database-entities', 'kotlinx-coroutines-core', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('door-door-runtime'), require('UstadMobile-lib-util'), require('UstadMobile-lib-database-entities'), require('kotlinx-coroutines-core'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-database'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'UstadMobile-lib-database'.");
    }if (typeof this['door-door-runtime'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-database'. Its dependency 'door-door-runtime' was not found. Please, check whether 'door-door-runtime' is loaded prior to 'UstadMobile-lib-database'.");
    }if (typeof this['UstadMobile-lib-util'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-database'. Its dependency 'UstadMobile-lib-util' was not found. Please, check whether 'UstadMobile-lib-util' is loaded prior to 'UstadMobile-lib-database'.");
    }if (typeof this['UstadMobile-lib-database-entities'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-database'. Its dependency 'UstadMobile-lib-database-entities' was not found. Please, check whether 'UstadMobile-lib-database-entities' is loaded prior to 'UstadMobile-lib-database'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-database'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'UstadMobile-lib-database'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-database'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'UstadMobile-lib-database'.");
    }root['UstadMobile-lib-database'] = factory(typeof this['UstadMobile-lib-database'] === 'undefined' ? {} : this['UstadMobile-lib-database'], kotlin, this['door-door-runtime'], this['UstadMobile-lib-util'], this['UstadMobile-lib-database-entities'], this['kotlinx-coroutines-core'], this['kotlinx-serialization-kotlinx-serialization-core-js-legacy']);
  }
}(this, function (_, Kotlin, $module$door_door_runtime, $module$UstadMobile_lib_util, $module$UstadMobile_lib_database_entities, $module$kotlinx_coroutines_core, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy) {
  'use strict';
  var dbType = $module$door_door_runtime.com.ustadmobile.door.ext.dbType_omobsc$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var minifySql = $module$door_door_runtime.com.ustadmobile.door.ext.minifySql_pdl1vz$;
  var joinToString = Kotlin.kotlin.collections.joinToString_cgipc5$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var DoorDatabaseCallbackStatementList = $module$door_door_runtime.com.ustadmobile.door.DoorDatabaseCallbackStatementList;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toString = Kotlin.toString;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var trimIndent = Kotlin.kotlin.text.trimIndent_pdl1vz$;
  var Unit = Kotlin.kotlin.Unit;
  var DoorMigrationSync = $module$door_door_runtime.com.ustadmobile.door.migration.DoorMigrationSync;
  var trimMargin = Kotlin.kotlin.text.trimMargin_rjktp$;
  var systemTimeInMillis = $module$door_door_runtime.com.ustadmobile.door.util.systemTimeInMillis;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var util = $module$door_door_runtime.com.ustadmobile.door.util;
  var ScopedGrant$Companion$ALL_ENTITIES = Kotlin.Long.fromInt(-2);
  var Role$Companion$ALL_PERMISSIONS = Kotlin.Long.MAX_VALUE;
  var randomString = $module$UstadMobile_lib_util.com.ustadmobile.lib.util.randomString_19mbxw$;
  var L13194139533312 = new Kotlin.Long(0, 3072);
  var plus = Kotlin.kotlin.collections.plus_mydzjv$;
  var DoorMigrationStatementList = $module$door_door_runtime.com.ustadmobile.door.migration.DoorMigrationStatementList;
  var fixTincan = $module$UstadMobile_lib_util.com.ustadmobile.lib.util.ext.fixTincan_omobsc$;
  var DoorDatabase = $module$door_door_runtime.com.ustadmobile.door.DoorDatabase;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var execSqlBatch = $module$door_door_runtime.com.ustadmobile.door.ext.execSqlBatch_3112hw$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var L0 = Kotlin.Long.ZERO;
  var ConnectivityStatus = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.ConnectivityStatus;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var doorMainDispatcher = $module$door_door_runtime.com.ustadmobile.door.doorMainDispatcher;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var DoorObserver = $module$door_door_runtime.com.ustadmobile.door.DoorObserver;
  var getCallableRef = Kotlin.getCallableRef;
  var chunked = Kotlin.kotlin.collections.chunked_ba2ldo$;
  var toList_0 = Kotlin.kotlin.collections.toList_7wnvza$;
  var wrapFunction = Kotlin.wrapFunction;
  var dbType_0 = $module$door_door_runtime.com.ustadmobile.door.ext.dbType_igmkyi$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  var Language = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.Language;
  var LeavingReason = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.LeavingReason;
  var LeavingReason_init = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.LeavingReason_init_tqiios$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var encryptPassword = $module$UstadMobile_lib_util.com.ustadmobile.lib.util.encryptPassword_61zpoe$;
  var equals = Kotlin.equals;
  var PersonAuth_init = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.PersonAuth_init_a4hdmt$;
  var getSystemTimeInMillis = $module$UstadMobile_lib_util.com.ustadmobile.lib.util.getSystemTimeInMillis;
  var AccessToken_init = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.AccessToken_init_jl0yiw$;
  var UmAccount = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.UmAccount;
  var ensureNotNull = Kotlin.ensureNotNull;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var AuditLog_init = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.AuditLog_init_ro19vi$;
  var L2419200000 = new Kotlin.Long(-1875767296, 0);
  var PluginGeneratedSerialDescriptor = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;
  var UnknownFieldException = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.UnknownFieldException;
  var internal = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal;
  var GeneratedSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal.GeneratedSerializer;
  var Report = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.Report;
  var SimpleDoorQuery = $module$door_door_runtime.com.ustadmobile.door.SimpleDoorQuery;
  var NullableSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal.NullableSerializer;
  var VerbEntity = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.VerbEntity;
  var VerbEntity_init = $module$UstadMobile_lib_database_entities.com.ustadmobile.lib.db.entities.VerbEntity_init_tqiios$;
  var SyncNodeIdCallback = $module$door_door_runtime.com.ustadmobile.door.SyncNodeIdCallback;
  UmAppDatabase.prototype = Object.create(DoorDatabase.prototype);
  UmAppDatabase.prototype.constructor = UmAppDatabase;
  function ContentJobItemTriggersCallback() {
    ContentJobItemTriggersCallback$Companion_getInstance();
  }
  ContentJobItemTriggersCallback.prototype.onCreate_j4i37p$ = function (db) {
    var tmp$;
    if (dbType(db) === 1) {
      tmp$ = toList(ContentJobItemTriggersCallback$Companion_getInstance().sqliteContentJobItemTriggers_0);
    } else {
      tmp$ = toList(ContentJobItemTriggersCallback$Companion_getInstance().postgresContentJobItemTriggers_0);
    }
    return tmp$;
  };
  ContentJobItemTriggersCallback.prototype.onOpen_j4i37p$ = function (db) {
    var tmp$;
    if (dbType(db) === 1) {
      tmp$ = listOf('\n                PRAGMA recursive_triggers = ON;\n            ');
    } else {
      tmp$ = emptyList();
    }
    return tmp$;
  };
  function ContentJobItemTriggersCallback$Companion() {
    ContentJobItemTriggersCallback$Companion_instance = this;
    this.sqliteContentJobItemTriggers_0 = ['\n                CREATE TRIGGER ContentJobItem_InsertTrigger \n                AFTER INSERT ON ContentJobItem\n                BEGIN\n                UPDATE ContentJobItem \n                   SET cjiRecursiveProgress = NEW.cjiItemProgress,\n                       cjiRecursiveTotal = NEW.cjiItemTotal\n                WHERE ContentJobItem.cjiUid = NEW.cjiUid;\n                END;\n                ', '\n                CREATE TRIGGER ContentJobItem_UpdateRecursiveTotals \n                AFTER UPDATE ON ContentJobItem\n                FOR EACH ROW WHEN (\n                    NEW.cjiItemProgress != OLD.cjiItemProgress\n                        OR NEW.cjiItemTotal != OLD.cjiItemTotal)\n                BEGIN\n                UPDATE ContentJobItem \n                   SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiItemProgress - OLD.cjiItemProgress)),\n                       cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiItemTotal - OLD.cjiItemTotal))\n                 WHERE ContentJobItem.cjiUid = NEW.cjiUid;\n                END;\n                ', '\n' + '                CREATE TRIGGER ContentJobItem_UpdateRecursiveStatus' + '\n' + '                AFTER UPDATE ON ContentJobItem' + '\n' + '                FOR EACH ROW WHEN (NEW.cjiStatus != OLD.cjiStatus)' + '\n' + '                BEGIN ' + '\n' + '                UPDATE ContentJobItem' + '\n' + '                   SET cjiRecursiveStatus = ' + this.recursiveStatusCaseClause_61zpoe$('NEW.cjiUid') + '\n' + '                 WHERE contentJobItem.cjiUid = NEW.cjiUid;' + '\n' + '                END;    ' + '\n' + '                ', '\n                CREATE TRIGGER ContentJobItem_UpdateParents\n                AFTER UPDATE ON ContentJobItem\n                FOR EACH ROW WHEN (\n                        NEW.cjiParentCjiUid != 0 \n                    AND (NEW.cjiRecursiveProgress != OLD.cjiRecursiveProgress\n                         OR NEW.cjiRecursiveTotal != OLD.cjiRecursiveTotal))\n                BEGIN\n                UPDATE ContentJobItem \n                   SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiRecursiveProgress - OLD.cjiRecursiveProgress)),\n                       cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiRecursiveTotal - OLD.cjiRecursiveTotal))\n                 WHERE ContentJobItem.cjiUid = NEW.cjiParentCjiUid;\n                END;\n                ', '\n' + '                CREATE TRIGGER ContentJobItem_UpdateStatusParent' + '\n' + '                AFTER UPDATE ON ContentJobItem' + '\n' + '                FOR EACH ROW WHEN (' + '\n' + '                         NEW.cjiParentCjiUid != 0' + '\n' + '                    AND (New.cjiRecursiveStatus != OLD.cjiRecursiveStatus))' + '\n' + '                BEGIN' + '\n' + '                UPDATE ContentJobItem' + '\n' + '                   SET cjiRecursiveStatus = ' + this.recursiveStatusCaseClause_61zpoe$('NEW.cjiParentCjiUid') + '\n' + '                 WHERE ContentJobItem.cjiUid = NEW.cjiParentCjiUid;' + '\n' + '                 END;' + '\n' + '                '];
    this.postgresContentJobItemTriggers_0 = ['\n                CREATE OR REPLACE FUNCTION contentjobiteminsert_fn() RETURNS TRIGGER AS $$ \n                BEGIN\n                UPDATE ContentJobItem \n                   SET cjiRecursiveProgress = NEW.cjiItemProgress,\n                       cjiRecursiveTotal = NEW.cjiItemTotal\n                 WHERE ContentJobItem.cjiUid = NEW.cjiUid;\n                RETURN NEW; \n                END $$ LANGUAGE plpgsql\n                ', '\n                CREATE TRIGGER contentjobiteminsert_trig \n                AFTER INSERT ON ContentJobItem\n                FOR EACH ROW EXECUTE PROCEDURE contentjobiteminsert_fn()    \n                ', '\n                CREATE OR REPLACE FUNCTION contentjobitem_updaterecursivetotals_fn() RETURNS TRIGGER AS $$\n                BEGIN\n                UPDATE ContentJobItem \n                   SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiItemProgress - OLD.cjiItemProgress)),\n                       cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiItemTotal - OLD.cjiItemTotal))\n                 WHERE (NEW.cjiItemProgress != OLD.cjiItemProgress OR NEW.cjiItemTotal != OLD.cjiItemTotal)\n                   AND ContentJobItem.cjiUid = NEW.cjiUid;\n                RETURN NEW;\n                END $$ LANGUAGE plpgsql\n                ', '\n                CREATE TRIGGER contentjobitem_updaterecursivetotals_trig\n                AFTER UPDATE ON ContentJobItem\n                FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updaterecursivetotals_fn();\n                ', '\n                CREATE OR REPLACE FUNCTION contentjobitem_updateparents_fn() RETURNS TRIGGER AS $$\n                BEGIN \n                UPDATE ContentJobItem \n                   SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiRecursiveProgress - OLD.cjiRecursiveProgress)),\n                       cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiRecursiveTotal - OLD.cjiRecursiveTotal))\n                 WHERE (NEW.cjiRecursiveProgress != OLD.cjiRecursiveProgress\n                        OR NEW.cjiRecursiveTotal != OLD.cjiRecursiveTotal)\n                    AND ContentJobItem.cjiUid = NEW.cjiParentCjiUid\n                    AND NEW.cjiParentCjiUid != 0;  \n                RETURN NEW;\n                END $$ LANGUAGE plpgsql\n                ', '\n                CREATE TRIGGER contentjobitem_updateparents_trig\n                AFTER UPDATE ON ContentJobItem\n                FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updateparents_fn();    \n                ', '\n' + '                 CREATE OR REPLACE FUNCTION contentjobitem_updatestatus_fn() RETURNS TRIGGER AS ' + String.fromCharCode(36) + String.fromCharCode(36) + '\n' + '                 BEGIN ' + '\n' + '                 UPDATE ContentJobItem' + '\n' + '                    SET cjiRecursiveStatus = ' + this.recursiveStatusCaseClause_61zpoe$('NEW.cjiUid') + '\n' + '                  WHERE contentJobItem.cjiUid = NEW.cjiUid ' + '\n' + '                    AND NEW.cjiStatus != OLD.cjiStatus;' + '\n' + '                 RETURN NEW;     ' + '\n' + '                 END ' + String.fromCharCode(36) + String.fromCharCode(36) + ' LANGUAGE plpgsql  ' + '\n' + '                 ', '\n                 CREATE TRIGGER contentjobitem_updatestatus_trig\n                 AFTER UPDATE ON ContentJobItem\n                 FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updatestatus_fn();    \n                 ', '\n' + '                 CREATE OR REPLACE FUNCTION contentjobitem_updatestatusparents_fn() RETURNS TRIGGER AS ' + String.fromCharCode(36) + String.fromCharCode(36) + '\n' + '                 BEGIN' + '\n' + '                 UPDATE ContentJobItem' + '\n' + '                   SET cjiRecursiveStatus = ' + this.recursiveStatusCaseClause_61zpoe$('NEW.cjiParentCjiUid') + '\n' + '                 WHERE NEW.cjiParentCjiUid != 0 ' + '\n' + '                   AND NEW.cjiRecursiveStatus != OLD.cjiRecursiveStatus' + '\n' + '                   AND ContentJobItem.cjiUid = NEW.cjiParentCjiUid;     ' + '\n' + '                 RETURN NEW;     ' + '\n' + '                 END ' + String.fromCharCode(36) + String.fromCharCode(36) + ' LANGUAGE plpgsql     ' + '\n' + '                 ', '\n                 CREATE TRIGGER contentjobitem_updatestatusparents_trig\n                 AFTER UPDATE ON ContentJobItem\n                 FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updatestatusparents_fn();        \n                 '];
  }
  function ContentJobItemTriggersCallback$Companion$dumpSqlStatements$lambda(it) {
    return minifySql(it);
  }
  function ContentJobItemTriggersCallback$Companion$dumpSqlStatements$lambda_0(it) {
    return minifySql(it);
  }
  ContentJobItemTriggersCallback$Companion.prototype.dumpSqlStatements = function () {
    println('SQLITE:');
    println(joinToString(this.sqliteContentJobItemTriggers_0, '",\n"', '"', '"', void 0, void 0, ContentJobItemTriggersCallback$Companion$dumpSqlStatements$lambda));
    println('POSTGRES');
    println(joinToString(this.postgresContentJobItemTriggers_0, '",\n"', '"', '"', void 0, void 0, ContentJobItemTriggersCallback$Companion$dumpSqlStatements$lambda_0));
  };
  ContentJobItemTriggersCallback$Companion.prototype.getStatusOfItemAndChildrenSql_0 = function (contentJobItemUidExpression) {
    return '\n' + '                  (SELECT cjiRecursiveStatus AS status ' + '\n' + '                     FROM ContentJobItem ' + '\n' + '                    WHERE cjiParentCjiUid = ' + contentJobItemUidExpression + '\n' + '              UNION' + '\n' + '                   SELECT cjiStatus AS status' + '\n' + '                     FROM ContentJobItem ' + '\n' + '                    WHERE cjiUid = ' + contentJobItemUidExpression + ') AS JobStatus' + '\n' + '            ';
  };
  ContentJobItemTriggersCallback$Companion.prototype.recursiveStatusCaseClause_61zpoe$ = function (contentJobItemUidExpression) {
    return '\n' + '                  (CASE WHEN ' + '\n' + '\t\t\t\t\t\t\t(SELECT Count(*) FROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ') = ' + '\n' + '\t\t\t\t\t\t\t(SELECT Count(*) ' + '\n' + '\t\t\t\t\t\t\t   FROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ' ' + '\n' + '\t\t\t\t\t\t\t  WHERE status = ' + '24' + ') ' + '\n' + '\t\t\t\t\t      THEN  ' + '24' + ' ' + '\n' + '                          WHEN (SELECT Count(*) FROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ') = ' + '\n' + '                            (SELECT Count(*) ' + '\n' + '\t\t\t\t\t\t\t   FROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ' ' + '\n' + '\t\t\t\t\t\t\t  WHERE status = ' + '25' + ') ' + '\n' + '                          THEN ' + '25' + '\n' + '                          WHEN(SELECT COUNT(*) FROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ') = ' + '\n' + '                             (SELECT COUNT(*)' + '\n' + '                                FROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + '\n' + '                               WHERE status = ' + '28' + ')' + '\n' + '                          THEN ' + '28' + '\n' + '\t\t\t\t\t\t  WHEN EXISTS (SELECT status ' + '\n' + '\t\t\t\t\t\t\t\t\t\tFROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + '\t' + '\n' + '\t\t\t\t\t\t\t\t\t\tWHERE status = ' + '12' + ')' + '\n' + '\t\t\t\t\t\t  THEN ' + '12' + '\n' + '                          WHEN EXISTS (SELECT status' + '\n' + '\t\t\t\t\t\t\t\t\t\tFROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ' ' + '\n' + '\t\t\t\t\t\t\t\t\t    WHERE (status = ' + '25' + '\n' + '                                           OR status = ' + '23' + '))' + '\n' + '\t\t\t\t\t\t  THEN ' + '23' + '\n' + '\t\t\t\t\t\t  WHEN EXISTS (SELECT status' + '\n' + '\t\t\t\t\t\t\t\t\t\tFROM ' + this.getStatusOfItemAndChildrenSql_0(contentJobItemUidExpression) + ' ' + '\n' + '\t\t\t\t\t\t\t\t\t    WHERE status = ' + '5' + ')' + '\n' + '\t\t\t\t\t\t  THEN ' + '5' + ' ' + '\n' + '\t\t\t\t\t\t  ELSE ' + '4' + ' END)  ' + '\n' + '            ';
  };
  ContentJobItemTriggersCallback$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ContentJobItemTriggersCallback$Companion_instance = null;
  function ContentJobItemTriggersCallback$Companion_getInstance() {
    if (ContentJobItemTriggersCallback$Companion_instance === null) {
      new ContentJobItemTriggersCallback$Companion();
    }return ContentJobItemTriggersCallback$Companion_instance;
  }
  ContentJobItemTriggersCallback.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentJobItemTriggersCallback', interfaces: [DoorDatabaseCallbackStatementList]};
  var JobStatus_instance = null;
  function SiteTermsDao() {
  }
  function Coroutine$deactivateByUids_ejltwb$($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$.prototype.constructor = Coroutine$deactivateByUids_ejltwb$;
  Coroutine$deactivateByUids_ejltwb$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateActiveByUid_zaz62j$(element, false, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  SiteTermsDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  SiteTermsDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'SiteTermsDao', interfaces: [OneToManyJoinDao]};
  function UmAppDatabase() {
    UmAppDatabase$Companion_getInstance();
    DoorDatabase.call(this);
  }
  function Coroutine$preload($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$preload.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$preload.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$preload.prototype.constructor = Coroutine$preload;
  Coroutine$preload.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.verbDao.initPreloadedVerbs(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.$this.reportDao.initPreloadedTemplates();
            this.state_0 = 3;
            this.result_0 = this.$this.leavingReasonDao.initPreloadedLeavingReasons(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.$this.languageDao.initPreloadedLanguages();
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  UmAppDatabase.prototype.preload = function (continuation_0, suspended) {
    var instance = new Coroutine$preload(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function UmAppDatabase$Companion() {
    UmAppDatabase$Companion_instance = this;
    this.TAG_DB = 1;
    this.TAG_REPO = 2;
    this.MIGRATION_44_45 = new DoorMigrationSync(44, 45, UmAppDatabase$Companion$MIGRATION_44_45$lambda);
    this.MIGRATION_45_46 = new DoorMigrationSync(45, 46, UmAppDatabase$Companion$MIGRATION_45_46$lambda);
    this.MIGRATION_46_47 = new DoorMigrationSync(46, 47, UmAppDatabase$Companion$MIGRATION_46_47$lambda);
    this.MIGRATION_47_48 = new DoorMigrationSync(47, 48, UmAppDatabase$Companion$MIGRATION_47_48$lambda);
    this.MIGRATION_48_49 = new DoorMigrationSync(48, 49, UmAppDatabase$Companion$MIGRATION_48_49$lambda);
    this.MIGRATION_49_50 = new DoorMigrationSync(49, 50, UmAppDatabase$Companion$MIGRATION_49_50$lambda);
    this.MIGRATION_50_51 = new DoorMigrationSync(50, 51, UmAppDatabase$Companion$MIGRATION_50_51$lambda);
    this.MIGRATION_51_52 = new DoorMigrationSync(51, 52, UmAppDatabase$Companion$MIGRATION_51_52$lambda);
    this.MIGRATION_52_53 = new DoorMigrationSync(52, 53, UmAppDatabase$Companion$MIGRATION_52_53$lambda);
    this.MIGRATION_53_54 = new DoorMigrationSync(53, 54, UmAppDatabase$Companion$MIGRATION_53_54$lambda);
    this.MIGRATION_54_55 = new DoorMigrationSync(54, 55, UmAppDatabase$Companion$MIGRATION_54_55$lambda);
    this.MIGRATION_55_56 = new DoorMigrationSync(55, 56, UmAppDatabase$Companion$MIGRATION_55_56$lambda);
    this.MIGRATION_56_57 = new DoorMigrationSync(56, 57, UmAppDatabase$Companion$MIGRATION_56_57$lambda);
    this.MIGRATION_57_58 = new DoorMigrationSync(57, 58, UmAppDatabase$Companion$MIGRATION_57_58$lambda);
    this.MIGRATION_58_59 = new DoorMigrationSync(58, 59, UmAppDatabase$Companion$MIGRATION_58_59$lambda);
    this.MIGRATION_59_60 = new DoorMigrationSync(59, 60, UmAppDatabase$Companion$MIGRATION_59_60$lambda);
    this.MIGRATION_60_61 = new DoorMigrationSync(60, 61, UmAppDatabase$Companion$MIGRATION_60_61$lambda);
    this.MIGRATION_61_62 = new DoorMigrationSync(61, 62, UmAppDatabase$Companion$MIGRATION_61_62$lambda);
    this.MIGRATION_62_63 = new DoorMigrationSync(62, 63, UmAppDatabase$Companion$MIGRATION_62_63$lambda);
    this.MIGRATION_63_64 = new DoorMigrationSync(63, 64, UmAppDatabase$Companion$MIGRATION_63_64$lambda);
    this.MIGRATION_78_79 = new DoorMigrationSync(78, 79, UmAppDatabase$Companion$MIGRATION_78_79$lambda);
    this.MIGRATION_64_65 = new DoorMigrationSync(64, 65, UmAppDatabase$Companion$MIGRATION_64_65$lambda);
    this.MIGRATION_65_66 = new DoorMigrationSync(65, 66, UmAppDatabase$Companion$MIGRATION_65_66$lambda);
    this.MIGRATION_66_67 = new DoorMigrationSync(66, 67, UmAppDatabase$Companion$MIGRATION_66_67$lambda);
    this.MIGRATION_68_69 = new DoorMigrationSync(68, 69, UmAppDatabase$Companion$MIGRATION_68_69$lambda);
    this.MIGRATION_69_70_8be2vx$ = new DoorMigrationSync(69, 70, UmAppDatabase$Companion$MIGRATION_69_70$lambda);
    this.MIGRATION_70_71_8be2vx$ = new DoorMigrationSync(70, 71, UmAppDatabase$Companion$MIGRATION_70_71$lambda);
    this.MIGRATION_71_72 = new DoorMigrationSync(71, 72, UmAppDatabase$Companion$MIGRATION_71_72$lambda);
    this.MIGRATION_72_73 = new DoorMigrationSync(72, 73, UmAppDatabase$Companion$MIGRATION_72_73$lambda);
    this.MIGRATION_73_74 = new DoorMigrationSync(73, 74, UmAppDatabase$Companion$MIGRATION_73_74$lambda);
    this.MIGRATION_74_75 = new DoorMigrationSync(74, 75, UmAppDatabase$Companion$MIGRATION_74_75$lambda);
    this.MIGRATION_75_76 = new DoorMigrationSync(75, 76, UmAppDatabase$Companion$MIGRATION_75_76$lambda);
    this.MIGRATION_76_77 = new DoorMigrationSync(76, 77, UmAppDatabase$Companion$MIGRATION_76_77$lambda);
    this.MIGRATION_77_78 = new DoorMigrationSync(77, 78, UmAppDatabase$Companion$MIGRATION_77_78$lambda);
    this.MIGRATION_79_80 = new DoorMigrationStatementList(79, 80, UmAppDatabase$Companion$MIGRATION_79_80$lambda);
    this.fooVar = 2;
    this.MIGRATION_80_81 = new DoorMigrationStatementList(80, 81, UmAppDatabase$Companion$MIGRATION_80_81$lambda);
    this.MIGRATION_81_82 = new DoorMigrationStatementList(81, 82, UmAppDatabase$Companion$MIGRATION_81_82$lambda);
    this.MIGRATION_82_83 = new DoorMigrationStatementList(82, 83, UmAppDatabase$Companion$MIGRATION_82_83$lambda);
    this.MIGRATION_83_84 = new DoorMigrationStatementList(83, 84, UmAppDatabase$Companion$MIGRATION_83_84$lambda);
    this.MIGRATION_84_85 = new DoorMigrationStatementList(84, 85, UmAppDatabase$Companion$MIGRATION_84_85$lambda);
    this.MIGRATION_85_86 = new DoorMigrationStatementList(85, 86, UmAppDatabase$Companion$MIGRATION_85_86$lambda);
    this.MIGRATION_86_87 = new DoorMigrationStatementList(86, 87, UmAppDatabase$Companion$MIGRATION_86_87$lambda);
    this.MIGRATION_87_88 = new DoorMigrationStatementList(87, 88, UmAppDatabase$Companion$MIGRATION_87_88$lambda);
    this.MIGRATION_88_89 = new DoorMigrationStatementList(88, 89, UmAppDatabase$Companion$MIGRATION_88_89$lambda);
    this.MIGRATION_89_90 = new DoorMigrationStatementList(89, 90, UmAppDatabase$Companion$MIGRATION_89_90$lambda);
    this.MIGRATION_90_91 = new DoorMigrationStatementList(90, 91, UmAppDatabase$Companion$MIGRATION_90_91$lambda);
    this.MIGRATION_92_93 = new DoorMigrationStatementList(92, 93, UmAppDatabase$Companion$MIGRATION_92_93$lambda);
    this.MIGRATION_93_94 = new DoorMigrationStatementList(93, 94, UmAppDatabase$Companion$MIGRATION_93_94$lambda);
    this.MIGRATION_94_95 = new DoorMigrationStatementList(94, 95, UmAppDatabase$Companion$MIGRATION_94_95$lambda);
    this.MIGRATION_95_96 = new DoorMigrationStatementList(95, 96, UmAppDatabase$Companion$MIGRATION_95_96$lambda);
    this.MIGRATION_96_97 = new DoorMigrationStatementList(96, 97, UmAppDatabase$Companion$MIGRATION_96_97$lambda);
    this.MIGRATION_97_98 = new DoorMigrationStatementList(97, 98, UmAppDatabase$Companion$MIGRATION_97_98$lambda);
    this.MIGRATION_98_99 = new DoorMigrationStatementList(98, 99, UmAppDatabase$Companion$MIGRATION_98_99$lambda);
    this.MIGRATION_99_100 = new DoorMigrationStatementList(99, 100, UmAppDatabase$Companion$MIGRATION_99_100$lambda);
    this.MIGRATION_100_101 = new DoorMigrationStatementList(100, 101, UmAppDatabase$Companion$MIGRATION_100_101$lambda);
    this.MIGRATION_101_102 = new DoorMigrationStatementList(101, 102, UmAppDatabase$Companion$MIGRATION_101_102$lambda);
    this.MIGRATION_102_103 = new DoorMigrationStatementList(102, 103, UmAppDatabase$Companion$MIGRATION_102_103$lambda);
    this.MIGRATION_103_104 = new DoorMigrationStatementList(103, 104, UmAppDatabase$Companion$MIGRATION_103_104$lambda);
    this.MIGRATION_104_105 = new DoorMigrationStatementList(104, 105, UmAppDatabase$Companion$MIGRATION_104_105$lambda);
    this.MIGRATION_105_106 = new DoorMigrationStatementList(105, 106, UmAppDatabase$Companion$MIGRATION_105_106$lambda);
  }
  UmAppDatabase$Companion.prototype.migrationList_s8cxhz$ = function (nodeId) {
    return listOf_0([this.MIGRATION_44_45, this.MIGRATION_45_46, this.MIGRATION_46_47, this.MIGRATION_47_48, this.MIGRATION_48_49, this.MIGRATION_49_50, this.MIGRATION_50_51, this.MIGRATION_51_52, this.MIGRATION_52_53, this.MIGRATION_53_54, this.MIGRATION_54_55, this.MIGRATION_55_56, this.MIGRATION_56_57, this.MIGRATION_57_58, this.MIGRATION_58_59, this.MIGRATION_59_60, this.MIGRATION_60_61, this.MIGRATION_61_62, this.MIGRATION_62_63, this.MIGRATION_63_64, this.MIGRATION_64_65, this.MIGRATION_65_66, this.MIGRATION_66_67, this.migrate67to68_8e33dg$(nodeId), this.MIGRATION_68_69, this.MIGRATION_69_70_8be2vx$, this.MIGRATION_70_71_8be2vx$, this.MIGRATION_71_72, this.MIGRATION_72_73, this.MIGRATION_73_74, this.MIGRATION_74_75, this.MIGRATION_75_76, this.MIGRATION_76_77, this.MIGRATION_77_78, this.MIGRATION_78_79, this.MIGRATION_78_79, this.MIGRATION_79_80, this.MIGRATION_80_81, this.MIGRATION_81_82, this.MIGRATION_82_83, this.MIGRATION_83_84, this.MIGRATION_84_85, this.MIGRATION_85_86, this.MIGRATION_86_87, this.MIGRATION_87_88, this.MIGRATION_88_89, this.MIGRATION_89_90, this.MIGRATION_90_91, UmAppDatabaseReplicationMigration91_92, this.MIGRATION_92_93, this.MIGRATION_93_94, this.MIGRATION_94_95, this.MIGRATION_95_96, this.MIGRATION_96_97, this.MIGRATION_97_98, this.MIGRATION_98_99, this.MIGRATION_99_100, this.MIGRATION_100_101, this.MIGRATION_101_102, this.MIGRATION_102_103, this.MIGRATION_103_104, this.MIGRATION_104_105, this.MIGRATION_105_106]);
  };
  function UmAppDatabase$Companion$migrate67to68$lambda(closure$nodeId) {
    return function (database) {
      if (dbType(database) === 1) {
        database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS DoorNode (  auth  TEXT , nodeId  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      } else {
        database.execSQL_61zpoe$('ALTER TABLE SyncNode ALTER COLUMN nodeClientId TYPE BIGINT');
        database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS DoorNode (  auth  TEXT , nodeId  SERIAL  PRIMARY KEY  NOT NULL )');
      }
      database.execSQL_61zpoe$(trimIndent('\n' + '                UPDATE SyncNode' + '\n' + '                   SET nodeClientId = ' + closure$nodeId.toString() + '\n' + '            '));
      return Unit;
    };
  }
  UmAppDatabase$Companion.prototype.migrate67to68_8e33dg$ = function (nodeId) {
    return new DoorMigrationSync(67, 68, UmAppDatabase$Companion$migrate67to68$lambda(nodeId));
  };
  function UmAppDatabase$Companion$MIGRATION_44_45$lambda(database) {
    database.execSQL_61zpoe$('DROP TABLE ContainerUploadJob');
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ContainerImportJob (`cijUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cijContainerUid` INTEGER NOT NULL, `cijFilePath` TEXT, `cijContainerBaseDir` TEXT, `cijContentEntryUid` INTEGER NOT NULL, `cijMimeType` TEXT, `cijSessionId` TEXT, `cijJobStatus` INTEGER NOT NULL, `cijBytesSoFar` INTEGER NOT NULL, `cijImportCompleted` INTEGER NOT NULL, `cijContentLength` INTEGER NOT NULL, `cijContainerEntryFileUids` TEXT, `cijConversionParams` TEXT)');
    } else if (dbType(database) === 2) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ContainerImportJob (  cijContainerUid  BIGINT , cijFilePath  TEXT , cijContainerBaseDir  TEXT , cijContentEntryUid  BIGINT , cijMimeType  TEXT , cijSessionId  TEXT , cijJobStatus  INTEGER , cijBytesSoFar  BIGINT , cijImportCompleted  BOOL , cijContentLength  BIGINT , cijContainerEntryFileUids  TEXT , cijConversionParams  TEXT , cijUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_45_46$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$(trimIndent('\n                    Update ClazzWorkQuestionResponse\n                    SET clazzWorkQuestionResponseLCB = (SELECT nodeClientId from SyncNode)\n                    WHERE\n                    clazzWorkQuestionResponseLCB = 0\n                '));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_46_47$lambda(database) {
    database.execSQL_61zpoe$('CREATE INDEX index_ClazzMember_clazzMemberPersonUid_clazzMemberClazzUid ON ClazzMember (clazzMemberPersonUid, clazzMemberClazzUid)');
    database.execSQL_61zpoe$('CREATE INDEX index_ClazzMember_clazzMemberClazzUid_clazzMemberPersonUid ON ClazzMember (clazzMemberClazzUid, clazzMemberPersonUid)');
    database.execSQL_61zpoe$('CREATE INDEX index_EntityRole_erGroupUid_erRoleUid_erTableId ON EntityRole (erGroupUid, erRoleUid, erTableId)');
    database.execSQL_61zpoe$('CREATE INDEX index_Role_rolePermissions ON Role(rolePermissions)');
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$("\n                    INSERT INTO PersonGroup(groupName, groupActive, personGroupFlag, groupMasterCsn, groupLocalCsn, groupLastChangedBy) \n                    SELECT 'PGA' || person.personUid AS groupName, \n                    true as groupActive,\n                    1 as personGroupFlag,\n                    0 as groupMasterCsn,\n                    0 as groupLocalCsn,\n                    0 as groupLastChangedBy\n                    FROM person\n                    where admin = true\n                    AND personGroupUid = 0");
      database.execSQL_61zpoe$("\n                    UPDATE Person SET\n                    personGroupUid = (SELECT groupUid FROM PersonGroup WHERE groupName = ('PGA' || Person.personUid) LIMIT 1)\n                    WHERE\n                    admin = true AND personGroupUid = 0\n                ");
      database.execSQL_61zpoe$('\n                    INSERT INTO PersonGroupMember(groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy)\n                    SELECT Person.personUid AS groupMemberPersonUid,\n                    Person.personGroupUid AS groupMemberGroupUid,\n                    0 AS groupMemberMasterCsn,\n                    0 AS groupMemberLocalCsn,\n                    0 AS groupMemberLastChangedBy\n                    FROM Person\n                    WHERE admin = true\n                    AND (SELECT COUNT(*) FROM PersonGroupMember WHERE PersonGroupmember.groupMemberGroupUid = Person.personGroupUid) = 0\n                ');
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_47_48$lambda(database) {
    database.execSQL_61zpoe$('CREATE INDEX ' + 'index_ClazzMember_clazzMemberClazzUid_clazzMemberRole ' + 'ON ClazzMember (clazzMemberClazzUid, clazzMemberRole)');
    database.execSQL_61zpoe$('CREATE INDEX ' + 'index_SchoolMember_schoolMemberSchoolUid_schoolMemberActive_schoolMemberRole ' + 'ON SchoolMember (schoolMemberSchoolUid, schoolMemberActive, schoolMemberRole)');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_48_49$lambda(database) {
    database.execSQL_61zpoe$(trimMargin('ALTER TABLE ScrapeRun ADD COLUMN conversionParams TEXT'));
    database.execSQL_61zpoe$(trimMargin('\n              |CREATE \n              | INDEX index_ScrapeQueueItem_status_itemType \n              |ON ScrapeQueueItem (status, itemType)\n              '));
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('ALTER TABLE ScrapeRun RENAME to ScrapeRun_OLD');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ScrapeRun (  scrapeType  TEXT , scrapeRunStatus  INTEGER  NOT NULL , conversionParams  TEXT , scrapeRunUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('INSERT INTO ScrapeRun (scrapeRunUid, scrapeType, scrapeRunStatus, conversionParams) SELECT scrapeRunUid, scrapeType, status, conversionParams FROM ScrapeRun_OLD');
      database.execSQL_61zpoe$('DROP TABLE ScrapeRun_OLD');
    } else if (dbType(database) === 2) {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ScrapeRun RENAME COLUMN status to scrapeRunStatus\n                    '));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_49_50$lambda(database) {
    database.execSQL_61zpoe$('DROP TABLE TimeZoneEntity');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_50_51$lambda(database) {
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS SqliteSyncablePk');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_51_52$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('UPDATE Clazz SET clazzEndTime = ' + systemTimeInMillis().toString() + ',' + 'clazzLastChangedBy = (SELECT nodeClientId FROM SyncNode LIMIT 1) ' + 'WHERE clazzEndTime = 0');
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_52_53$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS WorkspaceTerms (  termsHtml  TEXT , wtLang  TEXT , wtLastChangedBy  INTEGER  NOT NULL , wtPrimaryCsn  BIGINT  NOT NULL , wtLocalCsn  BIGINT  NOT NULL , wtUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS WorkspaceTerms_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS WorkspaceTerms_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n                  |CREATE OR REPLACE FUNCTION \n                  | inccsn_272_fn() RETURNS trigger AS $$\n                  | BEGIN  \n                  | UPDATE WorkspaceTerms SET wtLocalCsn =\n                  | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.wtLocalCsn \n                  | ELSE NEXTVAL('WorkspaceTerms_lcsn_seq') END),\n                  | wtPrimaryCsn = \n                  | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n                  | THEN NEXTVAL('WorkspaceTerms_mcsn_seq') \n                  | ELSE NEW.wtPrimaryCsn END)\n                  | WHERE wtUid = NEW.wtUid;\n                  | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  | SELECT 272, NEW.wtUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n                  | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n                  | RETURN null;\n                  | END $$\n                  | LANGUAGE plpgsql\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER inccsn_272_trig \n                  |AFTER UPDATE OR INSERT ON WorkspaceTerms \n                  |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n                  |EXECUTE PROCEDURE inccsn_272_fn()\n                  '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS WorkspaceTerms_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  | INDEX index_WorkspaceTerms_trk_clientId_epk_csn \n                  |ON WorkspaceTerms_trk (clientId, epk, csn)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  |UNIQUE INDEX index_WorkspaceTerms_trk_epk_clientId \n                  |ON WorkspaceTerms_trk (epk, clientId)\n                  '));
    } else {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS WorkspaceTerms (  termsHtml  TEXT , wtLang  TEXT , wtLastChangedBy  INTEGER  NOT NULL , wtPrimaryCsn  INTEGER  NOT NULL , wtLocalCsn  INTEGER  NOT NULL , wtUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER INS_LOC_272\n                  |AFTER INSERT ON WorkspaceTerms\n                  |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                  |    NEW.wtLocalCsn = 0)\n                  |BEGIN\n                  |    UPDATE WorkspaceTerms\n                  |    SET wtPrimaryCsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 272)\n                  |    WHERE wtUid = NEW.wtUid;\n                  |    \n                  |    UPDATE SqliteChangeSeqNums\n                  |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |    WHERE sCsnTableId = 272;\n                  |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                  |            CREATE TRIGGER INS_PRI_272\n                  |            AFTER INSERT ON WorkspaceTerms\n                  |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                  |                NEW.wtPrimaryCsn = 0)\n                  |            BEGIN\n                  |                UPDATE WorkspaceTerms\n                  |                SET wtPrimaryCsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 272)\n                  |                WHERE wtUid = NEW.wtUid;\n                  |                \n                  |                UPDATE SqliteChangeSeqNums\n                  |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |                WHERE sCsnTableId = 272;\n                  |                \n                  |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  |SELECT 272, NEW.wtUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                  |            END\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER UPD_LOC_272\n                  |AFTER UPDATE ON WorkspaceTerms\n                  |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                  |    AND (NEW.wtLocalCsn == OLD.wtLocalCsn OR\n                  |        NEW.wtLocalCsn == 0))\n                  |BEGIN\n                  |    UPDATE WorkspaceTerms\n                  |    SET wtLocalCsn = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 272) \n                  |    WHERE wtUid = NEW.wtUid;\n                  |    \n                  |    UPDATE SqliteChangeSeqNums \n                  |    SET sCsnNextLocal = sCsnNextLocal + 1\n                  |    WHERE sCsnTableId = 272;\n                  |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                  |            CREATE TRIGGER UPD_PRI_272\n                  |            AFTER UPDATE ON WorkspaceTerms\n                  |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                  |                AND (NEW.wtPrimaryCsn == OLD.wtPrimaryCsn OR\n                  |                    NEW.wtPrimaryCsn == 0))\n                  |            BEGIN\n                  |                UPDATE WorkspaceTerms\n                  |                SET wtPrimaryCsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 272)\n                  |                WHERE wtUid = NEW.wtUid;\n                  |                \n                  |                UPDATE SqliteChangeSeqNums\n                  |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |                WHERE sCsnTableId = 272;\n                  |                \n                  |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  |SELECT 272, NEW.wtUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                  |            END\n                  "));
      database.execSQL_61zpoe$('REPLACE INTO SqliteChangeSeqNums(sCsnTableId, sCsnNextLocal, sCsnNextPrimary) VALUES(272, 1, 1)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS WorkspaceTerms_trk (  epk  INTEGER NOT NULL , clientId  INTEGER NOT NULL, csn  INTEGER NOT NULL, rx  INTEGER NOT NULL , reqId  INTEGER NOT NULL, ts  INTEGER NOT NULL, pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  | INDEX index_WorkspaceTerms_trk_clientId_epk_csn \n                  |ON WorkspaceTerms_trk (clientId, epk, csn)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  |UNIQUE INDEX index_WorkspaceTerms_trk_epk_clientId \n                  |ON WorkspaceTerms_trk (epk, clientId)\n                  '));
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_53_54$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE Language ADD COLUMN Language_Type TEXT');
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS Site_trk (  epk  BIGINT NOT NULL, clientId  INTEGER NOT NULL, csn  INTEGER NOT NULL, rx  BOOL NOT NULL, reqId  INTEGER NOT NULL, ts  BIGINT NOT NULL, pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  | INDEX index_Site_trk_clientId_epk_csn \n                  |ON Site_trk (clientId, epk, csn)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  |UNIQUE INDEX index_Site_trk_epk_clientId \n                  |ON Site_trk (epk, clientId)\n                  '));
      database.execSQL_61zpoe$('ALTER TABLE WorkSpace RENAME TO Site');
      database.execSQL_61zpoe$('ALTER SEQUENCE workspace_uid_seq RENAME TO site_siteuid_seq');
      database.execSQL_61zpoe$('ALTER TABLE Site RENAME COLUMN uid TO siteUid');
      database.execSQL_61zpoe$('ALTER TABLE Site ADD COLUMN sitePcsn BIGINT DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$('ALTER TABLE Site ADD COLUMN siteLcsn BIGINT DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$('ALTER TABLE Site ADD COLUMN siteLcb INTEGER DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$('ALTER TABLE Site RENAME COLUMN name to siteName');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS Site_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS Site_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n                  |CREATE OR REPLACE FUNCTION \n                  | inccsn_189_fn() RETURNS trigger AS $$\n                  | BEGIN  \n                  | UPDATE Site SET siteLcsn =\n                  | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.siteLcsn \n                  | ELSE NEXTVAL('Site_lcsn_seq') END),\n                  | sitePcsn = \n                  | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n                  | THEN NEXTVAL('Site_mcsn_seq') \n                  | ELSE NEW.sitePcsn END)\n                  | WHERE siteUid = NEW.siteUid;\n                  | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  | SELECT 189, NEW.siteUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n                  | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n                  | RETURN null;\n                  | END $$\n                  | LANGUAGE plpgsql\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER inccsn_189_trig \n                  |AFTER UPDATE OR INSERT ON Site \n                  |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n                  |EXECUTE PROCEDURE inccsn_189_fn()\n                  '));
      database.execSQL_61zpoe$('DROP TABLE WorkspaceTerms');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS SiteTerms (  termsHtml  TEXT , sTermsLang  TEXT , sTermsLangUid  BIGINT  NOT NULL , sTermsActive  BOOL  NOT NULL , sTermsLastChangedBy  INTEGER  NOT NULL , sTermsPrimaryCsn  BIGINT  NOT NULL , sTermsLocalCsn  BIGINT  NOT NULL , sTermsUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS SiteTerms_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS SiteTerms_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n                  |CREATE OR REPLACE FUNCTION \n                  | inccsn_272_fn() RETURNS trigger AS $$\n                  | BEGIN  \n                  | UPDATE SiteTerms SET sTermsLocalCsn =\n                  | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.sTermsLocalCsn \n                  | ELSE NEXTVAL('SiteTerms_lcsn_seq') END),\n                  | sTermsPrimaryCsn = \n                  | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n                  | THEN NEXTVAL('SiteTerms_mcsn_seq') \n                  | ELSE NEW.sTermsPrimaryCsn END)\n                  | WHERE sTermsUid = NEW.sTermsUid;\n                  | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  | SELECT 272, NEW.sTermsUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n                  | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n                  | RETURN null;\n                  | END $$\n                  | LANGUAGE plpgsql\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER inccsn_272_trig \n                  |AFTER UPDATE OR INSERT ON SiteTerms \n                  |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n                  |EXECUTE PROCEDURE inccsn_272_fn()\n                  '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS SiteTerms_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  | INDEX index_SiteTerms_trk_clientId_epk_csn \n                  |ON SiteTerms_trk (clientId, epk, csn)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  |UNIQUE INDEX index_SiteTerms_trk_epk_clientId \n                  |ON SiteTerms_trk (epk, clientId)\n                  '));
    } else {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS Site (  sitePcsn  INTEGER  NOT NULL , siteLcsn  INTEGER  NOT NULL , siteLcb  INTEGER  NOT NULL , siteName  TEXT , guestLogin  INTEGER  NOT NULL , registrationAllowed  INTEGER  NOT NULL , siteUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('\n                    INSERT INTO Site (siteUid, sitePcsn, siteLcsn, siteLcb, siteName, guestLogin, registrationAllowed) \n                    SELECT uid AS siteUid, 0 AS sitePcsn, 0 AS siteLcsn, 0 AS siteLcb, name AS siteName, guestLogin, registrationAllowed \n                    FROM WorkSpace');
      database.execSQL_61zpoe$('DROP TABLE WorkSpace');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS Site_trk (  epk  INTEGER NOT NULL, clientId  INTEGER  NOT NULL, csn  INTEGER NOT NULL, rx  INTEGER NOT NULL, reqId  INTEGER NOT NULL, ts  INTEGER NOT NULL, pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  | INDEX index_Site_trk_clientId_epk_csn \n                  |ON Site_trk (clientId, epk, csn)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  |UNIQUE INDEX index_Site_trk_epk_clientId \n                  |ON Site_trk (epk, clientId)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER INS_LOC_189\n                  |AFTER INSERT ON Site\n                  |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                  |    NEW.siteLcsn = 0)\n                  |BEGIN\n                  |    UPDATE Site\n                  |    SET sitePcsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 189)\n                  |    WHERE siteUid = NEW.siteUid;\n                  |    \n                  |    UPDATE SqliteChangeSeqNums\n                  |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |    WHERE sCsnTableId = 189;\n                  |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                  |            CREATE TRIGGER INS_PRI_189\n                  |            AFTER INSERT ON Site\n                  |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                  |                NEW.sitePcsn = 0)\n                  |            BEGIN\n                  |                UPDATE Site\n                  |                SET sitePcsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 189)\n                  |                WHERE siteUid = NEW.siteUid;\n                  |                \n                  |                UPDATE SqliteChangeSeqNums\n                  |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |                WHERE sCsnTableId = 189;\n                  |                \n                  |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  |SELECT 189, NEW.siteUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                  |            END\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER UPD_LOC_189\n                  |AFTER UPDATE ON Site\n                  |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                  |    AND (NEW.siteLcsn == OLD.siteLcsn OR\n                  |        NEW.siteLcsn == 0))\n                  |BEGIN\n                  |    UPDATE Site\n                  |    SET siteLcsn = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 189) \n                  |    WHERE siteUid = NEW.siteUid;\n                  |    \n                  |    UPDATE SqliteChangeSeqNums \n                  |    SET sCsnNextLocal = sCsnNextLocal + 1\n                  |    WHERE sCsnTableId = 189;\n                  |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                  |            CREATE TRIGGER UPD_PRI_189\n                  |            AFTER UPDATE ON Site\n                  |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                  |                AND (NEW.sitePcsn == OLD.sitePcsn OR\n                  |                    NEW.sitePcsn == 0))\n                  |            BEGIN\n                  |                UPDATE Site\n                  |                SET sitePcsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 189)\n                  |                WHERE siteUid = NEW.siteUid;\n                  |                \n                  |                UPDATE SqliteChangeSeqNums\n                  |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |                WHERE sCsnTableId = 189;\n                  |                \n                  |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  |SELECT 189, NEW.siteUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                  |            END\n                  "));
      database.execSQL_61zpoe$('DROP TABLE WorkspaceTerms');
      database.execSQL_61zpoe$('DROP TABLE WorkspaceTerms_trk');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS SiteTerms (  termsHtml  TEXT , sTermsLang  TEXT , sTermsLangUid  INTEGER  NOT NULL , sTermsActive  INTEGER  NOT NULL , sTermsLastChangedBy  INTEGER  NOT NULL , sTermsPrimaryCsn  INTEGER  NOT NULL , sTermsLocalCsn  INTEGER  NOT NULL , sTermsUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER INS_LOC_272\n                  |AFTER INSERT ON SiteTerms\n                  |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                  |    NEW.sTermsLocalCsn = 0)\n                  |BEGIN\n                  |    UPDATE SiteTerms\n                  |    SET sTermsPrimaryCsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 272)\n                  |    WHERE sTermsUid = NEW.sTermsUid;\n                  |    \n                  |    UPDATE SqliteChangeSeqNums\n                  |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |    WHERE sCsnTableId = 272;\n                  |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                  |            CREATE TRIGGER INS_PRI_272\n                  |            AFTER INSERT ON SiteTerms\n                  |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                  |                NEW.sTermsPrimaryCsn = 0)\n                  |            BEGIN\n                  |                UPDATE SiteTerms\n                  |                SET sTermsPrimaryCsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 272)\n                  |                WHERE sTermsUid = NEW.sTermsUid;\n                  |                \n                  |                UPDATE SqliteChangeSeqNums\n                  |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |                WHERE sCsnTableId = 272;\n                  |                \n                  |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  |SELECT 272, NEW.sTermsUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                  |            END\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER UPD_LOC_272\n                  |AFTER UPDATE ON SiteTerms\n                  |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                  |    AND (NEW.sTermsLocalCsn == OLD.sTermsLocalCsn OR\n                  |        NEW.sTermsLocalCsn == 0))\n                  |BEGIN\n                  |    UPDATE SiteTerms\n                  |    SET sTermsLocalCsn = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 272) \n                  |    WHERE sTermsUid = NEW.sTermsUid;\n                  |    \n                  |    UPDATE SqliteChangeSeqNums \n                  |    SET sCsnNextLocal = sCsnNextLocal + 1\n                  |    WHERE sCsnTableId = 272;\n                  |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                  |            CREATE TRIGGER UPD_PRI_272\n                  |            AFTER UPDATE ON SiteTerms\n                  |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                  |                AND (NEW.sTermsPrimaryCsn == OLD.sTermsPrimaryCsn OR\n                  |                    NEW.sTermsPrimaryCsn == 0))\n                  |            BEGIN\n                  |                UPDATE SiteTerms\n                  |                SET sTermsPrimaryCsn = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 272)\n                  |                WHERE sTermsUid = NEW.sTermsUid;\n                  |                \n                  |                UPDATE SqliteChangeSeqNums\n                  |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                  |                WHERE sCsnTableId = 272;\n                  |                \n                  |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                  |SELECT 272, NEW.sTermsUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                  |            END\n                  "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS SiteTerms_trk (  epk  INTEGER NOT NULL , clientId  INTEGER NOT NULL, csn  INTEGER NOT NULL, rx  INTEGER NOT NULL, reqId  INTEGER NOT NULL, ts  INTEGER NOT NULL, pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  | INDEX index_SiteTerms_trk_clientId_epk_csn \n                  |ON SiteTerms_trk (clientId, epk, csn)\n                  '));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE \n                  |UNIQUE INDEX index_SiteTerms_trk_epk_clientId \n                  |ON SiteTerms_trk (epk, clientId)\n                  '));
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_54_55$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE PersonPicture ADD COLUMN personPictureUri TEXT');
    database.execSQL_61zpoe$('ALTER TABLE PersonPicture ADD COLUMN personPictureMd5 TEXT');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_55_56$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ZombieAttachmentData (  zaTableName  TEXT , zaPrimaryKey  INTEGER  NOT NULL , zaUri  TEXT , zaUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$("\n                    CREATE TRIGGER ATTUPD_PersonPicture\n                    AFTER UPDATE ON PersonPicture FOR EACH ROW WHEN\n                    OLD.personPictureMd5 IS NOT NULL AND (SELECT COUNT(*) FROM PersonPicture WHERE personPictureMd5 = OLD.personPictureMd5) = 0\n                    BEGIN\n                    INSERT INTO ZombieAttachmentData(zaTableName, zaPrimaryKey, zaUri) VALUES('PersonPicture', OLD.personPictureUid, OLD.personPictureUri);\n                    END");
    } else {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ZombieAttachmentData (  zaTableName  TEXT , zaPrimaryKey  BIGINT  NOT NULL , zaUri  TEXT , zaUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin("\n                  |CREATE OR REPLACE FUNCTION attach_PersonPicture_fn() RETURNS trigger AS $$\n                  |BEGIN\n                  |INSERT INTO ZombieAttachmentData(zaTableName, zaPrimaryKey, zaUri) \n                  |SELECT 'PersonPicture' AS zaTableName, OLD.personPictureUid AS zaPrimaryKey, OLD.personPictureUri AS zaUri\n                  |WHERE (SELECT COUNT(*) FROM PersonPicture WHERE personPictureMd5 = OLD.personPictureMd5) = 0;\n                  |RETURN null;\n                  |END $$\n                  |LANGUAGE plpgsql\n                  "));
      database.execSQL_61zpoe$(trimMargin('\n                  |CREATE TRIGGER attach_PersonPicture_trig\n                  |AFTER UPDATE ON PersonPicture\n                  |FOR EACH ROW WHEN (OLD.personPictureUri IS NOT NULL)\n                  |EXECUTE PROCEDURE attach_PersonPicture_fn();\n                  '));
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_56_57$lambda(database) {
    database.execSQL_61zpoe$(trimIndent("\n                UPDATE ContainerEntryFile SET \n                cefPath = REPLACE(cefPath, '/build/storage/singleton/container/', '/data/singleton/container/')\n                WHERE cefPath LIKE '%/build/storage/singleton/container/%'\n            "));
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_57_58$lambda(database) {
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ReportFilter');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ReportFilter_trk');
    database.execSQL_61zpoe$(trimMargin("UPDATE StatementEntity SET statementVerbUid = \n                10002 WHERE statementVerbUid IN (SELECT verbUid \n                FROM VerbEntity WHERE urlId = 'http://adlnet.gov/expapi/verbs/passed')"));
    database.execSQL_61zpoe$(trimMargin("UPDATE StatementEntity SET statementVerbUid = \n                10003 WHERE statementVerbUid IN (SELECT verbUid \n                FROM VerbEntity WHERE urlId = 'http://adlnet.gov/expapi/verbs/failed')"));
    database.execSQL_61zpoe$(trimMargin("UPDATE StatementEntity SET substatementVerbUid = \n                10002 WHERE substatementVerbUid IN (SELECT verbUid \n                FROM VerbEntity WHERE urlId = 'http://adlnet.gov/expapi/verbs/passed')"));
    database.execSQL_61zpoe$(trimMargin("UPDATE StatementEntity SET substatementVerbUid = \n                10003 WHERE substatementVerbUid IN (SELECT verbUid \n                FROM VerbEntity WHERE urlId = 'http://adlnet.gov/expapi/verbs/failed')"));
    database.execSQL_61zpoe$(trimMargin("UPDATE XLangMapEntry SET verbLangMapUid = \n                10002 WHERE verbLangMapUid IN (SELECT verbUid \n                FROM VerbEntity WHERE urlId = 'http://adlnet.gov/expapi/verbs/passed')"));
    database.execSQL_61zpoe$(trimMargin("UPDATE XLangMapEntry SET verbLangMapUid = \n                10003 WHERE verbLangMapUid IN (SELECT verbUid \n                FROM VerbEntity WHERE urlId = 'http://adlnet.gov/expapi/verbs/failed')"));
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS reportSeries TEXT'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS reportDescription TEXT'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS fromRelTo INTEGER'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS fromRelOffSet INTEGER'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS fromRelUnit INTEGER'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS toRelTo INTEGER'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS toRelOffSet INTEGER'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS toRelUnit INTEGER'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS priority INTEGER'));
      database.execSQL_61zpoe$('ALTER TABLE Report ADD COLUMN IF NOT EXISTS reportDateRangeSelection INTEGER');
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN IF NOT EXISTS isTemplate BOOL DEFAULT FALSE'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report \n                    DROP COLUMN IF EXISTS chartType'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report \n                    DROP COLUMN IF EXISTS yAxis'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report \n                    DROP COLUMN IF EXISTS subGroup'));
      database.execSQL_61zpoe$('ALTER TABLE StatementEntity ADD COLUMN IF NOT EXISTS contentEntryRoot BOOL DEFAULT FALSE');
      database.execSQL_61zpoe$(trimMargin('UPDATE StatementEntity SET contentEntryRoot = true \n                    WHERE statementUid IN (select statementUid from StatementEntity \n                    LEFT JOIN ContentEntry ON ContentEntry.contentEntryUid = StatementEntity.statementContentEntryUid \n                    LEFT JOIN XObjectEntity ON XObjectEntity.xObjectUid = StatementEntity.xObjectUid \n                    WHERE XObjectEntity.objectId = ContentEntry.entryId)'));
      database.execSQL_61zpoe$('ALTER TABLE VerbEntity ADD COLUMN IF NOT EXISTS verbInActive BOOL DEFAULT FALSE');
      database.execSQL_61zpoe$(trimMargin("UPDATE VerbEntity SET verbInActive = TRUE WHERE \n                    urlId = 'http://adlnet.gov/expapi/verbs/passed' AND verbUid != 10002"));
      database.execSQL_61zpoe$(trimMargin("UPDATE VerbEntity SET verbInActive = TRUE WHERE \n                    urlId = 'http://adlnet.gov/expapi/verbs/failed' AND verbUid != 10003"));
    } else if (dbType(database) === 1) {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN reportSeries TEXT'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report ADD COLUMN reportDescription TEXT'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE Report \n                    ADD COLUMN isTemplate INTEGER'));
      database.execSQL_61zpoe$('ALTER TABLE Report RENAME to Report_OLD');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS Report (`reportUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `reportOwnerUid` INTEGER NOT NULL, `xAxis` INTEGER NOT NULL, `reportDateRangeSelection` INTEGER NOT NULL, `fromDate` INTEGER NOT NULL, `fromRelTo` INTEGER NOT NULL, `fromRelOffSet` INTEGER NOT NULL, `fromRelUnit` INTEGER NOT NULL, `toDate` INTEGER NOT NULL, `toRelTo` INTEGER NOT NULL, `toRelOffSet` INTEGER NOT NULL, `toRelUnit` INTEGER NOT NULL, `reportTitle` TEXT, `reportDescription` TEXT, `reportSeries` TEXT, `reportInactive` INTEGER NOT NULL, `isTemplate` INTEGER NOT NULL, `priority` INTEGER NOT NULL, `reportMasterChangeSeqNum` INTEGER NOT NULL, `reportLocalChangeSeqNum` INTEGER NOT NULL, `reportLastChangedBy` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('INSERT INTO Report (reportUid, reportOwnerUid, xAxis, reportDateRangeSelection, fromDate, fromRelTo, fromRelOffSet, fromRelUnit, toDate, toRelTo, toRelOffSet, toRelUnit, reportTitle, reportDescription, reportSeries, reportInactive, isTemplate, priority, reportMasterChangeSeqNum, reportLocalChangeSeqNum, reportLastChangedBy) SELECT reportUid, reportOwnerUid, xAxis,0, fromDate, 0, 0, 0, 0, 0, 0, 0, reportTitle, reportDescription, reportSeries, reportInactive, isTemplate, 1, reportMasterChangeSeqNum, reportLocalChangeSeqNum, reportLastChangedBy FROM Report_OLD');
      database.execSQL_61zpoe$('DROP TABLE Report_OLD');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS Report_trk (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_Report_trk_clientId_epk_csn` ON Report_trk (`clientId`, `epk`, `csn`)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_XLangMapEntry_verbLangMapUid` ON XLangMapEntry (`verbLangMapUid`)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_StatementEntity_statementPersonUid` ON StatementEntity (`statementPersonUid`)');
      database.execSQL_61zpoe$('ALTER TABLE StatementEntity ADD COLUMN contentEntryRoot INTEGER DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$(trimMargin('UPDATE StatementEntity SET contentEntryRoot = 1 WHERE \n                    statementUid IN (select statementUid from StatementEntity LEFT JOIN \n                    ContentEntry ON ContentEntry.contentEntryUid = StatementEntity.statementContentEntryUid \n                    LEFT JOIN XObjectEntity ON XObjectEntity.xObjectUid = StatementEntity.xObjectUid \n                    WHERE XObjectEntity.objectId = ContentEntry.entryId)'));
      database.execSQL_61zpoe$('ALTER TABLE VerbEntity ADD COLUMN verbInActive INTEGER DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$(trimMargin("UPDATE VerbEntity SET verbInActive = 1 WHERE \n                    urlId = 'http://adlnet.gov/expapi/verbs/passed' AND verbUid != 10002"));
      database.execSQL_61zpoe$(trimMargin("UPDATE VerbEntity SET verbInActive = 1 WHERE \n                    urlId = 'http://adlnet.gov/expapi/verbs/failed' AND verbUid != 10003"));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_58_59$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzLogAttendanceRecord \n                    ADD COLUMN clazzLogAttendanceRecordPersonUid INTEGER DEFAULT 0 NOT NULL'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzLogAttendanceRecord \n                    RENAME to ClazzLogAttendanceRecord_OLD'));
      database.execSQL_61zpoe$(trimMargin('CREATE TABLE IF NOT EXISTS ClazzLogAttendanceRecord \n                    (  clazzLogAttendanceRecordClazzLogUid  INTEGER  NOT NULL , \n                    clazzLogAttendanceRecordPersonUid  INTEGER  NOT NULL , \n                    attendanceStatus  INTEGER  NOT NULL , \n                    clazzLogAttendanceRecordMasterChangeSeqNum  INTEGER  NOT NULL , \n                    clazzLogAttendanceRecordLocalChangeSeqNum  INTEGER  NOT NULL , \n                    clazzLogAttendanceRecordLastChangedBy  INTEGER  NOT NULL , \n                    clazzLogAttendanceRecordUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )'));
      database.execSQL_61zpoe$(trimMargin('INSERT INTO ClazzLogAttendanceRecord \n                    (clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, \n                    clazzLogAttendanceRecordPersonUid, attendanceStatus, \n                    clazzLogAttendanceRecordMasterChangeSeqNum, \n                    clazzLogAttendanceRecordLocalChangeSeqNum, \n                    clazzLogAttendanceRecordLastChangedBy) SELECT \n                    clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, \n                    clazzLogAttendanceRecordPersonUid, attendanceStatus, \n                    clazzLogAttendanceRecordMasterChangeSeqNum, \n                    clazzLogAttendanceRecordLocalChangeSeqNum, \n                    clazzLogAttendanceRecordLastChangedBy FROM ClazzLogAttendanceRecord_OLD'));
      database.execSQL_61zpoe$('DROP TABLE ClazzLogAttendanceRecord_OLD');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER INS_LOC_15\n                      |AFTER INSERT ON ClazzLogAttendanceRecord\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                      |    NEW.clazzLogAttendanceRecordLocalChangeSeqNum = 0)\n                      |BEGIN\n                      |    UPDATE ClazzLogAttendanceRecord\n                      |    SET clazzLogAttendanceRecordMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 15)\n                      |    WHERE clazzLogAttendanceRecordUid = NEW.clazzLogAttendanceRecordUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums\n                      |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |    WHERE sCsnTableId = 15;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER INS_PRI_15\n                      |            AFTER INSERT ON ClazzLogAttendanceRecord\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                      |                NEW.clazzLogAttendanceRecordMasterChangeSeqNum = 0)\n                      |            BEGIN\n                      |                UPDATE ClazzLogAttendanceRecord\n                      |                SET clazzLogAttendanceRecordMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 15)\n                      |                WHERE clazzLogAttendanceRecordUid = NEW.clazzLogAttendanceRecordUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 15;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 15, NEW.clazzLogAttendanceRecordUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER UPD_LOC_15\n                      |AFTER UPDATE ON ClazzLogAttendanceRecord\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                      |    AND (NEW.clazzLogAttendanceRecordLocalChangeSeqNum == OLD.clazzLogAttendanceRecordLocalChangeSeqNum OR\n                      |        NEW.clazzLogAttendanceRecordLocalChangeSeqNum == 0))\n                      |BEGIN\n                      |    UPDATE ClazzLogAttendanceRecord\n                      |    SET clazzLogAttendanceRecordLocalChangeSeqNum = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 15) \n                      |    WHERE clazzLogAttendanceRecordUid = NEW.clazzLogAttendanceRecordUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums \n                      |    SET sCsnNextLocal = sCsnNextLocal + 1\n                      |    WHERE sCsnTableId = 15;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER UPD_PRI_15\n                      |            AFTER UPDATE ON ClazzLogAttendanceRecord\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                      |                AND (NEW.clazzLogAttendanceRecordMasterChangeSeqNum == OLD.clazzLogAttendanceRecordMasterChangeSeqNum OR\n                      |                    NEW.clazzLogAttendanceRecordMasterChangeSeqNum == 0))\n                      |            BEGIN\n                      |                UPDATE ClazzLogAttendanceRecord\n                      |                SET clazzLogAttendanceRecordMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 15)\n                      |                WHERE clazzLogAttendanceRecordUid = NEW.clazzLogAttendanceRecordUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 15;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 15, NEW.clazzLogAttendanceRecordUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzLogAttendanceRecord_trk (  epk  INTEGER , clientId  INTEGER , csn  INTEGER , rx  INTEGER , reqId  INTEGER , ts  INTEGER , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('ALTER TABLE ClazzWorkSubmission RENAME to ClazzWorkSubmission_OLD');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzWorkSubmission (  clazzWorkSubmissionClazzWorkUid  INTEGER  NOT NULL , clazzWorkSubmissionMarkerPersonUid  INTEGER  NOT NULL , clazzWorkSubmissionPersonUid  INTEGER  NOT NULL , clazzWorkSubmissionInactive  INTEGER  NOT NULL , clazzWorkSubmissionDateTimeStarted  INTEGER  NOT NULL , clazzWorkSubmissionDateTimeUpdated  INTEGER  NOT NULL , clazzWorkSubmissionDateTimeFinished  INTEGER  NOT NULL , clazzWorkSubmissionDateTimeMarked  INTEGER  NOT NULL , clazzWorkSubmissionText  TEXT , clazzWorkSubmissionScore  INTEGER  NOT NULL , clazzWorkSubmissionMCSN  INTEGER  NOT NULL , clazzWorkSubmissionLCSN  INTEGER  NOT NULL , clazzWorkSubmissionLCB  INTEGER  NOT NULL , clazzWorkSubmissionUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('INSERT INTO ClazzWorkSubmission (clazzWorkSubmissionUid, clazzWorkSubmissionClazzWorkUid, clazzWorkSubmissionMarkerPersonUid, clazzWorkSubmissionPersonUid, clazzWorkSubmissionInactive, clazzWorkSubmissionDateTimeStarted, clazzWorkSubmissionDateTimeUpdated, clazzWorkSubmissionDateTimeFinished, clazzWorkSubmissionDateTimeMarked, clazzWorkSubmissionText, clazzWorkSubmissionScore, clazzWorkSubmissionMCSN, clazzWorkSubmissionLCSN, clazzWorkSubmissionLCB) SELECT clazzWorkSubmissionUid, clazzWorkSubmissionClazzWorkUid, clazzWorkSubmissionMarkerPersonUid, clazzWorkSubmissionPersonUid, clazzWorkSubmissionInactive, clazzWorkSubmissionDateTimeStarted, clazzWorkSubmissionDateTimeUpdated, clazzWorkSubmissionDateTimeFinished, clazzWorkSubmissionDateTimeMarked, clazzWorkSubmissionText, clazzWorkSubmissionScore, clazzWorkSubmissionMCSN, clazzWorkSubmissionLCSN, clazzWorkSubmissionLCB FROM ClazzWorkSubmission_OLD');
      database.execSQL_61zpoe$('DROP TABLE ClazzWorkSubmission_OLD');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER INS_LOC_206\n                      |AFTER INSERT ON ClazzWorkSubmission\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                      |    NEW.clazzWorkSubmissionLCSN = 0)\n                      |BEGIN\n                      |    UPDATE ClazzWorkSubmission\n                      |    SET clazzWorkSubmissionMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 206)\n                      |    WHERE clazzWorkSubmissionUid = NEW.clazzWorkSubmissionUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums\n                      |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |    WHERE sCsnTableId = 206;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER INS_PRI_206\n                      |            AFTER INSERT ON ClazzWorkSubmission\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                      |                NEW.clazzWorkSubmissionMCSN = 0)\n                      |            BEGIN\n                      |                UPDATE ClazzWorkSubmission\n                      |                SET clazzWorkSubmissionMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 206)\n                      |                WHERE clazzWorkSubmissionUid = NEW.clazzWorkSubmissionUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 206;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 206, NEW.clazzWorkSubmissionUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER UPD_LOC_206\n                      |AFTER UPDATE ON ClazzWorkSubmission\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                      |    AND (NEW.clazzWorkSubmissionLCSN == OLD.clazzWorkSubmissionLCSN OR\n                      |        NEW.clazzWorkSubmissionLCSN == 0))\n                      |BEGIN\n                      |    UPDATE ClazzWorkSubmission\n                      |    SET clazzWorkSubmissionLCSN = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 206) \n                      |    WHERE clazzWorkSubmissionUid = NEW.clazzWorkSubmissionUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums \n                      |    SET sCsnNextLocal = sCsnNextLocal + 1\n                      |    WHERE sCsnTableId = 206;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER UPD_PRI_206\n                      |            AFTER UPDATE ON ClazzWorkSubmission\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                      |                AND (NEW.clazzWorkSubmissionMCSN == OLD.clazzWorkSubmissionMCSN OR\n                      |                    NEW.clazzWorkSubmissionMCSN == 0))\n                      |            BEGIN\n                      |                UPDATE ClazzWorkSubmission\n                      |                SET clazzWorkSubmissionMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 206)\n                      |                WHERE clazzWorkSubmissionUid = NEW.clazzWorkSubmissionUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 206;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 206, NEW.clazzWorkSubmissionUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzWorkSubmission_trk (  epk  INTEGER , clientId  INTEGER , csn  INTEGER , rx  INTEGER , reqId  INTEGER , ts  INTEGER , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('ALTER TABLE ClazzWorkQuestionResponse RENAME to ClazzWorkQuestionResponse_OLD');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzWorkQuestionResponse (  clazzWorkQuestionResponseClazzWorkUid  INTEGER  NOT NULL , clazzWorkQuestionResponseQuestionUid  INTEGER  NOT NULL , clazzWorkQuestionResponseText  TEXT , clazzWorkQuestionResponseOptionSelected  INTEGER  NOT NULL , clazzWorkQuestionResponsePersonUid  INTEGER  NOT NULL , clazzWorkQuestionResponseInactive  INTEGER  NOT NULL , clazzWorkQuestionResponseDateResponded  INTEGER  NOT NULL , clazzWorkQuestionResponseMCSN  INTEGER  NOT NULL , clazzWorkQuestionResponseLCSN  INTEGER  NOT NULL , clazzWorkQuestionResponseLCB  INTEGER  NOT NULL , clazzWorkQuestionResponseUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('INSERT INTO ClazzWorkQuestionResponse (clazzWorkQuestionResponseUid, clazzWorkQuestionResponseClazzWorkUid, clazzWorkQuestionResponseQuestionUid, clazzWorkQuestionResponseText, clazzWorkQuestionResponseOptionSelected, clazzWorkQuestionResponsePersonUid, clazzWorkQuestionResponseInactive, clazzWorkQuestionResponseDateResponded, clazzWorkQuestionResponseMCSN, clazzWorkQuestionResponseLCSN, clazzWorkQuestionResponseLCB) SELECT clazzWorkQuestionResponseUid, clazzWorkQuestionResponseClazzWorkUid, clazzWorkQuestionResponseQuestionUid, clazzWorkQuestionResponseText, clazzWorkQuestionResponseOptionSelected, clazzWorkQuestionResponsePersonUid, clazzWorkQuestionResponseInactive, clazzWorkQuestionResponseDateResponded, clazzWorkQuestionResponseMCSN, clazzWorkQuestionResponseLCSN, clazzWorkQuestionResponseLCB FROM ClazzWorkQuestionResponse_OLD');
      database.execSQL_61zpoe$('DROP TABLE ClazzWorkQuestionResponse_OLD');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER INS_LOC_209\n                      |AFTER INSERT ON ClazzWorkQuestionResponse\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                      |    NEW.clazzWorkQuestionResponseLCSN = 0)\n                      |BEGIN\n                      |    UPDATE ClazzWorkQuestionResponse\n                      |    SET clazzWorkQuestionResponseMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 209)\n                      |    WHERE clazzWorkQuestionResponseUid = NEW.clazzWorkQuestionResponseUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums\n                      |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |    WHERE sCsnTableId = 209;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER INS_PRI_209\n                      |            AFTER INSERT ON ClazzWorkQuestionResponse\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                      |                NEW.clazzWorkQuestionResponseMCSN = 0)\n                      |            BEGIN\n                      |                UPDATE ClazzWorkQuestionResponse\n                      |                SET clazzWorkQuestionResponseMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 209)\n                      |                WHERE clazzWorkQuestionResponseUid = NEW.clazzWorkQuestionResponseUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 209;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 209, NEW.clazzWorkQuestionResponseUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER UPD_LOC_209\n                      |AFTER UPDATE ON ClazzWorkQuestionResponse\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                      |    AND (NEW.clazzWorkQuestionResponseLCSN == OLD.clazzWorkQuestionResponseLCSN OR\n                      |        NEW.clazzWorkQuestionResponseLCSN == 0))\n                      |BEGIN\n                      |    UPDATE ClazzWorkQuestionResponse\n                      |    SET clazzWorkQuestionResponseLCSN = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 209) \n                      |    WHERE clazzWorkQuestionResponseUid = NEW.clazzWorkQuestionResponseUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums \n                      |    SET sCsnNextLocal = sCsnNextLocal + 1\n                      |    WHERE sCsnTableId = 209;\n                      |END\n                  '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER UPD_PRI_209\n                      |            AFTER UPDATE ON ClazzWorkQuestionResponse\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                      |                AND (NEW.clazzWorkQuestionResponseMCSN == OLD.clazzWorkQuestionResponseMCSN OR\n                      |                    NEW.clazzWorkQuestionResponseMCSN == 0))\n                      |            BEGIN\n                      |                UPDATE ClazzWorkQuestionResponse\n                      |                SET clazzWorkQuestionResponseMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 209)\n                      |                WHERE clazzWorkQuestionResponseUid = NEW.clazzWorkQuestionResponseUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 209;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 209, NEW.clazzWorkQuestionResponseUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzWorkQuestionResponse_trk (  epk  INTEGER , clientId  INTEGER , csn  INTEGER , rx  INTEGER , reqId  INTEGER , ts  INTEGER , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzEnrolment (`clazzEnrolmentUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `clazzEnrolmentPersonUid` INTEGER NOT NULL, `clazzEnrolmentClazzUid` INTEGER NOT NULL, `clazzEnrolmentDateJoined` INTEGER NOT NULL, `clazzEnrolmentDateLeft` INTEGER NOT NULL, `clazzEnrolmentRole` INTEGER NOT NULL, `clazzEnrolmentAttendancePercentage` REAL NOT NULL, `clazzEnrolmentActive` INTEGER NOT NULL, `clazzEnrolmentLocalChangeSeqNum` INTEGER NOT NULL, `clazzEnrolmentMasterChangeSeqNum` INTEGER NOT NULL, `clazzEnrolmentLastChangedBy` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzEnrolment_clazzEnrolmentPersonUid_clazzEnrolmentClazzUid ON ClazzEnrolment (clazzEnrolmentPersonUid, clazzEnrolmentClazzUid)');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentPersonUid ON ClazzEnrolment (clazzEnrolmentClazzUid, clazzEnrolmentPersonUid)');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentRole ON ClazzEnrolment (clazzEnrolmentClazzUid, clazzEnrolmentRole)');
      database.execSQL_61zpoe$('INSERT INTO ClazzEnrolment (clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy) SELECT clazzMemberUid, clazzMemberPersonUid, clazzMemberClazzUid, clazzMemberDateJoined, clazzMemberDateLeft, clazzMemberRole, clazzMemberAttendancePercentage, clazzMemberActive,clazzMemberLocalChangeSeqNum, clazzMemberMasterChangeSeqNum, clazzMemberLastChangedBy FROM ClazzMember');
      database.execSQL_61zpoe$('DROP TABLE ClazzMember');
      database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzMember_trk');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER INS_LOC_65\n                      |AFTER INSERT ON ClazzEnrolment\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                      |    NEW.clazzEnrolmentLocalChangeSeqNum = 0)\n                      |BEGIN\n                      |    UPDATE ClazzEnrolment\n                      |    SET clazzEnrolmentMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 65)\n                      |    WHERE clazzEnrolmentUid = NEW.clazzEnrolmentUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums\n                      |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |    WHERE sCsnTableId = 65;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER INS_PRI_65\n                      |            AFTER INSERT ON ClazzEnrolment\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                      |                NEW.clazzEnrolmentMasterChangeSeqNum = 0)\n                      |            BEGIN\n                      |                UPDATE ClazzEnrolment\n                      |                SET clazzEnrolmentMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 65)\n                      |                WHERE clazzEnrolmentUid = NEW.clazzEnrolmentUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 65;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 65, NEW.clazzEnrolmentUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER UPD_LOC_65\n                      |AFTER UPDATE ON ClazzEnrolment\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                      |    AND (NEW.clazzEnrolmentLocalChangeSeqNum == OLD.clazzEnrolmentLocalChangeSeqNum OR\n                      |        NEW.clazzEnrolmentLocalChangeSeqNum == 0))\n                      |BEGIN\n                      |    UPDATE ClazzEnrolment\n                      |    SET clazzEnrolmentLocalChangeSeqNum = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 65) \n                      |    WHERE clazzEnrolmentUid = NEW.clazzEnrolmentUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums \n                      |    SET sCsnNextLocal = sCsnNextLocal + 1\n                      |    WHERE sCsnTableId = 65;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER UPD_PRI_65\n                      |            AFTER UPDATE ON ClazzEnrolment\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                      |                AND (NEW.clazzEnrolmentMasterChangeSeqNum == OLD.clazzEnrolmentMasterChangeSeqNum OR\n                      |                    NEW.clazzEnrolmentMasterChangeSeqNum == 0))\n                      |            BEGIN\n                      |                UPDATE ClazzEnrolment\n                      |                SET clazzEnrolmentMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 65)\n                      |                WHERE clazzEnrolmentUid = NEW.clazzEnrolmentUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 65;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 65, NEW.clazzEnrolmentUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzEnrolment_trk (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE \n                      | INDEX index_ClazzEnrolment_trk_clientId_epk_csn \n                      |ON ClazzEnrolment_trk (clientId, epk, csn)\n                      '));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE \n                      |UNIQUE INDEX index_ClazzEnrolment_trk_epk_clientId \n                      |ON ClazzEnrolment_trk (epk, clientId)\n                      '));
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentPersonUid` ON ClazzEnrolment (`clazzEnrolmentPersonUid`)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentClazzUid` ON ClazzEnrolment (`clazzEnrolmentClazzUid`)');
    } else if (dbType(database) === 2) {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzLogAttendanceRecord \n                    ADD COLUMN clazzLogAttendanceRecordPersonUid BIGINT DEFAULT 0 NOT NULL'));
      database.execSQL_61zpoe$(trimMargin('UPDATE ClazzLogAttendanceRecord SET \n                    clazzLogAttendanceRecordPersonUid = (SELECT clazzMemberPersonUid \n                    FROM ClazzMember LEFT JOIN ClazzLogAttendanceRecord ON \n                    ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzMemberUid = \n                    ClazzMember.clazzMemberUid WHERE ClazzMember.clazzMemberUid = \n                    ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzMemberUid LIMIT 1)'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzLogAttendanceRecord \n                    DROP COLUMN IF EXISTS clazzLogAttendanceRecordClazzMemberUid'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzWorkSubmission \n                    DROP COLUMN IF EXISTS clazzWorkSubmissionClazzMemberUid'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzWorkSubmission \n                    DROP COLUMN IF EXISTS clazzWorkSubmissionMarkerClazzMemberUid'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzWorkQuestionResponse \n                    DROP COLUMN IF EXISTS clazzWorkQuestionResponseClazzMemberUid'));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzEnrolment (  clazzEnrolmentPersonUid  BIGINT  NOT NULL , clazzEnrolmentClazzUid  BIGINT  NOT NULL , clazzEnrolmentDateJoined  BIGINT  NOT NULL , clazzEnrolmentDateLeft  BIGINT  NOT NULL , clazzEnrolmentRole  INTEGER  NOT NULL , clazzEnrolmentAttendancePercentage  FLOAT  NOT NULL , clazzEnrolmentActive  BOOL  NOT NULL , clazzEnrolmentLocalChangeSeqNum  BIGINT  NOT NULL , clazzEnrolmentMasterChangeSeqNum  BIGINT  NOT NULL , clazzEnrolmentLastChangedBy  INTEGER  NOT NULL , clazzEnrolmentUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzEnrolment_clazzEnrolmentPersonUid_clazzEnrolmentClazzUid ON ClazzEnrolment (clazzEnrolmentPersonUid, clazzEnrolmentClazzUid)');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentPersonUid ON ClazzEnrolment (clazzEnrolmentClazzUid, clazzEnrolmentPersonUid)');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentRole ON ClazzEnrolment (clazzEnrolmentClazzUid, clazzEnrolmentRole)');
      database.execSQL_61zpoe$('INSERT INTO ClazzEnrolment (clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy) SELECT clazzMemberUid, clazzMemberPersonUid, clazzMemberClazzUid, clazzMemberDateJoined, clazzMemberDateLeft, clazzMemberRole, clazzMemberAttendancePercentage, clazzMemberActive, clazzMemberLocalChangeSeqNum, clazzMemberMasterChangeSeqNum, clazzMemberLastChangedBy FROM ClazzMember');
      database.execSQL_61zpoe$('DROP TABLE ClazzMember');
      database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzMember_trk');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzEnrolment_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzEnrolment_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n                      |CREATE OR REPLACE FUNCTION \n                      | inccsn_65_fn() RETURNS trigger AS $$\n                      | BEGIN  \n                      | UPDATE ClazzEnrolment SET clazzEnrolmentLocalChangeSeqNum =\n                      | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.clazzEnrolmentLocalChangeSeqNum \n                      | ELSE NEXTVAL('ClazzEnrolment_lcsn_seq') END),\n                      | clazzEnrolmentMasterChangeSeqNum = \n                      | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n                      | THEN NEXTVAL('ClazzEnrolment_mcsn_seq') \n                      | ELSE NEW.clazzEnrolmentMasterChangeSeqNum END)\n                      | WHERE clazzEnrolmentUid = NEW.clazzEnrolmentUid;\n                      | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      | SELECT 65, NEW.clazzEnrolmentUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n                      | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n                      | RETURN null;\n                      | END $$\n                      | LANGUAGE plpgsql\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER inccsn_65_trig \n                      |AFTER UPDATE OR INSERT ON ClazzEnrolment \n                      |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n                      |EXECUTE PROCEDURE inccsn_65_fn()\n                      '));
      database.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inc_csn_65_fn');
      database.execSQL_61zpoe$('DROP SEQUENCE IF EXISTS spk_seq_65');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzEnrolment_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE \n                      | INDEX index_ClazzEnrolment_trk_clientId_epk_csn \n                      |ON ClazzEnrolment_trk (clientId, epk, csn)\n                      '));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE \n                      |UNIQUE INDEX index_ClazzEnrolment_trk_epk_clientId \n                      |ON ClazzEnrolment_trk (epk, clientId)\n                      '));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_59_60$lambda(database) {
    database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzEnrolment \n                    ADD COLUMN clazzEnrolmentOutcome INTEGER DEFAULT 0 NOT NULL'));
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzEnrolment \n                    ADD COLUMN clazzEnrolmentLeavingReasonUid INTEGER DEFAULT 0 NOT NULL'));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS LeavingReason (`leavingReasonUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `leavingReasonTitle` TEXT, `leavingReasonMCSN` INTEGER NOT NULL, `leavingReasonCSN` INTEGER NOT NULL, `leavingReasonLCB` INTEGER NOT NULL)');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER INS_LOC_410\n                      |AFTER INSERT ON LeavingReason\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                      |    NEW.leavingReasonCSN = 0)\n                      |BEGIN\n                      |    UPDATE LeavingReason\n                      |    SET leavingReasonMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 410)\n                      |    WHERE leavingReasonUid = NEW.leavingReasonUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums\n                      |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |    WHERE sCsnTableId = 410;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER INS_PRI_410\n                      |            AFTER INSERT ON LeavingReason\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n                      |                NEW.leavingReasonMCSN = 0)\n                      |            BEGIN\n                      |                UPDATE LeavingReason\n                      |                SET leavingReasonMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 410)\n                      |                WHERE leavingReasonUid = NEW.leavingReasonUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 410;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 410, NEW.leavingReasonUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER UPD_LOC_410\n                      |AFTER UPDATE ON LeavingReason\n                      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                      |    AND (NEW.leavingReasonCSN == OLD.leavingReasonCSN OR\n                      |        NEW.leavingReasonCSN == 0))\n                      |BEGIN\n                      |    UPDATE LeavingReason\n                      |    SET leavingReasonCSN = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 410) \n                      |    WHERE leavingReasonUid = NEW.leavingReasonUid;\n                      |    \n                      |    UPDATE SqliteChangeSeqNums \n                      |    SET sCsnNextLocal = sCsnNextLocal + 1\n                      |    WHERE sCsnTableId = 410;\n                      |END\n                      '));
      database.execSQL_61zpoe$(trimMargin("\n                      |            CREATE TRIGGER UPD_PRI_410\n                      |            AFTER UPDATE ON LeavingReason\n                      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                      |                AND (NEW.leavingReasonMCSN == OLD.leavingReasonMCSN OR\n                      |                    NEW.leavingReasonMCSN == 0))\n                      |            BEGIN\n                      |                UPDATE LeavingReason\n                      |                SET leavingReasonMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 410)\n                      |                WHERE leavingReasonUid = NEW.leavingReasonUid;\n                      |                \n                      |                UPDATE SqliteChangeSeqNums\n                      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                      |                WHERE sCsnTableId = 410;\n                      |                \n                      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      |SELECT 410, NEW.leavingReasonUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n                      |            END\n                      "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS LeavingReason_trk (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_LeavingReason_trk_clientId_epk_csn` ON LeavingReason_trk (`clientId`, `epk`, `csn`)');
      database.execSQL_61zpoe$('\n                    CREATE UNIQUE INDEX IF NOT EXISTS \n                   `index_LeavingReason_trk_epk_clientId` ON \n                   LeavingReason_trk (`epk`, `clientId`)\n                   ');
    } else if (dbType(database) === 2) {
      database.execSQL_61zpoe$(trimMargin('UPDATE ClazzEnrolment SET \n                clazzEnrolmentOutcome = 200'));
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ClazzEnrolment \n                    ADD COLUMN clazzEnrolmentLeavingReasonUid BIGINT DEFAULT 0 NOT NULL'));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS LeavingReason (  leavingReasonTitle  TEXT , leavingReasonMCSN  BIGINT  NOT NULL , leavingReasonCSN  BIGINT  NOT NULL , leavingReasonLCB  INTEGER  NOT NULL , leavingReasonUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS LeavingReason_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS LeavingReason_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n                      |CREATE OR REPLACE FUNCTION \n                      | inccsn_410_fn() RETURNS trigger AS $$\n                      | BEGIN  \n                      | UPDATE LeavingReason SET leavingReasonCSN =\n                      | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.leavingReasonCSN \n                      | ELSE NEXTVAL('LeavingReason_lcsn_seq') END),\n                      | leavingReasonMCSN = \n                      | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n                      | THEN NEXTVAL('LeavingReason_mcsn_seq') \n                      | ELSE NEW.leavingReasonMCSN END)\n                      | WHERE leavingReasonUid = NEW.leavingReasonUid;\n                      | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                      | SELECT 410, NEW.leavingReasonUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n                      | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n                      | RETURN null;\n                      | END $$\n                      | LANGUAGE plpgsql\n                      "));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE TRIGGER inccsn_410_trig \n                      |AFTER UPDATE OR INSERT ON LeavingReason \n                      |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n                      |EXECUTE PROCEDURE inccsn_410_fn()\n                      '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS LeavingReason_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE \n                      | INDEX index_LeavingReason_trk_clientId_epk_csn \n                      |ON LeavingReason_trk (clientId, epk, csn)\n                      '));
      database.execSQL_61zpoe$(trimMargin('\n                      |CREATE \n                      |UNIQUE INDEX index_LeavingReason_trk_epk_clientId \n                      |ON LeavingReason_trk (epk, clientId)\n                      '));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_60_61$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$(trimMargin('UPDATE Role SET \n                rolePermissions = 17051045363166 \n                WHERE roleUid = 1001 '));
      database.execSQL_61zpoe$(trimMargin('UPDATE persongroupmember SET groupmemberactive = true \n                    WHERE groupmemberactive is NULL'));
      database.execSQL_61zpoe$(trimMargin("INSERT INTO PersonGroup\n                    (groupName, groupActive, personGroupFlag) SELECT\n                    'Admin Group', true, 1 \n                    WHERE EXISTS (SELECT * FROM Person WHERE firstNames = 'Admin' \n                    AND lastName = 'User' AND personGroupUid = 0)"));
      database.execSQL_61zpoe$(trimMargin("UPDATE PERSON SET personGroupUid = (SELECT groupUid\n                    FROM PersonGroup WHERE groupName = 'Admin Group' LIMIT 1) WHERE\n                    firstNames = 'Admin' AND lastName = 'User' AND personGroupUid = 0"));
      database.execSQL_61zpoe$(trimMargin("INSERT INTO PersonGroupMember \n                    (groupMemberActive, groupMemberPersonUid, groupMemberGroupUid) \n                     SELECT true,(SELECT Person.personUid FROM PERSON WHERE username = 'admin') \n                    , (SELECT groupUid FROM PersonGroup WHERE groupName = 'Admin Group' LIMIT 1) \n                    WHERE EXISTS (SELECT * FROM PersonGroup WHERE groupName = 'Admin Group'); "));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_61_62$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('ALTER TABLE Language \n                    ADD COLUMN languageActive BOOL DEFAULT FALSE NOT NULL');
      database.execSQL_61zpoe$('UPDATE Language SET languageActive = true');
    } else {
      database.execSQL_61zpoe$('ALTER TABLE Language \n                    ADD COLUMN languageActive INTEGER DEFAULT 0 NOT NULL');
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_62_63$lambda(database) {
    var tmp$;
    if (dbType(database) === 1) {
      tmp$ = 'INTEGER';
    } else {
      tmp$ = 'BIGINT';
    }
    var fieldType = tmp$;
    var lastModTimeFields = listOf_0([to('ClazzLog', 'clazzLogLastChangedTime'), to('ClazzLogAttendanceRecord', 'clazzLogAttendanceRecordLastChangedTime'), to('Schedule', 'scheduleLastChangedTime'), to('DateRange', 'dateRangeLct'), to('HolidayCalendar', 'umCalendarLct'), to('Holiday', 'holLct'), to('CustomField', 'customFieldLct'), to('CustomFieldValue', 'customFieldLct'), to('Person', 'personLct'), to('Clazz', 'clazzLct'), to('ClazzEnrolment', 'clazzEnrolmentLct'), to('LeavingReason', 'leavingReasonLct'), to('PersonCustomFieldValue', 'personCustomFieldValueLct'), to('ContentEntry', 'contentEntryLct'), to('ContentEntryContentCategoryJoin', 'ceccjLct'), to('ContentCategorySchema', 'contentCategorySchemaLct'), to('ContentEntryParentChildJoin', 'cepcjLct'), to('ContentEntryRelatedEntryJoin', 'cerejLct'), to('ContentCategory', 'contentCategoryLct'), to('Language', 'langLct'), to('LanguageVariant', 'langVariantLct'), to('Role', 'roleLct'), to('EntityRole', 'erLct'), to('PersonGroup', 'groupLct'), to('PersonGroupMember', 'groupMemberLct'), to('PersonPicture', 'personPictureLct'), to('Container', 'cntLct'), to('VerbEntity', 'verbLct'), to('XObjectEntity', 'xObjectLct'), to('StatementEntity', 'statementLct'), to('ContextXObjectStatementJoin', 'contextXObjectLct'), to('AgentEntity', 'agentLct'), to('StateEntity', 'stateLct'), to('StateContentEntity', 'stateContentLct'), to('XLangMapEntry', 'statementLangMapLct'), to('School', 'schoolLct'), to('SchoolMember', 'schoolMemberLct'), to('ClazzWork', 'clazzWorkLct'), to('ClazzWorkContentJoin', 'clazzWorkContentJoinLct'), to('Comments', 'commentsLct'), to('ClazzWorkQuestion', 'clazzWorkQuestionLct'), to('ClazzWorkQuestionOption', 'clazzWorkQuestionOptionLct'), to('ClazzWorkSubmission', 'clazzWorkSubmissionLct'), to('ClazzWorkQuestionResponse', 'clazzWorkQuestionResponseLct'), to('ContentEntryProgress', 'contentEntryProgressLct'), to('Report', 'reportLct'), to('Site', 'siteLct'), to('LearnerGroup', 'learnerGroupLct'), to('LearnerGroupMember', 'learnerGroupMemberLct'), to('GroupLearningSession', 'groupLearningSessionLct'), to('SiteTerms', 'sTermsLct'), to('ScheduledCheck', 'scheduledCheckLct'), to('CustomFieldValueOption', 'customFieldValueLct'), to('AuditLog', 'auditLogLct')]);
    var tmp$_0;
    tmp$_0 = lastModTimeFields.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      database.execSQL_61zpoe$('ALTER TABLE ' + element.first + ' ADD COLUMN ' + element.second + ' ' + fieldType + ' NOT NULL DEFAULT 0');
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_63_64$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE Person ADD COLUMN personCountry TEXT');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_78_79$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE Report ADD COLUMN reportTitleId INTEGER NOT NULL DEFAULT 0');
    database.execSQL_61zpoe$('ALTER TABLE Report ADD COLUMN reportDescId INTEGER NOT NULL DEFAULT 0');
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$(trimIndent('\n                    UPDATE Report SET reportTitleId = 1 , reportDescId = 2 WHERE \n                        reportUid = 100000\n                '));
      database.execSQL_61zpoe$(trimIndent('\n                    UPDATE Report SET reportTitleId = 3 , reportDescId = 4  WHERE \n                        reportUid = 100001\n                '));
      database.execSQL_61zpoe$(trimIndent('\n                    UPDATE Report SET reportTitleId = 5 , reportDescId = 6 WHERE \n                        reportUid = 100002\n                '));
      database.execSQL_61zpoe$(trimIndent('\n                    UPDATE Report SET reportTitleId = 7 , reportDescId = 8 WHERE \n                        reportUid = 100003\n                '));
      database.execSQL_61zpoe$(trimIndent('\n                    UPDATE Report SET reportTitleId = 9 , reportDescId = 10 WHERE \n                        reportUid = 100004\n                '));
      database.execSQL_61zpoe$(trimIndent('\n                    UPDATE Report SET reportTitleId = 11 , reportDescId = 12 WHERE \n                        reportUid = 100005\n                '));
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_64_65$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('ALTER TABLE StatementEntity ADD COLUMN statementClazzUid BIGINT DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzContentJoin (  ccjContentEntryUid  BIGINT  NOT NULL , ccjClazzUid  BIGINT  NOT NULL , ccjActive  BOOL  NOT NULL , ccjLocalChangeSeqNum  BIGINT  NOT NULL , ccjMasterChangeSeqNum  BIGINT  NOT NULL , ccjLastChangedBy  INTEGER  NOT NULL , ccjLct  BIGINT  NOT NULL , ccjUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE INDEX index_ClazzContentJoin_ccjContentEntryUid ON ClazzContentJoin (ccjContentEntryUid)');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzContentJoin_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzContentJoin_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n      |CREATE OR REPLACE FUNCTION \n      | inccsn_134_fn() RETURNS trigger AS $$\n      | BEGIN  \n      | UPDATE ClazzContentJoin SET ccjLocalChangeSeqNum =\n      | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.ccjLocalChangeSeqNum \n      | ELSE NEXTVAL('ClazzContentJoin_lcsn_seq') END),\n      | ccjMasterChangeSeqNum = \n      | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n      | THEN NEXTVAL('ClazzContentJoin_mcsn_seq') \n      | ELSE NEW.ccjMasterChangeSeqNum END)\n      | WHERE ccjUid = NEW.ccjUid;\n      | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n      | SELECT 134, NEW.ccjUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n      | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n      | RETURN null;\n      | END $$\n      | LANGUAGE plpgsql\n      "));
      database.execSQL_61zpoe$(trimMargin('\n      |CREATE TRIGGER inccsn_134_trig \n      |AFTER UPDATE OR INSERT ON ClazzContentJoin \n      |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n      |EXECUTE PROCEDURE inccsn_134_fn()\n      '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzContentJoin_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n      |CREATE \n      | INDEX index_ClazzContentJoin_trk_clientId_epk_csn \n      |ON ClazzContentJoin_trk (clientId, epk, csn)\n      '));
      database.execSQL_61zpoe$(trimMargin('\n      |CREATE \n      |UNIQUE INDEX index_ClazzContentJoin_trk_epk_clientId \n      |ON ClazzContentJoin_trk (epk, clientId)\n      '));
    } else {
      database.execSQL_61zpoe$('ALTER TABLE StatementEntity ADD COLUMN statementClazzUid INTEGER DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzContentJoin (`ccjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ccjContentEntryUid` INTEGER NOT NULL, `ccjClazzUid` INTEGER NOT NULL, `ccjActive` INTEGER NOT NULL, `ccjLocalChangeSeqNum` INTEGER NOT NULL, `ccjMasterChangeSeqNum` INTEGER NOT NULL, `ccjLastChangedBy` INTEGER NOT NULL, `ccjLct` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_ClazzContentJoin_ccjContentEntryUid` ON ClazzContentJoin (`ccjContentEntryUid`)');
      database.execSQL_61zpoe$(trimMargin('\n      |CREATE TRIGGER INS_LOC_134\n      |AFTER INSERT ON ClazzContentJoin\n      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n      |    NEW.ccjLocalChangeSeqNum = 0)\n      |BEGIN\n      |    UPDATE ClazzContentJoin\n      |    SET ccjMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 134)\n      |    WHERE ccjUid = NEW.ccjUid;\n      |    \n      |    UPDATE SqliteChangeSeqNums\n      |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n      |    WHERE sCsnTableId = 134;\n      |END\n      '));
      database.execSQL_61zpoe$(trimMargin("\n      |            CREATE TRIGGER INS_PRI_134\n      |            AFTER INSERT ON ClazzContentJoin\n      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n      |                NEW.ccjMasterChangeSeqNum = 0)\n      |            BEGIN\n      |                UPDATE ClazzContentJoin\n      |                SET ccjMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 134)\n      |                WHERE ccjUid = NEW.ccjUid;\n      |                \n      |                UPDATE SqliteChangeSeqNums\n      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n      |                WHERE sCsnTableId = 134;\n      |                \n      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n      |SELECT 134, NEW.ccjUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n      |            END\n      "));
      database.execSQL_61zpoe$(trimMargin('\n      |CREATE TRIGGER UPD_LOC_134\n      |AFTER UPDATE ON ClazzContentJoin\n      |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n      |    AND (NEW.ccjLocalChangeSeqNum == OLD.ccjLocalChangeSeqNum OR\n      |        NEW.ccjLocalChangeSeqNum == 0))\n      |BEGIN\n      |    UPDATE ClazzContentJoin\n      |    SET ccjLocalChangeSeqNum = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 134) \n      |    WHERE ccjUid = NEW.ccjUid;\n      |    \n      |    UPDATE SqliteChangeSeqNums \n      |    SET sCsnNextLocal = sCsnNextLocal + 1\n      |    WHERE sCsnTableId = 134;\n      |END\n      '));
      database.execSQL_61zpoe$(trimMargin("\n      |            CREATE TRIGGER UPD_PRI_134\n      |            AFTER UPDATE ON ClazzContentJoin\n      |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n      |                AND (NEW.ccjMasterChangeSeqNum == OLD.ccjMasterChangeSeqNum OR\n      |                    NEW.ccjMasterChangeSeqNum == 0))\n      |            BEGIN\n      |                UPDATE ClazzContentJoin\n      |                SET ccjMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 134)\n      |                WHERE ccjUid = NEW.ccjUid;\n      |                \n      |                UPDATE SqliteChangeSeqNums\n      |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n      |                WHERE sCsnTableId = 134;\n      |                \n      |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n      |SELECT 134, NEW.ccjUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n      |            END\n      "));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzContentJoin_trk (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_ClazzContentJoin_trk_clientId_epk_csn` ON ClazzContentJoin_trk (`clientId`, `epk`, `csn`)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX IF NOT EXISTS `index_ClazzContentJoin_trk_epk_clientId` ON ClazzContentJoin_trk (`epk`, `clientId`)');
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_65_66$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ScopedGrant (  sgPcsn  INTEGER  NOT NULL , sgLcsn  INTEGER  NOT NULL , sgLcb  INTEGER  NOT NULL , sgLct  INTEGER  NOT NULL , sgTableId  INTEGER  NOT NULL , sgEntityUid  INTEGER  NOT NULL , sgPermissions  INTEGER  NOT NULL , sgGroupUid  INTEGER  NOT NULL , sgIndex  INTEGER  NOT NULL , sgFlags  INTEGER  NOT NULL , sgUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      var tmp$;
      tmp$ = util.DoorSqlGenerator.generateSyncableEntityInsertTriggersSqlite_nm8d6u$('ScopedGrant', 48, 'sgUid', 'sgLcsn', 'sgPcsn').iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        database.execSQL_61zpoe$(element);
      }
      var tmp$_0;
      tmp$_0 = util.DoorSqlGenerator.generateSyncableEntityUpdateTriggersSqlite_nm8d6u$('ScopedGrant', 48, 'sgUid', 'sgLcsn', 'sgPcsn').iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        database.execSQL_61zpoe$(element_0);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ScopedGrant_trk (  epk  INTEGER  NOT NULL DEFAULT 0 , clientId  INTEGER  NOT NULL DEFAULT 0 , csn  INTEGER  NOT NULL DEFAULT 0 , rx  INTEGER  NOT NULL DEFAULT 0 , reqId  INTEGER  NOT NULL DEFAULT 0 , ts  INTEGER  NOT NULL DEFAULT 0 , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_ScopedGrant_trk_clientId_epk_csn ON ScopedGrant_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_ScopedGrant_trk_epk_clientId ON ScopedGrant_trk (epk, clientId)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonParentJoin (  ppjPcsn  INTEGER  NOT NULL , ppjLcsn  INTEGER  NOT NULL , ppjLcb  INTEGER  NOT NULL , ppjLct  INTEGER  NOT NULL , ppjParentPersonUid  INTEGER  NOT NULL , ppjMinorPersonUid  INTEGER  NOT NULL , ppjRelationship  INTEGER  NOT NULL , ppjEmail  TEXT , ppjPhone  TEXT , ppjInactive  INTEGER  NOT NULL , ppjStatus  INTEGER  NOT NULL , ppjApprovalTiemstamp  INTEGER  NOT NULL , ppjApprovalIpAddr  TEXT , ppjUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      var tmp$_1;
      tmp$_1 = util.DoorSqlGenerator.generateSyncableEntityInsertTriggersSqlite_nm8d6u$('PersonParentJoin', 512, 'ppjUid', 'ppjLcsn', 'ppjPcsn').iterator();
      while (tmp$_1.hasNext()) {
        var element_1 = tmp$_1.next();
        database.execSQL_61zpoe$(element_1);
      }
      var tmp$_2;
      tmp$_2 = util.DoorSqlGenerator.generateSyncableEntityUpdateTriggersSqlite_nm8d6u$('PersonParentJoin', 512, 'ppjUid', 'ppjLcsn', 'ppjPcsn').iterator();
      while (tmp$_2.hasNext()) {
        var element_2 = tmp$_2.next();
        database.execSQL_61zpoe$(element_2);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonParentJoin_trk (  epk  INTEGER  NOT NULL DEFAULT 0 , clientId  INTEGER  NOT NULL DEFAULT 0 , csn  INTEGER  NOT NULL DEFAULT 0 , rx  INTEGER  NOT NULL DEFAULT 0 , reqId  INTEGER  NOT NULL DEFAULT 0 , ts  INTEGER  NOT NULL DEFAULT 0 , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_PersonParentJoin_trk_clientId_epk_csn ON PersonParentJoin_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_PersonParentJoin_trk_epk_clientId ON PersonParentJoin_trk (epk, clientId)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ErrorReport (  errPcsn  INTEGER  NOT NULL , errLcsn  INTEGER  NOT NULL , errLcb  INTEGER  NOT NULL , errLct  INTEGER  NOT NULL , severity  INTEGER  NOT NULL , timestamp  INTEGER  NOT NULL , presenterUri  TEXT , appVersion  TEXT , versionCode  INTEGER  NOT NULL , errorCode  INTEGER  NOT NULL , operatingSys  TEXT , osVersion  TEXT , stackTrace  TEXT , message  TEXT , errUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      var tmp$_3;
      tmp$_3 = util.DoorSqlGenerator.generateSyncableEntityInsertTriggersSqlite_nm8d6u$('ErrorReport', 419, 'errUid', 'errLcsn', 'errPcsn').iterator();
      while (tmp$_3.hasNext()) {
        var element_3 = tmp$_3.next();
        database.execSQL_61zpoe$(element_3);
      }
      var tmp$_4;
      tmp$_4 = util.DoorSqlGenerator.generateSyncableEntityUpdateTriggersSqlite_nm8d6u$('ErrorReport', 419, 'errUid', 'errLcsn', 'errPcsn').iterator();
      while (tmp$_4.hasNext()) {
        var element_4 = tmp$_4.next();
        database.execSQL_61zpoe$(element_4);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ErrorReport_trk (  epk  INTEGER  NOT NULL DEFAULT 0 , clientId  INTEGER  NOT NULL DEFAULT 0 , csn  INTEGER  NOT NULL DEFAULT 0 , rx  INTEGER  NOT NULL DEFAULT 0 , reqId  INTEGER  NOT NULL DEFAULT 0 , ts  INTEGER  NOT NULL DEFAULT 0 , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_ErrorReport_trk_clientId_epk_csn ON ErrorReport_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_ErrorReport_trk_epk_clientId ON ErrorReport_trk (epk, clientId)');
    } else {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ScopedGrant (  sgPcsn  BIGINT  NOT NULL , sgLcsn  BIGINT  NOT NULL , sgLcb  INTEGER  NOT NULL , sgLct  BIGINT  NOT NULL , sgTableId  INTEGER  NOT NULL , sgEntityUid  BIGINT  NOT NULL , sgPermissions  BIGINT  NOT NULL , sgGroupUid  BIGINT  NOT NULL , sgIndex  INTEGER  NOT NULL , sgFlags  INTEGER  NOT NULL , sgUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ScopedGrant_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ScopedGrant_lcsn_seq');
      var tmp$_5;
      tmp$_5 = util.DoorSqlGenerator.generateSyncableEntityFunctionAndTriggerPostgres_nm8d6u$('ScopedGrant', 48, 'sgUid', 'sgLcsn', 'sgPcsn').iterator();
      while (tmp$_5.hasNext()) {
        var element_5 = tmp$_5.next();
        database.execSQL_61zpoe$(element_5);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ScopedGrant_trk (  epk  BIGINT  NOT NULL DEFAULT 0 , clientId  INTEGER  NOT NULL DEFAULT 0 , csn  INTEGER  NOT NULL DEFAULT 0 , rx  BOOL  NOT NULL DEFAULT false , reqId  INTEGER  NOT NULL DEFAULT 0 , ts  BIGINT  NOT NULL DEFAULT 0 , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_ScopedGrant_trk_clientId_epk_csn ON ScopedGrant_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_ScopedGrant_trk_epk_clientId ON ScopedGrant_trk (epk, clientId)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonParentJoin (  ppjPcsn  BIGINT  NOT NULL , ppjLcsn  BIGINT  NOT NULL , ppjLcb  INTEGER  NOT NULL , ppjLct  BIGINT  NOT NULL , ppjParentPersonUid  BIGINT  NOT NULL , ppjMinorPersonUid  BIGINT  NOT NULL , ppjRelationship  INTEGER  NOT NULL , ppjEmail  TEXT , ppjPhone  TEXT , ppjInactive  BOOL  NOT NULL , ppjStatus  INTEGER  NOT NULL , ppjApprovalTiemstamp  BIGINT  NOT NULL , ppjApprovalIpAddr  TEXT , ppjUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS PersonParentJoin_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS PersonParentJoin_lcsn_seq');
      var tmp$_6;
      tmp$_6 = util.DoorSqlGenerator.generateSyncableEntityFunctionAndTriggerPostgres_nm8d6u$('PersonParentJoin', 512, 'ppjUid', 'ppjLcsn', 'ppjPcsn').iterator();
      while (tmp$_6.hasNext()) {
        var element_6 = tmp$_6.next();
        database.execSQL_61zpoe$(element_6);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonParentJoin_trk (  epk  BIGINT  NOT NULL DEFAULT 0 , clientId  INTEGER  NOT NULL DEFAULT 0 , csn  INTEGER  NOT NULL DEFAULT 0 , rx  BOOL  NOT NULL DEFAULT false , reqId  INTEGER  NOT NULL DEFAULT 0 , ts  BIGINT  NOT NULL DEFAULT 0 , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_PersonParentJoin_trk_clientId_epk_csn ON PersonParentJoin_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_PersonParentJoin_trk_epk_clientId ON PersonParentJoin_trk (epk, clientId)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ErrorReport (  errPcsn  BIGINT  NOT NULL , errLcsn  BIGINT  NOT NULL , errLcb  INTEGER  NOT NULL , errLct  BIGINT  NOT NULL , severity  INTEGER  NOT NULL , timestamp  BIGINT  NOT NULL , presenterUri  TEXT , appVersion  TEXT , versionCode  INTEGER  NOT NULL , errorCode  INTEGER  NOT NULL , operatingSys  TEXT , osVersion  TEXT , stackTrace  TEXT , message  TEXT , errUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ErrorReport_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ErrorReport_lcsn_seq');
      var tmp$_7;
      tmp$_7 = util.DoorSqlGenerator.generateSyncableEntityFunctionAndTriggerPostgres_nm8d6u$('ErrorReport', 419, 'errUid', 'errLcsn', 'errPcsn').iterator();
      while (tmp$_7.hasNext()) {
        var element_7 = tmp$_7.next();
        database.execSQL_61zpoe$(element_7);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ErrorReport_trk (  epk  BIGINT  NOT NULL DEFAULT 0 , clientId  INTEGER  NOT NULL DEFAULT 0 , csn  INTEGER  NOT NULL DEFAULT 0 , rx  BOOL  NOT NULL DEFAULT false , reqId  INTEGER  NOT NULL DEFAULT 0 , ts  BIGINT  NOT NULL DEFAULT 0 , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_ErrorReport_trk_clientId_epk_csn ON ErrorReport_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_ErrorReport_trk_epk_clientId ON ErrorReport_trk (epk, clientId)');
      database.execSQL_61zpoe$(trimIndent('\n                        UPDATE Role\n                           SET rolePermissions = (rolePermissions | 17051045363166)\n                         WHERE roleUid = 1001   \n                    '));
      database.execSQL_61zpoe$(trimIndent('\n                        UPDATE Role\n                           SET rolePermissions = (rolePermissions | 284013120966)\n                         WHERE roleUid = 1004  \n                    '));
      var updateTime = systemTimeInMillis();
      database.execSQL_61zpoe$(trimIndent('\n' + '                        INSERT INTO ScopedGrant(sgUid, sgPcsn, sgLcsn, sgLcb, sgLct, sgTableId, ' + '\n' + '                                    sgEntityUid, sgPermissions, sgGroupUid, sgIndex, sgFlags)' + '\n' + '                             SELECT EntityRole.erUid AS sgUid, 0 AS sgPcsn, 0 AS sgLcsn, 0 AS sgLcb, ' + '\n' + '                                    ' + updateTime.toString() + ' AS sgLct, EntityRole.erTableId AS sgTableId, ' + '\n' + '                                    EntityRole.erEntityUid AS sgEntityUid,' + '\n' + '                                    Role.rolePermissions AS sgPermissions, ' + '\n' + '                                    EntityRole.erGroupUid AS sgGroupUid, 0 AS sgIndex, ' + '\n' + '                                    CASE ' + '\n' + '                                         WHEN Role.roleUid = ' + '1001' + ' ' + '\n' + '                                              THEN ' + '9' + '\n' + '                                         WHEN Role.roleUid = ' + '1004' + ' ' + '\n' + '                                              THEN ' + '9' + '\n' + '                                         WHEN Role.roleUid = ' + '1000' + ' ' + '\n' + '                                              THEN ' + '17' + '\n' + '                                         WHEN Role.roleUid = ' + '1003' + ' ' + '\n' + '                                              THEN ' + '17' + '\n' + '                                         ELSE 0' + '\n' + '                                    END AS sgFlags' + '\n' + '                               FROM EntityRole' + '\n' + '                                    JOIN Role ON EntityRole.erRoleUid = Role.roleUid     ' + '\n' + '                    '));
      database.execSQL_61zpoe$(trimIndent('\n' + '                        INSERT INTO ScopedGrant(sgUid, sgPcsn, sgLcsn, sgLcb, sgLct, sgTableId, ' + '\n' + '                                    sgEntityUid, sgPermissions, sgGroupUid, sgIndex, sgFlags)' + '\n' + '                             SELECT Person.personUid AS sgUid, 0 AS sgPcsn, 0 AS sgLcsn, 0 AS sgLcb, ' + '\n' + '                                    ' + updateTime.toString() + ' AS sgLct, ' + '\n' + '                                    ' + '-2' + ' as sgTableId,' + '\n' + '                                    ' + ScopedGrant$Companion$ALL_ENTITIES.toString() + ' AS sgEntityUid,' + '\n' + '                                    ' + Role$Companion$ALL_PERMISSIONS.toString() + ' AS sgPermissions,' + '\n' + '                                    Person.personGroupUid AS sgGroupUid,' + '\n' + '                                    0 AS sgFlags,' + '\n' + '                                    0 AS sgIndex' + '\n' + '                               FROM Person' + '\n' + '                              WHERE CAST(Person.admin AS INTEGER) = 1      ' + '\n' + '                                          ' + '\n' + '                    '));
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_66_67$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('ALTER TABLE ContainerImportJob RENAME to ContainerImportJob_OLD');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ContainerImportJob (  cijContainerUid  INTEGER  NOT NULL , cijUri  TEXT , cijImportMode  INTEGER  NOT NULL , cijContainerBaseDir  TEXT , cijContentEntryUid  INTEGER  NOT NULL , cijMimeType  TEXT , cijSessionId  TEXT , cijJobStatus  INTEGER  NOT NULL , cijBytesSoFar  INTEGER  NOT NULL , cijImportCompleted  INTEGER  NOT NULL , cijContentLength  INTEGER  NOT NULL , cijContainerEntryFileUids  TEXT , cijConversionParams  TEXT , cijUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('INSERT INTO ContainerImportJob (cijUid, cijContainerUid, cijUri, cijImportMode, cijContainerBaseDir, cijContentEntryUid, cijMimeType, cijSessionId, cijJobStatus, cijBytesSoFar, cijImportCompleted, cijContentLength, cijContainerEntryFileUids, cijConversionParams) SELECT cijUid, cijContainerUid, cijFilePath, 0, cijContainerBaseDir, cijContentEntryUid, cijMimeType, cijSessionId, cijJobStatus, cijBytesSoFar, cijImportCompleted, cijContentLength, cijContainerEntryFileUids, cijConversionParams FROM ContainerImportJob_OLD');
      database.execSQL_61zpoe$('DROP TABLE ContainerImportJob_OLD');
    } else {
      database.execSQL_61zpoe$(trimMargin('ALTER TABLE ContainerImportJob RENAME COLUMN cijFilePath to cijUri'));
      database.execSQL_61zpoe$('ALTER TABLE ContainerImportJob ADD COLUMN cijImportMode INTEGER DEFAULT 0 NOT NULL');
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_68_69$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('ALTER TABLE ContentEntry ADD COLUMN contentOwner BIGINT DEFAULT 0 NOT NULL');
      database.execSQL_61zpoe$('UPDATE ContentEntry \n                                       SET contentOwner = (SELECT personUid \n                                                             FROM Person \n                                                            WHERE admin LIMIT 1)');
    } else {
      database.execSQL_61zpoe$('ALTER TABLE ContentEntry ADD COLUMN contentOwner INTEGER DEFAULT 0 NOT NULL');
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_69_70$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE Site ADD COLUMN authSalt TEXT');
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonAuth2 (  pauthUid  INTEGER  PRIMARY KEY  NOT NULL , pauthMechanism  TEXT , pauthAuth  TEXT , pauthLcsn  INTEGER  NOT NULL , pauthPcsn  INTEGER  NOT NULL , pauthLcb  INTEGER  NOT NULL , pauthLct  INTEGER  NOT NULL )');
      var tmp$;
      tmp$ = util.DoorSqlGenerator.generateSyncableEntityInsertTriggersSqlite_nm8d6u$('PersonAuth2', 678, 'pauthUid', 'pauthLcsn', 'pauthPcsn').iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        database.execSQL_61zpoe$(element);
      }
      var tmp$_0;
      tmp$_0 = util.DoorSqlGenerator.generateSyncableEntityUpdateTriggersSqlite_nm8d6u$('PersonAuth2', 678, 'pauthUid', 'pauthLcsn', 'pauthPcsn').iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        database.execSQL_61zpoe$(element_0);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonAuth2_trk (  epk  INTEGER  NOT NULL DEFAULT  0 , clientId  INTEGER  NOT NULL DEFAULT  0 , csn  INTEGER  NOT NULL DEFAULT  0 , rx  INTEGER  NOT NULL DEFAULT  0 , reqId  INTEGER  NOT NULL DEFAULT  0 , ts  INTEGER  NOT NULL DEFAULT  0 , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_PersonAuth2_trk_clientId_epk_csn ON PersonAuth2_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_PersonAuth2_trk_epk_clientId ON PersonAuth2_trk (epk, clientId)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS UserSession (  usPcsn  INTEGER  NOT NULL , usLcsn  INTEGER  NOT NULL , usLcb  INTEGER  NOT NULL , usLct  INTEGER  NOT NULL , usPersonUid  INTEGER  NOT NULL , usClientNodeId  INTEGER  NOT NULL , usStartTime  INTEGER  NOT NULL , usEndTime  INTEGER  NOT NULL , usStatus  INTEGER  NOT NULL , usReason  INTEGER  NOT NULL , usAuth  TEXT , usSessionType  INTEGER  NOT NULL , usUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      var tmp$_1;
      tmp$_1 = util.DoorSqlGenerator.generateSyncableEntityInsertTriggersSqlite_nm8d6u$('UserSession', 679, 'usUid', 'usLcsn', 'usPcsn').iterator();
      while (tmp$_1.hasNext()) {
        var element_1 = tmp$_1.next();
        database.execSQL_61zpoe$(element_1);
      }
      var tmp$_2;
      tmp$_2 = util.DoorSqlGenerator.generateSyncableEntityUpdateTriggersSqlite_nm8d6u$('UserSession', 679, 'usUid', 'usLcsn', 'usPcsn').iterator();
      while (tmp$_2.hasNext()) {
        var element_2 = tmp$_2.next();
        database.execSQL_61zpoe$(element_2);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS UserSession_trk (  epk  INTEGER  NOT NULL DEFAULT  0 , clientId  INTEGER  NOT NULL DEFAULT  0 , csn  INTEGER  NOT NULL DEFAULT  0 , rx  INTEGER  NOT NULL DEFAULT  0 , reqId  INTEGER  NOT NULL DEFAULT  0 , ts  INTEGER  NOT NULL DEFAULT  0 , pk  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_UserSession_trk_clientId_epk_csn ON UserSession_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_UserSession_trk_epk_clientId ON UserSession_trk (epk, clientId)');
    } else {
      database.execSQL_61zpoe$('\n' + '                    UPDATE Site' + '\n' + "                       SET authSalt = '" + randomString(20) + "'" + '\n' + '                ');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonAuth2 (  pauthUid  BIGINT  PRIMARY KEY  NOT NULL , pauthMechanism  TEXT , pauthAuth  TEXT , pauthLcsn  BIGINT  NOT NULL , pauthPcsn  BIGINT  NOT NULL , pauthLcb  INTEGER  NOT NULL , pauthLct  BIGINT  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS PersonAuth2_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS PersonAuth2_lcsn_seq');
      var tmp$_3;
      tmp$_3 = util.DoorSqlGenerator.generateSyncableEntityFunctionAndTriggerPostgres_nm8d6u$('PersonAuth2', 678, 'pauthUid', 'pauthLcsn', 'pauthPcsn').iterator();
      while (tmp$_3.hasNext()) {
        var element_3 = tmp$_3.next();
        database.execSQL_61zpoe$(element_3);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS PersonAuth2_trk (  epk  BIGINT  NOT NULL DEFAULT  0 , clientId  INTEGER  NOT NULL DEFAULT  0 , csn  INTEGER  NOT NULL DEFAULT  0 , rx  BOOL  NOT NULL DEFAULT  false , reqId  INTEGER  NOT NULL DEFAULT  0 , ts  BIGINT  NOT NULL DEFAULT  0 , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_PersonAuth2_trk_clientId_epk_csn ON PersonAuth2_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_PersonAuth2_trk_epk_clientId ON PersonAuth2_trk (epk, clientId)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS UserSession (  usPcsn  BIGINT  NOT NULL , usLcsn  BIGINT  NOT NULL , usLcb  INTEGER  NOT NULL , usLct  BIGINT  NOT NULL , usPersonUid  BIGINT  NOT NULL , usClientNodeId  INTEGER  NOT NULL , usStartTime  BIGINT  NOT NULL , usEndTime  BIGINT  NOT NULL , usStatus  INTEGER  NOT NULL , usReason  INTEGER  NOT NULL , usAuth  TEXT , usSessionType  INTEGER  NOT NULL , usUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS UserSession_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS UserSession_lcsn_seq');
      var tmp$_4;
      tmp$_4 = util.DoorSqlGenerator.generateSyncableEntityFunctionAndTriggerPostgres_nm8d6u$('UserSession', 679, 'usUid', 'usLcsn', 'usPcsn').iterator();
      while (tmp$_4.hasNext()) {
        var element_4 = tmp$_4.next();
        database.execSQL_61zpoe$(element_4);
      }
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS UserSession_trk (  epk  BIGINT  NOT NULL DEFAULT  0 , clientId  INTEGER  NOT NULL DEFAULT  0 , csn  INTEGER  NOT NULL DEFAULT  0 , rx  BOOL  NOT NULL DEFAULT  false , reqId  INTEGER  NOT NULL DEFAULT  0 , ts  BIGINT  NOT NULL DEFAULT  0 , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE  INDEX index_UserSession_trk_clientId_epk_csn ON UserSession_trk (clientId, epk, csn)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_UserSession_trk_epk_clientId ON UserSession_trk (epk, clientId)');
    }
    database.execSQL_61zpoe$('CREATE INDEX person_status_node_idx ON UserSession (usPersonUid, usStatus, usClientNodeId)');
    database.execSQL_61zpoe$('CREATE INDEX node_status_person_idx ON UserSession (usClientNodeId, usStatus, usPersonUid)');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_70_71$lambda(database) {
    database.execSQL_61zpoe$('CREATE INDEX idx_group_to_entity ON ScopedGrant (sgGroupUid, sgPermissions, sgTableId, sgEntityUid)');
    database.execSQL_61zpoe$('CREATE INDEX idx_entity_to_group ON ScopedGrant (sgTableId, sgEntityUid, sgPermissions, sgGroupUid)');
    database.execSQL_61zpoe$('DROP TABLE DeviceSession');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_71_72$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignment (`caUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `caTitle` TEXT, `caDescription` TEXT, `caDeadlineDate` INTEGER NOT NULL, `caStartDate` INTEGER NOT NULL, `caLateSubmissionType` INTEGER NOT NULL, `caLateSubmissionPenalty` INTEGER NOT NULL, `caGracePeriodDate` INTEGER NOT NULL, `caActive` INTEGER NOT NULL, `caClassCommentEnabled` INTEGER NOT NULL, `caPrivateCommentsEnabled` INTEGER NOT NULL, `caClazzUid` INTEGER NOT NULL, `caLocalChangeSeqNum` INTEGER NOT NULL, `caMasterChangeSeqNum` INTEGER NOT NULL, `caLastChangedBy` INTEGER NOT NULL, `caLct` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoin (`cacjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cacjContentUid` INTEGER NOT NULL, `cacjAssignmentUid` INTEGER NOT NULL, `cacjActive` INTEGER NOT NULL, `cacjMCSN` INTEGER NOT NULL, `cacjLCSN` INTEGER NOT NULL, `cacjLCB` INTEGER NOT NULL, `cacjLct` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignment_trk (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_ClazzAssignment_trk_clientId_epk_csn` ON ClazzAssignment_trk (`clientId`, `epk`, `csn`)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX IF NOT EXISTS `index_ClazzAssignment_trk_epk_clientId` ON ClazzAssignment_trk (`epk`, `clientId`)');
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoin_trk (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS `index_ClazzAssignmentContentJoin_trk_clientId_epk_csn` ON ClazzAssignmentContentJoin_trk (`clientId`, `epk`, `csn`)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX IF NOT EXISTS `index_ClazzAssignmentContentJoin_trk_epk_clientId` ON ClazzAssignmentContentJoin_trk (`epk`, `clientId`)');
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE TRIGGER INS_LOC_520\n          |AFTER INSERT ON ClazzAssignment\n          |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n          |    NEW.caLocalChangeSeqNum = 0)\n          |BEGIN\n          |    UPDATE ClazzAssignment\n          |    SET caMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 520)\n          |    WHERE caUid = NEW.caUid;\n          |    \n          |    UPDATE SqliteChangeSeqNums\n          |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n          |    WHERE sCsnTableId = 520;\n          |END\n          '));
      database.execSQL_61zpoe$(trimMargin("\n          |            CREATE TRIGGER INS_PRI_520\n          |            AFTER INSERT ON ClazzAssignment\n          |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n          |                NEW.caMasterChangeSeqNum = 0)\n          |            BEGIN\n          |                UPDATE ClazzAssignment\n          |                SET caMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 520)\n          |                WHERE caUid = NEW.caUid;\n          |                \n          |                UPDATE SqliteChangeSeqNums\n          |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n          |                WHERE sCsnTableId = 520;\n          |                \n          |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n          |SELECT 520, NEW.caUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n          |            END\n          "));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE TRIGGER UPD_LOC_520\n          |AFTER UPDATE ON ClazzAssignment\n          |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n          |    AND (NEW.caLocalChangeSeqNum == OLD.caLocalChangeSeqNum OR\n          |        NEW.caLocalChangeSeqNum == 0))\n          |BEGIN\n          |    UPDATE ClazzAssignment\n          |    SET caLocalChangeSeqNum = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 520) \n          |    WHERE caUid = NEW.caUid;\n          |    \n          |    UPDATE SqliteChangeSeqNums \n          |    SET sCsnNextLocal = sCsnNextLocal + 1\n          |    WHERE sCsnTableId = 520;\n          |END\n          '));
      database.execSQL_61zpoe$(trimMargin("\n          |            CREATE TRIGGER UPD_PRI_520\n          |            AFTER UPDATE ON ClazzAssignment\n          |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n          |                AND (NEW.caMasterChangeSeqNum == OLD.caMasterChangeSeqNum OR\n          |                    NEW.caMasterChangeSeqNum == 0))\n          |            BEGIN\n          |                UPDATE ClazzAssignment\n          |                SET caMasterChangeSeqNum = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 520)\n          |                WHERE caUid = NEW.caUid;\n          |                \n          |                UPDATE SqliteChangeSeqNums\n          |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n          |                WHERE sCsnTableId = 520;\n          |                \n          |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n          |SELECT 520, NEW.caUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n          |            END\n          "));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE TRIGGER INS_LOC_521\n          |AFTER INSERT ON ClazzAssignmentContentJoin\n          |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n          |    NEW.cacjLCSN = 0)\n          |BEGIN\n          |    UPDATE ClazzAssignmentContentJoin\n          |    SET cacjMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 521)\n          |    WHERE cacjUid = NEW.cacjUid;\n          |    \n          |    UPDATE SqliteChangeSeqNums\n          |    SET sCsnNextPrimary = sCsnNextPrimary + 1\n          |    WHERE sCsnTableId = 521;\n          |END\n          '));
      database.execSQL_61zpoe$(trimMargin("\n          |            CREATE TRIGGER INS_PRI_521\n          |            AFTER INSERT ON ClazzAssignmentContentJoin\n          |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND\n          |                NEW.cacjMCSN = 0)\n          |            BEGIN\n          |                UPDATE ClazzAssignmentContentJoin\n          |                SET cacjMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 521)\n          |                WHERE cacjUid = NEW.cacjUid;\n          |                \n          |                UPDATE SqliteChangeSeqNums\n          |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n          |                WHERE sCsnTableId = 521;\n          |                \n          |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n          |SELECT 521, NEW.cacjUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n          |            END\n          "));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE TRIGGER UPD_LOC_521\n          |AFTER UPDATE ON ClazzAssignmentContentJoin\n          |FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n          |    AND (NEW.cacjLCSN == OLD.cacjLCSN OR\n          |        NEW.cacjLCSN == 0))\n          |BEGIN\n          |    UPDATE ClazzAssignmentContentJoin\n          |    SET cacjLCSN = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = 521) \n          |    WHERE cacjUid = NEW.cacjUid;\n          |    \n          |    UPDATE SqliteChangeSeqNums \n          |    SET sCsnNextLocal = sCsnNextLocal + 1\n          |    WHERE sCsnTableId = 521;\n          |END\n          '));
      database.execSQL_61zpoe$(trimMargin("\n          |            CREATE TRIGGER UPD_PRI_521\n          |            AFTER UPDATE ON ClazzAssignmentContentJoin\n          |            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n          |                AND (NEW.cacjMCSN == OLD.cacjMCSN OR\n          |                    NEW.cacjMCSN == 0))\n          |            BEGIN\n          |                UPDATE ClazzAssignmentContentJoin\n          |                SET cacjMCSN = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = 521)\n          |                WHERE cacjUid = NEW.cacjUid;\n          |                \n          |                UPDATE SqliteChangeSeqNums\n          |                SET sCsnNextPrimary = sCsnNextPrimary + 1\n          |                WHERE sCsnTableId = 521;\n          |                \n          |                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n          |SELECT 521, NEW.cacjUid, 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);\n          |            END\n          "));
    } else {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignment (  caTitle  TEXT , caDescription  TEXT , caDeadlineDate  BIGINT  NOT NULL ,  caStartDate  BIGINT  NOT NULL , caLateSubmissionType  INTEGER  NOT NULL , caLateSubmissionPenalty  INTEGER  NOT NULL , caGracePeriodDate  BIGINT  NOT NULL , caActive  BOOL  NOT NULL , caClassCommentEnabled  BOOL  NOT NULL , caPrivateCommentsEnabled  BOOL  NOT NULL , caClazzUid  BIGINT  NOT NULL , caLocalChangeSeqNum  BIGINT  NOT NULL , caMasterChangeSeqNum  BIGINT  NOT NULL , caLastChangedBy  INTEGER  NOT NULL , caLct  BIGINT  NOT NULL , caUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzAssignment_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzAssignment_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n          |CREATE OR REPLACE FUNCTION \n          | inccsn_520_fn() RETURNS trigger AS $$\n          | BEGIN  \n          | UPDATE ClazzAssignment SET caLocalChangeSeqNum =\n          | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.caLocalChangeSeqNum \n          | ELSE NEXTVAL('ClazzAssignment_lcsn_seq') END),\n          | caMasterChangeSeqNum = \n          | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n          | THEN NEXTVAL('ClazzAssignment_mcsn_seq') \n          | ELSE NEW.caMasterChangeSeqNum END)\n          | WHERE caUid = NEW.caUid;\n          | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n          | SELECT 520, NEW.caUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n          | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n          | RETURN null;\n          | END $$\n          | LANGUAGE plpgsql\n          "));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE TRIGGER inccsn_520_trig \n          |AFTER UPDATE OR INSERT ON ClazzAssignment \n          |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n          |EXECUTE PROCEDURE inccsn_520_fn()\n          '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignment_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE \n          | INDEX index_ClazzAssignment_trk_clientId_epk_csn \n          |ON ClazzAssignment_trk (clientId, epk, csn)\n          '));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE \n          |UNIQUE INDEX index_ClazzAssignment_trk_epk_clientId \n          |ON ClazzAssignment_trk (epk, clientId)\n          '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoin (  cacjContentUid  BIGINT  NOT NULL , cacjAssignmentUid  BIGINT  NOT NULL , cacjActive  BOOL  NOT NULL , cacjMCSN  BIGINT  NOT NULL , cacjLCSN  BIGINT  NOT NULL , cacjLCB  INTEGER  NOT NULL , cacjLct  BIGINT  NOT NULL , cacjUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzAssignmentContentJoin_mcsn_seq');
      database.execSQL_61zpoe$('CREATE SEQUENCE IF NOT EXISTS ClazzAssignmentContentJoin_lcsn_seq');
      database.execSQL_61zpoe$(trimMargin("\n          |CREATE OR REPLACE FUNCTION \n          | inccsn_521_fn() RETURNS trigger AS $$\n          | BEGIN  \n          | UPDATE ClazzAssignmentContentJoin SET cacjLCSN =\n          | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW.cacjLCSN \n          | ELSE NEXTVAL('ClazzAssignmentContentJoin_lcsn_seq') END),\n          | cacjMCSN = \n          | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n          | THEN NEXTVAL('ClazzAssignmentContentJoin_mcsn_seq') \n          | ELSE NEW.cacjMCSN END)\n          | WHERE cacjUid = NEW.cacjUid;\n          | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n          | SELECT 521, NEW.cacjUid, false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n          | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n          | RETURN null;\n          | END $$\n          | LANGUAGE plpgsql\n          "));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE TRIGGER inccsn_521_trig \n          |AFTER UPDATE OR INSERT ON ClazzAssignmentContentJoin \n          |FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n          |EXECUTE PROCEDURE inccsn_521_fn()\n          '));
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoin_trk (  epk  BIGINT , clientId  INTEGER , csn  INTEGER , rx  BOOL , reqId  INTEGER , ts  BIGINT , pk  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE \n          | INDEX index_ClazzAssignmentContentJoin_trk_clientId_epk_csn \n          |ON ClazzAssignmentContentJoin_trk (clientId, epk, csn)\n          '));
      database.execSQL_61zpoe$(trimMargin('\n          |CREATE \n          |UNIQUE INDEX index_ClazzAssignmentContentJoin_trk_epk_clientId \n          |ON ClazzAssignmentContentJoin_trk (epk, clientId)\n          '));
    }
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_72_73$lambda(database) {
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignmentRollUp (`cacheUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cachePersonUid` INTEGER NOT NULL, `cacheContentEntryUid` INTEGER NOT NULL, `cacheClazzAssignmentUid` INTEGER NOT NULL, `cacheStudentScore` INTEGER NOT NULL, `cacheMaxScore` INTEGER NOT NULL, `cacheProgress` INTEGER NOT NULL, `cacheContentComplete` INTEGER NOT NULL, `lastCsnChecked` INTEGER NOT NULL)');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX IF NOT EXISTS `index_ClazzAssignmentRollUp_cachePersonUid_cacheContentEntryUid_cacheClazzAssignmentUid` ON ClazzAssignmentRollUp (`cachePersonUid`, `cacheContentEntryUid`, `cacheClazzAssignmentUid`)');
    } else if (dbType(database) === 2) {
      database.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ClazzAssignmentRollUp (  cachePersonUid  BIGINT  NOT NULL , cacheContentEntryUid  BIGINT  NOT NULL , cacheClazzAssignmentUid  BIGINT  NOT NULL , cacheStudentScore  INTEGER  NOT NULL , cacheMaxScore  INTEGER  NOT NULL , cacheProgress  INTEGER  NOT NULL , cacheContentComplete  BOOL  NOT NULL , lastCsnChecked  BIGINT  NOT NULL , cacheUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
      database.execSQL_61zpoe$('CREATE UNIQUE INDEX index_ClazzAssignmentRollUp_cachePersonUid_cacheContentEntryUid_cacheClazzAssignmentUid ON ClazzAssignmentRollUp (cachePersonUid, cacheContentEntryUid, cacheClazzAssignmentUid)');
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_73_74$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE ContentEntry ADD COLUMN completionCriteria INTEGER NOT NULL DEFAULT 0');
    database.execSQL_61zpoe$('ALTER TABLE ContentEntry ADD COLUMN minScore INTEGER NOT NULL DEFAULT 0');
    database.execSQL_61zpoe$('ALTER TABLE ClazzAssignmentRollUp ADD COLUMN cachePenalty INTEGER NOT NULL DEFAULT 0');
    if (dbType(database) === 1) {
      database.execSQL_61zpoe$('ALTER TABLE ClazzAssignmentRollUp ADD COLUMN cacheSuccess INTEGER NOT NULL DEFAULT 0');
    } else if (dbType(database) === 2) {
      database.execSQL_61zpoe$('ALTER TABLE ClazzAssignmentRollUp ADD COLUMN cacheSuccess SMALLINT NOT NULL DEFAULT 0');
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_74_75$lambda(database) {
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWork');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkContentJoin');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkQuestion');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkQuestionOption');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkQuestionResponse');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkSubmission');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentEntryProgress');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS SelQuestionSetResponse');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWork_trk');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkContentJoin_trk');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkQuestion_trk');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkQuestionOption_trk');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkQuestionResponse_trk');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzWorkSubmission_trk');
    database.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentEntryProgress_trk');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_75_76$lambda(database) {
    database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS index_StatementEntity_statementContentEntryUid_statementPersonUid_contentEntryRoot_timestamp_statementLocalChangeSeqNum ON StatementEntity (statementContentEntryUid, statementPersonUid, contentEntryRoot, timestamp, statementLocalChangeSeqNum)');
    database.execSQL_61zpoe$('CREATE INDEX IF NOT EXISTS index_ClazzAssignment_caClazzUid ON ClazzAssignment (caClazzUid)');
    return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_76_77$lambda(database) {
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$('\n                    UPDATE ScopedGrant \n                       SET sgPermissions = (sgPermissions | 4398046511104)\n                     WHERE (sgFlags & 16) = 16   \n                ');
      var teacherAddPermissions = L13194139533312;
      database.execSQL_61zpoe$('\n                    UPDATE ScopedGrant \n                       SET sgPermissions = (sgPermissions | 13194139533312)\n                     WHERE (sgFlags & 8) = 8   \n                ');
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_77_78$lambda(database) {
    database.execSQL_61zpoe$('ALTER TABLE Clazz ADD COLUMN clazzParentsPersonGroupUid INTEGER NOT NULL DEFAULT 0');
    if (dbType(database) === 2) {
      database.execSQL_61zpoe$("\n                    INSERT INTO PersonGroup (groupMasterCsn, groupLocalCsn, \n                                groupLastChangedBy, groupLct, groupName, groupActive, \n                                personGroupFlag)\n                         SELECT 0 AS groupMasterCsn, 0 AS groupLocalCsn,\n                                0 AS groupLastChangedBy,\n                                0 AS groupLct,\n                                ('Class-Parents-' || CAST(Clazz.clazzUid AS TEXT)) AS groupName,\n                                true AS groupActive,\n                                2 AS personGroupFlag\n                           FROM Clazz\n                ");
      database.execSQL_61zpoe$("\n                    UPDATE Clazz\n                       SET clazzParentsPersonGroupUid =\n                           (SELECT groupUid \n                              FROM PersonGroup\n                             WHERE clazzParentsPersonGroupUid = 0\n                               AND groupName = ('Class-Parents-' || CAST(Clazz.clazzUid AS TEXT)))  \n                ");
      database.execSQL_61zpoe$("\n                    UPDATE PersonGroup\n                       SET groupName = 'Parents'\n                     WHERE personGroupFlag =  2\n                       AND groupName LIKE 'Class-Parents%'  \n                ");
    }return Unit;
  }
  function UmAppDatabase$Companion$MIGRATION_79_80$lambda(database) {
    if (dbType(database) === 1) {
      return plus(plus(listOf_0(['ALTER TABLE XLangMapEntry RENAME to XLangMapEntry_OLD', 'CREATE TABLE IF NOT EXISTS XLangMapEntry (  verbLangMapUid  INTEGER  NOT NULL , objectLangMapUid  INTEGER  NOT NULL , languageLangMapUid  INTEGER  NOT NULL , languageVariantLangMapUid  INTEGER  NOT NULL , valueLangMap  TEXT , statementLangMapMasterCsn  INTEGER  NOT NULL , statementLangMapLocalCsn  INTEGER  NOT NULL , statementLangMapLcb  INTEGER  NOT NULL , statementLangMapLct  INTEGER  NOT NULL , statementLangMapUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )', 'INSERT INTO XLangMapEntry (verbLangMapUid, objectLangMapUid, languageLangMapUid, languageVariantLangMapUid, valueLangMap, statementLangMapMasterCsn, statementLangMapLocalCsn, statementLangMapLcb, statementLangMapLct, statementLangMapUid) SELECT verbLangMapUid, objectLangMapUid, languageLangMapUid, languageVariantLangMapUid, valueLangMap, statementLangMapMasterCsn, statementLangMapLocalCsn, statementLangMapLcb, statementLangMapLct, statementLangMapUid FROM XLangMapEntry_OLD', 'DROP TABLE XLangMapEntry_OLD', 'CREATE INDEX index_XLangMapEntry_verbLangMapUid ON XLangMapEntry (verbLangMapUid)']), util.DoorSqlGenerator.generateSyncableEntityInsertTriggersSqlite_nm8d6u$('XLangMapEntry', 74, 'statementLangMapUid', 'statementLangMapLocalCsn', 'statementLangMapMasterCsn')), util.DoorSqlGenerator.generateSyncableEntityUpdateTriggersSqlite_nm8d6u$('XLangMapEntry', 74, 'statementLangMapUid', 'statementLangMapLocalCsn', 'statementLangMapMasterCsn'));
    } else {
      return emptyList();
    }
  }
  function UmAppDatabase$Companion$MIGRATION_80_81$lambda(database) {
    if (dbType(database) === 1) {
      return listOf_0(['CREATE TABLE IF NOT EXISTS ContentJob (  toUri  TEXT , cjProgress  INTEGER  NOT NULL , cjTotal  INTEGER  NOT NULL , params  TEXT , cjUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )', 'CREATE TABLE IF NOT EXISTS ContentJobItem (  cjiJobUid  INTEGER  NOT NULL , sourceUri  TEXT , cjiIsLeaf  INTEGER  NOT NULL , cjiContentEntryUid  INTEGER  NOT NULL , cjiParentContentEntryUid  INTEGER  NOT NULL , cjiContainerUid  INTEGER  NOT NULL , cjiProgress  INTEGER  NOT NULL , cjiTotal  INTEGER  NOT NULL , cjiStatus  INTEGER  NOT NULL , cjiConnectivityAcceptable  INTEGER  NOT NULL , cjiPluginId  INTEGER  NOT NULL , cjiUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )', 'ALTER TABLE Site ADD COLUMN torrentAnnounceUrl TEXT']);
    } else {
      return listOf_0(['CREATE TABLE IF NOT EXISTS ContentJob (  toUri  TEXT , cjProgress  BIGINT  NOT NULL , cjTotal  BIGINT  NOT NULL , params  TEXT , cjUid  BIGSERIAL  PRIMARY KEY  NOT NULL )', 'CREATE TABLE IF NOT EXISTS ContentJobItem (  cjiJobUid  BIGINT  NOT NULL , sourceUri  TEXT , cjiIsLeaf  BOOL  NOT NULL , cjiContentEntryUid  BIGINT  NOT NULL , cjiParentContentEntryUid  BIGINT  NOT NULL , cjiContainerUid  BIGINT  NOT NULL , cjiProgress  BIGINT  NOT NULL , cjiTotal  BIGINT  NOT NULL , cjiStatus  INTEGER  NOT NULL , cjiConnectivityAcceptable  INTEGER  NOT NULL , cjiPluginId  INTEGER  NOT NULL , cjiUid  BIGSERIAL  PRIMARY KEY  NOT NULL )', 'ALTER TABLE Site ADD COLUMN torrentAnnounceUrl TEXT']);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_81_82$lambda(database) {
    return listOf('ALTER TABLE ContentJobItem ADD COLUMN cjiAttemptCount INTEGER NOT NULL DEFAULT 0');
  }
  function UmAppDatabase$Companion$MIGRATION_82_83$lambda(database) {
    var tmp$, tmp$_0;
    tmp$_0 = listOf('DROP TABLE ContentJobItem');
    if (dbType(database) === 1) {
      tmp$ = listOf('CREATE TABLE IF NOT EXISTS ContentJobItem (  cjiJobUid  INTEGER  NOT NULL , sourceUri  TEXT , cjiIsLeaf  INTEGER  NOT NULL , cjiContentEntryUid  INTEGER  NOT NULL , cjiParentContentEntryUid  INTEGER  NOT NULL , cjiContainerUid  INTEGER  NOT NULL , cjiItemProgress  INTEGER  NOT NULL , cjiItemTotal  INTEGER  NOT NULL , cjiRecursiveProgress  INTEGER  NOT NULL , cjiRecursiveTotal  INTEGER  NOT NULL , cjiStatus  INTEGER  NOT NULL , cjiConnectivityAcceptable  INTEGER  NOT NULL , cjiPluginId  INTEGER  NOT NULL , cjiAttemptCount  INTEGER  NOT NULL , cjiParentCjiUid  INTEGER  NOT NULL , cjiUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
    } else {
      tmp$ = listOf('CREATE TABLE IF NOT EXISTS ContentJobItem (  cjiJobUid  BIGINT  NOT NULL , sourceUri  TEXT , cjiIsLeaf  BOOL  NOT NULL , cjiContentEntryUid  BIGINT  NOT NULL , cjiParentContentEntryUid  BIGINT  NOT NULL , cjiContainerUid  BIGINT  NOT NULL , cjiItemProgress  BIGINT  NOT NULL , cjiItemTotal  BIGINT  NOT NULL , cjiRecursiveProgress  BIGINT  NOT NULL , cjiRecursiveTotal  BIGINT  NOT NULL , cjiStatus  INTEGER  NOT NULL , cjiConnectivityAcceptable  INTEGER  NOT NULL , cjiPluginId  INTEGER  NOT NULL , cjiAttemptCount  INTEGER  NOT NULL , cjiParentCjiUid  BIGINT  NOT NULL , cjiUid  BIGSERIAL  PRIMARY KEY  NOT NULL )');
    }
    return plus(tmp$_0, tmp$);
  }
  function UmAppDatabase$Companion$MIGRATION_83_84$lambda(database) {
    return emptyList();
  }
  function UmAppDatabase$Companion$MIGRATION_84_85$lambda(database) {
    var tmp$, tmp$_0;
    tmp$_0 = listOf_0(['ALTER TABLE ContentJob ADD COLUMN cjNotificationTitle TEXT', 'ALTER TABLE ContentJobItem ADD COLUMN cjiRecursiveStatus INTEGER NOT NULL DEFAULT 0']);
    if (dbType(database) === 1) {
      tmp$ = listOf('ALTER TABLE ContentJobItem ADD COLUMN cjiServerJobId INTEGER NOT NULL DEFAULT 0');
    } else {
      tmp$ = listOf('ALTER TABLE ContentJobItem ADD COLUMN cjiServerJobId BIGINT NOT NULL DEFAULT 0');
    }
    return plus(tmp$_0, tmp$);
  }
  function UmAppDatabase$Companion$MIGRATION_85_86$lambda(database) {
    if (dbType(database) === 1) {
      return listOf_0(['ALTER TABLE ContentJobItem ADD COLUMN cjiStartTime INTEGER NOT NULL DEFAULT 0', 'ALTER TABLE ContentJobItem ADD COLUMN cjiFinishTime INTEGER NOT NULL DEFAULT 0', 'ALTER TABLE ContentJobItem ADD COLUMN cjiConnectivityNeeded INTEGER NOT NULL DEFAULT 1', 'ALTER TABLE ContentJobItem RENAME to ContentJobItem_OLD', 'CREATE TABLE IF NOT EXISTS ContentJobItem (`cjiUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cjiJobUid` INTEGER NOT NULL, `sourceUri` TEXT, `cjiIsLeaf` INTEGER NOT NULL, `cjiContentEntryUid` INTEGER NOT NULL, `cjiParentContentEntryUid` INTEGER NOT NULL, `cjiContainerUid` INTEGER NOT NULL, `cjiItemProgress` INTEGER NOT NULL, `cjiItemTotal` INTEGER NOT NULL, `cjiRecursiveProgress` INTEGER NOT NULL, `cjiRecursiveTotal` INTEGER NOT NULL, `cjiStatus` INTEGER NOT NULL, `cjiRecursiveStatus` INTEGER NOT NULL, `cjiConnectivityNeeded` INTEGER NOT NULL, `cjiPluginId` INTEGER NOT NULL, `cjiAttemptCount` INTEGER NOT NULL, `cjiParentCjiUid` INTEGER NOT NULL, `cjiServerJobId` INTEGER NOT NULL, `cjiStartTime` INTEGER NOT NULL, `cjiFinishTime` INTEGER NOT NULL)', 'INSERT INTO ContentJobItem (cjiUid, cjiJobUid, sourceUri, cjiIsLeaf, cjiContentEntryUid, cjiParentContentEntryUid, cjiContainerUid, cjiItemProgress, cjiItemTotal, cjiRecursiveProgress, cjiRecursiveTotal, cjiStatus, cjiRecursiveStatus, cjiConnectivityNeeded, cjiPluginId, cjiAttemptCount, cjiParentCjiUid, cjiServerJobId, cjiStartTime, cjiFinishTime) SELECT cjiUid, cjiJobUid, sourceUri, cjiIsLeaf, cjiContentEntryUid, cjiParentContentEntryUid, cjiContainerUid, cjiItemProgress, cjiItemTotal, cjiRecursiveProgress, cjiRecursiveTotal, cjiStatus, cjiRecursiveStatus, cjiConnectivityNeeded, cjiPluginId, cjiAttemptCount, cjiParentCjiUid, cjiServerJobId, cjiStartTime, cjiFinishTime FROM ContentJobItem_OLD', 'DROP TABLE ContentJobItem_OLD', 'ALTER TABLE ContentJob ADD COLUMN cjIsMeteredAllowed INTEGER NOT NULL DEFAULT 0', 'CREATE INDEX IF NOT EXISTS `index_ContentJobItem_cjiContentEntryUid_cjiFinishTime` ON ContentJobItem (`cjiContentEntryUid`, `cjiFinishTime`)']);
    } else {
      return listOf_0(['ALTER TABLE ContentJobItem ADD COLUMN cjiStartTime BIGINT NOT NULL DEFAULT 0', 'ALTER TABLE ContentJobItem ADD COLUMN cjiFinishTime INTEGER NOT NULL DEFAULT 0', 'ALTER TABLE ContentJob ADD COLUMN cjIsMeteredAllowed BOOL NOT NULL DEFAULT FALSE', 'ALTER TABLE ContentJobItem ADD COLUMN cjiConnectivityNeeded BOOL NOT NULL DEFAULT FALSE', 'ALTER TABLE ContentJobItem DROP COLUMN cjiConnectivityAcceptable', 'CREATE INDEX index_ContentJobItem_cjiContentEntryUid_cjiFinishTime ON ContentJobItem (cjiContentEntryUid, cjiFinishTime)']);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_86_87$lambda(database) {
    return listOf_0(['DROP TABLE IF EXISTS DownloadJob', 'DROP TABLE IF EXISTS DownloadJobItem', 'DROP TABLE IF EXISTS DownloadJobItemHistory', 'DROP TABLE IF EXISTS DownloadJobItemParentChildJoin', 'DROP TABLE IF EXISTS ContentEntryStatus']);
  }
  function UmAppDatabase$Companion$MIGRATION_87_88$lambda(database) {
    if (dbType(database) === 1) {
      return listOf_0(['ALTER TABLE Site RENAME to Site_OLD', 'CREATE TABLE IF NOT EXISTS Site (  sitePcsn  INTEGER  NOT NULL , siteLcsn  INTEGER  NOT NULL , siteLcb  INTEGER  NOT NULL , siteLct  INTEGER  NOT NULL , siteName  TEXT , guestLogin  INTEGER  NOT NULL , registrationAllowed  INTEGER  NOT NULL , authSalt  TEXT , siteUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )', 'INSERT INTO Site (siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt) SELECT siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt FROM Site_OLD', 'DROP TABLE Site_OLD']);
    } else {
      return listOf('ALTER TABLE Site DROP COLUMN IF EXISTS torrentAnnounceUrl');
    }
  }
  function UmAppDatabase$Companion$MIGRATION_88_89$lambda(database) {
    return listOf('ALTER TABLE ContentJobItem ADD COLUMN cjiUploadSessionUid TEXT');
  }
  function UmAppDatabase$Companion$MIGRATION_89_90$lambda(db) {
    if (dbType(db) === 1) {
      return listOf_0(['ALTER TABLE ContentJobItem ADD COLUMN cjiContentDeletedOnCancellation INTEGER NOT NULL DEFAULT 0', 'ALTER TABLE ContentJobItem ADD COLUMN cjiContainerProcessed INTEGER NOT NULL DEFAULT 0']);
    } else {
      return listOf_0(['ALTER TABLE ContentJobItem ADD COLUMN cjiContentDeletedOnCancellation BOOL NOT NULL DEFAULT false', 'ALTER TABLE ContentJobItem ADD COLUMN cjiContainerProcessed BOOL NOT NULL DEFAULT false']);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_90_91$lambda(db) {
    if (dbType(db) === 1) {
      return emptyList();
    } else {
      return listOf_0(['ALTER TABLE Language ALTER COLUMN languageactive DROP DEFAULT', 'ALTER TABLE Language ALTER COLUMN languageActive TYPE BOOL ' + 'USING CASE WHEN CAST(LanguageActive AS INTEGER) = 0 THEN FALSE ELSE TRUE END']);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_92_93$lambda(db) {
    if (dbType(db) === 1) {
      return listOf_0(['ALTER TABLE SyncNode RENAME to SyncNode_OLD', 'CREATE TABLE IF NOT EXISTS SyncNode (  nodeClientId  INTEGER  PRIMARY KEY NOT NULL)', 'INSERT INTO SyncNode (nodeClientId) SELECT nodeClientId FROM SyncNode_OLD', 'DROP TABLE SyncNode_OLD']);
    } else {
      return listOf('ALTER TABLE SyncNode DROP COLUMN master');
    }
  }
  function UmAppDatabase$Companion$MIGRATION_93_94$lambda(db) {
    if (dbType(db) === 1) {
      return listOf_0(['CREATE VIEW IF NOT EXISTS ClazzLogAttendanceRecord_ReceiveView AS  SELECT ClazzLogAttendanceRecord.*, ClazzLogAttendanceRecordReplicate.* FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLogAttendanceRecordReplicate ON ClazzLogAttendanceRecordReplicate.clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid ', 'DROP TRIGGER IF EXISTS clazzlogattendancerecord_remote_insert_ins', 'CREATE TRIGGER clazzlogattendancerecord_remote_insert_ins INSTEAD OF INSERT ON ClazzLogAttendanceRecord_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzLogAttendanceRecord(clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES (NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime) /*psql ON CONFLICT (clazzLogAttendanceRecordUid) DO UPDATE SET clazzLogAttendanceRecordClazzLogUid = EXCLUDED.clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid = EXCLUDED.clazzLogAttendanceRecordPersonUid, attendanceStatus = EXCLUDED.attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy = EXCLUDED.clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime = EXCLUDED.clazzLogAttendanceRecordLastChangedTime */; END']);
    } else {
      return listOf_0(["CREATE OR REPLACE FUNCTION clazzlogattendancerecord_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzLogAttendanceRecord(clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES (NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime) ON CONFLICT (clazzLogAttendanceRecordUid) DO UPDATE SET clazzLogAttendanceRecordClazzLogUid = EXCLUDED.clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid = EXCLUDED.clazzLogAttendanceRecordPersonUid, attendanceStatus = EXCLUDED.attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy = EXCLUDED.clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime = EXCLUDED.clazzLogAttendanceRecordLastChangedTime ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql", 'DROP TRIGGER IF EXISTS clazzlogattendancerecord_remote_insert_trig ON ClazzLogAttendanceRecord_ReceiveView', ' CREATE TRIGGER clazzlogattendancerecord_remote_insert_trig INSTEAD OF INSERT ON ClazzLogAttendanceRecord_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzlogattendancerecord_remote_insert_fn() ']);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_94_95$lambda(db) {
    if (dbType(db) === 1) {
      return listOf_0(['DROP TRIGGER IF EXISTS ATTUPD_PersonPicture', 'DROP TABLE IF EXISTS ZombieAttachmentData', 'CREATE TABLE IF NOT EXISTS ZombieAttachmentData (  zaTableId  INTEGER  NOT NULL , zaPrimaryKey  INTEGER  NOT NULL , zaMd5  TEXT , zaUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )', trimMargin('\n        |\n        |        CREATE TRIGGER ATTUPD_PersonPicture\n        |        AFTER UPDATE ON PersonPicture FOR EACH ROW WHEN\n        |        OLD.personPictureMd5 IS NOT NULL\n        |        BEGIN\n        |        \n        |        INSERT INTO ZombieAttachmentData(zaTableId, zaPrimaryKey, zaMd5) \n        |        SELECT 50 AS zaTableId, OLD.personPictureUid AS zaPrimaryKey, OLD.personPictureMd5 AS zaMd5\n        |          FROM PersonPicture   \n        |         WHERE PersonPicture.personPictureUid = OLD.personPictureUid\n        |           AND (SELECT COUNT(*) \n        |                  FROM PersonPicture\n        |                 WHERE personPictureMd5 = OLD.personPictureMd5) = 0\n        |    ; \n        |        END\n        |    \n        ')]);
    } else {
      return listOf_0(['DROP TRIGGER IF EXISTS attach_PersonPicture_trig ON PersonPicture', 'DROP TABLE IF EXISTS ZombieAttachmentData', 'CREATE TABLE IF NOT EXISTS ZombieAttachmentData (  zaTableId  INTEGER  NOT NULL , zaPrimaryKey  BIGINT  NOT NULL , zaMd5  TEXT , zaUid  BIGSERIAL  PRIMARY KEY  NOT NULL )', trimMargin('\n        |    CREATE OR REPLACE FUNCTION attach_PersonPicture_fn() RETURNS trigger AS $$\n        |    BEGIN\n        |    \n        |    INSERT INTO ZombieAttachmentData(zaTableId, zaPrimaryKey, zaMd5) \n        |    SELECT 50 AS zaTableId, OLD.personPictureUid AS zaPrimaryKey, OLD.personPictureMd5 AS zaMd5\n        |      FROM PersonPicture   \n        |     WHERE PersonPicture.personPictureUid = OLD.personPictureUid\n        |       AND (SELECT COUNT(*) \n        |              FROM PersonPicture\n        |             WHERE personPictureMd5 = OLD.personPictureMd5) = 0\n        |;\n        |    RETURN NEW;\n        |    END $$\n        |    LANGUAGE plpgsql\n        '), trimMargin('\n        |CREATE TRIGGER attach_PersonPicture_trig\n        |AFTER UPDATE ON PersonPicture\n        |FOR EACH ROW WHEN (OLD.personPictureMd5 IS NOT NULL)\n        |EXECUTE PROCEDURE attach_PersonPicture_fn();\n        ')]);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_95_96$lambda(db) {
    if (dbType(db) === 2) {
      return listOf_0(['DROP VIEW PersonAuth2_receiveview', 'ALTER TABLE PersonAuth2 ALTER COLUMN pauthLcb TYPE BIGINT', 'CREATE VIEW PersonAuth2_ReceiveView AS  SELECT PersonAuth2.*, PersonAuth2Replicate.* FROM PersonAuth2 LEFT JOIN PersonAuth2Replicate ON PersonAuth2Replicate.paPk = PersonAuth2.pauthUid', "CREATE OR REPLACE FUNCTION personauth2_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO PersonAuth2(pauthUid, pauthMechanism, pauthAuth, pauthLcsn, pauthPcsn, pauthLcb, pauthLct) VALUES (NEW.pauthUid, NEW.pauthMechanism, NEW.pauthAuth, NEW.pauthLcsn, NEW.pauthPcsn, NEW.pauthLcb, NEW.pauthLct) ON CONFLICT (pauthUid) DO UPDATE SET pauthMechanism = EXCLUDED.pauthMechanism, pauthAuth = EXCLUDED.pauthAuth, pauthLcsn = EXCLUDED.pauthLcsn, pauthPcsn = EXCLUDED.pauthPcsn, pauthLcb = EXCLUDED.pauthLcb, pauthLct = EXCLUDED.pauthLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql", 'CREATE TRIGGER personauth2_remote_insert_trig INSTEAD OF INSERT ON PersonAuth2_ReceiveView FOR EACH ROW EXECUTE PROCEDURE personauth2_remote_insert_fn()']);
    } else {
      return emptyList();
    }
  }
  function UmAppDatabase$Companion$MIGRATION_96_97$lambda(db) {
    if (dbType(db) === 1) {
      return listOf_0(['DROP TABLE ZombieAttachmentData', 'CREATE TABLE ZombieAttachmentData (  zaUri  TEXT , zaUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )', 'DROP TRIGGER IF EXISTS ATTUPD_PersonPicture', trimMargin('\n                    |\n                    |        CREATE TRIGGER ATTUPD_PersonPicture\n                    |        AFTER UPDATE ON PersonPicture FOR EACH ROW WHEN\n                    |        OLD.personPictureMd5 IS NOT NULL\n                    |        BEGIN\n                    |        \n                    |        INSERT INTO ZombieAttachmentData(zaUri) \n                    |        SELECT OLD.personPictureUri AS zaUri\n                    |          FROM PersonPicture   \n                    |         WHERE PersonPicture.personPictureUid = OLD.personPictureUid\n                    |           AND (SELECT COUNT(*) \n                    |                  FROM PersonPicture\n                    |                 WHERE personPictureMd5 = OLD.personPictureMd5) = 0\n                    |    ; \n                    |        END\n                    |    \n                    ')]);
    } else {
      return listOf_0(['DROP TABLE IF EXISTS ZombieAttachmentData', 'CREATE TABLE IF NOT EXISTS ZombieAttachmentData (  zaUri  TEXT , zaUid  SERIAL  PRIMARY KEY  NOT NULL )', trimMargin('\n                    |    CREATE OR REPLACE FUNCTION attach_PersonPicture_fn() RETURNS trigger AS $$\n                    |    BEGIN\n                    |    \n                    |    INSERT INTO ZombieAttachmentData(zaUri) \n                    |    SELECT OLD.personPictureUri AS zaUri\n                    |      FROM PersonPicture   \n                    |     WHERE PersonPicture.personPictureUid = OLD.personPictureUid\n                    |       AND (SELECT COUNT(*) \n                    |              FROM PersonPicture\n                    |             WHERE personPictureMd5 = OLD.personPictureMd5) = 0\n                    |;\n                    |    RETURN NEW;\n                    |    END $$\n                    |    LANGUAGE plpgsql\n                    ')]);
    }
  }
  function UmAppDatabase$Companion$MIGRATION_97_98$lambda(db) {
    if (dbType(db) === 2) {
      fixTincan(db);
      return emptyList();
    } else {
      return emptyList();
    }
  }
  function UmAppDatabase$Companion$MIGRATION_98_99$lambda(db) {
    if (dbType(db) === 2) {
      return listOf('ALTER TABLE ContentJobItem ALTER COLUMN cjiFinishTime TYPE BIGINT');
    } else {
      return emptyList();
    }
  }
  function UmAppDatabase$Companion$MIGRATION_99_100$lambda(db) {
    return listOf_0(['\n  UPDATE ContainerEntry\n     SET ceCefUid = \n         (SELECT CefOuter.cefUid\n            FROM ContainerEntryFile CefOuter\n           WHERE CefOuter.cefMd5 = \n\t\t         (SELECT CefInner.cefMd5\n\t\t\t\t    FROM ContainerEntryFile CefInner\n\t\t\t\t   WHERE CefInner.cefUid = ContainerEntry.ceCefUid)\n\t\tORDER BY CefOuter.cefUid\n           LIMIT 1)\n            ', '\nDELETE FROM ContainerEntryFile \n      WHERE ContainerEntryFile.cefUid != \n            (SELECT CefInner.cefUid \n               FROM ContainerEntryFile CefInner\n              WHERE CefInner.cefMd5 = ContainerEntryFile.cefMd5\n           ORDER BY CefInner.cefUid\n              LIMIT 1)\n            ']);
  }
  function UmAppDatabase$Companion$MIGRATION_100_101$lambda(db) {
    if (dbType(db) === 1) {
      return listOf_0(['CREATE VIEW IF NOT EXISTS Container_ReceiveView AS  SELECT Container.*, ContainerReplicate.* FROM Container LEFT JOIN ContainerReplicate ON ContainerReplicate.containerPk = Container.containerUid ', 'DROP TRIGGER IF EXISTS container_remote_insert_ins', 'CREATE TRIGGER container_remote_insert_ins INSTEAD OF INSERT ON Container_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Container(containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, cntLct, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries) SELECT NEW.containerUid, NEW.cntLocalCsn, NEW.cntMasterCsn, NEW.cntLastModBy, NEW.cntLct, NEW.fileSize, NEW.containerContentEntryUid, NEW.cntLastModified, NEW.mimeType, NEW.remarks, NEW.mobileOptimized, NEW.cntNumEntries WHERE NEW.cntLct > (SELECT COALESCE( (SELECT ContainerInt.cntLct FROM Container ContainerInt WHERE ContainerInt.containerUid = NEW.containerUid), 0)) /*psql ON CONFLICT (containerUid) DO UPDATE SET cntLocalCsn = EXCLUDED.cntLocalCsn, cntMasterCsn = EXCLUDED.cntMasterCsn, cntLastModBy = EXCLUDED.cntLastModBy, cntLct = EXCLUDED.cntLct, fileSize = EXCLUDED.fileSize, containerContentEntryUid = EXCLUDED.containerContentEntryUid, cntLastModified = EXCLUDED.cntLastModified, mimeType = EXCLUDED.mimeType, remarks = EXCLUDED.remarks, mobileOptimized = EXCLUDED.mobileOptimized, cntNumEntries = EXCLUDED.cntNumEntries */; END ']);
    } else {
      return listOf("CREATE OR REPLACE FUNCTION container_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Container(containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, cntLct, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries) SELECT NEW.containerUid, NEW.cntLocalCsn, NEW.cntMasterCsn, NEW.cntLastModBy, NEW.cntLct, NEW.fileSize, NEW.containerContentEntryUid, NEW.cntLastModified, NEW.mimeType, NEW.remarks, NEW.mobileOptimized, NEW.cntNumEntries WHERE NEW.cntLct > (SELECT COALESCE( (SELECT ContainerInt.cntLct FROM Container ContainerInt WHERE ContainerInt.containerUid = NEW.containerUid), 0)) ON CONFLICT (containerUid) DO UPDATE SET cntLocalCsn = EXCLUDED.cntLocalCsn, cntMasterCsn = EXCLUDED.cntMasterCsn, cntLastModBy = EXCLUDED.cntLastModBy, cntLct = EXCLUDED.cntLct, fileSize = EXCLUDED.fileSize, containerContentEntryUid = EXCLUDED.containerContentEntryUid, cntLastModified = EXCLUDED.cntLastModified, mimeType = EXCLUDED.mimeType, remarks = EXCLUDED.remarks, mobileOptimized = EXCLUDED.mobileOptimized, cntNumEntries = EXCLUDED.cntNumEntries ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql");
    }
  }
  function UmAppDatabase$Companion$MIGRATION_101_102$lambda(db) {
    if (dbType(db) === 1) {
      var triggerNames = listOf_0(['ContentJobItem_InsertTrigger', 'ContentJobItem_UpdateRecursiveTotals', 'ContentJobItem_UpdateRecursiveStatus', 'ContentJobItem_UpdateParents', 'ContentJobItem_UpdateStatusParent']);
      var destination = ArrayList_init(collectionSizeOrDefault(triggerNames, 10));
      var tmp$;
      tmp$ = triggerNames.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$('DROP TRIGGER IF EXISTS ' + item);
      }
      return plus(destination, listOf_0([' CREATE TRIGGER ContentJobItem_InsertTrigger AFTER INSERT ON ContentJobItem BEGIN UPDATE ContentJobItem SET cjiRecursiveProgress = NEW.cjiItemProgress, cjiRecursiveTotal = NEW.cjiItemTotal WHERE ContentJobItem.cjiUid = NEW.cjiUid; END; ', ' CREATE TRIGGER ContentJobItem_UpdateRecursiveTotals AFTER UPDATE ON ContentJobItem FOR EACH ROW WHEN ( NEW.cjiItemProgress != OLD.cjiItemProgress OR NEW.cjiItemTotal != OLD.cjiItemTotal) BEGIN UPDATE ContentJobItem SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiItemProgress - OLD.cjiItemProgress)), cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiItemTotal - OLD.cjiItemTotal)) WHERE ContentJobItem.cjiUid = NEW.cjiUid; END; ', ' CREATE TRIGGER ContentJobItem_UpdateRecursiveStatus AFTER UPDATE ON ContentJobItem FOR EACH ROW WHEN (NEW.cjiStatus != OLD.cjiStatus) BEGIN UPDATE ContentJobItem SET cjiRecursiveStatus = (CASE WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 24) THEN 24 WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 25) THEN 25 WHEN(SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus ) = (SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 28) THEN 28 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 12) THEN 12 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE (status = 25 OR status = 23)) THEN 23 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 5) THEN 5 ELSE 4 END) WHERE contentJobItem.cjiUid = NEW.cjiUid; END; ', ' CREATE TRIGGER ContentJobItem_UpdateParents AFTER UPDATE ON ContentJobItem FOR EACH ROW WHEN ( NEW.cjiParentCjiUid != 0 AND (NEW.cjiRecursiveProgress != OLD.cjiRecursiveProgress OR NEW.cjiRecursiveTotal != OLD.cjiRecursiveTotal)) BEGIN UPDATE ContentJobItem SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiRecursiveProgress - OLD.cjiRecursiveProgress)), cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiRecursiveTotal - OLD.cjiRecursiveTotal)) WHERE ContentJobItem.cjiUid = NEW.cjiParentCjiUid; END; ', ' CREATE TRIGGER ContentJobItem_UpdateStatusParent AFTER UPDATE ON ContentJobItem FOR EACH ROW WHEN ( NEW.cjiParentCjiUid != 0 AND (New.cjiRecursiveStatus != OLD.cjiRecursiveStatus)) BEGIN UPDATE ContentJobItem SET cjiRecursiveStatus = (CASE WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 24) THEN 24 WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 25) THEN 25 WHEN(SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus ) = (SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 28) THEN 28 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 12) THEN 12 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE (status = 25 OR status = 23)) THEN 23 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 5) THEN 5 ELSE 4 END) WHERE ContentJobItem.cjiUid = NEW.cjiParentCjiUid; END; ']));
    } else {
      var triggerNames_0 = listOf_0(['contentjobiteminsert_trig', 'contentjobitem_updaterecursivetotals_trig', 'contentjobitem_updateparents_trig', 'contentjobitem_updatestatus_trig', 'contentjobitem_updatestatusparents_trig']);
      var destination_0 = ArrayList_init(collectionSizeOrDefault(triggerNames_0, 10));
      var tmp$_0;
      tmp$_0 = triggerNames_0.iterator();
      while (tmp$_0.hasNext()) {
        var item_0 = tmp$_0.next();
        destination_0.add_11rb$('DROP TRIGGER IF EXISTS ' + item_0 + ' ON ContentJobItem');
      }
      return plus(destination_0, listOf_0([' CREATE OR REPLACE FUNCTION contentjobiteminsert_fn() RETURNS TRIGGER AS $$ BEGIN UPDATE ContentJobItem SET cjiRecursiveProgress = NEW.cjiItemProgress, cjiRecursiveTotal = NEW.cjiItemTotal WHERE ContentJobItem.cjiUid = NEW.cjiUid; RETURN NEW; END $$ LANGUAGE plpgsql ', ' CREATE TRIGGER contentjobiteminsert_trig AFTER INSERT ON ContentJobItem FOR EACH ROW EXECUTE PROCEDURE contentjobiteminsert_fn() ', ' CREATE OR REPLACE FUNCTION contentjobitem_updaterecursivetotals_fn() RETURNS TRIGGER AS $$ BEGIN UPDATE ContentJobItem SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiItemProgress - OLD.cjiItemProgress)), cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiItemTotal - OLD.cjiItemTotal)) WHERE (NEW.cjiItemProgress != OLD.cjiItemProgress OR NEW.cjiItemTotal != OLD.cjiItemTotal) AND ContentJobItem.cjiUid = NEW.cjiUid; RETURN NEW; END $$ LANGUAGE plpgsql ', ' CREATE TRIGGER contentjobitem_updaterecursivetotals_trig AFTER UPDATE ON ContentJobItem FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updaterecursivetotals_fn(); ', ' CREATE OR REPLACE FUNCTION contentjobitem_updateparents_fn() RETURNS TRIGGER AS $$ BEGIN UPDATE ContentJobItem SET cjiRecursiveProgress = (cjiRecursiveProgress + (NEW.cjiRecursiveProgress - OLD.cjiRecursiveProgress)), cjiRecursiveTotal = (cjiRecursiveTotal + (NEW.cjiRecursiveTotal - OLD.cjiRecursiveTotal)) WHERE (NEW.cjiRecursiveProgress != OLD.cjiRecursiveProgress OR NEW.cjiRecursiveTotal != OLD.cjiRecursiveTotal) AND ContentJobItem.cjiUid = NEW.cjiParentCjiUid AND NEW.cjiParentCjiUid != 0; RETURN NEW; END $$ LANGUAGE plpgsql ', ' CREATE TRIGGER contentjobitem_updateparents_trig AFTER UPDATE ON ContentJobItem FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updateparents_fn(); ', ' CREATE OR REPLACE FUNCTION contentjobitem_updatestatus_fn() RETURNS TRIGGER AS $$ BEGIN UPDATE ContentJobItem SET cjiRecursiveStatus = (CASE WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 24) THEN 24 WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 25) THEN 25 WHEN(SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus ) = (SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 28) THEN 28 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 12) THEN 12 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE (status = 25 OR status = 23)) THEN 23 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiUid) AS JobStatus WHERE status = 5) THEN 5 ELSE 4 END) WHERE contentJobItem.cjiUid = NEW.cjiUid AND NEW.cjiStatus != OLD.cjiStatus; RETURN NEW; END $$ LANGUAGE plpgsql ', ' CREATE TRIGGER contentjobitem_updatestatus_trig AFTER UPDATE ON ContentJobItem FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updatestatus_fn(); ', ' CREATE OR REPLACE FUNCTION contentjobitem_updatestatusparents_fn() RETURNS TRIGGER AS $$ BEGIN UPDATE ContentJobItem SET cjiRecursiveStatus = (CASE WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 24) THEN 24 WHEN (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus ) = (SELECT Count(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 25) THEN 25 WHEN(SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus ) = (SELECT COUNT(*) FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 28) THEN 28 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 12) THEN 12 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE (status = 25 OR status = 23)) THEN 23 WHEN EXISTS (SELECT status FROM (SELECT cjiRecursiveStatus AS status FROM ContentJobItem WHERE cjiParentCjiUid = NEW.cjiParentCjiUid UNION SELECT cjiStatus AS status FROM ContentJobItem WHERE cjiUid = NEW.cjiParentCjiUid) AS JobStatus WHERE status = 5) THEN 5 ELSE 4 END) WHERE NEW.cjiParentCjiUid != 0 AND NEW.cjiRecursiveStatus != OLD.cjiRecursiveStatus AND ContentJobItem.cjiUid = NEW.cjiParentCjiUid; RETURN NEW; END $$ LANGUAGE plpgsql ', ' CREATE TRIGGER contentjobitem_updatestatusparents_trig AFTER UPDATE ON ContentJobItem FOR EACH ROW EXECUTE PROCEDURE contentjobitem_updatestatusparents_fn(); ']));
    }
  }
  function UmAppDatabase$Companion$MIGRATION_102_103$lambda(db) {
    var stmtList = ArrayList_init_0();
    if (dbType(db) === 1) {
      var element = 'CREATE TABLE IF NOT EXISTS Chat (  chatStartDate  INTEGER  NOT NULL , chatTitle  TEXT , chatGroup  INTEGER  NOT NULL , chatLct  INTEGER  NOT NULL , chatUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element);
      var element_0 = 'CREATE TABLE IF NOT EXISTS ChatReplicate (  chatPk  INTEGER  NOT NULL , chatVersionId  INTEGER  NOT NULL  DEFAULT 0 , chatDestination  INTEGER  NOT NULL , chatPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (chatPk, chatDestination) )';
      stmtList.add_11rb$(element_0);
      var element_1 = 'CREATE INDEX index_ChatReplicate_chatPk_chatDestination_chatVersionId ON ChatReplicate (chatPk, chatDestination, chatVersionId)';
      stmtList.add_11rb$(element_1);
      var element_2 = 'CREATE INDEX index_ChatReplicate_chatDestination_chatPending ON ChatReplicate (chatDestination, chatPending)';
      stmtList.add_11rb$(element_2);
      var element_3 = 'CREATE TABLE IF NOT EXISTS ChatMember (  chatMemberChatUid  INTEGER  NOT NULL , chatMemberPersonUid  INTEGER  NOT NULL , chatMemberJoinedDate  INTEGER  NOT NULL , chatMemberLeftDate  INTEGER  NOT NULL , chatMemberLct  INTEGER  NOT NULL , chatMemberUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_3);
      var element_4 = 'CREATE TABLE IF NOT EXISTS ChatMemberReplicate (  chatMemberPk  INTEGER  NOT NULL , chatMemberVersionId  INTEGER  NOT NULL  DEFAULT 0 , chatMemberDestination  INTEGER  NOT NULL , chatMemberPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (chatMemberPk, chatMemberDestination) )';
      stmtList.add_11rb$(element_4);
      var element_5 = 'CREATE INDEX index_ChatMemberReplicate_chatMemberPk_chatMemberDestination_chatMemberVersionId ON ChatMemberReplicate (chatMemberPk, chatMemberDestination, chatMemberVersionId)';
      stmtList.add_11rb$(element_5);
      var element_6 = 'CREATE INDEX index_ChatMemberReplicate_chatMemberDestination_chatMemberPending ON ChatMemberReplicate (chatMemberDestination, chatMemberPending)';
      stmtList.add_11rb$(element_6);
      var element_7 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentMark (  camAssignmentUid  INTEGER  NOT NULL , camSubmitterUid  INTEGER  NOT NULL , camMark  REAL  NOT NULL , camPenalty  INTEGER  NOT NULL , camLct  INTEGER  NOT NULL , camUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_7);
      var element_8 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentMarkReplicate (  camPk  INTEGER  NOT NULL , camVersionId  INTEGER  NOT NULL  DEFAULT 0 , camDestination  INTEGER  NOT NULL , camPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (camPk, camDestination) )';
      stmtList.add_11rb$(element_8);
      var element_9 = 'CREATE INDEX index_CourseAssignmentMarkReplicate_camPk_camDestination_camVersionId ON CourseAssignmentMarkReplicate (camPk, camDestination, camVersionId)';
      stmtList.add_11rb$(element_9);
      var element_10 = 'CREATE INDEX index_CourseAssignmentMarkReplicate_camDestination_camPending ON CourseAssignmentMarkReplicate (camDestination, camPending)';
      stmtList.add_11rb$(element_10);
      var element_11 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmission (  casAssignmentUid  INTEGER  NOT NULL , casSubmitterUid  INTEGER  NOT NULL , casSubmitterPersonUid  INTEGER  NOT NULL , casText  TEXT , casType  INTEGER  NOT NULL , casTimestamp  INTEGER  NOT NULL , casUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_11);
      var element_12 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmissionAttachment (  casaSubmissionUid  INTEGER  NOT NULL , casaMimeType  TEXT , casaUri  TEXT , casaMd5  TEXT , casaSize  INTEGER  NOT NULL , casaTimestamp  INTEGER  NOT NULL , casaUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_12);
      var element_13 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmissionAttachmentReplicate (  casaPk  INTEGER  NOT NULL , casaVersionId  INTEGER  NOT NULL  DEFAULT 0 , casaDestination  INTEGER  NOT NULL , casaPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (casaPk, casaDestination) )';
      stmtList.add_11rb$(element_13);
      var element_14 = 'CREATE INDEX index_CourseAssignmentSubmissionAttachmentReplicate_casaPk_casaDestination_casaVersionId ON CourseAssignmentSubmissionAttachmentReplicate (casaPk, casaDestination, casaVersionId)';
      stmtList.add_11rb$(element_14);
      var element_15 = 'CREATE INDEX index_CourseAssignmentSubmissionAttachmentReplicate_casaDestination_casaPending ON CourseAssignmentSubmissionAttachmentReplicate (casaDestination, casaPending)';
      stmtList.add_11rb$(element_15);
      var element_16 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmissionReplicate (  casPk  INTEGER  NOT NULL , casVersionId  INTEGER  NOT NULL  DEFAULT 0 , casDestination  INTEGER  NOT NULL , casPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (casPk, casDestination) )';
      stmtList.add_11rb$(element_16);
      var element_17 = 'CREATE INDEX index_CourseAssignmentSubmissionReplicate_casPk_casDestination_casVersionId ON CourseAssignmentSubmissionReplicate (casPk, casDestination, casVersionId)';
      stmtList.add_11rb$(element_17);
      var element_18 = 'CREATE INDEX index_CourseAssignmentSubmissionReplicate_casDestination_casPending ON CourseAssignmentSubmissionReplicate (casDestination, casPending)';
      stmtList.add_11rb$(element_18);
      var element_19 = 'CREATE TABLE IF NOT EXISTS CourseBlock (  cbType  INTEGER  NOT NULL , cbIndentLevel  INTEGER  NOT NULL , cbModuleParentBlockUid  INTEGER  NOT NULL , cbTitle  TEXT , cbDescription  TEXT , cbCompletionCriteria  INTEGER  NOT NULL , cbHideUntilDate  INTEGER  NOT NULL , cbDeadlineDate  INTEGER  NOT NULL , cbLateSubmissionPenalty  INTEGER  NOT NULL , cbGracePeriodDate  INTEGER  NOT NULL , cbMaxPoints  INTEGER  NOT NULL , cbMinPoints  INTEGER  NOT NULL , cbIndex  INTEGER  NOT NULL , cbClazzUid  INTEGER  NOT NULL , cbActive  INTEGER  NOT NULL , cbHidden  INTEGER  NOT NULL , cbEntityUid  INTEGER  NOT NULL , cbLct  INTEGER  NOT NULL , cbUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_19);
      var element_20 = 'CREATE INDEX index_CourseBlock_cbClazzUid ON CourseBlock (cbClazzUid)';
      stmtList.add_11rb$(element_20);
      var element_21 = 'CREATE TABLE IF NOT EXISTS CourseBlockReplicate (  cbPk  INTEGER  NOT NULL , cbVersionId  INTEGER  NOT NULL  DEFAULT 0 , cbDestination  INTEGER  NOT NULL , cbPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (cbPk, cbDestination) )';
      stmtList.add_11rb$(element_21);
      var element_22 = 'CREATE INDEX index_CourseBlockReplicate_cbPk_cbDestination_cbVersionId ON CourseBlockReplicate (cbPk, cbDestination, cbVersionId)';
      stmtList.add_11rb$(element_22);
      var element_23 = 'CREATE INDEX index_CourseBlockReplicate_cbDestination_cbPending ON CourseBlockReplicate (cbDestination, cbPending)';
      stmtList.add_11rb$(element_23);
      var element_24 = 'CREATE TABLE IF NOT EXISTS CourseDiscussion (  courseDiscussionTitle  TEXT , courseDiscussionDesc  TEXT , courseDiscussionClazzUid  INTEGER  NOT NULL , courseDiscussionActive  INTEGER  NOT NULL , courseDiscussionLct  INTEGER  NOT NULL , courseDiscussionUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_24);
      var element_25 = 'CREATE TABLE IF NOT EXISTS CourseDiscussionReplicate (  courseDiscussionPk  INTEGER  NOT NULL , courseDiscussionVersionId  INTEGER  NOT NULL  DEFAULT 0 , courseDiscussionDestination  INTEGER  NOT NULL , courseDiscussionPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (courseDiscussionPk, courseDiscussionDestination) )';
      stmtList.add_11rb$(element_25);
      var element_26 = 'CREATE INDEX index_CourseDiscussionReplicate_courseDiscussionPk_courseDiscussionDestination_courseDiscussionVersionId ON CourseDiscussionReplicate (courseDiscussionPk, courseDiscussionDestination, courseDiscussionVersionId)';
      stmtList.add_11rb$(element_26);
      var element_27 = 'CREATE INDEX index_CourseDiscussionReplicate_courseDiscussionDestination_courseDiscussionPending ON CourseDiscussionReplicate (courseDiscussionDestination, courseDiscussionPending)';
      stmtList.add_11rb$(element_27);
      var element_28 = 'CREATE TABLE IF NOT EXISTS CourseGroupMember (  cgmSetUid  INTEGER  NOT NULL , cgmGroupNumber  INTEGER  NOT NULL , cgmPersonUid  INTEGER  NOT NULL , cgmLct  INTEGER  NOT NULL , cgmUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_28);
      var element_29 = 'CREATE TABLE IF NOT EXISTS CourseGroupMemberReplicate (  cgmPk  INTEGER  NOT NULL , cgmVersionId  INTEGER  NOT NULL  DEFAULT 0 , cgmDestination  INTEGER  NOT NULL , cgmPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (cgmPk, cgmDestination) )';
      stmtList.add_11rb$(element_29);
      var element_30 = 'CREATE INDEX index_CourseGroupMemberReplicate_cgmPk_cgmDestination_cgmVersionId ON CourseGroupMemberReplicate (cgmPk, cgmDestination, cgmVersionId)';
      stmtList.add_11rb$(element_30);
      var element_31 = 'CREATE INDEX index_CourseGroupMemberReplicate_cgmDestination_cgmPending ON CourseGroupMemberReplicate (cgmDestination, cgmPending)';
      stmtList.add_11rb$(element_31);
      var element_32 = 'CREATE TABLE IF NOT EXISTS CourseGroupSet (  cgsName  TEXT , cgsTotalGroups  INTEGER  NOT NULL , cgsActive  INTEGER  NOT NULL , cgsClazzUid  INTEGER  NOT NULL , cgsLct  INTEGER  NOT NULL , cgsUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_32);
      var element_33 = 'CREATE INDEX index_CourseGroupSet_cgsClazzUid ON CourseGroupSet (cgsClazzUid)';
      stmtList.add_11rb$(element_33);
      var element_34 = 'CREATE TABLE IF NOT EXISTS CourseGroupSetReplicate (  cgsPk  INTEGER  NOT NULL , cgsVersionId  INTEGER  NOT NULL  DEFAULT 0 , cgsDestination  INTEGER  NOT NULL , cgsPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (cgsPk, cgsDestination) )';
      stmtList.add_11rb$(element_34);
      var element_35 = 'CREATE INDEX index_CourseGroupSetReplicate_cgsPk_cgsDestination_cgsVersionId ON CourseGroupSetReplicate (cgsPk, cgsDestination, cgsVersionId)';
      stmtList.add_11rb$(element_35);
      var element_36 = 'CREATE INDEX index_CourseGroupSetReplicate_cgsDestination_cgsPending ON CourseGroupSetReplicate (cgsDestination, cgsPending)';
      stmtList.add_11rb$(element_36);
      var element_37 = 'CREATE TABLE IF NOT EXISTS CoursePicture (  coursePictureClazzUid  INTEGER  NOT NULL , coursePictureMasterCsn  INTEGER  NOT NULL , coursePictureLocalCsn  INTEGER  NOT NULL , coursePictureLastChangedBy  INTEGER  NOT NULL , coursePictureLct  INTEGER  NOT NULL , coursePictureUri  TEXT , coursePictureMd5  TEXT , coursePictureFileSize  INTEGER  NOT NULL , coursePictureTimestamp  INTEGER  NOT NULL , coursePictureMimeType  TEXT , coursePictureActive  INTEGER  NOT NULL , coursePictureUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_37);
      var element_38 = 'CREATE TABLE IF NOT EXISTS CoursePictureReplicate (  cpPk  INTEGER  NOT NULL , cpVersionId  INTEGER  NOT NULL  DEFAULT 0 , cpDestination  INTEGER  NOT NULL , cpPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (cpPk, cpDestination) )';
      stmtList.add_11rb$(element_38);
      var element_39 = 'CREATE INDEX index_CoursePictureReplicate_cpPk_cpDestination_cpVersionId ON CoursePictureReplicate (cpPk, cpDestination, cpVersionId)';
      stmtList.add_11rb$(element_39);
      var element_40 = 'CREATE INDEX index_CoursePictureReplicate_cpDestination_cpPending ON CoursePictureReplicate (cpDestination, cpPending)';
      stmtList.add_11rb$(element_40);
      var element_41 = 'CREATE TABLE IF NOT EXISTS CourseTerminology (  ctTitle  TEXT , ctTerminology  TEXT , ctLct  INTEGER  NOT NULL , ctUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_41);
      var element_42 = 'CREATE TABLE IF NOT EXISTS CourseTerminologyReplicate (  ctPk  INTEGER  NOT NULL , ctVersionId  INTEGER  NOT NULL  DEFAULT 0 , ctDestination  INTEGER  NOT NULL , ctPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (ctPk, ctDestination) )';
      stmtList.add_11rb$(element_42);
      var element_43 = 'CREATE INDEX index_CourseTerminologyReplicate_ctPk_ctDestination_ctVersionId ON CourseTerminologyReplicate (ctPk, ctDestination, ctVersionId)';
      stmtList.add_11rb$(element_43);
      var element_44 = 'CREATE INDEX index_CourseTerminologyReplicate_ctDestination_ctPending ON CourseTerminologyReplicate (ctDestination, ctPending)';
      stmtList.add_11rb$(element_44);
      var element_45 = 'CREATE TABLE IF NOT EXISTS DiscussionPost (  discussionPostTitle  TEXT , discussionPostMessage  TEXT , discussionPostStartDate  INTEGER  NOT NULL , discussionPostDiscussionTopicUid  INTEGER  NOT NULL , discussionPostVisible  INTEGER  NOT NULL , discussionPostArchive  INTEGER  NOT NULL , discussionPostStartedPersonUid  INTEGER  NOT NULL , discussionPostClazzUid  INTEGER  NOT NULL , discussionPostLct  INTEGER  NOT NULL , discussionPostUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_45);
      var element_46 = 'CREATE TABLE IF NOT EXISTS DiscussionPostReplicate (  discussionPostPk  INTEGER  NOT NULL , discussionPostVersionId  INTEGER  NOT NULL  DEFAULT 0 , discussionPostDestination  INTEGER  NOT NULL , discussionPostPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (discussionPostPk, discussionPostDestination) )';
      stmtList.add_11rb$(element_46);
      var element_47 = 'CREATE INDEX index_DiscussionPostReplicate_discussionPostPk_discussionPostDestination_discussionPostVersionId ON DiscussionPostReplicate (discussionPostPk, discussionPostDestination, discussionPostVersionId)';
      stmtList.add_11rb$(element_47);
      var element_48 = 'CREATE INDEX index_DiscussionPostReplicate_discussionPostDestination_discussionPostPending ON DiscussionPostReplicate (discussionPostDestination, discussionPostPending)';
      stmtList.add_11rb$(element_48);
      var element_49 = 'CREATE TABLE IF NOT EXISTS DiscussionTopic (  discussionTopicTitle  TEXT , discussionTopicDesc  TEXT , discussionTopicStartDate  INTEGER  NOT NULL , discussionTopicCourseDiscussionUid  INTEGER  NOT NULL , discussionTopicVisible  INTEGER  NOT NULL , discussionTopicArchive  INTEGER  NOT NULL , discussionTopicIndex  INTEGER  NOT NULL , discussionTopicClazzUid  INTEGER  NOT NULL , discussionTopicLct  INTEGER  NOT NULL , discussionTopicUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_49);
      var element_50 = 'CREATE TABLE IF NOT EXISTS DiscussionTopicReplicate (  discussionTopicPk  INTEGER  NOT NULL , discussionTopicVersionId  INTEGER  NOT NULL  DEFAULT 0 , discussionTopicDestination  INTEGER  NOT NULL , discussionTopicPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (discussionTopicPk, discussionTopicDestination) )';
      stmtList.add_11rb$(element_50);
      var element_51 = 'CREATE INDEX index_DiscussionTopicReplicate_discussionTopicPk_discussionTopicDestination_discussionTopicVersionId ON DiscussionTopicReplicate (discussionTopicPk, discussionTopicDestination, discussionTopicVersionId)';
      stmtList.add_11rb$(element_51);
      var element_52 = 'CREATE INDEX index_DiscussionTopicReplicate_discussionTopicDestination_discussionTopicPending ON DiscussionTopicReplicate (discussionTopicDestination, discussionTopicPending)';
      stmtList.add_11rb$(element_52);
      var element_53 = 'CREATE TABLE IF NOT EXISTS Message (  messageSenderPersonUid  INTEGER  NOT NULL , messageTableId  INTEGER  NOT NULL , messageEntityUid  INTEGER  NOT NULL , messageText  TEXT , messageTimestamp  INTEGER  NOT NULL , messageClazzUid  INTEGER  NOT NULL , messageLct  INTEGER  NOT NULL , messageUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_53);
      var element_54 = 'CREATE TABLE IF NOT EXISTS MessageRead (  messageReadPersonUid  INTEGER  NOT NULL , messageReadMessageUid  INTEGER  NOT NULL , messageReadEntityUid  INTEGER  NOT NULL , messageReadLct  INTEGER  NOT NULL , messageReadUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_54);
      var element_55 = 'CREATE TABLE IF NOT EXISTS MessageReadReplicate (  messageReadPk  INTEGER  NOT NULL , messageReadVersionId  INTEGER  NOT NULL  DEFAULT 0 , messageReadDestination  INTEGER  NOT NULL , messageReadPending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (messageReadPk, messageReadDestination) )';
      stmtList.add_11rb$(element_55);
      var element_56 = 'CREATE INDEX index_MessageReadReplicate_messageReadPk_messageReadDestination_messageReadVersionId ON MessageReadReplicate (messageReadPk, messageReadDestination, messageReadVersionId)';
      stmtList.add_11rb$(element_56);
      var element_57 = 'CREATE INDEX index_MessageReadReplicate_messageReadDestination_messageReadPending ON MessageReadReplicate (messageReadDestination, messageReadPending)';
      stmtList.add_11rb$(element_57);
      var element_58 = 'CREATE TABLE IF NOT EXISTS MessageReplicate (  messagePk  INTEGER  NOT NULL , messageVersionId  INTEGER  NOT NULL  DEFAULT 0 , messageDestination  INTEGER  NOT NULL , messagePending  INTEGER  NOT NULL  DEFAULT 1 , PRIMARY KEY (messagePk, messageDestination) )';
      stmtList.add_11rb$(element_58);
      var element_59 = 'CREATE INDEX index_MessageReplicate_messagePk_messageDestination_messageVersionId ON MessageReplicate (messagePk, messageDestination, messageVersionId)';
      stmtList.add_11rb$(element_59);
      var element_60 = 'CREATE INDEX index_MessageReplicate_messageDestination_messagePending ON MessageReplicate (messageDestination, messagePending)';
      stmtList.add_11rb$(element_60);
      var element_61 = 'DROP TABLE ClazzAssignment';
      stmtList.add_11rb$(element_61);
      var element_62 = 'CREATE TABLE IF NOT EXISTS ClazzAssignment (  caTitle  TEXT , caDescription  TEXT , caGroupUid  INTEGER  NOT NULL  DEFAULT 0 , caActive  INTEGER  NOT NULL , caClassCommentEnabled  INTEGER  NOT NULL , caPrivateCommentsEnabled  INTEGER  NOT NULL  DEFAULT 1 , caCompletionCriteria  INTEGER  NOT NULL  DEFAULT 100 , caRequireFileSubmission  INTEGER  NOT NULL  DEFAULT 1 , caFileType  INTEGER  NOT NULL  DEFAULT 0 , caSizeLimit  INTEGER  NOT NULL  DEFAULT 50 , caNumberOfFiles  INTEGER  NOT NULL  DEFAULT 1 , caSubmissionPolicy  INTEGER  NOT NULL  DEFAULT 1 , caMarkingType  INTEGER  NOT NULL  DEFAULT 1 , caRequireTextSubmission  INTEGER  NOT NULL  DEFAULT 1 , caTextLimitType  INTEGER  NOT NULL  DEFAULT 1 , caTextLimit  INTEGER  NOT NULL  DEFAULT 500 , caXObjectUid  INTEGER  NOT NULL  DEFAULT 0 , caClazzUid  INTEGER  NOT NULL , caLocalChangeSeqNum  INTEGER  NOT NULL , caMasterChangeSeqNum  INTEGER  NOT NULL , caLastChangedBy  INTEGER  NOT NULL , caLct  INTEGER  NOT NULL , caUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_62);
      var element_63 = 'CREATE INDEX index_ClazzAssignment_caClazzUid ON ClazzAssignment (caClazzUid)';
      stmtList.add_11rb$(element_63);
      var element_64 = 'DROP TABLE ClazzAssignmentContentJoin';
      stmtList.add_11rb$(element_64);
      var element_65 = 'CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoin (  cacjContentUid  INTEGER  NOT NULL , cacjAssignmentUid  INTEGER  NOT NULL , cacjActive  INTEGER  NOT NULL , cacjWeight  INTEGER  NOT NULL  DEFAULT 0 , cacjMCSN  INTEGER  NOT NULL , cacjLCSN  INTEGER  NOT NULL , cacjLCB  INTEGER  NOT NULL , cacjLct  INTEGER  NOT NULL , cacjUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_65);
      var element_66 = 'DROP TABLE ClazzAssignmentRollUp';
      stmtList.add_11rb$(element_66);
      var element_67 = 'CREATE TABLE IF NOT EXISTS ClazzAssignmentRollUp (  cachePersonUid  INTEGER  NOT NULL , cacheContentEntryUid  INTEGER  NOT NULL , cacheClazzAssignmentUid  INTEGER  NOT NULL , cacheStudentScore  INTEGER  NOT NULL , cacheMaxScore  INTEGER  NOT NULL , cacheFinalWeightScoreWithPenalty  REAL  NOT NULL  DEFAULT 0 , cacheWeight  INTEGER  NOT NULL  DEFAULT 0 , cacheProgress  INTEGER  NOT NULL , cacheContentComplete  INTEGER  NOT NULL , cacheSuccess  INTEGER  NOT NULL , cachePenalty  INTEGER  NOT NULL , lastCsnChecked  INTEGER  NOT NULL , cacheUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_67);
      var element_68 = 'CREATE UNIQUE INDEX index_ClazzAssignmentRollUp_cachePersonUid_cacheContentEntryUid_cacheClazzAssignmentUid ON ClazzAssignmentRollUp (cachePersonUid, cacheContentEntryUid, cacheClazzAssignmentUid)';
      stmtList.add_11rb$(element_68);
      var element_69 = 'DROP TABLE Comments';
      stmtList.add_11rb$(element_69);
      var element_70 = 'CREATE TABLE IF NOT EXISTS Comments (  commentsText  TEXT , commentsEntityType  INTEGER  NOT NULL , commentsEntityUid  INTEGER  NOT NULL , commentsPublic  INTEGER  NOT NULL , commentsStatus  INTEGER  NOT NULL , commentsPersonUid  INTEGER  NOT NULL , commentsToPersonUid  INTEGER  NOT NULL , commentSubmitterUid  INTEGER  NOT NULL , commentsFlagged  INTEGER  NOT NULL , commentsInActive  INTEGER  NOT NULL , commentsDateTimeAdded  INTEGER  NOT NULL , commentsDateTimeUpdated  INTEGER  NOT NULL , commentsMCSN  INTEGER  NOT NULL , commentsLCSN  INTEGER  NOT NULL , commentsLCB  INTEGER  NOT NULL , commentsLct  INTEGER  NOT NULL , commentsUid  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )';
      stmtList.add_11rb$(element_70);
      var element_71 = 'ALTER TABLE Clazz ADD COLUMN clazzEnrolmentPolicy INTEGER NOT NULL DEFAULT 102 ';
      stmtList.add_11rb$(element_71);
      var element_72 = 'ALTER TABLE Clazz ADD COLUMN clazzTerminologyUid INTEGER NOT NULL DEFAULT 25966';
      stmtList.add_11rb$(element_72);
      var element_73 = 'ALTER TABLE XObjectEntity ADD COLUMN objectStatementRefUid INTEGER NOT NULL DEFAULT 0';
      stmtList.add_11rb$(element_73);
      var element_74 = ' CREATE TRIGGER ch_ins_127 AFTER INSERT ON Chat BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 127 AS chTableId, NEW.chatUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 127 AND chEntityPk = NEW.chatUid); END ';
      stmtList.add_11rb$(element_74);
      var element_75 = ' CREATE TRIGGER ch_upd_127 AFTER UPDATE ON Chat BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 127 AS chTableId, NEW.chatUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 127 AND chEntityPk = NEW.chatUid); END ';
      stmtList.add_11rb$(element_75);
      var element_76 = ' CREATE TRIGGER ch_del_127 AFTER DELETE ON Chat BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 127 AS chTableId, OLD.chatUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 127 AND chEntityPk = OLD.chatUid); END ';
      stmtList.add_11rb$(element_76);
      var element_77 = 'CREATE VIEW Chat_ReceiveView AS  SELECT Chat.*, ChatReplicate.* FROM Chat LEFT JOIN ChatReplicate ON ChatReplicate.chatPk = Chat.chatUid ';
      stmtList.add_11rb$(element_77);
      var element_78 = ' CREATE TRIGGER chat_remote_insert_ins INSTEAD OF INSERT ON Chat_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Chat(chatUid, chatStartDate, chatTitle, chatGroup, chatLct) VALUES(NEW.chatUid, NEW.chatStartDate, NEW.chatTitle, NEW.chatGroup, NEW.chatLct) /*psql ON CONFLICT (chatUid) DO UPDATE SET chatStartDate = EXCLUDED.chatStartDate, chatTitle = EXCLUDED.chatTitle, chatGroup = EXCLUDED.chatGroup, chatLct = EXCLUDED.chatLct */ ; END ';
      stmtList.add_11rb$(element_78);
      var element_79 = ' CREATE TRIGGER ch_ins_128 AFTER INSERT ON ChatMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 128 AS chTableId, NEW.chatMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 128 AND chEntityPk = NEW.chatMemberUid); END ';
      stmtList.add_11rb$(element_79);
      var element_80 = ' CREATE TRIGGER ch_upd_128 AFTER UPDATE ON ChatMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 128 AS chTableId, NEW.chatMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 128 AND chEntityPk = NEW.chatMemberUid); END ';
      stmtList.add_11rb$(element_80);
      var element_81 = ' CREATE TRIGGER ch_del_128 AFTER DELETE ON ChatMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 128 AS chTableId, OLD.chatMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 128 AND chEntityPk = OLD.chatMemberUid); END ';
      stmtList.add_11rb$(element_81);
      var element_82 = 'CREATE VIEW ChatMember_ReceiveView AS  SELECT ChatMember.*, ChatMemberReplicate.* FROM ChatMember LEFT JOIN ChatMemberReplicate ON ChatMemberReplicate.chatMemberPk = ChatMember.chatMemberUid ';
      stmtList.add_11rb$(element_82);
      var element_83 = ' CREATE TRIGGER chatmember_remote_insert_ins INSTEAD OF INSERT ON ChatMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ChatMember(chatMemberUid, chatMemberChatUid, chatMemberPersonUid, chatMemberJoinedDate, chatMemberLeftDate, chatMemberLct) VALUES(NEW.chatMemberUid, NEW.chatMemberChatUid, NEW.chatMemberPersonUid, NEW.chatMemberJoinedDate, NEW.chatMemberLeftDate, NEW.chatMemberLct) /*psql ON CONFLICT (chatMemberUid) DO UPDATE SET chatMemberChatUid = EXCLUDED.chatMemberChatUid, chatMemberPersonUid = EXCLUDED.chatMemberPersonUid, chatMemberJoinedDate = EXCLUDED.chatMemberJoinedDate, chatMemberLeftDate = EXCLUDED.chatMemberLeftDate, chatMemberLct = EXCLUDED.chatMemberLct */ ; END ';
      stmtList.add_11rb$(element_83);
      var element_84 = ' CREATE TRIGGER ch_ins_523 AFTER INSERT ON CourseAssignmentMark BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 523 AS chTableId, NEW.camUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 523 AND chEntityPk = NEW.camUid); END ';
      stmtList.add_11rb$(element_84);
      var element_85 = ' CREATE TRIGGER ch_upd_523 AFTER UPDATE ON CourseAssignmentMark BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 523 AS chTableId, NEW.camUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 523 AND chEntityPk = NEW.camUid); END ';
      stmtList.add_11rb$(element_85);
      var element_86 = ' CREATE TRIGGER ch_del_523 AFTER DELETE ON CourseAssignmentMark BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 523 AS chTableId, OLD.camUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 523 AND chEntityPk = OLD.camUid); END ';
      stmtList.add_11rb$(element_86);
      var element_87 = 'CREATE VIEW CourseAssignmentMark_ReceiveView AS  SELECT CourseAssignmentMark.*, CourseAssignmentMarkReplicate.* FROM CourseAssignmentMark LEFT JOIN CourseAssignmentMarkReplicate ON CourseAssignmentMarkReplicate.camPk = CourseAssignmentMark.camUid ';
      stmtList.add_11rb$(element_87);
      var element_88 = ' CREATE TRIGGER courseassignmentmark_remote_insert_ins INSTEAD OF INSERT ON CourseAssignmentMark_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseAssignmentMark(camUid, camAssignmentUid, camSubmitterUid, camMark, camPenalty, camLct) VALUES (NEW.camUid, NEW.camAssignmentUid, NEW.camSubmitterUid, NEW.camMark, NEW.camPenalty, NEW.camLct) /*psql ON CONFLICT (camUid) DO UPDATE SET camAssignmentUid = EXCLUDED.camAssignmentUid, camSubmitterUid = EXCLUDED.camSubmitterUid, camMark = EXCLUDED.camMark, camPenalty = EXCLUDED.camPenalty, camLct = EXCLUDED.camLct */; END ';
      stmtList.add_11rb$(element_88);
      var element_89 = ' CREATE TRIGGER ch_ins_522 AFTER INSERT ON CourseAssignmentSubmission BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 522 AS chTableId, NEW.casUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 522 AND chEntityPk = NEW.casUid); END ';
      stmtList.add_11rb$(element_89);
      var element_90 = ' CREATE TRIGGER ch_upd_522 AFTER UPDATE ON CourseAssignmentSubmission BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 522 AS chTableId, NEW.casUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 522 AND chEntityPk = NEW.casUid); END ';
      stmtList.add_11rb$(element_90);
      var element_91 = ' CREATE TRIGGER ch_del_522 AFTER DELETE ON CourseAssignmentSubmission BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 522 AS chTableId, OLD.casUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 522 AND chEntityPk = OLD.casUid); END ';
      stmtList.add_11rb$(element_91);
      var element_92 = 'CREATE VIEW CourseAssignmentSubmission_ReceiveView AS  SELECT CourseAssignmentSubmission.*, CourseAssignmentSubmissionReplicate.* FROM CourseAssignmentSubmission LEFT JOIN CourseAssignmentSubmissionReplicate ON CourseAssignmentSubmissionReplicate.casPk = CourseAssignmentSubmission.casUid ';
      stmtList.add_11rb$(element_92);
      var element_93 = ' CREATE TRIGGER courseassignmentsubmission_remote_insert_ins INSTEAD OF INSERT ON CourseAssignmentSubmission_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseAssignmentSubmission(casUid, casAssignmentUid, casSubmitterUid, casSubmitterPersonUid, casText, casType, casTimestamp) VALUES (NEW.casUid, NEW.casAssignmentUid, NEW.casSubmitterUid, NEW.casSubmitterPersonUid, NEW.casText, NEW.casType, NEW.casTimestamp) /*psql ON CONFLICT (casUid) DO UPDATE SET casAssignmentUid = EXCLUDED.casAssignmentUid, casSubmitterUid = EXCLUDED.casSubmitterUid, casSubmitterPersonUid = EXCLUDED.casSubmitterPersonUid, casText = EXCLUDED.casText, casType = EXCLUDED.casType, casTimestamp = EXCLUDED.casTimestamp */; END ';
      stmtList.add_11rb$(element_93);
      var element_94 = ' CREATE TRIGGER ch_ins_90 AFTER INSERT ON CourseAssignmentSubmissionAttachment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 90 AS chTableId, NEW.casaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 90 AND chEntityPk = NEW.casaUid); END ';
      stmtList.add_11rb$(element_94);
      var element_95 = ' CREATE TRIGGER ch_upd_90 AFTER UPDATE ON CourseAssignmentSubmissionAttachment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 90 AS chTableId, NEW.casaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 90 AND chEntityPk = NEW.casaUid); END ';
      stmtList.add_11rb$(element_95);
      var element_96 = ' CREATE TRIGGER ch_del_90 AFTER DELETE ON CourseAssignmentSubmissionAttachment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 90 AS chTableId, OLD.casaUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 90 AND chEntityPk = OLD.casaUid); END ';
      stmtList.add_11rb$(element_96);
      var element_97 = 'CREATE VIEW CourseAssignmentSubmissionAttachment_ReceiveView AS  SELECT CourseAssignmentSubmissionAttachment.*, CourseAssignmentSubmissionAttachmentReplicate.* FROM CourseAssignmentSubmissionAttachment LEFT JOIN CourseAssignmentSubmissionAttachmentReplicate ON CourseAssignmentSubmissionAttachmentReplicate.casaPk = CourseAssignmentSubmissionAttachment.casaUid ';
      stmtList.add_11rb$(element_97);
      var element_98 = ' CREATE TRIGGER courseassignmentsubmissionattachment_remote_insert_ins INSTEAD OF INSERT ON CourseAssignmentSubmissionAttachment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseAssignmentSubmissionAttachment(casaUid, casaSubmissionUid, casaMimeType, casaUri, casaMd5, casaSize, casaTimestamp) VALUES (NEW.casaUid, NEW.casaSubmissionUid, NEW.casaMimeType, NEW.casaUri, NEW.casaMd5, NEW.casaSize, NEW.casaTimestamp) /*psql ON CONFLICT (casaUid) DO UPDATE SET casaSubmissionUid = EXCLUDED.casaSubmissionUid, casaMimeType = EXCLUDED.casaMimeType, casaUri = EXCLUDED.casaUri, casaMd5 = EXCLUDED.casaMd5, casaSize = EXCLUDED.casaSize, casaTimestamp = EXCLUDED.casaTimestamp */; END ';
      stmtList.add_11rb$(element_98);
      var element_99 = trimMargin('\n        |\n        |        CREATE TRIGGER ATTUPD_CourseAssignmentSubmissionAttachment\n        |        AFTER UPDATE ON CourseAssignmentSubmissionAttachment FOR EACH ROW WHEN\n        |        OLD.casaMd5 IS NOT NULL\n        |        BEGIN\n        |        \n        |        INSERT INTO ZombieAttachmentData(zaUri) \n        |        SELECT OLD.casaUri AS zaUri\n        |          FROM CourseAssignmentSubmissionAttachment   \n        |         WHERE CourseAssignmentSubmissionAttachment.casaUid = OLD.casaUid\n        |           AND (SELECT COUNT(*) \n        |                  FROM CourseAssignmentSubmissionAttachment\n        |                 WHERE casaMd5 = OLD.casaMd5) = 0\n        |    ; \n        |        END\n        |    \n        ');
      stmtList.add_11rb$(element_99);
      var element_100 = ' CREATE TRIGGER ch_ins_124 AFTER INSERT ON CourseBlock BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 124 AS chTableId, NEW.cbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 124 AND chEntityPk = NEW.cbUid); END ';
      stmtList.add_11rb$(element_100);
      var element_101 = ' CREATE TRIGGER ch_upd_124 AFTER UPDATE ON CourseBlock BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 124 AS chTableId, NEW.cbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 124 AND chEntityPk = NEW.cbUid); END ';
      stmtList.add_11rb$(element_101);
      var element_102 = ' CREATE TRIGGER ch_del_124 AFTER DELETE ON CourseBlock BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 124 AS chTableId, OLD.cbUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 124 AND chEntityPk = OLD.cbUid); END ';
      stmtList.add_11rb$(element_102);
      var element_103 = 'CREATE VIEW CourseBlock_ReceiveView AS  SELECT CourseBlock.*, CourseBlockReplicate.* FROM CourseBlock LEFT JOIN CourseBlockReplicate ON CourseBlockReplicate.cbPk = CourseBlock.cbUid ';
      stmtList.add_11rb$(element_103);
      var element_104 = ' CREATE TRIGGER courseblock_remote_insert_ins INSTEAD OF INSERT ON CourseBlock_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseBlock(cbUid, cbType, cbIndentLevel, cbModuleParentBlockUid, cbTitle, cbDescription, cbCompletionCriteria, cbHideUntilDate, cbDeadlineDate, cbLateSubmissionPenalty, cbGracePeriodDate, cbMaxPoints,cbMinPoints, cbIndex, cbClazzUid, cbActive,cbHidden, cbEntityUid, cbLct) VALUES (NEW.cbUid, NEW.cbType, NEW.cbIndentLevel, NEW.cbModuleParentBlockUid, NEW.cbTitle, NEW.cbDescription, NEW.cbCompletionCriteria, NEW.cbHideUntilDate, NEW.cbDeadlineDate, NEW.cbLateSubmissionPenalty, NEW.cbGracePeriodDate, NEW.cbMaxPoints,NEW.cbMinPoints, NEW.cbIndex, NEW.cbClazzUid,NEW.cbActive, NEW.cbHidden, NEW.cbEntityUid, NEW.cbLct) /*psql ON CONFLICT (cbUid) DO UPDATE SET cbType = EXCLUDED.cbType, cbIndentLevel = EXCLUDED.cbIndentLevel, cbModuleParentBlockUid = EXCLUDED.cbModuleParentBlockUid, cbTitle = EXCLUDED.cbTitle, cbDescription = EXCLUDED.cbDescription, cbCompletionCriteria = EXCLUDED.cbCompletionCriteria, cbHideUntilDate = EXCLUDED.cbHideUntilDate,cbDeadlineDate = EXCLUDED.cbDeadlineDate, cbLateSubmissionPenalty = EXCLUDED.cbLateSubmissionPenalty, cbGracePeriodDate= EXCLUDED.cbGracePeriodDate, cbMaxPoints = EXCLUDED.cbMaxPoints, cbMinPoints = EXCLUDED.cbMinPoints, cbIndex = EXCLUDED.cbIndex,cbClazzUid = EXCLUDED.cbClazzUid, cbActive = EXCLUDED.cbActive, cbHidden = EXCLUDED.cbHidden, cbEntityUid = EXCLUDED.cbEntityUid, cbLct = EXCLUDED.cbLct */; END ';
      stmtList.add_11rb$(element_104);
      var element_105 = ' CREATE TRIGGER ch_ins_130 AFTER INSERT ON CourseDiscussion BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 130 AS chTableId, NEW.courseDiscussionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 130 AND chEntityPk = NEW.courseDiscussionUid); END ';
      stmtList.add_11rb$(element_105);
      var element_106 = ' CREATE TRIGGER ch_upd_130 AFTER UPDATE ON CourseDiscussion BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 130 AS chTableId, NEW.courseDiscussionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 130 AND chEntityPk = NEW.courseDiscussionUid); END ';
      stmtList.add_11rb$(element_106);
      var element_107 = ' CREATE TRIGGER ch_del_130 AFTER DELETE ON CourseDiscussion BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 130 AS chTableId, OLD.courseDiscussionUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 130 AND chEntityPk = OLD.courseDiscussionUid); END ';
      stmtList.add_11rb$(element_107);
      var element_108 = 'CREATE VIEW CourseDiscussion_ReceiveView AS  SELECT CourseDiscussion.*, CourseDiscussionReplicate.* FROM CourseDiscussion LEFT JOIN CourseDiscussionReplicate ON CourseDiscussionReplicate.courseDiscussionPk = CourseDiscussion.courseDiscussionUid ';
      stmtList.add_11rb$(element_108);
      var element_109 = ' CREATE TRIGGER coursediscussion_remote_insert_ins INSTEAD OF INSERT ON CourseDiscussion_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseDiscussion(courseDiscussionUid, courseDiscussionActive, courseDiscussionTitle, courseDiscussionDesc, courseDiscussionClazzUid, courseDiscussionLct) VALUES(NEW.courseDiscussionUid, NEW.courseDiscussionActive, NEW.courseDiscussionTitle, NEW.courseDiscussionDesc, NEW.courseDiscussionClazzUid, NEW.courseDiscussionLct) /*psql ON CONFLICT (courseDiscussionUid) DO UPDATE SET courseDiscussionActive = EXCLUDED.courseDiscussionActive, courseDiscussionTitle = EXCLUDED.courseDiscussionTitle, courseDiscussionDesc = EXCLUDED.courseDiscussionDesc, courseDiscussionClazzUid = EXCLUDED.courseDiscussionClazzUid, courseDiscussionLct = EXCLUDED.courseDiscussionLct */ ; END ';
      stmtList.add_11rb$(element_109);
      var element_110 = ' CREATE TRIGGER ch_ins_243 AFTER INSERT ON CourseGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 243 AS chTableId, NEW.cgmUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 243 AND chEntityPk = NEW.cgmUid); END ';
      stmtList.add_11rb$(element_110);
      var element_111 = ' CREATE TRIGGER ch_upd_243 AFTER UPDATE ON CourseGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 243 AS chTableId, NEW.cgmUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 243 AND chEntityPk = NEW.cgmUid); END ';
      stmtList.add_11rb$(element_111);
      var element_112 = ' CREATE TRIGGER ch_del_243 AFTER DELETE ON CourseGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 243 AS chTableId, OLD.cgmUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 243 AND chEntityPk = OLD.cgmUid); END ';
      stmtList.add_11rb$(element_112);
      var element_113 = 'CREATE VIEW CourseGroupMember_ReceiveView AS  SELECT CourseGroupMember.*, CourseGroupMemberReplicate.* FROM CourseGroupMember LEFT JOIN CourseGroupMemberReplicate ON CourseGroupMemberReplicate.cgmPk = CourseGroupMember.cgmUid ';
      stmtList.add_11rb$(element_113);
      var element_114 = ' CREATE TRIGGER coursegroupmember_remote_insert_ins INSTEAD OF INSERT ON CourseGroupMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseGroupMember(cgmUid, cgmSetUid, cgmGroupNumber, cgmPersonUid, cgmLct) VALUES (NEW.cgmUid, NEW.cgmSetUid, NEW.cgmGroupNumber, NEW.cgmPersonUid, NEW.cgmLct) /*psql ON CONFLICT (cgmUid) DO UPDATE SET cgmSetUid = EXCLUDED.cgmSetUid, cgmGroupNumber = EXCLUDED.cgmGroupNumber, cgmPersonUid = EXCLUDED.cgmPersonUid, cgmLct = EXCLUDED.cgmLct */; END ';
      stmtList.add_11rb$(element_114);
      var element_115 = ' CREATE TRIGGER ch_ins_242 AFTER INSERT ON CourseGroupSet BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 242 AS chTableId, NEW.cgsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 242 AND chEntityPk = NEW.cgsUid); END ';
      stmtList.add_11rb$(element_115);
      var element_116 = ' CREATE TRIGGER ch_upd_242 AFTER UPDATE ON CourseGroupSet BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 242 AS chTableId, NEW.cgsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 242 AND chEntityPk = NEW.cgsUid); END ';
      stmtList.add_11rb$(element_116);
      var element_117 = ' CREATE TRIGGER ch_del_242 AFTER DELETE ON CourseGroupSet BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 242 AS chTableId, OLD.cgsUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 242 AND chEntityPk = OLD.cgsUid); END ';
      stmtList.add_11rb$(element_117);
      var element_118 = 'CREATE VIEW CourseGroupSet_ReceiveView AS  SELECT CourseGroupSet.*, CourseGroupSetReplicate.* FROM CourseGroupSet LEFT JOIN CourseGroupSetReplicate ON CourseGroupSetReplicate.cgsPk = CourseGroupSet.cgsUid ';
      stmtList.add_11rb$(element_118);
      var element_119 = ' CREATE TRIGGER coursegroupset_remote_insert_ins INSTEAD OF INSERT ON CourseGroupSet_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseGroupSet(cgsUid, cgsName, cgsTotalGroups, cgsActive, cgsClazzUid, cgsLct) VALUES (NEW.cgsUid, NEW.cgsName, NEW.cgsTotalGroups, NEW.cgsActive, NEW.cgsClazzUid, NEW.cgsLct) /*psql ON CONFLICT (cgsUid) DO UPDATE SET cgsName = EXCLUDED.cgsName, cgsTotalGroups = EXCLUDED.cgsTotalGroups, cgsActive = EXCLUDED.cgsActive, cgsClazzUid = EXCLUDED.cgsClazzUid, cgsLct = EXCLUDED.cgsLct */; END ';
      stmtList.add_11rb$(element_119);
      var element_120 = ' CREATE TRIGGER ch_ins_125 AFTER INSERT ON CoursePicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 125 AS chTableId, NEW.coursePictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 125 AND chEntityPk = NEW.coursePictureUid); END ';
      stmtList.add_11rb$(element_120);
      var element_121 = ' CREATE TRIGGER ch_upd_125 AFTER UPDATE ON CoursePicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 125 AS chTableId, NEW.coursePictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 125 AND chEntityPk = NEW.coursePictureUid); END ';
      stmtList.add_11rb$(element_121);
      var element_122 = ' CREATE TRIGGER ch_del_125 AFTER DELETE ON CoursePicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 125 AS chTableId, OLD.coursePictureUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 125 AND chEntityPk = OLD.coursePictureUid); END ';
      stmtList.add_11rb$(element_122);
      var element_123 = 'CREATE VIEW CoursePicture_ReceiveView AS  SELECT CoursePicture.*, CoursePictureReplicate.* FROM CoursePicture LEFT JOIN CoursePictureReplicate ON CoursePictureReplicate.cpPk = CoursePicture.coursePictureUid ';
      stmtList.add_11rb$(element_123);
      var element_124 = ' CREATE TRIGGER coursepicture_remote_insert_ins INSTEAD OF INSERT ON CoursePicture_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CoursePicture(coursePictureUid, coursePictureClazzUid, coursePictureMasterCsn, coursePictureLocalCsn, coursePictureLastChangedBy, coursePictureLct, coursePictureUri, coursePictureMd5, coursePictureFileSize, coursePictureTimestamp, coursePictureMimeType, coursePictureActive) VALUES (NEW.coursePictureUid, NEW.coursePictureClazzUid, NEW.coursePictureMasterCsn, NEW.coursePictureLocalCsn, NEW.coursePictureLastChangedBy, NEW.coursePictureLct, NEW.coursePictureUri, NEW.coursePictureMd5, NEW.coursePictureFileSize, NEW.coursePictureTimestamp, NEW.coursePictureMimeType, NEW.coursePictureActive) /*psql ON CONFLICT (coursePictureUid) DO UPDATE SET coursePictureClazzUid = EXCLUDED.coursePictureClazzUid, coursePictureMasterCsn = EXCLUDED.coursePictureMasterCsn, coursePictureLocalCsn = EXCLUDED.coursePictureLocalCsn, coursePictureLastChangedBy = EXCLUDED.coursePictureLastChangedBy, coursePictureLct = EXCLUDED.coursePictureLct, coursePictureUri = EXCLUDED.coursePictureUri, coursePictureMd5 = EXCLUDED.coursePictureMd5, coursePictureFileSize = EXCLUDED.coursePictureFileSize, coursePictureTimestamp = EXCLUDED.coursePictureTimestamp, coursePictureMimeType = EXCLUDED.coursePictureMimeType, coursePictureActive = EXCLUDED.coursePictureActive */; END ';
      stmtList.add_11rb$(element_124);
      var element_125 = trimMargin('\n        |\n        |        CREATE TRIGGER ATTUPD_CoursePicture\n        |        AFTER UPDATE ON CoursePicture FOR EACH ROW WHEN\n        |        OLD.coursePictureMd5 IS NOT NULL\n        |        BEGIN\n        |        \n        |        INSERT INTO ZombieAttachmentData(zaUri) \n        |        SELECT OLD.coursePictureUri AS zaUri\n        |          FROM CoursePicture   \n        |         WHERE CoursePicture.coursePictureUid = OLD.coursePictureUid\n        |           AND (SELECT COUNT(*) \n        |                  FROM CoursePicture\n        |                 WHERE coursePictureMd5 = OLD.coursePictureMd5) = 0\n        |    ; \n        |        END\n        |    \n        ');
      stmtList.add_11rb$(element_125);
      var element_126 = ' CREATE TRIGGER ch_ins_450 AFTER INSERT ON CourseTerminology BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 450 AS chTableId, NEW.ctUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 450 AND chEntityPk = NEW.ctUid); END ';
      stmtList.add_11rb$(element_126);
      var element_127 = ' CREATE TRIGGER ch_upd_450 AFTER UPDATE ON CourseTerminology BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 450 AS chTableId, NEW.ctUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 450 AND chEntityPk = NEW.ctUid); END ';
      stmtList.add_11rb$(element_127);
      var element_128 = ' CREATE TRIGGER ch_del_450 AFTER DELETE ON CourseTerminology BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 450 AS chTableId, OLD.ctUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 450 AND chEntityPk = OLD.ctUid); END ';
      stmtList.add_11rb$(element_128);
      var element_129 = 'CREATE VIEW CourseTerminology_ReceiveView AS  SELECT CourseTerminology.*, CourseTerminologyReplicate.* FROM CourseTerminology LEFT JOIN CourseTerminologyReplicate ON CourseTerminologyReplicate.ctPk = CourseTerminology.ctUid ';
      stmtList.add_11rb$(element_129);
      var element_130 = ' CREATE TRIGGER courseterminology_remote_insert_ins INSTEAD OF INSERT ON CourseTerminology_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseTerminology(ctUid, ctTitle, ctTerminology, ctLct) VALUES (NEW.ctUid, NEW.ctTitle, NEW.ctTerminology, NEW.ctLct) /*psql ON CONFLICT (ctUid) DO UPDATE SET ctTitle = EXCLUDED.ctTitle, ctTerminology = EXCLUDED.ctTerminology, ctLct = EXCLUDED.ctLct */; END ';
      stmtList.add_11rb$(element_130);
      var element_131 = ' CREATE TRIGGER ch_ins_132 AFTER INSERT ON DiscussionPost BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 132 AS chTableId, NEW.discussionPostUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 132 AND chEntityPk = NEW.discussionPostUid); END ';
      stmtList.add_11rb$(element_131);
      var element_132 = ' CREATE TRIGGER ch_upd_132 AFTER UPDATE ON DiscussionPost BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 132 AS chTableId, NEW.discussionPostUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 132 AND chEntityPk = NEW.discussionPostUid); END ';
      stmtList.add_11rb$(element_132);
      var element_133 = ' CREATE TRIGGER ch_del_132 AFTER DELETE ON DiscussionPost BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 132 AS chTableId, OLD.discussionPostUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 132 AND chEntityPk = OLD.discussionPostUid); END ';
      stmtList.add_11rb$(element_133);
      var element_134 = 'CREATE VIEW DiscussionPost_ReceiveView AS  SELECT DiscussionPost.*, DiscussionPostReplicate.* FROM DiscussionPost LEFT JOIN DiscussionPostReplicate ON DiscussionPostReplicate.discussionPostPk = DiscussionPost.discussionPostUid ';
      stmtList.add_11rb$(element_134);
      var element_135 = ' CREATE TRIGGER discussionpost_remote_insert_ins INSTEAD OF INSERT ON DiscussionPost_ReceiveView FOR EACH ROW BEGIN REPLACE INTO DiscussionPost(discussionPostUid, discussionPostTitle, discussionPostMessage, discussionPostStartDate, discussionPostDiscussionTopicUid, discussionPostVisible, discussionPostArchive, discussionPostStartedPersonUid, discussionPostClazzUid, discussionPostLct) VALUES(NEW.discussionPostUid, NEW.discussionPostTitle, NEW.discussionPostMessage, NEW.discussionPostStartDate, NEW.discussionPostDiscussionTopicUid, NEW.discussionPostVisible, NEW.discussionPostArchive, NEW.discussionPostStartedPersonUid, NEW.discussionPostClazzUid, NEW.discussionPostLct) /*psql ON CONFLICT (discussionPostUid) DO UPDATE SET discussionPostTitle = EXCLUDED.discussionPostTitle , discussionPostMessage = EXCLUDED.discussionPostMessage , discussionPostStartDate = EXCLUDED.discussionPostStartDate , discussionPostDiscussionTopicUid = EXCLUDED.discussionPostDiscussionTopicUid, discussionPostVisible = EXCLUDED.discussionPostVisible , discussionPostArchive = EXCLUDED.discussionPostArchive , discussionPostStartedPersonUid = EXCLUDED.discussionPostStartedPersonUid , discussionPostClazzUid = EXCLUDED.discussionPostClazzUid, discussionPostLct = EXCLUDED.discussionPostLct */ ; END ';
      stmtList.add_11rb$(element_135);
      var element_136 = ' CREATE TRIGGER ch_ins_131 AFTER INSERT ON DiscussionTopic BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 131 AS chTableId, NEW.discussionTopicUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 131 AND chEntityPk = NEW.discussionTopicUid); END ';
      stmtList.add_11rb$(element_136);
      var element_137 = ' CREATE TRIGGER ch_upd_131 AFTER UPDATE ON DiscussionTopic BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 131 AS chTableId, NEW.discussionTopicUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 131 AND chEntityPk = NEW.discussionTopicUid); END ';
      stmtList.add_11rb$(element_137);
      var element_138 = ' CREATE TRIGGER ch_del_131 AFTER DELETE ON DiscussionTopic BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 131 AS chTableId, OLD.discussionTopicUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 131 AND chEntityPk = OLD.discussionTopicUid); END ';
      stmtList.add_11rb$(element_138);
      var element_139 = 'CREATE VIEW DiscussionTopic_ReceiveView AS  SELECT DiscussionTopic.*, DiscussionTopicReplicate.* FROM DiscussionTopic LEFT JOIN DiscussionTopicReplicate ON DiscussionTopicReplicate.discussionTopicPk = DiscussionTopic.discussionTopicUid ';
      stmtList.add_11rb$(element_139);
      var element_140 = ' CREATE TRIGGER discussiontopic_remote_insert_ins INSTEAD OF INSERT ON DiscussionTopic_ReceiveView FOR EACH ROW BEGIN REPLACE INTO DiscussionTopic(discussionTopicUid, discussionTopicTitle, discussionTopicDesc, discussionTopicStartDate, discussionTopicCourseDiscussionUid, discussionTopicVisible, discussionTopicArchive, discussionTopicIndex, discussionTopicClazzUid, discussionTopicLct) VALUES(NEW.discussionTopicUid, NEW.discussionTopicTitle, NEW.discussionTopicDesc, NEW.discussionTopicStartDate, NEW.discussionTopicCourseDiscussionUid, NEW.discussionTopicVisible, NEW.discussionTopicArchive, NEW.discussionTopicIndex, NEW.discussionTopicClazzUid, NEW.discussionTopicLct) /*psql ON CONFLICT (discussionTopicUid) DO UPDATE SET discussionTopicTitle = EXCLUDED.discussionTopicTitle, discussionTopicDesc = EXCLUDED.discussionTopicDesc, discussionTopicStartDate = EXCLUDED.discussionTopicStartDate, discussionTopicCourseDiscussionUid = EXCLUDED.discussionTopicCourseDiscussionUid, discussionTopicVisible = EXCLUDED.discussionTopicVisible, discussionTopicArchive = EXCLUDED.discussionTopicArchive, discussionTopicIndex = EXCLUDED.discussionTopicIndex, discussionTopicClazzUid = EXCLUDED.discussionTopicClazzUid, discussionTopicLct = EXCLUDED.discussionTopicLct */ ; END ';
      stmtList.add_11rb$(element_140);
      var element_141 = ' CREATE TRIGGER ch_ins_126 AFTER INSERT ON Message BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 126 AS chTableId, NEW.messageUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 126 AND chEntityPk = NEW.messageUid); END ';
      stmtList.add_11rb$(element_141);
      var element_142 = ' CREATE TRIGGER ch_upd_126 AFTER UPDATE ON Message BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 126 AS chTableId, NEW.messageUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 126 AND chEntityPk = NEW.messageUid); END ';
      stmtList.add_11rb$(element_142);
      var element_143 = ' CREATE TRIGGER ch_del_126 AFTER DELETE ON Message BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 126 AS chTableId, OLD.messageUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 126 AND chEntityPk = OLD.messageUid); END ';
      stmtList.add_11rb$(element_143);
      var element_144 = 'CREATE VIEW Message_ReceiveView AS  SELECT Message.*, MessageReplicate.* FROM Message LEFT JOIN MessageReplicate ON MessageReplicate.messagePk = Message.messageUid ';
      stmtList.add_11rb$(element_144);
      var element_145 = ' CREATE TRIGGER message_remote_insert_ins INSTEAD OF INSERT ON Message_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Message(messageUid, messageSenderPersonUid, messageTableId, messageEntityUid, messageText, messageTimestamp, messageClazzUid, messageLct) VALUES(NEW.messageUid, NEW.messageSenderPersonUid, NEW.messageTableId, NEW.messageEntityUid, NEW.messageText, NEW.messageTimestamp, NEW.messageClazzUid, NEW.messageLct) /*psql ON CONFLICT (messageUid) DO UPDATE SET messageSenderPersonUid = EXCLUDED.messageSenderPersonUid, messageTableId = EXCLUDED.messageTableId, messageEntityUid = EXCLUDED.messageEntityUid, messageText = EXCLUDED.messageText, messageTimestamp = EXCLUDED.messageTimestamp, messageClazzUid = EXCLUDED.messageClazzUid, messageLct = EXCLUDED.messageLct */ ; END ';
      stmtList.add_11rb$(element_145);
      var element_146 = ' CREATE TRIGGER ch_ins_129 AFTER INSERT ON MessageRead BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 129 AS chTableId, NEW.messageReadUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 129 AND chEntityPk = NEW.messageReadUid); END ';
      stmtList.add_11rb$(element_146);
      var element_147 = ' CREATE TRIGGER ch_upd_129 AFTER UPDATE ON MessageRead BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 129 AS chTableId, NEW.messageReadUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 129 AND chEntityPk = NEW.messageReadUid); END ';
      stmtList.add_11rb$(element_147);
      var element_148 = ' CREATE TRIGGER ch_del_129 AFTER DELETE ON MessageRead BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 129 AS chTableId, OLD.messageReadUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 129 AND chEntityPk = OLD.messageReadUid); END ';
      stmtList.add_11rb$(element_148);
      var element_149 = 'CREATE VIEW MessageRead_ReceiveView AS  SELECT MessageRead.*, MessageReadReplicate.* FROM MessageRead LEFT JOIN MessageReadReplicate ON MessageReadReplicate.messageReadPk = MessageRead.messageReadUid ';
      stmtList.add_11rb$(element_149);
      var element_150 = ' CREATE TRIGGER messageread_remote_insert_ins INSTEAD OF INSERT ON MessageRead_ReceiveView FOR EACH ROW BEGIN REPLACE INTO MessageRead(messageReadUid, messageReadPersonUid, messageReadMessageUid, messageReadEntityUid, messageReadLct) VALUES(NEW.messageReadUid, NEW.messageReadPersonUid, NEW.messageReadMessageUid, NEW.messageReadEntityUid, NEW.messageReadLct) /*psql ON CONFLICT (messageReadUid) DO UPDATE SET messageReadPersonUid = EXCLUDED.messageReadPersonUid, messageReadMessageUid = EXCLUDED.messageReadMessageUid, messageReadEntityUid = EXCLUDED.messageReadEntityUid, messageReadLct = EXCLUDED.messageReadLct */ ; END ';
      stmtList.add_11rb$(element_150);
      var element_151 = 'DROP VIEW IF EXISTS ClazzAssignment_ReceiveView';
      stmtList.add_11rb$(element_151);
      var element_152 = 'DROP TRIGGER IF EXISTS clazzassignment_remote_insert_ins';
      stmtList.add_11rb$(element_152);
      var element_153 = 'DROP TRIGGER IF EXISTS ch_ins_521';
      stmtList.add_11rb$(element_153);
      var element_154 = 'DROP TRIGGER IF EXISTS ch_upd_521';
      stmtList.add_11rb$(element_154);
      var element_155 = 'DROP TRIGGER IF EXISTS ch_del_521';
      stmtList.add_11rb$(element_155);
      var element_156 = 'CREATE VIEW ClazzAssignment_ReceiveView AS  SELECT ClazzAssignment.*, ClazzAssignmentReplicate.* FROM ClazzAssignment LEFT JOIN ClazzAssignmentReplicate ON ClazzAssignmentReplicate.caPk = ClazzAssignment.caUid ';
      stmtList.add_11rb$(element_156);
      var element_157 = ' CREATE TRIGGER clazzassignment_remote_insert_ins INSTEAD OF INSERT ON ClazzAssignment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzAssignment(caUid, caTitle, caDescription, caGroupUid, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caRequireFileSubmission, caFileType, caSizeLimit, caNumberOfFiles, caSubmissionPolicy, caMarkingType, caRequireTextSubmission, caTextLimitType, caTextLimit, caXObjectUid, caClazzUid, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES (NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caGroupUid, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caRequireFileSubmission, NEW.caFileType, NEW.caSizeLimit, NEW.caNumberOfFiles, NEW.caSubmissionPolicy, NEW.caMarkingType,NEW.caRequireTextSubmission, NEW.caTextLimitType, NEW.caTextLimit, NEW.caXObjectUid, NEW.caClazzUid, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) /*psql ON CONFLICT (caUid) DO UPDATE SET caTitle = EXCLUDED.caTitle, caDescription = EXCLUDED.caDescription, caGroupUid = EXCLUDED.caGroupUid, caActive = EXCLUDED.caActive, caClassCommentEnabled = EXCLUDED.caClassCommentEnabled, caPrivateCommentsEnabled = EXCLUDED.caPrivateCommentsEnabled, caRequireFileSubmission = EXCLUDED.caRequireFileSubmission, caFileType = EXCLUDED.caFileType, caSizeLimit = EXCLUDED.caSizeLimit, caNumberOfFiles = EXCLUDED.caNumberOfFiles, caSubmissionPolicy = EXCLUDED.caSubmissionPolicy, caMarkingType = EXCLUDED.caMarkingType, caRequireTextSubmission = EXCLUDED.caRequireTextSubmission, caTextLimitType = EXCLUDED.caTextLimitType, caTextLimit = EXCLUDED.caTextLimit, caXObjectUid = EXCLUDED.caXObjectUid, caClazzUid = EXCLUDED.caClazzUid, caLocalChangeSeqNum = EXCLUDED.caLocalChangeSeqNum, caMasterChangeSeqNum = EXCLUDED.caMasterChangeSeqNum, caLastChangedBy = EXCLUDED.caLastChangedBy, caLct = EXCLUDED.caLct */; END ';
      stmtList.add_11rb$(element_157);
      var element_158 = ' CREATE TRIGGER ch_ins_521 AFTER INSERT ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, NEW.cacjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = NEW.cacjUid); END ';
      stmtList.add_11rb$(element_158);
      var element_159 = ' CREATE TRIGGER ch_upd_521 AFTER UPDATE ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, NEW.cacjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = NEW.cacjUid); END ';
      stmtList.add_11rb$(element_159);
      var element_160 = ' CREATE TRIGGER ch_del_521 AFTER DELETE ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, OLD.cacjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = OLD.cacjUid); END ';
      stmtList.add_11rb$(element_160);
      var element_161 = 'DROP VIEW IF EXISTS ClazzAssignmentContentJoin_ReceiveView';
      stmtList.add_11rb$(element_161);
      var element_162 = 'DROP TRIGGER IF EXISTS clazzassignmentcontentjoin_remote_insert_ins';
      stmtList.add_11rb$(element_162);
      var element_163 = 'DROP TRIGGER IF EXISTS ch_ins_522';
      stmtList.add_11rb$(element_163);
      var element_164 = 'DROP TRIGGER IF EXISTS ch_upd_522';
      stmtList.add_11rb$(element_164);
      var element_165 = 'DROP TRIGGER IF EXISTS ch_del_522';
      stmtList.add_11rb$(element_165);
      var element_166 = 'DROP VIEW IF EXISTS Comments_ReceiveView';
      stmtList.add_11rb$(element_166);
      var element_167 = 'DROP TRIGGER IF EXISTS comments_remote_insert_ins';
      stmtList.add_11rb$(element_167);
      var element_168 = 'DROP TRIGGER IF EXISTS ch_ins_101';
      stmtList.add_11rb$(element_168);
      var element_169 = 'DROP TRIGGER IF EXISTS ch_upd_101';
      stmtList.add_11rb$(element_169);
      var element_170 = 'DROP TRIGGER IF EXISTS ch_del_101';
      stmtList.add_11rb$(element_170);
      var element_171 = 'CREATE VIEW Comments_ReceiveView AS  SELECT Comments.*, CommentsReplicate.* FROM Comments LEFT JOIN CommentsReplicate ON CommentsReplicate.commentsPk = Comments.commentsUid ';
      stmtList.add_11rb$(element_171);
      var element_172 = ' CREATE TRIGGER comments_remote_insert_ins INSTEAD OF INSERT ON Comments_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Comments(commentsUid, commentsText, commentsEntityType, commentsEntityUid, commentsPublic, commentsStatus, commentsPersonUid, commentsToPersonUid, commentSubmitterUid, commentsFlagged, commentsInActive, commentsDateTimeAdded, commentsDateTimeUpdated, commentsMCSN, commentsLCSN, commentsLCB, commentsLct) VALUES (NEW.commentsUid, NEW.commentsText, NEW.commentsEntityType, NEW.commentsEntityUid, NEW.commentsPublic, NEW.commentsStatus, NEW.commentsPersonUid, NEW.commentsToPersonUid, NEW.commentSubmitterUid, NEW.commentsFlagged, NEW.commentsInActive, NEW.commentsDateTimeAdded, NEW.commentsDateTimeUpdated, NEW.commentsMCSN, NEW.commentsLCSN, NEW.commentsLCB, NEW.commentsLct) /*psql ON CONFLICT (commentsUid) DO UPDATE SET commentsText = EXCLUDED.commentsText, commentsEntityType = EXCLUDED.commentsEntityType, commentsEntityUid = EXCLUDED.commentsEntityUid, commentsPublic = EXCLUDED.commentsPublic, commentsStatus = EXCLUDED.commentsStatus, commentsPersonUid = EXCLUDED.commentsPersonUid, commentsToPersonUid = EXCLUDED.commentsToPersonUid, commentSubmitterUid = EXCLUDED.commentSubmitterUid, commentsFlagged = EXCLUDED.commentsFlagged, commentsInActive = EXCLUDED.commentsInActive, commentsDateTimeAdded = EXCLUDED.commentsDateTimeAdded, commentsDateTimeUpdated = EXCLUDED.commentsDateTimeUpdated, commentsMCSN = EXCLUDED.commentsMCSN, commentsLCSN = EXCLUDED.commentsLCSN, commentsLCB = EXCLUDED.commentsLCB, commentsLct = EXCLUDED.commentsLct */; END ';
      stmtList.add_11rb$(element_172);
      var element_173 = ' CREATE TRIGGER ch_ins_101 AFTER INSERT ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, NEW.reportUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = NEW.reportUid); END ';
      stmtList.add_11rb$(element_173);
      var element_174 = ' CREATE TRIGGER ch_upd_101 AFTER UPDATE ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, NEW.reportUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = NEW.reportUid); END ';
      stmtList.add_11rb$(element_174);
      var element_175 = ' CREATE TRIGGER ch_del_101 AFTER DELETE ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, OLD.reportUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = OLD.reportUid); END ';
      stmtList.add_11rb$(element_175);
    } else {
      var element_176 = 'CREATE TABLE IF NOT EXISTS Chat (  chatStartDate  BIGINT  NOT NULL , chatTitle  TEXT , chatGroup  BOOL  NOT NULL , chatLct  BIGINT  NOT NULL , chatUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_176);
      var element_177 = 'CREATE TABLE IF NOT EXISTS ChatMember (  chatMemberChatUid  BIGINT  NOT NULL , chatMemberPersonUid  BIGINT  NOT NULL , chatMemberJoinedDate  BIGINT  NOT NULL , chatMemberLeftDate  BIGINT  NOT NULL , chatMemberLct  BIGINT  NOT NULL , chatMemberUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_177);
      var element_178 = 'CREATE TABLE IF NOT EXISTS ChatReplicate (  chatPk  BIGINT  NOT NULL , chatVersionId  BIGINT  NOT NULL  DEFAULT 0 , chatDestination  BIGINT  NOT NULL , chatPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (chatPk, chatDestination) )';
      stmtList.add_11rb$(element_178);
      var element_179 = 'CREATE INDEX index_ChatReplicate_chatPk_chatDestination_chatVersionId ON ChatReplicate (chatPk, chatDestination, chatVersionId)';
      stmtList.add_11rb$(element_179);
      var element_180 = 'CREATE INDEX index_ChatReplicate_chatDestination_chatPending ON ChatReplicate (chatDestination, chatPending)';
      stmtList.add_11rb$(element_180);
      var element_181 = 'CREATE TABLE IF NOT EXISTS ChatMemberReplicate (  chatMemberPk  BIGINT  NOT NULL , chatMemberVersionId  BIGINT  NOT NULL  DEFAULT 0 , chatMemberDestination  BIGINT  NOT NULL , chatMemberPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (chatMemberPk, chatMemberDestination) )';
      stmtList.add_11rb$(element_181);
      var element_182 = 'CREATE INDEX index_ChatMemberReplicate_chatMemberPk_chatMemberDestination_chatMemberVersionId ON ChatMemberReplicate (chatMemberPk, chatMemberDestination, chatMemberVersionId)';
      stmtList.add_11rb$(element_182);
      var element_183 = 'CREATE INDEX index_ChatMemberReplicate_chatMemberDestination_chatMemberPending ON ChatMemberReplicate (chatMemberDestination, chatMemberPending)';
      stmtList.add_11rb$(element_183);
      var element_184 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentMark (  camAssignmentUid  BIGINT  NOT NULL , camSubmitterUid  BIGINT  NOT NULL , camMark  FLOAT  NOT NULL , camPenalty  INTEGER  NOT NULL , camLct  BIGINT  NOT NULL , camUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_184);
      var element_185 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentMarkReplicate (  camPk  BIGINT  NOT NULL , camVersionId  BIGINT  NOT NULL  DEFAULT 0 , camDestination  BIGINT  NOT NULL , camPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (camPk, camDestination) )';
      stmtList.add_11rb$(element_185);
      var element_186 = 'CREATE INDEX index_CourseAssignmentMarkReplicate_camPk_camDestination_camVersionId ON CourseAssignmentMarkReplicate (camPk, camDestination, camVersionId)';
      stmtList.add_11rb$(element_186);
      var element_187 = 'CREATE INDEX index_CourseAssignmentMarkReplicate_camDestination_camPending ON CourseAssignmentMarkReplicate (camDestination, camPending)';
      stmtList.add_11rb$(element_187);
      var element_188 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmission (  casAssignmentUid  BIGINT  NOT NULL , casSubmitterUid  BIGINT  NOT NULL , casSubmitterPersonUid  BIGINT  NOT NULL , casText  TEXT , casType  INTEGER  NOT NULL , casTimestamp  BIGINT  NOT NULL , casUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_188);
      var element_189 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmissionAttachment (  casaSubmissionUid  BIGINT  NOT NULL , casaMimeType  TEXT , casaUri  TEXT , casaMd5  TEXT , casaSize  INTEGER  NOT NULL , casaTimestamp  BIGINT  NOT NULL , casaUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_189);
      var element_190 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmissionAttachmentReplicate (  casaPk  BIGINT  NOT NULL , casaVersionId  BIGINT  NOT NULL  DEFAULT 0 , casaDestination  BIGINT  NOT NULL , casaPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (casaPk, casaDestination) )';
      stmtList.add_11rb$(element_190);
      var element_191 = 'CREATE INDEX index_CourseAssignmentSubmissionAttachmentReplicate_casaPk_casaDestination_casaVersionId ON CourseAssignmentSubmissionAttachmentReplicate (casaPk, casaDestination, casaVersionId)';
      stmtList.add_11rb$(element_191);
      var element_192 = 'CREATE INDEX index_CourseAssignmentSubmissionAttachmentReplicate_casaDestination_casaPending ON CourseAssignmentSubmissionAttachmentReplicate (casaDestination, casaPending)';
      stmtList.add_11rb$(element_192);
      var element_193 = 'CREATE TABLE IF NOT EXISTS CourseAssignmentSubmissionReplicate (  casPk  BIGINT  NOT NULL , casVersionId  BIGINT  NOT NULL  DEFAULT 0 , casDestination  BIGINT  NOT NULL , casPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (casPk, casDestination) )';
      stmtList.add_11rb$(element_193);
      var element_194 = 'CREATE INDEX index_CourseAssignmentSubmissionReplicate_casPk_casDestination_casVersionId ON CourseAssignmentSubmissionReplicate (casPk, casDestination, casVersionId)';
      stmtList.add_11rb$(element_194);
      var element_195 = 'CREATE INDEX index_CourseAssignmentSubmissionReplicate_casDestination_casPending ON CourseAssignmentSubmissionReplicate (casDestination, casPending)';
      stmtList.add_11rb$(element_195);
      var element_196 = 'CREATE TABLE IF NOT EXISTS CourseBlock (  cbType  INTEGER  NOT NULL , cbIndentLevel  INTEGER  NOT NULL , cbModuleParentBlockUid  BIGINT  NOT NULL , cbTitle  TEXT , cbDescription  TEXT , cbCompletionCriteria  INTEGER  NOT NULL , cbHideUntilDate  BIGINT  NOT NULL , cbDeadlineDate  BIGINT  NOT NULL , cbLateSubmissionPenalty  INTEGER  NOT NULL , cbGracePeriodDate  BIGINT  NOT NULL , cbMaxPoints  INTEGER  NOT NULL , cbMinPoints  INTEGER  NOT NULL , cbIndex  INTEGER  NOT NULL , cbClazzUid  BIGINT  NOT NULL , cbActive  BOOL  NOT NULL , cbHidden  BOOL  NOT NULL , cbEntityUid  BIGINT  NOT NULL , cbLct  BIGINT  NOT NULL , cbUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_196);
      var element_197 = 'CREATE INDEX index_CourseBlock_cbClazzUid ON CourseBlock (cbClazzUid)';
      stmtList.add_11rb$(element_197);
      var element_198 = 'CREATE TABLE IF NOT EXISTS CourseBlockReplicate (  cbPk  BIGINT  NOT NULL , cbVersionId  BIGINT  NOT NULL  DEFAULT 0 , cbDestination  BIGINT  NOT NULL , cbPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (cbPk, cbDestination) )';
      stmtList.add_11rb$(element_198);
      var element_199 = 'CREATE INDEX index_CourseBlockReplicate_cbPk_cbDestination_cbVersionId ON CourseBlockReplicate (cbPk, cbDestination, cbVersionId)';
      stmtList.add_11rb$(element_199);
      var element_200 = 'CREATE INDEX index_CourseBlockReplicate_cbDestination_cbPending ON CourseBlockReplicate (cbDestination, cbPending)';
      stmtList.add_11rb$(element_200);
      var element_201 = 'CREATE TABLE IF NOT EXISTS CourseDiscussion (  courseDiscussionTitle  TEXT , courseDiscussionDesc  TEXT , courseDiscussionClazzUid  BIGINT  NOT NULL , courseDiscussionActive  BOOL  NOT NULL , courseDiscussionLct  BIGINT  NOT NULL , courseDiscussionUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_201);
      var element_202 = 'CREATE TABLE IF NOT EXISTS CourseDiscussionReplicate (  courseDiscussionPk  BIGINT  NOT NULL , courseDiscussionVersionId  BIGINT  NOT NULL  DEFAULT 0 , courseDiscussionDestination  BIGINT  NOT NULL , courseDiscussionPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (courseDiscussionPk, courseDiscussionDestination) )';
      stmtList.add_11rb$(element_202);
      var element_203 = 'CREATE INDEX index_CourseDiscussionReplicate_courseDiscussionPk_courseDiscussionDestination_courseDiscussionVersionId ON CourseDiscussionReplicate (courseDiscussionPk, courseDiscussionDestination, courseDiscussionVersionId)';
      stmtList.add_11rb$(element_203);
      var element_204 = 'CREATE INDEX index_CourseDiscussionReplicate_courseDiscussionDestination_courseDiscussionPending ON CourseDiscussionReplicate (courseDiscussionDestination, courseDiscussionPending)';
      stmtList.add_11rb$(element_204);
      var element_205 = 'CREATE TABLE IF NOT EXISTS CourseGroupMember (  cgmSetUid  BIGINT  NOT NULL , cgmGroupNumber  INTEGER  NOT NULL , cgmPersonUid  BIGINT  NOT NULL , cgmLct  BIGINT  NOT NULL , cgmUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_205);
      var element_206 = 'CREATE TABLE IF NOT EXISTS CourseGroupMemberReplicate (  cgmPk  BIGINT  NOT NULL , cgmVersionId  BIGINT  NOT NULL  DEFAULT 0 , cgmDestination  BIGINT  NOT NULL , cgmPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (cgmPk, cgmDestination) )';
      stmtList.add_11rb$(element_206);
      var element_207 = 'CREATE INDEX index_CourseGroupMemberReplicate_cgmPk_cgmDestination_cgmVersionId ON CourseGroupMemberReplicate (cgmPk, cgmDestination, cgmVersionId)';
      stmtList.add_11rb$(element_207);
      var element_208 = 'CREATE INDEX index_CourseGroupMemberReplicate_cgmDestination_cgmPending ON CourseGroupMemberReplicate (cgmDestination, cgmPending)';
      stmtList.add_11rb$(element_208);
      var element_209 = 'CREATE TABLE IF NOT EXISTS CourseGroupSet (  cgsName  TEXT , cgsTotalGroups  INTEGER  NOT NULL , cgsActive  BOOL  NOT NULL , cgsClazzUid  BIGINT  NOT NULL , cgsLct  BIGINT  NOT NULL , cgsUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_209);
      var element_210 = 'CREATE INDEX index_CourseGroupSet_cgsClazzUid ON CourseGroupSet (cgsClazzUid)';
      stmtList.add_11rb$(element_210);
      var element_211 = 'CREATE TABLE IF NOT EXISTS CourseGroupSetReplicate (  cgsPk  BIGINT  NOT NULL , cgsVersionId  BIGINT  NOT NULL  DEFAULT 0 , cgsDestination  BIGINT  NOT NULL , cgsPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (cgsPk, cgsDestination) )';
      stmtList.add_11rb$(element_211);
      var element_212 = 'CREATE INDEX index_CourseGroupSetReplicate_cgsPk_cgsDestination_cgsVersionId ON CourseGroupSetReplicate (cgsPk, cgsDestination, cgsVersionId)';
      stmtList.add_11rb$(element_212);
      var element_213 = 'CREATE INDEX index_CourseGroupSetReplicate_cgsDestination_cgsPending ON CourseGroupSetReplicate (cgsDestination, cgsPending)';
      stmtList.add_11rb$(element_213);
      var element_214 = 'CREATE TABLE IF NOT EXISTS CoursePicture (  coursePictureClazzUid  BIGINT  NOT NULL , coursePictureMasterCsn  BIGINT  NOT NULL , coursePictureLocalCsn  BIGINT  NOT NULL , coursePictureLastChangedBy  INTEGER  NOT NULL , coursePictureLct  BIGINT  NOT NULL , coursePictureUri  TEXT , coursePictureMd5  TEXT , coursePictureFileSize  INTEGER  NOT NULL , coursePictureTimestamp  BIGINT  NOT NULL , coursePictureMimeType  TEXT , coursePictureActive  BOOL  NOT NULL , coursePictureUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_214);
      var element_215 = 'CREATE TABLE IF NOT EXISTS CoursePictureReplicate (  cpPk  BIGINT  NOT NULL , cpVersionId  BIGINT  NOT NULL  DEFAULT 0 , cpDestination  BIGINT  NOT NULL , cpPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (cpPk, cpDestination) )';
      stmtList.add_11rb$(element_215);
      var element_216 = 'CREATE INDEX index_CoursePictureReplicate_cpPk_cpDestination_cpVersionId ON CoursePictureReplicate (cpPk, cpDestination, cpVersionId)';
      stmtList.add_11rb$(element_216);
      var element_217 = 'CREATE INDEX index_CoursePictureReplicate_cpDestination_cpPending ON CoursePictureReplicate (cpDestination, cpPending)';
      stmtList.add_11rb$(element_217);
      var element_218 = 'CREATE TABLE IF NOT EXISTS CourseTerminology (  ctTitle  TEXT , ctTerminology  TEXT , ctLct  BIGINT  NOT NULL , ctUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_218);
      var element_219 = 'CREATE TABLE IF NOT EXISTS CourseTerminologyReplicate (  ctPk  BIGINT  NOT NULL , ctVersionId  BIGINT  NOT NULL  DEFAULT 0 , ctDestination  BIGINT  NOT NULL , ctPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (ctPk, ctDestination) )';
      stmtList.add_11rb$(element_219);
      var element_220 = 'CREATE INDEX index_CourseTerminologyReplicate_ctPk_ctDestination_ctVersionId ON CourseTerminologyReplicate (ctPk, ctDestination, ctVersionId)';
      stmtList.add_11rb$(element_220);
      var element_221 = 'CREATE INDEX index_CourseTerminologyReplicate_ctDestination_ctPending ON CourseTerminologyReplicate (ctDestination, ctPending)';
      stmtList.add_11rb$(element_221);
      var element_222 = 'CREATE TABLE IF NOT EXISTS DiscussionPost (  discussionPostTitle  TEXT , discussionPostMessage  TEXT , discussionPostStartDate  BIGINT  NOT NULL , discussionPostDiscussionTopicUid  BIGINT  NOT NULL , discussionPostVisible  BOOL  NOT NULL , discussionPostArchive  BOOL  NOT NULL , discussionPostStartedPersonUid  BIGINT  NOT NULL , discussionPostClazzUid  BIGINT  NOT NULL , discussionPostLct  BIGINT  NOT NULL , discussionPostUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_222);
      var element_223 = 'CREATE TABLE IF NOT EXISTS DiscussionPostReplicate (  discussionPostPk  BIGINT  NOT NULL , discussionPostVersionId  BIGINT  NOT NULL  DEFAULT 0 , discussionPostDestination  BIGINT  NOT NULL , discussionPostPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (discussionPostPk, discussionPostDestination) )';
      stmtList.add_11rb$(element_223);
      var element_224 = 'CREATE INDEX index_DiscussionPostReplicate_discussionPostPk_discussionPostDestination_discussionPostVersionId ON DiscussionPostReplicate (discussionPostPk, discussionPostDestination, discussionPostVersionId)';
      stmtList.add_11rb$(element_224);
      var element_225 = 'CREATE INDEX index_DiscussionPostReplicate_discussionPostDestination_discussionPostPending ON DiscussionPostReplicate (discussionPostDestination, discussionPostPending)';
      stmtList.add_11rb$(element_225);
      var element_226 = 'CREATE TABLE IF NOT EXISTS DiscussionTopic (  discussionTopicTitle  TEXT , discussionTopicDesc  TEXT , discussionTopicStartDate  BIGINT  NOT NULL , discussionTopicCourseDiscussionUid  BIGINT  NOT NULL , discussionTopicVisible  BOOL  NOT NULL , discussionTopicArchive  BOOL  NOT NULL , discussionTopicIndex  INTEGER  NOT NULL , discussionTopicClazzUid  BIGINT  NOT NULL , discussionTopicLct  BIGINT  NOT NULL , discussionTopicUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_226);
      var element_227 = 'CREATE TABLE IF NOT EXISTS DiscussionTopicReplicate (  discussionTopicPk  BIGINT  NOT NULL , discussionTopicVersionId  BIGINT  NOT NULL  DEFAULT 0 , discussionTopicDestination  BIGINT  NOT NULL , discussionTopicPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (discussionTopicPk, discussionTopicDestination) )';
      stmtList.add_11rb$(element_227);
      var element_228 = 'CREATE INDEX index_DiscussionTopicReplicate_discussionTopicPk_discussionTopicDestination_discussionTopicVersionId ON DiscussionTopicReplicate (discussionTopicPk, discussionTopicDestination, discussionTopicVersionId)';
      stmtList.add_11rb$(element_228);
      var element_229 = 'CREATE INDEX index_DiscussionTopicReplicate_discussionTopicDestination_discussionTopicPending ON DiscussionTopicReplicate (discussionTopicDestination, discussionTopicPending)';
      stmtList.add_11rb$(element_229);
      var element_230 = 'CREATE TABLE IF NOT EXISTS Message (  messageSenderPersonUid  BIGINT  NOT NULL , messageTableId  INTEGER  NOT NULL , messageEntityUid  BIGINT  NOT NULL , messageText  TEXT , messageTimestamp  BIGINT  NOT NULL , messageClazzUid  BIGINT  NOT NULL , messageLct  BIGINT  NOT NULL , messageUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_230);
      var element_231 = 'CREATE TABLE IF NOT EXISTS MessageRead (  messageReadPersonUid  BIGINT  NOT NULL , messageReadMessageUid  BIGINT  NOT NULL , messageReadEntityUid  BIGINT  NOT NULL , messageReadLct  BIGINT  NOT NULL , messageReadUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_231);
      var element_232 = 'CREATE TABLE IF NOT EXISTS MessageReadReplicate (  messageReadPk  BIGINT  NOT NULL , messageReadVersionId  BIGINT  NOT NULL  DEFAULT 0 , messageReadDestination  BIGINT  NOT NULL , messageReadPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (messageReadPk, messageReadDestination) )';
      stmtList.add_11rb$(element_232);
      var element_233 = 'CREATE INDEX index_MessageReadReplicate_messageReadPk_messageReadDestination_messageReadVersionId ON MessageReadReplicate (messageReadPk, messageReadDestination, messageReadVersionId)';
      stmtList.add_11rb$(element_233);
      var element_234 = 'CREATE INDEX index_MessageReadReplicate_messageReadDestination_messageReadPending ON MessageReadReplicate (messageReadDestination, messageReadPending)';
      stmtList.add_11rb$(element_234);
      var element_235 = 'CREATE TABLE IF NOT EXISTS MessageReplicate (  messagePk  BIGINT  NOT NULL , messageVersionId  BIGINT  NOT NULL  DEFAULT 0 , messageDestination  BIGINT  NOT NULL , messagePending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (messagePk, messageDestination) )';
      stmtList.add_11rb$(element_235);
      var element_236 = 'CREATE INDEX index_MessageReplicate_messagePk_messageDestination_messageVersionId ON MessageReplicate (messagePk, messageDestination, messageVersionId)';
      stmtList.add_11rb$(element_236);
      var element_237 = 'CREATE INDEX index_MessageReplicate_messageDestination_messagePending ON MessageReplicate (messageDestination, messagePending)';
      stmtList.add_11rb$(element_237);
      var element_238 = 'DROP VIEW ClazzAssignment_ReceiveView';
      stmtList.add_11rb$(element_238);
      var element_239 = 'DROP TABLE ClazzAssignment';
      stmtList.add_11rb$(element_239);
      var element_240 = 'CREATE TABLE IF NOT EXISTS ClazzAssignment (  caTitle  TEXT , caDescription  TEXT , caGroupUid  BIGINT  NOT NULL  DEFAULT 0 , caActive  BOOL  NOT NULL , caClassCommentEnabled  BOOL  NOT NULL , caPrivateCommentsEnabled  BOOL  NOT NULL  DEFAULT true, caCompletionCriteria  INTEGER  NOT NULL  DEFAULT 100 , caRequireFileSubmission  BOOL  NOT NULL  DEFAULT true, caFileType  INTEGER  NOT NULL  DEFAULT 0 , caSizeLimit  INTEGER  NOT NULL  DEFAULT 50 , caNumberOfFiles  INTEGER  NOT NULL  DEFAULT 1 , caSubmissionPolicy  INTEGER  NOT NULL  DEFAULT 1 , caMarkingType  INTEGER  NOT NULL  DEFAULT 1 , caRequireTextSubmission  BOOL  NOT NULL  DEFAULT true, caTextLimitType  INTEGER  NOT NULL  DEFAULT 1 , caTextLimit  INTEGER  NOT NULL  DEFAULT 500 , caXObjectUid  BIGINT  NOT NULL  DEFAULT 0 , caClazzUid  BIGINT  NOT NULL , caLocalChangeSeqNum  BIGINT  NOT NULL , caMasterChangeSeqNum  BIGINT  NOT NULL , caLastChangedBy  INTEGER  NOT NULL , caLct  BIGINT  NOT NULL , caUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_240);
      var element_241 = 'CREATE INDEX index_ClazzAssignment_caClazzUid ON ClazzAssignment (caClazzUid)';
      stmtList.add_11rb$(element_241);
      var element_242 = 'DROP VIEW ClazzAssignmentContentJoin_ReceiveView';
      stmtList.add_11rb$(element_242);
      var element_243 = 'DROP TABLE ClazzAssignmentContentJoin';
      stmtList.add_11rb$(element_243);
      var element_244 = 'CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoin (  cacjContentUid  BIGINT  NOT NULL , cacjAssignmentUid  BIGINT  NOT NULL , cacjActive  BOOL  NOT NULL , cacjWeight  INTEGER  NOT NULL  DEFAULT 0 , cacjMCSN  BIGINT  NOT NULL , cacjLCSN  BIGINT  NOT NULL , cacjLCB  INTEGER  NOT NULL , cacjLct  BIGINT  NOT NULL , cacjUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_244);
      var element_245 = 'DROP TABLE ClazzAssignmentRollUp';
      stmtList.add_11rb$(element_245);
      var element_246 = 'CREATE TABLE IF NOT EXISTS ClazzAssignmentRollUp (  cachePersonUid  BIGINT  NOT NULL , cacheContentEntryUid  BIGINT  NOT NULL , cacheClazzAssignmentUid  BIGINT  NOT NULL , cacheStudentScore  INTEGER  NOT NULL , cacheMaxScore  INTEGER  NOT NULL , cacheFinalWeightScoreWithPenalty  FLOAT  NOT NULL  DEFAULT 0 , cacheWeight  INTEGER  NOT NULL  DEFAULT 0 , cacheProgress  INTEGER  NOT NULL , cacheContentComplete  BOOL  NOT NULL , cacheSuccess  SMALLINT  NOT NULL , cachePenalty  INTEGER  NOT NULL , lastCsnChecked  BIGINT  NOT NULL , cacheUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_246);
      var element_247 = 'CREATE UNIQUE INDEX index_ClazzAssignmentRollUp_cachePersonUid_cacheContentEntryUid_cacheClazzAssignmentUid ON ClazzAssignmentRollUp (cachePersonUid, cacheContentEntryUid, cacheClazzAssignmentUid)';
      stmtList.add_11rb$(element_247);
      var element_248 = 'DROP VIEW Comments_ReceiveView';
      stmtList.add_11rb$(element_248);
      var element_249 = 'CREATE TABLE IF NOT EXISTS Comments (  commentsText  TEXT , commentsEntityType  INTEGER  NOT NULL , commentsEntityUid  BIGINT  NOT NULL , commentsPublic  BOOL  NOT NULL , commentsStatus  INTEGER  NOT NULL , commentsPersonUid  BIGINT  NOT NULL , commentsToPersonUid  BIGINT  NOT NULL , commentSubmitterUid  BIGINT  NOT NULL , commentsFlagged  BOOL  NOT NULL , commentsInActive  BOOL  NOT NULL , commentsDateTimeAdded  BIGINT  NOT NULL , commentsDateTimeUpdated  BIGINT  NOT NULL , commentsMCSN  BIGINT  NOT NULL , commentsLCSN  BIGINT  NOT NULL , commentsLCB  INTEGER  NOT NULL , commentsLct  BIGINT  NOT NULL , commentsUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_249);
      var element_250 = 'ALTER TABLE Clazz ADD COLUMN clazzEnrolmentPolicy INTEGER NOT NULL DEFAULT 102 ';
      stmtList.add_11rb$(element_250);
      var element_251 = 'ALTER TABLE Clazz ADD COLUMN clazzTerminologyUid BIGINT NOT NULL DEFAULT 25966';
      stmtList.add_11rb$(element_251);
      var element_252 = 'ALTER TABLE XObjectEntity ADD COLUMN objectStatementRefUid INTEGER NOT NULL DEFAULT 0';
      stmtList.add_11rb$(element_252);
      var element_253 = ' CREATE OR REPLACE FUNCTION ch_upd_127_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (127, NEW.chatUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_253);
      var element_254 = ' CREATE TRIGGER ch_upd_127_trig AFTER UPDATE OR INSERT ON Chat FOR EACH ROW EXECUTE PROCEDURE ch_upd_127_fn(); ';
      stmtList.add_11rb$(element_254);
      var element_255 = ' CREATE OR REPLACE FUNCTION ch_del_127_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (127, OLD.chatUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_255);
      var element_256 = ' CREATE TRIGGER ch_del_127_trig AFTER DELETE ON Chat FOR EACH ROW EXECUTE PROCEDURE ch_del_127_fn(); ';
      stmtList.add_11rb$(element_256);
      var element_257 = 'CREATE VIEW Chat_ReceiveView AS  SELECT Chat.*, ChatReplicate.* FROM Chat LEFT JOIN ChatReplicate ON ChatReplicate.chatPk = Chat.chatUid ';
      stmtList.add_11rb$(element_257);
      var element_258 = "CREATE OR REPLACE FUNCTION chat_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Chat(chatUid, chatStartDate, chatTitle, chatGroup, chatLct) VALUES(NEW.chatUid, NEW.chatStartDate, NEW.chatTitle, NEW.chatGroup, NEW.chatLct) ON CONFLICT (chatUid) DO UPDATE SET chatStartDate = EXCLUDED.chatStartDate, chatTitle = EXCLUDED.chatTitle, chatGroup = EXCLUDED.chatGroup, chatLct = EXCLUDED.chatLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_258);
      var element_259 = ' CREATE TRIGGER chat_remote_insert_trig INSTEAD OF INSERT ON Chat_ReceiveView FOR EACH ROW EXECUTE PROCEDURE chat_remote_insert_fn() ';
      stmtList.add_11rb$(element_259);
      var element_260 = ' CREATE OR REPLACE FUNCTION ch_upd_128_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (128, NEW.chatMemberUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_260);
      var element_261 = ' CREATE TRIGGER ch_upd_128_trig AFTER UPDATE OR INSERT ON ChatMember FOR EACH ROW EXECUTE PROCEDURE ch_upd_128_fn(); ';
      stmtList.add_11rb$(element_261);
      var element_262 = ' CREATE OR REPLACE FUNCTION ch_del_128_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (128, OLD.chatMemberUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_262);
      var element_263 = ' CREATE TRIGGER ch_del_128_trig AFTER DELETE ON ChatMember FOR EACH ROW EXECUTE PROCEDURE ch_del_128_fn(); ';
      stmtList.add_11rb$(element_263);
      var element_264 = 'CREATE VIEW ChatMember_ReceiveView AS  SELECT ChatMember.*, ChatMemberReplicate.* FROM ChatMember LEFT JOIN ChatMemberReplicate ON ChatMemberReplicate.chatMemberPk = ChatMember.chatMemberUid ';
      stmtList.add_11rb$(element_264);
      var element_265 = "CREATE OR REPLACE FUNCTION chatmember_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChatMember(chatMemberUid, chatMemberChatUid, chatMemberPersonUid, chatMemberJoinedDate, chatMemberLeftDate, chatMemberLct) VALUES(NEW.chatMemberUid, NEW.chatMemberChatUid, NEW.chatMemberPersonUid, NEW.chatMemberJoinedDate, NEW.chatMemberLeftDate, NEW.chatMemberLct) ON CONFLICT (chatMemberUid) DO UPDATE SET chatMemberChatUid = EXCLUDED.chatMemberChatUid, chatMemberPersonUid = EXCLUDED.chatMemberPersonUid, chatMemberJoinedDate = EXCLUDED.chatMemberJoinedDate, chatMemberLeftDate = EXCLUDED.chatMemberLeftDate, chatMemberLct = EXCLUDED.chatMemberLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_265);
      var element_266 = ' CREATE TRIGGER chatmember_remote_insert_trig INSTEAD OF INSERT ON ChatMember_ReceiveView FOR EACH ROW EXECUTE PROCEDURE chatmember_remote_insert_fn() ';
      stmtList.add_11rb$(element_266);
      var element_267 = ' CREATE OR REPLACE FUNCTION ch_upd_523_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (523, NEW.camUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_267);
      var element_268 = ' CREATE TRIGGER ch_upd_523_trig AFTER UPDATE OR INSERT ON CourseAssignmentMark FOR EACH ROW EXECUTE PROCEDURE ch_upd_523_fn(); ';
      stmtList.add_11rb$(element_268);
      var element_269 = ' CREATE OR REPLACE FUNCTION ch_del_523_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (523, OLD.camUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_269);
      var element_270 = ' CREATE TRIGGER ch_del_523_trig AFTER DELETE ON CourseAssignmentMark FOR EACH ROW EXECUTE PROCEDURE ch_del_523_fn(); ';
      stmtList.add_11rb$(element_270);
      var element_271 = 'CREATE VIEW CourseAssignmentMark_ReceiveView AS  SELECT CourseAssignmentMark.*, CourseAssignmentMarkReplicate.* FROM CourseAssignmentMark LEFT JOIN CourseAssignmentMarkReplicate ON CourseAssignmentMarkReplicate.camPk = CourseAssignmentMark.camUid ';
      stmtList.add_11rb$(element_271);
      var element_272 = "CREATE OR REPLACE FUNCTION courseassignmentmark_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseAssignmentMark(camUid, camAssignmentUid, camSubmitterUid, camMark, camPenalty, camLct) VALUES (NEW.camUid, NEW.camAssignmentUid, NEW.camSubmitterUid, NEW.camMark, NEW.camPenalty, NEW.camLct) ON CONFLICT (camUid) DO UPDATE SET camAssignmentUid = EXCLUDED.camAssignmentUid, camSubmitterUid = EXCLUDED.camSubmitterUid, camMark = EXCLUDED.camMark, camPenalty = EXCLUDED.camPenalty, camLct = EXCLUDED.camLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_272);
      var element_273 = ' CREATE TRIGGER courseassignmentmark_remote_insert_trig INSTEAD OF INSERT ON CourseAssignmentMark_ReceiveView FOR EACH ROW EXECUTE PROCEDURE courseassignmentmark_remote_insert_fn() ';
      stmtList.add_11rb$(element_273);
      var element_274 = ' CREATE OR REPLACE FUNCTION ch_upd_522_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (522, NEW.casUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_274);
      var element_275 = ' CREATE TRIGGER ch_upd_522_trig AFTER UPDATE OR INSERT ON CourseAssignmentSubmission FOR EACH ROW EXECUTE PROCEDURE ch_upd_522_fn(); ';
      stmtList.add_11rb$(element_275);
      var element_276 = ' CREATE OR REPLACE FUNCTION ch_del_522_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (522, OLD.casUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_276);
      var element_277 = ' CREATE TRIGGER ch_del_522_trig AFTER DELETE ON CourseAssignmentSubmission FOR EACH ROW EXECUTE PROCEDURE ch_del_522_fn(); ';
      stmtList.add_11rb$(element_277);
      var element_278 = 'CREATE VIEW CourseAssignmentSubmission_ReceiveView AS  SELECT CourseAssignmentSubmission.*, CourseAssignmentSubmissionReplicate.* FROM CourseAssignmentSubmission LEFT JOIN CourseAssignmentSubmissionReplicate ON CourseAssignmentSubmissionReplicate.casPk = CourseAssignmentSubmission.casUid ';
      stmtList.add_11rb$(element_278);
      var element_279 = "CREATE OR REPLACE FUNCTION courseassignmentsubmission_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseAssignmentSubmission(casUid, casAssignmentUid, casSubmitterUid, casSubmitterPersonUid, casText, casType, casTimestamp) VALUES (NEW.casUid, NEW.casAssignmentUid, NEW.casSubmitterUid, NEW.casSubmitterPersonUid, NEW.casText, NEW.casType, NEW.casTimestamp) ON CONFLICT (casUid) DO UPDATE SET casAssignmentUid = EXCLUDED.casAssignmentUid, casSubmitterUid = EXCLUDED.casSubmitterUid, casSubmitterPersonUid = EXCLUDED.casSubmitterPersonUid, casText = EXCLUDED.casText, casType = EXCLUDED.casType, casTimestamp = EXCLUDED.casTimestamp ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_279);
      var element_280 = ' CREATE TRIGGER courseassignmentsubmission_remote_insert_trig INSTEAD OF INSERT ON CourseAssignmentSubmission_ReceiveView FOR EACH ROW EXECUTE PROCEDURE courseassignmentsubmission_remote_insert_fn() ';
      stmtList.add_11rb$(element_280);
      var element_281 = ' CREATE OR REPLACE FUNCTION ch_upd_90_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (90, NEW.casaUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_281);
      var element_282 = ' CREATE TRIGGER ch_upd_90_trig AFTER UPDATE OR INSERT ON CourseAssignmentSubmissionAttachment FOR EACH ROW EXECUTE PROCEDURE ch_upd_90_fn(); ';
      stmtList.add_11rb$(element_282);
      var element_283 = ' CREATE OR REPLACE FUNCTION ch_del_90_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (90, OLD.casaUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_283);
      var element_284 = ' CREATE TRIGGER ch_del_90_trig AFTER DELETE ON CourseAssignmentSubmissionAttachment FOR EACH ROW EXECUTE PROCEDURE ch_del_90_fn(); ';
      stmtList.add_11rb$(element_284);
      var element_285 = 'CREATE VIEW CourseAssignmentSubmissionAttachment_ReceiveView AS  SELECT CourseAssignmentSubmissionAttachment.*, CourseAssignmentSubmissionAttachmentReplicate.* FROM CourseAssignmentSubmissionAttachment LEFT JOIN CourseAssignmentSubmissionAttachmentReplicate ON CourseAssignmentSubmissionAttachmentReplicate.casaPk = CourseAssignmentSubmissionAttachment.casaUid ';
      stmtList.add_11rb$(element_285);
      var element_286 = "CREATE OR REPLACE FUNCTION courseassignmentsubmissionattachment_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseAssignmentSubmissionAttachment(casaUid, casaSubmissionUid, casaMimeType, casaUri, casaMd5, casaSize, casaTimestamp) VALUES (NEW.casaUid, NEW.casaSubmissionUid, NEW.casaMimeType, NEW.casaUri, NEW.casaMd5, NEW.casaSize, NEW.casaTimestamp) ON CONFLICT (casaUid) DO UPDATE SET casaSubmissionUid = EXCLUDED.casaSubmissionUid, casaMimeType = EXCLUDED.casaMimeType, casaUri = EXCLUDED.casaUri, casaMd5 = EXCLUDED.casaMd5, casaSize = EXCLUDED.casaSize, casaTimestamp = EXCLUDED.casaTimestamp ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_286);
      var element_287 = ' CREATE TRIGGER courseassignmentsubmissionattachment_remote_insert_trig INSTEAD OF INSERT ON CourseAssignmentSubmissionAttachment_ReceiveView FOR EACH ROW EXECUTE PROCEDURE courseassignmentsubmissionattachment_remote_insert_fn() ';
      stmtList.add_11rb$(element_287);
      var element_288 = trimMargin('\n        |    CREATE OR REPLACE FUNCTION attach_CourseAssignmentSubmissionAttachment_fn() RETURNS trigger AS $$\n        |    BEGIN\n        |    \n        |    INSERT INTO ZombieAttachmentData(zaUri) \n        |    SELECT OLD.casaUri AS zaUri\n        |      FROM CourseAssignmentSubmissionAttachment   \n        |     WHERE CourseAssignmentSubmissionAttachment.casaUid = OLD.casaUid\n        |       AND (SELECT COUNT(*) \n        |              FROM CourseAssignmentSubmissionAttachment\n        |             WHERE casaMd5 = OLD.casaMd5) = 0\n        |;\n        |    RETURN NEW;\n        |    END $$\n        |    LANGUAGE plpgsql\n        ');
      stmtList.add_11rb$(element_288);
      var element_289 = trimMargin('\n        |CREATE TRIGGER attach_CourseAssignmentSubmissionAttachment_trig\n        |AFTER UPDATE ON CourseAssignmentSubmissionAttachment\n        |FOR EACH ROW WHEN (OLD.casaMd5 IS NOT NULL)\n        |EXECUTE PROCEDURE attach_CourseAssignmentSubmissionAttachment_fn();\n        ');
      stmtList.add_11rb$(element_289);
      var element_290 = ' CREATE OR REPLACE FUNCTION ch_upd_124_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (124, NEW.cbUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_290);
      var element_291 = ' CREATE TRIGGER ch_upd_124_trig AFTER UPDATE OR INSERT ON CourseBlock FOR EACH ROW EXECUTE PROCEDURE ch_upd_124_fn(); ';
      stmtList.add_11rb$(element_291);
      var element_292 = ' CREATE OR REPLACE FUNCTION ch_del_124_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (124, OLD.cbUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_292);
      var element_293 = ' CREATE TRIGGER ch_del_124_trig AFTER DELETE ON CourseBlock FOR EACH ROW EXECUTE PROCEDURE ch_del_124_fn(); ';
      stmtList.add_11rb$(element_293);
      var element_294 = 'CREATE VIEW CourseBlock_ReceiveView AS  SELECT CourseBlock.*, CourseBlockReplicate.* FROM CourseBlock LEFT JOIN CourseBlockReplicate ON CourseBlockReplicate.cbPk = CourseBlock.cbUid ';
      stmtList.add_11rb$(element_294);
      var element_295 = "CREATE OR REPLACE FUNCTION courseblock_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseBlock(cbUid, cbType, cbIndentLevel, cbModuleParentBlockUid, cbTitle, cbDescription, cbCompletionCriteria, cbHideUntilDate, cbDeadlineDate, cbLateSubmissionPenalty, cbGracePeriodDate, cbMaxPoints,cbMinPoints, cbIndex, cbClazzUid, cbActive,cbHidden, cbEntityUid, cbLct) VALUES (NEW.cbUid, NEW.cbType, NEW.cbIndentLevel, NEW.cbModuleParentBlockUid, NEW.cbTitle, NEW.cbDescription, NEW.cbCompletionCriteria, NEW.cbHideUntilDate, NEW.cbDeadlineDate, NEW.cbLateSubmissionPenalty, NEW.cbGracePeriodDate, NEW.cbMaxPoints,NEW.cbMinPoints, NEW.cbIndex, NEW.cbClazzUid,NEW.cbActive, NEW.cbHidden, NEW.cbEntityUid, NEW.cbLct) ON CONFLICT (cbUid) DO UPDATE SET cbType = EXCLUDED.cbType, cbIndentLevel = EXCLUDED.cbIndentLevel, cbModuleParentBlockUid = EXCLUDED.cbModuleParentBlockUid, cbTitle = EXCLUDED.cbTitle, cbDescription = EXCLUDED.cbDescription, cbCompletionCriteria = EXCLUDED.cbCompletionCriteria, cbHideUntilDate = EXCLUDED.cbHideUntilDate,cbDeadlineDate = EXCLUDED.cbDeadlineDate, cbLateSubmissionPenalty = EXCLUDED.cbLateSubmissionPenalty, cbGracePeriodDate= EXCLUDED.cbGracePeriodDate, cbMaxPoints = EXCLUDED.cbMaxPoints, cbMinPoints = EXCLUDED.cbMinPoints, cbIndex = EXCLUDED.cbIndex,cbClazzUid = EXCLUDED.cbClazzUid, cbActive = EXCLUDED.cbActive, cbHidden = EXCLUDED.cbHidden, cbEntityUid = EXCLUDED.cbEntityUid, cbLct = EXCLUDED.cbLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_295);
      var element_296 = ' CREATE TRIGGER courseblock_remote_insert_trig INSTEAD OF INSERT ON CourseBlock_ReceiveView FOR EACH ROW EXECUTE PROCEDURE courseblock_remote_insert_fn() ';
      stmtList.add_11rb$(element_296);
      var element_297 = ' CREATE OR REPLACE FUNCTION ch_upd_130_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (130, NEW.courseDiscussionUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_297);
      var element_298 = ' CREATE TRIGGER ch_upd_130_trig AFTER UPDATE OR INSERT ON CourseDiscussion FOR EACH ROW EXECUTE PROCEDURE ch_upd_130_fn(); ';
      stmtList.add_11rb$(element_298);
      var element_299 = ' CREATE OR REPLACE FUNCTION ch_del_130_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (130, OLD.courseDiscussionUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_299);
      var element_300 = ' CREATE TRIGGER ch_del_130_trig AFTER DELETE ON CourseDiscussion FOR EACH ROW EXECUTE PROCEDURE ch_del_130_fn(); ';
      stmtList.add_11rb$(element_300);
      var element_301 = 'CREATE VIEW CourseDiscussion_ReceiveView AS  SELECT CourseDiscussion.*, CourseDiscussionReplicate.* FROM CourseDiscussion LEFT JOIN CourseDiscussionReplicate ON CourseDiscussionReplicate.courseDiscussionPk = CourseDiscussion.courseDiscussionUid ';
      stmtList.add_11rb$(element_301);
      var element_302 = "CREATE OR REPLACE FUNCTION coursediscussion_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseDiscussion(courseDiscussionUid, courseDiscussionActive, courseDiscussionTitle, courseDiscussionDesc, courseDiscussionClazzUid, courseDiscussionLct) VALUES(NEW.courseDiscussionUid, NEW.courseDiscussionActive, NEW.courseDiscussionTitle, NEW.courseDiscussionDesc, NEW.courseDiscussionClazzUid, NEW.courseDiscussionLct) ON CONFLICT (courseDiscussionUid) DO UPDATE SET courseDiscussionActive = EXCLUDED.courseDiscussionActive, courseDiscussionTitle = EXCLUDED.courseDiscussionTitle, courseDiscussionDesc = EXCLUDED.courseDiscussionDesc, courseDiscussionClazzUid = EXCLUDED.courseDiscussionClazzUid, courseDiscussionLct = EXCLUDED.courseDiscussionLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_302);
      var element_303 = ' CREATE TRIGGER coursediscussion_remote_insert_trig INSTEAD OF INSERT ON CourseDiscussion_ReceiveView FOR EACH ROW EXECUTE PROCEDURE coursediscussion_remote_insert_fn() ';
      stmtList.add_11rb$(element_303);
      var element_304 = ' CREATE OR REPLACE FUNCTION ch_upd_243_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (243, NEW.cgmUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_304);
      var element_305 = ' CREATE TRIGGER ch_upd_243_trig AFTER UPDATE OR INSERT ON CourseGroupMember FOR EACH ROW EXECUTE PROCEDURE ch_upd_243_fn(); ';
      stmtList.add_11rb$(element_305);
      var element_306 = ' CREATE OR REPLACE FUNCTION ch_del_243_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (243, OLD.cgmUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_306);
      var element_307 = ' CREATE TRIGGER ch_del_243_trig AFTER DELETE ON CourseGroupMember FOR EACH ROW EXECUTE PROCEDURE ch_del_243_fn(); ';
      stmtList.add_11rb$(element_307);
      var element_308 = 'CREATE VIEW CourseGroupMember_ReceiveView AS  SELECT CourseGroupMember.*, CourseGroupMemberReplicate.* FROM CourseGroupMember LEFT JOIN CourseGroupMemberReplicate ON CourseGroupMemberReplicate.cgmPk = CourseGroupMember.cgmUid ';
      stmtList.add_11rb$(element_308);
      var element_309 = "CREATE OR REPLACE FUNCTION coursegroupmember_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseGroupMember(cgmUid, cgmSetUid, cgmGroupNumber, cgmPersonUid, cgmLct) VALUES (NEW.cgmUid, NEW.cgmSetUid, NEW.cgmGroupNumber, NEW.cgmPersonUid, NEW.cgmLct) ON CONFLICT (cgmUid) DO UPDATE SET cgmSetUid = EXCLUDED.cgmSetUid, cgmGroupNumber = EXCLUDED.cgmGroupNumber, cgmPersonUid = EXCLUDED.cgmPersonUid, cgmLct = EXCLUDED.cgmLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_309);
      var element_310 = ' CREATE TRIGGER coursegroupmember_remote_insert_trig INSTEAD OF INSERT ON CourseGroupMember_ReceiveView FOR EACH ROW EXECUTE PROCEDURE coursegroupmember_remote_insert_fn() ';
      stmtList.add_11rb$(element_310);
      var element_311 = ' CREATE OR REPLACE FUNCTION ch_upd_242_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (242, NEW.cgsUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_311);
      var element_312 = ' CREATE TRIGGER ch_upd_242_trig AFTER UPDATE OR INSERT ON CourseGroupSet FOR EACH ROW EXECUTE PROCEDURE ch_upd_242_fn(); ';
      stmtList.add_11rb$(element_312);
      var element_313 = ' CREATE OR REPLACE FUNCTION ch_del_242_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (242, OLD.cgsUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_313);
      var element_314 = ' CREATE TRIGGER ch_del_242_trig AFTER DELETE ON CourseGroupSet FOR EACH ROW EXECUTE PROCEDURE ch_del_242_fn(); ';
      stmtList.add_11rb$(element_314);
      var element_315 = 'CREATE VIEW CourseGroupSet_ReceiveView AS  SELECT CourseGroupSet.*, CourseGroupSetReplicate.* FROM CourseGroupSet LEFT JOIN CourseGroupSetReplicate ON CourseGroupSetReplicate.cgsPk = CourseGroupSet.cgsUid ';
      stmtList.add_11rb$(element_315);
      var element_316 = "CREATE OR REPLACE FUNCTION coursegroupset_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseGroupSet(cgsUid, cgsName, cgsTotalGroups, cgsActive, cgsClazzUid, cgsLct) VALUES (NEW.cgsUid, NEW.cgsName, NEW.cgsTotalGroups, NEW.cgsActive, NEW.cgsClazzUid, NEW.cgsLct) ON CONFLICT (cgsUid) DO UPDATE SET cgsName = EXCLUDED.cgsName, cgsTotalGroups = EXCLUDED.cgsTotalGroups, cgsActive = EXCLUDED.cgsActive, cgsClazzUid = EXCLUDED.cgsClazzUid, cgsLct = EXCLUDED.cgsLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_316);
      var element_317 = ' CREATE TRIGGER coursegroupset_remote_insert_trig INSTEAD OF INSERT ON CourseGroupSet_ReceiveView FOR EACH ROW EXECUTE PROCEDURE coursegroupset_remote_insert_fn() ';
      stmtList.add_11rb$(element_317);
      var element_318 = ' CREATE OR REPLACE FUNCTION ch_upd_125_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (125, NEW.coursePictureUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_318);
      var element_319 = ' CREATE TRIGGER ch_upd_125_trig AFTER UPDATE OR INSERT ON CoursePicture FOR EACH ROW EXECUTE PROCEDURE ch_upd_125_fn(); ';
      stmtList.add_11rb$(element_319);
      var element_320 = ' CREATE OR REPLACE FUNCTION ch_del_125_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (125, OLD.coursePictureUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_320);
      var element_321 = ' CREATE TRIGGER ch_del_125_trig AFTER DELETE ON CoursePicture FOR EACH ROW EXECUTE PROCEDURE ch_del_125_fn(); ';
      stmtList.add_11rb$(element_321);
      var element_322 = 'CREATE VIEW CoursePicture_ReceiveView AS  SELECT CoursePicture.*, CoursePictureReplicate.* FROM CoursePicture LEFT JOIN CoursePictureReplicate ON CoursePictureReplicate.cpPk = CoursePicture.coursePictureUid ';
      stmtList.add_11rb$(element_322);
      var element_323 = "CREATE OR REPLACE FUNCTION coursepicture_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CoursePicture(coursePictureUid, coursePictureClazzUid, coursePictureMasterCsn, coursePictureLocalCsn, coursePictureLastChangedBy, coursePictureLct, coursePictureUri, coursePictureMd5, coursePictureFileSize, coursePictureTimestamp, coursePictureMimeType, coursePictureActive) VALUES (NEW.coursePictureUid, NEW.coursePictureClazzUid, NEW.coursePictureMasterCsn, NEW.coursePictureLocalCsn, NEW.coursePictureLastChangedBy, NEW.coursePictureLct, NEW.coursePictureUri, NEW.coursePictureMd5, NEW.coursePictureFileSize, NEW.coursePictureTimestamp, NEW.coursePictureMimeType, NEW.coursePictureActive) ON CONFLICT (coursePictureUid) DO UPDATE SET coursePictureClazzUid = EXCLUDED.coursePictureClazzUid, coursePictureMasterCsn = EXCLUDED.coursePictureMasterCsn, coursePictureLocalCsn = EXCLUDED.coursePictureLocalCsn, coursePictureLastChangedBy = EXCLUDED.coursePictureLastChangedBy, coursePictureLct = EXCLUDED.coursePictureLct, coursePictureUri = EXCLUDED.coursePictureUri, coursePictureMd5 = EXCLUDED.coursePictureMd5, coursePictureFileSize = EXCLUDED.coursePictureFileSize, coursePictureTimestamp = EXCLUDED.coursePictureTimestamp, coursePictureMimeType = EXCLUDED.coursePictureMimeType, coursePictureActive = EXCLUDED.coursePictureActive ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_323);
      var element_324 = ' CREATE TRIGGER coursepicture_remote_insert_trig INSTEAD OF INSERT ON CoursePicture_ReceiveView FOR EACH ROW EXECUTE PROCEDURE coursepicture_remote_insert_fn() ';
      stmtList.add_11rb$(element_324);
      var element_325 = trimMargin('\n        |    CREATE OR REPLACE FUNCTION attach_CoursePicture_fn() RETURNS trigger AS $$\n        |    BEGIN\n        |    \n        |    INSERT INTO ZombieAttachmentData(zaUri) \n        |    SELECT OLD.coursePictureUri AS zaUri\n        |      FROM CoursePicture   \n        |     WHERE CoursePicture.coursePictureUid = OLD.coursePictureUid\n        |       AND (SELECT COUNT(*) \n        |              FROM CoursePicture\n        |             WHERE coursePictureMd5 = OLD.coursePictureMd5) = 0\n        |;\n        |    RETURN NEW;\n        |    END $$\n        |    LANGUAGE plpgsql\n        ');
      stmtList.add_11rb$(element_325);
      var element_326 = trimMargin('\n        |CREATE TRIGGER attach_CoursePicture_trig\n        |AFTER UPDATE ON CoursePicture\n        |FOR EACH ROW WHEN (OLD.coursePictureMd5 IS NOT NULL)\n        |EXECUTE PROCEDURE attach_CoursePicture_fn();\n        ');
      stmtList.add_11rb$(element_326);
      var element_327 = ' CREATE OR REPLACE FUNCTION ch_upd_450_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (450, NEW.ctUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_327);
      var element_328 = ' CREATE TRIGGER ch_upd_450_trig AFTER UPDATE OR INSERT ON CourseTerminology FOR EACH ROW EXECUTE PROCEDURE ch_upd_450_fn(); ';
      stmtList.add_11rb$(element_328);
      var element_329 = ' CREATE OR REPLACE FUNCTION ch_del_450_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (450, OLD.ctUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_329);
      var element_330 = ' CREATE TRIGGER ch_del_450_trig AFTER DELETE ON CourseTerminology FOR EACH ROW EXECUTE PROCEDURE ch_del_450_fn(); ';
      stmtList.add_11rb$(element_330);
      var element_331 = 'CREATE VIEW CourseTerminology_ReceiveView AS  SELECT CourseTerminology.*, CourseTerminologyReplicate.* FROM CourseTerminology LEFT JOIN CourseTerminologyReplicate ON CourseTerminologyReplicate.ctPk = CourseTerminology.ctUid ';
      stmtList.add_11rb$(element_331);
      var element_332 = "CREATE OR REPLACE FUNCTION courseterminology_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO CourseTerminology(ctUid, ctTitle, ctTerminology, ctLct) VALUES (NEW.ctUid, NEW.ctTitle, NEW.ctTerminology, NEW.ctLct) ON CONFLICT (ctUid) DO UPDATE SET ctTitle = EXCLUDED.ctTitle, ctTerminology = EXCLUDED.ctTerminology, ctLct = EXCLUDED.ctLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_332);
      var element_333 = ' CREATE TRIGGER courseterminology_remote_insert_trig INSTEAD OF INSERT ON CourseTerminology_ReceiveView FOR EACH ROW EXECUTE PROCEDURE courseterminology_remote_insert_fn() ';
      stmtList.add_11rb$(element_333);
      var element_334 = ' CREATE OR REPLACE FUNCTION ch_upd_132_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (132, NEW.discussionPostUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_334);
      var element_335 = ' CREATE TRIGGER ch_upd_132_trig AFTER UPDATE OR INSERT ON DiscussionPost FOR EACH ROW EXECUTE PROCEDURE ch_upd_132_fn(); ';
      stmtList.add_11rb$(element_335);
      var element_336 = ' CREATE OR REPLACE FUNCTION ch_del_132_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (132, OLD.discussionPostUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_336);
      var element_337 = ' CREATE TRIGGER ch_del_132_trig AFTER DELETE ON DiscussionPost FOR EACH ROW EXECUTE PROCEDURE ch_del_132_fn(); ';
      stmtList.add_11rb$(element_337);
      var element_338 = 'CREATE VIEW DiscussionPost_ReceiveView AS  SELECT DiscussionPost.*, DiscussionPostReplicate.* FROM DiscussionPost LEFT JOIN DiscussionPostReplicate ON DiscussionPostReplicate.discussionPostPk = DiscussionPost.discussionPostUid ';
      stmtList.add_11rb$(element_338);
      var element_339 = "CREATE OR REPLACE FUNCTION discussionpost_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO DiscussionPost(discussionPostUid, discussionPostTitle, discussionPostMessage, discussionPostStartDate, discussionPostDiscussionTopicUid, discussionPostVisible, discussionPostArchive, discussionPostStartedPersonUid, discussionPostClazzUid, discussionPostLct) VALUES(NEW.discussionPostUid, NEW.discussionPostTitle, NEW.discussionPostMessage, NEW.discussionPostStartDate, NEW.discussionPostDiscussionTopicUid, NEW.discussionPostVisible, NEW.discussionPostArchive, NEW.discussionPostStartedPersonUid, NEW.discussionPostClazzUid, NEW.discussionPostLct) ON CONFLICT (discussionPostUid) DO UPDATE SET discussionPostTitle = EXCLUDED.discussionPostTitle , discussionPostMessage = EXCLUDED.discussionPostMessage , discussionPostStartDate = EXCLUDED.discussionPostStartDate , discussionPostDiscussionTopicUid = EXCLUDED.discussionPostDiscussionTopicUid, discussionPostVisible = EXCLUDED.discussionPostVisible , discussionPostArchive = EXCLUDED.discussionPostArchive , discussionPostStartedPersonUid = EXCLUDED.discussionPostStartedPersonUid , discussionPostClazzUid = EXCLUDED.discussionPostClazzUid, discussionPostLct = EXCLUDED.discussionPostLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_339);
      var element_340 = ' CREATE TRIGGER discussionpost_remote_insert_trig INSTEAD OF INSERT ON DiscussionPost_ReceiveView FOR EACH ROW EXECUTE PROCEDURE discussionpost_remote_insert_fn() ';
      stmtList.add_11rb$(element_340);
      var element_341 = ' CREATE OR REPLACE FUNCTION ch_upd_131_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (131, NEW.discussionTopicUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_341);
      var element_342 = ' CREATE TRIGGER ch_upd_131_trig AFTER UPDATE OR INSERT ON DiscussionTopic FOR EACH ROW EXECUTE PROCEDURE ch_upd_131_fn(); ';
      stmtList.add_11rb$(element_342);
      var element_343 = ' CREATE OR REPLACE FUNCTION ch_del_131_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (131, OLD.discussionTopicUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_343);
      var element_344 = ' CREATE TRIGGER ch_del_131_trig AFTER DELETE ON DiscussionTopic FOR EACH ROW EXECUTE PROCEDURE ch_del_131_fn(); ';
      stmtList.add_11rb$(element_344);
      var element_345 = 'CREATE VIEW DiscussionTopic_ReceiveView AS  SELECT DiscussionTopic.*, DiscussionTopicReplicate.* FROM DiscussionTopic LEFT JOIN DiscussionTopicReplicate ON DiscussionTopicReplicate.discussionTopicPk = DiscussionTopic.discussionTopicUid ';
      stmtList.add_11rb$(element_345);
      var element_346 = "CREATE OR REPLACE FUNCTION discussiontopic_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO DiscussionTopic(discussionTopicUid, discussionTopicTitle, discussionTopicDesc, discussionTopicStartDate, discussionTopicCourseDiscussionUid, discussionTopicVisible, discussionTopicArchive, discussionTopicIndex, discussionTopicClazzUid, discussionTopicLct) VALUES(NEW.discussionTopicUid, NEW.discussionTopicTitle, NEW.discussionTopicDesc, NEW.discussionTopicStartDate, NEW.discussionTopicCourseDiscussionUid, NEW.discussionTopicVisible, NEW.discussionTopicArchive, NEW.discussionTopicIndex, NEW.discussionTopicClazzUid, NEW.discussionTopicLct) ON CONFLICT (discussionTopicUid) DO UPDATE SET discussionTopicTitle = EXCLUDED.discussionTopicTitle, discussionTopicDesc = EXCLUDED.discussionTopicDesc, discussionTopicStartDate = EXCLUDED.discussionTopicStartDate, discussionTopicCourseDiscussionUid = EXCLUDED.discussionTopicCourseDiscussionUid, discussionTopicVisible = EXCLUDED.discussionTopicVisible, discussionTopicArchive = EXCLUDED.discussionTopicArchive, discussionTopicIndex = EXCLUDED.discussionTopicIndex, discussionTopicClazzUid = EXCLUDED.discussionTopicClazzUid, discussionTopicLct = EXCLUDED.discussionTopicLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_346);
      var element_347 = ' CREATE TRIGGER discussiontopic_remote_insert_trig INSTEAD OF INSERT ON DiscussionTopic_ReceiveView FOR EACH ROW EXECUTE PROCEDURE discussiontopic_remote_insert_fn() ';
      stmtList.add_11rb$(element_347);
      var element_348 = ' CREATE OR REPLACE FUNCTION ch_upd_126_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (126, NEW.messageUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_348);
      var element_349 = ' CREATE TRIGGER ch_upd_126_trig AFTER UPDATE OR INSERT ON Message FOR EACH ROW EXECUTE PROCEDURE ch_upd_126_fn(); ';
      stmtList.add_11rb$(element_349);
      var element_350 = ' CREATE OR REPLACE FUNCTION ch_del_126_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (126, OLD.messageUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_350);
      var element_351 = ' CREATE TRIGGER ch_del_126_trig AFTER DELETE ON Message FOR EACH ROW EXECUTE PROCEDURE ch_del_126_fn(); ';
      stmtList.add_11rb$(element_351);
      var element_352 = 'CREATE VIEW Message_ReceiveView AS  SELECT Message.*, MessageReplicate.* FROM Message LEFT JOIN MessageReplicate ON MessageReplicate.messagePk = Message.messageUid ';
      stmtList.add_11rb$(element_352);
      var element_353 = "CREATE OR REPLACE FUNCTION message_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Message(messageUid, messageSenderPersonUid, messageTableId, messageEntityUid, messageText, messageTimestamp, messageClazzUid, messageLct) VALUES(NEW.messageUid, NEW.messageSenderPersonUid, NEW.messageTableId, NEW.messageEntityUid, NEW.messageText, NEW.messageTimestamp, NEW.messageClazzUid, NEW.messageLct) ON CONFLICT (messageUid) DO UPDATE SET messageSenderPersonUid = EXCLUDED.messageSenderPersonUid, messageTableId = EXCLUDED.messageTableId, messageEntityUid = EXCLUDED.messageEntityUid, messageText = EXCLUDED.messageText, messageTimestamp = EXCLUDED.messageTimestamp, messageClazzUid = EXCLUDED.messageClazzUid, messageLct = EXCLUDED.messageLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_353);
      var element_354 = ' CREATE TRIGGER message_remote_insert_trig INSTEAD OF INSERT ON Message_ReceiveView FOR EACH ROW EXECUTE PROCEDURE message_remote_insert_fn() ';
      stmtList.add_11rb$(element_354);
      var element_355 = ' CREATE OR REPLACE FUNCTION ch_upd_129_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (129, NEW.messageReadUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_355);
      var element_356 = ' CREATE TRIGGER ch_upd_129_trig AFTER UPDATE OR INSERT ON MessageRead FOR EACH ROW EXECUTE PROCEDURE ch_upd_129_fn(); ';
      stmtList.add_11rb$(element_356);
      var element_357 = ' CREATE OR REPLACE FUNCTION ch_del_129_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (129, OLD.messageReadUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_357);
      var element_358 = ' CREATE TRIGGER ch_del_129_trig AFTER DELETE ON MessageRead FOR EACH ROW EXECUTE PROCEDURE ch_del_129_fn(); ';
      stmtList.add_11rb$(element_358);
      var element_359 = 'CREATE VIEW MessageRead_ReceiveView AS  SELECT MessageRead.*, MessageReadReplicate.* FROM MessageRead LEFT JOIN MessageReadReplicate ON MessageReadReplicate.messageReadPk = MessageRead.messageReadUid ';
      stmtList.add_11rb$(element_359);
      var element_360 = "CREATE OR REPLACE FUNCTION messageread_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO MessageRead(messageReadUid, messageReadPersonUid, messageReadMessageUid, messageReadEntityUid, messageReadLct) VALUES(NEW.messageReadUid, NEW.messageReadPersonUid, NEW.messageReadMessageUid, NEW.messageReadEntityUid, NEW.messageReadLct) ON CONFLICT (messageReadUid) DO UPDATE SET messageReadPersonUid = EXCLUDED.messageReadPersonUid, messageReadMessageUid = EXCLUDED.messageReadMessageUid, messageReadEntityUid = EXCLUDED.messageReadEntityUid, messageReadLct = EXCLUDED.messageReadLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_360);
      var element_361 = ' CREATE TRIGGER messageread_remote_insert_trig INSTEAD OF INSERT ON MessageRead_ReceiveView FOR EACH ROW EXECUTE PROCEDURE messageread_remote_insert_fn() ';
      stmtList.add_11rb$(element_361);
      var element_362 = ' CREATE OR REPLACE FUNCTION ch_upd_520_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (520, NEW.caUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_362);
      var element_363 = ' CREATE TRIGGER ch_upd_520_trig AFTER UPDATE OR INSERT ON ClazzAssignment FOR EACH ROW EXECUTE PROCEDURE ch_upd_520_fn(); ';
      stmtList.add_11rb$(element_363);
      var element_364 = ' CREATE OR REPLACE FUNCTION ch_del_520_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (520, OLD.caUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_364);
      var element_365 = ' CREATE TRIGGER ch_del_520_trig AFTER DELETE ON ClazzAssignment FOR EACH ROW EXECUTE PROCEDURE ch_del_520_fn(); ';
      stmtList.add_11rb$(element_365);
      var element_366 = 'CREATE VIEW ClazzAssignment_ReceiveView AS  SELECT ClazzAssignment.*, ClazzAssignmentReplicate.* FROM ClazzAssignment LEFT JOIN ClazzAssignmentReplicate ON ClazzAssignmentReplicate.caPk = ClazzAssignment.caUid ';
      stmtList.add_11rb$(element_366);
      var element_367 = "CREATE OR REPLACE FUNCTION clazzassignment_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzAssignment(caUid, caTitle, caDescription, caGroupUid, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caRequireFileSubmission, caFileType, caSizeLimit, caNumberOfFiles, caSubmissionPolicy, caMarkingType, caRequireTextSubmission, caTextLimitType, caTextLimit, caXObjectUid, caClazzUid, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES (NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caGroupUid, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caRequireFileSubmission, NEW.caFileType, NEW.caSizeLimit, NEW.caNumberOfFiles, NEW.caSubmissionPolicy, NEW.caMarkingType,NEW.caRequireTextSubmission, NEW.caTextLimitType, NEW.caTextLimit, NEW.caXObjectUid, NEW.caClazzUid, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) ON CONFLICT (caUid) DO UPDATE SET caTitle = EXCLUDED.caTitle, caDescription = EXCLUDED.caDescription, caGroupUid = EXCLUDED.caGroupUid, caActive = EXCLUDED.caActive, caClassCommentEnabled = EXCLUDED.caClassCommentEnabled, caPrivateCommentsEnabled = EXCLUDED.caPrivateCommentsEnabled, caRequireFileSubmission = EXCLUDED.caRequireFileSubmission, caFileType = EXCLUDED.caFileType, caSizeLimit = EXCLUDED.caSizeLimit, caNumberOfFiles = EXCLUDED.caNumberOfFiles, caSubmissionPolicy = EXCLUDED.caSubmissionPolicy, caMarkingType = EXCLUDED.caMarkingType, caRequireTextSubmission = EXCLUDED.caRequireTextSubmission, caTextLimitType = EXCLUDED.caTextLimitType, caTextLimit = EXCLUDED.caTextLimit, caXObjectUid = EXCLUDED.caXObjectUid, caClazzUid = EXCLUDED.caClazzUid, caLocalChangeSeqNum = EXCLUDED.caLocalChangeSeqNum, caMasterChangeSeqNum = EXCLUDED.caMasterChangeSeqNum, caLastChangedBy = EXCLUDED.caLastChangedBy, caLct = EXCLUDED.caLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_367);
      var element_368 = ' CREATE TRIGGER clazzassignment_remote_insert_trig INSTEAD OF INSERT ON ClazzAssignment_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzassignment_remote_insert_fn() ';
      stmtList.add_11rb$(element_368);
      var element_369 = ' CREATE OR REPLACE FUNCTION ch_upd_521_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (521, NEW.cacjUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_369);
      var element_370 = ' CREATE TRIGGER ch_upd_521_trig AFTER UPDATE OR INSERT ON ClazzAssignmentContentJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_521_fn(); ';
      stmtList.add_11rb$(element_370);
      var element_371 = ' CREATE OR REPLACE FUNCTION ch_del_521_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (521, OLD.cacjUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_371);
      var element_372 = ' CREATE TRIGGER ch_del_521_trig AFTER DELETE ON ClazzAssignmentContentJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_521_fn(); ';
      stmtList.add_11rb$(element_372);
      var element_373 = 'CREATE VIEW ClazzAssignmentContentJoin_ReceiveView AS  SELECT ClazzAssignmentContentJoin.*, ClazzAssignmentContentJoinReplicate.* FROM ClazzAssignmentContentJoin LEFT JOIN ClazzAssignmentContentJoinReplicate ON ClazzAssignmentContentJoinReplicate.cacjPk = ClazzAssignmentContentJoin.cacjUid ';
      stmtList.add_11rb$(element_373);
      var element_374 = "CREATE OR REPLACE FUNCTION clazzassignmentcontentjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzAssignmentContentJoin(cacjUid, cacjContentUid, cacjAssignmentUid, cacjActive,cacjWeight, cacjMCSN, cacjLCSN, cacjLCB, cacjLct) VALUES (NEW.cacjUid, NEW.cacjContentUid, NEW.cacjAssignmentUid, NEW.cacjActive, NEW.cacjWeight, NEW.cacjMCSN, NEW.cacjLCSN, NEW.cacjLCB, NEW.cacjLct) ON CONFLICT (cacjUid) DO UPDATE SET cacjContentUid = EXCLUDED.cacjContentUid, cacjAssignmentUid = EXCLUDED.cacjAssignmentUid, cacjActive = EXCLUDED.cacjActive, cacjWeight = EXCLUDED.cacjWeight, cacjMCSN = EXCLUDED.cacjMCSN, cacjLCSN = EXCLUDED.cacjLCSN, cacjLCB = EXCLUDED.cacjLCB, cacjLct = EXCLUDED.cacjLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_374);
      var element_375 = ' CREATE TRIGGER clazzassignmentcontentjoin_remote_insert_trig INSTEAD OF INSERT ON ClazzAssignmentContentJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzassignmentcontentjoin_remote_insert_fn() ';
      stmtList.add_11rb$(element_375);
      var element_376 = ' CREATE OR REPLACE FUNCTION ch_upd_208_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (208, NEW.commentsUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_376);
      var element_377 = 'DROP TRIGGER IF EXISTS ch_upd_208_trig ON Comments';
      stmtList.add_11rb$(element_377);
      var element_378 = ' CREATE TRIGGER ch_upd_208_trig AFTER UPDATE OR INSERT ON Comments FOR EACH ROW EXECUTE PROCEDURE ch_upd_208_fn(); ';
      stmtList.add_11rb$(element_378);
      var element_379 = ' CREATE OR REPLACE FUNCTION ch_del_208_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (208, OLD.commentsUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_379);
      var element_380 = 'DROP TRIGGER IF EXISTS ch_del_208_trig ON Comments';
      stmtList.add_11rb$(element_380);
      var element_381 = ' CREATE TRIGGER ch_del_208_trig AFTER DELETE ON Comments FOR EACH ROW EXECUTE PROCEDURE ch_del_208_fn(); ';
      stmtList.add_11rb$(element_381);
      var element_382 = 'CREATE VIEW Comments_ReceiveView AS  SELECT Comments.*, CommentsReplicate.* FROM Comments LEFT JOIN CommentsReplicate ON CommentsReplicate.commentsPk = Comments.commentsUid ';
      stmtList.add_11rb$(element_382);
      var element_383 = "CREATE OR REPLACE FUNCTION comments_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Comments(commentsUid, commentsText, commentsEntityType, commentsEntityUid, commentsPublic, commentsStatus, commentsPersonUid, commentsToPersonUid, commentSubmitterUid, commentsFlagged, commentsInActive, commentsDateTimeAdded, commentsDateTimeUpdated, commentsMCSN, commentsLCSN, commentsLCB, commentsLct) VALUES (NEW.commentsUid, NEW.commentsText, NEW.commentsEntityType, NEW.commentsEntityUid, NEW.commentsPublic, NEW.commentsStatus, NEW.commentsPersonUid, NEW.commentsToPersonUid, NEW.commentSubmitterUid, NEW.commentsFlagged, NEW.commentsInActive, NEW.commentsDateTimeAdded, NEW.commentsDateTimeUpdated, NEW.commentsMCSN, NEW.commentsLCSN, NEW.commentsLCB, NEW.commentsLct) ON CONFLICT (commentsUid) DO UPDATE SET commentsText = EXCLUDED.commentsText, commentsEntityType = EXCLUDED.commentsEntityType, commentsEntityUid = EXCLUDED.commentsEntityUid, commentsPublic = EXCLUDED.commentsPublic, commentsStatus = EXCLUDED.commentsStatus, commentsPersonUid = EXCLUDED.commentsPersonUid, commentsToPersonUid = EXCLUDED.commentsToPersonUid, commentSubmitterUid = EXCLUDED.commentSubmitterUid, commentsFlagged = EXCLUDED.commentsFlagged, commentsInActive = EXCLUDED.commentsInActive, commentsDateTimeAdded = EXCLUDED.commentsDateTimeAdded, commentsDateTimeUpdated = EXCLUDED.commentsDateTimeUpdated, commentsMCSN = EXCLUDED.commentsMCSN, commentsLCSN = EXCLUDED.commentsLCSN, commentsLCB = EXCLUDED.commentsLCB, commentsLct = EXCLUDED.commentsLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_383);
      var element_384 = 'DROP TRIGGER IF EXISTS comments_remote_insert_trig ON Comments_ReceiveView';
      stmtList.add_11rb$(element_384);
      var element_385 = ' CREATE TRIGGER comments_remote_insert_trig INSTEAD OF INSERT ON Comments_ReceiveView FOR EACH ROW EXECUTE PROCEDURE comments_remote_insert_fn() ';
      stmtList.add_11rb$(element_385);
    }
    return stmtList;
  }
  function UmAppDatabase$Companion$MIGRATION_103_104$lambda(db) {
    var stmtList = ArrayList_init_0();
    if (dbType(db) === 1) {
      var element = 'DROP VIEW IF EXISTS Clazz_ReceiveView';
      stmtList.add_11rb$(element);
      var element_0 = 'DROP TRIGGER IF EXISTS clazz_remote_insert_ins';
      stmtList.add_11rb$(element_0);
      var element_1 = 'CREATE VIEW Clazz_ReceiveView AS  SELECT Clazz.*, ClazzReplicate.* FROM Clazz LEFT JOIN ClazzReplicate ON ClazzReplicate.clazzPk = Clazz.clazzUid ';
      stmtList.add_11rb$(element_1);
      var element_2 = ' CREATE TRIGGER clazz_remote_insert_ins INSTEAD OF INSERT ON Clazz_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Clazz(clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzEnrolmentPolicy, clazzTerminologyUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode) VALUES (NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzEnrolmentPolicy, NEW.clazzTerminologyUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode) /*psql ON CONFLICT (clazzUid) DO UPDATE SET clazzName = EXCLUDED.clazzName, clazzDesc = EXCLUDED.clazzDesc, attendanceAverage = EXCLUDED.attendanceAverage, clazzHolidayUMCalendarUid = EXCLUDED.clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid = EXCLUDED.clazzScheuleUMCalendarUid, isClazzActive = EXCLUDED.isClazzActive, clazzLocationUid = EXCLUDED.clazzLocationUid, clazzStartTime = EXCLUDED.clazzStartTime, clazzEndTime = EXCLUDED.clazzEndTime, clazzFeatures = EXCLUDED.clazzFeatures, clazzSchoolUid = EXCLUDED.clazzSchoolUid, clazzEnrolmentPolicy = EXCLUDED.clazzEnrolmentPolicy, clazzTerminologyUid = EXCLUDED.clazzTerminologyUid, clazzMasterChangeSeqNum = EXCLUDED.clazzMasterChangeSeqNum, clazzLocalChangeSeqNum = EXCLUDED.clazzLocalChangeSeqNum, clazzLastChangedBy = EXCLUDED.clazzLastChangedBy, clazzLct = EXCLUDED.clazzLct, clazzTimeZone = EXCLUDED.clazzTimeZone, clazzStudentsPersonGroupUid = EXCLUDED.clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid = EXCLUDED.clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid = EXCLUDED.clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid = EXCLUDED.clazzParentsPersonGroupUid, clazzCode = EXCLUDED.clazzCode */; END ';
      stmtList.add_11rb$(element_2);
      var element_3 = 'DROP VIEW IF EXISTS XObjectEntity_ReceiveView';
      stmtList.add_11rb$(element_3);
      var element_4 = 'DROP TRIGGER IF EXISTS xobjectentity_remote_insert_ins';
      stmtList.add_11rb$(element_4);
      var element_5 = 'CREATE VIEW XObjectEntity_ReceiveView AS  SELECT XObjectEntity.*, XObjectEntityReplicate.* FROM XObjectEntity LEFT JOIN XObjectEntityReplicate ON XObjectEntityReplicate.xoePk = XObjectEntity.xObjectUid ';
      stmtList.add_11rb$(element_5);
      var element_6 = ' CREATE TRIGGER xobjectentity_remote_insert_ins INSTEAD OF INSERT ON XObjectEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO XObjectEntity(xObjectUid, objectType, objectId, definitionType, interactionType, correctResponsePattern, objectContentEntryUid, objectStatementRefUid, xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum, xObjectLastChangedBy, xObjectLct) VALUES (NEW.xObjectUid, NEW.objectType, NEW.objectId, NEW.definitionType, NEW.interactionType, NEW.correctResponsePattern, NEW.objectContentEntryUid, NEW.objectStatementRefUid, NEW.xObjectMasterChangeSeqNum, NEW.xObjectocalChangeSeqNum, NEW.xObjectLastChangedBy, NEW.xObjectLct) /*psql ON CONFLICT (xObjectUid) DO UPDATE SET objectType = EXCLUDED.objectType, objectId = EXCLUDED.objectId, definitionType = EXCLUDED.definitionType, interactionType = EXCLUDED.interactionType, correctResponsePattern = EXCLUDED.correctResponsePattern, objectContentEntryUid = EXCLUDED.objectContentEntryUid,objectStatementRefUid = EXCLUDED.objectStatementRefUid, xObjectMasterChangeSeqNum = EXCLUDED.xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum = EXCLUDED.xObjectocalChangeSeqNum, xObjectLastChangedBy = EXCLUDED.xObjectLastChangedBy, xObjectLct = EXCLUDED.xObjectLct */; END ';
      stmtList.add_11rb$(element_6);
    } else {
      var element_7 = 'DROP TRIGGER IF EXISTS clazz_remote_insert_trig ON Clazz_ReceiveView';
      stmtList.add_11rb$(element_7);
      var element_8 = 'DROP VIEW IF EXISTS Clazz_ReceiveView';
      stmtList.add_11rb$(element_8);
      var element_9 = 'CREATE VIEW Clazz_ReceiveView AS  SELECT Clazz.*, ClazzReplicate.* FROM Clazz LEFT JOIN ClazzReplicate ON ClazzReplicate.clazzPk = Clazz.clazzUid ';
      stmtList.add_11rb$(element_9);
      var element_10 = "CREATE OR REPLACE FUNCTION clazz_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Clazz(clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzEnrolmentPolicy, clazzTerminologyUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode) VALUES (NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzEnrolmentPolicy, NEW.clazzTerminologyUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode) ON CONFLICT (clazzUid) DO UPDATE SET clazzName = EXCLUDED.clazzName, clazzDesc = EXCLUDED.clazzDesc, attendanceAverage = EXCLUDED.attendanceAverage, clazzHolidayUMCalendarUid = EXCLUDED.clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid = EXCLUDED.clazzScheuleUMCalendarUid, isClazzActive = EXCLUDED.isClazzActive, clazzLocationUid = EXCLUDED.clazzLocationUid, clazzStartTime = EXCLUDED.clazzStartTime, clazzEndTime = EXCLUDED.clazzEndTime, clazzFeatures = EXCLUDED.clazzFeatures, clazzSchoolUid = EXCLUDED.clazzSchoolUid, clazzEnrolmentPolicy = EXCLUDED.clazzEnrolmentPolicy, clazzTerminologyUid = EXCLUDED.clazzTerminologyUid, clazzMasterChangeSeqNum = EXCLUDED.clazzMasterChangeSeqNum, clazzLocalChangeSeqNum = EXCLUDED.clazzLocalChangeSeqNum, clazzLastChangedBy = EXCLUDED.clazzLastChangedBy, clazzLct = EXCLUDED.clazzLct, clazzTimeZone = EXCLUDED.clazzTimeZone, clazzStudentsPersonGroupUid = EXCLUDED.clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid = EXCLUDED.clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid = EXCLUDED.clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid = EXCLUDED.clazzParentsPersonGroupUid, clazzCode = EXCLUDED.clazzCode ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_10);
      var element_11 = ' CREATE TRIGGER clazz_remote_insert_trig INSTEAD OF INSERT ON Clazz_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazz_remote_insert_fn() ';
      stmtList.add_11rb$(element_11);
      var element_12 = 'DROP TRIGGER IF EXISTS xobjectentity_remote_insert_trig ON XObjectEntity_ReceiveView';
      stmtList.add_11rb$(element_12);
      var element_13 = 'DROP VIEW IF EXISTS XObjectEntity_ReceiveView';
      stmtList.add_11rb$(element_13);
      var element_14 = 'CREATE VIEW XObjectEntity_ReceiveView AS  SELECT XObjectEntity.*, XObjectEntityReplicate.* FROM XObjectEntity LEFT JOIN XObjectEntityReplicate ON XObjectEntityReplicate.xoePk = XObjectEntity.xObjectUid ';
      stmtList.add_11rb$(element_14);
      var element_15 = "CREATE OR REPLACE FUNCTION xobjectentity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO XObjectEntity(xObjectUid, objectType, objectId, definitionType, interactionType, correctResponsePattern, objectContentEntryUid, objectStatementRefUid, xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum, xObjectLastChangedBy, xObjectLct) VALUES (NEW.xObjectUid, NEW.objectType, NEW.objectId, NEW.definitionType, NEW.interactionType, NEW.correctResponsePattern, NEW.objectContentEntryUid, NEW.objectStatementRefUid, NEW.xObjectMasterChangeSeqNum, NEW.xObjectocalChangeSeqNum, NEW.xObjectLastChangedBy, NEW.xObjectLct) ON CONFLICT (xObjectUid) DO UPDATE SET objectType = EXCLUDED.objectType, objectId = EXCLUDED.objectId, definitionType = EXCLUDED.definitionType, interactionType = EXCLUDED.interactionType, correctResponsePattern = EXCLUDED.correctResponsePattern, objectContentEntryUid = EXCLUDED.objectContentEntryUid,objectStatementRefUid = EXCLUDED.objectStatementRefUid, xObjectMasterChangeSeqNum = EXCLUDED.xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum = EXCLUDED.xObjectocalChangeSeqNum, xObjectLastChangedBy = EXCLUDED.xObjectLastChangedBy, xObjectLct = EXCLUDED.xObjectLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_15);
      var element_16 = ' CREATE TRIGGER xobjectentity_remote_insert_trig INSTEAD OF INSERT ON XObjectEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE xobjectentity_remote_insert_fn() ';
      stmtList.add_11rb$(element_16);
    }
    return stmtList;
  }
  function UmAppDatabase$Companion$MIGRATION_104_105$lambda(db) {
    var stmtList = ArrayList_init_0();
    if (dbType(db) === 1) {
      var element = 'CREATE TABLE IF NOT EXISTS ContentEntryPicture (`cepUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cepContentEntryUid` INTEGER NOT NULL, `cepUri` TEXT, `cepMd5` TEXT, `cepFileSize` INTEGER NOT NULL, `cepTimestamp` INTEGER NOT NULL, `cepMimeType` TEXT, `cepActive` INTEGER NOT NULL)';
      stmtList.add_11rb$(element);
      var element_0 = 'CREATE TABLE IF NOT EXISTS ContentEntryPictureReplicate (`cepPk` INTEGER NOT NULL, `cepVersionId` INTEGER NOT NULL DEFAULT 0, `cepDestination` INTEGER NOT NULL, `cepPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cepPk`, `cepDestination`))';
      stmtList.add_11rb$(element_0);
      var element_1 = 'CREATE INDEX IF NOT EXISTS `index_ContentEntryPictureReplicate_cepPk_cepDestination_cepVersionId` ON ContentEntryPictureReplicate (`cepPk`, `cepDestination`, `cepVersionId`)';
      stmtList.add_11rb$(element_1);
      var element_2 = 'CREATE INDEX IF NOT EXISTS `index_ContentEntryPictureReplicate_cepDestination_cepPending` ON ContentEntryPictureReplicate (`cepDestination`, `cepPending`)';
      stmtList.add_11rb$(element_2);
      var element_3 = ' CREATE TRIGGER ch_ins_138 AFTER INSERT ON ContentEntryPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 138 AS chTableId, NEW.cepUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 138 AND chEntityPk = NEW.cepUid); END ';
      stmtList.add_11rb$(element_3);
      var element_4 = ' CREATE TRIGGER ch_upd_138 AFTER UPDATE ON ContentEntryPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 138 AS chTableId, NEW.cepUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 138 AND chEntityPk = NEW.cepUid); END ';
      stmtList.add_11rb$(element_4);
      var element_5 = ' CREATE TRIGGER ch_del_138 AFTER DELETE ON ContentEntryPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 138 AS chTableId, OLD.cepUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 138 AND chEntityPk = OLD.cepUid); END ';
      stmtList.add_11rb$(element_5);
      var element_6 = 'CREATE VIEW ContentEntryPicture_ReceiveView AS  SELECT ContentEntryPicture.*, ContentEntryPictureReplicate.* FROM ContentEntryPicture LEFT JOIN ContentEntryPictureReplicate ON ContentEntryPictureReplicate.cepPk = ContentEntryPicture.cepUid ';
      stmtList.add_11rb$(element_6);
      var element_7 = ' CREATE TRIGGER ceppicture_remote_insert_ins INSTEAD OF INSERT ON ContentEntryPicture_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryPicture(cepUid, cepContentEntryUid, cepUri, cepMd5, cepFileSize, cepTimestamp, cepMimeType, cepActive) VALUES (NEW.cepUid, NEW.cepContentEntryUid, NEW.cepUri, NEW.cepMd5, NEW.cepFileSize, NEW.cepTimestamp, NEW.cepMimeType, NEW.cepActive) /*psql ON CONFLICT (cepUid) DO UPDATE SET cepContentEntryUid = EXCLUDED.cepContentEntryUid, cepUri = EXCLUDED.cepUri, cepMd5 = EXCLUDED.cepMd5, cepFileSize = EXCLUDED.cepFileSize, cepTimestamp = EXCLUDED.cepTimestamp, cepMimeType = EXCLUDED.cepMimeType, cepActive = EXCLUDED.cepActive */; END ';
      stmtList.add_11rb$(element_7);
      var element_8 = trimMargin('\n        |\n        |        CREATE TRIGGER ATTUPD_ContentEntryPicture\n        |        AFTER UPDATE ON ContentEntryPicture FOR EACH ROW WHEN\n        |        OLD.cepMd5 IS NOT NULL\n        |        BEGIN\n        |        \n        |        INSERT INTO ZombieAttachmentData(zaUri) \n        |        SELECT OLD.cepUri AS zaUri\n        |          FROM ContentEntryPicture   \n        |         WHERE ContentEntryPicture.cepUid = OLD.cepUid\n        |           AND (SELECT COUNT(*) \n        |                  FROM ContentEntryPicture\n        |                 WHERE cepMd5 = OLD.cepMd5) = 0\n        |    ; \n        |        END\n        |    \n        ');
      stmtList.add_11rb$(element_8);
    } else {
      var element_9 = 'CREATE TABLE IF NOT EXISTS ContentEntryPicture (  cepContentEntryUid  BIGINT  NOT NULL , cepUri  TEXT , cepMd5  TEXT , cepFileSize  INTEGER  NOT NULL , cepTimestamp  BIGINT  NOT NULL , cepMimeType  TEXT , cepActive  BOOL  NOT NULL , cepUid  BIGSERIAL  PRIMARY KEY  NOT NULL )';
      stmtList.add_11rb$(element_9);
      var element_10 = 'CREATE TABLE IF NOT EXISTS ContentEntryPictureReplicate (  cepPk  BIGINT  NOT NULL , cepVersionId  BIGINT  NOT NULL  DEFAULT 0 , cepDestination  BIGINT  NOT NULL , cepPending  BOOL  NOT NULL  DEFAULT true, PRIMARY KEY (cepPk, cepDestination) )';
      stmtList.add_11rb$(element_10);
      var element_11 = 'CREATE INDEX index_ContentEntryPictureReplicate_cepPk_cepDestination_cepVersionId ON ContentEntryPictureReplicate (cepPk, cepDestination, cepVersionId)';
      stmtList.add_11rb$(element_11);
      var element_12 = 'CREATE INDEX index_ContentEntryPictureReplicate_cepDestination_cepPending ON ContentEntryPictureReplicate (cepDestination, cepPending)';
      stmtList.add_11rb$(element_12);
      var element_13 = ' CREATE OR REPLACE FUNCTION ch_upd_138_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (138, NEW.cepUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_13);
      var element_14 = ' CREATE TRIGGER ch_upd_138_trig AFTER UPDATE OR INSERT ON ContentEntryPicture FOR EACH ROW EXECUTE PROCEDURE ch_upd_138_fn(); ';
      stmtList.add_11rb$(element_14);
      var element_15 = ' CREATE OR REPLACE FUNCTION ch_del_138_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (138, OLD.cepUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      stmtList.add_11rb$(element_15);
      var element_16 = ' CREATE TRIGGER ch_del_138_trig AFTER DELETE ON ContentEntryPicture FOR EACH ROW EXECUTE PROCEDURE ch_del_138_fn(); ';
      stmtList.add_11rb$(element_16);
      var element_17 = 'CREATE VIEW ContentEntryPicture_ReceiveView AS  SELECT ContentEntryPicture.*, ContentEntryPictureReplicate.* FROM ContentEntryPicture LEFT JOIN ContentEntryPictureReplicate ON ContentEntryPictureReplicate.cepPk = ContentEntryPicture.cepUid ';
      stmtList.add_11rb$(element_17);
      var element_18 = "CREATE OR REPLACE FUNCTION ceppicture_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentEntryPicture(cepUid, cepContentEntryUid, cepUri, cepMd5, cepFileSize, cepTimestamp, cepMimeType, cepActive) VALUES (NEW.cepUid, NEW.cepContentEntryUid, NEW.cepUri, NEW.cepMd5, NEW.cepFileSize, NEW.cepTimestamp, NEW.cepMimeType, NEW.cepActive) ON CONFLICT (cepUid) DO UPDATE SET cepContentEntryUid = EXCLUDED.cepContentEntryUid, cepUri = EXCLUDED.cepUri, cepMd5 = EXCLUDED.cepMd5, cepFileSize = EXCLUDED.cepFileSize, cepTimestamp = EXCLUDED.cepTimestamp, cepMimeType = EXCLUDED.cepMimeType, cepActive = EXCLUDED.cepActive ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      stmtList.add_11rb$(element_18);
      var element_19 = ' CREATE TRIGGER ceppicture_remote_insert_trig INSTEAD OF INSERT ON ContentEntryPicture_ReceiveView FOR EACH ROW EXECUTE PROCEDURE ceppicture_remote_insert_fn() ';
      stmtList.add_11rb$(element_19);
      var element_20 = trimMargin('\n        |    CREATE OR REPLACE FUNCTION attach_ContentEntryPicture_fn() RETURNS trigger AS $$\n        |    BEGIN\n        |    \n        |    INSERT INTO ZombieAttachmentData(zaUri) \n        |    SELECT OLD.cepUri AS zaUri\n        |      FROM ContentEntryPicture   \n        |     WHERE ContentEntryPicture.cepUid = OLD.cepUid\n        |       AND (SELECT COUNT(*) \n        |              FROM ContentEntryPicture\n        |             WHERE cepMd5 = OLD.cepMd5) = 0\n        |;\n        |    RETURN NEW;\n        |    END $$\n        |    LANGUAGE plpgsql\n        ');
      stmtList.add_11rb$(element_20);
      var element_21 = trimMargin('\n        |CREATE TRIGGER attach_ContentEntryPicture_trig\n        |AFTER UPDATE ON ContentEntryPicture\n        |FOR EACH ROW WHEN (OLD.cepMd5 IS NOT NULL)\n        |EXECUTE PROCEDURE attach_ContentEntryPicture_fn();\n        ');
      stmtList.add_11rb$(element_21);
    }
    return stmtList;
  }
  function UmAppDatabase$Companion$MIGRATION_105_106$lambda(db) {
    var stmtList = ArrayList_init_0();
    var element = 'ALTER TABLE CourseAssignmentSubmissionAttachment ADD COLUMN casaFileName TEXT';
    stmtList.add_11rb$(element);
    return stmtList;
  }
  UmAppDatabase$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var UmAppDatabase$Companion_instance = null;
  function UmAppDatabase$Companion_getInstance() {
    if (UmAppDatabase$Companion_instance === null) {
      new UmAppDatabase$Companion();
    }return UmAppDatabase$Companion_instance;
  }
  UmAppDatabase.$metadata$ = {kind: Kind_CLASS, simpleName: 'UmAppDatabase', interfaces: [DoorDatabase]};
  function dropOldSqliteTriggers($receiver) {
    var db = $receiver;
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_14');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_14');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_14');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_14');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_15');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_15');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_15');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_15');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_21');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_21');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_21');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_21');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_17');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_17');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_17');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_17');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_28');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_28');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_28');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_28');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_99');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_99');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_99');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_99');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_173');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_173');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_173');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_173');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_53');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_53');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_53');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_53');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_56');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_56');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_56');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_56');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_57');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_57');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_57');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_57');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_55');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_55');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_55');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_55');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_9');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_9');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_9');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_9');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_6');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_6');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_6');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_6');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_65');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_65');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_65');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_65');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_410');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_410');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_410');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_410');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_178');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_178');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_178');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_178');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_42');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_42');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_42');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_42');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_3');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_3');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_3');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_3');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_7');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_7');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_7');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_7');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_8');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_8');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_8');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_8');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_2');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_2');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_2');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_2');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_1');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_1');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_1');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_1');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_13');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_13');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_13');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_13');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_10');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_10');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_10');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_10');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_45');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_45');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_45');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_45');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_47');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_47');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_47');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_47');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_43');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_43');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_43');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_43');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_44');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_44');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_44');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_44');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_50');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_50');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_50');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_50');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_51');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_51');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_51');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_51');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_62');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_62');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_62');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_62');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_64');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_64');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_64');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_64');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_60');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_60');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_60');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_60');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_66');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_66');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_66');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_66');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_68');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_68');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_68');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_68');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_70');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_70');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_70');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_70');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_72');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_72');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_72');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_72');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_74');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_74');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_74');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_74');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_164');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_164');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_164');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_164');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_200');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_200');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_200');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_200');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_208');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_208');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_208');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_208');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_101');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_101');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_101');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_101');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_189');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_189');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_189');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_189');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_301');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_301');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_301');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_301');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_300');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_300');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_300');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_300');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_302');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_302');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_302');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_302');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_272');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_272');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_272');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_272');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_134');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_134');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_134');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_134');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_512');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_512');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_512');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_512');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_48');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_48');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_48');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_48');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_419');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_419');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_419');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_419');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_520');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_520');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_520');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_520');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_521');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_521');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_521');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_521');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_678');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_678');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_678');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_678');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_LOC_679');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS INS_PRI_679');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_LOC_679');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS UPD_PRI_679');
  }
  function dropOldPostgresTriggers($receiver) {
    var db = $receiver;
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_14_trig ON clazzlog');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_15_trig ON clazzlogattendancerecord');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_15_trig ON clazzlogattendancerecord');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_21_trig ON schedule');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_21_trig ON schedule');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_17_trig ON daterange');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_17_trig ON daterange');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_28_trig ON holidaycalendar');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_28_trig ON holidaycalendar');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_99_trig ON holiday');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_99_trig ON holiday');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_173_trig ON scheduledcheck');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_173_trig ON scheduledcheck');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_53_trig ON auditlog');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_53_trig ON auditlog');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_56_trig ON customfield');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_56_trig ON customfield');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_57_trig ON customfieldvalue');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_57_trig ON customfieldvalue');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_55_trig ON customfieldvalueoption');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_55_trig ON customfieldvalueoption');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_9_trig ON person');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_9_trig ON person');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_6_trig ON clazz');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_6_trig ON clazz');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_65_trig ON clazzenrolment');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_65_trig ON clazzenrolment');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_410_trig ON leavingreason');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_410_trig ON leavingreason');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_178_trig ON personcustomfieldvalue');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_178_trig ON personcustomfieldvalue');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_42_trig ON contententry');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_42_trig ON contententry');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_3_trig ON contententrycontentcategoryjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_3_trig ON contententrycontentcategoryjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_7_trig ON contententryparentchildjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_7_trig ON contententryparentchildjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_8_trig ON contententryrelatedentryjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_8_trig ON contententryrelatedentryjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_2_trig ON contentcategoryschema');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_2_trig ON contentcategoryschema');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_1_trig ON contentcategory');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_1_trig ON contentcategory');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_13_trig ON language');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_13_trig ON language');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_10_trig ON languagevariant');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_10_trig ON languagevariant');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_45_trig ON role');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_45_trig ON role');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_47_trig ON entityrole');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_47_trig ON entityrole');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_43_trig ON persongroup');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_43_trig ON persongroup');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_44_trig ON persongroupmember');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_44_trig ON persongroupmember');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_50_trig ON personpicture');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_50_trig ON personpicture');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_51_trig ON container');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_51_trig ON container');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_62_trig ON verbentity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_62_trig ON verbentity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_64_trig ON xobjectentity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_64_trig ON xobjectentity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_60_trig ON statemententity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_60_trig ON statemententity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_66_trig ON contextxobjectstatementjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_66_trig ON contextxobjectstatementjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_68_trig ON agententity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_68_trig ON agententity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_70_trig ON stateentity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_70_trig ON stateentity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_72_trig ON statecontententity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_72_trig ON statecontententity');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_74_trig ON xlangmapentry');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_74_trig ON xlangmapentry');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_164_trig ON school');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_164_trig ON school');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_200_trig ON schoolmember');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_200_trig ON schoolmember');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_208_trig ON comments');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_208_trig ON comments');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_101_trig ON report');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_101_trig ON report');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_189_trig ON site');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_189_trig ON site');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_301_trig ON learnergroup');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_301_trig ON learnergroup');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_300_trig ON learnergroupmember');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_300_trig ON learnergroupmember');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_302_trig ON grouplearningsession');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_302_trig ON grouplearningsession');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_272_trig ON siteterms');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_272_trig ON siteterms');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_134_trig ON clazzcontentjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_134_trig ON clazzcontentjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_512_trig ON personparentjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_512_trig ON personparentjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_48_trig ON scopedgrant');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_48_trig ON scopedgrant');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_419_trig ON errorreport');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_419_trig ON errorreport');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_520_trig ON clazzassignment');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_520_trig ON clazzassignment');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_521_trig ON clazzassignmentcontentjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_521_trig ON clazzassignmentcontentjoin');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_678_trig ON personauth2');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_678_trig ON personauth2');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_679_trig ON usersession');
    db.execSQL_61zpoe$('DROP TRIGGER IF EXISTS inccsn_679_trig ON usersession');
  }
  function dropOldPostgresFunctions($receiver) {
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_101_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_10_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_134_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_13_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_14_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_15_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_164_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_173_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_178_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_17_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_189_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_1_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_200_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_208_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_21_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_272_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_28_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_2_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_300_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_301_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_302_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_3_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_410_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_419_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_42_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_43_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_44_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_45_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_47_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_48_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_50_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_512_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_51_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_520_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_521_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_53_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_55_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_56_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_57_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_60_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_62_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_64_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_65_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_66_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_678_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_679_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_68_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_6_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_70_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_72_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_74_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_7_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_8_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_99_fn');
    $receiver.execSQL_61zpoe$('DROP FUNCTION IF EXISTS inccsn_9_fn');
  }
  function addReplicationEntities($receiver) {
    var _stmtList = ArrayList_init_0();
    var element = 'DROP TABLE IF EXISTS PersonCustomFieldValue';
    _stmtList.add_11rb$(element);
    var db = $receiver;
    if (dbType(db) === 1) {
      var element_0 = ' CREATE TABLE IF NOT EXISTS ClazzLogReplicate ( clPk INTEGER NOT NULL, clVersionId INTEGER NOT NULL DEFAULT 0, clDestination INTEGER NOT NULL, clPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (clPk, clDestination)) ';
      _stmtList.add_11rb$(element_0);
      var element_1 = ' CREATE INDEX index_ClazzLogReplicate_clPk_clDestination_clVersionId ON ClazzLogReplicate (clPk, clDestination, clVersionId) ';
      _stmtList.add_11rb$(element_1);
      var element_2 = ' CREATE INDEX index_ClazzLogReplicate_clDestination_clPending ON ClazzLogReplicate (clDestination, clPending) ';
      _stmtList.add_11rb$(element_2);
      var element_3 = ' CREATE TRIGGER ch_ins_14 AFTER INSERT ON ClazzLog BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 14 AS chTableId, NEW.clazzLogUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 14 AND chEntityPk = NEW.clazzLogUid); END ';
      _stmtList.add_11rb$(element_3);
      var element_4 = ' CREATE TRIGGER ch_upd_14 AFTER UPDATE ON ClazzLog BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 14 AS chTableId, NEW.clazzLogUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 14 AND chEntityPk = NEW.clazzLogUid); END ';
      _stmtList.add_11rb$(element_4);
      var element_5 = ' CREATE TRIGGER ch_del_14 AFTER DELETE ON ClazzLog BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 14 AS chTableId, OLD.clazzLogUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 14 AND chEntityPk = OLD.clazzLogUid); END ';
      _stmtList.add_11rb$(element_5);
      var element_6 = 'CREATE VIEW ClazzLog_ReceiveView AS  SELECT ClazzLog.*, ClazzLogReplicate.* FROM ClazzLog LEFT JOIN ClazzLogReplicate ON ClazzLogReplicate.clPk = ClazzLog.clazzLogUid ';
      _stmtList.add_11rb$(element_6);
      var element_7 = ' CREATE TRIGGER clazzlog_remote_insert_ins INSTEAD OF INSERT ON ClazzLog_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzLog(clazzLogUid, clazzLogClazzUid, logDate, timeRecorded, clazzLogDone, cancellationNote, clazzLogCancelled, clazzLogNumPresent, clazzLogNumAbsent, clazzLogNumPartial, clazzLogScheduleUid, clazzLogStatusFlag, clazzLogMSQN, clazzLogLCSN, clazzLogLCB, clazzLogLastChangedTime) VALUES (NEW.clazzLogUid, NEW.clazzLogClazzUid, NEW.logDate, NEW.timeRecorded, NEW.clazzLogDone, NEW.cancellationNote, NEW.clazzLogCancelled, NEW.clazzLogNumPresent, NEW.clazzLogNumAbsent, NEW.clazzLogNumPartial, NEW.clazzLogScheduleUid, NEW.clazzLogStatusFlag, NEW.clazzLogMSQN, NEW.clazzLogLCSN, NEW.clazzLogLCB, NEW.clazzLogLastChangedTime) /*psql ON CONFLICT (clazzLogUid) DO UPDATE SET clazzLogClazzUid = EXCLUDED.clazzLogClazzUid, logDate = EXCLUDED.logDate, timeRecorded = EXCLUDED.timeRecorded, clazzLogDone = EXCLUDED.clazzLogDone, cancellationNote = EXCLUDED.cancellationNote, clazzLogCancelled = EXCLUDED.clazzLogCancelled, clazzLogNumPresent = EXCLUDED.clazzLogNumPresent, clazzLogNumAbsent = EXCLUDED.clazzLogNumAbsent, clazzLogNumPartial = EXCLUDED.clazzLogNumPartial, clazzLogScheduleUid = EXCLUDED.clazzLogScheduleUid, clazzLogStatusFlag = EXCLUDED.clazzLogStatusFlag, clazzLogMSQN = EXCLUDED.clazzLogMSQN, clazzLogLCSN = EXCLUDED.clazzLogLCSN, clazzLogLCB = EXCLUDED.clazzLogLCB, clazzLogLastChangedTime = EXCLUDED.clazzLogLastChangedTime */; END ';
      _stmtList.add_11rb$(element_7);
      var element_8 = ' CREATE TABLE IF NOT EXISTS ClazzLogAttendanceRecordReplicate ( clarPk INTEGER NOT NULL, clarVersionId INTEGER NOT NULL DEFAULT 0, clarDestination INTEGER NOT NULL, clarPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (clarPk, clarDestination)) ';
      _stmtList.add_11rb$(element_8);
      var element_9 = ' CREATE INDEX index_ClazzLogAttendanceRecordReplicate_clarPk_clarDestination_clarVersionId ON ClazzLogAttendanceRecordReplicate (clarPk, clarDestination, clarVersionId) ';
      _stmtList.add_11rb$(element_9);
      var element_10 = ' CREATE INDEX index_ClazzLogAttendanceRecordReplicate_clarDestination_clarPending ON ClazzLogAttendanceRecordReplicate (clarDestination, clarPending) ';
      _stmtList.add_11rb$(element_10);
      var element_11 = ' CREATE TRIGGER ch_ins_15 AFTER INSERT ON ClazzLogAttendanceRecord BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 15 AS chTableId, NEW.clazzLogAttendanceRecordUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 15 AND chEntityPk = NEW.clazzLogAttendanceRecordUid); END ';
      _stmtList.add_11rb$(element_11);
      var element_12 = ' CREATE TRIGGER ch_upd_15 AFTER UPDATE ON ClazzLogAttendanceRecord BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 15 AS chTableId, NEW.clazzLogAttendanceRecordUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 15 AND chEntityPk = NEW.clazzLogAttendanceRecordUid); END ';
      _stmtList.add_11rb$(element_12);
      var element_13 = ' CREATE TRIGGER ch_del_15 AFTER DELETE ON ClazzLogAttendanceRecord BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 15 AS chTableId, OLD.clazzLogAttendanceRecordUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 15 AND chEntityPk = OLD.clazzLogAttendanceRecordUid); END ';
      _stmtList.add_11rb$(element_13);
      var element_14 = 'CREATE VIEW ClazzLogAttendanceRecord_ReceiveView AS  SELECT ClazzLogAttendanceRecord.*, ClazzLogAttendanceRecordReplicate.* FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLogAttendanceRecordReplicate ON ClazzLogAttendanceRecordReplicate.clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid ';
      _stmtList.add_11rb$(element_14);
      var element_15 = ' CREATE TRIGGER clazzlogattendancerecord_remote_insert_ins INSTEAD OF INSERT ON ClazzLogAttendanceRecord_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzLogAttendanceRecord(clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES (NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime) /*psql ON CONFLICT (clazzLogAttendanceRecordUid) DO UPDATE SET clazzLogAttendanceRecordClazzLogUid = EXCLUDED.clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid = EXCLUDED.clazzLogAttendanceRecordPersonUid, attendanceStatus = EXCLUDED.attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy = EXCLUDED.clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime = EXCLUDED.clazzLogAttendanceRecordLastChangedTime */; END ';
      _stmtList.add_11rb$(element_15);
      var element_16 = ' CREATE TABLE IF NOT EXISTS ScheduleReplicate ( schedulePk INTEGER NOT NULL, scheduleVersionId INTEGER NOT NULL DEFAULT 0, scheduleDestination INTEGER NOT NULL, schedulePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (schedulePk, scheduleDestination)) ';
      _stmtList.add_11rb$(element_16);
      var element_17 = ' CREATE INDEX index_ScheduleReplicate_schedulePk_scheduleDestination_scheduleVersionId ON ScheduleReplicate (schedulePk, scheduleDestination, scheduleVersionId) ';
      _stmtList.add_11rb$(element_17);
      var element_18 = ' CREATE INDEX index_ScheduleReplicate_scheduleDestination_schedulePending ON ScheduleReplicate (scheduleDestination, schedulePending) ';
      _stmtList.add_11rb$(element_18);
      var element_19 = ' CREATE TRIGGER ch_ins_21 AFTER INSERT ON Schedule BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 21 AS chTableId, NEW.scheduleUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 21 AND chEntityPk = NEW.scheduleUid); END ';
      _stmtList.add_11rb$(element_19);
      var element_20 = ' CREATE TRIGGER ch_upd_21 AFTER UPDATE ON Schedule BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 21 AS chTableId, NEW.scheduleUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 21 AND chEntityPk = NEW.scheduleUid); END ';
      _stmtList.add_11rb$(element_20);
      var element_21 = ' CREATE TRIGGER ch_del_21 AFTER DELETE ON Schedule BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 21 AS chTableId, OLD.scheduleUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 21 AND chEntityPk = OLD.scheduleUid); END ';
      _stmtList.add_11rb$(element_21);
      var element_22 = 'CREATE VIEW Schedule_ReceiveView AS  SELECT Schedule.*, ScheduleReplicate.* FROM Schedule LEFT JOIN ScheduleReplicate ON ScheduleReplicate.schedulePk = Schedule.scheduleUid ';
      _stmtList.add_11rb$(element_22);
      var element_23 = ' CREATE TRIGGER schedule_remote_insert_ins INSTEAD OF INSERT ON Schedule_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Schedule(scheduleUid, sceduleStartTime, scheduleEndTime, scheduleDay, scheduleMonth, scheduleFrequency, umCalendarUid, scheduleClazzUid, scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum, scheduleLastChangedBy, scheduleLastChangedTime, scheduleActive) VALUES (NEW.scheduleUid, NEW.sceduleStartTime, NEW.scheduleEndTime, NEW.scheduleDay, NEW.scheduleMonth, NEW.scheduleFrequency, NEW.umCalendarUid, NEW.scheduleClazzUid, NEW.scheduleMasterChangeSeqNum, NEW.scheduleLocalChangeSeqNum, NEW.scheduleLastChangedBy, NEW.scheduleLastChangedTime, NEW.scheduleActive) /*psql ON CONFLICT (scheduleUid) DO UPDATE SET sceduleStartTime = EXCLUDED.sceduleStartTime, scheduleEndTime = EXCLUDED.scheduleEndTime, scheduleDay = EXCLUDED.scheduleDay, scheduleMonth = EXCLUDED.scheduleMonth, scheduleFrequency = EXCLUDED.scheduleFrequency, umCalendarUid = EXCLUDED.umCalendarUid, scheduleClazzUid = EXCLUDED.scheduleClazzUid, scheduleMasterChangeSeqNum = EXCLUDED.scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum = EXCLUDED.scheduleLocalChangeSeqNum, scheduleLastChangedBy = EXCLUDED.scheduleLastChangedBy, scheduleLastChangedTime = EXCLUDED.scheduleLastChangedTime, scheduleActive = EXCLUDED.scheduleActive */; END ';
      _stmtList.add_11rb$(element_23);
      var element_24 = ' CREATE TABLE IF NOT EXISTS HolidayCalendarReplicate ( hcPk INTEGER NOT NULL, hcVersionId INTEGER NOT NULL DEFAULT 0, hcDestination INTEGER NOT NULL, hcPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (hcPk, hcDestination)) ';
      _stmtList.add_11rb$(element_24);
      var element_25 = ' CREATE INDEX index_HolidayCalendarReplicate_hcPk_hcDestination_hcVersionId ON HolidayCalendarReplicate (hcPk, hcDestination, hcVersionId) ';
      _stmtList.add_11rb$(element_25);
      var element_26 = ' CREATE INDEX index_HolidayCalendarReplicate_hcDestination_hcPending ON HolidayCalendarReplicate (hcDestination, hcPending) ';
      _stmtList.add_11rb$(element_26);
      var element_27 = ' CREATE TRIGGER ch_ins_28 AFTER INSERT ON HolidayCalendar BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 28 AS chTableId, NEW.umCalendarUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 28 AND chEntityPk = NEW.umCalendarUid); END ';
      _stmtList.add_11rb$(element_27);
      var element_28 = ' CREATE TRIGGER ch_upd_28 AFTER UPDATE ON HolidayCalendar BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 28 AS chTableId, NEW.umCalendarUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 28 AND chEntityPk = NEW.umCalendarUid); END ';
      _stmtList.add_11rb$(element_28);
      var element_29 = ' CREATE TRIGGER ch_del_28 AFTER DELETE ON HolidayCalendar BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 28 AS chTableId, OLD.umCalendarUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 28 AND chEntityPk = OLD.umCalendarUid); END ';
      _stmtList.add_11rb$(element_29);
      var element_30 = 'CREATE VIEW HolidayCalendar_ReceiveView AS  SELECT HolidayCalendar.*, HolidayCalendarReplicate.* FROM HolidayCalendar LEFT JOIN HolidayCalendarReplicate ON HolidayCalendarReplicate.hcPk = HolidayCalendar.umCalendarUid ';
      _stmtList.add_11rb$(element_30);
      var element_31 = ' CREATE TRIGGER holidaycalendar_remote_insert_ins INSTEAD OF INSERT ON HolidayCalendar_ReceiveView FOR EACH ROW BEGIN REPLACE INTO HolidayCalendar(umCalendarUid, umCalendarName, umCalendarCategory, umCalendarActive, umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum, umCalendarLastChangedBy, umCalendarLct) VALUES (NEW.umCalendarUid, NEW.umCalendarName, NEW.umCalendarCategory, NEW.umCalendarActive, NEW.umCalendarMasterChangeSeqNum, NEW.umCalendarLocalChangeSeqNum, NEW.umCalendarLastChangedBy, NEW.umCalendarLct) /*psql ON CONFLICT (umCalendarUid) DO UPDATE SET umCalendarName = EXCLUDED.umCalendarName, umCalendarCategory = EXCLUDED.umCalendarCategory, umCalendarActive = EXCLUDED.umCalendarActive, umCalendarMasterChangeSeqNum = EXCLUDED.umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum = EXCLUDED.umCalendarLocalChangeSeqNum, umCalendarLastChangedBy = EXCLUDED.umCalendarLastChangedBy, umCalendarLct = EXCLUDED.umCalendarLct */; END ';
      _stmtList.add_11rb$(element_31);
      var element_32 = ' CREATE TABLE IF NOT EXISTS HolidayReplicate ( holidayPk INTEGER NOT NULL, holidayVersionId INTEGER NOT NULL DEFAULT 0, holidayDestination INTEGER NOT NULL, holidayPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (holidayPk, holidayDestination)) ';
      _stmtList.add_11rb$(element_32);
      var element_33 = ' CREATE INDEX index_HolidayReplicate_holidayPk_holidayDestination_holidayVersionId ON HolidayReplicate (holidayPk, holidayDestination, holidayVersionId) ';
      _stmtList.add_11rb$(element_33);
      var element_34 = ' CREATE INDEX index_HolidayReplicate_holidayDestination_holidayPending ON HolidayReplicate (holidayDestination, holidayPending) ';
      _stmtList.add_11rb$(element_34);
      var element_35 = ' CREATE TRIGGER ch_ins_99 AFTER INSERT ON Holiday BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 99 AS chTableId, NEW.holUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 99 AND chEntityPk = NEW.holUid); END ';
      _stmtList.add_11rb$(element_35);
      var element_36 = ' CREATE TRIGGER ch_upd_99 AFTER UPDATE ON Holiday BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 99 AS chTableId, NEW.holUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 99 AND chEntityPk = NEW.holUid); END ';
      _stmtList.add_11rb$(element_36);
      var element_37 = ' CREATE TRIGGER ch_del_99 AFTER DELETE ON Holiday BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 99 AS chTableId, OLD.holUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 99 AND chEntityPk = OLD.holUid); END ';
      _stmtList.add_11rb$(element_37);
      var element_38 = 'CREATE VIEW Holiday_ReceiveView AS  SELECT Holiday.*, HolidayReplicate.* FROM Holiday LEFT JOIN HolidayReplicate ON HolidayReplicate.holidayPk = Holiday.holUid ';
      _stmtList.add_11rb$(element_38);
      var element_39 = ' CREATE TRIGGER holiday_remote_insert_ins INSTEAD OF INSERT ON Holiday_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Holiday(holUid, holMasterCsn, holLocalCsn, holLastModBy, holLct, holActive, holHolidayCalendarUid, holStartTime, holEndTime, holName) VALUES (NEW.holUid, NEW.holMasterCsn, NEW.holLocalCsn, NEW.holLastModBy, NEW.holLct, NEW.holActive, NEW.holHolidayCalendarUid, NEW.holStartTime, NEW.holEndTime, NEW.holName) /*psql ON CONFLICT (holUid) DO UPDATE SET holMasterCsn = EXCLUDED.holMasterCsn, holLocalCsn = EXCLUDED.holLocalCsn, holLastModBy = EXCLUDED.holLastModBy, holLct = EXCLUDED.holLct, holActive = EXCLUDED.holActive, holHolidayCalendarUid = EXCLUDED.holHolidayCalendarUid, holStartTime = EXCLUDED.holStartTime, holEndTime = EXCLUDED.holEndTime, holName = EXCLUDED.holName */; END ';
      _stmtList.add_11rb$(element_39);
      var element_40 = ' CREATE TABLE IF NOT EXISTS PersonReplicate ( personPk INTEGER NOT NULL, personVersionId INTEGER NOT NULL DEFAULT 0, personDestination INTEGER NOT NULL, personPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (personPk, personDestination)) ';
      _stmtList.add_11rb$(element_40);
      var element_41 = ' CREATE INDEX index_PersonReplicate_personPk_personDestination_personVersionId ON PersonReplicate (personPk, personDestination, personVersionId) ';
      _stmtList.add_11rb$(element_41);
      var element_42 = ' CREATE INDEX index_PersonReplicate_personDestination_personPending ON PersonReplicate (personDestination, personPending) ';
      _stmtList.add_11rb$(element_42);
      var element_43 = ' CREATE TRIGGER ch_ins_9 AFTER INSERT ON Person BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 9 AS chTableId, NEW.personUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 9 AND chEntityPk = NEW.personUid); END ';
      _stmtList.add_11rb$(element_43);
      var element_44 = ' CREATE TRIGGER ch_upd_9 AFTER UPDATE ON Person BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 9 AS chTableId, NEW.personUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 9 AND chEntityPk = NEW.personUid); END ';
      _stmtList.add_11rb$(element_44);
      var element_45 = ' CREATE TRIGGER ch_del_9 AFTER DELETE ON Person BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 9 AS chTableId, OLD.personUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 9 AND chEntityPk = OLD.personUid); END ';
      _stmtList.add_11rb$(element_45);
      var element_46 = 'CREATE VIEW Person_ReceiveView AS  SELECT Person.*, PersonReplicate.* FROM Person LEFT JOIN PersonReplicate ON PersonReplicate.personPk = Person.personUid ';
      _stmtList.add_11rb$(element_46);
      var element_47 = ' CREATE TRIGGER person_remote_insert_ins INSTEAD OF INSERT ON Person_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Person(personUid, username, firstNames, lastName, emailAddr, phoneNum, gender, active, admin, personNotes, fatherName, fatherNumber, motherName, motherNum, dateOfBirth, personAddress, personOrgId, personGroupUid, personMasterChangeSeqNum, personLocalChangeSeqNum, personLastChangedBy, personLct, personCountry, personType) VALUES (NEW.personUid, NEW.username, NEW.firstNames, NEW.lastName, NEW.emailAddr, NEW.phoneNum, NEW.gender, NEW.active, NEW.admin, NEW.personNotes, NEW.fatherName, NEW.fatherNumber, NEW.motherName, NEW.motherNum, NEW.dateOfBirth, NEW.personAddress, NEW.personOrgId, NEW.personGroupUid, NEW.personMasterChangeSeqNum, NEW.personLocalChangeSeqNum, NEW.personLastChangedBy, NEW.personLct, NEW.personCountry, NEW.personType) /*psql ON CONFLICT (personUid) DO UPDATE SET username = EXCLUDED.username, firstNames = EXCLUDED.firstNames, lastName = EXCLUDED.lastName, emailAddr = EXCLUDED.emailAddr, phoneNum = EXCLUDED.phoneNum, gender = EXCLUDED.gender, active = EXCLUDED.active, admin = EXCLUDED.admin, personNotes = EXCLUDED.personNotes, fatherName = EXCLUDED.fatherName, fatherNumber = EXCLUDED.fatherNumber, motherName = EXCLUDED.motherName, motherNum = EXCLUDED.motherNum, dateOfBirth = EXCLUDED.dateOfBirth, personAddress = EXCLUDED.personAddress, personOrgId = EXCLUDED.personOrgId, personGroupUid = EXCLUDED.personGroupUid, personMasterChangeSeqNum = EXCLUDED.personMasterChangeSeqNum, personLocalChangeSeqNum = EXCLUDED.personLocalChangeSeqNum, personLastChangedBy = EXCLUDED.personLastChangedBy, personLct = EXCLUDED.personLct, personCountry = EXCLUDED.personCountry, personType = EXCLUDED.personType */; END ';
      _stmtList.add_11rb$(element_47);
      var element_48 = ' CREATE TABLE IF NOT EXISTS ClazzReplicate ( clazzPk INTEGER NOT NULL, clazzVersionId INTEGER NOT NULL DEFAULT 0, clazzDestination INTEGER NOT NULL, clazzPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (clazzPk, clazzDestination)) ';
      _stmtList.add_11rb$(element_48);
      var element_49 = ' CREATE INDEX index_ClazzReplicate_clazzPk_clazzDestination_clazzVersionId ON ClazzReplicate (clazzPk, clazzDestination, clazzVersionId) ';
      _stmtList.add_11rb$(element_49);
      var element_50 = ' CREATE INDEX index_ClazzReplicate_clazzDestination_clazzPending ON ClazzReplicate (clazzDestination, clazzPending) ';
      _stmtList.add_11rb$(element_50);
      var element_51 = ' CREATE TRIGGER ch_ins_6 AFTER INSERT ON Clazz BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 6 AS chTableId, NEW.clazzUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 6 AND chEntityPk = NEW.clazzUid); END ';
      _stmtList.add_11rb$(element_51);
      var element_52 = ' CREATE TRIGGER ch_upd_6 AFTER UPDATE ON Clazz BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 6 AS chTableId, NEW.clazzUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 6 AND chEntityPk = NEW.clazzUid); END ';
      _stmtList.add_11rb$(element_52);
      var element_53 = ' CREATE TRIGGER ch_del_6 AFTER DELETE ON Clazz BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 6 AS chTableId, OLD.clazzUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 6 AND chEntityPk = OLD.clazzUid); END ';
      _stmtList.add_11rb$(element_53);
      var element_54 = 'CREATE VIEW Clazz_ReceiveView AS  SELECT Clazz.*, ClazzReplicate.* FROM Clazz LEFT JOIN ClazzReplicate ON ClazzReplicate.clazzPk = Clazz.clazzUid ';
      _stmtList.add_11rb$(element_54);
      var element_55 = ' CREATE TRIGGER clazz_remote_insert_ins INSTEAD OF INSERT ON Clazz_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Clazz(clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode) VALUES (NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode) /*psql ON CONFLICT (clazzUid) DO UPDATE SET clazzName = EXCLUDED.clazzName, clazzDesc = EXCLUDED.clazzDesc, attendanceAverage = EXCLUDED.attendanceAverage, clazzHolidayUMCalendarUid = EXCLUDED.clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid = EXCLUDED.clazzScheuleUMCalendarUid, isClazzActive = EXCLUDED.isClazzActive, clazzLocationUid = EXCLUDED.clazzLocationUid, clazzStartTime = EXCLUDED.clazzStartTime, clazzEndTime = EXCLUDED.clazzEndTime, clazzFeatures = EXCLUDED.clazzFeatures, clazzSchoolUid = EXCLUDED.clazzSchoolUid, clazzMasterChangeSeqNum = EXCLUDED.clazzMasterChangeSeqNum, clazzLocalChangeSeqNum = EXCLUDED.clazzLocalChangeSeqNum, clazzLastChangedBy = EXCLUDED.clazzLastChangedBy, clazzLct = EXCLUDED.clazzLct, clazzTimeZone = EXCLUDED.clazzTimeZone, clazzStudentsPersonGroupUid = EXCLUDED.clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid = EXCLUDED.clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid = EXCLUDED.clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid = EXCLUDED.clazzParentsPersonGroupUid, clazzCode = EXCLUDED.clazzCode */; END ';
      _stmtList.add_11rb$(element_55);
      var element_56 = ' CREATE TABLE IF NOT EXISTS ClazzEnrolmentReplicate ( cePk INTEGER NOT NULL, ceVersionId INTEGER NOT NULL DEFAULT 0, ceDestination INTEGER NOT NULL, cePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (cePk, ceDestination)) ';
      _stmtList.add_11rb$(element_56);
      var element_57 = ' CREATE INDEX index_ClazzEnrolmentReplicate_cePk_ceDestination_ceVersionId ON ClazzEnrolmentReplicate (cePk, ceDestination, ceVersionId) ';
      _stmtList.add_11rb$(element_57);
      var element_58 = ' CREATE INDEX index_ClazzEnrolmentReplicate_ceDestination_cePending ON ClazzEnrolmentReplicate (ceDestination, cePending) ';
      _stmtList.add_11rb$(element_58);
      var element_59 = ' CREATE TRIGGER ch_ins_65 AFTER INSERT ON ClazzEnrolment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 65 AS chTableId, NEW.clazzEnrolmentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 65 AND chEntityPk = NEW.clazzEnrolmentUid); END ';
      _stmtList.add_11rb$(element_59);
      var element_60 = ' CREATE TRIGGER ch_upd_65 AFTER UPDATE ON ClazzEnrolment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 65 AS chTableId, NEW.clazzEnrolmentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 65 AND chEntityPk = NEW.clazzEnrolmentUid); END ';
      _stmtList.add_11rb$(element_60);
      var element_61 = ' CREATE TRIGGER ch_del_65 AFTER DELETE ON ClazzEnrolment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 65 AS chTableId, OLD.clazzEnrolmentUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 65 AND chEntityPk = OLD.clazzEnrolmentUid); END ';
      _stmtList.add_11rb$(element_61);
      var element_62 = 'CREATE VIEW ClazzEnrolment_ReceiveView AS  SELECT ClazzEnrolment.*, ClazzEnrolmentReplicate.* FROM ClazzEnrolment LEFT JOIN ClazzEnrolmentReplicate ON ClazzEnrolmentReplicate.cePk = ClazzEnrolment.clazzEnrolmentUid ';
      _stmtList.add_11rb$(element_62);
      var element_63 = ' CREATE TRIGGER clazzenrolment_remote_insert_ins INSTEAD OF INSERT ON ClazzEnrolment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzEnrolment(clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy, clazzEnrolmentLct) VALUES (NEW.clazzEnrolmentUid, NEW.clazzEnrolmentPersonUid, NEW.clazzEnrolmentClazzUid, NEW.clazzEnrolmentDateJoined, NEW.clazzEnrolmentDateLeft, NEW.clazzEnrolmentRole, NEW.clazzEnrolmentAttendancePercentage, NEW.clazzEnrolmentActive, NEW.clazzEnrolmentLeavingReasonUid, NEW.clazzEnrolmentOutcome, NEW.clazzEnrolmentLocalChangeSeqNum, NEW.clazzEnrolmentMasterChangeSeqNum, NEW.clazzEnrolmentLastChangedBy, NEW.clazzEnrolmentLct) /*psql ON CONFLICT (clazzEnrolmentUid) DO UPDATE SET clazzEnrolmentPersonUid = EXCLUDED.clazzEnrolmentPersonUid, clazzEnrolmentClazzUid = EXCLUDED.clazzEnrolmentClazzUid, clazzEnrolmentDateJoined = EXCLUDED.clazzEnrolmentDateJoined, clazzEnrolmentDateLeft = EXCLUDED.clazzEnrolmentDateLeft, clazzEnrolmentRole = EXCLUDED.clazzEnrolmentRole, clazzEnrolmentAttendancePercentage = EXCLUDED.clazzEnrolmentAttendancePercentage, clazzEnrolmentActive = EXCLUDED.clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid = EXCLUDED.clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome = EXCLUDED.clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum = EXCLUDED.clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum = EXCLUDED.clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy = EXCLUDED.clazzEnrolmentLastChangedBy, clazzEnrolmentLct = EXCLUDED.clazzEnrolmentLct */; END ';
      _stmtList.add_11rb$(element_63);
      var element_64 = ' CREATE TABLE IF NOT EXISTS LeavingReasonReplicate ( lrPk INTEGER NOT NULL, lrVersionId INTEGER NOT NULL DEFAULT 0, lrDestination INTEGER NOT NULL, lrPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (lrPk, lrDestination)) ';
      _stmtList.add_11rb$(element_64);
      var element_65 = ' CREATE INDEX index_LeavingReasonReplicate_lrPk_lrDestination_lrVersionId ON LeavingReasonReplicate (lrPk, lrDestination, lrVersionId) ';
      _stmtList.add_11rb$(element_65);
      var element_66 = ' CREATE INDEX index_LeavingReasonReplicate_lrDestination_lrPending ON LeavingReasonReplicate (lrDestination, lrPending) ';
      _stmtList.add_11rb$(element_66);
      var element_67 = ' CREATE TRIGGER ch_ins_410 AFTER INSERT ON LeavingReason BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 410 AS chTableId, NEW.leavingReasonUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 410 AND chEntityPk = NEW.leavingReasonUid); END ';
      _stmtList.add_11rb$(element_67);
      var element_68 = ' CREATE TRIGGER ch_upd_410 AFTER UPDATE ON LeavingReason BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 410 AS chTableId, NEW.leavingReasonUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 410 AND chEntityPk = NEW.leavingReasonUid); END ';
      _stmtList.add_11rb$(element_68);
      var element_69 = ' CREATE TRIGGER ch_del_410 AFTER DELETE ON LeavingReason BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 410 AS chTableId, OLD.leavingReasonUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 410 AND chEntityPk = OLD.leavingReasonUid); END ';
      _stmtList.add_11rb$(element_69);
      var element_70 = 'CREATE VIEW LeavingReason_ReceiveView AS  SELECT LeavingReason.*, LeavingReasonReplicate.* FROM LeavingReason LEFT JOIN LeavingReasonReplicate ON LeavingReasonReplicate.lrPk = LeavingReason.leavingReasonUid ';
      _stmtList.add_11rb$(element_70);
      var element_71 = ' CREATE TRIGGER leavingreason_remote_insert_ins INSTEAD OF INSERT ON LeavingReason_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LeavingReason(leavingReasonUid, leavingReasonTitle, leavingReasonMCSN, leavingReasonCSN, leavingReasonLCB, leavingReasonLct) VALUES (NEW.leavingReasonUid, NEW.leavingReasonTitle, NEW.leavingReasonMCSN, NEW.leavingReasonCSN, NEW.leavingReasonLCB, NEW.leavingReasonLct) /*psql ON CONFLICT (leavingReasonUid) DO UPDATE SET leavingReasonTitle = EXCLUDED.leavingReasonTitle, leavingReasonMCSN = EXCLUDED.leavingReasonMCSN, leavingReasonCSN = EXCLUDED.leavingReasonCSN, leavingReasonLCB = EXCLUDED.leavingReasonLCB, leavingReasonLct = EXCLUDED.leavingReasonLct */; END ';
      _stmtList.add_11rb$(element_71);
      var element_72 = ' CREATE TABLE IF NOT EXISTS ContentEntryReplicate ( cePk INTEGER NOT NULL, ceVersionId INTEGER NOT NULL DEFAULT 0, ceDestination INTEGER NOT NULL, cePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (cePk, ceDestination)) ';
      _stmtList.add_11rb$(element_72);
      var element_73 = ' CREATE INDEX index_ContentEntryReplicate_cePk_ceDestination_ceVersionId ON ContentEntryReplicate (cePk, ceDestination, ceVersionId) ';
      _stmtList.add_11rb$(element_73);
      var element_74 = ' CREATE INDEX index_ContentEntryReplicate_ceDestination_cePending ON ContentEntryReplicate (ceDestination, cePending) ';
      _stmtList.add_11rb$(element_74);
      var element_75 = ' CREATE TRIGGER ch_ins_42 AFTER INSERT ON ContentEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 42 AS chTableId, NEW.contentEntryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 42 AND chEntityPk = NEW.contentEntryUid); END ';
      _stmtList.add_11rb$(element_75);
      var element_76 = ' CREATE TRIGGER ch_upd_42 AFTER UPDATE ON ContentEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 42 AS chTableId, NEW.contentEntryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 42 AND chEntityPk = NEW.contentEntryUid); END ';
      _stmtList.add_11rb$(element_76);
      var element_77 = ' CREATE TRIGGER ch_del_42 AFTER DELETE ON ContentEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 42 AS chTableId, OLD.contentEntryUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 42 AND chEntityPk = OLD.contentEntryUid); END ';
      _stmtList.add_11rb$(element_77);
      var element_78 = 'CREATE VIEW ContentEntry_ReceiveView AS  SELECT ContentEntry.*, ContentEntryReplicate.* FROM ContentEntry LEFT JOIN ContentEntryReplicate ON ContentEntryReplicate.cePk = ContentEntry.contentEntryUid ';
      _stmtList.add_11rb$(element_78);
      var element_79 = ' CREATE TRIGGER contententry_remote_insert_ins INSTEAD OF INSERT ON ContentEntry_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntry(contentEntryUid, title, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, contentFlags, leaf, publik, ceInactive, completionCriteria, minScore, contentTypeFlag, contentOwner, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct) VALUES (NEW.contentEntryUid, NEW.title, NEW.description, NEW.entryId, NEW.author, NEW.publisher, NEW.licenseType, NEW.licenseName, NEW.licenseUrl, NEW.sourceUrl, NEW.thumbnailUrl, NEW.lastModified, NEW.primaryLanguageUid, NEW.languageVariantUid, NEW.contentFlags, NEW.leaf, NEW.publik, NEW.ceInactive, NEW.completionCriteria, NEW.minScore, NEW.contentTypeFlag, NEW.contentOwner, NEW.contentEntryLocalChangeSeqNum, NEW.contentEntryMasterChangeSeqNum, NEW.contentEntryLastChangedBy, NEW.contentEntryLct) /*psql ON CONFLICT (contentEntryUid) DO UPDATE SET title = EXCLUDED.title, description = EXCLUDED.description, entryId = EXCLUDED.entryId, author = EXCLUDED.author, publisher = EXCLUDED.publisher, licenseType = EXCLUDED.licenseType, licenseName = EXCLUDED.licenseName, licenseUrl = EXCLUDED.licenseUrl, sourceUrl = EXCLUDED.sourceUrl, thumbnailUrl = EXCLUDED.thumbnailUrl, lastModified = EXCLUDED.lastModified, primaryLanguageUid = EXCLUDED.primaryLanguageUid, languageVariantUid = EXCLUDED.languageVariantUid, contentFlags = EXCLUDED.contentFlags, leaf = EXCLUDED.leaf, publik = EXCLUDED.publik, ceInactive = EXCLUDED.ceInactive, completionCriteria = EXCLUDED.completionCriteria, minScore = EXCLUDED.minScore, contentTypeFlag = EXCLUDED.contentTypeFlag, contentOwner = EXCLUDED.contentOwner, contentEntryLocalChangeSeqNum = EXCLUDED.contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum = EXCLUDED.contentEntryMasterChangeSeqNum, contentEntryLastChangedBy = EXCLUDED.contentEntryLastChangedBy, contentEntryLct = EXCLUDED.contentEntryLct*/; END ';
      _stmtList.add_11rb$(element_79);
      var element_80 = ' CREATE TABLE IF NOT EXISTS ContentEntryContentCategoryJoinReplicate ( ceccjPk INTEGER NOT NULL, ceccjVersionId INTEGER NOT NULL DEFAULT 0, ceccjDestination INTEGER NOT NULL, ceccjPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (ceccjPk, ceccjDestination)) ';
      _stmtList.add_11rb$(element_80);
      var element_81 = ' CREATE INDEX index_ContentEntryContentCategoryJoinReplicate_ceccjPk_ceccjDestination_ceccjVersionId ON ContentEntryContentCategoryJoinReplicate (ceccjPk, ceccjDestination, ceccjVersionId) ';
      _stmtList.add_11rb$(element_81);
      var element_82 = ' CREATE INDEX index_ContentEntryContentCategoryJoinReplicate_ceccjDestination_ceccjPending ON ContentEntryContentCategoryJoinReplicate (ceccjDestination, ceccjPending) ';
      _stmtList.add_11rb$(element_82);
      var element_83 = ' CREATE TRIGGER ch_ins_3 AFTER INSERT ON ContentEntryContentCategoryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 3 AS chTableId, NEW.ceccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 3 AND chEntityPk = NEW.ceccjUid); END ';
      _stmtList.add_11rb$(element_83);
      var element_84 = ' CREATE TRIGGER ch_upd_3 AFTER UPDATE ON ContentEntryContentCategoryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 3 AS chTableId, NEW.ceccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 3 AND chEntityPk = NEW.ceccjUid); END ';
      _stmtList.add_11rb$(element_84);
      var element_85 = ' CREATE TRIGGER ch_del_3 AFTER DELETE ON ContentEntryContentCategoryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 3 AS chTableId, OLD.ceccjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 3 AND chEntityPk = OLD.ceccjUid); END ';
      _stmtList.add_11rb$(element_85);
      var element_86 = 'CREATE VIEW ContentEntryContentCategoryJoin_ReceiveView AS  SELECT ContentEntryContentCategoryJoin.*, ContentEntryContentCategoryJoinReplicate.* FROM ContentEntryContentCategoryJoin LEFT JOIN ContentEntryContentCategoryJoinReplicate ON ContentEntryContentCategoryJoinReplicate.ceccjPk = ContentEntryContentCategoryJoin.ceccjUid ';
      _stmtList.add_11rb$(element_86);
      var element_87 = ' CREATE TRIGGER contententrycontentcategoryjoin_remote_insert_ins INSTEAD OF INSERT ON ContentEntryContentCategoryJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryContentCategoryJoin(ceccjUid, ceccjContentEntryUid, ceccjContentCategoryUid, ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum, ceccjLastChangedBy, ceccjLct) VALUES (NEW.ceccjUid, NEW.ceccjContentEntryUid, NEW.ceccjContentCategoryUid, NEW.ceccjLocalChangeSeqNum, NEW.ceccjMasterChangeSeqNum, NEW.ceccjLastChangedBy, NEW.ceccjLct) /*psql ON CONFLICT (ceccjUid) DO UPDATE SET ceccjContentEntryUid = EXCLUDED.ceccjContentEntryUid, ceccjContentCategoryUid = EXCLUDED.ceccjContentCategoryUid, ceccjLocalChangeSeqNum = EXCLUDED.ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum = EXCLUDED.ceccjMasterChangeSeqNum, ceccjLastChangedBy = EXCLUDED.ceccjLastChangedBy, ceccjLct = EXCLUDED.ceccjLct */; END ';
      _stmtList.add_11rb$(element_87);
      var element_88 = ' CREATE TABLE IF NOT EXISTS ContentEntryParentChildJoinReplicate ( cepcjPk INTEGER NOT NULL, cepcjVersionId INTEGER NOT NULL DEFAULT 0, cepcjDestination INTEGER NOT NULL, cepcjPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (cepcjPk, cepcjDestination)) ';
      _stmtList.add_11rb$(element_88);
      var element_89 = ' CREATE INDEX index_ContentEntryParentChildJoinReplicate_cepcjPk_cepcjDestination_cepcjVersionId ON ContentEntryParentChildJoinReplicate (cepcjPk, cepcjDestination, cepcjVersionId) ';
      _stmtList.add_11rb$(element_89);
      var element_90 = ' CREATE INDEX index_ContentEntryParentChildJoinReplicate_cepcjDestination_cepcjPending ON ContentEntryParentChildJoinReplicate (cepcjDestination, cepcjPending) ';
      _stmtList.add_11rb$(element_90);
      var element_91 = ' CREATE TRIGGER ch_ins_7 AFTER INSERT ON ContentEntryParentChildJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 7 AS chTableId, NEW.cepcjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 7 AND chEntityPk = NEW.cepcjUid); END ';
      _stmtList.add_11rb$(element_91);
      var element_92 = ' CREATE TRIGGER ch_upd_7 AFTER UPDATE ON ContentEntryParentChildJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 7 AS chTableId, NEW.cepcjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 7 AND chEntityPk = NEW.cepcjUid); END ';
      _stmtList.add_11rb$(element_92);
      var element_93 = ' CREATE TRIGGER ch_del_7 AFTER DELETE ON ContentEntryParentChildJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 7 AS chTableId, OLD.cepcjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 7 AND chEntityPk = OLD.cepcjUid); END ';
      _stmtList.add_11rb$(element_93);
      var element_94 = 'CREATE VIEW ContentEntryParentChildJoin_ReceiveView AS  SELECT ContentEntryParentChildJoin.*, ContentEntryParentChildJoinReplicate.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntryParentChildJoinReplicate ON ContentEntryParentChildJoinReplicate.cepcjPk = ContentEntryParentChildJoin.cepcjUid ';
      _stmtList.add_11rb$(element_94);
      var element_95 = ' CREATE TRIGGER contententryparentchildjoin_remote_insert_ins INSTEAD OF INSERT ON ContentEntryParentChildJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryParentChildJoin(cepcjParentContentEntryUid, cepcjChildContentEntryUid, childIndex, cepcjUid, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct) VALUES (NEW.cepcjParentContentEntryUid, NEW.cepcjChildContentEntryUid, NEW.childIndex, NEW.cepcjUid, NEW.cepcjLocalChangeSeqNum, NEW.cepcjMasterChangeSeqNum, NEW.cepcjLastChangedBy, NEW.cepcjLct) /*psql ON CONFLICT (cepcjUid) DO UPDATE SET cepcjParentContentEntryUid = EXCLUDED.cepcjParentContentEntryUid, cepcjChildContentEntryUid = EXCLUDED.cepcjChildContentEntryUid, childIndex = EXCLUDED.childIndex, cepcjLocalChangeSeqNum = EXCLUDED.cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum = EXCLUDED.cepcjMasterChangeSeqNum, cepcjLastChangedBy = EXCLUDED.cepcjLastChangedBy, cepcjLct = EXCLUDED.cepcjLct */; END ';
      _stmtList.add_11rb$(element_95);
      var element_96 = ' CREATE TABLE IF NOT EXISTS ContentEntryRelatedEntryJoinReplicate ( cerejPk INTEGER NOT NULL, cerejVersionId INTEGER NOT NULL DEFAULT 0, cerejDestination INTEGER NOT NULL, cerejPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (cerejPk, cerejDestination)) ';
      _stmtList.add_11rb$(element_96);
      var element_97 = ' CREATE INDEX index_ContentEntryRelatedEntryJoinReplicate_cerejPk_cerejDestination_cerejVersionId ON ContentEntryRelatedEntryJoinReplicate (cerejPk, cerejDestination, cerejVersionId) ';
      _stmtList.add_11rb$(element_97);
      var element_98 = ' CREATE INDEX index_ContentEntryRelatedEntryJoinReplicate_cerejDestination_cerejPending ON ContentEntryRelatedEntryJoinReplicate (cerejDestination, cerejPending) ';
      _stmtList.add_11rb$(element_98);
      var element_99 = ' CREATE TRIGGER ch_ins_8 AFTER INSERT ON ContentEntryRelatedEntryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 8 AS chTableId, NEW.cerejUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 8 AND chEntityPk = NEW.cerejUid); END ';
      _stmtList.add_11rb$(element_99);
      var element_100 = ' CREATE TRIGGER ch_upd_8 AFTER UPDATE ON ContentEntryRelatedEntryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 8 AS chTableId, NEW.cerejUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 8 AND chEntityPk = NEW.cerejUid); END ';
      _stmtList.add_11rb$(element_100);
      var element_101 = ' CREATE TRIGGER ch_del_8 AFTER DELETE ON ContentEntryRelatedEntryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 8 AS chTableId, OLD.cerejUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 8 AND chEntityPk = OLD.cerejUid); END ';
      _stmtList.add_11rb$(element_101);
      var element_102 = 'CREATE VIEW ContentEntryRelatedEntryJoin_ReceiveView AS  SELECT ContentEntryRelatedEntryJoin.*, ContentEntryRelatedEntryJoinReplicate.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntryRelatedEntryJoinReplicate ON ContentEntryRelatedEntryJoinReplicate.cerejPk = ContentEntryRelatedEntryJoin.cerejUid ';
      _stmtList.add_11rb$(element_102);
      var element_103 = ' CREATE TRIGGER contententryrelatedentryjoin_remote_insert_ins INSTEAD OF INSERT ON ContentEntryRelatedEntryJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryRelatedEntryJoin(cerejUid, cerejContentEntryUid, cerejRelatedEntryUid, cerejLastChangedBy, relType, comment, cerejRelLanguageUid, cerejLocalChangeSeqNum, cerejMasterChangeSeqNum, cerejLct) VALUES (NEW.cerejUid, NEW.cerejContentEntryUid, NEW.cerejRelatedEntryUid, NEW.cerejLastChangedBy, NEW.relType, NEW.comment, NEW.cerejRelLanguageUid, NEW.cerejLocalChangeSeqNum, NEW.cerejMasterChangeSeqNum, NEW.cerejLct) /*psql ON CONFLICT (cerejUid) DO UPDATE SET cerejContentEntryUid = EXCLUDED.cerejContentEntryUid, cerejRelatedEntryUid = EXCLUDED.cerejRelatedEntryUid, cerejLastChangedBy = EXCLUDED.cerejLastChangedBy, relType = EXCLUDED.relType, comment = EXCLUDED.comment, cerejRelLanguageUid = EXCLUDED.cerejRelLanguageUid, cerejLocalChangeSeqNum = EXCLUDED.cerejLocalChangeSeqNum, cerejMasterChangeSeqNum = EXCLUDED.cerejMasterChangeSeqNum, cerejLct = EXCLUDED.cerejLct */; END ';
      _stmtList.add_11rb$(element_103);
      var element_104 = ' CREATE TABLE IF NOT EXISTS ContentCategorySchemaReplicate ( ccsPk INTEGER NOT NULL, ccsVersionId INTEGER NOT NULL DEFAULT 0, ccsDestination INTEGER NOT NULL, ccsPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (ccsPk, ccsDestination)) ';
      _stmtList.add_11rb$(element_104);
      var element_105 = ' CREATE INDEX index_ContentCategorySchemaReplicate_ccsPk_ccsDestination_ccsVersionId ON ContentCategorySchemaReplicate (ccsPk, ccsDestination, ccsVersionId) ';
      _stmtList.add_11rb$(element_105);
      var element_106 = ' CREATE INDEX index_ContentCategorySchemaReplicate_ccsDestination_ccsPending ON ContentCategorySchemaReplicate (ccsDestination, ccsPending) ';
      _stmtList.add_11rb$(element_106);
      var element_107 = ' CREATE TRIGGER ch_ins_2 AFTER INSERT ON ContentCategorySchema BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 2 AS chTableId, NEW.contentCategorySchemaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 2 AND chEntityPk = NEW.contentCategorySchemaUid); END ';
      _stmtList.add_11rb$(element_107);
      var element_108 = ' CREATE TRIGGER ch_upd_2 AFTER UPDATE ON ContentCategorySchema BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 2 AS chTableId, NEW.contentCategorySchemaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 2 AND chEntityPk = NEW.contentCategorySchemaUid); END ';
      _stmtList.add_11rb$(element_108);
      var element_109 = ' CREATE TRIGGER ch_del_2 AFTER DELETE ON ContentCategorySchema BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 2 AS chTableId, OLD.contentCategorySchemaUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 2 AND chEntityPk = OLD.contentCategorySchemaUid); END ';
      _stmtList.add_11rb$(element_109);
      var element_110 = 'CREATE VIEW ContentCategorySchema_ReceiveView AS  SELECT ContentCategorySchema.*, ContentCategorySchemaReplicate.* FROM ContentCategorySchema LEFT JOIN ContentCategorySchemaReplicate ON ContentCategorySchemaReplicate.ccsPk = ContentCategorySchema.contentCategorySchemaUid ';
      _stmtList.add_11rb$(element_110);
      var element_111 = ' CREATE TRIGGER contentcategoryschema_remote_insert_ins INSTEAD OF INSERT ON ContentCategorySchema_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentCategorySchema(contentCategorySchemaUid, schemaName, schemaUrl, contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy, contentCategorySchemaLct) VALUES (NEW.contentCategorySchemaUid, NEW.schemaName, NEW.schemaUrl, NEW.contentCategorySchemaLocalChangeSeqNum, NEW.contentCategorySchemaMasterChangeSeqNum, NEW.contentCategorySchemaLastChangedBy, NEW.contentCategorySchemaLct) /*psql ON CONFLICT (contentCategorySchemaUid) DO UPDATE SET schemaName = EXCLUDED.schemaName, schemaUrl = EXCLUDED.schemaUrl, contentCategorySchemaLocalChangeSeqNum = EXCLUDED.contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum = EXCLUDED.contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy = EXCLUDED.contentCategorySchemaLastChangedBy, contentCategorySchemaLct = EXCLUDED.contentCategorySchemaLct */; END ';
      _stmtList.add_11rb$(element_111);
      var element_112 = ' CREATE TABLE IF NOT EXISTS ContentCategoryReplicate ( ccPk INTEGER NOT NULL, ccVersionId INTEGER NOT NULL DEFAULT 0, ccDestination INTEGER NOT NULL, ccPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (ccPk, ccDestination)) ';
      _stmtList.add_11rb$(element_112);
      var element_113 = ' CREATE INDEX index_ContentCategoryReplicate_ccPk_ccDestination_ccVersionId ON ContentCategoryReplicate (ccPk, ccDestination, ccVersionId) ';
      _stmtList.add_11rb$(element_113);
      var element_114 = ' CREATE INDEX index_ContentCategoryReplicate_ccDestination_ccPending ON ContentCategoryReplicate (ccDestination, ccPending) ';
      _stmtList.add_11rb$(element_114);
      var element_115 = ' CREATE TRIGGER ch_ins_1 AFTER INSERT ON ContentCategory BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 1 AS chTableId, NEW.contentCategoryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 1 AND chEntityPk = NEW.contentCategoryUid); END ';
      _stmtList.add_11rb$(element_115);
      var element_116 = ' CREATE TRIGGER ch_upd_1 AFTER UPDATE ON ContentCategory BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 1 AS chTableId, NEW.contentCategoryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 1 AND chEntityPk = NEW.contentCategoryUid); END ';
      _stmtList.add_11rb$(element_116);
      var element_117 = ' CREATE TRIGGER ch_del_1 AFTER DELETE ON ContentCategory BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 1 AS chTableId, OLD.contentCategoryUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 1 AND chEntityPk = OLD.contentCategoryUid); END ';
      _stmtList.add_11rb$(element_117);
      var element_118 = 'CREATE VIEW ContentCategory_ReceiveView AS  SELECT ContentCategory.*, ContentCategoryReplicate.* FROM ContentCategory LEFT JOIN ContentCategoryReplicate ON ContentCategoryReplicate.ccPk = ContentCategory.contentCategoryUid ';
      _stmtList.add_11rb$(element_118);
      var element_119 = ' CREATE TRIGGER contentcategory_remote_insert_ins INSTEAD OF INSERT ON ContentCategory_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentCategory(contentCategoryUid, ctnCatContentCategorySchemaUid, name, contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy, contentCategoryLct) VALUES (NEW.contentCategoryUid, NEW.ctnCatContentCategorySchemaUid, NEW.name, NEW.contentCategoryLocalChangeSeqNum, NEW.contentCategoryMasterChangeSeqNum, NEW.contentCategoryLastChangedBy, NEW.contentCategoryLct) /*psql ON CONFLICT (contentCategoryUid) DO UPDATE SET ctnCatContentCategorySchemaUid = EXCLUDED.ctnCatContentCategorySchemaUid, name = EXCLUDED.name, contentCategoryLocalChangeSeqNum = EXCLUDED.contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum = EXCLUDED.contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy = EXCLUDED.contentCategoryLastChangedBy, contentCategoryLct = EXCLUDED.contentCategoryLct */; END ';
      _stmtList.add_11rb$(element_119);
      var element_120 = ' CREATE TABLE IF NOT EXISTS LanguageReplicate ( languagePk INTEGER NOT NULL, languageVersionId INTEGER NOT NULL DEFAULT 0, languageDestination INTEGER NOT NULL, languagePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (languagePk, languageDestination)) ';
      _stmtList.add_11rb$(element_120);
      var element_121 = ' CREATE INDEX index_LanguageReplicate_languagePk_languageDestination_languageVersionId ON LanguageReplicate (languagePk, languageDestination, languageVersionId) ';
      _stmtList.add_11rb$(element_121);
      var element_122 = ' CREATE INDEX index_LanguageReplicate_languageDestination_languagePending ON LanguageReplicate (languageDestination, languagePending) ';
      _stmtList.add_11rb$(element_122);
      var element_123 = ' CREATE TRIGGER ch_ins_13 AFTER INSERT ON Language BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 13 AS chTableId, NEW.langUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 13 AND chEntityPk = NEW.langUid); END ';
      _stmtList.add_11rb$(element_123);
      var element_124 = ' CREATE TRIGGER ch_upd_13 AFTER UPDATE ON Language BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 13 AS chTableId, NEW.langUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 13 AND chEntityPk = NEW.langUid); END ';
      _stmtList.add_11rb$(element_124);
      var element_125 = ' CREATE TRIGGER ch_del_13 AFTER DELETE ON Language BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 13 AS chTableId, OLD.langUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 13 AND chEntityPk = OLD.langUid); END ';
      _stmtList.add_11rb$(element_125);
      var element_126 = 'CREATE VIEW Language_ReceiveView AS  SELECT Language.*, LanguageReplicate.* FROM Language LEFT JOIN LanguageReplicate ON LanguageReplicate.languagePk = Language.langUid ';
      _stmtList.add_11rb$(element_126);
      var element_127 = ' CREATE TRIGGER language_remote_insert_ins INSTEAD OF INSERT ON Language_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Language(langUid, name, iso_639_1_standard, iso_639_2_standard, iso_639_3_standard, Language_Type, languageActive, langLocalChangeSeqNum, langMasterChangeSeqNum, langLastChangedBy, langLct) VALUES (NEW.langUid, NEW.name, NEW.iso_639_1_standard, NEW.iso_639_2_standard, NEW.iso_639_3_standard, NEW.Language_Type, NEW.languageActive, NEW.langLocalChangeSeqNum, NEW.langMasterChangeSeqNum, NEW.langLastChangedBy, NEW.langLct) /*psql ON CONFLICT (langUid) DO UPDATE SET name = EXCLUDED.name, iso_639_1_standard = EXCLUDED.iso_639_1_standard, iso_639_2_standard = EXCLUDED.iso_639_2_standard, iso_639_3_standard = EXCLUDED.iso_639_3_standard, Language_Type = EXCLUDED.Language_Type, languageActive = EXCLUDED.languageActive, langLocalChangeSeqNum = EXCLUDED.langLocalChangeSeqNum, langMasterChangeSeqNum = EXCLUDED.langMasterChangeSeqNum, langLastChangedBy = EXCLUDED.langLastChangedBy, langLct = EXCLUDED.langLct */; END ';
      _stmtList.add_11rb$(element_127);
      var element_128 = ' CREATE TABLE IF NOT EXISTS LanguageVariantReplicate ( lvPk INTEGER NOT NULL, lvVersionId INTEGER NOT NULL DEFAULT 0, lvDestination INTEGER NOT NULL, lvPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (lvPk, lvDestination)) ';
      _stmtList.add_11rb$(element_128);
      var element_129 = ' CREATE INDEX index_LanguageVariantReplicate_lvPk_lvDestination_lvVersionId ON LanguageVariantReplicate (lvPk, lvDestination, lvVersionId) ';
      _stmtList.add_11rb$(element_129);
      var element_130 = ' CREATE INDEX index_LanguageVariantReplicate_lvDestination_lvPending ON LanguageVariantReplicate (lvDestination, lvPending) ';
      _stmtList.add_11rb$(element_130);
      var element_131 = ' CREATE TRIGGER ch_ins_10 AFTER INSERT ON LanguageVariant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 10 AS chTableId, NEW.langVariantUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 10 AND chEntityPk = NEW.langVariantUid); END ';
      _stmtList.add_11rb$(element_131);
      var element_132 = ' CREATE TRIGGER ch_upd_10 AFTER UPDATE ON LanguageVariant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 10 AS chTableId, NEW.langVariantUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 10 AND chEntityPk = NEW.langVariantUid); END ';
      _stmtList.add_11rb$(element_132);
      var element_133 = ' CREATE TRIGGER ch_del_10 AFTER DELETE ON LanguageVariant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 10 AS chTableId, OLD.langVariantUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 10 AND chEntityPk = OLD.langVariantUid); END ';
      _stmtList.add_11rb$(element_133);
      var element_134 = 'CREATE VIEW LanguageVariant_ReceiveView AS  SELECT LanguageVariant.*, LanguageVariantReplicate.* FROM LanguageVariant LEFT JOIN LanguageVariantReplicate ON LanguageVariantReplicate.lvPk = LanguageVariant.langVariantUid ';
      _stmtList.add_11rb$(element_134);
      var element_135 = ' CREATE TRIGGER languagevariant_remote_insert_ins INSTEAD OF INSERT ON LanguageVariant_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LanguageVariant(langVariantUid, langUid, countryCode, name, langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum, langVariantLastChangedBy, langVariantLct) VALUES (NEW.langVariantUid, NEW.langUid, NEW.countryCode, NEW.name, NEW.langVariantLocalChangeSeqNum, NEW.langVariantMasterChangeSeqNum, NEW.langVariantLastChangedBy, NEW.langVariantLct) /*psql ON CONFLICT (langVariantUid) DO UPDATE SET langUid = EXCLUDED.langUid, countryCode = EXCLUDED.countryCode, name = EXCLUDED.name, langVariantLocalChangeSeqNum = EXCLUDED.langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum = EXCLUDED.langVariantMasterChangeSeqNum, langVariantLastChangedBy = EXCLUDED.langVariantLastChangedBy, langVariantLct = EXCLUDED.langVariantLct */; END ';
      _stmtList.add_11rb$(element_135);
      var element_136 = ' CREATE TABLE IF NOT EXISTS PersonGroupReplicate ( pgPk INTEGER NOT NULL, pgVersionId INTEGER NOT NULL DEFAULT 0, pgDestination INTEGER NOT NULL, pgPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (pgPk, pgDestination)) ';
      _stmtList.add_11rb$(element_136);
      var element_137 = ' CREATE INDEX index_PersonGroupReplicate_pgPk_pgDestination_pgVersionId ON PersonGroupReplicate (pgPk, pgDestination, pgVersionId) ';
      _stmtList.add_11rb$(element_137);
      var element_138 = ' CREATE INDEX index_PersonGroupReplicate_pgDestination_pgPending ON PersonGroupReplicate (pgDestination, pgPending) ';
      _stmtList.add_11rb$(element_138);
      var element_139 = ' CREATE TRIGGER ch_ins_43 AFTER INSERT ON PersonGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 43 AS chTableId, NEW.groupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 43 AND chEntityPk = NEW.groupUid); END ';
      _stmtList.add_11rb$(element_139);
      var element_140 = ' CREATE TRIGGER ch_upd_43 AFTER UPDATE ON PersonGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 43 AS chTableId, NEW.groupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 43 AND chEntityPk = NEW.groupUid); END ';
      _stmtList.add_11rb$(element_140);
      var element_141 = ' CREATE TRIGGER ch_del_43 AFTER DELETE ON PersonGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 43 AS chTableId, OLD.groupUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 43 AND chEntityPk = OLD.groupUid); END ';
      _stmtList.add_11rb$(element_141);
      var element_142 = 'CREATE VIEW PersonGroup_ReceiveView AS  SELECT PersonGroup.*, PersonGroupReplicate.* FROM PersonGroup LEFT JOIN PersonGroupReplicate ON PersonGroupReplicate.pgPk = PersonGroup.groupUid ';
      _stmtList.add_11rb$(element_142);
      var element_143 = ' CREATE TRIGGER persongroup_remote_insert_ins INSTEAD OF INSERT ON PersonGroup_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonGroup(groupUid, groupMasterCsn, groupLocalCsn, groupLastChangedBy, groupLct, groupName, groupActive, personGroupFlag) VALUES (NEW.groupUid, NEW.groupMasterCsn, NEW.groupLocalCsn, NEW.groupLastChangedBy, NEW.groupLct, NEW.groupName, NEW.groupActive, NEW.personGroupFlag) /*psql ON CONFLICT (groupUid) DO UPDATE SET groupMasterCsn = EXCLUDED.groupMasterCsn, groupLocalCsn = EXCLUDED.groupLocalCsn, groupLastChangedBy = EXCLUDED.groupLastChangedBy, groupLct = EXCLUDED.groupLct, groupName = EXCLUDED.groupName, groupActive = EXCLUDED.groupActive, personGroupFlag = EXCLUDED.personGroupFlag */; END ';
      _stmtList.add_11rb$(element_143);
      var element_144 = ' CREATE TABLE IF NOT EXISTS PersonGroupMemberReplicate ( pgmPk INTEGER NOT NULL, pgmVersionId INTEGER NOT NULL DEFAULT 0, pgmDestination INTEGER NOT NULL, pgmPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (pgmPk, pgmDestination)) ';
      _stmtList.add_11rb$(element_144);
      var element_145 = ' CREATE INDEX index_PersonGroupMemberReplicate_pgmPk_pgmDestination_pgmVersionId ON PersonGroupMemberReplicate (pgmPk, pgmDestination, pgmVersionId) ';
      _stmtList.add_11rb$(element_145);
      var element_146 = ' CREATE INDEX index_PersonGroupMemberReplicate_pgmDestination_pgmPending ON PersonGroupMemberReplicate (pgmDestination, pgmPending) ';
      _stmtList.add_11rb$(element_146);
      var element_147 = ' CREATE TRIGGER ch_ins_44 AFTER INSERT ON PersonGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 44 AS chTableId, NEW.groupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 44 AND chEntityPk = NEW.groupMemberUid); END ';
      _stmtList.add_11rb$(element_147);
      var element_148 = ' CREATE TRIGGER ch_upd_44 AFTER UPDATE ON PersonGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 44 AS chTableId, NEW.groupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 44 AND chEntityPk = NEW.groupMemberUid); END ';
      _stmtList.add_11rb$(element_148);
      var element_149 = ' CREATE TRIGGER ch_del_44 AFTER DELETE ON PersonGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 44 AS chTableId, OLD.groupMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 44 AND chEntityPk = OLD.groupMemberUid); END ';
      _stmtList.add_11rb$(element_149);
      var element_150 = 'CREATE VIEW PersonGroupMember_ReceiveView AS  SELECT PersonGroupMember.*, PersonGroupMemberReplicate.* FROM PersonGroupMember LEFT JOIN PersonGroupMemberReplicate ON PersonGroupMemberReplicate.pgmPk = PersonGroupMember.groupMemberUid ';
      _stmtList.add_11rb$(element_150);
      var element_151 = ' CREATE TRIGGER persongroupmember_remote_insert_ins INSTEAD OF INSERT ON PersonGroupMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonGroupMember(groupMemberUid, groupMemberActive, groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy, groupMemberLct) VALUES (NEW.groupMemberUid, NEW.groupMemberActive, NEW.groupMemberPersonUid, NEW.groupMemberGroupUid, NEW.groupMemberMasterCsn, NEW.groupMemberLocalCsn, NEW.groupMemberLastChangedBy, NEW.groupMemberLct) /*psql ON CONFLICT (groupMemberUid) DO UPDATE SET groupMemberActive = EXCLUDED.groupMemberActive, groupMemberPersonUid = EXCLUDED.groupMemberPersonUid, groupMemberGroupUid = EXCLUDED.groupMemberGroupUid, groupMemberMasterCsn = EXCLUDED.groupMemberMasterCsn, groupMemberLocalCsn = EXCLUDED.groupMemberLocalCsn, groupMemberLastChangedBy = EXCLUDED.groupMemberLastChangedBy, groupMemberLct = EXCLUDED.groupMemberLct */; END ';
      _stmtList.add_11rb$(element_151);
      var element_152 = ' CREATE TABLE IF NOT EXISTS PersonPictureReplicate ( ppPk INTEGER NOT NULL, ppVersionId INTEGER NOT NULL DEFAULT 0, ppDestination INTEGER NOT NULL, ppPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (ppPk, ppDestination)) ';
      _stmtList.add_11rb$(element_152);
      var element_153 = ' CREATE INDEX index_PersonPictureReplicate_ppPk_ppDestination_ppVersionId ON PersonPictureReplicate (ppPk, ppDestination, ppVersionId) ';
      _stmtList.add_11rb$(element_153);
      var element_154 = ' CREATE INDEX index_PersonPictureReplicate_ppDestination_ppPending ON PersonPictureReplicate (ppDestination, ppPending) ';
      _stmtList.add_11rb$(element_154);
      var element_155 = ' CREATE TRIGGER ch_ins_50 AFTER INSERT ON PersonPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 50 AS chTableId, NEW.personPictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 50 AND chEntityPk = NEW.personPictureUid); END ';
      _stmtList.add_11rb$(element_155);
      var element_156 = ' CREATE TRIGGER ch_upd_50 AFTER UPDATE ON PersonPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 50 AS chTableId, NEW.personPictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 50 AND chEntityPk = NEW.personPictureUid); END ';
      _stmtList.add_11rb$(element_156);
      var element_157 = ' CREATE TRIGGER ch_del_50 AFTER DELETE ON PersonPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 50 AS chTableId, OLD.personPictureUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 50 AND chEntityPk = OLD.personPictureUid); END ';
      _stmtList.add_11rb$(element_157);
      var element_158 = 'CREATE VIEW PersonPicture_ReceiveView AS  SELECT PersonPicture.*, PersonPictureReplicate.* FROM PersonPicture LEFT JOIN PersonPictureReplicate ON PersonPictureReplicate.ppPk = PersonPicture.personPictureUid ';
      _stmtList.add_11rb$(element_158);
      var element_159 = ' CREATE TRIGGER personpicture_remote_insert_ins INSTEAD OF INSERT ON PersonPicture_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonPicture(personPictureUid, personPicturePersonUid, personPictureMasterCsn, personPictureLocalCsn, personPictureLastChangedBy, personPictureLct, personPictureUri, personPictureMd5, fileSize, picTimestamp, mimeType, personPictureActive) VALUES (NEW.personPictureUid, NEW.personPicturePersonUid, NEW.personPictureMasterCsn, NEW.personPictureLocalCsn, NEW.personPictureLastChangedBy, NEW.personPictureLct, NEW.personPictureUri, NEW.personPictureMd5, NEW.fileSize, NEW.picTimestamp, NEW.mimeType, NEW.personPictureActive) /*psql ON CONFLICT (personPictureUid) DO UPDATE SET personPicturePersonUid = EXCLUDED.personPicturePersonUid, personPictureMasterCsn = EXCLUDED.personPictureMasterCsn, personPictureLocalCsn = EXCLUDED.personPictureLocalCsn, personPictureLastChangedBy = EXCLUDED.personPictureLastChangedBy, personPictureLct = EXCLUDED.personPictureLct, personPictureUri = EXCLUDED.personPictureUri, personPictureMd5 = EXCLUDED.personPictureMd5, fileSize = EXCLUDED.fileSize, picTimestamp = EXCLUDED.picTimestamp, mimeType = EXCLUDED.mimeType, personPictureActive = EXCLUDED.personPictureActive */; END ';
      _stmtList.add_11rb$(element_159);
      var element_160 = ' CREATE TABLE IF NOT EXISTS ContainerReplicate ( containerPk INTEGER NOT NULL, containerVersionId INTEGER NOT NULL DEFAULT 0, containerDestination INTEGER NOT NULL, containerPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (containerPk, containerDestination)) ';
      _stmtList.add_11rb$(element_160);
      var element_161 = ' CREATE INDEX index_ContainerReplicate_containerPk_containerDestination_containerVersionId ON ContainerReplicate (containerPk, containerDestination, containerVersionId) ';
      _stmtList.add_11rb$(element_161);
      var element_162 = ' CREATE INDEX index_ContainerReplicate_containerDestination_containerPending ON ContainerReplicate (containerDestination, containerPending) ';
      _stmtList.add_11rb$(element_162);
      var element_163 = ' CREATE TRIGGER ch_ins_51 AFTER INSERT ON Container BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 51 AS chTableId, NEW.containerUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 51 AND chEntityPk = NEW.containerUid); END ';
      _stmtList.add_11rb$(element_163);
      var element_164 = ' CREATE TRIGGER ch_upd_51 AFTER UPDATE ON Container BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 51 AS chTableId, NEW.containerUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 51 AND chEntityPk = NEW.containerUid); END ';
      _stmtList.add_11rb$(element_164);
      var element_165 = ' CREATE TRIGGER ch_del_51 AFTER DELETE ON Container BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 51 AS chTableId, OLD.containerUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 51 AND chEntityPk = OLD.containerUid); END ';
      _stmtList.add_11rb$(element_165);
      var element_166 = 'CREATE VIEW Container_ReceiveView AS  SELECT Container.*, ContainerReplicate.* FROM Container LEFT JOIN ContainerReplicate ON ContainerReplicate.containerPk = Container.containerUid ';
      _stmtList.add_11rb$(element_166);
      var element_167 = ' CREATE TRIGGER container_remote_insert_ins INSTEAD OF INSERT ON Container_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Container(containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, cntLct, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries) VALUES (NEW.containerUid, NEW.cntLocalCsn, NEW.cntMasterCsn, NEW.cntLastModBy, NEW.cntLct, NEW.fileSize, NEW.containerContentEntryUid, NEW.cntLastModified, NEW.mimeType, NEW.remarks, NEW.mobileOptimized, NEW.cntNumEntries) /*psql ON CONFLICT (containerUid) DO UPDATE SET cntLocalCsn = EXCLUDED.cntLocalCsn, cntMasterCsn = EXCLUDED.cntMasterCsn, cntLastModBy = EXCLUDED.cntLastModBy, cntLct = EXCLUDED.cntLct, fileSize = EXCLUDED.fileSize, containerContentEntryUid = EXCLUDED.containerContentEntryUid, cntLastModified = EXCLUDED.cntLastModified, mimeType = EXCLUDED.mimeType, remarks = EXCLUDED.remarks, mobileOptimized = EXCLUDED.mobileOptimized, cntNumEntries = EXCLUDED.cntNumEntries */; END ';
      _stmtList.add_11rb$(element_167);
      var element_168 = ' CREATE TABLE IF NOT EXISTS VerbEntityReplicate ( vePk INTEGER NOT NULL, veVersionId INTEGER NOT NULL DEFAULT 0, veDestination INTEGER NOT NULL, vePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (vePk, veDestination)) ';
      _stmtList.add_11rb$(element_168);
      var element_169 = ' CREATE INDEX index_VerbEntityReplicate_vePk_veDestination_veVersionId ON VerbEntityReplicate (vePk, veDestination, veVersionId) ';
      _stmtList.add_11rb$(element_169);
      var element_170 = ' CREATE INDEX index_VerbEntityReplicate_veDestination_vePending ON VerbEntityReplicate (veDestination, vePending) ';
      _stmtList.add_11rb$(element_170);
      var element_171 = ' CREATE TRIGGER ch_ins_62 AFTER INSERT ON VerbEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 62 AS chTableId, NEW.verbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 62 AND chEntityPk = NEW.verbUid); END ';
      _stmtList.add_11rb$(element_171);
      var element_172 = ' CREATE TRIGGER ch_upd_62 AFTER UPDATE ON VerbEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 62 AS chTableId, NEW.verbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 62 AND chEntityPk = NEW.verbUid); END ';
      _stmtList.add_11rb$(element_172);
      var element_173 = ' CREATE TRIGGER ch_del_62 AFTER DELETE ON VerbEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 62 AS chTableId, OLD.verbUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 62 AND chEntityPk = OLD.verbUid); END ';
      _stmtList.add_11rb$(element_173);
      var element_174 = 'CREATE VIEW VerbEntity_ReceiveView AS  SELECT VerbEntity.*, VerbEntityReplicate.* FROM VerbEntity LEFT JOIN VerbEntityReplicate ON VerbEntityReplicate.vePk = VerbEntity.verbUid ';
      _stmtList.add_11rb$(element_174);
      var element_175 = ' CREATE TRIGGER verbentity_remote_insert_ins INSTEAD OF INSERT ON VerbEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO VerbEntity(verbUid, urlId, verbInActive, verbMasterChangeSeqNum, verbLocalChangeSeqNum, verbLastChangedBy, verbLct) VALUES (NEW.verbUid, NEW.urlId, NEW.verbInActive, NEW.verbMasterChangeSeqNum, NEW.verbLocalChangeSeqNum, NEW.verbLastChangedBy, NEW.verbLct) /*psql ON CONFLICT (verbUid) DO UPDATE SET urlId = EXCLUDED.urlId, verbInActive = EXCLUDED.verbInActive, verbMasterChangeSeqNum = EXCLUDED.verbMasterChangeSeqNum, verbLocalChangeSeqNum = EXCLUDED.verbLocalChangeSeqNum, verbLastChangedBy = EXCLUDED.verbLastChangedBy, verbLct = EXCLUDED.verbLct */; END ';
      _stmtList.add_11rb$(element_175);
      var element_176 = ' CREATE TABLE IF NOT EXISTS XObjectEntityReplicate ( xoePk INTEGER NOT NULL, xoeVersionId INTEGER NOT NULL DEFAULT 0, xoeDestination INTEGER NOT NULL, xoePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (xoePk, xoeDestination)) ';
      _stmtList.add_11rb$(element_176);
      var element_177 = ' CREATE INDEX index_XObjectEntityReplicate_xoePk_xoeDestination_xoeVersionId ON XObjectEntityReplicate (xoePk, xoeDestination, xoeVersionId) ';
      _stmtList.add_11rb$(element_177);
      var element_178 = ' CREATE INDEX index_XObjectEntityReplicate_xoeDestination_xoePending ON XObjectEntityReplicate (xoeDestination, xoePending) ';
      _stmtList.add_11rb$(element_178);
      var element_179 = ' CREATE TRIGGER ch_ins_64 AFTER INSERT ON XObjectEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 64 AS chTableId, NEW.xObjectUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 64 AND chEntityPk = NEW.xObjectUid); END ';
      _stmtList.add_11rb$(element_179);
      var element_180 = ' CREATE TRIGGER ch_upd_64 AFTER UPDATE ON XObjectEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 64 AS chTableId, NEW.xObjectUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 64 AND chEntityPk = NEW.xObjectUid); END ';
      _stmtList.add_11rb$(element_180);
      var element_181 = ' CREATE TRIGGER ch_del_64 AFTER DELETE ON XObjectEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 64 AS chTableId, OLD.xObjectUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 64 AND chEntityPk = OLD.xObjectUid); END ';
      _stmtList.add_11rb$(element_181);
      var element_182 = 'CREATE VIEW XObjectEntity_ReceiveView AS  SELECT XObjectEntity.*, XObjectEntityReplicate.* FROM XObjectEntity LEFT JOIN XObjectEntityReplicate ON XObjectEntityReplicate.xoePk = XObjectEntity.xObjectUid ';
      _stmtList.add_11rb$(element_182);
      var element_183 = ' CREATE TRIGGER xobjectentity_remote_insert_ins INSTEAD OF INSERT ON XObjectEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO XObjectEntity(xObjectUid, objectType, objectId, definitionType, interactionType, correctResponsePattern, objectContentEntryUid, xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum, xObjectLastChangedBy, xObjectLct) VALUES (NEW.xObjectUid, NEW.objectType, NEW.objectId, NEW.definitionType, NEW.interactionType, NEW.correctResponsePattern, NEW.objectContentEntryUid, NEW.xObjectMasterChangeSeqNum, NEW.xObjectocalChangeSeqNum, NEW.xObjectLastChangedBy, NEW.xObjectLct) /*psql ON CONFLICT (xObjectUid) DO UPDATE SET objectType = EXCLUDED.objectType, objectId = EXCLUDED.objectId, definitionType = EXCLUDED.definitionType, interactionType = EXCLUDED.interactionType, correctResponsePattern = EXCLUDED.correctResponsePattern, objectContentEntryUid = EXCLUDED.objectContentEntryUid, xObjectMasterChangeSeqNum = EXCLUDED.xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum = EXCLUDED.xObjectocalChangeSeqNum, xObjectLastChangedBy = EXCLUDED.xObjectLastChangedBy, xObjectLct = EXCLUDED.xObjectLct */; END ';
      _stmtList.add_11rb$(element_183);
      var element_184 = ' CREATE TABLE IF NOT EXISTS StatementEntityReplicate ( sePk INTEGER NOT NULL, seVersionId INTEGER NOT NULL DEFAULT 0, seDestination INTEGER NOT NULL, sePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (sePk, seDestination)) ';
      _stmtList.add_11rb$(element_184);
      var element_185 = ' CREATE INDEX index_StatementEntityReplicate_sePk_seDestination_seVersionId ON StatementEntityReplicate (sePk, seDestination, seVersionId) ';
      _stmtList.add_11rb$(element_185);
      var element_186 = ' CREATE INDEX index_StatementEntityReplicate_seDestination_sePending ON StatementEntityReplicate (seDestination, sePending) ';
      _stmtList.add_11rb$(element_186);
      var element_187 = ' CREATE TRIGGER ch_ins_60 AFTER INSERT ON StatementEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 60 AS chTableId, NEW.statementUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 60 AND chEntityPk = NEW.statementUid); END ';
      _stmtList.add_11rb$(element_187);
      var element_188 = ' CREATE TRIGGER ch_upd_60 AFTER UPDATE ON StatementEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 60 AS chTableId, NEW.statementUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 60 AND chEntityPk = NEW.statementUid); END ';
      _stmtList.add_11rb$(element_188);
      var element_189 = ' CREATE TRIGGER ch_del_60 AFTER DELETE ON StatementEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 60 AS chTableId, OLD.statementUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 60 AND chEntityPk = OLD.statementUid); END ';
      _stmtList.add_11rb$(element_189);
      var element_190 = 'CREATE VIEW StatementEntity_ReceiveView AS  SELECT StatementEntity.*, StatementEntityReplicate.* FROM StatementEntity LEFT JOIN StatementEntityReplicate ON StatementEntityReplicate.sePk = StatementEntity.statementUid ';
      _stmtList.add_11rb$(element_190);
      var element_191 = ' CREATE TRIGGER statemententity_remote_insert_ins INSTEAD OF INSERT ON StatementEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO StatementEntity(statementUid, statementId, statementPersonUid, statementVerbUid, xObjectUid, subStatementActorUid, substatementVerbUid, subStatementObjectUid, agentUid, instructorUid, authorityUid, teamUid, resultCompletion, resultSuccess, resultScoreScaled, resultScoreRaw, resultScoreMin, resultScoreMax, resultDuration, resultResponse, timestamp, stored, contextRegistration, contextPlatform, contextStatementId, fullStatement, statementMasterChangeSeqNum, statementLocalChangeSeqNum, statementLastChangedBy, statementLct, extensionProgress, contentEntryRoot, statementContentEntryUid, statementLearnerGroupUid, statementClazzUid) VALUES (NEW.statementUid, NEW.statementId, NEW.statementPersonUid, NEW.statementVerbUid, NEW.xObjectUid, NEW.subStatementActorUid, NEW.substatementVerbUid, NEW.subStatementObjectUid, NEW.agentUid, NEW.instructorUid, NEW.authorityUid, NEW.teamUid, NEW.resultCompletion, NEW.resultSuccess, NEW.resultScoreScaled, NEW.resultScoreRaw, NEW.resultScoreMin, NEW.resultScoreMax, NEW.resultDuration, NEW.resultResponse, NEW.timestamp, NEW.stored, NEW.contextRegistration, NEW.contextPlatform, NEW.contextStatementId, NEW.fullStatement, NEW.statementMasterChangeSeqNum, NEW.statementLocalChangeSeqNum, NEW.statementLastChangedBy, NEW.statementLct, NEW.extensionProgress, NEW.contentEntryRoot, NEW.statementContentEntryUid, NEW.statementLearnerGroupUid, NEW.statementClazzUid) /*psql ON CONFLICT (statementUid) DO UPDATE SET statementId = EXCLUDED.statementId, statementPersonUid = EXCLUDED.statementPersonUid, statementVerbUid = EXCLUDED.statementVerbUid, xObjectUid = EXCLUDED.xObjectUid, subStatementActorUid = EXCLUDED.subStatementActorUid, substatementVerbUid = EXCLUDED.substatementVerbUid, subStatementObjectUid = EXCLUDED.subStatementObjectUid, agentUid = EXCLUDED.agentUid, instructorUid = EXCLUDED.instructorUid, authorityUid = EXCLUDED.authorityUid, teamUid = EXCLUDED.teamUid, resultCompletion = EXCLUDED.resultCompletion, resultSuccess = EXCLUDED.resultSuccess, resultScoreScaled = EXCLUDED.resultScoreScaled, resultScoreRaw = EXCLUDED.resultScoreRaw, resultScoreMin = EXCLUDED.resultScoreMin, resultScoreMax = EXCLUDED.resultScoreMax, resultDuration = EXCLUDED.resultDuration, resultResponse = EXCLUDED.resultResponse, timestamp = EXCLUDED.timestamp, stored = EXCLUDED.stored, contextRegistration = EXCLUDED.contextRegistration, contextPlatform = EXCLUDED.contextPlatform, contextStatementId = EXCLUDED.contextStatementId, fullStatement = EXCLUDED.fullStatement, statementMasterChangeSeqNum = EXCLUDED.statementMasterChangeSeqNum, statementLocalChangeSeqNum = EXCLUDED.statementLocalChangeSeqNum, statementLastChangedBy = EXCLUDED.statementLastChangedBy, statementLct = EXCLUDED.statementLct, extensionProgress = EXCLUDED.extensionProgress, contentEntryRoot = EXCLUDED.contentEntryRoot, statementContentEntryUid = EXCLUDED.statementContentEntryUid, statementLearnerGroupUid = EXCLUDED.statementLearnerGroupUid, statementClazzUid = EXCLUDED.statementClazzUid */; END ';
      _stmtList.add_11rb$(element_191);
      var element_192 = ' CREATE TABLE IF NOT EXISTS ContextXObjectStatementJoinReplicate ( cxosjPk INTEGER NOT NULL, cxosjVersionId INTEGER NOT NULL DEFAULT 0, cxosjDestination INTEGER NOT NULL, cxosjPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (cxosjPk, cxosjDestination)) ';
      _stmtList.add_11rb$(element_192);
      var element_193 = ' CREATE INDEX index_ContextXObjectStatementJoinReplicate_cxosjPk_cxosjDestination_cxosjVersionId ON ContextXObjectStatementJoinReplicate (cxosjPk, cxosjDestination, cxosjVersionId) ';
      _stmtList.add_11rb$(element_193);
      var element_194 = ' CREATE INDEX index_ContextXObjectStatementJoinReplicate_cxosjDestination_cxosjPending ON ContextXObjectStatementJoinReplicate (cxosjDestination, cxosjPending) ';
      _stmtList.add_11rb$(element_194);
      var element_195 = ' CREATE TRIGGER ch_ins_66 AFTER INSERT ON ContextXObjectStatementJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 66 AS chTableId, NEW.contextXObjectStatementJoinUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 66 AND chEntityPk = NEW.contextXObjectStatementJoinUid); END ';
      _stmtList.add_11rb$(element_195);
      var element_196 = ' CREATE TRIGGER ch_upd_66 AFTER UPDATE ON ContextXObjectStatementJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 66 AS chTableId, NEW.contextXObjectStatementJoinUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 66 AND chEntityPk = NEW.contextXObjectStatementJoinUid); END ';
      _stmtList.add_11rb$(element_196);
      var element_197 = ' CREATE TRIGGER ch_del_66 AFTER DELETE ON ContextXObjectStatementJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 66 AS chTableId, OLD.contextXObjectStatementJoinUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 66 AND chEntityPk = OLD.contextXObjectStatementJoinUid); END ';
      _stmtList.add_11rb$(element_197);
      var element_198 = 'CREATE VIEW ContextXObjectStatementJoin_ReceiveView AS  SELECT ContextXObjectStatementJoin.*, ContextXObjectStatementJoinReplicate.* FROM ContextXObjectStatementJoin LEFT JOIN ContextXObjectStatementJoinReplicate ON ContextXObjectStatementJoinReplicate.cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid ';
      _stmtList.add_11rb$(element_198);
      var element_199 = ' CREATE TRIGGER contextxobjectstatementjoin_remote_insert_ins INSTEAD OF INSERT ON ContextXObjectStatementJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContextXObjectStatementJoin(contextXObjectStatementJoinUid, contextActivityFlag, contextStatementUid, contextXObjectUid, verbMasterChangeSeqNum, verbLocalChangeSeqNum, verbLastChangedBy, contextXObjectLct) VALUES (NEW.contextXObjectStatementJoinUid, NEW.contextActivityFlag, NEW.contextStatementUid, NEW.contextXObjectUid, NEW.verbMasterChangeSeqNum, NEW.verbLocalChangeSeqNum, NEW.verbLastChangedBy, NEW.contextXObjectLct) /*psql ON CONFLICT (contextXObjectStatementJoinUid) DO UPDATE SET contextActivityFlag = EXCLUDED.contextActivityFlag, contextStatementUid = EXCLUDED.contextStatementUid, contextXObjectUid = EXCLUDED.contextXObjectUid, verbMasterChangeSeqNum = EXCLUDED.verbMasterChangeSeqNum, verbLocalChangeSeqNum = EXCLUDED.verbLocalChangeSeqNum, verbLastChangedBy = EXCLUDED.verbLastChangedBy, contextXObjectLct = EXCLUDED.contextXObjectLct */; END ';
      _stmtList.add_11rb$(element_199);
      var element_200 = ' CREATE TABLE IF NOT EXISTS AgentEntityReplicate ( aePk INTEGER NOT NULL, aeVersionId INTEGER NOT NULL DEFAULT 0, aeDestination INTEGER NOT NULL, aePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (aePk, aeDestination)) ';
      _stmtList.add_11rb$(element_200);
      var element_201 = ' CREATE INDEX index_AgentEntityReplicate_aePk_aeDestination_aeVersionId ON AgentEntityReplicate (aePk, aeDestination, aeVersionId) ';
      _stmtList.add_11rb$(element_201);
      var element_202 = ' CREATE INDEX index_AgentEntityReplicate_aeDestination_aePending ON AgentEntityReplicate (aeDestination, aePending) ';
      _stmtList.add_11rb$(element_202);
      var element_203 = ' CREATE TRIGGER ch_ins_68 AFTER INSERT ON AgentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 68 AS chTableId, NEW.agentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 68 AND chEntityPk = NEW.agentUid); END ';
      _stmtList.add_11rb$(element_203);
      var element_204 = ' CREATE TRIGGER ch_upd_68 AFTER UPDATE ON AgentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 68 AS chTableId, NEW.agentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 68 AND chEntityPk = NEW.agentUid); END ';
      _stmtList.add_11rb$(element_204);
      var element_205 = ' CREATE TRIGGER ch_del_68 AFTER DELETE ON AgentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 68 AS chTableId, OLD.agentUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 68 AND chEntityPk = OLD.agentUid); END ';
      _stmtList.add_11rb$(element_205);
      var element_206 = 'CREATE VIEW AgentEntity_ReceiveView AS  SELECT AgentEntity.*, AgentEntityReplicate.* FROM AgentEntity LEFT JOIN AgentEntityReplicate ON AgentEntityReplicate.aePk = AgentEntity.agentUid ';
      _stmtList.add_11rb$(element_206);
      var element_207 = ' CREATE TRIGGER agententity_remote_insert_ins INSTEAD OF INSERT ON AgentEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO AgentEntity(agentUid, agentMbox, agentMbox_sha1sum, agentOpenid, agentAccountName, agentHomePage, agentPersonUid, statementMasterChangeSeqNum, statementLocalChangeSeqNum, statementLastChangedBy, agentLct) VALUES (NEW.agentUid, NEW.agentMbox, NEW.agentMbox_sha1sum, NEW.agentOpenid, NEW.agentAccountName, NEW.agentHomePage, NEW.agentPersonUid, NEW.statementMasterChangeSeqNum, NEW.statementLocalChangeSeqNum, NEW.statementLastChangedBy, NEW.agentLct) /*psql ON CONFLICT (agentUid) DO UPDATE SET agentMbox = EXCLUDED.agentMbox, agentMbox_sha1sum = EXCLUDED.agentMbox_sha1sum, agentOpenid = EXCLUDED.agentOpenid, agentAccountName = EXCLUDED.agentAccountName, agentHomePage = EXCLUDED.agentHomePage, agentPersonUid = EXCLUDED.agentPersonUid, statementMasterChangeSeqNum = EXCLUDED.statementMasterChangeSeqNum, statementLocalChangeSeqNum = EXCLUDED.statementLocalChangeSeqNum, statementLastChangedBy = EXCLUDED.statementLastChangedBy, agentLct = EXCLUDED.agentLct*/; END ';
      _stmtList.add_11rb$(element_207);
      var element_208 = ' CREATE TABLE IF NOT EXISTS StateEntityReplicate ( sePk INTEGER NOT NULL, seVersionId INTEGER NOT NULL DEFAULT 0, seDestination INTEGER NOT NULL, sePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (sePk, seDestination)) ';
      _stmtList.add_11rb$(element_208);
      var element_209 = ' CREATE INDEX index_StateEntityReplicate_sePk_seDestination_seVersionId ON StateEntityReplicate (sePk, seDestination, seVersionId) ';
      _stmtList.add_11rb$(element_209);
      var element_210 = ' CREATE INDEX index_StateEntityReplicate_seDestination_sePending ON StateEntityReplicate (seDestination, sePending) ';
      _stmtList.add_11rb$(element_210);
      var element_211 = ' CREATE TRIGGER ch_ins_70 AFTER INSERT ON StateEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 70 AS chTableId, NEW.stateUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 70 AND chEntityPk = NEW.stateUid); END ';
      _stmtList.add_11rb$(element_211);
      var element_212 = ' CREATE TRIGGER ch_upd_70 AFTER UPDATE ON StateEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 70 AS chTableId, NEW.stateUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 70 AND chEntityPk = NEW.stateUid); END ';
      _stmtList.add_11rb$(element_212);
      var element_213 = ' CREATE TRIGGER ch_del_70 AFTER DELETE ON StateEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 70 AS chTableId, OLD.stateUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 70 AND chEntityPk = OLD.stateUid); END ';
      _stmtList.add_11rb$(element_213);
      var element_214 = 'CREATE VIEW StateEntity_ReceiveView AS  SELECT StateEntity.*, StateEntityReplicate.* FROM StateEntity LEFT JOIN StateEntityReplicate ON StateEntityReplicate.sePk = StateEntity.stateUid ';
      _stmtList.add_11rb$(element_214);
      var element_215 = ' CREATE TRIGGER stateentity_remote_insert_ins INSTEAD OF INSERT ON StateEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO StateEntity(stateUid, stateId, agentUid, activityId, registration, isIsactive, timestamp, stateMasterChangeSeqNum, stateLocalChangeSeqNum, stateLastChangedBy, stateLct) VALUES (NEW.stateUid, NEW.stateId, NEW.agentUid, NEW.activityId, NEW.registration, NEW.isIsactive, NEW.timestamp, NEW.stateMasterChangeSeqNum, NEW.stateLocalChangeSeqNum, NEW.stateLastChangedBy, NEW.stateLct) /*psql ON CONFLICT (stateUid) DO UPDATE SET stateId = EXCLUDED.stateId, agentUid = EXCLUDED.agentUid, activityId = EXCLUDED.activityId, registration = EXCLUDED.registration, isIsactive = EXCLUDED.isIsactive, timestamp = EXCLUDED.timestamp, stateMasterChangeSeqNum = EXCLUDED.stateMasterChangeSeqNum, stateLocalChangeSeqNum = EXCLUDED.stateLocalChangeSeqNum, stateLastChangedBy = EXCLUDED.stateLastChangedBy, stateLct = EXCLUDED.stateLct */; END ';
      _stmtList.add_11rb$(element_215);
      var element_216 = ' CREATE TABLE IF NOT EXISTS StateContentEntityReplicate ( scePk INTEGER NOT NULL, sceVersionId INTEGER NOT NULL DEFAULT 0, sceDestination INTEGER NOT NULL, scePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (scePk, sceDestination)) ';
      _stmtList.add_11rb$(element_216);
      var element_217 = ' CREATE INDEX index_StateContentEntityReplicate_scePk_sceDestination_sceVersionId ON StateContentEntityReplicate (scePk, sceDestination, sceVersionId) ';
      _stmtList.add_11rb$(element_217);
      var element_218 = ' CREATE INDEX index_StateContentEntityReplicate_sceDestination_scePending ON StateContentEntityReplicate (sceDestination, scePending) ';
      _stmtList.add_11rb$(element_218);
      var element_219 = ' CREATE TRIGGER ch_ins_72 AFTER INSERT ON StateContentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 72 AS chTableId, NEW.stateContentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 72 AND chEntityPk = NEW.stateContentUid); END ';
      _stmtList.add_11rb$(element_219);
      var element_220 = ' CREATE TRIGGER ch_upd_72 AFTER UPDATE ON StateContentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 72 AS chTableId, NEW.stateContentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 72 AND chEntityPk = NEW.stateContentUid); END ';
      _stmtList.add_11rb$(element_220);
      var element_221 = ' CREATE TRIGGER ch_del_72 AFTER DELETE ON StateContentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 72 AS chTableId, OLD.stateContentUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 72 AND chEntityPk = OLD.stateContentUid); END ';
      _stmtList.add_11rb$(element_221);
      var element_222 = 'CREATE VIEW StateContentEntity_ReceiveView AS  SELECT StateContentEntity.*, StateContentEntityReplicate.* FROM StateContentEntity LEFT JOIN StateContentEntityReplicate ON StateContentEntityReplicate.scePk = StateContentEntity.stateContentUid ';
      _stmtList.add_11rb$(element_222);
      var element_223 = ' CREATE TRIGGER statecontententity_remote_insert_ins INSTEAD OF INSERT ON StateContentEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO StateContentEntity(stateContentUid, stateContentStateUid, stateContentKey, stateContentValue, isIsactive, stateContentMasterChangeSeqNum, stateContentLocalChangeSeqNum, stateContentLastChangedBy, stateContentLct) VALUES (NEW.stateContentUid, NEW.stateContentStateUid, NEW.stateContentKey, NEW.stateContentValue, NEW.isIsactive, NEW.stateContentMasterChangeSeqNum, NEW.stateContentLocalChangeSeqNum, NEW.stateContentLastChangedBy, NEW.stateContentLct) /*psql ON CONFLICT (stateContentUid) DO UPDATE SET stateContentStateUid = EXCLUDED.stateContentStateUid, stateContentKey = EXCLUDED.stateContentKey, stateContentValue = EXCLUDED.stateContentValue, isIsactive = EXCLUDED.isIsactive, stateContentMasterChangeSeqNum = EXCLUDED.stateContentMasterChangeSeqNum, stateContentLocalChangeSeqNum = EXCLUDED.stateContentLocalChangeSeqNum, stateContentLastChangedBy = EXCLUDED.stateContentLastChangedBy, stateContentLct = EXCLUDED.stateContentLct */; END ';
      _stmtList.add_11rb$(element_223);
      var element_224 = ' CREATE TABLE IF NOT EXISTS XLangMapEntryReplicate ( xlmePk INTEGER NOT NULL, xlmeVersionId INTEGER NOT NULL DEFAULT 0, xlmeDestination INTEGER NOT NULL, xlmePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (xlmePk, xlmeDestination)) ';
      _stmtList.add_11rb$(element_224);
      var element_225 = ' CREATE INDEX index_XLangMapEntryReplicate_xlmePk_xlmeDestination_xlmeVersionId ON XLangMapEntryReplicate (xlmePk, xlmeDestination, xlmeVersionId) ';
      _stmtList.add_11rb$(element_225);
      var element_226 = ' CREATE INDEX index_XLangMapEntryReplicate_xlmeDestination_xlmePending ON XLangMapEntryReplicate (xlmeDestination, xlmePending) ';
      _stmtList.add_11rb$(element_226);
      var element_227 = ' CREATE TRIGGER ch_ins_74 AFTER INSERT ON XLangMapEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 74 AS chTableId, NEW.statementLangMapUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 74 AND chEntityPk = NEW.statementLangMapUid); END ';
      _stmtList.add_11rb$(element_227);
      var element_228 = ' CREATE TRIGGER ch_upd_74 AFTER UPDATE ON XLangMapEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 74 AS chTableId, NEW.statementLangMapUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 74 AND chEntityPk = NEW.statementLangMapUid); END ';
      _stmtList.add_11rb$(element_228);
      var element_229 = ' CREATE TRIGGER ch_del_74 AFTER DELETE ON XLangMapEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 74 AS chTableId, OLD.statementLangMapUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 74 AND chEntityPk = OLD.statementLangMapUid); END ';
      _stmtList.add_11rb$(element_229);
      var element_230 = 'CREATE VIEW XLangMapEntry_ReceiveView AS  SELECT XLangMapEntry.*, XLangMapEntryReplicate.* FROM XLangMapEntry LEFT JOIN XLangMapEntryReplicate ON XLangMapEntryReplicate.xlmePk = XLangMapEntry.statementLangMapUid ';
      _stmtList.add_11rb$(element_230);
      var element_231 = ' CREATE TRIGGER xlangmapentry_remote_insert_ins INSTEAD OF INSERT ON XLangMapEntry_ReceiveView FOR EACH ROW BEGIN REPLACE INTO XLangMapEntry(verbLangMapUid, objectLangMapUid, languageLangMapUid, languageVariantLangMapUid, valueLangMap, statementLangMapMasterCsn, statementLangMapLocalCsn, statementLangMapLcb, statementLangMapLct, statementLangMapUid) VALUES (NEW.verbLangMapUid, NEW.objectLangMapUid, NEW.languageLangMapUid, NEW.languageVariantLangMapUid, NEW.valueLangMap, NEW.statementLangMapMasterCsn, NEW.statementLangMapLocalCsn, NEW.statementLangMapLcb, NEW.statementLangMapLct, NEW.statementLangMapUid) /*psql ON CONFLICT (statementLangMapUid) DO UPDATE SET verbLangMapUid = EXCLUDED.verbLangMapUid, objectLangMapUid = EXCLUDED.objectLangMapUid, languageLangMapUid = EXCLUDED.languageLangMapUid, languageVariantLangMapUid = EXCLUDED.languageVariantLangMapUid, valueLangMap = EXCLUDED.valueLangMap, statementLangMapMasterCsn = EXCLUDED.statementLangMapMasterCsn, statementLangMapLocalCsn = EXCLUDED.statementLangMapLocalCsn, statementLangMapLcb = EXCLUDED.statementLangMapLcb, statementLangMapLct = EXCLUDED.statementLangMapLct */; END ';
      _stmtList.add_11rb$(element_231);
      var element_232 = ' CREATE TABLE IF NOT EXISTS SchoolReplicate ( schoolPk INTEGER NOT NULL, schoolVersionId INTEGER NOT NULL DEFAULT 0, schoolDestination INTEGER NOT NULL, schoolPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (schoolPk, schoolDestination)) ';
      _stmtList.add_11rb$(element_232);
      var element_233 = ' CREATE INDEX index_SchoolReplicate_schoolPk_schoolDestination_schoolVersionId ON SchoolReplicate (schoolPk, schoolDestination, schoolVersionId) ';
      _stmtList.add_11rb$(element_233);
      var element_234 = ' CREATE INDEX index_SchoolReplicate_schoolDestination_schoolPending ON SchoolReplicate (schoolDestination, schoolPending) ';
      _stmtList.add_11rb$(element_234);
      var element_235 = ' CREATE TRIGGER ch_ins_164 AFTER INSERT ON School BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 164 AS chTableId, NEW.schoolUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 164 AND chEntityPk = NEW.schoolUid); END ';
      _stmtList.add_11rb$(element_235);
      var element_236 = ' CREATE TRIGGER ch_upd_164 AFTER UPDATE ON School BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 164 AS chTableId, NEW.schoolUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 164 AND chEntityPk = NEW.schoolUid); END ';
      _stmtList.add_11rb$(element_236);
      var element_237 = ' CREATE TRIGGER ch_del_164 AFTER DELETE ON School BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 164 AS chTableId, OLD.schoolUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 164 AND chEntityPk = OLD.schoolUid); END ';
      _stmtList.add_11rb$(element_237);
      var element_238 = 'CREATE VIEW School_ReceiveView AS  SELECT School.*, SchoolReplicate.* FROM School LEFT JOIN SchoolReplicate ON SchoolReplicate.schoolPk = School.schoolUid ';
      _stmtList.add_11rb$(element_238);
      var element_239 = ' CREATE TRIGGER school_remote_insert_ins INSTEAD OF INSERT ON School_ReceiveView FOR EACH ROW BEGIN REPLACE INTO School(schoolUid, schoolName, schoolDesc, schoolAddress, schoolActive, schoolPhoneNumber, schoolGender, schoolHolidayCalendarUid, schoolFeatures, schoolLocationLong, schoolLocationLatt, schoolEmailAddress, schoolTeachersPersonGroupUid, schoolStudentsPersonGroupUid, schoolPendingStudentsPersonGroupUid, schoolCode, schoolMasterChangeSeqNum, schoolLocalChangeSeqNum, schoolLastChangedBy, schoolLct, schoolTimeZone) VALUES (NEW.schoolUid, NEW.schoolName, NEW.schoolDesc, NEW.schoolAddress, NEW.schoolActive, NEW.schoolPhoneNumber, NEW.schoolGender, NEW.schoolHolidayCalendarUid, NEW.schoolFeatures, NEW.schoolLocationLong, NEW.schoolLocationLatt, NEW.schoolEmailAddress, NEW.schoolTeachersPersonGroupUid, NEW.schoolStudentsPersonGroupUid, NEW.schoolPendingStudentsPersonGroupUid, NEW.schoolCode, NEW.schoolMasterChangeSeqNum, NEW.schoolLocalChangeSeqNum, NEW.schoolLastChangedBy, NEW.schoolLct, NEW.schoolTimeZone) /*psql ON CONFLICT (schoolUid) DO UPDATE SET schoolName = EXCLUDED.schoolName, schoolDesc = EXCLUDED.schoolDesc, schoolAddress = EXCLUDED.schoolAddress, schoolActive = EXCLUDED.schoolActive, schoolPhoneNumber = EXCLUDED.schoolPhoneNumber, schoolGender = EXCLUDED.schoolGender, schoolHolidayCalendarUid = EXCLUDED.schoolHolidayCalendarUid, schoolFeatures = EXCLUDED.schoolFeatures, schoolLocationLong = EXCLUDED.schoolLocationLong, schoolLocationLatt = EXCLUDED.schoolLocationLatt, schoolEmailAddress = EXCLUDED.schoolEmailAddress, schoolTeachersPersonGroupUid = EXCLUDED.schoolTeachersPersonGroupUid, schoolStudentsPersonGroupUid = EXCLUDED.schoolStudentsPersonGroupUid, schoolPendingStudentsPersonGroupUid = EXCLUDED.schoolPendingStudentsPersonGroupUid, schoolCode = EXCLUDED.schoolCode, schoolMasterChangeSeqNum = EXCLUDED.schoolMasterChangeSeqNum, schoolLocalChangeSeqNum = EXCLUDED.schoolLocalChangeSeqNum, schoolLastChangedBy = EXCLUDED.schoolLastChangedBy, schoolLct = EXCLUDED.schoolLct, schoolTimeZone = EXCLUDED.schoolTimeZone */; END ';
      _stmtList.add_11rb$(element_239);
      var element_240 = ' CREATE TABLE IF NOT EXISTS SchoolMemberReplicate ( smPk INTEGER NOT NULL, smVersionId INTEGER NOT NULL DEFAULT 0, smDestination INTEGER NOT NULL, smPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (smPk, smDestination)) ';
      _stmtList.add_11rb$(element_240);
      var element_241 = ' CREATE INDEX index_SchoolMemberReplicate_smPk_smDestination_smVersionId ON SchoolMemberReplicate (smPk, smDestination, smVersionId) ';
      _stmtList.add_11rb$(element_241);
      var element_242 = ' CREATE INDEX index_SchoolMemberReplicate_smDestination_smPending ON SchoolMemberReplicate (smDestination, smPending) ';
      _stmtList.add_11rb$(element_242);
      var element_243 = ' CREATE TRIGGER ch_ins_200 AFTER INSERT ON SchoolMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 200 AS chTableId, NEW.schoolMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 200 AND chEntityPk = NEW.schoolMemberUid); END ';
      _stmtList.add_11rb$(element_243);
      var element_244 = ' CREATE TRIGGER ch_upd_200 AFTER UPDATE ON SchoolMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 200 AS chTableId, NEW.schoolMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 200 AND chEntityPk = NEW.schoolMemberUid); END ';
      _stmtList.add_11rb$(element_244);
      var element_245 = ' CREATE TRIGGER ch_del_200 AFTER DELETE ON SchoolMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 200 AS chTableId, OLD.schoolMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 200 AND chEntityPk = OLD.schoolMemberUid); END ';
      _stmtList.add_11rb$(element_245);
      var element_246 = 'CREATE VIEW SchoolMember_ReceiveView AS  SELECT SchoolMember.*, SchoolMemberReplicate.* FROM SchoolMember LEFT JOIN SchoolMemberReplicate ON SchoolMemberReplicate.smPk = SchoolMember.schoolMemberUid ';
      _stmtList.add_11rb$(element_246);
      var element_247 = ' CREATE TRIGGER schoolmember_remote_insert_ins INSTEAD OF INSERT ON SchoolMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO SchoolMember(schoolMemberUid, schoolMemberPersonUid, schoolMemberSchoolUid, schoolMemberJoinDate, schoolMemberLeftDate, schoolMemberRole, schoolMemberActive, schoolMemberLocalChangeSeqNum, schoolMemberMasterChangeSeqNum, schoolMemberLastChangedBy, schoolMemberLct) VALUES (NEW.schoolMemberUid, NEW.schoolMemberPersonUid, NEW.schoolMemberSchoolUid, NEW.schoolMemberJoinDate, NEW.schoolMemberLeftDate, NEW.schoolMemberRole, NEW.schoolMemberActive, NEW.schoolMemberLocalChangeSeqNum, NEW.schoolMemberMasterChangeSeqNum, NEW.schoolMemberLastChangedBy, NEW.schoolMemberLct) /*psql ON CONFLICT (schoolMemberUid) DO UPDATE SET schoolMemberPersonUid = EXCLUDED.schoolMemberPersonUid, schoolMemberSchoolUid = EXCLUDED.schoolMemberSchoolUid, schoolMemberJoinDate = EXCLUDED.schoolMemberJoinDate, schoolMemberLeftDate = EXCLUDED.schoolMemberLeftDate, schoolMemberRole = EXCLUDED.schoolMemberRole, schoolMemberActive = EXCLUDED.schoolMemberActive, schoolMemberLocalChangeSeqNum = EXCLUDED.schoolMemberLocalChangeSeqNum, schoolMemberMasterChangeSeqNum = EXCLUDED.schoolMemberMasterChangeSeqNum, schoolMemberLastChangedBy = EXCLUDED.schoolMemberLastChangedBy, schoolMemberLct = EXCLUDED.schoolMemberLct */; END ';
      _stmtList.add_11rb$(element_247);
      var element_248 = ' CREATE TABLE IF NOT EXISTS CommentsReplicate ( commentsPk INTEGER NOT NULL, commentsVersionId INTEGER NOT NULL DEFAULT 0, commentsDestination INTEGER NOT NULL, commentsPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (commentsPk, commentsDestination)) ';
      _stmtList.add_11rb$(element_248);
      var element_249 = ' CREATE INDEX index_CommentsReplicate_commentsPk_commentsDestination_commentsVersionId ON CommentsReplicate (commentsPk, commentsDestination, commentsVersionId) ';
      _stmtList.add_11rb$(element_249);
      var element_250 = ' CREATE INDEX index_CommentsReplicate_commentsDestination_commentsPending ON CommentsReplicate (commentsDestination, commentsPending) ';
      _stmtList.add_11rb$(element_250);
      var element_251 = ' CREATE TRIGGER ch_ins_208 AFTER INSERT ON Comments BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 208 AS chTableId, NEW.commentsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 208 AND chEntityPk = NEW.commentsUid); END ';
      _stmtList.add_11rb$(element_251);
      var element_252 = ' CREATE TRIGGER ch_upd_208 AFTER UPDATE ON Comments BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 208 AS chTableId, NEW.commentsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 208 AND chEntityPk = NEW.commentsUid); END ';
      _stmtList.add_11rb$(element_252);
      var element_253 = ' CREATE TRIGGER ch_del_208 AFTER DELETE ON Comments BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 208 AS chTableId, OLD.commentsUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 208 AND chEntityPk = OLD.commentsUid); END ';
      _stmtList.add_11rb$(element_253);
      var element_254 = 'CREATE VIEW Comments_ReceiveView AS  SELECT Comments.*, CommentsReplicate.* FROM Comments LEFT JOIN CommentsReplicate ON CommentsReplicate.commentsPk = Comments.commentsUid ';
      _stmtList.add_11rb$(element_254);
      var element_255 = ' CREATE TRIGGER comments_remote_insert_ins INSTEAD OF INSERT ON Comments_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Comments(commentsUid, commentsText, commentsEntityType, commentsEntityUid, commentsPublic, commentsStatus, commentsPersonUid, commentsToPersonUid, commentsFlagged, commentsInActive, commentsDateTimeAdded, commentsDateTimeUpdated, commentsMCSN, commentsLCSN, commentsLCB, commentsLct) VALUES (NEW.commentsUid, NEW.commentsText, NEW.commentsEntityType, NEW.commentsEntityUid, NEW.commentsPublic, NEW.commentsStatus, NEW.commentsPersonUid, NEW.commentsToPersonUid, NEW.commentsFlagged, NEW.commentsInActive, NEW.commentsDateTimeAdded, NEW.commentsDateTimeUpdated, NEW.commentsMCSN, NEW.commentsLCSN, NEW.commentsLCB, NEW.commentsLct) /*psql ON CONFLICT (commentsUid) DO UPDATE SET commentsText = EXCLUDED.commentsText, commentsEntityType = EXCLUDED.commentsEntityType, commentsEntityUid = EXCLUDED.commentsEntityUid, commentsPublic = EXCLUDED.commentsPublic, commentsStatus = EXCLUDED.commentsStatus, commentsPersonUid = EXCLUDED.commentsPersonUid, commentsToPersonUid = EXCLUDED.commentsToPersonUid, commentsFlagged = EXCLUDED.commentsFlagged, commentsInActive = EXCLUDED.commentsInActive, commentsDateTimeAdded = EXCLUDED.commentsDateTimeAdded, commentsDateTimeUpdated = EXCLUDED.commentsDateTimeUpdated, commentsMCSN = EXCLUDED.commentsMCSN, commentsLCSN = EXCLUDED.commentsLCSN, commentsLCB = EXCLUDED.commentsLCB, commentsLct = EXCLUDED.commentsLct */; END ';
      _stmtList.add_11rb$(element_255);
      var element_256 = ' CREATE TABLE IF NOT EXISTS ReportReplicate ( reportPk INTEGER NOT NULL, reportVersionId INTEGER NOT NULL DEFAULT 0, reportDestination INTEGER NOT NULL, reportPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (reportPk, reportDestination)) ';
      _stmtList.add_11rb$(element_256);
      var element_257 = ' CREATE INDEX index_ReportReplicate_reportPk_reportDestination_reportVersionId ON ReportReplicate (reportPk, reportDestination, reportVersionId) ';
      _stmtList.add_11rb$(element_257);
      var element_258 = ' CREATE INDEX index_ReportReplicate_reportDestination_reportPending ON ReportReplicate (reportDestination, reportPending) ';
      _stmtList.add_11rb$(element_258);
      var element_259 = ' CREATE TRIGGER ch_ins_101 AFTER INSERT ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, NEW.reportUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = NEW.reportUid); END ';
      _stmtList.add_11rb$(element_259);
      var element_260 = ' CREATE TRIGGER ch_upd_101 AFTER UPDATE ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, NEW.reportUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = NEW.reportUid); END ';
      _stmtList.add_11rb$(element_260);
      var element_261 = ' CREATE TRIGGER ch_del_101 AFTER DELETE ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, OLD.reportUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = OLD.reportUid); END ';
      _stmtList.add_11rb$(element_261);
      var element_262 = 'CREATE VIEW Report_ReceiveView AS  SELECT Report.*, ReportReplicate.* FROM Report LEFT JOIN ReportReplicate ON ReportReplicate.reportPk = Report.reportUid ';
      _stmtList.add_11rb$(element_262);
      var element_263 = ' CREATE TRIGGER report_remote_insert_ins INSTEAD OF INSERT ON Report_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Report(reportUid, reportOwnerUid, xAxis, reportDateRangeSelection, fromDate, fromRelTo, fromRelOffSet, fromRelUnit, toDate, toRelTo, toRelOffSet, toRelUnit, reportTitle, reportDescription, reportSeries, reportInactive, isTemplate, priority, reportTitleId, reportDescId, reportMasterChangeSeqNum, reportLocalChangeSeqNum, reportLastChangedBy, reportLct) VALUES (NEW.reportUid, NEW.reportOwnerUid, NEW.xAxis, NEW.reportDateRangeSelection, NEW.fromDate, NEW.fromRelTo, NEW.fromRelOffSet, NEW.fromRelUnit, NEW.toDate, NEW.toRelTo, NEW.toRelOffSet, NEW.toRelUnit, NEW.reportTitle, NEW.reportDescription, NEW.reportSeries, NEW.reportInactive, NEW.isTemplate, NEW.priority, NEW.reportTitleId, NEW.reportDescId, NEW.reportMasterChangeSeqNum, NEW.reportLocalChangeSeqNum, NEW.reportLastChangedBy, NEW.reportLct) /*psql ON CONFLICT (reportUid) DO UPDATE SET reportOwnerUid = EXCLUDED.reportOwnerUid, xAxis = EXCLUDED.xAxis, reportDateRangeSelection = EXCLUDED.reportDateRangeSelection, fromDate = EXCLUDED.fromDate, fromRelTo = EXCLUDED.fromRelTo, fromRelOffSet = EXCLUDED.fromRelOffSet, fromRelUnit = EXCLUDED.fromRelUnit, toDate = EXCLUDED.toDate, toRelTo = EXCLUDED.toRelTo, toRelOffSet = EXCLUDED.toRelOffSet, toRelUnit = EXCLUDED.toRelUnit, reportTitle = EXCLUDED.reportTitle, reportDescription = EXCLUDED.reportDescription, reportSeries = EXCLUDED.reportSeries, reportInactive = EXCLUDED.reportInactive, isTemplate = EXCLUDED.isTemplate, priority = EXCLUDED.priority, reportTitleId = EXCLUDED.reportTitleId, reportDescId = EXCLUDED.reportDescId, reportMasterChangeSeqNum = EXCLUDED.reportMasterChangeSeqNum, reportLocalChangeSeqNum = EXCLUDED.reportLocalChangeSeqNum, reportLastChangedBy = EXCLUDED.reportLastChangedBy, reportLct = EXCLUDED.reportLct */; END ';
      _stmtList.add_11rb$(element_263);
      var element_264 = ' CREATE TABLE IF NOT EXISTS SiteReplicate ( sitePk INTEGER NOT NULL, siteVersionId INTEGER NOT NULL DEFAULT 0, siteDestination INTEGER NOT NULL, sitePending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (sitePk, siteDestination)) ';
      _stmtList.add_11rb$(element_264);
      var element_265 = ' CREATE INDEX index_SiteReplicate_sitePk_siteDestination_siteVersionId ON SiteReplicate (sitePk, siteDestination, siteVersionId) ';
      _stmtList.add_11rb$(element_265);
      var element_266 = ' CREATE INDEX index_SiteReplicate_siteDestination_sitePending ON SiteReplicate (siteDestination, sitePending) ';
      _stmtList.add_11rb$(element_266);
      var element_267 = ' CREATE TRIGGER ch_ins_189 AFTER INSERT ON Site BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 189 AS chTableId, NEW.siteUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 189 AND chEntityPk = NEW.siteUid); END ';
      _stmtList.add_11rb$(element_267);
      var element_268 = ' CREATE TRIGGER ch_upd_189 AFTER UPDATE ON Site BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 189 AS chTableId, NEW.siteUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 189 AND chEntityPk = NEW.siteUid); END ';
      _stmtList.add_11rb$(element_268);
      var element_269 = ' CREATE TRIGGER ch_del_189 AFTER DELETE ON Site BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 189 AS chTableId, OLD.siteUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 189 AND chEntityPk = OLD.siteUid); END ';
      _stmtList.add_11rb$(element_269);
      var element_270 = 'CREATE VIEW Site_ReceiveView AS  SELECT Site.*, SiteReplicate.* FROM Site LEFT JOIN SiteReplicate ON SiteReplicate.sitePk = Site.siteUid ';
      _stmtList.add_11rb$(element_270);
      var element_271 = ' CREATE TRIGGER site_remote_insert_ins INSTEAD OF INSERT ON Site_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Site(siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt) VALUES (NEW.siteUid, NEW.sitePcsn, NEW.siteLcsn, NEW.siteLcb, NEW.siteLct, NEW.siteName, NEW.guestLogin, NEW.registrationAllowed, NEW.authSalt) /*psql ON CONFLICT (siteUid) DO UPDATE SET sitePcsn = EXCLUDED.sitePcsn, siteLcsn = EXCLUDED.siteLcsn, siteLcb = EXCLUDED.siteLcb, siteLct = EXCLUDED.siteLct, siteName = EXCLUDED.siteName, guestLogin = EXCLUDED.guestLogin, registrationAllowed = EXCLUDED.registrationAllowed, authSalt = EXCLUDED.authSalt*/; END ';
      _stmtList.add_11rb$(element_271);
      var element_272 = ' CREATE TABLE IF NOT EXISTS LearnerGroupReplicate ( lgPk INTEGER NOT NULL, lgVersionId INTEGER NOT NULL DEFAULT 0, lgDestination INTEGER NOT NULL, lgPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (lgPk, lgDestination)) ';
      _stmtList.add_11rb$(element_272);
      var element_273 = ' CREATE INDEX index_LearnerGroupReplicate_lgPk_lgDestination_lgVersionId ON LearnerGroupReplicate (lgPk, lgDestination, lgVersionId) ';
      _stmtList.add_11rb$(element_273);
      var element_274 = ' CREATE INDEX index_LearnerGroupReplicate_lgDestination_lgPending ON LearnerGroupReplicate (lgDestination, lgPending) ';
      _stmtList.add_11rb$(element_274);
      var element_275 = ' CREATE TRIGGER ch_ins_301 AFTER INSERT ON LearnerGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 301 AS chTableId, NEW.learnerGroupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 301 AND chEntityPk = NEW.learnerGroupUid); END ';
      _stmtList.add_11rb$(element_275);
      var element_276 = ' CREATE TRIGGER ch_upd_301 AFTER UPDATE ON LearnerGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 301 AS chTableId, NEW.learnerGroupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 301 AND chEntityPk = NEW.learnerGroupUid); END ';
      _stmtList.add_11rb$(element_276);
      var element_277 = ' CREATE TRIGGER ch_del_301 AFTER DELETE ON LearnerGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 301 AS chTableId, OLD.learnerGroupUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 301 AND chEntityPk = OLD.learnerGroupUid); END ';
      _stmtList.add_11rb$(element_277);
      var element_278 = 'CREATE VIEW LearnerGroup_ReceiveView AS  SELECT LearnerGroup.*, LearnerGroupReplicate.* FROM LearnerGroup LEFT JOIN LearnerGroupReplicate ON LearnerGroupReplicate.lgPk = LearnerGroup.learnerGroupUid ';
      _stmtList.add_11rb$(element_278);
      var element_279 = ' CREATE TRIGGER learnergroup_remote_insert_ins INSTEAD OF INSERT ON LearnerGroup_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LearnerGroup(learnerGroupUid, learnerGroupName, learnerGroupDescription, learnerGroupActive, learnerGroupMCSN, learnerGroupCSN, learnerGroupLCB, learnerGroupLct) VALUES (NEW.learnerGroupUid, NEW.learnerGroupName, NEW.learnerGroupDescription, NEW.learnerGroupActive, NEW.learnerGroupMCSN, NEW.learnerGroupCSN, NEW.learnerGroupLCB, NEW.learnerGroupLct) /*psql ON CONFLICT (learnerGroupUid) DO UPDATE SET learnerGroupName = EXCLUDED.learnerGroupName, learnerGroupDescription = EXCLUDED.learnerGroupDescription, learnerGroupActive = EXCLUDED.learnerGroupActive, learnerGroupMCSN = EXCLUDED.learnerGroupMCSN, learnerGroupCSN = EXCLUDED.learnerGroupCSN, learnerGroupLCB = EXCLUDED.learnerGroupLCB, learnerGroupLct = EXCLUDED.learnerGroupLct */; END ';
      _stmtList.add_11rb$(element_279);
      var element_280 = ' CREATE TABLE IF NOT EXISTS LearnerGroupMemberReplicate ( lgmPk INTEGER NOT NULL, lgmVersionId INTEGER NOT NULL DEFAULT 0, lgmDestination INTEGER NOT NULL, lgmPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (lgmPk, lgmDestination)) ';
      _stmtList.add_11rb$(element_280);
      var element_281 = ' CREATE INDEX index_LearnerGroupMemberReplicate_lgmPk_lgmDestination_lgmVersionId ON LearnerGroupMemberReplicate (lgmPk, lgmDestination, lgmVersionId) ';
      _stmtList.add_11rb$(element_281);
      var element_282 = ' CREATE INDEX index_LearnerGroupMemberReplicate_lgmDestination_lgmPending ON LearnerGroupMemberReplicate (lgmDestination, lgmPending) ';
      _stmtList.add_11rb$(element_282);
      var element_283 = ' CREATE TRIGGER ch_ins_300 AFTER INSERT ON LearnerGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 300 AS chTableId, NEW.learnerGroupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 300 AND chEntityPk = NEW.learnerGroupMemberUid); END ';
      _stmtList.add_11rb$(element_283);
      var element_284 = ' CREATE TRIGGER ch_upd_300 AFTER UPDATE ON LearnerGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 300 AS chTableId, NEW.learnerGroupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 300 AND chEntityPk = NEW.learnerGroupMemberUid); END ';
      _stmtList.add_11rb$(element_284);
      var element_285 = ' CREATE TRIGGER ch_del_300 AFTER DELETE ON LearnerGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 300 AS chTableId, OLD.learnerGroupMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 300 AND chEntityPk = OLD.learnerGroupMemberUid); END ';
      _stmtList.add_11rb$(element_285);
      var element_286 = 'CREATE VIEW LearnerGroupMember_ReceiveView AS  SELECT LearnerGroupMember.*, LearnerGroupMemberReplicate.* FROM LearnerGroupMember LEFT JOIN LearnerGroupMemberReplicate ON LearnerGroupMemberReplicate.lgmPk = LearnerGroupMember.learnerGroupMemberUid ';
      _stmtList.add_11rb$(element_286);
      var element_287 = ' CREATE TRIGGER learnergroupmember_remote_insert_ins INSTEAD OF INSERT ON LearnerGroupMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LearnerGroupMember(learnerGroupMemberUid, learnerGroupMemberPersonUid, learnerGroupMemberLgUid, learnerGroupMemberRole, learnerGroupMemberActive, learnerGroupMemberMCSN, learnerGroupMemberCSN, learnerGroupMemberLCB, learnerGroupMemberLct) VALUES (NEW.learnerGroupMemberUid, NEW.learnerGroupMemberPersonUid, NEW.learnerGroupMemberLgUid, NEW.learnerGroupMemberRole, NEW.learnerGroupMemberActive, NEW.learnerGroupMemberMCSN, NEW.learnerGroupMemberCSN, NEW.learnerGroupMemberLCB, NEW.learnerGroupMemberLct) /*psql ON CONFLICT (learnerGroupMemberUid) DO UPDATE SET learnerGroupMemberPersonUid = EXCLUDED.learnerGroupMemberPersonUid, learnerGroupMemberLgUid = EXCLUDED.learnerGroupMemberLgUid, learnerGroupMemberRole = EXCLUDED.learnerGroupMemberRole, learnerGroupMemberActive = EXCLUDED.learnerGroupMemberActive, learnerGroupMemberMCSN = EXCLUDED.learnerGroupMemberMCSN, learnerGroupMemberCSN = EXCLUDED.learnerGroupMemberCSN, learnerGroupMemberLCB = EXCLUDED.learnerGroupMemberLCB, learnerGroupMemberLct = EXCLUDED.learnerGroupMemberLct */; END ';
      _stmtList.add_11rb$(element_287);
      var element_288 = ' CREATE TABLE IF NOT EXISTS GroupLearningSessionReplicate ( glsPk INTEGER NOT NULL, glsVersionId INTEGER NOT NULL DEFAULT 0, glsDestination INTEGER NOT NULL, glsPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (glsPk, glsDestination)) ';
      _stmtList.add_11rb$(element_288);
      var element_289 = ' CREATE INDEX index_GroupLearningSessionReplicate_glsPk_glsDestination_glsVersionId ON GroupLearningSessionReplicate (glsPk, glsDestination, glsVersionId) ';
      _stmtList.add_11rb$(element_289);
      var element_290 = ' CREATE INDEX index_GroupLearningSessionReplicate_glsDestination_glsPending ON GroupLearningSessionReplicate (glsDestination, glsPending) ';
      _stmtList.add_11rb$(element_290);
      var element_291 = ' CREATE TRIGGER ch_ins_302 AFTER INSERT ON GroupLearningSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 302 AS chTableId, NEW.groupLearningSessionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 302 AND chEntityPk = NEW.groupLearningSessionUid); END ';
      _stmtList.add_11rb$(element_291);
      var element_292 = ' CREATE TRIGGER ch_upd_302 AFTER UPDATE ON GroupLearningSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 302 AS chTableId, NEW.groupLearningSessionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 302 AND chEntityPk = NEW.groupLearningSessionUid); END ';
      _stmtList.add_11rb$(element_292);
      var element_293 = ' CREATE TRIGGER ch_del_302 AFTER DELETE ON GroupLearningSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 302 AS chTableId, OLD.groupLearningSessionUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 302 AND chEntityPk = OLD.groupLearningSessionUid); END ';
      _stmtList.add_11rb$(element_293);
      var element_294 = 'CREATE VIEW GroupLearningSession_ReceiveView AS  SELECT GroupLearningSession.*, GroupLearningSessionReplicate.* FROM GroupLearningSession LEFT JOIN GroupLearningSessionReplicate ON GroupLearningSessionReplicate.glsPk = GroupLearningSession.groupLearningSessionUid ';
      _stmtList.add_11rb$(element_294);
      var element_295 = ' CREATE TRIGGER grouplearningsession_remote_insert_ins INSTEAD OF INSERT ON GroupLearningSession_ReceiveView FOR EACH ROW BEGIN REPLACE INTO GroupLearningSession(groupLearningSessionUid, groupLearningSessionContentUid, groupLearningSessionLearnerGroupUid, groupLearningSessionInactive, groupLearningSessionMCSN, groupLearningSessionCSN, groupLearningSessionLCB, groupLearningSessionLct) VALUES (NEW.groupLearningSessionUid, NEW.groupLearningSessionContentUid, NEW.groupLearningSessionLearnerGroupUid, NEW.groupLearningSessionInactive, NEW.groupLearningSessionMCSN, NEW.groupLearningSessionCSN, NEW.groupLearningSessionLCB, NEW.groupLearningSessionLct) /*psql ON CONFLICT (groupLearningSessionUid) DO UPDATE SET groupLearningSessionContentUid = EXCLUDED.groupLearningSessionContentUid, groupLearningSessionLearnerGroupUid = EXCLUDED.groupLearningSessionLearnerGroupUid, groupLearningSessionInactive = EXCLUDED.groupLearningSessionInactive, groupLearningSessionMCSN = EXCLUDED.groupLearningSessionMCSN, groupLearningSessionCSN = EXCLUDED.groupLearningSessionCSN, groupLearningSessionLCB = EXCLUDED.groupLearningSessionLCB, groupLearningSessionLct = EXCLUDED.groupLearningSessionLct */; END ';
      _stmtList.add_11rb$(element_295);
      var element_296 = ' CREATE TABLE IF NOT EXISTS SiteTermsReplicate ( stPk INTEGER NOT NULL, stVersionId INTEGER NOT NULL DEFAULT 0, stDestination INTEGER NOT NULL, stPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (stPk, stDestination)) ';
      _stmtList.add_11rb$(element_296);
      var element_297 = ' CREATE INDEX index_SiteTermsReplicate_stPk_stDestination_stVersionId ON SiteTermsReplicate (stPk, stDestination, stVersionId) ';
      _stmtList.add_11rb$(element_297);
      var element_298 = ' CREATE INDEX index_SiteTermsReplicate_stDestination_stPending ON SiteTermsReplicate (stDestination, stPending) ';
      _stmtList.add_11rb$(element_298);
      var element_299 = ' CREATE TRIGGER ch_ins_272 AFTER INSERT ON SiteTerms BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 272 AS chTableId, NEW.sTermsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 272 AND chEntityPk = NEW.sTermsUid); END ';
      _stmtList.add_11rb$(element_299);
      var element_300 = ' CREATE TRIGGER ch_upd_272 AFTER UPDATE ON SiteTerms BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 272 AS chTableId, NEW.sTermsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 272 AND chEntityPk = NEW.sTermsUid); END ';
      _stmtList.add_11rb$(element_300);
      var element_301 = ' CREATE TRIGGER ch_del_272 AFTER DELETE ON SiteTerms BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 272 AS chTableId, OLD.sTermsUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 272 AND chEntityPk = OLD.sTermsUid); END ';
      _stmtList.add_11rb$(element_301);
      var element_302 = 'CREATE VIEW SiteTerms_ReceiveView AS  SELECT SiteTerms.*, SiteTermsReplicate.* FROM SiteTerms LEFT JOIN SiteTermsReplicate ON SiteTermsReplicate.stPk = SiteTerms.sTermsUid ';
      _stmtList.add_11rb$(element_302);
      var element_303 = ' CREATE TRIGGER siteterms_remote_insert_ins INSTEAD OF INSERT ON SiteTerms_ReceiveView FOR EACH ROW BEGIN REPLACE INTO SiteTerms(sTermsUid, termsHtml, sTermsLang, sTermsLangUid, sTermsActive, sTermsLastChangedBy, sTermsPrimaryCsn, sTermsLocalCsn, sTermsLct) VALUES (NEW.sTermsUid, NEW.termsHtml, NEW.sTermsLang, NEW.sTermsLangUid, NEW.sTermsActive, NEW.sTermsLastChangedBy, NEW.sTermsPrimaryCsn, NEW.sTermsLocalCsn, NEW.sTermsLct) /*psql ON CONFLICT (sTermsUid) DO UPDATE SET termsHtml = EXCLUDED.termsHtml, sTermsLang = EXCLUDED.sTermsLang, sTermsLangUid = EXCLUDED.sTermsLangUid, sTermsActive = EXCLUDED.sTermsActive, sTermsLastChangedBy = EXCLUDED.sTermsLastChangedBy, sTermsPrimaryCsn = EXCLUDED.sTermsPrimaryCsn, sTermsLocalCsn = EXCLUDED.sTermsLocalCsn, sTermsLct = EXCLUDED.sTermsLct */; END ';
      _stmtList.add_11rb$(element_303);
      var element_304 = ' CREATE TABLE IF NOT EXISTS ClazzContentJoinReplicate ( ccjPk INTEGER NOT NULL, ccjVersionId INTEGER NOT NULL DEFAULT 0, ccjDestination INTEGER NOT NULL, ccjPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (ccjPk, ccjDestination)) ';
      _stmtList.add_11rb$(element_304);
      var element_305 = ' CREATE INDEX index_ClazzContentJoinReplicate_ccjPk_ccjDestination_ccjVersionId ON ClazzContentJoinReplicate (ccjPk, ccjDestination, ccjVersionId) ';
      _stmtList.add_11rb$(element_305);
      var element_306 = ' CREATE INDEX index_ClazzContentJoinReplicate_ccjDestination_ccjPending ON ClazzContentJoinReplicate (ccjDestination, ccjPending) ';
      _stmtList.add_11rb$(element_306);
      var element_307 = ' CREATE TRIGGER ch_ins_134 AFTER INSERT ON ClazzContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 134 AS chTableId, NEW.ccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 134 AND chEntityPk = NEW.ccjUid); END ';
      _stmtList.add_11rb$(element_307);
      var element_308 = ' CREATE TRIGGER ch_upd_134 AFTER UPDATE ON ClazzContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 134 AS chTableId, NEW.ccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 134 AND chEntityPk = NEW.ccjUid); END ';
      _stmtList.add_11rb$(element_308);
      var element_309 = ' CREATE TRIGGER ch_del_134 AFTER DELETE ON ClazzContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 134 AS chTableId, OLD.ccjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 134 AND chEntityPk = OLD.ccjUid); END ';
      _stmtList.add_11rb$(element_309);
      var element_310 = 'CREATE VIEW ClazzContentJoin_ReceiveView AS  SELECT ClazzContentJoin.*, ClazzContentJoinReplicate.* FROM ClazzContentJoin LEFT JOIN ClazzContentJoinReplicate ON ClazzContentJoinReplicate.ccjPk = ClazzContentJoin.ccjUid ';
      _stmtList.add_11rb$(element_310);
      var element_311 = ' CREATE TRIGGER clazzcontentjoin_remote_insert_ins INSTEAD OF INSERT ON ClazzContentJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzContentJoin(ccjUid, ccjContentEntryUid, ccjClazzUid, ccjActive, ccjLocalChangeSeqNum, ccjMasterChangeSeqNum, ccjLastChangedBy, ccjLct) VALUES (NEW.ccjUid, NEW.ccjContentEntryUid, NEW.ccjClazzUid, NEW.ccjActive, NEW.ccjLocalChangeSeqNum, NEW.ccjMasterChangeSeqNum, NEW.ccjLastChangedBy, NEW.ccjLct) /*psql ON CONFLICT (ccjUid) DO UPDATE SET ccjContentEntryUid = EXCLUDED.ccjContentEntryUid, ccjClazzUid = EXCLUDED.ccjClazzUid, ccjActive = EXCLUDED.ccjActive, ccjLocalChangeSeqNum = EXCLUDED.ccjLocalChangeSeqNum, ccjMasterChangeSeqNum = EXCLUDED.ccjMasterChangeSeqNum, ccjLastChangedBy = EXCLUDED.ccjLastChangedBy, ccjLct = EXCLUDED.ccjLct */; END ';
      _stmtList.add_11rb$(element_311);
      var element_312 = ' CREATE TABLE IF NOT EXISTS PersonParentJoinReplicate ( ppjPk INTEGER NOT NULL, ppjVersionId INTEGER NOT NULL DEFAULT 0, ppjDestination INTEGER NOT NULL, ppjPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (ppjPk, ppjDestination)) ';
      _stmtList.add_11rb$(element_312);
      var element_313 = ' CREATE INDEX index_PersonParentJoinReplicate_ppjPk_ppjDestination_ppjVersionId ON PersonParentJoinReplicate (ppjPk, ppjDestination, ppjVersionId) ';
      _stmtList.add_11rb$(element_313);
      var element_314 = ' CREATE INDEX index_PersonParentJoinReplicate_ppjDestination_ppjPending ON PersonParentJoinReplicate (ppjDestination, ppjPending) ';
      _stmtList.add_11rb$(element_314);
      var element_315 = ' CREATE TRIGGER ch_ins_512 AFTER INSERT ON PersonParentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 512 AS chTableId, NEW.ppjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 512 AND chEntityPk = NEW.ppjUid); END ';
      _stmtList.add_11rb$(element_315);
      var element_316 = ' CREATE TRIGGER ch_upd_512 AFTER UPDATE ON PersonParentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 512 AS chTableId, NEW.ppjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 512 AND chEntityPk = NEW.ppjUid); END ';
      _stmtList.add_11rb$(element_316);
      var element_317 = ' CREATE TRIGGER ch_del_512 AFTER DELETE ON PersonParentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 512 AS chTableId, OLD.ppjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 512 AND chEntityPk = OLD.ppjUid); END ';
      _stmtList.add_11rb$(element_317);
      var element_318 = 'CREATE VIEW PersonParentJoin_ReceiveView AS  SELECT PersonParentJoin.*, PersonParentJoinReplicate.* FROM PersonParentJoin LEFT JOIN PersonParentJoinReplicate ON PersonParentJoinReplicate.ppjPk = PersonParentJoin.ppjUid ';
      _stmtList.add_11rb$(element_318);
      var element_319 = ' CREATE TRIGGER personparentjoin_remote_insert_ins INSTEAD OF INSERT ON PersonParentJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonParentJoin(ppjUid, ppjPcsn, ppjLcsn, ppjLcb, ppjLct, ppjParentPersonUid, ppjMinorPersonUid, ppjRelationship, ppjEmail, ppjPhone, ppjInactive, ppjStatus, ppjApprovalTiemstamp, ppjApprovalIpAddr) VALUES (NEW.ppjUid, NEW.ppjPcsn, NEW.ppjLcsn, NEW.ppjLcb, NEW.ppjLct, NEW.ppjParentPersonUid, NEW.ppjMinorPersonUid, NEW.ppjRelationship, NEW.ppjEmail, NEW.ppjPhone, NEW.ppjInactive, NEW.ppjStatus, NEW.ppjApprovalTiemstamp, NEW.ppjApprovalIpAddr) /*psql ON CONFLICT (ppjUid) DO UPDATE SET ppjPcsn = EXCLUDED.ppjPcsn, ppjLcsn = EXCLUDED.ppjLcsn, ppjLcb = EXCLUDED.ppjLcb, ppjLct = EXCLUDED.ppjLct, ppjParentPersonUid = EXCLUDED.ppjParentPersonUid, ppjMinorPersonUid = EXCLUDED.ppjMinorPersonUid, ppjRelationship = EXCLUDED.ppjRelationship, ppjEmail = EXCLUDED.ppjEmail, ppjPhone = EXCLUDED.ppjPhone, ppjInactive = EXCLUDED.ppjInactive, ppjStatus = EXCLUDED.ppjStatus, ppjApprovalTiemstamp = EXCLUDED.ppjApprovalTiemstamp, ppjApprovalIpAddr = EXCLUDED.ppjApprovalIpAddr */; END ';
      _stmtList.add_11rb$(element_319);
      var element_320 = ' CREATE TABLE IF NOT EXISTS ScopedGrantReplicate ( sgPk INTEGER NOT NULL, sgVersionId INTEGER NOT NULL DEFAULT 0, sgDestination INTEGER NOT NULL, sgPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (sgPk, sgDestination)) ';
      _stmtList.add_11rb$(element_320);
      var element_321 = ' CREATE INDEX index_ScopedGrantReplicate_sgPk_sgDestination_sgVersionId ON ScopedGrantReplicate (sgPk, sgDestination, sgVersionId) ';
      _stmtList.add_11rb$(element_321);
      var element_322 = ' CREATE INDEX index_ScopedGrantReplicate_sgDestination_sgPending ON ScopedGrantReplicate (sgDestination, sgPending) ';
      _stmtList.add_11rb$(element_322);
      var element_323 = ' CREATE TRIGGER ch_ins_48 AFTER INSERT ON ScopedGrant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 48 AS chTableId, NEW.sgUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 48 AND chEntityPk = NEW.sgUid); END ';
      _stmtList.add_11rb$(element_323);
      var element_324 = ' CREATE TRIGGER ch_upd_48 AFTER UPDATE ON ScopedGrant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 48 AS chTableId, NEW.sgUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 48 AND chEntityPk = NEW.sgUid); END ';
      _stmtList.add_11rb$(element_324);
      var element_325 = ' CREATE TRIGGER ch_del_48 AFTER DELETE ON ScopedGrant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 48 AS chTableId, OLD.sgUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 48 AND chEntityPk = OLD.sgUid); END ';
      _stmtList.add_11rb$(element_325);
      var element_326 = 'CREATE VIEW ScopedGrant_ReceiveView AS  SELECT ScopedGrant.*, ScopedGrantReplicate.* FROM ScopedGrant LEFT JOIN ScopedGrantReplicate ON ScopedGrantReplicate.sgPk = ScopedGrant.sgUid ';
      _stmtList.add_11rb$(element_326);
      var element_327 = ' CREATE TRIGGER sg_remote_insert_ins INSTEAD OF INSERT ON ScopedGrant_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ScopedGrant(sgUid, sgPcsn, sgLcsn, sgLcb, sgLct, sgTableId, sgEntityUid, sgPermissions, sgGroupUid, sgIndex, sgFlags) VALUES (NEW.sgUid, NEW.sgPcsn, NEW.sgLcsn, NEW.sgLcb, NEW.sgLct, NEW.sgTableId, NEW.sgEntityUid, NEW.sgPermissions, NEW.sgGroupUid, NEW.sgIndex, NEW.sgFlags) /*psql ON CONFLICT(sgUid) DO UPDATE SET sgLct = EXCLUDED.sgLct, sgPermissions = EXCLUDED.sgPermissions */ ; END ';
      _stmtList.add_11rb$(element_327);
      var element_328 = ' CREATE TABLE IF NOT EXISTS ErrorReportReplicate ( erPk INTEGER NOT NULL, erVersionId INTEGER NOT NULL DEFAULT 0, erDestination INTEGER NOT NULL, erPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (erPk, erDestination)) ';
      _stmtList.add_11rb$(element_328);
      var element_329 = ' CREATE INDEX index_ErrorReportReplicate_erPk_erDestination_erVersionId ON ErrorReportReplicate (erPk, erDestination, erVersionId) ';
      _stmtList.add_11rb$(element_329);
      var element_330 = ' CREATE INDEX index_ErrorReportReplicate_erDestination_erPending ON ErrorReportReplicate (erDestination, erPending) ';
      _stmtList.add_11rb$(element_330);
      var element_331 = ' CREATE TRIGGER ch_ins_419 AFTER INSERT ON ErrorReport BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 419 AS chTableId, NEW.errUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 419 AND chEntityPk = NEW.errUid); END ';
      _stmtList.add_11rb$(element_331);
      var element_332 = ' CREATE TRIGGER ch_upd_419 AFTER UPDATE ON ErrorReport BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 419 AS chTableId, NEW.errUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 419 AND chEntityPk = NEW.errUid); END ';
      _stmtList.add_11rb$(element_332);
      var element_333 = ' CREATE TRIGGER ch_del_419 AFTER DELETE ON ErrorReport BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 419 AS chTableId, OLD.errUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 419 AND chEntityPk = OLD.errUid); END ';
      _stmtList.add_11rb$(element_333);
      var element_334 = 'CREATE VIEW ErrorReport_ReceiveView AS  SELECT ErrorReport.*, ErrorReportReplicate.* FROM ErrorReport LEFT JOIN ErrorReportReplicate ON ErrorReportReplicate.erPk = ErrorReport.errUid ';
      _stmtList.add_11rb$(element_334);
      var element_335 = ' CREATE TRIGGER errorreport_remote_insert_ins INSTEAD OF INSERT ON ErrorReport_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ErrorReport(errUid, errPcsn, errLcsn, errLcb, errLct, severity, timestamp, presenterUri, appVersion, versionCode, errorCode, operatingSys, osVersion, stackTrace, message) VALUES (NEW.errUid, NEW.errPcsn, NEW.errLcsn, NEW.errLcb, NEW.errLct, NEW.severity, NEW.timestamp, NEW.presenterUri, NEW.appVersion, NEW.versionCode, NEW.errorCode, NEW.operatingSys, NEW.osVersion, NEW.stackTrace, NEW.message) /*psql ON CONFLICT (errUid) DO UPDATE SET errPcsn = EXCLUDED.errPcsn, errLcsn = EXCLUDED.errLcsn, errLcb = EXCLUDED.errLcb, errLct = EXCLUDED.errLct, severity = EXCLUDED.severity, timestamp = EXCLUDED.timestamp, presenterUri = EXCLUDED.presenterUri, appVersion = EXCLUDED.appVersion, versionCode = EXCLUDED.versionCode, errorCode = EXCLUDED.errorCode, operatingSys = EXCLUDED.operatingSys, osVersion = EXCLUDED.osVersion, stackTrace = EXCLUDED.stackTrace, message = EXCLUDED.message */; END ';
      _stmtList.add_11rb$(element_335);
      var element_336 = ' CREATE TABLE IF NOT EXISTS ClazzAssignmentReplicate ( caPk INTEGER NOT NULL, caVersionId INTEGER NOT NULL DEFAULT 0, caDestination INTEGER NOT NULL, caPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (caPk, caDestination)) ';
      _stmtList.add_11rb$(element_336);
      var element_337 = ' CREATE INDEX index_ClazzAssignmentReplicate_caPk_caDestination_caVersionId ON ClazzAssignmentReplicate (caPk, caDestination, caVersionId) ';
      _stmtList.add_11rb$(element_337);
      var element_338 = ' CREATE INDEX index_ClazzAssignmentReplicate_caDestination_caPending ON ClazzAssignmentReplicate (caDestination, caPending) ';
      _stmtList.add_11rb$(element_338);
      var element_339 = ' CREATE TRIGGER ch_ins_520 AFTER INSERT ON ClazzAssignment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 520 AS chTableId, NEW.caUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 520 AND chEntityPk = NEW.caUid); END ';
      _stmtList.add_11rb$(element_339);
      var element_340 = ' CREATE TRIGGER ch_upd_520 AFTER UPDATE ON ClazzAssignment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 520 AS chTableId, NEW.caUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 520 AND chEntityPk = NEW.caUid); END ';
      _stmtList.add_11rb$(element_340);
      var element_341 = ' CREATE TRIGGER ch_del_520 AFTER DELETE ON ClazzAssignment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 520 AS chTableId, OLD.caUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 520 AND chEntityPk = OLD.caUid); END ';
      _stmtList.add_11rb$(element_341);
      var element_342 = 'CREATE VIEW ClazzAssignment_ReceiveView AS  SELECT ClazzAssignment.*, ClazzAssignmentReplicate.* FROM ClazzAssignment LEFT JOIN ClazzAssignmentReplicate ON ClazzAssignmentReplicate.caPk = ClazzAssignment.caUid ';
      _stmtList.add_11rb$(element_342);
      var element_343 = ' CREATE TRIGGER clazzassignment_remote_insert_ins INSTEAD OF INSERT ON ClazzAssignment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzAssignment(caUid, caTitle, caDescription, caDeadlineDate, caStartDate, caLateSubmissionType, caLateSubmissionPenalty, caGracePeriodDate, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caClazzUid, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES (NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caDeadlineDate, NEW.caStartDate, NEW.caLateSubmissionType, NEW.caLateSubmissionPenalty, NEW.caGracePeriodDate, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caClazzUid, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) /*psql ON CONFLICT (caUid) DO UPDATE SET caTitle = EXCLUDED.caTitle, caDescription = EXCLUDED.caDescription, caDeadlineDate = EXCLUDED.caDeadlineDate, caStartDate = EXCLUDED.caStartDate, caLateSubmissionType = EXCLUDED.caLateSubmissionType, caLateSubmissionPenalty = EXCLUDED.caLateSubmissionPenalty, caGracePeriodDate = EXCLUDED.caGracePeriodDate, caActive = EXCLUDED.caActive, caClassCommentEnabled = EXCLUDED.caClassCommentEnabled, caPrivateCommentsEnabled = EXCLUDED.caPrivateCommentsEnabled, caClazzUid = EXCLUDED.caClazzUid, caLocalChangeSeqNum = EXCLUDED.caLocalChangeSeqNum, caMasterChangeSeqNum = EXCLUDED.caMasterChangeSeqNum, caLastChangedBy = EXCLUDED.caLastChangedBy, caLct = EXCLUDED.caLct */; END ';
      _stmtList.add_11rb$(element_343);
      var element_344 = ' CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoinReplicate ( cacjPk INTEGER NOT NULL, cacjVersionId INTEGER NOT NULL DEFAULT 0, cacjDestination INTEGER NOT NULL, cacjPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (cacjPk, cacjDestination)) ';
      _stmtList.add_11rb$(element_344);
      var element_345 = ' CREATE INDEX index_ClazzAssignmentContentJoinReplicate_cacjPk_cacjDestination_cacjVersionId ON ClazzAssignmentContentJoinReplicate (cacjPk, cacjDestination, cacjVersionId) ';
      _stmtList.add_11rb$(element_345);
      var element_346 = ' CREATE INDEX index_ClazzAssignmentContentJoinReplicate_cacjDestination_cacjPending ON ClazzAssignmentContentJoinReplicate (cacjDestination, cacjPending) ';
      _stmtList.add_11rb$(element_346);
      var element_347 = ' CREATE TRIGGER ch_ins_521 AFTER INSERT ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, NEW.cacjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = NEW.cacjUid); END ';
      _stmtList.add_11rb$(element_347);
      var element_348 = ' CREATE TRIGGER ch_upd_521 AFTER UPDATE ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, NEW.cacjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = NEW.cacjUid); END ';
      _stmtList.add_11rb$(element_348);
      var element_349 = ' CREATE TRIGGER ch_del_521 AFTER DELETE ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, OLD.cacjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = OLD.cacjUid); END ';
      _stmtList.add_11rb$(element_349);
      var element_350 = 'CREATE VIEW ClazzAssignmentContentJoin_ReceiveView AS  SELECT ClazzAssignmentContentJoin.*, ClazzAssignmentContentJoinReplicate.* FROM ClazzAssignmentContentJoin LEFT JOIN ClazzAssignmentContentJoinReplicate ON ClazzAssignmentContentJoinReplicate.cacjPk = ClazzAssignmentContentJoin.cacjUid ';
      _stmtList.add_11rb$(element_350);
      var element_351 = ' CREATE TRIGGER clazzassignmentcontentjoin_remote_insert_ins INSTEAD OF INSERT ON ClazzAssignmentContentJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzAssignmentContentJoin(cacjUid, cacjContentUid, cacjAssignmentUid, cacjActive, cacjMCSN, cacjLCSN, cacjLCB, cacjLct) VALUES (NEW.cacjUid, NEW.cacjContentUid, NEW.cacjAssignmentUid, NEW.cacjActive, NEW.cacjMCSN, NEW.cacjLCSN, NEW.cacjLCB, NEW.cacjLct) /*psql ON CONFLICT (cacjUid) DO UPDATE SET cacjContentUid = EXCLUDED.cacjContentUid, cacjAssignmentUid = EXCLUDED.cacjAssignmentUid, cacjActive = EXCLUDED.cacjActive, cacjMCSN = EXCLUDED.cacjMCSN, cacjLCSN = EXCLUDED.cacjLCSN, cacjLCB = EXCLUDED.cacjLCB, cacjLct = EXCLUDED.cacjLct */; END ';
      _stmtList.add_11rb$(element_351);
      var element_352 = ' CREATE TABLE IF NOT EXISTS PersonAuth2Replicate ( paPk INTEGER NOT NULL, paVersionId INTEGER NOT NULL DEFAULT 0, paDestination INTEGER NOT NULL, paPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (paPk, paDestination)) ';
      _stmtList.add_11rb$(element_352);
      var element_353 = ' CREATE INDEX index_PersonAuth2Replicate_paPk_paDestination_paVersionId ON PersonAuth2Replicate (paPk, paDestination, paVersionId) ';
      _stmtList.add_11rb$(element_353);
      var element_354 = ' CREATE INDEX index_PersonAuth2Replicate_paDestination_paPending ON PersonAuth2Replicate (paDestination, paPending) ';
      _stmtList.add_11rb$(element_354);
      var element_355 = ' CREATE TRIGGER ch_ins_678 AFTER INSERT ON PersonAuth2 BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 678 AS chTableId, NEW.pauthUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 678 AND chEntityPk = NEW.pauthUid); END ';
      _stmtList.add_11rb$(element_355);
      var element_356 = ' CREATE TRIGGER ch_upd_678 AFTER UPDATE ON PersonAuth2 BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 678 AS chTableId, NEW.pauthUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 678 AND chEntityPk = NEW.pauthUid); END ';
      _stmtList.add_11rb$(element_356);
      var element_357 = ' CREATE TRIGGER ch_del_678 AFTER DELETE ON PersonAuth2 BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 678 AS chTableId, OLD.pauthUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 678 AND chEntityPk = OLD.pauthUid); END ';
      _stmtList.add_11rb$(element_357);
      var element_358 = 'CREATE VIEW PersonAuth2_ReceiveView AS  SELECT PersonAuth2.*, PersonAuth2Replicate.* FROM PersonAuth2 LEFT JOIN PersonAuth2Replicate ON PersonAuth2Replicate.paPk = PersonAuth2.pauthUid ';
      _stmtList.add_11rb$(element_358);
      var element_359 = ' CREATE TRIGGER personauth2_remote_insert_ins INSTEAD OF INSERT ON PersonAuth2_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonAuth2(pauthUid, pauthMechanism, pauthAuth, pauthLcsn, pauthPcsn, pauthLcb, pauthLct) VALUES (NEW.pauthUid, NEW.pauthMechanism, NEW.pauthAuth, NEW.pauthLcsn, NEW.pauthPcsn, NEW.pauthLcb, NEW.pauthLct) /*psql ON CONFLICT (pauthUid) DO UPDATE SET pauthMechanism = EXCLUDED.pauthMechanism, pauthAuth = EXCLUDED.pauthAuth, pauthLcsn = EXCLUDED.pauthLcsn, pauthPcsn = EXCLUDED.pauthPcsn, pauthLcb = EXCLUDED.pauthLcb, pauthLct = EXCLUDED.pauthLct */; END ';
      _stmtList.add_11rb$(element_359);
      var element_360 = ' CREATE TABLE IF NOT EXISTS UserSessionReplicate ( usPk INTEGER NOT NULL, usVersionId INTEGER NOT NULL DEFAULT 0, usDestination INTEGER NOT NULL, usPending INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (usPk, usDestination)) ';
      _stmtList.add_11rb$(element_360);
      var element_361 = ' CREATE INDEX index_UserSessionReplicate_usPk_usDestination_usVersionId ON UserSessionReplicate (usPk, usDestination, usVersionId) ';
      _stmtList.add_11rb$(element_361);
      var element_362 = ' CREATE INDEX index_UserSessionReplicate_usDestination_usPending ON UserSessionReplicate (usDestination, usPending) ';
      _stmtList.add_11rb$(element_362);
      var element_363 = ' CREATE TRIGGER ch_ins_679 AFTER INSERT ON UserSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 679 AS chTableId, NEW.usUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 679 AND chEntityPk = NEW.usUid); END ';
      _stmtList.add_11rb$(element_363);
      var element_364 = ' CREATE TRIGGER ch_upd_679 AFTER UPDATE ON UserSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 679 AS chTableId, NEW.usUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 679 AND chEntityPk = NEW.usUid); END ';
      _stmtList.add_11rb$(element_364);
      var element_365 = ' CREATE TRIGGER ch_del_679 AFTER DELETE ON UserSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 679 AS chTableId, OLD.usUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 679 AND chEntityPk = OLD.usUid); END ';
      _stmtList.add_11rb$(element_365);
      var element_366 = 'CREATE VIEW UserSession_ReceiveView AS  SELECT UserSession.*, UserSessionReplicate.* FROM UserSession LEFT JOIN UserSessionReplicate ON UserSessionReplicate.usPk = UserSession.usUid ';
      _stmtList.add_11rb$(element_366);
      var element_367 = ' CREATE TRIGGER usersession_remote_ins_ins INSTEAD OF INSERT ON UserSession_ReceiveView FOR EACH ROW BEGIN REPLACE INTO UserSession(usUid, usPcsn, usLcsn, usLcb, usLct, usPersonUid, usClientNodeId, usStartTime, usEndTime, usStatus, usReason, usAuth, usSessionType) VALUES (NEW.usUid, NEW.usPcsn, NEW.usLcsn, NEW.usLcb, NEW.usLct, NEW.usPersonUid, NEW.usClientNodeId, NEW.usStartTime, NEW.usEndTime, NEW.usStatus, NEW.usReason, NEW.usAuth, NEW.usSessionType) /*postgres ON CONFLICT (usUid) DO UPDATE SET usStatus = EXCLUDED.usStatus, usEndTime = EXCLUDED.usEndTime, usReason = EXCLUDED.usReason */ ; END ';
      _stmtList.add_11rb$(element_367);
    } else {
      var element_368 = 'UPDATE ClazzLog SET clazzLogLastChangedTime = ' + systemTimeInMillis().toString() + ' WHERE clazzLogLastChangedTime = 0';
      _stmtList.add_11rb$(element_368);
      var element_369 = 'UPDATE ClazzLogAttendanceRecord SET clazzLogAttendanceRecordLastChangedTime = ' + systemTimeInMillis().toString() + ' WHERE clazzLogAttendanceRecordLastChangedTime = 0';
      _stmtList.add_11rb$(element_369);
      var element_370 = 'UPDATE Schedule SET scheduleLastChangedTime = ' + systemTimeInMillis().toString() + ' WHERE scheduleLastChangedTime = 0';
      _stmtList.add_11rb$(element_370);
      var element_371 = 'UPDATE HolidayCalendar SET umCalendarLct = ' + systemTimeInMillis().toString() + ' WHERE umCalendarLct = 0';
      _stmtList.add_11rb$(element_371);
      var element_372 = 'UPDATE Holiday SET holLct = ' + systemTimeInMillis().toString() + ' WHERE holLct = 0';
      _stmtList.add_11rb$(element_372);
      var element_373 = 'UPDATE Person SET personLct = ' + systemTimeInMillis().toString() + ' WHERE personLct = 0';
      _stmtList.add_11rb$(element_373);
      var element_374 = 'UPDATE Clazz SET clazzLct = ' + systemTimeInMillis().toString() + ' WHERE clazzLct = 0';
      _stmtList.add_11rb$(element_374);
      var element_375 = 'UPDATE ClazzEnrolment SET clazzEnrolmentLct = ' + systemTimeInMillis().toString() + ' WHERE clazzEnrolmentLct = 0';
      _stmtList.add_11rb$(element_375);
      var element_376 = 'UPDATE LeavingReason SET leavingReasonLct = ' + systemTimeInMillis().toString() + ' WHERE leavingReasonLct = 0';
      _stmtList.add_11rb$(element_376);
      var element_377 = 'UPDATE ContentEntry SET contentEntryLct = ' + systemTimeInMillis().toString() + ' WHERE contentEntryLct = 0';
      _stmtList.add_11rb$(element_377);
      var element_378 = 'UPDATE ContentEntryContentCategoryJoin SET ceccjLct = ' + systemTimeInMillis().toString() + ' WHERE ceccjLct = 0';
      _stmtList.add_11rb$(element_378);
      var element_379 = 'UPDATE ContentEntryParentChildJoin SET cepcjLct = ' + systemTimeInMillis().toString() + ' WHERE cepcjLct = 0';
      _stmtList.add_11rb$(element_379);
      var element_380 = 'UPDATE ContentEntryRelatedEntryJoin SET cerejLct = ' + systemTimeInMillis().toString() + ' WHERE cerejLct = 0';
      _stmtList.add_11rb$(element_380);
      var element_381 = 'UPDATE ContentCategorySchema SET contentCategorySchemaLct = ' + systemTimeInMillis().toString() + ' WHERE contentCategorySchemaLct = 0';
      _stmtList.add_11rb$(element_381);
      var element_382 = 'UPDATE ContentCategory SET contentCategoryLct = ' + systemTimeInMillis().toString() + ' WHERE contentCategoryLct = 0';
      _stmtList.add_11rb$(element_382);
      var element_383 = 'UPDATE Language SET langLct = ' + systemTimeInMillis().toString() + ' WHERE langLct = 0';
      _stmtList.add_11rb$(element_383);
      var element_384 = 'UPDATE LanguageVariant SET langVariantLct = ' + systemTimeInMillis().toString() + ' WHERE langVariantLct = 0';
      _stmtList.add_11rb$(element_384);
      var element_385 = 'UPDATE PersonGroup SET groupLct = ' + systemTimeInMillis().toString() + ' WHERE groupLct = 0';
      _stmtList.add_11rb$(element_385);
      var element_386 = 'UPDATE PersonGroupMember SET groupMemberLct = ' + systemTimeInMillis().toString() + ' WHERE groupMemberLct = 0';
      _stmtList.add_11rb$(element_386);
      var element_387 = 'UPDATE PersonPicture SET personPictureLct = ' + systemTimeInMillis().toString() + ' WHERE personPictureLct = 0';
      _stmtList.add_11rb$(element_387);
      var element_388 = 'UPDATE Container SET cntLct = ' + systemTimeInMillis().toString() + ' WHERE cntLct = 0';
      _stmtList.add_11rb$(element_388);
      var element_389 = 'UPDATE VerbEntity SET verbLct = ' + systemTimeInMillis().toString() + ' WHERE verbLct = 0';
      _stmtList.add_11rb$(element_389);
      var element_390 = 'UPDATE XObjectEntity SET xObjectLct = ' + systemTimeInMillis().toString() + ' WHERE xObjectLct = 0';
      _stmtList.add_11rb$(element_390);
      var element_391 = 'UPDATE StatementEntity SET statementLct = ' + systemTimeInMillis().toString() + ' WHERE statementLct = 0';
      _stmtList.add_11rb$(element_391);
      var element_392 = 'UPDATE ContextXObjectStatementJoin SET contextXObjectLct = ' + systemTimeInMillis().toString() + ' WHERE contextXObjectLct = 0';
      _stmtList.add_11rb$(element_392);
      var element_393 = 'UPDATE AgentEntity SET agentLct = ' + systemTimeInMillis().toString() + ' WHERE agentLct = 0';
      _stmtList.add_11rb$(element_393);
      var element_394 = 'UPDATE StateEntity SET stateLct = ' + systemTimeInMillis().toString() + ' WHERE stateLct = 0';
      _stmtList.add_11rb$(element_394);
      var element_395 = 'UPDATE StateContentEntity SET stateContentLct = ' + systemTimeInMillis().toString() + ' WHERE stateContentLct = 0';
      _stmtList.add_11rb$(element_395);
      var element_396 = 'UPDATE XLangMapEntry SET statementLangMapLct = ' + systemTimeInMillis().toString() + ' WHERE statementLangMapLct = 0';
      _stmtList.add_11rb$(element_396);
      var element_397 = 'UPDATE School SET schoolLct = ' + systemTimeInMillis().toString() + ' WHERE schoolLct = 0';
      _stmtList.add_11rb$(element_397);
      var element_398 = 'UPDATE SchoolMember SET schoolMemberLct = ' + systemTimeInMillis().toString() + ' WHERE schoolMemberLct = 0';
      _stmtList.add_11rb$(element_398);
      var element_399 = 'UPDATE Comments SET commentsLct = ' + systemTimeInMillis().toString() + ' WHERE commentsLct = 0';
      _stmtList.add_11rb$(element_399);
      var element_400 = 'UPDATE Report SET reportLct = ' + systemTimeInMillis().toString() + ' WHERE reportLct = 0';
      _stmtList.add_11rb$(element_400);
      var element_401 = 'UPDATE Site SET siteLct = ' + systemTimeInMillis().toString() + ' WHERE siteLct = 0';
      _stmtList.add_11rb$(element_401);
      var element_402 = 'UPDATE LearnerGroup SET learnerGroupLct = ' + systemTimeInMillis().toString() + ' WHERE learnerGroupLct = 0';
      _stmtList.add_11rb$(element_402);
      var element_403 = 'UPDATE LearnerGroupMember SET learnerGroupMemberLct = ' + systemTimeInMillis().toString() + ' WHERE learnerGroupMemberLct = 0';
      _stmtList.add_11rb$(element_403);
      var element_404 = 'UPDATE GroupLearningSession SET groupLearningSessionLct = ' + systemTimeInMillis().toString() + ' WHERE groupLearningSessionLct = 0';
      _stmtList.add_11rb$(element_404);
      var element_405 = 'UPDATE SiteTerms SET sTermsLct = ' + systemTimeInMillis().toString() + ' WHERE sTermsLct = 0';
      _stmtList.add_11rb$(element_405);
      var element_406 = 'UPDATE ClazzContentJoin SET ccjLct = ' + systemTimeInMillis().toString() + ' WHERE ccjLct = 0';
      _stmtList.add_11rb$(element_406);
      var element_407 = 'UPDATE PersonParentJoin SET ppjLct = ' + systemTimeInMillis().toString() + ' WHERE ppjLct = 0';
      _stmtList.add_11rb$(element_407);
      var element_408 = 'UPDATE ScopedGrant SET sgLct = ' + systemTimeInMillis().toString() + ' WHERE sgLct = 0';
      _stmtList.add_11rb$(element_408);
      var element_409 = 'UPDATE ErrorReport SET errLct = ' + systemTimeInMillis().toString() + ' WHERE errLct = 0';
      _stmtList.add_11rb$(element_409);
      var element_410 = 'UPDATE ClazzAssignment SET caLct = ' + systemTimeInMillis().toString() + ' WHERE caLct = 0';
      _stmtList.add_11rb$(element_410);
      var element_411 = 'UPDATE ClazzAssignmentContentJoin SET cacjLct = ' + systemTimeInMillis().toString() + ' WHERE cacjLct = 0';
      _stmtList.add_11rb$(element_411);
      var element_412 = 'UPDATE PersonAuth2 SET pauthLct = ' + systemTimeInMillis().toString() + ' WHERE pauthLct = 0';
      _stmtList.add_11rb$(element_412);
      var element_413 = 'UPDATE UserSession SET usLct = ' + systemTimeInMillis().toString() + ' WHERE usLct = 0';
      _stmtList.add_11rb$(element_413);
      var element_414 = ' CREATE TABLE IF NOT EXISTS ClazzLogReplicate ( clPk BIGINT NOT NULL, clVersionId BIGINT NOT NULL DEFAULT 0, clDestination BIGINT NOT NULL, clPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (clPk, clDestination)) ';
      _stmtList.add_11rb$(element_414);
      var element_415 = ' CREATE INDEX index_ClazzLogReplicate_clPk_clDestination_clVersionId ON ClazzLogReplicate (clPk, clDestination, clVersionId) ';
      _stmtList.add_11rb$(element_415);
      var element_416 = ' CREATE INDEX index_ClazzLogReplicate_clDestination_clPending ON ClazzLogReplicate (clDestination, clPending) ';
      _stmtList.add_11rb$(element_416);
      var element_417 = ' CREATE OR REPLACE FUNCTION ch_upd_14_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (14, NEW.clazzLogUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_417);
      var element_418 = ' CREATE TRIGGER ch_upd_14_trig AFTER UPDATE OR INSERT ON ClazzLog FOR EACH ROW EXECUTE PROCEDURE ch_upd_14_fn(); ';
      _stmtList.add_11rb$(element_418);
      var element_419 = ' CREATE OR REPLACE FUNCTION ch_del_14_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (14, OLD.clazzLogUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_419);
      var element_420 = ' CREATE TRIGGER ch_del_14_trig AFTER DELETE ON ClazzLog FOR EACH ROW EXECUTE PROCEDURE ch_del_14_fn(); ';
      _stmtList.add_11rb$(element_420);
      var element_421 = 'CREATE VIEW ClazzLog_ReceiveView AS  SELECT ClazzLog.*, ClazzLogReplicate.* FROM ClazzLog LEFT JOIN ClazzLogReplicate ON ClazzLogReplicate.clPk = ClazzLog.clazzLogUid ';
      _stmtList.add_11rb$(element_421);
      var element_422 = "CREATE OR REPLACE FUNCTION clazzlog_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzLog(clazzLogUid, clazzLogClazzUid, logDate, timeRecorded, clazzLogDone, cancellationNote, clazzLogCancelled, clazzLogNumPresent, clazzLogNumAbsent, clazzLogNumPartial, clazzLogScheduleUid, clazzLogStatusFlag, clazzLogMSQN, clazzLogLCSN, clazzLogLCB, clazzLogLastChangedTime) VALUES (NEW.clazzLogUid, NEW.clazzLogClazzUid, NEW.logDate, NEW.timeRecorded, NEW.clazzLogDone, NEW.cancellationNote, NEW.clazzLogCancelled, NEW.clazzLogNumPresent, NEW.clazzLogNumAbsent, NEW.clazzLogNumPartial, NEW.clazzLogScheduleUid, NEW.clazzLogStatusFlag, NEW.clazzLogMSQN, NEW.clazzLogLCSN, NEW.clazzLogLCB, NEW.clazzLogLastChangedTime) ON CONFLICT (clazzLogUid) DO UPDATE SET clazzLogClazzUid = EXCLUDED.clazzLogClazzUid, logDate = EXCLUDED.logDate, timeRecorded = EXCLUDED.timeRecorded, clazzLogDone = EXCLUDED.clazzLogDone, cancellationNote = EXCLUDED.cancellationNote, clazzLogCancelled = EXCLUDED.clazzLogCancelled, clazzLogNumPresent = EXCLUDED.clazzLogNumPresent, clazzLogNumAbsent = EXCLUDED.clazzLogNumAbsent, clazzLogNumPartial = EXCLUDED.clazzLogNumPartial, clazzLogScheduleUid = EXCLUDED.clazzLogScheduleUid, clazzLogStatusFlag = EXCLUDED.clazzLogStatusFlag, clazzLogMSQN = EXCLUDED.clazzLogMSQN, clazzLogLCSN = EXCLUDED.clazzLogLCSN, clazzLogLCB = EXCLUDED.clazzLogLCB, clazzLogLastChangedTime = EXCLUDED.clazzLogLastChangedTime ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_422);
      var element_423 = ' CREATE TRIGGER clazzlog_remote_insert_trig INSTEAD OF INSERT ON ClazzLog_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzlog_remote_insert_fn() ';
      _stmtList.add_11rb$(element_423);
      var element_424 = ' CREATE TABLE IF NOT EXISTS ClazzLogAttendanceRecordReplicate ( clarPk BIGINT NOT NULL, clarVersionId BIGINT NOT NULL DEFAULT 0, clarDestination BIGINT NOT NULL, clarPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (clarPk, clarDestination)) ';
      _stmtList.add_11rb$(element_424);
      var element_425 = ' CREATE INDEX index_ClazzLogAttendanceRecordReplicate_clarPk_clarDestination_clarVersionId ON ClazzLogAttendanceRecordReplicate (clarPk, clarDestination, clarVersionId) ';
      _stmtList.add_11rb$(element_425);
      var element_426 = ' CREATE INDEX index_ClazzLogAttendanceRecordReplicate_clarDestination_clarPending ON ClazzLogAttendanceRecordReplicate (clarDestination, clarPending) ';
      _stmtList.add_11rb$(element_426);
      var element_427 = ' CREATE OR REPLACE FUNCTION ch_upd_15_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (15, NEW.clazzLogAttendanceRecordUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_427);
      var element_428 = ' CREATE TRIGGER ch_upd_15_trig AFTER UPDATE OR INSERT ON ClazzLogAttendanceRecord FOR EACH ROW EXECUTE PROCEDURE ch_upd_15_fn(); ';
      _stmtList.add_11rb$(element_428);
      var element_429 = ' CREATE OR REPLACE FUNCTION ch_del_15_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (15, OLD.clazzLogAttendanceRecordUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_429);
      var element_430 = ' CREATE TRIGGER ch_del_15_trig AFTER DELETE ON ClazzLogAttendanceRecord FOR EACH ROW EXECUTE PROCEDURE ch_del_15_fn(); ';
      _stmtList.add_11rb$(element_430);
      var element_431 = 'CREATE VIEW ClazzLogAttendanceRecord_ReceiveView AS  SELECT ClazzLogAttendanceRecord.*, ClazzLogAttendanceRecordReplicate.* FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLogAttendanceRecordReplicate ON ClazzLogAttendanceRecordReplicate.clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid ';
      _stmtList.add_11rb$(element_431);
      var element_432 = "CREATE OR REPLACE FUNCTION clazzlogattendancerecord_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzLogAttendanceRecord(clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES (NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime) ON CONFLICT (clazzLogAttendanceRecordUid) DO UPDATE SET clazzLogAttendanceRecordClazzLogUid = EXCLUDED.clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid = EXCLUDED.clazzLogAttendanceRecordPersonUid, attendanceStatus = EXCLUDED.attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy = EXCLUDED.clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime = EXCLUDED.clazzLogAttendanceRecordLastChangedTime ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_432);
      var element_433 = ' CREATE TRIGGER clazzlogattendancerecord_remote_insert_trig INSTEAD OF INSERT ON ClazzLogAttendanceRecord_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzlogattendancerecord_remote_insert_fn() ';
      _stmtList.add_11rb$(element_433);
      var element_434 = ' CREATE TABLE IF NOT EXISTS ScheduleReplicate ( schedulePk BIGINT NOT NULL, scheduleVersionId BIGINT NOT NULL DEFAULT 0, scheduleDestination BIGINT NOT NULL, schedulePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (schedulePk, scheduleDestination)) ';
      _stmtList.add_11rb$(element_434);
      var element_435 = ' CREATE INDEX index_ScheduleReplicate_schedulePk_scheduleDestination_scheduleVersionId ON ScheduleReplicate (schedulePk, scheduleDestination, scheduleVersionId) ';
      _stmtList.add_11rb$(element_435);
      var element_436 = ' CREATE INDEX index_ScheduleReplicate_scheduleDestination_schedulePending ON ScheduleReplicate (scheduleDestination, schedulePending) ';
      _stmtList.add_11rb$(element_436);
      var element_437 = ' CREATE OR REPLACE FUNCTION ch_upd_21_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (21, NEW.scheduleUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_437);
      var element_438 = ' CREATE TRIGGER ch_upd_21_trig AFTER UPDATE OR INSERT ON Schedule FOR EACH ROW EXECUTE PROCEDURE ch_upd_21_fn(); ';
      _stmtList.add_11rb$(element_438);
      var element_439 = ' CREATE OR REPLACE FUNCTION ch_del_21_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (21, OLD.scheduleUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_439);
      var element_440 = ' CREATE TRIGGER ch_del_21_trig AFTER DELETE ON Schedule FOR EACH ROW EXECUTE PROCEDURE ch_del_21_fn(); ';
      _stmtList.add_11rb$(element_440);
      var element_441 = 'CREATE VIEW Schedule_ReceiveView AS  SELECT Schedule.*, ScheduleReplicate.* FROM Schedule LEFT JOIN ScheduleReplicate ON ScheduleReplicate.schedulePk = Schedule.scheduleUid ';
      _stmtList.add_11rb$(element_441);
      var element_442 = "CREATE OR REPLACE FUNCTION schedule_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Schedule(scheduleUid, sceduleStartTime, scheduleEndTime, scheduleDay, scheduleMonth, scheduleFrequency, umCalendarUid, scheduleClazzUid, scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum, scheduleLastChangedBy, scheduleLastChangedTime, scheduleActive) VALUES (NEW.scheduleUid, NEW.sceduleStartTime, NEW.scheduleEndTime, NEW.scheduleDay, NEW.scheduleMonth, NEW.scheduleFrequency, NEW.umCalendarUid, NEW.scheduleClazzUid, NEW.scheduleMasterChangeSeqNum, NEW.scheduleLocalChangeSeqNum, NEW.scheduleLastChangedBy, NEW.scheduleLastChangedTime, NEW.scheduleActive) ON CONFLICT (scheduleUid) DO UPDATE SET sceduleStartTime = EXCLUDED.sceduleStartTime, scheduleEndTime = EXCLUDED.scheduleEndTime, scheduleDay = EXCLUDED.scheduleDay, scheduleMonth = EXCLUDED.scheduleMonth, scheduleFrequency = EXCLUDED.scheduleFrequency, umCalendarUid = EXCLUDED.umCalendarUid, scheduleClazzUid = EXCLUDED.scheduleClazzUid, scheduleMasterChangeSeqNum = EXCLUDED.scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum = EXCLUDED.scheduleLocalChangeSeqNum, scheduleLastChangedBy = EXCLUDED.scheduleLastChangedBy, scheduleLastChangedTime = EXCLUDED.scheduleLastChangedTime, scheduleActive = EXCLUDED.scheduleActive ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_442);
      var element_443 = ' CREATE TRIGGER schedule_remote_insert_trig INSTEAD OF INSERT ON Schedule_ReceiveView FOR EACH ROW EXECUTE PROCEDURE schedule_remote_insert_fn() ';
      _stmtList.add_11rb$(element_443);
      var element_444 = ' CREATE TABLE IF NOT EXISTS HolidayCalendarReplicate ( hcPk BIGINT NOT NULL, hcVersionId BIGINT NOT NULL DEFAULT 0, hcDestination BIGINT NOT NULL, hcPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (hcPk, hcDestination)) ';
      _stmtList.add_11rb$(element_444);
      var element_445 = ' CREATE INDEX index_HolidayCalendarReplicate_hcPk_hcDestination_hcVersionId ON HolidayCalendarReplicate (hcPk, hcDestination, hcVersionId) ';
      _stmtList.add_11rb$(element_445);
      var element_446 = ' CREATE INDEX index_HolidayCalendarReplicate_hcDestination_hcPending ON HolidayCalendarReplicate (hcDestination, hcPending) ';
      _stmtList.add_11rb$(element_446);
      var element_447 = ' CREATE OR REPLACE FUNCTION ch_upd_28_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (28, NEW.umCalendarUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_447);
      var element_448 = ' CREATE TRIGGER ch_upd_28_trig AFTER UPDATE OR INSERT ON HolidayCalendar FOR EACH ROW EXECUTE PROCEDURE ch_upd_28_fn(); ';
      _stmtList.add_11rb$(element_448);
      var element_449 = ' CREATE OR REPLACE FUNCTION ch_del_28_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (28, OLD.umCalendarUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_449);
      var element_450 = ' CREATE TRIGGER ch_del_28_trig AFTER DELETE ON HolidayCalendar FOR EACH ROW EXECUTE PROCEDURE ch_del_28_fn(); ';
      _stmtList.add_11rb$(element_450);
      var element_451 = 'CREATE VIEW HolidayCalendar_ReceiveView AS  SELECT HolidayCalendar.*, HolidayCalendarReplicate.* FROM HolidayCalendar LEFT JOIN HolidayCalendarReplicate ON HolidayCalendarReplicate.hcPk = HolidayCalendar.umCalendarUid ';
      _stmtList.add_11rb$(element_451);
      var element_452 = "CREATE OR REPLACE FUNCTION holidaycalendar_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO HolidayCalendar(umCalendarUid, umCalendarName, umCalendarCategory, umCalendarActive, umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum, umCalendarLastChangedBy, umCalendarLct) VALUES (NEW.umCalendarUid, NEW.umCalendarName, NEW.umCalendarCategory, NEW.umCalendarActive, NEW.umCalendarMasterChangeSeqNum, NEW.umCalendarLocalChangeSeqNum, NEW.umCalendarLastChangedBy, NEW.umCalendarLct) ON CONFLICT (umCalendarUid) DO UPDATE SET umCalendarName = EXCLUDED.umCalendarName, umCalendarCategory = EXCLUDED.umCalendarCategory, umCalendarActive = EXCLUDED.umCalendarActive, umCalendarMasterChangeSeqNum = EXCLUDED.umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum = EXCLUDED.umCalendarLocalChangeSeqNum, umCalendarLastChangedBy = EXCLUDED.umCalendarLastChangedBy, umCalendarLct = EXCLUDED.umCalendarLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_452);
      var element_453 = ' CREATE TRIGGER holidaycalendar_remote_insert_trig INSTEAD OF INSERT ON HolidayCalendar_ReceiveView FOR EACH ROW EXECUTE PROCEDURE holidaycalendar_remote_insert_fn() ';
      _stmtList.add_11rb$(element_453);
      var element_454 = ' CREATE TABLE IF NOT EXISTS HolidayReplicate ( holidayPk BIGINT NOT NULL, holidayVersionId BIGINT NOT NULL DEFAULT 0, holidayDestination BIGINT NOT NULL, holidayPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (holidayPk, holidayDestination)) ';
      _stmtList.add_11rb$(element_454);
      var element_455 = ' CREATE INDEX index_HolidayReplicate_holidayPk_holidayDestination_holidayVersionId ON HolidayReplicate (holidayPk, holidayDestination, holidayVersionId) ';
      _stmtList.add_11rb$(element_455);
      var element_456 = ' CREATE INDEX index_HolidayReplicate_holidayDestination_holidayPending ON HolidayReplicate (holidayDestination, holidayPending) ';
      _stmtList.add_11rb$(element_456);
      var element_457 = ' CREATE OR REPLACE FUNCTION ch_upd_99_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (99, NEW.holUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_457);
      var element_458 = ' CREATE TRIGGER ch_upd_99_trig AFTER UPDATE OR INSERT ON Holiday FOR EACH ROW EXECUTE PROCEDURE ch_upd_99_fn(); ';
      _stmtList.add_11rb$(element_458);
      var element_459 = ' CREATE OR REPLACE FUNCTION ch_del_99_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (99, OLD.holUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_459);
      var element_460 = ' CREATE TRIGGER ch_del_99_trig AFTER DELETE ON Holiday FOR EACH ROW EXECUTE PROCEDURE ch_del_99_fn(); ';
      _stmtList.add_11rb$(element_460);
      var element_461 = 'CREATE VIEW Holiday_ReceiveView AS  SELECT Holiday.*, HolidayReplicate.* FROM Holiday LEFT JOIN HolidayReplicate ON HolidayReplicate.holidayPk = Holiday.holUid ';
      _stmtList.add_11rb$(element_461);
      var element_462 = "CREATE OR REPLACE FUNCTION holiday_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Holiday(holUid, holMasterCsn, holLocalCsn, holLastModBy, holLct, holActive, holHolidayCalendarUid, holStartTime, holEndTime, holName) VALUES (NEW.holUid, NEW.holMasterCsn, NEW.holLocalCsn, NEW.holLastModBy, NEW.holLct, NEW.holActive, NEW.holHolidayCalendarUid, NEW.holStartTime, NEW.holEndTime, NEW.holName) ON CONFLICT (holUid) DO UPDATE SET holMasterCsn = EXCLUDED.holMasterCsn, holLocalCsn = EXCLUDED.holLocalCsn, holLastModBy = EXCLUDED.holLastModBy, holLct = EXCLUDED.holLct, holActive = EXCLUDED.holActive, holHolidayCalendarUid = EXCLUDED.holHolidayCalendarUid, holStartTime = EXCLUDED.holStartTime, holEndTime = EXCLUDED.holEndTime, holName = EXCLUDED.holName ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_462);
      var element_463 = ' CREATE TRIGGER holiday_remote_insert_trig INSTEAD OF INSERT ON Holiday_ReceiveView FOR EACH ROW EXECUTE PROCEDURE holiday_remote_insert_fn() ';
      _stmtList.add_11rb$(element_463);
      var element_464 = ' CREATE TABLE IF NOT EXISTS PersonReplicate ( personPk BIGINT NOT NULL, personVersionId BIGINT NOT NULL DEFAULT 0, personDestination BIGINT NOT NULL, personPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (personPk, personDestination)) ';
      _stmtList.add_11rb$(element_464);
      var element_465 = ' CREATE INDEX index_PersonReplicate_personPk_personDestination_personVersionId ON PersonReplicate (personPk, personDestination, personVersionId) ';
      _stmtList.add_11rb$(element_465);
      var element_466 = ' CREATE INDEX index_PersonReplicate_personDestination_personPending ON PersonReplicate (personDestination, personPending) ';
      _stmtList.add_11rb$(element_466);
      var element_467 = ' CREATE OR REPLACE FUNCTION ch_upd_9_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (9, NEW.personUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_467);
      var element_468 = ' CREATE TRIGGER ch_upd_9_trig AFTER UPDATE OR INSERT ON Person FOR EACH ROW EXECUTE PROCEDURE ch_upd_9_fn(); ';
      _stmtList.add_11rb$(element_468);
      var element_469 = ' CREATE OR REPLACE FUNCTION ch_del_9_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (9, OLD.personUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_469);
      var element_470 = ' CREATE TRIGGER ch_del_9_trig AFTER DELETE ON Person FOR EACH ROW EXECUTE PROCEDURE ch_del_9_fn(); ';
      _stmtList.add_11rb$(element_470);
      var element_471 = 'CREATE VIEW Person_ReceiveView AS  SELECT Person.*, PersonReplicate.* FROM Person LEFT JOIN PersonReplicate ON PersonReplicate.personPk = Person.personUid ';
      _stmtList.add_11rb$(element_471);
      var element_472 = "CREATE OR REPLACE FUNCTION person_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Person(personUid, username, firstNames, lastName, emailAddr, phoneNum, gender, active, admin, personNotes, fatherName, fatherNumber, motherName, motherNum, dateOfBirth, personAddress, personOrgId, personGroupUid, personMasterChangeSeqNum, personLocalChangeSeqNum, personLastChangedBy, personLct, personCountry, personType) VALUES (NEW.personUid, NEW.username, NEW.firstNames, NEW.lastName, NEW.emailAddr, NEW.phoneNum, NEW.gender, NEW.active, NEW.admin, NEW.personNotes, NEW.fatherName, NEW.fatherNumber, NEW.motherName, NEW.motherNum, NEW.dateOfBirth, NEW.personAddress, NEW.personOrgId, NEW.personGroupUid, NEW.personMasterChangeSeqNum, NEW.personLocalChangeSeqNum, NEW.personLastChangedBy, NEW.personLct, NEW.personCountry, NEW.personType) ON CONFLICT (personUid) DO UPDATE SET username = EXCLUDED.username, firstNames = EXCLUDED.firstNames, lastName = EXCLUDED.lastName, emailAddr = EXCLUDED.emailAddr, phoneNum = EXCLUDED.phoneNum, gender = EXCLUDED.gender, active = EXCLUDED.active, admin = EXCLUDED.admin, personNotes = EXCLUDED.personNotes, fatherName = EXCLUDED.fatherName, fatherNumber = EXCLUDED.fatherNumber, motherName = EXCLUDED.motherName, motherNum = EXCLUDED.motherNum, dateOfBirth = EXCLUDED.dateOfBirth, personAddress = EXCLUDED.personAddress, personOrgId = EXCLUDED.personOrgId, personGroupUid = EXCLUDED.personGroupUid, personMasterChangeSeqNum = EXCLUDED.personMasterChangeSeqNum, personLocalChangeSeqNum = EXCLUDED.personLocalChangeSeqNum, personLastChangedBy = EXCLUDED.personLastChangedBy, personLct = EXCLUDED.personLct, personCountry = EXCLUDED.personCountry, personType = EXCLUDED.personType ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_472);
      var element_473 = ' CREATE TRIGGER person_remote_insert_trig INSTEAD OF INSERT ON Person_ReceiveView FOR EACH ROW EXECUTE PROCEDURE person_remote_insert_fn() ';
      _stmtList.add_11rb$(element_473);
      var element_474 = ' CREATE TABLE IF NOT EXISTS ClazzReplicate ( clazzPk BIGINT NOT NULL, clazzVersionId BIGINT NOT NULL DEFAULT 0, clazzDestination BIGINT NOT NULL, clazzPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (clazzPk, clazzDestination)) ';
      _stmtList.add_11rb$(element_474);
      var element_475 = ' CREATE INDEX index_ClazzReplicate_clazzPk_clazzDestination_clazzVersionId ON ClazzReplicate (clazzPk, clazzDestination, clazzVersionId) ';
      _stmtList.add_11rb$(element_475);
      var element_476 = ' CREATE INDEX index_ClazzReplicate_clazzDestination_clazzPending ON ClazzReplicate (clazzDestination, clazzPending) ';
      _stmtList.add_11rb$(element_476);
      var element_477 = ' CREATE OR REPLACE FUNCTION ch_upd_6_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (6, NEW.clazzUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_477);
      var element_478 = ' CREATE TRIGGER ch_upd_6_trig AFTER UPDATE OR INSERT ON Clazz FOR EACH ROW EXECUTE PROCEDURE ch_upd_6_fn(); ';
      _stmtList.add_11rb$(element_478);
      var element_479 = ' CREATE OR REPLACE FUNCTION ch_del_6_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (6, OLD.clazzUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_479);
      var element_480 = ' CREATE TRIGGER ch_del_6_trig AFTER DELETE ON Clazz FOR EACH ROW EXECUTE PROCEDURE ch_del_6_fn(); ';
      _stmtList.add_11rb$(element_480);
      var element_481 = 'CREATE VIEW Clazz_ReceiveView AS  SELECT Clazz.*, ClazzReplicate.* FROM Clazz LEFT JOIN ClazzReplicate ON ClazzReplicate.clazzPk = Clazz.clazzUid ';
      _stmtList.add_11rb$(element_481);
      var element_482 = "CREATE OR REPLACE FUNCTION clazz_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Clazz(clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode) VALUES (NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode) ON CONFLICT (clazzUid) DO UPDATE SET clazzName = EXCLUDED.clazzName, clazzDesc = EXCLUDED.clazzDesc, attendanceAverage = EXCLUDED.attendanceAverage, clazzHolidayUMCalendarUid = EXCLUDED.clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid = EXCLUDED.clazzScheuleUMCalendarUid, isClazzActive = EXCLUDED.isClazzActive, clazzLocationUid = EXCLUDED.clazzLocationUid, clazzStartTime = EXCLUDED.clazzStartTime, clazzEndTime = EXCLUDED.clazzEndTime, clazzFeatures = EXCLUDED.clazzFeatures, clazzSchoolUid = EXCLUDED.clazzSchoolUid, clazzMasterChangeSeqNum = EXCLUDED.clazzMasterChangeSeqNum, clazzLocalChangeSeqNum = EXCLUDED.clazzLocalChangeSeqNum, clazzLastChangedBy = EXCLUDED.clazzLastChangedBy, clazzLct = EXCLUDED.clazzLct, clazzTimeZone = EXCLUDED.clazzTimeZone, clazzStudentsPersonGroupUid = EXCLUDED.clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid = EXCLUDED.clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid = EXCLUDED.clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid = EXCLUDED.clazzParentsPersonGroupUid, clazzCode = EXCLUDED.clazzCode ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_482);
      var element_483 = ' CREATE TRIGGER clazz_remote_insert_trig INSTEAD OF INSERT ON Clazz_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazz_remote_insert_fn() ';
      _stmtList.add_11rb$(element_483);
      var element_484 = ' CREATE TABLE IF NOT EXISTS ClazzEnrolmentReplicate ( cePk BIGINT NOT NULL, ceVersionId BIGINT NOT NULL DEFAULT 0, ceDestination BIGINT NOT NULL, cePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (cePk, ceDestination)) ';
      _stmtList.add_11rb$(element_484);
      var element_485 = ' CREATE INDEX index_ClazzEnrolmentReplicate_cePk_ceDestination_ceVersionId ON ClazzEnrolmentReplicate (cePk, ceDestination, ceVersionId) ';
      _stmtList.add_11rb$(element_485);
      var element_486 = ' CREATE INDEX index_ClazzEnrolmentReplicate_ceDestination_cePending ON ClazzEnrolmentReplicate (ceDestination, cePending) ';
      _stmtList.add_11rb$(element_486);
      var element_487 = ' CREATE OR REPLACE FUNCTION ch_upd_65_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (65, NEW.clazzEnrolmentUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_487);
      var element_488 = ' CREATE TRIGGER ch_upd_65_trig AFTER UPDATE OR INSERT ON ClazzEnrolment FOR EACH ROW EXECUTE PROCEDURE ch_upd_65_fn(); ';
      _stmtList.add_11rb$(element_488);
      var element_489 = ' CREATE OR REPLACE FUNCTION ch_del_65_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (65, OLD.clazzEnrolmentUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_489);
      var element_490 = ' CREATE TRIGGER ch_del_65_trig AFTER DELETE ON ClazzEnrolment FOR EACH ROW EXECUTE PROCEDURE ch_del_65_fn(); ';
      _stmtList.add_11rb$(element_490);
      var element_491 = 'CREATE VIEW ClazzEnrolment_ReceiveView AS  SELECT ClazzEnrolment.*, ClazzEnrolmentReplicate.* FROM ClazzEnrolment LEFT JOIN ClazzEnrolmentReplicate ON ClazzEnrolmentReplicate.cePk = ClazzEnrolment.clazzEnrolmentUid ';
      _stmtList.add_11rb$(element_491);
      var element_492 = "CREATE OR REPLACE FUNCTION clazzenrolment_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzEnrolment(clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy, clazzEnrolmentLct) VALUES (NEW.clazzEnrolmentUid, NEW.clazzEnrolmentPersonUid, NEW.clazzEnrolmentClazzUid, NEW.clazzEnrolmentDateJoined, NEW.clazzEnrolmentDateLeft, NEW.clazzEnrolmentRole, NEW.clazzEnrolmentAttendancePercentage, NEW.clazzEnrolmentActive, NEW.clazzEnrolmentLeavingReasonUid, NEW.clazzEnrolmentOutcome, NEW.clazzEnrolmentLocalChangeSeqNum, NEW.clazzEnrolmentMasterChangeSeqNum, NEW.clazzEnrolmentLastChangedBy, NEW.clazzEnrolmentLct) ON CONFLICT (clazzEnrolmentUid) DO UPDATE SET clazzEnrolmentPersonUid = EXCLUDED.clazzEnrolmentPersonUid, clazzEnrolmentClazzUid = EXCLUDED.clazzEnrolmentClazzUid, clazzEnrolmentDateJoined = EXCLUDED.clazzEnrolmentDateJoined, clazzEnrolmentDateLeft = EXCLUDED.clazzEnrolmentDateLeft, clazzEnrolmentRole = EXCLUDED.clazzEnrolmentRole, clazzEnrolmentAttendancePercentage = EXCLUDED.clazzEnrolmentAttendancePercentage, clazzEnrolmentActive = EXCLUDED.clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid = EXCLUDED.clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome = EXCLUDED.clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum = EXCLUDED.clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum = EXCLUDED.clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy = EXCLUDED.clazzEnrolmentLastChangedBy, clazzEnrolmentLct = EXCLUDED.clazzEnrolmentLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_492);
      var element_493 = ' CREATE TRIGGER clazzenrolment_remote_insert_trig INSTEAD OF INSERT ON ClazzEnrolment_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzenrolment_remote_insert_fn() ';
      _stmtList.add_11rb$(element_493);
      var element_494 = ' CREATE TABLE IF NOT EXISTS LeavingReasonReplicate ( lrPk BIGINT NOT NULL, lrVersionId BIGINT NOT NULL DEFAULT 0, lrDestination BIGINT NOT NULL, lrPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (lrPk, lrDestination)) ';
      _stmtList.add_11rb$(element_494);
      var element_495 = ' CREATE INDEX index_LeavingReasonReplicate_lrPk_lrDestination_lrVersionId ON LeavingReasonReplicate (lrPk, lrDestination, lrVersionId) ';
      _stmtList.add_11rb$(element_495);
      var element_496 = ' CREATE INDEX index_LeavingReasonReplicate_lrDestination_lrPending ON LeavingReasonReplicate (lrDestination, lrPending) ';
      _stmtList.add_11rb$(element_496);
      var element_497 = ' CREATE OR REPLACE FUNCTION ch_upd_410_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (410, NEW.leavingReasonUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_497);
      var element_498 = ' CREATE TRIGGER ch_upd_410_trig AFTER UPDATE OR INSERT ON LeavingReason FOR EACH ROW EXECUTE PROCEDURE ch_upd_410_fn(); ';
      _stmtList.add_11rb$(element_498);
      var element_499 = ' CREATE OR REPLACE FUNCTION ch_del_410_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (410, OLD.leavingReasonUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_499);
      var element_500 = ' CREATE TRIGGER ch_del_410_trig AFTER DELETE ON LeavingReason FOR EACH ROW EXECUTE PROCEDURE ch_del_410_fn(); ';
      _stmtList.add_11rb$(element_500);
      var element_501 = 'CREATE VIEW LeavingReason_ReceiveView AS  SELECT LeavingReason.*, LeavingReasonReplicate.* FROM LeavingReason LEFT JOIN LeavingReasonReplicate ON LeavingReasonReplicate.lrPk = LeavingReason.leavingReasonUid ';
      _stmtList.add_11rb$(element_501);
      var element_502 = "CREATE OR REPLACE FUNCTION leavingreason_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO LeavingReason(leavingReasonUid, leavingReasonTitle, leavingReasonMCSN, leavingReasonCSN, leavingReasonLCB, leavingReasonLct) VALUES (NEW.leavingReasonUid, NEW.leavingReasonTitle, NEW.leavingReasonMCSN, NEW.leavingReasonCSN, NEW.leavingReasonLCB, NEW.leavingReasonLct) ON CONFLICT (leavingReasonUid) DO UPDATE SET leavingReasonTitle = EXCLUDED.leavingReasonTitle, leavingReasonMCSN = EXCLUDED.leavingReasonMCSN, leavingReasonCSN = EXCLUDED.leavingReasonCSN, leavingReasonLCB = EXCLUDED.leavingReasonLCB, leavingReasonLct = EXCLUDED.leavingReasonLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_502);
      var element_503 = ' CREATE TRIGGER leavingreason_remote_insert_trig INSTEAD OF INSERT ON LeavingReason_ReceiveView FOR EACH ROW EXECUTE PROCEDURE leavingreason_remote_insert_fn() ';
      _stmtList.add_11rb$(element_503);
      var element_504 = ' CREATE TABLE IF NOT EXISTS ContentEntryReplicate ( cePk BIGINT NOT NULL, ceVersionId BIGINT NOT NULL DEFAULT 0, ceDestination BIGINT NOT NULL, cePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (cePk, ceDestination)) ';
      _stmtList.add_11rb$(element_504);
      var element_505 = ' CREATE INDEX index_ContentEntryReplicate_cePk_ceDestination_ceVersionId ON ContentEntryReplicate (cePk, ceDestination, ceVersionId) ';
      _stmtList.add_11rb$(element_505);
      var element_506 = ' CREATE INDEX index_ContentEntryReplicate_ceDestination_cePending ON ContentEntryReplicate (ceDestination, cePending) ';
      _stmtList.add_11rb$(element_506);
      var element_507 = ' CREATE OR REPLACE FUNCTION ch_upd_42_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (42, NEW.contentEntryUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_507);
      var element_508 = ' CREATE TRIGGER ch_upd_42_trig AFTER UPDATE OR INSERT ON ContentEntry FOR EACH ROW EXECUTE PROCEDURE ch_upd_42_fn(); ';
      _stmtList.add_11rb$(element_508);
      var element_509 = ' CREATE OR REPLACE FUNCTION ch_del_42_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (42, OLD.contentEntryUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_509);
      var element_510 = ' CREATE TRIGGER ch_del_42_trig AFTER DELETE ON ContentEntry FOR EACH ROW EXECUTE PROCEDURE ch_del_42_fn(); ';
      _stmtList.add_11rb$(element_510);
      var element_511 = 'CREATE VIEW ContentEntry_ReceiveView AS  SELECT ContentEntry.*, ContentEntryReplicate.* FROM ContentEntry LEFT JOIN ContentEntryReplicate ON ContentEntryReplicate.cePk = ContentEntry.contentEntryUid ';
      _stmtList.add_11rb$(element_511);
      var element_512 = "CREATE OR REPLACE FUNCTION contententry_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentEntry(contentEntryUid, title, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, contentFlags, leaf, publik, ceInactive, completionCriteria, minScore, contentTypeFlag, contentOwner, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct) VALUES (NEW.contentEntryUid, NEW.title, NEW.description, NEW.entryId, NEW.author, NEW.publisher, NEW.licenseType, NEW.licenseName, NEW.licenseUrl, NEW.sourceUrl, NEW.thumbnailUrl, NEW.lastModified, NEW.primaryLanguageUid, NEW.languageVariantUid, NEW.contentFlags, NEW.leaf, NEW.publik, NEW.ceInactive, NEW.completionCriteria, NEW.minScore, NEW.contentTypeFlag, NEW.contentOwner, NEW.contentEntryLocalChangeSeqNum, NEW.contentEntryMasterChangeSeqNum, NEW.contentEntryLastChangedBy, NEW.contentEntryLct) ON CONFLICT (contentEntryUid) DO UPDATE SET title = EXCLUDED.title, description = EXCLUDED.description, entryId = EXCLUDED.entryId, author = EXCLUDED.author, publisher = EXCLUDED.publisher, licenseType = EXCLUDED.licenseType, licenseName = EXCLUDED.licenseName, licenseUrl = EXCLUDED.licenseUrl, sourceUrl = EXCLUDED.sourceUrl, thumbnailUrl = EXCLUDED.thumbnailUrl, lastModified = EXCLUDED.lastModified, primaryLanguageUid = EXCLUDED.primaryLanguageUid, languageVariantUid = EXCLUDED.languageVariantUid, contentFlags = EXCLUDED.contentFlags, leaf = EXCLUDED.leaf, publik = EXCLUDED.publik, ceInactive = EXCLUDED.ceInactive, completionCriteria = EXCLUDED.completionCriteria, minScore = EXCLUDED.minScore, contentTypeFlag = EXCLUDED.contentTypeFlag, contentOwner = EXCLUDED.contentOwner, contentEntryLocalChangeSeqNum = EXCLUDED.contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum = EXCLUDED.contentEntryMasterChangeSeqNum, contentEntryLastChangedBy = EXCLUDED.contentEntryLastChangedBy, contentEntryLct = EXCLUDED.contentEntryLct; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_512);
      var element_513 = ' CREATE TRIGGER contententry_remote_insert_trig INSTEAD OF INSERT ON ContentEntry_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contententry_remote_insert_fn() ';
      _stmtList.add_11rb$(element_513);
      var element_514 = ' CREATE TABLE IF NOT EXISTS ContentEntryContentCategoryJoinReplicate ( ceccjPk BIGINT NOT NULL, ceccjVersionId BIGINT NOT NULL DEFAULT 0, ceccjDestination BIGINT NOT NULL, ceccjPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (ceccjPk, ceccjDestination)) ';
      _stmtList.add_11rb$(element_514);
      var element_515 = ' CREATE INDEX index_ContentEntryContentCategoryJoinReplicate_ceccjPk_ceccjDestination_ceccjVersionId ON ContentEntryContentCategoryJoinReplicate (ceccjPk, ceccjDestination, ceccjVersionId) ';
      _stmtList.add_11rb$(element_515);
      var element_516 = ' CREATE INDEX index_ContentEntryContentCategoryJoinReplicate_ceccjDestination_ceccjPending ON ContentEntryContentCategoryJoinReplicate (ceccjDestination, ceccjPending) ';
      _stmtList.add_11rb$(element_516);
      var element_517 = ' CREATE OR REPLACE FUNCTION ch_upd_3_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (3, NEW.ceccjUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_517);
      var element_518 = ' CREATE TRIGGER ch_upd_3_trig AFTER UPDATE OR INSERT ON ContentEntryContentCategoryJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_3_fn(); ';
      _stmtList.add_11rb$(element_518);
      var element_519 = ' CREATE OR REPLACE FUNCTION ch_del_3_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (3, OLD.ceccjUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_519);
      var element_520 = ' CREATE TRIGGER ch_del_3_trig AFTER DELETE ON ContentEntryContentCategoryJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_3_fn(); ';
      _stmtList.add_11rb$(element_520);
      var element_521 = 'CREATE VIEW ContentEntryContentCategoryJoin_ReceiveView AS  SELECT ContentEntryContentCategoryJoin.*, ContentEntryContentCategoryJoinReplicate.* FROM ContentEntryContentCategoryJoin LEFT JOIN ContentEntryContentCategoryJoinReplicate ON ContentEntryContentCategoryJoinReplicate.ceccjPk = ContentEntryContentCategoryJoin.ceccjUid ';
      _stmtList.add_11rb$(element_521);
      var element_522 = "CREATE OR REPLACE FUNCTION contententrycontentcategoryjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentEntryContentCategoryJoin(ceccjUid, ceccjContentEntryUid, ceccjContentCategoryUid, ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum, ceccjLastChangedBy, ceccjLct) VALUES (NEW.ceccjUid, NEW.ceccjContentEntryUid, NEW.ceccjContentCategoryUid, NEW.ceccjLocalChangeSeqNum, NEW.ceccjMasterChangeSeqNum, NEW.ceccjLastChangedBy, NEW.ceccjLct) ON CONFLICT (ceccjUid) DO UPDATE SET ceccjContentEntryUid = EXCLUDED.ceccjContentEntryUid, ceccjContentCategoryUid = EXCLUDED.ceccjContentCategoryUid, ceccjLocalChangeSeqNum = EXCLUDED.ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum = EXCLUDED.ceccjMasterChangeSeqNum, ceccjLastChangedBy = EXCLUDED.ceccjLastChangedBy, ceccjLct = EXCLUDED.ceccjLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_522);
      var element_523 = ' CREATE TRIGGER contententrycontentcategoryjoin_remote_insert_trig INSTEAD OF INSERT ON ContentEntryContentCategoryJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contententrycontentcategoryjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_523);
      var element_524 = ' CREATE TABLE IF NOT EXISTS ContentEntryParentChildJoinReplicate ( cepcjPk BIGINT NOT NULL, cepcjVersionId BIGINT NOT NULL DEFAULT 0, cepcjDestination BIGINT NOT NULL, cepcjPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (cepcjPk, cepcjDestination)) ';
      _stmtList.add_11rb$(element_524);
      var element_525 = ' CREATE INDEX index_ContentEntryParentChildJoinReplicate_cepcjPk_cepcjDestination_cepcjVersionId ON ContentEntryParentChildJoinReplicate (cepcjPk, cepcjDestination, cepcjVersionId) ';
      _stmtList.add_11rb$(element_525);
      var element_526 = ' CREATE INDEX index_ContentEntryParentChildJoinReplicate_cepcjDestination_cepcjPending ON ContentEntryParentChildJoinReplicate (cepcjDestination, cepcjPending) ';
      _stmtList.add_11rb$(element_526);
      var element_527 = ' CREATE OR REPLACE FUNCTION ch_upd_7_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (7, NEW.cepcjUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_527);
      var element_528 = ' CREATE TRIGGER ch_upd_7_trig AFTER UPDATE OR INSERT ON ContentEntryParentChildJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_7_fn(); ';
      _stmtList.add_11rb$(element_528);
      var element_529 = ' CREATE OR REPLACE FUNCTION ch_del_7_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (7, OLD.cepcjUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_529);
      var element_530 = ' CREATE TRIGGER ch_del_7_trig AFTER DELETE ON ContentEntryParentChildJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_7_fn(); ';
      _stmtList.add_11rb$(element_530);
      var element_531 = 'CREATE VIEW ContentEntryParentChildJoin_ReceiveView AS  SELECT ContentEntryParentChildJoin.*, ContentEntryParentChildJoinReplicate.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntryParentChildJoinReplicate ON ContentEntryParentChildJoinReplicate.cepcjPk = ContentEntryParentChildJoin.cepcjUid ';
      _stmtList.add_11rb$(element_531);
      var element_532 = "CREATE OR REPLACE FUNCTION contententryparentchildjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentEntryParentChildJoin(cepcjParentContentEntryUid, cepcjChildContentEntryUid, childIndex, cepcjUid, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct) VALUES (NEW.cepcjParentContentEntryUid, NEW.cepcjChildContentEntryUid, NEW.childIndex, NEW.cepcjUid, NEW.cepcjLocalChangeSeqNum, NEW.cepcjMasterChangeSeqNum, NEW.cepcjLastChangedBy, NEW.cepcjLct) ON CONFLICT (cepcjUid) DO UPDATE SET cepcjParentContentEntryUid = EXCLUDED.cepcjParentContentEntryUid, cepcjChildContentEntryUid = EXCLUDED.cepcjChildContentEntryUid, childIndex = EXCLUDED.childIndex, cepcjLocalChangeSeqNum = EXCLUDED.cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum = EXCLUDED.cepcjMasterChangeSeqNum, cepcjLastChangedBy = EXCLUDED.cepcjLastChangedBy, cepcjLct = EXCLUDED.cepcjLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_532);
      var element_533 = ' CREATE TRIGGER contententryparentchildjoin_remote_insert_trig INSTEAD OF INSERT ON ContentEntryParentChildJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contententryparentchildjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_533);
      var element_534 = ' CREATE TABLE IF NOT EXISTS ContentEntryRelatedEntryJoinReplicate ( cerejPk BIGINT NOT NULL, cerejVersionId BIGINT NOT NULL DEFAULT 0, cerejDestination BIGINT NOT NULL, cerejPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (cerejPk, cerejDestination)) ';
      _stmtList.add_11rb$(element_534);
      var element_535 = ' CREATE INDEX index_ContentEntryRelatedEntryJoinReplicate_cerejPk_cerejDestination_cerejVersionId ON ContentEntryRelatedEntryJoinReplicate (cerejPk, cerejDestination, cerejVersionId) ';
      _stmtList.add_11rb$(element_535);
      var element_536 = ' CREATE INDEX index_ContentEntryRelatedEntryJoinReplicate_cerejDestination_cerejPending ON ContentEntryRelatedEntryJoinReplicate (cerejDestination, cerejPending) ';
      _stmtList.add_11rb$(element_536);
      var element_537 = ' CREATE OR REPLACE FUNCTION ch_upd_8_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (8, NEW.cerejUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_537);
      var element_538 = ' CREATE TRIGGER ch_upd_8_trig AFTER UPDATE OR INSERT ON ContentEntryRelatedEntryJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_8_fn(); ';
      _stmtList.add_11rb$(element_538);
      var element_539 = ' CREATE OR REPLACE FUNCTION ch_del_8_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (8, OLD.cerejUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_539);
      var element_540 = ' CREATE TRIGGER ch_del_8_trig AFTER DELETE ON ContentEntryRelatedEntryJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_8_fn(); ';
      _stmtList.add_11rb$(element_540);
      var element_541 = 'CREATE VIEW ContentEntryRelatedEntryJoin_ReceiveView AS  SELECT ContentEntryRelatedEntryJoin.*, ContentEntryRelatedEntryJoinReplicate.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntryRelatedEntryJoinReplicate ON ContentEntryRelatedEntryJoinReplicate.cerejPk = ContentEntryRelatedEntryJoin.cerejUid ';
      _stmtList.add_11rb$(element_541);
      var element_542 = "CREATE OR REPLACE FUNCTION contententryrelatedentryjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentEntryRelatedEntryJoin(cerejUid, cerejContentEntryUid, cerejRelatedEntryUid, cerejLastChangedBy, relType, comment, cerejRelLanguageUid, cerejLocalChangeSeqNum, cerejMasterChangeSeqNum, cerejLct) VALUES (NEW.cerejUid, NEW.cerejContentEntryUid, NEW.cerejRelatedEntryUid, NEW.cerejLastChangedBy, NEW.relType, NEW.comment, NEW.cerejRelLanguageUid, NEW.cerejLocalChangeSeqNum, NEW.cerejMasterChangeSeqNum, NEW.cerejLct) ON CONFLICT (cerejUid) DO UPDATE SET cerejContentEntryUid = EXCLUDED.cerejContentEntryUid, cerejRelatedEntryUid = EXCLUDED.cerejRelatedEntryUid, cerejLastChangedBy = EXCLUDED.cerejLastChangedBy, relType = EXCLUDED.relType, comment = EXCLUDED.comment, cerejRelLanguageUid = EXCLUDED.cerejRelLanguageUid, cerejLocalChangeSeqNum = EXCLUDED.cerejLocalChangeSeqNum, cerejMasterChangeSeqNum = EXCLUDED.cerejMasterChangeSeqNum, cerejLct = EXCLUDED.cerejLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_542);
      var element_543 = ' CREATE TRIGGER contententryrelatedentryjoin_remote_insert_trig INSTEAD OF INSERT ON ContentEntryRelatedEntryJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contententryrelatedentryjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_543);
      var element_544 = ' CREATE TABLE IF NOT EXISTS ContentCategorySchemaReplicate ( ccsPk BIGINT NOT NULL, ccsVersionId BIGINT NOT NULL DEFAULT 0, ccsDestination BIGINT NOT NULL, ccsPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (ccsPk, ccsDestination)) ';
      _stmtList.add_11rb$(element_544);
      var element_545 = ' CREATE INDEX index_ContentCategorySchemaReplicate_ccsPk_ccsDestination_ccsVersionId ON ContentCategorySchemaReplicate (ccsPk, ccsDestination, ccsVersionId) ';
      _stmtList.add_11rb$(element_545);
      var element_546 = ' CREATE INDEX index_ContentCategorySchemaReplicate_ccsDestination_ccsPending ON ContentCategorySchemaReplicate (ccsDestination, ccsPending) ';
      _stmtList.add_11rb$(element_546);
      var element_547 = ' CREATE OR REPLACE FUNCTION ch_upd_2_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (2, NEW.contentCategorySchemaUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_547);
      var element_548 = ' CREATE TRIGGER ch_upd_2_trig AFTER UPDATE OR INSERT ON ContentCategorySchema FOR EACH ROW EXECUTE PROCEDURE ch_upd_2_fn(); ';
      _stmtList.add_11rb$(element_548);
      var element_549 = ' CREATE OR REPLACE FUNCTION ch_del_2_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (2, OLD.contentCategorySchemaUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_549);
      var element_550 = ' CREATE TRIGGER ch_del_2_trig AFTER DELETE ON ContentCategorySchema FOR EACH ROW EXECUTE PROCEDURE ch_del_2_fn(); ';
      _stmtList.add_11rb$(element_550);
      var element_551 = 'CREATE VIEW ContentCategorySchema_ReceiveView AS  SELECT ContentCategorySchema.*, ContentCategorySchemaReplicate.* FROM ContentCategorySchema LEFT JOIN ContentCategorySchemaReplicate ON ContentCategorySchemaReplicate.ccsPk = ContentCategorySchema.contentCategorySchemaUid ';
      _stmtList.add_11rb$(element_551);
      var element_552 = "CREATE OR REPLACE FUNCTION contentcategoryschema_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentCategorySchema(contentCategorySchemaUid, schemaName, schemaUrl, contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy, contentCategorySchemaLct) VALUES (NEW.contentCategorySchemaUid, NEW.schemaName, NEW.schemaUrl, NEW.contentCategorySchemaLocalChangeSeqNum, NEW.contentCategorySchemaMasterChangeSeqNum, NEW.contentCategorySchemaLastChangedBy, NEW.contentCategorySchemaLct) ON CONFLICT (contentCategorySchemaUid) DO UPDATE SET schemaName = EXCLUDED.schemaName, schemaUrl = EXCLUDED.schemaUrl, contentCategorySchemaLocalChangeSeqNum = EXCLUDED.contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum = EXCLUDED.contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy = EXCLUDED.contentCategorySchemaLastChangedBy, contentCategorySchemaLct = EXCLUDED.contentCategorySchemaLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_552);
      var element_553 = ' CREATE TRIGGER contentcategoryschema_remote_insert_trig INSTEAD OF INSERT ON ContentCategorySchema_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contentcategoryschema_remote_insert_fn() ';
      _stmtList.add_11rb$(element_553);
      var element_554 = ' CREATE TABLE IF NOT EXISTS ContentCategoryReplicate ( ccPk BIGINT NOT NULL, ccVersionId BIGINT NOT NULL DEFAULT 0, ccDestination BIGINT NOT NULL, ccPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (ccPk, ccDestination)) ';
      _stmtList.add_11rb$(element_554);
      var element_555 = ' CREATE INDEX index_ContentCategoryReplicate_ccPk_ccDestination_ccVersionId ON ContentCategoryReplicate (ccPk, ccDestination, ccVersionId) ';
      _stmtList.add_11rb$(element_555);
      var element_556 = ' CREATE INDEX index_ContentCategoryReplicate_ccDestination_ccPending ON ContentCategoryReplicate (ccDestination, ccPending) ';
      _stmtList.add_11rb$(element_556);
      var element_557 = ' CREATE OR REPLACE FUNCTION ch_upd_1_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (1, NEW.contentCategoryUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_557);
      var element_558 = ' CREATE TRIGGER ch_upd_1_trig AFTER UPDATE OR INSERT ON ContentCategory FOR EACH ROW EXECUTE PROCEDURE ch_upd_1_fn(); ';
      _stmtList.add_11rb$(element_558);
      var element_559 = ' CREATE OR REPLACE FUNCTION ch_del_1_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (1, OLD.contentCategoryUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_559);
      var element_560 = ' CREATE TRIGGER ch_del_1_trig AFTER DELETE ON ContentCategory FOR EACH ROW EXECUTE PROCEDURE ch_del_1_fn(); ';
      _stmtList.add_11rb$(element_560);
      var element_561 = 'CREATE VIEW ContentCategory_ReceiveView AS  SELECT ContentCategory.*, ContentCategoryReplicate.* FROM ContentCategory LEFT JOIN ContentCategoryReplicate ON ContentCategoryReplicate.ccPk = ContentCategory.contentCategoryUid ';
      _stmtList.add_11rb$(element_561);
      var element_562 = "CREATE OR REPLACE FUNCTION contentcategory_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContentCategory(contentCategoryUid, ctnCatContentCategorySchemaUid, name, contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy, contentCategoryLct) VALUES (NEW.contentCategoryUid, NEW.ctnCatContentCategorySchemaUid, NEW.name, NEW.contentCategoryLocalChangeSeqNum, NEW.contentCategoryMasterChangeSeqNum, NEW.contentCategoryLastChangedBy, NEW.contentCategoryLct) ON CONFLICT (contentCategoryUid) DO UPDATE SET ctnCatContentCategorySchemaUid = EXCLUDED.ctnCatContentCategorySchemaUid, name = EXCLUDED.name, contentCategoryLocalChangeSeqNum = EXCLUDED.contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum = EXCLUDED.contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy = EXCLUDED.contentCategoryLastChangedBy, contentCategoryLct = EXCLUDED.contentCategoryLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_562);
      var element_563 = ' CREATE TRIGGER contentcategory_remote_insert_trig INSTEAD OF INSERT ON ContentCategory_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contentcategory_remote_insert_fn() ';
      _stmtList.add_11rb$(element_563);
      var element_564 = ' CREATE TABLE IF NOT EXISTS LanguageReplicate ( languagePk BIGINT NOT NULL, languageVersionId BIGINT NOT NULL DEFAULT 0, languageDestination BIGINT NOT NULL, languagePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (languagePk, languageDestination)) ';
      _stmtList.add_11rb$(element_564);
      var element_565 = ' CREATE INDEX index_LanguageReplicate_languagePk_languageDestination_languageVersionId ON LanguageReplicate (languagePk, languageDestination, languageVersionId) ';
      _stmtList.add_11rb$(element_565);
      var element_566 = ' CREATE INDEX index_LanguageReplicate_languageDestination_languagePending ON LanguageReplicate (languageDestination, languagePending) ';
      _stmtList.add_11rb$(element_566);
      var element_567 = ' CREATE OR REPLACE FUNCTION ch_upd_13_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (13, NEW.langUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_567);
      var element_568 = ' CREATE TRIGGER ch_upd_13_trig AFTER UPDATE OR INSERT ON Language FOR EACH ROW EXECUTE PROCEDURE ch_upd_13_fn(); ';
      _stmtList.add_11rb$(element_568);
      var element_569 = ' CREATE OR REPLACE FUNCTION ch_del_13_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (13, OLD.langUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_569);
      var element_570 = ' CREATE TRIGGER ch_del_13_trig AFTER DELETE ON Language FOR EACH ROW EXECUTE PROCEDURE ch_del_13_fn(); ';
      _stmtList.add_11rb$(element_570);
      var element_571 = 'CREATE VIEW Language_ReceiveView AS  SELECT Language.*, LanguageReplicate.* FROM Language LEFT JOIN LanguageReplicate ON LanguageReplicate.languagePk = Language.langUid ';
      _stmtList.add_11rb$(element_571);
      var element_572 = "CREATE OR REPLACE FUNCTION language_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Language(langUid, name, iso_639_1_standard, iso_639_2_standard, iso_639_3_standard, Language_Type, languageActive, langLocalChangeSeqNum, langMasterChangeSeqNum, langLastChangedBy, langLct) VALUES (NEW.langUid, NEW.name, NEW.iso_639_1_standard, NEW.iso_639_2_standard, NEW.iso_639_3_standard, NEW.Language_Type, NEW.languageActive, NEW.langLocalChangeSeqNum, NEW.langMasterChangeSeqNum, NEW.langLastChangedBy, NEW.langLct) ON CONFLICT (langUid) DO UPDATE SET name = EXCLUDED.name, iso_639_1_standard = EXCLUDED.iso_639_1_standard, iso_639_2_standard = EXCLUDED.iso_639_2_standard, iso_639_3_standard = EXCLUDED.iso_639_3_standard, Language_Type = EXCLUDED.Language_Type, languageActive = EXCLUDED.languageActive, langLocalChangeSeqNum = EXCLUDED.langLocalChangeSeqNum, langMasterChangeSeqNum = EXCLUDED.langMasterChangeSeqNum, langLastChangedBy = EXCLUDED.langLastChangedBy, langLct = EXCLUDED.langLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_572);
      var element_573 = ' CREATE TRIGGER language_remote_insert_trig INSTEAD OF INSERT ON Language_ReceiveView FOR EACH ROW EXECUTE PROCEDURE language_remote_insert_fn() ';
      _stmtList.add_11rb$(element_573);
      var element_574 = ' CREATE TABLE IF NOT EXISTS LanguageVariantReplicate ( lvPk BIGINT NOT NULL, lvVersionId BIGINT NOT NULL DEFAULT 0, lvDestination BIGINT NOT NULL, lvPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (lvPk, lvDestination)) ';
      _stmtList.add_11rb$(element_574);
      var element_575 = ' CREATE INDEX index_LanguageVariantReplicate_lvPk_lvDestination_lvVersionId ON LanguageVariantReplicate (lvPk, lvDestination, lvVersionId) ';
      _stmtList.add_11rb$(element_575);
      var element_576 = ' CREATE INDEX index_LanguageVariantReplicate_lvDestination_lvPending ON LanguageVariantReplicate (lvDestination, lvPending) ';
      _stmtList.add_11rb$(element_576);
      var element_577 = ' CREATE OR REPLACE FUNCTION ch_upd_10_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (10, NEW.langVariantUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_577);
      var element_578 = ' CREATE TRIGGER ch_upd_10_trig AFTER UPDATE OR INSERT ON LanguageVariant FOR EACH ROW EXECUTE PROCEDURE ch_upd_10_fn(); ';
      _stmtList.add_11rb$(element_578);
      var element_579 = ' CREATE OR REPLACE FUNCTION ch_del_10_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (10, OLD.langVariantUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_579);
      var element_580 = ' CREATE TRIGGER ch_del_10_trig AFTER DELETE ON LanguageVariant FOR EACH ROW EXECUTE PROCEDURE ch_del_10_fn(); ';
      _stmtList.add_11rb$(element_580);
      var element_581 = 'CREATE VIEW LanguageVariant_ReceiveView AS  SELECT LanguageVariant.*, LanguageVariantReplicate.* FROM LanguageVariant LEFT JOIN LanguageVariantReplicate ON LanguageVariantReplicate.lvPk = LanguageVariant.langVariantUid ';
      _stmtList.add_11rb$(element_581);
      var element_582 = "CREATE OR REPLACE FUNCTION languagevariant_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO LanguageVariant(langVariantUid, langUid, countryCode, name, langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum, langVariantLastChangedBy, langVariantLct) VALUES (NEW.langVariantUid, NEW.langUid, NEW.countryCode, NEW.name, NEW.langVariantLocalChangeSeqNum, NEW.langVariantMasterChangeSeqNum, NEW.langVariantLastChangedBy, NEW.langVariantLct) ON CONFLICT (langVariantUid) DO UPDATE SET langUid = EXCLUDED.langUid, countryCode = EXCLUDED.countryCode, name = EXCLUDED.name, langVariantLocalChangeSeqNum = EXCLUDED.langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum = EXCLUDED.langVariantMasterChangeSeqNum, langVariantLastChangedBy = EXCLUDED.langVariantLastChangedBy, langVariantLct = EXCLUDED.langVariantLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_582);
      var element_583 = ' CREATE TRIGGER languagevariant_remote_insert_trig INSTEAD OF INSERT ON LanguageVariant_ReceiveView FOR EACH ROW EXECUTE PROCEDURE languagevariant_remote_insert_fn() ';
      _stmtList.add_11rb$(element_583);
      var element_584 = ' CREATE TABLE IF NOT EXISTS PersonGroupReplicate ( pgPk BIGINT NOT NULL, pgVersionId BIGINT NOT NULL DEFAULT 0, pgDestination BIGINT NOT NULL, pgPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (pgPk, pgDestination)) ';
      _stmtList.add_11rb$(element_584);
      var element_585 = ' CREATE INDEX index_PersonGroupReplicate_pgPk_pgDestination_pgVersionId ON PersonGroupReplicate (pgPk, pgDestination, pgVersionId) ';
      _stmtList.add_11rb$(element_585);
      var element_586 = ' CREATE INDEX index_PersonGroupReplicate_pgDestination_pgPending ON PersonGroupReplicate (pgDestination, pgPending) ';
      _stmtList.add_11rb$(element_586);
      var element_587 = ' CREATE OR REPLACE FUNCTION ch_upd_43_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (43, NEW.groupUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_587);
      var element_588 = ' CREATE TRIGGER ch_upd_43_trig AFTER UPDATE OR INSERT ON PersonGroup FOR EACH ROW EXECUTE PROCEDURE ch_upd_43_fn(); ';
      _stmtList.add_11rb$(element_588);
      var element_589 = ' CREATE OR REPLACE FUNCTION ch_del_43_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (43, OLD.groupUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_589);
      var element_590 = ' CREATE TRIGGER ch_del_43_trig AFTER DELETE ON PersonGroup FOR EACH ROW EXECUTE PROCEDURE ch_del_43_fn(); ';
      _stmtList.add_11rb$(element_590);
      var element_591 = 'CREATE VIEW PersonGroup_ReceiveView AS  SELECT PersonGroup.*, PersonGroupReplicate.* FROM PersonGroup LEFT JOIN PersonGroupReplicate ON PersonGroupReplicate.pgPk = PersonGroup.groupUid ';
      _stmtList.add_11rb$(element_591);
      var element_592 = "CREATE OR REPLACE FUNCTION persongroup_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO PersonGroup(groupUid, groupMasterCsn, groupLocalCsn, groupLastChangedBy, groupLct, groupName, groupActive, personGroupFlag) VALUES (NEW.groupUid, NEW.groupMasterCsn, NEW.groupLocalCsn, NEW.groupLastChangedBy, NEW.groupLct, NEW.groupName, NEW.groupActive, NEW.personGroupFlag) ON CONFLICT (groupUid) DO UPDATE SET groupMasterCsn = EXCLUDED.groupMasterCsn, groupLocalCsn = EXCLUDED.groupLocalCsn, groupLastChangedBy = EXCLUDED.groupLastChangedBy, groupLct = EXCLUDED.groupLct, groupName = EXCLUDED.groupName, groupActive = EXCLUDED.groupActive, personGroupFlag = EXCLUDED.personGroupFlag ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_592);
      var element_593 = ' CREATE TRIGGER persongroup_remote_insert_trig INSTEAD OF INSERT ON PersonGroup_ReceiveView FOR EACH ROW EXECUTE PROCEDURE persongroup_remote_insert_fn() ';
      _stmtList.add_11rb$(element_593);
      var element_594 = ' CREATE TABLE IF NOT EXISTS PersonGroupMemberReplicate ( pgmPk BIGINT NOT NULL, pgmVersionId BIGINT NOT NULL DEFAULT 0, pgmDestination BIGINT NOT NULL, pgmPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (pgmPk, pgmDestination)) ';
      _stmtList.add_11rb$(element_594);
      var element_595 = ' CREATE INDEX index_PersonGroupMemberReplicate_pgmPk_pgmDestination_pgmVersionId ON PersonGroupMemberReplicate (pgmPk, pgmDestination, pgmVersionId) ';
      _stmtList.add_11rb$(element_595);
      var element_596 = ' CREATE INDEX index_PersonGroupMemberReplicate_pgmDestination_pgmPending ON PersonGroupMemberReplicate (pgmDestination, pgmPending) ';
      _stmtList.add_11rb$(element_596);
      var element_597 = ' CREATE OR REPLACE FUNCTION ch_upd_44_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (44, NEW.groupMemberUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_597);
      var element_598 = ' CREATE TRIGGER ch_upd_44_trig AFTER UPDATE OR INSERT ON PersonGroupMember FOR EACH ROW EXECUTE PROCEDURE ch_upd_44_fn(); ';
      _stmtList.add_11rb$(element_598);
      var element_599 = ' CREATE OR REPLACE FUNCTION ch_del_44_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (44, OLD.groupMemberUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_599);
      var element_600 = ' CREATE TRIGGER ch_del_44_trig AFTER DELETE ON PersonGroupMember FOR EACH ROW EXECUTE PROCEDURE ch_del_44_fn(); ';
      _stmtList.add_11rb$(element_600);
      var element_601 = 'CREATE VIEW PersonGroupMember_ReceiveView AS  SELECT PersonGroupMember.*, PersonGroupMemberReplicate.* FROM PersonGroupMember LEFT JOIN PersonGroupMemberReplicate ON PersonGroupMemberReplicate.pgmPk = PersonGroupMember.groupMemberUid ';
      _stmtList.add_11rb$(element_601);
      var element_602 = "CREATE OR REPLACE FUNCTION persongroupmember_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO PersonGroupMember(groupMemberUid, groupMemberActive, groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy, groupMemberLct) VALUES (NEW.groupMemberUid, NEW.groupMemberActive, NEW.groupMemberPersonUid, NEW.groupMemberGroupUid, NEW.groupMemberMasterCsn, NEW.groupMemberLocalCsn, NEW.groupMemberLastChangedBy, NEW.groupMemberLct) ON CONFLICT (groupMemberUid) DO UPDATE SET groupMemberActive = EXCLUDED.groupMemberActive, groupMemberPersonUid = EXCLUDED.groupMemberPersonUid, groupMemberGroupUid = EXCLUDED.groupMemberGroupUid, groupMemberMasterCsn = EXCLUDED.groupMemberMasterCsn, groupMemberLocalCsn = EXCLUDED.groupMemberLocalCsn, groupMemberLastChangedBy = EXCLUDED.groupMemberLastChangedBy, groupMemberLct = EXCLUDED.groupMemberLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_602);
      var element_603 = ' CREATE TRIGGER persongroupmember_remote_insert_trig INSTEAD OF INSERT ON PersonGroupMember_ReceiveView FOR EACH ROW EXECUTE PROCEDURE persongroupmember_remote_insert_fn() ';
      _stmtList.add_11rb$(element_603);
      var element_604 = ' CREATE TABLE IF NOT EXISTS PersonPictureReplicate ( ppPk BIGINT NOT NULL, ppVersionId BIGINT NOT NULL DEFAULT 0, ppDestination BIGINT NOT NULL, ppPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (ppPk, ppDestination)) ';
      _stmtList.add_11rb$(element_604);
      var element_605 = ' CREATE INDEX index_PersonPictureReplicate_ppPk_ppDestination_ppVersionId ON PersonPictureReplicate (ppPk, ppDestination, ppVersionId) ';
      _stmtList.add_11rb$(element_605);
      var element_606 = ' CREATE INDEX index_PersonPictureReplicate_ppDestination_ppPending ON PersonPictureReplicate (ppDestination, ppPending) ';
      _stmtList.add_11rb$(element_606);
      var element_607 = ' CREATE OR REPLACE FUNCTION ch_upd_50_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (50, NEW.personPictureUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_607);
      var element_608 = ' CREATE TRIGGER ch_upd_50_trig AFTER UPDATE OR INSERT ON PersonPicture FOR EACH ROW EXECUTE PROCEDURE ch_upd_50_fn(); ';
      _stmtList.add_11rb$(element_608);
      var element_609 = ' CREATE OR REPLACE FUNCTION ch_del_50_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (50, OLD.personPictureUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_609);
      var element_610 = ' CREATE TRIGGER ch_del_50_trig AFTER DELETE ON PersonPicture FOR EACH ROW EXECUTE PROCEDURE ch_del_50_fn(); ';
      _stmtList.add_11rb$(element_610);
      var element_611 = 'CREATE VIEW PersonPicture_ReceiveView AS  SELECT PersonPicture.*, PersonPictureReplicate.* FROM PersonPicture LEFT JOIN PersonPictureReplicate ON PersonPictureReplicate.ppPk = PersonPicture.personPictureUid ';
      _stmtList.add_11rb$(element_611);
      var element_612 = "CREATE OR REPLACE FUNCTION personpicture_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO PersonPicture(personPictureUid, personPicturePersonUid, personPictureMasterCsn, personPictureLocalCsn, personPictureLastChangedBy, personPictureLct, personPictureUri, personPictureMd5, fileSize, picTimestamp, mimeType, personPictureActive) VALUES (NEW.personPictureUid, NEW.personPicturePersonUid, NEW.personPictureMasterCsn, NEW.personPictureLocalCsn, NEW.personPictureLastChangedBy, NEW.personPictureLct, NEW.personPictureUri, NEW.personPictureMd5, NEW.fileSize, NEW.picTimestamp, NEW.mimeType, NEW.personPictureActive) ON CONFLICT (personPictureUid) DO UPDATE SET personPicturePersonUid = EXCLUDED.personPicturePersonUid, personPictureMasterCsn = EXCLUDED.personPictureMasterCsn, personPictureLocalCsn = EXCLUDED.personPictureLocalCsn, personPictureLastChangedBy = EXCLUDED.personPictureLastChangedBy, personPictureLct = EXCLUDED.personPictureLct, personPictureUri = EXCLUDED.personPictureUri, personPictureMd5 = EXCLUDED.personPictureMd5, fileSize = EXCLUDED.fileSize, picTimestamp = EXCLUDED.picTimestamp, mimeType = EXCLUDED.mimeType, personPictureActive = EXCLUDED.personPictureActive ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_612);
      var element_613 = ' CREATE TRIGGER personpicture_remote_insert_trig INSTEAD OF INSERT ON PersonPicture_ReceiveView FOR EACH ROW EXECUTE PROCEDURE personpicture_remote_insert_fn() ';
      _stmtList.add_11rb$(element_613);
      var element_614 = ' CREATE TABLE IF NOT EXISTS ContainerReplicate ( containerPk BIGINT NOT NULL, containerVersionId BIGINT NOT NULL DEFAULT 0, containerDestination BIGINT NOT NULL, containerPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (containerPk, containerDestination)) ';
      _stmtList.add_11rb$(element_614);
      var element_615 = ' CREATE INDEX index_ContainerReplicate_containerPk_containerDestination_containerVersionId ON ContainerReplicate (containerPk, containerDestination, containerVersionId) ';
      _stmtList.add_11rb$(element_615);
      var element_616 = ' CREATE INDEX index_ContainerReplicate_containerDestination_containerPending ON ContainerReplicate (containerDestination, containerPending) ';
      _stmtList.add_11rb$(element_616);
      var element_617 = ' CREATE OR REPLACE FUNCTION ch_upd_51_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (51, NEW.containerUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_617);
      var element_618 = ' CREATE TRIGGER ch_upd_51_trig AFTER UPDATE OR INSERT ON Container FOR EACH ROW EXECUTE PROCEDURE ch_upd_51_fn(); ';
      _stmtList.add_11rb$(element_618);
      var element_619 = ' CREATE OR REPLACE FUNCTION ch_del_51_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (51, OLD.containerUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_619);
      var element_620 = ' CREATE TRIGGER ch_del_51_trig AFTER DELETE ON Container FOR EACH ROW EXECUTE PROCEDURE ch_del_51_fn(); ';
      _stmtList.add_11rb$(element_620);
      var element_621 = 'CREATE VIEW Container_ReceiveView AS  SELECT Container.*, ContainerReplicate.* FROM Container LEFT JOIN ContainerReplicate ON ContainerReplicate.containerPk = Container.containerUid ';
      _stmtList.add_11rb$(element_621);
      var element_622 = "CREATE OR REPLACE FUNCTION container_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Container(containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, cntLct, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries) VALUES (NEW.containerUid, NEW.cntLocalCsn, NEW.cntMasterCsn, NEW.cntLastModBy, NEW.cntLct, NEW.fileSize, NEW.containerContentEntryUid, NEW.cntLastModified, NEW.mimeType, NEW.remarks, NEW.mobileOptimized, NEW.cntNumEntries) ON CONFLICT (containerUid) DO UPDATE SET cntLocalCsn = EXCLUDED.cntLocalCsn, cntMasterCsn = EXCLUDED.cntMasterCsn, cntLastModBy = EXCLUDED.cntLastModBy, cntLct = EXCLUDED.cntLct, fileSize = EXCLUDED.fileSize, containerContentEntryUid = EXCLUDED.containerContentEntryUid, cntLastModified = EXCLUDED.cntLastModified, mimeType = EXCLUDED.mimeType, remarks = EXCLUDED.remarks, mobileOptimized = EXCLUDED.mobileOptimized, cntNumEntries = EXCLUDED.cntNumEntries ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_622);
      var element_623 = ' CREATE TRIGGER container_remote_insert_trig INSTEAD OF INSERT ON Container_ReceiveView FOR EACH ROW EXECUTE PROCEDURE container_remote_insert_fn() ';
      _stmtList.add_11rb$(element_623);
      var element_624 = ' CREATE TABLE IF NOT EXISTS VerbEntityReplicate ( vePk BIGINT NOT NULL, veVersionId BIGINT NOT NULL DEFAULT 0, veDestination BIGINT NOT NULL, vePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (vePk, veDestination)) ';
      _stmtList.add_11rb$(element_624);
      var element_625 = ' CREATE INDEX index_VerbEntityReplicate_vePk_veDestination_veVersionId ON VerbEntityReplicate (vePk, veDestination, veVersionId) ';
      _stmtList.add_11rb$(element_625);
      var element_626 = ' CREATE INDEX index_VerbEntityReplicate_veDestination_vePending ON VerbEntityReplicate (veDestination, vePending) ';
      _stmtList.add_11rb$(element_626);
      var element_627 = ' CREATE OR REPLACE FUNCTION ch_upd_62_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (62, NEW.verbUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_627);
      var element_628 = ' CREATE TRIGGER ch_upd_62_trig AFTER UPDATE OR INSERT ON VerbEntity FOR EACH ROW EXECUTE PROCEDURE ch_upd_62_fn(); ';
      _stmtList.add_11rb$(element_628);
      var element_629 = ' CREATE OR REPLACE FUNCTION ch_del_62_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (62, OLD.verbUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_629);
      var element_630 = ' CREATE TRIGGER ch_del_62_trig AFTER DELETE ON VerbEntity FOR EACH ROW EXECUTE PROCEDURE ch_del_62_fn(); ';
      _stmtList.add_11rb$(element_630);
      var element_631 = 'CREATE VIEW VerbEntity_ReceiveView AS  SELECT VerbEntity.*, VerbEntityReplicate.* FROM VerbEntity LEFT JOIN VerbEntityReplicate ON VerbEntityReplicate.vePk = VerbEntity.verbUid ';
      _stmtList.add_11rb$(element_631);
      var element_632 = "CREATE OR REPLACE FUNCTION verbentity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO VerbEntity(verbUid, urlId, verbInActive, verbMasterChangeSeqNum, verbLocalChangeSeqNum, verbLastChangedBy, verbLct) VALUES (NEW.verbUid, NEW.urlId, NEW.verbInActive, NEW.verbMasterChangeSeqNum, NEW.verbLocalChangeSeqNum, NEW.verbLastChangedBy, NEW.verbLct) ON CONFLICT (verbUid) DO UPDATE SET urlId = EXCLUDED.urlId, verbInActive = EXCLUDED.verbInActive, verbMasterChangeSeqNum = EXCLUDED.verbMasterChangeSeqNum, verbLocalChangeSeqNum = EXCLUDED.verbLocalChangeSeqNum, verbLastChangedBy = EXCLUDED.verbLastChangedBy, verbLct = EXCLUDED.verbLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_632);
      var element_633 = ' CREATE TRIGGER verbentity_remote_insert_trig INSTEAD OF INSERT ON VerbEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE verbentity_remote_insert_fn() ';
      _stmtList.add_11rb$(element_633);
      var element_634 = ' CREATE TABLE IF NOT EXISTS XObjectEntityReplicate ( xoePk BIGINT NOT NULL, xoeVersionId BIGINT NOT NULL DEFAULT 0, xoeDestination BIGINT NOT NULL, xoePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (xoePk, xoeDestination)) ';
      _stmtList.add_11rb$(element_634);
      var element_635 = ' CREATE INDEX index_XObjectEntityReplicate_xoePk_xoeDestination_xoeVersionId ON XObjectEntityReplicate (xoePk, xoeDestination, xoeVersionId) ';
      _stmtList.add_11rb$(element_635);
      var element_636 = ' CREATE INDEX index_XObjectEntityReplicate_xoeDestination_xoePending ON XObjectEntityReplicate (xoeDestination, xoePending) ';
      _stmtList.add_11rb$(element_636);
      var element_637 = ' CREATE OR REPLACE FUNCTION ch_upd_64_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (64, NEW.xObjectUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_637);
      var element_638 = ' CREATE TRIGGER ch_upd_64_trig AFTER UPDATE OR INSERT ON XObjectEntity FOR EACH ROW EXECUTE PROCEDURE ch_upd_64_fn(); ';
      _stmtList.add_11rb$(element_638);
      var element_639 = ' CREATE OR REPLACE FUNCTION ch_del_64_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (64, OLD.xObjectUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_639);
      var element_640 = ' CREATE TRIGGER ch_del_64_trig AFTER DELETE ON XObjectEntity FOR EACH ROW EXECUTE PROCEDURE ch_del_64_fn(); ';
      _stmtList.add_11rb$(element_640);
      var element_641 = 'CREATE VIEW XObjectEntity_ReceiveView AS  SELECT XObjectEntity.*, XObjectEntityReplicate.* FROM XObjectEntity LEFT JOIN XObjectEntityReplicate ON XObjectEntityReplicate.xoePk = XObjectEntity.xObjectUid ';
      _stmtList.add_11rb$(element_641);
      var element_642 = "CREATE OR REPLACE FUNCTION xobjectentity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO XObjectEntity(xObjectUid, objectType, objectId, definitionType, interactionType, correctResponsePattern, objectContentEntryUid, xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum, xObjectLastChangedBy, xObjectLct) VALUES (NEW.xObjectUid, NEW.objectType, NEW.objectId, NEW.definitionType, NEW.interactionType, NEW.correctResponsePattern, NEW.objectContentEntryUid, NEW.xObjectMasterChangeSeqNum, NEW.xObjectocalChangeSeqNum, NEW.xObjectLastChangedBy, NEW.xObjectLct) ON CONFLICT (xObjectUid) DO UPDATE SET objectType = EXCLUDED.objectType, objectId = EXCLUDED.objectId, definitionType = EXCLUDED.definitionType, interactionType = EXCLUDED.interactionType, correctResponsePattern = EXCLUDED.correctResponsePattern, objectContentEntryUid = EXCLUDED.objectContentEntryUid, xObjectMasterChangeSeqNum = EXCLUDED.xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum = EXCLUDED.xObjectocalChangeSeqNum, xObjectLastChangedBy = EXCLUDED.xObjectLastChangedBy, xObjectLct = EXCLUDED.xObjectLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_642);
      var element_643 = ' CREATE TRIGGER xobjectentity_remote_insert_trig INSTEAD OF INSERT ON XObjectEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE xobjectentity_remote_insert_fn() ';
      _stmtList.add_11rb$(element_643);
      var element_644 = ' CREATE TABLE IF NOT EXISTS StatementEntityReplicate ( sePk BIGINT NOT NULL, seVersionId BIGINT NOT NULL DEFAULT 0, seDestination BIGINT NOT NULL, sePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (sePk, seDestination)) ';
      _stmtList.add_11rb$(element_644);
      var element_645 = ' CREATE INDEX index_StatementEntityReplicate_sePk_seDestination_seVersionId ON StatementEntityReplicate (sePk, seDestination, seVersionId) ';
      _stmtList.add_11rb$(element_645);
      var element_646 = ' CREATE INDEX index_StatementEntityReplicate_seDestination_sePending ON StatementEntityReplicate (seDestination, sePending) ';
      _stmtList.add_11rb$(element_646);
      var element_647 = ' CREATE OR REPLACE FUNCTION ch_upd_60_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (60, NEW.statementUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_647);
      var element_648 = ' CREATE TRIGGER ch_upd_60_trig AFTER UPDATE OR INSERT ON StatementEntity FOR EACH ROW EXECUTE PROCEDURE ch_upd_60_fn(); ';
      _stmtList.add_11rb$(element_648);
      var element_649 = ' CREATE OR REPLACE FUNCTION ch_del_60_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (60, OLD.statementUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_649);
      var element_650 = ' CREATE TRIGGER ch_del_60_trig AFTER DELETE ON StatementEntity FOR EACH ROW EXECUTE PROCEDURE ch_del_60_fn(); ';
      _stmtList.add_11rb$(element_650);
      var element_651 = 'CREATE VIEW StatementEntity_ReceiveView AS  SELECT StatementEntity.*, StatementEntityReplicate.* FROM StatementEntity LEFT JOIN StatementEntityReplicate ON StatementEntityReplicate.sePk = StatementEntity.statementUid ';
      _stmtList.add_11rb$(element_651);
      var element_652 = "CREATE OR REPLACE FUNCTION statemententity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO StatementEntity(statementUid, statementId, statementPersonUid, statementVerbUid, xObjectUid, subStatementActorUid, substatementVerbUid, subStatementObjectUid, agentUid, instructorUid, authorityUid, teamUid, resultCompletion, resultSuccess, resultScoreScaled, resultScoreRaw, resultScoreMin, resultScoreMax, resultDuration, resultResponse, timestamp, stored, contextRegistration, contextPlatform, contextStatementId, fullStatement, statementMasterChangeSeqNum, statementLocalChangeSeqNum, statementLastChangedBy, statementLct, extensionProgress, contentEntryRoot, statementContentEntryUid, statementLearnerGroupUid, statementClazzUid) VALUES (NEW.statementUid, NEW.statementId, NEW.statementPersonUid, NEW.statementVerbUid, NEW.xObjectUid, NEW.subStatementActorUid, NEW.substatementVerbUid, NEW.subStatementObjectUid, NEW.agentUid, NEW.instructorUid, NEW.authorityUid, NEW.teamUid, NEW.resultCompletion, NEW.resultSuccess, NEW.resultScoreScaled, NEW.resultScoreRaw, NEW.resultScoreMin, NEW.resultScoreMax, NEW.resultDuration, NEW.resultResponse, NEW.timestamp, NEW.stored, NEW.contextRegistration, NEW.contextPlatform, NEW.contextStatementId, NEW.fullStatement, NEW.statementMasterChangeSeqNum, NEW.statementLocalChangeSeqNum, NEW.statementLastChangedBy, NEW.statementLct, NEW.extensionProgress, NEW.contentEntryRoot, NEW.statementContentEntryUid, NEW.statementLearnerGroupUid, NEW.statementClazzUid) ON CONFLICT (statementUid) DO UPDATE SET statementId = EXCLUDED.statementId, statementPersonUid = EXCLUDED.statementPersonUid, statementVerbUid = EXCLUDED.statementVerbUid, xObjectUid = EXCLUDED.xObjectUid, subStatementActorUid = EXCLUDED.subStatementActorUid, substatementVerbUid = EXCLUDED.substatementVerbUid, subStatementObjectUid = EXCLUDED.subStatementObjectUid, agentUid = EXCLUDED.agentUid, instructorUid = EXCLUDED.instructorUid, authorityUid = EXCLUDED.authorityUid, teamUid = EXCLUDED.teamUid, resultCompletion = EXCLUDED.resultCompletion, resultSuccess = EXCLUDED.resultSuccess, resultScoreScaled = EXCLUDED.resultScoreScaled, resultScoreRaw = EXCLUDED.resultScoreRaw, resultScoreMin = EXCLUDED.resultScoreMin, resultScoreMax = EXCLUDED.resultScoreMax, resultDuration = EXCLUDED.resultDuration, resultResponse = EXCLUDED.resultResponse, timestamp = EXCLUDED.timestamp, stored = EXCLUDED.stored, contextRegistration = EXCLUDED.contextRegistration, contextPlatform = EXCLUDED.contextPlatform, contextStatementId = EXCLUDED.contextStatementId, fullStatement = EXCLUDED.fullStatement, statementMasterChangeSeqNum = EXCLUDED.statementMasterChangeSeqNum, statementLocalChangeSeqNum = EXCLUDED.statementLocalChangeSeqNum, statementLastChangedBy = EXCLUDED.statementLastChangedBy, statementLct = EXCLUDED.statementLct, extensionProgress = EXCLUDED.extensionProgress, contentEntryRoot = EXCLUDED.contentEntryRoot, statementContentEntryUid = EXCLUDED.statementContentEntryUid, statementLearnerGroupUid = EXCLUDED.statementLearnerGroupUid, statementClazzUid = EXCLUDED.statementClazzUid ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_652);
      var element_653 = ' CREATE TRIGGER statemententity_remote_insert_trig INSTEAD OF INSERT ON StatementEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE statemententity_remote_insert_fn() ';
      _stmtList.add_11rb$(element_653);
      var element_654 = ' CREATE TABLE IF NOT EXISTS ContextXObjectStatementJoinReplicate ( cxosjPk BIGINT NOT NULL, cxosjVersionId BIGINT NOT NULL DEFAULT 0, cxosjDestination BIGINT NOT NULL, cxosjPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (cxosjPk, cxosjDestination)) ';
      _stmtList.add_11rb$(element_654);
      var element_655 = ' CREATE INDEX index_ContextXObjectStatementJoinReplicate_cxosjPk_cxosjDestination_cxosjVersionId ON ContextXObjectStatementJoinReplicate (cxosjPk, cxosjDestination, cxosjVersionId) ';
      _stmtList.add_11rb$(element_655);
      var element_656 = ' CREATE INDEX index_ContextXObjectStatementJoinReplicate_cxosjDestination_cxosjPending ON ContextXObjectStatementJoinReplicate (cxosjDestination, cxosjPending) ';
      _stmtList.add_11rb$(element_656);
      var element_657 = ' CREATE OR REPLACE FUNCTION ch_upd_66_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (66, NEW.contextXObjectStatementJoinUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_657);
      var element_658 = ' CREATE TRIGGER ch_upd_66_trig AFTER UPDATE OR INSERT ON ContextXObjectStatementJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_66_fn(); ';
      _stmtList.add_11rb$(element_658);
      var element_659 = ' CREATE OR REPLACE FUNCTION ch_del_66_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (66, OLD.contextXObjectStatementJoinUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_659);
      var element_660 = ' CREATE TRIGGER ch_del_66_trig AFTER DELETE ON ContextXObjectStatementJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_66_fn(); ';
      _stmtList.add_11rb$(element_660);
      var element_661 = 'CREATE VIEW ContextXObjectStatementJoin_ReceiveView AS  SELECT ContextXObjectStatementJoin.*, ContextXObjectStatementJoinReplicate.* FROM ContextXObjectStatementJoin LEFT JOIN ContextXObjectStatementJoinReplicate ON ContextXObjectStatementJoinReplicate.cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid ';
      _stmtList.add_11rb$(element_661);
      var element_662 = "CREATE OR REPLACE FUNCTION contextxobjectstatementjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ContextXObjectStatementJoin(contextXObjectStatementJoinUid, contextActivityFlag, contextStatementUid, contextXObjectUid, verbMasterChangeSeqNum, verbLocalChangeSeqNum, verbLastChangedBy, contextXObjectLct) VALUES (NEW.contextXObjectStatementJoinUid, NEW.contextActivityFlag, NEW.contextStatementUid, NEW.contextXObjectUid, NEW.verbMasterChangeSeqNum, NEW.verbLocalChangeSeqNum, NEW.verbLastChangedBy, NEW.contextXObjectLct) ON CONFLICT (contextXObjectStatementJoinUid) DO UPDATE SET contextActivityFlag = EXCLUDED.contextActivityFlag, contextStatementUid = EXCLUDED.contextStatementUid, contextXObjectUid = EXCLUDED.contextXObjectUid, verbMasterChangeSeqNum = EXCLUDED.verbMasterChangeSeqNum, verbLocalChangeSeqNum = EXCLUDED.verbLocalChangeSeqNum, verbLastChangedBy = EXCLUDED.verbLastChangedBy, contextXObjectLct = EXCLUDED.contextXObjectLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_662);
      var element_663 = ' CREATE TRIGGER contextxobjectstatementjoin_remote_insert_trig INSTEAD OF INSERT ON ContextXObjectStatementJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE contextxobjectstatementjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_663);
      var element_664 = ' CREATE TABLE IF NOT EXISTS AgentEntityReplicate ( aePk BIGINT NOT NULL, aeVersionId BIGINT NOT NULL DEFAULT 0, aeDestination BIGINT NOT NULL, aePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (aePk, aeDestination)) ';
      _stmtList.add_11rb$(element_664);
      var element_665 = ' CREATE INDEX index_AgentEntityReplicate_aePk_aeDestination_aeVersionId ON AgentEntityReplicate (aePk, aeDestination, aeVersionId) ';
      _stmtList.add_11rb$(element_665);
      var element_666 = ' CREATE INDEX index_AgentEntityReplicate_aeDestination_aePending ON AgentEntityReplicate (aeDestination, aePending) ';
      _stmtList.add_11rb$(element_666);
      var element_667 = ' CREATE OR REPLACE FUNCTION ch_upd_68_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (68, NEW.agentUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_667);
      var element_668 = ' CREATE TRIGGER ch_upd_68_trig AFTER UPDATE OR INSERT ON AgentEntity FOR EACH ROW EXECUTE PROCEDURE ch_upd_68_fn(); ';
      _stmtList.add_11rb$(element_668);
      var element_669 = ' CREATE OR REPLACE FUNCTION ch_del_68_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (68, OLD.agentUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_669);
      var element_670 = ' CREATE TRIGGER ch_del_68_trig AFTER DELETE ON AgentEntity FOR EACH ROW EXECUTE PROCEDURE ch_del_68_fn(); ';
      _stmtList.add_11rb$(element_670);
      var element_671 = 'CREATE VIEW AgentEntity_ReceiveView AS  SELECT AgentEntity.*, AgentEntityReplicate.* FROM AgentEntity LEFT JOIN AgentEntityReplicate ON AgentEntityReplicate.aePk = AgentEntity.agentUid ';
      _stmtList.add_11rb$(element_671);
      var element_672 = "CREATE OR REPLACE FUNCTION agententity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO AgentEntity(agentUid, agentMbox, agentMbox_sha1sum, agentOpenid, agentAccountName, agentHomePage, agentPersonUid, statementMasterChangeSeqNum, statementLocalChangeSeqNum, statementLastChangedBy, agentLct) VALUES (NEW.agentUid, NEW.agentMbox, NEW.agentMbox_sha1sum, NEW.agentOpenid, NEW.agentAccountName, NEW.agentHomePage, NEW.agentPersonUid, NEW.statementMasterChangeSeqNum, NEW.statementLocalChangeSeqNum, NEW.statementLastChangedBy, NEW.agentLct) ON CONFLICT (agentUid) DO UPDATE SET agentMbox = EXCLUDED.agentMbox, agentMbox_sha1sum = EXCLUDED.agentMbox_sha1sum, agentOpenid = EXCLUDED.agentOpenid, agentAccountName = EXCLUDED.agentAccountName, agentHomePage = EXCLUDED.agentHomePage, agentPersonUid = EXCLUDED.agentPersonUid, statementMasterChangeSeqNum = EXCLUDED.statementMasterChangeSeqNum, statementLocalChangeSeqNum = EXCLUDED.statementLocalChangeSeqNum, statementLastChangedBy = EXCLUDED.statementLastChangedBy, agentLct = EXCLUDED.agentLct; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_672);
      var element_673 = ' CREATE TRIGGER agententity_remote_insert_trig INSTEAD OF INSERT ON AgentEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE agententity_remote_insert_fn() ';
      _stmtList.add_11rb$(element_673);
      var element_674 = ' CREATE TABLE IF NOT EXISTS StateEntityReplicate ( sePk BIGINT NOT NULL, seVersionId BIGINT NOT NULL DEFAULT 0, seDestination BIGINT NOT NULL, sePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (sePk, seDestination)) ';
      _stmtList.add_11rb$(element_674);
      var element_675 = ' CREATE INDEX index_StateEntityReplicate_sePk_seDestination_seVersionId ON StateEntityReplicate (sePk, seDestination, seVersionId) ';
      _stmtList.add_11rb$(element_675);
      var element_676 = ' CREATE INDEX index_StateEntityReplicate_seDestination_sePending ON StateEntityReplicate (seDestination, sePending) ';
      _stmtList.add_11rb$(element_676);
      var element_677 = ' CREATE OR REPLACE FUNCTION ch_upd_70_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (70, NEW.stateUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_677);
      var element_678 = ' CREATE TRIGGER ch_upd_70_trig AFTER UPDATE OR INSERT ON StateEntity FOR EACH ROW EXECUTE PROCEDURE ch_upd_70_fn(); ';
      _stmtList.add_11rb$(element_678);
      var element_679 = ' CREATE OR REPLACE FUNCTION ch_del_70_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (70, OLD.stateUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_679);
      var element_680 = ' CREATE TRIGGER ch_del_70_trig AFTER DELETE ON StateEntity FOR EACH ROW EXECUTE PROCEDURE ch_del_70_fn(); ';
      _stmtList.add_11rb$(element_680);
      var element_681 = 'CREATE VIEW StateEntity_ReceiveView AS  SELECT StateEntity.*, StateEntityReplicate.* FROM StateEntity LEFT JOIN StateEntityReplicate ON StateEntityReplicate.sePk = StateEntity.stateUid ';
      _stmtList.add_11rb$(element_681);
      var element_682 = "CREATE OR REPLACE FUNCTION stateentity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO StateEntity(stateUid, stateId, agentUid, activityId, registration, isIsactive, timestamp, stateMasterChangeSeqNum, stateLocalChangeSeqNum, stateLastChangedBy, stateLct) VALUES (NEW.stateUid, NEW.stateId, NEW.agentUid, NEW.activityId, NEW.registration, NEW.isIsactive, NEW.timestamp, NEW.stateMasterChangeSeqNum, NEW.stateLocalChangeSeqNum, NEW.stateLastChangedBy, NEW.stateLct) ON CONFLICT (stateUid) DO UPDATE SET stateId = EXCLUDED.stateId, agentUid = EXCLUDED.agentUid, activityId = EXCLUDED.activityId, registration = EXCLUDED.registration, isIsactive = EXCLUDED.isIsactive, timestamp = EXCLUDED.timestamp, stateMasterChangeSeqNum = EXCLUDED.stateMasterChangeSeqNum, stateLocalChangeSeqNum = EXCLUDED.stateLocalChangeSeqNum, stateLastChangedBy = EXCLUDED.stateLastChangedBy, stateLct = EXCLUDED.stateLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_682);
      var element_683 = ' CREATE TRIGGER stateentity_remote_insert_trig INSTEAD OF INSERT ON StateEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE stateentity_remote_insert_fn() ';
      _stmtList.add_11rb$(element_683);
      var element_684 = ' CREATE TABLE IF NOT EXISTS StateContentEntityReplicate ( scePk BIGINT NOT NULL, sceVersionId BIGINT NOT NULL DEFAULT 0, sceDestination BIGINT NOT NULL, scePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (scePk, sceDestination)) ';
      _stmtList.add_11rb$(element_684);
      var element_685 = ' CREATE INDEX index_StateContentEntityReplicate_scePk_sceDestination_sceVersionId ON StateContentEntityReplicate (scePk, sceDestination, sceVersionId) ';
      _stmtList.add_11rb$(element_685);
      var element_686 = ' CREATE INDEX index_StateContentEntityReplicate_sceDestination_scePending ON StateContentEntityReplicate (sceDestination, scePending) ';
      _stmtList.add_11rb$(element_686);
      var element_687 = ' CREATE OR REPLACE FUNCTION ch_upd_72_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (72, NEW.stateContentUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_687);
      var element_688 = ' CREATE TRIGGER ch_upd_72_trig AFTER UPDATE OR INSERT ON StateContentEntity FOR EACH ROW EXECUTE PROCEDURE ch_upd_72_fn(); ';
      _stmtList.add_11rb$(element_688);
      var element_689 = ' CREATE OR REPLACE FUNCTION ch_del_72_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (72, OLD.stateContentUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_689);
      var element_690 = ' CREATE TRIGGER ch_del_72_trig AFTER DELETE ON StateContentEntity FOR EACH ROW EXECUTE PROCEDURE ch_del_72_fn(); ';
      _stmtList.add_11rb$(element_690);
      var element_691 = 'CREATE VIEW StateContentEntity_ReceiveView AS  SELECT StateContentEntity.*, StateContentEntityReplicate.* FROM StateContentEntity LEFT JOIN StateContentEntityReplicate ON StateContentEntityReplicate.scePk = StateContentEntity.stateContentUid ';
      _stmtList.add_11rb$(element_691);
      var element_692 = "CREATE OR REPLACE FUNCTION statecontententity_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO StateContentEntity(stateContentUid, stateContentStateUid, stateContentKey, stateContentValue, isIsactive, stateContentMasterChangeSeqNum, stateContentLocalChangeSeqNum, stateContentLastChangedBy, stateContentLct) VALUES (NEW.stateContentUid, NEW.stateContentStateUid, NEW.stateContentKey, NEW.stateContentValue, NEW.isIsactive, NEW.stateContentMasterChangeSeqNum, NEW.stateContentLocalChangeSeqNum, NEW.stateContentLastChangedBy, NEW.stateContentLct) ON CONFLICT (stateContentUid) DO UPDATE SET stateContentStateUid = EXCLUDED.stateContentStateUid, stateContentKey = EXCLUDED.stateContentKey, stateContentValue = EXCLUDED.stateContentValue, isIsactive = EXCLUDED.isIsactive, stateContentMasterChangeSeqNum = EXCLUDED.stateContentMasterChangeSeqNum, stateContentLocalChangeSeqNum = EXCLUDED.stateContentLocalChangeSeqNum, stateContentLastChangedBy = EXCLUDED.stateContentLastChangedBy, stateContentLct = EXCLUDED.stateContentLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_692);
      var element_693 = ' CREATE TRIGGER statecontententity_remote_insert_trig INSTEAD OF INSERT ON StateContentEntity_ReceiveView FOR EACH ROW EXECUTE PROCEDURE statecontententity_remote_insert_fn() ';
      _stmtList.add_11rb$(element_693);
      var element_694 = ' CREATE TABLE IF NOT EXISTS XLangMapEntryReplicate ( xlmePk BIGINT NOT NULL, xlmeVersionId BIGINT NOT NULL DEFAULT 0, xlmeDestination BIGINT NOT NULL, xlmePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (xlmePk, xlmeDestination)) ';
      _stmtList.add_11rb$(element_694);
      var element_695 = ' CREATE INDEX index_XLangMapEntryReplicate_xlmePk_xlmeDestination_xlmeVersionId ON XLangMapEntryReplicate (xlmePk, xlmeDestination, xlmeVersionId) ';
      _stmtList.add_11rb$(element_695);
      var element_696 = ' CREATE INDEX index_XLangMapEntryReplicate_xlmeDestination_xlmePending ON XLangMapEntryReplicate (xlmeDestination, xlmePending) ';
      _stmtList.add_11rb$(element_696);
      var element_697 = ' CREATE OR REPLACE FUNCTION ch_upd_74_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (74, NEW.statementLangMapUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_697);
      var element_698 = ' CREATE TRIGGER ch_upd_74_trig AFTER UPDATE OR INSERT ON XLangMapEntry FOR EACH ROW EXECUTE PROCEDURE ch_upd_74_fn(); ';
      _stmtList.add_11rb$(element_698);
      var element_699 = ' CREATE OR REPLACE FUNCTION ch_del_74_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (74, OLD.statementLangMapUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_699);
      var element_700 = ' CREATE TRIGGER ch_del_74_trig AFTER DELETE ON XLangMapEntry FOR EACH ROW EXECUTE PROCEDURE ch_del_74_fn(); ';
      _stmtList.add_11rb$(element_700);
      var element_701 = 'CREATE VIEW XLangMapEntry_ReceiveView AS  SELECT XLangMapEntry.*, XLangMapEntryReplicate.* FROM XLangMapEntry LEFT JOIN XLangMapEntryReplicate ON XLangMapEntryReplicate.xlmePk = XLangMapEntry.statementLangMapUid ';
      _stmtList.add_11rb$(element_701);
      var element_702 = "CREATE OR REPLACE FUNCTION xlangmapentry_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO XLangMapEntry(verbLangMapUid, objectLangMapUid, languageLangMapUid, languageVariantLangMapUid, valueLangMap, statementLangMapMasterCsn, statementLangMapLocalCsn, statementLangMapLcb, statementLangMapLct, statementLangMapUid) VALUES (NEW.verbLangMapUid, NEW.objectLangMapUid, NEW.languageLangMapUid, NEW.languageVariantLangMapUid, NEW.valueLangMap, NEW.statementLangMapMasterCsn, NEW.statementLangMapLocalCsn, NEW.statementLangMapLcb, NEW.statementLangMapLct, NEW.statementLangMapUid) ON CONFLICT (statementLangMapUid) DO UPDATE SET verbLangMapUid = EXCLUDED.verbLangMapUid, objectLangMapUid = EXCLUDED.objectLangMapUid, languageLangMapUid = EXCLUDED.languageLangMapUid, languageVariantLangMapUid = EXCLUDED.languageVariantLangMapUid, valueLangMap = EXCLUDED.valueLangMap, statementLangMapMasterCsn = EXCLUDED.statementLangMapMasterCsn, statementLangMapLocalCsn = EXCLUDED.statementLangMapLocalCsn, statementLangMapLcb = EXCLUDED.statementLangMapLcb, statementLangMapLct = EXCLUDED.statementLangMapLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_702);
      var element_703 = ' CREATE TRIGGER xlangmapentry_remote_insert_trig INSTEAD OF INSERT ON XLangMapEntry_ReceiveView FOR EACH ROW EXECUTE PROCEDURE xlangmapentry_remote_insert_fn() ';
      _stmtList.add_11rb$(element_703);
      var element_704 = ' CREATE TABLE IF NOT EXISTS SchoolReplicate ( schoolPk BIGINT NOT NULL, schoolVersionId BIGINT NOT NULL DEFAULT 0, schoolDestination BIGINT NOT NULL, schoolPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (schoolPk, schoolDestination)) ';
      _stmtList.add_11rb$(element_704);
      var element_705 = ' CREATE INDEX index_SchoolReplicate_schoolPk_schoolDestination_schoolVersionId ON SchoolReplicate (schoolPk, schoolDestination, schoolVersionId) ';
      _stmtList.add_11rb$(element_705);
      var element_706 = ' CREATE INDEX index_SchoolReplicate_schoolDestination_schoolPending ON SchoolReplicate (schoolDestination, schoolPending) ';
      _stmtList.add_11rb$(element_706);
      var element_707 = ' CREATE OR REPLACE FUNCTION ch_upd_164_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (164, NEW.schoolUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_707);
      var element_708 = ' CREATE TRIGGER ch_upd_164_trig AFTER UPDATE OR INSERT ON School FOR EACH ROW EXECUTE PROCEDURE ch_upd_164_fn(); ';
      _stmtList.add_11rb$(element_708);
      var element_709 = ' CREATE OR REPLACE FUNCTION ch_del_164_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (164, OLD.schoolUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_709);
      var element_710 = ' CREATE TRIGGER ch_del_164_trig AFTER DELETE ON School FOR EACH ROW EXECUTE PROCEDURE ch_del_164_fn(); ';
      _stmtList.add_11rb$(element_710);
      var element_711 = 'CREATE VIEW School_ReceiveView AS  SELECT School.*, SchoolReplicate.* FROM School LEFT JOIN SchoolReplicate ON SchoolReplicate.schoolPk = School.schoolUid ';
      _stmtList.add_11rb$(element_711);
      var element_712 = "CREATE OR REPLACE FUNCTION school_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO School(schoolUid, schoolName, schoolDesc, schoolAddress, schoolActive, schoolPhoneNumber, schoolGender, schoolHolidayCalendarUid, schoolFeatures, schoolLocationLong, schoolLocationLatt, schoolEmailAddress, schoolTeachersPersonGroupUid, schoolStudentsPersonGroupUid, schoolPendingStudentsPersonGroupUid, schoolCode, schoolMasterChangeSeqNum, schoolLocalChangeSeqNum, schoolLastChangedBy, schoolLct, schoolTimeZone) VALUES (NEW.schoolUid, NEW.schoolName, NEW.schoolDesc, NEW.schoolAddress, NEW.schoolActive, NEW.schoolPhoneNumber, NEW.schoolGender, NEW.schoolHolidayCalendarUid, NEW.schoolFeatures, NEW.schoolLocationLong, NEW.schoolLocationLatt, NEW.schoolEmailAddress, NEW.schoolTeachersPersonGroupUid, NEW.schoolStudentsPersonGroupUid, NEW.schoolPendingStudentsPersonGroupUid, NEW.schoolCode, NEW.schoolMasterChangeSeqNum, NEW.schoolLocalChangeSeqNum, NEW.schoolLastChangedBy, NEW.schoolLct, NEW.schoolTimeZone) ON CONFLICT (schoolUid) DO UPDATE SET schoolName = EXCLUDED.schoolName, schoolDesc = EXCLUDED.schoolDesc, schoolAddress = EXCLUDED.schoolAddress, schoolActive = EXCLUDED.schoolActive, schoolPhoneNumber = EXCLUDED.schoolPhoneNumber, schoolGender = EXCLUDED.schoolGender, schoolHolidayCalendarUid = EXCLUDED.schoolHolidayCalendarUid, schoolFeatures = EXCLUDED.schoolFeatures, schoolLocationLong = EXCLUDED.schoolLocationLong, schoolLocationLatt = EXCLUDED.schoolLocationLatt, schoolEmailAddress = EXCLUDED.schoolEmailAddress, schoolTeachersPersonGroupUid = EXCLUDED.schoolTeachersPersonGroupUid, schoolStudentsPersonGroupUid = EXCLUDED.schoolStudentsPersonGroupUid, schoolPendingStudentsPersonGroupUid = EXCLUDED.schoolPendingStudentsPersonGroupUid, schoolCode = EXCLUDED.schoolCode, schoolMasterChangeSeqNum = EXCLUDED.schoolMasterChangeSeqNum, schoolLocalChangeSeqNum = EXCLUDED.schoolLocalChangeSeqNum, schoolLastChangedBy = EXCLUDED.schoolLastChangedBy, schoolLct = EXCLUDED.schoolLct, schoolTimeZone = EXCLUDED.schoolTimeZone ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_712);
      var element_713 = ' CREATE TRIGGER school_remote_insert_trig INSTEAD OF INSERT ON School_ReceiveView FOR EACH ROW EXECUTE PROCEDURE school_remote_insert_fn() ';
      _stmtList.add_11rb$(element_713);
      var element_714 = ' CREATE TABLE IF NOT EXISTS SchoolMemberReplicate ( smPk BIGINT NOT NULL, smVersionId BIGINT NOT NULL DEFAULT 0, smDestination BIGINT NOT NULL, smPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (smPk, smDestination)) ';
      _stmtList.add_11rb$(element_714);
      var element_715 = ' CREATE INDEX index_SchoolMemberReplicate_smPk_smDestination_smVersionId ON SchoolMemberReplicate (smPk, smDestination, smVersionId) ';
      _stmtList.add_11rb$(element_715);
      var element_716 = ' CREATE INDEX index_SchoolMemberReplicate_smDestination_smPending ON SchoolMemberReplicate (smDestination, smPending) ';
      _stmtList.add_11rb$(element_716);
      var element_717 = ' CREATE OR REPLACE FUNCTION ch_upd_200_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (200, NEW.schoolMemberUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_717);
      var element_718 = ' CREATE TRIGGER ch_upd_200_trig AFTER UPDATE OR INSERT ON SchoolMember FOR EACH ROW EXECUTE PROCEDURE ch_upd_200_fn(); ';
      _stmtList.add_11rb$(element_718);
      var element_719 = ' CREATE OR REPLACE FUNCTION ch_del_200_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (200, OLD.schoolMemberUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_719);
      var element_720 = ' CREATE TRIGGER ch_del_200_trig AFTER DELETE ON SchoolMember FOR EACH ROW EXECUTE PROCEDURE ch_del_200_fn(); ';
      _stmtList.add_11rb$(element_720);
      var element_721 = 'CREATE VIEW SchoolMember_ReceiveView AS  SELECT SchoolMember.*, SchoolMemberReplicate.* FROM SchoolMember LEFT JOIN SchoolMemberReplicate ON SchoolMemberReplicate.smPk = SchoolMember.schoolMemberUid ';
      _stmtList.add_11rb$(element_721);
      var element_722 = "CREATE OR REPLACE FUNCTION schoolmember_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO SchoolMember(schoolMemberUid, schoolMemberPersonUid, schoolMemberSchoolUid, schoolMemberJoinDate, schoolMemberLeftDate, schoolMemberRole, schoolMemberActive, schoolMemberLocalChangeSeqNum, schoolMemberMasterChangeSeqNum, schoolMemberLastChangedBy, schoolMemberLct) VALUES (NEW.schoolMemberUid, NEW.schoolMemberPersonUid, NEW.schoolMemberSchoolUid, NEW.schoolMemberJoinDate, NEW.schoolMemberLeftDate, NEW.schoolMemberRole, NEW.schoolMemberActive, NEW.schoolMemberLocalChangeSeqNum, NEW.schoolMemberMasterChangeSeqNum, NEW.schoolMemberLastChangedBy, NEW.schoolMemberLct) ON CONFLICT (schoolMemberUid) DO UPDATE SET schoolMemberPersonUid = EXCLUDED.schoolMemberPersonUid, schoolMemberSchoolUid = EXCLUDED.schoolMemberSchoolUid, schoolMemberJoinDate = EXCLUDED.schoolMemberJoinDate, schoolMemberLeftDate = EXCLUDED.schoolMemberLeftDate, schoolMemberRole = EXCLUDED.schoolMemberRole, schoolMemberActive = EXCLUDED.schoolMemberActive, schoolMemberLocalChangeSeqNum = EXCLUDED.schoolMemberLocalChangeSeqNum, schoolMemberMasterChangeSeqNum = EXCLUDED.schoolMemberMasterChangeSeqNum, schoolMemberLastChangedBy = EXCLUDED.schoolMemberLastChangedBy, schoolMemberLct = EXCLUDED.schoolMemberLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_722);
      var element_723 = ' CREATE TRIGGER schoolmember_remote_insert_trig INSTEAD OF INSERT ON SchoolMember_ReceiveView FOR EACH ROW EXECUTE PROCEDURE schoolmember_remote_insert_fn() ';
      _stmtList.add_11rb$(element_723);
      var element_724 = ' CREATE TABLE IF NOT EXISTS CommentsReplicate ( commentsPk BIGINT NOT NULL, commentsVersionId BIGINT NOT NULL DEFAULT 0, commentsDestination BIGINT NOT NULL, commentsPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (commentsPk, commentsDestination)) ';
      _stmtList.add_11rb$(element_724);
      var element_725 = ' CREATE INDEX index_CommentsReplicate_commentsPk_commentsDestination_commentsVersionId ON CommentsReplicate (commentsPk, commentsDestination, commentsVersionId) ';
      _stmtList.add_11rb$(element_725);
      var element_726 = ' CREATE INDEX index_CommentsReplicate_commentsDestination_commentsPending ON CommentsReplicate (commentsDestination, commentsPending) ';
      _stmtList.add_11rb$(element_726);
      var element_727 = ' CREATE OR REPLACE FUNCTION ch_upd_208_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (208, NEW.commentsUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_727);
      var element_728 = ' CREATE TRIGGER ch_upd_208_trig AFTER UPDATE OR INSERT ON Comments FOR EACH ROW EXECUTE PROCEDURE ch_upd_208_fn(); ';
      _stmtList.add_11rb$(element_728);
      var element_729 = ' CREATE OR REPLACE FUNCTION ch_del_208_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (208, OLD.commentsUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_729);
      var element_730 = ' CREATE TRIGGER ch_del_208_trig AFTER DELETE ON Comments FOR EACH ROW EXECUTE PROCEDURE ch_del_208_fn(); ';
      _stmtList.add_11rb$(element_730);
      var element_731 = 'CREATE VIEW Comments_ReceiveView AS  SELECT Comments.*, CommentsReplicate.* FROM Comments LEFT JOIN CommentsReplicate ON CommentsReplicate.commentsPk = Comments.commentsUid ';
      _stmtList.add_11rb$(element_731);
      var element_732 = "CREATE OR REPLACE FUNCTION comments_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Comments(commentsUid, commentsText, commentsEntityType, commentsEntityUid, commentsPublic, commentsStatus, commentsPersonUid, commentsToPersonUid, commentsFlagged, commentsInActive, commentsDateTimeAdded, commentsDateTimeUpdated, commentsMCSN, commentsLCSN, commentsLCB, commentsLct) VALUES (NEW.commentsUid, NEW.commentsText, NEW.commentsEntityType, NEW.commentsEntityUid, NEW.commentsPublic, NEW.commentsStatus, NEW.commentsPersonUid, NEW.commentsToPersonUid, NEW.commentsFlagged, NEW.commentsInActive, NEW.commentsDateTimeAdded, NEW.commentsDateTimeUpdated, NEW.commentsMCSN, NEW.commentsLCSN, NEW.commentsLCB, NEW.commentsLct) ON CONFLICT (commentsUid) DO UPDATE SET commentsText = EXCLUDED.commentsText, commentsEntityType = EXCLUDED.commentsEntityType, commentsEntityUid = EXCLUDED.commentsEntityUid, commentsPublic = EXCLUDED.commentsPublic, commentsStatus = EXCLUDED.commentsStatus, commentsPersonUid = EXCLUDED.commentsPersonUid, commentsToPersonUid = EXCLUDED.commentsToPersonUid, commentsFlagged = EXCLUDED.commentsFlagged, commentsInActive = EXCLUDED.commentsInActive, commentsDateTimeAdded = EXCLUDED.commentsDateTimeAdded, commentsDateTimeUpdated = EXCLUDED.commentsDateTimeUpdated, commentsMCSN = EXCLUDED.commentsMCSN, commentsLCSN = EXCLUDED.commentsLCSN, commentsLCB = EXCLUDED.commentsLCB, commentsLct = EXCLUDED.commentsLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_732);
      var element_733 = ' CREATE TRIGGER comments_remote_insert_trig INSTEAD OF INSERT ON Comments_ReceiveView FOR EACH ROW EXECUTE PROCEDURE comments_remote_insert_fn() ';
      _stmtList.add_11rb$(element_733);
      var element_734 = ' CREATE TABLE IF NOT EXISTS ReportReplicate ( reportPk BIGINT NOT NULL, reportVersionId BIGINT NOT NULL DEFAULT 0, reportDestination BIGINT NOT NULL, reportPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (reportPk, reportDestination)) ';
      _stmtList.add_11rb$(element_734);
      var element_735 = ' CREATE INDEX index_ReportReplicate_reportPk_reportDestination_reportVersionId ON ReportReplicate (reportPk, reportDestination, reportVersionId) ';
      _stmtList.add_11rb$(element_735);
      var element_736 = ' CREATE INDEX index_ReportReplicate_reportDestination_reportPending ON ReportReplicate (reportDestination, reportPending) ';
      _stmtList.add_11rb$(element_736);
      var element_737 = ' CREATE OR REPLACE FUNCTION ch_upd_101_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (101, NEW.reportUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_737);
      var element_738 = ' CREATE TRIGGER ch_upd_101_trig AFTER UPDATE OR INSERT ON Report FOR EACH ROW EXECUTE PROCEDURE ch_upd_101_fn(); ';
      _stmtList.add_11rb$(element_738);
      var element_739 = ' CREATE OR REPLACE FUNCTION ch_del_101_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (101, OLD.reportUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_739);
      var element_740 = ' CREATE TRIGGER ch_del_101_trig AFTER DELETE ON Report FOR EACH ROW EXECUTE PROCEDURE ch_del_101_fn(); ';
      _stmtList.add_11rb$(element_740);
      var element_741 = 'CREATE VIEW Report_ReceiveView AS  SELECT Report.*, ReportReplicate.* FROM Report LEFT JOIN ReportReplicate ON ReportReplicate.reportPk = Report.reportUid ';
      _stmtList.add_11rb$(element_741);
      var element_742 = ' CREATE TABLE IF NOT EXISTS SiteReplicate ( sitePk BIGINT NOT NULL, siteVersionId BIGINT NOT NULL DEFAULT 0, siteDestination BIGINT NOT NULL, sitePending BOOL NOT NULL DEFAULT true, PRIMARY KEY (sitePk, siteDestination)) ';
      _stmtList.add_11rb$(element_742);
      var element_743 = ' CREATE INDEX index_SiteReplicate_sitePk_siteDestination_siteVersionId ON SiteReplicate (sitePk, siteDestination, siteVersionId) ';
      _stmtList.add_11rb$(element_743);
      var element_744 = ' CREATE INDEX index_SiteReplicate_siteDestination_sitePending ON SiteReplicate (siteDestination, sitePending) ';
      _stmtList.add_11rb$(element_744);
      var element_745 = ' CREATE OR REPLACE FUNCTION ch_upd_189_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (189, NEW.siteUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_745);
      var element_746 = ' CREATE TRIGGER ch_upd_189_trig AFTER UPDATE OR INSERT ON Site FOR EACH ROW EXECUTE PROCEDURE ch_upd_189_fn(); ';
      _stmtList.add_11rb$(element_746);
      var element_747 = ' CREATE OR REPLACE FUNCTION ch_del_189_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (189, OLD.siteUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_747);
      var element_748 = ' CREATE TRIGGER ch_del_189_trig AFTER DELETE ON Site FOR EACH ROW EXECUTE PROCEDURE ch_del_189_fn(); ';
      _stmtList.add_11rb$(element_748);
      var element_749 = 'CREATE VIEW Site_ReceiveView AS  SELECT Site.*, SiteReplicate.* FROM Site LEFT JOIN SiteReplicate ON SiteReplicate.sitePk = Site.siteUid ';
      _stmtList.add_11rb$(element_749);
      var element_750 = "CREATE OR REPLACE FUNCTION site_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO Site(siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt) VALUES (NEW.siteUid, NEW.sitePcsn, NEW.siteLcsn, NEW.siteLcb, NEW.siteLct, NEW.siteName, NEW.guestLogin, NEW.registrationAllowed, NEW.authSalt) ON CONFLICT (siteUid) DO UPDATE SET sitePcsn = EXCLUDED.sitePcsn, siteLcsn = EXCLUDED.siteLcsn, siteLcb = EXCLUDED.siteLcb, siteLct = EXCLUDED.siteLct, siteName = EXCLUDED.siteName, guestLogin = EXCLUDED.guestLogin, registrationAllowed = EXCLUDED.registrationAllowed, authSalt = EXCLUDED.authSalt; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_750);
      var element_751 = ' CREATE TRIGGER site_remote_insert_trig INSTEAD OF INSERT ON Site_ReceiveView FOR EACH ROW EXECUTE PROCEDURE site_remote_insert_fn() ';
      _stmtList.add_11rb$(element_751);
      var element_752 = ' CREATE TABLE IF NOT EXISTS LearnerGroupReplicate ( lgPk BIGINT NOT NULL, lgVersionId BIGINT NOT NULL DEFAULT 0, lgDestination BIGINT NOT NULL, lgPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (lgPk, lgDestination)) ';
      _stmtList.add_11rb$(element_752);
      var element_753 = ' CREATE INDEX index_LearnerGroupReplicate_lgPk_lgDestination_lgVersionId ON LearnerGroupReplicate (lgPk, lgDestination, lgVersionId) ';
      _stmtList.add_11rb$(element_753);
      var element_754 = ' CREATE INDEX index_LearnerGroupReplicate_lgDestination_lgPending ON LearnerGroupReplicate (lgDestination, lgPending) ';
      _stmtList.add_11rb$(element_754);
      var element_755 = ' CREATE OR REPLACE FUNCTION ch_upd_301_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (301, NEW.learnerGroupUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_755);
      var element_756 = ' CREATE TRIGGER ch_upd_301_trig AFTER UPDATE OR INSERT ON LearnerGroup FOR EACH ROW EXECUTE PROCEDURE ch_upd_301_fn(); ';
      _stmtList.add_11rb$(element_756);
      var element_757 = ' CREATE OR REPLACE FUNCTION ch_del_301_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (301, OLD.learnerGroupUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_757);
      var element_758 = ' CREATE TRIGGER ch_del_301_trig AFTER DELETE ON LearnerGroup FOR EACH ROW EXECUTE PROCEDURE ch_del_301_fn(); ';
      _stmtList.add_11rb$(element_758);
      var element_759 = 'CREATE VIEW LearnerGroup_ReceiveView AS  SELECT LearnerGroup.*, LearnerGroupReplicate.* FROM LearnerGroup LEFT JOIN LearnerGroupReplicate ON LearnerGroupReplicate.lgPk = LearnerGroup.learnerGroupUid ';
      _stmtList.add_11rb$(element_759);
      var element_760 = "CREATE OR REPLACE FUNCTION learnergroup_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO LearnerGroup(learnerGroupUid, learnerGroupName, learnerGroupDescription, learnerGroupActive, learnerGroupMCSN, learnerGroupCSN, learnerGroupLCB, learnerGroupLct) VALUES (NEW.learnerGroupUid, NEW.learnerGroupName, NEW.learnerGroupDescription, NEW.learnerGroupActive, NEW.learnerGroupMCSN, NEW.learnerGroupCSN, NEW.learnerGroupLCB, NEW.learnerGroupLct) ON CONFLICT (learnerGroupUid) DO UPDATE SET learnerGroupName = EXCLUDED.learnerGroupName, learnerGroupDescription = EXCLUDED.learnerGroupDescription, learnerGroupActive = EXCLUDED.learnerGroupActive, learnerGroupMCSN = EXCLUDED.learnerGroupMCSN, learnerGroupCSN = EXCLUDED.learnerGroupCSN, learnerGroupLCB = EXCLUDED.learnerGroupLCB, learnerGroupLct = EXCLUDED.learnerGroupLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_760);
      var element_761 = ' CREATE TRIGGER learnergroup_remote_insert_trig INSTEAD OF INSERT ON LearnerGroup_ReceiveView FOR EACH ROW EXECUTE PROCEDURE learnergroup_remote_insert_fn() ';
      _stmtList.add_11rb$(element_761);
      var element_762 = ' CREATE TABLE IF NOT EXISTS LearnerGroupMemberReplicate ( lgmPk BIGINT NOT NULL, lgmVersionId BIGINT NOT NULL DEFAULT 0, lgmDestination BIGINT NOT NULL, lgmPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (lgmPk, lgmDestination)) ';
      _stmtList.add_11rb$(element_762);
      var element_763 = ' CREATE INDEX index_LearnerGroupMemberReplicate_lgmPk_lgmDestination_lgmVersionId ON LearnerGroupMemberReplicate (lgmPk, lgmDestination, lgmVersionId) ';
      _stmtList.add_11rb$(element_763);
      var element_764 = ' CREATE INDEX index_LearnerGroupMemberReplicate_lgmDestination_lgmPending ON LearnerGroupMemberReplicate (lgmDestination, lgmPending) ';
      _stmtList.add_11rb$(element_764);
      var element_765 = ' CREATE OR REPLACE FUNCTION ch_upd_300_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (300, NEW.learnerGroupMemberUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_765);
      var element_766 = ' CREATE TRIGGER ch_upd_300_trig AFTER UPDATE OR INSERT ON LearnerGroupMember FOR EACH ROW EXECUTE PROCEDURE ch_upd_300_fn(); ';
      _stmtList.add_11rb$(element_766);
      var element_767 = ' CREATE OR REPLACE FUNCTION ch_del_300_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (300, OLD.learnerGroupMemberUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_767);
      var element_768 = ' CREATE TRIGGER ch_del_300_trig AFTER DELETE ON LearnerGroupMember FOR EACH ROW EXECUTE PROCEDURE ch_del_300_fn(); ';
      _stmtList.add_11rb$(element_768);
      var element_769 = 'CREATE VIEW LearnerGroupMember_ReceiveView AS  SELECT LearnerGroupMember.*, LearnerGroupMemberReplicate.* FROM LearnerGroupMember LEFT JOIN LearnerGroupMemberReplicate ON LearnerGroupMemberReplicate.lgmPk = LearnerGroupMember.learnerGroupMemberUid ';
      _stmtList.add_11rb$(element_769);
      var element_770 = "CREATE OR REPLACE FUNCTION learnergroupmember_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO LearnerGroupMember(learnerGroupMemberUid, learnerGroupMemberPersonUid, learnerGroupMemberLgUid, learnerGroupMemberRole, learnerGroupMemberActive, learnerGroupMemberMCSN, learnerGroupMemberCSN, learnerGroupMemberLCB, learnerGroupMemberLct) VALUES (NEW.learnerGroupMemberUid, NEW.learnerGroupMemberPersonUid, NEW.learnerGroupMemberLgUid, NEW.learnerGroupMemberRole, NEW.learnerGroupMemberActive, NEW.learnerGroupMemberMCSN, NEW.learnerGroupMemberCSN, NEW.learnerGroupMemberLCB, NEW.learnerGroupMemberLct) ON CONFLICT (learnerGroupMemberUid) DO UPDATE SET learnerGroupMemberPersonUid = EXCLUDED.learnerGroupMemberPersonUid, learnerGroupMemberLgUid = EXCLUDED.learnerGroupMemberLgUid, learnerGroupMemberRole = EXCLUDED.learnerGroupMemberRole, learnerGroupMemberActive = EXCLUDED.learnerGroupMemberActive, learnerGroupMemberMCSN = EXCLUDED.learnerGroupMemberMCSN, learnerGroupMemberCSN = EXCLUDED.learnerGroupMemberCSN, learnerGroupMemberLCB = EXCLUDED.learnerGroupMemberLCB, learnerGroupMemberLct = EXCLUDED.learnerGroupMemberLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_770);
      var element_771 = ' CREATE TRIGGER learnergroupmember_remote_insert_trig INSTEAD OF INSERT ON LearnerGroupMember_ReceiveView FOR EACH ROW EXECUTE PROCEDURE learnergroupmember_remote_insert_fn() ';
      _stmtList.add_11rb$(element_771);
      var element_772 = ' CREATE TABLE IF NOT EXISTS GroupLearningSessionReplicate ( glsPk BIGINT NOT NULL, glsVersionId BIGINT NOT NULL DEFAULT 0, glsDestination BIGINT NOT NULL, glsPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (glsPk, glsDestination)) ';
      _stmtList.add_11rb$(element_772);
      var element_773 = ' CREATE INDEX index_GroupLearningSessionReplicate_glsPk_glsDestination_glsVersionId ON GroupLearningSessionReplicate (glsPk, glsDestination, glsVersionId) ';
      _stmtList.add_11rb$(element_773);
      var element_774 = ' CREATE INDEX index_GroupLearningSessionReplicate_glsDestination_glsPending ON GroupLearningSessionReplicate (glsDestination, glsPending) ';
      _stmtList.add_11rb$(element_774);
      var element_775 = ' CREATE OR REPLACE FUNCTION ch_upd_302_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (302, NEW.groupLearningSessionUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_775);
      var element_776 = ' CREATE TRIGGER ch_upd_302_trig AFTER UPDATE OR INSERT ON GroupLearningSession FOR EACH ROW EXECUTE PROCEDURE ch_upd_302_fn(); ';
      _stmtList.add_11rb$(element_776);
      var element_777 = ' CREATE OR REPLACE FUNCTION ch_del_302_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (302, OLD.groupLearningSessionUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_777);
      var element_778 = ' CREATE TRIGGER ch_del_302_trig AFTER DELETE ON GroupLearningSession FOR EACH ROW EXECUTE PROCEDURE ch_del_302_fn(); ';
      _stmtList.add_11rb$(element_778);
      var element_779 = 'CREATE VIEW GroupLearningSession_ReceiveView AS  SELECT GroupLearningSession.*, GroupLearningSessionReplicate.* FROM GroupLearningSession LEFT JOIN GroupLearningSessionReplicate ON GroupLearningSessionReplicate.glsPk = GroupLearningSession.groupLearningSessionUid ';
      _stmtList.add_11rb$(element_779);
      var element_780 = "CREATE OR REPLACE FUNCTION grouplearningsession_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO GroupLearningSession(groupLearningSessionUid, groupLearningSessionContentUid, groupLearningSessionLearnerGroupUid, groupLearningSessionInactive, groupLearningSessionMCSN, groupLearningSessionCSN, groupLearningSessionLCB, groupLearningSessionLct) VALUES (NEW.groupLearningSessionUid, NEW.groupLearningSessionContentUid, NEW.groupLearningSessionLearnerGroupUid, NEW.groupLearningSessionInactive, NEW.groupLearningSessionMCSN, NEW.groupLearningSessionCSN, NEW.groupLearningSessionLCB, NEW.groupLearningSessionLct) ON CONFLICT (groupLearningSessionUid) DO UPDATE SET groupLearningSessionContentUid = EXCLUDED.groupLearningSessionContentUid, groupLearningSessionLearnerGroupUid = EXCLUDED.groupLearningSessionLearnerGroupUid, groupLearningSessionInactive = EXCLUDED.groupLearningSessionInactive, groupLearningSessionMCSN = EXCLUDED.groupLearningSessionMCSN, groupLearningSessionCSN = EXCLUDED.groupLearningSessionCSN, groupLearningSessionLCB = EXCLUDED.groupLearningSessionLCB, groupLearningSessionLct = EXCLUDED.groupLearningSessionLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_780);
      var element_781 = ' CREATE TRIGGER grouplearningsession_remote_insert_trig INSTEAD OF INSERT ON GroupLearningSession_ReceiveView FOR EACH ROW EXECUTE PROCEDURE grouplearningsession_remote_insert_fn() ';
      _stmtList.add_11rb$(element_781);
      var element_782 = ' CREATE TABLE IF NOT EXISTS SiteTermsReplicate ( stPk BIGINT NOT NULL, stVersionId BIGINT NOT NULL DEFAULT 0, stDestination BIGINT NOT NULL, stPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (stPk, stDestination)) ';
      _stmtList.add_11rb$(element_782);
      var element_783 = ' CREATE INDEX index_SiteTermsReplicate_stPk_stDestination_stVersionId ON SiteTermsReplicate (stPk, stDestination, stVersionId) ';
      _stmtList.add_11rb$(element_783);
      var element_784 = ' CREATE INDEX index_SiteTermsReplicate_stDestination_stPending ON SiteTermsReplicate (stDestination, stPending) ';
      _stmtList.add_11rb$(element_784);
      var element_785 = ' CREATE OR REPLACE FUNCTION ch_upd_272_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (272, NEW.sTermsUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_785);
      var element_786 = ' CREATE TRIGGER ch_upd_272_trig AFTER UPDATE OR INSERT ON SiteTerms FOR EACH ROW EXECUTE PROCEDURE ch_upd_272_fn(); ';
      _stmtList.add_11rb$(element_786);
      var element_787 = ' CREATE OR REPLACE FUNCTION ch_del_272_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (272, OLD.sTermsUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_787);
      var element_788 = ' CREATE TRIGGER ch_del_272_trig AFTER DELETE ON SiteTerms FOR EACH ROW EXECUTE PROCEDURE ch_del_272_fn(); ';
      _stmtList.add_11rb$(element_788);
      var element_789 = 'CREATE VIEW SiteTerms_ReceiveView AS  SELECT SiteTerms.*, SiteTermsReplicate.* FROM SiteTerms LEFT JOIN SiteTermsReplicate ON SiteTermsReplicate.stPk = SiteTerms.sTermsUid ';
      _stmtList.add_11rb$(element_789);
      var element_790 = "CREATE OR REPLACE FUNCTION siteterms_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO SiteTerms(sTermsUid, termsHtml, sTermsLang, sTermsLangUid, sTermsActive, sTermsLastChangedBy, sTermsPrimaryCsn, sTermsLocalCsn, sTermsLct) VALUES (NEW.sTermsUid, NEW.termsHtml, NEW.sTermsLang, NEW.sTermsLangUid, NEW.sTermsActive, NEW.sTermsLastChangedBy, NEW.sTermsPrimaryCsn, NEW.sTermsLocalCsn, NEW.sTermsLct) ON CONFLICT (sTermsUid) DO UPDATE SET termsHtml = EXCLUDED.termsHtml, sTermsLang = EXCLUDED.sTermsLang, sTermsLangUid = EXCLUDED.sTermsLangUid, sTermsActive = EXCLUDED.sTermsActive, sTermsLastChangedBy = EXCLUDED.sTermsLastChangedBy, sTermsPrimaryCsn = EXCLUDED.sTermsPrimaryCsn, sTermsLocalCsn = EXCLUDED.sTermsLocalCsn, sTermsLct = EXCLUDED.sTermsLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_790);
      var element_791 = ' CREATE TRIGGER siteterms_remote_insert_trig INSTEAD OF INSERT ON SiteTerms_ReceiveView FOR EACH ROW EXECUTE PROCEDURE siteterms_remote_insert_fn() ';
      _stmtList.add_11rb$(element_791);
      var element_792 = ' CREATE TABLE IF NOT EXISTS ClazzContentJoinReplicate ( ccjPk BIGINT NOT NULL, ccjVersionId BIGINT NOT NULL DEFAULT 0, ccjDestination BIGINT NOT NULL, ccjPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (ccjPk, ccjDestination)) ';
      _stmtList.add_11rb$(element_792);
      var element_793 = ' CREATE INDEX index_ClazzContentJoinReplicate_ccjPk_ccjDestination_ccjVersionId ON ClazzContentJoinReplicate (ccjPk, ccjDestination, ccjVersionId) ';
      _stmtList.add_11rb$(element_793);
      var element_794 = ' CREATE INDEX index_ClazzContentJoinReplicate_ccjDestination_ccjPending ON ClazzContentJoinReplicate (ccjDestination, ccjPending) ';
      _stmtList.add_11rb$(element_794);
      var element_795 = ' CREATE OR REPLACE FUNCTION ch_upd_134_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (134, NEW.ccjUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_795);
      var element_796 = ' CREATE TRIGGER ch_upd_134_trig AFTER UPDATE OR INSERT ON ClazzContentJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_134_fn(); ';
      _stmtList.add_11rb$(element_796);
      var element_797 = ' CREATE OR REPLACE FUNCTION ch_del_134_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (134, OLD.ccjUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_797);
      var element_798 = ' CREATE TRIGGER ch_del_134_trig AFTER DELETE ON ClazzContentJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_134_fn(); ';
      _stmtList.add_11rb$(element_798);
      var element_799 = 'CREATE VIEW ClazzContentJoin_ReceiveView AS  SELECT ClazzContentJoin.*, ClazzContentJoinReplicate.* FROM ClazzContentJoin LEFT JOIN ClazzContentJoinReplicate ON ClazzContentJoinReplicate.ccjPk = ClazzContentJoin.ccjUid ';
      _stmtList.add_11rb$(element_799);
      var element_800 = "CREATE OR REPLACE FUNCTION clazzcontentjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzContentJoin(ccjUid, ccjContentEntryUid, ccjClazzUid, ccjActive, ccjLocalChangeSeqNum, ccjMasterChangeSeqNum, ccjLastChangedBy, ccjLct) VALUES (NEW.ccjUid, NEW.ccjContentEntryUid, NEW.ccjClazzUid, NEW.ccjActive, NEW.ccjLocalChangeSeqNum, NEW.ccjMasterChangeSeqNum, NEW.ccjLastChangedBy, NEW.ccjLct) ON CONFLICT (ccjUid) DO UPDATE SET ccjContentEntryUid = EXCLUDED.ccjContentEntryUid, ccjClazzUid = EXCLUDED.ccjClazzUid, ccjActive = EXCLUDED.ccjActive, ccjLocalChangeSeqNum = EXCLUDED.ccjLocalChangeSeqNum, ccjMasterChangeSeqNum = EXCLUDED.ccjMasterChangeSeqNum, ccjLastChangedBy = EXCLUDED.ccjLastChangedBy, ccjLct = EXCLUDED.ccjLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_800);
      var element_801 = ' CREATE TRIGGER clazzcontentjoin_remote_insert_trig INSTEAD OF INSERT ON ClazzContentJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzcontentjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_801);
      var element_802 = ' CREATE TABLE IF NOT EXISTS PersonParentJoinReplicate ( ppjPk BIGINT NOT NULL, ppjVersionId BIGINT NOT NULL DEFAULT 0, ppjDestination BIGINT NOT NULL, ppjPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (ppjPk, ppjDestination)) ';
      _stmtList.add_11rb$(element_802);
      var element_803 = ' CREATE INDEX index_PersonParentJoinReplicate_ppjPk_ppjDestination_ppjVersionId ON PersonParentJoinReplicate (ppjPk, ppjDestination, ppjVersionId) ';
      _stmtList.add_11rb$(element_803);
      var element_804 = ' CREATE INDEX index_PersonParentJoinReplicate_ppjDestination_ppjPending ON PersonParentJoinReplicate (ppjDestination, ppjPending) ';
      _stmtList.add_11rb$(element_804);
      var element_805 = ' CREATE OR REPLACE FUNCTION ch_upd_512_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (512, NEW.ppjUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_805);
      var element_806 = ' CREATE TRIGGER ch_upd_512_trig AFTER UPDATE OR INSERT ON PersonParentJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_512_fn(); ';
      _stmtList.add_11rb$(element_806);
      var element_807 = ' CREATE OR REPLACE FUNCTION ch_del_512_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (512, OLD.ppjUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_807);
      var element_808 = ' CREATE TRIGGER ch_del_512_trig AFTER DELETE ON PersonParentJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_512_fn(); ';
      _stmtList.add_11rb$(element_808);
      var element_809 = 'CREATE VIEW PersonParentJoin_ReceiveView AS  SELECT PersonParentJoin.*, PersonParentJoinReplicate.* FROM PersonParentJoin LEFT JOIN PersonParentJoinReplicate ON PersonParentJoinReplicate.ppjPk = PersonParentJoin.ppjUid ';
      _stmtList.add_11rb$(element_809);
      var element_810 = "CREATE OR REPLACE FUNCTION personparentjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO PersonParentJoin(ppjUid, ppjPcsn, ppjLcsn, ppjLcb, ppjLct, ppjParentPersonUid, ppjMinorPersonUid, ppjRelationship, ppjEmail, ppjPhone, ppjInactive, ppjStatus, ppjApprovalTiemstamp, ppjApprovalIpAddr) VALUES (NEW.ppjUid, NEW.ppjPcsn, NEW.ppjLcsn, NEW.ppjLcb, NEW.ppjLct, NEW.ppjParentPersonUid, NEW.ppjMinorPersonUid, NEW.ppjRelationship, NEW.ppjEmail, NEW.ppjPhone, NEW.ppjInactive, NEW.ppjStatus, NEW.ppjApprovalTiemstamp, NEW.ppjApprovalIpAddr) ON CONFLICT (ppjUid) DO UPDATE SET ppjPcsn = EXCLUDED.ppjPcsn, ppjLcsn = EXCLUDED.ppjLcsn, ppjLcb = EXCLUDED.ppjLcb, ppjLct = EXCLUDED.ppjLct, ppjParentPersonUid = EXCLUDED.ppjParentPersonUid, ppjMinorPersonUid = EXCLUDED.ppjMinorPersonUid, ppjRelationship = EXCLUDED.ppjRelationship, ppjEmail = EXCLUDED.ppjEmail, ppjPhone = EXCLUDED.ppjPhone, ppjInactive = EXCLUDED.ppjInactive, ppjStatus = EXCLUDED.ppjStatus, ppjApprovalTiemstamp = EXCLUDED.ppjApprovalTiemstamp, ppjApprovalIpAddr = EXCLUDED.ppjApprovalIpAddr ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_810);
      var element_811 = ' CREATE TRIGGER personparentjoin_remote_insert_trig INSTEAD OF INSERT ON PersonParentJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE personparentjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_811);
      var element_812 = ' CREATE TABLE IF NOT EXISTS ScopedGrantReplicate ( sgPk BIGINT NOT NULL, sgVersionId BIGINT NOT NULL DEFAULT 0, sgDestination BIGINT NOT NULL, sgPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (sgPk, sgDestination)) ';
      _stmtList.add_11rb$(element_812);
      var element_813 = ' CREATE INDEX index_ScopedGrantReplicate_sgPk_sgDestination_sgVersionId ON ScopedGrantReplicate (sgPk, sgDestination, sgVersionId) ';
      _stmtList.add_11rb$(element_813);
      var element_814 = ' CREATE INDEX index_ScopedGrantReplicate_sgDestination_sgPending ON ScopedGrantReplicate (sgDestination, sgPending) ';
      _stmtList.add_11rb$(element_814);
      var element_815 = ' CREATE OR REPLACE FUNCTION ch_upd_48_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (48, NEW.sgUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_815);
      var element_816 = ' CREATE TRIGGER ch_upd_48_trig AFTER UPDATE OR INSERT ON ScopedGrant FOR EACH ROW EXECUTE PROCEDURE ch_upd_48_fn(); ';
      _stmtList.add_11rb$(element_816);
      var element_817 = ' CREATE OR REPLACE FUNCTION ch_del_48_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (48, OLD.sgUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_817);
      var element_818 = ' CREATE TRIGGER ch_del_48_trig AFTER DELETE ON ScopedGrant FOR EACH ROW EXECUTE PROCEDURE ch_del_48_fn(); ';
      _stmtList.add_11rb$(element_818);
      var element_819 = 'CREATE VIEW ScopedGrant_ReceiveView AS  SELECT ScopedGrant.*, ScopedGrantReplicate.* FROM ScopedGrant LEFT JOIN ScopedGrantReplicate ON ScopedGrantReplicate.sgPk = ScopedGrant.sgUid ';
      _stmtList.add_11rb$(element_819);
      var element_820 = "CREATE OR REPLACE FUNCTION sg_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ScopedGrant(sgUid, sgPcsn, sgLcsn, sgLcb, sgLct, sgTableId, sgEntityUid, sgPermissions, sgGroupUid, sgIndex, sgFlags) VALUES (NEW.sgUid, NEW.sgPcsn, NEW.sgLcsn, NEW.sgLcb, NEW.sgLct, NEW.sgTableId, NEW.sgEntityUid, NEW.sgPermissions, NEW.sgGroupUid, NEW.sgIndex, NEW.sgFlags) ON CONFLICT(sgUid) DO UPDATE SET sgLct = EXCLUDED.sgLct, sgPermissions = EXCLUDED.sgPermissions ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_820);
      var element_821 = ' CREATE TRIGGER sg_remote_insert_trig INSTEAD OF INSERT ON ScopedGrant_ReceiveView FOR EACH ROW EXECUTE PROCEDURE sg_remote_insert_fn() ';
      _stmtList.add_11rb$(element_821);
      var element_822 = ' CREATE TABLE IF NOT EXISTS ErrorReportReplicate ( erPk BIGINT NOT NULL, erVersionId BIGINT NOT NULL DEFAULT 0, erDestination BIGINT NOT NULL, erPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (erPk, erDestination)) ';
      _stmtList.add_11rb$(element_822);
      var element_823 = ' CREATE INDEX index_ErrorReportReplicate_erPk_erDestination_erVersionId ON ErrorReportReplicate (erPk, erDestination, erVersionId) ';
      _stmtList.add_11rb$(element_823);
      var element_824 = ' CREATE INDEX index_ErrorReportReplicate_erDestination_erPending ON ErrorReportReplicate (erDestination, erPending) ';
      _stmtList.add_11rb$(element_824);
      var element_825 = ' CREATE OR REPLACE FUNCTION ch_upd_419_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (419, NEW.errUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_825);
      var element_826 = ' CREATE TRIGGER ch_upd_419_trig AFTER UPDATE OR INSERT ON ErrorReport FOR EACH ROW EXECUTE PROCEDURE ch_upd_419_fn(); ';
      _stmtList.add_11rb$(element_826);
      var element_827 = ' CREATE OR REPLACE FUNCTION ch_del_419_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (419, OLD.errUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_827);
      var element_828 = ' CREATE TRIGGER ch_del_419_trig AFTER DELETE ON ErrorReport FOR EACH ROW EXECUTE PROCEDURE ch_del_419_fn(); ';
      _stmtList.add_11rb$(element_828);
      var element_829 = 'CREATE VIEW ErrorReport_ReceiveView AS  SELECT ErrorReport.*, ErrorReportReplicate.* FROM ErrorReport LEFT JOIN ErrorReportReplicate ON ErrorReportReplicate.erPk = ErrorReport.errUid ';
      _stmtList.add_11rb$(element_829);
      var element_830 = "CREATE OR REPLACE FUNCTION errorreport_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ErrorReport(errUid, errPcsn, errLcsn, errLcb, errLct, severity, timestamp, presenterUri, appVersion, versionCode, errorCode, operatingSys, osVersion, stackTrace, message) VALUES (NEW.errUid, NEW.errPcsn, NEW.errLcsn, NEW.errLcb, NEW.errLct, NEW.severity, NEW.timestamp, NEW.presenterUri, NEW.appVersion, NEW.versionCode, NEW.errorCode, NEW.operatingSys, NEW.osVersion, NEW.stackTrace, NEW.message) ON CONFLICT (errUid) DO UPDATE SET errPcsn = EXCLUDED.errPcsn, errLcsn = EXCLUDED.errLcsn, errLcb = EXCLUDED.errLcb, errLct = EXCLUDED.errLct, severity = EXCLUDED.severity, timestamp = EXCLUDED.timestamp, presenterUri = EXCLUDED.presenterUri, appVersion = EXCLUDED.appVersion, versionCode = EXCLUDED.versionCode, errorCode = EXCLUDED.errorCode, operatingSys = EXCLUDED.operatingSys, osVersion = EXCLUDED.osVersion, stackTrace = EXCLUDED.stackTrace, message = EXCLUDED.message ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_830);
      var element_831 = ' CREATE TRIGGER errorreport_remote_insert_trig INSTEAD OF INSERT ON ErrorReport_ReceiveView FOR EACH ROW EXECUTE PROCEDURE errorreport_remote_insert_fn() ';
      _stmtList.add_11rb$(element_831);
      var element_832 = ' CREATE TABLE IF NOT EXISTS ClazzAssignmentReplicate ( caPk BIGINT NOT NULL, caVersionId BIGINT NOT NULL DEFAULT 0, caDestination BIGINT NOT NULL, caPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (caPk, caDestination)) ';
      _stmtList.add_11rb$(element_832);
      var element_833 = ' CREATE INDEX index_ClazzAssignmentReplicate_caPk_caDestination_caVersionId ON ClazzAssignmentReplicate (caPk, caDestination, caVersionId) ';
      _stmtList.add_11rb$(element_833);
      var element_834 = ' CREATE INDEX index_ClazzAssignmentReplicate_caDestination_caPending ON ClazzAssignmentReplicate (caDestination, caPending) ';
      _stmtList.add_11rb$(element_834);
      var element_835 = ' CREATE OR REPLACE FUNCTION ch_upd_520_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (520, NEW.caUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_835);
      var element_836 = ' CREATE TRIGGER ch_upd_520_trig AFTER UPDATE OR INSERT ON ClazzAssignment FOR EACH ROW EXECUTE PROCEDURE ch_upd_520_fn(); ';
      _stmtList.add_11rb$(element_836);
      var element_837 = ' CREATE OR REPLACE FUNCTION ch_del_520_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (520, OLD.caUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_837);
      var element_838 = ' CREATE TRIGGER ch_del_520_trig AFTER DELETE ON ClazzAssignment FOR EACH ROW EXECUTE PROCEDURE ch_del_520_fn(); ';
      _stmtList.add_11rb$(element_838);
      var element_839 = 'CREATE VIEW ClazzAssignment_ReceiveView AS  SELECT ClazzAssignment.*, ClazzAssignmentReplicate.* FROM ClazzAssignment LEFT JOIN ClazzAssignmentReplicate ON ClazzAssignmentReplicate.caPk = ClazzAssignment.caUid ';
      _stmtList.add_11rb$(element_839);
      var element_840 = "CREATE OR REPLACE FUNCTION clazzassignment_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzAssignment(caUid, caTitle, caDescription, caDeadlineDate, caStartDate, caLateSubmissionType, caLateSubmissionPenalty, caGracePeriodDate, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caClazzUid, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES (NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caDeadlineDate, NEW.caStartDate, NEW.caLateSubmissionType, NEW.caLateSubmissionPenalty, NEW.caGracePeriodDate, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caClazzUid, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) ON CONFLICT (caUid) DO UPDATE SET caTitle = EXCLUDED.caTitle, caDescription = EXCLUDED.caDescription, caDeadlineDate = EXCLUDED.caDeadlineDate, caStartDate = EXCLUDED.caStartDate, caLateSubmissionType = EXCLUDED.caLateSubmissionType, caLateSubmissionPenalty = EXCLUDED.caLateSubmissionPenalty, caGracePeriodDate = EXCLUDED.caGracePeriodDate, caActive = EXCLUDED.caActive, caClassCommentEnabled = EXCLUDED.caClassCommentEnabled, caPrivateCommentsEnabled = EXCLUDED.caPrivateCommentsEnabled, caClazzUid = EXCLUDED.caClazzUid, caLocalChangeSeqNum = EXCLUDED.caLocalChangeSeqNum, caMasterChangeSeqNum = EXCLUDED.caMasterChangeSeqNum, caLastChangedBy = EXCLUDED.caLastChangedBy, caLct = EXCLUDED.caLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_840);
      var element_841 = ' CREATE TRIGGER clazzassignment_remote_insert_trig INSTEAD OF INSERT ON ClazzAssignment_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzassignment_remote_insert_fn() ';
      _stmtList.add_11rb$(element_841);
      var element_842 = ' CREATE TABLE IF NOT EXISTS ClazzAssignmentContentJoinReplicate ( cacjPk BIGINT NOT NULL, cacjVersionId BIGINT NOT NULL DEFAULT 0, cacjDestination BIGINT NOT NULL, cacjPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (cacjPk, cacjDestination)) ';
      _stmtList.add_11rb$(element_842);
      var element_843 = ' CREATE INDEX index_ClazzAssignmentContentJoinReplicate_cacjPk_cacjDestination_cacjVersionId ON ClazzAssignmentContentJoinReplicate (cacjPk, cacjDestination, cacjVersionId) ';
      _stmtList.add_11rb$(element_843);
      var element_844 = ' CREATE INDEX index_ClazzAssignmentContentJoinReplicate_cacjDestination_cacjPending ON ClazzAssignmentContentJoinReplicate (cacjDestination, cacjPending) ';
      _stmtList.add_11rb$(element_844);
      var element_845 = ' CREATE OR REPLACE FUNCTION ch_upd_521_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (521, NEW.cacjUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_845);
      var element_846 = ' CREATE TRIGGER ch_upd_521_trig AFTER UPDATE OR INSERT ON ClazzAssignmentContentJoin FOR EACH ROW EXECUTE PROCEDURE ch_upd_521_fn(); ';
      _stmtList.add_11rb$(element_846);
      var element_847 = ' CREATE OR REPLACE FUNCTION ch_del_521_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (521, OLD.cacjUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_847);
      var element_848 = ' CREATE TRIGGER ch_del_521_trig AFTER DELETE ON ClazzAssignmentContentJoin FOR EACH ROW EXECUTE PROCEDURE ch_del_521_fn(); ';
      _stmtList.add_11rb$(element_848);
      var element_849 = 'CREATE VIEW ClazzAssignmentContentJoin_ReceiveView AS  SELECT ClazzAssignmentContentJoin.*, ClazzAssignmentContentJoinReplicate.* FROM ClazzAssignmentContentJoin LEFT JOIN ClazzAssignmentContentJoinReplicate ON ClazzAssignmentContentJoinReplicate.cacjPk = ClazzAssignmentContentJoin.cacjUid ';
      _stmtList.add_11rb$(element_849);
      var element_850 = "CREATE OR REPLACE FUNCTION clazzassignmentcontentjoin_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ClazzAssignmentContentJoin(cacjUid, cacjContentUid, cacjAssignmentUid, cacjActive, cacjMCSN, cacjLCSN, cacjLCB, cacjLct) VALUES (NEW.cacjUid, NEW.cacjContentUid, NEW.cacjAssignmentUid, NEW.cacjActive, NEW.cacjMCSN, NEW.cacjLCSN, NEW.cacjLCB, NEW.cacjLct) ON CONFLICT (cacjUid) DO UPDATE SET cacjContentUid = EXCLUDED.cacjContentUid, cacjAssignmentUid = EXCLUDED.cacjAssignmentUid, cacjActive = EXCLUDED.cacjActive, cacjMCSN = EXCLUDED.cacjMCSN, cacjLCSN = EXCLUDED.cacjLCSN, cacjLCB = EXCLUDED.cacjLCB, cacjLct = EXCLUDED.cacjLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_850);
      var element_851 = ' CREATE TRIGGER clazzassignmentcontentjoin_remote_insert_trig INSTEAD OF INSERT ON ClazzAssignmentContentJoin_ReceiveView FOR EACH ROW EXECUTE PROCEDURE clazzassignmentcontentjoin_remote_insert_fn() ';
      _stmtList.add_11rb$(element_851);
      var element_852 = ' CREATE TABLE IF NOT EXISTS PersonAuth2Replicate ( paPk BIGINT NOT NULL, paVersionId BIGINT NOT NULL DEFAULT 0, paDestination BIGINT NOT NULL, paPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (paPk, paDestination)) ';
      _stmtList.add_11rb$(element_852);
      var element_853 = ' CREATE INDEX index_PersonAuth2Replicate_paPk_paDestination_paVersionId ON PersonAuth2Replicate (paPk, paDestination, paVersionId) ';
      _stmtList.add_11rb$(element_853);
      var element_854 = ' CREATE INDEX index_PersonAuth2Replicate_paDestination_paPending ON PersonAuth2Replicate (paDestination, paPending) ';
      _stmtList.add_11rb$(element_854);
      var element_855 = ' CREATE OR REPLACE FUNCTION ch_upd_678_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (678, NEW.pauthUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_855);
      var element_856 = ' CREATE TRIGGER ch_upd_678_trig AFTER UPDATE OR INSERT ON PersonAuth2 FOR EACH ROW EXECUTE PROCEDURE ch_upd_678_fn(); ';
      _stmtList.add_11rb$(element_856);
      var element_857 = ' CREATE OR REPLACE FUNCTION ch_del_678_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (678, OLD.pauthUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_857);
      var element_858 = ' CREATE TRIGGER ch_del_678_trig AFTER DELETE ON PersonAuth2 FOR EACH ROW EXECUTE PROCEDURE ch_del_678_fn(); ';
      _stmtList.add_11rb$(element_858);
      var element_859 = 'CREATE VIEW PersonAuth2_ReceiveView AS  SELECT PersonAuth2.*, PersonAuth2Replicate.* FROM PersonAuth2 LEFT JOIN PersonAuth2Replicate ON PersonAuth2Replicate.paPk = PersonAuth2.pauthUid ';
      _stmtList.add_11rb$(element_859);
      var element_860 = "CREATE OR REPLACE FUNCTION personauth2_remote_insert_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO PersonAuth2(pauthUid, pauthMechanism, pauthAuth, pauthLcsn, pauthPcsn, pauthLcb, pauthLct) VALUES (NEW.pauthUid, NEW.pauthMechanism, NEW.pauthAuth, NEW.pauthLcsn, NEW.pauthPcsn, NEW.pauthLcb, NEW.pauthLct) ON CONFLICT (pauthUid) DO UPDATE SET pauthMechanism = EXCLUDED.pauthMechanism, pauthAuth = EXCLUDED.pauthAuth, pauthLcsn = EXCLUDED.pauthLcsn, pauthPcsn = EXCLUDED.pauthPcsn, pauthLcb = EXCLUDED.pauthLcb, pauthLct = EXCLUDED.pauthLct ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_860);
      var element_861 = ' CREATE TRIGGER personauth2_remote_insert_trig INSTEAD OF INSERT ON PersonAuth2_ReceiveView FOR EACH ROW EXECUTE PROCEDURE personauth2_remote_insert_fn() ';
      _stmtList.add_11rb$(element_861);
      var element_862 = ' CREATE TABLE IF NOT EXISTS UserSessionReplicate ( usPk BIGINT NOT NULL, usVersionId BIGINT NOT NULL DEFAULT 0, usDestination BIGINT NOT NULL, usPending BOOL NOT NULL DEFAULT true, PRIMARY KEY (usPk, usDestination)) ';
      _stmtList.add_11rb$(element_862);
      var element_863 = ' CREATE INDEX index_UserSessionReplicate_usPk_usDestination_usVersionId ON UserSessionReplicate (usPk, usDestination, usVersionId) ';
      _stmtList.add_11rb$(element_863);
      var element_864 = ' CREATE INDEX index_UserSessionReplicate_usDestination_usPending ON UserSessionReplicate (usDestination, usPending) ';
      _stmtList.add_11rb$(element_864);
      var element_865 = ' CREATE OR REPLACE FUNCTION ch_upd_679_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (679, NEW.usUid, 1) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 1; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_865);
      var element_866 = ' CREATE TRIGGER ch_upd_679_trig AFTER UPDATE OR INSERT ON UserSession FOR EACH ROW EXECUTE PROCEDURE ch_upd_679_fn(); ';
      _stmtList.add_11rb$(element_866);
      var element_867 = ' CREATE OR REPLACE FUNCTION ch_del_679_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) VALUES (679, OLD.usUid, 2) ON CONFLICT(chTableId, chEntityPk) DO UPDATE SET chType = 2; RETURN NULL; END $$ LANGUAGE plpgsql ';
      _stmtList.add_11rb$(element_867);
      var element_868 = ' CREATE TRIGGER ch_del_679_trig AFTER DELETE ON UserSession FOR EACH ROW EXECUTE PROCEDURE ch_del_679_fn(); ';
      _stmtList.add_11rb$(element_868);
      var element_869 = 'CREATE VIEW UserSession_ReceiveView AS  SELECT UserSession.*, UserSessionReplicate.* FROM UserSession LEFT JOIN UserSessionReplicate ON UserSessionReplicate.usPk = UserSession.usUid ';
      _stmtList.add_11rb$(element_869);
      var element_870 = "CREATE OR REPLACE FUNCTION usersession_remote_ins_fn() RETURNS TRIGGER AS $$ BEGIN INSERT INTO UserSession(usUid, usPcsn, usLcsn, usLcb, usLct, usPersonUid, usClientNodeId, usStartTime, usEndTime, usStatus, usReason, usAuth, usSessionType) VALUES (NEW.usUid, NEW.usPcsn, NEW.usLcsn, NEW.usLcb, NEW.usLct, NEW.usPersonUid, NEW.usClientNodeId, NEW.usStartTime, NEW.usEndTime, NEW.usStatus, NEW.usReason, NEW.usAuth, NEW.usSessionType) /*postgres ON CONFLICT (usUid) DO UPDATE SET usStatus = EXCLUDED.usStatus, usEndTime = EXCLUDED.usEndTime, usReason = EXCLUDED.usReason */ ; IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN RETURN NEW; ELSE RETURN OLD; END IF; END $$ LANGUAGE plpgsql";
      _stmtList.add_11rb$(element_870);
      var element_871 = ' CREATE TRIGGER usersession_remote_ins_trig INSTEAD OF INSERT ON UserSession_ReceiveView FOR EACH ROW EXECUTE PROCEDURE usersession_remote_ins_fn() ';
      _stmtList.add_11rb$(element_871);
    }
    execSqlBatch(db, copyToArray(_stmtList));
  }
  function UmAppDatabaseReplicationMigration91_92$lambda(db) {
    db.execSQL_61zpoe$('ALTER TABLE DoorNode ADD COLUMN rel INTEGER NOT NULL DEFAULT 2');
    db.execSQL_61zpoe$('ALTER TABLE Person ADD COLUMN personType INTEGER NOT NULL DEFAULT 0');
    db.execSQL_61zpoe$('DROP TABLE ChangeLog');
    db.execSQL_61zpoe$('DROP TABLE SyncResult');
    db.execSQL_61zpoe$('DROP TABLE TableSyncStatus');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzLog_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzLogAttendanceRecord_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Schedule_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS DateRange_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS HolidayCalendar_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Holiday_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ScheduledCheck_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS AuditLog_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS CustomField_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS CustomFieldValue_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS CustomFieldValueOption_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Person_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Clazz_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzEnrolment_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS LeavingReason_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS PersonCustomFieldValue_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentEntry_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentEntryContentCategoryJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentEntryParentChildJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentEntryRelatedEntryJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentCategorySchema_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContentCategory_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Language_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS LanguageVariant_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Role_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS EntityRole_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS PersonGroup_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS PersonGroupMember_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS PersonPicture_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Container_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS VerbEntity_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS XObjectEntity_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS StatementEntity_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ContextXObjectStatementJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS AgentEntity_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS StateEntity_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS StateContentEntity_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS XLangMapEntry_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS School_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS SchoolMember_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Comments_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Report_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS Site_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS LearnerGroup_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS LearnerGroupMember_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS GroupLearningSession_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS SiteTerms_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzContentJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS PersonParentJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ScopedGrant_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ErrorReport_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzAssignment_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS ClazzAssignmentContentJoin_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS PersonAuth2_trk');
    db.execSQL_61zpoe$('DROP TABLE IF EXISTS UserSession_trk');
    if (dbType(db) === 1) {
      dropOldSqliteTriggers(db);
      db.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ReplicationStatus (  tableId  INTEGER  NOT NULL , priority  INTEGER  NOT NULL , nodeId  INTEGER  NOT NULL , lastRemoteChangeTime  INTEGER  NOT NULL , lastFetchReplicationCompleteTime  INTEGER  NOT NULL , lastLocalChangeTime  INTEGER  NOT NULL , lastSendReplicationCompleteTime  INTEGER  NOT NULL , repStatusId  INTEGER  PRIMARY KEY  AUTOINCREMENT  NOT NULL )');
      db.execSQL_61zpoe$('CREATE UNIQUE INDEX table_node_idx ON ReplicationStatus (tableId, nodeId)');
      db.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ChangeLog (  chTableId  INTEGER  NOT NULL , chEntityPk  INTEGER  NOT NULL , chType  INTEGER  NOT NULL , PRIMARY KEY (chTableId, chEntityPk) )');
    } else {
      dropOldPostgresTriggers(db);
      dropOldPostgresFunctions(db);
      db.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ChangeLog (  chTableId  INTEGER  NOT NULL , chEntityPk  BIGINT  NOT NULL , chType  INTEGER  NOT NULL , PRIMARY KEY (chTableId, chEntityPk) )');
      db.execSQL_61zpoe$('CREATE TABLE IF NOT EXISTS ReplicationStatus (  tableId  INTEGER  NOT NULL , priority  INTEGER  NOT NULL , nodeId  BIGINT  NOT NULL , lastRemoteChangeTime  BIGINT  NOT NULL , lastFetchReplicationCompleteTime  BIGINT  NOT NULL , lastLocalChangeTime  BIGINT  NOT NULL , lastSendReplicationCompleteTime  BIGINT  NOT NULL , repStatusId  SERIAL  PRIMARY KEY  NOT NULL )');
      db.execSQL_61zpoe$('CREATE UNIQUE INDEX table_node_idx ON ReplicationStatus (tableId, nodeId)');
      db.execSQL_61zpoe$('ALTER TABLE DoorNode ALTER COLUMN nodeId TYPE BIGINT');
      db.execSQL_61zpoe$('ALTER TABLE SyncNode ALTER COLUMN nodeClientId TYPE BIGINT');
      db.execSQL_61zpoe$('ALTER TABLE UserSession ALTER COLUMN usClientNodeId TYPE BIGINT');
    }
    addReplicationEntities(db);
    return Unit;
  }
  var UmAppDatabaseReplicationMigration91_92;
  function AgentDao() {
  }
  AgentDao.prototype.getAgentByAnyId_t5gqrj$ = function (openId, mbox, account, homepage, sha1, callback$default) {
    if (openId === void 0)
      openId = '';
    if (mbox === void 0)
      mbox = '';
    if (account === void 0)
      account = '';
    if (homepage === void 0)
      homepage = '';
    if (sha1 === void 0)
      sha1 = '';
    return callback$default ? callback$default(openId, mbox, account, homepage, sha1) : this.getAgentByAnyId_t5gqrj$$default(openId, mbox, account, homepage, sha1);
  };
  AgentDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'AgentDao', interfaces: [BaseDao]};
  function BaseDao() {
  }
  BaseDao.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'BaseDao', interfaces: []};
  function ChatDao() {
  }
  ChatDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ChatDao', interfaces: [BaseDao]};
  function ChatMemberDao() {
  }
  ChatMemberDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ChatMemberDao', interfaces: [BaseDao]};
  function ClazzAssignmentContentJoinDao() {
    ClazzAssignmentContentJoinDao$Companion_getInstance();
  }
  function ClazzAssignmentContentJoinDao$Companion() {
    ClazzAssignmentContentJoinDao$Companion_instance = this;
    this.FINDBY_CLAZZ_ASSIGNMENT_UID = "\n                    SELECT ContentEntry.*, ContentEntryParentChildJoin.*, \n                            Container.*, \n                             COALESCE(ClazzAssignmentRollUp.cacheStudentScore,0) AS resultScore,\n                                           \n                             COALESCE(ClazzAssignmentRollUp.cacheMaxScore,0) AS resultMax,\n                                                         \n                             COALESCE(ClazzAssignmentRollUp.cacheProgress,0) AS progress,                            \n                            \n                             COALESCE(ClazzAssignmentRollUp.cacheContentComplete,'FALSE') AS contentComplete,\n                                 \n                             COALESCE(ClazzAssignmentRollUp.cacheSuccess,0) AS success,\n                             \n                             COALESCE(ClazzAssignmentRollUp.cachePenalty,0) AS penalty,\n                               \n                             COALESCE((CASE WHEN ClazzAssignmentRollUp.cacheContentComplete \n                                            THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                        \n                             0 as assignmentContentWeight,\n                             1 as totalContent\n                           \n                             \n                      FROM ClazzAssignmentContentJoin\n                            LEFT JOIN ContentEntry \n                            ON ContentEntry.contentEntryUid = cacjContentUid \n                            \n                            LEFT JOIN ContentEntryParentChildJoin \n                            ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                           \n                            LEFT JOIN ClazzAssignmentRollUp\n                            ON cacheContentEntryUid = ClazzAssignmentContentJoin.cacjContentUid\n                                AND cachePersonUid = :personUid\n                                AND cacheClazzAssignmentUid = :clazzAssignmentUid\n                                                        \n                            \n                            LEFT JOIN Container \n                            ON Container.containerUid = \n                                (SELECT containerUid \n                                   FROM Container \n                                  WHERE containerContentEntryUid =  ContentEntry.contentEntryUid \n                               ORDER BY cntLastModified DESC LIMIT 1)\n                               \n                    WHERE ClazzAssignmentContentJoin.cacjAssignmentUid = :clazzAssignmentUid\n                      AND ClazzAssignmentContentJoin.cacjActive\n                      AND NOT ContentEntry.ceInactive\n                      AND (ContentEntry.publik OR :personUid != 0)\n                      ORDER BY ContentEntry.title ASC , \n                               ContentEntryParentChildJoin.childIndex, ContentEntry.contentEntryUid\n                               ";
  }
  ClazzAssignmentContentJoinDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ClazzAssignmentContentJoinDao$Companion_instance = null;
  function ClazzAssignmentContentJoinDao$Companion_getInstance() {
    if (ClazzAssignmentContentJoinDao$Companion_instance === null) {
      new ClazzAssignmentContentJoinDao$Companion();
    }return ClazzAssignmentContentJoinDao$Companion_instance;
  }
  ClazzAssignmentContentJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzAssignmentContentJoinDao', interfaces: [BaseDao]};
  function ClazzAssignmentDao() {
    ClazzAssignmentDao$Companion_getInstance();
  }
  function Coroutine$deactivateByUids_ejltwb$_0($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$_0.prototype.constructor = Coroutine$deactivateByUids_ejltwb$_0;
  Coroutine$deactivateByUids_ejltwb$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateActiveByUid_zaz62j$(element, false, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ClazzAssignmentDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$_0(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function ClazzAssignmentDao$Companion() {
    ClazzAssignmentDao$Companion_instance = this;
    this.SUBMITTER_LIST_CTE = "\n            WITH SubmitterList (submitterId, name)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                       Person.firstNames || ' ' || Person.lastName AS name\n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caUid = :assignmentUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, name\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    :group || ' ' || CourseGroupMember.cgmGroupNumber AS name  \n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caUid = :assignmentUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, name\n            )\n        ";
    this.SORT_DEADLINE_ASC = 1;
    this.SORT_DEADLINE_DESC = 2;
    this.SORT_TITLE_ASC = 3;
    this.SORT_TITLE_DESC = 4;
    this.SORT_SCORE_ASC = 5;
    this.SORT_SCORE_DESC = 6;
    this.SORT_START_DATE_ASC = 7;
    this.SORT_START_DATE_DESC = 8;
  }
  ClazzAssignmentDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ClazzAssignmentDao$Companion_instance = null;
  function ClazzAssignmentDao$Companion_getInstance() {
    if (ClazzAssignmentDao$Companion_instance === null) {
      new ClazzAssignmentDao$Companion();
    }return ClazzAssignmentDao$Companion_instance;
  }
  ClazzAssignmentDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzAssignmentDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function ClazzAssignmentRollUpDao() {
  }
  ClazzAssignmentRollUpDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzAssignmentRollUpDao', interfaces: [BaseDao]};
  function ClazzContentJoinDao() {
  }
  ClazzContentJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzContentJoinDao', interfaces: [BaseDao]};
  function ClazzDao() {
    ClazzDao$Companion_getInstance();
  }
  function ClazzDao$Companion() {
    ClazzDao$Companion_instance = this;
    this.SORT_CLAZZNAME_ASC = 1;
    this.SORT_CLAZZNAME_DESC = 2;
    this.SORT_ATTENDANCE_ASC = 3;
    this.SORT_ATTENDANCE_DESC = 4;
    this.FILTER_ACTIVE_ONLY = 1;
    this.FILTER_CURRENTLY_ENROLLED = 5;
    this.FILTER_PAST_ENROLLMENTS = 6;
    this.SELECT_ACTIVE_CLAZZES_0 = 'SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1';
  }
  ClazzDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ClazzDao$Companion_instance = null;
  function ClazzDao$Companion_getInstance() {
    if (ClazzDao$Companion_instance === null) {
      new ClazzDao$Companion();
    }return ClazzDao$Companion_instance;
  }
  ClazzDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzDao', interfaces: [BaseDao]};
  function ClazzEnrolmentDao() {
    ClazzEnrolmentDao$Companion_getInstance();
  }
  function Coroutine$updateDateLeft_ejltwb$($this, clazzEnrolmentUidList_0, endDate_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$updateTime = void 0;
    this.local$tmp$ = void 0;
    this.local$clazzEnrolmentUidList = clazzEnrolmentUidList_0;
    this.local$endDate = endDate_0;
  }
  Coroutine$updateDateLeft_ejltwb$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$updateDateLeft_ejltwb$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$updateDateLeft_ejltwb$.prototype.constructor = Coroutine$updateDateLeft_ejltwb$;
  Coroutine$updateDateLeft_ejltwb$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$updateTime = systemTimeInMillis();
            this.local$tmp$ = this.local$clazzEnrolmentUidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateDateLeftByUid_b9bd0d$(element, this.local$endDate, this.local$updateTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ClazzEnrolmentDao.prototype.updateDateLeft_ejltwb$ = function (clazzEnrolmentUidList_0, endDate_0, continuation_0, suspended) {
    var instance = new Coroutine$updateDateLeft_ejltwb$(this, clazzEnrolmentUidList_0, endDate_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ClazzEnrolmentDao.prototype.getAllClazzEnrolledAtTimeAsync_6qtc6d$ = function (clazzUid, date, roleFilter, personUidFilter, continuation, callback$default) {
    if (personUidFilter === void 0)
      personUidFilter = L0;
    return callback$default ? callback$default(clazzUid, date, roleFilter, personUidFilter, continuation) : this.getAllClazzEnrolledAtTimeAsync_6qtc6d$$default(clazzUid, date, roleFilter, personUidFilter, continuation);
  };
  ClazzEnrolmentDao.prototype.findByClazzUidAndRole_i7yiqk$ = function (clazzUid, roleId, sortOrder, searchText, filter, accountPersonUid, currentTime, callback$default) {
    if (searchText === void 0)
      searchText = '%';
    return callback$default ? callback$default(clazzUid, roleId, sortOrder, searchText, filter, accountPersonUid, currentTime) : this.findByClazzUidAndRole_i7yiqk$$default(clazzUid, roleId, sortOrder, searchText, filter, accountPersonUid, currentTime);
  };
  function ClazzEnrolmentDao$Companion() {
    ClazzEnrolmentDao$Companion_instance = this;
    this.SORT_FIRST_NAME_ASC = 1;
    this.SORT_FIRST_NAME_DESC = 2;
    this.SORT_LAST_NAME_ASC = 3;
    this.SORT_LAST_NAME_DESC = 4;
    this.SORT_ATTENDANCE_ASC = 5;
    this.SORT_ATTENDANCE_DESC = 6;
    this.SORT_DATE_REGISTERED_ASC = 7;
    this.SORT_DATE_REGISTERED_DESC = 8;
    this.SORT_DATE_LEFT_ASC = 9;
    this.SORT_DATE_LEFT_DESC = 10;
    this.FILTER_ACTIVE_ONLY = 1;
  }
  ClazzEnrolmentDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ClazzEnrolmentDao$Companion_instance = null;
  function ClazzEnrolmentDao$Companion_getInstance() {
    if (ClazzEnrolmentDao$Companion_instance === null) {
      new ClazzEnrolmentDao$Companion();
    }return ClazzEnrolmentDao$Companion_instance;
  }
  ClazzEnrolmentDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzEnrolmentDao', interfaces: [BaseDao]};
  function ClazzLogAttendanceRecordDao() {
  }
  ClazzLogAttendanceRecordDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzLogAttendanceRecordDao', interfaces: [BaseDao]};
  function ClazzLogDao() {
  }
  ClazzLogDao.prototype.findByClazzUidWithinTimeRange_ttedgd$ = function (clazzUid, fromTime, toTime, excludeStatusFilter, limit, callback$default) {
    if (excludeStatusFilter === void 0)
      excludeStatusFilter = 0;
    if (limit === void 0)
      limit = 2147483647;
    return callback$default ? callback$default(clazzUid, fromTime, toTime, excludeStatusFilter, limit) : this.findByClazzUidWithinTimeRange_ttedgd$$default(clazzUid, fromTime, toTime, excludeStatusFilter, limit);
  };
  ClazzLogDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ClazzLogDao', interfaces: [BaseDao]};
  function CommentsDao() {
  }
  function Coroutine$deactivateByUids_ejltwb$_1($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$_1.prototype.constructor = Coroutine$deactivateByUids_ejltwb$_1;
  Coroutine$deactivateByUids_ejltwb$_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateInActiveByCommentUid_zaz62j$(element, true, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  CommentsDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$_1(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  CommentsDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CommentsDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function ConnectivityStatusDao() {
    this.conenctivityStatusObserver = new ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral(this);
  }
  function Coroutine$addConnectivityStatusRecord_cqw3wz$($this, state_0, wifiSsid_0, connectedOrConnecting_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$state = state_0;
    this.local$wifiSsid = wifiSsid_0;
    this.local$connectedOrConnecting = connectedOrConnecting_0;
  }
  Coroutine$addConnectivityStatusRecord_cqw3wz$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$addConnectivityStatusRecord_cqw3wz$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$addConnectivityStatusRecord_cqw3wz$.prototype.constructor = Coroutine$addConnectivityStatusRecord_cqw3wz$;
  Coroutine$addConnectivityStatusRecord_cqw3wz$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var connectivityStatus = new ConnectivityStatus();
            connectivityStatus.connectedOrConnecting = this.local$connectedOrConnecting;
            connectivityStatus.connectivityState = this.local$state;
            connectivityStatus.wifiSsid = this.local$wifiSsid;
            this.state_0 = 2;
            this.result_0 = this.$this.insertAsync_v0v7in$(connectivityStatus, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ConnectivityStatusDao.prototype.addConnectivityStatusRecord_cqw3wz$ = function (state_0, wifiSsid_0, connectedOrConnecting_0, continuation_0, suspended) {
    var instance = new Coroutine$addConnectivityStatusRecord_cqw3wz$(this, state_0, wifiSsid_0, connectedOrConnecting_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda(closure$connectivityStatusLive_0, this$ConnectivityStatusDao_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$connectivityStatusLive = closure$connectivityStatusLive_0;
    this.local$this$ConnectivityStatusDao = this$ConnectivityStatusDao_0;
  }
  Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda.prototype.constructor = Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda;
  Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$connectivityStatusLive.observeForever_jsfaok$(this.local$this$ConnectivityStatusDao.conenctivityStatusObserver), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ConnectivityStatusDao$commitLiveConnectivityStatus$lambda(closure$connectivityStatusLive_0, this$ConnectivityStatusDao_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ConnectivityStatusDao$commitLiveConnectivityStatus$lambda(closure$connectivityStatusLive_0, this$ConnectivityStatusDao_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ConnectivityStatusDao.prototype.commitLiveConnectivityStatus_oros3t$ = function (connectivityStatusLive) {
    launch(coroutines.GlobalScope, doorMainDispatcher(), void 0, ConnectivityStatusDao$commitLiveConnectivityStatus$lambda(connectivityStatusLive, this));
  };
  function ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral(this$ConnectivityStatusDao) {
    this.this$ConnectivityStatusDao = this$ConnectivityStatusDao;
  }
  function Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda(closure$t_0, this$ConnectivityStatusDao_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$t = closure$t_0;
    this.local$this$ConnectivityStatusDao = this$ConnectivityStatusDao_0;
  }
  Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda.prototype.constructor = Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda;
  Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$ConnectivityStatusDao.insertAsync_v0v7in$(this.local$closure$t, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda(closure$t_0, this$ConnectivityStatusDao_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda(closure$t_0, this$ConnectivityStatusDao_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral.prototype.onChanged_11rb$ = function (t) {
    launch(coroutines.GlobalScope, void 0, void 0, ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral$onChanged$lambda(t, this.this$ConnectivityStatusDao));
  };
  ConnectivityStatusDao$conenctivityStatusObserver$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [DoorObserver]};
  ConnectivityStatusDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ConnectivityStatusDao', interfaces: []};
  function ContainerDao() {
    ContainerDao$Companion_getInstance();
  }
  function ContainerDao$Companion() {
    ContainerDao$Companion_instance = this;
    this.CONTAINER_READY_WHERE_CLAUSE_0 = '\n            Container.fileSize > 0\n        ';
    this.FROM_CONTAINER_WHERE_MOST_RECENT_AND_READY_0 = '\n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        ';
    this.SELECT_MOST_RECENT_READY_CONTAINER_0 = '\n            SELECT Container.*\n            \n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        \n        ';
    this.UPDATE_SIZE_AND_NUM_ENTRIES_SQL_0 = '\n            UPDATE Container \n               SET cntNumEntries = COALESCE(\n                   (SELECT COUNT(*) \n                      FROM ContainerEntry \n                     WHERE ceContainerUid = Container.containerUid), 0),\n                   fileSize = COALESCE(\n                   (SELECT SUM(ContainerEntryFile.ceCompressedSize) AS totalSize \n                      FROM ContainerEntry\n                      JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid\n                     WHERE ContainerEntry.ceContainerUid = Container.containerUid), 0),\n                   cntLct = :changeTime   \n                     \n             WHERE containerUid = :containerUid\n        ';
  }
  ContainerDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ContainerDao$Companion_instance = null;
  function ContainerDao$Companion_getInstance() {
    if (ContainerDao$Companion_instance === null) {
      new ContainerDao$Companion();
    }return ContainerDao$Companion_instance;
  }
  ContainerDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContainerDao', interfaces: [BaseDao]};
  function ContainerETagDao() {
  }
  ContainerETagDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContainerETagDao', interfaces: [BaseDao]};
  function ContainerEntryDao() {
  }
  ContainerEntryDao.prototype.insertAndSetIds_oe4mvo$ = function (containerEntryList) {
    var tmp$;
    tmp$ = containerEntryList.iterator();
    while (tmp$.hasNext()) {
      var entry = tmp$.next();
      entry.ceUid = this.insert_11rb$(entry);
    }
  };
  ContainerEntryDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContainerEntryDao', interfaces: [BaseDao]};
  function ContainerEntryFileDao() {
    ContainerEntryFileDao$Companion_getInstance();
  }
  ContainerEntryFileDao.prototype.findEntriesByMd5SumsSafe_udy8vv$$default = function (md5Sums, maxListParamSize) {
    var queryFn = getCallableRef('findEntriesByMd5Sums', function ($receiver, p1) {
      return $receiver.findEntriesByMd5Sums_mhpeer$(p1);
    }.bind(null, this));
    var tmp$;
    if (maxListParamSize > 0) {
      var chunkedList = chunked(md5Sums, maxListParamSize);
      var mutableList = ArrayList_init_0();
      var tmp$_0;
      tmp$_0 = chunkedList.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        var $receiver = queryFn(element);
        var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
        var tmp$_1;
        tmp$_1 = $receiver.iterator();
        while (tmp$_1.hasNext()) {
          var item = tmp$_1.next();
          destination.add_11rb$(mutableList.add_11rb$(item));
        }
      }
      tmp$ = toList_0(mutableList);
    } else {
      tmp$ = queryFn(md5Sums);
    }
    return tmp$;
  };
  ContainerEntryFileDao.prototype.findEntriesByMd5SumsSafe_udy8vv$ = function (md5Sums, maxListParamSize, callback$default) {
    if (maxListParamSize === void 0)
      maxListParamSize = 90;
    return callback$default ? callback$default(md5Sums, maxListParamSize) : this.findEntriesByMd5SumsSafe_udy8vv$$default(md5Sums, maxListParamSize);
  };
  function Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$($this, md5Sums_0, maxListParamSize_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$mutableList = void 0;
    this.local$tmp$_0 = void 0;
    this.local$md5Sums = md5Sums_0;
    this.local$maxListParamSize = maxListParamSize_0;
  }
  Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$.prototype.constructor = Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$;
  Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$maxListParamSize > 0) {
              var chunkedList = chunked(this.local$md5Sums, this.local$maxListParamSize);
              this.local$mutableList = ArrayList_init_0();
              this.local$tmp$_0 = chunkedList.iterator();
              this.state_0 = 3;
              continue;
            } else {
              this.state_0 = 2;
              this.result_0 = this.$this.findEntriesByMd5SumsAsync_mhpeer$(this.local$md5Sums, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            this.state_0 = 6;
            continue;
          case 3:
            if (!this.local$tmp$_0.hasNext()) {
              this.state_0 = 5;
              continue;
            }
            var element = this.local$tmp$_0.next();
            this.state_0 = 4;
            this.result_0 = this.$this.findEntriesByMd5SumsAsync_mhpeer$(element, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            var $receiver = this.result_0;
            var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
            var tmp$;
            tmp$ = $receiver.iterator();
            while (tmp$.hasNext()) {
              var item = tmp$.next();
              destination.add_11rb$(this.local$mutableList.add_11rb$(item));
            }

            this.state_0 = 3;
            continue;
          case 5:
            this.local$tmp$ = toList_0(this.local$mutableList);
            this.state_0 = 6;
            continue;
          case 6:
            return this.local$tmp$;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ContainerEntryFileDao.prototype.findEntriesByMd5SumsSafeAsync_udy8vv$ = function (md5Sums_0, maxListParamSize_0, continuation_0, suspended) {
    var instance = new Coroutine$findEntriesByMd5SumsSafeAsync_udy8vv$(this, md5Sums_0, maxListParamSize_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ContainerEntryFileDao.prototype.findEntriesByMd5SumsSafeInternal_pp2qb4$_0 = wrapFunction(function () {
    var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
    var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
    var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
    return function (md5Sums, maxListParamSize, queryFn) {
      var tmp$;
      if (maxListParamSize > 0) {
        var chunkedList = chunked(md5Sums, maxListParamSize);
        var mutableList = ArrayList_init_0();
        var tmp$_0;
        tmp$_0 = chunkedList.iterator();
        while (tmp$_0.hasNext()) {
          var element = tmp$_0.next();
          var $receiver = queryFn(element);
          var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
          var tmp$_1;
          tmp$_1 = $receiver.iterator();
          while (tmp$_1.hasNext()) {
            var item = tmp$_1.next();
            destination.add_11rb$(mutableList.add_11rb$(item));
          }
        }
        tmp$ = toList_0(mutableList);
      } else {
        tmp$ = queryFn(md5Sums);
      }
      return tmp$;
    };
  });
  ContainerEntryFileDao.prototype.findEntriesByMd5SumsSafe_vgju6u$ = function (md5Sums, db) {
    var tmp$;
    if (dbType_0(db) === 1) {
      tmp$ = 90;
    } else {
      tmp$ = -1;
    }
    return this.findEntriesByMd5SumsSafe_udy8vv$(md5Sums, tmp$);
  };
  function Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default($this, md5Sums_0, maxListParamSize_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$destination = void 0;
    this.local$tmp$_0 = void 0;
    this.local$md5Sums = md5Sums_0;
    this.local$maxListParamSize = maxListParamSize_0;
  }
  Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default.prototype.constructor = Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default;
  Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$maxListParamSize > 0) {
              var $receiver = chunked(this.local$md5Sums, this.local$maxListParamSize);
              this.local$destination = ArrayList_init_0();
              this.local$tmp$_0 = $receiver.iterator();
              this.state_0 = 3;
              continue;
            } else {
              this.state_0 = 2;
              this.result_0 = this.$this.findExistingMd5SumsByMd5SumsAsync_mhpeer$(this.local$md5Sums, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            this.state_0 = 6;
            continue;
          case 3:
            if (!this.local$tmp$_0.hasNext()) {
              this.state_0 = 5;
              continue;
            }
            var element = this.local$tmp$_0.next();
            this.state_0 = 4;
            this.result_0 = this.$this.findExistingMd5SumsByMd5SumsAsync_mhpeer$(element, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            var list = this.result_0;
            addAll(this.local$destination, list);
            this.state_0 = 3;
            continue;
          case 5:
            this.local$tmp$ = this.local$destination;
            this.state_0 = 6;
            continue;
          case 6:
            return this.local$tmp$;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ContainerEntryFileDao.prototype.findExistingMd5SumsByMd5SumsSafe_udy8vv$$default = function (md5Sums_0, maxListParamSize_0, continuation_0, suspended) {
    var instance = new Coroutine$findExistingMd5SumsByMd5SumsSafe_udy8vv$$default(this, md5Sums_0, maxListParamSize_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ContainerEntryFileDao.prototype.findExistingMd5SumsByMd5SumsSafe_udy8vv$ = function (md5Sums, maxListParamSize, continuation, callback$default) {
    if (maxListParamSize === void 0)
      maxListParamSize = 90;
    return callback$default ? callback$default(md5Sums, maxListParamSize, continuation) : this.findExistingMd5SumsByMd5SumsSafe_udy8vv$$default(md5Sums, maxListParamSize, continuation);
  };
  function ContainerEntryFileDao$Companion() {
    ContainerEntryFileDao$Companion_instance = this;
    this.ENDPOINT_CONCATENATEDFILES = 'ConcatenatedContainerFiles';
    this.ENDPOINT_CONCATENATEDFILES2 = 'ConcatenatedContainerFiles2';
  }
  ContainerEntryFileDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ContainerEntryFileDao$Companion_instance = null;
  function ContainerEntryFileDao$Companion_getInstance() {
    if (ContainerEntryFileDao$Companion_instance === null) {
      new ContainerEntryFileDao$Companion();
    }return ContainerEntryFileDao$Companion_instance;
  }
  ContainerEntryFileDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContainerEntryFileDao', interfaces: [BaseDao]};
  function ContainerImportJobDao() {
  }
  ContainerImportJobDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContainerImportJobDao', interfaces: [BaseDao]};
  function ContentCategoryDao() {
  }
  ContentCategoryDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentCategoryDao', interfaces: [BaseDao]};
  function ContentCategorySchemaDao() {
  }
  ContentCategorySchemaDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentCategorySchemaDao', interfaces: [BaseDao]};
  function ContentEntryContentCategoryJoinDao() {
  }
  ContentEntryContentCategoryJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentEntryContentCategoryJoinDao', interfaces: [BaseDao]};
  function ContentEntryDao() {
    ContentEntryDao$Companion_getInstance();
  }
  function ContentEntryDao$Companion() {
    ContentEntryDao$Companion_instance = this;
    this.PLUGIN_ID_DOWNLOAD = 10;
    this.PLUGIN_ID_DELETE = 14;
    this.SORT_TITLE_ASC = 1;
    this.SORT_TITLE_DESC = 2;
    this.LATEST_DOWNLOADED_CONTAINER_CTE_SQL_0 = '\n            LatestDownloadedContainer(containerUid) AS\n             (SELECT COALESCE(\n                     (SELECT containerUid\n                        FROM Container\n                       WHERE Container.containerContentEntryUid = :contentEntryUid \n                         AND EXISTS(\n                             SELECT 1\n                               FROM ContainerEntry\n                              WHERE ContainerEntry.ceContainerUid = Container.containerUid)\n                    ORDER BY cntLastModified DESC\n                       LIMIT 1), 0))\n        ';
    this.ACTIVE_CONTENT_JOB_ITEMS_CTE_SQL_0 = '\n            ActiveContentJobItems(cjiRecursiveStatus, cjiPluginId) AS\n             (SELECT cjiRecursiveStatus, cjiPluginId\n                FROM ContentJobItem\n               WHERE cjiContentEntryUid = :contentEntryUid\n                 AND cjiStatus BETWEEN 4 AND 20)\n        ';
    this.ENTITY_PERSONS_WITH_PERMISSION_PT1 = '\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 42 AND \n            EntityRole.erEntityUid = ContentEntry.contentEntryUid AND\n            (Role.rolePermissions &  \n        ';
    this.ENTITY_PERSONS_WITH_PERMISSION_PT2 = ') > 0)';
    this.ENTITY_PERSONS_WITH_PERMISSION = '\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 42 AND \n            EntityRole.erEntityUid = ContentEntry.contentEntryUid AND\n            (Role.rolePermissions &  \n         :permission ) > 0)';
    this.ALL_ENTRIES_RECURSIVE_SQL = 'WITH RECURSIVE ContentEntry_recursive(\n            contentEntryUid, title, ceInactive, contentFlags, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, leaf, publik,  completionCriteria, minScore, contentOwner, contentTypeFlag, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct,\n            \n            cepcjUid, cepcjChildContentEntryUid, cepcjParentContentEntryUid, childIndex, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct,\n            \n            containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries, cntLct\n            ) AS (\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct,\n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0))\n            WHERE ContentEntry.contentEntryUid = :contentEntryUid\n            UNION\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct, \n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0)),\n            ContentEntry_recursive\n            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid)\n            SELECT * FROM ContentEntry_recursive';
    this.ENTRY_WITH_CONTAINER_QUERY = '\n            SELECT ContentEntry.*, Container.* FROM ContentEntry LEFT \n                JOIN Container ON Container.containerUid = (\n                    SELECT containerUid FROM Container WHERE containerContentEntryUid =  ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1) \n            WHERE ContentEntry.contentEntryUid=:entryUuid\n            ';
  }
  ContentEntryDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ContentEntryDao$Companion_instance = null;
  function ContentEntryDao$Companion_getInstance() {
    if (ContentEntryDao$Companion_instance === null) {
      new ContentEntryDao$Companion();
    }return ContentEntryDao$Companion_instance;
  }
  ContentEntryDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentEntryDao', interfaces: [BaseDao]};
  function ContentEntryParentChildJoinDao() {
  }
  ContentEntryParentChildJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentEntryParentChildJoinDao', interfaces: [BaseDao]};
  function ContentEntryPictureDao() {
  }
  ContentEntryPictureDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentEntryPictureDao', interfaces: [BaseDao]};
  function ContentEntryRelatedEntryJoinDao() {
  }
  ContentEntryRelatedEntryJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentEntryRelatedEntryJoinDao', interfaces: [BaseDao]};
  function ContentJobDao() {
  }
  ContentJobDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentJobDao', interfaces: []};
  function ContentJobItemDao() {
  }
  function Coroutine$commitProgressUpdates_kqtj6w$($this, updates_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$updates = updates_0;
  }
  Coroutine$commitProgressUpdates_kqtj6w$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$commitProgressUpdates_kqtj6w$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$commitProgressUpdates_kqtj6w$.prototype.constructor = Coroutine$commitProgressUpdates_kqtj6w$;
  Coroutine$commitProgressUpdates_kqtj6w$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$updates.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateItemProgress_b9bd0d$(element.cjiUid, element.cjiItemProgress, element.cjiItemTotal, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ContentJobItemDao.prototype.commitProgressUpdates_kqtj6w$ = function (updates_0, continuation_0, suspended) {
    var instance = new Coroutine$commitProgressUpdates_kqtj6w$(this, updates_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ContentJobItemDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContentJobItemDao', interfaces: []};
  function ContextXObjectStatementJoinDao() {
    ContextXObjectStatementJoinDao$Companion_getInstance();
  }
  function ContextXObjectStatementJoinDao$Companion() {
    ContextXObjectStatementJoinDao$Companion_instance = this;
    this.CONTEXT_FLAG_PARENT = 0;
    this.CONTEXT_FLAG_CATEGORY = 1;
    this.CONTEXT_FLAG_GROUPING = 2;
    this.CONTEXT_FLAG_OTHER = 3;
  }
  ContextXObjectStatementJoinDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ContextXObjectStatementJoinDao$Companion_instance = null;
  function ContextXObjectStatementJoinDao$Companion_getInstance() {
    if (ContextXObjectStatementJoinDao$Companion_instance === null) {
      new ContextXObjectStatementJoinDao$Companion();
    }return ContextXObjectStatementJoinDao$Companion_instance;
  }
  ContextXObjectStatementJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ContextXObjectStatementJoinDao', interfaces: [BaseDao]};
  function CourseAssignmentMarkDao() {
  }
  CourseAssignmentMarkDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseAssignmentMarkDao', interfaces: [BaseDao]};
  function CourseAssignmentSubmissionAttachmentDao() {
  }
  CourseAssignmentSubmissionAttachmentDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseAssignmentSubmissionAttachmentDao', interfaces: [BaseDao]};
  function CourseAssignmentSubmissionDao() {
    CourseAssignmentSubmissionDao$Companion_getInstance();
  }
  function CourseAssignmentSubmissionDao$Companion() {
    CourseAssignmentSubmissionDao$Companion_instance = this;
    this.GET_SUBMITTERID_FROM_STUDENT = '\n             (CASE WHEN ClazzAssignment.caGroupUid = 0\n                                       THEN :studentUid\n                                       ELSE COALESCE((SELECT cgmGroupNumber \n                                                       FROM CourseGroupMember\n                                                      WHERE cgmSetUid = ClazzAssignment.caGroupUid\n                                                        AND cgmPersonUid = :studentUid\n                                                      LIMIT 1),0))\n        ';
  }
  CourseAssignmentSubmissionDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var CourseAssignmentSubmissionDao$Companion_instance = null;
  function CourseAssignmentSubmissionDao$Companion_getInstance() {
    if (CourseAssignmentSubmissionDao$Companion_instance === null) {
      new CourseAssignmentSubmissionDao$Companion();
    }return CourseAssignmentSubmissionDao$Companion_instance;
  }
  CourseAssignmentSubmissionDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseAssignmentSubmissionDao', interfaces: [BaseDao]};
  function CourseBlockDao() {
    CourseBlockDao$Companion_getInstance();
  }
  function Coroutine$deactivateByUids_ejltwb$_2($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$_2.prototype.constructor = Coroutine$deactivateByUids_ejltwb$_2;
  Coroutine$deactivateByUids_ejltwb$_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateActiveByUid_zaz62j$(element, false, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  CourseBlockDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$_2(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function CourseBlockDao$Companion() {
    CourseBlockDao$Companion_instance = this;
    this.SUBMITTER_LIST_IN_CLAZZ_CTE = '\n            SubmitterList (submitterId, assignmentUid)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId,\n                       ClazzAssignment.caUid AS assignmentUid\n                  \n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caClazzUid = :clazzUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, assignmentUid\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    ClazzAssignment.caUid AS assignmentUid\n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = :clazzUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, assignmentUid\n            )\n        ';
  }
  CourseBlockDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var CourseBlockDao$Companion_instance = null;
  function CourseBlockDao$Companion_getInstance() {
    if (CourseBlockDao$Companion_instance === null) {
      new CourseBlockDao$Companion();
    }return CourseBlockDao$Companion_instance;
  }
  CourseBlockDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseBlockDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function CourseDiscussionDao() {
  }
  function Coroutine$deactivateByUids_ejltwb$_3($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$_3.prototype.constructor = Coroutine$deactivateByUids_ejltwb$_3;
  Coroutine$deactivateByUids_ejltwb$_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateActiveByUid_zaz62j$(element, false, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  CourseDiscussionDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$_3(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  CourseDiscussionDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseDiscussionDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function CourseGroupMemberDao() {
  }
  CourseGroupMemberDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseGroupMemberDao', interfaces: [BaseDao]};
  function CourseGroupSetDao() {
  }
  CourseGroupSetDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseGroupSetDao', interfaces: [BaseDao]};
  function CoursePictureDao() {
    CoursePictureDao$Companion_getInstance();
  }
  function CoursePictureDao$Companion() {
    CoursePictureDao$Companion_instance = this;
  }
  CoursePictureDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var CoursePictureDao$Companion_instance = null;
  function CoursePictureDao$Companion_getInstance() {
    if (CoursePictureDao$Companion_instance === null) {
      new CoursePictureDao$Companion();
    }return CoursePictureDao$Companion_instance;
  }
  CoursePictureDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CoursePictureDao', interfaces: [BaseDao]};
  function CourseTerminologyDao() {
  }
  CourseTerminologyDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CourseTerminologyDao', interfaces: [BaseDao]};
  function DiscussionPostDao() {
  }
  DiscussionPostDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'DiscussionPostDao', interfaces: [BaseDao]};
  function DiscussionTopicDao() {
  }
  function Coroutine$deactivateByUids_ejltwb$_4($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$_4.prototype.constructor = Coroutine$deactivateByUids_ejltwb$_4;
  Coroutine$deactivateByUids_ejltwb$_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateActiveByUid_zaz62j$(element, false, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  DiscussionTopicDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$_4(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  DiscussionTopicDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'DiscussionTopicDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function EntityRoleDao() {
    EntityRoleDao$Companion_getInstance();
  }
  function EntityRoleDao$Companion() {
    EntityRoleDao$Companion_instance = this;
    this.FILTER_BY_PERSON_UID2 = "\n                    SELECT  \n                    (CASE \n                        WHEN EntityRole.erTableId = 6\tTHEN (SELECT Clazz.clazzName FROM Clazz WHERE Clazz.clazzUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 9\tTHEN (SELECT Person.firstNames||' '||Person.lastName FROM Person WHERE Person.personUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 164\tTHEN (SELECT School.schoolName FROM School WHERE School.schoolUid = EntityRole.erEntityUid)\n                        ELSE '' \n                    END) as entityRoleScopeName,\n                    Role.*, EntityRole.* FROM EntityRole\n                    LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid \n                    WHERE EntityRole.erGroupUid = :personGroupUid\n                    AND CAST(EntityRole.erActive AS INTEGER) = 1 \n                ";
  }
  EntityRoleDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var EntityRoleDao$Companion_instance = null;
  function EntityRoleDao$Companion_getInstance() {
    if (EntityRoleDao$Companion_instance === null) {
      new EntityRoleDao$Companion();
    }return EntityRoleDao$Companion_instance;
  }
  EntityRoleDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'EntityRoleDao', interfaces: []};
  function ErrorReportDao() {
  }
  ErrorReportDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ErrorReportDao', interfaces: []};
  function GroupLearningSessionDao() {
  }
  GroupLearningSessionDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'GroupLearningSessionDao', interfaces: [BaseDao]};
  function HolidayCalendarDao() {
  }
  HolidayCalendarDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'HolidayCalendarDao', interfaces: [BaseDao]};
  function HolidayDao() {
  }
  HolidayDao.prototype.deactivateByUids_ejltwb$ = function (uidList, changeTime, continuation) {
    var tmp$;
    tmp$ = uidList.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.updateActiveByUid_zaz62j$(element, false, changeTime);
    }
  };
  HolidayDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'HolidayDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function LanguageDao() {
    LanguageDao$Companion_getInstance();
  }
  LanguageDao.prototype.initPreloadedLanguages = function () {
    var $receiver = Language.Companion.FIXED_LANGUAGES;
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.langUid);
    }
    var uidsInserted = this.findByUidList(destination);
    var $receiver_0 = Language.Companion.FIXED_LANGUAGES;
    var destination_0 = ArrayList_init_0();
    var tmp$_0;
    tmp$_0 = $receiver_0.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (!uidsInserted.contains_11rb$(element.langUid))
        destination_0.add_11rb$(element);
    }
    var templateListToInsert = destination_0;
    this.replaceList(templateListToInsert);
  };
  function LanguageDao$Companion() {
    LanguageDao$Companion_instance = this;
    this.SORT_LANGNAME_ASC = 1;
    this.SORT_LANGNAME_DESC = 2;
    this.SORT_TWO_LETTER_ASC = 3;
    this.SORT_TWO_LETTER_DESC = 4;
    this.SORT_THREE_LETTER_ASC = 5;
    this.SORT_THREE_LETTER_DESC = 6;
  }
  LanguageDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var LanguageDao$Companion_instance = null;
  function LanguageDao$Companion_getInstance() {
    if (LanguageDao$Companion_instance === null) {
      new LanguageDao$Companion();
    }return LanguageDao$Companion_instance;
  }
  LanguageDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'LanguageDao', interfaces: [BaseDao]};
  function LanguageVariantDao() {
  }
  LanguageVariantDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'LanguageVariantDao', interfaces: [BaseDao]};
  function LearnerGroupDao() {
  }
  LearnerGroupDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'LearnerGroupDao', interfaces: [BaseDao]};
  function LearnerGroupMemberDao() {
  }
  LearnerGroupMemberDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'LearnerGroupMemberDao', interfaces: [BaseDao]};
  function LeavingReasonDao() {
  }
  function Coroutine$initPreloadedLeavingReasons($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$initPreloadedLeavingReasons.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$initPreloadedLeavingReasons.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$initPreloadedLeavingReasons.prototype.constructor = Coroutine$initPreloadedLeavingReasons;
  Coroutine$initPreloadedLeavingReasons.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.findByUidList(toList_0(LeavingReason.Companion.FIXED_UIDS.values), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var uidsInserted = this.result_0;
            var $receiver = LeavingReason.Companion.FIXED_UIDS;
            var destination = LinkedHashMap_init();
            var tmp$;
            tmp$ = $receiver.entries.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              if (!uidsInserted.contains_11rb$(element.value)) {
                destination.put_xwzc9p$(element.key, element.value);
              }}

            var uidsToInsert = destination;
            var destination_0 = ArrayList_init(uidsToInsert.size);
            var tmp$_0;
            tmp$_0 = uidsToInsert.entries.iterator();
            while (tmp$_0.hasNext()) {
              var item = tmp$_0.next();
              destination_0.add_11rb$(LeavingReason_init(item.value, item.key));
            }

            var verbListToInsert = destination_0;
            this.state_0 = 3;
            this.result_0 = this.$this.replaceList(verbListToInsert, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  LeavingReasonDao.prototype.initPreloadedLeavingReasons = function (continuation_0, suspended) {
    var instance = new Coroutine$initPreloadedLeavingReasons(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  LeavingReasonDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'LeavingReasonDao', interfaces: [BaseDao]};
  function LocallyAvailableContainerDao() {
  }
  LocallyAvailableContainerDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'LocallyAvailableContainerDao', interfaces: []};
  function MessageDao() {
  }
  MessageDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'MessageDao', interfaces: [BaseDao]};
  function MessageReadDao() {
  }
  MessageReadDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'MessageReadDao', interfaces: [BaseDao]};
  function NetworkNodeDao() {
    NetworkNodeDao$Companion_getInstance();
  }
  function Coroutine$updateNodeLastSeen_zhbzl8$($this, knownNodes_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$nodeIterator = void 0;
    this.local$knownNodes = knownNodes_0;
  }
  Coroutine$updateNodeLastSeen_zhbzl8$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$updateNodeLastSeen_zhbzl8$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$updateNodeLastSeen_zhbzl8$.prototype.constructor = Coroutine$updateNodeLastSeen_zhbzl8$;
  Coroutine$updateNodeLastSeen_zhbzl8$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$nodeIterator = this.local$knownNodes.entries.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$nodeIterator.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var nodeUpdates = this.local$nodeIterator.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateLastSeenAsync_4wgjuj$(nodeUpdates.key, nodeUpdates.value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  NetworkNodeDao.prototype.updateNodeLastSeen_zhbzl8$ = function (knownNodes_0, continuation_0, suspended) {
    var instance = new Coroutine$updateNodeLastSeen_zhbzl8$(this, knownNodes_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function NetworkNodeDao$Companion() {
    NetworkNodeDao$Companion_instance = this;
    this.findByBluetoothAddrSql = 'SELECT * from NetworkNode WHERE bluetoothMacAddress = :bluetoothAddress';
  }
  NetworkNodeDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var NetworkNodeDao$Companion_instance = null;
  function NetworkNodeDao$Companion_getInstance() {
    if (NetworkNodeDao$Companion_instance === null) {
      new NetworkNodeDao$Companion();
    }return NetworkNodeDao$Companion_instance;
  }
  NetworkNodeDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'NetworkNodeDao', interfaces: []};
  function OneToManyJoinDao() {
  }
  OneToManyJoinDao.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'OneToManyJoinDao', interfaces: []};
  function PersonAuth2Dao() {
  }
  PersonAuth2Dao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonAuth2Dao', interfaces: []};
  function PersonAuthDao() {
    PersonAuthDao$Companion_getInstance();
  }
  function Coroutine$resetPassword_4k311k$($this, personUid_0, password_0, loggedInPersonUid_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$personUid = personUid_0;
    this.local$password = password_0;
    this.local$loggedInPersonUid = loggedInPersonUid_0;
  }
  Coroutine$resetPassword_4k311k$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$resetPassword_4k311k$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$resetPassword_4k311k$.prototype.constructor = Coroutine$resetPassword_4k311k$;
  Coroutine$resetPassword_4k311k$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            println('hello');
            var passwordHash = PersonAuthDao$Companion_getInstance().ENCRYPTED_PASS_PREFIX + encryptPassword(this.local$password);
            println('Resetting password .. ');
            if (this.$this.isPersonAdmin_s8cxhz$(this.local$loggedInPersonUid)) {
              println('Password being reset by admin. Allowing.. ');
              this.state_0 = 4;
              this.result_0 = this.$this.changePassword_a4hdmt$(this.local$personUid, passwordHash, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              if (equals(this.local$loggedInPersonUid, this.local$personUid)) {
                println('Resetting password 2.. ');
                this.state_0 = 2;
                this.result_0 = this.$this.changePassword_a4hdmt$(this.local$personUid, passwordHash, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                println('Unable to reset password cause not the same user.. ');
                return -1;
              }
            }

          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          case 3:
            this.state_0 = 5;
            continue;
          case 4:
            return this.result_0;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PersonAuthDao.prototype.resetPassword_4k311k$ = function (personUid_0, password_0, loggedInPersonUid_0, continuation_0, suspended) {
    var instance = new Coroutine$resetPassword_4k311k$(this, personUid_0, password_0, loggedInPersonUid_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$changePassword_a4hdmt$($this, personUid_0, passwordHash_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$personUid = personUid_0;
    this.local$passwordHash = passwordHash_0;
  }
  Coroutine$changePassword_a4hdmt$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$changePassword_a4hdmt$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$changePassword_a4hdmt$.prototype.constructor = Coroutine$changePassword_a4hdmt$;
  Coroutine$changePassword_a4hdmt$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var existingPersonAuth = this.$this.findByUid_s8cxhz$(this.local$personUid);
            if (existingPersonAuth == null) {
              println('PersonAuth doesnt exist for reset password. Creating a new one..');
              var personAuth = PersonAuth_init(this.local$personUid, this.local$passwordHash);
              this.$this.insert_11rb$(personAuth);
              println(' .. created new PersonAuth');
            }
            this.state_0 = 2;
            this.result_0 = this.$this.updatePasswordForPersonUid_a4hdmt$(this.local$personUid, this.local$passwordHash, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var result = this.result_0;
            if (result > 0) {
              println('Update password success');
              return 1;
            } else {
              println('Unable to reset password');
              return 0;
            }

          case 3:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PersonAuthDao.prototype.changePassword_a4hdmt$ = function (personUid_0, passwordHash_0, continuation_0, suspended) {
    var instance = new Coroutine$changePassword_a4hdmt$(this, personUid_0, passwordHash_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  PersonAuthDao.prototype.onSuccessCreateAccessToken_a4hdmt$ = function (personUid, username, continuation) {
    var accessToken = AccessToken_init(personUid, getSystemTimeInMillis().add(PersonDao$Companion_getInstance().SESSION_LENGTH), getSystemTimeInMillis().toString());
    this.insertAccessToken_sz9w29$(accessToken);
    return new UmAccount(personUid, username, accessToken.token, '');
  };
  function Coroutine$authenticate_puj7f4$($this, username_0, password_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$person = void 0;
    this.local$username = username_0;
    this.local$password = password_0;
  }
  Coroutine$authenticate_puj7f4$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$authenticate_puj7f4$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$authenticate_puj7f4$.prototype.constructor = Coroutine$authenticate_puj7f4$;
  Coroutine$authenticate_puj7f4$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$person = this.$this.findPersonByUsername_61zpoe$(this.local$username);
            if (this.local$person == null) {
              return null;
            } else {
              this.state_0 = 2;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            var loggedInPersonUid = this.local$person.personUid;
            var personAuth = this.$this.findByUid_s8cxhz$(loggedInPersonUid);
            if (personAuth == null) {
              return null;
            } else {
              var passwordHash = personAuth.passwordHash;
              var tmp$ = startsWith(ensureNotNull(passwordHash), PersonAuthDao$Companion_getInstance().PLAIN_PASS_PREFIX);
              if (tmp$) {
                tmp$ = equals(passwordHash.substring(2), this.local$password);
              }if (tmp$) {
                this.state_0 = 7;
                this.result_0 = this.$this.onSuccessCreateAccessToken_a4hdmt$(loggedInPersonUid, this.local$username, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                var tmp$_0 = startsWith(passwordHash, PersonAuthDao$Companion_getInstance().ENCRYPTED_PASS_PREFIX);
                if (tmp$_0) {
                  tmp$_0 = PersonAuthDao$Companion_getInstance().authenticateThisEncryptedPassword_jyasbz$(this.local$password, passwordHash.substring(2));
                }if (tmp$_0) {
                  this.state_0 = 5;
                  this.result_0 = this.$this.onSuccessCreateAccessToken_a4hdmt$(loggedInPersonUid, this.local$username, this);
                  if (this.result_0 === COROUTINE_SUSPENDED)
                    return COROUTINE_SUSPENDED;
                  continue;
                } else {
                  if (PersonAuthDao$Companion_getInstance().authenticateThisEncryptedPassword_jyasbz$(this.local$password, passwordHash)) {
                    this.state_0 = 3;
                    this.result_0 = this.$this.onSuccessCreateAccessToken_a4hdmt$(loggedInPersonUid, this.local$username, this);
                    if (this.result_0 === COROUTINE_SUSPENDED)
                      return COROUTINE_SUSPENDED;
                    continue;
                  } else {
                    return null;
                  }
                }
              }
            }

          case 3:
            return this.result_0;
          case 4:
            this.state_0 = 6;
            continue;
          case 5:
            return this.result_0;
          case 6:
            this.state_0 = 8;
            continue;
          case 7:
            return this.result_0;
          case 8:
            this.state_0 = 9;
            continue;
          case 9:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PersonAuthDao.prototype.authenticate_puj7f4$ = function (username_0, password_0, continuation_0, suspended) {
    var instance = new Coroutine$authenticate_puj7f4$(this, username_0, password_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function PersonAuthDao$Companion() {
    PersonAuthDao$Companion_instance = this;
    this.KEY_LENGTH_0 = 512;
    this.ITERATIONS_0 = 10000;
    this.SALT_0 = 'fe10fe1010';
    this.ENCRYPTED_PASS_PREFIX = 'e:';
    this.PLAIN_PASS_PREFIX = 'p:';
  }
  PersonAuthDao$Companion.prototype.encryptThisPassword_61zpoe$ = function (originalPassword) {
    return encryptPassword(originalPassword);
  };
  PersonAuthDao$Companion.prototype.authenticateThisEncryptedPassword_jyasbz$ = function (providedPassword, encryptedPassword) {
    return equals(this.encryptThisPassword_61zpoe$(providedPassword), encryptedPassword);
  };
  PersonAuthDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var PersonAuthDao$Companion_instance = null;
  function PersonAuthDao$Companion_getInstance() {
    if (PersonAuthDao$Companion_instance === null) {
      new PersonAuthDao$Companion();
    }return PersonAuthDao$Companion_instance;
  }
  PersonAuthDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonAuthDao', interfaces: [BaseDao]};
  function PersonDao() {
    PersonDao$Companion_getInstance();
  }
  function PersonDao$PersonUidAndPasswordHash() {
    this.passwordHash = null;
    this.personUid = L0;
    this.firstNames = null;
    this.lastName = null;
    this.admin = false;
  }
  PersonDao$PersonUidAndPasswordHash.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonUidAndPasswordHash', interfaces: []};
  PersonDao.prototype.authenticate_4wgjuj$ = function (token, personUid) {
    return this.isValidToken_4wgjuj$(token, personUid);
  };
  PersonDao.prototype.findPersonsWithPermission_gs5uuz$ = function (timestamp, excludeClazz, excludeSchool, excludeSelected, accountPersonUid, sortOrder, searchText, callback$default) {
    if (searchText === void 0)
      searchText = '%';
    return callback$default ? callback$default(timestamp, excludeClazz, excludeSchool, excludeSelected, accountPersonUid, sortOrder, searchText) : this.findPersonsWithPermission_gs5uuz$$default(timestamp, excludeClazz, excludeSchool, excludeSelected, accountPersonUid, sortOrder, searchText);
  };
  PersonDao.prototype.findPersonsWithPermissionAsList_gs5uuz$ = function (timestamp, excludeClazz, excludeSchool, excludeSelected, accountPersonUid, sortOrder, searchText, callback$default) {
    if (searchText === void 0)
      searchText = '%';
    return callback$default ? callback$default(timestamp, excludeClazz, excludeSchool, excludeSelected, accountPersonUid, sortOrder, searchText) : this.findPersonsWithPermissionAsList_gs5uuz$$default(timestamp, excludeClazz, excludeSchool, excludeSelected, accountPersonUid, sortOrder, searchText);
  };
  PersonDao.prototype.createAuditLog_p9fb6p$_0 = function (toPersonUid, fromPersonUid) {
    if (!equals(fromPersonUid, L0)) {
      var auditLog = AuditLog_init(fromPersonUid, 9, toPersonUid);
      this.insertAuditLog_6gshjl$(auditLog);
    }};
  function PersonDao$Companion() {
    PersonDao$Companion_instance = this;
    this.SORT_FIRST_NAME_ASC = 1;
    this.SORT_FIRST_NAME_DESC = 2;
    this.SORT_LAST_NAME_ASC = 3;
    this.SORT_LAST_NAME_DESC = 4;
    this.SQL_SELECT_LIST_WITH_PERMISSION = "\n         SELECT Person.* \n           FROM PersonGroupMember \n                \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n           AND PersonGroupMember.groupMemberActive \n           AND (:excludeClazz = 0 OR :excludeClazz NOT IN\n                    (SELECT clazzEnrolmentClazzUid \n                       FROM ClazzEnrolment \n                      WHERE clazzEnrolmentPersonUid = Person.personUid \n                            AND :timestamp BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive))\n           AND (:excludeSchool = 0 OR :excludeSchool NOT IN\n                    (SELECT schoolMemberSchoolUid\n                      FROM SchoolMember \n                     WHERE schoolMemberPersonUid = Person.personUid \n                       AND :timestamp BETWEEN SchoolMember.schoolMemberJoinDate\n                            AND SchoolMember.schoolMemberLeftDate ))\n           AND Person.personType = 0                  \n           AND (Person.personUid NOT IN (:excludeSelected))\n           AND (:searchText = '%' \n               OR Person.firstNames || ' ' || Person.lastName LIKE :searchText)\n      GROUP BY Person.personUid\n      ORDER BY CASE(:sortOrder)\n               WHEN 1 THEN Person.firstNames\n               WHEN 3 THEN Person.lastName\n               ELSE ''\n               END ASC,\n               CASE(:sortOrder)\n               WHEN 2 THEN Person.firstNames\n               WHEN 4 THEN Person.lastName\n               ELSE ''\n               END DESC\n    ";
    this.ENTITY_PERSONS_WITH_PERMISSION_PT1_0 = '\n            SELECT DISTINCT Person_Perm.personUid FROM Person Person_Perm\n            LEFT JOIN PersonGroupMember ON Person_Perm.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE\n            CAST(Person_Perm.admin AS INTEGER) = 1 OR ( (\n            ';
    this.ENTITY_PERSONS_WITH_PERMISSION_PT2_0 = '\n            = 0) AND (Person_Perm.personUid = Person.personUid))\n            OR\n            (\n            ((EntityRole.erTableId = 9 AND EntityRole.erEntityUid = Person.personUid) OR \n            (EntityRole.erTableId = 6 AND EntityRole.erEntityUid IN (SELECT DISTINCT clazzEnrolmentClazzUid FROM ClazzEnrolment WHERE clazzEnrolmentPersonUid = Person.personUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (SELECT DISTINCT schoolMemberSchoolUid FROM SchoolMember WHERE schoolMemberPersonUid = Person.PersonUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (\n                SELECT DISTINCT Clazz.clazzSchoolUid \n                FROM Clazz\n                JOIN ClazzEnrolment ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid AND ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n            ))\n            ) \n            AND (Role.rolePermissions & \n        ';
    this.ENTITY_PERSONS_WITH_PERMISSION_PT4_0 = ') > 0)';
    this.SESSION_LENGTH = L2419200000;
    this.ENTITY_PERSONS_WITH_LEARNING_RECORD_PERMISSION = '\n            SELECT DISTINCT Person_Perm.personUid FROM Person Person_Perm\n            LEFT JOIN PersonGroupMember ON Person_Perm.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE\n            CAST(Person_Perm.admin AS INTEGER) = 1 OR ( (\n             0 \n            = 0) AND (Person_Perm.personUid = Person.personUid))\n            OR\n            (\n            ((EntityRole.erTableId = 9 AND EntityRole.erEntityUid = Person.personUid) OR \n            (EntityRole.erTableId = 6 AND EntityRole.erEntityUid IN (SELECT DISTINCT clazzEnrolmentClazzUid FROM ClazzEnrolment WHERE clazzEnrolmentPersonUid = Person.personUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (SELECT DISTINCT schoolMemberSchoolUid FROM SchoolMember WHERE schoolMemberPersonUid = Person.PersonUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (\n                SELECT DISTINCT Clazz.clazzSchoolUid \n                FROM Clazz\n                JOIN ClazzEnrolment ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid AND ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n            ))\n            ) \n            AND (Role.rolePermissions & \n         549755813888 ) > 0)';
  }
  PersonDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var PersonDao$Companion_instance = null;
  function PersonDao$Companion_getInstance() {
    if (PersonDao$Companion_instance === null) {
      new PersonDao$Companion();
    }return PersonDao$Companion_instance;
  }
  function PersonDao$PersonNameAndUid(personUid, name) {
    PersonDao$PersonNameAndUid$Companion_getInstance();
    if (personUid === void 0)
      personUid = L0;
    if (name === void 0)
      name = '';
    this.personUid = personUid;
    this.name = name;
  }
  PersonDao$PersonNameAndUid.prototype.toString = function () {
    return this.name;
  };
  function PersonDao$PersonNameAndUid$Companion() {
    PersonDao$PersonNameAndUid$Companion_instance = this;
  }
  PersonDao$PersonNameAndUid$Companion.prototype.serializer = function () {
    return PersonDao$PersonNameAndUid$$serializer_getInstance();
  };
  PersonDao$PersonNameAndUid$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var PersonDao$PersonNameAndUid$Companion_instance = null;
  function PersonDao$PersonNameAndUid$Companion_getInstance() {
    if (PersonDao$PersonNameAndUid$Companion_instance === null) {
      new PersonDao$PersonNameAndUid$Companion();
    }return PersonDao$PersonNameAndUid$Companion_instance;
  }
  function PersonDao$PersonNameAndUid$$serializer() {
    this.descriptor_91djkk$_0 = new PluginGeneratedSerialDescriptor('com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid', this, 2);
    this.descriptor.addElement_ivxn3r$('personUid', true);
    this.descriptor.addElement_ivxn3r$('name', true);
    PersonDao$PersonNameAndUid$$serializer_instance = this;
  }
  Object.defineProperty(PersonDao$PersonNameAndUid$$serializer.prototype, 'descriptor', {configurable: true, get: function () {
    return this.descriptor_91djkk$_0;
  }});
  PersonDao$PersonNameAndUid$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    if (!equals(value.personUid, L0) || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 0))
      output.encodeLongElement_j0o2mv$(this.descriptor, 0, value.personUid);
    if (!equals(value.name, '') || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 1))
      output.encodeStringElement_iij8qq$(this.descriptor, 1, value.name);
    output.endStructure_24f42q$(this.descriptor);
  };
  PersonDao$PersonNameAndUid$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0, local1;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeLongElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeStringElement_szpzho$(this.descriptor, 1);
          bitMask0 |= 2;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return PersonDao$PersonDao$PersonNameAndUid_init(bitMask0, local0, local1, null);
  };
  PersonDao$PersonNameAndUid$$serializer.prototype.childSerializers = function () {
    return [internal.LongSerializer, internal.StringSerializer];
  };
  PersonDao$PersonNameAndUid$$serializer.$metadata$ = {kind: Kind_OBJECT, simpleName: '$serializer', interfaces: [GeneratedSerializer]};
  var PersonDao$PersonNameAndUid$$serializer_instance = null;
  function PersonDao$PersonNameAndUid$$serializer_getInstance() {
    if (PersonDao$PersonNameAndUid$$serializer_instance === null) {
      new PersonDao$PersonNameAndUid$$serializer();
    }return PersonDao$PersonNameAndUid$$serializer_instance;
  }
  function PersonDao$PersonDao$PersonNameAndUid_init(seen1, personUid, name, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(PersonDao$PersonNameAndUid.prototype);
    if ((seen1 & 1) === 0)
      $this.personUid = L0;
    else
      $this.personUid = personUid;
    if ((seen1 & 2) === 0)
      $this.name = '';
    else
      $this.name = name;
    return $this;
  }
  PersonDao$PersonNameAndUid.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonNameAndUid', interfaces: []};
  PersonDao$PersonNameAndUid.prototype.component1 = function () {
    return this.personUid;
  };
  PersonDao$PersonNameAndUid.prototype.component2 = function () {
    return this.name;
  };
  PersonDao$PersonNameAndUid.prototype.copy_a4hdmt$ = function (personUid, name) {
    return new PersonDao$PersonNameAndUid(personUid === void 0 ? this.personUid : personUid, name === void 0 ? this.name : name);
  };
  PersonDao$PersonNameAndUid.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.personUid) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  PersonDao$PersonNameAndUid.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.personUid, other.personUid) && Kotlin.equals(this.name, other.name)))));
  };
  PersonDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonDao', interfaces: [BaseDao]};
  function PersonGroupDao() {
  }
  PersonGroupDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonGroupDao', interfaces: [BaseDao]};
  function PersonGroupMemberDao() {
  }
  PersonGroupMemberDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonGroupMemberDao', interfaces: [BaseDao]};
  function PersonParentJoinDao() {
  }
  function PersonParentJoinDao$ParentEnrolmentRequired(parentPersonUid, clazzUid) {
    if (parentPersonUid === void 0)
      parentPersonUid = L0;
    if (clazzUid === void 0)
      clazzUid = L0;
    this.parentPersonUid = parentPersonUid;
    this.clazzUid = clazzUid;
  }
  PersonParentJoinDao$ParentEnrolmentRequired.$metadata$ = {kind: Kind_CLASS, simpleName: 'ParentEnrolmentRequired', interfaces: []};
  PersonParentJoinDao$ParentEnrolmentRequired.prototype.component1 = function () {
    return this.parentPersonUid;
  };
  PersonParentJoinDao$ParentEnrolmentRequired.prototype.component2 = function () {
    return this.clazzUid;
  };
  PersonParentJoinDao$ParentEnrolmentRequired.prototype.copy_3pjtqy$ = function (parentPersonUid, clazzUid) {
    return new PersonParentJoinDao$ParentEnrolmentRequired(parentPersonUid === void 0 ? this.parentPersonUid : parentPersonUid, clazzUid === void 0 ? this.clazzUid : clazzUid);
  };
  PersonParentJoinDao$ParentEnrolmentRequired.prototype.toString = function () {
    return 'ParentEnrolmentRequired(parentPersonUid=' + Kotlin.toString(this.parentPersonUid) + (', clazzUid=' + Kotlin.toString(this.clazzUid)) + ')';
  };
  PersonParentJoinDao$ParentEnrolmentRequired.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.parentPersonUid) | 0;
    result = result * 31 + Kotlin.hashCode(this.clazzUid) | 0;
    return result;
  };
  PersonParentJoinDao$ParentEnrolmentRequired.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.parentPersonUid, other.parentPersonUid) && Kotlin.equals(this.clazzUid, other.clazzUid)))));
  };
  PersonParentJoinDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonParentJoinDao', interfaces: []};
  function PersonPictureDao() {
    PersonPictureDao$Companion_getInstance();
  }
  function PersonPictureDao$Companion() {
    PersonPictureDao$Companion_instance = this;
    this.TABLE_LEVEL_PERMISSION = '(SELECT admin FROM Person WHERE personUid = :accountPersonUid) ' + 'OR ' + 'EXISTS(SELECT PersonGroupMember.groupMemberPersonUid FROM PersonGroupMember ' + ' JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid ' + ' JOIN Role ON EntityRole.erRoleUid = Role.roleUid ' + ' WHERE ' + ' PersonGroupMember.groupMemberPersonUid = :accountPersonUid ' + ' AND EntityRole.erTableId = ' + toString(50) + ' AND Role.rolePermissions & ';
    this.TABLE_LEVEL_PERMISSION_CONDITION2_0 = ' > 0)';
  }
  PersonPictureDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var PersonPictureDao$Companion_instance = null;
  function PersonPictureDao$Companion_getInstance() {
    if (PersonPictureDao$Companion_instance === null) {
      new PersonPictureDao$Companion();
    }return PersonPictureDao$Companion_instance;
  }
  PersonPictureDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'PersonPictureDao', interfaces: [BaseDao]};
  function ReportDao() {
    ReportDao$Companion_getInstance();
  }
  ReportDao.prototype.initPreloadedTemplates = function () {
    var $receiver = Report.Companion.FIXED_TEMPLATES;
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.reportUid);
    }
    var uidsInserted = this.findByUidList(destination);
    var $receiver_0 = Report.Companion.FIXED_TEMPLATES;
    var destination_0 = ArrayList_init_0();
    var tmp$_0;
    tmp$_0 = $receiver_0.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (!uidsInserted.contains_11rb$(element.reportUid))
        destination_0.add_11rb$(element);
    }
    var templateListToInsert = destination_0;
    this.replaceList(templateListToInsert);
  };
  function ReportDao$Companion() {
    ReportDao$Companion_instance = this;
    this.SORT_TITLE_ASC = 1;
    this.SORT_TITLE_DESC = 2;
  }
  ReportDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ReportDao$Companion_instance = null;
  function ReportDao$Companion_getInstance() {
    if (ReportDao$Companion_instance === null) {
      new ReportDao$Companion();
    }return ReportDao$Companion_instance;
  }
  ReportDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ReportDao', interfaces: [BaseDao]};
  var RoleDao$Companion_instance = null;
  function ScheduleDao() {
  }
  function Coroutine$deactivateByUids_ejltwb$_5($this, uidList_0, changeTime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$uidList = uidList_0;
    this.local$changeTime = changeTime_0;
  }
  Coroutine$deactivateByUids_ejltwb$_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$deactivateByUids_ejltwb$_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$deactivateByUids_ejltwb$_5.prototype.constructor = Coroutine$deactivateByUids_ejltwb$_5;
  Coroutine$deactivateByUids_ejltwb$_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$uidList.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.$this.updateScheduleActivated_zaz62j$(element, false, this.local$changeTime, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ScheduleDao.prototype.deactivateByUids_ejltwb$ = function (uidList_0, changeTime_0, continuation_0, suspended) {
    var instance = new Coroutine$deactivateByUids_ejltwb$_5(this, uidList_0, changeTime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ScheduleDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ScheduleDao', interfaces: [OneToManyJoinDao, BaseDao]};
  function SchoolDao() {
    SchoolDao$Companion_getInstance();
  }
  function SchoolDao$Companion() {
    SchoolDao$Companion_instance = this;
    this.SORT_NAME_ASC = 1;
    this.SORT_NAME_DESC = 2;
    this.ENTITY_PERSONS_WITH_PERMISSION_PT1 = '\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 164 AND \n            EntityRole.erEntityUid = School.schoolUid AND\n            (Role.rolePermissions &  \n        ';
    this.ENTITY_PERSONS_WITH_PERMISSION_PT2 = ') > 0)';
    this.ENTITY_PERSONS_WITH_PERMISSION = '\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 164 AND \n            EntityRole.erEntityUid = School.schoolUid AND\n            (Role.rolePermissions &  \n         ' + ':permission ) > 0)';
  }
  SchoolDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var SchoolDao$Companion_instance = null;
  function SchoolDao$Companion_getInstance() {
    if (SchoolDao$Companion_instance === null) {
      new SchoolDao$Companion();
    }return SchoolDao$Companion_instance;
  }
  SchoolDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'SchoolDao', interfaces: [BaseDao]};
  function SchoolMemberDao() {
    SchoolMemberDao$Companion_getInstance();
  }
  SchoolMemberDao.prototype.findBySchoolAndPersonAndRole_6qtc6d$ = function (schoolUid, personUid, role, timeFilter, continuation, callback$default) {
    if (timeFilter === void 0)
      timeFilter = L0;
    return callback$default ? callback$default(schoolUid, personUid, role, timeFilter, continuation) : this.findBySchoolAndPersonAndRole_6qtc6d$$default(schoolUid, personUid, role, timeFilter, continuation);
  };
  function SchoolMemberDao$Companion() {
    SchoolMemberDao$Companion_instance = this;
    this.SORT_FIRST_NAME_ASC = 1;
    this.SORT_FIRST_NAME_DESC = 2;
    this.SORT_LAST_NAME_ASC = 3;
    this.SORT_LAST_NAME_DESC = 4;
  }
  SchoolMemberDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var SchoolMemberDao$Companion_instance = null;
  function SchoolMemberDao$Companion_getInstance() {
    if (SchoolMemberDao$Companion_instance === null) {
      new SchoolMemberDao$Companion();
    }return SchoolMemberDao$Companion_instance;
  }
  SchoolMemberDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'SchoolMemberDao', interfaces: [BaseDao]};
  function ScopedGrantDao() {
    ScopedGrantDao$Companion_getInstance();
  }
  function ScopedGrantDao$Companion() {
    ScopedGrantDao$Companion_instance = this;
    this.SQL_FIND_BY_TABLE_AND_ENTITY = '\n        SELECT ScopedGrant.*,\n               CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM ScopedGrant\n               JOIN PersonGroup \n                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE ScopedGrant.sgTableId = :tableId\n               AND ScopedGrant.sgEntityUid = :entityUid  \n    ';
  }
  ScopedGrantDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ScopedGrantDao$Companion_instance = null;
  function ScopedGrantDao$Companion_getInstance() {
    if (ScopedGrantDao$Companion_instance === null) {
      new ScopedGrantDao$Companion();
    }return ScopedGrantDao$Companion_instance;
  }
  ScopedGrantDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ScopedGrantDao', interfaces: []};
  function ScrapeQueueItemDao() {
    ScrapeQueueItemDao$Companion_getInstance();
  }
  function ScrapeQueueItemDao$Companion() {
    ScrapeQueueItemDao$Companion_instance = this;
    this.STATUS_PENDING = 1;
    this.STATUS_RUNNING = 2;
    this.STATUS_DONE = 3;
    this.STATUS_FAILED = 4;
  }
  ScrapeQueueItemDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ScrapeQueueItemDao$Companion_instance = null;
  function ScrapeQueueItemDao$Companion_getInstance() {
    if (ScrapeQueueItemDao$Companion_instance === null) {
      new ScrapeQueueItemDao$Companion();
    }return ScrapeQueueItemDao$Companion_instance;
  }
  ScrapeQueueItemDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ScrapeQueueItemDao', interfaces: [BaseDao]};
  function ScrapeRunDao() {
    ScrapeRunDao$Companion_getInstance();
  }
  function ScrapeRunDao$Companion() {
    ScrapeRunDao$Companion_instance = this;
    this.SCRAPE_TYPE_KHAN = 'khan';
    this.SCRAPE_TYPE_VOA = 'voa';
    this.SCRAPE_TYPE_EDRAAK = 'edraak';
    this.SCRAPE_TYPE_GDL = 'gdl';
    this.SCRAPE_TYPE_CK12 = 'ck12';
    this.SCRAPE_TYPE_DDL = 'ddl';
  }
  ScrapeRunDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var ScrapeRunDao$Companion_instance = null;
  function ScrapeRunDao$Companion_getInstance() {
    if (ScrapeRunDao$Companion_instance === null) {
      new ScrapeRunDao$Companion();
    }return ScrapeRunDao$Companion_instance;
  }
  ScrapeRunDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ScrapeRunDao', interfaces: [BaseDao]};
  function SiteDao() {
  }
  SiteDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'SiteDao', interfaces: []};
  function StateContentDao() {
  }
  StateContentDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'StateContentDao', interfaces: [BaseDao]};
  function StateDao() {
  }
  StateDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'StateDao', interfaces: [BaseDao]};
  function StatementDao() {
    StatementDao$Companion_getInstance();
  }
  StatementDao.prototype.getResults_pjwf99$ = function (sqlStr, paramsList, continuation) {
    return this.getResults_j49vja$(new SimpleDoorQuery(sqlStr, paramsList), continuation);
  };
  function StatementDao$ReportData(yAxis, xAxis, subgroup) {
    StatementDao$ReportData$Companion_getInstance();
    if (yAxis === void 0)
      yAxis = 0.0;
    if (xAxis === void 0)
      xAxis = '';
    if (subgroup === void 0)
      subgroup = '';
    this.yAxis = yAxis;
    this.xAxis = xAxis;
    this.subgroup = subgroup;
  }
  function StatementDao$ReportData$Companion() {
    StatementDao$ReportData$Companion_instance = this;
  }
  StatementDao$ReportData$Companion.prototype.serializer = function () {
    return StatementDao$ReportData$$serializer_getInstance();
  };
  StatementDao$ReportData$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var StatementDao$ReportData$Companion_instance = null;
  function StatementDao$ReportData$Companion_getInstance() {
    if (StatementDao$ReportData$Companion_instance === null) {
      new StatementDao$ReportData$Companion();
    }return StatementDao$ReportData$Companion_instance;
  }
  function StatementDao$ReportData$$serializer() {
    this.descriptor_fz3nhr$_0 = new PluginGeneratedSerialDescriptor('com.ustadmobile.core.db.dao.StatementDao.ReportData', this, 3);
    this.descriptor.addElement_ivxn3r$('yAxis', true);
    this.descriptor.addElement_ivxn3r$('xAxis', true);
    this.descriptor.addElement_ivxn3r$('subgroup', true);
    StatementDao$ReportData$$serializer_instance = this;
  }
  Object.defineProperty(StatementDao$ReportData$$serializer.prototype, 'descriptor', {configurable: true, get: function () {
    return this.descriptor_fz3nhr$_0;
  }});
  StatementDao$ReportData$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    if (!equals(value.yAxis, 0.0) || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 0))
      output.encodeFloatElement_lf6hpt$(this.descriptor, 0, value.yAxis);
    if (!equals(value.xAxis, '') || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 1))
      output.encodeNullableSerializableElement_qw92s8$(this.descriptor, 1, internal.StringSerializer, value.xAxis);
    if (!equals(value.subgroup, '') || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 2))
      output.encodeNullableSerializableElement_qw92s8$(this.descriptor, 2, internal.StringSerializer, value.subgroup);
    output.endStructure_24f42q$(this.descriptor);
  };
  StatementDao$ReportData$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0, local1, local2;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeFloatElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeNullableSerializableElement_8viuyw$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          break;
        case 2:
          local2 = input.decodeNullableSerializableElement_8viuyw$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return StatementDao$StatementDao$ReportData_init(bitMask0, local0, local1, local2, null);
  };
  StatementDao$ReportData$$serializer.prototype.childSerializers = function () {
    return [internal.FloatSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer)];
  };
  StatementDao$ReportData$$serializer.$metadata$ = {kind: Kind_OBJECT, simpleName: '$serializer', interfaces: [GeneratedSerializer]};
  var StatementDao$ReportData$$serializer_instance = null;
  function StatementDao$ReportData$$serializer_getInstance() {
    if (StatementDao$ReportData$$serializer_instance === null) {
      new StatementDao$ReportData$$serializer();
    }return StatementDao$ReportData$$serializer_instance;
  }
  function StatementDao$StatementDao$ReportData_init(seen1, yAxis, xAxis, subgroup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(StatementDao$ReportData.prototype);
    if ((seen1 & 1) === 0)
      $this.yAxis = 0.0;
    else
      $this.yAxis = yAxis;
    if ((seen1 & 2) === 0)
      $this.xAxis = '';
    else
      $this.xAxis = xAxis;
    if ((seen1 & 4) === 0)
      $this.subgroup = '';
    else
      $this.subgroup = subgroup;
    return $this;
  }
  StatementDao$ReportData.$metadata$ = {kind: Kind_CLASS, simpleName: 'ReportData', interfaces: []};
  StatementDao$ReportData.prototype.component1 = function () {
    return this.yAxis;
  };
  StatementDao$ReportData.prototype.component2 = function () {
    return this.xAxis;
  };
  StatementDao$ReportData.prototype.component3 = function () {
    return this.subgroup;
  };
  StatementDao$ReportData.prototype.copy_9c0xch$ = function (yAxis, xAxis, subgroup) {
    return new StatementDao$ReportData(yAxis === void 0 ? this.yAxis : yAxis, xAxis === void 0 ? this.xAxis : xAxis, subgroup === void 0 ? this.subgroup : subgroup);
  };
  StatementDao$ReportData.prototype.toString = function () {
    return 'ReportData(yAxis=' + Kotlin.toString(this.yAxis) + (', xAxis=' + Kotlin.toString(this.xAxis)) + (', subgroup=' + Kotlin.toString(this.subgroup)) + ')';
  };
  StatementDao$ReportData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.yAxis) | 0;
    result = result * 31 + Kotlin.hashCode(this.xAxis) | 0;
    result = result * 31 + Kotlin.hashCode(this.subgroup) | 0;
    return result;
  };
  StatementDao$ReportData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.yAxis, other.yAxis) && Kotlin.equals(this.xAxis, other.xAxis) && Kotlin.equals(this.subgroup, other.subgroup)))));
  };
  function StatementDao$Companion() {
    StatementDao$Companion_instance = this;
    this.SORT_FIRST_NAME_ASC = 1;
    this.SORT_FIRST_NAME_DESC = 2;
    this.SORT_LAST_NAME_ASC = 3;
    this.SORT_LAST_NAME_DESC = 4;
    this.SORT_LAST_ACTIVE_ASC = 5;
    this.SORT_LAST_ACTIVE_DESC = 6;
  }
  StatementDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var StatementDao$Companion_instance = null;
  function StatementDao$Companion_getInstance() {
    if (StatementDao$Companion_instance === null) {
      new StatementDao$Companion();
    }return StatementDao$Companion_instance;
  }
  StatementDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'StatementDao', interfaces: [BaseDao]};
  function SyncNodeDao() {
  }
  SyncNodeDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'SyncNodeDao', interfaces: []};
  function UserSessionDao() {
    UserSessionDao$Companion_getInstance();
  }
  function UserSessionDao$Companion() {
    UserSessionDao$Companion_instance = this;
    this.FIND_LOCAL_SESSIONS_SQL = '\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ';
  }
  UserSessionDao$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var UserSessionDao$Companion_instance = null;
  function UserSessionDao$Companion_getInstance() {
    if (UserSessionDao$Companion_instance === null) {
      new UserSessionDao$Companion();
    }return UserSessionDao$Companion_instance;
  }
  UserSessionDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'UserSessionDao', interfaces: []};
  function VerbDao() {
  }
  function Coroutine$initPreloadedVerbs($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$initPreloadedVerbs.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$initPreloadedVerbs.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$initPreloadedVerbs.prototype.constructor = Coroutine$initPreloadedVerbs;
  Coroutine$initPreloadedVerbs.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.findByUidList(toList_0(VerbEntity.Companion.FIXED_UIDS.values), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var uidsInserted = this.result_0;
            var $receiver = VerbEntity.Companion.FIXED_UIDS;
            var destination = LinkedHashMap_init();
            var tmp$;
            tmp$ = $receiver.entries.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              if (!uidsInserted.contains_11rb$(element.value)) {
                destination.put_xwzc9p$(element.key, element.value);
              }}

            var uidsToInsert = destination;
            var destination_0 = ArrayList_init(uidsToInsert.size);
            var tmp$_0;
            tmp$_0 = uidsToInsert.entries.iterator();
            while (tmp$_0.hasNext()) {
              var item = tmp$_0.next();
              destination_0.add_11rb$(VerbEntity_init(item.value, item.key));
            }

            var verbListToInsert = destination_0;
            this.state_0 = 3;
            this.result_0 = this.$this.replaceList(verbListToInsert, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  VerbDao.prototype.initPreloadedVerbs = function (continuation_0, suspended) {
    var instance = new Coroutine$initPreloadedVerbs(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  VerbDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'VerbDao', interfaces: [BaseDao]};
  function XLangMapEntryDao() {
  }
  function XLangMapEntryDao$Verb(verbLangMapUid, valueLangMap) {
    XLangMapEntryDao$Verb$Companion_getInstance();
    if (verbLangMapUid === void 0)
      verbLangMapUid = L0;
    if (valueLangMap === void 0)
      valueLangMap = '';
    this.verbLangMapUid = verbLangMapUid;
    this.valueLangMap = valueLangMap;
  }
  XLangMapEntryDao$Verb.prototype.toString = function () {
    return this.valueLangMap;
  };
  function XLangMapEntryDao$Verb$Companion() {
    XLangMapEntryDao$Verb$Companion_instance = this;
  }
  XLangMapEntryDao$Verb$Companion.prototype.serializer = function () {
    return XLangMapEntryDao$Verb$$serializer_getInstance();
  };
  XLangMapEntryDao$Verb$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var XLangMapEntryDao$Verb$Companion_instance = null;
  function XLangMapEntryDao$Verb$Companion_getInstance() {
    if (XLangMapEntryDao$Verb$Companion_instance === null) {
      new XLangMapEntryDao$Verb$Companion();
    }return XLangMapEntryDao$Verb$Companion_instance;
  }
  function XLangMapEntryDao$Verb$$serializer() {
    this.descriptor_gblzq7$_0 = new PluginGeneratedSerialDescriptor('com.ustadmobile.core.db.dao.XLangMapEntryDao.Verb', this, 2);
    this.descriptor.addElement_ivxn3r$('verbLangMapUid', true);
    this.descriptor.addElement_ivxn3r$('valueLangMap', true);
    XLangMapEntryDao$Verb$$serializer_instance = this;
  }
  Object.defineProperty(XLangMapEntryDao$Verb$$serializer.prototype, 'descriptor', {configurable: true, get: function () {
    return this.descriptor_gblzq7$_0;
  }});
  XLangMapEntryDao$Verb$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    if (!equals(value.verbLangMapUid, L0) || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 0))
      output.encodeLongElement_j0o2mv$(this.descriptor, 0, value.verbLangMapUid);
    if (!equals(value.valueLangMap, '') || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 1))
      output.encodeStringElement_iij8qq$(this.descriptor, 1, value.valueLangMap);
    output.endStructure_24f42q$(this.descriptor);
  };
  XLangMapEntryDao$Verb$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0, local1;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeLongElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeStringElement_szpzho$(this.descriptor, 1);
          bitMask0 |= 2;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return XLangMapEntryDao$XLangMapEntryDao$Verb_init(bitMask0, local0, local1, null);
  };
  XLangMapEntryDao$Verb$$serializer.prototype.childSerializers = function () {
    return [internal.LongSerializer, internal.StringSerializer];
  };
  XLangMapEntryDao$Verb$$serializer.$metadata$ = {kind: Kind_OBJECT, simpleName: '$serializer', interfaces: [GeneratedSerializer]};
  var XLangMapEntryDao$Verb$$serializer_instance = null;
  function XLangMapEntryDao$Verb$$serializer_getInstance() {
    if (XLangMapEntryDao$Verb$$serializer_instance === null) {
      new XLangMapEntryDao$Verb$$serializer();
    }return XLangMapEntryDao$Verb$$serializer_instance;
  }
  function XLangMapEntryDao$XLangMapEntryDao$Verb_init(seen1, verbLangMapUid, valueLangMap, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(XLangMapEntryDao$Verb.prototype);
    if ((seen1 & 1) === 0)
      $this.verbLangMapUid = L0;
    else
      $this.verbLangMapUid = verbLangMapUid;
    if ((seen1 & 2) === 0)
      $this.valueLangMap = '';
    else
      $this.valueLangMap = valueLangMap;
    return $this;
  }
  XLangMapEntryDao$Verb.$metadata$ = {kind: Kind_CLASS, simpleName: 'Verb', interfaces: []};
  XLangMapEntryDao$Verb.prototype.component1 = function () {
    return this.verbLangMapUid;
  };
  XLangMapEntryDao$Verb.prototype.component2 = function () {
    return this.valueLangMap;
  };
  XLangMapEntryDao$Verb.prototype.copy_a4hdmt$ = function (verbLangMapUid, valueLangMap) {
    return new XLangMapEntryDao$Verb(verbLangMapUid === void 0 ? this.verbLangMapUid : verbLangMapUid, valueLangMap === void 0 ? this.valueLangMap : valueLangMap);
  };
  XLangMapEntryDao$Verb.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.verbLangMapUid) | 0;
    result = result * 31 + Kotlin.hashCode(this.valueLangMap) | 0;
    return result;
  };
  XLangMapEntryDao$Verb.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.verbLangMapUid, other.verbLangMapUid) && Kotlin.equals(this.valueLangMap, other.valueLangMap)))));
  };
  function XLangMapEntryDao$XObject(objectLangMapUid, valueLangMap) {
    XLangMapEntryDao$XObject$Companion_getInstance();
    if (objectLangMapUid === void 0)
      objectLangMapUid = L0;
    if (valueLangMap === void 0)
      valueLangMap = '';
    this.objectLangMapUid = objectLangMapUid;
    this.valueLangMap = valueLangMap;
  }
  XLangMapEntryDao$XObject.prototype.toString = function () {
    return this.valueLangMap;
  };
  function XLangMapEntryDao$XObject$Companion() {
    XLangMapEntryDao$XObject$Companion_instance = this;
  }
  XLangMapEntryDao$XObject$Companion.prototype.serializer = function () {
    return XLangMapEntryDao$XObject$$serializer_getInstance();
  };
  XLangMapEntryDao$XObject$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var XLangMapEntryDao$XObject$Companion_instance = null;
  function XLangMapEntryDao$XObject$Companion_getInstance() {
    if (XLangMapEntryDao$XObject$Companion_instance === null) {
      new XLangMapEntryDao$XObject$Companion();
    }return XLangMapEntryDao$XObject$Companion_instance;
  }
  function XLangMapEntryDao$XObject$$serializer() {
    this.descriptor_dxxfr5$_0 = new PluginGeneratedSerialDescriptor('com.ustadmobile.core.db.dao.XLangMapEntryDao.XObject', this, 2);
    this.descriptor.addElement_ivxn3r$('objectLangMapUid', true);
    this.descriptor.addElement_ivxn3r$('valueLangMap', true);
    XLangMapEntryDao$XObject$$serializer_instance = this;
  }
  Object.defineProperty(XLangMapEntryDao$XObject$$serializer.prototype, 'descriptor', {configurable: true, get: function () {
    return this.descriptor_dxxfr5$_0;
  }});
  XLangMapEntryDao$XObject$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    if (!equals(value.objectLangMapUid, L0) || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 0))
      output.encodeLongElement_j0o2mv$(this.descriptor, 0, value.objectLangMapUid);
    if (!equals(value.valueLangMap, '') || output.shouldEncodeElementDefault_szpzho$(this.descriptor, 1))
      output.encodeStringElement_iij8qq$(this.descriptor, 1, value.valueLangMap);
    output.endStructure_24f42q$(this.descriptor);
  };
  XLangMapEntryDao$XObject$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0, local1;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeLongElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeStringElement_szpzho$(this.descriptor, 1);
          bitMask0 |= 2;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return XLangMapEntryDao$XLangMapEntryDao$XObject_init(bitMask0, local0, local1, null);
  };
  XLangMapEntryDao$XObject$$serializer.prototype.childSerializers = function () {
    return [internal.LongSerializer, internal.StringSerializer];
  };
  XLangMapEntryDao$XObject$$serializer.$metadata$ = {kind: Kind_OBJECT, simpleName: '$serializer', interfaces: [GeneratedSerializer]};
  var XLangMapEntryDao$XObject$$serializer_instance = null;
  function XLangMapEntryDao$XObject$$serializer_getInstance() {
    if (XLangMapEntryDao$XObject$$serializer_instance === null) {
      new XLangMapEntryDao$XObject$$serializer();
    }return XLangMapEntryDao$XObject$$serializer_instance;
  }
  function XLangMapEntryDao$XLangMapEntryDao$XObject_init(seen1, objectLangMapUid, valueLangMap, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(XLangMapEntryDao$XObject.prototype);
    if ((seen1 & 1) === 0)
      $this.objectLangMapUid = L0;
    else
      $this.objectLangMapUid = objectLangMapUid;
    if ((seen1 & 2) === 0)
      $this.valueLangMap = '';
    else
      $this.valueLangMap = valueLangMap;
    return $this;
  }
  XLangMapEntryDao$XObject.$metadata$ = {kind: Kind_CLASS, simpleName: 'XObject', interfaces: []};
  XLangMapEntryDao$XObject.prototype.component1 = function () {
    return this.objectLangMapUid;
  };
  XLangMapEntryDao$XObject.prototype.component2 = function () {
    return this.valueLangMap;
  };
  XLangMapEntryDao$XObject.prototype.copy_a4hdmt$ = function (objectLangMapUid, valueLangMap) {
    return new XLangMapEntryDao$XObject(objectLangMapUid === void 0 ? this.objectLangMapUid : objectLangMapUid, valueLangMap === void 0 ? this.valueLangMap : valueLangMap);
  };
  XLangMapEntryDao$XObject.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.objectLangMapUid) | 0;
    result = result * 31 + Kotlin.hashCode(this.valueLangMap) | 0;
    return result;
  };
  XLangMapEntryDao$XObject.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.objectLangMapUid, other.objectLangMapUid) && Kotlin.equals(this.valueLangMap, other.valueLangMap)))));
  };
  XLangMapEntryDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'XLangMapEntryDao', interfaces: [BaseDao]};
  function XObjectDao() {
  }
  XObjectDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'XObjectDao', interfaces: [BaseDao]};
  function addSyncCallback($receiver, nodeIdAndAuth) {
    $receiver.addCallback_zdc9ji$(new SyncNodeIdCallback(nodeIdAndAuth.nodeId));
    return $receiver;
  }
  function CustomFieldDao() {
  }
  CustomFieldDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CustomFieldDao', interfaces: [BaseDao]};
  function CustomFieldValueDao() {
  }
  CustomFieldValueDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CustomFieldValueDao', interfaces: [BaseDao]};
  function CustomFieldValueOptionDao() {
  }
  CustomFieldValueOptionDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'CustomFieldValueOptionDao', interfaces: [BaseDao]};
  function ScheduledCheckDao() {
  }
  ScheduledCheckDao.$metadata$ = {kind: Kind_CLASS, simpleName: 'ScheduledCheckDao', interfaces: [BaseDao]};
  Object.defineProperty(ContentJobItemTriggersCallback, 'Companion', {get: ContentJobItemTriggersCallback$Companion_getInstance});
  var package$com = _.com || (_.com = {});
  var package$ustadmobile = package$com.ustadmobile || (package$com.ustadmobile = {});
  var package$core = package$ustadmobile.core || (package$ustadmobile.core = {});
  var package$db = package$core.db || (package$core.db = {});
  package$db.ContentJobItemTriggersCallback = ContentJobItemTriggersCallback;
  package$db.SiteTermsDao = SiteTermsDao;
  Object.defineProperty(UmAppDatabase, 'Companion', {get: UmAppDatabase$Companion_getInstance});
  package$db.UmAppDatabase = UmAppDatabase;
  var package$dao = package$db.dao || (package$db.dao = {});
  package$dao.AgentDao = AgentDao;
  package$dao.BaseDao = BaseDao;
  package$dao.ChatDao = ChatDao;
  package$dao.ChatMemberDao = ChatMemberDao;
  Object.defineProperty(ClazzAssignmentContentJoinDao, 'Companion', {get: ClazzAssignmentContentJoinDao$Companion_getInstance});
  package$dao.ClazzAssignmentContentJoinDao = ClazzAssignmentContentJoinDao;
  Object.defineProperty(ClazzAssignmentDao, 'Companion', {get: ClazzAssignmentDao$Companion_getInstance});
  package$dao.ClazzAssignmentDao = ClazzAssignmentDao;
  package$dao.ClazzAssignmentRollUpDao = ClazzAssignmentRollUpDao;
  package$dao.ClazzContentJoinDao = ClazzContentJoinDao;
  Object.defineProperty(ClazzDao, 'Companion', {get: ClazzDao$Companion_getInstance});
  package$dao.ClazzDao = ClazzDao;
  Object.defineProperty(ClazzEnrolmentDao, 'Companion', {get: ClazzEnrolmentDao$Companion_getInstance});
  package$dao.ClazzEnrolmentDao = ClazzEnrolmentDao;
  package$dao.ClazzLogAttendanceRecordDao = ClazzLogAttendanceRecordDao;
  package$dao.ClazzLogDao = ClazzLogDao;
  package$dao.CommentsDao = CommentsDao;
  package$dao.ConnectivityStatusDao = ConnectivityStatusDao;
  Object.defineProperty(ContainerDao, 'Companion', {get: ContainerDao$Companion_getInstance});
  package$dao.ContainerDao = ContainerDao;
  package$dao.ContainerETagDao = ContainerETagDao;
  package$dao.ContainerEntryDao = ContainerEntryDao;
  Object.defineProperty(ContainerEntryFileDao, 'Companion', {get: ContainerEntryFileDao$Companion_getInstance});
  package$dao.ContainerEntryFileDao = ContainerEntryFileDao;
  package$dao.ContainerImportJobDao = ContainerImportJobDao;
  package$dao.ContentCategoryDao = ContentCategoryDao;
  package$dao.ContentCategorySchemaDao = ContentCategorySchemaDao;
  package$dao.ContentEntryContentCategoryJoinDao = ContentEntryContentCategoryJoinDao;
  Object.defineProperty(ContentEntryDao, 'Companion', {get: ContentEntryDao$Companion_getInstance});
  package$dao.ContentEntryDao = ContentEntryDao;
  package$dao.ContentEntryParentChildJoinDao = ContentEntryParentChildJoinDao;
  package$dao.ContentEntryPictureDao = ContentEntryPictureDao;
  package$dao.ContentEntryRelatedEntryJoinDao = ContentEntryRelatedEntryJoinDao;
  package$dao.ContentJobDao = ContentJobDao;
  package$dao.ContentJobItemDao = ContentJobItemDao;
  Object.defineProperty(ContextXObjectStatementJoinDao, 'Companion', {get: ContextXObjectStatementJoinDao$Companion_getInstance});
  package$dao.ContextXObjectStatementJoinDao = ContextXObjectStatementJoinDao;
  package$dao.CourseAssignmentMarkDao = CourseAssignmentMarkDao;
  package$dao.CourseAssignmentSubmissionAttachmentDao = CourseAssignmentSubmissionAttachmentDao;
  Object.defineProperty(CourseAssignmentSubmissionDao, 'Companion', {get: CourseAssignmentSubmissionDao$Companion_getInstance});
  package$dao.CourseAssignmentSubmissionDao = CourseAssignmentSubmissionDao;
  Object.defineProperty(CourseBlockDao, 'Companion', {get: CourseBlockDao$Companion_getInstance});
  package$dao.CourseBlockDao = CourseBlockDao;
  package$dao.CourseDiscussionDao = CourseDiscussionDao;
  package$dao.CourseGroupMemberDao = CourseGroupMemberDao;
  package$dao.CourseGroupSetDao = CourseGroupSetDao;
  Object.defineProperty(CoursePictureDao, 'Companion', {get: CoursePictureDao$Companion_getInstance});
  package$dao.CoursePictureDao = CoursePictureDao;
  package$dao.CourseTerminologyDao = CourseTerminologyDao;
  package$dao.DiscussionPostDao = DiscussionPostDao;
  package$dao.DiscussionTopicDao = DiscussionTopicDao;
  Object.defineProperty(EntityRoleDao, 'Companion', {get: EntityRoleDao$Companion_getInstance});
  package$dao.EntityRoleDao = EntityRoleDao;
  package$dao.ErrorReportDao = ErrorReportDao;
  package$dao.GroupLearningSessionDao = GroupLearningSessionDao;
  package$dao.HolidayCalendarDao = HolidayCalendarDao;
  package$dao.HolidayDao = HolidayDao;
  Object.defineProperty(LanguageDao, 'Companion', {get: LanguageDao$Companion_getInstance});
  package$dao.LanguageDao = LanguageDao;
  package$dao.LanguageVariantDao = LanguageVariantDao;
  package$dao.LearnerGroupDao = LearnerGroupDao;
  package$dao.LearnerGroupMemberDao = LearnerGroupMemberDao;
  package$dao.LeavingReasonDao = LeavingReasonDao;
  package$dao.LocallyAvailableContainerDao = LocallyAvailableContainerDao;
  package$dao.MessageDao = MessageDao;
  package$dao.MessageReadDao = MessageReadDao;
  Object.defineProperty(NetworkNodeDao, 'Companion', {get: NetworkNodeDao$Companion_getInstance});
  package$dao.NetworkNodeDao = NetworkNodeDao;
  package$dao.OneToManyJoinDao = OneToManyJoinDao;
  package$dao.PersonAuth2Dao = PersonAuth2Dao;
  Object.defineProperty(PersonAuthDao, 'Companion', {get: PersonAuthDao$Companion_getInstance});
  package$dao.PersonAuthDao = PersonAuthDao;
  PersonDao.PersonUidAndPasswordHash = PersonDao$PersonUidAndPasswordHash;
  Object.defineProperty(PersonDao, 'Companion', {get: PersonDao$Companion_getInstance});
  Object.defineProperty(PersonDao$PersonNameAndUid, 'Companion', {get: PersonDao$PersonNameAndUid$Companion_getInstance});
  Object.defineProperty(PersonDao$PersonNameAndUid, '$serializer', {get: PersonDao$PersonNameAndUid$$serializer_getInstance});
  PersonDao.PersonNameAndUid_init_wok9wd$ = PersonDao$PersonDao$PersonNameAndUid_init;
  PersonDao.PersonNameAndUid = PersonDao$PersonNameAndUid;
  package$dao.PersonDao = PersonDao;
  package$dao.PersonGroupDao = PersonGroupDao;
  package$dao.PersonGroupMemberDao = PersonGroupMemberDao;
  PersonParentJoinDao.ParentEnrolmentRequired = PersonParentJoinDao$ParentEnrolmentRequired;
  package$dao.PersonParentJoinDao = PersonParentJoinDao;
  Object.defineProperty(PersonPictureDao, 'Companion', {get: PersonPictureDao$Companion_getInstance});
  package$dao.PersonPictureDao = PersonPictureDao;
  Object.defineProperty(ReportDao, 'Companion', {get: ReportDao$Companion_getInstance});
  package$dao.ReportDao = ReportDao;
  package$dao.ScheduleDao = ScheduleDao;
  Object.defineProperty(SchoolDao, 'Companion', {get: SchoolDao$Companion_getInstance});
  package$dao.SchoolDao = SchoolDao;
  Object.defineProperty(SchoolMemberDao, 'Companion', {get: SchoolMemberDao$Companion_getInstance});
  package$dao.SchoolMemberDao = SchoolMemberDao;
  Object.defineProperty(ScopedGrantDao, 'Companion', {get: ScopedGrantDao$Companion_getInstance});
  package$dao.ScopedGrantDao = ScopedGrantDao;
  Object.defineProperty(ScrapeQueueItemDao, 'Companion', {get: ScrapeQueueItemDao$Companion_getInstance});
  package$dao.ScrapeQueueItemDao = ScrapeQueueItemDao;
  Object.defineProperty(ScrapeRunDao, 'Companion', {get: ScrapeRunDao$Companion_getInstance});
  package$dao.ScrapeRunDao = ScrapeRunDao;
  package$dao.SiteDao = SiteDao;
  package$dao.StateContentDao = StateContentDao;
  package$dao.StateDao = StateDao;
  Object.defineProperty(StatementDao$ReportData, 'Companion', {get: StatementDao$ReportData$Companion_getInstance});
  Object.defineProperty(StatementDao$ReportData, '$serializer', {get: StatementDao$ReportData$$serializer_getInstance});
  StatementDao.ReportData_init_hn5lyq$ = StatementDao$StatementDao$ReportData_init;
  StatementDao.ReportData = StatementDao$ReportData;
  Object.defineProperty(StatementDao, 'Companion', {get: StatementDao$Companion_getInstance});
  package$dao.StatementDao = StatementDao;
  package$dao.SyncNodeDao = SyncNodeDao;
  Object.defineProperty(UserSessionDao, 'Companion', {get: UserSessionDao$Companion_getInstance});
  package$dao.UserSessionDao = UserSessionDao;
  package$dao.VerbDao = VerbDao;
  Object.defineProperty(XLangMapEntryDao$Verb, 'Companion', {get: XLangMapEntryDao$Verb$Companion_getInstance});
  Object.defineProperty(XLangMapEntryDao$Verb, '$serializer', {get: XLangMapEntryDao$Verb$$serializer_getInstance});
  XLangMapEntryDao.Verb_init_wok9wd$ = XLangMapEntryDao$XLangMapEntryDao$Verb_init;
  XLangMapEntryDao.Verb = XLangMapEntryDao$Verb;
  Object.defineProperty(XLangMapEntryDao$XObject, 'Companion', {get: XLangMapEntryDao$XObject$Companion_getInstance});
  Object.defineProperty(XLangMapEntryDao$XObject, '$serializer', {get: XLangMapEntryDao$XObject$$serializer_getInstance});
  XLangMapEntryDao.XObject_init_wok9wd$ = XLangMapEntryDao$XLangMapEntryDao$XObject_init;
  XLangMapEntryDao.XObject = XLangMapEntryDao$XObject;
  package$dao.XLangMapEntryDao = XLangMapEntryDao;
  package$dao.XObjectDao = XObjectDao;
  var package$ext = package$db.ext || (package$db.ext = {});
  package$ext.addSyncCallback_oam1fn$ = addSyncCallback;
  package$dao.CustomFieldDao = CustomFieldDao;
  package$dao.CustomFieldValueDao = CustomFieldValueDao;
  package$dao.CustomFieldValueOptionDao = CustomFieldValueOptionDao;
  package$dao.ScheduledCheckDao = ScheduledCheckDao;
  PersonDao$PersonNameAndUid$$serializer.prototype.typeParametersSerializers = GeneratedSerializer.prototype.typeParametersSerializers;
  StatementDao$ReportData$$serializer.prototype.typeParametersSerializers = GeneratedSerializer.prototype.typeParametersSerializers;
  XLangMapEntryDao$Verb$$serializer.prototype.typeParametersSerializers = GeneratedSerializer.prototype.typeParametersSerializers;
  XLangMapEntryDao$XObject$$serializer.prototype.typeParametersSerializers = GeneratedSerializer.prototype.typeParametersSerializers;
  UmAppDatabaseReplicationMigration91_92 = new DoorMigrationSync(91, 92, UmAppDatabaseReplicationMigration91_92$lambda);
  return _;
}));

//# sourceMappingURL=UstadMobile-lib-database.js.map
