(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-coroutines-core', 'door-door-runtime', 'xmlpullparserkmp-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-coroutines-core'), require('door-door-runtime'), require('xmlpullparserkmp-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'UstadMobile-lib-util'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'UstadMobile-lib-util'.");
    }if (typeof this['door-door-runtime'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'door-door-runtime' was not found. Please, check whether 'door-door-runtime' is loaded prior to 'UstadMobile-lib-util'.");
    }if (typeof this['xmlpullparserkmp-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'xmlpullparserkmp-js-legacy' was not found. Please, check whether 'xmlpullparserkmp-js-legacy' is loaded prior to 'UstadMobile-lib-util'.");
    }root['UstadMobile-lib-util'] = factory(typeof this['UstadMobile-lib-util'] === 'undefined' ? {} : this['UstadMobile-lib-util'], kotlin, this['kotlinx-coroutines-core'], this['door-door-runtime'], this['xmlpullparserkmp-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kotlinx_coroutines_core, $module$door_door_runtime, $module$xmlpullparserkmp_js_legacy) {
  'use strict';
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var DoorObserver = $module$door_door_runtime.com.ustadmobile.door.DoorObserver;
  var withTimeoutOrNull = $module$kotlinx_coroutines_core.kotlinx.coroutines.withTimeoutOrNull_ms3uf5$;
  var L5000 = Kotlin.Long.fromInt(5000);
  var CompletableDeferred = $module$kotlinx_coroutines_core.kotlinx.coroutines.CompletableDeferred_xptg6w$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var substringBefore = Kotlin.kotlin.text.substringBefore_8cymmc$;
  var substringAfter = Kotlin.kotlin.text.substringAfter_j4ogox$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var Random = Kotlin.kotlin.random.Random;
  var toBoxedChar = Kotlin.toBoxedChar;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var L_1 = Kotlin.Long.NEG_ONE;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var L0 = Kotlin.Long.ZERO;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var equals = Kotlin.equals;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var Exception = Kotlin.kotlin.Exception;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var removePrefix = Kotlin.kotlin.text.removePrefix_gsj5wt$;
  var xmlpullparserkmp = $module$xmlpullparserkmp_js_legacy.com.ustadmobile.xmlpullparserkmp;
  var toString = Kotlin.toString;
  var contains = Kotlin.kotlin.collections.contains_mjy6jw$;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var mutableListOf = Kotlin.kotlin.collections.mutableListOf_i5x0yv$;
  var mutableMapOf = Kotlin.kotlin.collections.mutableMapOf_qfcya0$;
  function UmLifecycleOwner() {
    UmLifecycleOwner$Companion_getInstance();
  }
  function UmLifecycleOwner$Companion() {
    UmLifecycleOwner$Companion_instance = this;
    this.STATUS_CREATED = 1;
    this.STATUS_STARTED = 2;
    this.STATUS_RESUMED = 3;
    this.STATUS_PAUSED = 4;
    this.STATUS_STOPPED = 5;
    this.STATUS_DESTROYED = 6;
  }
  UmLifecycleOwner$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var UmLifecycleOwner$Companion_instance = null;
  function UmLifecycleOwner$Companion_getInstance() {
    if (UmLifecycleOwner$Companion_instance === null) {
      new UmLifecycleOwner$Companion();
    }return UmLifecycleOwner$Companion_instance;
  }
  UmLifecycleOwner.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'UmLifecycleOwner', interfaces: []};
  var CHAR_POOL_DEFAULT;
  function randomString(length, charPool) {
    if (charPool === void 0)
      charPool = CHAR_POOL_DEFAULT;
    var $receiver = new IntRange(1, length);
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(toBoxedChar(charPool.charCodeAt(Random.Default.nextInt_vux9f0$(0, charPool.length))));
    }
    return joinToString(destination, '');
  }
  var RANGE_CONTENT_LENGTH_HEADER;
  var RANGE_CONTENT_RANGE_HEADER;
  var RANGE_CONTENT_ACCEPT_RANGE_HEADER;
  var sanitizeRegex;
  function sanitizeDbNameFromUrl(url) {
    var $receiver = removePrefix(removePrefix(url, 'https://'), 'http://');
    return sanitizeRegex.replace_x2uqeu$($receiver, '_');
  }
  var SEPARATE_END_TAG_REQUIRED_ELEMENTS;
  function authenticateEncryptedPassword(providedPassword, encryptedPassword) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  }
  function encryptPassword(originalPassword) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  }
  function getSystemTimeInMillis() {
    return Kotlin.Long.fromNumber((new Date()).getTime());
  }
  function getDefaultTimeZoneId() {
    var tmp$;
    return typeof (tmp$ = Intl.DateTimeFormat().resolvedOptions().timeZone) === 'string' ? tmp$ : throwCCE();
  }
  function copyOnWriteListOf(items) {
    return mutableListOf(items.slice());
  }
  function fixTincan($receiver) {
  }
  var package$com = _.com || (_.com = {});
  var package$ustadmobile = package$com.ustadmobile || (package$com.ustadmobile = {});
  var package$core = package$ustadmobile.core || (package$ustadmobile.core = {});
  var package$impl = package$core.impl || (package$core.impl = {});
  Object.defineProperty(UmLifecycleOwner, 'Companion', {get: UmLifecycleOwner$Companion_getInstance});
  package$impl.UmLifecycleOwner = UmLifecycleOwner;
  var package$lib = package$ustadmobile.lib || (package$ustadmobile.lib = {});
  var package$util = package$lib.util || (package$lib.util = {});
  package$util.randomString_19mbxw$ = randomString;
  package$util.sanitizeDbNameFromUrl_61zpoe$ = sanitizeDbNameFromUrl;
  var package$ext = package$util.ext || (package$util.ext = {});
  package$util.authenticateEncryptedPassword_puj7f4$ = authenticateEncryptedPassword;
  package$util.encryptPassword_61zpoe$ = encryptPassword;
  package$util.getSystemTimeInMillis = getSystemTimeInMillis;
  package$util.getDefaultTimeZoneId = getDefaultTimeZoneId;
  package$util.copyOnWriteListOf_i5x0yv$ = copyOnWriteListOf;
  package$ext.fixTincan_omobsc$ = fixTincan;
  CHAR_POOL_DEFAULT = 'abcdefghikjmnpqrstuvxwyz23456789';
  RANGE_CONTENT_LENGTH_HEADER = 'Content-Length';
  RANGE_CONTENT_RANGE_HEADER = 'Content-Range';
  RANGE_CONTENT_ACCEPT_RANGE_HEADER = 'Accept-Ranges';
  sanitizeRegex = Regex_init('\\W');
  SEPARATE_END_TAG_REQUIRED_ELEMENTS = ['script', 'style', 'title'];
  return _;
}));

//# sourceMappingURL=UstadMobile-lib-util.js.map
