(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'ktor-ktor-http-js-legacy', 'ktor-ktor-io-js-legacy', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('ktor-ktor-http-js-legacy'), require('ktor-ktor-io-js-legacy'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-http-cio-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'ktor-ktor-http-cio-js-legacy'.");
    }if (typeof this['ktor-ktor-http-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-http-cio-js-legacy'. Its dependency 'ktor-ktor-http-js-legacy' was not found. Please, check whether 'ktor-ktor-http-js-legacy' is loaded prior to 'ktor-ktor-http-cio-js-legacy'.");
    }if (typeof this['ktor-ktor-io-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-http-cio-js-legacy'. Its dependency 'ktor-ktor-io-js-legacy' was not found. Please, check whether 'ktor-ktor-io-js-legacy' is loaded prior to 'ktor-ktor-http-cio-js-legacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-http-cio-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'ktor-ktor-http-cio-js-legacy'.");
    }root['ktor-ktor-http-cio-js-legacy'] = factory(typeof this['ktor-ktor-http-cio-js-legacy'] === 'undefined' ? {} : this['ktor-ktor-http-cio-js-legacy'], kotlin, this['ktor-ktor-http-js-legacy'], this['ktor-ktor-io-js-legacy'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$ktor_ktor_http_js_legacy, $module$ktor_ktor_io_js_legacy, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var toList = Kotlin.kotlin.sequences.toList_veqyi0$;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var toSet = Kotlin.kotlin.collections.toSet_7wnvza$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Map$Entry = Kotlin.kotlin.collections.Map.Entry;
  var LazyThreadSafetyMode = Kotlin.kotlin.LazyThreadSafetyMode;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_ww73n8$;
  var lazy = Kotlin.kotlin.lazy_kls4a0$;
  var Headers = $module$ktor_ktor_http_js_legacy.io.ktor.http.Headers;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init_za3lpa$;
  var DefaultPool = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.pool.DefaultPool;
  var L_1 = Kotlin.Long.NEG_ONE;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var writer = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.writer_x9a1ni$;
  var L0 = Kotlin.Long.ZERO;
  var EOFException = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.errors.EOFException;
  var copyTo = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.copyTo_47ygvz$;
  var equals = Kotlin.equals;
  var Throwable = Error;
  var close = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.close_x5qia6$;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var writeFully = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.writeFully_4scpqu$;
  var ByteChannel = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.ByteChannel;
  var requestBuffer = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.requestBuffer_78elpf$;
  var Buffer = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.Buffer;
  var completeReadingFromBuffer = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.completeReadingFromBuffer_6msh3s$;
  var charsets = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.charsets;
  var encodeToByteArray = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.charsets.encodeToByteArray_fj4osb$;
  var singleOrNull = Kotlin.kotlin.collections.singleOrNull_2p1efm$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var joinTo = Kotlin.kotlin.collections.joinTo_gcc71v$;
  var throwCCE = Kotlin.throwCCE;
  var hashCode = Kotlin.hashCode;
  var StringBuilder_init_0 = Kotlin.kotlin.text.StringBuilder_init;
  var HttpMethod = $module$ktor_ktor_http_js_legacy.io.ktor.http.HttpMethod;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var trimIndent = Kotlin.kotlin.text.trimIndent_pdl1vz$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var filter = Kotlin.kotlin.sequences.filter_euau3h$;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var Exception_init = Kotlin.kotlin.Exception_init_pdl1vj$;
  var Exception = Kotlin.kotlin.Exception;
  var setOf = Kotlin.kotlin.collections.setOf_i5x0yv$;
  var http = $module$ktor_ktor_http_js_legacy.io.ktor.http;
  var unboxChar = Kotlin.unboxChar;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var NumberFormatException = Kotlin.kotlin.NumberFormatException;
  var contains = Kotlin.kotlin.text.contains_sgbm27$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var Closeable = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.Closeable;
  var NoSuchElementException = Kotlin.kotlin.NoSuchElementException;
  var Array_0 = Array;
  var Collection = Kotlin.kotlin.collections.Collection;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var CharSequence = Kotlin.kotlin.CharSequence;
  var IndexOutOfBoundsException = Kotlin.kotlin.IndexOutOfBoundsException;
  var Appendable = Kotlin.kotlin.text.Appendable;
  var JsMath = Math;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var L48 = Kotlin.Long.fromInt(48);
  var L97 = Kotlin.Long.fromInt(97);
  var L102 = Kotlin.Long.fromInt(102);
  var L65 = Kotlin.Long.fromInt(65);
  var L70 = Kotlin.Long.fromInt(70);
  var toLongArray = Kotlin.kotlin.collections.toLongArray_558emf$;
  var toByte = Kotlin.toByte;
  var toChar = Kotlin.toChar;
  var toByteArray = Kotlin.kotlin.collections.toByteArray_kdx1v$;
  var isWhitespace = Kotlin.kotlin.text.isWhitespace_myv2d0$;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var writeFully_0 = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.writeFully_i6snlg$;
  var decode = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.charsets.decode_lb8wo3$;
  var readShort = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.readShort_7wsnj1$;
  var DisposableHandle = $module$kotlinx_coroutines_core.kotlinx.coroutines.DisposableHandle;
  var BytePacketBuilder = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.BytePacketBuilder_za3lpa$;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_m7z4lg$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var Annotation = Kotlin.kotlin.Annotation;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Unit = Kotlin.kotlin.Unit;
  var asSequence = Kotlin.kotlin.collections.asSequence_7wnvza$;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var substring = Kotlin.kotlin.text.substring_fc3b62$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var drop = Kotlin.kotlin.collections.drop_ba2ldo$;
  var CancellationException = Kotlin.kotlin.coroutines.cancellation.CancellationException;
  var writeText = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.writeText_t153jy$;
  var readBytes = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.readBytes_xc9h3n$;
  var writeShort = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.writeShort_9kfkzl$;
  var CoroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineScope;
  ChunkSizeBufferPool$ObjectLiteral.prototype = Object.create(DefaultPool.prototype);
  ChunkSizeBufferPool$ObjectLiteral.prototype.constructor = ChunkSizeBufferPool$ObjectLiteral;
  IntArrayPool$ObjectLiteral.prototype = Object.create(DefaultPool.prototype);
  IntArrayPool$ObjectLiteral.prototype.constructor = IntArrayPool$ObjectLiteral;
  CharArrayPool$ObjectLiteral.prototype = Object.create(DefaultPool.prototype);
  CharArrayPool$ObjectLiteral.prototype.constructor = CharArrayPool$ObjectLiteral;
  CloseReason$Codes.prototype = Object.create(Enum.prototype);
  CloseReason$Codes.prototype.constructor = CloseReason$Codes;
  FrameType.prototype = Object.create(Enum.prototype);
  FrameType.prototype.constructor = FrameType;
  Frame$Binary.prototype = Object.create(Frame.prototype);
  Frame$Binary.prototype.constructor = Frame$Binary;
  Frame$Text.prototype = Object.create(Frame.prototype);
  Frame$Text.prototype.constructor = Frame$Text;
  Frame$Close.prototype = Object.create(Frame.prototype);
  Frame$Close.prototype.constructor = Frame$Close;
  Frame$Ping.prototype = Object.create(Frame.prototype);
  Frame$Ping.prototype.constructor = Frame$Ping;
  Frame$Pong.prototype = Object.create(Frame.prototype);
  Frame$Pong.prototype.constructor = Frame$Pong;
  function CIOHeaders(headers) {
    this.headers_0 = headers;
    this.names_pj02dq$_0 = lazy(LazyThreadSafetyMode.NONE, CIOHeaders$names$lambda(this));
  }
  var MAX_CHUNK_SIZE_LENGTH;
  var CHUNK_BUFFER_POOL_SIZE;
  var DEFAULT_BYTE_BUFFER_SIZE;
  function ChunkSizeBufferPool$ObjectLiteral(capacity) {
    DefaultPool.call(this, capacity);
  }
  ChunkSizeBufferPool$ObjectLiteral.prototype.produceInstance = function () {
    return StringBuilder_init(128);
  };
  ChunkSizeBufferPool$ObjectLiteral.prototype.clearInstance_trkh7z$ = function (instance) {
    instance.clear();
    return instance;
  };
  ChunkSizeBufferPool$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [DefaultPool]};
  var ChunkSizeBufferPool;
  var CrLfShort;
  var CrLf;
  var LastChunkBytes;
  var ConnectionOptions$Companion_instance = null;
  var EXPECTED_HEADERS_QTY;
  var HEADER_SIZE;
  var HEADER_ARRAY_POOL_SIZE;
  var EMPTY_INT_ARRAY;
  function IntArrayPool$ObjectLiteral(capacity) {
    DefaultPool.call(this, capacity);
  }
  IntArrayPool$ObjectLiteral.prototype.produceInstance = function () {
    return new Int32Array(512);
  };
  IntArrayPool$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [DefaultPool]};
  var IntArrayPool;
  var HTTP_LINE_LIMIT;
  var HTTP_STATUS_CODE_MIN_RANGE;
  var HTTP_STATUS_CODE_MAX_RANGE;
  var hostForbiddenSymbols;
  var versions;
  var SP;
  var CR;
  var LF;
  function AsciiCharTree(root) {
    AsciiCharTree$Companion_getInstance();
    this.root = root;
  }
  function AsciiCharTree$Node(ch, exact, children) {
    this.ch = toBoxedChar(ch);
    this.exact = exact;
    this.children = children;
    var array = Array_0(256);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    loop_label: for (var i = 0; i <= tmp$; i++) {
      var $receiver = this.children;
      var singleOrNull$result;
      singleOrNull$break: do {
        var tmp$_0;
        var single = null;
        var found = false;
        tmp$_0 = $receiver.iterator();
        while (tmp$_0.hasNext()) {
          var element = tmp$_0.next();
          if ((unboxChar(element.ch) | 0) === i) {
            if (found) {
              singleOrNull$result = null;
              break singleOrNull$break;
            }single = element;
            found = true;
          }}
        if (!found) {
          singleOrNull$result = null;
          break singleOrNull$break;
        }singleOrNull$result = single;
      }
       while (false);
      array[i] = singleOrNull$result;
    }
    this.array = array;
  }
  AsciiCharTree$Node.$metadata$ = {kind: Kind_CLASS, simpleName: 'Node', interfaces: []};
  AsciiCharTree.prototype.search_5wmzmj$ = function (sequence, fromIdx, end, lowerCase, stopPredicate) {
    if (fromIdx === void 0)
      fromIdx = 0;
    if (end === void 0)
      end = sequence.length;
    if (lowerCase === void 0)
      lowerCase = false;
    var tmp$, tmp$_0;
    if (sequence.length === 0)
      throw IllegalArgumentException_init("Couldn't search in char tree for empty string");
    var node = this.root;
    for (var index = fromIdx; index < end; index++) {
      var current = sequence.charCodeAt(index);
      var currentCode = current | 0;
      if (stopPredicate(toBoxedChar(current), currentCode))
        break;
      tmp$_0 = (tmp$ = node.array[currentCode]) != null ? tmp$ : lowerCase ? node.array[String.fromCharCode(current).toLowerCase().charCodeAt(0) | 0] : null;
      if (tmp$_0 == null) {
        return emptyList();
      }var nextNode = tmp$_0;
      node = nextNode;
    }
    return node.exact;
  };
  function AsciiCharTree$Companion() {
    AsciiCharTree$Companion_instance = this;
  }
  function AsciiCharTree$Companion$build$lambda(it) {
    return it.length;
  }
  function AsciiCharTree$Companion$build$lambda_0(s, idx) {
    return toBoxedChar(s.charCodeAt(idx));
  }
  AsciiCharTree$Companion.prototype.build_mowv1r$ = function (from) {
    return this.build_za6fmz$(from, AsciiCharTree$Companion$build$lambda, AsciiCharTree$Companion$build$lambda_0);
  };
  AsciiCharTree$Companion.prototype.build_za6fmz$ = function (from, length, charAt) {
    var tmp$, tmp$_0;
    var maxByOrNull$result;
    maxByOrNull$break: do {
      var iterator = from.iterator();
      if (!iterator.hasNext()) {
        maxByOrNull$result = null;
        break maxByOrNull$break;
      }var maxElem = iterator.next();
      if (!iterator.hasNext()) {
        maxByOrNull$result = maxElem;
        break maxByOrNull$break;
      }var maxValue = length(maxElem);
      do {
        var e = iterator.next();
        var v = length(e);
        if (Kotlin.compareTo(maxValue, v) < 0) {
          maxElem = e;
          maxValue = v;
        }}
       while (iterator.hasNext());
      maxByOrNull$result = maxElem;
    }
     while (false);
    tmp$_0 = (tmp$ = maxByOrNull$result) != null ? length(tmp$) : null;
    if (tmp$_0 == null) {
      throw new NoSuchElementException('Unable to build char tree from an empty list');
    }var maxLen = tmp$_0;
    var any$result;
    any$break: do {
      var tmp$_1;
      if (Kotlin.isType(from, Collection) && from.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$_1 = from.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        if (length(element) === 0) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    if (any$result)
      throw IllegalArgumentException_init('There should be no empty entries');
    var root = ArrayList_init_0();
    this.build_0(root, from, maxLen, 0, length, charAt);
    root.trimToSize();
    return new AsciiCharTree(new AsciiCharTree$Node(0, emptyList(), root));
  };
  AsciiCharTree$Companion.prototype.build_0 = function (resultList, from, maxLength, idx, length, charAt) {
    var destination = LinkedHashMap_init();
    var tmp$;
    tmp$ = from.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = charAt(element, idx);
      var tmp$_0;
      var value = destination.get_11rb$(key);
      if (value == null) {
        var answer = ArrayList_init_0();
        destination.put_xwzc9p$(key, answer);
        tmp$_0 = answer;
      } else {
        tmp$_0 = value;
      }
      var list = tmp$_0;
      list.add_11rb$(element);
    }
    var tmp$_1;
    tmp$_1 = destination.entries.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var ch = unboxChar(element_0.key);
      var list_0 = element_0.value;
      var nextIdx = idx + 1 | 0;
      var children = ArrayList_init_0();
      var destination_0 = ArrayList_init_0();
      var tmp$_2;
      tmp$_2 = list_0.iterator();
      while (tmp$_2.hasNext()) {
        var element_1 = tmp$_2.next();
        if (length(element_1) > nextIdx)
          destination_0.add_11rb$(element_1);
      }
      this.build_0(children, destination_0, maxLength, nextIdx, length, charAt);
      children.trimToSize();
      var destination_1 = ArrayList_init_0();
      var tmp$_3;
      tmp$_3 = list_0.iterator();
      while (tmp$_3.hasNext()) {
        var element_2 = tmp$_3.next();
        if (length(element_2) === nextIdx)
          destination_1.add_11rb$(element_2);
      }
      resultList.add_11rb$(new AsciiCharTree$Node(ch, destination_1, children));
    }
  };
  AsciiCharTree$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var AsciiCharTree$Companion_instance = null;
  function AsciiCharTree$Companion_getInstance() {
    if (AsciiCharTree$Companion_instance === null) {
      new AsciiCharTree$Companion();
    }return AsciiCharTree$Companion_instance;
  }
  AsciiCharTree.$metadata$ = {kind: Kind_CLASS, simpleName: 'AsciiCharTree', interfaces: []};
  var CHAR_ARRAY_POOL_SIZE;
  var CHAR_BUFFER_ARRAY_LENGTH;
  function CharArrayPool$ObjectLiteral(capacity) {
    DefaultPool.call(this, capacity);
  }
  CharArrayPool$ObjectLiteral.prototype.produceInstance = function () {
    return Kotlin.charArray(2048);
  };
  CharArrayPool$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [DefaultPool]};
  var CharArrayPool;
  var HTAB;
  function DefaultHttpMethods$lambda(it) {
    return it.value.length;
  }
  function DefaultHttpMethods$lambda_0(m, idx) {
    return toBoxedChar(m.value.charCodeAt(idx));
  }
  var DefaultHttpMethods;
  var HexTable;
  var HexLetterTable;
  function CloseReason(code, message) {
    this.code = code;
    this.message = message;
  }
  Object.defineProperty(CloseReason.prototype, 'knownReason', {configurable: true, get: function () {
    return CloseReason$Codes$Companion_getInstance().byCode_mq22fl$(this.code);
  }});
  CloseReason.prototype.toString = function () {
    var tmp$;
    return 'CloseReason(reason=' + ((tmp$ = this.knownReason) != null ? tmp$ : this.code).toString() + ', message=' + this.message + ')';
  };
  function CloseReason$Codes(name, ordinal, code) {
    Enum.call(this);
    this.code = code;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function CloseReason$Codes_initFields() {
    CloseReason$Codes_initFields = function () {
    };
    CloseReason$Codes$NORMAL_instance = new CloseReason$Codes('NORMAL', 0, 1000);
    CloseReason$Codes$GOING_AWAY_instance = new CloseReason$Codes('GOING_AWAY', 1, 1001);
    CloseReason$Codes$PROTOCOL_ERROR_instance = new CloseReason$Codes('PROTOCOL_ERROR', 2, 1002);
    CloseReason$Codes$CANNOT_ACCEPT_instance = new CloseReason$Codes('CANNOT_ACCEPT', 3, 1003);
    CloseReason$Codes$CLOSED_ABNORMALLY_instance = new CloseReason$Codes('CLOSED_ABNORMALLY', 4, 1006);
    CloseReason$Codes$NOT_CONSISTENT_instance = new CloseReason$Codes('NOT_CONSISTENT', 5, 1007);
    CloseReason$Codes$VIOLATED_POLICY_instance = new CloseReason$Codes('VIOLATED_POLICY', 6, 1008);
    CloseReason$Codes$TOO_BIG_instance = new CloseReason$Codes('TOO_BIG', 7, 1009);
    CloseReason$Codes$NO_EXTENSION_instance = new CloseReason$Codes('NO_EXTENSION', 8, 1010);
    CloseReason$Codes$INTERNAL_ERROR_instance = new CloseReason$Codes('INTERNAL_ERROR', 9, 1011);
    CloseReason$Codes$SERVICE_RESTART_instance = new CloseReason$Codes('SERVICE_RESTART', 10, 1012);
    CloseReason$Codes$TRY_AGAIN_LATER_instance = new CloseReason$Codes('TRY_AGAIN_LATER', 11, 1013);
    CloseReason$Codes$Companion_getInstance();
  }
  var CloseReason$Codes$NORMAL_instance;
  function CloseReason$Codes$NORMAL_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$NORMAL_instance;
  }
  var CloseReason$Codes$GOING_AWAY_instance;
  function CloseReason$Codes$GOING_AWAY_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$GOING_AWAY_instance;
  }
  var CloseReason$Codes$PROTOCOL_ERROR_instance;
  function CloseReason$Codes$PROTOCOL_ERROR_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$PROTOCOL_ERROR_instance;
  }
  var CloseReason$Codes$CANNOT_ACCEPT_instance;
  function CloseReason$Codes$CANNOT_ACCEPT_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$CANNOT_ACCEPT_instance;
  }
  var CloseReason$Codes$CLOSED_ABNORMALLY_instance;
  function CloseReason$Codes$CLOSED_ABNORMALLY_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$CLOSED_ABNORMALLY_instance;
  }
  var CloseReason$Codes$NOT_CONSISTENT_instance;
  function CloseReason$Codes$NOT_CONSISTENT_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$NOT_CONSISTENT_instance;
  }
  var CloseReason$Codes$VIOLATED_POLICY_instance;
  function CloseReason$Codes$VIOLATED_POLICY_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$VIOLATED_POLICY_instance;
  }
  var CloseReason$Codes$TOO_BIG_instance;
  function CloseReason$Codes$TOO_BIG_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$TOO_BIG_instance;
  }
  var CloseReason$Codes$NO_EXTENSION_instance;
  function CloseReason$Codes$NO_EXTENSION_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$NO_EXTENSION_instance;
  }
  var CloseReason$Codes$INTERNAL_ERROR_instance;
  function CloseReason$Codes$INTERNAL_ERROR_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$INTERNAL_ERROR_instance;
  }
  var CloseReason$Codes$SERVICE_RESTART_instance;
  function CloseReason$Codes$SERVICE_RESTART_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$SERVICE_RESTART_instance;
  }
  var CloseReason$Codes$TRY_AGAIN_LATER_instance;
  function CloseReason$Codes$TRY_AGAIN_LATER_getInstance() {
    CloseReason$Codes_initFields();
    return CloseReason$Codes$TRY_AGAIN_LATER_instance;
  }
  function CloseReason$Codes$Companion() {
    CloseReason$Codes$Companion_instance = this;
    var $receiver = CloseReason$Codes$values();
    var capacity = coerceAtLeast(mapCapacity($receiver.length), 16);
    var destination = LinkedHashMap_init_0(capacity);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var element = $receiver[tmp$];
      destination.put_xwzc9p$(element.code, element);
    }
    this.byCodeMap_0 = destination;
    this.UNEXPECTED_CONDITION = CloseReason$Codes$INTERNAL_ERROR_getInstance();
  }
  CloseReason$Codes$Companion.prototype.byCode_mq22fl$ = function (code) {
    return this.byCodeMap_0.get_11rb$(code);
  };
  CloseReason$Codes$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var CloseReason$Codes$Companion_instance = null;
  function CloseReason$Codes$Companion_getInstance() {
    CloseReason$Codes_initFields();
    if (CloseReason$Codes$Companion_instance === null) {
      new CloseReason$Codes$Companion();
    }return CloseReason$Codes$Companion_instance;
  }
  CloseReason$Codes.$metadata$ = {kind: Kind_CLASS, simpleName: 'Codes', interfaces: [Enum]};
  function CloseReason$Codes$values() {
    return [CloseReason$Codes$NORMAL_getInstance(), CloseReason$Codes$GOING_AWAY_getInstance(), CloseReason$Codes$PROTOCOL_ERROR_getInstance(), CloseReason$Codes$CANNOT_ACCEPT_getInstance(), CloseReason$Codes$CLOSED_ABNORMALLY_getInstance(), CloseReason$Codes$NOT_CONSISTENT_getInstance(), CloseReason$Codes$VIOLATED_POLICY_getInstance(), CloseReason$Codes$TOO_BIG_getInstance(), CloseReason$Codes$NO_EXTENSION_getInstance(), CloseReason$Codes$INTERNAL_ERROR_getInstance(), CloseReason$Codes$SERVICE_RESTART_getInstance(), CloseReason$Codes$TRY_AGAIN_LATER_getInstance()];
  }
  CloseReason$Codes.values = CloseReason$Codes$values;
  function CloseReason$Codes$valueOf(name) {
    switch (name) {
      case 'NORMAL':
        return CloseReason$Codes$NORMAL_getInstance();
      case 'GOING_AWAY':
        return CloseReason$Codes$GOING_AWAY_getInstance();
      case 'PROTOCOL_ERROR':
        return CloseReason$Codes$PROTOCOL_ERROR_getInstance();
      case 'CANNOT_ACCEPT':
        return CloseReason$Codes$CANNOT_ACCEPT_getInstance();
      case 'CLOSED_ABNORMALLY':
        return CloseReason$Codes$CLOSED_ABNORMALLY_getInstance();
      case 'NOT_CONSISTENT':
        return CloseReason$Codes$NOT_CONSISTENT_getInstance();
      case 'VIOLATED_POLICY':
        return CloseReason$Codes$VIOLATED_POLICY_getInstance();
      case 'TOO_BIG':
        return CloseReason$Codes$TOO_BIG_getInstance();
      case 'NO_EXTENSION':
        return CloseReason$Codes$NO_EXTENSION_getInstance();
      case 'INTERNAL_ERROR':
        return CloseReason$Codes$INTERNAL_ERROR_getInstance();
      case 'SERVICE_RESTART':
        return CloseReason$Codes$SERVICE_RESTART_getInstance();
      case 'TRY_AGAIN_LATER':
        return CloseReason$Codes$TRY_AGAIN_LATER_getInstance();
      default:throwISE('No enum constant io.ktor.http.cio.websocket.CloseReason.Codes.' + name);
    }
  }
  CloseReason$Codes.valueOf_61zpoe$ = CloseReason$Codes$valueOf;
  CloseReason.$metadata$ = {kind: Kind_CLASS, simpleName: 'CloseReason', interfaces: []};
  CloseReason.prototype.component1 = function () {
    return this.code;
  };
  CloseReason.prototype.component2 = function () {
    return this.message;
  };
  CloseReason.prototype.copy_qid81t$ = function (code, message) {
    return new CloseReason(code === void 0 ? this.code : code, message === void 0 ? this.message : message);
  };
  CloseReason.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.code) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    return result;
  };
  CloseReason.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.code, other.code) && Kotlin.equals(this.message, other.message)))));
  };
  function NonDisposableHandle() {
    NonDisposableHandle_instance = this;
  }
  NonDisposableHandle.prototype.dispose = function () {
  };
  NonDisposableHandle.prototype.toString = function () {
    return 'NonDisposableHandle';
  };
  NonDisposableHandle.$metadata$ = {kind: Kind_OBJECT, simpleName: 'NonDisposableHandle', interfaces: [DisposableHandle]};
  var NonDisposableHandle_instance = null;
  function NonDisposableHandle_getInstance() {
    if (NonDisposableHandle_instance === null) {
      new NonDisposableHandle();
    }return NonDisposableHandle_instance;
  }
  function FrameType(name, ordinal, controlFrame, opcode) {
    Enum.call(this);
    this.controlFrame = controlFrame;
    this.opcode = opcode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function FrameType_initFields() {
    FrameType_initFields = function () {
    };
    FrameType$TEXT_instance = new FrameType('TEXT', 0, false, 1);
    FrameType$BINARY_instance = new FrameType('BINARY', 1, false, 2);
    FrameType$CLOSE_instance = new FrameType('CLOSE', 2, true, 8);
    FrameType$PING_instance = new FrameType('PING', 3, true, 9);
    FrameType$PONG_instance = new FrameType('PONG', 4, true, 10);
    FrameType$Companion_getInstance();
  }
  var FrameType$TEXT_instance;
  function FrameType$TEXT_getInstance() {
    FrameType_initFields();
    return FrameType$TEXT_instance;
  }
  var FrameType$BINARY_instance;
  function FrameType$BINARY_getInstance() {
    FrameType_initFields();
    return FrameType$BINARY_instance;
  }
  var FrameType$CLOSE_instance;
  function FrameType$CLOSE_getInstance() {
    FrameType_initFields();
    return FrameType$CLOSE_instance;
  }
  var FrameType$PING_instance;
  function FrameType$PING_getInstance() {
    FrameType_initFields();
    return FrameType$PING_instance;
  }
  var FrameType$PONG_instance;
  function FrameType$PONG_getInstance() {
    FrameType_initFields();
    return FrameType$PONG_instance;
  }
  function FrameType$Companion() {
    FrameType$Companion_instance = this;
    var $receiver = FrameType$values();
    var maxByOrNull$result;
    maxByOrNull$break: do {
      if ($receiver.length === 0) {
        maxByOrNull$result = null;
        break maxByOrNull$break;
      }var maxElem = $receiver[0];
      var lastIndex = get_lastIndex($receiver);
      if (lastIndex === 0) {
        maxByOrNull$result = maxElem;
        break maxByOrNull$break;
      }var maxValue = maxElem.opcode;
      for (var i = 1; i <= lastIndex; i++) {
        var e = $receiver[i];
        var v = e.opcode;
        if (Kotlin.compareTo(maxValue, v) < 0) {
          maxElem = e;
          maxValue = v;
        }}
      maxByOrNull$result = maxElem;
    }
     while (false);
    this.maxOpcode_0 = ensureNotNull(maxByOrNull$result).opcode;
    var array = Array_0(this.maxOpcode_0 + 1 | 0);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    loop_label: for (var i_0 = 0; i_0 <= tmp$; i_0++) {
      var $receiver_0 = FrameType$values();
      var singleOrNull$result;
      singleOrNull$break: do {
        var tmp$_0;
        var single = null;
        var found = false;
        for (tmp$_0 = 0; tmp$_0 !== $receiver_0.length; ++tmp$_0) {
          var element = $receiver_0[tmp$_0];
          if (element.opcode === i_0) {
            if (found) {
              singleOrNull$result = null;
              break singleOrNull$break;
            }single = element;
            found = true;
          }}
        if (!found) {
          singleOrNull$result = null;
          break singleOrNull$break;
        }singleOrNull$result = single;
      }
       while (false);
      array[i_0] = singleOrNull$result;
    }
    this.byOpcodeArray_0 = array;
  }
  FrameType$Companion.prototype.get_za3lpa$ = function (opcode) {
    var tmp$;
    tmp$ = this.maxOpcode_0;
    return 0 <= opcode && opcode <= tmp$ ? this.byOpcodeArray_0[opcode] : null;
  };
  FrameType$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var FrameType$Companion_instance = null;
  function FrameType$Companion_getInstance() {
    FrameType_initFields();
    if (FrameType$Companion_instance === null) {
      new FrameType$Companion();
    }return FrameType$Companion_instance;
  }
  FrameType.$metadata$ = {kind: Kind_CLASS, simpleName: 'FrameType', interfaces: [Enum]};
  function FrameType$values() {
    return [FrameType$TEXT_getInstance(), FrameType$BINARY_getInstance(), FrameType$CLOSE_getInstance(), FrameType$PING_getInstance(), FrameType$PONG_getInstance()];
  }
  FrameType.values = FrameType$values;
  function FrameType$valueOf(name) {
    switch (name) {
      case 'TEXT':
        return FrameType$TEXT_getInstance();
      case 'BINARY':
        return FrameType$BINARY_getInstance();
      case 'CLOSE':
        return FrameType$CLOSE_getInstance();
      case 'PING':
        return FrameType$PING_getInstance();
      case 'PONG':
        return FrameType$PONG_getInstance();
      default:throwISE('No enum constant io.ktor.http.cio.websocket.FrameType.' + name);
    }
  }
  FrameType.valueOf_61zpoe$ = FrameType$valueOf;
  var SP_0;
  var CR_0;
  var LF_0;
  function DefaultWebSocketSession() {
  }
  DefaultWebSocketSession.prototype.start_wohq5n$ = function (negotiatedExtensions, callback$default) {
    if (negotiatedExtensions === void 0)
      negotiatedExtensions = emptyList();
    callback$default ? callback$default(negotiatedExtensions) : this.start_wohq5n$$default(negotiatedExtensions);
  };
  DefaultWebSocketSession.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'DefaultWebSocketSession', interfaces: [WebSocketSession]};
  function Frame(fin, frameType, data, disposableHandle, rsv1, rsv2, rsv3) {
    Frame$Companion_getInstance();
    if (disposableHandle === void 0)
      disposableHandle = NonDisposableHandle_getInstance();
    if (rsv1 === void 0)
      rsv1 = false;
    if (rsv2 === void 0)
      rsv2 = false;
    if (rsv3 === void 0)
      rsv3 = false;
    this.fin = fin;
    this.frameType = frameType;
    this.data = data;
    this.disposableHandle = disposableHandle;
    this.rsv1_364fr9$_0 = rsv1;
    this.rsv2_364fs4$_0 = rsv2;
    this.rsv3_364fsz$_0 = rsv3;
  }
  Object.defineProperty(Frame.prototype, 'rsv1', {get: function () {
    return this.rsv1_364fr9$_0;
  }});
  Object.defineProperty(Frame.prototype, 'rsv2', {get: function () {
    return this.rsv2_364fs4$_0;
  }});
  Object.defineProperty(Frame.prototype, 'rsv3', {get: function () {
    return this.rsv3_364fsz$_0;
  }});
  function Frame$Binary(fin, data, rsv1, rsv2, rsv3) {
    if (rsv1 === void 0)
      rsv1 = false;
    if (rsv2 === void 0)
      rsv2 = false;
    if (rsv3 === void 0)
      rsv3 = false;
    Frame.call(this, fin, FrameType$BINARY_getInstance(), data, NonDisposableHandle_getInstance(), rsv1, rsv2, rsv3);
  }
  Frame$Binary.$metadata$ = {kind: Kind_CLASS, simpleName: 'Binary', interfaces: [Frame]};
  function Frame$Frame$Binary_init(fin, data, $this) {
    $this = $this || Object.create(Frame$Binary.prototype);
    Frame$Binary.call($this, fin, data, false, false, false);
    return $this;
  }
  function Frame$Frame$Binary_init_0(fin, packet, $this) {
    $this = $this || Object.create(Frame$Binary.prototype);
    Frame$Frame$Binary_init(fin, readBytes(packet), $this);
    return $this;
  }
  function Frame$Text(fin, data, rsv1, rsv2, rsv3) {
    if (rsv1 === void 0)
      rsv1 = false;
    if (rsv2 === void 0)
      rsv2 = false;
    if (rsv3 === void 0)
      rsv3 = false;
    Frame.call(this, fin, FrameType$TEXT_getInstance(), data, NonDisposableHandle_getInstance(), rsv1, rsv2, rsv3);
  }
  Frame$Text.$metadata$ = {kind: Kind_CLASS, simpleName: 'Text', interfaces: [Frame]};
  function Frame$Frame$Text_init(fin, data, $this) {
    $this = $this || Object.create(Frame$Text.prototype);
    Frame$Text.call($this, fin, data, false, false, false);
    return $this;
  }
  function Frame$Frame$Text_init_0(text, $this) {
    $this = $this || Object.create(Frame$Text.prototype);
    Frame$Frame$Text_init(true, encodeToByteArray(charsets.Charsets.UTF_8.newEncoder(), text, 0, text.length), $this);
    return $this;
  }
  function Frame$Frame$Text_init_1(fin, packet, $this) {
    $this = $this || Object.create(Frame$Text.prototype);
    Frame$Frame$Text_init(fin, readBytes(packet), $this);
    return $this;
  }
  function Frame$Close(data) {
    Frame.call(this, true, FrameType$CLOSE_getInstance(), data, NonDisposableHandle_getInstance(), false, false, false);
  }
  Frame$Close.$metadata$ = {kind: Kind_CLASS, simpleName: 'Close', interfaces: [Frame]};
  function Frame$Frame$Close_init(reason, $this) {
    $this = $this || Object.create(Frame$Close.prototype);
    var buildPacket$result;
    var builder = BytePacketBuilder(0);
    try {
      writeShort(builder, reason.code);
      writeText(builder, reason.message);
      buildPacket$result = builder.build();
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        builder.release();
        throw t;
      } else
        throw t;
    }
    Frame$Frame$Close_init_0(buildPacket$result, $this);
    return $this;
  }
  function Frame$Frame$Close_init_0(packet, $this) {
    $this = $this || Object.create(Frame$Close.prototype);
    Frame$Close.call($this, readBytes(packet));
    return $this;
  }
  function Frame$Frame$Close_init_1($this) {
    $this = $this || Object.create(Frame$Close.prototype);
    Frame$Close.call($this, Frame$Companion_getInstance().Empty_0);
    return $this;
  }
  function Frame$Ping(data) {
    Frame.call(this, true, FrameType$PING_getInstance(), data, NonDisposableHandle_getInstance(), false, false, false);
  }
  Frame$Ping.$metadata$ = {kind: Kind_CLASS, simpleName: 'Ping', interfaces: [Frame]};
  function Frame$Frame$Ping_init(packet, $this) {
    $this = $this || Object.create(Frame$Ping.prototype);
    Frame$Ping.call($this, readBytes(packet));
    return $this;
  }
  function Frame$Pong(data, disposableHandle) {
    if (disposableHandle === void 0)
      disposableHandle = NonDisposableHandle_getInstance();
    Frame.call(this, true, FrameType$PONG_getInstance(), data, disposableHandle, false, false, false);
  }
  Frame$Pong.$metadata$ = {kind: Kind_CLASS, simpleName: 'Pong', interfaces: [Frame]};
  function Frame$Frame$Pong_init(packet, $this) {
    $this = $this || Object.create(Frame$Pong.prototype);
    Frame$Pong.call($this, readBytes(packet), NonDisposableHandle_getInstance());
    return $this;
  }
  Frame.prototype.toString = function () {
    return 'Frame ' + this.frameType + ' (fin=' + this.fin + ', buffer len = ' + this.data.length + ')';
  };
  Frame.prototype.copy = function () {
    return Frame$Companion_getInstance().byType_a2mxhz$(this.fin, this.frameType, this.data.slice(), this.rsv1, this.rsv2, this.rsv3);
  };
  function Frame$Companion() {
    Frame$Companion_instance = this;
    this.Empty_0 = new Int8Array(0);
  }
  Frame$Companion.prototype.byType_8ejoj4$ = function (fin, frameType, data) {
    switch (frameType.name) {
      case 'BINARY':
        return Frame$Frame$Binary_init(fin, data);
      case 'TEXT':
        return Frame$Frame$Text_init(fin, data);
      case 'CLOSE':
        return new Frame$Close(data);
      case 'PING':
        return new Frame$Ping(data);
      case 'PONG':
        return new Frame$Pong(data, NonDisposableHandle_getInstance());
      default:return Kotlin.noWhenBranchMatched();
    }
  };
  Frame$Companion.prototype.byType_a2mxhz$ = function (fin, frameType, data, rsv1, rsv2, rsv3) {
    switch (frameType.name) {
      case 'BINARY':
        return new Frame$Binary(fin, data, rsv1, rsv2, rsv3);
      case 'TEXT':
        return new Frame$Text(fin, data, rsv1, rsv2, rsv3);
      case 'CLOSE':
        return new Frame$Close(data);
      case 'PING':
        return new Frame$Ping(data);
      case 'PONG':
        return new Frame$Pong(data, NonDisposableHandle_getInstance());
      default:return Kotlin.noWhenBranchMatched();
    }
  };
  Frame$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var Frame$Companion_instance = null;
  function Frame$Companion_getInstance() {
    if (Frame$Companion_instance === null) {
      new Frame$Companion();
    }return Frame$Companion_instance;
  }
  Frame.$metadata$ = {kind: Kind_CLASS, simpleName: 'Frame', interfaces: []};
  function WebSocketSession() {
  }
  function Coroutine$send_x9o3m3$($this, frame_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frame = frame_0;
  }
  Coroutine$send_x9o3m3$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$send_x9o3m3$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$send_x9o3m3$.prototype.constructor = Coroutine$send_x9o3m3$;
  Coroutine$send_x9o3m3$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.outgoing.send_11rb$(this.local$frame, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketSession.prototype.send_x9o3m3$ = function (frame_0, continuation_0, suspended) {
    var instance = new Coroutine$send_x9o3m3$(this, frame_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketSession.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'WebSocketSession', interfaces: [CoroutineScope]};
  var package$io = _.io || (_.io = {});
  var package$ktor = package$io.ktor || (package$io.ktor = {});
  var package$http = package$ktor.http || (package$ktor.http = {});
  var package$cio = package$http.cio || (package$http.cio = {});
  package$cio.CIOHeaders = CIOHeaders;
  $$importsForInline$$['ktor-ktor-io-js-legacy'] = $module$ktor_ktor_io_js_legacy;
  AsciiCharTree.Node = AsciiCharTree$Node;
  Object.defineProperty(AsciiCharTree, 'Companion', {get: AsciiCharTree$Companion_getInstance});
  var package$internals = package$cio.internals || (package$cio.internals = {});
  package$internals.AsciiCharTree = AsciiCharTree;
  Object.defineProperty(CloseReason$Codes, 'NORMAL', {get: CloseReason$Codes$NORMAL_getInstance});
  Object.defineProperty(CloseReason$Codes, 'GOING_AWAY', {get: CloseReason$Codes$GOING_AWAY_getInstance});
  Object.defineProperty(CloseReason$Codes, 'PROTOCOL_ERROR', {get: CloseReason$Codes$PROTOCOL_ERROR_getInstance});
  Object.defineProperty(CloseReason$Codes, 'CANNOT_ACCEPT', {get: CloseReason$Codes$CANNOT_ACCEPT_getInstance});
  Object.defineProperty(CloseReason$Codes, 'CLOSED_ABNORMALLY', {get: CloseReason$Codes$CLOSED_ABNORMALLY_getInstance});
  Object.defineProperty(CloseReason$Codes, 'NOT_CONSISTENT', {get: CloseReason$Codes$NOT_CONSISTENT_getInstance});
  Object.defineProperty(CloseReason$Codes, 'VIOLATED_POLICY', {get: CloseReason$Codes$VIOLATED_POLICY_getInstance});
  Object.defineProperty(CloseReason$Codes, 'TOO_BIG', {get: CloseReason$Codes$TOO_BIG_getInstance});
  Object.defineProperty(CloseReason$Codes, 'NO_EXTENSION', {get: CloseReason$Codes$NO_EXTENSION_getInstance});
  Object.defineProperty(CloseReason$Codes, 'INTERNAL_ERROR', {get: CloseReason$Codes$INTERNAL_ERROR_getInstance});
  Object.defineProperty(CloseReason$Codes, 'SERVICE_RESTART', {get: CloseReason$Codes$SERVICE_RESTART_getInstance});
  Object.defineProperty(CloseReason$Codes, 'TRY_AGAIN_LATER', {get: CloseReason$Codes$TRY_AGAIN_LATER_getInstance});
  Object.defineProperty(CloseReason$Codes, 'Companion', {get: CloseReason$Codes$Companion_getInstance});
  CloseReason.Codes = CloseReason$Codes;
  var package$websocket = package$cio.websocket || (package$cio.websocket = {});
  package$websocket.CloseReason = CloseReason;
  Object.defineProperty(package$websocket, 'NonDisposableHandle', {get: NonDisposableHandle_getInstance});
  Object.defineProperty(FrameType, 'TEXT', {get: FrameType$TEXT_getInstance});
  Object.defineProperty(FrameType, 'BINARY', {get: FrameType$BINARY_getInstance});
  Object.defineProperty(FrameType, 'CLOSE', {get: FrameType$CLOSE_getInstance});
  Object.defineProperty(FrameType, 'PING', {get: FrameType$PING_getInstance});
  Object.defineProperty(FrameType, 'PONG', {get: FrameType$PONG_getInstance});
  Object.defineProperty(FrameType, 'Companion', {get: FrameType$Companion_getInstance});
  package$websocket.FrameType = FrameType;
  package$websocket.DefaultWebSocketSession = DefaultWebSocketSession;
  Frame.Binary_init_3eyok5$ = Frame$Frame$Binary_init;
  Frame.Binary_init_cqnnqj$ = Frame$Frame$Binary_init_0;
  Frame.Binary = Frame$Binary;
  Frame.Text_init_3eyok5$ = Frame$Frame$Text_init;
  Frame.Text_init_61zpoe$ = Frame$Frame$Text_init_0;
  Frame.Text_init_cqnnqj$ = Frame$Frame$Text_init_1;
  Frame.Text = Frame$Text;
  Frame.Close_init_p695es$ = Frame$Frame$Close_init;
  Frame.Close_init_3uq2w4$ = Frame$Frame$Close_init_0;
  Frame.Close_init = Frame$Frame$Close_init_1;
  Frame.Close = Frame$Close;
  Frame.Ping_init_3uq2w4$ = Frame$Frame$Ping_init;
  Frame.Ping = Frame$Ping;
  Frame.Pong_init_3uq2w4$ = Frame$Frame$Pong_init;
  Frame.Pong = Frame$Pong;
  Object.defineProperty(Frame, 'Companion', {get: Frame$Companion_getInstance});
  package$websocket.Frame = Frame;
  package$websocket.WebSocketSession = WebSocketSession;
  CIOHeaders.prototype.contains_61zpoe$ = Headers.prototype.contains_61zpoe$;
  CIOHeaders.prototype.contains_puj7f4$ = Headers.prototype.contains_puj7f4$;
  CIOHeaders.prototype.forEach_ubvtmq$ = Headers.prototype.forEach_ubvtmq$;
  DefaultWebSocketSession.prototype.send_x9o3m3$ = WebSocketSession.prototype.send_x9o3m3$;
  MAX_CHUNK_SIZE_LENGTH = 128;
  CHUNK_BUFFER_POOL_SIZE = 2048;
  DEFAULT_BYTE_BUFFER_SIZE = 4088;
  ChunkSizeBufferPool = new ChunkSizeBufferPool$ObjectLiteral(2048);
  CrLfShort = 3338;
  CrLf = encodeToByteArray(charsets.Charsets.UTF_8.newEncoder(), '\r\n', 0, '\r\n'.length);
  var $receiver = '0\r\n\r\n';
  LastChunkBytes = encodeToByteArray(charsets.Charsets.UTF_8.newEncoder(), $receiver, 0, $receiver.length);
  EXPECTED_HEADERS_QTY = 64;
  HEADER_SIZE = 8;
  HEADER_ARRAY_POOL_SIZE = 1000;
  EMPTY_INT_ARRAY = new Int32Array(0);
  IntArrayPool = new IntArrayPool$ObjectLiteral(1000);
  HTTP_LINE_LIMIT = 8192;
  HTTP_STATUS_CODE_MIN_RANGE = 100;
  HTTP_STATUS_CODE_MAX_RANGE = 999;
  hostForbiddenSymbols = setOf([toBoxedChar(47), toBoxedChar(63), toBoxedChar(35), toBoxedChar(64)]);
  versions = AsciiCharTree$Companion_getInstance().build_mowv1r$(listOf_0(['HTTP/1.0', 'HTTP/1.1']));
  SP = 32;
  CR = 13;
  LF = 10;
  CHAR_ARRAY_POOL_SIZE = 4096;
  CHAR_BUFFER_ARRAY_LENGTH = 2048;
  CharArrayPool = new CharArrayPool$ObjectLiteral(4096);
  HTAB = 9;
  DefaultHttpMethods = AsciiCharTree$Companion_getInstance().build_za6fmz$(HttpMethod.Companion.DefaultMethods, DefaultHttpMethods$lambda, DefaultHttpMethods$lambda_0);
  var $receiver_0 = new IntRange(0, 255);
  var destination = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
  var tmp$;
  tmp$ = $receiver_0.iterator();
  while (tmp$.hasNext()) {
    var item = tmp$.next();
    var tmp$_0 = destination.add_11rb$;
    var transform$result;
    if (48 <= item && item <= 57) {
      transform$result = Kotlin.Long.fromInt(item).subtract(L48);
    } else if (item >= L97.toNumber() && item <= L102.toNumber()) {
      transform$result = Kotlin.Long.fromInt(item).subtract(L97).add(Kotlin.Long.fromInt(10));
    } else if (item >= L65.toNumber() && item <= L70.toNumber()) {
      transform$result = Kotlin.Long.fromInt(item).subtract(L65).add(Kotlin.Long.fromInt(10));
    } else {
      transform$result = L_1;
    }
    tmp$_0.call(destination, transform$result);
  }
  HexTable = toLongArray(destination);
  var $receiver_1 = new IntRange(0, 15);
  var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
  var tmp$_1;
  tmp$_1 = $receiver_1.iterator();
  while (tmp$_1.hasNext()) {
    var item_0 = tmp$_1.next();
    destination_0.add_11rb$(item_0 < 10 ? toByte(48 + item_0 | 0) : toByte(toChar(toChar(97 + item_0) - 10) | 0));
  }
  HexLetterTable = toByteArray(destination_0);
  SP_0 = 32;
  CR_0 = 13;
  LF_0 = 10;
  return _;
}));

//# sourceMappingURL=ktor-ktor-http-cio-js-legacy.js.map
