(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'xmlpullparserkmp-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'xmlpullparserkmp-js-legacy'.");
    }root['xmlpullparserkmp-js-legacy'] = factory(typeof this['xmlpullparserkmp-js-legacy'] === 'undefined' ? {} : this['xmlpullparserkmp-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Exception_init = Kotlin.kotlin.Exception_init_pdl1vj$;
  var Exception = Kotlin.kotlin.Exception;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var throwUPAE = Kotlin.throwUPAE;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var equals = Kotlin.equals;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var removeLastOrNull = Kotlin.kotlin.collections.removeLastOrNull_vvxzk3$;
  var indexOf = Kotlin.kotlin.collections.indexOf_bv23uc$;
  var reverse = Kotlin.kotlin.collections.reverse_vvxzk3$;
  var asList = Kotlin.org.w3c.dom.asList_kt9thq$;
  var IndexOutOfBoundsException_init = Kotlin.kotlin.IndexOutOfBoundsException_init;
  var contains = Kotlin.kotlin.text.contains_li3zpu$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  XmlPullParserException.prototype = Object.create(Exception.prototype);
  XmlPullParserException.prototype.constructor = XmlPullParserException;
  function XmlPullParserConstants() {
    XmlPullParserConstants_instance = this;
    this.START_DOCUMENT = 0;
    this.END_DOCUMENT = 1;
    this.START_TAG = 2;
    this.END_TAG = 3;
    this.TEXT = 4;
    this.CDSECT = 5;
    this.DOCDECL = 10;
    this.ENTITY_REF = 6;
    this.FEATURE_PROCESS_NAMESPACES = 'http://xmlpull.org/v1/doc/features.html#process-namespaces';
    this.PROPERTY_STANDALONE = 'http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone';
    this.PROPERTY_VERSION = 'http://xmlpull.org/v1/doc/properties.html#xmldecl-version';
  }
  XmlPullParserConstants.$metadata$ = {kind: Kind_OBJECT, simpleName: 'XmlPullParserConstants', interfaces: []};
  var XmlPullParserConstants_instance = null;
  function XmlPullParserConstants_getInstance() {
    if (XmlPullParserConstants_instance === null) {
      new XmlPullParserConstants();
    }return XmlPullParserConstants_instance;
  }
  function ParserEvent() {
    this.eventNode = null;
    this.eventNodeDepth = -1;
    this.eventType = -1;
  }
  ParserEvent.$metadata$ = {kind: Kind_CLASS, simpleName: 'ParserEvent', interfaces: []};
  function XmlPullParser() {
  }
  XmlPullParser.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'XmlPullParser', interfaces: []};
  function XmlPullParserException(message) {
    Exception_init(message, this);
    this.name = 'XmlPullParserException';
  }
  XmlPullParserException.$metadata$ = {kind: Kind_CLASS, simpleName: 'XmlPullParserException', interfaces: [Exception]};
  function setInputString($receiver, xmlString) {
    $receiver.setInput_61zpoe$(xmlString);
  }
  function XmlPullParserFactory() {
    XmlPullParserFactory$Companion_getInstance();
    this.features_naxo9$_0 = LinkedHashMap_init();
  }
  XmlPullParserFactory.prototype.setFeature_ivxn3r$ = function (name, state) {
    this.features_naxo9$_0.put_xwzc9p$(name, state);
  };
  XmlPullParserFactory.prototype.getFeature_61zpoe$ = function (name) {
    var tmp$;
    return (tmp$ = this.features_naxo9$_0.get_11rb$(name)) != null ? tmp$ : false;
  };
  XmlPullParserFactory.prototype.setNamespaceAware_6taknv$ = function (awareness) {
    this.setFeature_ivxn3r$(XmlPullParserFactory$Companion_getInstance().FEATURE_NAMESPACE, awareness);
  };
  XmlPullParserFactory.prototype.isNamespaceAware = function () {
    return this.getFeature_61zpoe$(XmlPullParserFactory$Companion_getInstance().FEATURE_NAMESPACE);
  };
  XmlPullParserFactory.prototype.setValidating_6taknv$ = function (validating) {
    this.setFeature_ivxn3r$(XmlPullParserFactory$Companion_getInstance().FEATURE_VALIDATING, validating);
  };
  XmlPullParserFactory.prototype.isValidating = function () {
    return this.getFeature_61zpoe$(XmlPullParserFactory$Companion_getInstance().FEATURE_VALIDATING);
  };
  XmlPullParserFactory.prototype.newPullParser = function () {
    var xpp = new XmlPullParserJsImpl();
    var tmp$;
    tmp$ = this.features_naxo9$_0.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      xpp.setFeature_ivxn3r$(element.key, element.value);
    }
    return xpp;
  };
  XmlPullParserFactory.prototype.newSerializer = function () {
    throw IllegalStateException_init('Not available on Javascript yet');
  };
  function XmlPullParserFactory$Companion() {
    XmlPullParserFactory$Companion_instance = this;
    this.FEATURE_VALIDATING = 'http://xmlpull.org/v1/doc/features.html#validation';
    this.FEATURE_NAMESPACE = 'http://xmlpull.org/v1/doc/features.html#process-namespaces';
  }
  XmlPullParserFactory$Companion.prototype.newInstance = function () {
    return new XmlPullParserFactory();
  };
  XmlPullParserFactory$Companion.$metadata$ = {kind: Kind_OBJECT, simpleName: 'Companion', interfaces: []};
  var XmlPullParserFactory$Companion_instance = null;
  function XmlPullParserFactory$Companion_getInstance() {
    if (XmlPullParserFactory$Companion_instance === null) {
      new XmlPullParserFactory$Companion();
    }return XmlPullParserFactory$Companion_instance;
  }
  XmlPullParserFactory.$metadata$ = {kind: Kind_CLASS, simpleName: 'XmlPullParserFactory', interfaces: []};
  function XmlPullParserJsImpl() {
    this.treeWalker_pdgf4x$_0 = this.treeWalker_pdgf4x$_0;
    this.document_yfpuna$_0 = this.document_yfpuna$_0;
    this.eventsStack_0 = ArrayList_init();
    this.parentNodesStack_0 = ArrayList_init();
    this.nextNode_0 = null;
    this.currentEvent_0 = null;
    this.lastParentNode_0 = null;
    this.processNsp_0 = false;
    this.relaxed_0 = true;
  }
  Object.defineProperty(XmlPullParserJsImpl.prototype, 'treeWalker_0', {configurable: true, get: function () {
    if (this.treeWalker_pdgf4x$_0 == null)
      return throwUPAE('treeWalker');
    return this.treeWalker_pdgf4x$_0;
  }, set: function (treeWalker) {
    this.treeWalker_pdgf4x$_0 = treeWalker;
  }});
  Object.defineProperty(XmlPullParserJsImpl.prototype, 'document_0', {configurable: true, get: function () {
    if (this.document_yfpuna$_0 == null)
      return throwUPAE('document');
    return this.document_yfpuna$_0;
  }, set: function (document) {
    this.document_yfpuna$_0 = document;
  }});
  function XmlPullParserJsImpl$setInput$lambda(it) {
    return NodeFilter.FILTER_ACCEPT;
  }
  XmlPullParserJsImpl.prototype.setInput_61zpoe$ = function (content) {
    this.document_0 = (new DOMParser()).parseFromString(content, 'text/' + (startsWith(content, '<?xml') ? 'xml' : 'html'));
    this.treeWalker_0 = this.document_0.createTreeWalker(this.document_0, NodeFilter.SHOW_ALL, XmlPullParserJsImpl$setInput$lambda);
    this.logParserEvents_0();
  };
  XmlPullParserJsImpl.prototype.isProp_0 = function (ns1, prop, ns2) {
    if (!startsWith(ns1, 'http://xmlpull.org/v1/doc/'))
      return false;
    return prop ? equals(ns1.substring(42), ns2) : equals(ns1.substring(40), ns2);
  };
  function XmlPullParserJsImpl$logParserEvents$lambda(this$XmlPullParserJsImpl) {
    return function () {
      this$XmlPullParserJsImpl.nextNode_0 = this$XmlPullParserJsImpl.treeWalker_0.nextNode();
      return this$XmlPullParserJsImpl.nextNode_0;
    };
  }
  function XmlPullParserJsImpl$logParserEvents$lambda_0(this$XmlPullParserJsImpl) {
    return function () {
      this$XmlPullParserJsImpl.lastParentNode_0 = removeLastOrNull(this$XmlPullParserJsImpl.parentNodesStack_0);
      return this$XmlPullParserJsImpl.lastParentNode_0;
    };
  }
  XmlPullParserJsImpl.prototype.logParserEvents_0 = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    while (XmlPullParserJsImpl$logParserEvents$lambda(this)() != null) {
      if (((tmp$ = this.nextNode_0) != null ? tmp$.nodeType : null) === Node.TEXT_NODE) {
        var tmp$_5 = this.eventsStack_0;
        var $receiver = new ParserEvent();
        $receiver.eventNode = this.nextNode_0;
        $receiver.eventType = 4;
        $receiver.eventNodeDepth = this.parentNodesStack_0.size + 1 | 0;
        tmp$_5.add_11rb$($receiver);
      }var tmp$_6 = this.eventsStack_0;
      var $receiver_0 = new ParserEvent();
      $receiver_0.eventNode = this.nextNode_0;
      $receiver_0.eventType = 2;
      $receiver_0.eventNodeDepth = this.parentNodesStack_0.size + 1 | 0;
      tmp$_6.add_11rb$($receiver_0);
      if (((tmp$_0 = this.nextNode_0) != null ? tmp$_0.hasChildNodes() : null) === false) {
        var tmp$_7 = this.eventsStack_0;
        var $receiver_1 = new ParserEvent();
        $receiver_1.eventNode = this.nextNode_0;
        $receiver_1.eventType = 3;
        $receiver_1.eventNodeDepth = this.parentNodesStack_0.size + 1 | 0;
        tmp$_7.add_11rb$($receiver_1);
      }if (this.parentNodesStack_0.isEmpty() || ((tmp$_1 = this.nextNode_0) != null ? tmp$_1.hasChildNodes() : null) === true) {
        if ((tmp$_2 = this.nextNode_0) != null) {
          this.parentNodesStack_0.add_11rb$(tmp$_2);
        }}var currentParentNode = last(this.parentNodesStack_0);
      if (equals(currentParentNode.lastChild, this.nextNode_0)) {
        var tmp$_8 = this.eventsStack_0;
        var $receiver_2 = new ParserEvent();
        $receiver_2.eventNode = currentParentNode;
        $receiver_2.eventType = 3;
        $receiver_2.eventNodeDepth = this.parentNodesStack_0.indexOf_11rb$(currentParentNode) + 1 | 0;
        tmp$_8.add_11rb$($receiver_2);
        removeLastOrNull(this.parentNodesStack_0);
        if (((tmp$_3 = currentParentNode.parentNode) != null ? tmp$_3.nextSibling : null) != null && equals((tmp$_4 = currentParentNode.parentNode) != null ? tmp$_4.lastChild : null, currentParentNode)) {
          var tmp$_9 = this.eventsStack_0;
          var $receiver_3 = new ParserEvent();
          $receiver_3.eventNode = currentParentNode.parentNode;
          $receiver_3.eventType = 3;
          $receiver_3.eventNodeDepth = indexOf(this.parentNodesStack_0, currentParentNode.parentNode) + 1 | 0;
          tmp$_9.add_11rb$($receiver_3);
          removeLastOrNull(this.parentNodesStack_0);
        }}}
    while (XmlPullParserJsImpl$logParserEvents$lambda_0(this)() != null) {
      var tmp$_10 = this.eventsStack_0;
      var $receiver_4 = new ParserEvent();
      $receiver_4.eventNode = this.lastParentNode_0;
      $receiver_4.eventType = 3;
      $receiver_4.eventNodeDepth = this.parentNodesStack_0.size + 1 | 0;
      tmp$_10.add_11rb$($receiver_4);
    }
    var tmp$_11 = this.eventsStack_0;
    var $receiver_5 = new ParserEvent();
    $receiver_5.eventNode = this.treeWalker_0.root;
    $receiver_5.eventType = 0;
    tmp$_11.add_wxm5ur$(0, $receiver_5);
    var tmp$_12 = this.eventsStack_0;
    var $receiver_6 = new ParserEvent();
    $receiver_6.eventNode = this.treeWalker_0.root;
    $receiver_6.eventType = 1;
    tmp$_12.add_11rb$($receiver_6);
    reverse(this.eventsStack_0);
  };
  XmlPullParserJsImpl.prototype.getAttributes_0 = function () {
    var tmp$, tmp$_0, tmp$_1;
    return (tmp$_1 = (tmp$_0 = (tmp$ = this.getCurrentEventElement_0()) != null ? tmp$.attributes : null) != null ? asList(tmp$_0) : null) != null ? tmp$_1 : emptyList();
  };
  XmlPullParserJsImpl.prototype.getCurrentEventElement_0 = function (event) {
    if (event === void 0)
      event = null;
    var tmp$, tmp$_0, tmp$_1;
    var mElement = event != null ? event : this.currentEvent_0;
    (tmp$ = mElement != null ? mElement.eventNode : null) != null ? tmp$.appendChild(this.document_0.createTextNode('text')) : null;
    return (tmp$_1 = (tmp$_0 = mElement != null ? mElement.eventNode : null) != null ? tmp$_0.lastChild : null) != null ? tmp$_1.parentElement : null;
  };
  XmlPullParserJsImpl.prototype.isStartOrEndTag_0 = function () {
    var tmp$, tmp$_0;
    return ((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) === 2 || ((tmp$_0 = this.currentEvent_0) != null ? tmp$_0.eventType : null) === 3;
  };
  XmlPullParserJsImpl.prototype.isNsEnabledAndStartOrEndTag_0 = function () {
    return this.processNsp_0 && this.isStartOrEndTag_0();
  };
  XmlPullParserJsImpl.prototype.getDepth = function () {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.currentEvent_0) != null ? tmp$.eventNodeDepth : null) != null ? tmp$_0 : -1;
  };
  XmlPullParserJsImpl.prototype.isWhitespace = function () {
    var tmp$;
    if (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) === 4) {
      var $receiver = this.getText();
      return $receiver == null || $receiver.length === 0;
    }return false;
  };
  XmlPullParserJsImpl.prototype.getText = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if (((tmp$_0 = (tmp$ = this.currentEvent_0) != null ? tmp$.eventNode : null) != null ? tmp$_0.nodeType : null) === Node.TEXT_NODE) {
      tmp$_3 = (tmp$_2 = (tmp$_1 = this.currentEvent_0) != null ? tmp$_1.eventNode : null) != null ? tmp$_2.textContent : null;
    } else
      tmp$_3 = null;
    return tmp$_3;
  };
  XmlPullParserJsImpl.prototype.getNamespace = function () {
    var tmp$;
    return this.isNsEnabledAndStartOrEndTag_0() ? (tmp$ = this.getCurrentEventElement_0()) != null ? tmp$.namespaceURI : null : !this.processNsp_0 ? '' : null;
  };
  XmlPullParserJsImpl.prototype.getNamespace_pdl1vj$ = function (prefix) {
    var tmp$;
    return (tmp$ = this.getCurrentEventElement_0()) != null ? tmp$.lookupNamespaceURI(prefix) : null;
  };
  XmlPullParserJsImpl.prototype.getName = function () {
    var tmp$, tmp$_0, tmp$_1;
    return (tmp$_1 = (tmp$_0 = (tmp$ = this.currentEvent_0) != null ? tmp$.eventNode : null) != null ? tmp$_0.nodeName : null) != null ? tmp$_1.toLowerCase() : null;
  };
  XmlPullParserJsImpl.prototype.getPrefix = function () {
    var tmp$, tmp$_0;
    return this.isNsEnabledAndStartOrEndTag_0() ? (tmp$_0 = (tmp$ = this.currentEvent_0) != null ? tmp$.eventNode : null) != null ? tmp$_0.lookupPrefix(null) : null : null;
  };
  XmlPullParserJsImpl.prototype.getAttributeCount = function () {
    var tmp$, tmp$_0;
    var currentNode = this.currentEvent_0;
    if (currentNode != null && currentNode.eventType === 2 && ((tmp$ = currentNode.eventNode) != null ? tmp$.nodeType : null) === Node.ELEMENT_NODE) {
      tmp$_0 = this.getAttributes_0().size;
    } else
      tmp$_0 = -1;
    return tmp$_0;
  };
  XmlPullParserJsImpl.prototype.getEventType = function () {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) != null ? tmp$_0 : -1;
  };
  XmlPullParserJsImpl.prototype.setFeature_ivxn3r$ = function (name, state) {
    if (equals(XmlPullParserConstants_getInstance().FEATURE_PROCESS_NAMESPACES, name))
      this.processNsp_0 = state;
    else if (this.isProp_0(name, false, 'relaxed'))
      this.relaxed_0 = state;
    else
      throw Exception_init('unsupported feature: ' + name);
  };
  XmlPullParserJsImpl.prototype.getFeature_61zpoe$ = function (name) {
    var tmp$;
    if (equals(XmlPullParserConstants_getInstance().FEATURE_PROCESS_NAMESPACES, name))
      tmp$ = this.processNsp_0;
    else if (this.isProp_0(name, false, 'relaxed'))
      tmp$ = this.relaxed_0;
    else
      tmp$ = false;
    return tmp$;
  };
  XmlPullParserJsImpl.prototype.getNamespaceCount_za3lpa$ = function (depth) {
    var tmp$;
    var namespaceSet = LinkedHashSet_init();
    var mDepth = depth + (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) === 3 ? 1 : 0) | 0;
    var $receiver = this.eventsStack_0;
    var destination = ArrayList_init();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (element.eventNodeDepth === mDepth)
        destination.add_11rb$(element);
    }
    var tmp$_1;
    tmp$_1 = destination.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var tmp$_2;
      var namespace = (tmp$_2 = this.getCurrentEventElement_0(element_0)) != null ? tmp$_2.namespaceURI : null;
      if (namespace != null) {
        namespaceSet.add_11rb$(namespace);
      }}
    return this.processNsp_0 ? namespaceSet.size : 0;
  };
  XmlPullParserJsImpl.prototype.getNamespacePrefix_za3lpa$ = function (pos) {
    var attributes = this.getAttributes_0();
    return attributes.get_za3lpa$(pos).prefix;
  };
  XmlPullParserJsImpl.prototype.getNamespaceUri_za3lpa$ = function (pos) {
    var tmp$, tmp$_0;
    var attributes = this.getAttributes_0();
    if (attributes.size < pos)
      throw new XmlPullParserException('');
    else
      tmp$_0 = (tmp$ = attributes.get_za3lpa$(pos).namespaceURI) != null ? tmp$ : '';
    return tmp$_0;
  };
  XmlPullParserJsImpl.prototype.getAttributeNamespace_za3lpa$ = function (index) {
    var tmp$, tmp$_0;
    var ns = this.getNamespaceUri_za3lpa$(index);
    var tmp$_1 = !this.processNsp_0;
    if (!tmp$_1) {
      tmp$_1 = ns.length === 0;
    }if (tmp$_1)
      tmp$_0 = '';
    else if (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) !== 2)
      throw IndexOutOfBoundsException_init();
    else
      tmp$_0 = ns;
    return tmp$_0;
  };
  XmlPullParserJsImpl.prototype.getAttributeName_za3lpa$ = function (index) {
    var tmp$, tmp$_0;
    var attributes = this.getAttributes_0();
    if (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) !== 2 || attributes.size < index)
      throw IndexOutOfBoundsException_init();
    else
      tmp$_0 = this.processNsp_0 ? attributes.get_za3lpa$(index).name : attributes.get_za3lpa$(index).localName;
    return tmp$_0;
  };
  XmlPullParserJsImpl.prototype.getAttributePrefix_za3lpa$ = function (index) {
    var tmp$, tmp$_0;
    var attributes = this.getAttributes_0();
    if (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) !== 2)
      throw IndexOutOfBoundsException_init();
    else {
      tmp$_0 = !attributes.isEmpty() && this.processNsp_0 ? attributes.get_za3lpa$(index).prefix : null;
    }
    return tmp$_0;
  };
  XmlPullParserJsImpl.prototype.getAttributeValue_za3lpa$ = function (index) {
    var tmp$;
    var attributes = this.getAttributes_0();
    var tmp$_0;
    if (((tmp$_0 = this.currentEvent_0) != null ? tmp$_0.eventType : null) !== 2 || attributes.size < index)
      throw IndexOutOfBoundsException_init();
    else
      tmp$ = attributes.get_za3lpa$(index).value;
    return tmp$;
  };
  XmlPullParserJsImpl.prototype.getAttributeValue_f5e6j7$ = function (namespace, name) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if (((tmp$_1 = this.currentEvent_0) != null ? tmp$_1.eventType : null) !== 2)
      throw IndexOutOfBoundsException_init();
    else {
      var $receiver = this.getAttributes_0();
      var firstOrNull$result;
      firstOrNull$break: do {
        var tmp$_2;
        tmp$_2 = $receiver.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          if ((equals(element.name, name) || contains(element.name, name)) && (element.namespaceURI == null || equals(element.namespaceURI, namespace))) {
            firstOrNull$result = element;
            break firstOrNull$break;
          }}
        firstOrNull$result = null;
      }
       while (false);
      tmp$_0 = (tmp$ = firstOrNull$result) != null ? tmp$.value : null;
    }
    return tmp$_0;
  };
  XmlPullParserJsImpl.prototype.next = function () {
    var tmp$, tmp$_0;
    this.currentEvent_0 = removeLastOrNull(this.eventsStack_0);
    return (tmp$_0 = (tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) != null ? tmp$_0 : -1;
  };
  XmlPullParserJsImpl.prototype.nextToken = function () {
    return this.next();
  };
  XmlPullParserJsImpl.prototype.nextTag = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    this.next();
    if (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) === 4 && ((tmp$_2 = (tmp$_1 = (tmp$_0 = this.currentEvent_0) != null ? tmp$_0.eventNode : null) != null ? tmp$_1.textContent : null) != null ? isBlank(tmp$_2) : null) === true)
      this.next();
    if (((tmp$_3 = this.currentEvent_0) != null ? tmp$_3.eventType === 2 || tmp$_3.eventType === 3 : null) !== true)
      throw new XmlPullParserException('nextTag: expected START_TAG or END_TAG');
    return (tmp$_5 = (tmp$_4 = this.currentEvent_0) != null ? tmp$_4.eventType : null) != null ? tmp$_5 : -1;
  };
  XmlPullParserJsImpl.prototype.nextText = function () {
    var tmp$, tmp$_0, tmp$_1;
    if (((tmp$ = this.currentEvent_0) != null ? tmp$.eventType : null) !== 2)
      throw new XmlPullParserException('nextText: precondition: current event must be start_tag');
    this.next();
    var result;
    if (((tmp$_0 = this.currentEvent_0) != null ? tmp$_0.eventType : null) === 4) {
      result = this.getText();
      this.next();
      this.next();
    } else {
      result = '';
    }
    if (((tmp$_1 = this.currentEvent_0) != null ? tmp$_1.eventType : null) !== 3) {
      throw new XmlPullParserException('nextText: END_TAG expected');
    }return result;
  };
  XmlPullParserJsImpl.prototype.getProperty_61zpoe$ = function (name) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    switch (name) {
      case 'http://xmlpull.org/v1/doc/properties.html#xmldecl-version':
        tmp$_2 = '1.0';
        break;
      case 'http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone':
        tmp$_2 = (tmp$_1 = (tmp$_0 = Kotlin.isType(tmp$ = this.document_0, XMLDocument) ? tmp$ : null) != null ? tmp$_0 : null) != null ? tmp$_1.xmlStandalone : null;
        break;
      default:tmp$_2 = null;
        break;
    }
    return tmp$_2;
  };
  XmlPullParserJsImpl.prototype.getInputEncoding = function () {
    return this.document_0.inputEncoding;
  };
  XmlPullParserJsImpl.prototype.getNode = function () {
    var tmp$;
    return (tmp$ = this.currentEvent_0) != null ? tmp$.eventNode : null;
  };
  XmlPullParserJsImpl.$metadata$ = {kind: Kind_CLASS, simpleName: 'XmlPullParserJsImpl', interfaces: [XmlPullParser]};
  function XmlSerializer() {
  }
  XmlSerializer.$metadata$ = {kind: Kind_INTERFACE, simpleName: 'XmlSerializer', interfaces: []};
  var package$com = _.com || (_.com = {});
  var package$ustadmobile = package$com.ustadmobile || (package$com.ustadmobile = {});
  var package$xmlpullparserkmp = package$ustadmobile.xmlpullparserkmp || (package$ustadmobile.xmlpullparserkmp = {});
  Object.defineProperty(package$xmlpullparserkmp, 'XmlPullParserConstants', {get: XmlPullParserConstants_getInstance});
  package$xmlpullparserkmp.ParserEvent = ParserEvent;
  package$xmlpullparserkmp.XmlPullParser = XmlPullParser;
  package$xmlpullparserkmp.XmlPullParserException = XmlPullParserException;
  package$xmlpullparserkmp.setInputString_fde4c1$ = setInputString;
  Object.defineProperty(XmlPullParserFactory, 'Companion', {get: XmlPullParserFactory$Companion_getInstance});
  package$xmlpullparserkmp.XmlPullParserFactory = XmlPullParserFactory;
  package$xmlpullparserkmp.XmlPullParserJsImpl = XmlPullParserJsImpl;
  package$xmlpullparserkmp.XmlSerializer = XmlSerializer;
  return _;
}));

//# sourceMappingURL=xmlpullparserkmp-js-legacy.js.map
