(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'door-room-annotations'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'door-room-annotations'.");
    }root['door-room-annotations'] = factory(typeof this['door-room-annotations'] === 'undefined' ? {} : this['door-room-annotations'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Annotation = Kotlin.kotlin.Annotation;
  var Long$Companion$MIN_VALUE = Kotlin.Long.MIN_VALUE;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  function IntDef(value, flag, open) {
    if (flag === void 0)
      flag = false;
    if (open === void 0)
      open = false;
    this.value = value;
    this.flag = flag;
    this.open = open;
  }
  IntDef.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IntDef',
    interfaces: [Annotation]
  };
  function IntRange(from, to) {
    if (from === void 0)
      from = Long$Companion$MIN_VALUE;
    if (to === void 0)
      to = Long$Companion$MAX_VALUE;
    this.from = from;
    this.to = to;
  }
  IntRange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IntRange',
    interfaces: [Annotation]
  };
  function NonNull() {
  }
  NonNull.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NonNull',
    interfaces: [Annotation]
  };
  function RequiresApi(value, api) {
    if (value === void 0)
      value = 1;
    if (api === void 0)
      api = 1;
    this.value = value;
    this.api = api;
  }
  RequiresApi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RequiresApi',
    interfaces: [Annotation]
  };
  function ColumnInfo(name, typeAffinity, index, collate, defaultValue) {
    ColumnInfo$Companion_getInstance();
    if (name === void 0)
      name = ColumnInfo$Companion_getInstance().INHERIT_FIELD_NAME;
    if (typeAffinity === void 0)
      typeAffinity = 1;
    if (index === void 0)
      index = false;
    if (collate === void 0)
      collate = 1;
    if (defaultValue === void 0)
      defaultValue = ColumnInfo$Companion_getInstance().VALUE_UNSPECIFIED;
    this.name = name;
    this.typeAffinity = typeAffinity;
    this.index = index;
    this.collate = collate;
    this.defaultValue = defaultValue;
  }
  function ColumnInfo$SQLiteTypeAffinity() {
  }
  ColumnInfo$SQLiteTypeAffinity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SQLiteTypeAffinity',
    interfaces: [Annotation]
  };
  function ColumnInfo$Collate() {
  }
  ColumnInfo$Collate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Collate',
    interfaces: [Annotation]
  };
  function ColumnInfo$Companion() {
    ColumnInfo$Companion_instance = this;
    this.INHERIT_FIELD_NAME = '[field-name]';
    this.UNDEFINED = 1;
    this.TEXT = 2;
    this.INTEGER = 3;
    this.REAL = 4;
    this.BLOB = 5;
    this.UNSPECIFIED = 1;
    this.BINARY = 2;
    this.NOCASE = 3;
    this.RTRIM = 4;
    this.LOCALIZED = 5;
    this.UNICODE = 6;
    this.VALUE_UNSPECIFIED = '[value-unspecified]';
  }
  ColumnInfo$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ColumnInfo$Companion_instance = null;
  function ColumnInfo$Companion_getInstance() {
    if (ColumnInfo$Companion_instance === null) {
      new ColumnInfo$Companion();
    }return ColumnInfo$Companion_instance;
  }
  ColumnInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColumnInfo',
    interfaces: [Annotation]
  };
  function Dao() {
  }
  Dao.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Dao',
    interfaces: [Annotation]
  };
  function Database(entities, views, version, exportSchema) {
    if (views === void 0)
      views = [];
    if (exportSchema === void 0)
      exportSchema = true;
    this.entities = entities;
    this.views = views;
    this.version = version;
    this.exportSchema = exportSchema;
  }
  Database.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Database',
    interfaces: [Annotation]
  };
  function Delete() {
  }
  Delete.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Delete',
    interfaces: [Annotation]
  };
  function Embedded(prefix) {
    if (prefix === void 0)
      prefix = '';
    this.prefix = prefix;
  }
  Embedded.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Embedded',
    interfaces: [Annotation]
  };
  function Entity(tableName, indices, inheritSuperIndices, primaryKeys, foreignKeys, ignoredColumns) {
    if (tableName === void 0)
      tableName = '';
    if (indices === void 0)
      indices = [];
    if (inheritSuperIndices === void 0)
      inheritSuperIndices = false;
    if (primaryKeys === void 0)
      primaryKeys = [];
    if (foreignKeys === void 0)
      foreignKeys = [];
    if (ignoredColumns === void 0)
      ignoredColumns = [];
    this.tableName = tableName;
    this.indices = indices;
    this.inheritSuperIndices = inheritSuperIndices;
    this.primaryKeys = primaryKeys;
    this.foreignKeys = foreignKeys;
    this.ignoredColumns = ignoredColumns;
  }
  Entity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Entity',
    interfaces: [Annotation]
  };
  function ForeignKey(entity, parentColumns, childColumns, onDelete, onUpdate, deferred) {
    ForeignKey$Companion_getInstance();
    if (onDelete === void 0)
      onDelete = 1;
    if (onUpdate === void 0)
      onUpdate = 1;
    if (deferred === void 0)
      deferred = false;
    this.entity = entity;
    this.parentColumns = parentColumns;
    this.childColumns = childColumns;
    this.onDelete = onDelete;
    this.onUpdate = onUpdate;
    this.deferred = deferred;
  }
  function ForeignKey$Action() {
  }
  ForeignKey$Action.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Action',
    interfaces: [Annotation]
  };
  function ForeignKey$Companion() {
    ForeignKey$Companion_instance = this;
    this.NO_ACTION = 1;
    this.RESTRICT = 2;
    this.SET_NULL = 3;
    this.SET_DEFAULT = 4;
    this.CASCADE = 5;
  }
  ForeignKey$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ForeignKey$Companion_instance = null;
  function ForeignKey$Companion_getInstance() {
    if (ForeignKey$Companion_instance === null) {
      new ForeignKey$Companion();
    }return ForeignKey$Companion_instance;
  }
  ForeignKey.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ForeignKey',
    interfaces: [Annotation]
  };
  function Index(value, name, unique) {
    if (name === void 0)
      name = '';
    if (unique === void 0)
      unique = false;
    this.value = value;
    this.name = name;
    this.unique = unique;
  }
  Index.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Index',
    interfaces: [Annotation]
  };
  function Insert(onConflict) {
    if (onConflict === void 0)
      onConflict = 3;
    this.onConflict = onConflict;
  }
  Insert.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Insert',
    interfaces: [Annotation]
  };
  function OnConflictStrategy() {
    OnConflictStrategy$Companion_getInstance();
  }
  function OnConflictStrategy$Companion() {
    OnConflictStrategy$Companion_instance = this;
    this.REPLACE = 1;
    this.ROLLBACK = 2;
    this.ABORT = 3;
    this.FAIL = 4;
    this.IGNORE = 5;
  }
  OnConflictStrategy$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnConflictStrategy$Companion_instance = null;
  function OnConflictStrategy$Companion_getInstance() {
    if (OnConflictStrategy$Companion_instance === null) {
      new OnConflictStrategy$Companion();
    }return OnConflictStrategy$Companion_instance;
  }
  OnConflictStrategy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OnConflictStrategy',
    interfaces: [Annotation]
  };
  function PrimaryKey(autoGenerate) {
    if (autoGenerate === void 0)
      autoGenerate = false;
    this.autoGenerate = autoGenerate;
  }
  PrimaryKey.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PrimaryKey',
    interfaces: [Annotation]
  };
  function Query(value) {
    this.value = value;
  }
  Query.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Query',
    interfaces: [Annotation]
  };
  function RawQuery(observedEntities) {
    if (observedEntities === void 0)
      observedEntities = [];
    this.observedEntities = observedEntities;
  }
  RawQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RawQuery',
    interfaces: [Annotation]
  };
  function Transaction() {
  }
  Transaction.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Transaction',
    interfaces: [Annotation]
  };
  function Update(onConflict) {
    if (onConflict === void 0)
      onConflict = 3;
    this.onConflict = onConflict;
  }
  Update.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Update',
    interfaces: [Annotation]
  };
  var package$androidx = _.androidx || (_.androidx = {});
  var package$annotation = package$androidx.annotation || (package$androidx.annotation = {});
  package$annotation.IntDef = IntDef;
  package$annotation.IntRange = IntRange;
  package$annotation.NonNull = NonNull;
  package$annotation.RequiresApi = RequiresApi;
  ColumnInfo.SQLiteTypeAffinity = ColumnInfo$SQLiteTypeAffinity;
  ColumnInfo.Collate = ColumnInfo$Collate;
  Object.defineProperty(ColumnInfo, 'Companion', {
    get: ColumnInfo$Companion_getInstance
  });
  var package$room = package$androidx.room || (package$androidx.room = {});
  package$room.ColumnInfo = ColumnInfo;
  package$room.Dao = Dao;
  package$room.Database = Database;
  package$room.Delete = Delete;
  package$room.Embedded = Embedded;
  package$room.Entity = Entity;
  ForeignKey.Action = ForeignKey$Action;
  Object.defineProperty(ForeignKey, 'Companion', {
    get: ForeignKey$Companion_getInstance
  });
  package$room.ForeignKey = ForeignKey;
  package$room.Index = Index;
  package$room.Insert = Insert;
  Object.defineProperty(OnConflictStrategy, 'Companion', {
    get: OnConflictStrategy$Companion_getInstance
  });
  package$room.OnConflictStrategy = OnConflictStrategy;
  package$room.PrimaryKey = PrimaryKey;
  package$room.Query = Query;
  package$room.RawQuery = RawQuery;
  package$room.Transaction = Transaction;
  package$room.Update = Update;
  Kotlin.defineModule('door-room-annotations', _);
  return _;
}));

//# sourceMappingURL=door-room-annotations.js.map
