"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = extendTheme;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _utils = require("@mui/utils");

var _system = require("@mui/system");

var _createTheme = _interopRequireDefault(require("./createTheme"));

var _Paper = require("../Paper/Paper");

const _excluded = ["colorSchemes"],
      _excluded2 = ["palette"];
const defaultDarkOverlays = [...Array(25)].map((_, index) => {
  if (index === 0) {
    return undefined;
  }

  const overlay = (0, _Paper.getOverlayAlpha)(index);
  return `linear-gradient(rgba(255 255 255 / ${overlay}), rgba(255 255 255 / ${overlay}))`;
});

function assignNode(obj, keys) {
  keys.forEach(k => {
    if (!obj[k]) {
      obj[k] = {};
    }
  });
}

function setColor(obj, key, defaultValue) {
  obj[key] = obj[key] || defaultValue;
}

function extendTheme(options = {}, ...args) {
  var _colorSchemesInput$li, _colorSchemesInput$da, _colorSchemesInput$li2, _colorSchemesInput$li3, _colorSchemesInput$da2, _colorSchemesInput$da3;

  const {
    colorSchemes: colorSchemesInput = {}
  } = options,
        input = (0, _objectWithoutPropertiesLoose2.default)(options, _excluded);

  const _createThemeWithoutVa = (0, _createTheme.default)((0, _extends2.default)({}, input, colorSchemesInput.light && {
    palette: (_colorSchemesInput$li = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li.palette
  })),
        {
    palette: lightPalette
  } = _createThemeWithoutVa,
        muiTheme = (0, _objectWithoutPropertiesLoose2.default)(_createThemeWithoutVa, _excluded2);

  const {
    palette: darkPalette
  } = (0, _createTheme.default)({
    palette: (0, _extends2.default)({
      mode: 'dark'
    }, (_colorSchemesInput$da = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da.palette)
  });
  let theme = (0, _extends2.default)({}, muiTheme, {
    colorSchemes: (0, _extends2.default)({}, colorSchemesInput, {
      light: (0, _extends2.default)({}, colorSchemesInput.light, {
        palette: lightPalette,
        opacity: (0, _extends2.default)({
          inputPlaceholder: 0.42,
          inputTouchBottomLine: 0.42,
          switchTrackDisabled: 0.12,
          switchTrack: 0.38
        }, (_colorSchemesInput$li2 = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li2.opacity),
        overlays: ((_colorSchemesInput$li3 = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li3.overlays) || []
      }),
      dark: (0, _extends2.default)({}, colorSchemesInput.dark, {
        palette: darkPalette,
        opacity: (0, _extends2.default)({
          inputPlaceholder: 0.5,
          inputTouchBottomLine: 0.7,
          switchTrackDisabled: 0.2,
          switchTrack: 0.3
        }, (_colorSchemesInput$da2 = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da2.opacity),
        overlays: ((_colorSchemesInput$da3 = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da3.overlays) || defaultDarkOverlays
      })
    })
  });
  Object.keys(theme.colorSchemes).forEach(key => {
    const palette = theme.colorSchemes[key].palette; // attach black & white channels to common node

    if (key === 'light') {
      setColor(palette.common, 'background', '#fff');
      setColor(palette.common, 'onBackground', '#000');
    } else {
      setColor(palette.common, 'background', '#000');
      setColor(palette.common, 'onBackground', '#fff');
    } // assign component variables


    assignNode(palette, ['AppBar', 'Avatar', 'Chip', 'FilledInput', 'LinearProgress', 'Skeleton', 'Slider', 'SnackbarContent', 'SpeedDialAction', 'StepConnector', 'StepContent', 'Switch', 'TableCell', 'Tooltip']);

    if (key === 'light') {
      setColor(palette.AppBar, 'defaultBg', 'var(--mui-palette-grey-100)');
      setColor(palette.Avatar, 'defaultBg', 'var(--mui-palette-grey-400)');
      setColor(palette.Chip, 'defaultBorder', 'var(--mui-palette-grey-400)');
      setColor(palette.Chip, 'defaultAvatarColor', 'var(--mui-palette-grey-700)');
      setColor(palette.Chip, 'defaultIconColor', 'var(--mui-palette-grey-700)');
      setColor(palette.FilledInput, 'bg', 'rgba(0, 0, 0, 0.06)');
      setColor(palette.FilledInput, 'hoverBg', 'rgba(0, 0, 0, 0.09)');
      setColor(palette.FilledInput, 'disabledBg', 'rgba(0, 0, 0, 0.12)');
      setColor(palette.LinearProgress, 'primaryBg', (0, _system.lighten)(palette.primary.main, 0.62));
      setColor(palette.LinearProgress, 'secondaryBg', (0, _system.lighten)(palette.secondary.main, 0.62));
      setColor(palette.LinearProgress, 'errorBg', (0, _system.lighten)(palette.error.main, 0.62));
      setColor(palette.LinearProgress, 'infoBg', (0, _system.lighten)(palette.info.main, 0.62));
      setColor(palette.LinearProgress, 'successBg', (0, _system.lighten)(palette.success.main, 0.62));
      setColor(palette.LinearProgress, 'warningBg', (0, _system.lighten)(palette.warning.main, 0.62));
      setColor(palette.Skeleton, 'bg', 'rgba(var(--mui-palette-text-primaryChannel) / 0.11)');
      setColor(palette.Slider, 'primaryTrack', (0, _system.lighten)(palette.primary.main, 0.62));
      setColor(palette.Slider, 'secondaryTrack', (0, _system.lighten)(palette.secondary.main, 0.62));
      setColor(palette.Slider, 'errorTrack', (0, _system.lighten)(palette.error.main, 0.62));
      setColor(palette.Slider, 'infoTrack', (0, _system.lighten)(palette.info.main, 0.62));
      setColor(palette.Slider, 'successTrack', (0, _system.lighten)(palette.success.main, 0.62));
      setColor(palette.Slider, 'warningTrack', (0, _system.lighten)(palette.warning.main, 0.62));
      setColor(palette.SnackbarContent, 'bg', (0, _system.emphasize)(palette.background.default, 0.8));
      setColor(palette.SpeedDialAction, 'fabHoverBg', (0, _system.emphasize)(palette.background.paper, 0.15));
      setColor(palette.StepConnector, 'border', 'var(--mui-palette-grey-400)');
      setColor(palette.StepContent, 'border', 'var(--mui-palette-grey-400)');
      setColor(palette.Switch, 'defaultColor', 'var(--mui-palette-common-white)');
      setColor(palette.Switch, 'defaultDisabledColor', 'var(--mui-palette-grey-100)');
      setColor(palette.Switch, 'primaryDisabledColor', (0, _system.lighten)(palette.primary.main, 0.62));
      setColor(palette.Switch, 'secondaryDisabledColor', (0, _system.lighten)(palette.secondary.main, 0.62));
      setColor(palette.Switch, 'errorDisabledColor', (0, _system.lighten)(palette.error.main, 0.62));
      setColor(palette.Switch, 'infoDisabledColor', (0, _system.lighten)(palette.info.main, 0.62));
      setColor(palette.Switch, 'successDisabledColor', (0, _system.lighten)(palette.success.main, 0.62));
      setColor(palette.Switch, 'warningDisabledColor', (0, _system.lighten)(palette.warning.main, 0.62));
      setColor(palette.TableCell, 'border', (0, _system.lighten)((0, _system.alpha)(palette.divider, 1), 0.88));
      setColor(palette.Tooltip, 'bg', (0, _system.alpha)(palette.grey[700], 0.92));
    } else {
      setColor(palette.AppBar, 'defaultBg', 'var(--mui-palette-grey-900)');
      setColor(palette.AppBar, 'darkBg', 'var(--mui-palette-background-paper)'); // specific for dark mode

      setColor(palette.AppBar, 'darkColor', 'var(--mui-palette-text-primary)'); // specific for dark mode

      setColor(palette.Avatar, 'defaultBg', 'var(--mui-palette-grey-600)');
      setColor(palette.Chip, 'defaultBorder', 'var(--mui-palette-grey-700)');
      setColor(palette.Chip, 'defaultAvatarColor', 'var(--mui-palette-grey-300)');
      setColor(palette.Chip, 'defaultIconColor', 'var(--mui-palette-grey-300)');
      setColor(palette.FilledInput, 'bg', 'rgba(255, 255, 255, 0.09)');
      setColor(palette.FilledInput, 'hoverBg', 'rgba(255, 255, 255, 0.13)');
      setColor(palette.FilledInput, 'disabledBg', 'rgba(255, 255, 255, 0.12)');
      setColor(palette.LinearProgress, 'primaryBg', (0, _system.darken)(palette.primary.main, 0.5));
      setColor(palette.LinearProgress, 'secondaryBg', (0, _system.darken)(palette.secondary.main, 0.5));
      setColor(palette.LinearProgress, 'errorBg', (0, _system.darken)(palette.error.main, 0.5));
      setColor(palette.LinearProgress, 'infoBg', (0, _system.darken)(palette.info.main, 0.5));
      setColor(palette.LinearProgress, 'successBg', (0, _system.darken)(palette.success.main, 0.5));
      setColor(palette.LinearProgress, 'warningBg', (0, _system.darken)(palette.warning.main, 0.5));
      setColor(palette.Skeleton, 'bg', 'rgba(var(--mui-palette-text-primaryChannel) / 0.13)');
      setColor(palette.Slider, 'primaryTrack', (0, _system.darken)(palette.primary.main, 0.5));
      setColor(palette.Slider, 'secondaryTrack', (0, _system.darken)(palette.secondary.main, 0.5));
      setColor(palette.Slider, 'errorTrack', (0, _system.darken)(palette.error.main, 0.5));
      setColor(palette.Slider, 'infoTrack', (0, _system.darken)(palette.info.main, 0.5));
      setColor(palette.Slider, 'successTrack', (0, _system.darken)(palette.success.main, 0.5));
      setColor(palette.Slider, 'warningTrack', (0, _system.darken)(palette.warning.main, 0.5));
      setColor(palette.SnackbarContent, 'bg', (0, _system.emphasize)(palette.background.default, 0.98));
      setColor(palette.SpeedDialAction, 'fabHoverBg', (0, _system.emphasize)(palette.background.paper, 0.15));
      setColor(palette.StepConnector, 'border', 'var(--mui-palette-grey-600)');
      setColor(palette.StepContent, 'border', 'var(--mui-palette-grey-600)');
      setColor(palette.Switch, 'defaultColor', 'var(--mui-palette-grey-300)');
      setColor(palette.Switch, 'defaultDisabledColor', 'var(--mui-palette-grey-600)');
      setColor(palette.Switch, 'primaryDisabledColor', (0, _system.darken)(palette.primary.main, 0.55));
      setColor(palette.Switch, 'secondaryDisabledColor', (0, _system.darken)(palette.secondary.main, 0.55));
      setColor(palette.Switch, 'errorDisabledColor', (0, _system.darken)(palette.error.main, 0.55));
      setColor(palette.Switch, 'infoDisabledColor', (0, _system.darken)(palette.info.main, 0.55));
      setColor(palette.Switch, 'successDisabledColor', (0, _system.darken)(palette.success.main, 0.55));
      setColor(palette.Switch, 'warningDisabledColor', (0, _system.darken)(palette.warning.main, 0.55));
      setColor(palette.TableCell, 'border', (0, _system.darken)((0, _system.alpha)(palette.divider, 1), 0.68));
      setColor(palette.Tooltip, 'bg', (0, _system.alpha)(palette.grey[700], 0.92));
    }

    palette.common.backgroundChannel = (0, _system.colorChannel)(palette.common.background);
    palette.common.onBackgroundChannel = (0, _system.colorChannel)(palette.common.onBackground);
    palette.dividerChannel = (0, _system.colorChannel)(palette.divider);
    Object.keys(palette).forEach(color => {
      const colors = palette[color]; // Color palettes: primary, secondary, error, info, success, and warning

      if (colors.main) {
        palette[color].mainChannel = (0, _system.colorChannel)(colors.main);
      }

      if (colors.light) {
        palette[color].lightChannel = (0, _system.colorChannel)(colors.light);
      }

      if (colors.dark) {
        palette[color].darkChannel = (0, _system.colorChannel)(colors.dark);
      }

      if (colors.contrastText) {
        palette[color].contrastTextChannel = (0, _system.colorChannel)(colors.contrastText);
      } // Text colors: text.primary, text.secondary


      if (colors.primary) {
        palette[color].primaryChannel = (0, _system.colorChannel)(colors.primary);
      }

      if (colors.secondary) {
        palette[color].secondaryChannel = (0, _system.colorChannel)(colors.secondary);
      } // Action colors: action.active, action.selected


      if (colors.active) {
        palette[color].activeChannel = (0, _system.colorChannel)(colors.active);
      }

      if (colors.selected) {
        palette[color].selectedChannel = (0, _system.colorChannel)(colors.selected);
      }
    });
  });
  theme = args.reduce((acc, argument) => (0, _utils.deepmerge)(acc, argument), theme);
  return theme;
}