/** @license MUI v5.8.5
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('react-dom')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', 'react-dom'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.MaterialUI = {}, global.React, global.ReactDOM));
})(this, (function (exports, React, ReactDOM) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var React__namespace = /*#__PURE__*/_interopNamespace(React);
  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
  var ReactDOM__namespace = /*#__PURE__*/_interopNamespace(ReactDOM);
  var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);

  const common = {
    black: '#000',
    white: '#fff'
  };
  var common$1 = common;

  const red = {
    50: '#ffebee',
    100: '#ffcdd2',
    200: '#ef9a9a',
    300: '#e57373',
    400: '#ef5350',
    500: '#f44336',
    600: '#e53935',
    700: '#d32f2f',
    800: '#c62828',
    900: '#b71c1c',
    A100: '#ff8a80',
    A200: '#ff5252',
    A400: '#ff1744',
    A700: '#d50000'
  };
  var red$1 = red;

  const pink = {
    50: '#fce4ec',
    100: '#f8bbd0',
    200: '#f48fb1',
    300: '#f06292',
    400: '#ec407a',
    500: '#e91e63',
    600: '#d81b60',
    700: '#c2185b',
    800: '#ad1457',
    900: '#880e4f',
    A100: '#ff80ab',
    A200: '#ff4081',
    A400: '#f50057',
    A700: '#c51162'
  };
  var pink$1 = pink;

  const purple = {
    50: '#f3e5f5',
    100: '#e1bee7',
    200: '#ce93d8',
    300: '#ba68c8',
    400: '#ab47bc',
    500: '#9c27b0',
    600: '#8e24aa',
    700: '#7b1fa2',
    800: '#6a1b9a',
    900: '#4a148c',
    A100: '#ea80fc',
    A200: '#e040fb',
    A400: '#d500f9',
    A700: '#aa00ff'
  };
  var purple$1 = purple;

  const deepPurple = {
    50: '#ede7f6',
    100: '#d1c4e9',
    200: '#b39ddb',
    300: '#9575cd',
    400: '#7e57c2',
    500: '#673ab7',
    600: '#5e35b1',
    700: '#512da8',
    800: '#4527a0',
    900: '#311b92',
    A100: '#b388ff',
    A200: '#7c4dff',
    A400: '#651fff',
    A700: '#6200ea'
  };
  var deepPurple$1 = deepPurple;

  const indigo = {
    50: '#e8eaf6',
    100: '#c5cae9',
    200: '#9fa8da',
    300: '#7986cb',
    400: '#5c6bc0',
    500: '#3f51b5',
    600: '#3949ab',
    700: '#303f9f',
    800: '#283593',
    900: '#1a237e',
    A100: '#8c9eff',
    A200: '#536dfe',
    A400: '#3d5afe',
    A700: '#304ffe'
  };
  var indigo$1 = indigo;

  const blue = {
    50: '#e3f2fd',
    100: '#bbdefb',
    200: '#90caf9',
    300: '#64b5f6',
    400: '#42a5f5',
    500: '#2196f3',
    600: '#1e88e5',
    700: '#1976d2',
    800: '#1565c0',
    900: '#0d47a1',
    A100: '#82b1ff',
    A200: '#448aff',
    A400: '#2979ff',
    A700: '#2962ff'
  };
  var blue$1 = blue;

  const lightBlue = {
    50: '#e1f5fe',
    100: '#b3e5fc',
    200: '#81d4fa',
    300: '#4fc3f7',
    400: '#29b6f6',
    500: '#03a9f4',
    600: '#039be5',
    700: '#0288d1',
    800: '#0277bd',
    900: '#01579b',
    A100: '#80d8ff',
    A200: '#40c4ff',
    A400: '#00b0ff',
    A700: '#0091ea'
  };
  var lightBlue$1 = lightBlue;

  const cyan = {
    50: '#e0f7fa',
    100: '#b2ebf2',
    200: '#80deea',
    300: '#4dd0e1',
    400: '#26c6da',
    500: '#00bcd4',
    600: '#00acc1',
    700: '#0097a7',
    800: '#00838f',
    900: '#006064',
    A100: '#84ffff',
    A200: '#18ffff',
    A400: '#00e5ff',
    A700: '#00b8d4'
  };
  var cyan$1 = cyan;

  const teal = {
    50: '#e0f2f1',
    100: '#b2dfdb',
    200: '#80cbc4',
    300: '#4db6ac',
    400: '#26a69a',
    500: '#009688',
    600: '#00897b',
    700: '#00796b',
    800: '#00695c',
    900: '#004d40',
    A100: '#a7ffeb',
    A200: '#64ffda',
    A400: '#1de9b6',
    A700: '#00bfa5'
  };
  var teal$1 = teal;

  const green = {
    50: '#e8f5e9',
    100: '#c8e6c9',
    200: '#a5d6a7',
    300: '#81c784',
    400: '#66bb6a',
    500: '#4caf50',
    600: '#43a047',
    700: '#388e3c',
    800: '#2e7d32',
    900: '#1b5e20',
    A100: '#b9f6ca',
    A200: '#69f0ae',
    A400: '#00e676',
    A700: '#00c853'
  };
  var green$1 = green;

  const lightGreen = {
    50: '#f1f8e9',
    100: '#dcedc8',
    200: '#c5e1a5',
    300: '#aed581',
    400: '#9ccc65',
    500: '#8bc34a',
    600: '#7cb342',
    700: '#689f38',
    800: '#558b2f',
    900: '#33691e',
    A100: '#ccff90',
    A200: '#b2ff59',
    A400: '#76ff03',
    A700: '#64dd17'
  };
  var lightGreen$1 = lightGreen;

  const lime = {
    50: '#f9fbe7',
    100: '#f0f4c3',
    200: '#e6ee9c',
    300: '#dce775',
    400: '#d4e157',
    500: '#cddc39',
    600: '#c0ca33',
    700: '#afb42b',
    800: '#9e9d24',
    900: '#827717',
    A100: '#f4ff81',
    A200: '#eeff41',
    A400: '#c6ff00',
    A700: '#aeea00'
  };
  var lime$1 = lime;

  const yellow = {
    50: '#fffde7',
    100: '#fff9c4',
    200: '#fff59d',
    300: '#fff176',
    400: '#ffee58',
    500: '#ffeb3b',
    600: '#fdd835',
    700: '#fbc02d',
    800: '#f9a825',
    900: '#f57f17',
    A100: '#ffff8d',
    A200: '#ffff00',
    A400: '#ffea00',
    A700: '#ffd600'
  };
  var yellow$1 = yellow;

  const amber = {
    50: '#fff8e1',
    100: '#ffecb3',
    200: '#ffe082',
    300: '#ffd54f',
    400: '#ffca28',
    500: '#ffc107',
    600: '#ffb300',
    700: '#ffa000',
    800: '#ff8f00',
    900: '#ff6f00',
    A100: '#ffe57f',
    A200: '#ffd740',
    A400: '#ffc400',
    A700: '#ffab00'
  };
  var amber$1 = amber;

  const orange = {
    50: '#fff3e0',
    100: '#ffe0b2',
    200: '#ffcc80',
    300: '#ffb74d',
    400: '#ffa726',
    500: '#ff9800',
    600: '#fb8c00',
    700: '#f57c00',
    800: '#ef6c00',
    900: '#e65100',
    A100: '#ffd180',
    A200: '#ffab40',
    A400: '#ff9100',
    A700: '#ff6d00'
  };
  var orange$1 = orange;

  const deepOrange = {
    50: '#fbe9e7',
    100: '#ffccbc',
    200: '#ffab91',
    300: '#ff8a65',
    400: '#ff7043',
    500: '#ff5722',
    600: '#f4511e',
    700: '#e64a19',
    800: '#d84315',
    900: '#bf360c',
    A100: '#ff9e80',
    A200: '#ff6e40',
    A400: '#ff3d00',
    A700: '#dd2c00'
  };
  var deepOrange$1 = deepOrange;

  const brown = {
    50: '#efebe9',
    100: '#d7ccc8',
    200: '#bcaaa4',
    300: '#a1887f',
    400: '#8d6e63',
    500: '#795548',
    600: '#6d4c41',
    700: '#5d4037',
    800: '#4e342e',
    900: '#3e2723',
    A100: '#d7ccc8',
    A200: '#bcaaa4',
    A400: '#8d6e63',
    A700: '#5d4037'
  };
  var brown$1 = brown;

  const grey = {
    50: '#fafafa',
    100: '#f5f5f5',
    200: '#eeeeee',
    300: '#e0e0e0',
    400: '#bdbdbd',
    500: '#9e9e9e',
    600: '#757575',
    700: '#616161',
    800: '#424242',
    900: '#212121',
    A100: '#f5f5f5',
    A200: '#eeeeee',
    A400: '#bdbdbd',
    A700: '#616161'
  };
  var grey$1 = grey;

  const blueGrey = {
    50: '#eceff1',
    100: '#cfd8dc',
    200: '#b0bec5',
    300: '#90a4ae',
    400: '#78909c',
    500: '#607d8b',
    600: '#546e7a',
    700: '#455a64',
    800: '#37474f',
    900: '#263238',
    A100: '#cfd8dc',
    A200: '#b0bec5',
    A400: '#78909c',
    A700: '#455a64'
  };
  var blueGrey$1 = blueGrey;

  var index = /*#__PURE__*/Object.freeze({
    __proto__: null,
    common: common$1,
    red: red$1,
    pink: pink$1,
    purple: purple$1,
    deepPurple: deepPurple$1,
    indigo: indigo$1,
    blue: blue$1,
    lightBlue: lightBlue$1,
    cyan: cyan$1,
    teal: teal$1,
    green: green$1,
    lightGreen: lightGreen$1,
    lime: lime$1,
    yellow: yellow$1,
    amber: amber$1,
    orange: orange$1,
    deepOrange: deepOrange$1,
    brown: brown$1,
    grey: grey$1,
    blueGrey: blueGrey$1
  });

  var global$1 = (typeof global !== "undefined" ? global :
              typeof self !== "undefined" ? self :
              typeof window !== "undefined" ? window : {});

  if (typeof global$1.setTimeout === 'function') ;
  if (typeof global$1.clearTimeout === 'function') ;

  // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
  var performance$1 = global$1.performance || {};
  performance$1.now        ||
    performance$1.mozNow     ||
    performance$1.msNow      ||
    performance$1.oNow       ||
    performance$1.webkitNow  ||
    function(){ return (new Date()).getTime() };

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var _extends_1 = createCommonjsModule(function (module) {
  function _extends() {
    module.exports = _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    }, module.exports.__esModule = true, module.exports["default"] = module.exports;
    return _extends.apply(this, arguments);
  }

  module.exports = _extends, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  unwrapExports(_extends_1);

  function memoize$1(fn) {
    var cache = Object.create(null);
    return function (arg) {
      if (cache[arg] === undefined) cache[arg] = fn(arg);
      return cache[arg];
    };
  }

  var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|enterKeyHint|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

  var isPropValid = /* #__PURE__ */memoize$1(function (prop) {
    return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
    /* o */
    && prop.charCodeAt(1) === 110
    /* n */
    && prop.charCodeAt(2) < 91;
  }
  /* Z+1 */
  );

  /*

  Based off glamor's StyleSheet, thanks Sunil ❤️

  high performance StyleSheet for css-in-js systems

  - uses multiple style tags behind the scenes for millions of rules
  - uses `insertRule` for appending in production for *much* faster performance

  // usage

  import { StyleSheet } from '@emotion/sheet'

  let styleSheet = new StyleSheet({ key: '', container: document.head })

  styleSheet.insert('#box { border: 1px solid red; }')
  - appends a css rule into the stylesheet

  styleSheet.flush()
  - empties the stylesheet of all its contents

  */
  // $FlowFixMe
  function sheetForTag(tag) {
    if (tag.sheet) {
      // $FlowFixMe
      return tag.sheet;
    } // this weirdness brought to you by firefox

    /* istanbul ignore next */


    for (var i = 0; i < document.styleSheets.length; i++) {
      if (document.styleSheets[i].ownerNode === tag) {
        // $FlowFixMe
        return document.styleSheets[i];
      }
    }
  }

  function createStyleElement(options) {
    var tag = document.createElement('style');
    tag.setAttribute('data-emotion', options.key);

    if (options.nonce !== undefined) {
      tag.setAttribute('nonce', options.nonce);
    }

    tag.appendChild(document.createTextNode(''));
    tag.setAttribute('data-s', '');
    return tag;
  }

  var StyleSheet = /*#__PURE__*/function () {
    function StyleSheet(options) {
      var _this = this;

      this._insertTag = function (tag) {
        var before;

        if (_this.tags.length === 0) {
          if (_this.insertionPoint) {
            before = _this.insertionPoint.nextSibling;
          } else if (_this.prepend) {
            before = _this.container.firstChild;
          } else {
            before = _this.before;
          }
        } else {
          before = _this.tags[_this.tags.length - 1].nextSibling;
        }

        _this.container.insertBefore(tag, before);

        _this.tags.push(tag);
      };

      this.isSpeedy = options.speedy === undefined ? "development" === 'production' : options.speedy;
      this.tags = [];
      this.ctr = 0;
      this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

      this.key = options.key;
      this.container = options.container;
      this.prepend = options.prepend;
      this.insertionPoint = options.insertionPoint;
      this.before = null;
    }

    var _proto = StyleSheet.prototype;

    _proto.hydrate = function hydrate(nodes) {
      nodes.forEach(this._insertTag);
    };

    _proto.insert = function insert(rule) {
      // the max length is how many rules we have per style tag, it's 65000 in speedy mode
      // it's 1 in dev because we insert source maps that map a single rule to a location
      // and you can only have one source map per style tag
      if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
        this._insertTag(createStyleElement(this));
      }

      var tag = this.tags[this.tags.length - 1];

      {
        var isImportRule = rule.charCodeAt(0) === 64 && rule.charCodeAt(1) === 105;

        if (isImportRule && this._alreadyInsertedOrderInsensitiveRule) {
          // this would only cause problem in speedy mode
          // but we don't want enabling speedy to affect the observable behavior
          // so we report this error at all times
          console.error("You're attempting to insert the following rule:\n" + rule + '\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules.');
        }
        this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !isImportRule;
      }

      if (this.isSpeedy) {
        var sheet = sheetForTag(tag);

        try {
          // this is the ultrafast version, works across browsers
          // the big drawback is that the css won't be editable in devtools
          sheet.insertRule(rule, sheet.cssRules.length);
        } catch (e) {
          if (!/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear){/.test(rule)) {
            console.error("There was a problem inserting the following rule: \"" + rule + "\"", e);
          }
        }
      } else {
        tag.appendChild(document.createTextNode(rule));
      }

      this.ctr++;
    };

    _proto.flush = function flush() {
      // $FlowFixMe
      this.tags.forEach(function (tag) {
        return tag.parentNode && tag.parentNode.removeChild(tag);
      });
      this.tags = [];
      this.ctr = 0;

      {
        this._alreadyInsertedOrderInsensitiveRule = false;
      }
    };

    return StyleSheet;
  }();

  var e="-ms-";var r="-moz-";var a="-webkit-";var c="comm";var n="rule";var t="decl";var i="@import";var p="@keyframes";var k=Math.abs;var d=String.fromCharCode;var g=Object.assign;function m(e,r){return (((r<<2^z(e,0))<<2^z(e,1))<<2^z(e,2))<<2^z(e,3)}function x$1(e){return e.trim()}function y(e,r){return (e=r.exec(e))?e[0]:e}function j(e,r,a){return e.replace(r,a)}function C(e,r){return e.indexOf(r)}function z(e,r){return e.charCodeAt(r)|0}function A(e,r,a){return e.slice(r,a)}function O(e){return e.length}function M(e){return e.length}function S(e,r){return r.push(e),e}function q(e,r){return e.map(r).join("")}var B=1;var D=1;var E=0;var F=0;var G=0;var H="";function I(e,r,a,c,n,t,s){return {value:e,root:r,parent:a,type:c,props:n,children:t,line:B,column:D,length:s,return:""}}function J(e,r){return g(I("",null,null,"",null,null,0),e,{length:-e.length},r)}function K(){return G}function L(){G=F>0?z(H,--F):0;if(D--,G===10)D=1,B--;return G}function N(){G=F<E?z(H,F++):0;if(D++,G===10)D=1,B++;return G}function P(){return z(H,F)}function Q(){return F}function R(e,r){return A(H,e,r)}function T(e){switch(e){case 0:case 9:case 10:case 13:case 32:return 5;case 33:case 43:case 44:case 47:case 62:case 64:case 126:case 59:case 123:case 125:return 4;case 58:return 3;case 34:case 39:case 40:case 91:return 2;case 41:case 93:return 1}return 0}function U(e){return B=D=1,E=O(H=e),F=0,[]}function V(e){return H="",e}function W(e){return x$1(R(F-1,ee(e===91?e+2:e===40?e+1:e)))}function Y(e){while(G=P())if(G<33)N();else break;return T(e)>2||T(G)>3?"":" "}function _$4(e,r){while(--r&&N())if(G<48||G>102||G>57&&G<65||G>70&&G<97)break;return R(e,Q()+(r<6&&P()==32&&N()==32))}function ee(e){while(N())switch(G){case e:return F;case 34:case 39:if(e!==34&&e!==39)ee(G);break;case 40:if(e===41)ee(e);break;case 92:N();break}return F}function re(e,r){while(N())if(e+G===47+10)break;else if(e+G===42+42&&P()===47)break;return "/*"+R(r,F-1)+"*"+d(e===47?e:N())}function ae(e){while(!T(P()))N();return R(e,F)}function ce(e){return V(ne("",null,null,null,[""],e=U(e),0,[0],e))}function ne(e,r,a,c,n,t,s,u,i){var f=0;var o=0;var l=s;var v=0;var h=0;var p=0;var b=1;var w=1;var $=1;var k=0;var g="";var m=n;var x=t;var y=c;var z=g;while(w)switch(p=k,k=N()){case 40:if(p!=108&&z.charCodeAt(l-1)==58){if(C(z+=j(W(k),"&","&\f"),"&\f")!=-1)$=-1;break}case 34:case 39:case 91:z+=W(k);break;case 9:case 10:case 13:case 32:z+=Y(p);break;case 92:z+=_$4(Q()-1,7);continue;case 47:switch(P()){case 42:case 47:S(se(re(N(),Q()),r,a),i);break;default:z+="/";}break;case 123*b:u[f++]=O(z)*$;case 125*b:case 59:case 0:switch(k){case 0:case 125:w=0;case 59+o:if(h>0&&O(z)-l)S(h>32?ue(z+";",c,a,l-1):ue(j(z," ","")+";",c,a,l-2),i);break;case 59:z+=";";default:S(y=te(z,r,a,f,o,n,u,g,m=[],x=[],l),t);if(k===123)if(o===0)ne(z,r,y,y,m,t,l,u,x);else switch(v){case 100:case 109:case 115:ne(e,y,y,c&&S(te(e,y,y,0,0,n,u,g,n,m=[],l),x),n,x,l,u,c?m:x);break;default:ne(z,y,y,y,[""],x,0,u,x);}}f=o=h=0,b=$=1,g=z="",l=s;break;case 58:l=1+O(z),h=p;default:if(b<1)if(k==123)--b;else if(k==125&&b++==0&&L()==125)continue;switch(z+=d(k),k*b){case 38:$=o>0?1:(z+="\f",-1);break;case 44:u[f++]=(O(z)-1)*$,$=1;break;case 64:if(P()===45)z+=W(N());v=P(),o=l=O(g=z+=ae(Q())),k++;break;case 45:if(p===45&&O(z)==2)b=0;}}return t}function te(e,r,a,c,t,s,u,i,f,o,l){var v=t-1;var h=t===0?s:[""];var p=M(h);for(var b=0,w=0,$=0;b<c;++b)for(var d=0,g=A(e,v+1,v=k(w=u[b])),m=e;d<p;++d)if(m=x$1(w>0?h[d]+" "+g:j(g,/&\f/g,h[d])))f[$++]=m;return I(e,r,a,t===0?n:i,f,o,l)}function se(e,r,a){return I(e,r,a,c,d(K()),A(e,2,-2),0)}function ue(e,r,a,c){return I(e,r,a,t,A(e,0,c),A(e,c+1,-1),c)}function ie(c,n){switch(m(c,n)){case 5103:return a+"print-"+c+c;case 5737:case 4201:case 3177:case 3433:case 1641:case 4457:case 2921:case 5572:case 6356:case 5844:case 3191:case 6645:case 3005:case 6391:case 5879:case 5623:case 6135:case 4599:case 4855:case 4215:case 6389:case 5109:case 5365:case 5621:case 3829:return a+c+c;case 5349:case 4246:case 4810:case 6968:case 2756:return a+c+r+c+e+c+c;case 6828:case 4268:return a+c+e+c+c;case 6165:return a+c+e+"flex-"+c+c;case 5187:return a+c+j(c,/(\w+).+(:[^]+)/,a+"box-$1$2"+e+"flex-$1$2")+c;case 5443:return a+c+e+"flex-item-"+j(c,/flex-|-self/,"")+c;case 4675:return a+c+e+"flex-line-pack"+j(c,/align-content|flex-|-self/,"")+c;case 5548:return a+c+e+j(c,"shrink","negative")+c;case 5292:return a+c+e+j(c,"basis","preferred-size")+c;case 6060:return a+"box-"+j(c,"-grow","")+a+c+e+j(c,"grow","positive")+c;case 4554:return a+j(c,/([^-])(transform)/g,"$1"+a+"$2")+c;case 6187:return j(j(j(c,/(zoom-|grab)/,a+"$1"),/(image-set)/,a+"$1"),c,"")+c;case 5495:case 3959:return j(c,/(image-set\([^]*)/,a+"$1"+"$`$1");case 4968:return j(j(c,/(.+:)(flex-)?(.*)/,a+"box-pack:$3"+e+"flex-pack:$3"),/s.+-b[^;]+/,"justify")+a+c+c;case 4095:case 3583:case 4068:case 2532:return j(c,/(.+)-inline(.+)/,a+"$1$2")+c;case 8116:case 7059:case 5753:case 5535:case 5445:case 5701:case 4933:case 4677:case 5533:case 5789:case 5021:case 4765:if(O(c)-1-n>6)switch(z(c,n+1)){case 109:if(z(c,n+4)!==45)break;case 102:return j(c,/(.+:)(.+)-([^]+)/,"$1"+a+"$2-$3"+"$1"+r+(z(c,n+3)==108?"$3":"$2-$3"))+c;case 115:return ~C(c,"stretch")?ie(j(c,"stretch","fill-available"),n)+c:c}break;case 4949:if(z(c,n+1)!==115)break;case 6444:switch(z(c,O(c)-3-(~C(c,"!important")&&10))){case 107:return j(c,":",":"+a)+c;case 101:return j(c,/(.+:)([^;!]+)(;|!.+)?/,"$1"+a+(z(c,14)===45?"inline-":"")+"box$3"+"$1"+a+"$2$3"+"$1"+e+"$2box$3")+c}break;case 5936:switch(z(c,n+11)){case 114:return a+c+e+j(c,/[svh]\w+-[tblr]{2}/,"tb")+c;case 108:return a+c+e+j(c,/[svh]\w+-[tblr]{2}/,"tb-rl")+c;case 45:return a+c+e+j(c,/[svh]\w+-[tblr]{2}/,"lr")+c}return a+c+e+c+c}return c}function fe(e,r){var a="";var c=M(e);for(var n=0;n<c;n++)a+=r(e[n],n,e,r)||"";return a}function oe(e,r,a,s){switch(e.type){case i:case t:return e.return=e.return||e.value;case c:return "";case p:return e.return=e.value+"{"+fe(e.children,s)+"}";case n:e.value=e.props.join(",");}return O(a=fe(e.children,s))?e.return=e.value+"{"+a+"}":""}function le(e){var r=M(e);return function(a,c,n,t){var s="";for(var u=0;u<r;u++)s+=e[u](a,c,n,t)||"";return s}}function he(c,s,u,i){if(c.length>-1)if(!c.return)switch(c.type){case t:c.return=ie(c.value,c.length);break;case p:return fe([J(c,{value:j(c.value,"@","@"+a)})],i);case n:if(c.length)return q(c.props,(function(n){switch(y(n,/(::plac\w+|:read-\w+)/)){case":read-only":case":read-write":return fe([J(c,{props:[j(n,/:(read-\w+)/,":"+r+"$1")]})],i);case"::placeholder":return fe([J(c,{props:[j(n,/:(plac\w+)/,":"+a+"input-$1")]}),J(c,{props:[j(n,/:(plac\w+)/,":"+r+"$1")]}),J(c,{props:[j(n,/:(plac\w+)/,e+"input-$1")]})],i)}return ""}))}}

  var weakMemoize = function weakMemoize(func) {
    // $FlowFixMe flow doesn't include all non-primitive types as allowed for weakmaps
    var cache = new WeakMap();
    return function (arg) {
      if (cache.has(arg)) {
        // $FlowFixMe
        return cache.get(arg);
      }

      var ret = func(arg);
      cache.set(arg, ret);
      return ret;
    };
  };

  var last = function last(arr) {
    return arr.length ? arr[arr.length - 1] : null;
  }; // based on https://github.com/thysultan/stylis.js/blob/e6843c373ebcbbfade25ebcc23f540ed8508da0a/src/Tokenizer.js#L239-L244


  var identifierWithPointTracking = function identifierWithPointTracking(begin, points, index) {
    var previous = 0;
    var character = 0;

    while (true) {
      previous = character;
      character = P(); // &\f

      if (previous === 38 && character === 12) {
        points[index] = 1;
      }

      if (T(character)) {
        break;
      }

      N();
    }

    return R(begin, F);
  };

  var toRules = function toRules(parsed, points) {
    // pretend we've started with a comma
    var index = -1;
    var character = 44;

    do {
      switch (T(character)) {
        case 0:
          // &\f
          if (character === 38 && P() === 12) {
            // this is not 100% correct, we don't account for literal sequences here - like for example quoted strings
            // stylis inserts \f after & to know when & where it should replace this sequence with the context selector
            // and when it should just concatenate the outer and inner selectors
            // it's very unlikely for this sequence to actually appear in a different context, so we just leverage this fact here
            points[index] = 1;
          }

          parsed[index] += identifierWithPointTracking(F - 1, points, index);
          break;

        case 2:
          parsed[index] += W(character);
          break;

        case 4:
          // comma
          if (character === 44) {
            // colon
            parsed[++index] = P() === 58 ? '&\f' : '';
            points[index] = parsed[index].length;
            break;
          }

        // fallthrough

        default:
          parsed[index] += d(character);
      }
    } while (character = N());

    return parsed;
  };

  var getRules = function getRules(value, points) {
    return V(toRules(U(value), points));
  }; // WeakSet would be more appropriate, but only WeakMap is supported in IE11


  var fixedElements = /* #__PURE__ */new WeakMap();
  var compat = function compat(element) {
    if (element.type !== 'rule' || !element.parent || // positive .length indicates that this rule contains pseudo
    // negative .length indicates that this rule has been already prefixed
    element.length < 1) {
      return;
    }

    var value = element.value,
        parent = element.parent;
    var isImplicitRule = element.column === parent.column && element.line === parent.line;

    while (parent.type !== 'rule') {
      parent = parent.parent;
      if (!parent) return;
    } // short-circuit for the simplest case


    if (element.props.length === 1 && value.charCodeAt(0) !== 58
    /* colon */
    && !fixedElements.get(parent)) {
      return;
    } // if this is an implicitly inserted rule (the one eagerly inserted at the each new nested level)
    // then the props has already been manipulated beforehand as they that array is shared between it and its "rule parent"


    if (isImplicitRule) {
      return;
    }

    fixedElements.set(element, true);
    var points = [];
    var rules = getRules(value, points);
    var parentRules = parent.props;

    for (var i = 0, k = 0; i < rules.length; i++) {
      for (var j = 0; j < parentRules.length; j++, k++) {
        element.props[k] = points[i] ? rules[i].replace(/&\f/g, parentRules[j]) : parentRules[j] + " " + rules[i];
      }
    }
  };
  var removeLabel = function removeLabel(element) {
    if (element.type === 'decl') {
      var value = element.value;

      if ( // charcode for l
      value.charCodeAt(0) === 108 && // charcode for b
      value.charCodeAt(2) === 98) {
        // this ignores label
        element["return"] = '';
        element.value = '';
      }
    }
  };
  var ignoreFlag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';

  var isIgnoringComment = function isIgnoringComment(element) {
    return !!element && element.type === 'comm' && element.children.indexOf(ignoreFlag) > -1;
  };

  var createUnsafeSelectorsAlarm = function createUnsafeSelectorsAlarm(cache) {
    return function (element, index, children) {
      if (element.type !== 'rule') return;
      var unsafePseudoClasses = element.value.match(/(:first|:nth|:nth-last)-child/g);

      if (unsafePseudoClasses && cache.compat !== true) {
        var prevElement = index > 0 ? children[index - 1] : null;

        if (prevElement && isIgnoringComment(last(prevElement.children))) {
          return;
        }

        unsafePseudoClasses.forEach(function (unsafePseudoClass) {
          console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
        });
      }
    };
  };

  var isImportRule = function isImportRule(element) {
    return element.type.charCodeAt(1) === 105 && element.type.charCodeAt(0) === 64;
  };

  var isPrependedWithRegularRules = function isPrependedWithRegularRules(index, children) {
    for (var i = index - 1; i >= 0; i--) {
      if (!isImportRule(children[i])) {
        return true;
      }
    }

    return false;
  }; // use this to remove incorrect elements from further processing
  // so they don't get handed to the `sheet` (or anything else)
  // as that could potentially lead to additional logs which in turn could be overhelming to the user


  var nullifyElement = function nullifyElement(element) {
    element.type = '';
    element.value = '';
    element["return"] = '';
    element.children = '';
    element.props = '';
  };

  var incorrectImportAlarm = function incorrectImportAlarm(element, index, children) {
    if (!isImportRule(element)) {
      return;
    }

    if (element.parent) {
      console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles.");
      nullifyElement(element);
    } else if (isPrependedWithRegularRules(index, children)) {
      console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules.");
      nullifyElement(element);
    }
  };

  var isBrowser$5 = typeof document !== 'undefined';
  var getServerStylisCache = isBrowser$5 ? undefined : weakMemoize(function () {
    return memoize$1(function () {
      var cache = {};
      return function (name) {
        return cache[name];
      };
    });
  });
  var defaultStylisPlugins = [he];

  var createCache = function createCache(options) {
    var key = options.key;

    if (!key) {
      throw new Error("You have to configure `key` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.\n" + "If multiple caches share the same key they might \"fight\" for each other's style elements.");
    }

    if (isBrowser$5 && key === 'css') {
      var ssrStyles = document.querySelectorAll("style[data-emotion]:not([data-s])"); // get SSRed styles out of the way of React's hydration
      // document.head is a safe place to move them to(though note document.head is not necessarily the last place they will be)
      // note this very very intentionally targets all style elements regardless of the key to ensure
      // that creating a cache works inside of render of a React component

      Array.prototype.forEach.call(ssrStyles, function (node) {
        // we want to only move elements which have a space in the data-emotion attribute value
        // because that indicates that it is an Emotion 11 server-side rendered style elements
        // while we will already ignore Emotion 11 client-side inserted styles because of the :not([data-s]) part in the selector
        // Emotion 10 client-side inserted styles did not have data-s (but importantly did not have a space in their data-emotion attributes)
        // so checking for the space ensures that loading Emotion 11 after Emotion 10 has inserted some styles
        // will not result in the Emotion 10 styles being destroyed
        var dataEmotionAttribute = node.getAttribute('data-emotion');

        if (dataEmotionAttribute.indexOf(' ') === -1) {
          return;
        }
        document.head.appendChild(node);
        node.setAttribute('data-s', '');
      });
    }

    var stylisPlugins = options.stylisPlugins || defaultStylisPlugins;

    {
      // $FlowFixMe
      if (/[^a-z-]/.test(key)) {
        throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
      }
    }

    var inserted = {}; // $FlowFixMe

    var container;
    var nodesToHydrate = [];

    if (isBrowser$5) {
      container = options.container || document.head;
      Array.prototype.forEach.call( // this means we will ignore elements which don't have a space in them which
      // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
      document.querySelectorAll("style[data-emotion^=\"" + key + " \"]"), function (node) {
        var attrib = node.getAttribute("data-emotion").split(' '); // $FlowFixMe

        for (var i = 1; i < attrib.length; i++) {
          inserted[attrib[i]] = true;
        }

        nodesToHydrate.push(node);
      });
    }

    var _insert;

    var omnipresentPlugins = [compat, removeLabel];

    {
      omnipresentPlugins.push(createUnsafeSelectorsAlarm({
        get compat() {
          return cache.compat;
        }

      }), incorrectImportAlarm);
    }

    if (isBrowser$5) {
      var currentSheet;
      var finalizingPlugins = [oe, function (element) {
        if (!element.root) {
          if (element["return"]) {
            currentSheet.insert(element["return"]);
          } else if (element.value && element.type !== c) {
            // insert empty rule in non-production environments
            // so @emotion/jest can grab `key` from the (JS)DOM for caches without any rules inserted yet
            currentSheet.insert(element.value + "{}");
          }
        }
      } ];
      var serializer = le(omnipresentPlugins.concat(stylisPlugins, finalizingPlugins));

      var stylis = function stylis(styles) {
        return fe(ce(styles), serializer);
      };

      _insert = function insert(selector, serialized, sheet, shouldCache) {
        currentSheet = sheet;

        if (serialized.map !== undefined) {
          currentSheet = {
            insert: function insert(rule) {
              sheet.insert(rule + serialized.map);
            }
          };
        }

        stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);

        if (shouldCache) {
          cache.inserted[serialized.name] = true;
        }
      };
    } else {
      var _finalizingPlugins = [oe];

      var _serializer = le(omnipresentPlugins.concat(stylisPlugins, _finalizingPlugins));

      var _stylis = function _stylis(styles) {
        return fe(ce(styles), _serializer);
      }; // $FlowFixMe


      var serverStylisCache = getServerStylisCache(stylisPlugins)(key);

      var getRules = function getRules(selector, serialized) {
        var name = serialized.name;

        if (serverStylisCache[name] === undefined) {
          serverStylisCache[name] = _stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);
        }

        return serverStylisCache[name];
      };

      _insert = function _insert(selector, serialized, sheet, shouldCache) {
        var name = serialized.name;
        var rules = getRules(selector, serialized);

        if (cache.compat === undefined) {
          // in regular mode, we don't set the styles on the inserted cache
          // since we don't need to and that would be wasting memory
          // we return them so that they are rendered in a style tag
          if (shouldCache) {
            cache.inserted[name] = true;
          }

          if ( // using === development instead of !== production
          // because if people do ssr in tests, the source maps showing up would be annoying
          serialized.map !== undefined) {
            return rules + serialized.map;
          }

          return rules;
        } else {
          // in compat mode, we put the styles on the inserted cache so
          // that emotion-server can pull out the styles
          // except when we don't want to cache it which was in Global but now
          // is nowhere but we don't want to do a major right now
          // and just in case we're going to leave the case here
          // it's also not affecting client side bundle size
          // so it's really not a big deal
          if (shouldCache) {
            cache.inserted[name] = rules;
          } else {
            return rules;
          }
        }
      };
    }

    var cache = {
      key: key,
      sheet: new StyleSheet({
        key: key,
        container: container,
        nonce: options.nonce,
        speedy: options.speedy,
        prepend: options.prepend,
        insertionPoint: options.insertionPoint
      }),
      nonce: options.nonce,
      inserted: inserted,
      registered: {},
      insert: _insert
    };
    cache.sheet.hydrate(nodesToHydrate);
    return cache;
  };

  var createCache$1 = createCache;

  /** @license React v17.0.2
   * react-is.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  if("function"===typeof Symbol&&Symbol.for){var x=Symbol.for;x("react.element");x("react.portal");x("react.fragment");x("react.strict_mode");x("react.profiler");x("react.provider");x("react.context");x("react.forward_ref");x("react.suspense");x("react.suspense_list");x("react.memo");x("react.lazy");x("react.block");x("react.server.block");x("react.fundamental");x("react.debug_trace_mode");x("react.legacy_hidden");}

  var reactIs_development = createCommonjsModule(function (module, exports) {

  {
    (function() {

  // ATTENTION
  // When adding new symbols to this file,
  // Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
  // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
  // nor polyfill, then a plain number is used for performance.
  var REACT_ELEMENT_TYPE = 0xeac7;
  var REACT_PORTAL_TYPE = 0xeaca;
  var REACT_FRAGMENT_TYPE = 0xeacb;
  var REACT_STRICT_MODE_TYPE = 0xeacc;
  var REACT_PROFILER_TYPE = 0xead2;
  var REACT_PROVIDER_TYPE = 0xeacd;
  var REACT_CONTEXT_TYPE = 0xeace;
  var REACT_FORWARD_REF_TYPE = 0xead0;
  var REACT_SUSPENSE_TYPE = 0xead1;
  var REACT_SUSPENSE_LIST_TYPE = 0xead8;
  var REACT_MEMO_TYPE = 0xead3;
  var REACT_LAZY_TYPE = 0xead4;
  var REACT_BLOCK_TYPE = 0xead9;
  var REACT_SERVER_BLOCK_TYPE = 0xeada;
  var REACT_FUNDAMENTAL_TYPE = 0xead5;
  var REACT_DEBUG_TRACING_MODE_TYPE = 0xeae1;
  var REACT_LEGACY_HIDDEN_TYPE = 0xeae3;

  if (typeof Symbol === 'function' && Symbol.for) {
    var symbolFor = Symbol.for;
    REACT_ELEMENT_TYPE = symbolFor('react.element');
    REACT_PORTAL_TYPE = symbolFor('react.portal');
    REACT_FRAGMENT_TYPE = symbolFor('react.fragment');
    REACT_STRICT_MODE_TYPE = symbolFor('react.strict_mode');
    REACT_PROFILER_TYPE = symbolFor('react.profiler');
    REACT_PROVIDER_TYPE = symbolFor('react.provider');
    REACT_CONTEXT_TYPE = symbolFor('react.context');
    REACT_FORWARD_REF_TYPE = symbolFor('react.forward_ref');
    REACT_SUSPENSE_TYPE = symbolFor('react.suspense');
    REACT_SUSPENSE_LIST_TYPE = symbolFor('react.suspense_list');
    REACT_MEMO_TYPE = symbolFor('react.memo');
    REACT_LAZY_TYPE = symbolFor('react.lazy');
    REACT_BLOCK_TYPE = symbolFor('react.block');
    REACT_SERVER_BLOCK_TYPE = symbolFor('react.server.block');
    REACT_FUNDAMENTAL_TYPE = symbolFor('react.fundamental');
    symbolFor('react.scope');
    symbolFor('react.opaque.id');
    REACT_DEBUG_TRACING_MODE_TYPE = symbolFor('react.debug_trace_mode');
    symbolFor('react.offscreen');
    REACT_LEGACY_HIDDEN_TYPE = symbolFor('react.legacy_hidden');
  }

  // Filter certain DOM attributes (e.g. src, href) if their values are empty strings.

  var enableScopeAPI = false; // Experimental Create Event Handle API.

  function isValidElementType(type) {
    if (typeof type === 'string' || typeof type === 'function') {
      return true;
    } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


    if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || type === REACT_DEBUG_TRACING_MODE_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || type === REACT_LEGACY_HIDDEN_TYPE || enableScopeAPI ) {
      return true;
    }

    if (typeof type === 'object' && type !== null) {
      if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_BLOCK_TYPE || type[0] === REACT_SERVER_BLOCK_TYPE) {
        return true;
      }
    }

    return false;
  }

  function typeOf(object) {
    if (typeof object === 'object' && object !== null) {
      var $$typeof = object.$$typeof;

      switch ($$typeof) {
        case REACT_ELEMENT_TYPE:
          var type = object.type;

          switch (type) {
            case REACT_FRAGMENT_TYPE:
            case REACT_PROFILER_TYPE:
            case REACT_STRICT_MODE_TYPE:
            case REACT_SUSPENSE_TYPE:
            case REACT_SUSPENSE_LIST_TYPE:
              return type;

            default:
              var $$typeofType = type && type.$$typeof;

              switch ($$typeofType) {
                case REACT_CONTEXT_TYPE:
                case REACT_FORWARD_REF_TYPE:
                case REACT_LAZY_TYPE:
                case REACT_MEMO_TYPE:
                case REACT_PROVIDER_TYPE:
                  return $$typeofType;

                default:
                  return $$typeof;
              }

          }

        case REACT_PORTAL_TYPE:
          return $$typeof;
      }
    }

    return undefined;
  }
  var ContextConsumer = REACT_CONTEXT_TYPE;
  var ContextProvider = REACT_PROVIDER_TYPE;
  var Element = REACT_ELEMENT_TYPE;
  var ForwardRef = REACT_FORWARD_REF_TYPE;
  var Fragment = REACT_FRAGMENT_TYPE;
  var Lazy = REACT_LAZY_TYPE;
  var Memo = REACT_MEMO_TYPE;
  var Portal = REACT_PORTAL_TYPE;
  var Profiler = REACT_PROFILER_TYPE;
  var StrictMode = REACT_STRICT_MODE_TYPE;
  var Suspense = REACT_SUSPENSE_TYPE;
  var hasWarnedAboutDeprecatedIsAsyncMode = false;
  var hasWarnedAboutDeprecatedIsConcurrentMode = false; // AsyncMode should be deprecated

  function isAsyncMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsAsyncMode) {
        hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

        console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
      }
    }

    return false;
  }
  function isConcurrentMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsConcurrentMode) {
        hasWarnedAboutDeprecatedIsConcurrentMode = true; // Using console['warn'] to evade Babel and ESLint

        console['warn']('The ReactIs.isConcurrentMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
      }
    }

    return false;
  }
  function isContextConsumer(object) {
    return typeOf(object) === REACT_CONTEXT_TYPE;
  }
  function isContextProvider(object) {
    return typeOf(object) === REACT_PROVIDER_TYPE;
  }
  function isElement(object) {
    return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
  }
  function isForwardRef(object) {
    return typeOf(object) === REACT_FORWARD_REF_TYPE;
  }
  function isFragment(object) {
    return typeOf(object) === REACT_FRAGMENT_TYPE;
  }
  function isLazy(object) {
    return typeOf(object) === REACT_LAZY_TYPE;
  }
  function isMemo(object) {
    return typeOf(object) === REACT_MEMO_TYPE;
  }
  function isPortal(object) {
    return typeOf(object) === REACT_PORTAL_TYPE;
  }
  function isProfiler(object) {
    return typeOf(object) === REACT_PROFILER_TYPE;
  }
  function isStrictMode(object) {
    return typeOf(object) === REACT_STRICT_MODE_TYPE;
  }
  function isSuspense(object) {
    return typeOf(object) === REACT_SUSPENSE_TYPE;
  }

  exports.ContextConsumer = ContextConsumer;
  exports.ContextProvider = ContextProvider;
  exports.Element = Element;
  exports.ForwardRef = ForwardRef;
  exports.Fragment = Fragment;
  exports.Lazy = Lazy;
  exports.Memo = Memo;
  exports.Portal = Portal;
  exports.Profiler = Profiler;
  exports.StrictMode = StrictMode;
  exports.Suspense = Suspense;
  exports.isAsyncMode = isAsyncMode;
  exports.isConcurrentMode = isConcurrentMode;
  exports.isContextConsumer = isContextConsumer;
  exports.isContextProvider = isContextProvider;
  exports.isElement = isElement;
  exports.isForwardRef = isForwardRef;
  exports.isFragment = isFragment;
  exports.isLazy = isLazy;
  exports.isMemo = isMemo;
  exports.isPortal = isPortal;
  exports.isProfiler = isProfiler;
  exports.isStrictMode = isStrictMode;
  exports.isSuspense = isSuspense;
  exports.isValidElementType = isValidElementType;
  exports.typeOf = typeOf;
    })();
  }
  });
  reactIs_development.ContextConsumer;
  reactIs_development.ContextProvider;
  reactIs_development.Element;
  reactIs_development.ForwardRef;
  reactIs_development.Fragment;
  reactIs_development.Lazy;
  reactIs_development.Memo;
  reactIs_development.Portal;
  reactIs_development.Profiler;
  reactIs_development.StrictMode;
  reactIs_development.Suspense;
  reactIs_development.isAsyncMode;
  reactIs_development.isConcurrentMode;
  reactIs_development.isContextConsumer;
  reactIs_development.isContextProvider;
  reactIs_development.isElement;
  reactIs_development.isForwardRef;
  reactIs_development.isFragment;
  reactIs_development.isLazy;
  reactIs_development.isMemo;
  reactIs_development.isPortal;
  reactIs_development.isProfiler;
  reactIs_development.isStrictMode;
  reactIs_development.isSuspense;
  reactIs_development.isValidElementType;
  reactIs_development.typeOf;

  var reactIs = createCommonjsModule(function (module) {

  {
    module.exports = reactIs_development;
  }
  });
  var reactIs_1 = reactIs.ForwardRef;
  var reactIs_2 = reactIs.isFragment;
  reactIs.isLazy;
  reactIs.isMemo;
  var reactIs_5 = reactIs.Memo;
  reactIs.isValidElementType;

  var FORWARD_REF_STATICS = {
    '$$typeof': true,
    render: true,
    defaultProps: true,
    displayName: true,
    propTypes: true
  };
  var MEMO_STATICS = {
    '$$typeof': true,
    compare: true,
    defaultProps: true,
    displayName: true,
    propTypes: true,
    type: true
  };
  var TYPE_STATICS = {};
  TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;
  TYPE_STATICS[reactIs.Memo] = MEMO_STATICS;

  var isBrowser$4 = typeof document !== 'undefined';
  function getRegisteredStyles(registered, registeredStyles, classNames) {
    var rawClassName = '';
    classNames.split(' ').forEach(function (className) {
      if (registered[className] !== undefined) {
        registeredStyles.push(registered[className] + ";");
      } else {
        rawClassName += className + " ";
      }
    });
    return rawClassName;
  }
  var registerStyles = function registerStyles(cache, serialized, isStringTag) {
    var className = cache.key + "-" + serialized.name;

    if ( // we only need to add the styles to the registered cache if the
    // class name could be used further down
    // the tree but if it's a string tag, we know it won't
    // so we don't have to add it to registered cache.
    // this improves memory usage since we can avoid storing the whole style string
    (isStringTag === false || // we need to always store it if we're in compat mode and
    // in node since emotion-server relies on whether a style is in
    // the registered cache to know whether a style is global or not
    // also, note that this check will be dead code eliminated in the browser
    isBrowser$4 === false && cache.compat !== undefined) && cache.registered[className] === undefined) {
      cache.registered[className] = serialized.styles;
    }
  };
  var insertStyles = function insertStyles(cache, serialized, isStringTag) {
    registerStyles(cache, serialized, isStringTag);
    var className = cache.key + "-" + serialized.name;

    if (cache.inserted[serialized.name] === undefined) {
      var stylesForSSR = '';
      var current = serialized;

      do {
        var maybeStyles = cache.insert(serialized === current ? "." + className : '', current, cache.sheet, true);

        if (!isBrowser$4 && maybeStyles !== undefined) {
          stylesForSSR += maybeStyles;
        }

        current = current.next;
      } while (current !== undefined);

      if (!isBrowser$4 && stylesForSSR.length !== 0) {
        return stylesForSSR;
      }
    }
  };

  /* eslint-disable */
  // Inspired by https://github.com/garycourt/murmurhash-js
  // Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
  function murmur2(str) {
    // 'm' and 'r' are mixing constants generated offline.
    // They're not really 'magic', they just happen to work well.
    // const m = 0x5bd1e995;
    // const r = 24;
    // Initialize the hash
    var h = 0; // Mix 4 bytes at a time into the hash

    var k,
        i = 0,
        len = str.length;

    for (; len >= 4; ++i, len -= 4) {
      k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
      k =
      /* Math.imul(k, m): */
      (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
      k ^=
      /* k >>> r: */
      k >>> 24;
      h =
      /* Math.imul(k, m): */
      (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
    } // Handle the last few bytes of the input array


    switch (len) {
      case 3:
        h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

      case 2:
        h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

      case 1:
        h ^= str.charCodeAt(i) & 0xff;
        h =
        /* Math.imul(h, m): */
        (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
    } // Do a few final mixes of the hash to ensure the last few
    // bytes are well-incorporated.


    h ^= h >>> 13;
    h =
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
    return ((h ^ h >>> 15) >>> 0).toString(36);
  }

  var unitlessKeys = {
    animationIterationCount: 1,
    borderImageOutset: 1,
    borderImageSlice: 1,
    borderImageWidth: 1,
    boxFlex: 1,
    boxFlexGroup: 1,
    boxOrdinalGroup: 1,
    columnCount: 1,
    columns: 1,
    flex: 1,
    flexGrow: 1,
    flexPositive: 1,
    flexShrink: 1,
    flexNegative: 1,
    flexOrder: 1,
    gridRow: 1,
    gridRowEnd: 1,
    gridRowSpan: 1,
    gridRowStart: 1,
    gridColumn: 1,
    gridColumnEnd: 1,
    gridColumnSpan: 1,
    gridColumnStart: 1,
    msGridRow: 1,
    msGridRowSpan: 1,
    msGridColumn: 1,
    msGridColumnSpan: 1,
    fontWeight: 1,
    lineHeight: 1,
    opacity: 1,
    order: 1,
    orphans: 1,
    tabSize: 1,
    widows: 1,
    zIndex: 1,
    zoom: 1,
    WebkitLineClamp: 1,
    // SVG-related properties
    fillOpacity: 1,
    floodOpacity: 1,
    stopOpacity: 1,
    strokeDasharray: 1,
    strokeDashoffset: 1,
    strokeMiterlimit: 1,
    strokeOpacity: 1,
    strokeWidth: 1
  };

  var ILLEGAL_ESCAPE_SEQUENCE_ERROR$1 = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
  var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
  var hyphenateRegex = /[A-Z]|^ms/g;
  var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

  var isCustomProperty = function isCustomProperty(property) {
    return property.charCodeAt(1) === 45;
  };

  var isProcessableValue = function isProcessableValue(value) {
    return value != null && typeof value !== 'boolean';
  };

  var processStyleName = /* #__PURE__ */memoize$1(function (styleName) {
    return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
  });

  var processStyleValue = function processStyleValue(key, value) {
    switch (key) {
      case 'animation':
      case 'animationName':
        {
          if (typeof value === 'string') {
            return value.replace(animationRegex, function (match, p1, p2) {
              cursor = {
                name: p1,
                styles: p2,
                next: cursor
              };
              return p1;
            });
          }
        }
    }

    if (unitlessKeys[key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
      return value + 'px';
    }

    return value;
  };

  {
    var contentValuePattern = /(var|attr|counters?|url|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/;
    var contentValues = ['normal', 'none', 'initial', 'inherit', 'unset'];
    var oldProcessStyleValue = processStyleValue;
    var msPattern = /^-ms-/;
    var hyphenPattern = /-(.)/g;
    var hyphenatedCache = {};

    processStyleValue = function processStyleValue(key, value) {
      if (key === 'content') {
        if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
          throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
        }
      }

      var processed = oldProcessStyleValue(key, value);

      if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
        hyphenatedCache[key] = true;
        console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
          return _char.toUpperCase();
        }) + "?");
      }

      return processed;
    };
  }

  function handleInterpolation(mergedProps, registered, interpolation) {
    if (interpolation == null) {
      return '';
    }

    if (interpolation.__emotion_styles !== undefined) {
      if (interpolation.toString() === 'NO_COMPONENT_SELECTOR') {
        throw new Error('Component selectors can only be used in conjunction with @emotion/babel-plugin.');
      }

      return interpolation;
    }

    switch (typeof interpolation) {
      case 'boolean':
        {
          return '';
        }

      case 'object':
        {
          if (interpolation.anim === 1) {
            cursor = {
              name: interpolation.name,
              styles: interpolation.styles,
              next: cursor
            };
            return interpolation.name;
          }

          if (interpolation.styles !== undefined) {
            var next = interpolation.next;

            if (next !== undefined) {
              // not the most efficient thing ever but this is a pretty rare case
              // and there will be very few iterations of this generally
              while (next !== undefined) {
                cursor = {
                  name: next.name,
                  styles: next.styles,
                  next: cursor
                };
                next = next.next;
              }
            }

            var styles = interpolation.styles + ";";

            if (interpolation.map !== undefined) {
              styles += interpolation.map;
            }

            return styles;
          }

          return createStringFromObject(mergedProps, registered, interpolation);
        }

      case 'function':
        {
          if (mergedProps !== undefined) {
            var previousCursor = cursor;
            var result = interpolation(mergedProps);
            cursor = previousCursor;
            return handleInterpolation(mergedProps, registered, result);
          } else {
            console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
          }

          break;
        }

      case 'string':
        {
          var matched = [];
          var replaced = interpolation.replace(animationRegex, function (match, p1, p2) {
            var fakeVarName = "animation" + matched.length;
            matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
            return "${" + fakeVarName + "}";
          });

          if (matched.length) {
            console.error('`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\n' + 'Instead of doing this:\n\n' + [].concat(matched, ["`" + replaced + "`"]).join('\n') + '\n\nYou should wrap it with `css` like this:\n\n' + ("css`" + replaced + "`"));
          }
        }

        break;
    } // finalize string values (regular strings and functions interpolated into css calls)


    if (registered == null) {
      return interpolation;
    }

    var cached = registered[interpolation];
    return cached !== undefined ? cached : interpolation;
  }

  function createStringFromObject(mergedProps, registered, obj) {
    var string = '';

    if (Array.isArray(obj)) {
      for (var i = 0; i < obj.length; i++) {
        string += handleInterpolation(mergedProps, registered, obj[i]) + ";";
      }
    } else {
      for (var _key in obj) {
        var value = obj[_key];

        if (typeof value !== 'object') {
          if (registered != null && registered[value] !== undefined) {
            string += _key + "{" + registered[value] + "}";
          } else if (isProcessableValue(value)) {
            string += processStyleName(_key) + ":" + processStyleValue(_key, value) + ";";
          }
        } else {
          if (_key === 'NO_COMPONENT_SELECTOR' && "development" !== 'production') {
            throw new Error('Component selectors can only be used in conjunction with @emotion/babel-plugin.');
          }

          if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
            for (var _i = 0; _i < value.length; _i++) {
              if (isProcessableValue(value[_i])) {
                string += processStyleName(_key) + ":" + processStyleValue(_key, value[_i]) + ";";
              }
            }
          } else {
            var interpolated = handleInterpolation(mergedProps, registered, value);

            switch (_key) {
              case 'animation':
              case 'animationName':
                {
                  string += processStyleName(_key) + ":" + interpolated + ";";
                  break;
                }

              default:
                {
                  if (_key === 'undefined') {
                    console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                  }

                  string += _key + "{" + interpolated + "}";
                }
            }
          }
        }
      }
    }

    return string;
  }

  var labelPattern = /label:\s*([^\s;\n{]+)\s*(;|$)/g;
  var sourceMapPattern;

  {
    sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;
  } // this is the cursor for keyframes
  // keyframes are stored on the SerializedStyles object as a linked list


  var cursor;
  var serializeStyles = function serializeStyles(args, registered, mergedProps) {
    if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
      return args[0];
    }

    var stringMode = true;
    var styles = '';
    cursor = undefined;
    var strings = args[0];

    if (strings == null || strings.raw === undefined) {
      stringMode = false;
      styles += handleInterpolation(mergedProps, registered, strings);
    } else {
      if (strings[0] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR$1);
      }

      styles += strings[0];
    } // we start at 1 since we've already handled the first arg


    for (var i = 1; i < args.length; i++) {
      styles += handleInterpolation(mergedProps, registered, args[i]);

      if (stringMode) {
        if (strings[i] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR$1);
        }

        styles += strings[i];
      }
    }

    var sourceMap;

    {
      styles = styles.replace(sourceMapPattern, function (match) {
        sourceMap = match;
        return '';
      });
    } // using a global regex with .exec is stateful so lastIndex has to be reset each time


    labelPattern.lastIndex = 0;
    var identifierName = '';
    var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

    while ((match = labelPattern.exec(styles)) !== null) {
      identifierName += '-' + // $FlowFixMe we know it's not null
      match[1];
    }

    var name = murmur2(styles) + identifierName;

    {
      // $FlowFixMe SerializedStyles type doesn't have toString property (and we don't want to add it)
      return {
        name: name,
        styles: styles,
        map: sourceMap,
        next: cursor,
        toString: function toString() {
          return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
        }
      };
    }
  };

  var isBrowser$3 = typeof document !== 'undefined';
  var hasOwnProperty$1 = {}.hasOwnProperty;

  var EmotionCacheContext = /* #__PURE__ */React.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
  // because this module is primarily intended for the browser and node
  // but it's also required in react native and similar environments sometimes
  // and we could have a special build just for that
  // but this is much easier and the native packages
  // might use a different theme context in the future anyway
  typeof HTMLElement !== 'undefined' ? /* #__PURE__ */createCache$1({
    key: 'css'
  }) : null);

  {
    EmotionCacheContext.displayName = 'EmotionCacheContext';
  }

  var CacheProvider = EmotionCacheContext.Provider;

  var withEmotionCache = function withEmotionCache(func) {
    // $FlowFixMe
    return /*#__PURE__*/React.forwardRef(function (props, ref) {
      // the cache will never be null in the browser
      var cache = React.useContext(EmotionCacheContext);
      return func(props, cache, ref);
    });
  };

  if (!isBrowser$3) {
    withEmotionCache = function withEmotionCache(func) {
      return function (props) {
        var cache = React.useContext(EmotionCacheContext);

        if (cache === null) {
          // yes, we're potentially creating this on every render
          // it doesn't actually matter though since it's only on the server
          // so there will only every be a single render
          // that could change in the future because of suspense and etc. but for now,
          // this works and i don't want to optimise for a future thing that we aren't sure about
          cache = createCache$1({
            key: 'css'
          });
          return /*#__PURE__*/React.createElement(EmotionCacheContext.Provider, {
            value: cache
          }, func(props, cache));
        } else {
          return func(props, cache);
        }
      };
    };
  }

  var ThemeContext$2 = /* #__PURE__ */React.createContext({});

  {
    ThemeContext$2.displayName = 'EmotionThemeContext';
  }

  var isBrowser$1$1 = typeof document !== 'undefined';
  var useInsertionEffect$2 = React__namespace['useInsertion' + 'Effect'] ? React__namespace['useInsertion' + 'Effect'] : function useInsertionEffect(create) {
    create();
  };
  function useInsertionEffectMaybe$1(create) {
    if (!isBrowser$1$1) {
      return create();
    }

    useInsertionEffect$2(create);
  }

  var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
  var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';

  var Insertion$2 = function Insertion(_ref) {
    var cache = _ref.cache,
        serialized = _ref.serialized,
        isStringTag = _ref.isStringTag;
    registerStyles(cache, serialized, isStringTag);
    var rules = useInsertionEffectMaybe$1(function () {
      return insertStyles(cache, serialized, isStringTag);
    });

    if (!isBrowser$3 && rules !== undefined) {
      var _ref2;

      var serializedNames = serialized.name;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        next = next.next;
      }

      return /*#__PURE__*/React.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedNames, _ref2.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref2.nonce = cache.sheet.nonce, _ref2));
    }

    return null;
  };

  var Emotion = /* #__PURE__ */withEmotionCache(function (props, cache, ref) {
    var cssProp = props.css; // so that using `css` from `emotion` and passing the result to the css prop works
    // not passing the registered cache to serializeStyles because it would
    // make certain babel optimisations not possible

    if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
      cssProp = cache.registered[cssProp];
    }

    var WrappedComponent = props[typePropName];
    var registeredStyles = [cssProp];
    var className = '';

    if (typeof props.className === 'string') {
      className = getRegisteredStyles(cache.registered, registeredStyles, props.className);
    } else if (props.className != null) {
      className = props.className + " ";
    }

    var serialized = serializeStyles(registeredStyles, undefined, React.useContext(ThemeContext$2));

    if (serialized.name.indexOf('-') === -1) {
      var labelFromStack = props[labelPropName];

      if (labelFromStack) {
        serialized = serializeStyles([serialized, 'label:' + labelFromStack + ';']);
      }
    }

    className += cache.key + "-" + serialized.name;
    var newProps = {};

    for (var key in props) {
      if (hasOwnProperty$1.call(props, key) && key !== 'css' && key !== typePropName && (key !== labelPropName)) {
        newProps[key] = props[key];
      }
    }

    newProps.ref = ref;
    newProps.className = className;
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Insertion$2, {
      cache: cache,
      serialized: serialized,
      isStringTag: typeof WrappedComponent === 'string'
    }), /*#__PURE__*/React.createElement(WrappedComponent, newProps));
  });

  {
    Emotion.displayName = 'EmotionCssPropInternal';
  }

  var pkg = {
  	name: "@emotion/react",
  	version: "11.9.0",
  	main: "dist/emotion-react.cjs.js",
  	module: "dist/emotion-react.esm.js",
  	browser: {
  		"./dist/emotion-react.cjs.js": "./dist/emotion-react.browser.cjs.js",
  		"./dist/emotion-react.esm.js": "./dist/emotion-react.browser.esm.js"
  	},
  	types: "types/index.d.ts",
  	files: [
  		"src",
  		"dist",
  		"jsx-runtime",
  		"jsx-dev-runtime",
  		"_isolated-hnrs",
  		"types/*.d.ts",
  		"macro.js",
  		"macro.d.ts",
  		"macro.js.flow"
  	],
  	sideEffects: false,
  	author: "Emotion Contributors",
  	license: "MIT",
  	scripts: {
  		"test:typescript": "dtslint types"
  	},
  	dependencies: {
  		"@babel/runtime": "^7.13.10",
  		"@emotion/babel-plugin": "^11.7.1",
  		"@emotion/cache": "^11.7.1",
  		"@emotion/serialize": "^1.0.3",
  		"@emotion/utils": "^1.1.0",
  		"@emotion/weak-memoize": "^0.2.5",
  		"hoist-non-react-statics": "^3.3.1"
  	},
  	peerDependencies: {
  		"@babel/core": "^7.0.0",
  		react: ">=16.8.0"
  	},
  	peerDependenciesMeta: {
  		"@babel/core": {
  			optional: true
  		},
  		"@types/react": {
  			optional: true
  		}
  	},
  	devDependencies: {
  		"@babel/core": "^7.13.10",
  		"@emotion/css": "11.9.0",
  		"@emotion/css-prettifier": "1.0.1",
  		"@emotion/server": "11.4.0",
  		"@emotion/styled": "11.8.1",
  		"@types/react": "^16.9.11",
  		dtslint: "^4.2.1",
  		"html-tag-names": "^1.1.2",
  		react: "16.14.0",
  		"svg-tag-names": "^1.1.1",
  		typescript: "^4.5.5"
  	},
  	repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
  	publishConfig: {
  		access: "public"
  	},
  	"umd:main": "dist/emotion-react.umd.min.js",
  	preconstruct: {
  		entrypoints: [
  			"./index.js",
  			"./jsx-runtime.js",
  			"./jsx-dev-runtime.js",
  			"./_isolated-hnrs.js"
  		],
  		umdName: "emotionReact"
  	}
  };

  var useInsertionEffect$1 = React__namespace['useInsertion' + 'Effect'] ? React__namespace['useInsertion' + 'Effect'] : React.useLayoutEffect;
  var warnedAboutCssPropForGlobal = false; // maintain place over rerenders.
  // initial render from browser, insertBefore context.sheet.tags[0] or if a style hasn't been inserted there yet, appendChild
  // initial client-side render from SSR, use place of hydrating tag

  var Global = /* #__PURE__ */withEmotionCache(function (props, cache) {
    if (!warnedAboutCssPropForGlobal && ( // check for className as well since the user is
    // probably using the custom createElement which
    // means it will be turned into a className prop
    // $FlowFixMe I don't really want to add it to the type since it shouldn't be used
    props.className || props.css)) {
      console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?");
      warnedAboutCssPropForGlobal = true;
    }

    var styles = props.styles;
    var serialized = serializeStyles([styles], undefined, React.useContext(ThemeContext$2));

    if (!isBrowser$3) {
      var _ref;

      var serializedNames = serialized.name;
      var serializedStyles = serialized.styles;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        serializedStyles += next.styles;
        next = next.next;
      }

      var shouldCache = cache.compat === true;
      var rules = cache.insert("", {
        name: serializedNames,
        styles: serializedStyles
      }, cache.sheet, shouldCache);

      if (shouldCache) {
        return null;
      }

      return /*#__PURE__*/React.createElement("style", (_ref = {}, _ref["data-emotion"] = cache.key + "-global " + serializedNames, _ref.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref.nonce = cache.sheet.nonce, _ref));
    } // yes, i know these hooks are used conditionally
    // but it is based on a constant that will never change at runtime
    // it's effectively like having two implementations and switching them out
    // so it's not actually breaking anything


    var sheetRef = React.useRef();
    useInsertionEffect$1(function () {
      var key = cache.key + "-global"; // use case of https://github.com/emotion-js/emotion/issues/2675

      var sheet = new cache.sheet.constructor({
        key: key,
        nonce: cache.sheet.nonce,
        container: cache.sheet.container,
        speedy: cache.sheet.isSpeedy
      });
      var rehydrating = false; // $FlowFixMe

      var node = document.querySelector("style[data-emotion=\"" + key + " " + serialized.name + "\"]");

      if (cache.sheet.tags.length) {
        sheet.before = cache.sheet.tags[0];
      }

      if (node !== null) {
        rehydrating = true; // clear the hash so this node won't be recognizable as rehydratable by other <Global/>s

        node.setAttribute('data-emotion', key);
        sheet.hydrate([node]);
      }

      sheetRef.current = [sheet, rehydrating];
      return function () {
        sheet.flush();
      };
    }, [cache]);
    useInsertionEffect$1(function () {
      var sheetRefCurrent = sheetRef.current;
      var sheet = sheetRefCurrent[0],
          rehydrating = sheetRefCurrent[1];

      if (rehydrating) {
        sheetRefCurrent[1] = false;
        return;
      }

      if (serialized.next !== undefined) {
        // insert keyframes
        insertStyles(cache, serialized.next, true);
      }

      if (sheet.tags.length) {
        // if this doesn't exist then it will be null so the style element will be appended
        var element = sheet.tags[sheet.tags.length - 1].nextElementSibling;
        sheet.before = element;
        sheet.flush();
      }

      cache.insert("", serialized, sheet, false);
    }, [cache, serialized.name]);
    return null;
  });

  {
    Global.displayName = 'EmotionGlobal';
  }

  function css() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return serializeStyles(args);
  }

  var keyframes = function keyframes() {
    var insertable = css.apply(void 0, arguments);
    var name = "animation-" + insertable.name; // $FlowFixMe

    return {
      name: name,
      styles: "@keyframes " + name + "{" + insertable.styles + "}",
      anim: 1,
      toString: function toString() {
        return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
      }
    };
  };

  var classnames = function classnames(args) {
    var len = args.length;
    var i = 0;
    var cls = '';

    for (; i < len; i++) {
      var arg = args[i];
      if (arg == null) continue;
      var toAdd = void 0;

      switch (typeof arg) {
        case 'boolean':
          break;

        case 'object':
          {
            if (Array.isArray(arg)) {
              toAdd = classnames(arg);
            } else {
              if (arg.styles !== undefined && arg.name !== undefined) {
                console.error('You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n' + '`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component.');
              }

              toAdd = '';

              for (var k in arg) {
                if (arg[k] && k) {
                  toAdd && (toAdd += ' ');
                  toAdd += k;
                }
              }
            }

            break;
          }

        default:
          {
            toAdd = arg;
          }
      }

      if (toAdd) {
        cls && (cls += ' ');
        cls += toAdd;
      }
    }

    return cls;
  };

  function merge$1(registered, css, className) {
    var registeredStyles = [];
    var rawClassName = getRegisteredStyles(registered, registeredStyles, className);

    if (registeredStyles.length < 2) {
      return className;
    }

    return rawClassName + css(registeredStyles);
  }

  var Insertion$1 = function Insertion(_ref) {
    var cache = _ref.cache,
        serializedArr = _ref.serializedArr;
    var rules = useInsertionEffectMaybe$1(function () {
      var rules = '';

      for (var i = 0; i < serializedArr.length; i++) {
        var res = insertStyles(cache, serializedArr[i], false);

        if (!isBrowser$3 && res !== undefined) {
          rules += res;
        }
      }

      if (!isBrowser$3) {
        return rules;
      }
    });

    if (!isBrowser$3 && rules.length !== 0) {
      var _ref2;

      return /*#__PURE__*/React.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedArr.map(function (serialized) {
        return serialized.name;
      }).join(' '), _ref2.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref2.nonce = cache.sheet.nonce, _ref2));
    }

    return null;
  };

  var ClassNames = /* #__PURE__ */withEmotionCache(function (props, cache) {
    var hasRendered = false;
    var serializedArr = [];

    var css = function css() {
      if (hasRendered && "development" !== 'production') {
        throw new Error('css can only be used during render');
      }

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var serialized = serializeStyles(args, cache.registered);
      serializedArr.push(serialized); // registration has to happen here as the result of this might get consumed by `cx`

      registerStyles(cache, serialized, false);
      return cache.key + "-" + serialized.name;
    };

    var cx = function cx() {
      if (hasRendered && "development" !== 'production') {
        throw new Error('cx can only be used during render');
      }

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return merge$1(cache.registered, css, classnames(args));
    };

    var content = {
      css: css,
      cx: cx,
      theme: React.useContext(ThemeContext$2)
    };
    var ele = props.children(content);
    hasRendered = true;
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Insertion$1, {
      cache: cache,
      serializedArr: serializedArr
    }), ele);
  });

  {
    ClassNames.displayName = 'EmotionClassNames';
  }

  {
    var isBrowser$2 = typeof document !== 'undefined'; // #1727 for some reason Jest evaluates modules twice if some consuming module gets mocked with jest.mock

    var isJest = typeof jest !== 'undefined';

    if (isBrowser$2 && !isJest) {
      // globalThis has wide browser support - https://caniuse.com/?search=globalThis, Node.js 12 and later
      var globalContext = // $FlowIgnore
      typeof globalThis !== 'undefined' ? globalThis // eslint-disable-line no-undef
      : isBrowser$2 ? window : global$1;
      var globalKey = "__EMOTION_REACT_" + pkg.version.split('.')[0] + "__";

      if (globalContext[globalKey]) {
        console.warn('You are loading @emotion/react when it is already loaded. Running ' + 'multiple instances may cause problems. This can happen if multiple ' + 'versions are used, or if multiple builds of the same version are ' + 'used.');
      }

      globalContext[globalKey] = true;
    }
  }

  var testOmitPropsOnStringTag = isPropValid;

  var testOmitPropsOnComponent = function testOmitPropsOnComponent(key) {
    return key !== 'theme';
  };

  var getDefaultShouldForwardProp = function getDefaultShouldForwardProp(tag) {
    return typeof tag === 'string' && // 96 is one less than the char code
    // for "a" so this is checking that
    // it's a lowercase character
    tag.charCodeAt(0) > 96 ? testOmitPropsOnStringTag : testOmitPropsOnComponent;
  };
  var composeShouldForwardProps = function composeShouldForwardProps(tag, options, isReal) {
    var shouldForwardProp;

    if (options) {
      var optionsShouldForwardProp = options.shouldForwardProp;
      shouldForwardProp = tag.__emotion_forwardProp && optionsShouldForwardProp ? function (propName) {
        return tag.__emotion_forwardProp(propName) && optionsShouldForwardProp(propName);
      } : optionsShouldForwardProp;
    }

    if (typeof shouldForwardProp !== 'function' && isReal) {
      shouldForwardProp = tag.__emotion_forwardProp;
    }

    return shouldForwardProp;
  };

  var isBrowser = typeof document !== 'undefined';
  var useInsertionEffect = React__namespace['useInsertion' + 'Effect'] ? React__namespace['useInsertion' + 'Effect'] : function useInsertionEffect(create) {
    create();
  };
  function useInsertionEffectMaybe(create) {
    if (!isBrowser) {
      return create();
    }

    useInsertionEffect(create);
  }

  var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
  var isBrowser$1 = typeof document !== 'undefined';

  var Insertion = function Insertion(_ref) {
    var cache = _ref.cache,
        serialized = _ref.serialized,
        isStringTag = _ref.isStringTag;
    registerStyles(cache, serialized, isStringTag);
    var rules = useInsertionEffectMaybe(function () {
      return insertStyles(cache, serialized, isStringTag);
    });

    if (!isBrowser$1 && rules !== undefined) {
      var _ref2;

      var serializedNames = serialized.name;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        next = next.next;
      }

      return /*#__PURE__*/React.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedNames, _ref2.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref2.nonce = cache.sheet.nonce, _ref2));
    }

    return null;
  };

  var createStyled$1 = function createStyled(tag, options) {
    {
      if (tag === undefined) {
        throw new Error('You are trying to create a styled element with an undefined component.\nYou may have forgotten to import it.');
      }
    }

    var isReal = tag.__emotion_real === tag;
    var baseTag = isReal && tag.__emotion_base || tag;
    var identifierName;
    var targetClassName;

    if (options !== undefined) {
      identifierName = options.label;
      targetClassName = options.target;
    }

    var shouldForwardProp = composeShouldForwardProps(tag, options, isReal);
    var defaultShouldForwardProp = shouldForwardProp || getDefaultShouldForwardProp(baseTag);
    var shouldUseAs = !defaultShouldForwardProp('as');
    return function () {
      var args = arguments;
      var styles = isReal && tag.__emotion_styles !== undefined ? tag.__emotion_styles.slice(0) : [];

      if (identifierName !== undefined) {
        styles.push("label:" + identifierName + ";");
      }

      if (args[0] == null || args[0].raw === undefined) {
        styles.push.apply(styles, args);
      } else {
        if (args[0][0] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
        }

        styles.push(args[0][0]);
        var len = args.length;
        var i = 1;

        for (; i < len; i++) {
          if (args[0][i] === undefined) {
            console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
          }

          styles.push(args[i], args[0][i]);
        }
      } // $FlowFixMe: we need to cast StatelessFunctionalComponent to our PrivateStyledComponent class


      var Styled = withEmotionCache(function (props, cache, ref) {
        var FinalTag = shouldUseAs && props.as || baseTag;
        var className = '';
        var classInterpolations = [];
        var mergedProps = props;

        if (props.theme == null) {
          mergedProps = {};

          for (var key in props) {
            mergedProps[key] = props[key];
          }

          mergedProps.theme = React.useContext(ThemeContext$2);
        }

        if (typeof props.className === 'string') {
          className = getRegisteredStyles(cache.registered, classInterpolations, props.className);
        } else if (props.className != null) {
          className = props.className + " ";
        }

        var serialized = serializeStyles(styles.concat(classInterpolations), cache.registered, mergedProps);
        className += cache.key + "-" + serialized.name;

        if (targetClassName !== undefined) {
          className += " " + targetClassName;
        }

        var finalShouldForwardProp = shouldUseAs && shouldForwardProp === undefined ? getDefaultShouldForwardProp(FinalTag) : defaultShouldForwardProp;
        var newProps = {};

        for (var _key in props) {
          if (shouldUseAs && _key === 'as') continue;

          if ( // $FlowFixMe
          finalShouldForwardProp(_key)) {
            newProps[_key] = props[_key];
          }
        }

        newProps.className = className;
        newProps.ref = ref;
        return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Insertion, {
          cache: cache,
          serialized: serialized,
          isStringTag: typeof FinalTag === 'string'
        }), /*#__PURE__*/React.createElement(FinalTag, newProps));
      });
      Styled.displayName = identifierName !== undefined ? identifierName : "Styled(" + (typeof baseTag === 'string' ? baseTag : baseTag.displayName || baseTag.name || 'Component') + ")";
      Styled.defaultProps = tag.defaultProps;
      Styled.__emotion_real = Styled;
      Styled.__emotion_base = baseTag;
      Styled.__emotion_styles = styles;
      Styled.__emotion_forwardProp = shouldForwardProp;
      Object.defineProperty(Styled, 'toString', {
        value: function value() {
          if (targetClassName === undefined && "development" !== 'production') {
            return 'NO_COMPONENT_SELECTOR';
          } // $FlowFixMe: coerce undefined to string


          return "." + targetClassName;
        }
      });

      Styled.withComponent = function (nextTag, nextOptions) {
        return createStyled(nextTag, _extends({}, options, nextOptions, {
          shouldForwardProp: composeShouldForwardProps(Styled, nextOptions, true)
        })).apply(void 0, styles);
      };

      return Styled;
    };
  };

  var tags = ['a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'big', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'cite', 'code', 'col', 'colgroup', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meta', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'section', 'select', 'small', 'source', 'span', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr', // SVG
  'circle', 'clipPath', 'defs', 'ellipse', 'foreignObject', 'g', 'image', 'line', 'linearGradient', 'mask', 'path', 'pattern', 'polygon', 'polyline', 'radialGradient', 'rect', 'stop', 'svg', 'text', 'tspan'];

  var newStyled = createStyled$1.bind();
  tags.forEach(function (tagName) {
    // $FlowFixMe: we can ignore this because its exposed type is defined by the CreateStyled type
    newStyled[tagName] = newStyled(tagName);
  });

  var emStyled = newStyled;

  /*
  object-assign
  (c) Sindre Sorhus
  @license MIT
  */
  /* eslint-disable no-unused-vars */
  var getOwnPropertySymbols = Object.getOwnPropertySymbols;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var propIsEnumerable = Object.prototype.propertyIsEnumerable;

  function toObject(val) {
  	if (val === null || val === undefined) {
  		throw new TypeError('Object.assign cannot be called with null or undefined');
  	}

  	return Object(val);
  }

  function shouldUseNative() {
  	try {
  		if (!Object.assign) {
  			return false;
  		}

  		// Detect buggy property enumeration order in older V8 versions.

  		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
  		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
  		test1[5] = 'de';
  		if (Object.getOwnPropertyNames(test1)[0] === '5') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test2 = {};
  		for (var i = 0; i < 10; i++) {
  			test2['_' + String.fromCharCode(i)] = i;
  		}
  		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
  			return test2[n];
  		});
  		if (order2.join('') !== '0123456789') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test3 = {};
  		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
  			test3[letter] = letter;
  		});
  		if (Object.keys(Object.assign({}, test3)).join('') !==
  				'abcdefghijklmnopqrst') {
  			return false;
  		}

  		return true;
  	} catch (err) {
  		// We don't expect any of the above to throw, but better to be safe.
  		return false;
  	}
  }

  var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
  	var from;
  	var to = toObject(target);
  	var symbols;

  	for (var s = 1; s < arguments.length; s++) {
  		from = Object(arguments[s]);

  		for (var key in from) {
  			if (hasOwnProperty.call(from, key)) {
  				to[key] = from[key];
  			}
  		}

  		if (getOwnPropertySymbols) {
  			symbols = getOwnPropertySymbols(from);
  			for (var i = 0; i < symbols.length; i++) {
  				if (propIsEnumerable.call(from, symbols[i])) {
  					to[symbols[i]] = from[symbols[i]];
  				}
  			}
  		}
  	}

  	return to;
  };

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var ReactPropTypesSecret$2 = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

  var ReactPropTypesSecret_1 = ReactPropTypesSecret$2;

  var has$2 = Function.call.bind(Object.prototype.hasOwnProperty);

  var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;

  var has$1 = has$2;

  var printWarning$1 = function() {};

  {
    var ReactPropTypesSecret = ReactPropTypesSecret$1;
    var loggedTypeFailures = {};
    var has = has$1;

    printWarning$1 = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) { /**/ }
    };
  }

  /**
   * Assert that the values match with the type specs.
   * Error messages are memorized and will only be shown once.
   *
   * @param {object} typeSpecs Map of name to a ReactPropType
   * @param {object} values Runtime values that need to be type-checked
   * @param {string} location e.g. "prop", "context", "child context"
   * @param {string} componentName Name of the component for error messages.
   * @param {?Function} getStack Returns the component stack.
   * @private
   */
  function checkPropTypes$1(typeSpecs, values, location, componentName, getStack) {
    {
      for (var typeSpecName in typeSpecs) {
        if (has(typeSpecs, typeSpecName)) {
          var error;
          // Prop type validation may throw. In case they do, we don't want to
          // fail the render phase where it didn't fail before. So we log it.
          // After these have been cleaned up, we'll let them throw.
          try {
            // This is intentionally an invariant that gets caught. It's the same
            // behavior as without this statement except with a better message.
            if (typeof typeSpecs[typeSpecName] !== 'function') {
              var err = Error(
                (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
                'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' +
                'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.'
              );
              err.name = 'Invariant Violation';
              throw err;
            }
            error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
          } catch (ex) {
            error = ex;
          }
          if (error && !(error instanceof Error)) {
            printWarning$1(
              (componentName || 'React class') + ': type specification of ' +
              location + ' `' + typeSpecName + '` is invalid; the type checker ' +
              'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
              'You may have forgotten to pass an argument to the type checker ' +
              'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
              'shape all require an argument).'
            );
          }
          if (error instanceof Error && !(error.message in loggedTypeFailures)) {
            // Only monitor this failure once because there tends to be a lot of the
            // same error.
            loggedTypeFailures[error.message] = true;

            var stack = getStack ? getStack() : '';

            printWarning$1(
              'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
            );
          }
        }
      }
    }
  }

  /**
   * Resets warning cache when testing.
   *
   * @private
   */
  checkPropTypes$1.resetWarningCache = function() {
    {
      loggedTypeFailures = {};
    }
  };

  var checkPropTypes_1 = checkPropTypes$1;

  var checkPropTypes = checkPropTypes_1;

  var printWarning = function() {};

  {
    printWarning = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };
  }

  function emptyFunctionThatReturnsNull() {
    return null;
  }

  var factoryWithTypeCheckers = function(isValidElement, throwOnDirectAccess) {
    /* global Symbol */
    var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
    var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

    /**
     * Returns the iterator method function contained on the iterable object.
     *
     * Be sure to invoke the function with the iterable as context:
     *
     *     var iteratorFn = getIteratorFn(myIterable);
     *     if (iteratorFn) {
     *       var iterator = iteratorFn.call(myIterable);
     *       ...
     *     }
     *
     * @param {?object} maybeIterable
     * @return {?function}
     */
    function getIteratorFn(maybeIterable) {
      var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
      if (typeof iteratorFn === 'function') {
        return iteratorFn;
      }
    }

    /**
     * Collection of methods that allow declaration and validation of props that are
     * supplied to React components. Example usage:
     *
     *   var Props = require('ReactPropTypes');
     *   var MyArticle = React.createClass({
     *     propTypes: {
     *       // An optional string prop named "description".
     *       description: Props.string,
     *
     *       // A required enum prop named "category".
     *       category: Props.oneOf(['News','Photos']).isRequired,
     *
     *       // A prop named "dialog" that requires an instance of Dialog.
     *       dialog: Props.instanceOf(Dialog).isRequired
     *     },
     *     render: function() { ... }
     *   });
     *
     * A more formal specification of how these methods are used:
     *
     *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
     *   decl := ReactPropTypes.{type}(.isRequired)?
     *
     * Each and every declaration produces a function with the same signature. This
     * allows the creation of custom validation functions. For example:
     *
     *  var MyLink = React.createClass({
     *    propTypes: {
     *      // An optional string or URI prop named "href".
     *      href: function(props, propName, componentName) {
     *        var propValue = props[propName];
     *        if (propValue != null && typeof propValue !== 'string' &&
     *            !(propValue instanceof URI)) {
     *          return new Error(
     *            'Expected a string or an URI for ' + propName + ' in ' +
     *            componentName
     *          );
     *        }
     *      }
     *    },
     *    render: function() {...}
     *  });
     *
     * @internal
     */

    var ANONYMOUS = '<<anonymous>>';

    // Important!
    // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
    var ReactPropTypes = {
      array: createPrimitiveTypeChecker('array'),
      bigint: createPrimitiveTypeChecker('bigint'),
      bool: createPrimitiveTypeChecker('boolean'),
      func: createPrimitiveTypeChecker('function'),
      number: createPrimitiveTypeChecker('number'),
      object: createPrimitiveTypeChecker('object'),
      string: createPrimitiveTypeChecker('string'),
      symbol: createPrimitiveTypeChecker('symbol'),

      any: createAnyTypeChecker(),
      arrayOf: createArrayOfTypeChecker,
      element: createElementTypeChecker(),
      elementType: createElementTypeTypeChecker(),
      instanceOf: createInstanceTypeChecker,
      node: createNodeChecker(),
      objectOf: createObjectOfTypeChecker,
      oneOf: createEnumTypeChecker,
      oneOfType: createUnionTypeChecker,
      shape: createShapeTypeChecker,
      exact: createStrictShapeTypeChecker,
    };

    /**
     * inlined Object.is polyfill to avoid requiring consumers ship their own
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
     */
    /*eslint-disable no-self-compare*/
    function is(x, y) {
      // SameValue algorithm
      if (x === y) {
        // Steps 1-5, 7-10
        // Steps 6.b-6.e: +0 != -0
        return x !== 0 || 1 / x === 1 / y;
      } else {
        // Step 6.a: NaN == NaN
        return x !== x && y !== y;
      }
    }
    /*eslint-enable no-self-compare*/

    /**
     * We use an Error-like object for backward compatibility as people may call
     * PropTypes directly and inspect their output. However, we don't use real
     * Errors anymore. We don't inspect their stack anyway, and creating them
     * is prohibitively expensive if they are created too often, such as what
     * happens in oneOfType() for any type before the one that matched.
     */
    function PropTypeError(message, data) {
      this.message = message;
      this.data = data && typeof data === 'object' ? data: {};
      this.stack = '';
    }
    // Make `instanceof Error` still work for returned errors.
    PropTypeError.prototype = Error.prototype;

    function createChainableTypeChecker(validate) {
      {
        var manualPropTypeCallCache = {};
        var manualPropTypeWarningCount = 0;
      }
      function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
        componentName = componentName || ANONYMOUS;
        propFullName = propFullName || propName;

        if (secret !== ReactPropTypesSecret$1) {
          if (throwOnDirectAccess) {
            // New behavior only for users of `prop-types` package
            var err = new Error(
              'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
              'Use `PropTypes.checkPropTypes()` to call them. ' +
              'Read more at http://fb.me/use-check-prop-types'
            );
            err.name = 'Invariant Violation';
            throw err;
          } else if (typeof console !== 'undefined') {
            // Old behavior for people using React.PropTypes
            var cacheKey = componentName + ':' + propName;
            if (
              !manualPropTypeCallCache[cacheKey] &&
              // Avoid spamming the console because they are often not actionable except for lib authors
              manualPropTypeWarningCount < 3
            ) {
              printWarning(
                'You are manually calling a React.PropTypes validation ' +
                'function for the `' + propFullName + '` prop on `' + componentName + '`. This is deprecated ' +
                'and will throw in the standalone `prop-types` package. ' +
                'You may be seeing this warning due to a third-party PropTypes ' +
                'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
              );
              manualPropTypeCallCache[cacheKey] = true;
              manualPropTypeWarningCount++;
            }
          }
        }
        if (props[propName] == null) {
          if (isRequired) {
            if (props[propName] === null) {
              return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
            }
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
          }
          return null;
        } else {
          return validate(props, propName, componentName, location, propFullName);
        }
      }

      var chainedCheckType = checkType.bind(null, false);
      chainedCheckType.isRequired = checkType.bind(null, true);

      return chainedCheckType;
    }

    function createPrimitiveTypeChecker(expectedType) {
      function validate(props, propName, componentName, location, propFullName, secret) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== expectedType) {
          // `propValue` being instance of, say, date/regexp, pass the 'object'
          // check, but we can offer a more precise error message here rather than
          // 'of type `object`'.
          var preciseType = getPreciseType(propValue);

          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'),
            {expectedType: expectedType}
          );
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createAnyTypeChecker() {
      return createChainableTypeChecker(emptyFunctionThatReturnsNull);
    }

    function createArrayOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
        }
        var propValue = props[propName];
        if (!Array.isArray(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
        }
        for (var i = 0; i < propValue.length; i++) {
          var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret$1);
          if (error instanceof Error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!isValidElement(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!reactIs.isValidElementType(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createInstanceTypeChecker(expectedClass) {
      function validate(props, propName, componentName, location, propFullName) {
        if (!(props[propName] instanceof expectedClass)) {
          var expectedClassName = expectedClass.name || ANONYMOUS;
          var actualClassName = getClassName(props[propName]);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createEnumTypeChecker(expectedValues) {
      if (!Array.isArray(expectedValues)) {
        {
          if (arguments.length > 1) {
            printWarning(
              'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
              'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
            );
          } else {
            printWarning('Invalid argument supplied to oneOf, expected an array.');
          }
        }
        return emptyFunctionThatReturnsNull;
      }

      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        for (var i = 0; i < expectedValues.length; i++) {
          if (is(propValue, expectedValues[i])) {
            return null;
          }
        }

        var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
          var type = getPreciseType(value);
          if (type === 'symbol') {
            return String(value);
          }
          return value;
        });
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createObjectOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
        }
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
        }
        for (var key in propValue) {
          if (has$1(propValue, key)) {
            var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret$1);
            if (error instanceof Error) {
              return error;
            }
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createUnionTypeChecker(arrayOfTypeCheckers) {
      if (!Array.isArray(arrayOfTypeCheckers)) {
        printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') ;
        return emptyFunctionThatReturnsNull;
      }

      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (typeof checker !== 'function') {
          printWarning(
            'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
            'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
          );
          return emptyFunctionThatReturnsNull;
        }
      }

      function validate(props, propName, componentName, location, propFullName) {
        var expectedTypes = [];
        for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
          var checker = arrayOfTypeCheckers[i];
          var checkerResult = checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret$1);
          if (checkerResult == null) {
            return null;
          }
          if (checkerResult.data && has$1(checkerResult.data, 'expectedType')) {
            expectedTypes.push(checkerResult.data.expectedType);
          }
        }
        var expectedTypesMessage = (expectedTypes.length > 0) ? ', expected one of type [' + expectedTypes.join(', ') + ']': '';
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`' + expectedTypesMessage + '.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createNodeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        if (!isNode(props[propName])) {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function invalidValidatorError(componentName, location, propFullName, key, type) {
      return new PropTypeError(
        (componentName || 'React class') + ': ' + location + ' type `' + propFullName + '.' + key + '` is invalid; ' +
        'it must be a function, usually from the `prop-types` package, but received `' + type + '`.'
      );
    }

    function createShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        for (var key in shapeTypes) {
          var checker = shapeTypes[key];
          if (typeof checker !== 'function') {
            return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret$1);
          if (error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createStrictShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        // We need to check all keys in case some are required but missing from props.
        var allKeys = objectAssign({}, props[propName], shapeTypes);
        for (var key in allKeys) {
          var checker = shapeTypes[key];
          if (has$1(shapeTypes, key) && typeof checker !== 'function') {
            return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
          }
          if (!checker) {
            return new PropTypeError(
              'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
              '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
              '\nValid keys: ' + JSON.stringify(Object.keys(shapeTypes), null, '  ')
            );
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret$1);
          if (error) {
            return error;
          }
        }
        return null;
      }

      return createChainableTypeChecker(validate);
    }

    function isNode(propValue) {
      switch (typeof propValue) {
        case 'number':
        case 'string':
        case 'undefined':
          return true;
        case 'boolean':
          return !propValue;
        case 'object':
          if (Array.isArray(propValue)) {
            return propValue.every(isNode);
          }
          if (propValue === null || isValidElement(propValue)) {
            return true;
          }

          var iteratorFn = getIteratorFn(propValue);
          if (iteratorFn) {
            var iterator = iteratorFn.call(propValue);
            var step;
            if (iteratorFn !== propValue.entries) {
              while (!(step = iterator.next()).done) {
                if (!isNode(step.value)) {
                  return false;
                }
              }
            } else {
              // Iterator will provide entry [k,v] tuples rather than values.
              while (!(step = iterator.next()).done) {
                var entry = step.value;
                if (entry) {
                  if (!isNode(entry[1])) {
                    return false;
                  }
                }
              }
            }
          } else {
            return false;
          }

          return true;
        default:
          return false;
      }
    }

    function isSymbol(propType, propValue) {
      // Native Symbol.
      if (propType === 'symbol') {
        return true;
      }

      // falsy value can't be a Symbol
      if (!propValue) {
        return false;
      }

      // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
      if (propValue['@@toStringTag'] === 'Symbol') {
        return true;
      }

      // Fallback for non-spec compliant Symbols which are polyfilled.
      if (typeof Symbol === 'function' && propValue instanceof Symbol) {
        return true;
      }

      return false;
    }

    // Equivalent of `typeof` but with special handling for array and regexp.
    function getPropType(propValue) {
      var propType = typeof propValue;
      if (Array.isArray(propValue)) {
        return 'array';
      }
      if (propValue instanceof RegExp) {
        // Old webkits (at least until Android 4.0) return 'function' rather than
        // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
        // passes PropTypes.object.
        return 'object';
      }
      if (isSymbol(propType, propValue)) {
        return 'symbol';
      }
      return propType;
    }

    // This handles more types than `getPropType`. Only used for error messages.
    // See `createPrimitiveTypeChecker`.
    function getPreciseType(propValue) {
      if (typeof propValue === 'undefined' || propValue === null) {
        return '' + propValue;
      }
      var propType = getPropType(propValue);
      if (propType === 'object') {
        if (propValue instanceof Date) {
          return 'date';
        } else if (propValue instanceof RegExp) {
          return 'regexp';
        }
      }
      return propType;
    }

    // Returns a string that is postfixed to a warning about an invalid type.
    // For example, "undefined" or "of type array"
    function getPostfixForTypeWarning(value) {
      var type = getPreciseType(value);
      switch (type) {
        case 'array':
        case 'object':
          return 'an ' + type;
        case 'boolean':
        case 'date':
        case 'regexp':
          return 'a ' + type;
        default:
          return type;
      }
    }

    // Returns class name of the object, if any.
    function getClassName(propValue) {
      if (!propValue.constructor || !propValue.constructor.name) {
        return ANONYMOUS;
      }
      return propValue.constructor.name;
    }

    ReactPropTypes.checkPropTypes = checkPropTypes;
    ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;
    ReactPropTypes.PropTypes = ReactPropTypes;

    return ReactPropTypes;
  };

  var require$$1 = factoryWithTypeCheckers;

  var propTypes = createCommonjsModule(function (module) {
  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  {
    var ReactIs = reactIs;

    // By explicitly using `prop-types` you are opting into new development behavior.
    // http://fb.me/prop-types-in-prod
    var throwOnDirectAccess = true;
    module.exports = require$$1(ReactIs.isElement, throwOnDirectAccess);
  }
  });

  var PropTypes = propTypes;
  propTypes.elementType;
  propTypes.bool;
  propTypes.func;
  propTypes.object;
  propTypes.oneOfType;
  propTypes.element;

  var reactJsxRuntime_production_min = createCommonjsModule(function (module, exports) {
  var g=60103;exports.Fragment=60107;if("function"===typeof Symbol&&Symbol.for){var h=Symbol.for;g=h("react.element");exports.Fragment=h("react.fragment");}var m=React__default["default"].__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,n=Object.prototype.hasOwnProperty,p={key:!0,ref:!0,__self:!0,__source:!0};
  function q(c,a,k){var b,d={},e=null,l=null;void 0!==k&&(e=""+k);void 0!==a.key&&(e=""+a.key);void 0!==a.ref&&(l=a.ref);for(b in a)n.call(a,b)&&!p.hasOwnProperty(b)&&(d[b]=a[b]);if(c&&c.defaultProps)for(b in a=c.defaultProps,a)void 0===d[b]&&(d[b]=a[b]);return {$$typeof:g,type:c,key:e,ref:l,props:d,_owner:m.current}}exports.jsx=q;exports.jsxs=q;
  });
  reactJsxRuntime_production_min.Fragment;
  reactJsxRuntime_production_min.jsx;
  reactJsxRuntime_production_min.jsxs;

  var reactJsxRuntime_development = createCommonjsModule(function (module, exports) {

  {
    (function() {

  var React = React__default["default"];
  var _assign = objectAssign;

  // ATTENTION
  // When adding new symbols to this file,
  // Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
  // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
  // nor polyfill, then a plain number is used for performance.
  var REACT_ELEMENT_TYPE = 0xeac7;
  var REACT_PORTAL_TYPE = 0xeaca;
  exports.Fragment = 0xeacb;
  var REACT_STRICT_MODE_TYPE = 0xeacc;
  var REACT_PROFILER_TYPE = 0xead2;
  var REACT_PROVIDER_TYPE = 0xeacd;
  var REACT_CONTEXT_TYPE = 0xeace;
  var REACT_FORWARD_REF_TYPE = 0xead0;
  var REACT_SUSPENSE_TYPE = 0xead1;
  var REACT_SUSPENSE_LIST_TYPE = 0xead8;
  var REACT_MEMO_TYPE = 0xead3;
  var REACT_LAZY_TYPE = 0xead4;
  var REACT_BLOCK_TYPE = 0xead9;
  var REACT_SERVER_BLOCK_TYPE = 0xeada;
  var REACT_FUNDAMENTAL_TYPE = 0xead5;
  var REACT_DEBUG_TRACING_MODE_TYPE = 0xeae1;
  var REACT_LEGACY_HIDDEN_TYPE = 0xeae3;

  if (typeof Symbol === 'function' && Symbol.for) {
    var symbolFor = Symbol.for;
    REACT_ELEMENT_TYPE = symbolFor('react.element');
    REACT_PORTAL_TYPE = symbolFor('react.portal');
    exports.Fragment = symbolFor('react.fragment');
    REACT_STRICT_MODE_TYPE = symbolFor('react.strict_mode');
    REACT_PROFILER_TYPE = symbolFor('react.profiler');
    REACT_PROVIDER_TYPE = symbolFor('react.provider');
    REACT_CONTEXT_TYPE = symbolFor('react.context');
    REACT_FORWARD_REF_TYPE = symbolFor('react.forward_ref');
    REACT_SUSPENSE_TYPE = symbolFor('react.suspense');
    REACT_SUSPENSE_LIST_TYPE = symbolFor('react.suspense_list');
    REACT_MEMO_TYPE = symbolFor('react.memo');
    REACT_LAZY_TYPE = symbolFor('react.lazy');
    REACT_BLOCK_TYPE = symbolFor('react.block');
    REACT_SERVER_BLOCK_TYPE = symbolFor('react.server.block');
    REACT_FUNDAMENTAL_TYPE = symbolFor('react.fundamental');
    symbolFor('react.scope');
    symbolFor('react.opaque.id');
    REACT_DEBUG_TRACING_MODE_TYPE = symbolFor('react.debug_trace_mode');
    symbolFor('react.offscreen');
    REACT_LEGACY_HIDDEN_TYPE = symbolFor('react.legacy_hidden');
  }

  var MAYBE_ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator';
  function getIteratorFn(maybeIterable) {
    if (maybeIterable === null || typeof maybeIterable !== 'object') {
      return null;
    }

    var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];

    if (typeof maybeIterator === 'function') {
      return maybeIterator;
    }

    return null;
  }

  var ReactSharedInternals = React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;

  function error(format) {
    {
      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      printWarning('error', format, args);
    }
  }

  function printWarning(level, format, args) {
    // When changing this logic, you might want to also
    // update consoleWithStackDev.www.js as well.
    {
      var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;
      var stack = ReactDebugCurrentFrame.getStackAddendum();

      if (stack !== '') {
        format += '%s';
        args = args.concat([stack]);
      }

      var argsWithFormat = args.map(function (item) {
        return '' + item;
      }); // Careful: RN currently depends on this prefix

      argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it
      // breaks IE9: https://github.com/facebook/react/issues/13610
      // eslint-disable-next-line react-internal/no-production-logging

      Function.prototype.apply.call(console[level], console, argsWithFormat);
    }
  }

  // Filter certain DOM attributes (e.g. src, href) if their values are empty strings.

  var enableScopeAPI = false; // Experimental Create Event Handle API.

  function isValidElementType(type) {
    if (typeof type === 'string' || typeof type === 'function') {
      return true;
    } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


    if (type === exports.Fragment || type === REACT_PROFILER_TYPE || type === REACT_DEBUG_TRACING_MODE_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || type === REACT_LEGACY_HIDDEN_TYPE || enableScopeAPI ) {
      return true;
    }

    if (typeof type === 'object' && type !== null) {
      if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_BLOCK_TYPE || type[0] === REACT_SERVER_BLOCK_TYPE) {
        return true;
      }
    }

    return false;
  }

  function getWrappedName(outerType, innerType, wrapperName) {
    var functionName = innerType.displayName || innerType.name || '';
    return outerType.displayName || (functionName !== '' ? wrapperName + "(" + functionName + ")" : wrapperName);
  }

  function getContextName(type) {
    return type.displayName || 'Context';
  }

  function getComponentName(type) {
    if (type == null) {
      // Host root, text node or just invalid type.
      return null;
    }

    {
      if (typeof type.tag === 'number') {
        error('Received an unexpected object in getComponentName(). ' + 'This is likely a bug in React. Please file an issue.');
      }
    }

    if (typeof type === 'function') {
      return type.displayName || type.name || null;
    }

    if (typeof type === 'string') {
      return type;
    }

    switch (type) {
      case exports.Fragment:
        return 'Fragment';

      case REACT_PORTAL_TYPE:
        return 'Portal';

      case REACT_PROFILER_TYPE:
        return 'Profiler';

      case REACT_STRICT_MODE_TYPE:
        return 'StrictMode';

      case REACT_SUSPENSE_TYPE:
        return 'Suspense';

      case REACT_SUSPENSE_LIST_TYPE:
        return 'SuspenseList';
    }

    if (typeof type === 'object') {
      switch (type.$$typeof) {
        case REACT_CONTEXT_TYPE:
          var context = type;
          return getContextName(context) + '.Consumer';

        case REACT_PROVIDER_TYPE:
          var provider = type;
          return getContextName(provider._context) + '.Provider';

        case REACT_FORWARD_REF_TYPE:
          return getWrappedName(type, type.render, 'ForwardRef');

        case REACT_MEMO_TYPE:
          return getComponentName(type.type);

        case REACT_BLOCK_TYPE:
          return getComponentName(type._render);

        case REACT_LAZY_TYPE:
          {
            var lazyComponent = type;
            var payload = lazyComponent._payload;
            var init = lazyComponent._init;

            try {
              return getComponentName(init(payload));
            } catch (x) {
              return null;
            }
          }
      }
    }

    return null;
  }

  // Helpers to patch console.logs to avoid logging during side-effect free
  // replaying on render function. This currently only patches the object
  // lazily which won't cover if the log function was extracted eagerly.
  // We could also eagerly patch the method.
  var disabledDepth = 0;
  var prevLog;
  var prevInfo;
  var prevWarn;
  var prevError;
  var prevGroup;
  var prevGroupCollapsed;
  var prevGroupEnd;

  function disabledLog() {}

  disabledLog.__reactDisabledLog = true;
  function disableLogs() {
    {
      if (disabledDepth === 0) {
        /* eslint-disable react-internal/no-production-logging */
        prevLog = console.log;
        prevInfo = console.info;
        prevWarn = console.warn;
        prevError = console.error;
        prevGroup = console.group;
        prevGroupCollapsed = console.groupCollapsed;
        prevGroupEnd = console.groupEnd; // https://github.com/facebook/react/issues/19099

        var props = {
          configurable: true,
          enumerable: true,
          value: disabledLog,
          writable: true
        }; // $FlowFixMe Flow thinks console is immutable.

        Object.defineProperties(console, {
          info: props,
          log: props,
          warn: props,
          error: props,
          group: props,
          groupCollapsed: props,
          groupEnd: props
        });
        /* eslint-enable react-internal/no-production-logging */
      }

      disabledDepth++;
    }
  }
  function reenableLogs() {
    {
      disabledDepth--;

      if (disabledDepth === 0) {
        /* eslint-disable react-internal/no-production-logging */
        var props = {
          configurable: true,
          enumerable: true,
          writable: true
        }; // $FlowFixMe Flow thinks console is immutable.

        Object.defineProperties(console, {
          log: _assign({}, props, {
            value: prevLog
          }),
          info: _assign({}, props, {
            value: prevInfo
          }),
          warn: _assign({}, props, {
            value: prevWarn
          }),
          error: _assign({}, props, {
            value: prevError
          }),
          group: _assign({}, props, {
            value: prevGroup
          }),
          groupCollapsed: _assign({}, props, {
            value: prevGroupCollapsed
          }),
          groupEnd: _assign({}, props, {
            value: prevGroupEnd
          })
        });
        /* eslint-enable react-internal/no-production-logging */
      }

      if (disabledDepth < 0) {
        error('disabledDepth fell below zero. ' + 'This is a bug in React. Please file an issue.');
      }
    }
  }

  var ReactCurrentDispatcher = ReactSharedInternals.ReactCurrentDispatcher;
  var prefix;
  function describeBuiltInComponentFrame(name, source, ownerFn) {
    {
      if (prefix === undefined) {
        // Extract the VM specific prefix used by each line.
        try {
          throw Error();
        } catch (x) {
          var match = x.stack.trim().match(/\n( *(at )?)/);
          prefix = match && match[1] || '';
        }
      } // We use the prefix to ensure our stacks line up with native stack frames.


      return '\n' + prefix + name;
    }
  }
  var reentry = false;
  var componentFrameCache;

  {
    var PossiblyWeakMap = typeof WeakMap === 'function' ? WeakMap : Map;
    componentFrameCache = new PossiblyWeakMap();
  }

  function describeNativeComponentFrame(fn, construct) {
    // If something asked for a stack inside a fake render, it should get ignored.
    if (!fn || reentry) {
      return '';
    }

    {
      var frame = componentFrameCache.get(fn);

      if (frame !== undefined) {
        return frame;
      }
    }

    var control;
    reentry = true;
    var previousPrepareStackTrace = Error.prepareStackTrace; // $FlowFixMe It does accept undefined.

    Error.prepareStackTrace = undefined;
    var previousDispatcher;

    {
      previousDispatcher = ReactCurrentDispatcher.current; // Set the dispatcher in DEV because this might be call in the render function
      // for warnings.

      ReactCurrentDispatcher.current = null;
      disableLogs();
    }

    try {
      // This should throw.
      if (construct) {
        // Something should be setting the props in the constructor.
        var Fake = function () {
          throw Error();
        }; // $FlowFixMe


        Object.defineProperty(Fake.prototype, 'props', {
          set: function () {
            // We use a throwing setter instead of frozen or non-writable props
            // because that won't throw in a non-strict mode function.
            throw Error();
          }
        });

        if (typeof Reflect === 'object' && Reflect.construct) {
          // We construct a different control for this case to include any extra
          // frames added by the construct call.
          try {
            Reflect.construct(Fake, []);
          } catch (x) {
            control = x;
          }

          Reflect.construct(fn, [], Fake);
        } else {
          try {
            Fake.call();
          } catch (x) {
            control = x;
          }

          fn.call(Fake.prototype);
        }
      } else {
        try {
          throw Error();
        } catch (x) {
          control = x;
        }

        fn();
      }
    } catch (sample) {
      // This is inlined manually because closure doesn't do it for us.
      if (sample && control && typeof sample.stack === 'string') {
        // This extracts the first frame from the sample that isn't also in the control.
        // Skipping one frame that we assume is the frame that calls the two.
        var sampleLines = sample.stack.split('\n');
        var controlLines = control.stack.split('\n');
        var s = sampleLines.length - 1;
        var c = controlLines.length - 1;

        while (s >= 1 && c >= 0 && sampleLines[s] !== controlLines[c]) {
          // We expect at least one stack frame to be shared.
          // Typically this will be the root most one. However, stack frames may be
          // cut off due to maximum stack limits. In this case, one maybe cut off
          // earlier than the other. We assume that the sample is longer or the same
          // and there for cut off earlier. So we should find the root most frame in
          // the sample somewhere in the control.
          c--;
        }

        for (; s >= 1 && c >= 0; s--, c--) {
          // Next we find the first one that isn't the same which should be the
          // frame that called our sample function and the control.
          if (sampleLines[s] !== controlLines[c]) {
            // In V8, the first line is describing the message but other VMs don't.
            // If we're about to return the first line, and the control is also on the same
            // line, that's a pretty good indicator that our sample threw at same line as
            // the control. I.e. before we entered the sample frame. So we ignore this result.
            // This can happen if you passed a class to function component, or non-function.
            if (s !== 1 || c !== 1) {
              do {
                s--;
                c--; // We may still have similar intermediate frames from the construct call.
                // The next one that isn't the same should be our match though.

                if (c < 0 || sampleLines[s] !== controlLines[c]) {
                  // V8 adds a "new" prefix for native classes. Let's remove it to make it prettier.
                  var _frame = '\n' + sampleLines[s].replace(' at new ', ' at ');

                  {
                    if (typeof fn === 'function') {
                      componentFrameCache.set(fn, _frame);
                    }
                  } // Return the line we found.


                  return _frame;
                }
              } while (s >= 1 && c >= 0);
            }

            break;
          }
        }
      }
    } finally {
      reentry = false;

      {
        ReactCurrentDispatcher.current = previousDispatcher;
        reenableLogs();
      }

      Error.prepareStackTrace = previousPrepareStackTrace;
    } // Fallback to just using the name if we couldn't make it throw.


    var name = fn ? fn.displayName || fn.name : '';
    var syntheticFrame = name ? describeBuiltInComponentFrame(name) : '';

    {
      if (typeof fn === 'function') {
        componentFrameCache.set(fn, syntheticFrame);
      }
    }

    return syntheticFrame;
  }
  function describeFunctionComponentFrame(fn, source, ownerFn) {
    {
      return describeNativeComponentFrame(fn, false);
    }
  }

  function shouldConstruct(Component) {
    var prototype = Component.prototype;
    return !!(prototype && prototype.isReactComponent);
  }

  function describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {

    if (type == null) {
      return '';
    }

    if (typeof type === 'function') {
      {
        return describeNativeComponentFrame(type, shouldConstruct(type));
      }
    }

    if (typeof type === 'string') {
      return describeBuiltInComponentFrame(type);
    }

    switch (type) {
      case REACT_SUSPENSE_TYPE:
        return describeBuiltInComponentFrame('Suspense');

      case REACT_SUSPENSE_LIST_TYPE:
        return describeBuiltInComponentFrame('SuspenseList');
    }

    if (typeof type === 'object') {
      switch (type.$$typeof) {
        case REACT_FORWARD_REF_TYPE:
          return describeFunctionComponentFrame(type.render);

        case REACT_MEMO_TYPE:
          // Memo may contain any component type so we recursively resolve it.
          return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);

        case REACT_BLOCK_TYPE:
          return describeFunctionComponentFrame(type._render);

        case REACT_LAZY_TYPE:
          {
            var lazyComponent = type;
            var payload = lazyComponent._payload;
            var init = lazyComponent._init;

            try {
              // Lazy may contain any component type so we recursively resolve it.
              return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);
            } catch (x) {}
          }
      }
    }

    return '';
  }

  var loggedTypeFailures = {};
  var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;

  function setCurrentlyValidatingElement(element) {
    {
      if (element) {
        var owner = element._owner;
        var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
        ReactDebugCurrentFrame.setExtraStackFrame(stack);
      } else {
        ReactDebugCurrentFrame.setExtraStackFrame(null);
      }
    }
  }

  function checkPropTypes(typeSpecs, values, location, componentName, element) {
    {
      // $FlowFixMe This is okay but Flow doesn't know it.
      var has = Function.call.bind(Object.prototype.hasOwnProperty);

      for (var typeSpecName in typeSpecs) {
        if (has(typeSpecs, typeSpecName)) {
          var error$1 = void 0; // Prop type validation may throw. In case they do, we don't want to
          // fail the render phase where it didn't fail before. So we log it.
          // After these have been cleaned up, we'll let them throw.

          try {
            // This is intentionally an invariant that gets caught. It's the same
            // behavior as without this statement except with a better message.
            if (typeof typeSpecs[typeSpecName] !== 'function') {
              var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' + 'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.');
              err.name = 'Invariant Violation';
              throw err;
            }

            error$1 = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED');
          } catch (ex) {
            error$1 = ex;
          }

          if (error$1 && !(error$1 instanceof Error)) {
            setCurrentlyValidatingElement(element);

            error('%s: type specification of %s' + ' `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error$1);

            setCurrentlyValidatingElement(null);
          }

          if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {
            // Only monitor this failure once because there tends to be a lot of the
            // same error.
            loggedTypeFailures[error$1.message] = true;
            setCurrentlyValidatingElement(element);

            error('Failed %s type: %s', location, error$1.message);

            setCurrentlyValidatingElement(null);
          }
        }
      }
    }
  }

  var ReactCurrentOwner = ReactSharedInternals.ReactCurrentOwner;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var RESERVED_PROPS = {
    key: true,
    ref: true,
    __self: true,
    __source: true
  };
  var specialPropKeyWarningShown;
  var specialPropRefWarningShown;
  var didWarnAboutStringRefs;

  {
    didWarnAboutStringRefs = {};
  }

  function hasValidRef(config) {
    {
      if (hasOwnProperty.call(config, 'ref')) {
        var getter = Object.getOwnPropertyDescriptor(config, 'ref').get;

        if (getter && getter.isReactWarning) {
          return false;
        }
      }
    }

    return config.ref !== undefined;
  }

  function hasValidKey(config) {
    {
      if (hasOwnProperty.call(config, 'key')) {
        var getter = Object.getOwnPropertyDescriptor(config, 'key').get;

        if (getter && getter.isReactWarning) {
          return false;
        }
      }
    }

    return config.key !== undefined;
  }

  function warnIfStringRefCannotBeAutoConverted(config, self) {
    {
      if (typeof config.ref === 'string' && ReactCurrentOwner.current && self && ReactCurrentOwner.current.stateNode !== self) {
        var componentName = getComponentName(ReactCurrentOwner.current.type);

        if (!didWarnAboutStringRefs[componentName]) {
          error('Component "%s" contains the string ref "%s". ' + 'Support for string refs will be removed in a future major release. ' + 'This case cannot be automatically converted to an arrow function. ' + 'We ask you to manually fix this case by using useRef() or createRef() instead. ' + 'Learn more about using refs safely here: ' + 'https://reactjs.org/link/strict-mode-string-ref', getComponentName(ReactCurrentOwner.current.type), config.ref);

          didWarnAboutStringRefs[componentName] = true;
        }
      }
    }
  }

  function defineKeyPropWarningGetter(props, displayName) {
    {
      var warnAboutAccessingKey = function () {
        if (!specialPropKeyWarningShown) {
          specialPropKeyWarningShown = true;

          error('%s: `key` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://reactjs.org/link/special-props)', displayName);
        }
      };

      warnAboutAccessingKey.isReactWarning = true;
      Object.defineProperty(props, 'key', {
        get: warnAboutAccessingKey,
        configurable: true
      });
    }
  }

  function defineRefPropWarningGetter(props, displayName) {
    {
      var warnAboutAccessingRef = function () {
        if (!specialPropRefWarningShown) {
          specialPropRefWarningShown = true;

          error('%s: `ref` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://reactjs.org/link/special-props)', displayName);
        }
      };

      warnAboutAccessingRef.isReactWarning = true;
      Object.defineProperty(props, 'ref', {
        get: warnAboutAccessingRef,
        configurable: true
      });
    }
  }
  /**
   * Factory method to create a new React element. This no longer adheres to
   * the class pattern, so do not use new to call it. Also, instanceof check
   * will not work. Instead test $$typeof field against Symbol.for('react.element') to check
   * if something is a React Element.
   *
   * @param {*} type
   * @param {*} props
   * @param {*} key
   * @param {string|object} ref
   * @param {*} owner
   * @param {*} self A *temporary* helper to detect places where `this` is
   * different from the `owner` when React.createElement is called, so that we
   * can warn. We want to get rid of owner and replace string `ref`s with arrow
   * functions, and as long as `this` and owner are the same, there will be no
   * change in behavior.
   * @param {*} source An annotation object (added by a transpiler or otherwise)
   * indicating filename, line number, and/or other information.
   * @internal
   */


  var ReactElement = function (type, key, ref, self, source, owner, props) {
    var element = {
      // This tag allows us to uniquely identify this as a React Element
      $$typeof: REACT_ELEMENT_TYPE,
      // Built-in properties that belong on the element
      type: type,
      key: key,
      ref: ref,
      props: props,
      // Record the component responsible for creating this element.
      _owner: owner
    };

    {
      // The validation flag is currently mutative. We put it on
      // an external backing store so that we can freeze the whole object.
      // This can be replaced with a WeakMap once they are implemented in
      // commonly used development environments.
      element._store = {}; // To make comparing ReactElements easier for testing purposes, we make
      // the validation flag non-enumerable (where possible, which should
      // include every environment we run tests in), so the test framework
      // ignores it.

      Object.defineProperty(element._store, 'validated', {
        configurable: false,
        enumerable: false,
        writable: true,
        value: false
      }); // self and source are DEV only properties.

      Object.defineProperty(element, '_self', {
        configurable: false,
        enumerable: false,
        writable: false,
        value: self
      }); // Two elements created in two different places should be considered
      // equal for testing purposes and therefore we hide it from enumeration.

      Object.defineProperty(element, '_source', {
        configurable: false,
        enumerable: false,
        writable: false,
        value: source
      });

      if (Object.freeze) {
        Object.freeze(element.props);
        Object.freeze(element);
      }
    }

    return element;
  };
  /**
   * https://github.com/reactjs/rfcs/pull/107
   * @param {*} type
   * @param {object} props
   * @param {string} key
   */

  function jsxDEV(type, config, maybeKey, source, self) {
    {
      var propName; // Reserved names are extracted

      var props = {};
      var key = null;
      var ref = null; // Currently, key can be spread in as a prop. This causes a potential
      // issue if key is also explicitly declared (ie. <div {...props} key="Hi" />
      // or <div key="Hi" {...props} /> ). We want to deprecate key spread,
      // but as an intermediary step, we will use jsxDEV for everything except
      // <div {...props} key="Hi" />, because we aren't currently able to tell if
      // key is explicitly declared to be undefined or not.

      if (maybeKey !== undefined) {
        key = '' + maybeKey;
      }

      if (hasValidKey(config)) {
        key = '' + config.key;
      }

      if (hasValidRef(config)) {
        ref = config.ref;
        warnIfStringRefCannotBeAutoConverted(config, self);
      } // Remaining properties are added to a new props object


      for (propName in config) {
        if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
          props[propName] = config[propName];
        }
      } // Resolve default props


      if (type && type.defaultProps) {
        var defaultProps = type.defaultProps;

        for (propName in defaultProps) {
          if (props[propName] === undefined) {
            props[propName] = defaultProps[propName];
          }
        }
      }

      if (key || ref) {
        var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;

        if (key) {
          defineKeyPropWarningGetter(props, displayName);
        }

        if (ref) {
          defineRefPropWarningGetter(props, displayName);
        }
      }

      return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);
    }
  }

  var ReactCurrentOwner$1 = ReactSharedInternals.ReactCurrentOwner;
  var ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;

  function setCurrentlyValidatingElement$1(element) {
    {
      if (element) {
        var owner = element._owner;
        var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
        ReactDebugCurrentFrame$1.setExtraStackFrame(stack);
      } else {
        ReactDebugCurrentFrame$1.setExtraStackFrame(null);
      }
    }
  }

  var propTypesMisspellWarningShown;

  {
    propTypesMisspellWarningShown = false;
  }
  /**
   * Verifies the object is a ReactElement.
   * See https://reactjs.org/docs/react-api.html#isvalidelement
   * @param {?object} object
   * @return {boolean} True if `object` is a ReactElement.
   * @final
   */

  function isValidElement(object) {
    {
      return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
    }
  }

  function getDeclarationErrorAddendum() {
    {
      if (ReactCurrentOwner$1.current) {
        var name = getComponentName(ReactCurrentOwner$1.current.type);

        if (name) {
          return '\n\nCheck the render method of `' + name + '`.';
        }
      }

      return '';
    }
  }

  function getSourceInfoErrorAddendum(source) {
    {
      if (source !== undefined) {
        var fileName = source.fileName.replace(/^.*[\\\/]/, '');
        var lineNumber = source.lineNumber;
        return '\n\nCheck your code at ' + fileName + ':' + lineNumber + '.';
      }

      return '';
    }
  }
  /**
   * Warn if there's no key explicitly set on dynamic arrays of children or
   * object keys are not valid. This allows us to keep track of children between
   * updates.
   */


  var ownerHasKeyUseWarning = {};

  function getCurrentComponentErrorInfo(parentType) {
    {
      var info = getDeclarationErrorAddendum();

      if (!info) {
        var parentName = typeof parentType === 'string' ? parentType : parentType.displayName || parentType.name;

        if (parentName) {
          info = "\n\nCheck the top-level render call using <" + parentName + ">.";
        }
      }

      return info;
    }
  }
  /**
   * Warn if the element doesn't have an explicit key assigned to it.
   * This element is in an array. The array could grow and shrink or be
   * reordered. All children that haven't already been validated are required to
   * have a "key" property assigned to it. Error statuses are cached so a warning
   * will only be shown once.
   *
   * @internal
   * @param {ReactElement} element Element that requires a key.
   * @param {*} parentType element's parent's type.
   */


  function validateExplicitKey(element, parentType) {
    {
      if (!element._store || element._store.validated || element.key != null) {
        return;
      }

      element._store.validated = true;
      var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);

      if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
        return;
      }

      ownerHasKeyUseWarning[currentComponentErrorInfo] = true; // Usually the current owner is the offender, but if it accepts children as a
      // property, it may be the creator of the child that's responsible for
      // assigning it a key.

      var childOwner = '';

      if (element && element._owner && element._owner !== ReactCurrentOwner$1.current) {
        // Give the component that originally created this child.
        childOwner = " It was passed a child from " + getComponentName(element._owner.type) + ".";
      }

      setCurrentlyValidatingElement$1(element);

      error('Each child in a list should have a unique "key" prop.' + '%s%s See https://reactjs.org/link/warning-keys for more information.', currentComponentErrorInfo, childOwner);

      setCurrentlyValidatingElement$1(null);
    }
  }
  /**
   * Ensure that every element either is passed in a static location, in an
   * array with an explicit keys property defined, or in an object literal
   * with valid key property.
   *
   * @internal
   * @param {ReactNode} node Statically passed child of any type.
   * @param {*} parentType node's parent's type.
   */


  function validateChildKeys(node, parentType) {
    {
      if (typeof node !== 'object') {
        return;
      }

      if (Array.isArray(node)) {
        for (var i = 0; i < node.length; i++) {
          var child = node[i];

          if (isValidElement(child)) {
            validateExplicitKey(child, parentType);
          }
        }
      } else if (isValidElement(node)) {
        // This element was passed in a valid location.
        if (node._store) {
          node._store.validated = true;
        }
      } else if (node) {
        var iteratorFn = getIteratorFn(node);

        if (typeof iteratorFn === 'function') {
          // Entry iterators used to provide implicit keys,
          // but now we print a separate warning for them later.
          if (iteratorFn !== node.entries) {
            var iterator = iteratorFn.call(node);
            var step;

            while (!(step = iterator.next()).done) {
              if (isValidElement(step.value)) {
                validateExplicitKey(step.value, parentType);
              }
            }
          }
        }
      }
    }
  }
  /**
   * Given an element, validate that its props follow the propTypes definition,
   * provided by the type.
   *
   * @param {ReactElement} element
   */


  function validatePropTypes(element) {
    {
      var type = element.type;

      if (type === null || type === undefined || typeof type === 'string') {
        return;
      }

      var propTypes;

      if (typeof type === 'function') {
        propTypes = type.propTypes;
      } else if (typeof type === 'object' && (type.$$typeof === REACT_FORWARD_REF_TYPE || // Note: Memo only checks outer props here.
      // Inner props are checked in the reconciler.
      type.$$typeof === REACT_MEMO_TYPE)) {
        propTypes = type.propTypes;
      } else {
        return;
      }

      if (propTypes) {
        // Intentionally inside to avoid triggering lazy initializers:
        var name = getComponentName(type);
        checkPropTypes(propTypes, element.props, 'prop', name, element);
      } else if (type.PropTypes !== undefined && !propTypesMisspellWarningShown) {
        propTypesMisspellWarningShown = true; // Intentionally inside to avoid triggering lazy initializers:

        var _name = getComponentName(type);

        error('Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?', _name || 'Unknown');
      }

      if (typeof type.getDefaultProps === 'function' && !type.getDefaultProps.isReactClassApproved) {
        error('getDefaultProps is only used on classic React.createClass ' + 'definitions. Use a static property named `defaultProps` instead.');
      }
    }
  }
  /**
   * Given a fragment, validate that it can only be provided with fragment props
   * @param {ReactElement} fragment
   */


  function validateFragmentProps(fragment) {
    {
      var keys = Object.keys(fragment.props);

      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];

        if (key !== 'children' && key !== 'key') {
          setCurrentlyValidatingElement$1(fragment);

          error('Invalid prop `%s` supplied to `React.Fragment`. ' + 'React.Fragment can only have `key` and `children` props.', key);

          setCurrentlyValidatingElement$1(null);
          break;
        }
      }

      if (fragment.ref !== null) {
        setCurrentlyValidatingElement$1(fragment);

        error('Invalid attribute `ref` supplied to `React.Fragment`.');

        setCurrentlyValidatingElement$1(null);
      }
    }
  }

  function jsxWithValidation(type, props, key, isStaticChildren, source, self) {
    {
      var validType = isValidElementType(type); // We warn in this case but don't throw. We expect the element creation to
      // succeed and there will likely be errors in render.

      if (!validType) {
        var info = '';

        if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {
          info += ' You likely forgot to export your component from the file ' + "it's defined in, or you might have mixed up default and named imports.";
        }

        var sourceInfo = getSourceInfoErrorAddendum(source);

        if (sourceInfo) {
          info += sourceInfo;
        } else {
          info += getDeclarationErrorAddendum();
        }

        var typeString;

        if (type === null) {
          typeString = 'null';
        } else if (Array.isArray(type)) {
          typeString = 'array';
        } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {
          typeString = "<" + (getComponentName(type.type) || 'Unknown') + " />";
          info = ' Did you accidentally export a JSX literal instead of a component?';
        } else {
          typeString = typeof type;
        }

        error('React.jsx: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);
      }

      var element = jsxDEV(type, props, key, source, self); // The result can be nullish if a mock or a custom function is used.
      // TODO: Drop this when these are no longer allowed as the type argument.

      if (element == null) {
        return element;
      } // Skip key warning if the type isn't valid since our key validation logic
      // doesn't expect a non-string/function type and can throw confusing errors.
      // We don't want exception behavior to differ between dev and prod.
      // (Rendering will throw with a helpful message and as soon as the type is
      // fixed, the key warnings will appear.)


      if (validType) {
        var children = props.children;

        if (children !== undefined) {
          if (isStaticChildren) {
            if (Array.isArray(children)) {
              for (var i = 0; i < children.length; i++) {
                validateChildKeys(children[i], type);
              }

              if (Object.freeze) {
                Object.freeze(children);
              }
            } else {
              error('React.jsx: Static children should always be an array. ' + 'You are likely explicitly calling React.jsxs or React.jsxDEV. ' + 'Use the Babel transform instead.');
            }
          } else {
            validateChildKeys(children, type);
          }
        }
      }

      if (type === exports.Fragment) {
        validateFragmentProps(element);
      } else {
        validatePropTypes(element);
      }

      return element;
    }
  } // These two functions exist to still get child warnings in dev
  // even with the prod transform. This means that jsxDEV is purely
  // opt-in behavior for better messages but that we won't stop
  // giving you warnings if you use production apis.

  function jsxWithValidationStatic(type, props, key) {
    {
      return jsxWithValidation(type, props, key, true);
    }
  }
  function jsxWithValidationDynamic(type, props, key) {
    {
      return jsxWithValidation(type, props, key, false);
    }
  }

  var jsx =  jsxWithValidationDynamic ; // we may want to special case jsxs internally to take advantage of static children.
  // for now we can ship identical prod functions

  var jsxs =  jsxWithValidationStatic ;

  exports.jsx = jsx;
  exports.jsxs = jsxs;
    })();
  }
  });
  reactJsxRuntime_development.Fragment;
  reactJsxRuntime_development.jsx;
  reactJsxRuntime_development.jsxs;

  var jsxRuntime = createCommonjsModule(function (module) {

  {
    module.exports = reactJsxRuntime_development;
  }
  });
  var jsxRuntime_1 = jsxRuntime.jsx;
  var jsxRuntime_2 = jsxRuntime.jsxs;

  const cache = createCache$1({
    key: 'css',
    prepend: true
  });
  function StyledEngineProvider(props) {
    const {
      injectFirst,
      children
    } = props;
    return injectFirst ? /*#__PURE__*/jsxRuntime_1(CacheProvider, {
      value: cache,
      children: children
    }) : children;
  }
  StyledEngineProvider.propTypes = {
    /**
     * Your component tree.
     */
    children: PropTypes.node,

    /**
     * By default, the styles are injected last in the <head> element of the page.
     * As a result, they gain more specificity than any other style sheet.
     * If you want to override MUI's styles, set this prop.
     */
    injectFirst: PropTypes.bool
  } ;

  function isEmpty$3(obj) {
    return obj === undefined || obj === null || Object.keys(obj).length === 0;
  }

  function GlobalStyles$1(props) {
    const {
      styles,
      defaultTheme = {}
    } = props;
    const globalStyles = typeof styles === 'function' ? themeInput => styles(isEmpty$3(themeInput) ? defaultTheme : themeInput) : styles;
    return /*#__PURE__*/jsxRuntime_1(Global, {
      styles: globalStyles
    });
  }
  GlobalStyles$1.propTypes = {
    defaultTheme: PropTypes.object,
    styles: PropTypes.oneOfType([PropTypes.string, PropTypes.object, PropTypes.func])
  } ;

  function styled$3(tag, options) {
    const stylesFactory = emStyled(tag, options);

    {
      return (...styles) => {
        const component = typeof tag === 'string' ? `"${tag}"` : 'component';

        if (styles.length === 0) {
          console.error([`MUI: Seems like you called \`styled(${component})()\` without a \`style\` argument.`, 'You must provide a `styles` argument: `styled("div")(styleYouForgotToPass)`.'].join('\n'));
        } else if (styles.some(style => style === undefined)) {
          console.error(`MUI: the styled(${component})(...args) API requires all its args to be defined.`);
        }

        return stylesFactory(...styles);
      };
    }
  }

  const responsivePropType = PropTypes.oneOfType([PropTypes.number, PropTypes.string, PropTypes.object, PropTypes.array]) ;
  var responsivePropType$1 = responsivePropType;

  function chainPropTypes(propType1, propType2) {

    return function validate(...args) {
      return propType1(...args) || propType2(...args);
    };
  }

  function isPlainObject(item) {
    return item !== null && typeof item === 'object' && item.constructor === Object;
  }
  function deepmerge(target, source, options = {
    clone: true
  }) {
    const output = options.clone ? _extends({}, target) : target;

    if (isPlainObject(target) && isPlainObject(source)) {
      Object.keys(source).forEach(key => {
        // Avoid prototype pollution
        if (key === '__proto__') {
          return;
        }

        if (isPlainObject(source[key]) && key in target && isPlainObject(target[key])) {
          // Since `output` is a clone of `target` and we have narrowed `target` in this block we can cast to the same type.
          output[key] = deepmerge(target[key], source[key], options);
        } else {
          output[key] = source[key];
        }
      });
    }

    return output;
  }

  function isClassComponent$1(elementType) {
    // elementType.prototype?.isReactComponent
    const {
      prototype = {}
    } = elementType;
    return Boolean(prototype.isReactComponent);
  }

  function acceptingRef(props, propName, componentName, location, propFullName) {
    const element = props[propName];
    const safePropName = propFullName || propName;

    if (element == null || // When server-side rendering React doesn't warn either.
    // This is not an accurate check for SSR.
    // This is only in place for Emotion compat.
    // TODO: Revisit once https://github.com/facebook/react/issues/20047 is resolved.
    typeof window === 'undefined') {
      return null;
    }

    let warningHint;
    const elementType = element.type;
    /**
     * Blacklisting instead of whitelisting
     *
     * Blacklisting will miss some components, such as React.Fragment. Those will at least
     * trigger a warning in React.
     * We can't whitelist because there is no safe way to detect React.forwardRef
     * or class components. "Safe" means there's no public API.
     *
     */

    if (typeof elementType === 'function' && !isClassComponent$1(elementType)) {
      warningHint = 'Did you accidentally use a plain function component for an element instead?';
    }

    if (warningHint !== undefined) {
      return new Error(`Invalid ${location} \`${safePropName}\` supplied to \`${componentName}\`. ` + `Expected an element that can hold a ref. ${warningHint} ` + 'For more information see https://mui.com/r/caveat-with-refs-guide');
    }

    return null;
  }

  const elementAcceptingRef = chainPropTypes(PropTypes.element, acceptingRef);
  elementAcceptingRef.isRequired = chainPropTypes(PropTypes.element.isRequired, acceptingRef);
  var elementAcceptingRef$1 = elementAcceptingRef;

  function isClassComponent(elementType) {
    // elementType.prototype?.isReactComponent
    const {
      prototype = {}
    } = elementType;
    return Boolean(prototype.isReactComponent);
  }

  function elementTypeAcceptingRef(props, propName, componentName, location, propFullName) {
    const propValue = props[propName];
    const safePropName = propFullName || propName;

    if (propValue == null || // When server-side rendering React doesn't warn either.
    // This is not an accurate check for SSR.
    // This is only in place for emotion compat.
    // TODO: Revisit once https://github.com/facebook/react/issues/20047 is resolved.
    typeof window === 'undefined') {
      return null;
    }

    let warningHint;
    /**
     * Blacklisting instead of whitelisting
     *
     * Blacklisting will miss some components, such as React.Fragment. Those will at least
     * trigger a warning in React.
     * We can't whitelist because there is no safe way to detect React.forwardRef
     * or class components. "Safe" means there's no public API.
     *
     */

    if (typeof propValue === 'function' && !isClassComponent(propValue)) {
      warningHint = 'Did you accidentally provide a plain function component instead?';
    }

    if (warningHint !== undefined) {
      return new Error(`Invalid ${location} \`${safePropName}\` supplied to \`${componentName}\`. ` + `Expected an element type that can hold a ref. ${warningHint} ` + 'For more information see https://mui.com/r/caveat-with-refs-guide');
    }

    return null;
  }

  var elementTypeAcceptingRef$1 = chainPropTypes(PropTypes.elementType, elementTypeAcceptingRef);

  // This module is based on https://github.com/airbnb/prop-types-exact repository.
  // However, in order to reduce the number of dependencies and to remove some extra safe checks
  // the module was forked.
  const specialProperty = 'exact-prop: \u200b';
  function exactProp(propTypes) {

    return _extends({}, propTypes, {
      [specialProperty]: props => {
        const unsupportedProps = Object.keys(props).filter(prop => !propTypes.hasOwnProperty(prop));

        if (unsupportedProps.length > 0) {
          return new Error(`The following props are not supported: ${unsupportedProps.map(prop => `\`${prop}\``).join(', ')}. Please remove them.`);
        }

        return null;
      }
    });
  }

  // https://github.com/JamesMGreene/Function.name/blob/58b314d4a983110c3682f1228f845d39ccca1817/Function.name.js#L3

  const fnNameMatchRegex = /^\s*function(?:\s|\s*\/\*.*\*\/\s*)+([^(\s/]*)\s*/;
  function getFunctionName(fn) {
    const match = `${fn}`.match(fnNameMatchRegex);
    const name = match && match[1];
    return name || '';
  }

  function getFunctionComponentName(Component, fallback = '') {
    return Component.displayName || Component.name || getFunctionName(Component) || fallback;
  }

  function getWrappedName(outerType, innerType, wrapperName) {
    const functionName = getFunctionComponentName(innerType);
    return outerType.displayName || (functionName !== '' ? `${wrapperName}(${functionName})` : wrapperName);
  }
  /**
   * cherry-pick from
   * https://github.com/facebook/react/blob/769b1f270e1251d9dbdce0fcbd9e92e502d059b8/packages/shared/getComponentName.js
   * originally forked from recompose/getDisplayName with added IE11 support
   */


  function getDisplayName(Component) {
    if (Component == null) {
      return undefined;
    }

    if (typeof Component === 'string') {
      return Component;
    }

    if (typeof Component === 'function') {
      return getFunctionComponentName(Component, 'Component');
    } // TypeScript can't have components as objects but they exist in the form of `memo` or `Suspense`


    if (typeof Component === 'object') {
      switch (Component.$$typeof) {
        case reactIs_1:
          return getWrappedName(Component, Component.render, 'ForwardRef');

        case reactIs_5:
          return getWrappedName(Component, Component.type, 'memo');

        default:
          return undefined;
      }
    }

    return undefined;
  }

  function HTMLElementType(props, propName, componentName, location, propFullName) {

    const propValue = props[propName];
    const safePropName = propFullName || propName;

    if (propValue == null) {
      return null;
    }

    if (propValue && propValue.nodeType !== 1) {
      return new Error(`Invalid ${location} \`${safePropName}\` supplied to \`${componentName}\`. ` + `Expected an HTMLElement.`);
    }

    return null;
  }

  const refType = PropTypes.oneOfType([PropTypes.func, PropTypes.object]);
  var refType$1 = refType;

  // It should to be noted that this function isn't equivalent to `text-transform: capitalize`.
  //
  // A strict capitalization should uppercase the first letter of each word in the sentence.
  // We only handle the first word.
  function capitalize(string) {
    if (typeof string !== 'string') {
      throw new Error(`MUI: \`capitalize(string)\` expects a string argument.` );
    }

    return string.charAt(0).toUpperCase() + string.slice(1);
  }

  /**
   * Safe chained function.
   *
   * Will only create a new function if needed,
   * otherwise will pass back existing functions or null.
   */
  function createChainedFunction(...funcs) {
    return funcs.reduce((acc, func) => {
      if (func == null) {
        return acc;
      }

      return function chainedFunction(...args) {
        acc.apply(this, args);
        func.apply(this, args);
      };
    }, () => {});
  }

  // Corresponds to 10 frames at 60 Hz.
  // A few bytes payload overhead when lodash/debounce is ~3 kB and debounce ~300 B.
  function debounce$1(func, wait = 166) {
    let timeout;

    function debounced(...args) {
      const later = () => {
        func.apply(this, args);
      };

      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
    }

    debounced.clear = () => {
      clearTimeout(timeout);
    };

    return debounced;
  }

  function deprecatedPropType(validator, reason) {

    return (props, propName, componentName, location, propFullName) => {
      const componentNameSafe = componentName || '<<anonymous>>';
      const propFullNameSafe = propFullName || propName;

      if (typeof props[propName] !== 'undefined') {
        return new Error(`The ${location} \`${propFullNameSafe}\` of ` + `\`${componentNameSafe}\` is deprecated. ${reason}`);
      }

      return null;
    };
  }

  function isMuiElement(element, muiNames) {
    return /*#__PURE__*/React__namespace.isValidElement(element) && muiNames.indexOf(element.type.muiName) !== -1;
  }

  function ownerDocument(node) {
    return node && node.ownerDocument || document;
  }

  function ownerWindow(node) {
    const doc = ownerDocument(node);
    return doc.defaultView || window;
  }

  function requirePropFactory(componentNameInError, Component) {


    const prevPropTypes = Component ? _extends({}, Component.propTypes) : null;

    const requireProp = requiredProp => (props, propName, componentName, location, propFullName, ...args) => {
      const propFullNameSafe = propFullName || propName;
      const defaultTypeChecker = prevPropTypes == null ? void 0 : prevPropTypes[propFullNameSafe];

      if (defaultTypeChecker) {
        const typeCheckerResult = defaultTypeChecker(props, propName, componentName, location, propFullName, ...args);

        if (typeCheckerResult) {
          return typeCheckerResult;
        }
      }

      if (typeof props[propName] !== 'undefined' && !props[requiredProp]) {
        return new Error(`The prop \`${propFullNameSafe}\` of ` + `\`${componentNameInError}\` can only be used together with the \`${requiredProp}\` prop.`);
      }

      return null;
    };

    return requireProp;
  }

  /**
   * TODO v5: consider making it private
   *
   * passes {value} to {ref}
   *
   * WARNING: Be sure to only call this inside a callback that is passed as a ref.
   * Otherwise, make sure to cleanup the previous {ref} if it changes. See
   * https://github.com/mui/material-ui/issues/13539
   *
   * Useful if you want to expose the ref of an inner component to the public API
   * while still using it inside the component.
   * @param ref A ref callback or ref object. If anything falsy, this is a no-op.
   */
  function setRef(ref, value) {
    if (typeof ref === 'function') {
      ref(value);
    } else if (ref) {
      ref.current = value;
    }
  }

  const useEnhancedEffect = typeof window !== 'undefined' ? React__namespace.useLayoutEffect : React__namespace.useEffect;
  var useEnhancedEffect$1 = useEnhancedEffect;

  let globalId = 0;

  function useGlobalId(idOverride) {
    const [defaultId, setDefaultId] = React__namespace.useState(idOverride);
    const id = idOverride || defaultId;
    React__namespace.useEffect(() => {
      if (defaultId == null) {
        // Fallback to this default id when possible.
        // Use the incrementing value for client-side rendering only.
        // We can't use it server-side.
        // If you want to use random values please consider the Birthday Problem: https://en.wikipedia.org/wiki/Birthday_problem
        globalId += 1;
        setDefaultId(`mui-${globalId}`);
      }
    }, [defaultId]);
    return id;
  } // eslint-disable-next-line no-useless-concat -- Workaround for https://github.com/webpack/webpack/issues/14814


  const maybeReactUseId = React__namespace['useId' + ''];
  /**
   *
   * @example <div id={useId()} />
   * @param idOverride
   * @returns {string}
   */

  function useId(idOverride) {
    if (maybeReactUseId !== undefined) {
      const reactId = maybeReactUseId();
      return idOverride != null ? idOverride : reactId;
    } // eslint-disable-next-line react-hooks/rules-of-hooks -- `React.useId` is invariant at runtime.


    return useGlobalId(idOverride);
  }

  function unsupportedProp(props, propName, componentName, location, propFullName) {

    const propFullNameSafe = propFullName || propName;

    if (typeof props[propName] !== 'undefined') {
      return new Error(`The prop \`${propFullNameSafe}\` is not supported. Please remove it.`);
    }

    return null;
  }

  function useControlled({
    controlled,
    default: defaultProp,
    name,
    state = 'value'
  }) {
    // isControlled is ignored in the hook dependency lists as it should never change.
    const {
      current: isControlled
    } = React__namespace.useRef(controlled !== undefined);
    const [valueState, setValue] = React__namespace.useState(defaultProp);
    const value = isControlled ? controlled : valueState;

    {
      React__namespace.useEffect(() => {
        if (isControlled !== (controlled !== undefined)) {
          console.error([`MUI: A component is changing the ${isControlled ? '' : 'un'}controlled ${state} state of ${name} to be ${isControlled ? 'un' : ''}controlled.`, 'Elements should not switch from uncontrolled to controlled (or vice versa).', `Decide between using a controlled or uncontrolled ${name} ` + 'element for the lifetime of the component.', "The nature of the state is determined during the first render. It's considered controlled if the value is not `undefined`.", 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [state, name, controlled]);
      const {
        current: defaultValue
      } = React__namespace.useRef(defaultProp);
      React__namespace.useEffect(() => {
        if (!isControlled && defaultValue !== defaultProp) {
          console.error([`MUI: A component is changing the default ${state} state of an uncontrolled ${name} after being initialized. ` + `To suppress this warning opt to use a controlled ${name}.`].join('\n'));
        }
      }, [JSON.stringify(defaultProp)]);
    }

    const setValueIfUncontrolled = React__namespace.useCallback(newValue => {
      if (!isControlled) {
        setValue(newValue);
      }
    }, []);
    return [value, setValueIfUncontrolled];
  }

  /**
   * https://github.com/facebook/react/issues/14099#issuecomment-440013892
   */

  function useEventCallback(fn) {
    const ref = React__namespace.useRef(fn);
    useEnhancedEffect$1(() => {
      ref.current = fn;
    });
    return React__namespace.useCallback((...args) => // @ts-expect-error hide `this`
    // tslint:disable-next-line:ban-comma-operator
    (0, ref.current)(...args), []);
  }

  function useForkRef(refA, refB) {
    /**
     * This will create a new function if the ref props change and are defined.
     * This means react will call the old forkRef with `null` and the new forkRef
     * with the ref. Cleanup naturally emerges from this behavior.
     */
    return React__namespace.useMemo(() => {
      if (refA == null && refB == null) {
        return null;
      }

      return refValue => {
        setRef(refA, refValue);
        setRef(refB, refValue);
      };
    }, [refA, refB]);
  }

  // based on https://github.com/WICG/focus-visible/blob/v4.1.5/src/focus-visible.js
  let hadKeyboardEvent = true;
  let hadFocusVisibleRecently = false;
  let hadFocusVisibleRecentlyTimeout;
  const inputTypesWhitelist = {
    text: true,
    search: true,
    url: true,
    tel: true,
    email: true,
    password: true,
    number: true,
    date: true,
    month: true,
    week: true,
    time: true,
    datetime: true,
    'datetime-local': true
  };
  /**
   * Computes whether the given element should automatically trigger the
   * `focus-visible` class being added, i.e. whether it should always match
   * `:focus-visible` when focused.
   * @param {Element} node
   * @returns {boolean}
   */

  function focusTriggersKeyboardModality(node) {
    const {
      type,
      tagName
    } = node;

    if (tagName === 'INPUT' && inputTypesWhitelist[type] && !node.readOnly) {
      return true;
    }

    if (tagName === 'TEXTAREA' && !node.readOnly) {
      return true;
    }

    if (node.isContentEditable) {
      return true;
    }

    return false;
  }
  /**
   * Keep track of our keyboard modality state with `hadKeyboardEvent`.
   * If the most recent user interaction was via the keyboard;
   * and the key press did not include a meta, alt/option, or control key;
   * then the modality is keyboard. Otherwise, the modality is not keyboard.
   * @param {KeyboardEvent} event
   */


  function handleKeyDown(event) {
    if (event.metaKey || event.altKey || event.ctrlKey) {
      return;
    }

    hadKeyboardEvent = true;
  }
  /**
   * If at any point a user clicks with a pointing device, ensure that we change
   * the modality away from keyboard.
   * This avoids the situation where a user presses a key on an already focused
   * element, and then clicks on a different element, focusing it with a
   * pointing device, while we still think we're in keyboard modality.
   */


  function handlePointerDown() {
    hadKeyboardEvent = false;
  }

  function handleVisibilityChange() {
    if (this.visibilityState === 'hidden') {
      // If the tab becomes active again, the browser will handle calling focus
      // on the element (Safari actually calls it twice).
      // If this tab change caused a blur on an element with focus-visible,
      // re-apply the class when the user switches back to the tab.
      if (hadFocusVisibleRecently) {
        hadKeyboardEvent = true;
      }
    }
  }

  function prepare(doc) {
    doc.addEventListener('keydown', handleKeyDown, true);
    doc.addEventListener('mousedown', handlePointerDown, true);
    doc.addEventListener('pointerdown', handlePointerDown, true);
    doc.addEventListener('touchstart', handlePointerDown, true);
    doc.addEventListener('visibilitychange', handleVisibilityChange, true);
  }

  function isFocusVisible(event) {
    const {
      target
    } = event;

    try {
      return target.matches(':focus-visible');
    } catch (error) {// Browsers not implementing :focus-visible will throw a SyntaxError.
      // We use our own heuristic for those browsers.
      // Rethrow might be better if it's not the expected error but do we really
      // want to crash if focus-visible malfunctioned?
    } // No need for validFocusTarget check. The user does that by attaching it to
    // focusable events only.


    return hadKeyboardEvent || focusTriggersKeyboardModality(target);
  }

  function useIsFocusVisible() {
    const ref = React__namespace.useCallback(node => {
      if (node != null) {
        prepare(node.ownerDocument);
      }
    }, []);
    const isFocusVisibleRef = React__namespace.useRef(false);
    /**
     * Should be called if a blur event is fired
     */

    function handleBlurVisible() {
      // checking against potential state variable does not suffice if we focus and blur synchronously.
      // React wouldn't have time to trigger a re-render so `focusVisible` would be stale.
      // Ideally we would adjust `isFocusVisible(event)` to look at `relatedTarget` for blur events.
      // This doesn't work in IE11 due to https://github.com/facebook/react/issues/3751
      // TODO: check again if React releases their internal changes to focus event handling (https://github.com/facebook/react/pull/19186).
      if (isFocusVisibleRef.current) {
        // To detect a tab/window switch, we look for a blur event followed
        // rapidly by a visibility change.
        // If we don't see a visibility change within 100ms, it's probably a
        // regular focus change.
        hadFocusVisibleRecently = true;
        window.clearTimeout(hadFocusVisibleRecentlyTimeout);
        hadFocusVisibleRecentlyTimeout = window.setTimeout(() => {
          hadFocusVisibleRecently = false;
        }, 100);
        isFocusVisibleRef.current = false;
        return true;
      }

      return false;
    }
    /**
     * Should be called if a blur event is fired
     */


    function handleFocusVisible(event) {
      if (isFocusVisible(event)) {
        isFocusVisibleRef.current = true;
        return true;
      }

      return false;
    }

    return {
      isFocusVisibleRef,
      onFocus: handleFocusVisible,
      onBlur: handleBlurVisible,
      ref
    };
  }

  // A change of the browser zoom change the scrollbar size.
  // Credit https://github.com/twbs/bootstrap/blob/488fd8afc535ca3a6ad4dc581f5e89217b6a36ac/js/src/util/scrollbar.js#L14-L18
  function getScrollbarSize(doc) {
    // https://developer.mozilla.org/en-US/docs/Web/API/Window/innerWidth#usage_notes
    const documentWidth = doc.documentElement.clientWidth;
    return Math.abs(window.innerWidth - documentWidth);
  }

  // Source from https://github.com/alitaheri/normalize-scroll-left
  let cachedType;
  /**
   * Based on the jquery plugin https://github.com/othree/jquery.rtl-scroll-type
   *
   * Types of scrollLeft, assuming scrollWidth=100 and direction is rtl.
   *
   * Type             | <- Most Left | Most Right -> | Initial
   * ---------------- | ------------ | ------------- | -------
   * default          | 0            | 100           | 100
   * negative (spec*) | -100         | 0             | 0
   * reverse          | 100          | 0             | 0
   *
   * Edge 85: default
   * Safari 14: negative
   * Chrome 85: negative
   * Firefox 81: negative
   * IE11: reverse
   *
   * spec* https://drafts.csswg.org/cssom-view/#dom-window-scroll
   */

  function detectScrollType() {
    if (cachedType) {
      return cachedType;
    }

    const dummy = document.createElement('div');
    const container = document.createElement('div');
    container.style.width = '10px';
    container.style.height = '1px';
    dummy.appendChild(container);
    dummy.dir = 'rtl';
    dummy.style.fontSize = '14px';
    dummy.style.width = '4px';
    dummy.style.height = '1px';
    dummy.style.position = 'absolute';
    dummy.style.top = '-1000px';
    dummy.style.overflow = 'scroll';
    document.body.appendChild(dummy);
    cachedType = 'reverse';

    if (dummy.scrollLeft > 0) {
      cachedType = 'default';
    } else {
      dummy.scrollLeft = 1;

      if (dummy.scrollLeft === 0) {
        cachedType = 'negative';
      }
    }

    document.body.removeChild(dummy);
    return cachedType;
  } // Based on https://stackoverflow.com/a/24394376

  function getNormalizedScrollLeft(element, direction) {
    const scrollLeft = element.scrollLeft; // Perform the calculations only when direction is rtl to avoid messing up the ltr behavior

    if (direction !== 'rtl') {
      return scrollLeft;
    }

    const type = detectScrollType();

    switch (type) {
      case 'negative':
        return element.scrollWidth - element.clientWidth + scrollLeft;

      case 'reverse':
        return element.scrollWidth - element.clientWidth - scrollLeft;

      default:
        return scrollLeft;
    }
  }

  const usePreviousProps = value => {
    const ref = React__namespace.useRef({});
    React__namespace.useEffect(() => {
      ref.current = value;
    });
    return ref.current;
  };

  var usePreviousProps$1 = usePreviousProps;

  const visuallyHidden = {
    border: 0,
    clip: 'rect(0 0 0 0)',
    height: '1px',
    margin: -1,
    overflow: 'hidden',
    padding: 0,
    position: 'absolute',
    whiteSpace: 'nowrap',
    width: '1px'
  };
  var visuallyHidden$1 = visuallyHidden;

  function getTypeByValue(value) {
    const valueType = typeof value;

    switch (valueType) {
      case 'number':
        if (Number.isNaN(value)) {
          return 'NaN';
        }

        if (!Number.isFinite(value)) {
          return 'Infinity';
        }

        if (value !== Math.floor(value)) {
          return 'float';
        }

        return 'number';

      case 'object':
        if (value === null) {
          return 'null';
        }

        return value.constructor.name;

      default:
        return valueType;
    }
  } // IE 11 support

  function ponyfillIsInteger(x) {
    // eslint-disable-next-line no-restricted-globals
    return typeof x === 'number' && isFinite(x) && Math.floor(x) === x;
  }

  const isInteger = Number.isInteger || ponyfillIsInteger;

  function requiredInteger(props, propName, componentName, location) {
    const propValue = props[propName];

    if (propValue == null || !isInteger(propValue)) {
      const propType = getTypeByValue(propValue);
      return new RangeError(`Invalid ${location} \`${propName}\` of type \`${propType}\` supplied to \`${componentName}\`, expected \`integer\`.`);
    }

    return null;
  }

  function validator(props, propName, ...other) {
    const propValue = props[propName];

    if (propValue === undefined) {
      return null;
    }

    return requiredInteger(props, propName, ...other);
  }

  validator.isRequired = requiredInteger;
  var integerPropType = validator;

  /**
   * Add keys, values of `defaultProps` that does not exist in `props`
   * @param {object} defaultProps
   * @param {object} props
   * @returns {object} resolved props
   */
  function resolveProps(defaultProps, props) {
    const output = _extends({}, props);

    Object.keys(defaultProps).forEach(propName => {
      if (output[propName] === undefined) {
        output[propName] = defaultProps[propName];
      }
    });
    return output;
  }

  function composeClasses(slots, getUtilityClass, classes) {
    const output = {};
    Object.keys(slots).forEach( // `Objet.keys(slots)` can't be wider than `T` because we infer `T` from `slots`.
    // @ts-expect-error https://github.com/microsoft/TypeScript/pull/12253#issuecomment-263132208
    slot => {
      output[slot] = slots[slot].reduce((acc, key) => {
        if (key) {
          if (classes && classes[key]) {
            acc.push(classes[key]);
          }

          acc.push(getUtilityClass(key));
        }

        return acc;
      }, []).join(' ');
    });
    return output;
  }

  const defaultGenerator = componentName => componentName;

  const createClassNameGenerator = () => {
    let generate = defaultGenerator;
    return {
      configure(generator) {
        generate = generator;
      },

      generate(componentName) {
        return generate(componentName);
      },

      reset() {
        generate = defaultGenerator;
      }

    };
  };

  const ClassNameGenerator = createClassNameGenerator();
  var ClassNameGenerator$1 = ClassNameGenerator;

  const globalStateClassesMapping = {
    active: 'Mui-active',
    checked: 'Mui-checked',
    completed: 'Mui-completed',
    disabled: 'Mui-disabled',
    error: 'Mui-error',
    expanded: 'Mui-expanded',
    focused: 'Mui-focused',
    focusVisible: 'Mui-focusVisible',
    required: 'Mui-required',
    selected: 'Mui-selected'
  };
  function generateUtilityClass(componentName, slot) {
    const globalStateClass = globalStateClassesMapping[slot];
    return globalStateClass || `${ClassNameGenerator$1.generate(componentName)}-${slot}`;
  }

  function generateUtilityClasses(componentName, slots) {
    const result = {};
    slots.forEach(slot => {
      result[slot] = generateUtilityClass(componentName, slot);
    });
    return result;
  }

  function merge(acc, item) {
    if (!item) {
      return acc;
    }

    return deepmerge(acc, item, {
      clone: false // No need to clone deep, it's way faster.

    });
  }

  // For instance with the first breakpoint xs: [xs, sm[.

  const values$1 = {
    xs: 0,
    // phone
    sm: 600,
    // tablet
    md: 900,
    // small laptop
    lg: 1200,
    // desktop
    xl: 1536 // large screen

  };
  const defaultBreakpoints = {
    // Sorted ASC by size. That's important.
    // It can't be configured as it's used statically for propTypes.
    keys: ['xs', 'sm', 'md', 'lg', 'xl'],
    up: key => `@media (min-width:${values$1[key]}px)`
  };
  function handleBreakpoints(props, propValue, styleFromPropValue) {
    const theme = props.theme || {};

    if (Array.isArray(propValue)) {
      const themeBreakpoints = theme.breakpoints || defaultBreakpoints;
      return propValue.reduce((acc, item, index) => {
        acc[themeBreakpoints.up(themeBreakpoints.keys[index])] = styleFromPropValue(propValue[index]);
        return acc;
      }, {});
    }

    if (typeof propValue === 'object') {
      const themeBreakpoints = theme.breakpoints || defaultBreakpoints;
      return Object.keys(propValue).reduce((acc, breakpoint) => {
        // key is breakpoint
        if (Object.keys(themeBreakpoints.values || values$1).indexOf(breakpoint) !== -1) {
          const mediaKey = themeBreakpoints.up(breakpoint);
          acc[mediaKey] = styleFromPropValue(propValue[breakpoint], breakpoint);
        } else {
          const cssKey = breakpoint;
          acc[cssKey] = propValue[cssKey];
        }

        return acc;
      }, {});
    }

    const output = styleFromPropValue(propValue);
    return output;
  }

  function createEmptyBreakpointObject(breakpointsInput = {}) {
    var _breakpointsInput$key;

    const breakpointsInOrder = breakpointsInput == null ? void 0 : (_breakpointsInput$key = breakpointsInput.keys) == null ? void 0 : _breakpointsInput$key.reduce((acc, key) => {
      const breakpointStyleKey = breakpointsInput.up(key);
      acc[breakpointStyleKey] = {};
      return acc;
    }, {});
    return breakpointsInOrder || {};
  }
  function removeUnusedBreakpoints(breakpointKeys, style) {
    return breakpointKeys.reduce((acc, key) => {
      const breakpointOutput = acc[key];
      const isBreakpointUnused = !breakpointOutput || Object.keys(breakpointOutput).length === 0;

      if (isBreakpointUnused) {
        delete acc[key];
      }

      return acc;
    }, style);
  }
  // [1,2,3] => {xs: true, sm: true, md: true}
  // {xs: 1, sm: 2, md: 3} => {xs: true, sm: true, md: true}

  function computeBreakpointsBase(breakpointValues, themeBreakpoints) {
    // fixed value
    if (typeof breakpointValues !== 'object') {
      return {};
    }

    const base = {};
    const breakpointsKeys = Object.keys(themeBreakpoints);

    if (Array.isArray(breakpointValues)) {
      breakpointsKeys.forEach((breakpoint, i) => {
        if (i < breakpointValues.length) {
          base[breakpoint] = true;
        }
      });
    } else {
      breakpointsKeys.forEach(breakpoint => {
        if (breakpointValues[breakpoint] != null) {
          base[breakpoint] = true;
        }
      });
    }

    return base;
  }
  function resolveBreakpointValues({
    values: breakpointValues,
    breakpoints: themeBreakpoints,
    base: customBase
  }) {
    const base = customBase || computeBreakpointsBase(breakpointValues, themeBreakpoints);
    const keys = Object.keys(base);

    if (keys.length === 0) {
      return breakpointValues;
    }

    let previous;
    return keys.reduce((acc, breakpoint, i) => {
      if (Array.isArray(breakpointValues)) {
        acc[breakpoint] = breakpointValues[i] != null ? breakpointValues[i] : breakpointValues[previous];
        previous = i;
      } else if (typeof breakpointValues === 'object') {
        acc[breakpoint] = breakpointValues[breakpoint] != null ? breakpointValues[breakpoint] : breakpointValues[previous];
        previous = breakpoint;
      } else {
        acc[breakpoint] = breakpointValues;
      }

      return acc;
    }, {});
  }

  function getPath(obj, path, checkVars = true) {
    if (!path || typeof path !== 'string') {
      return null;
    } // Check if CSS variables are used


    if (obj && obj.vars && checkVars) {
      const val = `vars.${path}`.split('.').reduce((acc, item) => acc && acc[item] ? acc[item] : null, obj);

      if (val != null) {
        return val;
      }
    }

    return path.split('.').reduce((acc, item) => {
      if (acc && acc[item] != null) {
        return acc[item];
      }

      return null;
    }, obj);
  }

  function getValue$1(themeMapping, transform, propValueFinal, userValue = propValueFinal) {
    let value;

    if (typeof themeMapping === 'function') {
      value = themeMapping(propValueFinal);
    } else if (Array.isArray(themeMapping)) {
      value = themeMapping[propValueFinal] || userValue;
    } else {
      value = getPath(themeMapping, propValueFinal) || userValue;
    }

    if (transform) {
      value = transform(value);
    }

    return value;
  }

  function style$2(options) {
    const {
      prop,
      cssProperty = options.prop,
      themeKey,
      transform
    } = options;

    const fn = props => {
      if (props[prop] == null) {
        return null;
      }

      const propValue = props[prop];
      const theme = props.theme;
      const themeMapping = getPath(theme, themeKey) || {};

      const styleFromPropValue = propValueFinal => {
        let value = getValue$1(themeMapping, transform, propValueFinal);

        if (propValueFinal === value && typeof propValueFinal === 'string') {
          // Haven't found value
          value = getValue$1(themeMapping, transform, `${prop}${propValueFinal === 'default' ? '' : capitalize(propValueFinal)}`, propValueFinal);
        }

        if (cssProperty === false) {
          return value;
        }

        return {
          [cssProperty]: value
        };
      };

      return handleBreakpoints(props, propValue, styleFromPropValue);
    };

    fn.propTypes = {
      [prop]: responsivePropType$1
    } ;
    fn.filterProps = [prop];
    return fn;
  }

  function compose(...styles) {
    const handlers = styles.reduce((acc, style) => {
      style.filterProps.forEach(prop => {
        acc[prop] = style;
      });
      return acc;
    }, {});

    const fn = props => {
      return Object.keys(props).reduce((acc, prop) => {
        if (handlers[prop]) {
          return merge(acc, handlers[prop](props));
        }

        return acc;
      }, {});
    };

    fn.propTypes = styles.reduce((acc, style) => Object.assign(acc, style.propTypes), {}) ;
    fn.filterProps = styles.reduce((acc, style) => acc.concat(style.filterProps), []);
    return fn;
  }

  function memoize(fn) {
    const cache = {};
    return arg => {
      if (cache[arg] === undefined) {
        cache[arg] = fn(arg);
      }

      return cache[arg];
    };
  }

  const properties = {
    m: 'margin',
    p: 'padding'
  };
  const directions = {
    t: 'Top',
    r: 'Right',
    b: 'Bottom',
    l: 'Left',
    x: ['Left', 'Right'],
    y: ['Top', 'Bottom']
  };
  const aliases = {
    marginX: 'mx',
    marginY: 'my',
    paddingX: 'px',
    paddingY: 'py'
  }; // memoize() impact:
  // From 300,000 ops/sec
  // To 350,000 ops/sec

  const getCssProperties = memoize(prop => {
    // It's not a shorthand notation.
    if (prop.length > 2) {
      if (aliases[prop]) {
        prop = aliases[prop];
      } else {
        return [prop];
      }
    }

    const [a, b] = prop.split('');
    const property = properties[a];
    const direction = directions[b] || '';
    return Array.isArray(direction) ? direction.map(dir => property + dir) : [property + direction];
  });
  const marginKeys = ['m', 'mt', 'mr', 'mb', 'ml', 'mx', 'my', 'margin', 'marginTop', 'marginRight', 'marginBottom', 'marginLeft', 'marginX', 'marginY', 'marginInline', 'marginInlineStart', 'marginInlineEnd', 'marginBlock', 'marginBlockStart', 'marginBlockEnd'];
  const paddingKeys = ['p', 'pt', 'pr', 'pb', 'pl', 'px', 'py', 'padding', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft', 'paddingX', 'paddingY', 'paddingInline', 'paddingInlineStart', 'paddingInlineEnd', 'paddingBlock', 'paddingBlockStart', 'paddingBlockEnd'];
  const spacingKeys = [...marginKeys, ...paddingKeys];
  function createUnaryUnit(theme, themeKey, defaultValue, propName) {
    var _getPath;

    const themeSpacing = (_getPath = getPath(theme, themeKey, false)) != null ? _getPath : defaultValue;

    if (typeof themeSpacing === 'number') {
      return abs => {
        if (typeof abs === 'string') {
          return abs;
        }

        {
          if (typeof abs !== 'number') {
            console.error(`MUI: Expected ${propName} argument to be a number or a string, got ${abs}.`);
          }
        }

        return themeSpacing * abs;
      };
    }

    if (Array.isArray(themeSpacing)) {
      return abs => {
        if (typeof abs === 'string') {
          return abs;
        }

        {
          if (!Number.isInteger(abs)) {
            console.error([`MUI: The \`theme.${themeKey}\` array type cannot be combined with non integer values.` + `You should either use an integer value that can be used as index, or define the \`theme.${themeKey}\` as a number.`].join('\n'));
          } else if (abs > themeSpacing.length - 1) {
            console.error([`MUI: The value provided (${abs}) overflows.`, `The supported values are: ${JSON.stringify(themeSpacing)}.`, `${abs} > ${themeSpacing.length - 1}, you need to add the missing values.`].join('\n'));
          }
        }

        return themeSpacing[abs];
      };
    }

    if (typeof themeSpacing === 'function') {
      return themeSpacing;
    }

    {
      console.error([`MUI: The \`theme.${themeKey}\` value (${themeSpacing}) is invalid.`, 'It should be a number, an array or a function.'].join('\n'));
    }

    return () => undefined;
  }
  function createUnarySpacing(theme) {
    return createUnaryUnit(theme, 'spacing', 8, 'spacing');
  }
  function getValue(transformer, propValue) {
    if (typeof propValue === 'string' || propValue == null) {
      return propValue;
    }

    const abs = Math.abs(propValue);
    const transformed = transformer(abs);

    if (propValue >= 0) {
      return transformed;
    }

    if (typeof transformed === 'number') {
      return -transformed;
    }

    return `-${transformed}`;
  }
  function getStyleFromPropValue(cssProperties, transformer) {
    return propValue => cssProperties.reduce((acc, cssProperty) => {
      acc[cssProperty] = getValue(transformer, propValue);
      return acc;
    }, {});
  }

  function resolveCssProperty(props, keys, prop, transformer) {
    // Using a hash computation over an array iteration could be faster, but with only 28 items,
    // it's doesn't worth the bundle size.
    if (keys.indexOf(prop) === -1) {
      return null;
    }

    const cssProperties = getCssProperties(prop);
    const styleFromPropValue = getStyleFromPropValue(cssProperties, transformer);
    const propValue = props[prop];
    return handleBreakpoints(props, propValue, styleFromPropValue);
  }

  function style$1(props, keys) {
    const transformer = createUnarySpacing(props.theme);
    return Object.keys(props).map(prop => resolveCssProperty(props, keys, prop, transformer)).reduce(merge, {});
  }
  marginKeys.reduce((obj, key) => {
    obj[key] = responsivePropType$1;
    return obj;
  }, {}) ;
  paddingKeys.reduce((obj, key) => {
    obj[key] = responsivePropType$1;
    return obj;
  }, {}) ;

  function spacing(props) {
    return style$1(props, spacingKeys);
  }

  spacing.propTypes = spacingKeys.reduce((obj, key) => {
    obj[key] = responsivePropType$1;
    return obj;
  }, {}) ;
  spacing.filterProps = spacingKeys;

  function getBorder(value) {
    if (typeof value !== 'number') {
      return value;
    }

    return `${value}px solid`;
  }

  const border = style$2({
    prop: 'border',
    themeKey: 'borders',
    transform: getBorder
  });
  const borderTop = style$2({
    prop: 'borderTop',
    themeKey: 'borders',
    transform: getBorder
  });
  const borderRight = style$2({
    prop: 'borderRight',
    themeKey: 'borders',
    transform: getBorder
  });
  const borderBottom = style$2({
    prop: 'borderBottom',
    themeKey: 'borders',
    transform: getBorder
  });
  const borderLeft = style$2({
    prop: 'borderLeft',
    themeKey: 'borders',
    transform: getBorder
  });
  const borderColor = style$2({
    prop: 'borderColor',
    themeKey: 'palette'
  });
  const borderTopColor = style$2({
    prop: 'borderTopColor',
    themeKey: 'palette'
  });
  const borderRightColor = style$2({
    prop: 'borderRightColor',
    themeKey: 'palette'
  });
  const borderBottomColor = style$2({
    prop: 'borderBottomColor',
    themeKey: 'palette'
  });
  const borderLeftColor = style$2({
    prop: 'borderLeftColor',
    themeKey: 'palette'
  });
  const borderRadius = props => {
    if (props.borderRadius !== undefined && props.borderRadius !== null) {
      const transformer = createUnaryUnit(props.theme, 'shape.borderRadius', 4, 'borderRadius');

      const styleFromPropValue = propValue => ({
        borderRadius: getValue(transformer, propValue)
      });

      return handleBreakpoints(props, props.borderRadius, styleFromPropValue);
    }

    return null;
  };
  borderRadius.propTypes = {
    borderRadius: responsivePropType$1
  } ;
  borderRadius.filterProps = ['borderRadius'];
  const borders = compose(border, borderTop, borderRight, borderBottom, borderLeft, borderColor, borderTopColor, borderRightColor, borderBottomColor, borderLeftColor, borderRadius);
  var borders$1 = borders;

  const displayPrint = style$2({
    prop: 'displayPrint',
    cssProperty: false,
    transform: value => ({
      '@media print': {
        display: value
      }
    })
  });
  const displayRaw = style$2({
    prop: 'display'
  });
  const overflow = style$2({
    prop: 'overflow'
  });
  const textOverflow = style$2({
    prop: 'textOverflow'
  });
  const visibility = style$2({
    prop: 'visibility'
  });
  const whiteSpace = style$2({
    prop: 'whiteSpace'
  });
  var display = compose(displayPrint, displayRaw, overflow, textOverflow, visibility, whiteSpace);

  const flexBasis = style$2({
    prop: 'flexBasis'
  });
  const flexDirection = style$2({
    prop: 'flexDirection'
  });
  const flexWrap = style$2({
    prop: 'flexWrap'
  });
  const justifyContent = style$2({
    prop: 'justifyContent'
  });
  const alignItems = style$2({
    prop: 'alignItems'
  });
  const alignContent = style$2({
    prop: 'alignContent'
  });
  const order$1 = style$2({
    prop: 'order'
  });
  const flex = style$2({
    prop: 'flex'
  });
  const flexGrow = style$2({
    prop: 'flexGrow'
  });
  const flexShrink = style$2({
    prop: 'flexShrink'
  });
  const alignSelf = style$2({
    prop: 'alignSelf'
  });
  const justifyItems = style$2({
    prop: 'justifyItems'
  });
  const justifySelf = style$2({
    prop: 'justifySelf'
  });
  const flexbox = compose(flexBasis, flexDirection, flexWrap, justifyContent, alignItems, alignContent, order$1, flex, flexGrow, flexShrink, alignSelf, justifyItems, justifySelf);
  var flexbox$1 = flexbox;

  const gap = props => {
    if (props.gap !== undefined && props.gap !== null) {
      const transformer = createUnaryUnit(props.theme, 'spacing', 8, 'gap');

      const styleFromPropValue = propValue => ({
        gap: getValue(transformer, propValue)
      });

      return handleBreakpoints(props, props.gap, styleFromPropValue);
    }

    return null;
  };
  gap.propTypes = {
    gap: responsivePropType$1
  } ;
  gap.filterProps = ['gap'];
  const columnGap = props => {
    if (props.columnGap !== undefined && props.columnGap !== null) {
      const transformer = createUnaryUnit(props.theme, 'spacing', 8, 'columnGap');

      const styleFromPropValue = propValue => ({
        columnGap: getValue(transformer, propValue)
      });

      return handleBreakpoints(props, props.columnGap, styleFromPropValue);
    }

    return null;
  };
  columnGap.propTypes = {
    columnGap: responsivePropType$1
  } ;
  columnGap.filterProps = ['columnGap'];
  const rowGap = props => {
    if (props.rowGap !== undefined && props.rowGap !== null) {
      const transformer = createUnaryUnit(props.theme, 'spacing', 8, 'rowGap');

      const styleFromPropValue = propValue => ({
        rowGap: getValue(transformer, propValue)
      });

      return handleBreakpoints(props, props.rowGap, styleFromPropValue);
    }

    return null;
  };
  rowGap.propTypes = {
    rowGap: responsivePropType$1
  } ;
  rowGap.filterProps = ['rowGap'];
  const gridColumn = style$2({
    prop: 'gridColumn'
  });
  const gridRow = style$2({
    prop: 'gridRow'
  });
  const gridAutoFlow = style$2({
    prop: 'gridAutoFlow'
  });
  const gridAutoColumns = style$2({
    prop: 'gridAutoColumns'
  });
  const gridAutoRows = style$2({
    prop: 'gridAutoRows'
  });
  const gridTemplateColumns = style$2({
    prop: 'gridTemplateColumns'
  });
  const gridTemplateRows = style$2({
    prop: 'gridTemplateRows'
  });
  const gridTemplateAreas = style$2({
    prop: 'gridTemplateAreas'
  });
  const gridArea = style$2({
    prop: 'gridArea'
  });
  const grid = compose(gap, columnGap, rowGap, gridColumn, gridRow, gridAutoFlow, gridAutoColumns, gridAutoRows, gridTemplateColumns, gridTemplateRows, gridTemplateAreas, gridArea);
  var grid$1 = grid;

  const color = style$2({
    prop: 'color',
    themeKey: 'palette'
  });
  const bgcolor = style$2({
    prop: 'bgcolor',
    cssProperty: 'backgroundColor',
    themeKey: 'palette'
  });
  const backgroundColor = style$2({
    prop: 'backgroundColor',
    themeKey: 'palette'
  });
  const palette = compose(color, bgcolor, backgroundColor);
  var palette$1 = palette;

  const position = style$2({
    prop: 'position'
  });
  const zIndex$2 = style$2({
    prop: 'zIndex',
    themeKey: 'zIndex'
  });
  const top$1 = style$2({
    prop: 'top'
  });
  const right$1 = style$2({
    prop: 'right'
  });
  const bottom$1 = style$2({
    prop: 'bottom'
  });
  const left$1 = style$2({
    prop: 'left'
  });
  var positions = compose(position, zIndex$2, top$1, right$1, bottom$1, left$1);

  const boxShadow = style$2({
    prop: 'boxShadow',
    themeKey: 'shadows'
  });
  var shadows$2 = boxShadow;

  function transform(value) {
    return value <= 1 && value !== 0 ? `${value * 100}%` : value;
  }

  const width = style$2({
    prop: 'width',
    transform
  });
  const maxWidth = props => {
    if (props.maxWidth !== undefined && props.maxWidth !== null) {
      const styleFromPropValue = propValue => {
        var _props$theme, _props$theme$breakpoi, _props$theme$breakpoi2;

        const breakpoint = ((_props$theme = props.theme) == null ? void 0 : (_props$theme$breakpoi = _props$theme.breakpoints) == null ? void 0 : (_props$theme$breakpoi2 = _props$theme$breakpoi.values) == null ? void 0 : _props$theme$breakpoi2[propValue]) || values$1[propValue];
        return {
          maxWidth: breakpoint || transform(propValue)
        };
      };

      return handleBreakpoints(props, props.maxWidth, styleFromPropValue);
    }

    return null;
  };
  maxWidth.filterProps = ['maxWidth'];
  const minWidth = style$2({
    prop: 'minWidth',
    transform
  });
  const height = style$2({
    prop: 'height',
    transform
  });
  const maxHeight = style$2({
    prop: 'maxHeight',
    transform
  });
  const minHeight = style$2({
    prop: 'minHeight',
    transform
  });
  style$2({
    prop: 'size',
    cssProperty: 'width',
    transform
  });
  style$2({
    prop: 'size',
    cssProperty: 'height',
    transform
  });
  const boxSizing = style$2({
    prop: 'boxSizing'
  });
  const sizing = compose(width, maxWidth, minWidth, height, maxHeight, minHeight, boxSizing);
  var sizing$1 = sizing;

  const fontFamily = style$2({
    prop: 'fontFamily',
    themeKey: 'typography'
  });
  const fontSize = style$2({
    prop: 'fontSize',
    themeKey: 'typography'
  });
  const fontStyle = style$2({
    prop: 'fontStyle',
    themeKey: 'typography'
  });
  const fontWeight = style$2({
    prop: 'fontWeight',
    themeKey: 'typography'
  });
  const letterSpacing = style$2({
    prop: 'letterSpacing'
  });
  const textTransform = style$2({
    prop: 'textTransform'
  });
  const lineHeight = style$2({
    prop: 'lineHeight'
  });
  const textAlign = style$2({
    prop: 'textAlign'
  });
  const typographyVariant = style$2({
    prop: 'typography',
    cssProperty: false,
    themeKey: 'typography'
  });
  const typography = compose(typographyVariant, fontFamily, fontSize, fontStyle, fontWeight, letterSpacing, lineHeight, textAlign, textTransform);
  var typography$1 = typography;

  const filterPropsMapping = {
    borders: borders$1.filterProps,
    display: display.filterProps,
    flexbox: flexbox$1.filterProps,
    grid: grid$1.filterProps,
    positions: positions.filterProps,
    palette: palette$1.filterProps,
    shadows: shadows$2.filterProps,
    sizing: sizing$1.filterProps,
    spacing: spacing.filterProps,
    typography: typography$1.filterProps
  };
  const styleFunctionMapping = {
    borders: borders$1,
    display,
    flexbox: flexbox$1,
    grid: grid$1,
    positions,
    palette: palette$1,
    shadows: shadows$2,
    sizing: sizing$1,
    spacing,
    typography: typography$1
  };
  const propToStyleFunction = Object.keys(filterPropsMapping).reduce((acc, styleFnName) => {
    filterPropsMapping[styleFnName].forEach(propName => {
      acc[propName] = styleFunctionMapping[styleFnName];
    });
    return acc;
  }, {});

  function objectsHaveSameKeys(...objects) {
    const allKeys = objects.reduce((keys, object) => keys.concat(Object.keys(object)), []);
    const union = new Set(allKeys);
    return objects.every(object => union.size === Object.keys(object).length);
  }

  function callIfFn(maybeFn, arg) {
    return typeof maybeFn === 'function' ? maybeFn(arg) : maybeFn;
  } // eslint-disable-next-line @typescript-eslint/naming-convention


  function unstable_createStyleFunctionSx(styleFunctionMapping$1 = styleFunctionMapping) {
    const propToStyleFunction = Object.keys(styleFunctionMapping$1).reduce((acc, styleFnName) => {
      styleFunctionMapping$1[styleFnName].filterProps.forEach(propName => {
        acc[propName] = styleFunctionMapping$1[styleFnName];
      });
      return acc;
    }, {});

    function getThemeValue(prop, value, theme) {
      const inputProps = {
        [prop]: value,
        theme
      };
      const styleFunction = propToStyleFunction[prop];
      return styleFunction ? styleFunction(inputProps) : {
        [prop]: value
      };
    }

    function styleFunctionSx(props) {
      const {
        sx,
        theme = {}
      } = props || {};

      if (!sx) {
        return null; // Emotion & styled-components will neglect null
      }
      /*
       * Receive `sxInput` as object or callback
       * and then recursively check keys & values to create media query object styles.
       * (the result will be used in `styled`)
       */


      function traverse(sxInput) {
        let sxObject = sxInput;

        if (typeof sxInput === 'function') {
          sxObject = sxInput(theme);
        } else if (typeof sxInput !== 'object') {
          // value
          return sxInput;
        }

        if (!sxObject) {
          return null;
        }

        const emptyBreakpoints = createEmptyBreakpointObject(theme.breakpoints);
        const breakpointsKeys = Object.keys(emptyBreakpoints);
        let css = emptyBreakpoints;
        Object.keys(sxObject).forEach(styleKey => {
          const value = callIfFn(sxObject[styleKey], theme);

          if (value !== null && value !== undefined) {
            if (typeof value === 'object') {
              if (propToStyleFunction[styleKey]) {
                css = merge(css, getThemeValue(styleKey, value, theme));
              } else {
                const breakpointsValues = handleBreakpoints({
                  theme
                }, value, x => ({
                  [styleKey]: x
                }));

                if (objectsHaveSameKeys(breakpointsValues, value)) {
                  css[styleKey] = styleFunctionSx({
                    sx: value,
                    theme
                  });
                } else {
                  css = merge(css, breakpointsValues);
                }
              }
            } else {
              css = merge(css, getThemeValue(styleKey, value, theme));
            }
          }
        });
        return removeUnusedBreakpoints(breakpointsKeys, css);
      }

      return Array.isArray(sx) ? sx.map(traverse) : traverse(sx);
    }

    return styleFunctionSx;
  }
  const styleFunctionSx = unstable_createStyleFunctionSx();
  styleFunctionSx.filterProps = ['sx'];
  var defaultStyleFunctionSx = styleFunctionSx;

  const _excluded$2m = ["sx"];

  const splitProps = props => {
    const result = {
      systemProps: {},
      otherProps: {}
    };
    Object.keys(props).forEach(prop => {
      if (propToStyleFunction[prop]) {
        result.systemProps[prop] = props[prop];
      } else {
        result.otherProps[prop] = props[prop];
      }
    });
    return result;
  };

  function extendSxProp(props) {
    const {
      sx: inSx
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$2m);

    const {
      systemProps,
      otherProps
    } = splitProps(other);
    let finalSx;

    if (Array.isArray(inSx)) {
      finalSx = [systemProps, ...inSx];
    } else if (typeof inSx === 'function') {
      finalSx = (...args) => {
        const result = inSx(...args);

        if (!isPlainObject(result)) {
          return systemProps;
        }

        return _extends({}, systemProps, result);
      };
    } else {
      finalSx = _extends({}, systemProps, inSx);
    }

    return _extends({}, otherProps, {
      sx: finalSx
    });
  }

  function sx(styles) {
    return ({
      theme
    }) => defaultStyleFunctionSx({
      sx: styles,
      theme
    });
  }

  function toVal(mix) {
  	var k, y, str='';

  	if (typeof mix === 'string' || typeof mix === 'number') {
  		str += mix;
  	} else if (typeof mix === 'object') {
  		if (Array.isArray(mix)) {
  			for (k=0; k < mix.length; k++) {
  				if (mix[k]) {
  					if (y = toVal(mix[k])) {
  						str && (str += ' ');
  						str += y;
  					}
  				}
  			}
  		} else {
  			for (k in mix) {
  				if (mix[k]) {
  					str && (str += ' ');
  					str += k;
  				}
  			}
  		}
  	}

  	return str;
  }

  function clsx () {
  	var i=0, tmp, x, str='';
  	while (i < arguments.length) {
  		if (tmp = arguments[i++]) {
  			if (x = toVal(tmp)) {
  				str && (str += ' ');
  				str += x;
  			}
  		}
  	}
  	return str;
  }

  const _excluded$2l = ["values", "unit", "step"];

  const sortBreakpointsValues = values => {
    const breakpointsAsArray = Object.keys(values).map(key => ({
      key,
      val: values[key]
    })) || []; // Sort in ascending order

    breakpointsAsArray.sort((breakpoint1, breakpoint2) => breakpoint1.val - breakpoint2.val);
    return breakpointsAsArray.reduce((acc, obj) => {
      return _extends({}, acc, {
        [obj.key]: obj.val
      });
    }, {});
  }; // Keep in mind that @media is inclusive by the CSS specification.


  function createBreakpoints(breakpoints) {
    const {
      // The breakpoint **start** at this value.
      // For instance with the first breakpoint xs: [xs, sm).
      values = {
        xs: 0,
        // phone
        sm: 600,
        // tablet
        md: 900,
        // small laptop
        lg: 1200,
        // desktop
        xl: 1536 // large screen

      },
      unit = 'px',
      step = 5
    } = breakpoints,
          other = _objectWithoutPropertiesLoose(breakpoints, _excluded$2l);

    const sortedValues = sortBreakpointsValues(values);
    const keys = Object.keys(sortedValues);

    function up(key) {
      const value = typeof values[key] === 'number' ? values[key] : key;
      return `@media (min-width:${value}${unit})`;
    }

    function down(key) {
      const value = typeof values[key] === 'number' ? values[key] : key;
      return `@media (max-width:${value - step / 100}${unit})`;
    }

    function between(start, end) {
      const endIndex = keys.indexOf(end);
      return `@media (min-width:${typeof values[start] === 'number' ? values[start] : start}${unit}) and ` + `(max-width:${(endIndex !== -1 && typeof values[keys[endIndex]] === 'number' ? values[keys[endIndex]] : end) - step / 100}${unit})`;
    }

    function only(key) {
      if (keys.indexOf(key) + 1 < keys.length) {
        return between(key, keys[keys.indexOf(key) + 1]);
      }

      return up(key);
    }

    function not(key) {
      // handle first and last key separately, for better readability
      const keyIndex = keys.indexOf(key);

      if (keyIndex === 0) {
        return up(keys[1]);
      }

      if (keyIndex === keys.length - 1) {
        return down(keys[keyIndex]);
      }

      return between(key, keys[keys.indexOf(key) + 1]).replace('@media', '@media not all and');
    }

    return _extends({
      keys,
      values: sortedValues,
      up,
      down,
      between,
      only,
      not,
      unit
    }, other);
  }

  const shape = {
    borderRadius: 4
  };
  var shape$1 = shape;

  /* tslint:enable:unified-signatures */
  function createSpacing(spacingInput = 8) {
    // Already transformed.
    if (spacingInput.mui) {
      return spacingInput;
    } // Material Design layouts are visually balanced. Most measurements align to an 8dp grid, which aligns both spacing and the overall layout.
    // Smaller components, such as icons, can align to a 4dp grid.
    // https://material.io/design/layout/understanding-layout.html#usage


    const transform = createUnarySpacing({
      spacing: spacingInput
    });

    const spacing = (...argsInput) => {
      {
        if (!(argsInput.length <= 4)) {
          console.error(`MUI: Too many arguments provided, expected between 0 and 4, got ${argsInput.length}`);
        }
      }

      const args = argsInput.length === 0 ? [1] : argsInput;
      return args.map(argument => {
        const output = transform(argument);
        return typeof output === 'number' ? `${output}px` : output;
      }).join(' ');
    };

    spacing.mui = true;
    return spacing;
  }

  const _excluded$2k = ["breakpoints", "palette", "spacing", "shape"];

  function createTheme$1(options = {}, ...args) {
    const {
      breakpoints: breakpointsInput = {},
      palette: paletteInput = {},
      spacing: spacingInput,
      shape: shapeInput = {}
    } = options,
          other = _objectWithoutPropertiesLoose(options, _excluded$2k);

    const breakpoints = createBreakpoints(breakpointsInput);
    const spacing = createSpacing(spacingInput);
    let muiTheme = deepmerge({
      breakpoints,
      direction: 'ltr',
      components: {},
      // Inject component definitions.
      palette: _extends({
        mode: 'light'
      }, paletteInput),
      spacing,
      shape: _extends({}, shape$1, shapeInput)
    }, other);
    muiTheme = args.reduce((acc, argument) => deepmerge(acc, argument), muiTheme);
    return muiTheme;
  }

  const ThemeContext = /*#__PURE__*/React__namespace.createContext(null);

  {
    ThemeContext.displayName = 'ThemeContext';
  }

  var ThemeContext$1 = ThemeContext;

  function useTheme$3() {
    const theme = React__namespace.useContext(ThemeContext$1);

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useDebugValue(theme);
    }

    return theme;
  }

  const hasSymbol = typeof Symbol === 'function' && Symbol.for;
  var nested = hasSymbol ? Symbol.for('mui.nested') : '__THEME_NESTED__';

  function mergeOuterLocalTheme(outerTheme, localTheme) {
    if (typeof localTheme === 'function') {
      const mergedTheme = localTheme(outerTheme);

      {
        if (!mergedTheme) {
          console.error(['MUI: You should return an object from your theme function, i.e.', '<ThemeProvider theme={() => ({})} />'].join('\n'));
        }
      }

      return mergedTheme;
    }

    return _extends({}, outerTheme, localTheme);
  }
  /**
   * This component takes a `theme` prop.
   * It makes the `theme` available down the React tree thanks to React context.
   * This component should preferably be used at **the root of your component tree**.
   */


  function ThemeProvider$1(props) {
    const {
      children,
      theme: localTheme
    } = props;
    const outerTheme = useTheme$3();

    {
      if (outerTheme === null && typeof localTheme === 'function') {
        console.error(['MUI: You are providing a theme function prop to the ThemeProvider component:', '<ThemeProvider theme={outerTheme => outerTheme} />', '', 'However, no outer theme is present.', 'Make sure a theme is already injected higher in the React tree ' + 'or provide a theme object.'].join('\n'));
      }
    }

    const theme = React__namespace.useMemo(() => {
      const output = outerTheme === null ? localTheme : mergeOuterLocalTheme(outerTheme, localTheme);

      if (output != null) {
        output[nested] = outerTheme !== null;
      }

      return output;
    }, [localTheme, outerTheme]);
    return /*#__PURE__*/jsxRuntime_1(ThemeContext$1.Provider, {
      value: theme,
      children: children
    });
  }

  ThemeProvider$1.propTypes = {
    /**
     * Your component tree.
     */
    children: PropTypes.node,

    /**
     * A theme object. You can provide a function to extend the outer theme.
     */
    theme: PropTypes.oneOfType([PropTypes.object, PropTypes.func]).isRequired
  } ;

  {
    ThemeProvider$1.propTypes = exactProp(ThemeProvider$1.propTypes) ;
  }

  function isObjectEmpty(obj) {
    return Object.keys(obj).length === 0;
  }

  function useTheme$2(defaultTheme = null) {
    const contextTheme = useTheme$3();
    return !contextTheme || isObjectEmpty(contextTheme) ? defaultTheme : contextTheme;
  }

  const systemDefaultTheme$1 = createTheme$1();

  function useTheme$1(defaultTheme = systemDefaultTheme$1) {
    return useTheme$2(defaultTheme);
  }

  const _excluded$2j = ["className", "component"];
  function createBox(options = {}) {
    const {
      defaultTheme,
      defaultClassName = 'MuiBox-root',
      generateClassName,
      styleFunctionSx = defaultStyleFunctionSx
    } = options;
    const BoxRoot = styled$3('div')(styleFunctionSx);
    const Box = /*#__PURE__*/React__namespace.forwardRef(function Box(inProps, ref) {
      const theme = useTheme$1(defaultTheme);

      const _extendSxProp = extendSxProp(inProps),
            {
        className,
        component = 'div'
      } = _extendSxProp,
            other = _objectWithoutPropertiesLoose(_extendSxProp, _excluded$2j);

      return /*#__PURE__*/jsxRuntime_1(BoxRoot, _extends({
        as: component,
        ref: ref,
        className: clsx(className, generateClassName ? generateClassName(defaultClassName) : defaultClassName),
        theme: theme
      }, other));
    });
    return Box;
  }

  const _excluded$2i = ["variant"];

  function isEmpty$2(string) {
    return string.length === 0;
  }
  /**
   * Generates string classKey based on the properties provided. It starts with the
   * variant if defined, and then it appends all other properties in alphabetical order.
   * @param {object} props - the properties for which the classKey should be created.
   */


  function propsToClassKey(props) {
    const {
      variant
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$2i);

    let classKey = variant || '';
    Object.keys(other).sort().forEach(key => {
      if (key === 'color') {
        classKey += isEmpty$2(classKey) ? props[key] : capitalize(props[key]);
      } else {
        classKey += `${isEmpty$2(classKey) ? key : capitalize(key)}${capitalize(props[key].toString())}`;
      }
    });
    return classKey;
  }

  const _excluded$2h = ["name", "slot", "skipVariantsResolver", "skipSx", "overridesResolver"],
        _excluded2$c = ["theme"],
        _excluded3$1 = ["theme"];

  function isEmpty$1(obj) {
    return Object.keys(obj).length === 0;
  }

  const getStyleOverrides = (name, theme) => {
    if (theme.components && theme.components[name] && theme.components[name].styleOverrides) {
      return theme.components[name].styleOverrides;
    }

    return null;
  };

  const getVariantStyles = (name, theme) => {
    let variants = [];

    if (theme && theme.components && theme.components[name] && theme.components[name].variants) {
      variants = theme.components[name].variants;
    }

    const variantsStyles = {};
    variants.forEach(definition => {
      const key = propsToClassKey(definition.props);
      variantsStyles[key] = definition.style;
    });
    return variantsStyles;
  };

  const variantsResolver = (props, styles, theme, name) => {
    var _theme$components, _theme$components$nam;

    const {
      ownerState = {}
    } = props;
    const variantsStyles = [];
    const themeVariants = theme == null ? void 0 : (_theme$components = theme.components) == null ? void 0 : (_theme$components$nam = _theme$components[name]) == null ? void 0 : _theme$components$nam.variants;

    if (themeVariants) {
      themeVariants.forEach(themeVariant => {
        let isMatch = true;
        Object.keys(themeVariant.props).forEach(key => {
          if (ownerState[key] !== themeVariant.props[key] && props[key] !== themeVariant.props[key]) {
            isMatch = false;
          }
        });

        if (isMatch) {
          variantsStyles.push(styles[propsToClassKey(themeVariant.props)]);
        }
      });
    }

    return variantsStyles;
  }; // Update /system/styled/#api in case if this changes


  function shouldForwardProp(prop) {
    return prop !== 'ownerState' && prop !== 'theme' && prop !== 'sx' && prop !== 'as';
  }
  const systemDefaultTheme = createTheme$1();

  const lowercaseFirstLetter = string => {
    return string.charAt(0).toLowerCase() + string.slice(1);
  };

  function createStyled(input = {}) {
    const {
      defaultTheme = systemDefaultTheme,
      rootShouldForwardProp = shouldForwardProp,
      slotShouldForwardProp = shouldForwardProp,
      styleFunctionSx = defaultStyleFunctionSx
    } = input;
    return (tag, inputOptions = {}) => {
      const {
        name: componentName,
        slot: componentSlot,
        skipVariantsResolver: inputSkipVariantsResolver,
        skipSx: inputSkipSx,
        overridesResolver
      } = inputOptions,
            options = _objectWithoutPropertiesLoose(inputOptions, _excluded$2h); // if skipVariantsResolver option is defined, take the value, otherwise, true for root and false for other slots.


      const skipVariantsResolver = inputSkipVariantsResolver !== undefined ? inputSkipVariantsResolver : componentSlot && componentSlot !== 'Root' || false;
      const skipSx = inputSkipSx || false;
      let label;

      {
        if (componentName) {
          label = `${componentName}-${lowercaseFirstLetter(componentSlot || 'Root')}`;
        }
      }

      let shouldForwardPropOption = shouldForwardProp;

      if (componentSlot === 'Root') {
        shouldForwardPropOption = rootShouldForwardProp;
      } else if (componentSlot) {
        // any other slot specified
        shouldForwardPropOption = slotShouldForwardProp;
      }

      const defaultStyledResolver = styled$3(tag, _extends({
        shouldForwardProp: shouldForwardPropOption,
        label
      }, options));

      const muiStyledResolver = (styleArg, ...expressions) => {
        const expressionsWithDefaultTheme = expressions ? expressions.map(stylesArg => {
          // On the server Emotion doesn't use React.forwardRef for creating components, so the created
          // component stays as a function. This condition makes sure that we do not interpolate functions
          // which are basically components used as a selectors.
          // eslint-disable-next-line no-underscore-dangle
          return typeof stylesArg === 'function' && stylesArg.__emotion_real !== stylesArg ? _ref => {
            let {
              theme: themeInput
            } = _ref,
                other = _objectWithoutPropertiesLoose(_ref, _excluded2$c);

            return stylesArg(_extends({
              theme: isEmpty$1(themeInput) ? defaultTheme : themeInput
            }, other));
          } : stylesArg;
        }) : [];
        let transformedStyleArg = styleArg;

        if (componentName && overridesResolver) {
          expressionsWithDefaultTheme.push(props => {
            const theme = isEmpty$1(props.theme) ? defaultTheme : props.theme;
            const styleOverrides = getStyleOverrides(componentName, theme);

            if (styleOverrides) {
              const resolvedStyleOverrides = {};
              Object.entries(styleOverrides).forEach(([slotKey, slotStyle]) => {
                resolvedStyleOverrides[slotKey] = typeof slotStyle === 'function' ? slotStyle(_extends({}, props, {
                  theme
                })) : slotStyle;
              });
              return overridesResolver(props, resolvedStyleOverrides);
            }

            return null;
          });
        }

        if (componentName && !skipVariantsResolver) {
          expressionsWithDefaultTheme.push(props => {
            const theme = isEmpty$1(props.theme) ? defaultTheme : props.theme;
            return variantsResolver(props, getVariantStyles(componentName, theme), theme, componentName);
          });
        }

        if (!skipSx) {
          expressionsWithDefaultTheme.push(props => {
            const theme = isEmpty$1(props.theme) ? defaultTheme : props.theme;
            return styleFunctionSx(_extends({}, props, {
              theme
            }));
          });
        }

        const numOfCustomFnsApplied = expressionsWithDefaultTheme.length - expressions.length;

        if (Array.isArray(styleArg) && numOfCustomFnsApplied > 0) {
          const placeholders = new Array(numOfCustomFnsApplied).fill(''); // If the type is array, than we need to add placeholders in the template for the overrides, variants and the sx styles.

          transformedStyleArg = [...styleArg, ...placeholders];
          transformedStyleArg.raw = [...styleArg.raw, ...placeholders];
        } else if (typeof styleArg === 'function' && // On the server Emotion doesn't use React.forwardRef for creating components, so the created
        // component stays as a function. This condition makes sure that we do not interpolate functions
        // which are basically components used as a selectors.
        // eslint-disable-next-line no-underscore-dangle
        styleArg.__emotion_real !== styleArg) {
          // If the type is function, we need to define the default theme.
          transformedStyleArg = _ref2 => {
            let {
              theme: themeInput
            } = _ref2,
                other = _objectWithoutPropertiesLoose(_ref2, _excluded3$1);

            return styleArg(_extends({
              theme: isEmpty$1(themeInput) ? defaultTheme : themeInput
            }, other));
          };
        }

        const Component = defaultStyledResolver(transformedStyleArg, ...expressionsWithDefaultTheme);

        {
          let displayName;

          if (componentName) {
            displayName = `${componentName}${componentSlot || ''}`;
          }

          if (displayName === undefined) {
            displayName = `Styled(${getDisplayName(tag)})`;
          }

          Component.displayName = displayName;
        }

        return Component;
      };

      if (defaultStyledResolver.withConfig) {
        muiStyledResolver.withConfig = defaultStyledResolver.withConfig;
      }

      return muiStyledResolver;
    };
  }

  const styled$2 = createStyled();
  var systemStyled = styled$2;

  function getThemeProps(params) {
    const {
      theme,
      name,
      props
    } = params;

    if (!theme || !theme.components || !theme.components[name] || !theme.components[name].defaultProps) {
      return props;
    }

    return resolveProps(theme.components[name].defaultProps, props);
  }

  function useThemeProps$1({
    props,
    name,
    defaultTheme
  }) {
    const theme = useTheme$1(defaultTheme);
    const mergedProps = getThemeProps({
      theme,
      name,
      props
    });
    return mergedProps;
  }

  /**
   * Returns a number whose value is limited to the given range.
   * @param {number} value The value to be clamped
   * @param {number} min The lower boundary of the output range
   * @param {number} max The upper boundary of the output range
   * @returns {number} A number in the range [min, max]
   */
  function clamp$3(value, min = 0, max = 1) {
    {
      if (value < min || value > max) {
        console.error(`MUI: The value provided ${value} is out of range [${min}, ${max}].`);
      }
    }

    return Math.min(Math.max(min, value), max);
  }
  /**
   * Converts a color from CSS hex format to CSS rgb format.
   * @param {string} color - Hex color, i.e. #nnn or #nnnnnn
   * @returns {string} A CSS rgb color string
   */


  function hexToRgb(color) {
    color = color.slice(1);
    const re = new RegExp(`.{1,${color.length >= 6 ? 2 : 1}}`, 'g');
    let colors = color.match(re);

    if (colors && colors[0].length === 1) {
      colors = colors.map(n => n + n);
    }

    return colors ? `rgb${colors.length === 4 ? 'a' : ''}(${colors.map((n, index) => {
    return index < 3 ? parseInt(n, 16) : Math.round(parseInt(n, 16) / 255 * 1000) / 1000;
  }).join(', ')})` : '';
  }

  function intToHex(int) {
    const hex = int.toString(16);
    return hex.length === 1 ? `0${hex}` : hex;
  }
  /**
   * Returns an object with the type and values of a color.
   *
   * Note: Does not support rgb % values.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @returns {object} - A MUI color object: {type: string, values: number[]}
   */


  function decomposeColor(color) {
    // Idempotent
    if (color.type) {
      return color;
    }

    if (color.charAt(0) === '#') {
      return decomposeColor(hexToRgb(color));
    }

    const marker = color.indexOf('(');
    const type = color.substring(0, marker);

    if (['rgb', 'rgba', 'hsl', 'hsla', 'color'].indexOf(type) === -1) {
      throw new Error(`MUI: Unsupported \`${color}\` color.
The following formats are supported: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color().` );
    }

    let values = color.substring(marker + 1, color.length - 1);
    let colorSpace;

    if (type === 'color') {
      values = values.split(' ');
      colorSpace = values.shift();

      if (values.length === 4 && values[3].charAt(0) === '/') {
        values[3] = values[3].slice(1);
      }

      if (['srgb', 'display-p3', 'a98-rgb', 'prophoto-rgb', 'rec-2020'].indexOf(colorSpace) === -1) {
        throw new Error(`MUI: unsupported \`${colorSpace}\` color space.
The following color spaces are supported: srgb, display-p3, a98-rgb, prophoto-rgb, rec-2020.` );
      }
    } else {
      values = values.split(',');
    }

    values = values.map(value => parseFloat(value));
    return {
      type,
      values,
      colorSpace
    };
  }
  /**
   * Returns a channel created from the input color.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @returns {string} - The channel for the color, that can be used in rgba or hsla colors
   */

  const colorChannel = color => {
    const decomposedColor = decomposeColor(color);
    return decomposedColor.values.slice(0, 3).map((val, idx) => decomposedColor.type.indexOf('hsl') !== -1 && idx !== 0 ? `${val}%` : val).join(' ');
  };
  /**
   * Converts a color object with type and values to a string.
   * @param {object} color - Decomposed color
   * @param {string} color.type - One of: 'rgb', 'rgba', 'hsl', 'hsla', 'color'
   * @param {array} color.values - [n,n,n] or [n,n,n,n]
   * @returns {string} A CSS color string
   */

  function recomposeColor(color) {
    const {
      type,
      colorSpace
    } = color;
    let {
      values
    } = color;

    if (type.indexOf('rgb') !== -1) {
      // Only convert the first 3 values to int (i.e. not alpha)
      values = values.map((n, i) => i < 3 ? parseInt(n, 10) : n);
    } else if (type.indexOf('hsl') !== -1) {
      values[1] = `${values[1]}%`;
      values[2] = `${values[2]}%`;
    }

    if (type.indexOf('color') !== -1) {
      values = `${colorSpace} ${values.join(' ')}`;
    } else {
      values = `${values.join(', ')}`;
    }

    return `${type}(${values})`;
  }
  /**
   * Converts a color from CSS rgb format to CSS hex format.
   * @param {string} color - RGB color, i.e. rgb(n, n, n)
   * @returns {string} A CSS rgb color string, i.e. #nnnnnn
   */

  function rgbToHex(color) {
    // Idempotent
    if (color.indexOf('#') === 0) {
      return color;
    }

    const {
      values
    } = decomposeColor(color);
    return `#${values.map((n, i) => intToHex(i === 3 ? Math.round(255 * n) : n)).join('')}`;
  }
  /**
   * Converts a color from hsl format to rgb format.
   * @param {string} color - HSL color values
   * @returns {string} rgb color values
   */

  function hslToRgb(color) {
    color = decomposeColor(color);
    const {
      values
    } = color;
    const h = values[0];
    const s = values[1] / 100;
    const l = values[2] / 100;
    const a = s * Math.min(l, 1 - l);

    const f = (n, k = (n + h / 30) % 12) => l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);

    let type = 'rgb';
    const rgb = [Math.round(f(0) * 255), Math.round(f(8) * 255), Math.round(f(4) * 255)];

    if (color.type === 'hsla') {
      type += 'a';
      rgb.push(values[3]);
    }

    return recomposeColor({
      type,
      values: rgb
    });
  }
  /**
   * The relative brightness of any point in a color space,
   * normalized to 0 for darkest black and 1 for lightest white.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @returns {number} The relative brightness of the color in the range 0 - 1
   */

  function getLuminance(color) {
    color = decomposeColor(color);
    let rgb = color.type === 'hsl' ? decomposeColor(hslToRgb(color)).values : color.values;
    rgb = rgb.map(val => {
      if (color.type !== 'color') {
        val /= 255; // normalized
      }

      return val <= 0.03928 ? val / 12.92 : ((val + 0.055) / 1.055) ** 2.4;
    }); // Truncate at 3 digits

    return Number((0.2126 * rgb[0] + 0.7152 * rgb[1] + 0.0722 * rgb[2]).toFixed(3));
  }
  /**
   * Calculates the contrast ratio between two colors.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   * @param {string} foreground - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {string} background - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {number} A contrast ratio value in the range 0 - 21.
   */

  function getContrastRatio(foreground, background) {
    const lumA = getLuminance(foreground);
    const lumB = getLuminance(background);
    return (Math.max(lumA, lumB) + 0.05) / (Math.min(lumA, lumB) + 0.05);
  }
  /**
   * Sets the absolute transparency of a color.
   * Any existing alpha values are overwritten.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} value - value to set the alpha channel to in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function alpha(color, value) {
    color = decomposeColor(color);
    value = clamp$3(value);

    if (color.type === 'rgb' || color.type === 'hsl') {
      color.type += 'a';
    }

    if (color.type === 'color') {
      color.values[3] = `/${value}`;
    } else {
      color.values[3] = value;
    }

    return recomposeColor(color);
  }
  /**
   * Darkens a color.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function darken(color, coefficient) {
    color = decomposeColor(color);
    coefficient = clamp$3(coefficient);

    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] *= 1 - coefficient;
    } else if (color.type.indexOf('rgb') !== -1 || color.type.indexOf('color') !== -1) {
      for (let i = 0; i < 3; i += 1) {
        color.values[i] *= 1 - coefficient;
      }
    }

    return recomposeColor(color);
  }
  /**
   * Lightens a color.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function lighten(color, coefficient) {
    color = decomposeColor(color);
    coefficient = clamp$3(coefficient);

    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] += (100 - color.values[2]) * coefficient;
    } else if (color.type.indexOf('rgb') !== -1) {
      for (let i = 0; i < 3; i += 1) {
        color.values[i] += (255 - color.values[i]) * coefficient;
      }
    } else if (color.type.indexOf('color') !== -1) {
      for (let i = 0; i < 3; i += 1) {
        color.values[i] += (1 - color.values[i]) * coefficient;
      }
    }

    return recomposeColor(color);
  }
  /**
   * Darken or lighten a color, depending on its luminance.
   * Light colors are darkened, dark colors are lightened.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} coefficient=0.15 - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function emphasize(color, coefficient = 0.15) {
    return getLuminance(color) > 0.5 ? darken(color, coefficient) : lighten(color, coefficient);
  }

  function InnerThemeProvider(props) {
    const theme = useTheme$1();
    return /*#__PURE__*/jsxRuntime_1(ThemeContext$2.Provider, {
      value: typeof theme === 'object' ? theme : {},
      children: props.children
    });
  }

  InnerThemeProvider.propTypes = {
    /**
     * Your component tree.
     */
    children: PropTypes.node
  } ;
  /**
   * This component makes the `theme` available down the React tree.
   * It should preferably be used at **the root of your component tree**.
   */

  function ThemeProvider(props) {
    const {
      children,
      theme: localTheme
    } = props;
    return /*#__PURE__*/jsxRuntime_1(ThemeProvider$1, {
      theme: localTheme,
      children: /*#__PURE__*/jsxRuntime_1(InnerThemeProvider, {
        children: children
      })
    });
  }

  ThemeProvider.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Your component tree.
     */
    children: PropTypes.node,

    /**
     * A theme object. You can provide a function to extend the outer theme.
     */
    theme: PropTypes.oneOfType([PropTypes.func, PropTypes.object]).isRequired
  } ;

  {
    ThemeProvider.propTypes = exactProp(ThemeProvider.propTypes) ;
  }

  /**
   * This function create an object from keys, value and then assign to target
   *
   * @param {Object} obj : the target object to be assigned
   * @param {string[]} keys
   * @param {string | number} value
   *
   * @example
   * const source = {}
   * assignNestedKeys(source, ['palette', 'primary'], 'var(--palette-primary)')
   * console.log(source) // { palette: { primary: 'var(--palette-primary)' } }
   *
   * @example
   * const source = { palette: { primary: 'var(--palette-primary)' } }
   * assignNestedKeys(source, ['palette', 'secondary'], 'var(--palette-secondary)')
   * console.log(source) // { palette: { primary: 'var(--palette-primary)', secondary: 'var(--palette-secondary)' } }
   */
  const assignNestedKeys = (obj, keys, value, arrayKeys = []) => {
    let temp = obj;
    keys.forEach((k, index) => {
      if (index === keys.length - 1) {
        if (Array.isArray(temp)) {
          temp[Number(k)] = value;
        } else if (temp && typeof temp === 'object') {
          temp[k] = value;
        }
      } else if (temp && typeof temp === 'object') {
        if (!temp[k]) {
          temp[k] = arrayKeys.includes(k) ? [] : {};
        }

        temp = temp[k];
      }
    });
  };
  /**
   *
   * @param {Object} obj : source object
   * @param {Function} callback : a function that will be called when
   *                   - the deepest key in source object is reached
   *                   - the value of the deepest key is NOT `undefined` | `null`
   *
   * @example
   * walkObjectDeep({ palette: { primary: { main: '#000000' } } }, console.log)
   * // ['palette', 'primary', 'main'] '#000000'
   */

  const walkObjectDeep = (obj, callback, shouldSkipPaths) => {
    function recurse(object, parentKeys = [], arrayKeys = []) {
      Object.entries(object).forEach(([key, value]) => {
        if (!shouldSkipPaths || shouldSkipPaths && !shouldSkipPaths([...parentKeys, key])) {
          if (value !== undefined && value !== null) {
            if (typeof value === 'object' && Object.keys(value).length > 0) {
              recurse(value, [...parentKeys, key], Array.isArray(value) ? [...arrayKeys, key] : arrayKeys);
            } else {
              callback([...parentKeys, key], value, arrayKeys);
            }
          }
        }
      });
    }

    recurse(obj);
  };

  const getCssValue = (keys, value) => {
    if (typeof value === 'number') {
      if (['lineHeight', 'fontWeight', 'opacity', 'zIndex'].some(prop => keys.includes(prop))) {
        // CSS property that are unitless
        return value;
      }

      const lastKey = keys[keys.length - 1];

      if (lastKey.toLowerCase().indexOf('opacity') >= 0) {
        // opacity values are unitless
        return value;
      }

      return `${value}px`;
    }

    return value;
  };
  /**
   * a function that parse theme and return { css, vars }
   *
   * @param {Object} theme
   * @param {{
   *  prefix?: string,
   *  basePrefix?: string,
   *  shouldSkipGeneratingVar?: (objectPathKeys: Array<string>, value: string | number) => boolean
   * }} options.
   *  `basePrefix`: defined by design system.
   *  `prefix`: defined by application
   *
   *   the CSS variable value will be adjusted based on the provided `basePrefix` & `prefix` which can be found in `parsedTheme`.
   *
   * @returns {{ css: Object, vars: Object, parsedTheme: typeof theme }} `css` is the stylesheet, `vars` is an object to get css variable (same structure as theme), and `parsedTheme` is the cloned version of theme.
   *
   * @example
   * const { css, vars, parsedTheme } = parser({
   *   fontSize: 12,
   *   lineHeight: 1.2,
   *   palette: { primary: { 500: 'var(--color)' } }
   * }, { prefix: 'foo' })
   *
   * console.log(css) // { '--foo-fontSize': '12px', '--foo-lineHeight': 1.2, '--foo-palette-primary-500': 'var(--foo-color)' }
   * console.log(vars) // { fontSize: '--foo-fontSize', lineHeight: '--foo-lineHeight', palette: { primary: { 500: 'var(--foo-palette-primary-500)' } } }
   * console.log(parsedTheme) // { fontSize: 12, lineHeight: 1.2, palette: { primary: { 500: 'var(--foo-color)' } } }
   */


  function cssVarsParser(theme, options) {
    const {
      prefix,
      basePrefix = '',
      shouldSkipGeneratingVar
    } = options || {};
    const css = {};
    const vars = {};
    const parsedTheme = {};
    walkObjectDeep(theme, (keys, value, arrayKeys) => {
      if (typeof value === 'string' || typeof value === 'number') {
        if (typeof value === 'string' && value.match(/var\(\s*--/)) {
          // for CSS variable, apply prefix or remove basePrefix from the variable
          if (!basePrefix && prefix) {
            value = value.replace(/var\(\s*--/g, `var(--${prefix}-`);
          } else {
            value = prefix ? value.replace(new RegExp(`var\\(\\s*--${basePrefix}`, 'g'), `var(--${prefix}`) // removing spaces
            : value.replace(new RegExp(`var\\(\\s*--${basePrefix}-`, 'g'), 'var(--');
          }
        }

        if (!shouldSkipGeneratingVar || shouldSkipGeneratingVar && !shouldSkipGeneratingVar(keys, value)) {
          // only create css & var if `shouldSkipGeneratingVar` return false
          const cssVar = `--${prefix ? `${prefix}-` : ''}${keys.join('-')}`;
          Object.assign(css, {
            [cssVar]: getCssValue(keys, value)
          });
          assignNestedKeys(vars, keys, `var(${cssVar})`, arrayKeys);
        }
      }

      assignNestedKeys(parsedTheme, keys, value, arrayKeys);
    }, keys => keys[0] === 'vars' // skip 'vars/*' paths
    );
    return {
      css,
      vars,
      parsedTheme
    };
  }

  const DEFAULT_MODE_STORAGE_KEY = 'mode';
  const DEFAULT_COLOR_SCHEME_STORAGE_KEY = 'color-scheme';
  const DEFAULT_ATTRIBUTE = 'data-color-scheme';
  function getInitColorSchemeScript$1(options) {
    const {
      enableSystem = false,
      defaultLightColorScheme = 'light',
      defaultDarkColorScheme = 'dark',
      modeStorageKey = DEFAULT_MODE_STORAGE_KEY,
      colorSchemeStorageKey = DEFAULT_COLOR_SCHEME_STORAGE_KEY,
      attribute = DEFAULT_ATTRIBUTE,
      colorSchemeNode = 'document.documentElement'
    } = options || {};
    return /*#__PURE__*/jsxRuntime_1("script", {
      // eslint-disable-next-line react/no-danger
      dangerouslySetInnerHTML: {
        __html: `(function() { try {
        var mode = localStorage.getItem('${modeStorageKey}');
        var colorScheme = '';
        if (mode === 'system' || (!mode && !!${enableSystem})) {
          // handle system mode
          var mql = window.matchMedia('(prefers-color-scheme: dark)');
          if (mql.matches) {
            colorScheme = localStorage.getItem('${colorSchemeStorageKey}-dark') || '${defaultDarkColorScheme}';
          } else {
            colorScheme = localStorage.getItem('${colorSchemeStorageKey}-light') || '${defaultLightColorScheme}';
          }
        }
        if (mode === 'light') {
          colorScheme = localStorage.getItem('${colorSchemeStorageKey}-light') || '${defaultLightColorScheme}';
        }
        if (mode === 'dark') {
          colorScheme = localStorage.getItem('${colorSchemeStorageKey}-dark') || '${defaultDarkColorScheme}';
        }
        if (colorScheme) {
          ${colorSchemeNode}.setAttribute('${attribute}', colorScheme);
        }
      } catch (e) {} })();`
      }
    });
  }

  function getSystemMode(mode) {
    if (typeof window !== 'undefined' && mode === 'system') {
      const mql = window.matchMedia('(prefers-color-scheme: dark)');

      if (mql.matches) {
        return 'dark';
      }

      return 'light';
    }

    return undefined;
  }

  function processState(state, callback) {
    if (state.mode === 'light' || state.mode === 'system' && state.systemMode === 'light') {
      return callback('light');
    }

    if (state.mode === 'dark' || state.mode === 'system' && state.systemMode === 'dark') {
      return callback('dark');
    }

    return undefined;
  }

  function getColorScheme(state) {
    return processState(state, mode => {
      if (mode === 'light') {
        return state.lightColorScheme;
      }

      if (mode === 'dark') {
        return state.darkColorScheme;
      }

      return undefined;
    });
  }

  function resolveValue(key, defaultValue) {
    if (typeof window === 'undefined') {
      return undefined;
    }

    let value;

    try {
      value = localStorage.getItem(key) || undefined;
    } catch (e) {// Unsupported
    }

    return value || defaultValue;
  }

  function useCurrentColorScheme(options) {
    const {
      defaultMode = 'light',
      defaultLightColorScheme,
      defaultDarkColorScheme,
      supportedColorSchemes = [],
      modeStorageKey = DEFAULT_MODE_STORAGE_KEY,
      colorSchemeStorageKey = DEFAULT_COLOR_SCHEME_STORAGE_KEY,
      storageWindow = typeof window === 'undefined' ? undefined : window
    } = options;
    const joinedColorSchemes = supportedColorSchemes.join(',');
    const [state, setState] = React__namespace.useState(() => {
      const initialMode = resolveValue(modeStorageKey, defaultMode);
      return {
        mode: initialMode,
        systemMode: getSystemMode(initialMode),
        lightColorScheme: resolveValue(`${colorSchemeStorageKey}-light`) || defaultLightColorScheme,
        darkColorScheme: resolveValue(`${colorSchemeStorageKey}-dark`) || defaultDarkColorScheme
      };
    });
    const colorScheme = getColorScheme(state);
    const setMode = React__namespace.useCallback(mode => {
      setState(currentState => {
        const newMode = !mode ? defaultMode : mode;

        if (mode === currentState.mode) {
          return currentState;
        }

        if (typeof localStorage !== 'undefined') {
          localStorage.setItem(modeStorageKey, newMode);
        }

        return _extends({}, currentState, {
          mode: newMode,
          systemMode: getSystemMode(newMode)
        });
      });
    }, [modeStorageKey, defaultMode]);
    const setColorScheme = React__namespace.useCallback(value => {
      if (!value || typeof value === 'string') {
        if (value && !joinedColorSchemes.includes(value)) {
          console.error(`\`${value}\` does not exist in \`theme.colorSchemes\`.`);
        } else {
          setState(currentState => {
            const newState = _extends({}, currentState);

            if (!value) {
              // reset to default color scheme
              newState.lightColorScheme = defaultLightColorScheme;
              newState.darkColorScheme = defaultDarkColorScheme;
              return newState;
            }

            processState(currentState, mode => {
              localStorage.setItem(`${colorSchemeStorageKey}-${mode}`, value);

              if (mode === 'light') {
                newState.lightColorScheme = value;
              }

              if (mode === 'dark') {
                newState.darkColorScheme = value;
              }
            });
            return newState;
          });
        }
      } else if (value.light && !joinedColorSchemes.includes(value.light) || value.dark && !joinedColorSchemes.includes(value.dark)) {
        console.error(`\`${value}\` does not exist in \`theme.colorSchemes\`.`);
      } else {
        setState(currentState => {
          const newState = _extends({}, currentState);

          if (value.light || value.light === null) {
            newState.lightColorScheme = value.light === null ? defaultLightColorScheme : value.light;
          }

          if (value.dark || value.dark === null) {
            newState.darkColorScheme = value.dark === null ? defaultDarkColorScheme : value.dark;
          }

          return newState;
        });

        if (value.light) {
          localStorage.setItem(`${colorSchemeStorageKey}-light`, value.light);
        }

        if (value.dark) {
          localStorage.setItem(`${colorSchemeStorageKey}-dark`, value.dark);
        }
      }
    }, [joinedColorSchemes, colorSchemeStorageKey, defaultLightColorScheme, defaultDarkColorScheme]);
    const handleMediaQuery = React__namespace.useCallback(e => {
      if (state.mode === 'system') {
        setState(currentState => _extends({}, currentState, {
          systemMode: e.matches ? 'dark' : 'light'
        }));
      }
    }, [state.mode]); // Ref hack to avoid adding handleMediaQuery as a dep

    const mediaListener = React__namespace.useRef(handleMediaQuery);
    mediaListener.current = handleMediaQuery;
    React__namespace.useEffect(() => {
      const handler = (...args) => mediaListener.current(...args); // Always listen to System preference


      const media = window.matchMedia('(prefers-color-scheme: dark)'); // Intentionally use deprecated listener methods to support iOS & old browsers

      media.addListener(handler);
      handler(media);
      return () => media.removeListener(handler);
    }, []); // Save mode, lightColorScheme & darkColorScheme to localStorage

    React__namespace.useEffect(() => {
      if (state.mode) {
        localStorage.setItem(modeStorageKey, state.mode);
      }

      processState(state, mode => {
        if (mode === 'light') {
          localStorage.setItem(`${colorSchemeStorageKey}-light`, state.lightColorScheme);
        }

        if (mode === 'dark') {
          localStorage.setItem(`${colorSchemeStorageKey}-dark`, state.darkColorScheme);
        }
      });
    }, [state, colorSchemeStorageKey, modeStorageKey]); // Handle when localStorage has changed

    React__namespace.useEffect(() => {
      const handleStorage = event => {
        const value = event.newValue;

        if (typeof event.key === 'string' && event.key.startsWith(colorSchemeStorageKey) && (!value || joinedColorSchemes.match(value))) {
          // If the key is deleted, value will be null then reset color scheme to the default one.
          if (event.key.endsWith('light')) {
            setColorScheme({
              light: value
            });
          }

          if (event.key.endsWith('dark')) {
            setColorScheme({
              dark: value
            });
          }
        }

        if (event.key === modeStorageKey && (!value || ['light', 'dark', 'system'].includes(value))) {
          setMode(value || defaultMode);
        }
      };

      if (storageWindow) {
        // For syncing color-scheme changes between iframes
        storageWindow.addEventListener('storage', handleStorage);
        return () => storageWindow.removeEventListener('storage', handleStorage);
      }

      return undefined;
    }, [setColorScheme, setMode, modeStorageKey, colorSchemeStorageKey, joinedColorSchemes, defaultMode, storageWindow]);
    return _extends({}, state, {
      colorScheme,
      setMode,
      setColorScheme
    });
  }

  /**
   * The benefit of this function is to help developers get CSS var from theme without specifying the whole variable
   * and they does not need to remember the prefix (defined once).
   */
  function createGetCssVar(prefix = '') {
    function appendVar(...vars) {
      if (!vars.length) {
        return '';
      }

      const value = vars[0];

      if (typeof value === 'string' && !value.match(/(#|\(|\)|(-?(\d*\.)?\d+)(px|em|%|ex|ch|rem|vw|vh|vmin|vmax|cm|mm|in|pt|pc))/)) {
        return `, var(--${prefix ? `${prefix}-` : ''}${value}${appendVar(...vars.slice(1))})`;
      }

      return `, ${value}`;
    } // AdditionalVars makes `getCssVar` less strict, so it can be use like this `getCssVar('non-mui-variable')` without type error.


    const getCssVar = (field, ...vars) => {
      return `var(--${prefix ? `${prefix}-` : ''}${field}${appendVar(...vars)})`;
    };

    return getCssVar;
  }

  const _excluded$2g = ["colorSchemes", "components"];
  const DISABLE_CSS_TRANSITION = '*{-webkit-transition:none!important;-moz-transition:none!important;-o-transition:none!important;-ms-transition:none!important;transition:none!important}';
  function createCssVarsProvider(options) {
    const {
      theme: defaultTheme = {},
      attribute: defaultAttribute = DEFAULT_ATTRIBUTE,
      modeStorageKey: defaultModeStorageKey = DEFAULT_MODE_STORAGE_KEY,
      colorSchemeStorageKey: defaultColorSchemeStorageKey = DEFAULT_COLOR_SCHEME_STORAGE_KEY,
      defaultMode: desisgnSystemMode = 'light',
      defaultColorScheme: designSystemColorScheme,
      disableTransitionOnChange: designSystemTransitionOnChange = false,
      enableColorScheme: designSystemEnableColorScheme = true,
      prefix: designSystemPrefix = '',
      shouldSkipGeneratingVar,
      resolveTheme
    } = options;

    if (!defaultTheme.colorSchemes || typeof designSystemColorScheme === 'string' && !defaultTheme.colorSchemes[designSystemColorScheme] || typeof designSystemColorScheme === 'object' && !defaultTheme.colorSchemes[designSystemColorScheme == null ? void 0 : designSystemColorScheme.light] || typeof designSystemColorScheme === 'object' && !defaultTheme.colorSchemes[designSystemColorScheme == null ? void 0 : designSystemColorScheme.dark]) {
      console.error(`MUI: \`${designSystemColorScheme}\` does not exist in \`theme.colorSchemes\`.`);
    }

    const ColorSchemeContext = /*#__PURE__*/React__namespace.createContext(undefined);

    const useColorScheme = () => {
      const value = React__namespace.useContext(ColorSchemeContext);

      if (!value) {
        throw new Error(`MUI: \`useColorScheme\` must be called under <CssVarsProvider />` );
      }

      return value;
    };

    function CssVarsProvider({
      children,
      theme: themeProp = defaultTheme,
      prefix = designSystemPrefix,
      modeStorageKey = defaultModeStorageKey,
      colorSchemeStorageKey = defaultColorSchemeStorageKey,
      attribute = defaultAttribute,
      defaultMode = desisgnSystemMode,
      defaultColorScheme = designSystemColorScheme,
      disableTransitionOnChange = designSystemTransitionOnChange,
      enableColorScheme = designSystemEnableColorScheme,
      storageWindow = typeof window === 'undefined' ? undefined : window,
      documentNode = typeof document === 'undefined' ? undefined : document,
      colorSchemeNode = typeof document === 'undefined' ? undefined : document.documentElement,
      colorSchemeSelector = ':root'
    }) {
      const hasMounted = React__namespace.useRef(false);

      const {
        colorSchemes = {},
        components = {}
      } = themeProp,
            restThemeProp = _objectWithoutPropertiesLoose(themeProp, _excluded$2g);

      const allColorSchemes = Object.keys(colorSchemes);
      const defaultLightColorScheme = typeof defaultColorScheme === 'string' ? defaultColorScheme : defaultColorScheme.light;
      const defaultDarkColorScheme = typeof defaultColorScheme === 'string' ? defaultColorScheme : defaultColorScheme.dark;
      const {
        mode,
        setMode,
        systemMode,
        lightColorScheme,
        darkColorScheme,
        colorScheme,
        setColorScheme
      } = useCurrentColorScheme({
        supportedColorSchemes: allColorSchemes,
        defaultLightColorScheme,
        defaultDarkColorScheme,
        modeStorageKey,
        colorSchemeStorageKey,
        defaultMode,
        storageWindow
      });

      const resolvedColorScheme = (() => {
        if (!colorScheme) {
          // This scope occurs on the server
          if (defaultMode === 'dark') {
            return defaultDarkColorScheme;
          } // use light color scheme, if default mode is 'light' | 'auto'


          return defaultLightColorScheme;
        }

        return colorScheme;
      })();

      let theme = restThemeProp;
      const {
        css: rootCss,
        vars: rootVars,
        parsedTheme
      } = cssVarsParser(theme, {
        prefix,
        basePrefix: designSystemPrefix,
        shouldSkipGeneratingVar
      });
      theme = _extends({}, parsedTheme, {
        components,
        colorSchemes,
        prefix,
        vars: rootVars,
        getCssVar: createGetCssVar(prefix),
        getColorSchemeSelector: targetColorScheme => `[${attribute}="${targetColorScheme}"] &`
      });
      const defaultColorSchemeStyleSheet = {};
      const otherColorSchemesStyleSheet = {};
      Object.entries(colorSchemes).forEach(([key, scheme]) => {
        const {
          css,
          vars,
          parsedTheme: parsedScheme
        } = cssVarsParser(scheme, {
          prefix,
          basePrefix: designSystemPrefix,
          shouldSkipGeneratingVar
        });
        theme.vars = deepmerge(theme.vars, vars);

        if (key === resolvedColorScheme) {
          theme = _extends({}, theme, parsedScheme);

          if (theme.palette) {
            // assign runtime mode & colorScheme
            theme.palette.mode = mode;
            theme.palette.colorScheme = resolvedColorScheme;
          }
        }

        const resolvedDefaultColorScheme = (() => {
          if (typeof defaultColorScheme === 'string') {
            return defaultColorScheme;
          }

          if (defaultMode === 'dark') {
            return defaultColorScheme.dark;
          }

          return defaultColorScheme.light;
        })();

        if (key === resolvedDefaultColorScheme) {
          defaultColorSchemeStyleSheet[colorSchemeSelector] = css;
        } else {
          otherColorSchemesStyleSheet[`${colorSchemeSelector === ':root' ? '' : colorSchemeSelector}[${attribute}="${key}"]`] = css;
        }
      });
      React__namespace.useEffect(() => {
        if (colorScheme && colorSchemeNode) {
          // attaches attribute to <html> because the css variables are attached to :root (html)
          colorSchemeNode.setAttribute(attribute, colorScheme);
        }
      }, [colorScheme, attribute, colorSchemeNode]);
      useEnhancedEffect$1(() => {
        if (!mode || !enableColorScheme || !colorSchemeNode) {
          return undefined;
        }

        const priorColorScheme = colorSchemeNode.style.getPropertyValue('color-scheme'); // `color-scheme` tells browser to render built-in elements according to its value: `light` or `dark`

        if (mode === 'system') {
          colorSchemeNode.style.setProperty('color-scheme', systemMode);
        } else {
          colorSchemeNode.style.setProperty('color-scheme', mode);
        }

        return () => {
          colorSchemeNode.style.setProperty('color-scheme', priorColorScheme);
        };
      }, [mode, systemMode, enableColorScheme, colorSchemeNode]);
      React__namespace.useEffect(() => {
        let timer;

        if (disableTransitionOnChange && hasMounted.current && documentNode) {
          // credit: https://github.com/pacocoursey/next-themes/blob/b5c2bad50de2d61ad7b52a9c5cdc801a78507d7a/index.tsx#L313
          const css = documentNode.createElement('style');
          css.appendChild(documentNode.createTextNode(DISABLE_CSS_TRANSITION));
          documentNode.head.appendChild(css); // Force browser repaint

          (() => window.getComputedStyle(documentNode.body))();

          timer = setTimeout(() => {
            documentNode.head.removeChild(css);
          }, 1);
        }

        return () => {
          clearTimeout(timer);
        };
      }, [colorScheme, disableTransitionOnChange, documentNode]);
      React__namespace.useEffect(() => {
        hasMounted.current = true;
        return () => {
          hasMounted.current = false;
        };
      }, []);
      return /*#__PURE__*/jsxRuntime_2(ColorSchemeContext.Provider, {
        value: {
          mode,
          setMode,
          lightColorScheme,
          darkColorScheme,
          colorScheme,
          setColorScheme,
          allColorSchemes
        },
        children: [/*#__PURE__*/jsxRuntime_1(GlobalStyles$1, {
          styles: {
            [colorSchemeSelector]: rootCss
          }
        }), /*#__PURE__*/jsxRuntime_1(GlobalStyles$1, {
          styles: defaultColorSchemeStyleSheet
        }), /*#__PURE__*/jsxRuntime_1(GlobalStyles$1, {
          styles: otherColorSchemesStyleSheet
        }), /*#__PURE__*/jsxRuntime_1(ThemeProvider, {
          theme: resolveTheme ? resolveTheme(theme) : theme,
          children: children
        })]
      });
    }

    CssVarsProvider.propTypes = {
      /**
       * The body attribute name to attach colorScheme.
       */
      attribute: PropTypes.string,

      /**
       * The component tree.
       */
      children: PropTypes.node,

      /**
       * The node used to attach the color-scheme attribute
       */
      colorSchemeNode: PropTypes.any,

      /**
       * The CSS selector for attaching the generated custom properties
       */
      colorSchemeSelector: PropTypes.string,

      /**
       * localStorage key used to store `colorScheme`
       */
      colorSchemeStorageKey: PropTypes.string,

      /**
       * The initial color scheme used.
       */
      defaultColorScheme: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),

      /**
       * The initial mode used.
       */
      defaultMode: PropTypes.string,

      /**
       * Disable CSS transitions when switching between modes or color schemes
       */
      disableTransitionOnChange: PropTypes.bool,

      /**
       * The document to attach the attribute to
       */
      documentNode: PropTypes.any,

      /**
       * Indicate to the browser which color scheme is used (light or dark) for rendering built-in UI
       */
      enableColorScheme: PropTypes.bool,

      /**
       * The key in the local storage used to store current color scheme.
       */
      modeStorageKey: PropTypes.string,

      /**
       * CSS variable prefix.
       */
      prefix: PropTypes.string,

      /**
       * The window that attaches the 'storage' event listener
       * @default window
       */
      storageWindow: PropTypes.any,

      /**
       * The calculated theme object that will be passed through context.
       */
      theme: PropTypes.object
    } ;

    const getInitColorSchemeScript = params => getInitColorSchemeScript$1(_extends({
      attribute: defaultAttribute,
      colorSchemeStorageKey: defaultColorSchemeStorageKey,
      modeStorageKey: defaultModeStorageKey
    }, params));

    return {
      CssVarsProvider,
      useColorScheme,
      getInitColorSchemeScript
    };
  }

  const _excluded$2f = ["className", "component", "disableGutters", "fixed", "maxWidth", "classes"];
  const defaultTheme$4 = createTheme$1();
  const defaultCreateStyledComponent = systemStyled('div', {
    name: 'MuiContainer',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[`maxWidth${capitalize(String(ownerState.maxWidth))}`], ownerState.fixed && styles.fixed, ownerState.disableGutters && styles.disableGutters];
    }
  });

  const useThemePropsDefault = inProps => useThemeProps$1({
    props: inProps,
    name: 'MuiContainer',
    defaultTheme: defaultTheme$4
  });

  const useUtilityClasses$1P = (ownerState, componentName) => {
    const getContainerUtilityClass = slot => {
      return generateUtilityClass(componentName, slot);
    };

    const {
      classes,
      fixed,
      disableGutters,
      maxWidth
    } = ownerState;
    const slots = {
      root: ['root', maxWidth && `maxWidth${capitalize(String(maxWidth))}`, fixed && 'fixed', disableGutters && 'disableGutters']
    };
    return composeClasses(slots, getContainerUtilityClass, classes);
  };

  function createContainer(options = {}) {
    const {
      // This will allow adding custom styled fn (for example for custom sx style function)
      createStyledComponent = defaultCreateStyledComponent,
      useThemeProps = useThemePropsDefault,
      componentName = 'MuiContainer'
    } = options;
    const ContainerRoot = createStyledComponent(({
      theme,
      ownerState
    }) => _extends({
      width: '100%',
      marginLeft: 'auto',
      boxSizing: 'border-box',
      marginRight: 'auto',
      display: 'block'
    }, !ownerState.disableGutters && {
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2),
      // @ts-ignore module augmentation fails if custom breakpoints are used
      [theme.breakpoints.up('sm')]: {
        paddingLeft: theme.spacing(3),
        paddingRight: theme.spacing(3)
      }
    }), ({
      theme,
      ownerState
    }) => ownerState.fixed && Object.keys(theme.breakpoints.values).reduce((acc, breakpointValueKey) => {
      const breakpoint = breakpointValueKey;
      const value = theme.breakpoints.values[breakpoint];

      if (value !== 0) {
        // @ts-ignore
        acc[theme.breakpoints.up(breakpoint)] = {
          maxWidth: `${value}${theme.breakpoints.unit}`
        };
      }

      return acc;
    }, {}), ({
      theme,
      ownerState
    }) => _extends({}, ownerState.maxWidth === 'xs' && {
      // @ts-ignore module augmentation fails if custom breakpoints are used
      [theme.breakpoints.up('xs')]: {
        // @ts-ignore module augmentation fails if custom breakpoints are used
        maxWidth: Math.max(theme.breakpoints.values.xs, 444)
      }
    }, ownerState.maxWidth && // @ts-ignore module augmentation fails if custom breakpoints are used
    ownerState.maxWidth !== 'xs' && {
      // @ts-ignore module augmentation fails if custom breakpoints are used
      [theme.breakpoints.up(ownerState.maxWidth)]: {
        // @ts-ignore module augmentation fails if custom breakpoints are used
        maxWidth: `${theme.breakpoints.values[ownerState.maxWidth]}${theme.breakpoints.unit}`
      }
    }));
    const Container = /*#__PURE__*/React__namespace.forwardRef(function Container(inProps, ref) {
      const props = useThemeProps(inProps);

      const {
        className,
        component = 'div',
        disableGutters = false,
        fixed = false,
        maxWidth = 'lg'
      } = props,
            other = _objectWithoutPropertiesLoose(props, _excluded$2f);

      const ownerState = _extends({}, props, {
        component,
        disableGutters,
        fixed,
        maxWidth
      }); // @ts-ignore module augmentation fails if custom breakpoints are used


      const classes = useUtilityClasses$1P(ownerState, componentName);
      return (
        /*#__PURE__*/
        // @ts-ignore theme is injected by the styled util
        jsxRuntime_1(ContainerRoot, _extends({
          as: component // @ts-ignore module augmentation fails if custom breakpoints are used
          ,
          ownerState: ownerState,
          className: clsx(classes.root, className),
          ref: ref
        }, other))
      );
    });
    Container.propTypes
    /* remove-proptypes */
    = {
      children: PropTypes.node,
      classes: PropTypes.object,
      className: PropTypes.string,
      component: PropTypes.elementType,
      disableGutters: PropTypes.bool,
      fixed: PropTypes.bool,
      maxWidth: PropTypes
      /* @typescript-to-proptypes-ignore */
      .oneOfType([PropTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false]), PropTypes.string]),
      sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
    } ;
    return Container;
  }

  const _excluded$2e = ["defaultProps", "mixins", "overrides", "palette", "props", "styleOverrides"],
        _excluded2$b = ["type", "mode"];
  function adaptV4Theme(inputTheme) {
    {
      console.warn(['MUI: adaptV4Theme() is deprecated.', 'Follow the upgrade guide on https://mui.com/r/migration-v4#theme.'].join('\n'));
    }

    const {
      defaultProps = {},
      mixins = {},
      overrides = {},
      palette = {},
      props = {},
      styleOverrides = {}
    } = inputTheme,
          other = _objectWithoutPropertiesLoose(inputTheme, _excluded$2e);

    const theme = _extends({}, other, {
      components: {}
    }); // default props


    Object.keys(defaultProps).forEach(component => {
      const componentValue = theme.components[component] || {};
      componentValue.defaultProps = defaultProps[component];
      theme.components[component] = componentValue;
    });
    Object.keys(props).forEach(component => {
      const componentValue = theme.components[component] || {};
      componentValue.defaultProps = props[component];
      theme.components[component] = componentValue;
    }); // CSS overrides

    Object.keys(styleOverrides).forEach(component => {
      const componentValue = theme.components[component] || {};
      componentValue.styleOverrides = styleOverrides[component];
      theme.components[component] = componentValue;
    });
    Object.keys(overrides).forEach(component => {
      const componentValue = theme.components[component] || {};
      componentValue.styleOverrides = overrides[component];
      theme.components[component] = componentValue;
    }); // theme.spacing

    theme.spacing = createSpacing(inputTheme.spacing); // theme.mixins.gutters

    const breakpoints = createBreakpoints(inputTheme.breakpoints || {});
    const spacing = theme.spacing;
    theme.mixins = _extends({
      gutters: (styles = {}) => {
        return _extends({
          paddingLeft: spacing(2),
          paddingRight: spacing(2)
        }, styles, {
          [breakpoints.up('sm')]: _extends({
            paddingLeft: spacing(3),
            paddingRight: spacing(3)
          }, styles[breakpoints.up('sm')])
        });
      }
    }, mixins);

    const {
      type: typeInput,
      mode: modeInput
    } = palette,
          paletteRest = _objectWithoutPropertiesLoose(palette, _excluded2$b);

    const finalMode = modeInput || typeInput || 'light';
    theme.palette = _extends({
      // theme.palette.text.hint
      text: {
        hint: finalMode === 'dark' ? 'rgba(255, 255, 255, 0.5)' : 'rgba(0, 0, 0, 0.38)'
      },
      mode: finalMode,
      type: finalMode
    }, paletteRest);
    return theme;
  }

  /**
   * Determines if a given element is a DOM element name (i.e. not a React component).
   */
  function isHostComponent(element) {
    return typeof element === 'string';
  }

  /**
   * Appends the ownerState object to the props, merging with the existing one if necessary.
   *
   * @param elementType Type of the element that owns the `existingProps`. If the element is a DOM node, `ownerState` are not applied.
   * @param existingProps Props of the element.
   * @param ownerState
   */

  function appendOwnerState(elementType, existingProps = {}, ownerState) {
    if (isHostComponent(elementType)) {
      return existingProps;
    }

    return _extends({}, existingProps, {
      ownerState: _extends({}, existingProps.ownerState, ownerState)
    });
  }

  /**
   * Extracts event handlers from a given object.
   * A prop is considered an event handler if it is a function and its name starts with `on`.
   *
   * @param object An object to extract event handlers from.
   * @param excludeKeys An array of keys to exclude from the returned object.
   */
  function extractEventHandlers(object, excludeKeys = []) {
    if (object === undefined) {
      return {};
    }

    const result = {};
    Object.keys(object).filter(prop => prop.match(/^on[A-Z]/) && typeof object[prop] === 'function' && !excludeKeys.includes(prop)).forEach(prop => {
      result[prop] = object[prop];
    });
    return result;
  }

  /**
   * Creates a type that is T with removed properties that are functions with names beginning with `on`.
   * Note that it does not exactly follow the logic of `omitEventHandlers` as it also removes fields where
   * `on` is followed by a non-letter character,
   */

  /**
   * Removes event handlers from the given object.
   * A field is considered an event handler if it is a function with a name beginning with `on`.
   *
   * @param object Object to remove event handlers from.
   * @returns Object with event handlers removed.
   */
  function omitEventHandlers(object) {
    if (object === undefined) {
      return {};
    }

    const result = {};
    Object.keys(object).filter(prop => !(prop.match(/^on[A-Z]/) && typeof object[prop] === 'function')).forEach(prop => {
      result[prop] = object[prop];
    });
    return result;
  }

  /**
   * Merges the slot component internal props (usually coming from a hook)
   * with the externally provided ones.
   *
   * The merge order is (the latter overrides the former):
   * 1. The internal props (specified as a getter function to work with get*Props hook result)
   * 2. Additional props (specified internally on an unstyled component)
   * 3. External props specified on the owner component. These should only be used on a root slot.
   * 4. External props specified in the `componentsProps.*` prop.
   * 5. The `className` prop - combined from all the above.
   * @param parameters
   * @returns
   */
  function mergeSlotProps(parameters) {
    const {
      getSlotProps,
      additionalProps,
      externalSlotProps,
      externalForwardedProps,
      className
    } = parameters;

    if (!getSlotProps) {
      // The simpler case - getSlotProps is not defined, so no internal event handlers are defined,
      // so we can simply merge all the props without having to worry about extracting event handlers.
      const joinedClasses = clsx(externalForwardedProps == null ? void 0 : externalForwardedProps.className, externalSlotProps == null ? void 0 : externalSlotProps.className, className, additionalProps == null ? void 0 : additionalProps.className);

      const props = _extends({}, additionalProps, externalForwardedProps, externalSlotProps, {
        className: joinedClasses
      });

      if (joinedClasses.length === 0) {
        delete props.className;
      }

      return {
        props,
        internalRef: undefined
      };
    } // In this case, getSlotProps is responsible for calling the external event handlers.
    // We don't need to include them in the merged props because of this.


    const eventHandlers = extractEventHandlers(_extends({}, externalForwardedProps, externalSlotProps));
    const componentsPropsWithoutEventHandlers = omitEventHandlers(externalSlotProps);
    const otherPropsWithoutEventHandlers = omitEventHandlers(externalForwardedProps);
    const internalSlotProps = getSlotProps(eventHandlers);
    const joinedClasses = clsx(externalForwardedProps == null ? void 0 : externalForwardedProps.className, externalSlotProps == null ? void 0 : externalSlotProps.className, className, additionalProps == null ? void 0 : additionalProps.className, internalSlotProps == null ? void 0 : internalSlotProps.className);

    const props = _extends({}, internalSlotProps, additionalProps, otherPropsWithoutEventHandlers, componentsPropsWithoutEventHandlers, {
      className: joinedClasses
    });

    if (joinedClasses.length === 0) {
      delete props.className;
    }

    return {
      props,
      internalRef: internalSlotProps.ref
    };
  }

  /**
   * If `componentProps` is a function, calls it with the provided `ownerState`.
   * Otherwise, just returns `componentProps`.
   */
  function resolveComponentProps(componentProps, ownerState) {
    if (typeof componentProps === 'function') {
      return componentProps(ownerState);
    }

    return componentProps;
  }

  const _excluded$2d = ["elementType", "externalSlotProps", "ownerState"];

  /**
   * Builds the props to be passed into the slot of an unstyled component.
   * It merges the internal props of the component with the ones supplied by the user, allowing to customize the behavior.
   * If the slot component is not a host component, it also merges in the `ownerState`.
   *
   * @param parameters.getSlotProps - A function that returns the props to be passed to the slot component.
   */
  function useSlotProps(parameters) {
    var _parameters$additiona;

    const {
      elementType,
      externalSlotProps,
      ownerState
    } = parameters,
          rest = _objectWithoutPropertiesLoose(parameters, _excluded$2d);

    const resolvedComponentsProps = resolveComponentProps(externalSlotProps, ownerState);
    const merged = mergeSlotProps(_extends({}, rest, {
      externalSlotProps: resolvedComponentsProps
    }));
    const props = appendOwnerState(elementType, _extends({}, merged.props, {
      ref: useForkRef(merged.internalRef, useForkRef(resolvedComponentsProps == null ? void 0 : resolvedComponentsProps.ref, (_parameters$additiona = parameters.additionalProps) == null ? void 0 : _parameters$additiona.ref))
    }), ownerState);
    return props;
  }

  // Give up on IE11 support for this feature

  function stripDiacritics(string) {
    return typeof string.normalize !== 'undefined' ? string.normalize('NFD').replace(/[\u0300-\u036f]/g, '') : string;
  }

  function createFilterOptions(config = {}) {
    const {
      ignoreAccents = true,
      ignoreCase = true,
      limit,
      matchFrom = 'any',
      stringify,
      trim = false
    } = config;
    return (options, {
      inputValue,
      getOptionLabel
    }) => {
      let input = trim ? inputValue.trim() : inputValue;

      if (ignoreCase) {
        input = input.toLowerCase();
      }

      if (ignoreAccents) {
        input = stripDiacritics(input);
      }

      const filteredOptions = options.filter(option => {
        let candidate = (stringify || getOptionLabel)(option);

        if (ignoreCase) {
          candidate = candidate.toLowerCase();
        }

        if (ignoreAccents) {
          candidate = stripDiacritics(candidate);
        }

        return matchFrom === 'start' ? candidate.indexOf(input) === 0 : candidate.indexOf(input) > -1;
      });
      return typeof limit === 'number' ? filteredOptions.slice(0, limit) : filteredOptions;
    };
  } // To replace with .findIndex() once we stop IE11 support.

  function findIndex(array, comp) {
    for (let i = 0; i < array.length; i += 1) {
      if (comp(array[i])) {
        return i;
      }
    }

    return -1;
  }

  const defaultFilterOptions = createFilterOptions(); // Number of options to jump in list box when pageup and pagedown keys are used.

  const pageSize = 5;
  function useAutocomplete(props) {
    const {
      autoComplete = false,
      autoHighlight = false,
      autoSelect = false,
      blurOnSelect = false,
      disabled: disabledProp,
      clearOnBlur = !props.freeSolo,
      clearOnEscape = false,
      componentName = 'useAutocomplete',
      defaultValue = props.multiple ? [] : null,
      disableClearable = false,
      disableCloseOnSelect = false,
      disabledItemsFocusable = false,
      disableListWrap = false,
      filterOptions = defaultFilterOptions,
      filterSelectedOptions = false,
      freeSolo = false,
      getOptionDisabled,
      getOptionLabel: getOptionLabelProp = option => {
        var _option$label;

        return (_option$label = option.label) != null ? _option$label : option;
      },
      isOptionEqualToValue = (option, value) => option === value,
      groupBy,
      handleHomeEndKeys = !props.freeSolo,
      id: idProp,
      includeInputInList = false,
      inputValue: inputValueProp,
      multiple = false,
      onChange,
      onClose,
      onHighlightChange,
      onInputChange,
      onOpen,
      open: openProp,
      openOnFocus = false,
      options,
      readOnly = false,
      selectOnFocus = !props.freeSolo,
      value: valueProp
    } = props;
    const id = useId(idProp);
    let getOptionLabel = getOptionLabelProp;

    getOptionLabel = option => {
      const optionLabel = getOptionLabelProp(option);

      if (typeof optionLabel !== 'string') {
        {
          const erroneousReturn = optionLabel === undefined ? 'undefined' : `${typeof optionLabel} (${optionLabel})`;
          console.error(`MUI: The \`getOptionLabel\` method of ${componentName} returned ${erroneousReturn} instead of a string for ${JSON.stringify(option)}.`);
        }

        return String(optionLabel);
      }

      return optionLabel;
    };

    const ignoreFocus = React__namespace.useRef(false);
    const firstFocus = React__namespace.useRef(true);
    const inputRef = React__namespace.useRef(null);
    const listboxRef = React__namespace.useRef(null);
    const [anchorEl, setAnchorEl] = React__namespace.useState(null);
    const [focusedTag, setFocusedTag] = React__namespace.useState(-1);
    const defaultHighlighted = autoHighlight ? 0 : -1;
    const highlightedIndexRef = React__namespace.useRef(defaultHighlighted);
    const [value, setValueState] = useControlled({
      controlled: valueProp,
      default: defaultValue,
      name: componentName
    });
    const [inputValue, setInputValueState] = useControlled({
      controlled: inputValueProp,
      default: '',
      name: componentName,
      state: 'inputValue'
    });
    const [focused, setFocused] = React__namespace.useState(false);
    const resetInputValue = React__namespace.useCallback((event, newValue) => {
      // retain current `inputValue` if new option isn't selected and `clearOnBlur` is false
      // When `multiple` is enabled, `newValue` is an array of all selected items including the newly selected item
      const isOptionSelected = multiple ? value.length < newValue.length : newValue !== null;

      if (!isOptionSelected && !clearOnBlur) {
        return;
      }

      let newInputValue;

      if (multiple) {
        newInputValue = '';
      } else if (newValue == null) {
        newInputValue = '';
      } else {
        const optionLabel = getOptionLabel(newValue);
        newInputValue = typeof optionLabel === 'string' ? optionLabel : '';
      }

      if (inputValue === newInputValue) {
        return;
      }

      setInputValueState(newInputValue);

      if (onInputChange) {
        onInputChange(event, newInputValue, 'reset');
      }
    }, [getOptionLabel, inputValue, multiple, onInputChange, setInputValueState, clearOnBlur, value]);
    const prevValue = React__namespace.useRef();
    React__namespace.useEffect(() => {
      const valueChange = value !== prevValue.current;
      prevValue.current = value;

      if (focused && !valueChange) {
        return;
      } // Only reset the input's value when freeSolo if the component's value changes.


      if (freeSolo && !valueChange) {
        return;
      }

      resetInputValue(null, value);
    }, [value, resetInputValue, focused, prevValue, freeSolo]);
    const [open, setOpenState] = useControlled({
      controlled: openProp,
      default: false,
      name: componentName,
      state: 'open'
    });
    const [inputPristine, setInputPristine] = React__namespace.useState(true);
    const inputValueIsSelectedValue = !multiple && value != null && inputValue === getOptionLabel(value);
    const popupOpen = open && !readOnly;
    const filteredOptions = popupOpen ? filterOptions(options.filter(option => {
      if (filterSelectedOptions && (multiple ? value : [value]).some(value2 => value2 !== null && isOptionEqualToValue(option, value2))) {
        return false;
      }

      return true;
    }), // we use the empty string to manipulate `filterOptions` to not filter any options
    // i.e. the filter predicate always returns true
    {
      inputValue: inputValueIsSelectedValue && inputPristine ? '' : inputValue,
      getOptionLabel
    }) : [];
    const listboxAvailable = open && filteredOptions.length > 0 && !readOnly;

    {
      if (value !== null && !freeSolo && options.length > 0) {
        const missingValue = (multiple ? value : [value]).filter(value2 => !options.some(option => isOptionEqualToValue(option, value2)));

        if (missingValue.length > 0) {
          console.warn([`MUI: The value provided to ${componentName} is invalid.`, `None of the options match with \`${missingValue.length > 1 ? JSON.stringify(missingValue) : JSON.stringify(missingValue[0])}\`.`, 'You can use the `isOptionEqualToValue` prop to customize the equality test.'].join('\n'));
        }
      }
    }

    const focusTag = useEventCallback(tagToFocus => {
      if (tagToFocus === -1) {
        inputRef.current.focus();
      } else {
        anchorEl.querySelector(`[data-tag-index="${tagToFocus}"]`).focus();
      }
    }); // Ensure the focusedTag is never inconsistent

    React__namespace.useEffect(() => {
      if (multiple && focusedTag > value.length - 1) {
        setFocusedTag(-1);
        focusTag(-1);
      }
    }, [value, multiple, focusedTag, focusTag]);

    function validOptionIndex(index, direction) {
      if (!listboxRef.current || index === -1) {
        return -1;
      }

      let nextFocus = index;

      while (true) {
        // Out of range
        if (direction === 'next' && nextFocus === filteredOptions.length || direction === 'previous' && nextFocus === -1) {
          return -1;
        }

        const option = listboxRef.current.querySelector(`[data-option-index="${nextFocus}"]`); // Same logic as MenuList.js

        const nextFocusDisabled = disabledItemsFocusable ? false : !option || option.disabled || option.getAttribute('aria-disabled') === 'true';

        if (option && !option.hasAttribute('tabindex') || nextFocusDisabled) {
          // Move to the next element.
          nextFocus += direction === 'next' ? 1 : -1;
        } else {
          return nextFocus;
        }
      }
    }

    const setHighlightedIndex = useEventCallback(({
      event,
      index,
      reason = 'auto'
    }) => {
      highlightedIndexRef.current = index; // does the index exist?

      if (index === -1) {
        inputRef.current.removeAttribute('aria-activedescendant');
      } else {
        inputRef.current.setAttribute('aria-activedescendant', `${id}-option-${index}`);
      }

      if (onHighlightChange) {
        onHighlightChange(event, index === -1 ? null : filteredOptions[index], reason);
      }

      if (!listboxRef.current) {
        return;
      }

      const prev = listboxRef.current.querySelector('[role="option"].Mui-focused');

      if (prev) {
        prev.classList.remove('Mui-focused');
        prev.classList.remove('Mui-focusVisible');
      }

      const listboxNode = listboxRef.current.parentElement.querySelector('[role="listbox"]'); // "No results"

      if (!listboxNode) {
        return;
      }

      if (index === -1) {
        listboxNode.scrollTop = 0;
        return;
      }

      const option = listboxRef.current.querySelector(`[data-option-index="${index}"]`);

      if (!option) {
        return;
      }

      option.classList.add('Mui-focused');

      if (reason === 'keyboard') {
        option.classList.add('Mui-focusVisible');
      } // Scroll active descendant into view.
      // Logic copied from https://www.w3.org/WAI/ARIA/apg/example-index/combobox/js/select-only.js
      //
      // Consider this API instead once it has a better browser support:
      // .scrollIntoView({ scrollMode: 'if-needed', block: 'nearest' });


      if (listboxNode.scrollHeight > listboxNode.clientHeight && reason !== 'mouse') {
        const element = option;
        const scrollBottom = listboxNode.clientHeight + listboxNode.scrollTop;
        const elementBottom = element.offsetTop + element.offsetHeight;

        if (elementBottom > scrollBottom) {
          listboxNode.scrollTop = elementBottom - listboxNode.clientHeight;
        } else if (element.offsetTop - element.offsetHeight * (groupBy ? 1.3 : 0) < listboxNode.scrollTop) {
          listboxNode.scrollTop = element.offsetTop - element.offsetHeight * (groupBy ? 1.3 : 0);
        }
      }
    });
    const changeHighlightedIndex = useEventCallback(({
      event,
      diff,
      direction = 'next',
      reason = 'auto'
    }) => {
      if (!popupOpen) {
        return;
      }

      const getNextIndex = () => {
        const maxIndex = filteredOptions.length - 1;

        if (diff === 'reset') {
          return defaultHighlighted;
        }

        if (diff === 'start') {
          return 0;
        }

        if (diff === 'end') {
          return maxIndex;
        }

        const newIndex = highlightedIndexRef.current + diff;

        if (newIndex < 0) {
          if (newIndex === -1 && includeInputInList) {
            return -1;
          }

          if (disableListWrap && highlightedIndexRef.current !== -1 || Math.abs(diff) > 1) {
            return 0;
          }

          return maxIndex;
        }

        if (newIndex > maxIndex) {
          if (newIndex === maxIndex + 1 && includeInputInList) {
            return -1;
          }

          if (disableListWrap || Math.abs(diff) > 1) {
            return maxIndex;
          }

          return 0;
        }

        return newIndex;
      };

      const nextIndex = validOptionIndex(getNextIndex(), direction);
      setHighlightedIndex({
        index: nextIndex,
        reason,
        event
      }); // Sync the content of the input with the highlighted option.

      if (autoComplete && diff !== 'reset') {
        if (nextIndex === -1) {
          inputRef.current.value = inputValue;
        } else {
          const option = getOptionLabel(filteredOptions[nextIndex]);
          inputRef.current.value = option; // The portion of the selected suggestion that has not been typed by the user,
          // a completion string, appears inline after the input cursor in the textbox.

          const index = option.toLowerCase().indexOf(inputValue.toLowerCase());

          if (index === 0 && inputValue.length > 0) {
            inputRef.current.setSelectionRange(inputValue.length, option.length);
          }
        }
      }
    });
    const syncHighlightedIndex = React__namespace.useCallback(() => {
      if (!popupOpen) {
        return;
      }

      const valueItem = multiple ? value[0] : value; // The popup is empty, reset

      if (filteredOptions.length === 0 || valueItem == null) {
        changeHighlightedIndex({
          diff: 'reset'
        });
        return;
      }

      if (!listboxRef.current) {
        return;
      } // Synchronize the value with the highlighted index


      if (valueItem != null) {
        const currentOption = filteredOptions[highlightedIndexRef.current]; // Keep the current highlighted index if possible

        if (multiple && currentOption && findIndex(value, val => isOptionEqualToValue(currentOption, val)) !== -1) {
          return;
        }

        const itemIndex = findIndex(filteredOptions, optionItem => isOptionEqualToValue(optionItem, valueItem));

        if (itemIndex === -1) {
          changeHighlightedIndex({
            diff: 'reset'
          });
        } else {
          setHighlightedIndex({
            index: itemIndex
          });
        }

        return;
      } // Prevent the highlighted index to leak outside the boundaries.


      if (highlightedIndexRef.current >= filteredOptions.length - 1) {
        setHighlightedIndex({
          index: filteredOptions.length - 1
        });
        return;
      } // Restore the focus to the previous index.


      setHighlightedIndex({
        index: highlightedIndexRef.current
      }); // Ignore filteredOptions (and options, isOptionEqualToValue, getOptionLabel) not to break the scroll position
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [// Only sync the highlighted index when the option switch between empty and not
    filteredOptions.length, // Don't sync the highlighted index with the value when multiple
    // eslint-disable-next-line react-hooks/exhaustive-deps
    multiple ? false : value, filterSelectedOptions, changeHighlightedIndex, setHighlightedIndex, popupOpen, inputValue, multiple]);
    const handleListboxRef = useEventCallback(node => {
      setRef(listboxRef, node);

      if (!node) {
        return;
      }

      syncHighlightedIndex();
    });

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useEffect(() => {
        if (!inputRef.current || inputRef.current.nodeName !== 'INPUT') {
          if (inputRef.current && inputRef.current.nodeName === 'TEXTAREA') {
            console.warn([`A textarea element was provided to ${componentName} where input was expected.`, `This is not a supported scenario but it may work under certain conditions.`, `A textarea keyboard navigation may conflict with Autocomplete controls (e.g. enter and arrow keys).`, `Make sure to test keyboard navigation and add custom event handlers if necessary.`].join('\n'));
          } else {
            console.error([`MUI: Unable to find the input element. It was resolved to ${inputRef.current} while an HTMLInputElement was expected.`, `Instead, ${componentName} expects an input element.`, '', componentName === 'useAutocomplete' ? 'Make sure you have binded getInputProps correctly and that the normal ref/effect resolutions order is guaranteed.' : 'Make sure you have customized the input component correctly.'].join('\n'));
          }
        }
      }, [componentName]);
    }

    React__namespace.useEffect(() => {
      syncHighlightedIndex();
    }, [syncHighlightedIndex]);

    const handleOpen = event => {
      if (open) {
        return;
      }

      setOpenState(true);
      setInputPristine(true);

      if (onOpen) {
        onOpen(event);
      }
    };

    const handleClose = (event, reason) => {
      if (!open) {
        return;
      }

      setOpenState(false);

      if (onClose) {
        onClose(event, reason);
      }
    };

    const handleValue = (event, newValue, reason, details) => {
      if (multiple) {
        if (value.length === newValue.length && value.every((val, i) => val === newValue[i])) {
          return;
        }
      } else if (value === newValue) {
        return;
      }

      if (onChange) {
        onChange(event, newValue, reason, details);
      }

      setValueState(newValue);
    };

    const isTouch = React__namespace.useRef(false);

    const selectNewValue = (event, option, reasonProp = 'selectOption', origin = 'options') => {
      let reason = reasonProp;
      let newValue = option;

      if (multiple) {
        newValue = Array.isArray(value) ? value.slice() : [];

        {
          const matches = newValue.filter(val => isOptionEqualToValue(option, val));

          if (matches.length > 1) {
            console.error([`MUI: The \`isOptionEqualToValue\` method of ${componentName} do not handle the arguments correctly.`, `The component expects a single value to match a given option but found ${matches.length} matches.`].join('\n'));
          }
        }

        const itemIndex = findIndex(newValue, valueItem => isOptionEqualToValue(option, valueItem));

        if (itemIndex === -1) {
          newValue.push(option);
        } else if (origin !== 'freeSolo') {
          newValue.splice(itemIndex, 1);
          reason = 'removeOption';
        }
      }

      resetInputValue(event, newValue);
      handleValue(event, newValue, reason, {
        option
      });

      if (!disableCloseOnSelect && !event.ctrlKey && !event.metaKey) {
        handleClose(event, reason);
      }

      if (blurOnSelect === true || blurOnSelect === 'touch' && isTouch.current || blurOnSelect === 'mouse' && !isTouch.current) {
        inputRef.current.blur();
      }
    };

    function validTagIndex(index, direction) {
      if (index === -1) {
        return -1;
      }

      let nextFocus = index;

      while (true) {
        // Out of range
        if (direction === 'next' && nextFocus === value.length || direction === 'previous' && nextFocus === -1) {
          return -1;
        }

        const option = anchorEl.querySelector(`[data-tag-index="${nextFocus}"]`); // Same logic as MenuList.js

        if (!option || !option.hasAttribute('tabindex') || option.disabled || option.getAttribute('aria-disabled') === 'true') {
          nextFocus += direction === 'next' ? 1 : -1;
        } else {
          return nextFocus;
        }
      }
    }

    const handleFocusTag = (event, direction) => {
      if (!multiple) {
        return;
      }

      if (inputValue === '') {
        handleClose(event, 'toggleInput');
      }

      let nextTag = focusedTag;

      if (focusedTag === -1) {
        if (inputValue === '' && direction === 'previous') {
          nextTag = value.length - 1;
        }
      } else {
        nextTag += direction === 'next' ? 1 : -1;

        if (nextTag < 0) {
          nextTag = 0;
        }

        if (nextTag === value.length) {
          nextTag = -1;
        }
      }

      nextTag = validTagIndex(nextTag, direction);
      setFocusedTag(nextTag);
      focusTag(nextTag);
    };

    const handleClear = event => {
      ignoreFocus.current = true;
      setInputValueState('');

      if (onInputChange) {
        onInputChange(event, '', 'clear');
      }

      handleValue(event, multiple ? [] : null, 'clear');
    };

    const handleKeyDown = other => event => {
      if (other.onKeyDown) {
        other.onKeyDown(event);
      }

      if (event.defaultMuiPrevented) {
        return;
      }

      if (focusedTag !== -1 && ['ArrowLeft', 'ArrowRight'].indexOf(event.key) === -1) {
        setFocusedTag(-1);
        focusTag(-1);
      } // Wait until IME is settled.


      if (event.which !== 229) {
        switch (event.key) {
          case 'Home':
            if (popupOpen && handleHomeEndKeys) {
              // Prevent scroll of the page
              event.preventDefault();
              changeHighlightedIndex({
                diff: 'start',
                direction: 'next',
                reason: 'keyboard',
                event
              });
            }

            break;

          case 'End':
            if (popupOpen && handleHomeEndKeys) {
              // Prevent scroll of the page
              event.preventDefault();
              changeHighlightedIndex({
                diff: 'end',
                direction: 'previous',
                reason: 'keyboard',
                event
              });
            }

            break;

          case 'PageUp':
            // Prevent scroll of the page
            event.preventDefault();
            changeHighlightedIndex({
              diff: -pageSize,
              direction: 'previous',
              reason: 'keyboard',
              event
            });
            handleOpen(event);
            break;

          case 'PageDown':
            // Prevent scroll of the page
            event.preventDefault();
            changeHighlightedIndex({
              diff: pageSize,
              direction: 'next',
              reason: 'keyboard',
              event
            });
            handleOpen(event);
            break;

          case 'ArrowDown':
            // Prevent cursor move
            event.preventDefault();
            changeHighlightedIndex({
              diff: 1,
              direction: 'next',
              reason: 'keyboard',
              event
            });
            handleOpen(event);
            break;

          case 'ArrowUp':
            // Prevent cursor move
            event.preventDefault();
            changeHighlightedIndex({
              diff: -1,
              direction: 'previous',
              reason: 'keyboard',
              event
            });
            handleOpen(event);
            break;

          case 'ArrowLeft':
            handleFocusTag(event, 'previous');
            break;

          case 'ArrowRight':
            handleFocusTag(event, 'next');
            break;

          case 'Enter':
            if (highlightedIndexRef.current !== -1 && popupOpen) {
              const option = filteredOptions[highlightedIndexRef.current];
              const disabled = getOptionDisabled ? getOptionDisabled(option) : false; // Avoid early form validation, let the end-users continue filling the form.

              event.preventDefault();

              if (disabled) {
                return;
              }

              selectNewValue(event, option, 'selectOption'); // Move the selection to the end.

              if (autoComplete) {
                inputRef.current.setSelectionRange(inputRef.current.value.length, inputRef.current.value.length);
              }
            } else if (freeSolo && inputValue !== '' && inputValueIsSelectedValue === false) {
              if (multiple) {
                // Allow people to add new values before they submit the form.
                event.preventDefault();
              }

              selectNewValue(event, inputValue, 'createOption', 'freeSolo');
            }

            break;

          case 'Escape':
            if (popupOpen) {
              // Avoid Opera to exit fullscreen mode.
              event.preventDefault(); // Avoid the Modal to handle the event.

              event.stopPropagation();
              handleClose(event, 'escape');
            } else if (clearOnEscape && (inputValue !== '' || multiple && value.length > 0)) {
              // Avoid Opera to exit fullscreen mode.
              event.preventDefault(); // Avoid the Modal to handle the event.

              event.stopPropagation();
              handleClear(event);
            }

            break;

          case 'Backspace':
            if (multiple && !readOnly && inputValue === '' && value.length > 0) {
              const index = focusedTag === -1 ? value.length - 1 : focusedTag;
              const newValue = value.slice();
              newValue.splice(index, 1);
              handleValue(event, newValue, 'removeOption', {
                option: value[index]
              });
            }

            break;
        }
      }
    };

    const handleFocus = event => {
      setFocused(true);

      if (openOnFocus && !ignoreFocus.current) {
        handleOpen(event);
      }
    };

    const handleBlur = event => {
      // Ignore the event when using the scrollbar with IE11
      if (listboxRef.current !== null && listboxRef.current.parentElement.contains(document.activeElement)) {
        inputRef.current.focus();
        return;
      }

      setFocused(false);
      firstFocus.current = true;
      ignoreFocus.current = false;

      if (autoSelect && highlightedIndexRef.current !== -1 && popupOpen) {
        selectNewValue(event, filteredOptions[highlightedIndexRef.current], 'blur');
      } else if (autoSelect && freeSolo && inputValue !== '') {
        selectNewValue(event, inputValue, 'blur', 'freeSolo');
      } else if (clearOnBlur) {
        resetInputValue(event, value);
      }

      handleClose(event, 'blur');
    };

    const handleInputChange = event => {
      const newValue = event.target.value;

      if (inputValue !== newValue) {
        setInputValueState(newValue);
        setInputPristine(false);

        if (onInputChange) {
          onInputChange(event, newValue, 'input');
        }
      }

      if (newValue === '') {
        if (!disableClearable && !multiple) {
          handleValue(event, null, 'clear');
        }
      } else {
        handleOpen(event);
      }
    };

    const handleOptionMouseOver = event => {
      setHighlightedIndex({
        event,
        index: Number(event.currentTarget.getAttribute('data-option-index')),
        reason: 'mouse'
      });
    };

    const handleOptionTouchStart = () => {
      isTouch.current = true;
    };

    const handleOptionClick = event => {
      const index = Number(event.currentTarget.getAttribute('data-option-index'));
      selectNewValue(event, filteredOptions[index], 'selectOption');
      isTouch.current = false;
    };

    const handleTagDelete = index => event => {
      const newValue = value.slice();
      newValue.splice(index, 1);
      handleValue(event, newValue, 'removeOption', {
        option: value[index]
      });
    };

    const handlePopupIndicator = event => {
      if (open) {
        handleClose(event, 'toggleInput');
      } else {
        handleOpen(event);
      }
    }; // Prevent input blur when interacting with the combobox


    const handleMouseDown = event => {
      if (event.target.getAttribute('id') !== id) {
        event.preventDefault();
      }
    }; // Focus the input when interacting with the combobox


    const handleClick = () => {
      inputRef.current.focus();

      if (selectOnFocus && firstFocus.current && inputRef.current.selectionEnd - inputRef.current.selectionStart === 0) {
        inputRef.current.select();
      }

      firstFocus.current = false;
    };

    const handleInputMouseDown = event => {
      if (inputValue === '' || !open) {
        handlePopupIndicator(event);
      }
    };

    let dirty = freeSolo && inputValue.length > 0;
    dirty = dirty || (multiple ? value.length > 0 : value !== null);
    let groupedOptions = filteredOptions;

    if (groupBy) {
      // used to keep track of key and indexes in the result array
      const indexBy = new Map();
      let warn = false;
      groupedOptions = filteredOptions.reduce((acc, option, index) => {
        const group = groupBy(option);

        if (acc.length > 0 && acc[acc.length - 1].group === group) {
          acc[acc.length - 1].options.push(option);
        } else {
          {
            if (indexBy.get(group) && !warn) {
              console.warn(`MUI: The options provided combined with the \`groupBy\` method of ${componentName} returns duplicated headers.`, 'You can solve the issue by sorting the options with the output of `groupBy`.');
              warn = true;
            }

            indexBy.set(group, true);
          }

          acc.push({
            key: index,
            index,
            group,
            options: [option]
          });
        }

        return acc;
      }, []);
    }

    if (disabledProp && focused) {
      handleBlur();
    }

    return {
      getRootProps: (other = {}) => _extends({
        'aria-owns': listboxAvailable ? `${id}-listbox` : null
      }, other, {
        onKeyDown: handleKeyDown(other),
        onMouseDown: handleMouseDown,
        onClick: handleClick
      }),
      getInputLabelProps: () => ({
        id: `${id}-label`,
        htmlFor: id
      }),
      getInputProps: () => ({
        id,
        value: inputValue,
        onBlur: handleBlur,
        onFocus: handleFocus,
        onChange: handleInputChange,
        onMouseDown: handleInputMouseDown,
        // if open then this is handled imperativeley so don't let react override
        // only have an opinion about this when closed
        'aria-activedescendant': popupOpen ? '' : null,
        'aria-autocomplete': autoComplete ? 'both' : 'list',
        'aria-controls': listboxAvailable ? `${id}-listbox` : undefined,
        'aria-expanded': listboxAvailable,
        // Disable browser's suggestion that might overlap with the popup.
        // Handle autocomplete but not autofill.
        autoComplete: 'off',
        ref: inputRef,
        autoCapitalize: 'none',
        spellCheck: 'false',
        role: 'combobox'
      }),
      getClearProps: () => ({
        tabIndex: -1,
        onClick: handleClear
      }),
      getPopupIndicatorProps: () => ({
        tabIndex: -1,
        onClick: handlePopupIndicator
      }),
      getTagProps: ({
        index
      }) => _extends({
        key: index,
        'data-tag-index': index,
        tabIndex: -1
      }, !readOnly && {
        onDelete: handleTagDelete(index)
      }),
      getListboxProps: () => ({
        role: 'listbox',
        id: `${id}-listbox`,
        'aria-labelledby': `${id}-label`,
        ref: handleListboxRef,
        onMouseDown: event => {
          // Prevent blur
          event.preventDefault();
        }
      }),
      getOptionProps: ({
        index,
        option
      }) => {
        const selected = (multiple ? value : [value]).some(value2 => value2 != null && isOptionEqualToValue(option, value2));
        const disabled = getOptionDisabled ? getOptionDisabled(option) : false;
        return {
          key: getOptionLabel(option),
          tabIndex: -1,
          role: 'option',
          id: `${id}-option-${index}`,
          onMouseOver: handleOptionMouseOver,
          onClick: handleOptionClick,
          onTouchStart: handleOptionTouchStart,
          'data-option-index': index,
          'aria-disabled': disabled,
          'aria-selected': selected
        };
      },
      id,
      inputValue,
      value,
      dirty,
      popupOpen,
      focused: focused || focusedTag !== -1,
      anchorEl,
      setAnchorEl,
      focusedTag,
      groupedOptions
    };
  }

  function useBadge(parameters) {
    const {
      badgeContent: badgeContentProp,
      invisible: invisibleProp = false,
      max: maxProp = 99,
      showZero = false
    } = parameters;
    const prevProps = usePreviousProps$1({
      badgeContent: badgeContentProp,
      max: maxProp
    });
    let invisible = invisibleProp;

    if (invisibleProp === false && badgeContentProp === 0 && !showZero) {
      invisible = true;
    }

    const {
      badgeContent,
      max = maxProp
    } = invisible ? prevProps : parameters;
    const displayValue = badgeContent && Number(badgeContent) > max ? `${max}+` : badgeContent;
    return {
      badgeContent,
      invisible,
      max,
      displayValue
    };
  }

  function getBadgeUnstyledUtilityClass(slot) {
    return generateUtilityClass('BaseBadge', slot);
  }
  generateUtilityClasses('BaseBadge', ['root', 'badge', 'invisible']);

  const _excluded$2c = ["badgeContent", "component", "children", "components", "componentsProps", "invisible", "max", "showZero"];

  const useUtilityClasses$1O = ownerState => {
    const {
      invisible
    } = ownerState;
    const slots = {
      root: ['root'],
      badge: ['badge', invisible && 'invisible']
    };
    return composeClasses(slots, getBadgeUnstyledUtilityClass, undefined);
  };
  /**
   *
   * Demos:
   *
   * - [Badge](https://mui.com/base/react-badge/)
   *
   * API:
   *
   * - [BadgeUnstyled API](https://mui.com/base/api/badge-unstyled/)
   */


  const BadgeUnstyled = /*#__PURE__*/React__namespace.forwardRef(function BadgeUnstyled(props, ref) {
    const {
      component,
      children,
      components = {},
      componentsProps = {},
      max: maxProp = 99,
      showZero = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$2c);

    const {
      badgeContent,
      max,
      displayValue,
      invisible
    } = useBadge(_extends({}, props, {
      max: maxProp
    }));

    const ownerState = _extends({}, props, {
      badgeContent,
      invisible,
      max,
      showZero
    });

    const classes = useUtilityClasses$1O(ownerState);
    const Root = component || components.Root || 'span';
    const rootProps = useSlotProps({
      elementType: Root,
      externalSlotProps: componentsProps.root,
      externalForwardedProps: other,
      additionalProps: {
        ref
      },
      ownerState,
      className: classes.root
    });
    const Badge = components.Badge || 'span';
    const badgeProps = useSlotProps({
      elementType: Badge,
      externalSlotProps: componentsProps.badge,
      ownerState,
      className: classes.badge
    });
    return /*#__PURE__*/jsxRuntime_2(Root, _extends({}, rootProps, {
      children: [children, /*#__PURE__*/jsxRuntime_1(Badge, _extends({}, badgeProps, {
        children: displayValue
      }))]
    }));
  });
  BadgeUnstyled.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit TypeScript types and run "yarn proptypes"  |
    // ----------------------------------------------------------------------

    /**
     * The content rendered within the badge.
     */
    badgeContent: PropTypes.node,

    /**
     * The badge will be added relative to this node.
     */
    children: PropTypes.node,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The components used for each slot inside the Badge.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Badge: PropTypes.elementType,
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Badge.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      badge: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),

    /**
     * If `true`, the badge is invisible.
     * @default false
     */
    invisible: PropTypes.bool,

    /**
     * Max count to show.
     * @default 99
     */
    max: PropTypes.number,

    /**
     * Controls whether the badge is hidden when `badgeContent` is zero.
     * @default false
     */
    showZero: PropTypes.bool
  } ;
  var BadgeUnstyled$1 = BadgeUnstyled;

  function mapEventPropToEvent(eventProp) {
    return eventProp.substring(2).toLowerCase();
  }

  function clickedRootScrollbar(event, doc) {
    return doc.documentElement.clientWidth < event.clientX || doc.documentElement.clientHeight < event.clientY;
  }

  /**
   * Listen for click events that occur somewhere in the document, outside of the element itself.
   * For instance, if you need to hide a menu when people click anywhere else on your page.
   *
   * Demos:
   *
   * - [Click away listener](https://mui.com/base/react-click-away-listener/)
   *
   * API:
   *
   * - [ClickAwayListener API](https://mui.com/base/api/click-away-listener/)
   */
  function ClickAwayListener(props) {
    const {
      children,
      disableReactTree = false,
      mouseEvent = 'onClick',
      onClickAway,
      touchEvent = 'onTouchEnd'
    } = props;
    const movedRef = React__namespace.useRef(false);
    const nodeRef = React__namespace.useRef(null);
    const activatedRef = React__namespace.useRef(false);
    const syntheticEventRef = React__namespace.useRef(false);
    React__namespace.useEffect(() => {
      // Ensure that this component is not "activated" synchronously.
      // https://github.com/facebook/react/issues/20074
      setTimeout(() => {
        activatedRef.current = true;
      }, 0);
      return () => {
        activatedRef.current = false;
      };
    }, []);
    const handleRef = useForkRef( // @ts-expect-error TODO upstream fix
    children.ref, nodeRef); // The handler doesn't take event.defaultPrevented into account:
    //
    // event.preventDefault() is meant to stop default behaviors like
    // clicking a checkbox to check it, hitting a button to submit a form,
    // and hitting left arrow to move the cursor in a text input etc.
    // Only special HTML elements have these default behaviors.

    const handleClickAway = useEventCallback(event => {
      // Given developers can stop the propagation of the synthetic event,
      // we can only be confident with a positive value.
      const insideReactTree = syntheticEventRef.current;
      syntheticEventRef.current = false;
      const doc = ownerDocument(nodeRef.current); // 1. IE11 support, which trigger the handleClickAway even after the unbind
      // 2. The child might render null.
      // 3. Behave like a blur listener.

      if (!activatedRef.current || !nodeRef.current || 'clientX' in event && clickedRootScrollbar(event, doc)) {
        return;
      } // Do not act if user performed touchmove


      if (movedRef.current) {
        movedRef.current = false;
        return;
      }

      let insideDOM; // If not enough, can use https://github.com/DieterHolvoet/event-propagation-path/blob/master/propagationPath.js

      if (event.composedPath) {
        insideDOM = event.composedPath().indexOf(nodeRef.current) > -1;
      } else {
        insideDOM = !doc.documentElement.contains( // @ts-expect-error returns `false` as intended when not dispatched from a Node
        event.target) || nodeRef.current.contains( // @ts-expect-error returns `false` as intended when not dispatched from a Node
        event.target);
      }

      if (!insideDOM && (disableReactTree || !insideReactTree)) {
        onClickAway(event);
      }
    }); // Keep track of mouse/touch events that bubbled up through the portal.

    const createHandleSynthetic = handlerName => event => {
      syntheticEventRef.current = true;
      const childrenPropsHandler = children.props[handlerName];

      if (childrenPropsHandler) {
        childrenPropsHandler(event);
      }
    };

    const childrenProps = {
      ref: handleRef
    };

    if (touchEvent !== false) {
      childrenProps[touchEvent] = createHandleSynthetic(touchEvent);
    }

    React__namespace.useEffect(() => {
      if (touchEvent !== false) {
        const mappedTouchEvent = mapEventPropToEvent(touchEvent);
        const doc = ownerDocument(nodeRef.current);

        const handleTouchMove = () => {
          movedRef.current = true;
        };

        doc.addEventListener(mappedTouchEvent, handleClickAway);
        doc.addEventListener('touchmove', handleTouchMove);
        return () => {
          doc.removeEventListener(mappedTouchEvent, handleClickAway);
          doc.removeEventListener('touchmove', handleTouchMove);
        };
      }

      return undefined;
    }, [handleClickAway, touchEvent]);

    if (mouseEvent !== false) {
      childrenProps[mouseEvent] = createHandleSynthetic(mouseEvent);
    }

    React__namespace.useEffect(() => {
      if (mouseEvent !== false) {
        const mappedMouseEvent = mapEventPropToEvent(mouseEvent);
        const doc = ownerDocument(nodeRef.current);
        doc.addEventListener(mappedMouseEvent, handleClickAway);
        return () => {
          doc.removeEventListener(mappedMouseEvent, handleClickAway);
        };
      }

      return undefined;
    }, [handleClickAway, mouseEvent]);
    return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
      children: /*#__PURE__*/React__namespace.cloneElement(children, childrenProps)
    });
  }

  ClickAwayListener.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit TypeScript types and run "yarn proptypes"  |
    // ----------------------------------------------------------------------

    /**
     * The wrapped element.
     */
    children: elementAcceptingRef$1.isRequired,

    /**
     * If `true`, the React tree is ignored and only the DOM tree is considered.
     * This prop changes how portaled elements are handled.
     * @default false
     */
    disableReactTree: PropTypes.bool,

    /**
     * The mouse event to listen to. You can disable the listener by providing `false`.
     * @default 'onClick'
     */
    mouseEvent: PropTypes.oneOf(['onClick', 'onMouseDown', 'onMouseUp', 'onPointerDown', 'onPointerUp', false]),

    /**
     * Callback fired when a "click away" event is detected.
     */
    onClickAway: PropTypes.func.isRequired,

    /**
     * The touch event to listen to. You can disable the listener by providing `false`.
     * @default 'onTouchEnd'
     */
    touchEvent: PropTypes.oneOf(['onTouchEnd', 'onTouchStart', false])
  } ;

  {
    // eslint-disable-next-line
    ClickAwayListener['propTypes' + ''] = exactProp(ClickAwayListener.propTypes);
  }

  var top = 'top';
  var bottom = 'bottom';
  var right = 'right';
  var left = 'left';
  var auto = 'auto';
  var basePlacements = [top, bottom, right, left];
  var start = 'start';
  var end = 'end';
  var clippingParents = 'clippingParents';
  var viewport = 'viewport';
  var popper = 'popper';
  var reference = 'reference';
  var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
    return acc.concat([placement + "-" + start, placement + "-" + end]);
  }, []);
  var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
    return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
  }, []); // modifiers that need to read the DOM

  var beforeRead = 'beforeRead';
  var read = 'read';
  var afterRead = 'afterRead'; // pure-logic modifiers

  var beforeMain = 'beforeMain';
  var main = 'main';
  var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

  var beforeWrite = 'beforeWrite';
  var write = 'write';
  var afterWrite = 'afterWrite';
  var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

  function getNodeName(element) {
    return element ? (element.nodeName || '').toLowerCase() : null;
  }

  function getWindow(node) {
    if (node == null) {
      return window;
    }

    if (node.toString() !== '[object Window]') {
      var ownerDocument = node.ownerDocument;
      return ownerDocument ? ownerDocument.defaultView || window : window;
    }

    return node;
  }

  function isElement(node) {
    var OwnElement = getWindow(node).Element;
    return node instanceof OwnElement || node instanceof Element;
  }

  function isHTMLElement(node) {
    var OwnElement = getWindow(node).HTMLElement;
    return node instanceof OwnElement || node instanceof HTMLElement;
  }

  function isShadowRoot(node) {
    // IE 11 has no ShadowRoot
    if (typeof ShadowRoot === 'undefined') {
      return false;
    }

    var OwnElement = getWindow(node).ShadowRoot;
    return node instanceof OwnElement || node instanceof ShadowRoot;
  }

  // and applies them to the HTMLElements such as popper and arrow

  function applyStyles(_ref) {
    var state = _ref.state;
    Object.keys(state.elements).forEach(function (name) {
      var style = state.styles[name] || {};
      var attributes = state.attributes[name] || {};
      var element = state.elements[name]; // arrow is optional + virtual elements

      if (!isHTMLElement(element) || !getNodeName(element)) {
        return;
      } // Flow doesn't support to extend this property, but it's the most
      // effective way to apply styles to an HTMLElement
      // $FlowFixMe[cannot-write]


      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (name) {
        var value = attributes[name];

        if (value === false) {
          element.removeAttribute(name);
        } else {
          element.setAttribute(name, value === true ? '' : value);
        }
      });
    });
  }

  function effect$2(_ref2) {
    var state = _ref2.state;
    var initialStyles = {
      popper: {
        position: state.options.strategy,
        left: '0',
        top: '0',
        margin: '0'
      },
      arrow: {
        position: 'absolute'
      },
      reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    state.styles = initialStyles;

    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }

    return function () {
      Object.keys(state.elements).forEach(function (name) {
        var element = state.elements[name];
        var attributes = state.attributes[name] || {};
        var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

        var style = styleProperties.reduce(function (style, property) {
          style[property] = '';
          return style;
        }, {}); // arrow is optional + virtual elements

        if (!isHTMLElement(element) || !getNodeName(element)) {
          return;
        }

        Object.assign(element.style, style);
        Object.keys(attributes).forEach(function (attribute) {
          element.removeAttribute(attribute);
        });
      });
    };
  } // eslint-disable-next-line import/no-unused-modules


  var applyStyles$1 = {
    name: 'applyStyles',
    enabled: true,
    phase: 'write',
    fn: applyStyles,
    effect: effect$2,
    requires: ['computeStyles']
  };

  function getBasePlacement(placement) {
    return placement.split('-')[0];
  }

  var max = Math.max;
  var min = Math.min;
  var round$2 = Math.round;

  function getBoundingClientRect(element, includeScale) {
    if (includeScale === void 0) {
      includeScale = false;
    }

    var rect = element.getBoundingClientRect();
    var scaleX = 1;
    var scaleY = 1;

    if (isHTMLElement(element) && includeScale) {
      var offsetHeight = element.offsetHeight;
      var offsetWidth = element.offsetWidth; // Do not attempt to divide by 0, otherwise we get `Infinity` as scale
      // Fallback to 1 in case both values are `0`

      if (offsetWidth > 0) {
        scaleX = round$2(rect.width) / offsetWidth || 1;
      }

      if (offsetHeight > 0) {
        scaleY = round$2(rect.height) / offsetHeight || 1;
      }
    }

    return {
      width: rect.width / scaleX,
      height: rect.height / scaleY,
      top: rect.top / scaleY,
      right: rect.right / scaleX,
      bottom: rect.bottom / scaleY,
      left: rect.left / scaleX,
      x: rect.left / scaleX,
      y: rect.top / scaleY
    };
  }

  // means it doesn't take into account transforms.

  function getLayoutRect(element) {
    var clientRect = getBoundingClientRect(element); // Use the clientRect sizes if it's not been transformed.
    // Fixes https://github.com/popperjs/popper-core/issues/1223

    var width = element.offsetWidth;
    var height = element.offsetHeight;

    if (Math.abs(clientRect.width - width) <= 1) {
      width = clientRect.width;
    }

    if (Math.abs(clientRect.height - height) <= 1) {
      height = clientRect.height;
    }

    return {
      x: element.offsetLeft,
      y: element.offsetTop,
      width: width,
      height: height
    };
  }

  function contains(parent, child) {
    var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

    if (parent.contains(child)) {
      return true;
    } // then fallback to custom implementation with Shadow DOM support
    else if (rootNode && isShadowRoot(rootNode)) {
        var next = child;

        do {
          if (next && parent.isSameNode(next)) {
            return true;
          } // $FlowFixMe[prop-missing]: need a better way to handle this...


          next = next.parentNode || next.host;
        } while (next);
      } // Give up, the result is false


    return false;
  }

  function getComputedStyle(element) {
    return getWindow(element).getComputedStyle(element);
  }

  function isTableElement(element) {
    return ['table', 'td', 'th'].indexOf(getNodeName(element)) >= 0;
  }

  function getDocumentElement(element) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return ((isElement(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
    element.document) || window.document).documentElement;
  }

  function getParentNode(element) {
    if (getNodeName(element) === 'html') {
      return element;
    }

    return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
      // $FlowFixMe[incompatible-return]
      // $FlowFixMe[prop-missing]
      element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
      element.parentNode || ( // DOM Element detected
      isShadowRoot(element) ? element.host : null) || // ShadowRoot detected
      // $FlowFixMe[incompatible-call]: HTMLElement is a Node
      getDocumentElement(element) // fallback

    );
  }

  function getTrueOffsetParent(element) {
    if (!isHTMLElement(element) || // https://github.com/popperjs/popper-core/issues/837
    getComputedStyle(element).position === 'fixed') {
      return null;
    }

    return element.offsetParent;
  } // `.offsetParent` reports `null` for fixed elements, while absolute elements
  // return the containing block


  function getContainingBlock(element) {
    var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') !== -1;
    var isIE = navigator.userAgent.indexOf('Trident') !== -1;

    if (isIE && isHTMLElement(element)) {
      // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
      var elementCss = getComputedStyle(element);

      if (elementCss.position === 'fixed') {
        return null;
      }
    }

    var currentNode = getParentNode(element);

    if (isShadowRoot(currentNode)) {
      currentNode = currentNode.host;
    }

    while (isHTMLElement(currentNode) && ['html', 'body'].indexOf(getNodeName(currentNode)) < 0) {
      var css = getComputedStyle(currentNode); // This is non-exhaustive but covers the most common CSS properties that
      // create a containing block.
      // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

      if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
        return currentNode;
      } else {
        currentNode = currentNode.parentNode;
      }
    }

    return null;
  } // Gets the closest ancestor positioned element. Handles some edge cases,
  // such as table ancestors and cross browser bugs.


  function getOffsetParent(element) {
    var window = getWindow(element);
    var offsetParent = getTrueOffsetParent(element);

    while (offsetParent && isTableElement(offsetParent) && getComputedStyle(offsetParent).position === 'static') {
      offsetParent = getTrueOffsetParent(offsetParent);
    }

    if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle(offsetParent).position === 'static')) {
      return window;
    }

    return offsetParent || getContainingBlock(element) || window;
  }

  function getMainAxisFromPlacement(placement) {
    return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
  }

  function within(min$1, value, max$1) {
    return max(min$1, min(value, max$1));
  }
  function withinMaxClamp(min, value, max) {
    var v = within(min, value, max);
    return v > max ? max : v;
  }

  function getFreshSideObject() {
    return {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
  }

  function mergePaddingObject(paddingObject) {
    return Object.assign({}, getFreshSideObject(), paddingObject);
  }

  function expandToHashMap(value, keys) {
    return keys.reduce(function (hashMap, key) {
      hashMap[key] = value;
      return hashMap;
    }, {});
  }

  var toPaddingObject = function toPaddingObject(padding, state) {
    padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
      placement: state.placement
    })) : padding;
    return mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
  };

  function arrow(_ref) {
    var _state$modifiersData$;

    var state = _ref.state,
        name = _ref.name,
        options = _ref.options;
    var arrowElement = state.elements.arrow;
    var popperOffsets = state.modifiersData.popperOffsets;
    var basePlacement = getBasePlacement(state.placement);
    var axis = getMainAxisFromPlacement(basePlacement);
    var isVertical = [left, right].indexOf(basePlacement) >= 0;
    var len = isVertical ? 'height' : 'width';

    if (!arrowElement || !popperOffsets) {
      return;
    }

    var paddingObject = toPaddingObject(options.padding, state);
    var arrowRect = getLayoutRect(arrowElement);
    var minProp = axis === 'y' ? top : left;
    var maxProp = axis === 'y' ? bottom : right;
    var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
    var startDiff = popperOffsets[axis] - state.rects.reference[axis];
    var arrowOffsetParent = getOffsetParent(arrowElement);
    var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
    var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
    // outside of the popper bounds

    var min = paddingObject[minProp];
    var max = clientSize - arrowRect[len] - paddingObject[maxProp];
    var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
    var offset = within(min, center, max); // Prevents breaking syntax highlighting...

    var axisProp = axis;
    state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
  }

  function effect$1(_ref2) {
    var state = _ref2.state,
        options = _ref2.options;
    var _options$element = options.element,
        arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

    if (arrowElement == null) {
      return;
    } // CSS selector


    if (typeof arrowElement === 'string') {
      arrowElement = state.elements.popper.querySelector(arrowElement);

      if (!arrowElement) {
        return;
      }
    }

    {
      if (!isHTMLElement(arrowElement)) {
        console.error(['Popper: "arrow" element must be an HTMLElement (not an SVGElement).', 'To use an SVG arrow, wrap it in an HTMLElement that will be used as', 'the arrow.'].join(' '));
      }
    }

    if (!contains(state.elements.popper, arrowElement)) {
      {
        console.error(['Popper: "arrow" modifier\'s `element` must be a child of the popper', 'element.'].join(' '));
      }

      return;
    }

    state.elements.arrow = arrowElement;
  } // eslint-disable-next-line import/no-unused-modules


  var arrow$1 = {
    name: 'arrow',
    enabled: true,
    phase: 'main',
    fn: arrow,
    effect: effect$1,
    requires: ['popperOffsets'],
    requiresIfExists: ['preventOverflow']
  };

  function getVariation(placement) {
    return placement.split('-')[1];
  }

  var unsetSides = {
    top: 'auto',
    right: 'auto',
    bottom: 'auto',
    left: 'auto'
  }; // Round the offsets to the nearest suitable subpixel based on the DPR.
  // Zooming can change the DPR, but it seems to report a value that will
  // cleanly divide the values into the appropriate subpixels.

  function roundOffsetsByDPR(_ref) {
    var x = _ref.x,
        y = _ref.y;
    var win = window;
    var dpr = win.devicePixelRatio || 1;
    return {
      x: round$2(x * dpr) / dpr || 0,
      y: round$2(y * dpr) / dpr || 0
    };
  }

  function mapToStyles(_ref2) {
    var _Object$assign2;

    var popper = _ref2.popper,
        popperRect = _ref2.popperRect,
        placement = _ref2.placement,
        variation = _ref2.variation,
        offsets = _ref2.offsets,
        position = _ref2.position,
        gpuAcceleration = _ref2.gpuAcceleration,
        adaptive = _ref2.adaptive,
        roundOffsets = _ref2.roundOffsets,
        isFixed = _ref2.isFixed;
    var _offsets$x = offsets.x,
        x = _offsets$x === void 0 ? 0 : _offsets$x,
        _offsets$y = offsets.y,
        y = _offsets$y === void 0 ? 0 : _offsets$y;

    var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
      x: x,
      y: y
    }) : {
      x: x,
      y: y
    };

    x = _ref3.x;
    y = _ref3.y;
    var hasX = offsets.hasOwnProperty('x');
    var hasY = offsets.hasOwnProperty('y');
    var sideX = left;
    var sideY = top;
    var win = window;

    if (adaptive) {
      var offsetParent = getOffsetParent(popper);
      var heightProp = 'clientHeight';
      var widthProp = 'clientWidth';

      if (offsetParent === getWindow(popper)) {
        offsetParent = getDocumentElement(popper);

        if (getComputedStyle(offsetParent).position !== 'static' && position === 'absolute') {
          heightProp = 'scrollHeight';
          widthProp = 'scrollWidth';
        }
      } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


      offsetParent = offsetParent;

      if (placement === top || (placement === left || placement === right) && variation === end) {
        sideY = bottom;
        var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
        offsetParent[heightProp];
        y -= offsetY - popperRect.height;
        y *= gpuAcceleration ? 1 : -1;
      }

      if (placement === left || (placement === top || placement === bottom) && variation === end) {
        sideX = right;
        var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
        offsetParent[widthProp];
        x -= offsetX - popperRect.width;
        x *= gpuAcceleration ? 1 : -1;
      }
    }

    var commonStyles = Object.assign({
      position: position
    }, adaptive && unsetSides);

    var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
      x: x,
      y: y
    }) : {
      x: x,
      y: y
    };

    x = _ref4.x;
    y = _ref4.y;

    if (gpuAcceleration) {
      var _Object$assign;

      return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
    }

    return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
  }

  function computeStyles(_ref5) {
    var state = _ref5.state,
        options = _ref5.options;
    var _options$gpuAccelerat = options.gpuAcceleration,
        gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
        _options$adaptive = options.adaptive,
        adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
        _options$roundOffsets = options.roundOffsets,
        roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;

    {
      var transitionProperty = getComputedStyle(state.elements.popper).transitionProperty || '';

      if (adaptive && ['transform', 'top', 'right', 'bottom', 'left'].some(function (property) {
        return transitionProperty.indexOf(property) >= 0;
      })) {
        console.warn(['Popper: Detected CSS transitions on at least one of the following', 'CSS properties: "transform", "top", "right", "bottom", "left".', '\n\n', 'Disable the "computeStyles" modifier\'s `adaptive` option to allow', 'for smooth transitions, or remove these properties from the CSS', 'transition declaration on the popper element if only transitioning', 'opacity or background-color for example.', '\n\n', 'We recommend using the popper element as a wrapper around an inner', 'element that can have any CSS property transitioned for animations.'].join(' '));
      }
    }

    var commonStyles = {
      placement: getBasePlacement(state.placement),
      variation: getVariation(state.placement),
      popper: state.elements.popper,
      popperRect: state.rects.popper,
      gpuAcceleration: gpuAcceleration,
      isFixed: state.options.strategy === 'fixed'
    };

    if (state.modifiersData.popperOffsets != null) {
      state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.popperOffsets,
        position: state.options.strategy,
        adaptive: adaptive,
        roundOffsets: roundOffsets
      })));
    }

    if (state.modifiersData.arrow != null) {
      state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.arrow,
        position: 'absolute',
        adaptive: false,
        roundOffsets: roundOffsets
      })));
    }

    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      'data-popper-placement': state.placement
    });
  } // eslint-disable-next-line import/no-unused-modules


  var computeStyles$1 = {
    name: 'computeStyles',
    enabled: true,
    phase: 'beforeWrite',
    fn: computeStyles,
    data: {}
  };

  var passive = {
    passive: true
  };

  function effect(_ref) {
    var state = _ref.state,
        instance = _ref.instance,
        options = _ref.options;
    var _options$scroll = options.scroll,
        scroll = _options$scroll === void 0 ? true : _options$scroll,
        _options$resize = options.resize,
        resize = _options$resize === void 0 ? true : _options$resize;
    var window = getWindow(state.elements.popper);
    var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.addEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.addEventListener('resize', instance.update, passive);
    }

    return function () {
      if (scroll) {
        scrollParents.forEach(function (scrollParent) {
          scrollParent.removeEventListener('scroll', instance.update, passive);
        });
      }

      if (resize) {
        window.removeEventListener('resize', instance.update, passive);
      }
    };
  } // eslint-disable-next-line import/no-unused-modules


  var eventListeners = {
    name: 'eventListeners',
    enabled: true,
    phase: 'write',
    fn: function fn() {},
    effect: effect,
    data: {}
  };

  var hash$1 = {
    left: 'right',
    right: 'left',
    bottom: 'top',
    top: 'bottom'
  };
  function getOppositePlacement(placement) {
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash$1[matched];
    });
  }

  var hash = {
    start: 'end',
    end: 'start'
  };
  function getOppositeVariationPlacement(placement) {
    return placement.replace(/start|end/g, function (matched) {
      return hash[matched];
    });
  }

  function getWindowScroll(node) {
    var win = getWindow(node);
    var scrollLeft = win.pageXOffset;
    var scrollTop = win.pageYOffset;
    return {
      scrollLeft: scrollLeft,
      scrollTop: scrollTop
    };
  }

  function getWindowScrollBarX(element) {
    // If <html> has a CSS width greater than the viewport, then this will be
    // incorrect for RTL.
    // Popper 1 is broken in this case and never had a bug report so let's assume
    // it's not an issue. I don't think anyone ever specifies width on <html>
    // anyway.
    // Browsers where the left scrollbar doesn't cause an issue report `0` for
    // this (e.g. Edge 2019, IE11, Safari)
    return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
  }

  function getViewportRect(element) {
    var win = getWindow(element);
    var html = getDocumentElement(element);
    var visualViewport = win.visualViewport;
    var width = html.clientWidth;
    var height = html.clientHeight;
    var x = 0;
    var y = 0; // NB: This isn't supported on iOS <= 12. If the keyboard is open, the popper
    // can be obscured underneath it.
    // Also, `html.clientHeight` adds the bottom bar height in Safari iOS, even
    // if it isn't open, so if this isn't available, the popper will be detected
    // to overflow the bottom of the screen too early.

    if (visualViewport) {
      width = visualViewport.width;
      height = visualViewport.height; // Uses Layout Viewport (like Chrome; Safari does not currently)
      // In Chrome, it returns a value very close to 0 (+/-) but contains rounding
      // errors due to floating point numbers, so we need to check precision.
      // Safari returns a number <= 0, usually < -1 when pinch-zoomed
      // Feature detection fails in mobile emulation mode in Chrome.
      // Math.abs(win.innerWidth / visualViewport.scale - visualViewport.width) <
      // 0.001
      // Fallback here: "Not Safari" userAgent

      if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
        x = visualViewport.offsetLeft;
        y = visualViewport.offsetTop;
      }
    }

    return {
      width: width,
      height: height,
      x: x + getWindowScrollBarX(element),
      y: y
    };
  }

  // of the `<html>` and `<body>` rect bounds if horizontally scrollable

  function getDocumentRect(element) {
    var _element$ownerDocumen;

    var html = getDocumentElement(element);
    var winScroll = getWindowScroll(element);
    var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
    var width = max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
    var height = max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
    var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
    var y = -winScroll.scrollTop;

    if (getComputedStyle(body || html).direction === 'rtl') {
      x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
    }

    return {
      width: width,
      height: height,
      x: x,
      y: y
    };
  }

  function isScrollParent(element) {
    // Firefox wants us to check `-x` and `-y` variations as well
    var _getComputedStyle = getComputedStyle(element),
        overflow = _getComputedStyle.overflow,
        overflowX = _getComputedStyle.overflowX,
        overflowY = _getComputedStyle.overflowY;

    return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
  }

  function getScrollParent(node) {
    if (['html', 'body', '#document'].indexOf(getNodeName(node)) >= 0) {
      // $FlowFixMe[incompatible-return]: assume body is always available
      return node.ownerDocument.body;
    }

    if (isHTMLElement(node) && isScrollParent(node)) {
      return node;
    }

    return getScrollParent(getParentNode(node));
  }

  /*
  given a DOM element, return the list of all scroll parents, up the list of ancesors
  until we get to the top window object. This list is what we attach scroll listeners
  to, because if any of these parent elements scroll, we'll need to re-calculate the
  reference element's position.
  */

  function listScrollParents(element, list) {
    var _element$ownerDocumen;

    if (list === void 0) {
      list = [];
    }

    var scrollParent = getScrollParent(element);
    var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
    var win = getWindow(scrollParent);
    var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
    var updatedList = list.concat(target);
    return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
    updatedList.concat(listScrollParents(getParentNode(target)));
  }

  function rectToClientRect(rect) {
    return Object.assign({}, rect, {
      left: rect.x,
      top: rect.y,
      right: rect.x + rect.width,
      bottom: rect.y + rect.height
    });
  }

  function getInnerBoundingClientRect(element) {
    var rect = getBoundingClientRect(element);
    rect.top = rect.top + element.clientTop;
    rect.left = rect.left + element.clientLeft;
    rect.bottom = rect.top + element.clientHeight;
    rect.right = rect.left + element.clientWidth;
    rect.width = element.clientWidth;
    rect.height = element.clientHeight;
    rect.x = rect.left;
    rect.y = rect.top;
    return rect;
  }

  function getClientRectFromMixedType(element, clippingParent) {
    return clippingParent === viewport ? rectToClientRect(getViewportRect(element)) : isElement(clippingParent) ? getInnerBoundingClientRect(clippingParent) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
  } // A "clipping parent" is an overflowable container with the characteristic of
  // clipping (or hiding) overflowing elements with a position different from
  // `initial`


  function getClippingParents(element) {
    var clippingParents = listScrollParents(getParentNode(element));
    var canEscapeClipping = ['absolute', 'fixed'].indexOf(getComputedStyle(element).position) >= 0;
    var clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;

    if (!isElement(clipperElement)) {
      return [];
    } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


    return clippingParents.filter(function (clippingParent) {
      return isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== 'body';
    });
  } // Gets the maximum area that the element is visible in due to any number of
  // clipping parents


  function getClippingRect(element, boundary, rootBoundary) {
    var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
    var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
    var firstClippingParent = clippingParents[0];
    var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
      var rect = getClientRectFromMixedType(element, clippingParent);
      accRect.top = max(rect.top, accRect.top);
      accRect.right = min(rect.right, accRect.right);
      accRect.bottom = min(rect.bottom, accRect.bottom);
      accRect.left = max(rect.left, accRect.left);
      return accRect;
    }, getClientRectFromMixedType(element, firstClippingParent));
    clippingRect.width = clippingRect.right - clippingRect.left;
    clippingRect.height = clippingRect.bottom - clippingRect.top;
    clippingRect.x = clippingRect.left;
    clippingRect.y = clippingRect.top;
    return clippingRect;
  }

  function computeOffsets(_ref) {
    var reference = _ref.reference,
        element = _ref.element,
        placement = _ref.placement;
    var basePlacement = placement ? getBasePlacement(placement) : null;
    var variation = placement ? getVariation(placement) : null;
    var commonX = reference.x + reference.width / 2 - element.width / 2;
    var commonY = reference.y + reference.height / 2 - element.height / 2;
    var offsets;

    switch (basePlacement) {
      case top:
        offsets = {
          x: commonX,
          y: reference.y - element.height
        };
        break;

      case bottom:
        offsets = {
          x: commonX,
          y: reference.y + reference.height
        };
        break;

      case right:
        offsets = {
          x: reference.x + reference.width,
          y: commonY
        };
        break;

      case left:
        offsets = {
          x: reference.x - element.width,
          y: commonY
        };
        break;

      default:
        offsets = {
          x: reference.x,
          y: reference.y
        };
    }

    var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;

    if (mainAxis != null) {
      var len = mainAxis === 'y' ? 'height' : 'width';

      switch (variation) {
        case start:
          offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
          break;

        case end:
          offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
          break;
      }
    }

    return offsets;
  }

  function detectOverflow(state, options) {
    if (options === void 0) {
      options = {};
    }

    var _options = options,
        _options$placement = _options.placement,
        placement = _options$placement === void 0 ? state.placement : _options$placement,
        _options$boundary = _options.boundary,
        boundary = _options$boundary === void 0 ? clippingParents : _options$boundary,
        _options$rootBoundary = _options.rootBoundary,
        rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary,
        _options$elementConte = _options.elementContext,
        elementContext = _options$elementConte === void 0 ? popper : _options$elementConte,
        _options$altBoundary = _options.altBoundary,
        altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
        _options$padding = _options.padding,
        padding = _options$padding === void 0 ? 0 : _options$padding;
    var paddingObject = mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
    var altContext = elementContext === popper ? reference : popper;
    var popperRect = state.rects.popper;
    var element = state.elements[altBoundary ? altContext : elementContext];
    var clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary);
    var referenceClientRect = getBoundingClientRect(state.elements.reference);
    var popperOffsets = computeOffsets({
      reference: referenceClientRect,
      element: popperRect,
      strategy: 'absolute',
      placement: placement
    });
    var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets));
    var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
    // 0 or negative = within the clipping rect

    var overflowOffsets = {
      top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
      bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
      left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
      right: elementClientRect.right - clippingClientRect.right + paddingObject.right
    };
    var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

    if (elementContext === popper && offsetData) {
      var offset = offsetData[placement];
      Object.keys(overflowOffsets).forEach(function (key) {
        var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
        var axis = [top, bottom].indexOf(key) >= 0 ? 'y' : 'x';
        overflowOffsets[key] += offset[axis] * multiply;
      });
    }

    return overflowOffsets;
  }

  function computeAutoPlacement(state, options) {
    if (options === void 0) {
      options = {};
    }

    var _options = options,
        placement = _options.placement,
        boundary = _options.boundary,
        rootBoundary = _options.rootBoundary,
        padding = _options.padding,
        flipVariations = _options.flipVariations,
        _options$allowedAutoP = _options.allowedAutoPlacements,
        allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
    var variation = getVariation(placement);
    var placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function (placement) {
      return getVariation(placement) === variation;
    }) : basePlacements;
    var allowedPlacements = placements$1.filter(function (placement) {
      return allowedAutoPlacements.indexOf(placement) >= 0;
    });

    if (allowedPlacements.length === 0) {
      allowedPlacements = placements$1;

      {
        console.error(['Popper: The `allowedAutoPlacements` option did not allow any', 'placements. Ensure the `placement` option matches the variation', 'of the allowed placements.', 'For example, "auto" cannot be used to allow "bottom-start".', 'Use "auto-start" instead.'].join(' '));
      }
    } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


    var overflows = allowedPlacements.reduce(function (acc, placement) {
      acc[placement] = detectOverflow(state, {
        placement: placement,
        boundary: boundary,
        rootBoundary: rootBoundary,
        padding: padding
      })[getBasePlacement(placement)];
      return acc;
    }, {});
    return Object.keys(overflows).sort(function (a, b) {
      return overflows[a] - overflows[b];
    });
  }

  function getExpandedFallbackPlacements(placement) {
    if (getBasePlacement(placement) === auto) {
      return [];
    }

    var oppositePlacement = getOppositePlacement(placement);
    return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
  }

  function flip(_ref) {
    var state = _ref.state,
        options = _ref.options,
        name = _ref.name;

    if (state.modifiersData[name]._skip) {
      return;
    }

    var _options$mainAxis = options.mainAxis,
        checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
        _options$altAxis = options.altAxis,
        checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
        specifiedFallbackPlacements = options.fallbackPlacements,
        padding = options.padding,
        boundary = options.boundary,
        rootBoundary = options.rootBoundary,
        altBoundary = options.altBoundary,
        _options$flipVariatio = options.flipVariations,
        flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
        allowedAutoPlacements = options.allowedAutoPlacements;
    var preferredPlacement = state.options.placement;
    var basePlacement = getBasePlacement(preferredPlacement);
    var isBasePlacement = basePlacement === preferredPlacement;
    var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
    var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
      return acc.concat(getBasePlacement(placement) === auto ? computeAutoPlacement(state, {
        placement: placement,
        boundary: boundary,
        rootBoundary: rootBoundary,
        padding: padding,
        flipVariations: flipVariations,
        allowedAutoPlacements: allowedAutoPlacements
      }) : placement);
    }, []);
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var checksMap = new Map();
    var makeFallbackChecks = true;
    var firstFittingPlacement = placements[0];

    for (var i = 0; i < placements.length; i++) {
      var placement = placements[i];

      var _basePlacement = getBasePlacement(placement);

      var isStartVariation = getVariation(placement) === start;
      var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
      var len = isVertical ? 'width' : 'height';
      var overflow = detectOverflow(state, {
        placement: placement,
        boundary: boundary,
        rootBoundary: rootBoundary,
        altBoundary: altBoundary,
        padding: padding
      });
      var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;

      if (referenceRect[len] > popperRect[len]) {
        mainVariationSide = getOppositePlacement(mainVariationSide);
      }

      var altVariationSide = getOppositePlacement(mainVariationSide);
      var checks = [];

      if (checkMainAxis) {
        checks.push(overflow[_basePlacement] <= 0);
      }

      if (checkAltAxis) {
        checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
      }

      if (checks.every(function (check) {
        return check;
      })) {
        firstFittingPlacement = placement;
        makeFallbackChecks = false;
        break;
      }

      checksMap.set(placement, checks);
    }

    if (makeFallbackChecks) {
      // `2` may be desired in some cases – research later
      var numberOfChecks = flipVariations ? 3 : 1;

      var _loop = function _loop(_i) {
        var fittingPlacement = placements.find(function (placement) {
          var checks = checksMap.get(placement);

          if (checks) {
            return checks.slice(0, _i).every(function (check) {
              return check;
            });
          }
        });

        if (fittingPlacement) {
          firstFittingPlacement = fittingPlacement;
          return "break";
        }
      };

      for (var _i = numberOfChecks; _i > 0; _i--) {
        var _ret = _loop(_i);

        if (_ret === "break") break;
      }
    }

    if (state.placement !== firstFittingPlacement) {
      state.modifiersData[name]._skip = true;
      state.placement = firstFittingPlacement;
      state.reset = true;
    }
  } // eslint-disable-next-line import/no-unused-modules


  var flip$1 = {
    name: 'flip',
    enabled: true,
    phase: 'main',
    fn: flip,
    requiresIfExists: ['offset'],
    data: {
      _skip: false
    }
  };

  function getSideOffsets(overflow, rect, preventedOffsets) {
    if (preventedOffsets === void 0) {
      preventedOffsets = {
        x: 0,
        y: 0
      };
    }

    return {
      top: overflow.top - rect.height - preventedOffsets.y,
      right: overflow.right - rect.width + preventedOffsets.x,
      bottom: overflow.bottom - rect.height + preventedOffsets.y,
      left: overflow.left - rect.width - preventedOffsets.x
    };
  }

  function isAnySideFullyClipped(overflow) {
    return [top, right, bottom, left].some(function (side) {
      return overflow[side] >= 0;
    });
  }

  function hide(_ref) {
    var state = _ref.state,
        name = _ref.name;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var preventedOffsets = state.modifiersData.preventOverflow;
    var referenceOverflow = detectOverflow(state, {
      elementContext: 'reference'
    });
    var popperAltOverflow = detectOverflow(state, {
      altBoundary: true
    });
    var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
    var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
    var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
    var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
    state.modifiersData[name] = {
      referenceClippingOffsets: referenceClippingOffsets,
      popperEscapeOffsets: popperEscapeOffsets,
      isReferenceHidden: isReferenceHidden,
      hasPopperEscaped: hasPopperEscaped
    };
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      'data-popper-reference-hidden': isReferenceHidden,
      'data-popper-escaped': hasPopperEscaped
    });
  } // eslint-disable-next-line import/no-unused-modules


  var hide$1 = {
    name: 'hide',
    enabled: true,
    phase: 'main',
    requiresIfExists: ['preventOverflow'],
    fn: hide
  };

  function distanceAndSkiddingToXY(placement, rects, offset) {
    var basePlacement = getBasePlacement(placement);
    var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;

    var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
      placement: placement
    })) : offset,
        skidding = _ref[0],
        distance = _ref[1];

    skidding = skidding || 0;
    distance = (distance || 0) * invertDistance;
    return [left, right].indexOf(basePlacement) >= 0 ? {
      x: distance,
      y: skidding
    } : {
      x: skidding,
      y: distance
    };
  }

  function offset(_ref2) {
    var state = _ref2.state,
        options = _ref2.options,
        name = _ref2.name;
    var _options$offset = options.offset,
        offset = _options$offset === void 0 ? [0, 0] : _options$offset;
    var data = placements.reduce(function (acc, placement) {
      acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
      return acc;
    }, {});
    var _data$state$placement = data[state.placement],
        x = _data$state$placement.x,
        y = _data$state$placement.y;

    if (state.modifiersData.popperOffsets != null) {
      state.modifiersData.popperOffsets.x += x;
      state.modifiersData.popperOffsets.y += y;
    }

    state.modifiersData[name] = data;
  } // eslint-disable-next-line import/no-unused-modules


  var offset$1 = {
    name: 'offset',
    enabled: true,
    phase: 'main',
    requires: ['popperOffsets'],
    fn: offset
  };

  function popperOffsets(_ref) {
    var state = _ref.state,
        name = _ref.name;
    // Offsets are the actual position the popper needs to have to be
    // properly positioned near its reference element
    // This is the most basic placement, and will be adjusted by
    // the modifiers in the next step
    state.modifiersData[name] = computeOffsets({
      reference: state.rects.reference,
      element: state.rects.popper,
      strategy: 'absolute',
      placement: state.placement
    });
  } // eslint-disable-next-line import/no-unused-modules


  var popperOffsets$1 = {
    name: 'popperOffsets',
    enabled: true,
    phase: 'read',
    fn: popperOffsets,
    data: {}
  };

  function getAltAxis(axis) {
    return axis === 'x' ? 'y' : 'x';
  }

  function preventOverflow(_ref) {
    var state = _ref.state,
        options = _ref.options,
        name = _ref.name;
    var _options$mainAxis = options.mainAxis,
        checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
        _options$altAxis = options.altAxis,
        checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
        boundary = options.boundary,
        rootBoundary = options.rootBoundary,
        altBoundary = options.altBoundary,
        padding = options.padding,
        _options$tether = options.tether,
        tether = _options$tether === void 0 ? true : _options$tether,
        _options$tetherOffset = options.tetherOffset,
        tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
    var overflow = detectOverflow(state, {
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      altBoundary: altBoundary
    });
    var basePlacement = getBasePlacement(state.placement);
    var variation = getVariation(state.placement);
    var isBasePlacement = !variation;
    var mainAxis = getMainAxisFromPlacement(basePlacement);
    var altAxis = getAltAxis(mainAxis);
    var popperOffsets = state.modifiersData.popperOffsets;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
      placement: state.placement
    })) : tetherOffset;
    var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
      mainAxis: tetherOffsetValue,
      altAxis: tetherOffsetValue
    } : Object.assign({
      mainAxis: 0,
      altAxis: 0
    }, tetherOffsetValue);
    var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
    var data = {
      x: 0,
      y: 0
    };

    if (!popperOffsets) {
      return;
    }

    if (checkMainAxis) {
      var _offsetModifierState$;

      var mainSide = mainAxis === 'y' ? top : left;
      var altSide = mainAxis === 'y' ? bottom : right;
      var len = mainAxis === 'y' ? 'height' : 'width';
      var offset = popperOffsets[mainAxis];
      var min$1 = offset + overflow[mainSide];
      var max$1 = offset - overflow[altSide];
      var additive = tether ? -popperRect[len] / 2 : 0;
      var minLen = variation === start ? referenceRect[len] : popperRect[len];
      var maxLen = variation === start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
      // outside the reference bounds

      var arrowElement = state.elements.arrow;
      var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
        width: 0,
        height: 0
      };
      var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : getFreshSideObject();
      var arrowPaddingMin = arrowPaddingObject[mainSide];
      var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
      // to include its full size in the calculation. If the reference is small
      // and near the edge of a boundary, the popper can overflow even if the
      // reference is not overflowing as well (e.g. virtual elements with no
      // width or height)

      var arrowLen = within(0, referenceRect[len], arrowRect[len]);
      var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
      var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
      var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
      var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
      var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
      var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
      var tetherMax = offset + maxOffset - offsetModifierValue;
      var preventedOffset = within(tether ? min(min$1, tetherMin) : min$1, offset, tether ? max(max$1, tetherMax) : max$1);
      popperOffsets[mainAxis] = preventedOffset;
      data[mainAxis] = preventedOffset - offset;
    }

    if (checkAltAxis) {
      var _offsetModifierState$2;

      var _mainSide = mainAxis === 'x' ? top : left;

      var _altSide = mainAxis === 'x' ? bottom : right;

      var _offset = popperOffsets[altAxis];

      var _len = altAxis === 'y' ? 'height' : 'width';

      var _min = _offset + overflow[_mainSide];

      var _max = _offset - overflow[_altSide];

      var isOriginSide = [top, left].indexOf(basePlacement) !== -1;

      var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

      var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

      var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

      var _preventedOffset = tether && isOriginSide ? withinMaxClamp(_tetherMin, _offset, _tetherMax) : within(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

      popperOffsets[altAxis] = _preventedOffset;
      data[altAxis] = _preventedOffset - _offset;
    }

    state.modifiersData[name] = data;
  } // eslint-disable-next-line import/no-unused-modules


  var preventOverflow$1 = {
    name: 'preventOverflow',
    enabled: true,
    phase: 'main',
    fn: preventOverflow,
    requiresIfExists: ['offset']
  };

  function getHTMLElementScroll(element) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }

  function getNodeScroll(node) {
    if (node === getWindow(node) || !isHTMLElement(node)) {
      return getWindowScroll(node);
    } else {
      return getHTMLElementScroll(node);
    }
  }

  function isElementScaled(element) {
    var rect = element.getBoundingClientRect();
    var scaleX = round$2(rect.width) / element.offsetWidth || 1;
    var scaleY = round$2(rect.height) / element.offsetHeight || 1;
    return scaleX !== 1 || scaleY !== 1;
  } // Returns the composite rect of an element relative to its offsetParent.
  // Composite means it takes into account transforms as well as layout.


  function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
    if (isFixed === void 0) {
      isFixed = false;
    }

    var isOffsetParentAnElement = isHTMLElement(offsetParent);
    var offsetParentIsScaled = isHTMLElement(offsetParent) && isElementScaled(offsetParent);
    var documentElement = getDocumentElement(offsetParent);
    var rect = getBoundingClientRect(elementOrVirtualElement, offsetParentIsScaled);
    var scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    var offsets = {
      x: 0,
      y: 0
    };

    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
      if (getNodeName(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
      isScrollParent(documentElement)) {
        scroll = getNodeScroll(offsetParent);
      }

      if (isHTMLElement(offsetParent)) {
        offsets = getBoundingClientRect(offsetParent, true);
        offsets.x += offsetParent.clientLeft;
        offsets.y += offsetParent.clientTop;
      } else if (documentElement) {
        offsets.x = getWindowScrollBarX(documentElement);
      }
    }

    return {
      x: rect.left + scroll.scrollLeft - offsets.x,
      y: rect.top + scroll.scrollTop - offsets.y,
      width: rect.width,
      height: rect.height
    };
  }

  function order(modifiers) {
    var map = new Map();
    var visited = new Set();
    var result = [];
    modifiers.forEach(function (modifier) {
      map.set(modifier.name, modifier);
    }); // On visiting object, check for its dependencies and visit them recursively

    function sort(modifier) {
      visited.add(modifier.name);
      var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
      requires.forEach(function (dep) {
        if (!visited.has(dep)) {
          var depModifier = map.get(dep);

          if (depModifier) {
            sort(depModifier);
          }
        }
      });
      result.push(modifier);
    }

    modifiers.forEach(function (modifier) {
      if (!visited.has(modifier.name)) {
        // check for visited object
        sort(modifier);
      }
    });
    return result;
  }

  function orderModifiers(modifiers) {
    // order based on dependencies
    var orderedModifiers = order(modifiers); // order based on phase

    return modifierPhases.reduce(function (acc, phase) {
      return acc.concat(orderedModifiers.filter(function (modifier) {
        return modifier.phase === phase;
      }));
    }, []);
  }

  function debounce(fn) {
    var pending;
    return function () {
      if (!pending) {
        pending = new Promise(function (resolve) {
          Promise.resolve().then(function () {
            pending = undefined;
            resolve(fn());
          });
        });
      }

      return pending;
    };
  }

  function format(str) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    return [].concat(args).reduce(function (p, c) {
      return p.replace(/%s/, c);
    }, str);
  }

  var INVALID_MODIFIER_ERROR = 'Popper: modifier "%s" provided an invalid %s property, expected %s but got %s';
  var MISSING_DEPENDENCY_ERROR = 'Popper: modifier "%s" requires "%s", but "%s" modifier is not available';
  var VALID_PROPERTIES = ['name', 'enabled', 'phase', 'fn', 'effect', 'requires', 'options'];
  function validateModifiers(modifiers) {
    modifiers.forEach(function (modifier) {
      [].concat(Object.keys(modifier), VALID_PROPERTIES) // IE11-compatible replacement for `new Set(iterable)`
      .filter(function (value, index, self) {
        return self.indexOf(value) === index;
      }).forEach(function (key) {
        switch (key) {
          case 'name':
            if (typeof modifier.name !== 'string') {
              console.error(format(INVALID_MODIFIER_ERROR, String(modifier.name), '"name"', '"string"', "\"" + String(modifier.name) + "\""));
            }

            break;

          case 'enabled':
            if (typeof modifier.enabled !== 'boolean') {
              console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"enabled"', '"boolean"', "\"" + String(modifier.enabled) + "\""));
            }

            break;

          case 'phase':
            if (modifierPhases.indexOf(modifier.phase) < 0) {
              console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"phase"', "either " + modifierPhases.join(', '), "\"" + String(modifier.phase) + "\""));
            }

            break;

          case 'fn':
            if (typeof modifier.fn !== 'function') {
              console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"fn"', '"function"', "\"" + String(modifier.fn) + "\""));
            }

            break;

          case 'effect':
            if (modifier.effect != null && typeof modifier.effect !== 'function') {
              console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"effect"', '"function"', "\"" + String(modifier.fn) + "\""));
            }

            break;

          case 'requires':
            if (modifier.requires != null && !Array.isArray(modifier.requires)) {
              console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"requires"', '"array"', "\"" + String(modifier.requires) + "\""));
            }

            break;

          case 'requiresIfExists':
            if (!Array.isArray(modifier.requiresIfExists)) {
              console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"requiresIfExists"', '"array"', "\"" + String(modifier.requiresIfExists) + "\""));
            }

            break;

          case 'options':
          case 'data':
            break;

          default:
            console.error("PopperJS: an invalid property has been provided to the \"" + modifier.name + "\" modifier, valid properties are " + VALID_PROPERTIES.map(function (s) {
              return "\"" + s + "\"";
            }).join(', ') + "; but \"" + key + "\" was provided.");
        }

        modifier.requires && modifier.requires.forEach(function (requirement) {
          if (modifiers.find(function (mod) {
            return mod.name === requirement;
          }) == null) {
            console.error(format(MISSING_DEPENDENCY_ERROR, String(modifier.name), requirement, requirement));
          }
        });
      });
    });
  }

  function uniqueBy(arr, fn) {
    var identifiers = new Set();
    return arr.filter(function (item) {
      var identifier = fn(item);

      if (!identifiers.has(identifier)) {
        identifiers.add(identifier);
        return true;
      }
    });
  }

  function mergeByName(modifiers) {
    var merged = modifiers.reduce(function (merged, current) {
      var existing = merged[current.name];
      merged[current.name] = existing ? Object.assign({}, existing, current, {
        options: Object.assign({}, existing.options, current.options),
        data: Object.assign({}, existing.data, current.data)
      }) : current;
      return merged;
    }, {}); // IE11 does not support Object.values

    return Object.keys(merged).map(function (key) {
      return merged[key];
    });
  }

  var INVALID_ELEMENT_ERROR = 'Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.';
  var INFINITE_LOOP_ERROR = 'Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.';
  var DEFAULT_OPTIONS = {
    placement: 'bottom',
    modifiers: [],
    strategy: 'absolute'
  };

  function areValidElements() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return !args.some(function (element) {
      return !(element && typeof element.getBoundingClientRect === 'function');
    });
  }

  function popperGenerator(generatorOptions) {
    if (generatorOptions === void 0) {
      generatorOptions = {};
    }

    var _generatorOptions = generatorOptions,
        _generatorOptions$def = _generatorOptions.defaultModifiers,
        defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
        _generatorOptions$def2 = _generatorOptions.defaultOptions,
        defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
    return function createPopper(reference, popper, options) {
      if (options === void 0) {
        options = defaultOptions;
      }

      var state = {
        placement: 'bottom',
        orderedModifiers: [],
        options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
        modifiersData: {},
        elements: {
          reference: reference,
          popper: popper
        },
        attributes: {},
        styles: {}
      };
      var effectCleanupFns = [];
      var isDestroyed = false;
      var instance = {
        state: state,
        setOptions: function setOptions(setOptionsAction) {
          var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
          cleanupModifierEffects();
          state.options = Object.assign({}, defaultOptions, state.options, options);
          state.scrollParents = {
            reference: isElement(reference) ? listScrollParents(reference) : reference.contextElement ? listScrollParents(reference.contextElement) : [],
            popper: listScrollParents(popper)
          }; // Orders the modifiers based on their dependencies and `phase`
          // properties

          var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

          state.orderedModifiers = orderedModifiers.filter(function (m) {
            return m.enabled;
          }); // Validate the provided modifiers so that the consumer will get warned
          // if one of the modifiers is invalid for any reason

          {
            var modifiers = uniqueBy([].concat(orderedModifiers, state.options.modifiers), function (_ref) {
              var name = _ref.name;
              return name;
            });
            validateModifiers(modifiers);

            if (getBasePlacement(state.options.placement) === auto) {
              var flipModifier = state.orderedModifiers.find(function (_ref2) {
                var name = _ref2.name;
                return name === 'flip';
              });

              if (!flipModifier) {
                console.error(['Popper: "auto" placements require the "flip" modifier be', 'present and enabled to work.'].join(' '));
              }
            }

            var _getComputedStyle = getComputedStyle(popper),
                marginTop = _getComputedStyle.marginTop,
                marginRight = _getComputedStyle.marginRight,
                marginBottom = _getComputedStyle.marginBottom,
                marginLeft = _getComputedStyle.marginLeft; // We no longer take into account `margins` on the popper, and it can
            // cause bugs with positioning, so we'll warn the consumer


            if ([marginTop, marginRight, marginBottom, marginLeft].some(function (margin) {
              return parseFloat(margin);
            })) {
              console.warn(['Popper: CSS "margin" styles cannot be used to apply padding', 'between the popper and its reference element or boundary.', 'To replicate margin, use the `offset` modifier, as well as', 'the `padding` option in the `preventOverflow` and `flip`', 'modifiers.'].join(' '));
            }
          }

          runModifierEffects();
          return instance.update();
        },
        // Sync update – it will always be executed, even if not necessary. This
        // is useful for low frequency updates where sync behavior simplifies the
        // logic.
        // For high frequency updates (e.g. `resize` and `scroll` events), always
        // prefer the async Popper#update method
        forceUpdate: function forceUpdate() {
          if (isDestroyed) {
            return;
          }

          var _state$elements = state.elements,
              reference = _state$elements.reference,
              popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
          // anymore

          if (!areValidElements(reference, popper)) {
            {
              console.error(INVALID_ELEMENT_ERROR);
            }

            return;
          } // Store the reference and popper rects to be read by modifiers


          state.rects = {
            reference: getCompositeRect(reference, getOffsetParent(popper), state.options.strategy === 'fixed'),
            popper: getLayoutRect(popper)
          }; // Modifiers have the ability to reset the current update cycle. The
          // most common use case for this is the `flip` modifier changing the
          // placement, which then needs to re-run all the modifiers, because the
          // logic was previously ran for the previous placement and is therefore
          // stale/incorrect

          state.reset = false;
          state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
          // is filled with the initial data specified by the modifier. This means
          // it doesn't persist and is fresh on each update.
          // To ensure persistent data, use `${name}#persistent`

          state.orderedModifiers.forEach(function (modifier) {
            return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
          });
          var __debug_loops__ = 0;

          for (var index = 0; index < state.orderedModifiers.length; index++) {
            {
              __debug_loops__ += 1;

              if (__debug_loops__ > 100) {
                console.error(INFINITE_LOOP_ERROR);
                break;
              }
            }

            if (state.reset === true) {
              state.reset = false;
              index = -1;
              continue;
            }

            var _state$orderedModifie = state.orderedModifiers[index],
                fn = _state$orderedModifie.fn,
                _state$orderedModifie2 = _state$orderedModifie.options,
                _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
                name = _state$orderedModifie.name;

            if (typeof fn === 'function') {
              state = fn({
                state: state,
                options: _options,
                name: name,
                instance: instance
              }) || state;
            }
          }
        },
        // Async and optimistically optimized update – it will not be executed if
        // not necessary (debounced to run at most once-per-tick)
        update: debounce(function () {
          return new Promise(function (resolve) {
            instance.forceUpdate();
            resolve(state);
          });
        }),
        destroy: function destroy() {
          cleanupModifierEffects();
          isDestroyed = true;
        }
      };

      if (!areValidElements(reference, popper)) {
        {
          console.error(INVALID_ELEMENT_ERROR);
        }

        return instance;
      }

      instance.setOptions(options).then(function (state) {
        if (!isDestroyed && options.onFirstUpdate) {
          options.onFirstUpdate(state);
        }
      }); // Modifiers have the ability to execute arbitrary code before the first
      // update cycle runs. They will be executed in the same order as the update
      // cycle. This is useful when a modifier adds some persistent data that
      // other modifiers need to use, but the modifier is run after the dependent
      // one.

      function runModifierEffects() {
        state.orderedModifiers.forEach(function (_ref3) {
          var name = _ref3.name,
              _ref3$options = _ref3.options,
              options = _ref3$options === void 0 ? {} : _ref3$options,
              effect = _ref3.effect;

          if (typeof effect === 'function') {
            var cleanupFn = effect({
              state: state,
              name: name,
              instance: instance,
              options: options
            });

            var noopFn = function noopFn() {};

            effectCleanupFns.push(cleanupFn || noopFn);
          }
        });
      }

      function cleanupModifierEffects() {
        effectCleanupFns.forEach(function (fn) {
          return fn();
        });
        effectCleanupFns = [];
      }

      return instance;
    };
  }

  var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$1, flip$1, preventOverflow$1, arrow$1, hide$1];
  var createPopper = /*#__PURE__*/popperGenerator({
    defaultModifiers: defaultModifiers
  }); // eslint-disable-next-line import/no-unused-modules

  function getContainer$1(container) {
    return typeof container === 'function' ? container() : container;
  }
  /**
   * Portals provide a first-class way to render children into a DOM node
   * that exists outside the DOM hierarchy of the parent component.
   */


  const Portal = /*#__PURE__*/React__namespace.forwardRef(function Portal(props, ref) {
    const {
      children,
      container,
      disablePortal = false
    } = props;
    const [mountNode, setMountNode] = React__namespace.useState(null);
    const handleRef = useForkRef( /*#__PURE__*/React__namespace.isValidElement(children) ? children.ref : null, ref);
    useEnhancedEffect$1(() => {
      if (!disablePortal) {
        setMountNode(getContainer$1(container) || document.body);
      }
    }, [container, disablePortal]);
    useEnhancedEffect$1(() => {
      if (mountNode && !disablePortal) {
        setRef(ref, mountNode);
        return () => {
          setRef(ref, null);
        };
      }

      return undefined;
    }, [ref, mountNode, disablePortal]);

    if (disablePortal) {
      if ( /*#__PURE__*/React__namespace.isValidElement(children)) {
        return /*#__PURE__*/React__namespace.cloneElement(children, {
          ref: handleRef
        });
      }

      return children;
    }

    return mountNode ? /*#__PURE__*/ReactDOM__namespace.createPortal(children, mountNode) : mountNode;
  });
  Portal.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The children to render into the `container`.
     */
    children: PropTypes.node,

    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([HTMLElementType, PropTypes.func]),

    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool
  } ;

  {
    // eslint-disable-next-line
    Portal['propTypes' + ''] = exactProp(Portal.propTypes);
  }

  var Portal$1 = Portal;

  const _excluded$2b = ["anchorEl", "children", "direction", "disablePortal", "modifiers", "open", "ownerState", "placement", "popperOptions", "popperRef", "TransitionProps"],
        _excluded2$a = ["anchorEl", "children", "container", "direction", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "popperRef", "style", "transition"];

  function flipPlacement(placement, direction) {
    if (direction === 'ltr') {
      return placement;
    }

    switch (placement) {
      case 'bottom-end':
        return 'bottom-start';

      case 'bottom-start':
        return 'bottom-end';

      case 'top-end':
        return 'top-start';

      case 'top-start':
        return 'top-end';

      default:
        return placement;
    }
  }

  function resolveAnchorEl$1(anchorEl) {
    return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
  }

  const defaultPopperOptions = {};
  /* eslint-disable react/prop-types */

  const PopperTooltip = /*#__PURE__*/React__namespace.forwardRef(function PopperTooltip(props, ref) {
    const {
      anchorEl,
      children,
      direction,
      disablePortal,
      modifiers,
      open,
      placement: initialPlacement,
      popperOptions,
      popperRef: popperRefProp,
      TransitionProps
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$2b);

    const tooltipRef = React__namespace.useRef(null);
    const ownRef = useForkRef(tooltipRef, ref);
    const popperRef = React__namespace.useRef(null);
    const handlePopperRef = useForkRef(popperRef, popperRefProp);
    const handlePopperRefRef = React__namespace.useRef(handlePopperRef);
    useEnhancedEffect$1(() => {
      handlePopperRefRef.current = handlePopperRef;
    }, [handlePopperRef]);
    React__namespace.useImperativeHandle(popperRefProp, () => popperRef.current, []);
    const rtlPlacement = flipPlacement(initialPlacement, direction);
    /**
     * placement initialized from prop but can change during lifetime if modifiers.flip.
     * modifiers.flip is essentially a flip for controlled/uncontrolled behavior
     */

    const [placement, setPlacement] = React__namespace.useState(rtlPlacement);
    React__namespace.useEffect(() => {
      if (popperRef.current) {
        popperRef.current.forceUpdate();
      }
    });
    useEnhancedEffect$1(() => {
      if (!anchorEl || !open) {
        return undefined;
      }

      const handlePopperUpdate = data => {
        setPlacement(data.placement);
      };

      const resolvedAnchorEl = resolveAnchorEl$1(anchorEl);

      {
        if (resolvedAnchorEl && resolvedAnchorEl.nodeType === 1) {
          const box = resolvedAnchorEl.getBoundingClientRect();

          if (box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            console.warn(['MUI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        }
      }

      let popperModifiers = [{
        name: 'preventOverflow',
        options: {
          altBoundary: disablePortal
        }
      }, {
        name: 'flip',
        options: {
          altBoundary: disablePortal
        }
      }, {
        name: 'onUpdate',
        enabled: true,
        phase: 'afterWrite',
        fn: ({
          state
        }) => {
          handlePopperUpdate(state);
        }
      }];

      if (modifiers != null) {
        popperModifiers = popperModifiers.concat(modifiers);
      }

      if (popperOptions && popperOptions.modifiers != null) {
        popperModifiers = popperModifiers.concat(popperOptions.modifiers);
      }

      const popper = createPopper(resolveAnchorEl$1(anchorEl), tooltipRef.current, _extends({
        placement: rtlPlacement
      }, popperOptions, {
        modifiers: popperModifiers
      }));
      handlePopperRefRef.current(popper);
      return () => {
        popper.destroy();
        handlePopperRefRef.current(null);
      };
    }, [anchorEl, disablePortal, modifiers, open, popperOptions, rtlPlacement]);
    const childProps = {
      placement
    };

    if (TransitionProps !== null) {
      childProps.TransitionProps = TransitionProps;
    }

    return /*#__PURE__*/jsxRuntime_1("div", _extends({
      ref: ownRef,
      role: "tooltip"
    }, other, {
      children: typeof children === 'function' ? children(childProps) : children
    }));
  });
  /* eslint-enable react/prop-types */

  /**
   * Poppers rely on the 3rd party library [Popper.js](https://popper.js.org/docs/v2/) for positioning.
   */

  const PopperUnstyled = /*#__PURE__*/React__namespace.forwardRef(function PopperUnstyled(props, ref) {
    const {
      anchorEl,
      children,
      container: containerProp,
      direction = 'ltr',
      disablePortal = false,
      keepMounted = false,
      modifiers,
      open,
      placement = 'bottom',
      popperOptions = defaultPopperOptions,
      popperRef,
      style,
      transition = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded2$a);

    const [exited, setExited] = React__namespace.useState(true);

    const handleEnter = () => {
      setExited(false);
    };

    const handleExited = () => {
      setExited(true);
    };

    if (!keepMounted && !open && (!transition || exited)) {
      return null;
    } // If the container prop is provided, use that
    // If the anchorEl prop is provided, use its parent body element as the container
    // If neither are provided let the Modal take care of choosing the container


    const container = containerProp || (anchorEl ? ownerDocument(resolveAnchorEl$1(anchorEl)).body : undefined);
    return /*#__PURE__*/jsxRuntime_1(Portal$1, {
      disablePortal: disablePortal,
      container: container,
      children: /*#__PURE__*/jsxRuntime_1(PopperTooltip, _extends({
        anchorEl: anchorEl,
        direction: direction,
        disablePortal: disablePortal,
        modifiers: modifiers,
        ref: ref,
        open: transition ? !exited : open,
        placement: placement,
        popperOptions: popperOptions,
        popperRef: popperRef
      }, other, {
        style: _extends({
          // Prevents scroll issue, waiting for Popper.js to add this style once initiated.
          position: 'fixed',
          // Fix Popper.js display issue
          top: 0,
          left: 0,
          display: !open && keepMounted && (!transition || exited) ? 'none' : null
        }, style),
        TransitionProps: transition ? {
          in: open,
          onEnter: handleEnter,
          onExited: handleExited
        } : null,
        children: children
      }))
    });
  });
  PopperUnstyled.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * An HTML element, [virtualElement](https://popper.js.org/docs/v2/virtual-elements/),
     * or a function that returns either.
     * It's used to set the position of the popper.
     * The return value will passed as the reference object of the Popper instance.
     */
    anchorEl: chainPropTypes(PropTypes.oneOfType([HTMLElementType, PropTypes.object, PropTypes.func]), props => {
      if (props.open) {
        const resolvedAnchorEl = resolveAnchorEl$1(props.anchorEl);

        if (resolvedAnchorEl && resolvedAnchorEl.nodeType === 1) {
          const box = resolvedAnchorEl.getBoundingClientRect();

          if (box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            return new Error(['MUI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        } else if (!resolvedAnchorEl || typeof resolvedAnchorEl.getBoundingClientRect !== 'function' || resolvedAnchorEl.contextElement != null && resolvedAnchorEl.contextElement.nodeType !== 1) {
          return new Error(['MUI: The `anchorEl` prop provided to the component is invalid.', 'It should be an HTML element instance or a virtualElement ', '(https://popper.js.org/docs/v2/virtual-elements/).'].join('\n'));
        }
      }

      return null;
    }),

    /**
     * Popper render function or node.
     */
    children: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.node, PropTypes.func]),

    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([HTMLElementType, PropTypes.func]),

    /**
     * Direction of the text.
     * @default 'ltr'
     */
    direction: PropTypes.oneOf(['ltr', 'rtl']),

    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Popper.
     * @default false
     */
    keepMounted: PropTypes.bool,

    /**
     * Popper.js is based on a "plugin-like" architecture,
     * most of its features are fully encapsulated "modifiers".
     *
     * A modifier is a function that is called each time Popper.js needs to
     * compute the position of the popper.
     * For this reason, modifiers should be very performant to avoid bottlenecks.
     * To learn how to create a modifier, [read the modifiers documentation](https://popper.js.org/docs/v2/modifiers/).
     */
    modifiers: PropTypes.arrayOf(PropTypes.shape({
      data: PropTypes.object,
      effect: PropTypes.func,
      enabled: PropTypes.bool,
      fn: PropTypes.func,
      name: PropTypes.any,
      options: PropTypes.object,
      phase: PropTypes.oneOf(['afterMain', 'afterRead', 'afterWrite', 'beforeMain', 'beforeRead', 'beforeWrite', 'main', 'read', 'write']),
      requires: PropTypes.arrayOf(PropTypes.string),
      requiresIfExists: PropTypes.arrayOf(PropTypes.string)
    })),

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,

    /**
     * Popper placement.
     * @default 'bottom'
     */
    placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

    /**
     * Options provided to the [`Popper.js`](https://popper.js.org/docs/v2/constructors/#options) instance.
     * @default {}
     */
    popperOptions: PropTypes.shape({
      modifiers: PropTypes.array,
      onFirstUpdate: PropTypes.func,
      placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
      strategy: PropTypes.oneOf(['absolute', 'fixed'])
    }),

    /**
     * A ref that points to the used popper instance.
     */
    popperRef: refType$1,

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * Help supporting a react-transition-group/Transition component.
     * @default false
     */
    transition: PropTypes.bool
  } ;
  var PopperUnstyled$1 = PopperUnstyled;

  // Is a vertical scrollbar displayed?
  function isOverflowing(container) {
    const doc = ownerDocument(container);

    if (doc.body === container) {
      return ownerWindow(container).innerWidth > doc.documentElement.clientWidth;
    }

    return container.scrollHeight > container.clientHeight;
  }

  function ariaHidden(element, show) {
    if (show) {
      element.setAttribute('aria-hidden', 'true');
    } else {
      element.removeAttribute('aria-hidden');
    }
  }

  function getPaddingRight(element) {
    return parseInt(ownerWindow(element).getComputedStyle(element).paddingRight, 10) || 0;
  }

  function isAriaHiddenForbiddenOnElement(element) {
    // The forbidden HTML tags are the ones from ARIA specification that
    // can be children of body and can't have aria-hidden attribute.
    // cf. https://www.w3.org/TR/html-aria/#docconformance
    const forbiddenTagNames = ['TEMPLATE', 'SCRIPT', 'STYLE', 'LINK', 'MAP', 'META', 'NOSCRIPT', 'PICTURE', 'COL', 'COLGROUP', 'PARAM', 'SLOT', 'SOURCE', 'TRACK'];
    const isForbiddenTagName = forbiddenTagNames.indexOf(element.tagName) !== -1;
    const isInputHidden = element.tagName === 'INPUT' && element.getAttribute('type') === 'hidden';
    return isForbiddenTagName || isInputHidden;
  }

  function ariaHiddenSiblings(container, mountElement, currentElement, elementsToExclude = [], show) {
    const blacklist = [mountElement, currentElement, ...elementsToExclude];
    [].forEach.call(container.children, element => {
      const isNotExcludedElement = blacklist.indexOf(element) === -1;
      const isNotForbiddenElement = !isAriaHiddenForbiddenOnElement(element);

      if (isNotExcludedElement && isNotForbiddenElement) {
        ariaHidden(element, show);
      }
    });
  }

  function findIndexOf(items, callback) {
    let idx = -1;
    items.some((item, index) => {
      if (callback(item)) {
        idx = index;
        return true;
      }

      return false;
    });
    return idx;
  }

  function handleContainer(containerInfo, props) {
    const restoreStyle = [];
    const container = containerInfo.container;

    if (!props.disableScrollLock) {
      if (isOverflowing(container)) {
        // Compute the size before applying overflow hidden to avoid any scroll jumps.
        const scrollbarSize = getScrollbarSize(ownerDocument(container));
        restoreStyle.push({
          value: container.style.paddingRight,
          property: 'padding-right',
          el: container
        }); // Use computed style, here to get the real padding to add our scrollbar width.

        container.style.paddingRight = `${getPaddingRight(container) + scrollbarSize}px`; // .mui-fixed is a global helper.

        const fixedElements = ownerDocument(container).querySelectorAll('.mui-fixed');
        [].forEach.call(fixedElements, element => {
          restoreStyle.push({
            value: element.style.paddingRight,
            property: 'padding-right',
            el: element
          });
          element.style.paddingRight = `${getPaddingRight(element) + scrollbarSize}px`;
        });
      } // Improve Gatsby support
      // https://css-tricks.com/snippets/css/force-vertical-scrollbar/


      const parent = container.parentElement;
      const containerWindow = ownerWindow(container);
      const scrollContainer = (parent == null ? void 0 : parent.nodeName) === 'HTML' && containerWindow.getComputedStyle(parent).overflowY === 'scroll' ? parent : container; // Block the scroll even if no scrollbar is visible to account for mobile keyboard
      // screensize shrink.

      restoreStyle.push({
        value: scrollContainer.style.overflow,
        property: 'overflow',
        el: scrollContainer
      }, {
        value: scrollContainer.style.overflowX,
        property: 'overflow-x',
        el: scrollContainer
      }, {
        value: scrollContainer.style.overflowY,
        property: 'overflow-y',
        el: scrollContainer
      });
      scrollContainer.style.overflow = 'hidden';
    }

    const restore = () => {
      restoreStyle.forEach(({
        value,
        el,
        property
      }) => {
        if (value) {
          el.style.setProperty(property, value);
        } else {
          el.style.removeProperty(property);
        }
      });
    };

    return restore;
  }

  function getHiddenSiblings(container) {
    const hiddenSiblings = [];
    [].forEach.call(container.children, element => {
      if (element.getAttribute('aria-hidden') === 'true') {
        hiddenSiblings.push(element);
      }
    });
    return hiddenSiblings;
  }

  /**
   * @ignore - do not document.
   *
   * Proper state management for containers and the modals in those containers.
   * Simplified, but inspired by react-overlay's ModalManager class.
   * Used by the Modal to ensure proper styling of containers.
   */
  class ModalManager {
    constructor() {
      this.containers = void 0;
      this.modals = void 0;
      this.modals = [];
      this.containers = [];
    }

    add(modal, container) {
      let modalIndex = this.modals.indexOf(modal);

      if (modalIndex !== -1) {
        return modalIndex;
      }

      modalIndex = this.modals.length;
      this.modals.push(modal); // If the modal we are adding is already in the DOM.

      if (modal.modalRef) {
        ariaHidden(modal.modalRef, false);
      }

      const hiddenSiblings = getHiddenSiblings(container);
      ariaHiddenSiblings(container, modal.mount, modal.modalRef, hiddenSiblings, true);
      const containerIndex = findIndexOf(this.containers, item => item.container === container);

      if (containerIndex !== -1) {
        this.containers[containerIndex].modals.push(modal);
        return modalIndex;
      }

      this.containers.push({
        modals: [modal],
        container,
        restore: null,
        hiddenSiblings
      });
      return modalIndex;
    }

    mount(modal, props) {
      const containerIndex = findIndexOf(this.containers, item => item.modals.indexOf(modal) !== -1);
      const containerInfo = this.containers[containerIndex];

      if (!containerInfo.restore) {
        containerInfo.restore = handleContainer(containerInfo, props);
      }
    }

    remove(modal, ariaHiddenState = true) {
      const modalIndex = this.modals.indexOf(modal);

      if (modalIndex === -1) {
        return modalIndex;
      }

      const containerIndex = findIndexOf(this.containers, item => item.modals.indexOf(modal) !== -1);
      const containerInfo = this.containers[containerIndex];
      containerInfo.modals.splice(containerInfo.modals.indexOf(modal), 1);
      this.modals.splice(modalIndex, 1); // If that was the last modal in a container, clean up the container.

      if (containerInfo.modals.length === 0) {
        // The modal might be closed before it had the chance to be mounted in the DOM.
        if (containerInfo.restore) {
          containerInfo.restore();
        }

        if (modal.modalRef) {
          // In case the modal wasn't in the DOM yet.
          ariaHidden(modal.modalRef, ariaHiddenState);
        }

        ariaHiddenSiblings(containerInfo.container, modal.mount, modal.modalRef, containerInfo.hiddenSiblings, false);
        this.containers.splice(containerIndex, 1);
      } else {
        // Otherwise make sure the next top modal is visible to a screen reader.
        const nextTop = containerInfo.modals[containerInfo.modals.length - 1]; // as soon as a modal is adding its modalRef is undefined. it can't set
        // aria-hidden because the dom element doesn't exist either
        // when modal was unmounted before modalRef gets null

        if (nextTop.modalRef) {
          ariaHidden(nextTop.modalRef, false);
        }
      }

      return modalIndex;
    }

    isTopModal(modal) {
      return this.modals.length > 0 && this.modals[this.modals.length - 1] === modal;
    }

  }

  const candidatesSelector = ['input', 'select', 'textarea', 'a[href]', 'button', '[tabindex]', 'audio[controls]', 'video[controls]', '[contenteditable]:not([contenteditable="false"])'].join(',');

  function getTabIndex(node) {
    const tabindexAttr = parseInt(node.getAttribute('tabindex'), 10);

    if (!Number.isNaN(tabindexAttr)) {
      return tabindexAttr;
    } // Browsers do not return `tabIndex` correctly for contentEditable nodes;
    // https://bugs.chromium.org/p/chromium/issues/detail?id=661108&q=contenteditable%20tabindex&can=2
    // so if they don't have a tabindex attribute specifically set, assume it's 0.
    // in Chrome, <details/>, <audio controls/> and <video controls/> elements get a default
    //  `tabIndex` of -1 when the 'tabindex' attribute isn't specified in the DOM,
    //  yet they are still part of the regular tab order; in FF, they get a default
    //  `tabIndex` of 0; since Chrome still puts those elements in the regular tab
    //  order, consider their tab index to be 0.


    if (node.contentEditable === 'true' || (node.nodeName === 'AUDIO' || node.nodeName === 'VIDEO' || node.nodeName === 'DETAILS') && node.getAttribute('tabindex') === null) {
      return 0;
    }

    return node.tabIndex;
  }

  function isNonTabbableRadio(node) {
    if (node.tagName !== 'INPUT' || node.type !== 'radio') {
      return false;
    }

    if (!node.name) {
      return false;
    }

    const getRadio = selector => node.ownerDocument.querySelector(`input[type="radio"]${selector}`);

    let roving = getRadio(`[name="${node.name}"]:checked`);

    if (!roving) {
      roving = getRadio(`[name="${node.name}"]`);
    }

    return roving !== node;
  }

  function isNodeMatchingSelectorFocusable(node) {
    if (node.disabled || node.tagName === 'INPUT' && node.type === 'hidden' || isNonTabbableRadio(node)) {
      return false;
    }

    return true;
  }

  function defaultGetTabbable(root) {
    const regularTabNodes = [];
    const orderedTabNodes = [];
    Array.from(root.querySelectorAll(candidatesSelector)).forEach((node, i) => {
      const nodeTabIndex = getTabIndex(node);

      if (nodeTabIndex === -1 || !isNodeMatchingSelectorFocusable(node)) {
        return;
      }

      if (nodeTabIndex === 0) {
        regularTabNodes.push(node);
      } else {
        orderedTabNodes.push({
          documentOrder: i,
          tabIndex: nodeTabIndex,
          node
        });
      }
    });
    return orderedTabNodes.sort((a, b) => a.tabIndex === b.tabIndex ? a.documentOrder - b.documentOrder : a.tabIndex - b.tabIndex).map(a => a.node).concat(regularTabNodes);
  }

  function defaultIsEnabled() {
    return true;
  }
  /**
   * Utility component that locks focus inside the component.
   */


  function TrapFocus(props) {
    const {
      children,
      disableAutoFocus = false,
      disableEnforceFocus = false,
      disableRestoreFocus = false,
      getTabbable = defaultGetTabbable,
      isEnabled = defaultIsEnabled,
      open
    } = props;
    const ignoreNextEnforceFocus = React__namespace.useRef();
    const sentinelStart = React__namespace.useRef(null);
    const sentinelEnd = React__namespace.useRef(null);
    const nodeToRestore = React__namespace.useRef(null);
    const reactFocusEventTarget = React__namespace.useRef(null); // This variable is useful when disableAutoFocus is true.
    // It waits for the active element to move into the component to activate.

    const activated = React__namespace.useRef(false);
    const rootRef = React__namespace.useRef(null);
    const handleRef = useForkRef(children.ref, rootRef);
    const lastKeydown = React__namespace.useRef(null);
    React__namespace.useEffect(() => {
      // We might render an empty child.
      if (!open || !rootRef.current) {
        return;
      }

      activated.current = !disableAutoFocus;
    }, [disableAutoFocus, open]);
    React__namespace.useEffect(() => {
      // We might render an empty child.
      if (!open || !rootRef.current) {
        return;
      }

      const doc = ownerDocument(rootRef.current);

      if (!rootRef.current.contains(doc.activeElement)) {
        if (!rootRef.current.hasAttribute('tabIndex')) {
          {
            console.error(['MUI: The modal content node does not accept focus.', 'For the benefit of assistive technologies, ' + 'the tabIndex of the node is being set to "-1".'].join('\n'));
          }

          rootRef.current.setAttribute('tabIndex', -1);
        }

        if (activated.current) {
          rootRef.current.focus();
        }
      }

      return () => {
        // restoreLastFocus()
        if (!disableRestoreFocus) {
          // In IE11 it is possible for document.activeElement to be null resulting
          // in nodeToRestore.current being null.
          // Not all elements in IE11 have a focus method.
          // Once IE11 support is dropped the focus() call can be unconditional.
          if (nodeToRestore.current && nodeToRestore.current.focus) {
            ignoreNextEnforceFocus.current = true;
            nodeToRestore.current.focus();
          }

          nodeToRestore.current = null;
        }
      }; // Missing `disableRestoreFocus` which is fine.
      // We don't support changing that prop on an open TrapFocus
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [open]);
    React__namespace.useEffect(() => {
      // We might render an empty child.
      if (!open || !rootRef.current) {
        return;
      }

      const doc = ownerDocument(rootRef.current);

      const contain = nativeEvent => {
        const {
          current: rootElement
        } = rootRef; // Cleanup functions are executed lazily in React 17.
        // Contain can be called between the component being unmounted and its cleanup function being run.

        if (rootElement === null) {
          return;
        }

        if (!doc.hasFocus() || disableEnforceFocus || !isEnabled() || ignoreNextEnforceFocus.current) {
          ignoreNextEnforceFocus.current = false;
          return;
        }

        if (!rootElement.contains(doc.activeElement)) {
          // if the focus event is not coming from inside the children's react tree, reset the refs
          if (nativeEvent && reactFocusEventTarget.current !== nativeEvent.target || doc.activeElement !== reactFocusEventTarget.current) {
            reactFocusEventTarget.current = null;
          } else if (reactFocusEventTarget.current !== null) {
            return;
          }

          if (!activated.current) {
            return;
          }

          let tabbable = [];

          if (doc.activeElement === sentinelStart.current || doc.activeElement === sentinelEnd.current) {
            tabbable = getTabbable(rootRef.current);
          }

          if (tabbable.length > 0) {
            var _lastKeydown$current, _lastKeydown$current2;

            const isShiftTab = Boolean(((_lastKeydown$current = lastKeydown.current) == null ? void 0 : _lastKeydown$current.shiftKey) && ((_lastKeydown$current2 = lastKeydown.current) == null ? void 0 : _lastKeydown$current2.key) === 'Tab');
            const focusNext = tabbable[0];
            const focusPrevious = tabbable[tabbable.length - 1];

            if (isShiftTab) {
              focusPrevious.focus();
            } else {
              focusNext.focus();
            }
          } else {
            rootElement.focus();
          }
        }
      };

      const loopFocus = nativeEvent => {
        lastKeydown.current = nativeEvent;

        if (disableEnforceFocus || !isEnabled() || nativeEvent.key !== 'Tab') {
          return;
        } // Make sure the next tab starts from the right place.
        // doc.activeElement referes to the origin.


        if (doc.activeElement === rootRef.current && nativeEvent.shiftKey) {
          // We need to ignore the next contain as
          // it will try to move the focus back to the rootRef element.
          ignoreNextEnforceFocus.current = true;
          sentinelEnd.current.focus();
        }
      };

      doc.addEventListener('focusin', contain);
      doc.addEventListener('keydown', loopFocus, true); // With Edge, Safari and Firefox, no focus related events are fired when the focused area stops being a focused area.
      // e.g. https://bugzilla.mozilla.org/show_bug.cgi?id=559561.
      // Instead, we can look if the active element was restored on the BODY element.
      //
      // The whatwg spec defines how the browser should behave but does not explicitly mention any events:
      // https://html.spec.whatwg.org/multipage/interaction.html#focus-fixup-rule.

      const interval = setInterval(() => {
        if (doc.activeElement.tagName === 'BODY') {
          contain();
        }
      }, 50);
      return () => {
        clearInterval(interval);
        doc.removeEventListener('focusin', contain);
        doc.removeEventListener('keydown', loopFocus, true);
      };
    }, [disableAutoFocus, disableEnforceFocus, disableRestoreFocus, isEnabled, open, getTabbable]);

    const onFocus = event => {
      if (nodeToRestore.current === null) {
        nodeToRestore.current = event.relatedTarget;
      }

      activated.current = true;
      reactFocusEventTarget.current = event.target;
      const childrenPropsHandler = children.props.onFocus;

      if (childrenPropsHandler) {
        childrenPropsHandler(event);
      }
    };

    const handleFocusSentinel = event => {
      if (nodeToRestore.current === null) {
        nodeToRestore.current = event.relatedTarget;
      }

      activated.current = true;
    };

    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1("div", {
        tabIndex: 0,
        onFocus: handleFocusSentinel,
        ref: sentinelStart,
        "data-test": "sentinelStart"
      }), /*#__PURE__*/React__namespace.cloneElement(children, {
        ref: handleRef,
        onFocus
      }), /*#__PURE__*/jsxRuntime_1("div", {
        tabIndex: 0,
        onFocus: handleFocusSentinel,
        ref: sentinelEnd,
        "data-test": "sentinelEnd"
      })]
    });
  }

  TrapFocus.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1,

    /**
     * If `true`, the trap focus will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any trap focus children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the trap focus less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableAutoFocus: PropTypes.bool,

    /**
     * If `true`, the trap focus will not prevent focus from leaving the trap focus while open.
     *
     * Generally this should never be set to `true` as it makes the trap focus less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableEnforceFocus: PropTypes.bool,

    /**
     * If `true`, the trap focus will not restore focus to previously focused element once
     * trap focus is hidden or unmounted.
     * @default false
     */
    disableRestoreFocus: PropTypes.bool,

    /**
     * Returns an array of ordered tabbable nodes (i.e. in tab order) within the root.
     * For instance, you can provide the "tabbable" npm dependency.
     * @param {HTMLElement} root
     */
    getTabbable: PropTypes.func,

    /**
     * This prop extends the `open` prop.
     * It allows to toggle the open state without having to wait for a rerender when changing the `open` prop.
     * This prop should be memoized.
     * It can be used to support multiple trap focus mounted at the same time.
     * @default function defaultIsEnabled() {
     *   return true;
     * }
     */
    isEnabled: PropTypes.func,

    /**
     * If `true`, focus is locked.
     */
    open: PropTypes.bool.isRequired
  } ;

  {
    // eslint-disable-next-line
    TrapFocus['propTypes' + ''] = exactProp(TrapFocus.propTypes);
  }

  function getModalUtilityClass(slot) {
    return generateUtilityClass('MuiModal', slot);
  }
  const modalUnstyledClasses = generateUtilityClasses('MuiModal', ['root', 'hidden']);
  var modalUnstyledClasses$1 = modalUnstyledClasses;

  const _excluded$2a = ["children", "classes", "className", "closeAfterTransition", "component", "components", "componentsProps", "container", "disableAutoFocus", "disableEnforceFocus", "disableEscapeKeyDown", "disablePortal", "disableRestoreFocus", "disableScrollLock", "hideBackdrop", "keepMounted", "manager", "onBackdropClick", "onClose", "onKeyDown", "open", "onTransitionEnter", "onTransitionExited"];

  const useUtilityClasses$1N = ownerState => {
    const {
      open,
      exited,
      classes
    } = ownerState;
    const slots = {
      root: ['root', !open && exited && 'hidden']
    };
    return composeClasses(slots, getModalUtilityClass, classes);
  };

  function getContainer(container) {
    return typeof container === 'function' ? container() : container;
  }

  function getHasTransition(props) {
    return props.children ? props.children.props.hasOwnProperty('in') : false;
  } // A modal manager used to track and manage the state of open Modals.
  // Modals don't open on the server so this won't conflict with concurrent requests.


  const defaultManager = new ModalManager();
  /**
   * Modal is a lower-level construct that is leveraged by the following components:
   *
   * - [Dialog](/material-ui/api/dialog/)
   * - [Drawer](/material-ui/api/drawer/)
   * - [Menu](/material-ui/api/menu/)
   * - [Popover](/material-ui/api/popover/)
   *
   * If you are creating a modal dialog, you probably want to use the [Dialog](/material-ui/api/dialog/) component
   * rather than directly using Modal.
   *
   * This component shares many concepts with [react-overlays](https://react-bootstrap.github.io/react-overlays/#modals).
   */

  const ModalUnstyled = /*#__PURE__*/React__namespace.forwardRef(function ModalUnstyled(props, ref) {
    var _props$ariaHidden, _componentsProps$root;

    const {
      children,
      classes: classesProp,
      className,
      closeAfterTransition = false,
      component = 'div',
      components = {},
      componentsProps = {},
      container,
      disableAutoFocus = false,
      disableEnforceFocus = false,
      disableEscapeKeyDown = false,
      disablePortal = false,
      disableRestoreFocus = false,
      disableScrollLock = false,
      hideBackdrop = false,
      keepMounted = false,
      // private
      // eslint-disable-next-line react/prop-types
      manager = defaultManager,
      onBackdropClick,
      onClose,
      onKeyDown,
      open,

      /* eslint-disable react/prop-types */
      onTransitionEnter,
      onTransitionExited
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$2a);

    const [exited, setExited] = React__namespace.useState(true);
    const modal = React__namespace.useRef({});
    const mountNodeRef = React__namespace.useRef(null);
    const modalRef = React__namespace.useRef(null);
    const handleRef = useForkRef(modalRef, ref);
    const hasTransition = getHasTransition(props);
    const ariaHiddenProp = (_props$ariaHidden = props['aria-hidden']) != null ? _props$ariaHidden : true;

    const getDoc = () => ownerDocument(mountNodeRef.current);

    const getModal = () => {
      modal.current.modalRef = modalRef.current;
      modal.current.mountNode = mountNodeRef.current;
      return modal.current;
    };

    const handleMounted = () => {
      manager.mount(getModal(), {
        disableScrollLock
      }); // Fix a bug on Chrome where the scroll isn't initially 0.

      modalRef.current.scrollTop = 0;
    };

    const handleOpen = useEventCallback(() => {
      const resolvedContainer = getContainer(container) || getDoc().body;
      manager.add(getModal(), resolvedContainer); // The element was already mounted.

      if (modalRef.current) {
        handleMounted();
      }
    });
    const isTopModal = React__namespace.useCallback(() => manager.isTopModal(getModal()), [manager]);
    const handlePortalRef = useEventCallback(node => {
      mountNodeRef.current = node;

      if (!node) {
        return;
      }

      if (open && isTopModal()) {
        handleMounted();
      } else {
        ariaHidden(modalRef.current, ariaHiddenProp);
      }
    });
    const handleClose = React__namespace.useCallback(() => {
      manager.remove(getModal(), ariaHiddenProp);
    }, [manager, ariaHiddenProp]);
    React__namespace.useEffect(() => {
      return () => {
        handleClose();
      };
    }, [handleClose]);
    React__namespace.useEffect(() => {
      if (open) {
        handleOpen();
      } else if (!hasTransition || !closeAfterTransition) {
        handleClose();
      }
    }, [open, handleClose, hasTransition, closeAfterTransition, handleOpen]);

    const ownerState = _extends({}, props, {
      classes: classesProp,
      closeAfterTransition,
      disableAutoFocus,
      disableEnforceFocus,
      disableEscapeKeyDown,
      disablePortal,
      disableRestoreFocus,
      disableScrollLock,
      exited,
      hideBackdrop,
      keepMounted
    });

    const classes = useUtilityClasses$1N(ownerState);

    if (!keepMounted && !open && (!hasTransition || exited)) {
      return null;
    }

    const handleEnter = () => {
      setExited(false);

      if (onTransitionEnter) {
        onTransitionEnter();
      }
    };

    const handleExited = () => {
      setExited(true);

      if (onTransitionExited) {
        onTransitionExited();
      }

      if (closeAfterTransition) {
        handleClose();
      }
    };

    const handleBackdropClick = event => {
      if (event.target !== event.currentTarget) {
        return;
      }

      if (onBackdropClick) {
        onBackdropClick(event);
      }

      if (onClose) {
        onClose(event, 'backdropClick');
      }
    };

    const handleKeyDown = event => {
      if (onKeyDown) {
        onKeyDown(event);
      } // The handler doesn't take event.defaultPrevented into account:
      //
      // event.preventDefault() is meant to stop default behaviors like
      // clicking a checkbox to check it, hitting a button to submit a form,
      // and hitting left arrow to move the cursor in a text input etc.
      // Only special HTML elements have these default behaviors.


      if (event.key !== 'Escape' || !isTopModal()) {
        return;
      }

      if (!disableEscapeKeyDown) {
        // Swallow the event, in case someone is listening for the escape key on the body.
        event.stopPropagation();

        if (onClose) {
          onClose(event, 'escapeKeyDown');
        }
      }
    };

    const childProps = {};

    if (children.props.tabIndex === undefined) {
      childProps.tabIndex = '-1';
    } // It's a Transition like component


    if (hasTransition) {
      childProps.onEnter = createChainedFunction(handleEnter, children.props.onEnter);
      childProps.onExited = createChainedFunction(handleExited, children.props.onExited);
    }

    const Root = components.Root || component;
    const rootProps = appendOwnerState(Root, _extends({
      role: 'presentation'
    }, other, componentsProps.root, {
      ref: handleRef,
      onKeyDown: handleKeyDown,
      className: clsx(classes.root, (_componentsProps$root = componentsProps.root) == null ? void 0 : _componentsProps$root.className, className)
    }), ownerState);
    const BackdropComponent = components.Backdrop;
    const backdropProps = appendOwnerState(BackdropComponent, _extends({
      'aria-hidden': true,
      open,
      onClick: handleBackdropClick
    }, componentsProps.backdrop), ownerState);
    return /*#__PURE__*/jsxRuntime_1(Portal$1, {
      ref: handlePortalRef,
      container: container,
      disablePortal: disablePortal,
      children: /*#__PURE__*/jsxRuntime_2(Root, _extends({}, rootProps, {
        children: [!hideBackdrop && BackdropComponent ? /*#__PURE__*/jsxRuntime_1(BackdropComponent, _extends({}, backdropProps)) : null, /*#__PURE__*/jsxRuntime_1(TrapFocus, {
          disableEnforceFocus: disableEnforceFocus,
          disableAutoFocus: disableAutoFocus,
          disableRestoreFocus: disableRestoreFocus,
          isEnabled: isTopModal,
          open: open,
          children: /*#__PURE__*/React__namespace.cloneElement(children, childProps)
        })]
      }))
    });
  });
  ModalUnstyled.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1.isRequired,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * When set to true the Modal waits until a nested Transition is completed before closing.
     * @default false
     */
    closeAfterTransition: PropTypes.bool,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The components used for each slot inside the Modal.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Backdrop: PropTypes.elementType,
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Modal.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      backdrop: PropTypes.object,
      root: PropTypes.object
    }),

    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([HTMLElementType, PropTypes.func]),

    /**
     * If `true`, the modal will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any modal children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableAutoFocus: PropTypes.bool,

    /**
     * If `true`, the modal will not prevent focus from leaving the modal while open.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableEnforceFocus: PropTypes.bool,

    /**
     * If `true`, hitting escape will not fire the `onClose` callback.
     * @default false
     */
    disableEscapeKeyDown: PropTypes.bool,

    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,

    /**
     * If `true`, the modal will not restore focus to previously focused element once
     * modal is hidden or unmounted.
     * @default false
     */
    disableRestoreFocus: PropTypes.bool,

    /**
     * Disable the scroll lock behavior.
     * @default false
     */
    disableScrollLock: PropTypes.bool,

    /**
     * If `true`, the backdrop is not rendered.
     * @default false
     */
    hideBackdrop: PropTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Modal.
     * @default false
     */
    keepMounted: PropTypes.bool,

    /**
     * Callback fired when the backdrop is clicked.
     * @deprecated Use the `onClose` prop with the `reason` argument to handle the `backdropClick` events.
     */
    onBackdropClick: PropTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * The `reason` parameter can optionally be used to control the response to `onClose`.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be: `"escapeKeyDown"`, `"backdropClick"`.
     */
    onClose: PropTypes.func,

    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired
  } ;
  var ModalUnstyled$1 = ModalUnstyled;

  function NoSsr(props) {
    const {
      children,
      defer = false,
      fallback = null
    } = props;
    const [mountedState, setMountedState] = React__namespace.useState(false);
    useEnhancedEffect$1(() => {
      if (!defer) {
        setMountedState(true);
      }
    }, [defer]);
    React__namespace.useEffect(() => {
      if (defer) {
        setMountedState(true);
      }
    }, [defer]); // We need the Fragment here to force react-docgen to recognise NoSsr as a component.

    return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
      children: mountedState ? children : fallback
    });
  }

  NoSsr.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * You can wrap a node.
     */
    children: PropTypes.node,

    /**
     * If `true`, the component will not only prevent server-side rendering.
     * It will also defer the rendering of the children into a different screen frame.
     * @default false
     */
    defer: PropTypes.bool,

    /**
     * The fallback content to display.
     * @default null
     */
    fallback: PropTypes.node
  } ;

  {
    // eslint-disable-next-line
    NoSsr['propTypes' + ''] = exactProp(NoSsr.propTypes);
  }

  function getSliderUtilityClass(slot) {
    return generateUtilityClass('MuiSlider', slot);
  }
  const sliderUnstyledClasses = generateUtilityClasses('MuiSlider', ['root', 'active', 'focusVisible', 'disabled', 'dragging', 'marked', 'vertical', 'trackInverted', 'trackFalse', 'rail', 'track', 'mark', 'markActive', 'markLabel', 'markLabelActive', 'thumb', 'valueLabel', 'valueLabelOpen', 'valueLabelCircle', 'valueLabelLabel']);
  var sliderUnstyledClasses$1 = sliderUnstyledClasses;

  const useValueLabelClasses = props => {
    const {
      open
    } = props;
    const utilityClasses = {
      offset: clsx(open && sliderUnstyledClasses$1.valueLabelOpen),
      circle: sliderUnstyledClasses$1.valueLabelCircle,
      label: sliderUnstyledClasses$1.valueLabelLabel
    };
    return utilityClasses;
  };
  /**
   * @ignore - internal component.
   */


  function SliderValueLabelUnstyled(props) {
    const {
      children,
      className,
      value,
      theme
    } = props;
    const classes = useValueLabelClasses(props);
    return /*#__PURE__*/React__namespace.cloneElement(children, {
      className: clsx(children.props.className)
    }, /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [children.props.children, /*#__PURE__*/jsxRuntime_1("span", {
        className: clsx(classes.offset, className),
        theme: theme,
        "aria-hidden": true,
        children: /*#__PURE__*/jsxRuntime_1("span", {
          className: classes.circle,
          children: /*#__PURE__*/jsxRuntime_1("span", {
            className: classes.label,
            children: value
          })
        })
      })]
    }));
  }
  SliderValueLabelUnstyled.propTypes = {
    children: PropTypes.element.isRequired,
    className: PropTypes.string,
    theme: PropTypes.any,
    value: PropTypes.node
  } ;

  const INTENTIONAL_DRAG_COUNT_THRESHOLD = 2;

  function asc(a, b) {
    return a - b;
  }

  function clamp$2(value, min, max) {
    if (value == null) {
      return min;
    }

    return Math.min(Math.max(min, value), max);
  }

  function findClosest(values, currentValue) {
    var _values$reduce;

    const {
      index: closestIndex
    } = (_values$reduce = values.reduce((acc, value, index) => {
      const distance = Math.abs(currentValue - value);

      if (acc === null || distance < acc.distance || distance === acc.distance) {
        return {
          distance,
          index
        };
      }

      return acc;
    }, null)) != null ? _values$reduce : {};
    return closestIndex;
  }

  function trackFinger(event, touchId) {
    // The event is TouchEvent
    if (touchId.current !== undefined && event.changedTouches) {
      const touchEvent = event;

      for (let i = 0; i < touchEvent.changedTouches.length; i += 1) {
        const touch = touchEvent.changedTouches[i];

        if (touch.identifier === touchId.current) {
          return {
            x: touch.clientX,
            y: touch.clientY
          };
        }
      }

      return false;
    } // The event is MouseEvent


    return {
      x: event.clientX,
      y: event.clientY
    };
  }

  function valueToPercent(value, min, max) {
    return (value - min) * 100 / (max - min);
  }

  function percentToValue(percent, min, max) {
    return (max - min) * percent + min;
  }

  function getDecimalPrecision$1(num) {
    // This handles the case when num is very small (0.00000001), js will turn this into 1e-8.
    // When num is bigger than 1 or less than -1 it won't get converted to this notation so it's fine.
    if (Math.abs(num) < 1) {
      const parts = num.toExponential().split('e-');
      const matissaDecimalPart = parts[0].split('.')[1];
      return (matissaDecimalPart ? matissaDecimalPart.length : 0) + parseInt(parts[1], 10);
    }

    const decimalPart = num.toString().split('.')[1];
    return decimalPart ? decimalPart.length : 0;
  }

  function roundValueToStep(value, step, min) {
    const nearest = Math.round((value - min) / step) * step + min;
    return Number(nearest.toFixed(getDecimalPrecision$1(step)));
  }

  function setValueIndex({
    values,
    newValue,
    index
  }) {
    const output = values.slice();
    output[index] = newValue;
    return output.sort(asc);
  }

  function focusThumb({
    sliderRef,
    activeIndex,
    setActive
  }) {
    var _sliderRef$current, _doc$activeElement;

    const doc = ownerDocument(sliderRef.current);

    if (!((_sliderRef$current = sliderRef.current) != null && _sliderRef$current.contains(doc.activeElement)) || Number(doc == null ? void 0 : (_doc$activeElement = doc.activeElement) == null ? void 0 : _doc$activeElement.getAttribute('data-index')) !== activeIndex) {
      var _sliderRef$current2;

      (_sliderRef$current2 = sliderRef.current) == null ? void 0 : _sliderRef$current2.querySelector(`[type="range"][data-index="${activeIndex}"]`).focus();
    }

    if (setActive) {
      setActive(activeIndex);
    }
  }

  const axisProps = {
    horizontal: {
      offset: percent => ({
        left: `${percent}%`
      }),
      leap: percent => ({
        width: `${percent}%`
      })
    },
    'horizontal-reverse': {
      offset: percent => ({
        right: `${percent}%`
      }),
      leap: percent => ({
        width: `${percent}%`
      })
    },
    vertical: {
      offset: percent => ({
        bottom: `${percent}%`
      }),
      leap: percent => ({
        height: `${percent}%`
      })
    }
  };
  const Identity$1 = x => x; // TODO: remove support for Safari < 13.
  // https://caniuse.com/#search=touch-action
  //
  // Safari, on iOS, supports touch action since v13.
  // Over 80% of the iOS phones are compatible
  // in August 2020.
  // Utilizing the CSS.supports method to check if touch-action is supported.
  // Since CSS.supports is supported on all but Edge@12 and IE and touch-action
  // is supported on both Edge@12 and IE if CSS.supports is not available that means that
  // touch-action will be supported

  let cachedSupportsTouchActionNone;

  function doesSupportTouchActionNone() {
    if (cachedSupportsTouchActionNone === undefined) {
      if (typeof CSS !== 'undefined' && typeof CSS.supports === 'function') {
        cachedSupportsTouchActionNone = CSS.supports('touch-action', 'none');
      } else {
        cachedSupportsTouchActionNone = true;
      }
    }

    return cachedSupportsTouchActionNone;
  }

  function useSlider(parameters) {
    const {
      'aria-labelledby': ariaLabelledby,
      defaultValue,
      disabled = false,
      disableSwap = false,
      isRtl = false,
      marks: marksProp = false,
      max = 100,
      min = 0,
      name,
      onChange,
      onChangeCommitted,
      orientation = 'horizontal',
      ref,
      scale = Identity$1,
      step = 1,
      tabIndex,
      value: valueProp
    } = parameters;
    const touchId = React__namespace.useRef(); // We can't use the :active browser pseudo-classes.
    // - The active state isn't triggered when clicking on the rail.
    // - The active state isn't transferred when inversing a range slider.

    const [active, setActive] = React__namespace.useState(-1);
    const [open, setOpen] = React__namespace.useState(-1);
    const [dragging, setDragging] = React__namespace.useState(false);
    const moveCount = React__namespace.useRef(0);
    const [valueDerived, setValueState] = useControlled({
      controlled: valueProp,
      default: defaultValue != null ? defaultValue : min,
      name: 'Slider'
    });

    const handleChange = onChange && ((event, value, thumbIndex) => {
      // Redefine target to allow name and value to be read.
      // This allows seamless integration with the most popular form libraries.
      // https://github.com/mui/material-ui/issues/13485#issuecomment-676048492
      // Clone the event to not override `target` of the original event.
      const nativeEvent = event.nativeEvent || event; // @ts-ignore The nativeEvent is function, not object

      const clonedEvent = new nativeEvent.constructor(nativeEvent.type, nativeEvent);
      Object.defineProperty(clonedEvent, 'target', {
        writable: true,
        value: {
          value,
          name
        }
      });
      onChange(clonedEvent, value, thumbIndex);
    });

    const range = Array.isArray(valueDerived);
    let values = range ? valueDerived.slice().sort(asc) : [valueDerived];
    values = values.map(value => clamp$2(value, min, max));
    const marks = marksProp === true && step !== null ? [...Array(Math.floor((max - min) / step) + 1)].map((_, index) => ({
      value: min + step * index
    })) : marksProp || [];
    const marksValues = marks.map(mark => mark.value);
    const {
      isFocusVisibleRef,
      onBlur: handleBlurVisible,
      onFocus: handleFocusVisible,
      ref: focusVisibleRef
    } = useIsFocusVisible();
    const [focusVisible, setFocusVisible] = React__namespace.useState(-1);
    const sliderRef = React__namespace.useRef();
    const handleFocusRef = useForkRef(focusVisibleRef, sliderRef);
    const handleRef = useForkRef(ref, handleFocusRef);

    const createHandleHiddenInputFocus = otherHandlers => event => {
      var _otherHandlers$onFocu;

      const index = Number(event.currentTarget.getAttribute('data-index'));
      handleFocusVisible(event);

      if (isFocusVisibleRef.current === true) {
        setFocusVisible(index);
      }

      setOpen(index);
      otherHandlers == null ? void 0 : (_otherHandlers$onFocu = otherHandlers.onFocus) == null ? void 0 : _otherHandlers$onFocu.call(otherHandlers, event);
    };

    const createHandleHiddenInputBlur = otherHandlers => event => {
      var _otherHandlers$onBlur;

      handleBlurVisible(event);

      if (isFocusVisibleRef.current === false) {
        setFocusVisible(-1);
      }

      setOpen(-1);
      otherHandlers == null ? void 0 : (_otherHandlers$onBlur = otherHandlers.onBlur) == null ? void 0 : _otherHandlers$onBlur.call(otherHandlers, event);
    };

    useEnhancedEffect$1(() => {
      if (disabled && sliderRef.current.contains(document.activeElement)) {
        var _document$activeEleme;

        // This is necessary because Firefox and Safari will keep focus
        // on a disabled element:
        // https://codesandbox.io/s/mui-pr-22247-forked-h151h?file=/src/App.js
        // @ts-ignore
        (_document$activeEleme = document.activeElement) == null ? void 0 : _document$activeEleme.blur();
      }
    }, [disabled]);

    if (disabled && active !== -1) {
      setActive(-1);
    }

    if (disabled && focusVisible !== -1) {
      setFocusVisible(-1);
    }

    const createHandleHiddenInputChange = otherHandlers => event => {
      var _otherHandlers$onChan;

      (_otherHandlers$onChan = otherHandlers.onChange) == null ? void 0 : _otherHandlers$onChan.call(otherHandlers, event);
      const index = Number(event.currentTarget.getAttribute('data-index'));
      const value = values[index];
      const marksIndex = marksValues.indexOf(value); // @ts-ignore

      let newValue = event.target.valueAsNumber;

      if (marks && step == null) {
        newValue = newValue < value ? marksValues[marksIndex - 1] : marksValues[marksIndex + 1];
      }

      newValue = clamp$2(newValue, min, max);

      if (marks && step == null) {
        const currentMarkIndex = marksValues.indexOf(values[index]);
        newValue = newValue < values[index] ? marksValues[currentMarkIndex - 1] : marksValues[currentMarkIndex + 1];
      }

      if (range) {
        // Bound the new value to the thumb's neighbours.
        if (disableSwap) {
          newValue = clamp$2(newValue, values[index - 1] || -Infinity, values[index + 1] || Infinity);
        }

        const previousValue = newValue;
        newValue = setValueIndex({
          values,
          newValue,
          index
        });
        let activeIndex = index; // Potentially swap the index if needed.

        if (!disableSwap) {
          activeIndex = newValue.indexOf(previousValue);
        }

        focusThumb({
          sliderRef,
          activeIndex
        });
      }

      setValueState(newValue);
      setFocusVisible(index);

      if (handleChange) {
        handleChange(event, newValue, index);
      }

      if (onChangeCommitted) {
        onChangeCommitted(event, newValue);
      }
    };

    const previousIndex = React__namespace.useRef();
    let axis = orientation;

    if (isRtl && orientation === 'horizontal') {
      axis += '-reverse';
    }

    const getFingerNewValue = ({
      finger,
      move = false,
      values: values2
    }) => {
      const {
        current: slider
      } = sliderRef;
      const {
        width,
        height,
        bottom,
        left
      } = slider.getBoundingClientRect();
      let percent;

      if (axis.indexOf('vertical') === 0) {
        percent = (bottom - finger.y) / height;
      } else {
        percent = (finger.x - left) / width;
      }

      if (axis.indexOf('-reverse') !== -1) {
        percent = 1 - percent;
      }

      let newValue;
      newValue = percentToValue(percent, min, max);

      if (step) {
        newValue = roundValueToStep(newValue, step, min);
      } else {
        const closestIndex = findClosest(marksValues, newValue);
        newValue = marksValues[closestIndex];
      }

      newValue = clamp$2(newValue, min, max);
      let activeIndex = 0;

      if (range) {
        if (!move) {
          activeIndex = findClosest(values2, newValue);
        } else {
          activeIndex = previousIndex.current;
        } // Bound the new value to the thumb's neighbours.


        if (disableSwap) {
          newValue = clamp$2(newValue, values2[activeIndex - 1] || -Infinity, values2[activeIndex + 1] || Infinity);
        }

        const previousValue = newValue;
        newValue = setValueIndex({
          values: values2,
          newValue,
          index: activeIndex
        }); // Potentially swap the index if needed.

        if (!(disableSwap && move)) {
          activeIndex = newValue.indexOf(previousValue);
          previousIndex.current = activeIndex;
        }
      }

      return {
        newValue,
        activeIndex
      };
    };

    const handleTouchMove = useEventCallback(nativeEvent => {
      const finger = trackFinger(nativeEvent, touchId);

      if (!finger) {
        return;
      }

      moveCount.current += 1; // Cancel move in case some other element consumed a mouseup event and it was not fired.
      // @ts-ignore buttons doesn't not exists on touch event

      if (nativeEvent.type === 'mousemove' && nativeEvent.buttons === 0) {
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        handleTouchEnd(nativeEvent);
        return;
      }

      const {
        newValue,
        activeIndex
      } = getFingerNewValue({
        finger,
        move: true,
        values
      });
      focusThumb({
        sliderRef,
        activeIndex,
        setActive
      });
      setValueState(newValue);

      if (!dragging && moveCount.current > INTENTIONAL_DRAG_COUNT_THRESHOLD) {
        setDragging(true);
      }

      if (handleChange) {
        handleChange(nativeEvent, newValue, activeIndex);
      }
    });
    const handleTouchEnd = useEventCallback(nativeEvent => {
      const finger = trackFinger(nativeEvent, touchId);
      setDragging(false);

      if (!finger) {
        return;
      }

      const {
        newValue
      } = getFingerNewValue({
        finger,
        move: true,
        values
      });
      setActive(-1);

      if (nativeEvent.type === 'touchend') {
        setOpen(-1);
      }

      if (onChangeCommitted) {
        onChangeCommitted(nativeEvent, newValue);
      }

      touchId.current = undefined; // eslint-disable-next-line @typescript-eslint/no-use-before-define

      stopListening();
    });
    const handleTouchStart = useEventCallback(nativeEvent => {
      if (disabled) {
        return;
      } // If touch-action: none; is not supported we need to prevent the scroll manually.


      if (!doesSupportTouchActionNone()) {
        nativeEvent.preventDefault();
      }

      const touch = nativeEvent.changedTouches[0];

      if (touch != null) {
        // A number that uniquely identifies the current finger in the touch session.
        touchId.current = touch.identifier;
      }

      const finger = trackFinger(nativeEvent, touchId);

      if (finger !== false) {
        const {
          newValue,
          activeIndex
        } = getFingerNewValue({
          finger,
          values
        });
        focusThumb({
          sliderRef,
          activeIndex,
          setActive
        });
        setValueState(newValue);

        if (handleChange) {
          handleChange(nativeEvent, newValue, activeIndex);
        }
      }

      moveCount.current = 0;
      const doc = ownerDocument(sliderRef.current);
      doc.addEventListener('touchmove', handleTouchMove);
      doc.addEventListener('touchend', handleTouchEnd);
    });
    const stopListening = React__namespace.useCallback(() => {
      const doc = ownerDocument(sliderRef.current);
      doc.removeEventListener('mousemove', handleTouchMove);
      doc.removeEventListener('mouseup', handleTouchEnd);
      doc.removeEventListener('touchmove', handleTouchMove);
      doc.removeEventListener('touchend', handleTouchEnd);
    }, [handleTouchEnd, handleTouchMove]);
    React__namespace.useEffect(() => {
      const {
        current: slider
      } = sliderRef;
      slider.addEventListener('touchstart', handleTouchStart, {
        passive: doesSupportTouchActionNone()
      });
      return () => {
        // @ts-ignore
        slider.removeEventListener('touchstart', handleTouchStart, {
          passive: doesSupportTouchActionNone()
        });
        stopListening();
      };
    }, [stopListening, handleTouchStart]);
    React__namespace.useEffect(() => {
      if (disabled) {
        stopListening();
      }
    }, [disabled, stopListening]);

    const createHandleMouseDown = otherHandlers => event => {
      var _otherHandlers$onMous;

      (_otherHandlers$onMous = otherHandlers.onMouseDown) == null ? void 0 : _otherHandlers$onMous.call(otherHandlers, event);

      if (disabled) {
        return;
      }

      if (event.defaultPrevented) {
        return;
      } // Only handle left clicks


      if (event.button !== 0) {
        return;
      } // Avoid text selection


      event.preventDefault();
      const finger = trackFinger(event, touchId);

      if (finger !== false) {
        const {
          newValue,
          activeIndex
        } = getFingerNewValue({
          finger,
          values
        });
        focusThumb({
          sliderRef,
          activeIndex,
          setActive
        });
        setValueState(newValue);

        if (handleChange) {
          handleChange(event, newValue, activeIndex);
        }
      }

      moveCount.current = 0;
      const doc = ownerDocument(sliderRef.current);
      doc.addEventListener('mousemove', handleTouchMove);
      doc.addEventListener('mouseup', handleTouchEnd);
    };

    const trackOffset = valueToPercent(range ? values[0] : min, min, max);
    const trackLeap = valueToPercent(values[values.length - 1], min, max) - trackOffset;

    const getRootProps = (otherHandlers = {}) => {
      const ownEventHandlers = {
        onMouseDown: createHandleMouseDown(otherHandlers || {})
      };

      const mergedEventHandlers = _extends({}, otherHandlers, ownEventHandlers);

      return _extends({
        ref: handleRef
      }, mergedEventHandlers);
    };

    const createHandleMouseOver = otherHandlers => event => {
      var _otherHandlers$onMous2;

      (_otherHandlers$onMous2 = otherHandlers.onMouseOver) == null ? void 0 : _otherHandlers$onMous2.call(otherHandlers, event);
      const index = Number(event.currentTarget.getAttribute('data-index'));
      setOpen(index);
    };

    const createHandleMouseLeave = otherHandlers => event => {
      var _otherHandlers$onMous3;

      (_otherHandlers$onMous3 = otherHandlers.onMouseLeave) == null ? void 0 : _otherHandlers$onMous3.call(otherHandlers, event);
      setOpen(-1);
    };

    const getThumbProps = (otherHandlers = {}) => {
      const ownEventHandlers = {
        onMouseOver: createHandleMouseOver(otherHandlers || {}),
        onMouseLeave: createHandleMouseLeave(otherHandlers || {})
      };

      const mergedEventHandlers = _extends({}, otherHandlers, ownEventHandlers);

      return _extends({}, mergedEventHandlers);
    };

    const getHiddenInputProps = (otherHandlers = {}) => {
      const ownEventHandlers = {
        onChange: createHandleHiddenInputChange(otherHandlers || {}),
        onFocus: createHandleHiddenInputFocus(otherHandlers || {}),
        onBlur: createHandleHiddenInputBlur(otherHandlers || {})
      };

      const mergedEventHandlers = _extends({}, otherHandlers, ownEventHandlers);

      return _extends({
        tabIndex,
        'aria-labelledby': ariaLabelledby,
        'aria-orientation': orientation,
        'aria-valuemax': scale(max),
        'aria-valuemin': scale(min),
        name,
        type: 'range',
        min: parameters.min,
        max: parameters.max,
        step: parameters.step,
        disabled
      }, mergedEventHandlers, {
        style: _extends({}, visuallyHidden$1, {
          direction: isRtl ? 'rtl' : 'ltr',
          // So that VoiceOver's focus indicator matches the thumb's dimensions
          width: '100%',
          height: '100%'
        })
      });
    };

    return {
      active,
      axis: axis,
      axisProps,
      dragging,
      focusVisible,
      getHiddenInputProps,
      getRootProps,
      getThumbProps,
      marks: marks,
      open,
      range,
      trackLeap,
      trackOffset,
      values
    };
  }

  const _excluded$29 = ["aria-label", "aria-valuetext", "className", "component", "classes", "disableSwap", "disabled", "getAriaLabel", "getAriaValueText", "marks", "max", "min", "name", "onChange", "onChangeCommitted", "onMouseDown", "orientation", "scale", "step", "tabIndex", "track", "value", "valueLabelDisplay", "valueLabelFormat", "isRtl", "components", "componentsProps"];

  const Identity = x => x;

  const useUtilityClasses$1M = ownerState => {
    const {
      disabled,
      dragging,
      marked,
      orientation,
      track,
      classes
    } = ownerState;
    const slots = {
      root: ['root', disabled && 'disabled', dragging && 'dragging', marked && 'marked', orientation === 'vertical' && 'vertical', track === 'inverted' && 'trackInverted', track === false && 'trackFalse'],
      rail: ['rail'],
      track: ['track'],
      mark: ['mark'],
      markActive: ['markActive'],
      markLabel: ['markLabel'],
      markLabelActive: ['markLabelActive'],
      valueLabel: ['valueLabel'],
      thumb: ['thumb', disabled && 'disabled'],
      active: ['active'],
      disabled: ['disabled'],
      focusVisible: ['focusVisible']
    };
    return composeClasses(slots, getSliderUtilityClass, classes);
  };

  const Forward = ({
    children
  }) => children;

  const SliderUnstyled = /*#__PURE__*/React__namespace.forwardRef(function SliderUnstyled(props, ref) {
    var _ref, _components$Rail, _components$Track, _components$Thumb, _components$ValueLabe, _components$Mark, _components$MarkLabel;

    const {
      'aria-label': ariaLabel,
      'aria-valuetext': ariaValuetext,
      className,
      component,
      classes: classesProp,
      disableSwap = false,
      disabled = false,
      getAriaLabel,
      getAriaValueText,
      marks: marksProp = false,
      max = 100,
      min = 0,
      onMouseDown,
      orientation = 'horizontal',
      scale = Identity,
      step = 1,
      track = 'normal',
      valueLabelDisplay = 'off',
      valueLabelFormat = Identity,
      isRtl = false,
      components = {},
      componentsProps = {}
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$29); // all props with defaults
    // consider extracting to hook an reusing the lint rule for the varints


    const ownerState = _extends({}, props, {
      marks: marksProp,
      classes: classesProp,
      disabled,
      isRtl,
      max,
      min,
      orientation,
      scale,
      step,
      track,
      valueLabelDisplay,
      valueLabelFormat
    });

    const {
      axisProps,
      getRootProps,
      getHiddenInputProps,
      getThumbProps,
      open,
      active,
      axis,
      range,
      focusVisible,
      dragging,
      marks,
      values,
      trackOffset,
      trackLeap
    } = useSlider(_extends({}, ownerState, {
      ref
    }));
    ownerState.marked = marks.length > 0 && marks.some(mark => mark.label);
    ownerState.dragging = dragging;
    const Root = (_ref = component != null ? component : components.Root) != null ? _ref : 'span';
    const rootProps = appendOwnerState(Root, _extends({}, other, componentsProps.root), ownerState);
    const Rail = (_components$Rail = components.Rail) != null ? _components$Rail : 'span';
    const railProps = appendOwnerState(Rail, componentsProps.rail, ownerState);
    const Track = (_components$Track = components.Track) != null ? _components$Track : 'span';
    const trackProps = appendOwnerState(Track, componentsProps.track, ownerState);

    const trackStyle = _extends({}, axisProps[axis].offset(trackOffset), axisProps[axis].leap(trackLeap));

    const Thumb = (_components$Thumb = components.Thumb) != null ? _components$Thumb : 'span';
    const thumbProps = appendOwnerState(Thumb, componentsProps.thumb, ownerState);
    const ValueLabel = (_components$ValueLabe = components.ValueLabel) != null ? _components$ValueLabe : SliderValueLabelUnstyled;
    const valueLabelProps = appendOwnerState(ValueLabel, componentsProps.valueLabel, ownerState);
    const Mark = (_components$Mark = components.Mark) != null ? _components$Mark : 'span';
    const markProps = appendOwnerState(Mark, componentsProps.mark, ownerState);
    const MarkLabel = (_components$MarkLabel = components.MarkLabel) != null ? _components$MarkLabel : 'span';
    const markLabelProps = appendOwnerState(MarkLabel, componentsProps.markLabel, ownerState);
    const Input = components.Input || 'input';
    const inputProps = appendOwnerState(Input, componentsProps.input, ownerState);
    const hiddenInputProps = getHiddenInputProps();
    const classes = useUtilityClasses$1M(ownerState);
    return /*#__PURE__*/jsxRuntime_2(Root, _extends({}, rootProps, getRootProps({
      onMouseDown
    }), {
      className: clsx(classes.root, rootProps.className, className),
      children: [/*#__PURE__*/jsxRuntime_1(Rail, _extends({}, railProps, {
        className: clsx(classes.rail, railProps.className)
      })), /*#__PURE__*/jsxRuntime_1(Track, _extends({}, trackProps, {
        className: clsx(classes.track, trackProps.className),
        style: _extends({}, trackStyle, trackProps.style)
      })), marks.filter(mark => mark.value >= min && mark.value <= max).map((mark, index) => {
        const percent = valueToPercent(mark.value, min, max);
        const style = axisProps[axis].offset(percent);
        let markActive;

        if (track === false) {
          markActive = values.indexOf(mark.value) !== -1;
        } else {
          markActive = track === 'normal' && (range ? mark.value >= values[0] && mark.value <= values[values.length - 1] : mark.value <= values[0]) || track === 'inverted' && (range ? mark.value <= values[0] || mark.value >= values[values.length - 1] : mark.value >= values[0]);
        }

        return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
          children: [/*#__PURE__*/jsxRuntime_1(Mark, _extends({
            "data-index": index
          }, markProps, !isHostComponent(Mark) && {
            markActive
          }, {
            style: _extends({}, style, markProps.style),
            className: clsx(classes.mark, markProps.className, markActive && classes.markActive)
          })), mark.label != null ? /*#__PURE__*/jsxRuntime_1(MarkLabel, _extends({
            "aria-hidden": true,
            "data-index": index
          }, markLabelProps, !isHostComponent(MarkLabel) && {
            markLabelActive: markActive
          }, {
            style: _extends({}, style, markLabelProps.style),
            className: clsx(classes.markLabel, markLabelProps.className, markActive && classes.markLabelActive),
            children: mark.label
          })) : null]
        }, mark.value);
      }), values.map((value, index) => {
        const percent = valueToPercent(value, min, max);
        const style = axisProps[axis].offset(percent);
        const ValueLabelComponent = valueLabelDisplay === 'off' ? Forward : ValueLabel;
        return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
          children: /*#__PURE__*/jsxRuntime_1(ValueLabelComponent, _extends({}, !isHostComponent(ValueLabelComponent) && {
            valueLabelFormat,
            valueLabelDisplay,
            value: typeof valueLabelFormat === 'function' ? valueLabelFormat(scale(value), index) : valueLabelFormat,
            index,
            open: open === index || active === index || valueLabelDisplay === 'on',
            disabled
          }, valueLabelProps, {
            className: clsx(classes.valueLabel, valueLabelProps.className),
            children: /*#__PURE__*/jsxRuntime_1(Thumb, _extends({
              "data-index": index
            }, thumbProps, getThumbProps(), {
              className: clsx(classes.thumb, thumbProps.className, active === index && classes.active, focusVisible === index && classes.focusVisible),
              style: _extends({}, style, {
                pointerEvents: disableSwap && active !== index ? 'none' : undefined
              }, thumbProps.style),
              children: /*#__PURE__*/jsxRuntime_1(Input, _extends({}, hiddenInputProps, {
                "data-index": index,
                "aria-label": getAriaLabel ? getAriaLabel(index) : ariaLabel,
                "aria-valuenow": scale(value),
                "aria-valuetext": getAriaValueText ? getAriaValueText(scale(value), index) : ariaValuetext,
                value: values[index]
              }, !isHostComponent(Input) && {
                ownerState: _extends({}, ownerState, inputProps.ownerState)
              }, inputProps, {
                style: _extends({}, hiddenInputProps.style, inputProps.style)
              }))
            }))
          }))
        }, index);
      })]
    }));
  });
  SliderUnstyled.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The label of the slider.
     */
    'aria-label': chainPropTypes(PropTypes.string, props => {
      const range = Array.isArray(props.value || props.defaultValue);

      if (range && props['aria-label'] != null) {
        return new Error('MUI: You need to use the `getAriaLabel` prop instead of `aria-label` when using a range slider.');
      }

      return null;
    }),

    /**
     * The id of the element containing a label for the slider.
     */
    'aria-labelledby': PropTypes.string,

    /**
     * A string value that provides a user-friendly name for the current value of the slider.
     */
    'aria-valuetext': chainPropTypes(PropTypes.string, props => {
      const range = Array.isArray(props.value || props.defaultValue);

      if (range && props['aria-valuetext'] != null) {
        return new Error('MUI: You need to use the `getAriaValueText` prop instead of `aria-valuetext` when using a range slider.');
      }

      return null;
    }),

    /**
     * @ignore
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The components used for each slot inside the Slider.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Input: PropTypes.elementType,
      Mark: PropTypes.elementType,
      MarkLabel: PropTypes.elementType,
      Rail: PropTypes.elementType,
      Root: PropTypes.elementType,
      Thumb: PropTypes.elementType,
      Track: PropTypes.elementType,
      ValueLabel: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Slider.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      input: PropTypes.object,
      mark: PropTypes.object,
      markLabel: PropTypes.object,
      rail: PropTypes.object,
      root: PropTypes.object,
      thumb: PropTypes.object,
      track: PropTypes.object,
      valueLabel: PropTypes.shape({
        children: PropTypes.element,
        className: PropTypes.string,
        components: PropTypes.shape({
          Root: PropTypes.elementType
        }),
        open: PropTypes.bool,
        style: PropTypes.object,
        value: PropTypes.number,
        valueLabelDisplay: PropTypes.oneOf(['auto', 'off', 'on'])
      })
    }),

    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.number), PropTypes.number]),

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the active thumb doesn't swap when moving pointer over a thumb while dragging another thumb.
     * @default false
     */
    disableSwap: PropTypes.bool,

    /**
     * Accepts a function which returns a string value that provides a user-friendly name for the thumb labels of the slider.
     * This is important for screen reader users.
     * @param {number} index The thumb label's index to format.
     * @returns {string}
     */
    getAriaLabel: PropTypes.func,

    /**
     * Accepts a function which returns a string value that provides a user-friendly name for the current value of the slider.
     * This is important for screen reader users.
     * @param {number} value The thumb label's value to format.
     * @param {number} index The thumb label's index to format.
     * @returns {string}
     */
    getAriaValueText: PropTypes.func,

    /**
     * Indicates whether the theme context has rtl direction. It is set automatically.
     * @default false
     */
    isRtl: PropTypes.bool,

    /**
     * Marks indicate predetermined values to which the user can move the slider.
     * If `true` the marks are spaced according the value of the `step` prop.
     * If an array, it should contain objects with `value` and an optional `label` keys.
     * @default false
     */
    marks: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.shape({
      label: PropTypes.node,
      value: PropTypes.number.isRequired
    })), PropTypes.bool]),

    /**
     * The maximum allowed value of the slider.
     * Should not be equal to min.
     * @default 100
     */
    max: PropTypes.number,

    /**
     * The minimum allowed value of the slider.
     * Should not be equal to max.
     * @default 0
     */
    min: PropTypes.number,

    /**
     * Name attribute of the hidden `input` element.
     */
    name: PropTypes.string,

    /**
     * Callback function that is fired when the slider's value changed.
     *
     * @param {Event} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (any).
     * **Warning**: This is a generic event not a change event.
     * @param {number | number[]} value The new value.
     * @param {number} activeThumb Index of the currently moved thumb.
     */
    onChange: PropTypes.func,

    /**
     * Callback function that is fired when the `mouseup` is triggered.
     *
     * @param {React.SyntheticEvent | Event} event The event source of the callback. **Warning**: This is a generic event not a change event.
     * @param {number | number[]} value The new value.
     */
    onChangeCommitted: PropTypes.func,

    /**
     * @ignore
     */
    onMouseDown: PropTypes.func,

    /**
     * The component orientation.
     * @default 'horizontal'
     */
    orientation: PropTypes.oneOf(['horizontal', 'vertical']),

    /**
     * A transformation function, to change the scale of the slider.
     * @default (x) => x
     */
    scale: PropTypes.func,

    /**
     * The granularity with which the slider can step through values. (A "discrete" slider.)
     * The `min` prop serves as the origin for the valid values.
     * We recommend (max - min) to be evenly divisible by the step.
     *
     * When step is `null`, the thumb can only be slid onto marks provided with the `marks` prop.
     * @default 1
     */
    step: PropTypes.number,

    /**
     * Tab index attribute of the hidden `input` element.
     */
    tabIndex: PropTypes.number,

    /**
     * The track presentation:
     *
     * - `normal` the track will render a bar representing the slider value.
     * - `inverted` the track will render a bar representing the remaining slider value.
     * - `false` the track will render without a bar.
     * @default 'normal'
     */
    track: PropTypes.oneOf(['inverted', 'normal', false]),

    /**
     * The value of the slider.
     * For ranged sliders, provide an array with two values.
     */
    value: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.number), PropTypes.number]),

    /**
     * Controls when the value label is displayed:
     *
     * - `auto` the value label will display when the thumb is hovered or focused.
     * - `on` will display persistently.
     * - `off` will never display.
     * @default 'off'
     */
    valueLabelDisplay: PropTypes.oneOf(['auto', 'off', 'on']),

    /**
     * The format function the value label's value.
     *
     * When a function is provided, it should have the following signature:
     *
     * - {number} value The value label's value to format
     * - {number} index The value label's index to format
     * @default (x) => x
     */
    valueLabelFormat: PropTypes.oneOfType([PropTypes.func, PropTypes.string])
  } ;
  var SliderUnstyled$1 = SliderUnstyled;

  const _excluded$28 = ["onChange", "maxRows", "minRows", "style", "value"];

  function getStyleValue(computedStyle, property) {
    return parseInt(computedStyle[property], 10) || 0;
  }

  const styles$5 = {
    shadow: {
      // Visibility needed to hide the extra text area on iPads
      visibility: 'hidden',
      // Remove from the content flow
      position: 'absolute',
      // Ignore the scrollbar width
      overflow: 'hidden',
      height: 0,
      top: 0,
      left: 0,
      // Create a new layer, increase the isolation of the computed values
      transform: 'translateZ(0)'
    }
  };
  const TextareaAutosize = /*#__PURE__*/React__namespace.forwardRef(function TextareaAutosize(props, ref) {
    const {
      onChange,
      maxRows,
      minRows = 1,
      style,
      value
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$28);

    const {
      current: isControlled
    } = React__namespace.useRef(value != null);
    const inputRef = React__namespace.useRef(null);
    const handleRef = useForkRef(ref, inputRef);
    const shadowRef = React__namespace.useRef(null);
    const renders = React__namespace.useRef(0);
    const [state, setState] = React__namespace.useState({});
    const syncHeight = React__namespace.useCallback(() => {
      const input = inputRef.current;
      const containerWindow = ownerWindow(input);
      const computedStyle = containerWindow.getComputedStyle(input); // If input's width is shrunk and it's not visible, don't sync height.

      if (computedStyle.width === '0px') {
        return;
      }

      const inputShallow = shadowRef.current;
      inputShallow.style.width = computedStyle.width;
      inputShallow.value = input.value || props.placeholder || 'x';

      if (inputShallow.value.slice(-1) === '\n') {
        // Certain fonts which overflow the line height will cause the textarea
        // to report a different scrollHeight depending on whether the last line
        // is empty. Make it non-empty to avoid this issue.
        inputShallow.value += ' ';
      }

      const boxSizing = computedStyle['box-sizing'];
      const padding = getStyleValue(computedStyle, 'padding-bottom') + getStyleValue(computedStyle, 'padding-top');
      const border = getStyleValue(computedStyle, 'border-bottom-width') + getStyleValue(computedStyle, 'border-top-width'); // The height of the inner content

      const innerHeight = inputShallow.scrollHeight; // Measure height of a textarea with a single row

      inputShallow.value = 'x';
      const singleRowHeight = inputShallow.scrollHeight; // The height of the outer content

      let outerHeight = innerHeight;

      if (minRows) {
        outerHeight = Math.max(Number(minRows) * singleRowHeight, outerHeight);
      }

      if (maxRows) {
        outerHeight = Math.min(Number(maxRows) * singleRowHeight, outerHeight);
      }

      outerHeight = Math.max(outerHeight, singleRowHeight); // Take the box sizing into account for applying this value as a style.

      const outerHeightStyle = outerHeight + (boxSizing === 'border-box' ? padding + border : 0);
      const overflow = Math.abs(outerHeight - innerHeight) <= 1;
      setState(prevState => {
        // Need a large enough difference to update the height.
        // This prevents infinite rendering loop.
        if (renders.current < 20 && (outerHeightStyle > 0 && Math.abs((prevState.outerHeightStyle || 0) - outerHeightStyle) > 1 || prevState.overflow !== overflow)) {
          renders.current += 1;
          return {
            overflow,
            outerHeightStyle
          };
        }

        {
          if (renders.current === 20) {
            console.error(['MUI: Too many re-renders. The layout is unstable.', 'TextareaAutosize limits the number of renders to prevent an infinite loop.'].join('\n'));
          }
        }

        return prevState;
      });
    }, [maxRows, minRows, props.placeholder]);
    React__namespace.useEffect(() => {
      const handleResize = debounce$1(() => {
        renders.current = 0;
        syncHeight();
      });
      const containerWindow = ownerWindow(inputRef.current);
      containerWindow.addEventListener('resize', handleResize);
      let resizeObserver;

      if (typeof ResizeObserver !== 'undefined') {
        resizeObserver = new ResizeObserver(handleResize);
        resizeObserver.observe(inputRef.current);
      }

      return () => {
        handleResize.clear();
        containerWindow.removeEventListener('resize', handleResize);

        if (resizeObserver) {
          resizeObserver.disconnect();
        }
      };
    }, [syncHeight]);
    useEnhancedEffect$1(() => {
      syncHeight();
    });
    React__namespace.useEffect(() => {
      renders.current = 0;
    }, [value]);

    const handleChange = event => {
      renders.current = 0;

      if (!isControlled) {
        syncHeight();
      }

      if (onChange) {
        onChange(event);
      }
    };

    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1("textarea", _extends({
        value: value,
        onChange: handleChange,
        ref: handleRef // Apply the rows prop to get a "correct" first SSR paint
        ,
        rows: minRows,
        style: _extends({
          height: state.outerHeightStyle,
          // Need a large enough difference to allow scrolling.
          // This prevents infinite rendering loop.
          overflow: state.overflow ? 'hidden' : null
        }, style)
      }, other)), /*#__PURE__*/jsxRuntime_1("textarea", {
        "aria-hidden": true,
        className: props.className,
        readOnly: true,
        ref: shadowRef,
        tabIndex: -1,
        style: _extends({}, styles$5.shadow, style, {
          padding: 0
        })
      })]
    });
  });
  TextareaAutosize.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * Maximum number of rows to display.
     */
    maxRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * Minimum number of rows to display.
     * @default 1
     */
    minRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * @ignore
     */
    onChange: PropTypes.func,

    /**
     * @ignore
     */
    placeholder: PropTypes.string,

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * @ignore
     */
    value: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.number, PropTypes.string])
  } ;
  var TextareaAutosize$1 = TextareaAutosize;

  function createMixins(breakpoints, mixins) {
    return _extends({
      toolbar: {
        minHeight: 56,
        [breakpoints.up('xs')]: {
          '@media (orientation: landscape)': {
            minHeight: 48
          }
        },
        [breakpoints.up('sm')]: {
          minHeight: 64
        }
      }
    }, mixins);
  }

  const _excluded$27 = ["mode", "contrastThreshold", "tonalOffset"];
  const light = {
    // The colors used to style the text.
    text: {
      // The most important text.
      primary: 'rgba(0, 0, 0, 0.87)',
      // Secondary text.
      secondary: 'rgba(0, 0, 0, 0.6)',
      // Disabled text have even lower visual prominence.
      disabled: 'rgba(0, 0, 0, 0.38)'
    },
    // The color used to divide different elements.
    divider: 'rgba(0, 0, 0, 0.12)',
    // The background colors used to style the surfaces.
    // Consistency between these values is important.
    background: {
      paper: common$1.white,
      default: common$1.white
    },
    // The colors used to style the action elements.
    action: {
      // The color of an active action like an icon button.
      active: 'rgba(0, 0, 0, 0.54)',
      // The color of an hovered action.
      hover: 'rgba(0, 0, 0, 0.04)',
      hoverOpacity: 0.04,
      // The color of a selected action.
      selected: 'rgba(0, 0, 0, 0.08)',
      selectedOpacity: 0.08,
      // The color of a disabled action.
      disabled: 'rgba(0, 0, 0, 0.26)',
      // The background color of a disabled action.
      disabledBackground: 'rgba(0, 0, 0, 0.12)',
      disabledOpacity: 0.38,
      focus: 'rgba(0, 0, 0, 0.12)',
      focusOpacity: 0.12,
      activatedOpacity: 0.12
    }
  };
  const dark = {
    text: {
      primary: common$1.white,
      secondary: 'rgba(255, 255, 255, 0.7)',
      disabled: 'rgba(255, 255, 255, 0.5)',
      icon: 'rgba(255, 255, 255, 0.5)'
    },
    divider: 'rgba(255, 255, 255, 0.12)',
    background: {
      paper: '#121212',
      default: '#121212'
    },
    action: {
      active: common$1.white,
      hover: 'rgba(255, 255, 255, 0.08)',
      hoverOpacity: 0.08,
      selected: 'rgba(255, 255, 255, 0.16)',
      selectedOpacity: 0.16,
      disabled: 'rgba(255, 255, 255, 0.3)',
      disabledBackground: 'rgba(255, 255, 255, 0.12)',
      disabledOpacity: 0.38,
      focus: 'rgba(255, 255, 255, 0.12)',
      focusOpacity: 0.12,
      activatedOpacity: 0.24
    }
  };

  function addLightOrDark(intent, direction, shade, tonalOffset) {
    const tonalOffsetLight = tonalOffset.light || tonalOffset;
    const tonalOffsetDark = tonalOffset.dark || tonalOffset * 1.5;

    if (!intent[direction]) {
      if (intent.hasOwnProperty(shade)) {
        intent[direction] = intent[shade];
      } else if (direction === 'light') {
        intent.light = lighten(intent.main, tonalOffsetLight);
      } else if (direction === 'dark') {
        intent.dark = darken(intent.main, tonalOffsetDark);
      }
    }
  }

  function getDefaultPrimary(mode = 'light') {
    if (mode === 'dark') {
      return {
        main: blue$1[200],
        light: blue$1[50],
        dark: blue$1[400]
      };
    }

    return {
      main: blue$1[700],
      light: blue$1[400],
      dark: blue$1[800]
    };
  }

  function getDefaultSecondary(mode = 'light') {
    if (mode === 'dark') {
      return {
        main: purple$1[200],
        light: purple$1[50],
        dark: purple$1[400]
      };
    }

    return {
      main: purple$1[500],
      light: purple$1[300],
      dark: purple$1[700]
    };
  }

  function getDefaultError(mode = 'light') {
    if (mode === 'dark') {
      return {
        main: red$1[500],
        light: red$1[300],
        dark: red$1[700]
      };
    }

    return {
      main: red$1[700],
      light: red$1[400],
      dark: red$1[800]
    };
  }

  function getDefaultInfo(mode = 'light') {
    if (mode === 'dark') {
      return {
        main: lightBlue$1[400],
        light: lightBlue$1[300],
        dark: lightBlue$1[700]
      };
    }

    return {
      main: lightBlue$1[700],
      light: lightBlue$1[500],
      dark: lightBlue$1[900]
    };
  }

  function getDefaultSuccess(mode = 'light') {
    if (mode === 'dark') {
      return {
        main: green$1[400],
        light: green$1[300],
        dark: green$1[700]
      };
    }

    return {
      main: green$1[800],
      light: green$1[500],
      dark: green$1[900]
    };
  }

  function getDefaultWarning(mode = 'light') {
    if (mode === 'dark') {
      return {
        main: orange$1[400],
        light: orange$1[300],
        dark: orange$1[700]
      };
    }

    return {
      main: '#ed6c02',
      // closest to orange[800] that pass 3:1.
      light: orange$1[500],
      dark: orange$1[900]
    };
  }

  function createPalette(palette) {
    const {
      mode = 'light',
      contrastThreshold = 3,
      tonalOffset = 0.2
    } = palette,
          other = _objectWithoutPropertiesLoose(palette, _excluded$27);

    const primary = palette.primary || getDefaultPrimary(mode);
    const secondary = palette.secondary || getDefaultSecondary(mode);
    const error = palette.error || getDefaultError(mode);
    const info = palette.info || getDefaultInfo(mode);
    const success = palette.success || getDefaultSuccess(mode);
    const warning = palette.warning || getDefaultWarning(mode); // Use the same logic as
    // Bootstrap: https://github.com/twbs/bootstrap/blob/1d6e3710dd447de1a200f29e8fa521f8a0908f70/scss/_functions.scss#L59
    // and material-components-web https://github.com/material-components/material-components-web/blob/ac46b8863c4dab9fc22c4c662dc6bd1b65dd652f/packages/mdc-theme/_functions.scss#L54

    function getContrastText(background) {
      const contrastText = getContrastRatio(background, dark.text.primary) >= contrastThreshold ? dark.text.primary : light.text.primary;

      {
        const contrast = getContrastRatio(background, contrastText);

        if (contrast < 3) {
          console.error([`MUI: The contrast ratio of ${contrast}:1 for ${contrastText} on ${background}`, 'falls below the WCAG recommended absolute minimum contrast ratio of 3:1.', 'https://www.w3.org/TR/2008/REC-WCAG20-20081211/#visual-audio-contrast-contrast'].join('\n'));
        }
      }

      return contrastText;
    }

    const augmentColor = ({
      color,
      name,
      mainShade = 500,
      lightShade = 300,
      darkShade = 700
    }) => {
      color = _extends({}, color);

      if (!color.main && color[mainShade]) {
        color.main = color[mainShade];
      }

      if (!color.hasOwnProperty('main')) {
        throw new Error(`MUI: The color${name ? ` (${name})` : ''} provided to augmentColor(color) is invalid.
The color object needs to have a \`main\` property or a \`${mainShade}\` property.` );
      }

      if (typeof color.main !== 'string') {
        throw new Error(`MUI: The color${name ? ` (${name})` : ''} provided to augmentColor(color) is invalid.
\`color.main\` should be a string, but \`${JSON.stringify(color.main)}\` was provided instead.

Did you intend to use one of the following approaches?

import { green } from "@mui/material/colors";

const theme1 = createTheme({ palette: {
  primary: green,
} });

const theme2 = createTheme({ palette: {
  primary: { main: green[500] },
} });` );
      }

      addLightOrDark(color, 'light', lightShade, tonalOffset);
      addLightOrDark(color, 'dark', darkShade, tonalOffset);

      if (!color.contrastText) {
        color.contrastText = getContrastText(color.main);
      }

      return color;
    };

    const modes = {
      dark,
      light
    };

    {
      if (!modes[mode]) {
        console.error(`MUI: The palette mode \`${mode}\` is not supported.`);
      }
    }

    const paletteOutput = deepmerge(_extends({
      // A collection of common colors.
      common: _extends({}, common$1),
      // prevent mutable object.
      // The palette mode, can be light or dark.
      mode,
      // The colors used to represent primary interface elements for a user.
      primary: augmentColor({
        color: primary,
        name: 'primary'
      }),
      // The colors used to represent secondary interface elements for a user.
      secondary: augmentColor({
        color: secondary,
        name: 'secondary',
        mainShade: 'A400',
        lightShade: 'A200',
        darkShade: 'A700'
      }),
      // The colors used to represent interface elements that the user should be made aware of.
      error: augmentColor({
        color: error,
        name: 'error'
      }),
      // The colors used to represent potentially dangerous actions or important messages.
      warning: augmentColor({
        color: warning,
        name: 'warning'
      }),
      // The colors used to present information to the user that is neutral and not necessarily important.
      info: augmentColor({
        color: info,
        name: 'info'
      }),
      // The colors used to indicate the successful completion of an action that user triggered.
      success: augmentColor({
        color: success,
        name: 'success'
      }),
      // The grey colors.
      grey: grey$1,
      // Used by `getContrastText()` to maximize the contrast between
      // the background and the text.
      contrastThreshold,
      // Takes a background color and returns the text color that maximizes the contrast.
      getContrastText,
      // Generate a rich color object.
      augmentColor,
      // Used by the functions below to shift a color's luminance by approximately
      // two indexes within its tonal palette.
      // E.g., shift from Red 500 to Red 300 or Red 700.
      tonalOffset
    }, modes[mode]), other);
    return paletteOutput;
  }

  const _excluded$26 = ["fontFamily", "fontSize", "fontWeightLight", "fontWeightRegular", "fontWeightMedium", "fontWeightBold", "htmlFontSize", "allVariants", "pxToRem"];

  function round$1(value) {
    return Math.round(value * 1e5) / 1e5;
  }

  const caseAllCaps = {
    textTransform: 'uppercase'
  };
  const defaultFontFamily = '"Roboto", "Helvetica", "Arial", sans-serif';
  /**
   * @see @link{https://material.io/design/typography/the-type-system.html}
   * @see @link{https://material.io/design/typography/understanding-typography.html}
   */

  function createTypography(palette, typography) {
    const _ref = typeof typography === 'function' ? typography(palette) : typography,
          {
      fontFamily = defaultFontFamily,
      // The default font size of the Material Specification.
      fontSize = 14,
      // px
      fontWeightLight = 300,
      fontWeightRegular = 400,
      fontWeightMedium = 500,
      fontWeightBold = 700,
      // Tell MUI what's the font-size on the html element.
      // 16px is the default font-size used by browsers.
      htmlFontSize = 16,
      // Apply the CSS properties to all the variants.
      allVariants,
      pxToRem: pxToRem2
    } = _ref,
          other = _objectWithoutPropertiesLoose(_ref, _excluded$26);

    {
      if (typeof fontSize !== 'number') {
        console.error('MUI: `fontSize` is required to be a number.');
      }

      if (typeof htmlFontSize !== 'number') {
        console.error('MUI: `htmlFontSize` is required to be a number.');
      }
    }

    const coef = fontSize / 14;

    const pxToRem = pxToRem2 || (size => `${size / htmlFontSize * coef}rem`);

    const buildVariant = (fontWeight, size, lineHeight, letterSpacing, casing) => _extends({
      fontFamily,
      fontWeight,
      fontSize: pxToRem(size),
      // Unitless following https://meyerweb.com/eric/thoughts/2006/02/08/unitless-line-heights/
      lineHeight
    }, fontFamily === defaultFontFamily ? {
      letterSpacing: `${round$1(letterSpacing / size)}em`
    } : {}, casing, allVariants);

    const variants = {
      h1: buildVariant(fontWeightLight, 96, 1.167, -1.5),
      h2: buildVariant(fontWeightLight, 60, 1.2, -0.5),
      h3: buildVariant(fontWeightRegular, 48, 1.167, 0),
      h4: buildVariant(fontWeightRegular, 34, 1.235, 0.25),
      h5: buildVariant(fontWeightRegular, 24, 1.334, 0),
      h6: buildVariant(fontWeightMedium, 20, 1.6, 0.15),
      subtitle1: buildVariant(fontWeightRegular, 16, 1.75, 0.15),
      subtitle2: buildVariant(fontWeightMedium, 14, 1.57, 0.1),
      body1: buildVariant(fontWeightRegular, 16, 1.5, 0.15),
      body2: buildVariant(fontWeightRegular, 14, 1.43, 0.15),
      button: buildVariant(fontWeightMedium, 14, 1.75, 0.4, caseAllCaps),
      caption: buildVariant(fontWeightRegular, 12, 1.66, 0.4),
      overline: buildVariant(fontWeightRegular, 12, 2.66, 1, caseAllCaps)
    };
    return deepmerge(_extends({
      htmlFontSize,
      pxToRem,
      fontFamily,
      fontSize,
      fontWeightLight,
      fontWeightRegular,
      fontWeightMedium,
      fontWeightBold
    }, variants), other, {
      clone: false // No need to clone deep

    });
  }

  const shadowKeyUmbraOpacity = 0.2;
  const shadowKeyPenumbraOpacity = 0.14;
  const shadowAmbientShadowOpacity = 0.12;

  function createShadow(...px) {
    return [`${px[0]}px ${px[1]}px ${px[2]}px ${px[3]}px rgba(0,0,0,${shadowKeyUmbraOpacity})`, `${px[4]}px ${px[5]}px ${px[6]}px ${px[7]}px rgba(0,0,0,${shadowKeyPenumbraOpacity})`, `${px[8]}px ${px[9]}px ${px[10]}px ${px[11]}px rgba(0,0,0,${shadowAmbientShadowOpacity})`].join(',');
  } // Values from https://github.com/material-components/material-components-web/blob/be8747f94574669cb5e7add1a7c54fa41a89cec7/packages/mdc-elevation/_variables.scss


  const shadows = ['none', createShadow(0, 2, 1, -1, 0, 1, 1, 0, 0, 1, 3, 0), createShadow(0, 3, 1, -2, 0, 2, 2, 0, 0, 1, 5, 0), createShadow(0, 3, 3, -2, 0, 3, 4, 0, 0, 1, 8, 0), createShadow(0, 2, 4, -1, 0, 4, 5, 0, 0, 1, 10, 0), createShadow(0, 3, 5, -1, 0, 5, 8, 0, 0, 1, 14, 0), createShadow(0, 3, 5, -1, 0, 6, 10, 0, 0, 1, 18, 0), createShadow(0, 4, 5, -2, 0, 7, 10, 1, 0, 2, 16, 1), createShadow(0, 5, 5, -3, 0, 8, 10, 1, 0, 3, 14, 2), createShadow(0, 5, 6, -3, 0, 9, 12, 1, 0, 3, 16, 2), createShadow(0, 6, 6, -3, 0, 10, 14, 1, 0, 4, 18, 3), createShadow(0, 6, 7, -4, 0, 11, 15, 1, 0, 4, 20, 3), createShadow(0, 7, 8, -4, 0, 12, 17, 2, 0, 5, 22, 4), createShadow(0, 7, 8, -4, 0, 13, 19, 2, 0, 5, 24, 4), createShadow(0, 7, 9, -4, 0, 14, 21, 2, 0, 5, 26, 4), createShadow(0, 8, 9, -5, 0, 15, 22, 2, 0, 6, 28, 5), createShadow(0, 8, 10, -5, 0, 16, 24, 2, 0, 6, 30, 5), createShadow(0, 8, 11, -5, 0, 17, 26, 2, 0, 6, 32, 5), createShadow(0, 9, 11, -5, 0, 18, 28, 2, 0, 7, 34, 6), createShadow(0, 9, 12, -6, 0, 19, 29, 2, 0, 7, 36, 6), createShadow(0, 10, 13, -6, 0, 20, 31, 3, 0, 8, 38, 7), createShadow(0, 10, 13, -6, 0, 21, 33, 3, 0, 8, 40, 7), createShadow(0, 10, 14, -6, 0, 22, 35, 3, 0, 8, 42, 7), createShadow(0, 11, 14, -7, 0, 23, 36, 3, 0, 9, 44, 8), createShadow(0, 11, 15, -7, 0, 24, 38, 3, 0, 9, 46, 8)];
  var shadows$1 = shadows;

  const _excluded$25 = ["duration", "easing", "delay"];
  // Follow https://material.google.com/motion/duration-easing.html#duration-easing-natural-easing-curves
  // to learn the context in which each easing should be used.
  const easing = {
    // This is the most common easing curve.
    easeInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
    // Objects enter the screen at full velocity from off-screen and
    // slowly decelerate to a resting point.
    easeOut: 'cubic-bezier(0.0, 0, 0.2, 1)',
    // Objects leave the screen at full velocity. They do not decelerate when off-screen.
    easeIn: 'cubic-bezier(0.4, 0, 1, 1)',
    // The sharp curve is used by objects that may return to the screen at any time.
    sharp: 'cubic-bezier(0.4, 0, 0.6, 1)'
  }; // Follow https://material.io/guidelines/motion/duration-easing.html#duration-easing-common-durations
  // to learn when use what timing

  const duration = {
    shortest: 150,
    shorter: 200,
    short: 250,
    // most basic recommended timing
    standard: 300,
    // this is to be used in complex animations
    complex: 375,
    // recommended when something is entering screen
    enteringScreen: 225,
    // recommended when something is leaving screen
    leavingScreen: 195
  };

  function formatMs(milliseconds) {
    return `${Math.round(milliseconds)}ms`;
  }

  function getAutoHeightDuration(height) {
    if (!height) {
      return 0;
    }

    const constant = height / 36; // https://www.wolframalpha.com/input/?i=(4+%2B+15+*+(x+%2F+36+)+**+0.25+%2B+(x+%2F+36)+%2F+5)+*+10

    return Math.round((4 + 15 * constant ** 0.25 + constant / 5) * 10);
  }

  function createTransitions(inputTransitions) {
    const mergedEasing = _extends({}, easing, inputTransitions.easing);

    const mergedDuration = _extends({}, duration, inputTransitions.duration);

    const create = (props = ['all'], options = {}) => {
      const {
        duration: durationOption = mergedDuration.standard,
        easing: easingOption = mergedEasing.easeInOut,
        delay = 0
      } = options,
            other = _objectWithoutPropertiesLoose(options, _excluded$25);

      {
        const isString = value => typeof value === 'string'; // IE11 support, replace with Number.isNaN
        // eslint-disable-next-line no-restricted-globals


        const isNumber = value => !isNaN(parseFloat(value));

        if (!isString(props) && !Array.isArray(props)) {
          console.error('MUI: Argument "props" must be a string or Array.');
        }

        if (!isNumber(durationOption) && !isString(durationOption)) {
          console.error(`MUI: Argument "duration" must be a number or a string but found ${durationOption}.`);
        }

        if (!isString(easingOption)) {
          console.error('MUI: Argument "easing" must be a string.');
        }

        if (!isNumber(delay) && !isString(delay)) {
          console.error('MUI: Argument "delay" must be a number or a string.');
        }

        if (Object.keys(other).length !== 0) {
          console.error(`MUI: Unrecognized argument(s) [${Object.keys(other).join(',')}].`);
        }
      }

      return (Array.isArray(props) ? props : [props]).map(animatedProp => `${animatedProp} ${typeof durationOption === 'string' ? durationOption : formatMs(durationOption)} ${easingOption} ${typeof delay === 'string' ? delay : formatMs(delay)}`).join(',');
    };

    return _extends({
      getAutoHeightDuration,
      create
    }, inputTransitions, {
      easing: mergedEasing,
      duration: mergedDuration
    });
  }

  // We need to centralize the zIndex definitions as they work
  // like global values in the browser.
  const zIndex = {
    mobileStepper: 1000,
    fab: 1050,
    speedDial: 1050,
    appBar: 1100,
    drawer: 1200,
    modal: 1300,
    snackbar: 1400,
    tooltip: 1500
  };
  var zIndex$1 = zIndex;

  const _excluded$24 = ["breakpoints", "mixins", "spacing", "palette", "transitions", "typography", "shape"];

  function createTheme(options = {}, ...args) {
    const {
      mixins: mixinsInput = {},
      palette: paletteInput = {},
      transitions: transitionsInput = {},
      typography: typographyInput = {}
    } = options,
          other = _objectWithoutPropertiesLoose(options, _excluded$24);

    const palette = createPalette(paletteInput);
    const systemTheme = createTheme$1(options);
    let muiTheme = deepmerge(systemTheme, {
      mixins: createMixins(systemTheme.breakpoints, mixinsInput),
      palette,
      // Don't use [...shadows] until you've verified its transpiled code is not invoking the iterator protocol.
      shadows: shadows$1.slice(),
      typography: createTypography(palette, typographyInput),
      transitions: createTransitions(transitionsInput),
      zIndex: _extends({}, zIndex$1)
    });
    muiTheme = deepmerge(muiTheme, other);
    muiTheme = args.reduce((acc, argument) => deepmerge(acc, argument), muiTheme);

    {
      const stateClasses = ['active', 'checked', 'completed', 'disabled', 'error', 'expanded', 'focused', 'focusVisible', 'required', 'selected'];

      const traverse = (node, component) => {
        let key; // eslint-disable-next-line guard-for-in, no-restricted-syntax

        for (key in node) {
          const child = node[key];

          if (stateClasses.indexOf(key) !== -1 && Object.keys(child).length > 0) {
            {
              const stateClass = generateUtilityClass('', key);
              console.error([`MUI: The \`${component}\` component increases ` + `the CSS specificity of the \`${key}\` internal state.`, 'You can not override it like this: ', JSON.stringify(node, null, 2), '', `Instead, you need to use the '&.${stateClass}' syntax:`, JSON.stringify({
                root: {
                  [`&.${stateClass}`]: child
                }
              }, null, 2), '', 'https://mui.com/r/state-classes-guide'].join('\n'));
            } // Remove the style to prevent global conflicts.


            node[key] = {};
          }
        }
      };

      Object.keys(muiTheme.components).forEach(component => {
        const styleOverrides = muiTheme.components[component].styleOverrides;

        if (styleOverrides && component.indexOf('Mui') === 0) {
          traverse(styleOverrides, component);
        }
      });
    }

    return muiTheme;
  }

  let warnedOnce$1 = false;
  function createMuiTheme(...args) {
    {
      if (!warnedOnce$1) {
        warnedOnce$1 = true;
        console.error(['MUI: the createMuiTheme function was renamed to createTheme.', '', "You should use `import { createTheme } from '@mui/material/styles'`"].join('\n'));
      }
    }

    return createTheme(...args);
  }

  function createMuiStrictModeTheme(options, ...args) {
    return createTheme(deepmerge({
      unstable_strictMode: true
    }, options), ...args);
  }

  let warnedOnce = false; // To remove in v6

  function createStyles(styles) {
    if (!warnedOnce) {
      console.warn(['MUI: createStyles from @mui/material/styles is deprecated.', 'Please use @mui/styles/createStyles'].join('\n'));
      warnedOnce = true;
    }

    return styles;
  }

  function isUnitless(value) {
    return String(parseFloat(value)).length === String(value).length;
  } // Ported from Compass
  // https://github.com/Compass/compass/blob/master/core/stylesheets/compass/typography/_units.scss
  // Emulate the sass function "unit"

  function getUnit(input) {
    return String(input).match(/[\d.\-+]*\s*(.*)/)[1] || '';
  } // Emulate the sass function "unitless"

  function toUnitless(length) {
    return parseFloat(length);
  } // Convert any CSS <length> or <percentage> value to any another.
  // From https://github.com/KyleAMathews/convert-css-length

  function convertLength(baseFontSize) {
    return (length, toUnit) => {
      const fromUnit = getUnit(length); // Optimize for cases where `from` and `to` units are accidentally the same.

      if (fromUnit === toUnit) {
        return length;
      } // Convert input length to pixels.


      let pxLength = toUnitless(length);

      if (fromUnit !== 'px') {
        if (fromUnit === 'em') {
          pxLength = toUnitless(length) * toUnitless(baseFontSize);
        } else if (fromUnit === 'rem') {
          pxLength = toUnitless(length) * toUnitless(baseFontSize);
        }
      } // Convert length in pixels to the output unit


      let outputLength = pxLength;

      if (toUnit !== 'px') {
        if (toUnit === 'em') {
          outputLength = pxLength / toUnitless(baseFontSize);
        } else if (toUnit === 'rem') {
          outputLength = pxLength / toUnitless(baseFontSize);
        } else {
          return length;
        }
      }

      return parseFloat(outputLength.toFixed(5)) + toUnit;
    };
  }
  function alignProperty({
    size,
    grid
  }) {
    const sizeBelow = size - size % grid;
    const sizeAbove = sizeBelow + grid;
    return size - sizeBelow < sizeAbove - size ? sizeBelow : sizeAbove;
  } // fontGrid finds a minimal grid (in rem) for the fontSize values so that the
  // lineHeight falls under a x pixels grid, 4px in the case of Material Design,
  // without changing the relative line height

  function fontGrid({
    lineHeight,
    pixels,
    htmlFontSize
  }) {
    return pixels / (lineHeight * htmlFontSize);
  }
  /**
   * generate a responsive version of a given CSS property
   * @example
   * responsiveProperty({
   *   cssProperty: 'fontSize',
   *   min: 15,
   *   max: 20,
   *   unit: 'px',
   *   breakpoints: [300, 600],
   * })
   *
   * // this returns
   *
   * {
   *   fontSize: '15px',
   *   '@media (min-width:300px)': {
   *     fontSize: '17.5px',
   *   },
   *   '@media (min-width:600px)': {
   *     fontSize: '20px',
   *   },
   * }
   * @param {Object} params
   * @param {string} params.cssProperty - The CSS property to be made responsive
   * @param {number} params.min - The smallest value of the CSS property
   * @param {number} params.max - The largest value of the CSS property
   * @param {string} [params.unit] - The unit to be used for the CSS property
   * @param {Array.number} [params.breakpoints]  - An array of breakpoints
   * @param {number} [params.alignStep] - Round scaled value to fall under this grid
   * @returns {Object} responsive styles for {params.cssProperty}
   */

  function responsiveProperty({
    cssProperty,
    min,
    max,
    unit = 'rem',
    breakpoints = [600, 900, 1200],
    transform = null
  }) {
    const output = {
      [cssProperty]: `${min}${unit}`
    };
    const factor = (max - min) / breakpoints[breakpoints.length - 1];
    breakpoints.forEach(breakpoint => {
      let value = min + factor * breakpoint;

      if (transform !== null) {
        value = transform(value);
      }

      output[`@media (min-width:${breakpoint}px)`] = {
        [cssProperty]: `${Math.round(value * 10000) / 10000}${unit}`
      };
    });
    return output;
  }

  function responsiveFontSizes(themeInput, options = {}) {
    const {
      breakpoints = ['sm', 'md', 'lg'],
      disableAlign = false,
      factor = 2,
      variants = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline']
    } = options;

    const theme = _extends({}, themeInput);

    theme.typography = _extends({}, theme.typography);
    const typography = theme.typography; // Convert between CSS lengths e.g. em->px or px->rem
    // Set the baseFontSize for your project. Defaults to 16px (also the browser default).

    const convert = convertLength(typography.htmlFontSize);
    const breakpointValues = breakpoints.map(x => theme.breakpoints.values[x]);
    variants.forEach(variant => {
      const style = typography[variant];
      const remFontSize = parseFloat(convert(style.fontSize, 'rem'));

      if (remFontSize <= 1) {
        return;
      }

      const maxFontSize = remFontSize;
      const minFontSize = 1 + (maxFontSize - 1) / factor;
      let {
        lineHeight
      } = style;

      if (!isUnitless(lineHeight) && !disableAlign) {
        throw new Error(`MUI: Unsupported non-unitless line height with grid alignment.
Use unitless line heights instead.` );
      }

      if (!isUnitless(lineHeight)) {
        // make it unitless
        lineHeight = parseFloat(convert(lineHeight, 'rem')) / parseFloat(remFontSize);
      }

      let transform = null;

      if (!disableAlign) {
        transform = value => alignProperty({
          size: value,
          grid: fontGrid({
            pixels: 4,
            lineHeight,
            htmlFontSize: typography.htmlFontSize
          })
        });
      }

      typography[variant] = _extends({}, style, responsiveProperty({
        cssProperty: 'fontSize',
        min: minFontSize,
        max: maxFontSize,
        unit: 'rem',
        breakpoints: breakpointValues,
        transform
      }));
    });
    return theme;
  }

  const defaultTheme$2 = createTheme();
  var defaultTheme$3 = defaultTheme$2;

  function useTheme() {
    const theme = useTheme$1(defaultTheme$3);

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useDebugValue(theme);
    }

    return theme;
  }

  function useThemeProps({
    props,
    name
  }) {
    return useThemeProps$1({
      props,
      name,
      defaultTheme: defaultTheme$3
    });
  }

  const rootShouldForwardProp = prop => shouldForwardProp(prop) && prop !== 'classes';
  const slotShouldForwardProp = shouldForwardProp;
  const styled = createStyled({
    defaultTheme: defaultTheme$3,
    rootShouldForwardProp
  });
  var styled$1 = styled;

  function makeStyles() {
    throw new Error(`MUI: makeStyles is no longer exported from @mui/material/styles.
You have to import it from @mui/styles.
See https://mui.com/r/migration-v4/#mui-material-styles for more details.` );
  }

  function withStyles() {
    throw new Error(`MUI: withStyles is no longer exported from @mui/material/styles.
You have to import it from @mui/styles.
See https://mui.com/r/migration-v4/#mui-material-styles for more details.` );
  }

  function withTheme() {
    throw new Error(`MUI: withTheme is no longer exported from @mui/material/styles.
You have to import it from @mui/styles.
See https://mui.com/r/migration-v4/#mui-material-styles for more details.` );
  }

  function getPaperUtilityClass(slot) {
    return generateUtilityClass('MuiPaper', slot);
  }
  const paperClasses = generateUtilityClasses('MuiPaper', ['root', 'rounded', 'outlined', 'elevation', 'elevation0', 'elevation1', 'elevation2', 'elevation3', 'elevation4', 'elevation5', 'elevation6', 'elevation7', 'elevation8', 'elevation9', 'elevation10', 'elevation11', 'elevation12', 'elevation13', 'elevation14', 'elevation15', 'elevation16', 'elevation17', 'elevation18', 'elevation19', 'elevation20', 'elevation21', 'elevation22', 'elevation23', 'elevation24']);
  var paperClasses$1 = paperClasses;

  const _excluded$23 = ["className", "component", "elevation", "square", "variant"];
  const getOverlayAlpha = elevation => {
    let alphaValue;

    if (elevation < 1) {
      alphaValue = 5.11916 * elevation ** 2;
    } else {
      alphaValue = 4.5 * Math.log(elevation + 1) + 2;
    }

    return (alphaValue / 100).toFixed(2);
  };

  const useUtilityClasses$1L = ownerState => {
    const {
      square,
      elevation,
      variant,
      classes
    } = ownerState;
    const slots = {
      root: ['root', variant, !square && 'rounded', variant === 'elevation' && `elevation${elevation}`]
    };
    return composeClasses(slots, getPaperUtilityClass, classes);
  };

  const PaperRoot = styled$1('div', {
    name: 'MuiPaper',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.variant], !ownerState.square && styles.rounded, ownerState.variant === 'elevation' && styles[`elevation${ownerState.elevation}`]];
    }
  })(({
    theme,
    ownerState
  }) => {
    var _theme$vars$overlays;

    return _extends({
      backgroundColor: (theme.vars || theme).palette.background.paper,
      color: (theme.vars || theme).palette.text.primary,
      transition: theme.transitions.create('box-shadow')
    }, !ownerState.square && {
      borderRadius: theme.shape.borderRadius
    }, ownerState.variant === 'outlined' && {
      border: `1px solid ${(theme.vars || theme).palette.divider}`
    }, ownerState.variant === 'elevation' && _extends({
      boxShadow: (theme.vars || theme).shadows[ownerState.elevation]
    }, !theme.vars && theme.palette.mode === 'dark' && {
      backgroundImage: `linear-gradient(${alpha('#fff', getOverlayAlpha(ownerState.elevation))}, ${alpha('#fff', getOverlayAlpha(ownerState.elevation))})`
    }, theme.vars && {
      backgroundImage: (_theme$vars$overlays = theme.vars.overlays) == null ? void 0 : _theme$vars$overlays[ownerState.elevation]
    }));
  });
  const Paper = /*#__PURE__*/React__namespace.forwardRef(function Paper(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiPaper'
    });

    const {
      className,
      component = 'div',
      elevation = 1,
      square = false,
      variant = 'elevation'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$23);

    const ownerState = _extends({}, props, {
      component,
      elevation,
      square,
      variant
    });

    const classes = useUtilityClasses$1L(ownerState);

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      const theme = useTheme();

      if (theme.shadows[elevation] === undefined) {
        console.error([`MUI: The elevation provided <Paper elevation={${elevation}}> is not available in the theme.`, `Please make sure that \`theme.shadows[${elevation}]\` is defined.`].join('\n'));
      }
    }

    return /*#__PURE__*/jsxRuntime_1(PaperRoot, _extends({
      as: component,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other));
  });
  Paper.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * Shadow depth, corresponds to `dp` in the spec.
     * It accepts values between 0 and 24 inclusive.
     * @default 1
     */
    elevation: chainPropTypes(integerPropType, props => {
      const {
        elevation,
        variant
      } = props;

      if (elevation > 0 && variant === 'outlined') {
        return new Error(`MUI: Combining \`elevation={${elevation}}\` with \`variant="${variant}"\` has no effect. Either use \`elevation={0}\` or use a different \`variant\`.`);
      }

      return null;
    }),

    /**
     * If `true`, rounded corners are disabled.
     * @default false
     */
    square: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The variant to use.
     * @default 'elevation'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['elevation', 'outlined']), PropTypes.string])
  } ;
  var Paper$1 = Paper;

  const _excluded$22 = ["colorSchemes"],
        _excluded2$9 = ["palette"];
  const defaultDarkOverlays = [...Array(25)].map((_, index) => {
    if (index === 0) {
      return undefined;
    }

    const overlay = getOverlayAlpha(index);
    return `linear-gradient(rgba(255 255 255 / ${overlay}), rgba(255 255 255 / ${overlay}))`;
  });

  function assignNode(obj, keys) {
    keys.forEach(k => {
      if (!obj[k]) {
        obj[k] = {};
      }
    });
  }

  function setColor(obj, key, defaultValue) {
    obj[key] = obj[key] || defaultValue;
  }

  function extendTheme(options = {}, ...args) {
    var _colorSchemesInput$li, _colorSchemesInput$da, _colorSchemesInput$li2, _colorSchemesInput$li3, _colorSchemesInput$da2, _colorSchemesInput$da3;

    const {
      colorSchemes: colorSchemesInput = {}
    } = options,
          input = _objectWithoutPropertiesLoose(options, _excluded$22);

    const _createThemeWithoutVa = createTheme(_extends({}, input, colorSchemesInput.light && {
      palette: (_colorSchemesInput$li = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li.palette
    })),
          {
      palette: lightPalette
    } = _createThemeWithoutVa,
          muiTheme = _objectWithoutPropertiesLoose(_createThemeWithoutVa, _excluded2$9);

    const {
      palette: darkPalette
    } = createTheme({
      palette: _extends({
        mode: 'dark'
      }, (_colorSchemesInput$da = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da.palette)
    });

    let theme = _extends({}, muiTheme, {
      colorSchemes: _extends({}, colorSchemesInput, {
        light: _extends({}, colorSchemesInput.light, {
          palette: lightPalette,
          opacity: _extends({
            inputPlaceholder: 0.42,
            inputTouchBottomLine: 0.42,
            switchTrackDisabled: 0.12,
            switchTrack: 0.38
          }, (_colorSchemesInput$li2 = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li2.opacity),
          overlays: ((_colorSchemesInput$li3 = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li3.overlays) || []
        }),
        dark: _extends({}, colorSchemesInput.dark, {
          palette: darkPalette,
          opacity: _extends({
            inputPlaceholder: 0.5,
            inputTouchBottomLine: 0.7,
            switchTrackDisabled: 0.2,
            switchTrack: 0.3
          }, (_colorSchemesInput$da2 = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da2.opacity),
          overlays: ((_colorSchemesInput$da3 = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da3.overlays) || defaultDarkOverlays
        })
      })
    });

    Object.keys(theme.colorSchemes).forEach(key => {
      const palette = theme.colorSchemes[key].palette; // attach black & white channels to common node

      if (key === 'light') {
        setColor(palette.common, 'background', '#fff');
        setColor(palette.common, 'onBackground', '#000');
      } else {
        setColor(palette.common, 'background', '#000');
        setColor(palette.common, 'onBackground', '#fff');
      } // assign component variables


      assignNode(palette, ['AppBar', 'Avatar', 'Chip', 'FilledInput', 'LinearProgress', 'Skeleton', 'Slider', 'SnackbarContent', 'SpeedDialAction', 'StepConnector', 'StepContent', 'Switch', 'TableCell', 'Tooltip']);

      if (key === 'light') {
        setColor(palette.AppBar, 'defaultBg', 'var(--mui-palette-grey-100)');
        setColor(palette.Avatar, 'defaultBg', 'var(--mui-palette-grey-400)');
        setColor(palette.Chip, 'defaultBorder', 'var(--mui-palette-grey-400)');
        setColor(palette.Chip, 'defaultAvatarColor', 'var(--mui-palette-grey-700)');
        setColor(palette.Chip, 'defaultIconColor', 'var(--mui-palette-grey-700)');
        setColor(palette.FilledInput, 'bg', 'rgba(0, 0, 0, 0.06)');
        setColor(palette.FilledInput, 'hoverBg', 'rgba(0, 0, 0, 0.09)');
        setColor(palette.FilledInput, 'disabledBg', 'rgba(0, 0, 0, 0.12)');
        setColor(palette.LinearProgress, 'primaryBg', lighten(palette.primary.main, 0.62));
        setColor(palette.LinearProgress, 'secondaryBg', lighten(palette.secondary.main, 0.62));
        setColor(palette.LinearProgress, 'errorBg', lighten(palette.error.main, 0.62));
        setColor(palette.LinearProgress, 'infoBg', lighten(palette.info.main, 0.62));
        setColor(palette.LinearProgress, 'successBg', lighten(palette.success.main, 0.62));
        setColor(palette.LinearProgress, 'warningBg', lighten(palette.warning.main, 0.62));
        setColor(palette.Skeleton, 'bg', 'rgba(var(--mui-palette-text-primaryChannel) / 0.11)');
        setColor(palette.Slider, 'primaryTrack', lighten(palette.primary.main, 0.62));
        setColor(palette.Slider, 'secondaryTrack', lighten(palette.secondary.main, 0.62));
        setColor(palette.Slider, 'errorTrack', lighten(palette.error.main, 0.62));
        setColor(palette.Slider, 'infoTrack', lighten(palette.info.main, 0.62));
        setColor(palette.Slider, 'successTrack', lighten(palette.success.main, 0.62));
        setColor(palette.Slider, 'warningTrack', lighten(palette.warning.main, 0.62));
        setColor(palette.SnackbarContent, 'bg', emphasize(palette.background.default, 0.8));
        setColor(palette.SpeedDialAction, 'fabHoverBg', emphasize(palette.background.paper, 0.15));
        setColor(palette.StepConnector, 'border', 'var(--mui-palette-grey-400)');
        setColor(palette.StepContent, 'border', 'var(--mui-palette-grey-400)');
        setColor(palette.Switch, 'defaultColor', 'var(--mui-palette-common-white)');
        setColor(palette.Switch, 'defaultDisabledColor', 'var(--mui-palette-grey-100)');
        setColor(palette.Switch, 'primaryDisabledColor', lighten(palette.primary.main, 0.62));
        setColor(palette.Switch, 'secondaryDisabledColor', lighten(palette.secondary.main, 0.62));
        setColor(palette.Switch, 'errorDisabledColor', lighten(palette.error.main, 0.62));
        setColor(palette.Switch, 'infoDisabledColor', lighten(palette.info.main, 0.62));
        setColor(palette.Switch, 'successDisabledColor', lighten(palette.success.main, 0.62));
        setColor(palette.Switch, 'warningDisabledColor', lighten(palette.warning.main, 0.62));
        setColor(palette.TableCell, 'border', lighten(alpha(palette.divider, 1), 0.88));
        setColor(palette.Tooltip, 'bg', alpha(palette.grey[700], 0.92));
      } else {
        setColor(palette.AppBar, 'defaultBg', 'var(--mui-palette-grey-900)');
        setColor(palette.AppBar, 'darkBg', 'var(--mui-palette-background-paper)'); // specific for dark mode

        setColor(palette.AppBar, 'darkColor', 'var(--mui-palette-text-primary)'); // specific for dark mode

        setColor(palette.Avatar, 'defaultBg', 'var(--mui-palette-grey-600)');
        setColor(palette.Chip, 'defaultBorder', 'var(--mui-palette-grey-700)');
        setColor(palette.Chip, 'defaultAvatarColor', 'var(--mui-palette-grey-300)');
        setColor(palette.Chip, 'defaultIconColor', 'var(--mui-palette-grey-300)');
        setColor(palette.FilledInput, 'bg', 'rgba(255, 255, 255, 0.09)');
        setColor(palette.FilledInput, 'hoverBg', 'rgba(255, 255, 255, 0.13)');
        setColor(palette.FilledInput, 'disabledBg', 'rgba(255, 255, 255, 0.12)');
        setColor(palette.LinearProgress, 'primaryBg', darken(palette.primary.main, 0.5));
        setColor(palette.LinearProgress, 'secondaryBg', darken(palette.secondary.main, 0.5));
        setColor(palette.LinearProgress, 'errorBg', darken(palette.error.main, 0.5));
        setColor(palette.LinearProgress, 'infoBg', darken(palette.info.main, 0.5));
        setColor(palette.LinearProgress, 'successBg', darken(palette.success.main, 0.5));
        setColor(palette.LinearProgress, 'warningBg', darken(palette.warning.main, 0.5));
        setColor(palette.Skeleton, 'bg', 'rgba(var(--mui-palette-text-primaryChannel) / 0.13)');
        setColor(palette.Slider, 'primaryTrack', darken(palette.primary.main, 0.5));
        setColor(palette.Slider, 'secondaryTrack', darken(palette.secondary.main, 0.5));
        setColor(palette.Slider, 'errorTrack', darken(palette.error.main, 0.5));
        setColor(palette.Slider, 'infoTrack', darken(palette.info.main, 0.5));
        setColor(palette.Slider, 'successTrack', darken(palette.success.main, 0.5));
        setColor(palette.Slider, 'warningTrack', darken(palette.warning.main, 0.5));
        setColor(palette.SnackbarContent, 'bg', emphasize(palette.background.default, 0.98));
        setColor(palette.SpeedDialAction, 'fabHoverBg', emphasize(palette.background.paper, 0.15));
        setColor(palette.StepConnector, 'border', 'var(--mui-palette-grey-600)');
        setColor(palette.StepContent, 'border', 'var(--mui-palette-grey-600)');
        setColor(palette.Switch, 'defaultColor', 'var(--mui-palette-grey-300)');
        setColor(palette.Switch, 'defaultDisabledColor', 'var(--mui-palette-grey-600)');
        setColor(palette.Switch, 'primaryDisabledColor', darken(palette.primary.main, 0.55));
        setColor(palette.Switch, 'secondaryDisabledColor', darken(palette.secondary.main, 0.55));
        setColor(palette.Switch, 'errorDisabledColor', darken(palette.error.main, 0.55));
        setColor(palette.Switch, 'infoDisabledColor', darken(palette.info.main, 0.55));
        setColor(palette.Switch, 'successDisabledColor', darken(palette.success.main, 0.55));
        setColor(palette.Switch, 'warningDisabledColor', darken(palette.warning.main, 0.55));
        setColor(palette.TableCell, 'border', darken(alpha(palette.divider, 1), 0.68));
        setColor(palette.Tooltip, 'bg', alpha(palette.grey[700], 0.92));
      }

      palette.common.backgroundChannel = colorChannel(palette.common.background);
      palette.common.onBackgroundChannel = colorChannel(palette.common.onBackground);
      palette.dividerChannel = colorChannel(palette.divider);
      Object.keys(palette).forEach(color => {
        const colors = palette[color]; // Color palettes: primary, secondary, error, info, success, and warning

        if (colors.main) {
          palette[color].mainChannel = colorChannel(colors.main);
        }

        if (colors.light) {
          palette[color].lightChannel = colorChannel(colors.light);
        }

        if (colors.dark) {
          palette[color].darkChannel = colorChannel(colors.dark);
        }

        if (colors.contrastText) {
          palette[color].contrastTextChannel = colorChannel(colors.contrastText);
        } // Text colors: text.primary, text.secondary


        if (colors.primary) {
          palette[color].primaryChannel = colorChannel(colors.primary);
        }

        if (colors.secondary) {
          palette[color].secondaryChannel = colorChannel(colors.secondary);
        } // Action colors: action.active, action.selected


        if (colors.active) {
          palette[color].activeChannel = colorChannel(colors.active);
        }

        if (colors.selected) {
          palette[color].selectedChannel = colorChannel(colors.selected);
        }
      });
    });
    theme = args.reduce((acc, argument) => deepmerge(acc, argument), theme);
    return theme;
  }

  const defaultTheme$1 = extendTheme();
  const {
    CssVarsProvider: Experimental_CssVarsProvider,
    useColorScheme,
    getInitColorSchemeScript
  } = createCssVarsProvider({
    theme: defaultTheme$1,
    attribute: 'data-mui-color-scheme',
    modeStorageKey: 'mui-mode',
    colorSchemeStorageKey: 'mui-color-scheme',
    defaultColorScheme: {
      light: 'light',
      dark: 'dark'
    },
    prefix: 'mui',
    resolveTheme: theme => {
      const newTheme = _extends({}, theme, {
        typography: createTypography(theme.palette, theme.typography)
      });

      return newTheme;
    },
    shouldSkipGeneratingVar: keys => !!keys[0].match(/(typography|mixins|breakpoints|direction|transitions)/)
  });

  function getSvgIconUtilityClass(slot) {
    return generateUtilityClass('MuiSvgIcon', slot);
  }
  const svgIconClasses = generateUtilityClasses('MuiSvgIcon', ['root', 'colorPrimary', 'colorSecondary', 'colorAction', 'colorError', 'colorDisabled', 'fontSizeInherit', 'fontSizeSmall', 'fontSizeMedium', 'fontSizeLarge']);
  var svgIconClasses$1 = svgIconClasses;

  const _excluded$21 = ["children", "className", "color", "component", "fontSize", "htmlColor", "inheritViewBox", "titleAccess", "viewBox"];

  const useUtilityClasses$1K = ownerState => {
    const {
      color,
      fontSize,
      classes
    } = ownerState;
    const slots = {
      root: ['root', color !== 'inherit' && `color${capitalize(color)}`, `fontSize${capitalize(fontSize)}`]
    };
    return composeClasses(slots, getSvgIconUtilityClass, classes);
  };

  const SvgIconRoot = styled$1('svg', {
    name: 'MuiSvgIcon',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.color !== 'inherit' && styles[`color${capitalize(ownerState.color)}`], styles[`fontSize${capitalize(ownerState.fontSize)}`]];
    }
  })(({
    theme,
    ownerState
  }) => {
    var _theme$transitions, _theme$transitions$cr, _theme$transitions2, _theme$transitions2$d, _theme$typography, _theme$typography$pxT, _theme$typography2, _theme$typography2$px, _theme$typography3, _theme$typography3$px, _palette$ownerState$c, _palette, _palette$ownerState$c2, _palette2, _palette2$action, _palette3, _palette3$action;

    return {
      userSelect: 'none',
      width: '1em',
      height: '1em',
      display: 'inline-block',
      fill: 'currentColor',
      flexShrink: 0,
      transition: (_theme$transitions = theme.transitions) == null ? void 0 : (_theme$transitions$cr = _theme$transitions.create) == null ? void 0 : _theme$transitions$cr.call(_theme$transitions, 'fill', {
        duration: (_theme$transitions2 = theme.transitions) == null ? void 0 : (_theme$transitions2$d = _theme$transitions2.duration) == null ? void 0 : _theme$transitions2$d.shorter
      }),
      fontSize: {
        inherit: 'inherit',
        small: ((_theme$typography = theme.typography) == null ? void 0 : (_theme$typography$pxT = _theme$typography.pxToRem) == null ? void 0 : _theme$typography$pxT.call(_theme$typography, 20)) || '1.25rem',
        medium: ((_theme$typography2 = theme.typography) == null ? void 0 : (_theme$typography2$px = _theme$typography2.pxToRem) == null ? void 0 : _theme$typography2$px.call(_theme$typography2, 24)) || '1.5rem',
        large: ((_theme$typography3 = theme.typography) == null ? void 0 : (_theme$typography3$px = _theme$typography3.pxToRem) == null ? void 0 : _theme$typography3$px.call(_theme$typography3, 35)) || '2.1875'
      }[ownerState.fontSize],
      // TODO v5 deprecate, v6 remove for sx
      color: (_palette$ownerState$c = (_palette = (theme.vars || theme).palette) == null ? void 0 : (_palette$ownerState$c2 = _palette[ownerState.color]) == null ? void 0 : _palette$ownerState$c2.main) != null ? _palette$ownerState$c : {
        action: (_palette2 = (theme.vars || theme).palette) == null ? void 0 : (_palette2$action = _palette2.action) == null ? void 0 : _palette2$action.active,
        disabled: (_palette3 = (theme.vars || theme).palette) == null ? void 0 : (_palette3$action = _palette3.action) == null ? void 0 : _palette3$action.disabled,
        inherit: undefined
      }[ownerState.color]
    };
  });
  const SvgIcon = /*#__PURE__*/React__namespace.forwardRef(function SvgIcon(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiSvgIcon'
    });

    const {
      children,
      className,
      color = 'inherit',
      component = 'svg',
      fontSize = 'medium',
      htmlColor,
      inheritViewBox = false,
      titleAccess,
      viewBox = '0 0 24 24'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$21);

    const ownerState = _extends({}, props, {
      color,
      component,
      fontSize,
      instanceFontSize: inProps.fontSize,
      inheritViewBox,
      viewBox
    });

    const more = {};

    if (!inheritViewBox) {
      more.viewBox = viewBox;
    }

    const classes = useUtilityClasses$1K(ownerState);
    return /*#__PURE__*/jsxRuntime_2(SvgIconRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      ownerState: ownerState,
      focusable: "false",
      color: htmlColor,
      "aria-hidden": titleAccess ? undefined : true,
      role: titleAccess ? 'img' : undefined,
      ref: ref
    }, more, other, {
      children: [children, titleAccess ? /*#__PURE__*/jsxRuntime_1("title", {
        children: titleAccess
      }) : null]
    }));
  });
  SvgIcon.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Node passed into the SVG element.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * You can use the `htmlColor` prop to apply a color attribute to the SVG element.
     * @default 'inherit'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['inherit', 'action', 'disabled', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
     * @default 'medium'
     */
    fontSize: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['inherit', 'large', 'medium', 'small']), PropTypes.string]),

    /**
     * Applies a color attribute to the SVG element.
     */
    htmlColor: PropTypes.string,

    /**
     * If `true`, the root node will inherit the custom `component`'s viewBox and the `viewBox`
     * prop will be ignored.
     * Useful when you want to reference a custom `component` and have `SvgIcon` pass that
     * `component`'s viewBox to the root node.
     * @default false
     */
    inheritViewBox: PropTypes.bool,

    /**
     * The shape-rendering attribute. The behavior of the different options is described on the
     * [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/shape-rendering).
     * If you are having issues with blurry icons you should investigate this prop.
     */
    shapeRendering: PropTypes.string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * Provides a human-readable title for the element that contains it.
     * https://www.w3.org/TR/SVG-access/#Equivalent
     */
    titleAccess: PropTypes.string,

    /**
     * Allows you to redefine what the coordinates without units mean inside an SVG element.
     * For example, if the SVG element is 500 (width) by 200 (height),
     * and you pass viewBox="0 0 50 20",
     * this means that the coordinates inside the SVG will go from the top left corner (0,0)
     * to bottom right (50,20) and each unit will be worth 10px.
     * @default '0 0 24 24'
     */
    viewBox: PropTypes.string
  } ;
  SvgIcon.muiName = 'SvgIcon';
  var SvgIcon$1 = SvgIcon;

  function createSvgIcon(path, displayName) {
    const Component = (props, ref) => /*#__PURE__*/jsxRuntime_1(SvgIcon$1, _extends({
      "data-testid": `${displayName}Icon`,
      ref: ref
    }, props, {
      children: path
    }));

    {
      // Need to set `displayName` on the inner component for React.memo.
      // React prior to 16.14 ignores `displayName` on the wrapper.
      Component.displayName = `${displayName}Icon`;
    }

    Component.muiName = SvgIcon$1.muiName;
    return /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(Component));
  }

  // eslint-disable-next-line @typescript-eslint/naming-convention

  const unstable_ClassNameGenerator = {
    configure: generator => {
      console.warn(['MUI: `ClassNameGenerator` import from `@mui/material/utils` is outdated and might cause unexpected issues.', '', "You should use `import { unstable_ClassNameGenerator } from '@mui/material/className'` instead", '', 'The detail of the issue: https://github.com/mui/material-ui/issues/30011#issuecomment-1024993401', '', 'The updated documentation: https://mui.com/guides/classname-generator/'].join('\n'));
      ClassNameGenerator$1.configure(generator);
    }
  };

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf(subClass, superClass);
  }

  var config = {
    disabled: false
  };

  var timeoutsShape = PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
    enter: PropTypes.number,
    exit: PropTypes.number,
    appear: PropTypes.number
  }).isRequired]) ;
  PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
    enter: PropTypes.string,
    exit: PropTypes.string,
    active: PropTypes.string
  }), PropTypes.shape({
    enter: PropTypes.string,
    enterDone: PropTypes.string,
    enterActive: PropTypes.string,
    exit: PropTypes.string,
    exitDone: PropTypes.string,
    exitActive: PropTypes.string
  })]) ;

  var TransitionGroupContext = React__default["default"].createContext(null);

  var UNMOUNTED = 'unmounted';
  var EXITED = 'exited';
  var ENTERING = 'entering';
  var ENTERED = 'entered';
  var EXITING = 'exiting';
  /**
   * The Transition component lets you describe a transition from one component
   * state to another _over time_ with a simple declarative API. Most commonly
   * it's used to animate the mounting and unmounting of a component, but can also
   * be used to describe in-place transition states as well.
   *
   * ---
   *
   * **Note**: `Transition` is a platform-agnostic base component. If you're using
   * transitions in CSS, you'll probably want to use
   * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)
   * instead. It inherits all the features of `Transition`, but contains
   * additional features necessary to play nice with CSS transitions (hence the
   * name of the component).
   *
   * ---
   *
   * By default the `Transition` component does not alter the behavior of the
   * component it renders, it only tracks "enter" and "exit" states for the
   * components. It's up to you to give meaning and effect to those states. For
   * example we can add styles to a component when it enters or exits:
   *
   * ```jsx
   * import { Transition } from 'react-transition-group';
   *
   * const duration = 300;
   *
   * const defaultStyle = {
   *   transition: `opacity ${duration}ms ease-in-out`,
   *   opacity: 0,
   * }
   *
   * const transitionStyles = {
   *   entering: { opacity: 1 },
   *   entered:  { opacity: 1 },
   *   exiting:  { opacity: 0 },
   *   exited:  { opacity: 0 },
   * };
   *
   * const Fade = ({ in: inProp }) => (
   *   <Transition in={inProp} timeout={duration}>
   *     {state => (
   *       <div style={{
   *         ...defaultStyle,
   *         ...transitionStyles[state]
   *       }}>
   *         I'm a fade Transition!
   *       </div>
   *     )}
   *   </Transition>
   * );
   * ```
   *
   * There are 4 main states a Transition can be in:
   *  - `'entering'`
   *  - `'entered'`
   *  - `'exiting'`
   *  - `'exited'`
   *
   * Transition state is toggled via the `in` prop. When `true` the component
   * begins the "Enter" stage. During this stage, the component will shift from
   * its current transition state, to `'entering'` for the duration of the
   * transition and then to the `'entered'` stage once it's complete. Let's take
   * the following example (we'll use the
   * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):
   *
   * ```jsx
   * function App() {
   *   const [inProp, setInProp] = useState(false);
   *   return (
   *     <div>
   *       <Transition in={inProp} timeout={500}>
   *         {state => (
   *           // ...
   *         )}
   *       </Transition>
   *       <button onClick={() => setInProp(true)}>
   *         Click to Enter
   *       </button>
   *     </div>
   *   );
   * }
   * ```
   *
   * When the button is clicked the component will shift to the `'entering'` state
   * and stay there for 500ms (the value of `timeout`) before it finally switches
   * to `'entered'`.
   *
   * When `in` is `false` the same thing happens except the state moves from
   * `'exiting'` to `'exited'`.
   */

  var Transition = /*#__PURE__*/function (_React$Component) {
    _inheritsLoose(Transition, _React$Component);

    function Transition(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;
      var parentGroup = context; // In the context of a TransitionGroup all enters are really appears

      var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
      var initialStatus;
      _this.appearStatus = null;

      if (props.in) {
        if (appear) {
          initialStatus = EXITED;
          _this.appearStatus = ENTERING;
        } else {
          initialStatus = ENTERED;
        }
      } else {
        if (props.unmountOnExit || props.mountOnEnter) {
          initialStatus = UNMOUNTED;
        } else {
          initialStatus = EXITED;
        }
      }

      _this.state = {
        status: initialStatus
      };
      _this.nextCallback = null;
      return _this;
    }

    Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
      var nextIn = _ref.in;

      if (nextIn && prevState.status === UNMOUNTED) {
        return {
          status: EXITED
        };
      }

      return null;
    } // getSnapshotBeforeUpdate(prevProps) {
    //   let nextStatus = null
    //   if (prevProps !== this.props) {
    //     const { status } = this.state
    //     if (this.props.in) {
    //       if (status !== ENTERING && status !== ENTERED) {
    //         nextStatus = ENTERING
    //       }
    //     } else {
    //       if (status === ENTERING || status === ENTERED) {
    //         nextStatus = EXITING
    //       }
    //     }
    //   }
    //   return { nextStatus }
    // }
    ;

    var _proto = Transition.prototype;

    _proto.componentDidMount = function componentDidMount() {
      this.updateStatus(true, this.appearStatus);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      var nextStatus = null;

      if (prevProps !== this.props) {
        var status = this.state.status;

        if (this.props.in) {
          if (status !== ENTERING && status !== ENTERED) {
            nextStatus = ENTERING;
          }
        } else {
          if (status === ENTERING || status === ENTERED) {
            nextStatus = EXITING;
          }
        }
      }

      this.updateStatus(false, nextStatus);
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.cancelNextCallback();
    };

    _proto.getTimeouts = function getTimeouts() {
      var timeout = this.props.timeout;
      var exit, enter, appear;
      exit = enter = appear = timeout;

      if (timeout != null && typeof timeout !== 'number') {
        exit = timeout.exit;
        enter = timeout.enter; // TODO: remove fallback for next major

        appear = timeout.appear !== undefined ? timeout.appear : enter;
      }

      return {
        exit: exit,
        enter: enter,
        appear: appear
      };
    };

    _proto.updateStatus = function updateStatus(mounting, nextStatus) {
      if (mounting === void 0) {
        mounting = false;
      }

      if (nextStatus !== null) {
        // nextStatus will always be ENTERING or EXITING.
        this.cancelNextCallback();

        if (nextStatus === ENTERING) {
          this.performEnter(mounting);
        } else {
          this.performExit();
        }
      } else if (this.props.unmountOnExit && this.state.status === EXITED) {
        this.setState({
          status: UNMOUNTED
        });
      }
    };

    _proto.performEnter = function performEnter(mounting) {
      var _this2 = this;

      var enter = this.props.enter;
      var appearing = this.context ? this.context.isMounting : mounting;

      var _ref2 = this.props.nodeRef ? [appearing] : [ReactDOM__default["default"].findDOMNode(this), appearing],
          maybeNode = _ref2[0],
          maybeAppearing = _ref2[1];

      var timeouts = this.getTimeouts();
      var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED
      // if we are mounting and running this it means appear _must_ be set

      if (!mounting && !enter || config.disabled) {
        this.safeSetState({
          status: ENTERED
        }, function () {
          _this2.props.onEntered(maybeNode);
        });
        return;
      }

      this.props.onEnter(maybeNode, maybeAppearing);
      this.safeSetState({
        status: ENTERING
      }, function () {
        _this2.props.onEntering(maybeNode, maybeAppearing);

        _this2.onTransitionEnd(enterTimeout, function () {
          _this2.safeSetState({
            status: ENTERED
          }, function () {
            _this2.props.onEntered(maybeNode, maybeAppearing);
          });
        });
      });
    };

    _proto.performExit = function performExit() {
      var _this3 = this;

      var exit = this.props.exit;
      var timeouts = this.getTimeouts();
      var maybeNode = this.props.nodeRef ? undefined : ReactDOM__default["default"].findDOMNode(this); // no exit animation skip right to EXITED

      if (!exit || config.disabled) {
        this.safeSetState({
          status: EXITED
        }, function () {
          _this3.props.onExited(maybeNode);
        });
        return;
      }

      this.props.onExit(maybeNode);
      this.safeSetState({
        status: EXITING
      }, function () {
        _this3.props.onExiting(maybeNode);

        _this3.onTransitionEnd(timeouts.exit, function () {
          _this3.safeSetState({
            status: EXITED
          }, function () {
            _this3.props.onExited(maybeNode);
          });
        });
      });
    };

    _proto.cancelNextCallback = function cancelNextCallback() {
      if (this.nextCallback !== null) {
        this.nextCallback.cancel();
        this.nextCallback = null;
      }
    };

    _proto.safeSetState = function safeSetState(nextState, callback) {
      // This shouldn't be necessary, but there are weird race conditions with
      // setState callbacks and unmounting in testing, so always make sure that
      // we can cancel any pending setState callbacks after we unmount.
      callback = this.setNextCallback(callback);
      this.setState(nextState, callback);
    };

    _proto.setNextCallback = function setNextCallback(callback) {
      var _this4 = this;

      var active = true;

      this.nextCallback = function (event) {
        if (active) {
          active = false;
          _this4.nextCallback = null;
          callback(event);
        }
      };

      this.nextCallback.cancel = function () {
        active = false;
      };

      return this.nextCallback;
    };

    _proto.onTransitionEnd = function onTransitionEnd(timeout, handler) {
      this.setNextCallback(handler);
      var node = this.props.nodeRef ? this.props.nodeRef.current : ReactDOM__default["default"].findDOMNode(this);
      var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;

      if (!node || doesNotHaveTimeoutOrListener) {
        setTimeout(this.nextCallback, 0);
        return;
      }

      if (this.props.addEndListener) {
        var _ref3 = this.props.nodeRef ? [this.nextCallback] : [node, this.nextCallback],
            maybeNode = _ref3[0],
            maybeNextCallback = _ref3[1];

        this.props.addEndListener(maybeNode, maybeNextCallback);
      }

      if (timeout != null) {
        setTimeout(this.nextCallback, timeout);
      }
    };

    _proto.render = function render() {
      var status = this.state.status;

      if (status === UNMOUNTED) {
        return null;
      }

      var _this$props = this.props,
          children = _this$props.children;
          _this$props.in;
          _this$props.mountOnEnter;
          _this$props.unmountOnExit;
          _this$props.appear;
          _this$props.enter;
          _this$props.exit;
          _this$props.timeout;
          _this$props.addEndListener;
          _this$props.onEnter;
          _this$props.onEntering;
          _this$props.onEntered;
          _this$props.onExit;
          _this$props.onExiting;
          _this$props.onExited;
          _this$props.nodeRef;
          var childProps = _objectWithoutPropertiesLoose(_this$props, ["children", "in", "mountOnEnter", "unmountOnExit", "appear", "enter", "exit", "timeout", "addEndListener", "onEnter", "onEntering", "onEntered", "onExit", "onExiting", "onExited", "nodeRef"]);

      return (
        /*#__PURE__*/
        // allows for nested Transitions
        React__default["default"].createElement(TransitionGroupContext.Provider, {
          value: null
        }, typeof children === 'function' ? children(status, childProps) : React__default["default"].cloneElement(React__default["default"].Children.only(children), childProps))
      );
    };

    return Transition;
  }(React__default["default"].Component);

  Transition.contextType = TransitionGroupContext;
  Transition.propTypes = {
    /**
     * A React reference to DOM element that need to transition:
     * https://stackoverflow.com/a/51127130/4671932
     *
     *   - When `nodeRef` prop is used, `node` is not passed to callback functions
     *      (e.g. `onEnter`) because user already has direct access to the node.
     *   - When changing `key` prop of `Transition` in a `TransitionGroup` a new
     *     `nodeRef` need to be provided to `Transition` with changed `key` prop
     *     (see
     *     [test/CSSTransition-test.js](https://github.com/reactjs/react-transition-group/blob/13435f897b3ab71f6e19d724f145596f5910581c/test/CSSTransition-test.js#L362-L437)).
     */
    nodeRef: PropTypes.shape({
      current: typeof Element === 'undefined' ? PropTypes.any : function (propValue, key, componentName, location, propFullName, secret) {
        var value = propValue[key];
        return PropTypes.instanceOf(value && 'ownerDocument' in value ? value.ownerDocument.defaultView.Element : Element)(propValue, key, componentName, location, propFullName, secret);
      }
    }),

    /**
     * A `function` child can be used instead of a React element. This function is
     * called with the current transition status (`'entering'`, `'entered'`,
     * `'exiting'`, `'exited'`), which can be used to apply context
     * specific props to a component.
     *
     * ```jsx
     * <Transition in={this.state.in} timeout={150}>
     *   {state => (
     *     <MyComponent className={`fade fade-${state}`} />
     *   )}
     * </Transition>
     * ```
     */
    children: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.element.isRequired]).isRequired,

    /**
     * Show the component; triggers the enter or exit states
     */
    in: PropTypes.bool,

    /**
     * By default the child component is mounted immediately along with
     * the parent `Transition` component. If you want to "lazy mount" the component on the
     * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
     * mounted, even on "exited", unless you also specify `unmountOnExit`.
     */
    mountOnEnter: PropTypes.bool,

    /**
     * By default the child component stays mounted after it reaches the `'exited'` state.
     * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
     */
    unmountOnExit: PropTypes.bool,

    /**
     * By default the child component does not perform the enter transition when
     * it first mounts, regardless of the value of `in`. If you want this
     * behavior, set both `appear` and `in` to `true`.
     *
     * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop
     * > only adds an additional enter transition. However, in the
     * > `<CSSTransition>` component that first enter transition does result in
     * > additional `.appear-*` classes, that way you can choose to style it
     * > differently.
     */
    appear: PropTypes.bool,

    /**
     * Enable or disable enter transitions.
     */
    enter: PropTypes.bool,

    /**
     * Enable or disable exit transitions.
     */
    exit: PropTypes.bool,

    /**
     * The duration of the transition, in milliseconds.
     * Required unless `addEndListener` is provided.
     *
     * You may specify a single timeout for all transitions:
     *
     * ```jsx
     * timeout={500}
     * ```
     *
     * or individually:
     *
     * ```jsx
     * timeout={{
     *  appear: 500,
     *  enter: 300,
     *  exit: 500,
     * }}
     * ```
     *
     * - `appear` defaults to the value of `enter`
     * - `enter` defaults to `0`
     * - `exit` defaults to `0`
     *
     * @type {number | { enter?: number, exit?: number, appear?: number }}
     */
    timeout: function timeout(props) {
      var pt = timeoutsShape;
      if (!props.addEndListener) pt = pt.isRequired;

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return pt.apply(void 0, [props].concat(args));
    },

    /**
     * Add a custom transition end trigger. Called with the transitioning
     * DOM node and a `done` callback. Allows for more fine grained transition end
     * logic. Timeouts are still used as a fallback if provided.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * ```jsx
     * addEndListener={(node, done) => {
     *   // use the css transitionend event to mark the finish of a transition
     *   node.addEventListener('transitionend', done, false);
     * }}
     * ```
     */
    addEndListener: PropTypes.func,

    /**
     * Callback fired before the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEnter: PropTypes.func,

    /**
     * Callback fired after the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement, isAppearing: bool)
     */
    onEntering: PropTypes.func,

    /**
     * Callback fired after the "entered" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEntered: PropTypes.func,

    /**
     * Callback fired before the "exiting" status is applied.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExit: PropTypes.func,

    /**
     * Callback fired after the "exiting" status is applied.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExiting: PropTypes.func,

    /**
     * Callback fired after the "exited" status is applied.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExited: PropTypes.func
  } ; // Name the function so it is clearer in the documentation

  function noop() {}

  Transition.defaultProps = {
    in: false,
    mountOnEnter: false,
    unmountOnExit: false,
    appear: false,
    enter: true,
    exit: true,
    onEnter: noop,
    onEntering: noop,
    onEntered: noop,
    onExit: noop,
    onExiting: noop,
    onExited: noop
  };
  Transition.UNMOUNTED = UNMOUNTED;
  Transition.EXITED = EXITED;
  Transition.ENTERING = ENTERING;
  Transition.ENTERED = ENTERED;
  Transition.EXITING = EXITING;
  var Transition$1 = Transition;

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  /**
   * Given `this.props.children`, return an object mapping key to child.
   *
   * @param {*} children `this.props.children`
   * @return {object} Mapping of key to child
   */

  function getChildMapping(children, mapFn) {
    var mapper = function mapper(child) {
      return mapFn && React.isValidElement(child) ? mapFn(child) : child;
    };

    var result = Object.create(null);
    if (children) React.Children.map(children, function (c) {
      return c;
    }).forEach(function (child) {
      // run the map function here instead so that the key is the computed one
      result[child.key] = mapper(child);
    });
    return result;
  }
  /**
   * When you're adding or removing children some may be added or removed in the
   * same render pass. We want to show *both* since we want to simultaneously
   * animate elements in and out. This function takes a previous set of keys
   * and a new set of keys and merges them with its best guess of the correct
   * ordering. In the future we may expose some of the utilities in
   * ReactMultiChild to make this easy, but for now React itself does not
   * directly have this concept of the union of prevChildren and nextChildren
   * so we implement it here.
   *
   * @param {object} prev prev children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @param {object} next next children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @return {object} a key set that contains all keys in `prev` and all keys
   * in `next` in a reasonable order.
   */

  function mergeChildMappings(prev, next) {
    prev = prev || {};
    next = next || {};

    function getValueForKey(key) {
      return key in next ? next[key] : prev[key];
    } // For each key of `next`, the list of keys to insert before that key in
    // the combined list


    var nextKeysPending = Object.create(null);
    var pendingKeys = [];

    for (var prevKey in prev) {
      if (prevKey in next) {
        if (pendingKeys.length) {
          nextKeysPending[prevKey] = pendingKeys;
          pendingKeys = [];
        }
      } else {
        pendingKeys.push(prevKey);
      }
    }

    var i;
    var childMapping = {};

    for (var nextKey in next) {
      if (nextKeysPending[nextKey]) {
        for (i = 0; i < nextKeysPending[nextKey].length; i++) {
          var pendingNextKey = nextKeysPending[nextKey][i];
          childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
        }
      }

      childMapping[nextKey] = getValueForKey(nextKey);
    } // Finally, add the keys which didn't appear before any key in `next`


    for (i = 0; i < pendingKeys.length; i++) {
      childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
    }

    return childMapping;
  }

  function getProp(child, prop, props) {
    return props[prop] != null ? props[prop] : child.props[prop];
  }

  function getInitialChildMapping(props, onExited) {
    return getChildMapping(props.children, function (child) {
      return React.cloneElement(child, {
        onExited: onExited.bind(null, child),
        in: true,
        appear: getProp(child, 'appear', props),
        enter: getProp(child, 'enter', props),
        exit: getProp(child, 'exit', props)
      });
    });
  }
  function getNextChildMapping(nextProps, prevChildMapping, onExited) {
    var nextChildMapping = getChildMapping(nextProps.children);
    var children = mergeChildMappings(prevChildMapping, nextChildMapping);
    Object.keys(children).forEach(function (key) {
      var child = children[key];
      if (!React.isValidElement(child)) return;
      var hasPrev = (key in prevChildMapping);
      var hasNext = (key in nextChildMapping);
      var prevChild = prevChildMapping[key];
      var isLeaving = React.isValidElement(prevChild) && !prevChild.props.in; // item is new (entering)

      if (hasNext && (!hasPrev || isLeaving)) {
        // console.log('entering', key)
        children[key] = React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: true,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      } else if (!hasNext && hasPrev && !isLeaving) {
        // item is old (exiting)
        // console.log('leaving', key)
        children[key] = React.cloneElement(child, {
          in: false
        });
      } else if (hasNext && hasPrev && React.isValidElement(prevChild)) {
        // item hasn't changed transition states
        // copy over the last transition props;
        // console.log('unchanged', key)
        children[key] = React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: prevChild.props.in,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      }
    });
    return children;
  }

  var values = Object.values || function (obj) {
    return Object.keys(obj).map(function (k) {
      return obj[k];
    });
  };

  var defaultProps = {
    component: 'div',
    childFactory: function childFactory(child) {
      return child;
    }
  };
  /**
   * The `<TransitionGroup>` component manages a set of transition components
   * (`<Transition>` and `<CSSTransition>`) in a list. Like with the transition
   * components, `<TransitionGroup>` is a state machine for managing the mounting
   * and unmounting of components over time.
   *
   * Consider the example below. As items are removed or added to the TodoList the
   * `in` prop is toggled automatically by the `<TransitionGroup>`.
   *
   * Note that `<TransitionGroup>`  does not define any animation behavior!
   * Exactly _how_ a list item animates is up to the individual transition
   * component. This means you can mix and match animations across different list
   * items.
   */

  var TransitionGroup = /*#__PURE__*/function (_React$Component) {
    _inheritsLoose(TransitionGroup, _React$Component);

    function TransitionGroup(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;

      var handleExited = _this.handleExited.bind(_assertThisInitialized(_this)); // Initial children should all be entering, dependent on appear


      _this.state = {
        contextValue: {
          isMounting: true
        },
        handleExited: handleExited,
        firstRender: true
      };
      return _this;
    }

    var _proto = TransitionGroup.prototype;

    _proto.componentDidMount = function componentDidMount() {
      this.mounted = true;
      this.setState({
        contextValue: {
          isMounting: false
        }
      });
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.mounted = false;
    };

    TransitionGroup.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
      var prevChildMapping = _ref.children,
          handleExited = _ref.handleExited,
          firstRender = _ref.firstRender;
      return {
        children: firstRender ? getInitialChildMapping(nextProps, handleExited) : getNextChildMapping(nextProps, prevChildMapping, handleExited),
        firstRender: false
      };
    } // node is `undefined` when user provided `nodeRef` prop
    ;

    _proto.handleExited = function handleExited(child, node) {
      var currentChildMapping = getChildMapping(this.props.children);
      if (child.key in currentChildMapping) return;

      if (child.props.onExited) {
        child.props.onExited(node);
      }

      if (this.mounted) {
        this.setState(function (state) {
          var children = _extends({}, state.children);

          delete children[child.key];
          return {
            children: children
          };
        });
      }
    };

    _proto.render = function render() {
      var _this$props = this.props,
          Component = _this$props.component,
          childFactory = _this$props.childFactory,
          props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);

      var contextValue = this.state.contextValue;
      var children = values(this.state.children).map(childFactory);
      delete props.appear;
      delete props.enter;
      delete props.exit;

      if (Component === null) {
        return /*#__PURE__*/React__default["default"].createElement(TransitionGroupContext.Provider, {
          value: contextValue
        }, children);
      }

      return /*#__PURE__*/React__default["default"].createElement(TransitionGroupContext.Provider, {
        value: contextValue
      }, /*#__PURE__*/React__default["default"].createElement(Component, props, children));
    };

    return TransitionGroup;
  }(React__default["default"].Component);

  TransitionGroup.propTypes = {
    /**
     * `<TransitionGroup>` renders a `<div>` by default. You can change this
     * behavior by providing a `component` prop.
     * If you use React v16+ and would like to avoid a wrapping `<div>` element
     * you can pass in `component={null}`. This is useful if the wrapping div
     * borks your css styles.
     */
    component: PropTypes.any,

    /**
     * A set of `<Transition>` components, that are toggled `in` and out as they
     * leave. the `<TransitionGroup>` will inject specific transition props, so
     * remember to spread them through if you are wrapping the `<Transition>` as
     * with our `<Fade>` example.
     *
     * While this component is meant for multiple `Transition` or `CSSTransition`
     * children, sometimes you may want to have a single transition child with
     * content that you want to be transitioned out and in when you change it
     * (e.g. routes, images etc.) In that case you can change the `key` prop of
     * the transition child as you change its content, this will cause
     * `TransitionGroup` to transition the child out and back in.
     */
    children: PropTypes.node,

    /**
     * A convenience prop that enables or disables appear animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    appear: PropTypes.bool,

    /**
     * A convenience prop that enables or disables enter animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    enter: PropTypes.bool,

    /**
     * A convenience prop that enables or disables exit animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    exit: PropTypes.bool,

    /**
     * You may need to apply reactive updates to a child as it is exiting.
     * This is generally done by using `cloneElement` however in the case of an exiting
     * child the element has already been removed and not accessible to the consumer.
     *
     * If you do need to update a child as it leaves you can provide a `childFactory`
     * to wrap every child, even the ones that are leaving.
     *
     * @type Function(child: ReactElement) -> ReactElement
     */
    childFactory: PropTypes.func
  } ;
  TransitionGroup.defaultProps = defaultProps;
  var TransitionGroup$1 = TransitionGroup;

  const reflow = node => node.scrollTop;
  function getTransitionProps(props, options) {
    var _style$transitionDura, _style$transitionTimi;

    const {
      timeout,
      easing,
      style = {}
    } = props;
    return {
      duration: (_style$transitionDura = style.transitionDuration) != null ? _style$transitionDura : typeof timeout === 'number' ? timeout : timeout[options.mode] || 0,
      easing: (_style$transitionTimi = style.transitionTimingFunction) != null ? _style$transitionTimi : typeof easing === 'object' ? easing[options.mode] : easing,
      delay: style.transitionDelay
    };
  }

  function getCollapseUtilityClass(slot) {
    return generateUtilityClass('MuiCollapse', slot);
  }
  const collapseClasses = generateUtilityClasses('MuiCollapse', ['root', 'horizontal', 'vertical', 'entered', 'hidden', 'wrapper', 'wrapperInner']);
  var collapseClasses$1 = collapseClasses;

  const _excluded$20 = ["addEndListener", "children", "className", "collapsedSize", "component", "easing", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "orientation", "style", "timeout", "TransitionComponent"];

  const useUtilityClasses$1J = ownerState => {
    const {
      orientation,
      classes
    } = ownerState;
    const slots = {
      root: ['root', `${orientation}`],
      entered: ['entered'],
      hidden: ['hidden'],
      wrapper: ['wrapper', `${orientation}`],
      wrapperInner: ['wrapperInner', `${orientation}`]
    };
    return composeClasses(slots, getCollapseUtilityClass, classes);
  };

  const CollapseRoot = styled$1('div', {
    name: 'MuiCollapse',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.orientation], ownerState.state === 'entered' && styles.entered, ownerState.state === 'exited' && !ownerState.in && ownerState.collapsedSize === '0px' && styles.hidden];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    height: 0,
    overflow: 'hidden',
    transition: theme.transitions.create('height')
  }, ownerState.orientation === 'horizontal' && {
    height: 'auto',
    width: 0,
    transition: theme.transitions.create('width')
  }, ownerState.state === 'entered' && _extends({
    height: 'auto',
    overflow: 'visible'
  }, ownerState.orientation === 'horizontal' && {
    width: 'auto'
  }), ownerState.state === 'exited' && !ownerState.in && ownerState.collapsedSize === '0px' && {
    visibility: 'hidden'
  }));
  const CollapseWrapper = styled$1('div', {
    name: 'MuiCollapse',
    slot: 'Wrapper',
    overridesResolver: (props, styles) => styles.wrapper
  })(({
    ownerState
  }) => _extends({
    // Hack to get children with a negative margin to not falsify the height computation.
    display: 'flex',
    width: '100%'
  }, ownerState.orientation === 'horizontal' && {
    width: 'auto',
    height: '100%'
  }));
  const CollapseWrapperInner = styled$1('div', {
    name: 'MuiCollapse',
    slot: 'WrapperInner',
    overridesResolver: (props, styles) => styles.wrapperInner
  })(({
    ownerState
  }) => _extends({
    width: '100%'
  }, ownerState.orientation === 'horizontal' && {
    width: 'auto',
    height: '100%'
  }));
  /**
   * The Collapse transition is used by the
   * [Vertical Stepper](/material-ui/react-stepper/#vertical-stepper) StepContent component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  const Collapse = /*#__PURE__*/React__namespace.forwardRef(function Collapse(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCollapse'
    });

    const {
      addEndListener,
      children,
      className,
      collapsedSize: collapsedSizeProp = '0px',
      component,
      easing,
      in: inProp,
      onEnter,
      onEntered,
      onEntering,
      onExit,
      onExited,
      onExiting,
      orientation = 'vertical',
      style,
      timeout = duration.standard,
      // eslint-disable-next-line react/prop-types
      TransitionComponent = Transition$1
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$20);

    const ownerState = _extends({}, props, {
      orientation,
      collapsedSize: collapsedSizeProp
    });

    const classes = useUtilityClasses$1J(ownerState);
    const theme = useTheme();
    const timer = React__namespace.useRef();
    const wrapperRef = React__namespace.useRef(null);
    const autoTransitionDuration = React__namespace.useRef();
    const collapsedSize = typeof collapsedSizeProp === 'number' ? `${collapsedSizeProp}px` : collapsedSizeProp;
    const isHorizontal = orientation === 'horizontal';
    const size = isHorizontal ? 'width' : 'height';
    React__namespace.useEffect(() => {
      return () => {
        clearTimeout(timer.current);
      };
    }, []);
    const nodeRef = React__namespace.useRef(null);
    const handleRef = useForkRef(ref, nodeRef);

    const normalizedTransitionCallback = callback => maybeIsAppearing => {
      if (callback) {
        const node = nodeRef.current; // onEnterXxx and onExitXxx callbacks have a different arguments.length value.

        if (maybeIsAppearing === undefined) {
          callback(node);
        } else {
          callback(node, maybeIsAppearing);
        }
      }
    };

    const getWrapperSize = () => wrapperRef.current ? wrapperRef.current[isHorizontal ? 'clientWidth' : 'clientHeight'] : 0;

    const handleEnter = normalizedTransitionCallback((node, isAppearing) => {
      if (wrapperRef.current && isHorizontal) {
        // Set absolute position to get the size of collapsed content
        wrapperRef.current.style.position = 'absolute';
      }

      node.style[size] = collapsedSize;

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    });
    const handleEntering = normalizedTransitionCallback((node, isAppearing) => {
      const wrapperSize = getWrapperSize();

      if (wrapperRef.current && isHorizontal) {
        // After the size is read reset the position back to default
        wrapperRef.current.style.position = '';
      }

      const {
        duration: transitionDuration,
        easing: transitionTimingFunction
      } = getTransitionProps({
        style,
        timeout,
        easing
      }, {
        mode: 'enter'
      });

      if (timeout === 'auto') {
        const duration2 = theme.transitions.getAutoHeightDuration(wrapperSize);
        node.style.transitionDuration = `${duration2}ms`;
        autoTransitionDuration.current = duration2;
      } else {
        node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : `${transitionDuration}ms`;
      }

      node.style[size] = `${wrapperSize}px`;
      node.style.transitionTimingFunction = transitionTimingFunction;

      if (onEntering) {
        onEntering(node, isAppearing);
      }
    });
    const handleEntered = normalizedTransitionCallback((node, isAppearing) => {
      node.style[size] = 'auto';

      if (onEntered) {
        onEntered(node, isAppearing);
      }
    });
    const handleExit = normalizedTransitionCallback(node => {
      node.style[size] = `${getWrapperSize()}px`;

      if (onExit) {
        onExit(node);
      }
    });
    const handleExited = normalizedTransitionCallback(onExited);
    const handleExiting = normalizedTransitionCallback(node => {
      const wrapperSize = getWrapperSize();
      const {
        duration: transitionDuration,
        easing: transitionTimingFunction
      } = getTransitionProps({
        style,
        timeout,
        easing
      }, {
        mode: 'exit'
      });

      if (timeout === 'auto') {
        // TODO: rename getAutoHeightDuration to something more generic (width support)
        // Actually it just calculates animation duration based on size
        const duration2 = theme.transitions.getAutoHeightDuration(wrapperSize);
        node.style.transitionDuration = `${duration2}ms`;
        autoTransitionDuration.current = duration2;
      } else {
        node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : `${transitionDuration}ms`;
      }

      node.style[size] = collapsedSize;
      node.style.transitionTimingFunction = transitionTimingFunction;

      if (onExiting) {
        onExiting(node);
      }
    });

    const handleAddEndListener = next => {
      if (timeout === 'auto') {
        timer.current = setTimeout(next, autoTransitionDuration.current || 0);
      }

      if (addEndListener) {
        // Old call signature before `react-transition-group` implemented `nodeRef`
        addEndListener(nodeRef.current, next);
      }
    };

    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      in: inProp,
      onEnter: handleEnter,
      onEntered: handleEntered,
      onEntering: handleEntering,
      onExit: handleExit,
      onExited: handleExited,
      onExiting: handleExiting,
      addEndListener: handleAddEndListener,
      nodeRef: nodeRef,
      timeout: timeout === 'auto' ? null : timeout
    }, other, {
      children: (state, childProps) => /*#__PURE__*/jsxRuntime_1(CollapseRoot, _extends({
        as: component,
        className: clsx(classes.root, className, {
          'entered': classes.entered,
          'exited': !inProp && collapsedSize === '0px' && classes.hidden
        }[state]),
        style: _extends({
          [isHorizontal ? 'minWidth' : 'minHeight']: collapsedSize
        }, style),
        ownerState: _extends({}, ownerState, {
          state
        }),
        ref: handleRef
      }, childProps, {
        children: /*#__PURE__*/jsxRuntime_1(CollapseWrapper, {
          ownerState: _extends({}, ownerState, {
            state
          }),
          className: classes.wrapper,
          ref: wrapperRef,
          children: /*#__PURE__*/jsxRuntime_1(CollapseWrapperInner, {
            ownerState: _extends({}, ownerState, {
              state
            }),
            className: classes.wrapperInner,
            children: children
          })
        })
      }))
    }));
  });
  Collapse.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Add a custom transition end trigger. Called with the transitioning DOM
     * node and a done callback. Allows for more fine grained transition end
     * logic. Note: Timeouts are still used as a fallback if provided.
     */
    addEndListener: PropTypes.func,

    /**
     * The content node to be collapsed.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The width (horizontal) or height (vertical) of the container when collapsed.
     * @default '0px'
     */
    collapsedSize: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: elementTypeAcceptingRef$1,

    /**
     * The transition timing function.
     * You may specify a single easing or a object containing enter and exit values.
     */
    easing: PropTypes.oneOfType([PropTypes.shape({
      enter: PropTypes.string,
      exit: PropTypes.string
    }), PropTypes.string]),

    /**
     * If `true`, the component will transition in.
     */
    in: PropTypes.bool,

    /**
     * @ignore
     */
    onEnter: PropTypes.func,

    /**
     * @ignore
     */
    onEntered: PropTypes.func,

    /**
     * @ignore
     */
    onEntering: PropTypes.func,

    /**
     * @ignore
     */
    onExit: PropTypes.func,

    /**
     * @ignore
     */
    onExited: PropTypes.func,

    /**
     * @ignore
     */
    onExiting: PropTypes.func,

    /**
     * The transition orientation.
     * @default 'vertical'
     */
    orientation: PropTypes.oneOf(['horizontal', 'vertical']),

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     * @default duration.standard
     */
    timeout: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  Collapse.muiSupportAuto = true;
  var Collapse$1 = Collapse;

  /**
   * @ignore - internal component.
   * @type {React.Context<{} | {expanded: boolean, disabled: boolean, toggle: () => void}>}
   */

  const AccordionContext = /*#__PURE__*/React__namespace.createContext({});

  {
    AccordionContext.displayName = 'AccordionContext';
  }

  var AccordionContext$1 = AccordionContext;

  function getAccordionUtilityClass(slot) {
    return generateUtilityClass('MuiAccordion', slot);
  }
  const accordionClasses = generateUtilityClasses('MuiAccordion', ['root', 'rounded', 'expanded', 'disabled', 'gutters', 'region']);
  var accordionClasses$1 = accordionClasses;

  const _excluded$1$ = ["children", "className", "defaultExpanded", "disabled", "disableGutters", "expanded", "onChange", "square", "TransitionComponent", "TransitionProps"];

  const useUtilityClasses$1I = ownerState => {
    const {
      classes,
      square,
      expanded,
      disabled,
      disableGutters
    } = ownerState;
    const slots = {
      root: ['root', !square && 'rounded', expanded && 'expanded', disabled && 'disabled', !disableGutters && 'gutters'],
      region: ['region']
    };
    return composeClasses(slots, getAccordionUtilityClass, classes);
  };

  const AccordionRoot = styled$1(Paper$1, {
    name: 'MuiAccordion',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [{
        [`& .${accordionClasses$1.region}`]: styles.region
      }, styles.root, !ownerState.square && styles.rounded, !ownerState.disableGutters && styles.gutters];
    }
  })(({
    theme
  }) => {
    const transition = {
      duration: theme.transitions.duration.shortest
    };
    return {
      position: 'relative',
      transition: theme.transitions.create(['margin'], transition),
      overflowAnchor: 'none',
      // Keep the same scrolling position
      '&:before': {
        position: 'absolute',
        left: 0,
        top: -1,
        right: 0,
        height: 1,
        content: '""',
        opacity: 1,
        backgroundColor: (theme.vars || theme).palette.divider,
        transition: theme.transitions.create(['opacity', 'background-color'], transition)
      },
      '&:first-of-type': {
        '&:before': {
          display: 'none'
        }
      },
      [`&.${accordionClasses$1.expanded}`]: {
        '&:before': {
          opacity: 0
        },
        '&:first-of-type': {
          marginTop: 0
        },
        '&:last-of-type': {
          marginBottom: 0
        },
        '& + &': {
          '&:before': {
            display: 'none'
          }
        }
      },
      [`&.${accordionClasses$1.disabled}`]: {
        backgroundColor: (theme.vars || theme).palette.action.disabledBackground
      }
    };
  }, ({
    theme,
    ownerState
  }) => _extends({}, !ownerState.square && {
    borderRadius: 0,
    '&:first-of-type': {
      borderTopLeftRadius: (theme.vars || theme).shape.borderRadius,
      borderTopRightRadius: (theme.vars || theme).shape.borderRadius
    },
    '&:last-of-type': {
      borderBottomLeftRadius: (theme.vars || theme).shape.borderRadius,
      borderBottomRightRadius: (theme.vars || theme).shape.borderRadius,
      // Fix a rendering issue on Edge
      '@supports (-ms-ime-align: auto)': {
        borderBottomLeftRadius: 0,
        borderBottomRightRadius: 0
      }
    }
  }, !ownerState.disableGutters && {
    [`&.${accordionClasses$1.expanded}`]: {
      margin: '16px 0'
    }
  }));
  const Accordion = /*#__PURE__*/React__namespace.forwardRef(function Accordion(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAccordion'
    });

    const {
      children: childrenProp,
      className,
      defaultExpanded = false,
      disabled = false,
      disableGutters = false,
      expanded: expandedProp,
      onChange,
      square = false,
      TransitionComponent = Collapse$1,
      TransitionProps
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1$);

    const [expanded, setExpandedState] = useControlled({
      controlled: expandedProp,
      default: defaultExpanded,
      name: 'Accordion',
      state: 'expanded'
    });
    const handleChange = React__namespace.useCallback(event => {
      setExpandedState(!expanded);

      if (onChange) {
        onChange(event, !expanded);
      }
    }, [expanded, onChange, setExpandedState]);
    const [summary, ...children] = React__namespace.Children.toArray(childrenProp);
    const contextValue = React__namespace.useMemo(() => ({
      expanded,
      disabled,
      disableGutters,
      toggle: handleChange
    }), [expanded, disabled, disableGutters, handleChange]);

    const ownerState = _extends({}, props, {
      square,
      disabled,
      disableGutters,
      expanded
    });

    const classes = useUtilityClasses$1I(ownerState);
    return /*#__PURE__*/jsxRuntime_2(AccordionRoot, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState,
      square: square
    }, other, {
      children: [/*#__PURE__*/jsxRuntime_1(AccordionContext$1.Provider, {
        value: contextValue,
        children: summary
      }), /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
        in: expanded,
        timeout: "auto"
      }, TransitionProps, {
        children: /*#__PURE__*/jsxRuntime_1("div", {
          "aria-labelledby": summary.props.id,
          id: summary.props['aria-controls'],
          role: "region",
          className: classes.region,
          children: children
        })
      }))]
    }));
  });
  Accordion.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: chainPropTypes(PropTypes.node.isRequired, props => {
      const summary = React__namespace.Children.toArray(props.children)[0];

      if (reactIs_2(summary)) {
        return new Error("MUI: The Accordion doesn't accept a Fragment as a child. " + 'Consider providing an array instead.');
      }

      if (! /*#__PURE__*/React__namespace.isValidElement(summary)) {
        return new Error('MUI: Expected the first child of Accordion to be a valid element.');
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, expands the accordion by default.
     * @default false
     */
    defaultExpanded: PropTypes.bool,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, it removes the margin between two expanded accordion items and the increase of height.
     * @default false
     */
    disableGutters: PropTypes.bool,

    /**
     * If `true`, expands the accordion, otherwise collapse it.
     * Setting this prop enables control over the accordion.
     */
    expanded: PropTypes.bool,

    /**
     * Callback fired when the expand/collapse state is changed.
     *
     * @param {React.SyntheticEvent} event The event source of the callback. **Warning**: This is a generic event not a change event.
     * @param {boolean} expanded The `expanded` state of the accordion.
     */
    onChange: PropTypes.func,

    /**
     * If `true`, rounded corners are disabled.
     * @default false
     */
    square: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The component used for the transition.
     * [Follow this guide](/material-ui/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
     * @default Collapse
     */
    TransitionComponent: PropTypes.elementType,

    /**
     * Props applied to the transition element.
     * By default, the element is based on this [`Transition`](http://reactcommunity.org/react-transition-group/transition/) component.
     */
    TransitionProps: PropTypes.object
  } ;
  var Accordion$1 = Accordion;

  function getAccordionActionsUtilityClass(slot) {
    return generateUtilityClass('MuiAccordionActions', slot);
  }
  const accordionActionsClasses = generateUtilityClasses('MuiAccordionActions', ['root', 'spacing']);
  var accordionActionsClasses$1 = accordionActionsClasses;

  const _excluded$1_ = ["className", "disableSpacing"];

  const useUtilityClasses$1H = ownerState => {
    const {
      classes,
      disableSpacing
    } = ownerState;
    const slots = {
      root: ['root', !disableSpacing && 'spacing']
    };
    return composeClasses(slots, getAccordionActionsUtilityClass, classes);
  };

  const AccordionActionsRoot = styled$1('div', {
    name: 'MuiAccordionActions',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, !ownerState.disableSpacing && styles.spacing];
    }
  })(({
    ownerState
  }) => _extends({
    display: 'flex',
    alignItems: 'center',
    padding: 8,
    justifyContent: 'flex-end'
  }, !ownerState.disableSpacing && {
    '& > :not(:first-of-type)': {
      marginLeft: 8
    }
  }));
  const AccordionActions = /*#__PURE__*/React__namespace.forwardRef(function AccordionActions(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAccordionActions'
    });

    const {
      className,
      disableSpacing = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1_);

    const ownerState = _extends({}, props, {
      disableSpacing
    });

    const classes = useUtilityClasses$1H(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AccordionActionsRoot, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  AccordionActions.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, the actions do not have additional margin.
     * @default false
     */
    disableSpacing: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AccordionActions$1 = AccordionActions;

  function getAccordionDetailsUtilityClass(slot) {
    return generateUtilityClass('MuiAccordionDetails', slot);
  }
  const accordionDetailsClasses = generateUtilityClasses('MuiAccordionDetails', ['root']);
  var accordionDetailsClasses$1 = accordionDetailsClasses;

  const _excluded$1Z = ["className"];

  const useUtilityClasses$1G = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    return composeClasses(slots, getAccordionDetailsUtilityClass, classes);
  };

  const AccordionDetailsRoot = styled$1('div', {
    name: 'MuiAccordionDetails',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(({
    theme
  }) => ({
    padding: theme.spacing(1, 2, 2)
  }));
  const AccordionDetails = /*#__PURE__*/React__namespace.forwardRef(function AccordionDetails(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAccordionDetails'
    });

    const {
      className
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1Z);

    const ownerState = props;
    const classes = useUtilityClasses$1G(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AccordionDetailsRoot, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  AccordionDetails.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AccordionDetails$1 = AccordionDetails;

  function Ripple(props) {
    const {
      className,
      classes,
      pulsate = false,
      rippleX,
      rippleY,
      rippleSize,
      in: inProp,
      onExited,
      timeout
    } = props;
    const [leaving, setLeaving] = React__namespace.useState(false);
    const rippleClassName = clsx(className, classes.ripple, classes.rippleVisible, pulsate && classes.ripplePulsate);
    const rippleStyles = {
      width: rippleSize,
      height: rippleSize,
      top: -(rippleSize / 2) + rippleY,
      left: -(rippleSize / 2) + rippleX
    };
    const childClassName = clsx(classes.child, leaving && classes.childLeaving, pulsate && classes.childPulsate);

    if (!inProp && !leaving) {
      setLeaving(true);
    }

    React__namespace.useEffect(() => {
      if (!inProp && onExited != null) {
        // react-transition-group#onExited
        const timeoutId = setTimeout(onExited, timeout);
        return () => {
          clearTimeout(timeoutId);
        };
      }

      return undefined;
    }, [onExited, inProp, timeout]);
    return /*#__PURE__*/jsxRuntime_1("span", {
      className: rippleClassName,
      style: rippleStyles,
      children: /*#__PURE__*/jsxRuntime_1("span", {
        className: childClassName
      })
    });
  }

  Ripple.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: PropTypes.object.isRequired,
    className: PropTypes.string,

    /**
     * @ignore - injected from TransitionGroup
     */
    in: PropTypes.bool,

    /**
     * @ignore - injected from TransitionGroup
     */
    onExited: PropTypes.func,

    /**
     * If `true`, the ripple pulsates, typically indicating the keyboard focus state of an element.
     */
    pulsate: PropTypes.bool,

    /**
     * Diameter of the ripple.
     */
    rippleSize: PropTypes.number,

    /**
     * Horizontal position of the ripple center.
     */
    rippleX: PropTypes.number,

    /**
     * Vertical position of the ripple center.
     */
    rippleY: PropTypes.number,

    /**
     * exit delay
     */
    timeout: PropTypes.number.isRequired
  } ;

  function getTouchRippleUtilityClass(slot) {
    return generateUtilityClass('MuiTouchRipple', slot);
  }
  const touchRippleClasses = generateUtilityClasses('MuiTouchRipple', ['root', 'ripple', 'rippleVisible', 'ripplePulsate', 'child', 'childLeaving', 'childPulsate']);
  var touchRippleClasses$1 = touchRippleClasses;

  const _excluded$1Y = ["center", "classes", "className"];

  let _$3 = t => t,
      _t$3,
      _t2$3,
      _t3$3,
      _t4$3;
  const DURATION = 550;
  const DELAY_RIPPLE = 80;
  const enterKeyframe = keyframes(_t$3 || (_t$3 = _$3`
  0% {
    transform: scale(0);
    opacity: 0.1;
  }

  100% {
    transform: scale(1);
    opacity: 0.3;
  }
`));
  const exitKeyframe = keyframes(_t2$3 || (_t2$3 = _$3`
  0% {
    opacity: 1;
  }

  100% {
    opacity: 0;
  }
`));
  const pulsateKeyframe = keyframes(_t3$3 || (_t3$3 = _$3`
  0% {
    transform: scale(1);
  }

  50% {
    transform: scale(0.92);
  }

  100% {
    transform: scale(1);
  }
`));
  const TouchRippleRoot = styled$1('span', {
    name: 'MuiTouchRipple',
    slot: 'Root'
  })({
    overflow: 'hidden',
    pointerEvents: 'none',
    position: 'absolute',
    zIndex: 0,
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    borderRadius: 'inherit'
  }); // This `styled()` function invokes keyframes. `styled-components` only supports keyframes
  // in string templates. Do not convert these styles in JS object as it will break.

  const TouchRippleRipple = styled$1(Ripple, {
    name: 'MuiTouchRipple',
    slot: 'Ripple'
  })(_t4$3 || (_t4$3 = _$3`
  opacity: 0;
  position: absolute;

  &.${0} {
    opacity: 0.3;
    transform: scale(1);
    animation-name: ${0};
    animation-duration: ${0}ms;
    animation-timing-function: ${0};
  }

  &.${0} {
    animation-duration: ${0}ms;
  }

  & .${0} {
    opacity: 1;
    display: block;
    width: 100%;
    height: 100%;
    border-radius: 50%;
    background-color: currentColor;
  }

  & .${0} {
    opacity: 0;
    animation-name: ${0};
    animation-duration: ${0}ms;
    animation-timing-function: ${0};
  }

  & .${0} {
    position: absolute;
    /* @noflip */
    left: 0px;
    top: 0;
    animation-name: ${0};
    animation-duration: 2500ms;
    animation-timing-function: ${0};
    animation-iteration-count: infinite;
    animation-delay: 200ms;
  }
`), touchRippleClasses$1.rippleVisible, enterKeyframe, DURATION, ({
    theme
  }) => theme.transitions.easing.easeInOut, touchRippleClasses$1.ripplePulsate, ({
    theme
  }) => theme.transitions.duration.shorter, touchRippleClasses$1.child, touchRippleClasses$1.childLeaving, exitKeyframe, DURATION, ({
    theme
  }) => theme.transitions.easing.easeInOut, touchRippleClasses$1.childPulsate, pulsateKeyframe, ({
    theme
  }) => theme.transitions.easing.easeInOut);
  /**
   * @ignore - internal component.
   *
   * TODO v5: Make private
   */

  const TouchRipple = /*#__PURE__*/React__namespace.forwardRef(function TouchRipple(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiTouchRipple'
    });

    const {
      center: centerProp = false,
      classes = {},
      className
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1Y);

    const [ripples, setRipples] = React__namespace.useState([]);
    const nextKey = React__namespace.useRef(0);
    const rippleCallback = React__namespace.useRef(null);
    React__namespace.useEffect(() => {
      if (rippleCallback.current) {
        rippleCallback.current();
        rippleCallback.current = null;
      }
    }, [ripples]); // Used to filter out mouse emulated events on mobile.

    const ignoringMouseDown = React__namespace.useRef(false); // We use a timer in order to only show the ripples for touch "click" like events.
    // We don't want to display the ripple for touch scroll events.

    const startTimer = React__namespace.useRef(null); // This is the hook called once the previous timeout is ready.

    const startTimerCommit = React__namespace.useRef(null);
    const container = React__namespace.useRef(null);
    React__namespace.useEffect(() => {
      return () => {
        clearTimeout(startTimer.current);
      };
    }, []);
    const startCommit = React__namespace.useCallback(params => {
      const {
        pulsate,
        rippleX,
        rippleY,
        rippleSize,
        cb
      } = params;
      setRipples(oldRipples => [...oldRipples, /*#__PURE__*/jsxRuntime_1(TouchRippleRipple, {
        classes: {
          ripple: clsx(classes.ripple, touchRippleClasses$1.ripple),
          rippleVisible: clsx(classes.rippleVisible, touchRippleClasses$1.rippleVisible),
          ripplePulsate: clsx(classes.ripplePulsate, touchRippleClasses$1.ripplePulsate),
          child: clsx(classes.child, touchRippleClasses$1.child),
          childLeaving: clsx(classes.childLeaving, touchRippleClasses$1.childLeaving),
          childPulsate: clsx(classes.childPulsate, touchRippleClasses$1.childPulsate)
        },
        timeout: DURATION,
        pulsate: pulsate,
        rippleX: rippleX,
        rippleY: rippleY,
        rippleSize: rippleSize
      }, nextKey.current)]);
      nextKey.current += 1;
      rippleCallback.current = cb;
    }, [classes]);
    const start = React__namespace.useCallback((event = {}, options = {}, cb) => {
      const {
        pulsate = false,
        center = centerProp || options.pulsate,
        fakeElement = false // For test purposes

      } = options;

      if ((event == null ? void 0 : event.type) === 'mousedown' && ignoringMouseDown.current) {
        ignoringMouseDown.current = false;
        return;
      }

      if ((event == null ? void 0 : event.type) === 'touchstart') {
        ignoringMouseDown.current = true;
      }

      const element = fakeElement ? null : container.current;
      const rect = element ? element.getBoundingClientRect() : {
        width: 0,
        height: 0,
        left: 0,
        top: 0
      }; // Get the size of the ripple

      let rippleX;
      let rippleY;
      let rippleSize;

      if (center || event === undefined || event.clientX === 0 && event.clientY === 0 || !event.clientX && !event.touches) {
        rippleX = Math.round(rect.width / 2);
        rippleY = Math.round(rect.height / 2);
      } else {
        const {
          clientX,
          clientY
        } = event.touches ? event.touches[0] : event;
        rippleX = Math.round(clientX - rect.left);
        rippleY = Math.round(clientY - rect.top);
      }

      if (center) {
        rippleSize = Math.sqrt((2 * rect.width ** 2 + rect.height ** 2) / 3); // For some reason the animation is broken on Mobile Chrome if the size is even.

        if (rippleSize % 2 === 0) {
          rippleSize += 1;
        }
      } else {
        const sizeX = Math.max(Math.abs((element ? element.clientWidth : 0) - rippleX), rippleX) * 2 + 2;
        const sizeY = Math.max(Math.abs((element ? element.clientHeight : 0) - rippleY), rippleY) * 2 + 2;
        rippleSize = Math.sqrt(sizeX ** 2 + sizeY ** 2);
      } // Touche devices


      if (event != null && event.touches) {
        // check that this isn't another touchstart due to multitouch
        // otherwise we will only clear a single timer when unmounting while two
        // are running
        if (startTimerCommit.current === null) {
          // Prepare the ripple effect.
          startTimerCommit.current = () => {
            startCommit({
              pulsate,
              rippleX,
              rippleY,
              rippleSize,
              cb
            });
          }; // Delay the execution of the ripple effect.


          startTimer.current = setTimeout(() => {
            if (startTimerCommit.current) {
              startTimerCommit.current();
              startTimerCommit.current = null;
            }
          }, DELAY_RIPPLE); // We have to make a tradeoff with this value.
        }
      } else {
        startCommit({
          pulsate,
          rippleX,
          rippleY,
          rippleSize,
          cb
        });
      }
    }, [centerProp, startCommit]);
    const pulsate = React__namespace.useCallback(() => {
      start({}, {
        pulsate: true
      });
    }, [start]);
    const stop = React__namespace.useCallback((event, cb) => {
      clearTimeout(startTimer.current); // The touch interaction occurs too quickly.
      // We still want to show ripple effect.

      if ((event == null ? void 0 : event.type) === 'touchend' && startTimerCommit.current) {
        startTimerCommit.current();
        startTimerCommit.current = null;
        startTimer.current = setTimeout(() => {
          stop(event, cb);
        });
        return;
      }

      startTimerCommit.current = null;
      setRipples(oldRipples => {
        if (oldRipples.length > 0) {
          return oldRipples.slice(1);
        }

        return oldRipples;
      });
      rippleCallback.current = cb;
    }, []);
    React__namespace.useImperativeHandle(ref, () => ({
      pulsate,
      start,
      stop
    }), [pulsate, start, stop]);
    return /*#__PURE__*/jsxRuntime_1(TouchRippleRoot, _extends({
      className: clsx(classes.root, touchRippleClasses$1.root, className),
      ref: container
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(TransitionGroup$1, {
        component: null,
        exit: true,
        children: ripples
      })
    }));
  });
  TouchRipple.propTypes = {
    /**
     * If `true`, the ripple starts at the center of the component
     * rather than at the point of interaction.
     */
    center: PropTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string
  } ;
  var TouchRipple$1 = TouchRipple;

  function getButtonBaseUtilityClass(slot) {
    return generateUtilityClass('MuiButtonBase', slot);
  }
  const buttonBaseClasses = generateUtilityClasses('MuiButtonBase', ['root', 'disabled', 'focusVisible']);
  var buttonBaseClasses$1 = buttonBaseClasses;

  const _excluded$1X = ["action", "centerRipple", "children", "className", "component", "disabled", "disableRipple", "disableTouchRipple", "focusRipple", "focusVisibleClassName", "LinkComponent", "onBlur", "onClick", "onContextMenu", "onDragLeave", "onFocus", "onFocusVisible", "onKeyDown", "onKeyUp", "onMouseDown", "onMouseLeave", "onMouseUp", "onTouchEnd", "onTouchMove", "onTouchStart", "tabIndex", "TouchRippleProps", "touchRippleRef", "type"];

  const useUtilityClasses$1F = ownerState => {
    const {
      disabled,
      focusVisible,
      focusVisibleClassName,
      classes
    } = ownerState;
    const slots = {
      root: ['root', disabled && 'disabled', focusVisible && 'focusVisible']
    };
    const composedClasses = composeClasses(slots, getButtonBaseUtilityClass, classes);

    if (focusVisible && focusVisibleClassName) {
      composedClasses.root += ` ${focusVisibleClassName}`;
    }

    return composedClasses;
  };

  const ButtonBaseRoot = styled$1('button', {
    name: 'MuiButtonBase',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })({
    display: 'inline-flex',
    alignItems: 'center',
    justifyContent: 'center',
    position: 'relative',
    boxSizing: 'border-box',
    WebkitTapHighlightColor: 'transparent',
    backgroundColor: 'transparent',
    // Reset default value
    // We disable the focus ring for mouse, touch and keyboard users.
    outline: 0,
    border: 0,
    margin: 0,
    // Remove the margin in Safari
    borderRadius: 0,
    padding: 0,
    // Remove the padding in Firefox
    cursor: 'pointer',
    userSelect: 'none',
    verticalAlign: 'middle',
    MozAppearance: 'none',
    // Reset
    WebkitAppearance: 'none',
    // Reset
    textDecoration: 'none',
    // So we take precedent over the style of a native <a /> element.
    color: 'inherit',
    '&::-moz-focus-inner': {
      borderStyle: 'none' // Remove Firefox dotted outline.

    },
    [`&.${buttonBaseClasses$1.disabled}`]: {
      pointerEvents: 'none',
      // Disable link interactions
      cursor: 'default'
    },
    '@media print': {
      colorAdjust: 'exact'
    }
  });
  /**
   * `ButtonBase` contains as few styles as possible.
   * It aims to be a simple building block for creating a button.
   * It contains a load of style reset and some focus/ripple logic.
   */

  const ButtonBase = /*#__PURE__*/React__namespace.forwardRef(function ButtonBase(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiButtonBase'
    });

    const {
      action,
      centerRipple = false,
      children,
      className,
      component = 'button',
      disabled = false,
      disableRipple = false,
      disableTouchRipple = false,
      focusRipple = false,
      LinkComponent = 'a',
      onBlur,
      onClick,
      onContextMenu,
      onDragLeave,
      onFocus,
      onFocusVisible,
      onKeyDown,
      onKeyUp,
      onMouseDown,
      onMouseLeave,
      onMouseUp,
      onTouchEnd,
      onTouchMove,
      onTouchStart,
      tabIndex = 0,
      TouchRippleProps,
      touchRippleRef,
      type
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1X);

    const buttonRef = React__namespace.useRef(null);
    const rippleRef = React__namespace.useRef(null);
    const handleRippleRef = useForkRef(rippleRef, touchRippleRef);
    const {
      isFocusVisibleRef,
      onFocus: handleFocusVisible,
      onBlur: handleBlurVisible,
      ref: focusVisibleRef
    } = useIsFocusVisible();
    const [focusVisible, setFocusVisible] = React__namespace.useState(false);

    if (disabled && focusVisible) {
      setFocusVisible(false);
    }

    React__namespace.useImperativeHandle(action, () => ({
      focusVisible: () => {
        setFocusVisible(true);
        buttonRef.current.focus();
      }
    }), []);
    const [mountedState, setMountedState] = React__namespace.useState(false);
    React__namespace.useEffect(() => {
      setMountedState(true);
    }, []);
    const enableTouchRipple = mountedState && !disableRipple && !disabled;
    React__namespace.useEffect(() => {
      if (focusVisible && focusRipple && !disableRipple && mountedState) {
        rippleRef.current.pulsate();
      }
    }, [disableRipple, focusRipple, focusVisible, mountedState]);

    function useRippleHandler(rippleAction, eventCallback, skipRippleAction = disableTouchRipple) {
      return useEventCallback(event => {
        if (eventCallback) {
          eventCallback(event);
        }

        const ignore = skipRippleAction;

        if (!ignore && rippleRef.current) {
          rippleRef.current[rippleAction](event);
        }

        return true;
      });
    }

    const handleMouseDown = useRippleHandler('start', onMouseDown);
    const handleContextMenu = useRippleHandler('stop', onContextMenu);
    const handleDragLeave = useRippleHandler('stop', onDragLeave);
    const handleMouseUp = useRippleHandler('stop', onMouseUp);
    const handleMouseLeave = useRippleHandler('stop', event => {
      if (focusVisible) {
        event.preventDefault();
      }

      if (onMouseLeave) {
        onMouseLeave(event);
      }
    });
    const handleTouchStart = useRippleHandler('start', onTouchStart);
    const handleTouchEnd = useRippleHandler('stop', onTouchEnd);
    const handleTouchMove = useRippleHandler('stop', onTouchMove);
    const handleBlur = useRippleHandler('stop', event => {
      handleBlurVisible(event);

      if (isFocusVisibleRef.current === false) {
        setFocusVisible(false);
      }

      if (onBlur) {
        onBlur(event);
      }
    }, false);
    const handleFocus = useEventCallback(event => {
      // Fix for https://github.com/facebook/react/issues/7769
      if (!buttonRef.current) {
        buttonRef.current = event.currentTarget;
      }

      handleFocusVisible(event);

      if (isFocusVisibleRef.current === true) {
        setFocusVisible(true);

        if (onFocusVisible) {
          onFocusVisible(event);
        }
      }

      if (onFocus) {
        onFocus(event);
      }
    });

    const isNonNativeButton = () => {
      const button = buttonRef.current;
      return component && component !== 'button' && !(button.tagName === 'A' && button.href);
    };
    /**
     * IE11 shim for https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/repeat
     */


    const keydownRef = React__namespace.useRef(false);
    const handleKeyDown = useEventCallback(event => {
      // Check if key is already down to avoid repeats being counted as multiple activations
      if (focusRipple && !keydownRef.current && focusVisible && rippleRef.current && event.key === ' ') {
        keydownRef.current = true;
        rippleRef.current.stop(event, () => {
          rippleRef.current.start(event);
        });
      }

      if (event.target === event.currentTarget && isNonNativeButton() && event.key === ' ') {
        event.preventDefault();
      }

      if (onKeyDown) {
        onKeyDown(event);
      } // Keyboard accessibility for non interactive elements


      if (event.target === event.currentTarget && isNonNativeButton() && event.key === 'Enter' && !disabled) {
        event.preventDefault();

        if (onClick) {
          onClick(event);
        }
      }
    });
    const handleKeyUp = useEventCallback(event => {
      // calling preventDefault in keyUp on a <button> will not dispatch a click event if Space is pressed
      // https://codesandbox.io/s/button-keyup-preventdefault-dn7f0
      if (focusRipple && event.key === ' ' && rippleRef.current && focusVisible && !event.defaultPrevented) {
        keydownRef.current = false;
        rippleRef.current.stop(event, () => {
          rippleRef.current.pulsate(event);
        });
      }

      if (onKeyUp) {
        onKeyUp(event);
      } // Keyboard accessibility for non interactive elements


      if (onClick && event.target === event.currentTarget && isNonNativeButton() && event.key === ' ' && !event.defaultPrevented) {
        onClick(event);
      }
    });
    let ComponentProp = component;

    if (ComponentProp === 'button' && (other.href || other.to)) {
      ComponentProp = LinkComponent;
    }

    const buttonProps = {};

    if (ComponentProp === 'button') {
      buttonProps.type = type === undefined ? 'button' : type;
      buttonProps.disabled = disabled;
    } else {
      if (!other.href && !other.to) {
        buttonProps.role = 'button';
      }

      if (disabled) {
        buttonProps['aria-disabled'] = disabled;
      }
    }

    const handleOwnRef = useForkRef(focusVisibleRef, buttonRef);
    const handleRef = useForkRef(ref, handleOwnRef);

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useEffect(() => {
        if (enableTouchRipple && !rippleRef.current) {
          console.error(['MUI: The `component` prop provided to ButtonBase is invalid.', 'Please make sure the children prop is rendered in this custom component.'].join('\n'));
        }
      }, [enableTouchRipple]);
    }

    const ownerState = _extends({}, props, {
      centerRipple,
      component,
      disabled,
      disableRipple,
      disableTouchRipple,
      focusRipple,
      tabIndex,
      focusVisible
    });

    const classes = useUtilityClasses$1F(ownerState);
    return /*#__PURE__*/jsxRuntime_2(ButtonBaseRoot, _extends({
      as: ComponentProp,
      className: clsx(classes.root, className),
      ownerState: ownerState,
      onBlur: handleBlur,
      onClick: onClick,
      onContextMenu: handleContextMenu,
      onFocus: handleFocus,
      onKeyDown: handleKeyDown,
      onKeyUp: handleKeyUp,
      onMouseDown: handleMouseDown,
      onMouseLeave: handleMouseLeave,
      onMouseUp: handleMouseUp,
      onDragLeave: handleDragLeave,
      onTouchEnd: handleTouchEnd,
      onTouchMove: handleTouchMove,
      onTouchStart: handleTouchStart,
      ref: handleRef,
      tabIndex: disabled ? -1 : tabIndex,
      type: type
    }, buttonProps, other, {
      children: [children, enableTouchRipple ?
      /*#__PURE__*/

      /* TouchRipple is only needed client-side, x2 boost on the server. */
      jsxRuntime_1(TouchRipple$1, _extends({
        ref: handleRippleRef,
        center: centerRipple
      }, TouchRippleProps)) : null]
    }));
  });
  ButtonBase.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * A ref for imperative actions.
     * It currently only supports `focusVisible()` action.
     */
    action: refType$1,

    /**
     * If `true`, the ripples are centered.
     * They won't start at the cursor interaction position.
     * @default false
     */
    centerRipple: PropTypes.bool,

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: elementTypeAcceptingRef$1,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the ripple effect is disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `.Mui-focusVisible` class.
     * @default false
     */
    disableRipple: PropTypes.bool,

    /**
     * If `true`, the touch ripple effect is disabled.
     * @default false
     */
    disableTouchRipple: PropTypes.bool,

    /**
     * If `true`, the base button will have a keyboard focus ripple.
     * @default false
     */
    focusRipple: PropTypes.bool,

    /**
     * This prop can help identify which element has keyboard focus.
     * The class name will be applied when the element gains the focus through keyboard interaction.
     * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
     * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/HEAD/explainer.md).
     * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
     * if needed.
     */
    focusVisibleClassName: PropTypes.string,

    /**
     * @ignore
     */
    href: PropTypes
    /* @typescript-to-proptypes-ignore */
    .any,

    /**
     * The component used to render a link when the `href` prop is provided.
     * @default 'a'
     */
    LinkComponent: PropTypes.elementType,

    /**
     * @ignore
     */
    onBlur: PropTypes.func,

    /**
     * @ignore
     */
    onClick: PropTypes.func,

    /**
     * @ignore
     */
    onContextMenu: PropTypes.func,

    /**
     * @ignore
     */
    onDragLeave: PropTypes.func,

    /**
     * @ignore
     */
    onFocus: PropTypes.func,

    /**
     * Callback fired when the component is focused with a keyboard.
     * We trigger a `onFocus` callback too.
     */
    onFocusVisible: PropTypes.func,

    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,

    /**
     * @ignore
     */
    onKeyUp: PropTypes.func,

    /**
     * @ignore
     */
    onMouseDown: PropTypes.func,

    /**
     * @ignore
     */
    onMouseLeave: PropTypes.func,

    /**
     * @ignore
     */
    onMouseUp: PropTypes.func,

    /**
     * @ignore
     */
    onTouchEnd: PropTypes.func,

    /**
     * @ignore
     */
    onTouchMove: PropTypes.func,

    /**
     * @ignore
     */
    onTouchStart: PropTypes.func,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * @default 0
     */
    tabIndex: PropTypes.number,

    /**
     * Props applied to the `TouchRipple` element.
     */
    TouchRippleProps: PropTypes.object,

    /**
     * A ref that points to the `TouchRipple` element.
     */
    touchRippleRef: PropTypes.oneOfType([PropTypes.func, PropTypes.shape({
      current: PropTypes.shape({
        pulsate: PropTypes.func.isRequired,
        start: PropTypes.func.isRequired,
        stop: PropTypes.func.isRequired
      })
    })]),

    /**
     * @ignore
     */
    type: PropTypes.oneOfType([PropTypes.oneOf(['button', 'reset', 'submit']), PropTypes.string])
  } ;
  var ButtonBase$1 = ButtonBase;

  function getAccordionSummaryUtilityClass(slot) {
    return generateUtilityClass('MuiAccordionSummary', slot);
  }
  const accordionSummaryClasses = generateUtilityClasses('MuiAccordionSummary', ['root', 'expanded', 'focusVisible', 'disabled', 'gutters', 'contentGutters', 'content', 'expandIconWrapper']);
  var accordionSummaryClasses$1 = accordionSummaryClasses;

  const _excluded$1W = ["children", "className", "expandIcon", "focusVisibleClassName", "onClick"];

  const useUtilityClasses$1E = ownerState => {
    const {
      classes,
      expanded,
      disabled,
      disableGutters
    } = ownerState;
    const slots = {
      root: ['root', expanded && 'expanded', disabled && 'disabled', !disableGutters && 'gutters'],
      focusVisible: ['focusVisible'],
      content: ['content', expanded && 'expanded', !disableGutters && 'contentGutters'],
      expandIconWrapper: ['expandIconWrapper', expanded && 'expanded']
    };
    return composeClasses(slots, getAccordionSummaryUtilityClass, classes);
  };

  const AccordionSummaryRoot = styled$1(ButtonBase$1, {
    name: 'MuiAccordionSummary',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(({
    theme,
    ownerState
  }) => {
    const transition = {
      duration: theme.transitions.duration.shortest
    };
    return _extends({
      display: 'flex',
      minHeight: 48,
      padding: theme.spacing(0, 2),
      transition: theme.transitions.create(['min-height', 'background-color'], transition),
      [`&.${accordionSummaryClasses$1.focusVisible}`]: {
        backgroundColor: (theme.vars || theme).palette.action.focus
      },
      [`&.${accordionSummaryClasses$1.disabled}`]: {
        opacity: (theme.vars || theme).palette.action.disabledOpacity
      },
      [`&:hover:not(.${accordionSummaryClasses$1.disabled})`]: {
        cursor: 'pointer'
      }
    }, !ownerState.disableGutters && {
      [`&.${accordionSummaryClasses$1.expanded}`]: {
        minHeight: 64
      }
    });
  });
  const AccordionSummaryContent = styled$1('div', {
    name: 'MuiAccordionSummary',
    slot: 'Content',
    overridesResolver: (props, styles) => styles.content
  })(({
    theme,
    ownerState
  }) => _extends({
    display: 'flex',
    flexGrow: 1,
    margin: '12px 0'
  }, !ownerState.disableGutters && {
    transition: theme.transitions.create(['margin'], {
      duration: theme.transitions.duration.shortest
    }),
    [`&.${accordionSummaryClasses$1.expanded}`]: {
      margin: '20px 0'
    }
  }));
  const AccordionSummaryExpandIconWrapper = styled$1('div', {
    name: 'MuiAccordionSummary',
    slot: 'ExpandIconWrapper',
    overridesResolver: (props, styles) => styles.expandIconWrapper
  })(({
    theme
  }) => ({
    display: 'flex',
    color: (theme.vars || theme).palette.action.active,
    transform: 'rotate(0deg)',
    transition: theme.transitions.create('transform', {
      duration: theme.transitions.duration.shortest
    }),
    [`&.${accordionSummaryClasses$1.expanded}`]: {
      transform: 'rotate(180deg)'
    }
  }));
  const AccordionSummary = /*#__PURE__*/React__namespace.forwardRef(function AccordionSummary(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAccordionSummary'
    });

    const {
      children,
      className,
      expandIcon,
      focusVisibleClassName,
      onClick
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1W);

    const {
      disabled = false,
      disableGutters,
      expanded,
      toggle
    } = React__namespace.useContext(AccordionContext$1);

    const handleChange = event => {
      if (toggle) {
        toggle(event);
      }

      if (onClick) {
        onClick(event);
      }
    };

    const ownerState = _extends({}, props, {
      expanded,
      disabled,
      disableGutters
    });

    const classes = useUtilityClasses$1E(ownerState);
    return /*#__PURE__*/jsxRuntime_2(AccordionSummaryRoot, _extends({
      focusRipple: false,
      disableRipple: true,
      disabled: disabled,
      component: "div",
      "aria-expanded": expanded,
      className: clsx(classes.root, className),
      focusVisibleClassName: clsx(classes.focusVisible, focusVisibleClassName),
      onClick: handleChange,
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: [/*#__PURE__*/jsxRuntime_1(AccordionSummaryContent, {
        className: classes.content,
        ownerState: ownerState,
        children: children
      }), expandIcon && /*#__PURE__*/jsxRuntime_1(AccordionSummaryExpandIconWrapper, {
        className: classes.expandIconWrapper,
        ownerState: ownerState,
        children: expandIcon
      })]
    }));
  });
  AccordionSummary.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The icon to display as the expand indicator.
     */
    expandIcon: PropTypes.node,

    /**
     * This prop can help identify which element has keyboard focus.
     * The class name will be applied when the element gains the focus through keyboard interaction.
     * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
     * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/HEAD/explainer.md).
     * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
     * if needed.
     */
    focusVisibleClassName: PropTypes.string,

    /**
     * @ignore
     */
    onClick: PropTypes.func,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AccordionSummary$1 = AccordionSummary;

  function getAlertUtilityClass(slot) {
    return generateUtilityClass('MuiAlert', slot);
  }
  const alertClasses = generateUtilityClasses('MuiAlert', ['root', 'action', 'icon', 'message', 'filled', 'filledSuccess', 'filledInfo', 'filledWarning', 'filledError', 'outlined', 'outlinedSuccess', 'outlinedInfo', 'outlinedWarning', 'outlinedError', 'standard', 'standardSuccess', 'standardInfo', 'standardWarning', 'standardError']);
  var alertClasses$1 = alertClasses;

  function getIconButtonUtilityClass(slot) {
    return generateUtilityClass('MuiIconButton', slot);
  }
  const iconButtonClasses = generateUtilityClasses('MuiIconButton', ['root', 'disabled', 'colorInherit', 'colorPrimary', 'colorSecondary', 'edgeStart', 'edgeEnd', 'sizeSmall', 'sizeMedium', 'sizeLarge']);
  var iconButtonClasses$1 = iconButtonClasses;

  const _excluded$1V = ["edge", "children", "className", "color", "disabled", "disableFocusRipple", "size"];

  const useUtilityClasses$1D = ownerState => {
    const {
      classes,
      disabled,
      color,
      edge,
      size
    } = ownerState;
    const slots = {
      root: ['root', disabled && 'disabled', color !== 'default' && `color${capitalize(color)}`, edge && `edge${capitalize(edge)}`, `size${capitalize(size)}`]
    };
    return composeClasses(slots, getIconButtonUtilityClass, classes);
  };

  const IconButtonRoot = styled$1(ButtonBase$1, {
    name: 'MuiIconButton',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.color !== 'default' && styles[`color${capitalize(ownerState.color)}`], ownerState.edge && styles[`edge${capitalize(ownerState.edge)}`], styles[`size${capitalize(ownerState.size)}`]];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    textAlign: 'center',
    flex: '0 0 auto',
    fontSize: theme.typography.pxToRem(24),
    padding: 8,
    borderRadius: '50%',
    overflow: 'visible',
    // Explicitly set the default value to solve a bug on IE11.
    color: (theme.vars || theme).palette.action.active,
    transition: theme.transitions.create('background-color', {
      duration: theme.transitions.duration.shortest
    })
  }, !ownerState.disableRipple && {
    '&:hover': {
      backgroundColor: theme.vars ? `rgba(${theme.vars.palette.action.active} / ${theme.vars.palette.action.hoverOpacity})` : alpha(theme.palette.action.active, theme.palette.action.hoverOpacity),
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        backgroundColor: 'transparent'
      }
    }
  }, ownerState.edge === 'start' && {
    marginLeft: ownerState.size === 'small' ? -3 : -12
  }, ownerState.edge === 'end' && {
    marginRight: ownerState.size === 'small' ? -3 : -12
  }), ({
    theme,
    ownerState
  }) => _extends({}, ownerState.color === 'inherit' && {
    color: 'inherit'
  }, ownerState.color !== 'inherit' && ownerState.color !== 'default' && _extends({
    color: (theme.vars || theme).palette[ownerState.color].main
  }, !ownerState.disableRipple && {
    '&:hover': {
      backgroundColor: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / ${theme.vars.palette.action.hoverOpacity})` : alpha(theme.palette[ownerState.color].main, theme.palette.action.hoverOpacity),
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        backgroundColor: 'transparent'
      }
    }
  }), ownerState.size === 'small' && {
    padding: 5,
    fontSize: theme.typography.pxToRem(18)
  }, ownerState.size === 'large' && {
    padding: 12,
    fontSize: theme.typography.pxToRem(28)
  }, {
    [`&.${iconButtonClasses$1.disabled}`]: {
      backgroundColor: 'transparent',
      color: (theme.vars || theme).palette.action.disabled
    }
  }));
  /**
   * Refer to the [Icons](/material-ui/icons/) section of the documentation
   * regarding the available icon options.
   */

  const IconButton = /*#__PURE__*/React__namespace.forwardRef(function IconButton(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiIconButton'
    });

    const {
      edge = false,
      children,
      className,
      color = 'default',
      disabled = false,
      disableFocusRipple = false,
      size = 'medium'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1V);

    const ownerState = _extends({}, props, {
      edge,
      color,
      disabled,
      disableFocusRipple,
      size
    });

    const classes = useUtilityClasses$1D(ownerState);
    return /*#__PURE__*/jsxRuntime_1(IconButtonRoot, _extends({
      className: clsx(classes.root, className),
      centerRipple: true,
      focusRipple: !disableFocusRipple,
      disabled: disabled,
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: children
    }));
  });
  IconButton.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The icon to display.
     */
    children: chainPropTypes(PropTypes.node, props => {
      const found = React__namespace.Children.toArray(props.children).some(child => /*#__PURE__*/React__namespace.isValidElement(child) && child.props.onClick);

      if (found) {
        return new Error(['MUI: You are providing an onClick event listener to a child of a button element.', 'Prefer applying it to the IconButton directly.', 'This guarantees that the whole <button> will be responsive to click events.'].join('\n'));
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'default'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['inherit', 'default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple is disabled.
     * @default false
     */
    disableFocusRipple: PropTypes.bool,

    /**
     * If `true`, the ripple effect is disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `.Mui-focusVisible` class.
     * @default false
     */
    disableRipple: PropTypes.bool,

    /**
     * If given, uses a negative margin to counteract the padding on one
     * side (this is often helpful for aligning the left or right
     * side of the icon with content above or below, without ruining the border
     * size and shape).
     * @default false
     */
    edge: PropTypes.oneOf(['end', 'start', false]),

    /**
     * The size of the component.
     * `small` is equivalent to the dense button styling.
     * @default 'medium'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['small', 'medium', 'large']), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var IconButton$1 = IconButton;

  var SuccessOutlinedIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M20,12A8,8 0 0,1 12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4C12.76,4 13.5,4.11 14.2, 4.31L15.77,2.74C14.61,2.26 13.34,2 12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0, 0 22,12M7.91,10.08L6.5,11.5L11,16L21,6L19.59,4.58L11,13.17L7.91,10.08Z"
  }), 'SuccessOutlined');

  var ReportProblemOutlinedIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M12 5.99L19.53 19H4.47L12 5.99M12 2L1 21h22L12 2zm1 14h-2v2h2v-2zm0-6h-2v4h2v-4z"
  }), 'ReportProblemOutlined');

  var ErrorOutlineIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"
  }), 'ErrorOutline');

  var InfoOutlinedIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M11,9H13V7H11M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20, 12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10, 10 0 0,0 12,2M11,17H13V11H11V17Z"
  }), 'InfoOutlined');

  var ClearIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"
  }), 'Close');

  var _CloseIcon;

  const _excluded$1U = ["action", "children", "className", "closeText", "color", "icon", "iconMapping", "onClose", "role", "severity", "variant"];

  const useUtilityClasses$1C = ownerState => {
    const {
      variant,
      color,
      severity,
      classes
    } = ownerState;
    const slots = {
      root: ['root', `${variant}${capitalize(color || severity)}`, `${variant}`],
      icon: ['icon'],
      message: ['message'],
      action: ['action']
    };
    return composeClasses(slots, getAlertUtilityClass, classes);
  };

  const AlertRoot = styled$1(Paper$1, {
    name: 'MuiAlert',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.variant], styles[`${ownerState.variant}${capitalize(ownerState.color || ownerState.severity)}`]];
    }
  })(({
    theme,
    ownerState
  }) => {
    const getColor = theme.palette.mode === 'light' ? darken : lighten;
    const getBackgroundColor = theme.palette.mode === 'light' ? lighten : darken;
    const color = ownerState.color || ownerState.severity;
    return _extends({}, theme.typography.body2, {
      backgroundColor: 'transparent',
      display: 'flex',
      padding: '6px 16px'
    }, color && ownerState.variant === 'standard' && {
      color: getColor(theme.palette[color].light, 0.6),
      backgroundColor: getBackgroundColor(theme.palette[color].light, 0.9),
      [`& .${alertClasses$1.icon}`]: {
        color: theme.palette.mode === 'dark' ? theme.palette[color].main : theme.palette[color].light
      }
    }, color && ownerState.variant === 'outlined' && {
      color: getColor(theme.palette[color].light, 0.6),
      border: `1px solid ${theme.palette[color].light}`,
      [`& .${alertClasses$1.icon}`]: {
        color: theme.palette.mode === 'dark' ? theme.palette[color].main : theme.palette[color].light
      }
    }, color && ownerState.variant === 'filled' && {
      color: '#fff',
      fontWeight: theme.typography.fontWeightMedium,
      backgroundColor: theme.palette.mode === 'dark' ? theme.palette[color].dark : theme.palette[color].main
    });
  });
  const AlertIcon = styled$1('div', {
    name: 'MuiAlert',
    slot: 'Icon',
    overridesResolver: (props, styles) => styles.icon
  })({
    marginRight: 12,
    padding: '7px 0',
    display: 'flex',
    fontSize: 22,
    opacity: 0.9
  });
  const AlertMessage = styled$1('div', {
    name: 'MuiAlert',
    slot: 'Message',
    overridesResolver: (props, styles) => styles.message
  })({
    padding: '8px 0',
    minWidth: 0,
    overflow: 'auto'
  });
  const AlertAction = styled$1('div', {
    name: 'MuiAlert',
    slot: 'Action',
    overridesResolver: (props, styles) => styles.action
  })({
    display: 'flex',
    alignItems: 'flex-start',
    padding: '4px 0 0 16px',
    marginLeft: 'auto',
    marginRight: -8
  });
  const defaultIconMapping = {
    success: /*#__PURE__*/jsxRuntime_1(SuccessOutlinedIcon, {
      fontSize: "inherit"
    }),
    warning: /*#__PURE__*/jsxRuntime_1(ReportProblemOutlinedIcon, {
      fontSize: "inherit"
    }),
    error: /*#__PURE__*/jsxRuntime_1(ErrorOutlineIcon, {
      fontSize: "inherit"
    }),
    info: /*#__PURE__*/jsxRuntime_1(InfoOutlinedIcon, {
      fontSize: "inherit"
    })
  };
  const Alert = /*#__PURE__*/React__namespace.forwardRef(function Alert(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAlert'
    });

    const {
      action,
      children,
      className,
      closeText = 'Close',
      color,
      icon,
      iconMapping = defaultIconMapping,
      onClose,
      role = 'alert',
      severity = 'success',
      variant = 'standard'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1U);

    const ownerState = _extends({}, props, {
      color,
      severity,
      variant
    });

    const classes = useUtilityClasses$1C(ownerState);
    return /*#__PURE__*/jsxRuntime_2(AlertRoot, _extends({
      role: role,
      elevation: 0,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other, {
      children: [icon !== false ? /*#__PURE__*/jsxRuntime_1(AlertIcon, {
        ownerState: ownerState,
        className: classes.icon,
        children: icon || iconMapping[severity] || defaultIconMapping[severity]
      }) : null, /*#__PURE__*/jsxRuntime_1(AlertMessage, {
        ownerState: ownerState,
        className: classes.message,
        children: children
      }), action != null ? /*#__PURE__*/jsxRuntime_1(AlertAction, {
        ownerState: ownerState,
        className: classes.action,
        children: action
      }) : null, action == null && onClose ? /*#__PURE__*/jsxRuntime_1(AlertAction, {
        ownerState: ownerState,
        className: classes.action,
        children: /*#__PURE__*/jsxRuntime_1(IconButton$1, {
          size: "small",
          "aria-label": closeText,
          title: closeText,
          color: "inherit",
          onClick: onClose,
          children: _CloseIcon || (_CloseIcon = /*#__PURE__*/jsxRuntime_1(ClearIcon, {
            fontSize: "small"
          }))
        })
      }) : null]
    }));
  });
  Alert.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The action to display. It renders after the message, at the end of the alert.
     */
    action: PropTypes.node,

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * Override the default label for the *close popup* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Close'
     */
    closeText: PropTypes.string,

    /**
     * The color of the component. Unless provided, the value is taken from the `severity` prop.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * Override the icon displayed before the children.
     * Unless provided, the icon is mapped to the value of the `severity` prop.
     * Set to `false` to remove the `icon`.
     */
    icon: PropTypes.node,

    /**
     * The component maps the `severity` prop to a range of different icons,
     * for instance success to `<SuccessOutlined>`.
     * If you wish to change this mapping, you can provide your own.
     * Alternatively, you can use the `icon` prop to override the icon displayed.
     */
    iconMapping: PropTypes.shape({
      error: PropTypes.node,
      info: PropTypes.node,
      success: PropTypes.node,
      warning: PropTypes.node
    }),

    /**
     * Callback fired when the component requests to be closed.
     * When provided and no `action` prop is set, a close icon button is displayed that triggers the callback when clicked.
     * @param {React.SyntheticEvent} event The event source of the callback.
     */
    onClose: PropTypes.func,

    /**
     * The ARIA role attribute of the element.
     * @default 'alert'
     */
    role: PropTypes.string,

    /**
     * The severity of the alert. This defines the color and icon used.
     * @default 'success'
     */
    severity: PropTypes.oneOf(['error', 'info', 'success', 'warning']),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The variant to use.
     * @default 'standard'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['filled', 'outlined', 'standard']), PropTypes.string])
  } ;
  var Alert$1 = Alert;

  function getTypographyUtilityClass(slot) {
    return generateUtilityClass('MuiTypography', slot);
  }
  const typographyClasses = generateUtilityClasses('MuiTypography', ['root', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'inherit', 'button', 'caption', 'overline', 'alignLeft', 'alignRight', 'alignCenter', 'alignJustify', 'noWrap', 'gutterBottom', 'paragraph']);
  var typographyClasses$1 = typographyClasses;

  const _excluded$1T = ["align", "className", "component", "gutterBottom", "noWrap", "paragraph", "variant", "variantMapping"];

  const useUtilityClasses$1B = ownerState => {
    const {
      align,
      gutterBottom,
      noWrap,
      paragraph,
      variant,
      classes
    } = ownerState;
    const slots = {
      root: ['root', variant, ownerState.align !== 'inherit' && `align${capitalize(align)}`, gutterBottom && 'gutterBottom', noWrap && 'noWrap', paragraph && 'paragraph']
    };
    return composeClasses(slots, getTypographyUtilityClass, classes);
  };

  const TypographyRoot = styled$1('span', {
    name: 'MuiTypography',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.variant && styles[ownerState.variant], ownerState.align !== 'inherit' && styles[`align${capitalize(ownerState.align)}`], ownerState.noWrap && styles.noWrap, ownerState.gutterBottom && styles.gutterBottom, ownerState.paragraph && styles.paragraph];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    margin: 0
  }, ownerState.variant && theme.typography[ownerState.variant], ownerState.align !== 'inherit' && {
    textAlign: ownerState.align
  }, ownerState.noWrap && {
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap'
  }, ownerState.gutterBottom && {
    marginBottom: '0.35em'
  }, ownerState.paragraph && {
    marginBottom: 16
  }));
  const defaultVariantMapping = {
    h1: 'h1',
    h2: 'h2',
    h3: 'h3',
    h4: 'h4',
    h5: 'h5',
    h6: 'h6',
    subtitle1: 'h6',
    subtitle2: 'h6',
    body1: 'p',
    body2: 'p',
    inherit: 'p'
  }; // TODO v6: deprecate these color values in v5.x and remove the transformation in v6

  const colorTransformations$1 = {
    primary: 'primary.main',
    textPrimary: 'text.primary',
    secondary: 'secondary.main',
    textSecondary: 'text.secondary',
    error: 'error.main'
  };

  const transformDeprecatedColors$1 = color => {
    return colorTransformations$1[color] || color;
  };

  const Typography = /*#__PURE__*/React__namespace.forwardRef(function Typography(inProps, ref) {
    const themeProps = useThemeProps({
      props: inProps,
      name: 'MuiTypography'
    });
    const color = transformDeprecatedColors$1(themeProps.color);
    const props = extendSxProp(_extends({}, themeProps, {
      color
    }));

    const {
      align = 'inherit',
      className,
      component,
      gutterBottom = false,
      noWrap = false,
      paragraph = false,
      variant = 'body1',
      variantMapping = defaultVariantMapping
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1T);

    const ownerState = _extends({}, props, {
      align,
      color,
      className,
      component,
      gutterBottom,
      noWrap,
      paragraph,
      variant,
      variantMapping
    });

    const Component = component || (paragraph ? 'p' : variantMapping[variant] || defaultVariantMapping[variant]) || 'span';
    const classes = useUtilityClasses$1B(ownerState);
    return /*#__PURE__*/jsxRuntime_1(TypographyRoot, _extends({
      as: Component,
      ref: ref,
      ownerState: ownerState,
      className: clsx(classes.root, className)
    }, other));
  });
  Typography.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Set the text-align on the component.
     * @default 'inherit'
     */
    align: PropTypes.oneOf(['center', 'inherit', 'justify', 'left', 'right']),

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the text will have a bottom margin.
     * @default false
     */
    gutterBottom: PropTypes.bool,

    /**
     * If `true`, the text will not wrap, but instead will truncate with a text overflow ellipsis.
     *
     * Note that text overflow can only happen with block or inline-block level elements
     * (the element needs to have a width in order to overflow).
     * @default false
     */
    noWrap: PropTypes.bool,

    /**
     * If `true`, the element will be a paragraph element.
     * @default false
     */
    paragraph: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * Applies the theme typography styles.
     * @default 'body1'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['body1', 'body2', 'button', 'caption', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'inherit', 'overline', 'subtitle1', 'subtitle2']), PropTypes.string]),

    /**
     * The component maps the variant prop to a range of different HTML element types.
     * For instance, subtitle1 to `<h6>`.
     * If you wish to change that mapping, you can provide your own.
     * Alternatively, you can use the `component` prop.
     * @default {
     *   h1: 'h1',
     *   h2: 'h2',
     *   h3: 'h3',
     *   h4: 'h4',
     *   h5: 'h5',
     *   h6: 'h6',
     *   subtitle1: 'h6',
     *   subtitle2: 'h6',
     *   body1: 'p',
     *   body2: 'p',
     *   inherit: 'p',
     * }
     */
    variantMapping: PropTypes
    /* @typescript-to-proptypes-ignore */
    .object
  } ;
  var Typography$1 = Typography;

  function getAlertTitleUtilityClass(slot) {
    return generateUtilityClass('MuiAlertTitle', slot);
  }
  const alertTitleClasses = generateUtilityClasses('MuiAlertTitle', ['root']);
  var alertTitleClasses$1 = alertTitleClasses;

  const _excluded$1S = ["className"];

  const useUtilityClasses$1A = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    return composeClasses(slots, getAlertTitleUtilityClass, classes);
  };

  const AlertTitleRoot = styled$1(Typography$1, {
    name: 'MuiAlertTitle',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(({
    theme
  }) => {
    return {
      fontWeight: theme.typography.fontWeightMedium,
      marginTop: -2
    };
  });
  const AlertTitle = /*#__PURE__*/React__namespace.forwardRef(function AlertTitle(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAlertTitle'
    });

    const {
      className
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1S);

    const ownerState = props;
    const classes = useUtilityClasses$1A(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AlertTitleRoot, _extends({
      gutterBottom: true,
      component: "div",
      ownerState: ownerState,
      ref: ref,
      className: clsx(classes.root, className)
    }, other));
  });
  AlertTitle.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AlertTitle$1 = AlertTitle;

  function getAppBarUtilityClass(slot) {
    return generateUtilityClass('MuiAppBar', slot);
  }
  const appBarClasses = generateUtilityClasses('MuiAppBar', ['root', 'positionFixed', 'positionAbsolute', 'positionSticky', 'positionStatic', 'positionRelative', 'colorDefault', 'colorPrimary', 'colorSecondary', 'colorInherit', 'colorTransparent']);
  var appBarClasses$1 = appBarClasses;

  const _excluded$1R = ["className", "color", "enableColorOnDark", "position"];

  const useUtilityClasses$1z = ownerState => {
    const {
      color,
      position,
      classes
    } = ownerState;
    const slots = {
      root: ['root', `color${capitalize(color)}`, `position${capitalize(position)}`]
    };
    return composeClasses(slots, getAppBarUtilityClass, classes);
  }; // var2 is the fallback.
  // Ex. var1: 'var(--a)', var2: 'var(--b)'; return: 'var(--a, var(--b))'


  const joinVars = (var1, var2) => `${var1 == null ? void 0 : var1.replace(')', '')}, ${var2})`;

  const AppBarRoot = styled$1(Paper$1, {
    name: 'MuiAppBar',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[`position${capitalize(ownerState.position)}`], styles[`color${capitalize(ownerState.color)}`]];
    }
  })(({
    theme,
    ownerState
  }) => {
    const backgroundColorDefault = theme.palette.mode === 'light' ? theme.palette.grey[100] : theme.palette.grey[900];
    return _extends({
      display: 'flex',
      flexDirection: 'column',
      width: '100%',
      boxSizing: 'border-box',
      // Prevent padding issue with the Modal and fixed positioned AppBar.
      flexShrink: 0
    }, ownerState.position === 'fixed' && {
      position: 'fixed',
      zIndex: (theme.vars || theme).zIndex.appBar,
      top: 0,
      left: 'auto',
      right: 0,
      '@media print': {
        // Prevent the app bar to be visible on each printed page.
        position: 'absolute'
      }
    }, ownerState.position === 'absolute' && {
      position: 'absolute',
      zIndex: (theme.vars || theme).zIndex.appBar,
      top: 0,
      left: 'auto',
      right: 0
    }, ownerState.position === 'sticky' && {
      // ⚠️ sticky is not supported by IE11.
      position: 'sticky',
      zIndex: (theme.vars || theme).zIndex.appBar,
      top: 0,
      left: 'auto',
      right: 0
    }, ownerState.position === 'static' && {
      position: 'static'
    }, ownerState.position === 'relative' && {
      position: 'relative'
    }, !theme.vars && _extends({}, ownerState.color === 'default' && {
      backgroundColor: backgroundColorDefault,
      color: theme.palette.getContrastText(backgroundColorDefault)
    }, ownerState.color && ownerState.color !== 'default' && ownerState.color !== 'inherit' && ownerState.color !== 'transparent' && {
      backgroundColor: theme.palette[ownerState.color].main,
      color: theme.palette[ownerState.color].contrastText
    }, ownerState.color === 'inherit' && {
      color: 'inherit'
    }, theme.palette.mode === 'dark' && !ownerState.enableColorOnDark && {
      backgroundColor: null,
      color: null
    }, ownerState.color === 'transparent' && _extends({
      backgroundColor: 'transparent',
      color: 'inherit'
    }, theme.palette.mode === 'dark' && {
      backgroundImage: 'none'
    })), theme.vars && _extends({}, ownerState.color === 'default' && {
      '--AppBar-background': ownerState.enableColorOnDark ? theme.vars.palette.AppBar.defaultBg : joinVars(theme.vars.palette.AppBar.darkBg, theme.vars.palette.AppBar.defaultBg),
      '--AppBar-color': ownerState.enableColorOnDark ? theme.vars.palette.text.primary : joinVars(theme.vars.palette.AppBar.darkColor, theme.vars.palette.text.primary)
    }, ownerState.color && !ownerState.color.match(/^(default|inherit|transparent)$/) && {
      '--AppBar-background': ownerState.enableColorOnDark ? theme.vars.palette[ownerState.color].main : joinVars(theme.vars.palette.AppBar.darkBg, theme.vars.palette[ownerState.color].main),
      '--AppBar-color': ownerState.enableColorOnDark ? theme.vars.palette[ownerState.color].contrastText : joinVars(theme.vars.palette.AppBar.darkColor, theme.vars.palette[ownerState.color].contrastText)
    }, {
      backgroundColor: 'var(--AppBar-background)',
      color: ownerState.color === 'inherit' ? 'inherit' : 'var(--AppBar-color)'
    }, ownerState.color === 'transparent' && {
      backgroundImage: 'none',
      backgroundColor: 'transparent',
      color: 'inherit'
    }));
  });
  const AppBar = /*#__PURE__*/React__namespace.forwardRef(function AppBar(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAppBar'
    });

    const {
      className,
      color = 'primary',
      enableColorOnDark = false,
      position = 'fixed'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1R);

    const ownerState = _extends({}, props, {
      color,
      position,
      enableColorOnDark
    });

    const classes = useUtilityClasses$1z(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AppBarRoot, _extends({
      square: true,
      component: "header",
      ownerState: ownerState,
      elevation: 4,
      className: clsx(classes.root, className, position === 'fixed' && 'mui-fixed'),
      ref: ref
    }, other));
  });
  AppBar.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'primary'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['default', 'inherit', 'primary', 'secondary', 'transparent']), PropTypes.string]),

    /**
     * If true, the `color` prop is applied in dark mode.
     * @default false
     */
    enableColorOnDark: PropTypes.bool,

    /**
     * The positioning type. The behavior of the different options is described
     * [in the MDN web docs](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Positioning).
     * Note: `sticky` is not universally supported and will fall back to `static` when unavailable.
     * @default 'fixed'
     */
    position: PropTypes.oneOf(['absolute', 'fixed', 'relative', 'static', 'sticky']),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AppBar$1 = AppBar;

  const PopperRoot = styled$1(PopperUnstyled$1, {
    name: 'MuiPopper',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })({});
  /**
   *
   * Demos:
   *
   * - [Autocomplete](https://mui.com/material-ui/react-autocomplete/)
   * - [Menus](https://mui.com/material-ui/react-menu/)
   * - [Popper](https://mui.com/material-ui/react-popper/)
   *
   * API:
   *
   * - [Popper API](https://mui.com/material-ui/api/popper/)
   */

  const Popper = /*#__PURE__*/React__namespace.forwardRef(function Popper(inProps, ref) {
    const theme = useTheme$2();
    const props = useThemeProps({
      props: inProps,
      name: 'MuiPopper'
    });
    return /*#__PURE__*/jsxRuntime_1(PopperRoot, _extends({
      direction: theme == null ? void 0 : theme.direction
    }, props, {
      ref: ref
    }));
  });
  Popper.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit TypeScript types and run "yarn proptypes"  |
    // ----------------------------------------------------------------------

    /**
     * An HTML element, [virtualElement](https://popper.js.org/docs/v2/virtual-elements/),
     * or a function that returns either.
     * It's used to set the position of the popper.
     * The return value will passed as the reference object of the Popper instance.
     */
    anchorEl: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([HTMLElementType, PropTypes.object, PropTypes.func]),

    /**
     * Popper render function or node.
     */
    children: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.node, PropTypes.func]),

    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([HTMLElementType, PropTypes.func]),

    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Popper.
     * @default false
     */
    keepMounted: PropTypes.bool,

    /**
     * Popper.js is based on a "plugin-like" architecture,
     * most of its features are fully encapsulated "modifiers".
     *
     * A modifier is a function that is called each time Popper.js needs to
     * compute the position of the popper.
     * For this reason, modifiers should be very performant to avoid bottlenecks.
     * To learn how to create a modifier, [read the modifiers documentation](https://popper.js.org/docs/v2/modifiers/).
     */
    modifiers: PropTypes.arrayOf(PropTypes.shape({
      data: PropTypes.object,
      effect: PropTypes.func,
      enabled: PropTypes.bool,
      fn: PropTypes.func,
      name: PropTypes.any,
      options: PropTypes.object,
      phase: PropTypes.oneOf(['afterMain', 'afterRead', 'afterWrite', 'beforeMain', 'beforeRead', 'beforeWrite', 'main', 'read', 'write']),
      requires: PropTypes.arrayOf(PropTypes.string),
      requiresIfExists: PropTypes.arrayOf(PropTypes.string)
    })),

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,

    /**
     * Popper placement.
     * @default 'bottom'
     */
    placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

    /**
     * Options provided to the [`Popper.js`](https://popper.js.org/docs/v2/constructors/#options) instance.
     * @default {}
     */
    popperOptions: PropTypes.shape({
      modifiers: PropTypes.array,
      onFirstUpdate: PropTypes.func,
      placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
      strategy: PropTypes.oneOf(['absolute', 'fixed'])
    }),

    /**
     * A ref that points to the used popper instance.
     */
    popperRef: refType$1,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * Help supporting a react-transition-group/Transition component.
     * @default false
     */
    transition: PropTypes.bool
  } ;
  var Popper$1 = Popper;

  function getListSubheaderUtilityClass(slot) {
    return generateUtilityClass('MuiListSubheader', slot);
  }
  const listSubheaderClasses = generateUtilityClasses('MuiListSubheader', ['root', 'colorPrimary', 'colorInherit', 'gutters', 'inset', 'sticky']);
  var listSubheaderClasses$1 = listSubheaderClasses;

  const _excluded$1Q = ["className", "color", "component", "disableGutters", "disableSticky", "inset"];

  const useUtilityClasses$1y = ownerState => {
    const {
      classes,
      color,
      disableGutters,
      inset,
      disableSticky
    } = ownerState;
    const slots = {
      root: ['root', color !== 'default' && `color${capitalize(color)}`, !disableGutters && 'gutters', inset && 'inset', !disableSticky && 'sticky']
    };
    return composeClasses(slots, getListSubheaderUtilityClass, classes);
  };

  const ListSubheaderRoot = styled$1('li', {
    name: 'MuiListSubheader',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.color !== 'default' && styles[`color${capitalize(ownerState.color)}`], !ownerState.disableGutters && styles.gutters, ownerState.inset && styles.inset, !ownerState.disableSticky && styles.sticky];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    boxSizing: 'border-box',
    lineHeight: '48px',
    listStyle: 'none',
    color: (theme.vars || theme).palette.text.secondary,
    fontFamily: theme.typography.fontFamily,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.pxToRem(14)
  }, ownerState.color === 'primary' && {
    color: (theme.vars || theme).palette.primary.main
  }, ownerState.color === 'inherit' && {
    color: 'inherit'
  }, !ownerState.disableGutters && {
    paddingLeft: 16,
    paddingRight: 16
  }, ownerState.inset && {
    paddingLeft: 72
  }, !ownerState.disableSticky && {
    position: 'sticky',
    top: 0,
    zIndex: 1,
    backgroundColor: (theme.vars || theme).palette.background.paper
  }));
  const ListSubheader = /*#__PURE__*/React__namespace.forwardRef(function ListSubheader(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiListSubheader'
    });

    const {
      className,
      color = 'default',
      component = 'li',
      disableGutters = false,
      disableSticky = false,
      inset = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1Q);

    const ownerState = _extends({}, props, {
      color,
      component,
      disableGutters,
      disableSticky,
      inset
    });

    const classes = useUtilityClasses$1y(ownerState);
    return /*#__PURE__*/jsxRuntime_1(ListSubheaderRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  ListSubheader.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     * @default 'default'
     */
    color: PropTypes.oneOf(['default', 'inherit', 'primary']),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the List Subheader will not have gutters.
     * @default false
     */
    disableGutters: PropTypes.bool,

    /**
     * If `true`, the List Subheader will not stick to the top during scroll.
     * @default false
     */
    disableSticky: PropTypes.bool,

    /**
     * If `true`, the List Subheader is indented.
     * @default false
     */
    inset: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var ListSubheader$1 = ListSubheader;

  var CancelIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"
  }), 'Cancel');

  function getChipUtilityClass(slot) {
    return generateUtilityClass('MuiChip', slot);
  }
  const chipClasses = generateUtilityClasses('MuiChip', ['root', 'sizeSmall', 'sizeMedium', 'colorPrimary', 'colorSecondary', 'disabled', 'clickable', 'clickableColorPrimary', 'clickableColorSecondary', 'deletable', 'deletableColorPrimary', 'deletableColorSecondary', 'outlined', 'filled', 'outlinedPrimary', 'outlinedSecondary', 'avatar', 'avatarSmall', 'avatarMedium', 'avatarColorPrimary', 'avatarColorSecondary', 'icon', 'iconSmall', 'iconMedium', 'iconColorPrimary', 'iconColorSecondary', 'label', 'labelSmall', 'labelMedium', 'deleteIcon', 'deleteIconSmall', 'deleteIconMedium', 'deleteIconColorPrimary', 'deleteIconColorSecondary', 'deleteIconOutlinedColorPrimary', 'deleteIconOutlinedColorSecondary', 'focusVisible']);
  var chipClasses$1 = chipClasses;

  const _excluded$1P = ["avatar", "className", "clickable", "color", "component", "deleteIcon", "disabled", "icon", "label", "onClick", "onDelete", "onKeyDown", "onKeyUp", "size", "variant"];

  const useUtilityClasses$1x = ownerState => {
    const {
      classes,
      disabled,
      size,
      color,
      onDelete,
      clickable,
      variant
    } = ownerState;
    const slots = {
      root: ['root', variant, disabled && 'disabled', `size${capitalize(size)}`, `color${capitalize(color)}`, clickable && 'clickable', clickable && `clickableColor${capitalize(color)}`, onDelete && 'deletable', onDelete && `deletableColor${capitalize(color)}`, `${variant}${capitalize(color)}`],
      label: ['label', `label${capitalize(size)}`],
      avatar: ['avatar', `avatar${capitalize(size)}`, `avatarColor${capitalize(color)}`],
      icon: ['icon', `icon${capitalize(size)}`, `iconColor${capitalize(color)}`],
      deleteIcon: ['deleteIcon', `deleteIcon${capitalize(size)}`, `deleteIconColor${capitalize(color)}`, `deleteIconOutlinedColor${capitalize(color)}`]
    };
    return composeClasses(slots, getChipUtilityClass, classes);
  };

  const ChipRoot = styled$1('div', {
    name: 'MuiChip',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      const {
        color,
        clickable,
        onDelete,
        size,
        variant
      } = ownerState;
      return [{
        [`& .${chipClasses$1.avatar}`]: styles.avatar
      }, {
        [`& .${chipClasses$1.avatar}`]: styles[`avatar${capitalize(size)}`]
      }, {
        [`& .${chipClasses$1.avatar}`]: styles[`avatarColor${capitalize(color)}`]
      }, {
        [`& .${chipClasses$1.icon}`]: styles.icon
      }, {
        [`& .${chipClasses$1.icon}`]: styles[`icon${capitalize(size)}`]
      }, {
        [`& .${chipClasses$1.icon}`]: styles[`iconColor${capitalize(color)}`]
      }, {
        [`& .${chipClasses$1.deleteIcon}`]: styles.deleteIcon
      }, {
        [`& .${chipClasses$1.deleteIcon}`]: styles[`deleteIcon${capitalize(size)}`]
      }, {
        [`& .${chipClasses$1.deleteIcon}`]: styles[`deleteIconColor${capitalize(color)}`]
      }, {
        [`& .${chipClasses$1.deleteIcon}`]: styles[`deleteIconOutlinedColor${capitalize(color)}`]
      }, styles.root, styles[`size${capitalize(size)}`], styles[`color${capitalize(color)}`], clickable && styles.clickable, clickable && color !== 'default' && styles[`clickableColor${capitalize(color)})`], onDelete && styles.deletable, onDelete && color !== 'default' && styles[`deletableColor${capitalize(color)}`], styles[variant], variant === 'outlined' && styles[`outlined${capitalize(color)}`]];
    }
  })(({
    theme,
    ownerState
  }) => {
    const deleteIconColor = alpha(theme.palette.text.primary, 0.26);
    const textColor = theme.palette.mode === 'light' ? theme.palette.grey[700] : theme.palette.grey[300];
    return _extends({
      maxWidth: '100%',
      fontFamily: theme.typography.fontFamily,
      fontSize: theme.typography.pxToRem(13),
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      height: 32,
      color: (theme.vars || theme).palette.text.primary,
      backgroundColor: (theme.vars || theme).palette.action.selected,
      borderRadius: 32 / 2,
      whiteSpace: 'nowrap',
      transition: theme.transitions.create(['background-color', 'box-shadow']),
      // label will inherit this from root, then `clickable` class overrides this for both
      cursor: 'default',
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 0,
      textDecoration: 'none',
      border: 0,
      // Remove `button` border
      padding: 0,
      // Remove `button` padding
      verticalAlign: 'middle',
      boxSizing: 'border-box',
      [`&.${chipClasses$1.disabled}`]: {
        opacity: (theme.vars || theme).palette.action.disabledOpacity,
        pointerEvents: 'none'
      },
      [`& .${chipClasses$1.avatar}`]: {
        marginLeft: 5,
        marginRight: -6,
        width: 24,
        height: 24,
        color: theme.vars ? theme.vars.palette.Chip.defaultAvatarColor : textColor,
        fontSize: theme.typography.pxToRem(12)
      },
      [`& .${chipClasses$1.avatarColorPrimary}`]: {
        color: (theme.vars || theme).palette.primary.contrastText,
        backgroundColor: (theme.vars || theme).palette.primary.dark
      },
      [`& .${chipClasses$1.avatarColorSecondary}`]: {
        color: (theme.vars || theme).palette.secondary.contrastText,
        backgroundColor: (theme.vars || theme).palette.secondary.dark
      },
      [`& .${chipClasses$1.avatarSmall}`]: {
        marginLeft: 4,
        marginRight: -4,
        width: 18,
        height: 18,
        fontSize: theme.typography.pxToRem(10)
      },
      [`& .${chipClasses$1.icon}`]: _extends({
        color: theme.vars ? theme.vars.palette.Chip.defaultIconColor : textColor,
        marginLeft: 5,
        marginRight: -6
      }, ownerState.size === 'small' && {
        fontSize: 18,
        marginLeft: 4,
        marginRight: -4
      }, ownerState.color !== 'default' && {
        color: 'inherit'
      }),
      [`& .${chipClasses$1.deleteIcon}`]: _extends({
        WebkitTapHighlightColor: 'transparent',
        color: theme.vars ? `rgba(${theme.vars.palette.text.primaryChannel} / 0.26)` : deleteIconColor,
        fontSize: 22,
        cursor: 'pointer',
        margin: '0 5px 0 -6px',
        '&:hover': {
          color: theme.vars ? `rgba(${theme.vars.palette.text.primaryChannel} / 0.4)` : alpha(deleteIconColor, 0.4)
        }
      }, ownerState.size === 'small' && {
        fontSize: 16,
        marginRight: 4,
        marginLeft: -4
      }, ownerState.color !== 'default' && {
        color: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].contrastTextChannel} / 0.7)` : alpha(theme.palette[ownerState.color].contrastText, 0.7),
        '&:hover, &:active': {
          color: (theme.vars || theme).palette[ownerState.color].contrastText
        }
      })
    }, ownerState.size === 'small' && {
      height: 24
    }, ownerState.color !== 'default' && {
      backgroundColor: (theme.vars || theme).palette[ownerState.color].main,
      color: (theme.vars || theme).palette[ownerState.color].contrastText
    }, ownerState.onDelete && {
      [`&.${chipClasses$1.focusVisible}`]: {
        backgroundColor: theme.vars ? `rgba(${theme.vars.palette.action.selectedChannel} / calc(${theme.vars.palette.action.selectedOpacity + theme.vars.palette.action.focusOpacity}))` : alpha(theme.palette.action.selected, theme.palette.action.selectedOpacity + theme.palette.action.focusOpacity)
      }
    }, ownerState.onDelete && ownerState.color !== 'default' && {
      [`&.${chipClasses$1.focusVisible}`]: {
        backgroundColor: (theme.vars || theme).palette[ownerState.color].dark
      }
    });
  }, ({
    theme,
    ownerState
  }) => _extends({}, ownerState.clickable && {
    userSelect: 'none',
    WebkitTapHighlightColor: 'transparent',
    cursor: 'pointer',
    '&:hover': {
      backgroundColor: theme.vars ? `rgba(${theme.vars.palette.action.selectedChannel} / calc(${theme.vars.palette.action.selectedOpacity + theme.vars.palette.action.hoverOpacity}))` : alpha(theme.palette.action.selected, theme.palette.action.selectedOpacity + theme.palette.action.hoverOpacity)
    },
    [`&.${chipClasses$1.focusVisible}`]: {
      backgroundColor: theme.vars ? `rgba(${theme.vars.palette.action.selectedChannel} / calc(${theme.vars.palette.action.selectedOpacity + theme.vars.palette.action.focusOpacity}))` : alpha(theme.palette.action.selected, theme.palette.action.selectedOpacity + theme.palette.action.focusOpacity)
    },
    '&:active': {
      boxShadow: (theme.vars || theme).shadows[1]
    }
  }, ownerState.clickable && ownerState.color !== 'default' && {
    [`&:hover, &.${chipClasses$1.focusVisible}`]: {
      backgroundColor: (theme.vars || theme).palette[ownerState.color].dark
    }
  }), ({
    theme,
    ownerState
  }) => _extends({}, ownerState.variant === 'outlined' && {
    backgroundColor: 'transparent',
    border: theme.vars ? `1px solid ${theme.vars.palette.Chip.defaultBorder}` : `1px solid ${theme.palette.mode === 'light' ? theme.palette.grey[400] : theme.palette.grey[700]}`,
    [`&.${chipClasses$1.clickable}:hover`]: {
      backgroundColor: (theme.vars || theme).palette.action.hover
    },
    [`&.${chipClasses$1.focusVisible}`]: {
      backgroundColor: (theme.vars || theme).palette.action.focus
    },
    [`& .${chipClasses$1.avatar}`]: {
      marginLeft: 4
    },
    [`& .${chipClasses$1.avatarSmall}`]: {
      marginLeft: 2
    },
    [`& .${chipClasses$1.icon}`]: {
      marginLeft: 4
    },
    [`& .${chipClasses$1.iconSmall}`]: {
      marginLeft: 2
    },
    [`& .${chipClasses$1.deleteIcon}`]: {
      marginRight: 5
    },
    [`& .${chipClasses$1.deleteIconSmall}`]: {
      marginRight: 3
    }
  }, ownerState.variant === 'outlined' && ownerState.color !== 'default' && {
    color: (theme.vars || theme).palette[ownerState.color].main,
    border: `1px solid ${theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / 0.7)` : alpha(theme.palette[ownerState.color].main, 0.7)}`,
    [`&.${chipClasses$1.clickable}:hover`]: {
      backgroundColor: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / ${theme.vars.palette.action.hoverOpacity})` : alpha(theme.palette[ownerState.color].main, theme.palette.action.hoverOpacity)
    },
    [`&.${chipClasses$1.focusVisible}`]: {
      backgroundColor: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / ${theme.vars.palette.action.focusOpacity})` : alpha(theme.palette[ownerState.color].main, theme.palette.action.focusOpacity)
    },
    [`& .${chipClasses$1.deleteIcon}`]: {
      color: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / 0.7)` : alpha(theme.palette[ownerState.color].main, 0.7),
      '&:hover, &:active': {
        color: (theme.vars || theme).palette[ownerState.color].main
      }
    }
  }));
  const ChipLabel = styled$1('span', {
    name: 'MuiChip',
    slot: 'Label',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      const {
        size
      } = ownerState;
      return [styles.label, styles[`label${capitalize(size)}`]];
    }
  })(({
    ownerState
  }) => _extends({
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    paddingLeft: 12,
    paddingRight: 12,
    whiteSpace: 'nowrap'
  }, ownerState.size === 'small' && {
    paddingLeft: 8,
    paddingRight: 8
  }));

  function isDeleteKeyboardEvent(keyboardEvent) {
    return keyboardEvent.key === 'Backspace' || keyboardEvent.key === 'Delete';
  }
  /**
   * Chips represent complex entities in small blocks, such as a contact.
   */


  const Chip = /*#__PURE__*/React__namespace.forwardRef(function Chip(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiChip'
    });

    const {
      avatar: avatarProp,
      className,
      clickable: clickableProp,
      color = 'default',
      component: ComponentProp,
      deleteIcon: deleteIconProp,
      disabled = false,
      icon: iconProp,
      label,
      onClick,
      onDelete,
      onKeyDown,
      onKeyUp,
      size = 'medium',
      variant = 'filled'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1P);

    const chipRef = React__namespace.useRef(null);
    const handleRef = useForkRef(chipRef, ref);

    const handleDeleteIconClick = event => {
      // Stop the event from bubbling up to the `Chip`
      event.stopPropagation();

      if (onDelete) {
        onDelete(event);
      }
    };

    const handleKeyDown = event => {
      // Ignore events from children of `Chip`.
      if (event.currentTarget === event.target && isDeleteKeyboardEvent(event)) {
        // Will be handled in keyUp, otherwise some browsers
        // might init navigation
        event.preventDefault();
      }

      if (onKeyDown) {
        onKeyDown(event);
      }
    };

    const handleKeyUp = event => {
      // Ignore events from children of `Chip`.
      if (event.currentTarget === event.target) {
        if (onDelete && isDeleteKeyboardEvent(event)) {
          onDelete(event);
        } else if (event.key === 'Escape' && chipRef.current) {
          chipRef.current.blur();
        }
      }

      if (onKeyUp) {
        onKeyUp(event);
      }
    };

    const clickable = clickableProp !== false && onClick ? true : clickableProp;
    const small = size === 'small';
    const component = clickable || onDelete ? ButtonBase$1 : ComponentProp || 'div';

    const ownerState = _extends({}, props, {
      component,
      disabled,
      size,
      color,
      onDelete: !!onDelete,
      clickable,
      variant
    });

    const classes = useUtilityClasses$1x(ownerState);
    const moreProps = component === ButtonBase$1 ? _extends({
      component: ComponentProp || 'div',
      focusVisibleClassName: classes.focusVisible
    }, onDelete && {
      disableRipple: true
    }) : {};
    let deleteIcon = null;

    if (onDelete) {
      const customClasses = clsx(color !== 'default' && (variant === 'outlined' ? classes[`deleteIconOutlinedColor${capitalize(color)}`] : classes[`deleteIconColor${capitalize(color)}`]), small && classes.deleteIconSmall);
      deleteIcon = deleteIconProp && /*#__PURE__*/React__namespace.isValidElement(deleteIconProp) ? /*#__PURE__*/React__namespace.cloneElement(deleteIconProp, {
        className: clsx(deleteIconProp.props.className, classes.deleteIcon, customClasses),
        onClick: handleDeleteIconClick
      }) : /*#__PURE__*/jsxRuntime_1(CancelIcon, {
        className: clsx(classes.deleteIcon, customClasses),
        onClick: handleDeleteIconClick
      });
    }

    let avatar = null;

    if (avatarProp && /*#__PURE__*/React__namespace.isValidElement(avatarProp)) {
      avatar = /*#__PURE__*/React__namespace.cloneElement(avatarProp, {
        className: clsx(classes.avatar, avatarProp.props.className)
      });
    }

    let icon = null;

    if (iconProp && /*#__PURE__*/React__namespace.isValidElement(iconProp)) {
      icon = /*#__PURE__*/React__namespace.cloneElement(iconProp, {
        className: clsx(classes.icon, iconProp.props.className)
      });
    }

    {
      if (avatar && icon) {
        console.error('MUI: The Chip component can not handle the avatar ' + 'and the icon prop at the same time. Pick one.');
      }
    }

    return /*#__PURE__*/jsxRuntime_2(ChipRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      disabled: clickable && disabled ? true : undefined,
      onClick: onClick,
      onKeyDown: handleKeyDown,
      onKeyUp: handleKeyUp,
      ref: handleRef,
      ownerState: ownerState
    }, moreProps, other, {
      children: [avatar || icon, /*#__PURE__*/jsxRuntime_1(ChipLabel, {
        className: clsx(classes.label),
        ownerState: ownerState,
        children: label
      }), deleteIcon]
    }));
  });
  Chip.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The Avatar element to display.
     */
    avatar: PropTypes.element,

    /**
     * This prop isn't supported.
     * Use the `component` prop if you need to change the children structure.
     */
    children: unsupportedProp,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, the chip will appear clickable, and will raise when pressed,
     * even if the onClick prop is not defined.
     * If `false`, the chip will not appear clickable, even if onClick prop is defined.
     * This can be used, for example,
     * along with the component prop to indicate an anchor Chip is clickable.
     * Note: this controls the UI and does not affect the onClick event.
     */
    clickable: PropTypes.bool,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'default'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * Override the default delete icon element. Shown only if `onDelete` is set.
     */
    deleteIcon: PropTypes.element,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * Icon element.
     */
    icon: PropTypes.element,

    /**
     * The content of the component.
     */
    label: PropTypes.node,

    /**
     * @ignore
     */
    onClick: PropTypes.func,

    /**
     * Callback fired when the delete icon is clicked.
     * If set, the delete icon will be shown.
     */
    onDelete: PropTypes.func,

    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,

    /**
     * @ignore
     */
    onKeyUp: PropTypes.func,

    /**
     * The size of the component.
     * @default 'medium'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The variant to use.
     * @default 'filled'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['filled', 'outlined']), PropTypes.string])
  } ;
  var Chip$1 = Chip;

  function formControlState({
    props,
    states,
    muiFormControl
  }) {
    return states.reduce((acc, state) => {
      acc[state] = props[state];

      if (muiFormControl) {
        if (typeof props[state] === 'undefined') {
          acc[state] = muiFormControl[state];
        }
      }

      return acc;
    }, {});
  }

  /**
   * @ignore - internal component.
   */

  const FormControlContext = /*#__PURE__*/React__namespace.createContext();

  {
    FormControlContext.displayName = 'FormControlContext';
  }

  var FormControlContext$1 = FormControlContext;

  function useFormControl() {
    return React__namespace.useContext(FormControlContext$1);
  }

  function GlobalStyles(props) {
    return /*#__PURE__*/jsxRuntime_1(GlobalStyles$1, _extends({}, props, {
      defaultTheme: defaultTheme$3
    }));
  }

  GlobalStyles.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The styles you want to apply globally.
     */
    styles: PropTypes.oneOfType([PropTypes.func, PropTypes.number, PropTypes.object, PropTypes.shape({
      __emotion_styles: PropTypes.any.isRequired
    }), PropTypes.string, PropTypes.bool])
  } ;

  // Supports determination of isControlled().
  // Controlled input accepts its current value as a prop.
  //
  // @see https://facebook.github.io/react/docs/forms.html#controlled-components
  // @param value
  // @returns {boolean} true if string (including '') or number (including zero)
  function hasValue(value) {
    return value != null && !(Array.isArray(value) && value.length === 0);
  } // Determine if field is empty or filled.
  // Response determines if label is presented above field or as placeholder.
  //
  // @param obj
  // @param SSR
  // @returns {boolean} False when not present or empty string.
  //                    True when any number or string with length.

  function isFilled(obj, SSR = false) {
    return obj && (hasValue(obj.value) && obj.value !== '' || SSR && hasValue(obj.defaultValue) && obj.defaultValue !== '');
  } // Determine if an Input is adorned on start.
  // It's corresponding to the left with LTR.
  //
  // @param obj
  // @returns {boolean} False when no adornments.
  //                    True when adorned at the start.

  function isAdornedStart(obj) {
    return obj.startAdornment;
  }

  function getInputBaseUtilityClass(slot) {
    return generateUtilityClass('MuiInputBase', slot);
  }
  const inputBaseClasses = generateUtilityClasses('MuiInputBase', ['root', 'formControl', 'focused', 'disabled', 'adornedStart', 'adornedEnd', 'error', 'sizeSmall', 'multiline', 'colorSecondary', 'fullWidth', 'hiddenLabel', 'input', 'inputSizeSmall', 'inputMultiline', 'inputTypeSearch', 'inputAdornedStart', 'inputAdornedEnd', 'inputHiddenLabel']);
  var inputBaseClasses$1 = inputBaseClasses;

  const _excluded$1O = ["aria-describedby", "autoComplete", "autoFocus", "className", "color", "components", "componentsProps", "defaultValue", "disabled", "disableInjectingGlobalStyles", "endAdornment", "error", "fullWidth", "id", "inputComponent", "inputProps", "inputRef", "margin", "maxRows", "minRows", "multiline", "name", "onBlur", "onChange", "onClick", "onFocus", "onKeyDown", "onKeyUp", "placeholder", "readOnly", "renderSuffix", "rows", "size", "startAdornment", "type", "value"];
  const rootOverridesResolver = (props, styles) => {
    const {
      ownerState
    } = props;
    return [styles.root, ownerState.formControl && styles.formControl, ownerState.startAdornment && styles.adornedStart, ownerState.endAdornment && styles.adornedEnd, ownerState.error && styles.error, ownerState.size === 'small' && styles.sizeSmall, ownerState.multiline && styles.multiline, ownerState.color && styles[`color${capitalize(ownerState.color)}`], ownerState.fullWidth && styles.fullWidth, ownerState.hiddenLabel && styles.hiddenLabel];
  };
  const inputOverridesResolver = (props, styles) => {
    const {
      ownerState
    } = props;
    return [styles.input, ownerState.size === 'small' && styles.inputSizeSmall, ownerState.multiline && styles.inputMultiline, ownerState.type === 'search' && styles.inputTypeSearch, ownerState.startAdornment && styles.inputAdornedStart, ownerState.endAdornment && styles.inputAdornedEnd, ownerState.hiddenLabel && styles.inputHiddenLabel];
  };

  const useUtilityClasses$1w = ownerState => {
    const {
      classes,
      color,
      disabled,
      error,
      endAdornment,
      focused,
      formControl,
      fullWidth,
      hiddenLabel,
      multiline,
      size,
      startAdornment,
      type
    } = ownerState;
    const slots = {
      root: ['root', `color${capitalize(color)}`, disabled && 'disabled', error && 'error', fullWidth && 'fullWidth', focused && 'focused', formControl && 'formControl', size === 'small' && 'sizeSmall', multiline && 'multiline', startAdornment && 'adornedStart', endAdornment && 'adornedEnd', hiddenLabel && 'hiddenLabel'],
      input: ['input', disabled && 'disabled', type === 'search' && 'inputTypeSearch', multiline && 'inputMultiline', size === 'small' && 'inputSizeSmall', hiddenLabel && 'inputHiddenLabel', startAdornment && 'inputAdornedStart', endAdornment && 'inputAdornedEnd']
    };
    return composeClasses(slots, getInputBaseUtilityClass, classes);
  };

  const InputBaseRoot = styled$1('div', {
    name: 'MuiInputBase',
    slot: 'Root',
    overridesResolver: rootOverridesResolver
  })(({
    theme,
    ownerState
  }) => _extends({}, theme.typography.body1, {
    color: (theme.vars || theme).palette.text.primary,
    lineHeight: '1.4375em',
    // 23px
    boxSizing: 'border-box',
    // Prevent padding issue with fullWidth.
    position: 'relative',
    cursor: 'text',
    display: 'inline-flex',
    alignItems: 'center',
    [`&.${inputBaseClasses$1.disabled}`]: {
      color: (theme.vars || theme).palette.text.disabled,
      cursor: 'default'
    }
  }, ownerState.multiline && _extends({
    padding: '4px 0 5px'
  }, ownerState.size === 'small' && {
    paddingTop: 1
  }), ownerState.fullWidth && {
    width: '100%'
  }));
  const InputBaseComponent = styled$1('input', {
    name: 'MuiInputBase',
    slot: 'Input',
    overridesResolver: inputOverridesResolver
  })(({
    theme,
    ownerState
  }) => {
    const light = theme.palette.mode === 'light';

    const placeholder = _extends({
      color: 'currentColor'
    }, theme.vars ? {
      opacity: theme.vars.opacity.inputPlaceholder
    } : {
      opacity: light ? 0.42 : 0.5
    }, {
      transition: theme.transitions.create('opacity', {
        duration: theme.transitions.duration.shorter
      })
    });

    const placeholderHidden = {
      opacity: '0 !important'
    };
    const placeholderVisible = theme.vars ? {
      opacity: theme.vars.opacity.inputPlaceholder
    } : {
      opacity: light ? 0.42 : 0.5
    };
    return _extends({
      font: 'inherit',
      letterSpacing: 'inherit',
      color: 'currentColor',
      padding: '4px 0 5px',
      border: 0,
      boxSizing: 'content-box',
      background: 'none',
      height: '1.4375em',
      // Reset 23pxthe native input line-height
      margin: 0,
      // Reset for Safari
      WebkitTapHighlightColor: 'transparent',
      display: 'block',
      // Make the flex item shrink with Firefox
      minWidth: 0,
      width: '100%',
      // Fix IE11 width issue
      animationName: 'mui-auto-fill-cancel',
      animationDuration: '10ms',
      '&::-webkit-input-placeholder': placeholder,
      '&::-moz-placeholder': placeholder,
      // Firefox 19+
      '&:-ms-input-placeholder': placeholder,
      // IE11
      '&::-ms-input-placeholder': placeholder,
      // Edge
      '&:focus': {
        outline: 0
      },
      // Reset Firefox invalid required input style
      '&:invalid': {
        boxShadow: 'none'
      },
      '&::-webkit-search-decoration': {
        // Remove the padding when type=search.
        WebkitAppearance: 'none'
      },
      // Show and hide the placeholder logic
      [`label[data-shrink=false] + .${inputBaseClasses$1.formControl} &`]: {
        '&::-webkit-input-placeholder': placeholderHidden,
        '&::-moz-placeholder': placeholderHidden,
        // Firefox 19+
        '&:-ms-input-placeholder': placeholderHidden,
        // IE11
        '&::-ms-input-placeholder': placeholderHidden,
        // Edge
        '&:focus::-webkit-input-placeholder': placeholderVisible,
        '&:focus::-moz-placeholder': placeholderVisible,
        // Firefox 19+
        '&:focus:-ms-input-placeholder': placeholderVisible,
        // IE11
        '&:focus::-ms-input-placeholder': placeholderVisible // Edge

      },
      [`&.${inputBaseClasses$1.disabled}`]: {
        opacity: 1,
        // Reset iOS opacity
        WebkitTextFillColor: (theme.vars || theme).palette.text.disabled // Fix opacity Safari bug

      },
      '&:-webkit-autofill': {
        animationDuration: '5000s',
        animationName: 'mui-auto-fill'
      }
    }, ownerState.size === 'small' && {
      paddingTop: 1
    }, ownerState.multiline && {
      height: 'auto',
      resize: 'none',
      padding: 0,
      paddingTop: 0
    }, ownerState.type === 'search' && {
      // Improve type search style.
      MozAppearance: 'textfield'
    });
  });

  const inputGlobalStyles = /*#__PURE__*/jsxRuntime_1(GlobalStyles, {
    styles: {
      '@keyframes mui-auto-fill': {
        from: {
          display: 'block'
        }
      },
      '@keyframes mui-auto-fill-cancel': {
        from: {
          display: 'block'
        }
      }
    }
  });
  /**
   * `InputBase` contains as few styles as possible.
   * It aims to be a simple building block for creating an input.
   * It contains a load of style reset and some state logic.
   */


  const InputBase = /*#__PURE__*/React__namespace.forwardRef(function InputBase(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiInputBase'
    });

    const {
      'aria-describedby': ariaDescribedby,
      autoComplete,
      autoFocus,
      className,
      components = {},
      componentsProps = {},
      defaultValue,
      disabled,
      disableInjectingGlobalStyles,
      endAdornment,
      fullWidth = false,
      id,
      inputComponent = 'input',
      inputProps: inputPropsProp = {},
      inputRef: inputRefProp,
      maxRows,
      minRows,
      multiline = false,
      name,
      onBlur,
      onChange,
      onClick,
      onFocus,
      onKeyDown,
      onKeyUp,
      placeholder,
      readOnly,
      renderSuffix,
      rows,
      startAdornment,
      type = 'text',
      value: valueProp
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1O);

    const value = inputPropsProp.value != null ? inputPropsProp.value : valueProp;
    const {
      current: isControlled
    } = React__namespace.useRef(value != null);
    const inputRef = React__namespace.useRef();
    const handleInputRefWarning = React__namespace.useCallback(instance => {
      {
        if (instance && instance.nodeName !== 'INPUT' && !instance.focus) {
          console.error(['MUI: You have provided a `inputComponent` to the input component', 'that does not correctly handle the `ref` prop.', 'Make sure the `ref` prop is called with a HTMLInputElement.'].join('\n'));
        }
      }
    }, []);
    const handleInputPropsRefProp = useForkRef(inputPropsProp.ref, handleInputRefWarning);
    const handleInputRefProp = useForkRef(inputRefProp, handleInputPropsRefProp);
    const handleInputRef = useForkRef(inputRef, handleInputRefProp);
    const [focused, setFocused] = React__namespace.useState(false);
    const muiFormControl = useFormControl();

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useEffect(() => {
        if (muiFormControl) {
          return muiFormControl.registerEffect();
        }

        return undefined;
      }, [muiFormControl]);
    }

    const fcs = formControlState({
      props,
      muiFormControl,
      states: ['color', 'disabled', 'error', 'hiddenLabel', 'size', 'required', 'filled']
    });
    fcs.focused = muiFormControl ? muiFormControl.focused : focused; // The blur won't fire when the disabled state is set on a focused input.
    // We need to book keep the focused state manually.

    React__namespace.useEffect(() => {
      if (!muiFormControl && disabled && focused) {
        setFocused(false);

        if (onBlur) {
          onBlur();
        }
      }
    }, [muiFormControl, disabled, focused, onBlur]);
    const onFilled = muiFormControl && muiFormControl.onFilled;
    const onEmpty = muiFormControl && muiFormControl.onEmpty;
    const checkDirty = React__namespace.useCallback(obj => {
      if (isFilled(obj)) {
        if (onFilled) {
          onFilled();
        }
      } else if (onEmpty) {
        onEmpty();
      }
    }, [onFilled, onEmpty]);
    useEnhancedEffect$1(() => {
      if (isControlled) {
        checkDirty({
          value
        });
      }
    }, [value, checkDirty, isControlled]);

    const handleFocus = event => {
      // Fix a bug with IE11 where the focus/blur events are triggered
      // while the component is disabled.
      if (fcs.disabled) {
        event.stopPropagation();
        return;
      }

      if (onFocus) {
        onFocus(event);
      }

      if (inputPropsProp.onFocus) {
        inputPropsProp.onFocus(event);
      }

      if (muiFormControl && muiFormControl.onFocus) {
        muiFormControl.onFocus(event);
      } else {
        setFocused(true);
      }
    };

    const handleBlur = event => {
      if (onBlur) {
        onBlur(event);
      }

      if (inputPropsProp.onBlur) {
        inputPropsProp.onBlur(event);
      }

      if (muiFormControl && muiFormControl.onBlur) {
        muiFormControl.onBlur(event);
      } else {
        setFocused(false);
      }
    };

    const handleChange = (event, ...args) => {
      if (!isControlled) {
        const element = event.target || inputRef.current;

        if (element == null) {
          throw new Error(`MUI: Expected valid input target. Did you use a custom \`inputComponent\` and forget to forward refs? See https://mui.com/r/input-component-ref-interface for more info.` );
        }

        checkDirty({
          value: element.value
        });
      }

      if (inputPropsProp.onChange) {
        inputPropsProp.onChange(event, ...args);
      } // Perform in the willUpdate


      if (onChange) {
        onChange(event, ...args);
      }
    }; // Check the input state on mount, in case it was filled by the user
    // or auto filled by the browser before the hydration (for SSR).


    React__namespace.useEffect(() => {
      checkDirty(inputRef.current); // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);

    const handleClick = event => {
      if (inputRef.current && event.currentTarget === event.target) {
        inputRef.current.focus();
      }

      if (onClick) {
        onClick(event);
      }
    };

    let InputComponent = inputComponent;
    let inputProps = inputPropsProp;

    if (multiline && InputComponent === 'input') {
      if (rows) {
        {
          if (minRows || maxRows) {
            console.warn('MUI: You can not use the `minRows` or `maxRows` props when the input `rows` prop is set.');
          }
        }

        inputProps = _extends({
          type: undefined,
          minRows: rows,
          maxRows: rows
        }, inputProps);
      } else {
        inputProps = _extends({
          type: undefined,
          maxRows,
          minRows
        }, inputProps);
      }

      InputComponent = TextareaAutosize$1;
    }

    const handleAutoFill = event => {
      // Provide a fake value as Chrome might not let you access it for security reasons.
      checkDirty(event.animationName === 'mui-auto-fill-cancel' ? inputRef.current : {
        value: 'x'
      });
    };

    React__namespace.useEffect(() => {
      if (muiFormControl) {
        muiFormControl.setAdornedStart(Boolean(startAdornment));
      }
    }, [muiFormControl, startAdornment]);

    const ownerState = _extends({}, props, {
      color: fcs.color || 'primary',
      disabled: fcs.disabled,
      endAdornment,
      error: fcs.error,
      focused: fcs.focused,
      formControl: muiFormControl,
      fullWidth,
      hiddenLabel: fcs.hiddenLabel,
      multiline,
      size: fcs.size,
      startAdornment,
      type
    });

    const classes = useUtilityClasses$1w(ownerState);
    const Root = components.Root || InputBaseRoot;
    const rootProps = componentsProps.root || {};
    const Input = components.Input || InputBaseComponent;
    inputProps = _extends({}, inputProps, componentsProps.input);
    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [!disableInjectingGlobalStyles && inputGlobalStyles, /*#__PURE__*/jsxRuntime_2(Root, _extends({}, rootProps, !isHostComponent(Root) && {
        ownerState: _extends({}, ownerState, rootProps.ownerState)
      }, {
        ref: ref,
        onClick: handleClick
      }, other, {
        className: clsx(classes.root, rootProps.className, className),
        children: [startAdornment, /*#__PURE__*/jsxRuntime_1(FormControlContext$1.Provider, {
          value: null,
          children: /*#__PURE__*/jsxRuntime_1(Input, _extends({
            ownerState: ownerState,
            "aria-invalid": fcs.error,
            "aria-describedby": ariaDescribedby,
            autoComplete: autoComplete,
            autoFocus: autoFocus,
            defaultValue: defaultValue,
            disabled: fcs.disabled,
            id: id,
            onAnimationStart: handleAutoFill,
            name: name,
            placeholder: placeholder,
            readOnly: readOnly,
            required: fcs.required,
            rows: rows,
            value: value,
            onKeyDown: onKeyDown,
            onKeyUp: onKeyUp,
            type: type
          }, inputProps, !isHostComponent(Input) && {
            as: InputComponent,
            ownerState: _extends({}, ownerState, inputProps.ownerState)
          }, {
            ref: handleInputRef,
            className: clsx(classes.input, inputProps.className),
            onBlur: handleBlur,
            onChange: handleChange,
            onFocus: handleFocus
          }))
        }), endAdornment, renderSuffix ? renderSuffix(_extends({}, fcs, {
          startAdornment
        })) : null]
      }))]
    });
  });
  InputBase.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * @ignore
     */
    'aria-describedby': PropTypes.string,

    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: PropTypes.string,

    /**
     * If `true`, the `input` element is focused during the first mount.
     */
    autoFocus: PropTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * The prop defaults to the value (`'primary'`) inherited from the parent FormControl component.
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The components used for each slot inside the InputBase.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Input: PropTypes.elementType,
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Input.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      input: PropTypes.object,
      root: PropTypes.object
    }),

    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue: PropTypes.any,

    /**
     * If `true`, the component is disabled.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, GlobalStyles for the auto-fill keyframes will not be injected/removed on mount/unmount. Make sure to inject them at the top of your application.
     * This option is intended to help with boosting the initial rendering performance if you are loading a big amount of Input components at once.
     * @default false
     */
    disableInjectingGlobalStyles: PropTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: PropTypes.node,

    /**
     * If `true`, the `input` will indicate an error.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    error: PropTypes.bool,

    /**
     * If `true`, the `input` will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: PropTypes.string,

    /**
     * The component used for the `input` element.
     * Either a string to use a HTML element or a component.
     * @default 'input'
     */
    inputComponent: elementTypeAcceptingRef$1,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     * @default {}
     */
    inputProps: PropTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType$1,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     * The prop defaults to the value (`'none'`) inherited from the parent FormControl component.
     */
    margin: PropTypes.oneOf(['dense', 'none']),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    maxRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * Minimum number of rows to display when multiline option is set to true.
     */
    minRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * If `true`, a [TextareaAutosize](/material-ui/react-textarea-autosize/) element is rendered.
     * @default false
     */
    multiline: PropTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: PropTypes.string,

    /**
     * Callback fired when the `input` is blurred.
     *
     * Notice that the first argument (event) might be undefined.
     */
    onBlur: PropTypes.func,

    /**
     * Callback fired when the value is changed.
     *
     * @param {React.ChangeEvent<HTMLTextAreaElement | HTMLInputElement>} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: PropTypes.func,

    /**
     * @ignore
     */
    onClick: PropTypes.func,

    /**
     * @ignore
     */
    onFocus: PropTypes.func,

    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,

    /**
     * @ignore
     */
    onKeyUp: PropTypes.func,

    /**
     * The short hint displayed in the `input` before the user enters a value.
     */
    placeholder: PropTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: PropTypes.bool,

    /**
     * @ignore
     */
    renderSuffix: PropTypes.func,

    /**
     * If `true`, the `input` element is required.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    required: PropTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * The size of the component.
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.string]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: PropTypes.node,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     * @default 'text'
     */
    type: PropTypes.string,

    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: PropTypes.any
  } ;
  var InputBase$1 = InputBase;

  function getInputUtilityClass(slot) {
    return generateUtilityClass('MuiInput', slot);
  }

  const inputClasses = _extends({}, inputBaseClasses$1, generateUtilityClasses('MuiInput', ['root', 'underline', 'input']));

  var inputClasses$1 = inputClasses;

  function getOutlinedInputUtilityClass(slot) {
    return generateUtilityClass('MuiOutlinedInput', slot);
  }

  const outlinedInputClasses = _extends({}, inputBaseClasses$1, generateUtilityClasses('MuiOutlinedInput', ['root', 'notchedOutline', 'input']));

  var outlinedInputClasses$1 = outlinedInputClasses;

  function getFilledInputUtilityClass(slot) {
    return generateUtilityClass('MuiFilledInput', slot);
  }

  const filledInputClasses = _extends({}, inputBaseClasses$1, generateUtilityClasses('MuiFilledInput', ['root', 'underline', 'input']));

  var filledInputClasses$1 = filledInputClasses;

  var ArrowDropDownIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M7 10l5 5 5-5z"
  }), 'ArrowDropDown');

  function getAutocompleteUtilityClass(slot) {
    return generateUtilityClass('MuiAutocomplete', slot);
  }
  const autocompleteClasses = generateUtilityClasses('MuiAutocomplete', ['root', 'fullWidth', 'focused', 'focusVisible', 'tag', 'tagSizeSmall', 'tagSizeMedium', 'hasPopupIcon', 'hasClearIcon', 'inputRoot', 'input', 'inputFocused', 'endAdornment', 'clearIndicator', 'popupIndicator', 'popupIndicatorOpen', 'popper', 'popperDisablePortal', 'paper', 'listbox', 'loading', 'noOptions', 'option', 'groupLabel', 'groupUl']);
  var autocompleteClasses$1 = autocompleteClasses;

  var _ClearIcon, _ArrowDropDownIcon;

  const _excluded$1N = ["autoComplete", "autoHighlight", "autoSelect", "blurOnSelect", "ChipProps", "className", "clearIcon", "clearOnBlur", "clearOnEscape", "clearText", "closeText", "componentsProps", "defaultValue", "disableClearable", "disableCloseOnSelect", "disabled", "disabledItemsFocusable", "disableListWrap", "disablePortal", "filterOptions", "filterSelectedOptions", "forcePopupIcon", "freeSolo", "fullWidth", "getLimitTagsText", "getOptionDisabled", "getOptionLabel", "isOptionEqualToValue", "groupBy", "handleHomeEndKeys", "id", "includeInputInList", "inputValue", "limitTags", "ListboxComponent", "ListboxProps", "loading", "loadingText", "multiple", "noOptionsText", "onChange", "onClose", "onHighlightChange", "onInputChange", "onOpen", "open", "openOnFocus", "openText", "options", "PaperComponent", "PopperComponent", "popupIcon", "readOnly", "renderGroup", "renderInput", "renderOption", "renderTags", "selectOnFocus", "size", "value"];

  const useUtilityClasses$1v = ownerState => {
    const {
      classes,
      disablePortal,
      focused,
      fullWidth,
      hasClearIcon,
      hasPopupIcon,
      inputFocused,
      popupOpen,
      size
    } = ownerState;
    const slots = {
      root: ['root', focused && 'focused', fullWidth && 'fullWidth', hasClearIcon && 'hasClearIcon', hasPopupIcon && 'hasPopupIcon'],
      inputRoot: ['inputRoot'],
      input: ['input', inputFocused && 'inputFocused'],
      tag: ['tag', `tagSize${capitalize(size)}`],
      endAdornment: ['endAdornment'],
      clearIndicator: ['clearIndicator'],
      popupIndicator: ['popupIndicator', popupOpen && 'popupIndicatorOpen'],
      popper: ['popper', disablePortal && 'popperDisablePortal'],
      paper: ['paper'],
      listbox: ['listbox'],
      loading: ['loading'],
      noOptions: ['noOptions'],
      option: ['option'],
      groupLabel: ['groupLabel'],
      groupUl: ['groupUl']
    };
    return composeClasses(slots, getAutocompleteUtilityClass, classes);
  };

  const AutocompleteRoot = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      const {
        fullWidth,
        hasClearIcon,
        hasPopupIcon,
        inputFocused,
        size
      } = ownerState;
      return [{
        [`& .${autocompleteClasses$1.tag}`]: styles.tag
      }, {
        [`& .${autocompleteClasses$1.tag}`]: styles[`tagSize${capitalize(size)}`]
      }, {
        [`& .${autocompleteClasses$1.inputRoot}`]: styles.inputRoot
      }, {
        [`& .${autocompleteClasses$1.input}`]: styles.input
      }, {
        [`& .${autocompleteClasses$1.input}`]: inputFocused && styles.inputFocused
      }, styles.root, fullWidth && styles.fullWidth, hasPopupIcon && styles.hasPopupIcon, hasClearIcon && styles.hasClearIcon];
    }
  })(({
    ownerState
  }) => _extends({
    [`&.${autocompleteClasses$1.focused} .${autocompleteClasses$1.clearIndicator}`]: {
      visibility: 'visible'
    },

    /* Avoid double tap issue on iOS */
    '@media (pointer: fine)': {
      [`&:hover .${autocompleteClasses$1.clearIndicator}`]: {
        visibility: 'visible'
      }
    }
  }, ownerState.fullWidth && {
    width: '100%'
  }, {
    [`& .${autocompleteClasses$1.tag}`]: _extends({
      margin: 3,
      maxWidth: 'calc(100% - 6px)'
    }, ownerState.size === 'small' && {
      margin: 2,
      maxWidth: 'calc(100% - 4px)'
    }),
    [`& .${autocompleteClasses$1.inputRoot}`]: {
      flexWrap: 'wrap',
      [`.${autocompleteClasses$1.hasPopupIcon}&, .${autocompleteClasses$1.hasClearIcon}&`]: {
        paddingRight: 26 + 4
      },
      [`.${autocompleteClasses$1.hasPopupIcon}.${autocompleteClasses$1.hasClearIcon}&`]: {
        paddingRight: 52 + 4
      },
      [`& .${autocompleteClasses$1.input}`]: {
        width: 0,
        minWidth: 30
      }
    },
    [`& .${inputClasses$1.root}`]: {
      paddingBottom: 1,
      '& .MuiInput-input': {
        padding: '4px 4px 4px 0px'
      }
    },
    [`& .${inputClasses$1.root}.${inputBaseClasses$1.sizeSmall}`]: {
      [`& .${inputClasses$1.input}`]: {
        padding: '2px 4px 3px 0'
      }
    },
    [`& .${outlinedInputClasses$1.root}`]: {
      padding: 9,
      [`.${autocompleteClasses$1.hasPopupIcon}&, .${autocompleteClasses$1.hasClearIcon}&`]: {
        paddingRight: 26 + 4 + 9
      },
      [`.${autocompleteClasses$1.hasPopupIcon}.${autocompleteClasses$1.hasClearIcon}&`]: {
        paddingRight: 52 + 4 + 9
      },
      [`& .${autocompleteClasses$1.input}`]: {
        padding: '7.5px 4px 7.5px 6px'
      },
      [`& .${autocompleteClasses$1.endAdornment}`]: {
        right: 9
      }
    },
    [`& .${outlinedInputClasses$1.root}.${inputBaseClasses$1.sizeSmall}`]: {
      padding: 6,
      [`& .${autocompleteClasses$1.input}`]: {
        padding: '2.5px 4px 2.5px 6px'
      }
    },
    [`& .${filledInputClasses$1.root}`]: {
      paddingTop: 19,
      paddingLeft: 8,
      [`.${autocompleteClasses$1.hasPopupIcon}&, .${autocompleteClasses$1.hasClearIcon}&`]: {
        paddingRight: 26 + 4 + 9
      },
      [`.${autocompleteClasses$1.hasPopupIcon}.${autocompleteClasses$1.hasClearIcon}&`]: {
        paddingRight: 52 + 4 + 9
      },
      [`& .${filledInputClasses$1.input}`]: {
        padding: '7px 4px'
      },
      [`& .${autocompleteClasses$1.endAdornment}`]: {
        right: 9
      }
    },
    [`& .${filledInputClasses$1.root}.${inputBaseClasses$1.sizeSmall}`]: {
      paddingBottom: 1,
      [`& .${filledInputClasses$1.input}`]: {
        padding: '2.5px 4px'
      }
    },
    [`& .${inputBaseClasses$1.hiddenLabel}`]: {
      paddingTop: 8
    },
    [`& .${autocompleteClasses$1.input}`]: _extends({
      flexGrow: 1,
      textOverflow: 'ellipsis',
      opacity: 0
    }, ownerState.inputFocused && {
      opacity: 1
    })
  }));
  const AutocompleteEndAdornment = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'EndAdornment',
    overridesResolver: (props, styles) => styles.endAdornment
  })({
    // We use a position absolute to support wrapping tags.
    position: 'absolute',
    right: 0,
    top: 'calc(50% - 14px)' // Center vertically

  });
  const AutocompleteClearIndicator = styled$1(IconButton$1, {
    name: 'MuiAutocomplete',
    slot: 'ClearIndicator',
    overridesResolver: (props, styles) => styles.clearIndicator
  })({
    marginRight: -2,
    padding: 4,
    visibility: 'hidden'
  });
  const AutocompletePopupIndicator = styled$1(IconButton$1, {
    name: 'MuiAutocomplete',
    slot: 'PopupIndicator',
    overridesResolver: ({
      ownerState
    }, styles) => _extends({}, styles.popupIndicator, ownerState.popupOpen && styles.popupIndicatorOpen)
  })(({
    ownerState
  }) => _extends({
    padding: 2,
    marginRight: -2
  }, ownerState.popupOpen && {
    transform: 'rotate(180deg)'
  }));
  const AutocompletePopper = styled$1(Popper$1, {
    name: 'MuiAutocomplete',
    slot: 'Popper',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [{
        [`& .${autocompleteClasses$1.option}`]: styles.option
      }, styles.popper, ownerState.disablePortal && styles.popperDisablePortal];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    zIndex: (theme.vars || theme).zIndex.modal
  }, ownerState.disablePortal && {
    position: 'absolute'
  }));
  const AutocompletePaper = styled$1(Paper$1, {
    name: 'MuiAutocomplete',
    slot: 'Paper',
    overridesResolver: (props, styles) => styles.paper
  })(({
    theme
  }) => _extends({}, theme.typography.body1, {
    overflow: 'auto'
  }));
  const AutocompleteLoading = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'Loading',
    overridesResolver: (props, styles) => styles.loading
  })(({
    theme
  }) => ({
    color: (theme.vars || theme).palette.text.secondary,
    padding: '14px 16px'
  }));
  const AutocompleteNoOptions = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'NoOptions',
    overridesResolver: (props, styles) => styles.noOptions
  })(({
    theme
  }) => ({
    color: (theme.vars || theme).palette.text.secondary,
    padding: '14px 16px'
  }));
  const AutocompleteListbox = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'Listbox',
    overridesResolver: (props, styles) => styles.listbox
  })(({
    theme
  }) => ({
    listStyle: 'none',
    margin: 0,
    padding: '8px 0',
    maxHeight: '40vh',
    overflow: 'auto',
    [`& .${autocompleteClasses$1.option}`]: {
      minHeight: 48,
      display: 'flex',
      overflow: 'hidden',
      justifyContent: 'flex-start',
      alignItems: 'center',
      cursor: 'pointer',
      paddingTop: 6,
      boxSizing: 'border-box',
      outline: '0',
      WebkitTapHighlightColor: 'transparent',
      paddingBottom: 6,
      paddingLeft: 16,
      paddingRight: 16,
      [theme.breakpoints.up('sm')]: {
        minHeight: 'auto'
      },
      [`&.${autocompleteClasses$1.focused}`]: {
        backgroundColor: (theme.vars || theme).palette.action.hover,
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      },
      '&[aria-disabled="true"]': {
        opacity: (theme.vars || theme).palette.action.disabledOpacity,
        pointerEvents: 'none'
      },
      [`&.${autocompleteClasses$1.focusVisible}`]: {
        backgroundColor: (theme.vars || theme).palette.action.focus
      },
      '&[aria-selected="true"]': {
        backgroundColor: theme.vars ? `rgba(${theme.vars.palette.primary.mainChannel} / ${theme.vars.palette.action.selectedOpacity})` : alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity),
        [`&.${autocompleteClasses$1.focused}`]: {
          backgroundColor: theme.vars ? `rgba(${theme.vars.palette.primary.mainChannel} / calc(${theme.vars.palette.action.selectedOpacity} + ${theme.vars.palette.action.hoverOpacity}))` : alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity + theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: (theme.vars || theme).palette.action.selected
          }
        },
        [`&.${autocompleteClasses$1.focusVisible}`]: {
          backgroundColor: theme.vars ? `rgba(${theme.vars.palette.primary.mainChannel} / calc(${theme.vars.palette.action.selectedOpacity} + ${theme.vars.palette.action.focusOpacity}))` : alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity + theme.palette.action.focusOpacity)
        }
      }
    }
  }));
  const AutocompleteGroupLabel = styled$1(ListSubheader$1, {
    name: 'MuiAutocomplete',
    slot: 'GroupLabel',
    overridesResolver: (props, styles) => styles.groupLabel
  })(({
    theme
  }) => ({
    backgroundColor: (theme.vars || theme).palette.background.paper,
    top: -8
  }));
  const AutocompleteGroupUl = styled$1('ul', {
    name: 'MuiAutocomplete',
    slot: 'GroupUl',
    overridesResolver: (props, styles) => styles.groupUl
  })({
    padding: 0,
    [`& .${autocompleteClasses$1.option}`]: {
      paddingLeft: 24
    }
  });
  const Autocomplete = /*#__PURE__*/React__namespace.forwardRef(function Autocomplete(inProps, ref) {
    var _componentsProps$clea, _componentsProps$pape;

    const props = useThemeProps({
      props: inProps,
      name: 'MuiAutocomplete'
    });
    /* eslint-disable @typescript-eslint/no-unused-vars */

    const {
      autoComplete = false,
      autoHighlight = false,
      autoSelect = false,
      blurOnSelect = false,
      ChipProps,
      className,
      clearIcon = _ClearIcon || (_ClearIcon = /*#__PURE__*/jsxRuntime_1(ClearIcon, {
        fontSize: "small"
      })),
      clearOnBlur = !props.freeSolo,
      clearOnEscape = false,
      clearText = 'Clear',
      closeText = 'Close',
      componentsProps = {},
      defaultValue = props.multiple ? [] : null,
      disableClearable = false,
      disableCloseOnSelect = false,
      disabled = false,
      disabledItemsFocusable = false,
      disableListWrap = false,
      disablePortal = false,
      filterSelectedOptions = false,
      forcePopupIcon = 'auto',
      freeSolo = false,
      fullWidth = false,
      getLimitTagsText = more => `+${more}`,
      getOptionLabel = option => {
        var _option$label;

        return (_option$label = option.label) != null ? _option$label : option;
      },
      groupBy,
      handleHomeEndKeys = !props.freeSolo,
      includeInputInList = false,
      limitTags = -1,
      ListboxComponent = 'ul',
      ListboxProps,
      loading = false,
      loadingText = 'Loading…',
      multiple = false,
      noOptionsText = 'No options',
      openOnFocus = false,
      openText = 'Open',
      PaperComponent = Paper$1,
      PopperComponent = Popper$1,
      popupIcon = _ArrowDropDownIcon || (_ArrowDropDownIcon = /*#__PURE__*/jsxRuntime_1(ArrowDropDownIcon, {})),
      readOnly = false,
      renderGroup: renderGroupProp,
      renderInput,
      renderOption: renderOptionProp,
      renderTags,
      selectOnFocus = !props.freeSolo,
      size = 'medium'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1N);
    /* eslint-enable @typescript-eslint/no-unused-vars */


    const {
      getRootProps,
      getInputProps,
      getInputLabelProps,
      getPopupIndicatorProps,
      getClearProps,
      getTagProps,
      getListboxProps,
      getOptionProps,
      value,
      dirty,
      id,
      popupOpen,
      focused,
      focusedTag,
      anchorEl,
      setAnchorEl,
      inputValue,
      groupedOptions
    } = useAutocomplete(_extends({}, props, {
      componentName: 'Autocomplete'
    }));
    const hasClearIcon = !disableClearable && !disabled && dirty && !readOnly;
    const hasPopupIcon = (!freeSolo || forcePopupIcon === true) && forcePopupIcon !== false; // If you modify this, make sure to keep the `AutocompleteOwnerState` type in sync.

    const ownerState = _extends({}, props, {
      disablePortal,
      focused,
      fullWidth,
      hasClearIcon,
      hasPopupIcon,
      inputFocused: focusedTag === -1,
      popupOpen,
      size
    });

    const classes = useUtilityClasses$1v(ownerState);
    let startAdornment;

    if (multiple && value.length > 0) {
      const getCustomizedTagProps = params => _extends({
        className: clsx(classes.tag),
        disabled
      }, getTagProps(params));

      if (renderTags) {
        startAdornment = renderTags(value, getCustomizedTagProps, ownerState);
      } else {
        startAdornment = value.map((option, index) => /*#__PURE__*/jsxRuntime_1(Chip$1, _extends({
          label: getOptionLabel(option),
          size: size
        }, getCustomizedTagProps({
          index
        }), ChipProps)));
      }
    }

    if (limitTags > -1 && Array.isArray(startAdornment)) {
      const more = startAdornment.length - limitTags;

      if (!focused && more > 0) {
        startAdornment = startAdornment.splice(0, limitTags);
        startAdornment.push( /*#__PURE__*/jsxRuntime_1("span", {
          className: classes.tag,
          children: getLimitTagsText(more)
        }, startAdornment.length));
      }
    }

    const defaultRenderGroup = params => /*#__PURE__*/jsxRuntime_2("li", {
      children: [/*#__PURE__*/jsxRuntime_1(AutocompleteGroupLabel, {
        className: classes.groupLabel,
        ownerState: ownerState,
        component: "div",
        children: params.group
      }), /*#__PURE__*/jsxRuntime_1(AutocompleteGroupUl, {
        className: classes.groupUl,
        ownerState: ownerState,
        children: params.children
      })]
    }, params.key);

    const renderGroup = renderGroupProp || defaultRenderGroup;

    const defaultRenderOption = (props2, option) => /*#__PURE__*/jsxRuntime_1("li", _extends({}, props2, {
      children: getOptionLabel(option)
    }));

    const renderOption = renderOptionProp || defaultRenderOption;

    const renderListOption = (option, index) => {
      const optionProps = getOptionProps({
        option,
        index
      });
      return renderOption(_extends({}, optionProps, {
        className: classes.option
      }), option, {
        selected: optionProps['aria-selected'],
        inputValue
      });
    };

    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1(AutocompleteRoot, _extends({
        ref: ref,
        className: clsx(classes.root, className),
        ownerState: ownerState
      }, getRootProps(other), {
        children: renderInput({
          id,
          disabled,
          fullWidth: true,
          size: size === 'small' ? 'small' : undefined,
          InputLabelProps: getInputLabelProps(),
          InputProps: _extends({
            ref: setAnchorEl,
            className: classes.inputRoot,
            startAdornment
          }, (hasClearIcon || hasPopupIcon) && {
            endAdornment: /*#__PURE__*/jsxRuntime_2(AutocompleteEndAdornment, {
              className: classes.endAdornment,
              ownerState: ownerState,
              children: [hasClearIcon ? /*#__PURE__*/jsxRuntime_1(AutocompleteClearIndicator, _extends({}, getClearProps(), {
                "aria-label": clearText,
                title: clearText,
                ownerState: ownerState
              }, componentsProps.clearIndicator, {
                className: clsx(classes.clearIndicator, (_componentsProps$clea = componentsProps.clearIndicator) == null ? void 0 : _componentsProps$clea.className),
                children: clearIcon
              })) : null, hasPopupIcon ? /*#__PURE__*/jsxRuntime_1(AutocompletePopupIndicator, _extends({}, getPopupIndicatorProps(), {
                disabled: disabled,
                "aria-label": popupOpen ? closeText : openText,
                title: popupOpen ? closeText : openText,
                className: clsx(classes.popupIndicator),
                ownerState: ownerState,
                children: popupIcon
              })) : null]
            })
          }),
          inputProps: _extends({
            className: clsx(classes.input),
            disabled,
            readOnly
          }, getInputProps())
        })
      })), popupOpen && anchorEl ? /*#__PURE__*/jsxRuntime_1(AutocompletePopper, {
        as: PopperComponent,
        className: clsx(classes.popper),
        disablePortal: disablePortal,
        style: {
          width: anchorEl ? anchorEl.clientWidth : null
        },
        ownerState: ownerState,
        role: "presentation",
        anchorEl: anchorEl,
        open: true,
        children: /*#__PURE__*/jsxRuntime_2(AutocompletePaper, _extends({
          ownerState: ownerState,
          as: PaperComponent
        }, componentsProps.paper, {
          className: clsx(classes.paper, (_componentsProps$pape = componentsProps.paper) == null ? void 0 : _componentsProps$pape.className),
          children: [loading && groupedOptions.length === 0 ? /*#__PURE__*/jsxRuntime_1(AutocompleteLoading, {
            className: classes.loading,
            ownerState: ownerState,
            children: loadingText
          }) : null, groupedOptions.length === 0 && !freeSolo && !loading ? /*#__PURE__*/jsxRuntime_1(AutocompleteNoOptions, {
            className: classes.noOptions,
            ownerState: ownerState,
            role: "presentation",
            onMouseDown: event => {
              // Prevent input blur when interacting with the "no options" content
              event.preventDefault();
            },
            children: noOptionsText
          }) : null, groupedOptions.length > 0 ? /*#__PURE__*/jsxRuntime_1(AutocompleteListbox, _extends({
            as: ListboxComponent,
            className: classes.listbox,
            ownerState: ownerState
          }, getListboxProps(), ListboxProps, {
            children: groupedOptions.map((option, index) => {
              if (groupBy) {
                return renderGroup({
                  key: option.key,
                  group: option.group,
                  children: option.options.map((option2, index2) => renderListOption(option2, option.index + index2))
                });
              }

              return renderListOption(option, index);
            })
          })) : null]
        }))
      }) : null]
    });
  });
  Autocomplete.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * If `true`, the portion of the selected suggestion that has not been typed by the user,
     * known as the completion string, appears inline after the input cursor in the textbox.
     * The inline completion string is visually highlighted and has a selected state.
     * @default false
     */
    autoComplete: PropTypes.bool,

    /**
     * If `true`, the first option is automatically highlighted.
     * @default false
     */
    autoHighlight: PropTypes.bool,

    /**
     * If `true`, the selected option becomes the value of the input
     * when the Autocomplete loses focus unless the user chooses
     * a different option or changes the character string in the input.
     * @default false
     */
    autoSelect: PropTypes.bool,

    /**
     * Control if the input should be blurred when an option is selected:
     *
     * - `false` the input is not blurred.
     * - `true` the input is always blurred.
     * - `touch` the input is blurred after a touch event.
     * - `mouse` the input is blurred after a mouse event.
     * @default false
     */
    blurOnSelect: PropTypes.oneOfType([PropTypes.oneOf(['mouse', 'touch']), PropTypes.bool]),

    /**
     * Props applied to the [`Chip`](/material-ui/api/chip/) element.
     */
    ChipProps: PropTypes.object,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The icon to display in place of the default clear icon.
     * @default <ClearIcon fontSize="small" />
     */
    clearIcon: PropTypes.node,

    /**
     * If `true`, the input's text is cleared on blur if no value is selected.
     *
     * Set to `true` if you want to help the user enter a new value.
     * Set to `false` if you want to help the user resume their search.
     * @default !props.freeSolo
     */
    clearOnBlur: PropTypes.bool,

    /**
     * If `true`, clear all values when the user presses escape and the popup is closed.
     * @default false
     */
    clearOnEscape: PropTypes.bool,

    /**
     * Override the default text for the *clear* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Clear'
     */
    clearText: PropTypes.string,

    /**
     * Override the default text for the *close popup* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Close'
     */
    closeText: PropTypes.string,

    /**
     * The props used for each slot inside.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      clearIndicator: PropTypes.object,
      paper: PropTypes.object
    }),

    /**
     * The default value. Use when the component is not controlled.
     * @default props.multiple ? [] : null
     */
    defaultValue: chainPropTypes(PropTypes.any, props => {
      if (props.multiple && props.defaultValue !== undefined && !Array.isArray(props.defaultValue)) {
        return new Error(['MUI: The Autocomplete expects the `defaultValue` prop to be an array when `multiple={true}` or undefined.', `However, ${props.defaultValue} was provided.`].join('\n'));
      }

      return null;
    }),

    /**
     * If `true`, the input can't be cleared.
     * @default false
     */
    disableClearable: PropTypes.bool,

    /**
     * If `true`, the popup won't close when a value is selected.
     * @default false
     */
    disableCloseOnSelect: PropTypes.bool,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, will allow focus on disabled items.
     * @default false
     */
    disabledItemsFocusable: PropTypes.bool,

    /**
     * If `true`, the list box in the popup will not wrap focus.
     * @default false
     */
    disableListWrap: PropTypes.bool,

    /**
     * If `true`, the `Popper` content will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,

    /**
     * A function that determines the filtered options to be rendered on search.
     *
     * @param {T[]} options The options to render.
     * @param {object} state The state of the component.
     * @returns {T[]}
     */
    filterOptions: PropTypes.func,

    /**
     * If `true`, hide the selected options from the list box.
     * @default false
     */
    filterSelectedOptions: PropTypes.bool,

    /**
     * Force the visibility display of the popup icon.
     * @default 'auto'
     */
    forcePopupIcon: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.bool]),

    /**
     * If `true`, the Autocomplete is free solo, meaning that the user input is not bound to provided options.
     * @default false
     */
    freeSolo: PropTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,

    /**
     * The label to display when the tags are truncated (`limitTags`).
     *
     * @param {number} more The number of truncated tags.
     * @returns {ReactNode}
     * @default (more) => `+${more}`
     */
    getLimitTagsText: PropTypes.func,

    /**
     * Used to determine the disabled state for a given option.
     *
     * @param {T} option The option to test.
     * @returns {boolean}
     */
    getOptionDisabled: PropTypes.func,

    /**
     * Used to determine the string value for a given option.
     * It's used to fill the input (and the list box options if `renderOption` is not provided).
     *
     * If used in free solo mode, it must accept both the type of the options and a string.
     *
     * @param {T} option
     * @returns {string}
     * @default (option) => option.label ?? option
     */
    getOptionLabel: PropTypes.func,

    /**
     * If provided, the options will be grouped under the returned string.
     * The groupBy value is also used as the text for group headings when `renderGroup` is not provided.
     *
     * @param {T} options The options to group.
     * @returns {string}
     */
    groupBy: PropTypes.func,

    /**
     * If `true`, the component handles the "Home" and "End" keys when the popup is open.
     * It should move focus to the first option and last option, respectively.
     * @default !props.freeSolo
     */
    handleHomeEndKeys: PropTypes.bool,

    /**
     * This prop is used to help implement the accessibility logic.
     * If you don't provide an id it will fall back to a randomly generated one.
     */
    id: PropTypes.string,

    /**
     * If `true`, the highlight can move to the input.
     * @default false
     */
    includeInputInList: PropTypes.bool,

    /**
     * The input value.
     */
    inputValue: PropTypes.string,

    /**
     * Used to determine if the option represents the given value.
     * Uses strict equality by default.
     * ⚠️ Both arguments need to be handled, an option can only match with one value.
     *
     * @param {T} option The option to test.
     * @param {T} value The value to test against.
     * @returns {boolean}
     */
    isOptionEqualToValue: PropTypes.func,

    /**
     * The maximum number of tags that will be visible when not focused.
     * Set `-1` to disable the limit.
     * @default -1
     */
    limitTags: integerPropType,

    /**
     * The component used to render the listbox.
     * @default 'ul'
     */
    ListboxComponent: PropTypes.elementType,

    /**
     * Props applied to the Listbox element.
     */
    ListboxProps: PropTypes.object,

    /**
     * If `true`, the component is in a loading state.
     * This shows the `loadingText` in place of suggestions (only if there are no suggestions to show, e.g. `options` are empty).
     * @default false
     */
    loading: PropTypes.bool,

    /**
     * Text to display when in a loading state.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Loading…'
     */
    loadingText: PropTypes.node,

    /**
     * If `true`, `value` must be an array and the menu will support multiple selections.
     * @default false
     */
    multiple: PropTypes.bool,

    /**
     * Text to display when there are no options.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'No options'
     */
    noOptionsText: PropTypes.node,

    /**
     * Callback fired when the value changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {T|T[]} value The new value of the component.
     * @param {string} reason One of "createOption", "selectOption", "removeOption", "blur" or "clear".
     * @param {string} [details]
     */
    onChange: PropTypes.func,

    /**
     * Callback fired when the popup requests to be closed.
     * Use in controlled mode (see open).
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {string} reason Can be: `"toggleInput"`, `"escape"`, `"selectOption"`, `"removeOption"`, `"blur"`.
     */
    onClose: PropTypes.func,

    /**
     * Callback fired when the highlight option changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {T} option The highlighted option.
     * @param {string} reason Can be: `"keyboard"`, `"auto"`, `"mouse"`.
     */
    onHighlightChange: PropTypes.func,

    /**
     * Callback fired when the input value changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {string} value The new value of the text input.
     * @param {string} reason Can be: `"input"` (user input), `"reset"` (programmatic change), `"clear"`.
     */
    onInputChange: PropTypes.func,

    /**
     * Callback fired when the popup requests to be opened.
     * Use in controlled mode (see open).
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     */
    onOpen: PropTypes.func,

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool,

    /**
     * If `true`, the popup will open on input focus.
     * @default false
     */
    openOnFocus: PropTypes.bool,

    /**
     * Override the default text for the *open popup* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Open'
     */
    openText: PropTypes.string,

    /**
     * Array of options.
     */
    options: PropTypes.array.isRequired,

    /**
     * The component used to render the body of the popup.
     * @default Paper
     */
    PaperComponent: PropTypes.elementType,

    /**
     * The component used to position the popup.
     * @default Popper
     */
    PopperComponent: PropTypes.elementType,

    /**
     * The icon to display in place of the default popup icon.
     * @default <ArrowDropDownIcon />
     */
    popupIcon: PropTypes.node,

    /**
     * If `true`, the component becomes readonly. It is also supported for multiple tags where the tag cannot be deleted.
     * @default false
     */
    readOnly: PropTypes.bool,

    /**
     * Render the group.
     *
     * @param {AutocompleteRenderGroupParams} params The group to render.
     * @returns {ReactNode}
     */
    renderGroup: PropTypes.func,

    /**
     * Render the input.
     *
     * @param {object} params
     * @returns {ReactNode}
     */
    renderInput: PropTypes.func.isRequired,

    /**
     * Render the option, use `getOptionLabel` by default.
     *
     * @param {object} props The props to apply on the li element.
     * @param {T} option The option to render.
     * @param {object} state The state of the component.
     * @returns {ReactNode}
     */
    renderOption: PropTypes.func,

    /**
     * Render the selected value.
     *
     * @param {T[]} value The `value` provided to the component.
     * @param {function} getTagProps A tag props getter.
     * @param {object} ownerState The state of the Autocomplete component.
     * @returns {ReactNode}
     */
    renderTags: PropTypes.func,

    /**
     * If `true`, the input's text is selected on focus.
     * It helps the user clear the selected value.
     * @default !props.freeSolo
     */
    selectOnFocus: PropTypes.bool,

    /**
     * The size of the component.
     * @default 'medium'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['small', 'medium']), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The value of the autocomplete.
     *
     * The value must have reference equality with the option in order to be selected.
     * You can customize the equality behavior with the `isOptionEqualToValue` prop.
     */
    value: chainPropTypes(PropTypes.any, props => {
      if (props.multiple && props.value !== undefined && !Array.isArray(props.value)) {
        return new Error(['MUI: The Autocomplete expects the `value` prop to be an array when `multiple={true}` or undefined.', `However, ${props.value} was provided.`].join('\n'));
      }

      return null;
    })
  } ;
  var Autocomplete$1 = Autocomplete;

  var Person = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"
  }), 'Person');

  function getAvatarUtilityClass(slot) {
    return generateUtilityClass('MuiAvatar', slot);
  }
  const avatarClasses = generateUtilityClasses('MuiAvatar', ['root', 'colorDefault', 'circular', 'rounded', 'square', 'img', 'fallback']);
  var avatarClasses$1 = avatarClasses;

  const _excluded$1M = ["alt", "children", "className", "component", "imgProps", "sizes", "src", "srcSet", "variant"];

  const useUtilityClasses$1u = ownerState => {
    const {
      classes,
      variant,
      colorDefault
    } = ownerState;
    const slots = {
      root: ['root', variant, colorDefault && 'colorDefault'],
      img: ['img'],
      fallback: ['fallback']
    };
    return composeClasses(slots, getAvatarUtilityClass, classes);
  };

  const AvatarRoot = styled$1('div', {
    name: 'MuiAvatar',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.variant], ownerState.colorDefault && styles.colorDefault];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    flexShrink: 0,
    width: 40,
    height: 40,
    fontFamily: theme.typography.fontFamily,
    fontSize: theme.typography.pxToRem(20),
    lineHeight: 1,
    borderRadius: '50%',
    overflow: 'hidden',
    userSelect: 'none'
  }, ownerState.variant === 'rounded' && {
    borderRadius: (theme.vars || theme).shape.borderRadius
  }, ownerState.variant === 'square' && {
    borderRadius: 0
  }, ownerState.colorDefault && _extends({
    color: (theme.vars || theme).palette.background.default
  }, theme.vars ? {
    backgroundColor: theme.vars.palette.Avatar.defaultBg
  } : {
    backgroundColor: theme.palette.mode === 'light' ? theme.palette.grey[400] : theme.palette.grey[600]
  })));
  const AvatarImg = styled$1('img', {
    name: 'MuiAvatar',
    slot: 'Img',
    overridesResolver: (props, styles) => styles.img
  })({
    width: '100%',
    height: '100%',
    textAlign: 'center',
    // Handle non-square image. The property isn't supported by IE11.
    objectFit: 'cover',
    // Hide alt text.
    color: 'transparent',
    // Hide the image broken icon, only works on Chrome.
    textIndent: 10000
  });
  const AvatarFallback = styled$1(Person, {
    name: 'MuiAvatar',
    slot: 'Fallback',
    overridesResolver: (props, styles) => styles.fallback
  })({
    width: '75%',
    height: '75%'
  });

  function useLoaded({
    crossOrigin,
    referrerPolicy,
    src,
    srcSet
  }) {
    const [loaded, setLoaded] = React__namespace.useState(false);
    React__namespace.useEffect(() => {
      if (!src && !srcSet) {
        return undefined;
      }

      setLoaded(false);
      let active = true;
      const image = new Image();

      image.onload = () => {
        if (!active) {
          return;
        }

        setLoaded('loaded');
      };

      image.onerror = () => {
        if (!active) {
          return;
        }

        setLoaded('error');
      };

      image.crossOrigin = crossOrigin;
      image.referrerPolicy = referrerPolicy;
      image.src = src;

      if (srcSet) {
        image.srcset = srcSet;
      }

      return () => {
        active = false;
      };
    }, [crossOrigin, referrerPolicy, src, srcSet]);
    return loaded;
  }

  const Avatar = /*#__PURE__*/React__namespace.forwardRef(function Avatar(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiAvatar'
    });

    const {
      alt,
      children: childrenProp,
      className,
      component = 'div',
      imgProps,
      sizes,
      src,
      srcSet,
      variant = 'circular'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1M);

    let children = null; // Use a hook instead of onError on the img element to support server-side rendering.

    const loaded = useLoaded(_extends({}, imgProps, {
      src,
      srcSet
    }));
    const hasImg = src || srcSet;
    const hasImgNotFailing = hasImg && loaded !== 'error';

    const ownerState = _extends({}, props, {
      colorDefault: !hasImgNotFailing,
      component,
      variant
    });

    const classes = useUtilityClasses$1u(ownerState);

    if (hasImgNotFailing) {
      children = /*#__PURE__*/jsxRuntime_1(AvatarImg, _extends({
        alt: alt,
        src: src,
        srcSet: srcSet,
        sizes: sizes,
        ownerState: ownerState,
        className: classes.img
      }, imgProps));
    } else if (childrenProp != null) {
      children = childrenProp;
    } else if (hasImg && alt) {
      children = alt[0];
    } else {
      children = /*#__PURE__*/jsxRuntime_1(AvatarFallback, {
        className: classes.fallback
      });
    }

    return /*#__PURE__*/jsxRuntime_1(AvatarRoot, _extends({
      as: component,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other, {
      children: children
    }));
  });
  Avatar.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Used in combination with `src` or `srcSet` to
     * provide an alt attribute for the rendered `img` element.
     */
    alt: PropTypes.string,

    /**
     * Used to render icon or text elements inside the Avatar if `src` is not set.
     * This can be an element, or just a string.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img#attributes) applied to the `img` element if the component is used to display an image.
     * It can be used to listen for the loading error event.
     */
    imgProps: PropTypes.object,

    /**
     * The `sizes` attribute for the `img` element.
     */
    sizes: PropTypes.string,

    /**
     * The `src` attribute for the `img` element.
     */
    src: PropTypes.string,

    /**
     * The `srcSet` attribute for the `img` element.
     * Use this attribute for responsive image display.
     */
    srcSet: PropTypes.string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The shape of the avatar.
     * @default 'circular'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['circular', 'rounded', 'square']), PropTypes.string])
  } ;
  var Avatar$1 = Avatar;

  function getAvatarGroupUtilityClass(slot) {
    return generateUtilityClass('MuiAvatarGroup', slot);
  }
  const avatarGroupClasses = generateUtilityClasses('MuiAvatarGroup', ['root', 'avatar']);
  var avatarGroupClasses$1 = avatarGroupClasses;

  const _excluded$1L = ["children", "className", "componentsProps", "max", "spacing", "total", "variant"];
  const SPACINGS$1 = {
    small: -16,
    medium: null
  };

  const useUtilityClasses$1t = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root'],
      avatar: ['avatar']
    };
    return composeClasses(slots, getAvatarGroupUtilityClass, classes);
  };

  const AvatarGroupRoot = styled$1('div', {
    name: 'MuiAvatarGroup',
    slot: 'Root',
    overridesResolver: (props, styles) => _extends({
      [`& .${avatarGroupClasses$1.avatar}`]: styles.avatar
    }, styles.root)
  })(({
    theme
  }) => ({
    [`& .${avatarClasses$1.root}`]: {
      border: `2px solid ${(theme.vars || theme).palette.background.default}`,
      boxSizing: 'content-box',
      marginLeft: -8,
      '&:last-child': {
        marginLeft: 0
      }
    },
    display: 'flex',
    flexDirection: 'row-reverse'
  }));
  const AvatarGroupAvatar = styled$1(Avatar$1, {
    name: 'MuiAvatarGroup',
    slot: 'Avatar',
    overridesResolver: (props, styles) => styles.avatar
  })(({
    theme
  }) => ({
    border: `2px solid ${(theme.vars || theme).palette.background.default}`,
    boxSizing: 'content-box',
    marginLeft: -8,
    '&:last-child': {
      marginLeft: 0
    }
  }));
  const AvatarGroup = /*#__PURE__*/React__namespace.forwardRef(function AvatarGroup(inProps, ref) {
    var _componentsProps$addi, _componentsProps$addi2;

    const props = useThemeProps({
      props: inProps,
      name: 'MuiAvatarGroup'
    });

    const {
      children: childrenProp,
      className,
      componentsProps = {},
      max = 5,
      spacing = 'medium',
      total,
      variant = 'circular'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1L);

    let clampedMax = max < 2 ? 2 : max;

    const ownerState = _extends({}, props, {
      max,
      spacing,
      variant
    });

    const classes = useUtilityClasses$1t(ownerState);
    const children = React__namespace.Children.toArray(childrenProp).filter(child => {
      {
        if (reactIs_2(child)) {
          console.error(["MUI: The AvatarGroup component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      return /*#__PURE__*/React__namespace.isValidElement(child);
    });
    const totalAvatars = total || children.length;

    if (totalAvatars === clampedMax) {
      clampedMax += 1;
    }

    clampedMax = Math.min(totalAvatars + 1, clampedMax);
    const maxAvatars = Math.min(children.length, clampedMax - 1);
    const extraAvatars = Math.max(totalAvatars - clampedMax, totalAvatars - maxAvatars, 0);
    const marginLeft = spacing && SPACINGS$1[spacing] !== undefined ? SPACINGS$1[spacing] : -spacing;
    return /*#__PURE__*/jsxRuntime_2(AvatarGroupRoot, _extends({
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other, {
      children: [extraAvatars ? /*#__PURE__*/jsxRuntime_2(AvatarGroupAvatar, _extends({
        ownerState: ownerState,
        variant: variant
      }, componentsProps.additionalAvatar, {
        className: clsx(classes.avatar, (_componentsProps$addi = componentsProps.additionalAvatar) == null ? void 0 : _componentsProps$addi.className),
        style: _extends({
          marginLeft
        }, (_componentsProps$addi2 = componentsProps.additionalAvatar) == null ? void 0 : _componentsProps$addi2.style),
        children: ["+", extraAvatars]
      })) : null, children.slice(0, maxAvatars).reverse().map((child, index) => {
        return /*#__PURE__*/React__namespace.cloneElement(child, {
          className: clsx(child.props.className, classes.avatar),
          style: _extends({
            // Consistent with "&:last-child" styling for the default spacing,
            // we do not apply custom marginLeft spacing on the last child
            marginLeft: index === maxAvatars - 1 ? undefined : marginLeft
          }, child.props.style),
          variant: child.props.variant || variant
        });
      })]
    }));
  });
  AvatarGroup.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The avatars to stack.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The props used for each slot inside the AvatarGroup.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      additionalAvatar: PropTypes.object
    }),

    /**
     * Max avatars to show before +x.
     * @default 5
     */
    max: chainPropTypes(PropTypes.number, props => {
      if (props.max < 2) {
        return new Error(['MUI: The prop `max` should be equal to 2 or above.', 'A value below is clamped to 2.'].join('\n'));
      }

      return null;
    }),

    /**
     * Spacing between avatars.
     * @default 'medium'
     */
    spacing: PropTypes.oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.number]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The total number of avatars. Used for calculating the number of extra avatars.
     * @default children.length
     */
    total: PropTypes.number,

    /**
     * The variant to use.
     * @default 'circular'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['circular', 'rounded', 'square']), PropTypes.string])
  } ;
  var AvatarGroup$1 = AvatarGroup;

  const _excluded$1K = ["addEndListener", "appear", "children", "easing", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "style", "timeout", "TransitionComponent"];
  const styles$4 = {
    entering: {
      opacity: 1
    },
    entered: {
      opacity: 1
    }
  };
  /**
   * The Fade transition is used by the [Modal](/material-ui/react-modal/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  const Fade = /*#__PURE__*/React__namespace.forwardRef(function Fade(props, ref) {
    const theme = useTheme();
    const defaultTimeout = {
      enter: theme.transitions.duration.enteringScreen,
      exit: theme.transitions.duration.leavingScreen
    };

    const {
      addEndListener,
      appear = true,
      children,
      easing,
      in: inProp,
      onEnter,
      onEntered,
      onEntering,
      onExit,
      onExited,
      onExiting,
      style,
      timeout = defaultTimeout,
      // eslint-disable-next-line react/prop-types
      TransitionComponent = Transition$1
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1K);
    const nodeRef = React__namespace.useRef(null);
    const foreignRef = useForkRef(children.ref, ref);
    const handleRef = useForkRef(nodeRef, foreignRef);

    const normalizedTransitionCallback = callback => maybeIsAppearing => {
      if (callback) {
        const node = nodeRef.current; // onEnterXxx and onExitXxx callbacks have a different arguments.length value.

        if (maybeIsAppearing === undefined) {
          callback(node);
        } else {
          callback(node, maybeIsAppearing);
        }
      }
    };

    const handleEntering = normalizedTransitionCallback(onEntering);
    const handleEnter = normalizedTransitionCallback((node, isAppearing) => {
      reflow(node); // So the animation always start from the start.

      const transitionProps = getTransitionProps({
        style,
        timeout,
        easing
      }, {
        mode: 'enter'
      });
      node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
      node.style.transition = theme.transitions.create('opacity', transitionProps);

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    });
    const handleEntered = normalizedTransitionCallback(onEntered);
    const handleExiting = normalizedTransitionCallback(onExiting);
    const handleExit = normalizedTransitionCallback(node => {
      const transitionProps = getTransitionProps({
        style,
        timeout,
        easing
      }, {
        mode: 'exit'
      });
      node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
      node.style.transition = theme.transitions.create('opacity', transitionProps);

      if (onExit) {
        onExit(node);
      }
    });
    const handleExited = normalizedTransitionCallback(onExited);

    const handleAddEndListener = next => {
      if (addEndListener) {
        // Old call signature before `react-transition-group` implemented `nodeRef`
        addEndListener(nodeRef.current, next);
      }
    };

    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      appear: appear,
      in: inProp,
      nodeRef: nodeRef ,
      onEnter: handleEnter,
      onEntered: handleEntered,
      onEntering: handleEntering,
      onExit: handleExit,
      onExited: handleExited,
      onExiting: handleExiting,
      addEndListener: handleAddEndListener,
      timeout: timeout
    }, other, {
      children: (state, childProps) => {
        return /*#__PURE__*/React__namespace.cloneElement(children, _extends({
          style: _extends({
            opacity: 0,
            visibility: state === 'exited' && !inProp ? 'hidden' : undefined
          }, styles$4[state], style, children.props.style),
          ref: handleRef
        }, childProps));
      }
    }));
  });
  Fade.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Add a custom transition end trigger. Called with the transitioning DOM
     * node and a done callback. Allows for more fine grained transition end
     * logic. Note: Timeouts are still used as a fallback if provided.
     */
    addEndListener: PropTypes.func,

    /**
     * Perform the enter transition when it first mounts if `in` is also `true`.
     * Set this to `false` to disable this behavior.
     * @default true
     */
    appear: PropTypes.bool,

    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1.isRequired,

    /**
     * The transition timing function.
     * You may specify a single easing or a object containing enter and exit values.
     */
    easing: PropTypes.oneOfType([PropTypes.shape({
      enter: PropTypes.string,
      exit: PropTypes.string
    }), PropTypes.string]),

    /**
     * If `true`, the component will transition in.
     */
    in: PropTypes.bool,

    /**
     * @ignore
     */
    onEnter: PropTypes.func,

    /**
     * @ignore
     */
    onEntered: PropTypes.func,

    /**
     * @ignore
     */
    onEntering: PropTypes.func,

    /**
     * @ignore
     */
    onExit: PropTypes.func,

    /**
     * @ignore
     */
    onExited: PropTypes.func,

    /**
     * @ignore
     */
    onExiting: PropTypes.func,

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     * @default {
     *   enter: theme.transitions.duration.enteringScreen,
     *   exit: theme.transitions.duration.leavingScreen,
     * }
     */
    timeout: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  var Fade$1 = Fade;

  function getBackdropUtilityClass(slot) {
    return generateUtilityClass('MuiBackdrop', slot);
  }
  const backdropClasses = generateUtilityClasses('MuiBackdrop', ['root', 'invisible']);
  var backdropClasses$1 = backdropClasses;

  const _excluded$1J = ["children", "component", "components", "componentsProps", "className", "invisible", "open", "transitionDuration", "TransitionComponent"];

  const useUtilityClasses$1s = ownerState => {
    const {
      classes,
      invisible
    } = ownerState;
    const slots = {
      root: ['root', invisible && 'invisible']
    };
    return composeClasses(slots, getBackdropUtilityClass, classes);
  };

  const BackdropRoot = styled$1('div', {
    name: 'MuiBackdrop',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.invisible && styles.invisible];
    }
  })(({
    ownerState
  }) => _extends({
    position: 'fixed',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    right: 0,
    bottom: 0,
    top: 0,
    left: 0,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    WebkitTapHighlightColor: 'transparent'
  }, ownerState.invisible && {
    backgroundColor: 'transparent'
  }));
  const Backdrop = /*#__PURE__*/React__namespace.forwardRef(function Backdrop(inProps, ref) {
    var _components$Root, _componentsProps$root;

    const props = useThemeProps({
      props: inProps,
      name: 'MuiBackdrop'
    });

    const {
      children,
      component = 'div',
      components = {},
      componentsProps = {},
      className,
      invisible = false,
      open,
      transitionDuration,
      // eslint-disable-next-line react/prop-types
      TransitionComponent = Fade$1
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1J);

    const ownerState = _extends({}, props, {
      component,
      invisible
    });

    const classes = useUtilityClasses$1s(ownerState);
    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      in: open,
      timeout: transitionDuration
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(BackdropRoot, {
        "aria-hidden": true,
        as: (_components$Root = components.Root) != null ? _components$Root : component,
        className: clsx(classes.root, className),
        ownerState: _extends({}, ownerState, (_componentsProps$root = componentsProps.root) == null ? void 0 : _componentsProps$root.ownerState),
        classes: classes,
        ref: ref,
        children: children
      })
    }));
  });
  Backdrop.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The components used for each slot inside the Backdrop.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Backdrop.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      root: PropTypes.object
    }),

    /**
     * If `true`, the backdrop is invisible.
     * It can be used when rendering a popover or a custom select component.
     * @default false
     */
    invisible: PropTypes.bool,

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  var Backdrop$1 = Backdrop;

  const shouldSpreadAdditionalProps = Slot => {
    return !Slot || !isHostComponent(Slot);
  };

  var shouldSpreadAdditionalProps$1 = shouldSpreadAdditionalProps;

  function getBadgeUtilityClass(slot) {
    return generateUtilityClass('MuiBadge', slot);
  }
  const badgeClasses = generateUtilityClasses('MuiBadge', ['root', 'badge', 'dot', 'standard', 'anchorOriginTopRight', 'anchorOriginBottomRight', 'anchorOriginTopLeft', 'anchorOriginBottomLeft', 'invisible', 'colorError', 'colorInfo', 'colorPrimary', 'colorSecondary', 'colorSuccess', 'colorWarning', 'overlapRectangular', 'overlapCircular', // TODO: v6 remove the overlap value from these class keys
  'anchorOriginTopLeftCircular', 'anchorOriginTopLeftRectangular', 'anchorOriginTopRightCircular', 'anchorOriginTopRightRectangular', 'anchorOriginBottomLeftCircular', 'anchorOriginBottomLeftRectangular', 'anchorOriginBottomRightCircular', 'anchorOriginBottomRightRectangular']);
  var badgeClasses$1 = badgeClasses;

  const _excluded$1I = ["anchorOrigin", "className", "component", "components", "componentsProps", "overlap", "color", "invisible", "max", "badgeContent", "showZero", "variant"];
  const RADIUS_STANDARD = 10;
  const RADIUS_DOT = 4;

  const useUtilityClasses$1r = ownerState => {
    const {
      color,
      anchorOrigin,
      invisible,
      overlap,
      variant,
      classes = {}
    } = ownerState;
    const slots = {
      root: ['root'],
      badge: ['badge', variant, invisible && 'invisible', `anchorOrigin${capitalize(anchorOrigin.vertical)}${capitalize(anchorOrigin.horizontal)}`, `anchorOrigin${capitalize(anchorOrigin.vertical)}${capitalize(anchorOrigin.horizontal)}${capitalize(overlap)}`, `overlap${capitalize(overlap)}`, color !== 'default' && `color${capitalize(color)}`]
    };
    return composeClasses(slots, getBadgeUtilityClass, classes);
  };

  const BadgeRoot = styled$1('span', {
    name: 'MuiBadge',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })({
    position: 'relative',
    display: 'inline-flex',
    // For correct alignment with the text.
    verticalAlign: 'middle',
    flexShrink: 0
  });
  const BadgeBadge = styled$1('span', {
    name: 'MuiBadge',
    slot: 'Badge',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.badge, styles[ownerState.variant], styles[`anchorOrigin${capitalize(ownerState.anchorOrigin.vertical)}${capitalize(ownerState.anchorOrigin.horizontal)}${capitalize(ownerState.overlap)}`], ownerState.color !== 'default' && styles[`color${capitalize(ownerState.color)}`], ownerState.invisible && styles.invisible];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    display: 'flex',
    flexDirection: 'row',
    flexWrap: 'wrap',
    justifyContent: 'center',
    alignContent: 'center',
    alignItems: 'center',
    position: 'absolute',
    boxSizing: 'border-box',
    fontFamily: theme.typography.fontFamily,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.pxToRem(12),
    minWidth: RADIUS_STANDARD * 2,
    lineHeight: 1,
    padding: '0 6px',
    height: RADIUS_STANDARD * 2,
    borderRadius: RADIUS_STANDARD,
    zIndex: 1,
    // Render the badge on top of potential ripples.
    transition: theme.transitions.create('transform', {
      easing: theme.transitions.easing.easeInOut,
      duration: theme.transitions.duration.enteringScreen
    })
  }, ownerState.color !== 'default' && {
    backgroundColor: (theme.vars || theme).palette[ownerState.color].main,
    color: (theme.vars || theme).palette[ownerState.color].contrastText
  }, ownerState.variant === 'dot' && {
    borderRadius: RADIUS_DOT,
    height: RADIUS_DOT * 2,
    minWidth: RADIUS_DOT * 2,
    padding: 0
  }, ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'rectangular' && {
    top: 0,
    right: 0,
    transform: 'scale(1) translate(50%, -50%)',
    transformOrigin: '100% 0%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(50%, -50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'rectangular' && {
    bottom: 0,
    right: 0,
    transform: 'scale(1) translate(50%, 50%)',
    transformOrigin: '100% 100%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(50%, 50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'rectangular' && {
    top: 0,
    left: 0,
    transform: 'scale(1) translate(-50%, -50%)',
    transformOrigin: '0% 0%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(-50%, -50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'rectangular' && {
    bottom: 0,
    left: 0,
    transform: 'scale(1) translate(-50%, 50%)',
    transformOrigin: '0% 100%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(-50%, 50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'circular' && {
    top: '14%',
    right: '14%',
    transform: 'scale(1) translate(50%, -50%)',
    transformOrigin: '100% 0%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(50%, -50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'circular' && {
    bottom: '14%',
    right: '14%',
    transform: 'scale(1) translate(50%, 50%)',
    transformOrigin: '100% 100%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(50%, 50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'circular' && {
    top: '14%',
    left: '14%',
    transform: 'scale(1) translate(-50%, -50%)',
    transformOrigin: '0% 0%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(-50%, -50%)'
    }
  }, ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'circular' && {
    bottom: '14%',
    left: '14%',
    transform: 'scale(1) translate(-50%, 50%)',
    transformOrigin: '0% 100%',
    [`&.${badgeClasses$1.invisible}`]: {
      transform: 'scale(0) translate(-50%, 50%)'
    }
  }, ownerState.invisible && {
    transition: theme.transitions.create('transform', {
      easing: theme.transitions.easing.easeInOut,
      duration: theme.transitions.duration.leavingScreen
    })
  }));
  const Badge = /*#__PURE__*/React__namespace.forwardRef(function Badge(inProps, ref) {
    var _componentsProps$root, _componentsProps$root2, _componentsProps$badg, _componentsProps$badg2;

    const props = useThemeProps({
      props: inProps,
      name: 'MuiBadge'
    });

    const {
      anchorOrigin: anchorOriginProp = {
        vertical: 'top',
        horizontal: 'right'
      },
      className,
      component = 'span',
      components = {},
      componentsProps = {},
      overlap: overlapProp = 'rectangular',
      color: colorProp = 'default',
      invisible: invisibleProp = false,
      max,
      badgeContent: badgeContentProp,
      showZero = false,
      variant: variantProp = 'standard'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1I);

    const prevProps = usePreviousProps$1({
      anchorOrigin: anchorOriginProp,
      color: colorProp,
      overlap: overlapProp,
      variant: variantProp
    });
    let invisible = invisibleProp;

    if (invisibleProp === false && (badgeContentProp === 0 && !showZero || badgeContentProp == null && variantProp !== 'dot')) {
      invisible = true;
    }

    const {
      color = colorProp,
      overlap = overlapProp,
      anchorOrigin = anchorOriginProp,
      variant = variantProp
    } = invisible ? prevProps : props;

    const ownerState = _extends({}, props, {
      anchorOrigin,
      invisible,
      color,
      overlap,
      variant
    });

    const classes = useUtilityClasses$1r(ownerState);
    let displayValue;

    if (variant !== 'dot') {
      displayValue = badgeContentProp && Number(badgeContentProp) > max ? `${max}+` : badgeContentProp;
    }

    return /*#__PURE__*/jsxRuntime_1(BadgeUnstyled$1, _extends({
      invisible: invisibleProp,
      badgeContent: displayValue,
      showZero: showZero,
      max: max
    }, other, {
      components: _extends({
        Root: BadgeRoot,
        Badge: BadgeBadge
      }, components),
      className: clsx(className, classes.root, (_componentsProps$root = componentsProps.root) == null ? void 0 : _componentsProps$root.className),
      componentsProps: {
        root: _extends({}, componentsProps.root, shouldSpreadAdditionalProps$1(components.Root) && {
          as: component,
          ownerState: _extends({}, (_componentsProps$root2 = componentsProps.root) == null ? void 0 : _componentsProps$root2.ownerState, {
            anchorOrigin,
            color,
            overlap,
            variant
          })
        }),
        badge: _extends({}, componentsProps.badge, {
          className: clsx(classes.badge, (_componentsProps$badg = componentsProps.badge) == null ? void 0 : _componentsProps$badg.className)
        }, shouldSpreadAdditionalProps$1(components.Badge) && {
          ownerState: _extends({}, (_componentsProps$badg2 = componentsProps.badge) == null ? void 0 : _componentsProps$badg2.ownerState, {
            anchorOrigin,
            color,
            overlap,
            variant
          })
        })
      },
      ref: ref
    }));
  });
  Badge.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The anchor of the badge.
     * @default {
     *   vertical: 'top',
     *   horizontal: 'right',
     * }
     */
    anchorOrigin: PropTypes.shape({
      horizontal: PropTypes.oneOf(['left', 'right']).isRequired,
      vertical: PropTypes.oneOf(['bottom', 'top']).isRequired
    }),

    /**
     * The content rendered within the badge.
     */
    badgeContent: PropTypes.node,

    /**
     * The badge will be added relative to this node.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'default'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The components used for each slot inside the Badge.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Badge: PropTypes.elementType,
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Badge.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      badge: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),

    /**
     * If `true`, the badge is invisible.
     * @default false
     */
    invisible: PropTypes.bool,

    /**
     * Max count to show.
     * @default 99
     */
    max: PropTypes.number,

    /**
     * Wrapped shape the badge should overlap.
     * @default 'rectangular'
     */
    overlap: PropTypes.oneOf(['circular', 'rectangular']),

    /**
     * Controls whether the badge is hidden when `badgeContent` is zero.
     * @default false
     */
    showZero: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The variant to use.
     * @default 'standard'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['dot', 'standard']), PropTypes.string])
  } ;
  var Badge$1 = Badge;

  function getBottomNavigationUtilityClass(slot) {
    return generateUtilityClass('MuiBottomNavigation', slot);
  }
  const bottomNavigationClasses = generateUtilityClasses('MuiBottomNavigation', ['root']);
  var bottomNavigationClasses$1 = bottomNavigationClasses;

  const _excluded$1H = ["children", "className", "component", "onChange", "showLabels", "value"];

  const useUtilityClasses$1q = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    return composeClasses(slots, getBottomNavigationUtilityClass, classes);
  };

  const BottomNavigationRoot = styled$1('div', {
    name: 'MuiBottomNavigation',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(({
    theme
  }) => ({
    display: 'flex',
    justifyContent: 'center',
    height: 56,
    backgroundColor: (theme.vars || theme).palette.background.paper
  }));
  const BottomNavigation = /*#__PURE__*/React__namespace.forwardRef(function BottomNavigation(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiBottomNavigation'
    });

    const {
      children,
      className,
      component = 'div',
      onChange,
      showLabels = false,
      value
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1H);

    const ownerState = _extends({}, props, {
      component,
      showLabels
    });

    const classes = useUtilityClasses$1q(ownerState);
    return /*#__PURE__*/jsxRuntime_1(BottomNavigationRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: React__namespace.Children.map(children, (child, childIndex) => {
        if (! /*#__PURE__*/React__namespace.isValidElement(child)) {
          return null;
        }

        {
          if (reactIs_2(child)) {
            console.error(["MUI: The BottomNavigation component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
          }
        }

        const childValue = child.props.value === undefined ? childIndex : child.props.value;
        return /*#__PURE__*/React__namespace.cloneElement(child, {
          selected: childValue === value,
          showLabel: child.props.showLabel !== undefined ? child.props.showLabel : showLabels,
          value: childValue,
          onChange
        });
      })
    }));
  });
  BottomNavigation.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * Callback fired when the value changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback. **Warning**: This is a generic event not a change event.
     * @param {any} value We default to the index of the child.
     */
    onChange: PropTypes.func,

    /**
     * If `true`, all `BottomNavigationAction`s will show their labels.
     * By default, only the selected `BottomNavigationAction` will show its label.
     * @default false
     */
    showLabels: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The value of the currently selected `BottomNavigationAction`.
     */
    value: PropTypes.any
  } ;
  var BottomNavigation$1 = BottomNavigation;

  function getBottomNavigationActionUtilityClass(slot) {
    return generateUtilityClass('MuiBottomNavigationAction', slot);
  }
  const bottomNavigationActionClasses = generateUtilityClasses('MuiBottomNavigationAction', ['root', 'iconOnly', 'selected', 'label']);
  var bottomNavigationActionClasses$1 = bottomNavigationActionClasses;

  const _excluded$1G = ["className", "icon", "label", "onChange", "onClick", "selected", "showLabel", "value"];

  const useUtilityClasses$1p = ownerState => {
    const {
      classes,
      showLabel,
      selected
    } = ownerState;
    const slots = {
      root: ['root', !showLabel && !selected && 'iconOnly', selected && 'selected'],
      label: ['label', !showLabel && !selected && 'iconOnly', selected && 'selected']
    };
    return composeClasses(slots, getBottomNavigationActionUtilityClass, classes);
  };

  const BottomNavigationActionRoot = styled$1(ButtonBase$1, {
    name: 'MuiBottomNavigationAction',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, !ownerState.showLabel && !ownerState.selected && styles.iconOnly];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    transition: theme.transitions.create(['color', 'padding-top'], {
      duration: theme.transitions.duration.short
    }),
    padding: '0px 12px',
    minWidth: 80,
    maxWidth: 168,
    color: (theme.vars || theme).palette.text.secondary,
    flexDirection: 'column',
    flex: '1'
  }, !ownerState.showLabel && !ownerState.selected && {
    paddingTop: 14
  }, !ownerState.showLabel && !ownerState.selected && !ownerState.label && {
    paddingTop: 0
  }, {
    [`&.${bottomNavigationActionClasses$1.selected}`]: {
      color: (theme.vars || theme).palette.primary.main
    }
  }));
  const BottomNavigationActionLabel = styled$1('span', {
    name: 'MuiBottomNavigationAction',
    slot: 'Label',
    overridesResolver: (props, styles) => styles.label
  })(({
    theme,
    ownerState
  }) => _extends({
    fontFamily: theme.typography.fontFamily,
    fontSize: theme.typography.pxToRem(12),
    opacity: 1,
    transition: 'font-size 0.2s, opacity 0.2s',
    transitionDelay: '0.1s'
  }, !ownerState.showLabel && !ownerState.selected && {
    opacity: 0,
    transitionDelay: '0s'
  }, {
    [`&.${bottomNavigationActionClasses$1.selected}`]: {
      fontSize: theme.typography.pxToRem(14)
    }
  }));
  const BottomNavigationAction = /*#__PURE__*/React__namespace.forwardRef(function BottomNavigationAction(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiBottomNavigationAction'
    });

    const {
      className,
      icon,
      label,
      onChange,
      onClick,
      value
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1G);

    const ownerState = props;
    const classes = useUtilityClasses$1p(ownerState);

    const handleChange = event => {
      if (onChange) {
        onChange(event, value);
      }

      if (onClick) {
        onClick(event);
      }
    };

    return /*#__PURE__*/jsxRuntime_2(BottomNavigationActionRoot, _extends({
      ref: ref,
      className: clsx(classes.root, className),
      focusRipple: true,
      onClick: handleChange,
      ownerState: ownerState
    }, other, {
      children: [icon, /*#__PURE__*/jsxRuntime_1(BottomNavigationActionLabel, {
        className: classes.label,
        ownerState: ownerState,
        children: label
      })]
    }));
  });
  BottomNavigationAction.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * This prop isn't supported.
     * Use the `component` prop if you need to change the children structure.
     */
    children: unsupportedProp,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The icon to display.
     */
    icon: PropTypes.node,

    /**
     * The label element.
     */
    label: PropTypes.node,

    /**
     * @ignore
     */
    onChange: PropTypes.func,

    /**
     * @ignore
     */
    onClick: PropTypes.func,

    /**
     * If `true`, the `BottomNavigationAction` will show its label.
     * By default, only the selected `BottomNavigationAction`
     * inside `BottomNavigation` will show its label.
     *
     * The prop defaults to the value (`false`) inherited from the parent BottomNavigation component.
     */
    showLabel: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * You can provide your own value. Otherwise, we fallback to the child position index.
     */
    value: PropTypes.any
  } ;
  var BottomNavigationAction$1 = BottomNavigationAction;

  const defaultTheme = createTheme();
  const Box = createBox({
    defaultTheme,
    defaultClassName: 'MuiBox-root',
    generateClassName: ClassNameGenerator$1.generate
  });
  Box.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * @ignore
     */
    children: PropTypes.node,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Box$1 = Box;

  var MoreHorizIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
  }), 'MoreHoriz');

  const BreadcrumbCollapsedButton = styled$1(ButtonBase$1)(({
    theme
  }) => _extends({
    display: 'flex',
    marginLeft: `calc(${theme.spacing(1)} * 0.5)`,
    marginRight: `calc(${theme.spacing(1)} * 0.5)`
  }, theme.palette.mode === 'light' ? {
    backgroundColor: theme.palette.grey[100],
    color: theme.palette.grey[700]
  } : {
    backgroundColor: theme.palette.grey[700],
    color: theme.palette.grey[100]
  }, {
    borderRadius: 2,
    '&:hover, &:focus': _extends({}, theme.palette.mode === 'light' ? {
      backgroundColor: theme.palette.grey[200]
    } : {
      backgroundColor: theme.palette.grey[600]
    }),
    '&:active': _extends({
      boxShadow: theme.shadows[0]
    }, theme.palette.mode === 'light' ? {
      backgroundColor: emphasize(theme.palette.grey[200], 0.12)
    } : {
      backgroundColor: emphasize(theme.palette.grey[600], 0.12)
    })
  }));
  const BreadcrumbCollapsedIcon = styled$1(MoreHorizIcon)({
    width: 24,
    height: 16
  });
  /**
   * @ignore - internal component.
   */

  function BreadcrumbCollapsed(props) {
    const ownerState = props;
    return /*#__PURE__*/jsxRuntime_1("li", {
      children: /*#__PURE__*/jsxRuntime_1(BreadcrumbCollapsedButton, _extends({
        focusRipple: true
      }, props, {
        ownerState: ownerState,
        children: /*#__PURE__*/jsxRuntime_1(BreadcrumbCollapsedIcon, {
          ownerState: ownerState
        })
      }))
    });
  }

  BreadcrumbCollapsed.propTypes = {
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.object
  } ;

  function getBreadcrumbsUtilityClass(slot) {
    return generateUtilityClass('MuiBreadcrumbs', slot);
  }
  const breadcrumbsClasses = generateUtilityClasses('MuiBreadcrumbs', ['root', 'ol', 'li', 'separator']);
  var breadcrumbsClasses$1 = breadcrumbsClasses;

  const _excluded$1F = ["children", "className", "component", "expandText", "itemsAfterCollapse", "itemsBeforeCollapse", "maxItems", "separator"];

  const useUtilityClasses$1o = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root'],
      li: ['li'],
      ol: ['ol'],
      separator: ['separator']
    };
    return composeClasses(slots, getBreadcrumbsUtilityClass, classes);
  };

  const BreadcrumbsRoot = styled$1(Typography$1, {
    name: 'MuiBreadcrumbs',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      return [{
        [`& .${breadcrumbsClasses$1.li}`]: styles.li
      }, styles.root];
    }
  })({});
  const BreadcrumbsOl = styled$1('ol', {
    name: 'MuiBreadcrumbs',
    slot: 'Ol',
    overridesResolver: (props, styles) => styles.ol
  })({
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center',
    padding: 0,
    margin: 0,
    listStyle: 'none'
  });
  const BreadcrumbsSeparator = styled$1('li', {
    name: 'MuiBreadcrumbs',
    slot: 'Separator',
    overridesResolver: (props, styles) => styles.separator
  })({
    display: 'flex',
    userSelect: 'none',
    marginLeft: 8,
    marginRight: 8
  });

  function insertSeparators(items, className, separator, ownerState) {
    return items.reduce((acc, current, index) => {
      if (index < items.length - 1) {
        acc = acc.concat(current, /*#__PURE__*/jsxRuntime_1(BreadcrumbsSeparator, {
          "aria-hidden": true,
          className: className,
          ownerState: ownerState,
          children: separator
        }, `separator-${index}`));
      } else {
        acc.push(current);
      }

      return acc;
    }, []);
  }

  const Breadcrumbs = /*#__PURE__*/React__namespace.forwardRef(function Breadcrumbs(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiBreadcrumbs'
    });

    const {
      children,
      className,
      component = 'nav',
      expandText = 'Show path',
      itemsAfterCollapse = 1,
      itemsBeforeCollapse = 1,
      maxItems = 8,
      separator = '/'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1F);

    const [expanded, setExpanded] = React__namespace.useState(false);

    const ownerState = _extends({}, props, {
      component,
      expanded,
      expandText,
      itemsAfterCollapse,
      itemsBeforeCollapse,
      maxItems,
      separator
    });

    const classes = useUtilityClasses$1o(ownerState);
    const listRef = React__namespace.useRef(null);

    const renderItemsBeforeAndAfter = allItems => {
      const handleClickExpand = () => {
        setExpanded(true); // The clicked element received the focus but gets removed from the DOM.
        // Let's keep the focus in the component after expanding.
        // Moving it to the <ol> or <nav> does not cause any announcement in NVDA.
        // By moving it to some link/button at least we have some announcement.

        const focusable = listRef.current.querySelector('a[href],button,[tabindex]');

        if (focusable) {
          focusable.focus();
        }
      }; // This defends against someone passing weird input, to ensure that if all
      // items would be shown anyway, we just show all items without the EllipsisItem


      if (itemsBeforeCollapse + itemsAfterCollapse >= allItems.length) {
        {
          console.error(['MUI: You have provided an invalid combination of props to the Breadcrumbs.', `itemsAfterCollapse={${itemsAfterCollapse}} + itemsBeforeCollapse={${itemsBeforeCollapse}} >= maxItems={${maxItems}}`].join('\n'));
        }

        return allItems;
      }

      return [...allItems.slice(0, itemsBeforeCollapse), /*#__PURE__*/jsxRuntime_1(BreadcrumbCollapsed, {
        "aria-label": expandText,
        onClick: handleClickExpand
      }, "ellipsis"), ...allItems.slice(allItems.length - itemsAfterCollapse, allItems.length)];
    };

    const allItems = React__namespace.Children.toArray(children).filter(child => {
      {
        if (reactIs_2(child)) {
          console.error(["MUI: The Breadcrumbs component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      return /*#__PURE__*/React__namespace.isValidElement(child);
    }).map((child, index) => /*#__PURE__*/jsxRuntime_1("li", {
      className: classes.li,
      children: child
    }, `child-${index}`));
    return /*#__PURE__*/jsxRuntime_1(BreadcrumbsRoot, _extends({
      ref: ref,
      component: component,
      color: "text.secondary",
      className: clsx(classes.root, className),
      ownerState: ownerState
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(BreadcrumbsOl, {
        className: classes.ol,
        ref: listRef,
        ownerState: ownerState,
        children: insertSeparators(expanded || maxItems && allItems.length <= maxItems ? allItems : renderItemsBeforeAndAfter(allItems), classes.separator, separator, ownerState)
      })
    }));
  });
  Breadcrumbs.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * Override the default label for the expand button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Show path'
     */
    expandText: PropTypes.string,

    /**
     * If max items is exceeded, the number of items to show after the ellipsis.
     * @default 1
     */
    itemsAfterCollapse: integerPropType,

    /**
     * If max items is exceeded, the number of items to show before the ellipsis.
     * @default 1
     */
    itemsBeforeCollapse: integerPropType,

    /**
     * Specifies the maximum number of breadcrumbs to display. When there are more
     * than the maximum number, only the first `itemsBeforeCollapse` and last `itemsAfterCollapse`
     * will be shown, with an ellipsis in between.
     * @default 8
     */
    maxItems: integerPropType,

    /**
     * Custom separator node.
     * @default '/'
     */
    separator: PropTypes.node,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Breadcrumbs$1 = Breadcrumbs;

  function getButtonUtilityClass(slot) {
    return generateUtilityClass('MuiButton', slot);
  }
  const buttonClasses = generateUtilityClasses('MuiButton', ['root', 'text', 'textInherit', 'textPrimary', 'textSecondary', 'textSuccess', 'textError', 'textInfo', 'textWarning', 'outlined', 'outlinedInherit', 'outlinedPrimary', 'outlinedSecondary', 'outlinedSuccess', 'outlinedError', 'outlinedInfo', 'outlinedWarning', 'contained', 'containedInherit', 'containedPrimary', 'containedSecondary', 'containedSuccess', 'containedError', 'containedInfo', 'containedWarning', 'disableElevation', 'focusVisible', 'disabled', 'colorInherit', 'textSizeSmall', 'textSizeMedium', 'textSizeLarge', 'outlinedSizeSmall', 'outlinedSizeMedium', 'outlinedSizeLarge', 'containedSizeSmall', 'containedSizeMedium', 'containedSizeLarge', 'sizeMedium', 'sizeSmall', 'sizeLarge', 'fullWidth', 'startIcon', 'endIcon', 'iconSizeSmall', 'iconSizeMedium', 'iconSizeLarge']);
  var buttonClasses$1 = buttonClasses;

  /**
   * @ignore - internal component.
   */
  const ButtonGroupContext = /*#__PURE__*/React__namespace.createContext({});

  {
    ButtonGroupContext.displayName = 'ButtonGroupContext';
  }

  var ButtonGroupContext$1 = ButtonGroupContext;

  const _excluded$1E = ["children", "color", "component", "className", "disabled", "disableElevation", "disableFocusRipple", "endIcon", "focusVisibleClassName", "fullWidth", "size", "startIcon", "type", "variant"];

  const useUtilityClasses$1n = ownerState => {
    const {
      color,
      disableElevation,
      fullWidth,
      size,
      variant,
      classes
    } = ownerState;
    const slots = {
      root: ['root', variant, `${variant}${capitalize(color)}`, `size${capitalize(size)}`, `${variant}Size${capitalize(size)}`, color === 'inherit' && 'colorInherit', disableElevation && 'disableElevation', fullWidth && 'fullWidth'],
      label: ['label'],
      startIcon: ['startIcon', `iconSize${capitalize(size)}`],
      endIcon: ['endIcon', `iconSize${capitalize(size)}`]
    };
    const composedClasses = composeClasses(slots, getButtonUtilityClass, classes);
    return _extends({}, classes, composedClasses);
  };

  const commonIconStyles = ownerState => _extends({}, ownerState.size === 'small' && {
    '& > *:nth-of-type(1)': {
      fontSize: 18
    }
  }, ownerState.size === 'medium' && {
    '& > *:nth-of-type(1)': {
      fontSize: 20
    }
  }, ownerState.size === 'large' && {
    '& > *:nth-of-type(1)': {
      fontSize: 22
    }
  });

  const ButtonRoot = styled$1(ButtonBase$1, {
    shouldForwardProp: prop => rootShouldForwardProp(prop) || prop === 'classes',
    name: 'MuiButton',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.variant], styles[`${ownerState.variant}${capitalize(ownerState.color)}`], styles[`size${capitalize(ownerState.size)}`], styles[`${ownerState.variant}Size${capitalize(ownerState.size)}`], ownerState.color === 'inherit' && styles.colorInherit, ownerState.disableElevation && styles.disableElevation, ownerState.fullWidth && styles.fullWidth];
    }
  })(({
    theme,
    ownerState
  }) => {
    var _theme$palette$getCon, _theme$palette;

    return _extends({}, theme.typography.button, {
      minWidth: 64,
      padding: '6px 16px',
      borderRadius: (theme.vars || theme).shape.borderRadius,
      transition: theme.transitions.create(['background-color', 'box-shadow', 'border-color', 'color'], {
        duration: theme.transitions.duration.short
      }),
      '&:hover': _extends({
        textDecoration: 'none',
        backgroundColor: theme.vars ? `rgba(${theme.vars.palette.text.primaryChannel} / ${theme.vars.palette.action.hoverOpacity})` : alpha(theme.palette.text.primary, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }, ownerState.variant === 'text' && ownerState.color !== 'inherit' && {
        backgroundColor: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / ${theme.vars.palette.action.hoverOpacity})` : alpha(theme.palette[ownerState.color].main, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }, ownerState.variant === 'outlined' && ownerState.color !== 'inherit' && {
        border: `1px solid ${(theme.vars || theme).palette[ownerState.color].main}`,
        backgroundColor: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / ${theme.vars.palette.action.hoverOpacity})` : alpha(theme.palette[ownerState.color].main, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }, ownerState.variant === 'contained' && {
        backgroundColor: (theme.vars || theme).palette.grey.A100,
        boxShadow: (theme.vars || theme).shadows[4],
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          boxShadow: (theme.vars || theme).shadows[2],
          backgroundColor: (theme.vars || theme).palette.grey[300]
        }
      }, ownerState.variant === 'contained' && ownerState.color !== 'inherit' && {
        backgroundColor: (theme.vars || theme).palette[ownerState.color].dark,
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: (theme.vars || theme).palette[ownerState.color].main
        }
      }),
      '&:active': _extends({}, ownerState.variant === 'contained' && {
        boxShadow: (theme.vars || theme).shadows[8]
      }),
      [`&.${buttonClasses$1.focusVisible}`]: _extends({}, ownerState.variant === 'contained' && {
        boxShadow: (theme.vars || theme).shadows[6]
      }),
      [`&.${buttonClasses$1.disabled}`]: _extends({
        color: (theme.vars || theme).palette.action.disabled
      }, ownerState.variant === 'outlined' && {
        border: `1px solid ${(theme.vars || theme).palette.action.disabledBackground}`
      }, ownerState.variant === 'outlined' && ownerState.color === 'secondary' && {
        border: `1px solid ${(theme.vars || theme).palette.action.disabled}`
      }, ownerState.variant === 'contained' && {
        color: (theme.vars || theme).palette.action.disabled,
        boxShadow: (theme.vars || theme).shadows[0],
        backgroundColor: (theme.vars || theme).palette.action.disabledBackground
      })
    }, ownerState.variant === 'text' && {
      padding: '6px 8px'
    }, ownerState.variant === 'text' && ownerState.color !== 'inherit' && {
      color: (theme.vars || theme).palette[ownerState.color].main
    }, ownerState.variant === 'outlined' && {
      padding: '5px 15px',
      border: '1px solid currentColor'
    }, ownerState.variant === 'outlined' && ownerState.color !== 'inherit' && {
      color: (theme.vars || theme).palette[ownerState.color].main,
      border: theme.vars ? `1px solid rgba(${theme.vars.palette[ownerState.color].mainChannel} / 0.5)` : `1px solid ${alpha(theme.palette[ownerState.color].main, 0.5)}`
    }, ownerState.variant === 'contained' && {
      color: theme.vars ? // this is safe because grey does not change between default light/dark mode
      theme.vars.palette.text.primary : (_theme$palette$getCon = (_theme$palette = theme.palette).getContrastText) == null ? void 0 : _theme$palette$getCon.call(_theme$palette, theme.palette.grey[300]),
      backgroundColor: (theme.vars || theme).palette.grey[300],
      boxShadow: (theme.vars || theme).shadows[2]
    }, ownerState.variant === 'contained' && ownerState.color !== 'inherit' && {
      color: (theme.vars || theme).palette[ownerState.color].contrastText,
      backgroundColor: (theme.vars || theme).palette[ownerState.color].main
    }, ownerState.color === 'inherit' && {
      color: 'inherit',
      borderColor: 'currentColor'
    }, ownerState.size === 'small' && ownerState.variant === 'text' && {
      padding: '4px 5px',
      fontSize: theme.typography.pxToRem(13)
    }, ownerState.size === 'large' && ownerState.variant === 'text' && {
      padding: '8px 11px',
      fontSize: theme.typography.pxToRem(15)
    }, ownerState.size === 'small' && ownerState.variant === 'outlined' && {
      padding: '3px 9px',
      fontSize: theme.typography.pxToRem(13)
    }, ownerState.size === 'large' && ownerState.variant === 'outlined' && {
      padding: '7px 21px',
      fontSize: theme.typography.pxToRem(15)
    }, ownerState.size === 'small' && ownerState.variant === 'contained' && {
      padding: '4px 10px',
      fontSize: theme.typography.pxToRem(13)
    }, ownerState.size === 'large' && ownerState.variant === 'contained' && {
      padding: '8px 22px',
      fontSize: theme.typography.pxToRem(15)
    }, ownerState.fullWidth && {
      width: '100%'
    });
  }, ({
    ownerState
  }) => ownerState.disableElevation && {
    boxShadow: 'none',
    '&:hover': {
      boxShadow: 'none'
    },
    [`&.${buttonClasses$1.focusVisible}`]: {
      boxShadow: 'none'
    },
    '&:active': {
      boxShadow: 'none'
    },
    [`&.${buttonClasses$1.disabled}`]: {
      boxShadow: 'none'
    }
  });
  const ButtonStartIcon = styled$1('span', {
    name: 'MuiButton',
    slot: 'StartIcon',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.startIcon, styles[`iconSize${capitalize(ownerState.size)}`]];
    }
  })(({
    ownerState
  }) => _extends({
    display: 'inherit',
    marginRight: 8,
    marginLeft: -4
  }, ownerState.size === 'small' && {
    marginLeft: -2
  }, commonIconStyles(ownerState)));
  const ButtonEndIcon = styled$1('span', {
    name: 'MuiButton',
    slot: 'EndIcon',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.endIcon, styles[`iconSize${capitalize(ownerState.size)}`]];
    }
  })(({
    ownerState
  }) => _extends({
    display: 'inherit',
    marginRight: -4,
    marginLeft: 8
  }, ownerState.size === 'small' && {
    marginRight: -2
  }, commonIconStyles(ownerState)));
  const Button = /*#__PURE__*/React__namespace.forwardRef(function Button(inProps, ref) {
    // props priority: `inProps` > `contextProps` > `themeDefaultProps`
    const contextProps = React__namespace.useContext(ButtonGroupContext$1);
    const resolvedProps = resolveProps(contextProps, inProps);
    const props = useThemeProps({
      props: resolvedProps,
      name: 'MuiButton'
    });

    const {
      children,
      color = 'primary',
      component = 'button',
      className,
      disabled = false,
      disableElevation = false,
      disableFocusRipple = false,
      endIcon: endIconProp,
      focusVisibleClassName,
      fullWidth = false,
      size = 'medium',
      startIcon: startIconProp,
      type,
      variant = 'text'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1E);

    const ownerState = _extends({}, props, {
      color,
      component,
      disabled,
      disableElevation,
      disableFocusRipple,
      fullWidth,
      size,
      type,
      variant
    });

    const classes = useUtilityClasses$1n(ownerState);

    const startIcon = startIconProp && /*#__PURE__*/jsxRuntime_1(ButtonStartIcon, {
      className: classes.startIcon,
      ownerState: ownerState,
      children: startIconProp
    });

    const endIcon = endIconProp && /*#__PURE__*/jsxRuntime_1(ButtonEndIcon, {
      className: classes.endIcon,
      ownerState: ownerState,
      children: endIconProp
    });

    return /*#__PURE__*/jsxRuntime_2(ButtonRoot, _extends({
      ownerState: ownerState,
      className: clsx(className, contextProps.className),
      component: component,
      disabled: disabled,
      focusRipple: !disableFocusRipple,
      focusVisibleClassName: clsx(classes.focusVisible, focusVisibleClassName),
      ref: ref,
      type: type
    }, other, {
      classes: classes,
      children: [startIcon, children, endIcon]
    }));
  });
  Button.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'primary'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['inherit', 'primary', 'secondary', 'success', 'error', 'info', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, no elevation is used.
     * @default false
     */
    disableElevation: PropTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple is disabled.
     * @default false
     */
    disableFocusRipple: PropTypes.bool,

    /**
     * If `true`, the ripple effect is disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `.Mui-focusVisible` class.
     * @default false
     */
    disableRipple: PropTypes.bool,

    /**
     * Element placed after the children.
     */
    endIcon: PropTypes.node,

    /**
     * @ignore
     */
    focusVisibleClassName: PropTypes.string,

    /**
     * If `true`, the button will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,

    /**
     * The URL to link to when the button is clicked.
     * If defined, an `a` element will be used as the root node.
     */
    href: PropTypes.string,

    /**
     * The size of the component.
     * `small` is equivalent to the dense button styling.
     * @default 'medium'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['small', 'medium', 'large']), PropTypes.string]),

    /**
     * Element placed before the children.
     */
    startIcon: PropTypes.node,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * @ignore
     */
    type: PropTypes.oneOfType([PropTypes.oneOf(['button', 'reset', 'submit']), PropTypes.string]),

    /**
     * The variant to use.
     * @default 'text'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['contained', 'outlined', 'text']), PropTypes.string])
  } ;
  var Button$1 = Button;

  function getButtonGroupUtilityClass(slot) {
    return generateUtilityClass('MuiButtonGroup', slot);
  }
  const buttonGroupClasses = generateUtilityClasses('MuiButtonGroup', ['root', 'contained', 'outlined', 'text', 'disableElevation', 'disabled', 'fullWidth', 'vertical', 'grouped', 'groupedHorizontal', 'groupedVertical', 'groupedText', 'groupedTextHorizontal', 'groupedTextVertical', 'groupedTextPrimary', 'groupedTextSecondary', 'groupedOutlined', 'groupedOutlinedHorizontal', 'groupedOutlinedVertical', 'groupedOutlinedPrimary', 'groupedOutlinedSecondary', 'groupedContained', 'groupedContainedHorizontal', 'groupedContainedVertical', 'groupedContainedPrimary', 'groupedContainedSecondary']);
  var buttonGroupClasses$1 = buttonGroupClasses;

  const _excluded$1D = ["children", "className", "color", "component", "disabled", "disableElevation", "disableFocusRipple", "disableRipple", "fullWidth", "orientation", "size", "variant"];

  const overridesResolver$6 = (props, styles) => {
    const {
      ownerState
    } = props;
    return [{
      [`& .${buttonGroupClasses$1.grouped}`]: styles.grouped
    }, {
      [`& .${buttonGroupClasses$1.grouped}`]: styles[`grouped${capitalize(ownerState.orientation)}`]
    }, {
      [`& .${buttonGroupClasses$1.grouped}`]: styles[`grouped${capitalize(ownerState.variant)}`]
    }, {
      [`& .${buttonGroupClasses$1.grouped}`]: styles[`grouped${capitalize(ownerState.variant)}${capitalize(ownerState.orientation)}`]
    }, {
      [`& .${buttonGroupClasses$1.grouped}`]: styles[`grouped${capitalize(ownerState.variant)}${capitalize(ownerState.color)}`]
    }, styles.root, styles[ownerState.variant], ownerState.disableElevation === true && styles.disableElevation, ownerState.fullWidth && styles.fullWidth, ownerState.orientation === 'vertical' && styles.vertical];
  };

  const useUtilityClasses$1m = ownerState => {
    const {
      classes,
      color,
      disabled,
      disableElevation,
      fullWidth,
      orientation,
      variant
    } = ownerState;
    const slots = {
      root: ['root', variant, orientation === 'vertical' && 'vertical', fullWidth && 'fullWidth', disableElevation && 'disableElevation'],
      grouped: ['grouped', `grouped${capitalize(orientation)}`, `grouped${capitalize(variant)}`, `grouped${capitalize(variant)}${capitalize(orientation)}`, `grouped${capitalize(variant)}${capitalize(color)}`, disabled && 'disabled']
    };
    return composeClasses(slots, getButtonGroupUtilityClass, classes);
  };

  const ButtonGroupRoot = styled$1('div', {
    name: 'MuiButtonGroup',
    slot: 'Root',
    overridesResolver: overridesResolver$6
  })(({
    theme,
    ownerState
  }) => _extends({
    display: 'inline-flex',
    borderRadius: (theme.vars || theme).shape.borderRadius
  }, ownerState.variant === 'contained' && {
    boxShadow: (theme.vars || theme).shadows[2]
  }, ownerState.disableElevation && {
    boxShadow: 'none'
  }, ownerState.fullWidth && {
    width: '100%'
  }, ownerState.orientation === 'vertical' && {
    flexDirection: 'column'
  }, {
    [`& .${buttonGroupClasses$1.grouped}`]: _extends({
      minWidth: 40,
      '&:not(:first-of-type)': _extends({}, ownerState.orientation === 'horizontal' && {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0
      }, ownerState.orientation === 'vertical' && {
        borderTopRightRadius: 0,
        borderTopLeftRadius: 0
      }, ownerState.variant === 'outlined' && ownerState.orientation === 'horizontal' && {
        marginLeft: -1
      }, ownerState.variant === 'outlined' && ownerState.orientation === 'vertical' && {
        marginTop: -1
      }),
      '&:not(:last-of-type)': _extends({}, ownerState.orientation === 'horizontal' && {
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0
      }, ownerState.orientation === 'vertical' && {
        borderBottomRightRadius: 0,
        borderBottomLeftRadius: 0
      }, ownerState.variant === 'text' && ownerState.orientation === 'horizontal' && {
        borderRight: theme.vars ? `1px solid rgba(${theme.vars.palette.common.onBackgroundChannel} / 0.23)` : `1px solid ${theme.palette.mode === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'}`
      }, ownerState.variant === 'text' && ownerState.orientation === 'vertical' && {
        borderBottom: theme.vars ? `1px solid rgba(${theme.vars.palette.common.onBackgroundChannel} / 0.23)` : `1px solid ${theme.palette.mode === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'}`
      }, ownerState.variant === 'text' && ownerState.color !== 'inherit' && {
        borderColor: theme.vars ? `rgba(${theme.vars.palette[ownerState.color].mainChannel} / 0.5)` : alpha(theme.palette[ownerState.color].main, 0.5)
      }, ownerState.variant === 'outlined' && ownerState.orientation === 'horizontal' && {
        borderRightColor: 'transparent'
      }, ownerState.variant === 'outlined' && ownerState.orientation === 'vertical' && {
        borderBottomColor: 'transparent'
      }, ownerState.variant === 'contained' && ownerState.orientation === 'horizontal' && {
        borderRight: `1px solid ${(theme.vars || theme).palette.grey[400]}`,
        [`&.${buttonGroupClasses$1.disabled}`]: {
          borderRight: `1px solid ${(theme.vars || theme).palette.action.disabled}`
        }
      }, ownerState.variant === 'contained' && ownerState.orientation === 'vertical' && {
        borderBottom: `1px solid ${(theme.vars || theme).palette.grey[400]}`,
        [`&.${buttonGroupClasses$1.disabled}`]: {
          borderBottom: `1px solid ${(theme.vars || theme).palette.action.disabled}`
        }
      }, ownerState.variant === 'contained' && ownerState.color !== 'inherit' && {
        borderColor: (theme.vars || theme).palette[ownerState.color].dark
      }, {
        '&:hover': _extends({}, ownerState.variant === 'outlined' && ownerState.orientation === 'horizontal' && {
          borderRightColor: 'currentColor'
        }, ownerState.variant === 'outlined' && ownerState.orientation === 'vertical' && {
          borderBottomColor: 'currentColor'
        })
      }),
      '&:hover': _extends({}, ownerState.variant === 'contained' && {
        boxShadow: 'none'
      })
    }, ownerState.variant === 'contained' && {
      boxShadow: 'none'
    })
  }));
  const ButtonGroup = /*#__PURE__*/React__namespace.forwardRef(function ButtonGroup(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiButtonGroup'
    });

    const {
      children,
      className,
      color = 'primary',
      component = 'div',
      disabled = false,
      disableElevation = false,
      disableFocusRipple = false,
      disableRipple = false,
      fullWidth = false,
      orientation = 'horizontal',
      size = 'medium',
      variant = 'outlined'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1D);

    const ownerState = _extends({}, props, {
      color,
      component,
      disabled,
      disableElevation,
      disableFocusRipple,
      disableRipple,
      fullWidth,
      orientation,
      size,
      variant
    });

    const classes = useUtilityClasses$1m(ownerState);
    const context = React__namespace.useMemo(() => ({
      className: classes.grouped,
      color,
      disabled,
      disableElevation,
      disableFocusRipple,
      disableRipple,
      fullWidth,
      size,
      variant
    }), [color, disabled, disableElevation, disableFocusRipple, disableRipple, fullWidth, size, variant, classes.grouped]);
    return /*#__PURE__*/jsxRuntime_1(ButtonGroupRoot, _extends({
      as: component,
      role: "group",
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(ButtonGroupContext$1.Provider, {
        value: context,
        children: children
      })
    }));
  });
  ButtonGroup.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'primary'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['inherit', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, no elevation is used.
     * @default false
     */
    disableElevation: PropTypes.bool,

    /**
     * If `true`, the button keyboard focus ripple is disabled.
     * @default false
     */
    disableFocusRipple: PropTypes.bool,

    /**
     * If `true`, the button ripple effect is disabled.
     * @default false
     */
    disableRipple: PropTypes.bool,

    /**
     * If `true`, the buttons will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,

    /**
     * The component orientation (layout flow direction).
     * @default 'horizontal'
     */
    orientation: PropTypes.oneOf(['horizontal', 'vertical']),

    /**
     * The size of the component.
     * `small` is equivalent to the dense button styling.
     * @default 'medium'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['small', 'medium', 'large']), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The variant to use.
     * @default 'outlined'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['contained', 'outlined', 'text']), PropTypes.string])
  } ;
  var ButtonGroup$1 = ButtonGroup;

  function getCardUtilityClass(slot) {
    return generateUtilityClass('MuiCard', slot);
  }
  const cardClasses = generateUtilityClasses('MuiCard', ['root']);
  var cardClasses$1 = cardClasses;

  const _excluded$1C = ["className", "raised"];

  const useUtilityClasses$1l = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    return composeClasses(slots, getCardUtilityClass, classes);
  };

  const CardRoot = styled$1(Paper$1, {
    name: 'MuiCard',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(() => {
    return {
      overflow: 'hidden'
    };
  });
  const Card = /*#__PURE__*/React__namespace.forwardRef(function Card(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCard'
    });

    const {
      className,
      raised = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1C);

    const ownerState = _extends({}, props, {
      raised
    });

    const classes = useUtilityClasses$1l(ownerState);
    return /*#__PURE__*/jsxRuntime_1(CardRoot, _extends({
      className: clsx(classes.root, className),
      elevation: raised ? 8 : undefined,
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  Card.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, the card will use raised styling.
     * @default false
     */
    raised: chainPropTypes(PropTypes.bool, props => {
      if (props.raised && props.variant === 'outlined') {
        return new Error('MUI: Combining `raised={true}` with `variant="outlined"` has no effect.');
      }

      return null;
    }),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Card$1 = Card;

  function getCardActionAreaUtilityClass(slot) {
    return generateUtilityClass('MuiCardActionArea', slot);
  }
  const cardActionAreaClasses = generateUtilityClasses('MuiCardActionArea', ['root', 'focusVisible', 'focusHighlight']);
  var cardActionAreaClasses$1 = cardActionAreaClasses;

  const _excluded$1B = ["children", "className", "focusVisibleClassName"];

  const useUtilityClasses$1k = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root'],
      focusHighlight: ['focusHighlight']
    };
    return composeClasses(slots, getCardActionAreaUtilityClass, classes);
  };

  const CardActionAreaRoot = styled$1(ButtonBase$1, {
    name: 'MuiCardActionArea',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(({
    theme
  }) => ({
    display: 'block',
    textAlign: 'inherit',
    width: '100%',
    [`&:hover .${cardActionAreaClasses$1.focusHighlight}`]: {
      opacity: (theme.vars || theme).palette.action.hoverOpacity,
      '@media (hover: none)': {
        opacity: 0
      }
    },
    [`&.${cardActionAreaClasses$1.focusVisible} .${cardActionAreaClasses$1.focusHighlight}`]: {
      opacity: (theme.vars || theme).palette.action.focusOpacity
    }
  }));
  const CardActionAreaFocusHighlight = styled$1('span', {
    name: 'MuiCardActionArea',
    slot: 'FocusHighlight',
    overridesResolver: (props, styles) => styles.focusHighlight
  })(({
    theme
  }) => ({
    overflow: 'hidden',
    pointerEvents: 'none',
    position: 'absolute',
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    borderRadius: 'inherit',
    opacity: 0,
    backgroundColor: 'currentcolor',
    transition: theme.transitions.create('opacity', {
      duration: theme.transitions.duration.short
    })
  }));
  const CardActionArea = /*#__PURE__*/React__namespace.forwardRef(function CardActionArea(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCardActionArea'
    });

    const {
      children,
      className,
      focusVisibleClassName
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1B);

    const ownerState = props;
    const classes = useUtilityClasses$1k(ownerState);
    return /*#__PURE__*/jsxRuntime_2(CardActionAreaRoot, _extends({
      className: clsx(classes.root, className),
      focusVisibleClassName: clsx(focusVisibleClassName, classes.focusVisible),
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: [children, /*#__PURE__*/jsxRuntime_1(CardActionAreaFocusHighlight, {
        className: classes.focusHighlight,
        ownerState: ownerState
      })]
    }));
  });
  CardActionArea.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * @ignore
     */
    focusVisibleClassName: PropTypes.string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var CardActionArea$1 = CardActionArea;

  function getCardActionsUtilityClass(slot) {
    return generateUtilityClass('MuiCardActions', slot);
  }
  const cardActionsClasses = generateUtilityClasses('MuiCardActions', ['root', 'spacing']);
  var cardActionsClasses$1 = cardActionsClasses;

  const _excluded$1A = ["disableSpacing", "className"];

  const useUtilityClasses$1j = ownerState => {
    const {
      classes,
      disableSpacing
    } = ownerState;
    const slots = {
      root: ['root', !disableSpacing && 'spacing']
    };
    return composeClasses(slots, getCardActionsUtilityClass, classes);
  };

  const CardActionsRoot = styled$1('div', {
    name: 'MuiCardActions',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, !ownerState.disableSpacing && styles.spacing];
    }
  })(({
    ownerState
  }) => _extends({
    display: 'flex',
    alignItems: 'center',
    padding: 8
  }, !ownerState.disableSpacing && {
    '& > :not(:first-of-type)': {
      marginLeft: 8
    }
  }));
  const CardActions = /*#__PURE__*/React__namespace.forwardRef(function CardActions(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCardActions'
    });

    const {
      disableSpacing = false,
      className
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1A);

    const ownerState = _extends({}, props, {
      disableSpacing
    });

    const classes = useUtilityClasses$1j(ownerState);
    return /*#__PURE__*/jsxRuntime_1(CardActionsRoot, _extends({
      className: clsx(classes.root, className),
      ownerState: ownerState,
      ref: ref
    }, other));
  });
  CardActions.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, the actions do not have additional margin.
     * @default false
     */
    disableSpacing: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var CardActions$1 = CardActions;

  function getCardContentUtilityClass(slot) {
    return generateUtilityClass('MuiCardContent', slot);
  }
  const cardContentClasses = generateUtilityClasses('MuiCardContent', ['root']);
  var cardContentClasses$1 = cardContentClasses;

  const _excluded$1z = ["className", "component"];

  const useUtilityClasses$1i = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    return composeClasses(slots, getCardContentUtilityClass, classes);
  };

  const CardContentRoot = styled$1('div', {
    name: 'MuiCardContent',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })(() => {
    return {
      padding: 16,
      '&:last-child': {
        paddingBottom: 24
      }
    };
  });
  const CardContent = /*#__PURE__*/React__namespace.forwardRef(function CardContent(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCardContent'
    });

    const {
      className,
      component = 'div'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1z);

    const ownerState = _extends({}, props, {
      component
    });

    const classes = useUtilityClasses$1i(ownerState);
    return /*#__PURE__*/jsxRuntime_1(CardContentRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      ownerState: ownerState,
      ref: ref
    }, other));
  });
  CardContent.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var CardContent$1 = CardContent;

  function getCardHeaderUtilityClass(slot) {
    return generateUtilityClass('MuiCardHeader', slot);
  }
  const cardHeaderClasses = generateUtilityClasses('MuiCardHeader', ['root', 'avatar', 'action', 'content', 'title', 'subheader']);
  var cardHeaderClasses$1 = cardHeaderClasses;

  const _excluded$1y = ["action", "avatar", "className", "component", "disableTypography", "subheader", "subheaderTypographyProps", "title", "titleTypographyProps"];

  const useUtilityClasses$1h = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root'],
      avatar: ['avatar'],
      action: ['action'],
      content: ['content'],
      title: ['title'],
      subheader: ['subheader']
    };
    return composeClasses(slots, getCardHeaderUtilityClass, classes);
  };

  const CardHeaderRoot = styled$1('div', {
    name: 'MuiCardHeader',
    slot: 'Root',
    overridesResolver: (props, styles) => _extends({
      [`& .${cardHeaderClasses$1.title}`]: styles.title,
      [`& .${cardHeaderClasses$1.subheader}`]: styles.subheader
    }, styles.root)
  })({
    display: 'flex',
    alignItems: 'center',
    padding: 16
  });
  const CardHeaderAvatar = styled$1('div', {
    name: 'MuiCardHeader',
    slot: 'Avatar',
    overridesResolver: (props, styles) => styles.avatar
  })({
    display: 'flex',
    flex: '0 0 auto',
    marginRight: 16
  });
  const CardHeaderAction = styled$1('div', {
    name: 'MuiCardHeader',
    slot: 'Action',
    overridesResolver: (props, styles) => styles.action
  })({
    flex: '0 0 auto',
    alignSelf: 'flex-start',
    marginTop: -4,
    marginRight: -8,
    marginBottom: -4
  });
  const CardHeaderContent = styled$1('div', {
    name: 'MuiCardHeader',
    slot: 'Content',
    overridesResolver: (props, styles) => styles.content
  })({
    flex: '1 1 auto'
  });
  const CardHeader = /*#__PURE__*/React__namespace.forwardRef(function CardHeader(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCardHeader'
    });

    const {
      action,
      avatar,
      className,
      component = 'div',
      disableTypography = false,
      subheader: subheaderProp,
      subheaderTypographyProps,
      title: titleProp,
      titleTypographyProps
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1y);

    const ownerState = _extends({}, props, {
      component,
      disableTypography
    });

    const classes = useUtilityClasses$1h(ownerState);
    let title = titleProp;

    if (title != null && title.type !== Typography$1 && !disableTypography) {
      title = /*#__PURE__*/jsxRuntime_1(Typography$1, _extends({
        variant: avatar ? 'body2' : 'h5',
        className: classes.title,
        component: "span",
        display: "block"
      }, titleTypographyProps, {
        children: title
      }));
    }

    let subheader = subheaderProp;

    if (subheader != null && subheader.type !== Typography$1 && !disableTypography) {
      subheader = /*#__PURE__*/jsxRuntime_1(Typography$1, _extends({
        variant: avatar ? 'body2' : 'body1',
        className: classes.subheader,
        color: "text.secondary",
        component: "span",
        display: "block"
      }, subheaderTypographyProps, {
        children: subheader
      }));
    }

    return /*#__PURE__*/jsxRuntime_2(CardHeaderRoot, _extends({
      className: clsx(classes.root, className),
      as: component,
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: [avatar && /*#__PURE__*/jsxRuntime_1(CardHeaderAvatar, {
        className: classes.avatar,
        ownerState: ownerState,
        children: avatar
      }), /*#__PURE__*/jsxRuntime_2(CardHeaderContent, {
        className: classes.content,
        ownerState: ownerState,
        children: [title, subheader]
      }), action && /*#__PURE__*/jsxRuntime_1(CardHeaderAction, {
        className: classes.action,
        ownerState: ownerState,
        children: action
      })]
    }));
  });
  CardHeader.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The action to display in the card header.
     */
    action: PropTypes.node,

    /**
     * The Avatar element to display.
     */
    avatar: PropTypes.node,

    /**
     * @ignore
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes
    /* @typescript-to-proptypes-ignore */
    .elementType,

    /**
     * If `true`, `subheader` and `title` won't be wrapped by a Typography component.
     * This can be useful to render an alternative Typography variant by wrapping
     * the `title` text, and optional `subheader` text
     * with the Typography component.
     * @default false
     */
    disableTypography: PropTypes.bool,

    /**
     * The content of the component.
     */
    subheader: PropTypes.node,

    /**
     * These props will be forwarded to the subheader
     * (as long as disableTypography is not `true`).
     */
    subheaderTypographyProps: PropTypes.object,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The content of the component.
     */
    title: PropTypes.node,

    /**
     * These props will be forwarded to the title
     * (as long as disableTypography is not `true`).
     */
    titleTypographyProps: PropTypes.object
  } ;
  var CardHeader$1 = CardHeader;

  function getCardMediaUtilityClass(slot) {
    return generateUtilityClass('MuiCardMedia', slot);
  }
  const cardMediaClasses = generateUtilityClasses('MuiCardMedia', ['root', 'media', 'img']);
  var cardMediaClasses$1 = cardMediaClasses;

  const _excluded$1x = ["children", "className", "component", "image", "src", "style"];

  const useUtilityClasses$1g = ownerState => {
    const {
      classes,
      isMediaComponent,
      isImageComponent
    } = ownerState;
    const slots = {
      root: ['root', isMediaComponent && 'media', isImageComponent && 'img']
    };
    return composeClasses(slots, getCardMediaUtilityClass, classes);
  };

  const CardMediaRoot = styled$1('div', {
    name: 'MuiCardMedia',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      const {
        isMediaComponent,
        isImageComponent
      } = ownerState;
      return [styles.root, isMediaComponent && styles.media, isImageComponent && styles.img];
    }
  })(({
    ownerState
  }) => _extends({
    display: 'block',
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    backgroundPosition: 'center'
  }, ownerState.isMediaComponent && {
    width: '100%'
  }, ownerState.isImageComponent && {
    // ⚠️ object-fit is not supported by IE11.
    objectFit: 'cover'
  }));
  const MEDIA_COMPONENTS = ['video', 'audio', 'picture', 'iframe', 'img'];
  const IMAGE_COMPONENTS = ['picture', 'img'];
  const CardMedia = /*#__PURE__*/React__namespace.forwardRef(function CardMedia(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCardMedia'
    });

    const {
      children,
      className,
      component = 'div',
      image,
      src,
      style
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1x);

    const isMediaComponent = MEDIA_COMPONENTS.indexOf(component) !== -1;
    const composedStyle = !isMediaComponent && image ? _extends({
      backgroundImage: `url("${image}")`
    }, style) : style;

    const ownerState = _extends({}, props, {
      component,
      isMediaComponent,
      isImageComponent: IMAGE_COMPONENTS.indexOf(component) !== -1
    });

    const classes = useUtilityClasses$1g(ownerState);
    return /*#__PURE__*/jsxRuntime_1(CardMediaRoot, _extends({
      className: clsx(classes.root, className),
      as: component,
      role: !isMediaComponent && image ? 'img' : undefined,
      ref: ref,
      style: composedStyle,
      ownerState: ownerState,
      src: isMediaComponent ? image || src : undefined
    }, other, {
      children: children
    }));
  });
  CardMedia.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: chainPropTypes(PropTypes.node, props => {
      if (!props.children && !props.image && !props.src && !props.component) {
        return new Error('MUI: Either `children`, `image`, `src` or `component` prop must be specified.');
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * Image to be displayed as a background image.
     * Either `image` or `src` prop must be specified.
     * Note that caller must specify height otherwise the image will not be visible.
     */
    image: PropTypes.string,

    /**
     * An alias for `image` property.
     * Available only with media components.
     * Media components: `video`, `audio`, `picture`, `iframe`, `img`.
     */
    src: PropTypes.string,

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var CardMedia$1 = CardMedia;

  function getSwitchBaseUtilityClass(slot) {
    return generateUtilityClass('PrivateSwitchBase', slot);
  }
  generateUtilityClasses('PrivateSwitchBase', ['root', 'checked', 'disabled', 'input', 'edgeStart', 'edgeEnd']);

  const _excluded$1w = ["autoFocus", "checked", "checkedIcon", "className", "defaultChecked", "disabled", "disableFocusRipple", "edge", "icon", "id", "inputProps", "inputRef", "name", "onBlur", "onChange", "onFocus", "readOnly", "required", "tabIndex", "type", "value"];

  const useUtilityClasses$1f = ownerState => {
    const {
      classes,
      checked,
      disabled,
      edge
    } = ownerState;
    const slots = {
      root: ['root', checked && 'checked', disabled && 'disabled', edge && `edge${capitalize(edge)}`],
      input: ['input']
    };
    return composeClasses(slots, getSwitchBaseUtilityClass, classes);
  };

  const SwitchBaseRoot = styled$1(ButtonBase$1)(({
    ownerState
  }) => _extends({
    padding: 9,
    borderRadius: '50%'
  }, ownerState.edge === 'start' && {
    marginLeft: ownerState.size === 'small' ? -3 : -12
  }, ownerState.edge === 'end' && {
    marginRight: ownerState.size === 'small' ? -3 : -12
  }));
  const SwitchBaseInput = styled$1('input')({
    cursor: 'inherit',
    position: 'absolute',
    opacity: 0,
    width: '100%',
    height: '100%',
    top: 0,
    left: 0,
    margin: 0,
    padding: 0,
    zIndex: 1
  });
  /**
   * @ignore - internal component.
   */

  const SwitchBase = /*#__PURE__*/React__namespace.forwardRef(function SwitchBase(props, ref) {
    const {
      autoFocus,
      checked: checkedProp,
      checkedIcon,
      className,
      defaultChecked,
      disabled: disabledProp,
      disableFocusRipple = false,
      edge = false,
      icon,
      id,
      inputProps,
      inputRef,
      name,
      onBlur,
      onChange,
      onFocus,
      readOnly,
      required,
      tabIndex,
      type,
      value
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1w);

    const [checked, setCheckedState] = useControlled({
      controlled: checkedProp,
      default: Boolean(defaultChecked),
      name: 'SwitchBase',
      state: 'checked'
    });
    const muiFormControl = useFormControl();

    const handleFocus = event => {
      if (onFocus) {
        onFocus(event);
      }

      if (muiFormControl && muiFormControl.onFocus) {
        muiFormControl.onFocus(event);
      }
    };

    const handleBlur = event => {
      if (onBlur) {
        onBlur(event);
      }

      if (muiFormControl && muiFormControl.onBlur) {
        muiFormControl.onBlur(event);
      }
    };

    const handleInputChange = event => {
      // Workaround for https://github.com/facebook/react/issues/9023
      if (event.nativeEvent.defaultPrevented) {
        return;
      }

      const newChecked = event.target.checked;
      setCheckedState(newChecked);

      if (onChange) {
        // TODO v6: remove the second argument.
        onChange(event, newChecked);
      }
    };

    let disabled = disabledProp;

    if (muiFormControl) {
      if (typeof disabled === 'undefined') {
        disabled = muiFormControl.disabled;
      }
    }

    const hasLabelFor = type === 'checkbox' || type === 'radio';

    const ownerState = _extends({}, props, {
      checked,
      disabled,
      disableFocusRipple,
      edge
    });

    const classes = useUtilityClasses$1f(ownerState);
    return /*#__PURE__*/jsxRuntime_2(SwitchBaseRoot, _extends({
      component: "span",
      className: clsx(classes.root, className),
      centerRipple: true,
      focusRipple: !disableFocusRipple,
      disabled: disabled,
      tabIndex: null,
      role: undefined,
      onFocus: handleFocus,
      onBlur: handleBlur,
      ownerState: ownerState,
      ref: ref
    }, other, {
      children: [/*#__PURE__*/jsxRuntime_1(SwitchBaseInput, _extends({
        autoFocus: autoFocus,
        checked: checkedProp,
        defaultChecked: defaultChecked,
        className: classes.input,
        disabled: disabled,
        id: hasLabelFor && id,
        name: name,
        onChange: handleInputChange,
        readOnly: readOnly,
        ref: inputRef,
        required: required,
        ownerState: ownerState,
        tabIndex: tabIndex,
        type: type
      }, type === 'checkbox' && value === undefined ? {} : {
        value
      }, inputProps)), checked ? checkedIcon : icon]
    }));
  }); // NB: If changed, please update Checkbox, Switch and Radio
  // so that the API documentation is updated.

  SwitchBase.propTypes = {
    /**
     * If `true`, the `input` element is focused during the first mount.
     */
    autoFocus: PropTypes.bool,

    /**
     * If `true`, the component is checked.
     */
    checked: PropTypes.bool,

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: PropTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * @ignore
     */
    defaultChecked: PropTypes.bool,

    /**
     * If `true`, the component is disabled.
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple is disabled.
     * @default false
     */
    disableFocusRipple: PropTypes.bool,

    /**
     * If given, uses a negative margin to counteract the padding on one
     * side (this is often helpful for aligning the left or right
     * side of the icon with content above or below, without ruining the border
     * size and shape).
     * @default false
     */
    edge: PropTypes.oneOf(['end', 'start', false]),

    /**
     * The icon to display when the component is unchecked.
     */
    icon: PropTypes.node.isRequired,

    /**
     * The id of the `input` element.
     */
    id: PropTypes.string,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: PropTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType$1,

    /*
     * @ignore
     */
    name: PropTypes.string,

    /**
     * @ignore
     */
    onBlur: PropTypes.func,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new checked state by accessing `event.target.checked` (boolean).
     */
    onChange: PropTypes.func,

    /**
     * @ignore
     */
    onFocus: PropTypes.func,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: PropTypes.bool,

    /**
     * If `true`, the `input` element is required.
     */
    required: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.object,

    /**
     * @ignore
     */
    tabIndex: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * The input component prop `type`.
     */
    type: PropTypes.string.isRequired,

    /**
     * The value of the component.
     */
    value: PropTypes.any
  } ;
  var SwitchBase$1 = SwitchBase;

  var CheckBoxOutlineBlankIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"
  }), 'CheckBoxOutlineBlank');

  var CheckBoxIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"
  }), 'CheckBox');

  var IndeterminateCheckBoxIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10H7v-2h10v2z"
  }), 'IndeterminateCheckBox');

  function getCheckboxUtilityClass(slot) {
    return generateUtilityClass('MuiCheckbox', slot);
  }
  const checkboxClasses = generateUtilityClasses('MuiCheckbox', ['root', 'checked', 'disabled', 'indeterminate', 'colorPrimary', 'colorSecondary']);
  var checkboxClasses$1 = checkboxClasses;

  const _excluded$1v = ["checkedIcon", "color", "icon", "indeterminate", "indeterminateIcon", "inputProps", "size"];

  const useUtilityClasses$1e = ownerState => {
    const {
      classes,
      indeterminate,
      color
    } = ownerState;
    const slots = {
      root: ['root', indeterminate && 'indeterminate', `color${capitalize(color)}`]
    };
    const composedClasses = composeClasses(slots, getCheckboxUtilityClass, classes);
    return _extends({}, classes, composedClasses);
  };

  const CheckboxRoot = styled$1(SwitchBase$1, {
    shouldForwardProp: prop => rootShouldForwardProp(prop) || prop === 'classes',
    name: 'MuiCheckbox',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.indeterminate && styles.indeterminate, ownerState.color !== 'default' && styles[`color${capitalize(ownerState.color)}`]];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    color: (theme.vars || theme).palette.text.secondary
  }, !ownerState.disableRipple && {
    '&:hover': {
      backgroundColor: theme.vars ? `rgba(${ownerState.color === 'default' ? theme.vars.palette.action.activeChannel : theme.vars.palette.primary.mainChannel} / ${theme.vars.palette.action.hoverOpacity})` : alpha(ownerState.color === 'default' ? theme.palette.action.active : theme.palette[ownerState.color].main, theme.palette.action.hoverOpacity),
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        backgroundColor: 'transparent'
      }
    }
  }, ownerState.color !== 'default' && {
    [`&.${checkboxClasses$1.checked}, &.${checkboxClasses$1.indeterminate}`]: {
      color: (theme.vars || theme).palette[ownerState.color].main
    },
    [`&.${checkboxClasses$1.disabled}`]: {
      color: (theme.vars || theme).palette.action.disabled
    }
  }));

  const defaultCheckedIcon$1 = /*#__PURE__*/jsxRuntime_1(CheckBoxIcon, {});

  const defaultIcon$2 = /*#__PURE__*/jsxRuntime_1(CheckBoxOutlineBlankIcon, {});

  const defaultIndeterminateIcon = /*#__PURE__*/jsxRuntime_1(IndeterminateCheckBoxIcon, {});

  const Checkbox = /*#__PURE__*/React__namespace.forwardRef(function Checkbox(inProps, ref) {
    var _icon$props$fontSize, _indeterminateIcon$pr;

    const props = useThemeProps({
      props: inProps,
      name: 'MuiCheckbox'
    });

    const {
      checkedIcon = defaultCheckedIcon$1,
      color = 'primary',
      icon: iconProp = defaultIcon$2,
      indeterminate = false,
      indeterminateIcon: indeterminateIconProp = defaultIndeterminateIcon,
      inputProps,
      size = 'medium'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1v);

    const icon = indeterminate ? indeterminateIconProp : iconProp;
    const indeterminateIcon = indeterminate ? indeterminateIconProp : checkedIcon;

    const ownerState = _extends({}, props, {
      color,
      indeterminate,
      size
    });

    const classes = useUtilityClasses$1e(ownerState);
    return /*#__PURE__*/jsxRuntime_1(CheckboxRoot, _extends({
      type: "checkbox",
      inputProps: _extends({
        'data-indeterminate': indeterminate
      }, inputProps),
      icon: /*#__PURE__*/React__namespace.cloneElement(icon, {
        fontSize: (_icon$props$fontSize = icon.props.fontSize) != null ? _icon$props$fontSize : size
      }),
      checkedIcon: /*#__PURE__*/React__namespace.cloneElement(indeterminateIcon, {
        fontSize: (_indeterminateIcon$pr = indeterminateIcon.props.fontSize) != null ? _indeterminateIcon$pr : size
      }),
      ownerState: ownerState,
      ref: ref
    }, other, {
      classes: classes
    }));
  });
  Checkbox.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * If `true`, the component is checked.
     */
    checked: PropTypes.bool,

    /**
     * The icon to display when the component is checked.
     * @default <CheckBoxIcon />
     */
    checkedIcon: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'primary'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The default checked state. Use when the component is not controlled.
     */
    defaultChecked: PropTypes.bool,

    /**
     * If `true`, the component is disabled.
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the ripple effect is disabled.
     */
    disableRipple: PropTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     * @default <CheckBoxOutlineBlankIcon />
     */
    icon: PropTypes.node,

    /**
     * The id of the `input` element.
     */
    id: PropTypes.string,

    /**
     * If `true`, the component appears indeterminate.
     * This does not set the native input element to indeterminate due
     * to inconsistent behavior across browsers.
     * However, we set a `data-indeterminate` attribute on the `input`.
     * @default false
     */
    indeterminate: PropTypes.bool,

    /**
     * The icon to display when the component is indeterminate.
     * @default <IndeterminateCheckBoxIcon />
     */
    indeterminateIcon: PropTypes.node,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: PropTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType$1,

    /**
     * Callback fired when the state is changed.
     *
     * @param {React.ChangeEvent<HTMLInputElement>} event The event source of the callback.
     * You can pull out the new checked state by accessing `event.target.checked` (boolean).
     */
    onChange: PropTypes.func,

    /**
     * If `true`, the `input` element is required.
     */
    required: PropTypes.bool,

    /**
     * The size of the component.
     * `small` is equivalent to the dense checkbox styling.
     * @default 'medium'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The value of the component. The DOM API casts this to a string.
     * The browser uses "on" as the default value.
     */
    value: PropTypes.any
  } ;
  var Checkbox$1 = Checkbox;

  function getCircularProgressUtilityClass(slot) {
    return generateUtilityClass('MuiCircularProgress', slot);
  }
  const circularProgressClasses = generateUtilityClasses('MuiCircularProgress', ['root', 'determinate', 'indeterminate', 'colorPrimary', 'colorSecondary', 'svg', 'circle', 'circleDeterminate', 'circleIndeterminate', 'circleDisableShrink']);
  var circularProgressClasses$1 = circularProgressClasses;

  const _excluded$1u = ["className", "color", "disableShrink", "size", "style", "thickness", "value", "variant"];

  let _$2 = t => t,
      _t$2,
      _t2$2,
      _t3$2,
      _t4$2;
  const SIZE = 44;
  const circularRotateKeyframe = keyframes(_t$2 || (_t$2 = _$2`
  0% {
    transform: rotate(0deg);
  }

  100% {
    transform: rotate(360deg);
  }
`));
  const circularDashKeyframe = keyframes(_t2$2 || (_t2$2 = _$2`
  0% {
    stroke-dasharray: 1px, 200px;
    stroke-dashoffset: 0;
  }

  50% {
    stroke-dasharray: 100px, 200px;
    stroke-dashoffset: -15px;
  }

  100% {
    stroke-dasharray: 100px, 200px;
    stroke-dashoffset: -125px;
  }
`));

  const useUtilityClasses$1d = ownerState => {
    const {
      classes,
      variant,
      color,
      disableShrink
    } = ownerState;
    const slots = {
      root: ['root', variant, `color${capitalize(color)}`],
      svg: ['svg'],
      circle: ['circle', `circle${capitalize(variant)}`, disableShrink && 'circleDisableShrink']
    };
    return composeClasses(slots, getCircularProgressUtilityClass, classes);
  };

  const CircularProgressRoot = styled$1('span', {
    name: 'MuiCircularProgress',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.variant], styles[`color${capitalize(ownerState.color)}`]];
    }
  })(({
    ownerState,
    theme
  }) => _extends({
    display: 'inline-block'
  }, ownerState.variant === 'determinate' && {
    transition: theme.transitions.create('transform')
  }, ownerState.color !== 'inherit' && {
    color: (theme.vars || theme).palette[ownerState.color].main
  }), ({
    ownerState
  }) => ownerState.variant === 'indeterminate' && css(_t3$2 || (_t3$2 = _$2`
      animation: ${0} 1.4s linear infinite;
    `), circularRotateKeyframe));
  const CircularProgressSVG = styled$1('svg', {
    name: 'MuiCircularProgress',
    slot: 'Svg',
    overridesResolver: (props, styles) => styles.svg
  })({
    display: 'block' // Keeps the progress centered

  });
  const CircularProgressCircle = styled$1('circle', {
    name: 'MuiCircularProgress',
    slot: 'Circle',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.circle, styles[`circle${capitalize(ownerState.variant)}`], ownerState.disableShrink && styles.circleDisableShrink];
    }
  })(({
    ownerState,
    theme
  }) => _extends({
    stroke: 'currentColor'
  }, ownerState.variant === 'determinate' && {
    transition: theme.transitions.create('stroke-dashoffset')
  }, ownerState.variant === 'indeterminate' && {
    // Some default value that looks fine waiting for the animation to kicks in.
    strokeDasharray: '80px, 200px',
    strokeDashoffset: 0 // Add the unit to fix a Edge 16 and below bug.

  }), ({
    ownerState
  }) => ownerState.variant === 'indeterminate' && !ownerState.disableShrink && css(_t4$2 || (_t4$2 = _$2`
      animation: ${0} 1.4s ease-in-out infinite;
    `), circularDashKeyframe));
  /**
   * ## ARIA
   *
   * If the progress bar is describing the loading progress of a particular region of a page,
   * you should use `aria-describedby` to point to the progress bar, and set the `aria-busy`
   * attribute to `true` on that region until it has finished loading.
   */

  const CircularProgress = /*#__PURE__*/React__namespace.forwardRef(function CircularProgress(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCircularProgress'
    });

    const {
      className,
      color = 'primary',
      disableShrink = false,
      size = 40,
      style,
      thickness = 3.6,
      value = 0,
      variant = 'indeterminate'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1u);

    const ownerState = _extends({}, props, {
      color,
      disableShrink,
      size,
      thickness,
      value,
      variant
    });

    const classes = useUtilityClasses$1d(ownerState);
    const circleStyle = {};
    const rootStyle = {};
    const rootProps = {};

    if (variant === 'determinate') {
      const circumference = 2 * Math.PI * ((SIZE - thickness) / 2);
      circleStyle.strokeDasharray = circumference.toFixed(3);
      rootProps['aria-valuenow'] = Math.round(value);
      circleStyle.strokeDashoffset = `${((100 - value) / 100 * circumference).toFixed(3)}px`;
      rootStyle.transform = 'rotate(-90deg)';
    }

    return /*#__PURE__*/jsxRuntime_1(CircularProgressRoot, _extends({
      className: clsx(classes.root, className),
      style: _extends({
        width: size,
        height: size
      }, rootStyle, style),
      ownerState: ownerState,
      ref: ref,
      role: "progressbar"
    }, rootProps, other, {
      children: /*#__PURE__*/jsxRuntime_1(CircularProgressSVG, {
        className: classes.svg,
        ownerState: ownerState,
        viewBox: `${SIZE / 2} ${SIZE / 2} ${SIZE} ${SIZE}`,
        children: /*#__PURE__*/jsxRuntime_1(CircularProgressCircle, {
          className: classes.circle,
          style: circleStyle,
          ownerState: ownerState,
          cx: SIZE,
          cy: SIZE,
          r: (SIZE - thickness) / 2,
          fill: "none",
          strokeWidth: thickness
        })
      })
    }));
  });
  CircularProgress.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'primary'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['inherit', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * If `true`, the shrink animation is disabled.
     * This only works if variant is `indeterminate`.
     * @default false
     */
    disableShrink: chainPropTypes(PropTypes.bool, props => {
      if (props.disableShrink && props.variant && props.variant !== 'indeterminate') {
        return new Error('MUI: You have provided the `disableShrink` prop ' + 'with a variant other than `indeterminate`. This will have no effect.');
      }

      return null;
    }),

    /**
     * The size of the component.
     * If using a number, the pixel unit is assumed.
     * If using a string, you need to provide the CSS unit, e.g '3rem'.
     * @default 40
     */
    size: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The thickness of the circle.
     * @default 3.6
     */
    thickness: PropTypes.number,

    /**
     * The value of the progress indicator for the determinate variant.
     * Value between 0 and 100.
     * @default 0
     */
    value: PropTypes.number,

    /**
     * The variant to use.
     * Use indeterminate when there is no progress value.
     * @default 'indeterminate'
     */
    variant: PropTypes.oneOf(['determinate', 'indeterminate'])
  } ;
  var CircularProgress$1 = CircularProgress;

  const Container = createContainer({
    createStyledComponent: styled$1('div', {
      name: 'MuiContainer',
      slot: 'Root',
      overridesResolver: (props, styles) => {
        const {
          ownerState
        } = props;
        return [styles.root, styles[`maxWidth${capitalize(String(ownerState.maxWidth))}`], ownerState.fixed && styles.fixed, ownerState.disableGutters && styles.disableGutters];
      }
    }),
    useThemeProps: inProps => useThemeProps({
      props: inProps,
      name: 'MuiContainer'
    })
  });
  Container.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * @ignore
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the left and right padding is removed.
     * @default false
     */
    disableGutters: PropTypes.bool,

    /**
     * Set the max-width to match the min-width of the current breakpoint.
     * This is useful if you'd prefer to design for a fixed set of sizes
     * instead of trying to accommodate a fully fluid viewport.
     * It's fluid by default.
     * @default false
     */
    fixed: PropTypes.bool,

    /**
     * Determine the max-width of the container.
     * The container width grows with the size of the screen.
     * Set to `false` to disable `maxWidth`.
     * @default 'lg'
     */
    maxWidth: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false]), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Container$1 = Container;

  function getContainerUtilityClass(slot) {
    return generateUtilityClass('MuiContainer', slot);
  }
  const containerClasses = generateUtilityClasses('MuiContainer', ['root', 'disableGutters', 'fixed', 'maxWidthXs', 'maxWidthSm', 'maxWidthMd', 'maxWidthLg', 'maxWidthXl']);
  var containerClasses$1 = containerClasses;

  const html = (theme, enableColorScheme) => _extends({
    WebkitFontSmoothing: 'antialiased',
    // Antialiasing.
    MozOsxFontSmoothing: 'grayscale',
    // Antialiasing.
    // Change from `box-sizing: content-box` so that `width`
    // is not affected by `padding` or `border`.
    boxSizing: 'border-box',
    // Fix font resize problem in iOS
    WebkitTextSizeAdjust: '100%'
  }, enableColorScheme && {
    colorScheme: theme.palette.mode
  });
  const body = theme => _extends({
    color: (theme.vars || theme).palette.text.primary
  }, theme.typography.body1, {
    backgroundColor: (theme.vars || theme).palette.background.default,
    '@media print': {
      // Save printer ink.
      backgroundColor: (theme.vars || theme).palette.common.white
    }
  });
  const styles$3 = (theme, enableColorScheme = false) => {
    var _theme$components, _theme$components$Mui;

    let defaultStyles = {
      html: html(theme, enableColorScheme),
      '*, *::before, *::after': {
        boxSizing: 'inherit'
      },
      'strong, b': {
        fontWeight: theme.typography.fontWeightBold
      },
      body: _extends({
        margin: 0
      }, body(theme), {
        // Add support for document.body.requestFullScreen().
        // Other elements, if background transparent, are not supported.
        '&::backdrop': {
          backgroundColor: (theme.vars || theme).palette.background.default
        }
      })
    };
    const themeOverrides = (_theme$components = theme.components) == null ? void 0 : (_theme$components$Mui = _theme$components.MuiCssBaseline) == null ? void 0 : _theme$components$Mui.styleOverrides;

    if (themeOverrides) {
      defaultStyles = [defaultStyles, themeOverrides];
    }

    return defaultStyles;
  };
  /**
   * Kickstart an elegant, consistent, and simple baseline to build upon.
   */

  function CssBaseline(inProps) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiCssBaseline'
    });
    const {
      children,
      enableColorScheme = false
    } = props;
    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1(GlobalStyles, {
        styles: theme => styles$3(theme, enableColorScheme)
      }), children]
    });
  }

  CssBaseline.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * You can wrap a node.
     */
    children: PropTypes.node,

    /**
     * Enable `color-scheme` CSS property to use `theme.palette.mode`.
     * For more details, check out https://developer.mozilla.org/en-US/docs/Web/CSS/color-scheme
     * For browser support, check out https://caniuse.com/?search=color-scheme
     * @default false
     */
    enableColorScheme: PropTypes.bool
  } ;

  // track, thumb and active are derieved from macOS 10.15.7
  const scrollBar = {
    track: '#2b2b2b',
    thumb: '#6b6b6b',
    active: '#959595'
  };
  function darkScrollbar(options = scrollBar) {
    return {
      scrollbarColor: `${options.thumb} ${options.track}`,
      '&::-webkit-scrollbar, & *::-webkit-scrollbar': {
        backgroundColor: options.track
      },
      '&::-webkit-scrollbar-thumb, & *::-webkit-scrollbar-thumb': {
        borderRadius: 8,
        backgroundColor: options.thumb,
        minHeight: 24,
        border: `3px solid ${options.track}`
      },
      '&::-webkit-scrollbar-thumb:focus, & *::-webkit-scrollbar-thumb:focus': {
        backgroundColor: options.active
      },
      '&::-webkit-scrollbar-thumb:active, & *::-webkit-scrollbar-thumb:active': {
        backgroundColor: options.active
      },
      '&::-webkit-scrollbar-thumb:hover, & *::-webkit-scrollbar-thumb:hover': {
        backgroundColor: options.active
      },
      '&::-webkit-scrollbar-corner, & *::-webkit-scrollbar-corner': {
        backgroundColor: options.track
      }
    };
  }

  const _excluded$1t = ["BackdropComponent", "BackdropProps", "closeAfterTransition", "children", "component", "components", "componentsProps", "disableAutoFocus", "disableEnforceFocus", "disableEscapeKeyDown", "disablePortal", "disableRestoreFocus", "disableScrollLock", "hideBackdrop", "keepMounted", "theme"];
  const modalClasses = modalUnstyledClasses$1;

  const extendUtilityClasses$1 = ownerState => {
    return ownerState.classes;
  };

  const ModalRoot = styled$1('div', {
    name: 'MuiModal',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, !ownerState.open && ownerState.exited && styles.hidden];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    position: 'fixed',
    zIndex: (theme.vars || theme).zIndex.modal,
    right: 0,
    bottom: 0,
    top: 0,
    left: 0
  }, !ownerState.open && ownerState.exited && {
    visibility: 'hidden'
  }));
  const ModalBackdrop = styled$1(Backdrop$1, {
    name: 'MuiModal',
    slot: 'Backdrop',
    overridesResolver: (props, styles) => {
      return styles.backdrop;
    }
  })({
    zIndex: -1
  });
  /**
   * Modal is a lower-level construct that is leveraged by the following components:
   *
   * - [Dialog](/material-ui/api/dialog/)
   * - [Drawer](/material-ui/api/drawer/)
   * - [Menu](/material-ui/api/menu/)
   * - [Popover](/material-ui/api/popover/)
   *
   * If you are creating a modal dialog, you probably want to use the [Dialog](/material-ui/api/dialog/) component
   * rather than directly using Modal.
   *
   * This component shares many concepts with [react-overlays](https://react-bootstrap.github.io/react-overlays/#modals).
   */

  const Modal = /*#__PURE__*/React__namespace.forwardRef(function Modal(inProps, ref) {
    var _ref, _components$Root;

    const props = useThemeProps({
      name: 'MuiModal',
      props: inProps
    });

    const {
      BackdropComponent = ModalBackdrop,
      BackdropProps,
      closeAfterTransition = false,
      children,
      component,
      components = {},
      componentsProps = {},
      disableAutoFocus = false,
      disableEnforceFocus = false,
      disableEscapeKeyDown = false,
      disablePortal = false,
      disableRestoreFocus = false,
      disableScrollLock = false,
      hideBackdrop = false,
      keepMounted = false,
      // eslint-disable-next-line react/prop-types
      theme
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1t);

    const [exited, setExited] = React__namespace.useState(true);
    const commonProps = {
      closeAfterTransition,
      disableAutoFocus,
      disableEnforceFocus,
      disableEscapeKeyDown,
      disablePortal,
      disableRestoreFocus,
      disableScrollLock,
      hideBackdrop,
      keepMounted
    };

    const ownerState = _extends({}, props, commonProps, {
      exited
    });

    const classes = extendUtilityClasses$1(ownerState);
    const Root = (_ref = (_components$Root = components.Root) != null ? _components$Root : component) != null ? _ref : ModalRoot;
    return /*#__PURE__*/jsxRuntime_1(ModalUnstyled$1, _extends({
      components: _extends({
        Root,
        Backdrop: BackdropComponent
      }, components),
      componentsProps: {
        root: _extends({}, componentsProps.root, !isHostComponent(Root) && {
          as: component,
          theme
        }),
        backdrop: _extends({}, BackdropProps, componentsProps.backdrop)
      },
      onTransitionEnter: () => setExited(false),
      onTransitionExited: () => setExited(true),
      ref: ref
    }, other, {
      classes: classes
    }, commonProps, {
      children: children
    }));
  });
  Modal.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * A backdrop component. This prop enables custom backdrop rendering.
     * @deprecated Use `components.Backdrop` instead.
     * @default styled(Backdrop, {
     *   name: 'MuiModal',
     *   slot: 'Backdrop',
     *   overridesResolver: (props, styles) => {
     *     return styles.backdrop;
     *   },
     * })({
     *   zIndex: -1,
     * })
     */
    BackdropComponent: PropTypes.elementType,

    /**
     * Props applied to the [`Backdrop`](/material-ui/api/backdrop/) element.
     * @deprecated Use `componentsProps.backdrop` instead.
     */
    BackdropProps: PropTypes.object,

    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1.isRequired,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * When set to true the Modal waits until a nested Transition is completed before closing.
     * @default false
     */
    closeAfterTransition: PropTypes.bool,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * The components used for each slot inside the Modal.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Backdrop: PropTypes.elementType,
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Modal.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      backdrop: PropTypes.object,
      root: PropTypes.object
    }),

    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([HTMLElementType, PropTypes.func]),

    /**
     * If `true`, the modal will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any modal children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableAutoFocus: PropTypes.bool,

    /**
     * If `true`, the modal will not prevent focus from leaving the modal while open.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableEnforceFocus: PropTypes.bool,

    /**
     * If `true`, hitting escape will not fire the `onClose` callback.
     * @default false
     */
    disableEscapeKeyDown: PropTypes.bool,

    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,

    /**
     * If `true`, the modal will not restore focus to previously focused element once
     * modal is hidden or unmounted.
     * @default false
     */
    disableRestoreFocus: PropTypes.bool,

    /**
     * Disable the scroll lock behavior.
     * @default false
     */
    disableScrollLock: PropTypes.bool,

    /**
     * If `true`, the backdrop is not rendered.
     * @default false
     */
    hideBackdrop: PropTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Modal.
     * @default false
     */
    keepMounted: PropTypes.bool,

    /**
     * Callback fired when the backdrop is clicked.
     * @deprecated Use the `onClose` prop with the `reason` argument to handle the `backdropClick` events.
     */
    onBackdropClick: PropTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * The `reason` parameter can optionally be used to control the response to `onClose`.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be: `"escapeKeyDown"`, `"backdropClick"`.
     */
    onClose: PropTypes.func,

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Modal$1 = Modal;

  function getDialogUtilityClass(slot) {
    return generateUtilityClass('MuiDialog', slot);
  }
  const dialogClasses = generateUtilityClasses('MuiDialog', ['root', 'scrollPaper', 'scrollBody', 'container', 'paper', 'paperScrollPaper', 'paperScrollBody', 'paperWidthFalse', 'paperWidthXs', 'paperWidthSm', 'paperWidthMd', 'paperWidthLg', 'paperWidthXl', 'paperFullWidth', 'paperFullScreen']);
  var dialogClasses$1 = dialogClasses;

  const DialogContext = /*#__PURE__*/React.createContext({});

  {
    DialogContext.displayName = 'DialogContext';
  }

  var DialogContext$1 = DialogContext;

  const _excluded$1s = ["aria-describedby", "aria-labelledby", "BackdropComponent", "BackdropProps", "children", "className", "disableEscapeKeyDown", "fullScreen", "fullWidth", "maxWidth", "onBackdropClick", "onClose", "open", "PaperComponent", "PaperProps", "scroll", "TransitionComponent", "transitionDuration", "TransitionProps"];
  const DialogBackdrop = styled$1(Backdrop$1, {
    name: 'MuiDialog',
    slot: 'Backdrop',
    overrides: (props, styles) => styles.backdrop
  })({
    // Improve scrollable dialog support.
    zIndex: -1
  });

  const useUtilityClasses$1c = ownerState => {
    const {
      classes,
      scroll,
      maxWidth,
      fullWidth,
      fullScreen
    } = ownerState;
    const slots = {
      root: ['root'],
      container: ['container', `scroll${capitalize(scroll)}`],
      paper: ['paper', `paperScroll${capitalize(scroll)}`, `paperWidth${capitalize(String(maxWidth))}`, fullWidth && 'paperFullWidth', fullScreen && 'paperFullScreen']
    };
    return composeClasses(slots, getDialogUtilityClass, classes);
  };

  const DialogRoot = styled$1(Modal$1, {
    name: 'MuiDialog',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })({
    '@media print': {
      // Use !important to override the Modal inline-style.
      position: 'absolute !important'
    }
  });
  const DialogContainer = styled$1('div', {
    name: 'MuiDialog',
    slot: 'Container',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.container, styles[`scroll${capitalize(ownerState.scroll)}`]];
    }
  })(({
    ownerState
  }) => _extends({
    height: '100%',
    '@media print': {
      height: 'auto'
    },
    // We disable the focus ring for mouse, touch and keyboard users.
    outline: 0
  }, ownerState.scroll === 'paper' && {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  }, ownerState.scroll === 'body' && {
    overflowY: 'auto',
    overflowX: 'hidden',
    textAlign: 'center',
    '&:after': {
      content: '""',
      display: 'inline-block',
      verticalAlign: 'middle',
      height: '100%',
      width: '0'
    }
  }));
  const DialogPaper = styled$1(Paper$1, {
    name: 'MuiDialog',
    slot: 'Paper',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.paper, styles[`scrollPaper${capitalize(ownerState.scroll)}`], styles[`paperWidth${capitalize(String(ownerState.maxWidth))}`], ownerState.fullWidth && styles.paperFullWidth, ownerState.fullScreen && styles.paperFullScreen];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    margin: 32,
    position: 'relative',
    overflowY: 'auto',
    // Fix IE11 issue, to remove at some point.
    '@media print': {
      overflowY: 'visible',
      boxShadow: 'none'
    }
  }, ownerState.scroll === 'paper' && {
    display: 'flex',
    flexDirection: 'column',
    maxHeight: 'calc(100% - 64px)'
  }, ownerState.scroll === 'body' && {
    display: 'inline-block',
    verticalAlign: 'middle',
    textAlign: 'left' // 'initial' doesn't work on IE11

  }, !ownerState.maxWidth && {
    maxWidth: 'calc(100% - 64px)'
  }, ownerState.maxWidth === 'xs' && {
    maxWidth: theme.breakpoints.unit === 'px' ? Math.max(theme.breakpoints.values.xs, 444) : `${theme.breakpoints.values.xs}${theme.breakpoints.unit}`,
    [`&.${dialogClasses$1.paperScrollBody}`]: {
      [theme.breakpoints.down(Math.max(theme.breakpoints.values.xs, 444) + 32 * 2)]: {
        maxWidth: 'calc(100% - 64px)'
      }
    }
  }, ownerState.maxWidth && ownerState.maxWidth !== 'xs' && {
    maxWidth: `${theme.breakpoints.values[ownerState.maxWidth]}${theme.breakpoints.unit}`,
    [`&.${dialogClasses$1.paperScrollBody}`]: {
      [theme.breakpoints.down(theme.breakpoints.values[ownerState.maxWidth] + 32 * 2)]: {
        maxWidth: 'calc(100% - 64px)'
      }
    }
  }, ownerState.fullWidth && {
    width: 'calc(100% - 64px)'
  }, ownerState.fullScreen && {
    margin: 0,
    width: '100%',
    maxWidth: '100%',
    height: '100%',
    maxHeight: 'none',
    borderRadius: 0,
    [`&.${dialogClasses$1.paperScrollBody}`]: {
      margin: 0,
      maxWidth: '100%'
    }
  }));
  /**
   * Dialogs are overlaid modal paper based components with a backdrop.
   */

  const Dialog = /*#__PURE__*/React__namespace.forwardRef(function Dialog(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDialog'
    });
    const theme = useTheme();
    const defaultTransitionDuration = {
      enter: theme.transitions.duration.enteringScreen,
      exit: theme.transitions.duration.leavingScreen
    };

    const {
      'aria-describedby': ariaDescribedby,
      'aria-labelledby': ariaLabelledbyProp,
      BackdropComponent,
      BackdropProps,
      children,
      className,
      disableEscapeKeyDown = false,
      fullScreen = false,
      fullWidth = false,
      maxWidth = 'sm',
      onBackdropClick,
      onClose,
      open,
      PaperComponent = Paper$1,
      PaperProps = {},
      scroll = 'paper',
      TransitionComponent = Fade$1,
      transitionDuration = defaultTransitionDuration,
      TransitionProps
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1s);

    const ownerState = _extends({}, props, {
      disableEscapeKeyDown,
      fullScreen,
      fullWidth,
      maxWidth,
      scroll
    });

    const classes = useUtilityClasses$1c(ownerState);
    const backdropClick = React__namespace.useRef();

    const handleMouseDown = event => {
      // We don't want to close the dialog when clicking the dialog content.
      // Make sure the event starts and ends on the same DOM element.
      backdropClick.current = event.target === event.currentTarget;
    };

    const handleBackdropClick = event => {
      // Ignore the events not coming from the "backdrop".
      if (!backdropClick.current) {
        return;
      }

      backdropClick.current = null;

      if (onBackdropClick) {
        onBackdropClick(event);
      }

      if (onClose) {
        onClose(event, 'backdropClick');
      }
    };

    const ariaLabelledby = useId(ariaLabelledbyProp);
    const dialogContextValue = React__namespace.useMemo(() => {
      return {
        titleId: ariaLabelledby
      };
    }, [ariaLabelledby]);
    return /*#__PURE__*/jsxRuntime_1(DialogRoot, _extends({
      className: clsx(classes.root, className),
      closeAfterTransition: true,
      components: {
        Backdrop: DialogBackdrop
      },
      componentsProps: {
        backdrop: _extends({
          transitionDuration,
          as: BackdropComponent
        }, BackdropProps)
      },
      disableEscapeKeyDown: disableEscapeKeyDown,
      onClose: onClose,
      open: open,
      ref: ref,
      onClick: handleBackdropClick,
      ownerState: ownerState
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
        appear: true,
        in: open,
        timeout: transitionDuration,
        role: "presentation"
      }, TransitionProps, {
        children: /*#__PURE__*/jsxRuntime_1(DialogContainer, {
          className: clsx(classes.container),
          onMouseDown: handleMouseDown,
          ownerState: ownerState,
          children: /*#__PURE__*/jsxRuntime_1(DialogPaper, _extends({
            as: PaperComponent,
            elevation: 24,
            role: "dialog",
            "aria-describedby": ariaDescribedby,
            "aria-labelledby": ariaLabelledby
          }, PaperProps, {
            className: clsx(classes.paper, PaperProps.className),
            ownerState: ownerState,
            children: /*#__PURE__*/jsxRuntime_1(DialogContext$1.Provider, {
              value: dialogContextValue,
              children: children
            })
          }))
        })
      }))
    }));
  });
  Dialog.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The id(s) of the element(s) that describe the dialog.
     */
    'aria-describedby': PropTypes.string,

    /**
     * The id(s) of the element(s) that label the dialog.
     */
    'aria-labelledby': PropTypes.string,

    /**
     * A backdrop component. This prop enables custom backdrop rendering.
     * @deprecated Use `components.Backdrop` instead.
     * @default styled(Backdrop, {
     *   name: 'MuiModal',
     *   slot: 'Backdrop',
     *   overridesResolver: (props, styles) => {
     *     return styles.backdrop;
     *   },
     * })({
     *   zIndex: -1,
     * })
     */
    BackdropComponent: PropTypes.elementType,

    /**
     * @ignore
     */
    BackdropProps: PropTypes.object,

    /**
     * Dialog children, usually the included sub-components.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, hitting escape will not fire the `onClose` callback.
     * @default false
     */
    disableEscapeKeyDown: PropTypes.bool,

    /**
     * If `true`, the dialog is full-screen.
     * @default false
     */
    fullScreen: PropTypes.bool,

    /**
     * If `true`, the dialog stretches to `maxWidth`.
     *
     * Notice that the dialog width grow is limited by the default margin.
     * @default false
     */
    fullWidth: PropTypes.bool,

    /**
     * Determine the max-width of the dialog.
     * The dialog width grows with the size of the screen.
     * Set to `false` to disable `maxWidth`.
     * @default 'sm'
     */
    maxWidth: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false]), PropTypes.string]),

    /**
     * Callback fired when the backdrop is clicked.
     * @deprecated Use the `onClose` prop with the `reason` argument to handle the `backdropClick` events.
     */
    onBackdropClick: PropTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be: `"escapeKeyDown"`, `"backdropClick"`.
     */
    onClose: PropTypes.func,

    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,

    /**
     * The component used to render the body of the dialog.
     * @default Paper
     */
    PaperComponent: PropTypes.elementType,

    /**
     * Props applied to the [`Paper`](/material-ui/api/paper/) element.
     * @default {}
     */
    PaperProps: PropTypes.object,

    /**
     * Determine the container for scrolling the dialog.
     * @default 'paper'
     */
    scroll: PropTypes.oneOf(['body', 'paper']),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The component used for the transition.
     * [Follow this guide](/material-ui/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
     * @default Fade
     */
    TransitionComponent: PropTypes.elementType,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     * @default {
     *   enter: theme.transitions.duration.enteringScreen,
     *   exit: theme.transitions.duration.leavingScreen,
     * }
     */
    transitionDuration: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })]),

    /**
     * Props applied to the transition element.
     * By default, the element is based on this [`Transition`](http://reactcommunity.org/react-transition-group/transition/) component.
     */
    TransitionProps: PropTypes.object
  } ;
  var Dialog$1 = Dialog;

  function getDialogActionsUtilityClass(slot) {
    return generateUtilityClass('MuiDialogActions', slot);
  }
  const dialogActionsClasses = generateUtilityClasses('MuiDialogActions', ['root', 'spacing']);
  var dialogActionsClasses$1 = dialogActionsClasses;

  const _excluded$1r = ["className", "disableSpacing"];

  const useUtilityClasses$1b = ownerState => {
    const {
      classes,
      disableSpacing
    } = ownerState;
    const slots = {
      root: ['root', !disableSpacing && 'spacing']
    };
    return composeClasses(slots, getDialogActionsUtilityClass, classes);
  };

  const DialogActionsRoot = styled$1('div', {
    name: 'MuiDialogActions',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, !ownerState.disableSpacing && styles.spacing];
    }
  })(({
    ownerState
  }) => _extends({
    display: 'flex',
    alignItems: 'center',
    padding: 8,
    justifyContent: 'flex-end',
    flex: '0 0 auto'
  }, !ownerState.disableSpacing && {
    '& > :not(:first-of-type)': {
      marginLeft: 8
    }
  }));
  const DialogActions = /*#__PURE__*/React__namespace.forwardRef(function DialogActions(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDialogActions'
    });

    const {
      className,
      disableSpacing = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1r);

    const ownerState = _extends({}, props, {
      disableSpacing
    });

    const classes = useUtilityClasses$1b(ownerState);
    return /*#__PURE__*/jsxRuntime_1(DialogActionsRoot, _extends({
      className: clsx(classes.root, className),
      ownerState: ownerState,
      ref: ref
    }, other));
  });
  DialogActions.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * If `true`, the actions do not have additional margin.
     * @default false
     */
    disableSpacing: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var DialogActions$1 = DialogActions;

  function getDialogContentUtilityClass(slot) {
    return generateUtilityClass('MuiDialogContent', slot);
  }
  const dialogContentClasses = generateUtilityClasses('MuiDialogContent', ['root', 'dividers']);
  var dialogContentClasses$1 = dialogContentClasses;

  function getDialogTitleUtilityClass(slot) {
    return generateUtilityClass('MuiDialogTitle', slot);
  }
  const dialogTitleClasses = generateUtilityClasses('MuiDialogTitle', ['root']);
  var dialogTitleClasses$1 = dialogTitleClasses;

  const _excluded$1q = ["className", "dividers"];

  const useUtilityClasses$1a = ownerState => {
    const {
      classes,
      dividers
    } = ownerState;
    const slots = {
      root: ['root', dividers && 'dividers']
    };
    return composeClasses(slots, getDialogContentUtilityClass, classes);
  };

  const DialogContentRoot = styled$1('div', {
    name: 'MuiDialogContent',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.dividers && styles.dividers];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    flex: '1 1 auto',
    // Add iOS momentum scrolling for iOS < 13.0
    WebkitOverflowScrolling: 'touch',
    overflowY: 'auto',
    padding: '20px 24px'
  }, ownerState.dividers ? {
    padding: '16px 24px',
    borderTop: `1px solid ${(theme.vars || theme).palette.divider}`,
    borderBottom: `1px solid ${(theme.vars || theme).palette.divider}`
  } : {
    [`.${dialogTitleClasses$1.root} + &`]: {
      paddingTop: 0
    }
  }));
  const DialogContent = /*#__PURE__*/React__namespace.forwardRef(function DialogContent(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDialogContent'
    });

    const {
      className,
      dividers = false
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1q);

    const ownerState = _extends({}, props, {
      dividers
    });

    const classes = useUtilityClasses$1a(ownerState);
    return /*#__PURE__*/jsxRuntime_1(DialogContentRoot, _extends({
      className: clsx(classes.root, className),
      ownerState: ownerState,
      ref: ref
    }, other));
  });
  DialogContent.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * Display the top and bottom dividers.
     * @default false
     */
    dividers: PropTypes.bool,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var DialogContent$1 = DialogContent;

  function getDialogContentTextUtilityClass(slot) {
    return generateUtilityClass('MuiDialogContentText', slot);
  }
  const dialogContentTextClasses = generateUtilityClasses('MuiDialogContentText', ['root']);
  var dialogContentTextClasses$1 = dialogContentTextClasses;

  const _excluded$1p = ["children"];

  const useUtilityClasses$19 = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    const composedClasses = composeClasses(slots, getDialogContentTextUtilityClass, classes);
    return _extends({}, classes, composedClasses);
  };

  const DialogContentTextRoot = styled$1(Typography$1, {
    shouldForwardProp: prop => rootShouldForwardProp(prop) || prop === 'classes',
    name: 'MuiDialogContentText',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })({});
  const DialogContentText = /*#__PURE__*/React__namespace.forwardRef(function DialogContentText(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDialogContentText'
    });

    const ownerState = _objectWithoutPropertiesLoose(props, _excluded$1p);

    const classes = useUtilityClasses$19(ownerState);
    return /*#__PURE__*/jsxRuntime_1(DialogContentTextRoot, _extends({
      component: "p",
      variant: "body1",
      color: "text.secondary",
      ref: ref,
      ownerState: ownerState
    }, props, {
      classes: classes
    }));
  });
  DialogContentText.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var DialogContentText$1 = DialogContentText;

  const _excluded$1o = ["className", "id"];

  const useUtilityClasses$18 = ownerState => {
    const {
      classes
    } = ownerState;
    const slots = {
      root: ['root']
    };
    return composeClasses(slots, getDialogTitleUtilityClass, classes);
  };

  const DialogTitleRoot = styled$1(Typography$1, {
    name: 'MuiDialogTitle',
    slot: 'Root',
    overridesResolver: (props, styles) => styles.root
  })({
    padding: '16px 24px',
    flex: '0 0 auto'
  });
  const DialogTitle = /*#__PURE__*/React__namespace.forwardRef(function DialogTitle(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDialogTitle'
    });

    const {
      className,
      id: idProp
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1o);

    const ownerState = props;
    const classes = useUtilityClasses$18(ownerState);
    const {
      titleId: id = idProp
    } = React__namespace.useContext(DialogContext$1);
    return /*#__PURE__*/jsxRuntime_1(DialogTitleRoot, _extends({
      component: "h2",
      className: clsx(classes.root, className),
      ownerState: ownerState,
      ref: ref,
      variant: "h6",
      id: id
    }, other));
  });
  DialogTitle.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * @ignore
     */
    id: PropTypes.string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var DialogTitle$1 = DialogTitle;

  function getDividerUtilityClass(slot) {
    return generateUtilityClass('MuiDivider', slot);
  }
  const dividerClasses = generateUtilityClasses('MuiDivider', ['root', 'absolute', 'fullWidth', 'inset', 'middle', 'flexItem', 'light', 'vertical', 'withChildren', 'withChildrenVertical', 'textAlignRight', 'textAlignLeft', 'wrapper', 'wrapperVertical']);
  var dividerClasses$1 = dividerClasses;

  const _excluded$1n = ["absolute", "children", "className", "component", "flexItem", "light", "orientation", "role", "textAlign", "variant"];

  const useUtilityClasses$17 = ownerState => {
    const {
      absolute,
      children,
      classes,
      flexItem,
      light,
      orientation,
      textAlign,
      variant
    } = ownerState;
    const slots = {
      root: ['root', absolute && 'absolute', variant, light && 'light', orientation === 'vertical' && 'vertical', flexItem && 'flexItem', children && 'withChildren', children && orientation === 'vertical' && 'withChildrenVertical', textAlign === 'right' && orientation !== 'vertical' && 'textAlignRight', textAlign === 'left' && orientation !== 'vertical' && 'textAlignLeft'],
      wrapper: ['wrapper', orientation === 'vertical' && 'wrapperVertical']
    };
    return composeClasses(slots, getDividerUtilityClass, classes);
  };

  const DividerRoot = styled$1('div', {
    name: 'MuiDivider',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, ownerState.absolute && styles.absolute, styles[ownerState.variant], ownerState.light && styles.light, ownerState.orientation === 'vertical' && styles.vertical, ownerState.flexItem && styles.flexItem, ownerState.children && styles.withChildren, ownerState.children && ownerState.orientation === 'vertical' && styles.withChildrenVertical, ownerState.textAlign === 'right' && ownerState.orientation !== 'vertical' && styles.textAlignRight, ownerState.textAlign === 'left' && ownerState.orientation !== 'vertical' && styles.textAlignLeft];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    margin: 0,
    // Reset browser default style.
    flexShrink: 0,
    borderWidth: 0,
    borderStyle: 'solid',
    borderColor: (theme.vars || theme).palette.divider,
    borderBottomWidth: 'thin'
  }, ownerState.absolute && {
    position: 'absolute',
    bottom: 0,
    left: 0,
    width: '100%'
  }, ownerState.light && {
    borderColor: theme.vars ? `rgba(${theme.vars.palette.dividerChannel} / 0.08)` : alpha(theme.palette.divider, 0.08)
  }, ownerState.variant === 'inset' && {
    marginLeft: 72
  }, ownerState.variant === 'middle' && ownerState.orientation === 'horizontal' && {
    marginLeft: theme.spacing(2),
    marginRight: theme.spacing(2)
  }, ownerState.variant === 'middle' && ownerState.orientation === 'vertical' && {
    marginTop: theme.spacing(1),
    marginBottom: theme.spacing(1)
  }, ownerState.orientation === 'vertical' && {
    height: '100%',
    borderBottomWidth: 0,
    borderRightWidth: 'thin'
  }, ownerState.flexItem && {
    alignSelf: 'stretch',
    height: 'auto'
  }), ({
    theme,
    ownerState
  }) => _extends({}, ownerState.children && {
    display: 'flex',
    whiteSpace: 'nowrap',
    textAlign: 'center',
    border: 0,
    '&::before, &::after': {
      position: 'relative',
      width: '100%',
      borderTop: `thin solid ${(theme.vars || theme).palette.divider}`,
      top: '50%',
      content: '""',
      transform: 'translateY(50%)'
    }
  }), ({
    theme,
    ownerState
  }) => _extends({}, ownerState.children && ownerState.orientation === 'vertical' && {
    flexDirection: 'column',
    '&::before, &::after': {
      height: '100%',
      top: '0%',
      left: '50%',
      borderTop: 0,
      borderLeft: `thin solid ${(theme.vars || theme).palette.divider}`,
      transform: 'translateX(0%)'
    }
  }), ({
    ownerState
  }) => _extends({}, ownerState.textAlign === 'right' && ownerState.orientation !== 'vertical' && {
    '&::before': {
      width: '90%'
    },
    '&::after': {
      width: '10%'
    }
  }, ownerState.textAlign === 'left' && ownerState.orientation !== 'vertical' && {
    '&::before': {
      width: '10%'
    },
    '&::after': {
      width: '90%'
    }
  }));
  const DividerWrapper = styled$1('span', {
    name: 'MuiDivider',
    slot: 'Wrapper',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.wrapper, ownerState.orientation === 'vertical' && styles.wrapperVertical];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    display: 'inline-block',
    paddingLeft: `calc(${theme.spacing(1)} * 1.2)`,
    paddingRight: `calc(${theme.spacing(1)} * 1.2)`
  }, ownerState.orientation === 'vertical' && {
    paddingTop: `calc(${theme.spacing(1)} * 1.2)`,
    paddingBottom: `calc(${theme.spacing(1)} * 1.2)`
  }));
  const Divider = /*#__PURE__*/React__namespace.forwardRef(function Divider(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDivider'
    });

    const {
      absolute = false,
      children,
      className,
      component = children ? 'div' : 'hr',
      flexItem = false,
      light = false,
      orientation = 'horizontal',
      role = component !== 'hr' ? 'separator' : undefined,
      textAlign = 'center',
      variant = 'fullWidth'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1n);

    const ownerState = _extends({}, props, {
      absolute,
      component,
      flexItem,
      light,
      orientation,
      role,
      textAlign,
      variant
    });

    const classes = useUtilityClasses$17(ownerState);
    return /*#__PURE__*/jsxRuntime_1(DividerRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      role: role,
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: children ? /*#__PURE__*/jsxRuntime_1(DividerWrapper, {
        className: classes.wrapper,
        ownerState: ownerState,
        children: children
      }) : null
    }));
  });
  Divider.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Absolutely position the element.
     * @default false
     */
    absolute: PropTypes.bool,

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, a vertical divider will have the correct height when used in flex container.
     * (By default, a vertical divider will have a calculated height of `0px` if it is the child of a flex container.)
     * @default false
     */
    flexItem: PropTypes.bool,

    /**
     * If `true`, the divider will have a lighter color.
     * @default false
     */
    light: PropTypes.bool,

    /**
     * The component orientation.
     * @default 'horizontal'
     */
    orientation: PropTypes.oneOf(['horizontal', 'vertical']),

    /**
     * @ignore
     */
    role: PropTypes
    /* @typescript-to-proptypes-ignore */
    .string,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The text alignment.
     * @default 'center'
     */
    textAlign: PropTypes.oneOf(['center', 'left', 'right']),

    /**
     * The variant to use.
     * @default 'fullWidth'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['fullWidth', 'inset', 'middle']), PropTypes.string])
  } ;
  var Divider$1 = Divider;

  const _excluded$1m = ["addEndListener", "appear", "children", "container", "direction", "easing", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "style", "timeout", "TransitionComponent"];

  function getTranslateValue(direction, node, resolvedContainer) {
    const rect = node.getBoundingClientRect();
    const containerRect = resolvedContainer && resolvedContainer.getBoundingClientRect();
    const containerWindow = ownerWindow(node);
    let transform;

    if (node.fakeTransform) {
      transform = node.fakeTransform;
    } else {
      const computedStyle = containerWindow.getComputedStyle(node);
      transform = computedStyle.getPropertyValue('-webkit-transform') || computedStyle.getPropertyValue('transform');
    }

    let offsetX = 0;
    let offsetY = 0;

    if (transform && transform !== 'none' && typeof transform === 'string') {
      const transformValues = transform.split('(')[1].split(')')[0].split(',');
      offsetX = parseInt(transformValues[4], 10);
      offsetY = parseInt(transformValues[5], 10);
    }

    if (direction === 'left') {
      if (containerRect) {
        return `translateX(${containerRect.right + offsetX - rect.left}px)`;
      }

      return `translateX(${containerWindow.innerWidth + offsetX - rect.left}px)`;
    }

    if (direction === 'right') {
      if (containerRect) {
        return `translateX(-${rect.right - containerRect.left - offsetX}px)`;
      }

      return `translateX(-${rect.left + rect.width - offsetX}px)`;
    }

    if (direction === 'up') {
      if (containerRect) {
        return `translateY(${containerRect.bottom + offsetY - rect.top}px)`;
      }

      return `translateY(${containerWindow.innerHeight + offsetY - rect.top}px)`;
    } // direction === 'down'


    if (containerRect) {
      return `translateY(-${rect.top - containerRect.top + rect.height - offsetY}px)`;
    }

    return `translateY(-${rect.top + rect.height - offsetY}px)`;
  }

  function resolveContainer(containerPropProp) {
    return typeof containerPropProp === 'function' ? containerPropProp() : containerPropProp;
  }

  function setTranslateValue(direction, node, containerProp) {
    const resolvedContainer = resolveContainer(containerProp);
    const transform = getTranslateValue(direction, node, resolvedContainer);

    if (transform) {
      node.style.webkitTransform = transform;
      node.style.transform = transform;
    }
  }
  /**
   * The Slide transition is used by the [Drawer](/material-ui/react-drawer/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  const Slide = /*#__PURE__*/React__namespace.forwardRef(function Slide(props, ref) {
    const theme = useTheme();
    const defaultEasing = {
      enter: theme.transitions.easing.easeOut,
      exit: theme.transitions.easing.sharp
    };
    const defaultTimeout = {
      enter: theme.transitions.duration.enteringScreen,
      exit: theme.transitions.duration.leavingScreen
    };

    const {
      addEndListener,
      appear = true,
      children,
      container: containerProp,
      direction = 'down',
      easing: easingProp = defaultEasing,
      in: inProp,
      onEnter,
      onEntered,
      onEntering,
      onExit,
      onExited,
      onExiting,
      style,
      timeout = defaultTimeout,
      // eslint-disable-next-line react/prop-types
      TransitionComponent = Transition$1
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1m);

    const childrenRef = React__namespace.useRef(null);
    const handleRefIntermediary = useForkRef(children.ref, childrenRef);
    const handleRef = useForkRef(handleRefIntermediary, ref);

    const normalizedTransitionCallback = callback => isAppearing => {
      if (callback) {
        // onEnterXxx and onExitXxx callbacks have a different arguments.length value.
        if (isAppearing === undefined) {
          callback(childrenRef.current);
        } else {
          callback(childrenRef.current, isAppearing);
        }
      }
    };

    const handleEnter = normalizedTransitionCallback((node, isAppearing) => {
      setTranslateValue(direction, node, containerProp);
      reflow(node);

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    });
    const handleEntering = normalizedTransitionCallback((node, isAppearing) => {
      const transitionProps = getTransitionProps({
        timeout,
        style,
        easing: easingProp
      }, {
        mode: 'enter'
      });
      node.style.webkitTransition = theme.transitions.create('-webkit-transform', _extends({}, transitionProps));
      node.style.transition = theme.transitions.create('transform', _extends({}, transitionProps));
      node.style.webkitTransform = 'none';
      node.style.transform = 'none';

      if (onEntering) {
        onEntering(node, isAppearing);
      }
    });
    const handleEntered = normalizedTransitionCallback(onEntered);
    const handleExiting = normalizedTransitionCallback(onExiting);
    const handleExit = normalizedTransitionCallback(node => {
      const transitionProps = getTransitionProps({
        timeout,
        style,
        easing: easingProp
      }, {
        mode: 'exit'
      });
      node.style.webkitTransition = theme.transitions.create('-webkit-transform', transitionProps);
      node.style.transition = theme.transitions.create('transform', transitionProps);
      setTranslateValue(direction, node, containerProp);

      if (onExit) {
        onExit(node);
      }
    });
    const handleExited = normalizedTransitionCallback(node => {
      // No need for transitions when the component is hidden
      node.style.webkitTransition = '';
      node.style.transition = '';

      if (onExited) {
        onExited(node);
      }
    });

    const handleAddEndListener = next => {
      if (addEndListener) {
        // Old call signature before `react-transition-group` implemented `nodeRef`
        addEndListener(childrenRef.current, next);
      }
    };

    const updatePosition = React__namespace.useCallback(() => {
      if (childrenRef.current) {
        setTranslateValue(direction, childrenRef.current, containerProp);
      }
    }, [direction, containerProp]);
    React__namespace.useEffect(() => {
      // Skip configuration where the position is screen size invariant.
      if (inProp || direction === 'down' || direction === 'right') {
        return undefined;
      }

      const handleResize = debounce$1(() => {
        if (childrenRef.current) {
          setTranslateValue(direction, childrenRef.current, containerProp);
        }
      });
      const containerWindow = ownerWindow(childrenRef.current);
      containerWindow.addEventListener('resize', handleResize);
      return () => {
        handleResize.clear();
        containerWindow.removeEventListener('resize', handleResize);
      };
    }, [direction, inProp, containerProp]);
    React__namespace.useEffect(() => {
      if (!inProp) {
        // We need to update the position of the drawer when the direction change and
        // when it's hidden.
        updatePosition();
      }
    }, [inProp, updatePosition]);
    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      nodeRef: childrenRef,
      onEnter: handleEnter,
      onEntered: handleEntered,
      onEntering: handleEntering,
      onExit: handleExit,
      onExited: handleExited,
      onExiting: handleExiting,
      addEndListener: handleAddEndListener,
      appear: appear,
      in: inProp,
      timeout: timeout
    }, other, {
      children: (state, childProps) => {
        return /*#__PURE__*/React__namespace.cloneElement(children, _extends({
          ref: handleRef,
          style: _extends({
            visibility: state === 'exited' && !inProp ? 'hidden' : undefined
          }, style, children.props.style)
        }, childProps));
      }
    }));
  });
  Slide.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Add a custom transition end trigger. Called with the transitioning DOM
     * node and a done callback. Allows for more fine grained transition end
     * logic. Note: Timeouts are still used as a fallback if provided.
     */
    addEndListener: PropTypes.func,

    /**
     * Perform the enter transition when it first mounts if `in` is also `true`.
     * Set this to `false` to disable this behavior.
     * @default true
     */
    appear: PropTypes.bool,

    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1.isRequired,

    /**
     * An HTML element, or a function that returns one.
     * It's used to set the container the Slide is transitioning from.
     */
    container: chainPropTypes(PropTypes.oneOfType([HTMLElementType, PropTypes.func]), props => {
      if (props.open) {
        const resolvedContainer = resolveContainer(props.container);

        if (resolvedContainer && resolvedContainer.nodeType === 1) {
          const box = resolvedContainer.getBoundingClientRect();

          if (box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            return new Error(['MUI: The `container` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        } else if (!resolvedContainer || typeof resolvedContainer.getBoundingClientRect !== 'function' || resolvedContainer.contextElement != null && resolvedContainer.contextElement.nodeType !== 1) {
          return new Error(['MUI: The `container` prop provided to the component is invalid.', 'It should be an HTML element instance.'].join('\n'));
        }
      }

      return null;
    }),

    /**
     * Direction the child node will enter from.
     * @default 'down'
     */
    direction: PropTypes.oneOf(['down', 'left', 'right', 'up']),

    /**
     * The transition timing function.
     * You may specify a single easing or a object containing enter and exit values.
     * @default {
     *   enter: theme.transitions.easing.easeOut,
     *   exit: theme.transitions.easing.sharp,
     * }
     */
    easing: PropTypes.oneOfType([PropTypes.shape({
      enter: PropTypes.string,
      exit: PropTypes.string
    }), PropTypes.string]),

    /**
     * If `true`, the component will transition in.
     */
    in: PropTypes.bool,

    /**
     * @ignore
     */
    onEnter: PropTypes.func,

    /**
     * @ignore
     */
    onEntered: PropTypes.func,

    /**
     * @ignore
     */
    onEntering: PropTypes.func,

    /**
     * @ignore
     */
    onExit: PropTypes.func,

    /**
     * @ignore
     */
    onExited: PropTypes.func,

    /**
     * @ignore
     */
    onExiting: PropTypes.func,

    /**
     * @ignore
     */
    style: PropTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     * @default {
     *   enter: theme.transitions.duration.enteringScreen,
     *   exit: theme.transitions.duration.leavingScreen,
     * }
     */
    timeout: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  var Slide$1 = Slide;

  function getDrawerUtilityClass(slot) {
    return generateUtilityClass('MuiDrawer', slot);
  }
  const drawerClasses = generateUtilityClasses('MuiDrawer', ['root', 'docked', 'paper', 'paperAnchorLeft', 'paperAnchorRight', 'paperAnchorTop', 'paperAnchorBottom', 'paperAnchorDockedLeft', 'paperAnchorDockedRight', 'paperAnchorDockedTop', 'paperAnchorDockedBottom', 'modal']);
  var drawerClasses$1 = drawerClasses;

  const _excluded$1l = ["BackdropProps"],
        _excluded2$8 = ["anchor", "BackdropProps", "children", "className", "elevation", "hideBackdrop", "ModalProps", "onClose", "open", "PaperProps", "SlideProps", "TransitionComponent", "transitionDuration", "variant"];

  const overridesResolver$5 = (props, styles) => {
    const {
      ownerState
    } = props;
    return [styles.root, (ownerState.variant === 'permanent' || ownerState.variant === 'persistent') && styles.docked, styles.modal];
  };

  const useUtilityClasses$16 = ownerState => {
    const {
      classes,
      anchor,
      variant
    } = ownerState;
    const slots = {
      root: ['root'],
      docked: [(variant === 'permanent' || variant === 'persistent') && 'docked'],
      modal: ['modal'],
      paper: ['paper', `paperAnchor${capitalize(anchor)}`, variant !== 'temporary' && `paperAnchorDocked${capitalize(anchor)}`]
    };
    return composeClasses(slots, getDrawerUtilityClass, classes);
  };

  const DrawerRoot = styled$1(Modal$1, {
    name: 'MuiDrawer',
    slot: 'Root',
    overridesResolver: overridesResolver$5
  })(({
    theme
  }) => ({
    zIndex: (theme.vars || theme).zIndex.drawer
  }));
  const DrawerDockedRoot = styled$1('div', {
    shouldForwardProp: rootShouldForwardProp,
    name: 'MuiDrawer',
    slot: 'Docked',
    skipVariantsResolver: false,
    overridesResolver: overridesResolver$5
  })({
    flex: '0 0 auto'
  });
  const DrawerPaper = styled$1(Paper$1, {
    name: 'MuiDrawer',
    slot: 'Paper',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.paper, styles[`paperAnchor${capitalize(ownerState.anchor)}`], ownerState.variant !== 'temporary' && styles[`paperAnchorDocked${capitalize(ownerState.anchor)}`]];
    }
  })(({
    theme,
    ownerState
  }) => _extends({
    overflowY: 'auto',
    display: 'flex',
    flexDirection: 'column',
    height: '100%',
    flex: '1 0 auto',
    zIndex: (theme.vars || theme).zIndex.drawer,
    // Add iOS momentum scrolling for iOS < 13.0
    WebkitOverflowScrolling: 'touch',
    // temporary style
    position: 'fixed',
    top: 0,
    // We disable the focus ring for mouse, touch and keyboard users.
    // At some point, it would be better to keep it for keyboard users.
    // :focus-ring CSS pseudo-class will help.
    outline: 0
  }, ownerState.anchor === 'left' && {
    left: 0
  }, ownerState.anchor === 'top' && {
    top: 0,
    left: 0,
    right: 0,
    height: 'auto',
    maxHeight: '100%'
  }, ownerState.anchor === 'right' && {
    right: 0
  }, ownerState.anchor === 'bottom' && {
    top: 'auto',
    left: 0,
    bottom: 0,
    right: 0,
    height: 'auto',
    maxHeight: '100%'
  }, ownerState.anchor === 'left' && ownerState.variant !== 'temporary' && {
    borderRight: `1px solid ${(theme.vars || theme).palette.divider}`
  }, ownerState.anchor === 'top' && ownerState.variant !== 'temporary' && {
    borderBottom: `1px solid ${(theme.vars || theme).palette.divider}`
  }, ownerState.anchor === 'right' && ownerState.variant !== 'temporary' && {
    borderLeft: `1px solid ${(theme.vars || theme).palette.divider}`
  }, ownerState.anchor === 'bottom' && ownerState.variant !== 'temporary' && {
    borderTop: `1px solid ${(theme.vars || theme).palette.divider}`
  }));
  const oppositeDirection = {
    left: 'right',
    right: 'left',
    top: 'down',
    bottom: 'up'
  };
  function isHorizontal(anchor) {
    return ['left', 'right'].indexOf(anchor) !== -1;
  }
  function getAnchor(theme, anchor) {
    return theme.direction === 'rtl' && isHorizontal(anchor) ? oppositeDirection[anchor] : anchor;
  }
  /**
   * The props of the [Modal](/material-ui/api/modal/) component are available
   * when `variant="temporary"` is set.
   */

  const Drawer = /*#__PURE__*/React__namespace.forwardRef(function Drawer(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiDrawer'
    });
    const theme = useTheme();
    const defaultTransitionDuration = {
      enter: theme.transitions.duration.enteringScreen,
      exit: theme.transitions.duration.leavingScreen
    };

    const {
      anchor: anchorProp = 'left',
      BackdropProps,
      children,
      className,
      elevation = 16,
      hideBackdrop = false,
      ModalProps: {
        BackdropProps: BackdropPropsProp
      } = {},
      onClose,
      open = false,
      PaperProps = {},
      SlideProps,
      // eslint-disable-next-line react/prop-types
      TransitionComponent = Slide$1,
      transitionDuration = defaultTransitionDuration,
      variant = 'temporary'
    } = props,
          ModalProps = _objectWithoutPropertiesLoose(props.ModalProps, _excluded$1l),
          other = _objectWithoutPropertiesLoose(props, _excluded2$8); // Let's assume that the Drawer will always be rendered on user space.
    // We use this state is order to skip the appear transition during the
    // initial mount of the component.


    const mounted = React__namespace.useRef(false);
    React__namespace.useEffect(() => {
      mounted.current = true;
    }, []);
    const anchorInvariant = getAnchor(theme, anchorProp);
    const anchor = anchorProp;

    const ownerState = _extends({}, props, {
      anchor,
      elevation,
      open,
      variant
    }, other);

    const classes = useUtilityClasses$16(ownerState);

    const drawer = /*#__PURE__*/jsxRuntime_1(DrawerPaper, _extends({
      elevation: variant === 'temporary' ? elevation : 0,
      square: true
    }, PaperProps, {
      className: clsx(classes.paper, PaperProps.className),
      ownerState: ownerState,
      children: children
    }));

    if (variant === 'permanent') {
      return /*#__PURE__*/jsxRuntime_1(DrawerDockedRoot, _extends({
        className: clsx(classes.root, classes.docked, className),
        ownerState: ownerState,
        ref: ref
      }, other, {
        children: drawer
      }));
    }

    const slidingDrawer = /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      in: open,
      direction: oppositeDirection[anchorInvariant],
      timeout: transitionDuration,
      appear: mounted.current
    }, SlideProps, {
      children: drawer
    }));

    if (variant === 'persistent') {
      return /*#__PURE__*/jsxRuntime_1(DrawerDockedRoot, _extends({
        className: clsx(classes.root, classes.docked, className),
        ownerState: ownerState,
        ref: ref
      }, other, {
        children: slidingDrawer
      }));
    } // variant === temporary


    return /*#__PURE__*/jsxRuntime_1(DrawerRoot, _extends({
      BackdropProps: _extends({}, BackdropProps, BackdropPropsProp, {
        transitionDuration
      }),
      className: clsx(classes.root, classes.modal, className),
      open: open,
      ownerState: ownerState,
      onClose: onClose,
      hideBackdrop: hideBackdrop,
      ref: ref
    }, other, ModalProps, {
      children: slidingDrawer
    }));
  });
  Drawer.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Side from which the drawer will appear.
     * @default 'left'
     */
    anchor: PropTypes.oneOf(['bottom', 'left', 'right', 'top']),

    /**
     * @ignore
     */
    BackdropProps: PropTypes.object,

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The elevation of the drawer.
     * @default 16
     */
    elevation: integerPropType,

    /**
     * If `true`, the backdrop is not rendered.
     * @default false
     */
    hideBackdrop: PropTypes.bool,

    /**
     * Props applied to the [`Modal`](/material-ui/api/modal/) element.
     * @default {}
     */
    ModalProps: PropTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     */
    onClose: PropTypes.func,

    /**
     * If `true`, the component is shown.
     * @default false
     */
    open: PropTypes.bool,

    /**
     * Props applied to the [`Paper`](/material-ui/api/paper/) element.
     * @default {}
     */
    PaperProps: PropTypes.object,

    /**
     * Props applied to the [`Slide`](/material-ui/api/slide/) element.
     */
    SlideProps: PropTypes.object,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     * @default {
     *   enter: theme.transitions.duration.enteringScreen,
     *   exit: theme.transitions.duration.leavingScreen,
     * }
     */
    transitionDuration: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })]),

    /**
     * The variant to use.
     * @default 'temporary'
     */
    variant: PropTypes.oneOf(['permanent', 'persistent', 'temporary'])
  } ;
  var Drawer$1 = Drawer;

  function getFabUtilityClass(slot) {
    return generateUtilityClass('MuiFab', slot);
  }
  const fabClasses = generateUtilityClasses('MuiFab', ['root', 'primary', 'secondary', 'extended', 'circular', 'focusVisible', 'disabled', 'colorInherit', 'sizeSmall', 'sizeMedium', 'sizeLarge', 'info', 'error', 'warning', 'success']);
  var fabClasses$1 = fabClasses;

  const _excluded$1k = ["children", "className", "color", "component", "disabled", "disableFocusRipple", "focusVisibleClassName", "size", "variant"];

  const useUtilityClasses$15 = ownerState => {
    const {
      color,
      variant,
      classes,
      size
    } = ownerState;
    const slots = {
      root: ['root', variant, `size${capitalize(size)}`, color === 'inherit' ? 'colorInherit' : color]
    };
    return composeClasses(slots, getFabUtilityClass, classes);
  };

  const FabRoot = styled$1(ButtonBase$1, {
    name: 'MuiFab',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [styles.root, styles[ownerState.variant], styles[`size${capitalize(ownerState.size)}`], ownerState.color === 'inherit' && styles.colorInherit, styles[capitalize(ownerState.size)], styles[ownerState.color]];
    }
  })(({
    theme,
    ownerState
  }) => {
    var _theme$palette$getCon, _theme$palette;

    return _extends({}, theme.typography.button, {
      minHeight: 36,
      transition: theme.transitions.create(['background-color', 'box-shadow', 'border-color'], {
        duration: theme.transitions.duration.short
      }),
      borderRadius: '50%',
      padding: 0,
      minWidth: 0,
      width: 56,
      height: 56,
      zIndex: (theme.vars || theme).zIndex.fab,
      boxShadow: (theme.vars || theme).shadows[6],
      '&:active': {
        boxShadow: (theme.vars || theme).shadows[12]
      },
      color: theme.vars ? theme.vars.palette.text.primary : (_theme$palette$getCon = (_theme$palette = theme.palette).getContrastText) == null ? void 0 : _theme$palette$getCon.call(_theme$palette, theme.palette.grey[300]),
      backgroundColor: (theme.vars || theme).palette.grey[300],
      '&:hover': {
        backgroundColor: (theme.vars || theme).palette.grey.A100,
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: (theme.vars || theme).palette.grey[300]
        },
        textDecoration: 'none'
      },
      [`&.${fabClasses$1.focusVisible}`]: {
        boxShadow: (theme.vars || theme).shadows[6]
      },
      [`&.${fabClasses$1.disabled}`]: {
        color: (theme.vars || theme).palette.action.disabled,
        boxShadow: (theme.vars || theme).shadows[0],
        backgroundColor: (theme.vars || theme).palette.action.disabledBackground
      }
    }, ownerState.size === 'small' && {
      width: 40,
      height: 40
    }, ownerState.size === 'medium' && {
      width: 48,
      height: 48
    }, ownerState.variant === 'extended' && {
      borderRadius: 48 / 2,
      padding: '0 16px',
      width: 'auto',
      minHeight: 'auto',
      minWidth: 48,
      height: 48
    }, ownerState.variant === 'extended' && ownerState.size === 'small' && {
      width: 'auto',
      padding: '0 8px',
      borderRadius: 34 / 2,
      minWidth: 34,
      height: 34
    }, ownerState.variant === 'extended' && ownerState.size === 'medium' && {
      width: 'auto',
      padding: '0 16px',
      borderRadius: 40 / 2,
      minWidth: 40,
      height: 40
    }, ownerState.color === 'inherit' && {
      color: 'inherit'
    });
  }, ({
    theme,
    ownerState
  }) => _extends({}, ownerState.color !== 'inherit' && ownerState.color !== 'default' && (theme.vars || theme).palette[ownerState.color] != null && {
    color: (theme.vars || theme).palette[ownerState.color].contrastText,
    backgroundColor: (theme.vars || theme).palette[ownerState.color].main,
    '&:hover': {
      backgroundColor: (theme.vars || theme).palette[ownerState.color].dark,
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        backgroundColor: (theme.vars || theme).palette[ownerState.color].main
      }
    }
  }));
  const Fab = /*#__PURE__*/React__namespace.forwardRef(function Fab(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiFab'
    });

    const {
      children,
      className,
      color = 'default',
      component = 'button',
      disabled = false,
      disableFocusRipple = false,
      focusVisibleClassName,
      size = 'large',
      variant = 'circular'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1k);

    const ownerState = _extends({}, props, {
      color,
      component,
      disabled,
      disableFocusRipple,
      size,
      variant
    });

    const classes = useUtilityClasses$15(ownerState);
    return /*#__PURE__*/jsxRuntime_1(FabRoot, _extends({
      className: clsx(classes.root, className),
      component: component,
      disabled: disabled,
      focusRipple: !disableFocusRipple,
      focusVisibleClassName: clsx(classes.focusVisible, focusVisibleClassName),
      ownerState: ownerState,
      ref: ref
    }, other, {
      children: children
    }));
  });
  Fab.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'default'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['default', 'error', 'info', 'inherit', 'primary', 'secondary', 'success', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple is disabled.
     * @default false
     */
    disableFocusRipple: PropTypes.bool,

    /**
     * If `true`, the ripple effect is disabled.
     */
    disableRipple: PropTypes.bool,

    /**
     * @ignore
     */
    focusVisibleClassName: PropTypes.string,

    /**
     * The URL to link to when the button is clicked.
     * If defined, an `a` element will be used as the root node.
     */
    href: PropTypes.string,

    /**
     * The size of the component.
     * `small` is equivalent to the dense button styling.
     * @default 'large'
     */
    size: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['small', 'medium', 'large']), PropTypes.string]),

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * The variant to use.
     * @default 'circular'
     */
    variant: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['circular', 'extended']), PropTypes.string])
  } ;
  var Fab$1 = Fab;

  const _excluded$1j = ["disableUnderline", "components", "componentsProps", "fullWidth", "hiddenLabel", "inputComponent", "multiline", "type"];

  const useUtilityClasses$14 = ownerState => {
    const {
      classes,
      disableUnderline
    } = ownerState;
    const slots = {
      root: ['root', !disableUnderline && 'underline'],
      input: ['input']
    };
    const composedClasses = composeClasses(slots, getFilledInputUtilityClass, classes);
    return _extends({}, classes, composedClasses);
  };

  const FilledInputRoot = styled$1(InputBaseRoot, {
    shouldForwardProp: prop => rootShouldForwardProp(prop) || prop === 'classes',
    name: 'MuiFilledInput',
    slot: 'Root',
    overridesResolver: (props, styles) => {
      const {
        ownerState
      } = props;
      return [...rootOverridesResolver(props, styles), !ownerState.disableUnderline && styles.underline];
    }
  })(({
    theme,
    ownerState
  }) => {
    var _palette;

    const light = theme.palette.mode === 'light';
    const bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
    const backgroundColor = light ? 'rgba(0, 0, 0, 0.06)' : 'rgba(255, 255, 255, 0.09)';
    const hoverBackground = light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.13)';
    const disabledBackground = light ? 'rgba(0, 0, 0, 0.12)' : 'rgba(255, 255, 255, 0.12)';
    return _extends({
      position: 'relative',
      backgroundColor: theme.vars ? theme.vars.palette.FilledInput.bg : backgroundColor,
      borderTopLeftRadius: (theme.vars || theme).shape.borderRadius,
      borderTopRightRadius: (theme.vars || theme).shape.borderRadius,
      transition: theme.transitions.create('background-color', {
        duration: theme.transitions.duration.shorter,
        easing: theme.transitions.easing.easeOut
      }),
      '&:hover': {
        backgroundColor: theme.vars ? theme.vars.palette.FilledInput.hoverBg : hoverBackground,
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: theme.vars ? theme.vars.palette.FilledInput.bg : backgroundColor
        }
      },
      [`&.${filledInputClasses$1.focused}`]: {
        backgroundColor: theme.vars ? theme.vars.palette.FilledInput.bg : backgroundColor
      },
      [`&.${filledInputClasses$1.disabled}`]: {
        backgroundColor: theme.vars ? theme.vars.palette.FilledInput.disabledBg : disabledBackground
      }
    }, !ownerState.disableUnderline && {
      '&:after': {
        borderBottom: `2px solid ${(_palette = (theme.vars || theme).palette[ownerState.color || 'primary']) == null ? void 0 : _palette.main}`,
        left: 0,
        bottom: 0,
        // Doing the other way around crash on IE11 "''" https://github.com/cssinjs/jss/issues/242
        content: '""',
        position: 'absolute',
        right: 0,
        transform: 'scaleX(0)',
        transition: theme.transitions.create('transform', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        }),
        pointerEvents: 'none' // Transparent to the hover style.

      },
      [`&.${filledInputClasses$1.focused}:after`]: {
        // translateX(0) is a workaround for Safari transform scale bug
        // See https://github.com/mui/material-ui/issues/31766
        transform: 'scaleX(1) translateX(0)'
      },
      [`&.${filledInputClasses$1.error}:after`]: {
        borderBottomColor: (theme.vars || theme).palette.error.main,
        transform: 'scaleX(1)' // error is always underlined in red

      },
      '&:before': {
        borderBottom: `1px solid ${theme.vars ? `rgba(${theme.vars.palette.common.onBackgroundChannel} / ${theme.vars.opacity.inputTouchBottomLine})` : bottomLineColor}`,
        left: 0,
        bottom: 0,
        // Doing the other way around crash on IE11 "''" https://github.com/cssinjs/jss/issues/242
        content: '"\\00a0"',
        position: 'absolute',
        right: 0,
        transition: theme.transitions.create('border-bottom-color', {
          duration: theme.transitions.duration.shorter
        }),
        pointerEvents: 'none' // Transparent to the hover style.

      },
      [`&:hover:not(.${filledInputClasses$1.disabled}):before`]: {
        borderBottom: `1px solid ${(theme.vars || theme).palette.text.primary}`
      },
      [`&.${filledInputClasses$1.disabled}:before`]: {
        borderBottomStyle: 'dotted'
      }
    }, ownerState.startAdornment && {
      paddingLeft: 12
    }, ownerState.endAdornment && {
      paddingRight: 12
    }, ownerState.multiline && _extends({
      padding: '25px 12px 8px'
    }, ownerState.size === 'small' && {
      paddingTop: 21,
      paddingBottom: 4
    }, ownerState.hiddenLabel && {
      paddingTop: 16,
      paddingBottom: 17
    }));
  });
  const FilledInputInput = styled$1(InputBaseComponent, {
    name: 'MuiFilledInput',
    slot: 'Input',
    overridesResolver: inputOverridesResolver
  })(({
    theme,
    ownerState
  }) => _extends({
    paddingTop: 25,
    paddingRight: 12,
    paddingBottom: 8,
    paddingLeft: 12
  }, !theme.vars && {
    '&:-webkit-autofill': {
      WebkitBoxShadow: theme.palette.mode === 'light' ? null : '0 0 0 100px #266798 inset',
      WebkitTextFillColor: theme.palette.mode === 'light' ? null : '#fff',
      caretColor: theme.palette.mode === 'light' ? null : '#fff',
      borderTopLeftRadius: 'inherit',
      borderTopRightRadius: 'inherit'
    }
  }, theme.vars && {
    '&:-webkit-autofill': {
      borderTopLeftRadius: 'inherit',
      borderTopRightRadius: 'inherit'
    },
    [theme.getColorSchemeSelector('dark')]: {
      '&:-webkit-autofill': {
        WebkitBoxShadow: '0 0 0 100px #266798 inset',
        WebkitTextFillColor: '#fff',
        caretColor: '#fff'
      }
    }
  }, ownerState.size === 'small' && {
    paddingTop: 21,
    paddingBottom: 4
  }, ownerState.hiddenLabel && {
    paddingTop: 16,
    paddingBottom: 17
  }, ownerState.multiline && {
    paddingTop: 0,
    paddingBottom: 0,
    paddingLeft: 0,
    paddingRight: 0
  }, ownerState.startAdornment && {
    paddingLeft: 0
  }, ownerState.endAdornment && {
    paddingRight: 0
  }, ownerState.hiddenLabel && ownerState.size === 'small' && {
    paddingTop: 8,
    paddingBottom: 9
  }));
  const FilledInput = /*#__PURE__*/React__namespace.forwardRef(function FilledInput(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiFilledInput'
    });

    const {
      components = {},
      componentsProps: componentsPropsProp,
      fullWidth = false,
      // declare here to prevent spreading to DOM
      inputComponent = 'input',
      multiline = false,
      type = 'text'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1j);

    const ownerState = _extends({}, props, {
      fullWidth,
      inputComponent,
      multiline,
      type
    });

    const classes = useUtilityClasses$14(props);
    const filledInputComponentsProps = {
      root: {
        ownerState
      },
      input: {
        ownerState
      }
    };
    const componentsProps = componentsPropsProp ? deepmerge(componentsPropsProp, filledInputComponentsProps) : filledInputComponentsProps;
    return /*#__PURE__*/jsxRuntime_1(InputBase$1, _extends({
      components: _extends({
        Root: FilledInputRoot,
        Input: FilledInputInput
      }, components),
      componentsProps: componentsProps,
      fullWidth: fullWidth,
      inputComponent: inputComponent,
      multiline: multiline,
      ref: ref,
      type: type
    }, other, {
      classes: classes
    }));
  });
  FilledInput.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: PropTypes.string,

    /**
     * If `true`, the `input` element is focused during the first mount.
     */
    autoFocus: PropTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * The prop defaults to the value (`'primary'`) inherited from the parent FormControl component.
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['primary', 'secondary']), PropTypes.string]),

    /**
     * The components used for each slot inside the InputBase.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Input: PropTypes.elementType,
      Root: PropTypes.elementType
    }),

    /**
     * The props used for each slot inside the Input.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      input: PropTypes.object,
      root: PropTypes.object
    }),

    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue: PropTypes.any,

    /**
     * If `true`, the component is disabled.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the input will not have an underline.
     */
    disableUnderline: PropTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: PropTypes.node,

    /**
     * If `true`, the `input` will indicate an error.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    error: PropTypes.bool,

    /**
     * If `true`, the `input` will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,

    /**
     * If `true`, the label is hidden.
     * This is used to increase density for a `FilledInput`.
     * Be sure to add `aria-label` to the `input` element.
     * @default false
     */
    hiddenLabel: PropTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: PropTypes.string,

    /**
     * The component used for the `input` element.
     * Either a string to use a HTML element or a component.
     * @default 'input'
     */
    inputComponent: PropTypes.elementType,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     * @default {}
     */
    inputProps: PropTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType$1,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     * The prop defaults to the value (`'none'`) inherited from the parent FormControl component.
     */
    margin: PropTypes.oneOf(['dense', 'none']),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    maxRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * Minimum number of rows to display when multiline option is set to true.
     */
    minRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * If `true`, a [TextareaAutosize](/material-ui/react-textarea-autosize/) element is rendered.
     * @default false
     */
    multiline: PropTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: PropTypes.string,

    /**
     * Callback fired when the value is changed.
     *
     * @param {React.ChangeEvent<HTMLTextAreaElement | HTMLInputElement>} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: PropTypes.func,

    /**
     * The short hint displayed in the `input` before the user enters a value.
     */
    placeholder: PropTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: PropTypes.bool,

    /**
     * If `true`, the `input` element is required.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    required: PropTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: PropTypes.node,

    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),

    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     * @default 'text'
     */
    type: PropTypes.string,

    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: PropTypes.any
  } ;
  FilledInput.muiName = 'Input';
  var FilledInput$1 = FilledInput;

  function getFormControlUtilityClasses(slot) {
    return generateUtilityClass('MuiFormControl', slot);
  }
  const formControlClasses = generateUtilityClasses('MuiFormControl', ['root', 'marginNone', 'marginNormal', 'marginDense', 'fullWidth', 'disabled']);
  var formControlClasses$1 = formControlClasses;

  const _excluded$1i = ["children", "className", "color", "component", "disabled", "error", "focused", "fullWidth", "hiddenLabel", "margin", "required", "size", "variant"];

  const useUtilityClasses$13 = ownerState => {
    const {
      classes,
      margin,
      fullWidth
    } = ownerState;
    const slots = {
      root: ['root', margin !== 'none' && `margin${capitalize(margin)}`, fullWidth && 'fullWidth']
    };
    return composeClasses(slots, getFormControlUtilityClasses, classes);
  };

  const FormControlRoot = styled$1('div', {
    name: 'MuiFormControl',
    slot: 'Root',
    overridesResolver: ({
      ownerState
    }, styles) => {
      return _extends({}, styles.root, styles[`margin${capitalize(ownerState.margin)}`], ownerState.fullWidth && styles.fullWidth);
    }
  })(({
    ownerState
  }) => _extends({
    display: 'inline-flex',
    flexDirection: 'column',
    position: 'relative',
    // Reset fieldset default style.
    minWidth: 0,
    padding: 0,
    margin: 0,
    border: 0,
    verticalAlign: 'top'
  }, ownerState.margin === 'normal' && {
    marginTop: 16,
    marginBottom: 8
  }, ownerState.margin === 'dense' && {
    marginTop: 8,
    marginBottom: 4
  }, ownerState.fullWidth && {
    width: '100%'
  }));
  /**
   * Provides context such as filled/focused/error/required for form inputs.
   * Relying on the context provides high flexibility and ensures that the state always stays
   * consistent across the children of the `FormControl`.
   * This context is used by the following components:
   *
   *  - FormLabel
   *  - FormHelperText
   *  - Input
   *  - InputLabel
   *
   * You can find one composition example below and more going to [the demos](/material-ui/react-text-field/#components).
   *
   * ```jsx
   * <FormControl>
   *   <InputLabel htmlFor="my-input">Email address</InputLabel>
   *   <Input id="my-input" aria-describedby="my-helper-text" />
   *   <FormHelperText id="my-helper-text">We'll never share your email.</FormHelperText>
   * </FormControl>
   * ```
   *
   * ⚠️ Only one `InputBase` can be used within a FormControl because it create visual inconsistencies.
   * For instance, only one input can be focused at the same time, the state shouldn't be shared.
   */

  const FormControl = /*#__PURE__*/React__namespace.forwardRef(function FormControl(inProps, ref) {
    const props = useThemeProps({
      props: inProps,
      name: 'MuiFormControl'
    });

    const {
      children,
      className,
      color = 'primary',
      component = 'div',
      disabled = false,
      error = false,
      focused: visuallyFocused,
      fullWidth = false,
      hiddenLabel = false,
      margin = 'none',
      required = false,
      size = 'medium',
      variant = 'outlined'
    } = props,
          other = _objectWithoutPropertiesLoose(props, _excluded$1i);

    const ownerState = _extends({}, props, {
      color,
      component,
      disabled,
      error,
      fullWidth,
      hiddenLabel,
      margin,
      required,
      size,
      variant
    });

    const classes = useUtilityClasses$13(ownerState);
    const [adornedStart, setAdornedStart] = React__namespace.useState(() => {
      // We need to iterate through the children and find the Input in order
      // to fully support server-side rendering.
      let initialAdornedStart = false;

      if (children) {
        React__namespace.Children.forEach(children, child => {
          if (!isMuiElement(child, ['Input', 'Select'])) {
            return;
          }

          const input = isMuiElement(child, ['Select']) ? child.props.input : child;

          if (input && isAdornedStart(input.props)) {
            initialAdornedStart = true;
          }
        });
      }

      return initialAdornedStart;
    });
    const [filled, setFilled] = React__namespace.useState(() => {
      // We need to iterate through the children and find the Input in order
      // to fully support server-side rendering.
      let initialFilled = false;

      if (children) {
        React__namespace.Children.forEach(children, child => {
          if (!isMuiElement(child, ['Input', 'Select'])) {
            return;
          }

          if (isFilled(child.props, true)) {
            initialFilled = true;
          }
        });
      }

      return initialFilled;
    });
    const [focusedState, setFocused] = React__namespace.useState(false);

    if (disabled && focusedState) {
      setFocused(false);
    }

    const focused = visuallyFocused !== undefined && !disabled ? visuallyFocused : focusedState;
    let registerEffect;

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      const registeredInput = React__namespace.useRef(false);

      registerEffect = () => {
        if (registeredInput.current) {
          console.error(['MUI: There are multiple `InputBase` components inside a FormControl.', 'This creates visual inconsistencies, only use one `InputBase`.'].join('\n'));
        }

        registeredInput.current = true;
        return () => {
          registeredInput.current = false;
        };
      };
    }

    const onFilled = React__namespace.useCallback(() => {
      setFilled(true);
    }, []);
    const onEmpty = React__namespace.useCallback(() => {
      setFilled(false);
    }, []);
    const childContext = {
      adornedStart,
      setAdornedStart,
      color,
      disabled,
      error,
      filled,
      focused,
      fullWidth,
      hiddenLabel,
      size,
      onBlur: () => {
        setFocused(false);
      },
      onEmpty,
      onFilled,
      onFocus: () => {
        setFocused(true);
      },
      registerEffect,
      required,
      variant
    };
    return /*#__PURE__*/jsxRuntime_1(FormControlContext$1.Provider, {
      value: childContext,
      children: /*#__PURE__*/jsxRuntime_1(FormControlRoot, _extends({
        as: component,
        ownerState: ownerState,
        className: clsx(classes.root, className),
        ref: ref
      }, other, {
        children: children
      }))
    });
  });
  FormControl.propTypes
  /* remove-proptypes */
  = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: PropTypes.node,

    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,

    /**
     * @ignore
     */
    className: PropTypes.string,

    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#adding-new-colors).
     * @default 'primary'
     */
    color: PropTypes
    /* @typescript-to-proptypes-ignore */
    .oneOfType([PropTypes.oneOf(['primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),

    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,

    /**
     * If `true`, the label, input and helper text should be displayed in a disabled state.
     * @default false
     */
    disabled: PropTypes.bool,

    /**
     * If `true`, the label is displayed in an error state.
     * @default false
     */
    error: PropTypes.bool,

    /**
     * If `true`, th