/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.util;

import com.soywiz.klock.DateTimeSpan;
import com.soywiz.klock.ISO8601;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\f\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\r\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/core/util/UMTinCanUtil;", "", "()V", "ADL_PREFIX_VERB", "", "VERB_ANSWERED", "VERB_FAILED", "VERB_PASSED", "format8601Duration", "duration", "", "parse8601Duration", "parse8601DurationOrDefault", "defaultDuration", "core_release"})
public final class UMTinCanUtil {
    @NotNull
    public static final UMTinCanUtil INSTANCE = new UMTinCanUtil();
    @NotNull
    public static final String ADL_PREFIX_VERB = "http://adlnet.gov/expapi/verbs/";
    @NotNull
    public static final String VERB_PASSED = "http://adlnet.gov/expapi/verbs/passed";
    @NotNull
    public static final String VERB_FAILED = "http://adlnet.gov/expapi/verbs/failed";
    @NotNull
    public static final String VERB_ANSWERED = "http://adlnet.gov/expapi/verbs/answered";

    private UMTinCanUtil() {
    }

    @NotNull
    public final String format8601Duration(long duration) {
        int msPerHour = 3600000;
        int hours = (int)Math.floor(duration / (long)msPerHour);
        long durationRemaining = duration % (long)msPerHour;
        int msPerMin = 60000;
        int mins = (int)Math.floor(durationRemaining / (long)msPerMin);
        int msPerS = 1000;
        int secs = (int)Math.floor((durationRemaining %= (long)msPerMin) / (long)msPerS);
        return "PT" + hours + 'H' + mins + 'M' + secs + 'S';
    }

    public final long parse8601Duration(@NotNull String duration) {
        long l;
        DateTimeSpan time;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        DateTimeSpan dateTimeSpan = time = new ISO8601.IsoIntervalFormat("PTnnHnnMnnS").tryParse(duration, false);
        if (dateTimeSpan == null) {
            l = 0L;
        } else {
            long l2;
            double d = dateTimeSpan.getTotalMilliseconds();
            l = l2 = (long)d;
        }
        return l;
    }

    public final long parse8601DurationOrDefault(@Nullable String duration, long defaultDuration) {
        return duration != null ? this.parse8601Duration(duration) : defaultDuration;
    }

    public static /* synthetic */ long parse8601DurationOrDefault$default(UMTinCanUtil uMTinCanUtil, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return uMTinCanUtil.parse8601DurationOrDefault(string, l);
    }
}

