/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.impl;

import android.annotation.TargetApi;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import com.ustadmobile.core.contentformats.har.HarContent;
import com.ustadmobile.core.contentformats.har.HarNameValuePair;
import com.ustadmobile.core.contentformats.har.HarRequest;
import com.ustadmobile.core.contentformats.har.HarResponse;
import com.ustadmobile.core.io.RangeInputStream;
import com.ustadmobile.core.io.ext.ContainerEntryFileJvmExtKt;
import com.ustadmobile.core.util.ext.HarContentExtKt;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.util.RangeUtilKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0007\u00a8\u0006\n"}, d2={"getInputStreamFromContent", "Ljava/io/InputStream;", "Lcom/ustadmobile/core/contentformats/har/HarResponse;", "toHarRequest", "Lcom/ustadmobile/core/contentformats/har/HarRequest;", "Landroid/webkit/WebResourceRequest;", "payload", "", "toWebResourceResponse", "Landroid/webkit/WebResourceResponse;", "core_release"})
public final class HarWebViewClientKt {
    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    @NotNull
    public static final HarRequest toHarRequest(@NotNull WebResourceRequest $this$toHarRequest, @Nullable String payload) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toHarRequest, (String)"<this>");
        HarRequest request = new HarRequest();
        request.setUrl($this$toHarRequest.getUrl().toString());
        Map map = $this$toHarRequest.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.requestHeaders");
        HarRequest harRequest = request;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getKey();
            Intrinsics.checkNotNullExpressionValue(object, (String)"it.key");
            String string2 = (String)object;
            object = it.getValue();
            Intrinsics.checkNotNullExpressionValue(object, (String)"it.value");
            collection.add(new HarNameValuePair(string2, (String)object));
        }
        harRequest.setHeaders((List)destination$iv$iv);
        request.setMethod($this$toHarRequest.getMethod());
        request.setBody(payload);
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    @NotNull
    public static final WebResourceResponse toWebResourceResponse(@NotNull HarResponse $this$toWebResourceResponse) {
        String string2;
        String string3;
        List $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toWebResourceResponse, (String)"<this>");
        Iterable $this$map$iv = $this$toWebResourceResponse.getHeaders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HarNameValuePair harNameValuePair = (HarNameValuePair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getValue()));
        }
        Map headerMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        InputStream inputStreamContent = HarWebViewClientKt.getInputStreamFromContent($this$toWebResourceResponse);
        if ($this$toWebResourceResponse.getStatus() == 206 && inputStreamContent != null) {
            String string4;
            String string5;
            List list;
            String string6 = (String)headerMap.get(RangeUtilKt.getRANGE_CONTENT_RANGE_HEADER());
            if (string6 == null) {
                list = null;
            } else {
                String $i$f$mapTo2 = StringsKt.substringAfter$default((String)string6, (String)"bytes ", null, (int)2, null);
                if ($i$f$mapTo2 == null) {
                    list = null;
                } else {
                    String string7 = StringsKt.substringBefore$default((String)$i$f$mapTo2, (String)"/", null, (int)2, null);
                    if (string7 == null) {
                        list = null;
                    } else {
                        String[] stringArray = new String[]{"-"};
                        list = StringsKt.split$default((CharSequence)string7, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    }
                }
            }
            $this$mapTo$iv$iv = list;
            List rangeString = $this$mapTo$iv$iv == null ? CollectionsKt.emptyList() : $this$mapTo$iv$iv;
            long fromByte = Long.parseLong((String)rangeString.get(0));
            long toByte = Long.parseLong((String)rangeString.get(1));
            HarContent harContent = $this$toWebResourceResponse.getContent();
            if (harContent == null) {
                string5 = "text/html";
            } else {
                String string8 = harContent.getMimeType();
                if (string8 == null) {
                    string5 = "text/html";
                } else {
                    String[] stringArray = new String[]{";"};
                    List list2 = StringsKt.split$default((CharSequence)string8, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    if (list2 == null) {
                        string5 = "text/html";
                    } else {
                        string5 = (String)list2.get(0);
                        if (string5 == null) {
                            string5 = "text/html";
                        }
                    }
                }
            }
            HarContent harContent2 = $this$toWebResourceResponse.getContent();
            if (harContent2 == null) {
                string4 = "utf-8";
            } else {
                string4 = harContent2.getEncoding();
                if (string4 == null) {
                    string4 = "utf-8";
                }
            }
            int n = $this$toWebResourceResponse.getStatus() < 100 || $this$toWebResourceResponse.getStatus() > 299 || $this$toWebResourceResponse.getStatus() < 400 ? 200 : $this$toWebResourceResponse.getStatus();
            String string9 = $this$toWebResourceResponse.getStatusText();
            if (string9 == null) {
                string9 = "OK";
            }
            return new WebResourceResponse(string5, string4, n, string9, headerMap, (InputStream)new RangeInputStream(inputStreamContent, fromByte, toByte));
        }
        HarContent harContent = $this$toWebResourceResponse.getContent();
        if (harContent == null) {
            string3 = "text/html";
        } else {
            String string10 = harContent.getMimeType();
            if (string10 == null) {
                string3 = "text/html";
            } else {
                String[] stringArray = new String[]{";"};
                List list = StringsKt.split$default((CharSequence)string10, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (list == null) {
                    string3 = "text/html";
                } else {
                    string3 = (String)list.get(0);
                    if (string3 == null) {
                        string3 = "text/html";
                    }
                }
            }
        }
        HarContent harContent3 = $this$toWebResourceResponse.getContent();
        if (harContent3 == null) {
            string2 = "utf-8";
        } else {
            string2 = harContent3.getEncoding();
            if (string2 == null) {
                string2 = "utf-8";
            }
        }
        int n = $this$toWebResourceResponse.getStatus() < 100 || $this$toWebResourceResponse.getStatus() > 299 || $this$toWebResourceResponse.getStatus() < 400 ? 200 : $this$toWebResourceResponse.getStatus();
        String string11 = $this$toWebResourceResponse.getStatusText();
        if (string11 == null) {
            string11 = "OK";
        }
        return new WebResourceResponse(string3, string2, n, string11, headerMap, inputStreamContent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final InputStream getInputStreamFromContent(@NotNull HarResponse $this$getInputStreamFromContent) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)$this$getInputStreamFromContent, (String)"<this>");
        HarContent harContent = $this$getInputStreamFromContent.getContent();
        if (harContent == null ? false : HarContentExtKt.isTextContent(harContent)) {
            HarContent harContent2 = $this$getInputStreamFromContent.getContent();
            if ((harContent2 == null ? null : harContent2.getText()) != null) {
                byte[] byArray;
                HarContent harContent3 = $this$getInputStreamFromContent.getContent();
                if (harContent3 == null) {
                    byArray = null;
                } else {
                    String string2 = harContent3.getText();
                    if (string2 == null) {
                        byArray = null;
                    } else {
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        byte[] byArray = string2.getBytes(charset);
                        byArray = byArray;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                    }
                }
                inputStream = new ByteArrayInputStream(byArray);
                return inputStream;
            }
        }
        HarContent harContent4 = $this$getInputStreamFromContent.getContent();
        if (harContent4 == null) {
            return null;
        }
        ContainerEntryFile containerEntryFile = harContent4.getEntryFile();
        if (containerEntryFile == null) {
            return null;
        }
        inputStream = ContainerEntryFileJvmExtKt.openInputStream(containerEntryFile);
        return inputStream;
    }
}

