/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.schedule;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.ustadmobile.core.schedule.ClazzLogCreatorManager;
import com.ustadmobile.core.schedule.ClazzLogScheduleWorker;
import com.ustadmobile.core.util.ext.OneTimeWorkRequestBuilderExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/core/schedule/ClazzLogCreatorManagerAndroidImpl;", "Lcom/ustadmobile/core/schedule/ClazzLogCreatorManager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "requestClazzLogCreation", "", "clazzUid", "", "endpointUrl", "", "fromTime", "toTime", "core_release"})
public final class ClazzLogCreatorManagerAndroidImpl
implements ClazzLogCreatorManager {
    @NotNull
    private final Context context;

    public ClazzLogCreatorManagerAndroidImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public void requestClazzLogCreation(long clazzUid, @NotNull String endpointUrl, long fromTime, long toTime) {
        Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
        Data.Builder builder = new Data.Builder().putLong("clazzUidFilter", clazzUid).putString("dbName", endpointUrl).putLong("fromTime", fromTime).putLong("toTime", toTime);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n            .p\u2026ong(INPUT_TOTIME, toTime)");
        Data.Builder inputData = builder;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)OneTimeWorkRequestBuilderExtKt.setInitialDelayIfLater(new OneTimeWorkRequest.Builder(ClazzLogScheduleWorker.class), fromTime).setInputData(inputData.build())).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(ClazzLogSchedule\u2026\n                .build()");
        OneTimeWorkRequest request = (OneTimeWorkRequest)workRequest;
        WorkManager.getInstance((Context)this.context).enqueueUniqueWork("genclazzlog-" + endpointUrl + '-' + clazzUid, ExistingWorkPolicy.REPLACE, request);
    }
}

