/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.contentjob;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.contentjob.ContentJobManager;
import com.ustadmobile.core.contentjob.ContentJobRunnerWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/core/contentjob/ContentJobManagerAndroid;", "Lcom/ustadmobile/core/contentjob/ContentJobManager;", "appContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getAppContext", "()Landroid/content/Context;", "cancelContentJob", "", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "contentJobUid", "", "enqueueContentJob", "core_release"})
public final class ContentJobManagerAndroid
implements ContentJobManager {
    @NotNull
    private final Context appContext;

    public ContentJobManagerAndroid(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
    }

    @NotNull
    public final Context getAppContext() {
        return this.appContext;
    }

    @Override
    public void enqueueContentJob(@NotNull Endpoint endpoint, long contentJobUid) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Data data = new Data.Builder().putString("endpoint", endpoint.getUrl()).putLong("cjUid", contentJobUid).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n            .p\u2026Uid)\n            .build()");
        Data inputData = data;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ContentJobRunnerWorker.class).setInputData(inputData)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(ContentJobRunner\u2026ata)\n            .build()");
        OneTimeWorkRequest request = (OneTimeWorkRequest)workRequest;
        WorkManager.getInstance((Context)this.appContext).enqueueUniqueWork("contentjob-" + endpoint.getUrl() + '-' + contentJobUid, ExistingWorkPolicy.REPLACE, request);
    }

    @Override
    public void cancelContentJob(@NotNull Endpoint endpoint, long contentJobUid) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        WorkManager.getInstance((Context)this.appContext).cancelUniqueWork("contentjob-" + endpoint.getUrl() + '-' + contentJobUid);
    }
}

