/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.io.ext;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.lib.util.UmAccountUtilKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"makeTempDir", "Ljava/io/File;", "prefix", "", "postfix", "getUnCompressedSize", "", "isGzipped", "", "isParentOf", "parent", "siteDataSubDir", "siteEndpoint", "Lcom/ustadmobile/core/account/Endpoint;", "core_debug"})
public final class FileCommonJvmExtKt {
    @NotNull
    public static final File siteDataSubDir(@NotNull File $this$siteDataSubDir, @NotNull Endpoint siteEndpoint) {
        Intrinsics.checkNotNullParameter((Object)$this$siteDataSubDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)siteEndpoint, (String)"siteEndpoint");
        return new File(new File($this$siteDataSubDir, "sitedata"), UmAccountUtilKt.sanitizeDbNameFromUrl((String)siteEndpoint.getUrl()));
    }

    public static final boolean isParentOf(@NotNull File $this$isParentOf, @NotNull File parent) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$isParentOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        File parentNormalized = FilesKt.normalize((File)parent);
        File parentToCheck = $this$isParentOf.getParentFile();
        do {
            File file2 = parentToCheck;
            if (Intrinsics.areEqual((Object)(file2 == null ? null : FilesKt.normalize((File)file2)), (Object)parentNormalized)) {
                return true;
            }
            file = parentToCheck;
        } while ((parentToCheck = file == null ? null : file.getParentFile()) != null);
        return false;
    }

    @NotNull
    public static final File makeTempDir(@NotNull String prefix, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        File tmpDir = File.createTempFile(prefix, postfix);
        if (!tmpDir.delete() || !tmpDir.mkdirs()) {
            throw new IOException("Could not delete / create tmp dir");
        }
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        return tmpDir;
    }

    public static /* synthetic */ File makeTempDir$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        return FileCommonJvmExtKt.makeTempDir(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getUnCompressedSize(@NotNull File $this$getUnCompressedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getUnCompressedSize, (String)"<this>");
        byte[] byteArray = new byte[8192];
        int byteCount = 0;
        if (FileCommonJvmExtKt.isGzipped($this$getUnCompressedSize)) {
            Closeable closeable = new FileInputStream($this$getUnCompressedSize);
            Throwable throwable = null;
            try {
                FileInputStream fileInput = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new GZIPInputStream(fileInput);
                Throwable throwable2 = null;
                try {
                    int n;
                    GZIPInputStream gzip = (GZIPInputStream)closeable2;
                    boolean bl2 = false;
                    do {
                        int it = n = gzip.read(byteArray);
                        boolean bl3 = false;
                        byteCount += it;
                    } while (n != -1);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return byteCount;
        }
        return $this$getUnCompressedSize.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isGzipped(@NotNull File $this$isGzipped) {
        Intrinsics.checkNotNullParameter((Object)$this$isGzipped, (String)"<this>");
        Closeable closeable = new FileInputStream($this$isGzipped);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            byte[] signature = new byte[2];
            int nread = it.read(signature);
            boolean bl2 = nread == 2 && signature[0] == 31 && signature[1] == -117;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

