/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageAlpha3Code;
import com.neovisionaries.i18n.LanguageCode;
import com.ustadmobile.core.container.ContainerAddOptions;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ContentCategoryDao;
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao;
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.core.io.ext.UmAppDatabaseContainerIoExtKt;
import com.ustadmobile.core.util.UMFileUtil;
import com.ustadmobile.door.DoorUri;
import com.ustadmobile.door.ext.FileExpectExtKt;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.LogIndex;
import com.ustadmobile.lib.contentscrapers.LogResponse;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.ShrinkerUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.khanacademy.ItemData;
import com.ustadmobile.lib.contentscrapers.util.SrtFormat;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContentCategory;
import com.ustadmobile.lib.db.entities.ContentCategorySchema;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import com.ustadmobile.lib.db.entities.ScrapeQueueItem;
import io.github.aakira.napier.Napier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.HarNameValuePair;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fJ.\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010%\u001a\u00020$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00040'J\u0089\u0001\u0010(\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020>J<\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00042\b\u0010B\u001a\u0004\u0018\u00010\u00042\b\u0010C\u001a\u0004\u0018\u00010$2\b\u0010D\u001a\u0004\u0018\u00010$2\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010FJ6\u0010H\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00042\b\u0010B\u001a\u0004\u0018\u00010\u00042\b\u0010C\u001a\u0004\u0018\u00010$2\b\u0010D\u001a\u0004\u0018\u00010$2\b\u0010I\u001a\u0004\u0018\u00010JJ.\u0010K\u001a\u00020@2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010%\u001a\u00020$2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0004J\u008f\u0001\u0010O\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010PJ@\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020>2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010<\u001a\u00020$2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020.2\u0006\u0010Y\u001a\u00020.J\u001e\u0010Z\u001a\u00020\u00042\u000e\u0010[\u001a\n\u0012\u0004\u0012\u00020\\\u0018\u00010\r2\u0006\u0010]\u001a\u00020$J\u0016\u0010^\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020$2\u0006\u0010N\u001a\u00020\u0004J\u0010\u0010_\u001a\u00020\u001c2\b\u0010`\u001a\u0004\u0018\u00010$J\u001e\u0010a\u001a\u00020\u00042\u0006\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u00020$2\u0006\u0010d\u001a\u00020>J*\u0010e\u001a\u00020$2\u0006\u0010=\u001a\u00020>2\u0006\u0010<\u001a\u00020$2\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010f\u001a\u0004\u0018\u00010\u0004JB\u0010g\u001a\u00020\u001c2\u001c\u0010h\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0018\u00010iR\u00060jR\u00020k0'2\u0006\u0010l\u001a\u00020$2\u0006\u0010m\u001a\u00020\u00042\f\u0010n\u001a\b\u0012\u0004\u0012\u00020@0FJ\u000e\u0010o\u001a\u0002042\u0006\u0010D\u001a\u00020$J\u000e\u0010p\u001a\u00020\u00042\u0006\u0010q\u001a\u000200JF\u0010r\u001a\u00020\u001c2\u0006\u0010s\u001a\u00020$2\u0006\u0010t\u001a\u00020\u00042\u0006\u0010u\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010v\u001a\u00020\u00042\u0006\u0010w\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u0010x\u001a\u00020\u0004J\u000e\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|J\u000e\u0010}\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>J&\u0010~\u001a\u0004\u0018\u00010\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\u00042\u0007\u0010\u0081\u0001\u001a\u00020\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u0010\u0010\u0084\u0001\u001a\u00020\u00042\u0007\u0010\u0085\u0001\u001a\u00020$J^\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u00162\u0007\u0010\u008b\u0001\u001a\u0002042\u0007\u0010\u008c\u0001\u001a\u00020\u00042\u0007\u0010\u008d\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u00020$2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0092\u0001\u001a\u00020$H\u0007J%\u0010\u0093\u0001\u001a\u00030\u0094\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u0099\u0001\u001a\u00020\u0004J%\u0010\u009a\u0001\u001a\u00030\u009b\u00012\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\b\u0010\u009e\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u009f\u0001\u001a\u00020\u0016J/\u0010\u00a0\u0001\u001a\u00030\u00a1\u00012\b\u0010\u0082\u0001\u001a\u00030\u00a2\u00012\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u009f\u0001\u001a\u00020\u00162\u0007\u0010\u00a4\u0001\u001a\u00020.J\u001a\u0010\u00a5\u0001\u001a\u00020\u007f2\b\u0010\u00a6\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0080\u0001\u001a\u00020\u0004J\u001a\u0010\u00a7\u0001\u001a\u00020\u007f2\b\u0010\u00a8\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u00a9\u0001\u001a\u00020\u0004J\u001a\u0010\u00aa\u0001\u001a\u00020\u007f2\b\u0010\u00a6\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u00ab\u0001\u001a\u00020\u0004J\"\u0010\u00ac\u0001\u001a\u00020\u001c2\b\u0010\u00a8\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0080\u0001\u001a\u00020\u00042\u0006\u0010u\u001a\u00020\u0004J(\u0010\u00ad\u0001\u001a\u0005\u0018\u00010\u00ae\u00012\b\u0010\u00af\u0001\u001a\u00030\u00b0\u00012\t\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u00b2\u0001\u001a\u00020\u007fJ/\u0010\u00b3\u0001\u001a\u00030\u00a1\u00012\b\u0010\u0082\u0001\u001a\u00030\u00a2\u00012\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u009f\u0001\u001a\u00020\u00162\u0007\u0010\u00a4\u0001\u001a\u00020.J-\u0010\u00b4\u0001\u001a\u00030\u00b5\u00012\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u00012\u0007\u0010\u00b8\u0001\u001a\u00020\u00162\u0007\u0010\u00a3\u0001\u001a\u00020\u00162\u0007\u0010\u00b9\u0001\u001a\u00020.J$\u0010\u00ba\u0001\u001a\u00030\u0098\u00012\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u00012\u0007\u0010\u00bd\u0001\u001a\u00020\u00042\u0007\u0010\u00be\u0001\u001a\u00020\u0004J(\u0010\u00bf\u0001\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u00042\u0007\u0010\u00c0\u0001\u001a\u0002002\u0006\u0010*\u001a\u00020\u0004JC\u0010\u00c1\u0001\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u00042\u0007\u0010\u00c0\u0001\u001a\u0002002\u0006\u0010*\u001a\u00020\u00042\u0007\u0010\u00c2\u0001\u001a\u00020\u00042\u0007\u0010\u00c3\u0001\u001a\u00020.2\u0007\u0010\u00c4\u0001\u001a\u000200J\u0018\u0010\u00c5\u0001\u001a\u0002042\u0007\u0010\u00c6\u0001\u001a\u0002002\u0006\u0010D\u001a\u00020$J\u0019\u0010\u00c7\u0001\u001a\u0002042\u0007\u0010\u00c8\u0001\u001a\u00020$2\u0007\u0010\u00c9\u0001\u001a\u00020\u0004J!\u0010\u00ca\u0001\u001a\u0002042\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u00012\u0006\u0010c\u001a\u00020$2\u0006\u0010N\u001a\u00020\u0004J\u0010\u0010\u00cd\u0001\u001a\u0002042\u0007\u0010\u00ce\u0001\u001a\u00020\u0004J\u000f\u0010\u00cf\u0001\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0007\u0010\u00d0\u0001\u001a\u00020\u001fJ\u0010\u0010\u00d1\u0001\u001a\u0002002\u0007\u0010\u00d2\u0001\u001a\u00020\u0004J \u0010\u00d3\u0001\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u000f\u0010\u00d4\u0001\u001a\n\u0012\u0005\u0012\u00030\u00d6\u00010\u00d5\u0001J$\u0010\u00d7\u0001\u001a\u00020\u001c2\u0006\u0010c\u001a\u00020$2\u000b\u0010\u00d8\u0001\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010N\u001a\u00020\u0004J\u0007\u0010\u00d9\u0001\u001a\u00020\u001cJ\u0010\u0010\u00da\u0001\u001a\u00020\u001f2\u0007\u0010\u00db\u0001\u001a\u000204J\u0010\u0010\u00dc\u0001\u001a\u00020\u001f2\u0007\u0010\u00dd\u0001\u001a\u00020zJ\u0007\u0010\u00de\u0001\u001a\u00020\u001fJ\u0011\u0010\u00df\u0001\u001a\u0002042\b\u0010\u00e0\u0001\u001a\u00030\u00e1\u0001J\u0016\u0010\u00e2\u0001\u001a\t\u0012\u0005\u0012\u00030\u00e3\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u0010\u00e4\u0001\u001a\u00020\u001c2\u0007\u0010\u00e5\u0001\u001a\u00020$2\u0007\u0010\u00e6\u0001\u001a\u00020\u00042\u0007\u0010\u00e7\u0001\u001a\u00020$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u00e8\u0001"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ContentScraperUtil;", "", "()V", "CHROME_PATH_KEY", "", "CODEC2_PATH_KEY", "FFMPEG_PATH_KEY", "LOOSE_ISO_DATE_TIME_ZONE_PARSER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "MOGRIFY_PATH_KEY", "SEARCH_LOCATIONS", "", "", "getSEARCH_LOCATIONS", "()Ljava/util/Map;", "WEBP_PATH_KEY", "YOUTUBE_DL_PATH_KEY", "driversList", "getDriversList", "()Ljava/util/List;", "checkContentEntryChanges", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "changedEntry", "oldEntry", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "checkIfPathsToDriversExist", "", "clearChromeConsoleLog", "driver", "Lorg/openqa/selenium/chrome/ChromeDriver;", "convertMapToStringBuffer", "Ljava/lang/StringBuffer;", "params", "createContainerFromDirectory", "Ljava/io/File;", "directory", "filemap", "", "createContentEntryObject", "id", "title", "sourceUrl", "publisher", "licenseType", "", "primaryLanguage", "", "languageVariant", "description", "isLeaf", "", "author", "thumbnailUrl", "licenseName", "licenseUrl", "contentTypeFlag", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IJLjava/lang/Long;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Lcom/ustadmobile/lib/db/entities/ContentEntry;", "createDirectoryFromUrl", "destination", "url", "Ljava/net/URL;", "createIndexFromHar", "Lcom/ustadmobile/lib/contentscrapers/LogIndex$IndexEntry;", "urlString", "mimeType", "urlDirectory", "file", "headers", "", "Lnet/lightbody/bmp/core/har/HarNameValuePair;", "createIndexFromLog", "log", "Lcom/ustadmobile/lib/contentscrapers/LogResponse;", "createIndexWithResourceFiles", "filePath", "Ljava/io/InputStream;", "fileName", "createOrUpdateContentEntry", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IJLjava/lang/Long;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILcom/ustadmobile/core/db/dao/ContentEntryDao;)Lcom/ustadmobile/lib/db/entities/ContentEntry;", "createQueueItem", "Lcom/ustadmobile/lib/db/entities/ScrapeQueueItem;", "queueDao", "Lcom/ustadmobile/core/db/dao/ScrapeQueueItemDao;", "subjectUrl", "subjectEntry", "type", "runId", "itemType", "createSrtFile", "srtFormatList", "Lcom/ustadmobile/lib/contentscrapers/util/SrtFormat;", "srtFile", "deleteETagOrModified", "deleteFile", "content", "downloadAllResources", "html", "destinationDir", "baseUrl", "downloadFileFromLogIndex", "cookies", "downloadImagesFromJsonContent", "images", "Lcom/ustadmobile/lib/contentscrapers/khanacademy/ItemData$Content$Image;", "Lcom/ustadmobile/lib/contentscrapers/khanacademy/ItemData$Content;", "Lcom/ustadmobile/lib/contentscrapers/khanacademy/ItemData;", "destDir", "scrapeUrl", "indexList", "fileHasContent", "formatTimeInMs", "timeMs", "generateTinCanXMLFile", "destinationDirectory", "activityName", "langCode", "typeText", "entityId", "descLang", "getDefaultSeleniumProxy", "Lorg/openqa/selenium/Proxy;", "proxy", "Lnet/lightbody/bmp/BrowserMobProxyServer;", "getFileNameFromUrl", "getLanguageFromDao", "Lcom/ustadmobile/lib/db/entities/Language;", "langName", "twoLetterCode", "dao", "Lcom/ustadmobile/core/db/dao/LanguageDao;", "getMd5", "ePubFile", "insertContainer", "Lcom/ustadmobile/lib/db/entities/Container;", "containerDao", "Lcom/ustadmobile/core/db/dao/ContainerDao;", "contentEntry", "mobileOptimized", "fileType", "lastModified", "tmpDir", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "repository", "containerDir", "insertOrUpdateCategoryContent", "Lcom/ustadmobile/lib/db/entities/ContentCategory;", "categoryDao", "Lcom/ustadmobile/core/db/dao/ContentCategoryDao;", "schema", "Lcom/ustadmobile/lib/db/entities/ContentCategorySchema;", "categoryName", "insertOrUpdateChildWithMultipleCategoriesJoin", "Lcom/ustadmobile/lib/db/entities/ContentEntryContentCategoryJoin;", "contentEntryCategoryJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryContentCategoryJoinDao;", "category", "childEntry", "insertOrUpdateChildWithMultipleParentsJoin", "Lcom/ustadmobile/lib/db/entities/ContentEntryParentChildJoin;", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "parentEntry", "index", "insertOrUpdateLanguageByName", "languageDao", "insertOrUpdateLanguageByThreeCode", "langDao", "langThreeCode", "insertOrUpdateLanguageByTwoCode", "langTwoCode", "insertOrUpdateLanguageManual", "insertOrUpdateLanguageVariant", "Lcom/ustadmobile/lib/db/entities/LanguageVariant;", "variantDao", "Lcom/ustadmobile/core/db/dao/LanguageVariantDao;", "variant", "language", "insertOrUpdateParentChildJoin", "insertOrUpdateRelatedContentJoin", "Lcom/ustadmobile/lib/db/entities/ContentEntryRelatedEntryJoin;", "contentEntryRelatedJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryRelatedEntryJoinDao;", "relatedEntry", "relatedType", "insertOrUpdateSchema", "categorySchemeDao", "Lcom/ustadmobile/core/db/dao/ContentCategorySchemaDao;", "schemaName", "schemaUrl", "insertTempContentEntry", "primaryLanguageUid", "insertTempYoutubeContentEntry", "publisherText", "license", "langVariant", "isContentUpdated", "modifiedTime", "isFileContentsUpdated", "modifiedFile", "data", "isFileModified", "conn", "Ljava/net/URLConnection;", "isImportedComponent", "component_type", "loginCK12", "loginKhanAcademy", "parseServerDate", "date", "returnListOfCookies", "cookieList", "", "Lorg/openqa/selenium/Cookie;", "saveListAsJson", "list", "setChromeDriverLocation", "setupChrome", "headless", "setupChromeDriverWithSeleniumProxy", "seleniumProxy", "setupLogIndexChromeDriver", "waitForJSandJQueryToLoad", "waitDriver", "Lorg/openqa/selenium/support/ui/WebDriverWait;", "waitForNewFiles", "Lorg/openqa/selenium/logging/LogEntry;", "zipDirectory", "directoryToZip", "filename", "locationToSave", "lib-content-scrapers"})
public final class ContentScraperUtil {
    @NotNull
    public static final ContentScraperUtil INSTANCE = new ContentScraperUtil();
    private static final DateTimeFormatter LOOSE_ISO_DATE_TIME_ZONE_PARSER = DateTimeFormatter.ofPattern("[yyyyMMdd][yyyy-MM-dd][yyyy-DDD]['T'[HHmmss][HHmm][HH:mm:ss][HH:mm][.SSSSSSSSS][.SSSSSS][.SSS][.SS][.S]][OOOO][O][z][XXXXX][XXXX]['['VV']']");
    @NotNull
    public static final String CHROME_PATH_KEY = "chromedriver";
    @NotNull
    public static final String FFMPEG_PATH_KEY = "webm";
    @NotNull
    public static final String CODEC2_PATH_KEY = "codec2";
    @NotNull
    public static final String WEBP_PATH_KEY = "webp";
    @NotNull
    public static final String MOGRIFY_PATH_KEY = "mogrify";
    @NotNull
    public static final String YOUTUBE_DL_PATH_KEY = "youtube-dl";
    @NotNull
    private static final Map<String, List<String>> SEARCH_LOCATIONS;
    @NotNull
    private static final List<String> driversList;

    private ContentScraperUtil() {
    }

    @NotNull
    public final Map<String, List<String>> getSEARCH_LOCATIONS() {
        return SEARCH_LOCATIONS;
    }

    @NotNull
    public final List<String> getDriversList() {
        return driversList;
    }

    public final void checkIfPathsToDriversExist() {
        Iterable $this$forEach$iv = driversList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            String driver;
            block3: {
                driver = (String)element$iv;
                boolean bl = false;
                if (System.getProperty(driver) != null) continue;
                Iterable $this$firstOrNull$iv = (Iterable)MapsKt.getValue(INSTANCE.getSEARCH_LOCATIONS(), (Object)driver);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    String it = (String)element$iv2;
                    boolean bl2 = false;
                    if (!new File(it).exists()) continue;
                    v0 = element$iv2;
                    break block3;
                }
                v0 = null;
            }
            String location = v0;
            if (location != null) {
                System.setProperty(driver, location);
                continue;
            }
            System.out.println((Object)Intrinsics.stringPlus((String)driver, (Object)" path is not set"));
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public final boolean isImportedComponent(@NotNull String component_type) {
        Intrinsics.checkNotNullParameter((Object)component_type, (String)"component_type");
        return StringsKt.equals((String)ScraperConstants.ComponentType.IMPORTED.getType(), (String)component_type, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String downloadAllResources(@NotNull String html, @NotNull File destinationDir, @NotNull URL baseUrl) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        if (((CharSequence)html).length() == 0) {
            return html;
        }
        Document doc = Jsoup.parse((String)html);
        Elements contentList = doc.select("[src]");
        for (org.jsoup.nodes.Element content : contentList) {
            Object contentUrl;
            String videoHtml;
            String url;
            String string = url = content.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"data:image", (boolean)false, (int)2, null)) {
                string = url;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"base64", (boolean)false, (int)2, null)) continue;
            }
            string = url;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"file://", (boolean)false, (int)2, null)) continue;
            string = url;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"braingenie.ck12.org", (boolean)false, (int)2, null)) {
                videoHtml = null;
                try {
                    String string2 = url;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url");
                    if (StringsKt.startsWith$default((String)string2, (String)"//", (boolean)false, (int)2, null)) {
                        url = Intrinsics.stringPlus((String)"https:", (Object)url);
                    }
                    string2 = Jsoup.connect((String)url).followRedirects(true).get().select("video").outerHtml();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connect(url).followRedir\u2026lect(\"video\").outerHtml()");
                    videoHtml = string2;
                }
                catch (IOException e) {
                    continue;
                }
                org.jsoup.nodes.Element element = content.parent();
                if (element == null) continue;
                element.html(this.downloadAllResources(videoHtml, destinationDir, baseUrl));
                continue;
            }
            videoHtml = url;
            Intrinsics.checkNotNullExpressionValue((Object)videoHtml, (String)"url");
            if (StringsKt.contains$default((CharSequence)videoHtml, (CharSequence)"youtube", (boolean)false, (int)2, null)) {
                org.jsoup.nodes.Element element = content.parent();
                if (element == null) continue;
                element.html("");
                continue;
            }
            videoHtml = url;
            Intrinsics.checkNotNullExpressionValue((Object)videoHtml, (String)"url");
            if (StringsKt.contains$default((CharSequence)videoHtml, (CharSequence)"www.slideshare.net", (boolean)false, (int)2, null)) {
                org.jsoup.nodes.Element element = content.parent();
                if (element == null) continue;
                element.html("");
                continue;
            }
            HttpURLConnection conn = null;
            try {
                Object object;
                File contentFile;
                contentUrl = new URL(baseUrl, url);
                URLConnection uRLConnection = ((URL)contentUrl).openConnection();
                if (uRLConnection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                conn = (HttpURLConnection)uRLConnection;
                conn.setRequestMethod("HEAD");
                String fileName = this.getFileNameFromUrl((URL)contentUrl);
                File destinationFile = contentFile = new File(destinationDir, fileName);
                String ext = FilenameUtils.getExtension((String)fileName);
                if (ScraperConstants.INSTANCE.getIMAGE_EXTENSIONS().contains(ext)) {
                    object = contentFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contentFile.path");
                    destinationFile = new File(Intrinsics.stringPlus((String)UMFileUtil.INSTANCE.stripExtensionIfPresent((String)object), (Object)".webp"));
                } else if (ScraperConstants.INSTANCE.getVIDEO_EXTENSIONS().contains(ext)) {
                    object = contentFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contentFile.path");
                    destinationFile = new File(Intrinsics.stringPlus((String)UMFileUtil.INSTANCE.stripExtensionIfPresent((String)object), (Object)".webm"));
                } else if (ScraperConstants.INSTANCE.getAUDIO_EXTENSIONS().contains(ext)) {
                    object = contentFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contentFile.path");
                    destinationFile = new File(Intrinsics.stringPlus((String)UMFileUtil.INSTANCE.stripExtensionIfPresent((String)object), (Object)".opus"));
                }
                content.attr("src", destinationDir.getName() + '/' + destinationFile.getName());
                if (!this.isFileModified(conn, destinationDir, fileName) && this.fileHasContent(destinationFile)) {
                    object = conn;
                    ((HttpURLConnection)object).disconnect();
                    continue;
                }
                FileUtils.copyURLToFile((URL)contentUrl, (File)contentFile);
                object = destinationFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"destinationFile.name");
                if (StringsKt.endsWith$default((String)object, (String)".webp", (boolean)false, (int)2, null)) {
                    ShrinkerUtil.INSTANCE.convertImageToWebp(contentFile, destinationFile);
                    contentFile.delete();
                } else {
                    object = destinationFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"destinationFile.name");
                    if (StringsKt.endsWith$default((String)object, (String)".webm", (boolean)false, (int)2, null)) {
                        ShrinkerUtil.INSTANCE.convertVideoToWebM(contentFile, destinationFile);
                        contentFile.delete();
                    } else {
                        object = destinationFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"destinationFile.name");
                        if (StringsKt.endsWith$default((String)object, (String)".opus", (boolean)false, (int)2, null)) {
                            ShrinkerUtil.INSTANCE.convertAudioToOpos(contentFile, destinationFile);
                            contentFile.delete();
                        }
                    }
                }
                contentUrl = conn;
            }
            catch (IOException e) {
                System.out.println((Object)("Url path " + url + " failed to download to file with base url " + baseUrl));
                e.printStackTrace();
                continue;
            }
            finally {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) continue;
                httpURLConnection.disconnect();
                continue;
            }
            ((HttpURLConnection)contentUrl).disconnect();
        }
        String string = doc.body().html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc.body().html()");
        return string;
    }

    @NotNull
    public final String getFileNameFromUrl(@NotNull URL url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String decodedPath = URLDecoder.decode(url.getPath(), "UTF-8");
        CharSequence charSequence = FilenameUtils.getPath((String)decodedPath);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getPath(decodedPath)");
        charSequence = charSequence;
        Regex regex = new Regex("[^a-zA-Z0-9\\.\\-]");
        String string2 = "_";
        String string3 = regex.replace(charSequence, string2);
        charSequence = FilenameUtils.getName((String)decodedPath);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getName(decodedPath)");
        charSequence = charSequence;
        regex = new Regex("[^a-zA-Z0-9\\.\\-]");
        string2 = "_";
        String fileName = Intrinsics.stringPlus((String)string3, (Object)regex.replace(charSequence, string2));
        if (((CharSequence)fileName).length() == 0) {
            charSequence = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"url.path");
            charSequence = charSequence;
            regex = new Regex("[^a-zA-Z0-9\\.\\-]");
            string2 = "_";
            string = regex.replace(charSequence, string2);
        } else {
            string = fileName;
        }
        return string;
    }

    public final void saveListAsJson(@NotNull File destinationDir, @NotNull List<?> list, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String savedQuestionsJson = gson.toJson(list, (Type)((Object)List.class));
        File savedQuestionsFile = new File(destinationDir, fileName);
        FileUtils.writeStringToFile((File)savedQuestionsFile, (String)savedQuestionsJson, (String)"UTF-8");
    }

    public final boolean isContentUpdated(long modifiedTime, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileHasContent(file) ? modifiedTime >= file.lastModified() : true;
    }

    public final boolean fileHasContent(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.exists() && file.length() > 0L;
    }

    public final long parseServerDate(@NotNull String date) {
        long l;
        TemporalQuery[] temporalQueryArray;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        TemporalQuery[] temporalQueryArray2 = new TemporalQuery[]{ContentScraperUtil::parseServerDate$lambda-2, ContentScraperUtil::parseServerDate$lambda-3, ContentScraperUtil::parseServerDate$lambda-4};
        TemporalAccessor temporalAccessor = LOOSE_ISO_DATE_TIME_ZONE_PARSER.parseBest(date, temporalQueryArray2);
        ZonedDateTime zonedDateTime = temporalAccessor instanceof ZonedDateTime ? (ZonedDateTime)temporalAccessor : null;
        if (zonedDateTime == null) {
            temporalQueryArray = null;
        } else {
            Instant instant = zonedDateTime.toInstant();
            temporalQueryArray = temporalQueryArray2 = instant == null ? null : Long.valueOf(instant.toEpochMilli());
        }
        if (temporalQueryArray2 == null) {
            Long l2;
            Long l3;
            LocalDateTime localDateTime = temporalAccessor instanceof LocalDateTime ? (LocalDateTime)temporalAccessor : null;
            if (localDateTime == null) {
                l3 = null;
            } else {
                ZonedDateTime zonedDateTime2 = localDateTime.atZone(ZoneId.systemDefault());
                if (zonedDateTime2 == null) {
                    l3 = null;
                } else {
                    Instant instant = zonedDateTime2.toInstant();
                    l3 = l2 = instant == null ? null : Long.valueOf(instant.toEpochMilli());
                }
            }
            if (l2 == null) {
                TemporalAccessor temporalAccessor2 = temporalAccessor;
                if (temporalAccessor2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.time.LocalDate");
                }
                l = ((LocalDate)temporalAccessor2).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            } else {
                l = l2;
            }
        } else {
            l = temporalQueryArray2.longValue();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zipDirectory(@NotNull File directoryToZip, @NotNull String filename, @NotNull File locationToSave) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directoryToZip, (String)"directoryToZip");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)locationToSave, (String)"locationToSave");
        File zippedFile = new File(locationToSave, filename);
        Closeable closeable = new ZipOutputStream(Files.newOutputStream(zippedFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            ZipOutputStream out = (ZipOutputStream)closeable;
            boolean bl = false;
            Path sourceDirPath = Paths.get(directoryToZip.toURI());
            Files.walk(sourceDirPath, new FileVisitOption[0]).filter(ContentScraperUtil::zipDirectory$lambda-7$lambda-5).forEach(arg_0 -> ContentScraperUtil.zipDirectory$lambda-7$lambda-6(sourceDirPath, out, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Map<File, String> createContainerFromDirectory(@NotNull File directory, @NotNull Map<File, String> filemap) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(filemap, (String)"filemap");
        Path sourceDirPath = Paths.get(directory.toURI());
        try {
            Files.walk(sourceDirPath, new FileVisitOption[0]).filter(ContentScraperUtil::createContainerFromDirectory$lambda-8).forEach(arg_0 -> ContentScraperUtil.createContainerFromDirectory$lambda-9(sourceDirPath, filemap, arg_0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filemap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean waitForJSandJQueryToLoad(@NotNull WebDriverWait waitDriver) {
        Intrinsics.checkNotNullParameter((Object)waitDriver, (String)"waitDriver");
        ExpectedCondition jQueryLoad = ContentScraperUtil::waitForJSandJQueryToLoad$lambda-10;
        ExpectedCondition jsLoad = ContentScraperUtil::waitForJSandJQueryToLoad$lambda-11;
        Object object = waitDriver.until((Function)jQueryLoad);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"waitDriver.until(jQueryLoad)");
        if ((Boolean)object == false) return false;
        object = waitDriver.until((Function)jsLoad);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"waitDriver.until(jsLoad)");
        if ((Boolean)object == false) return false;
        return true;
    }

    public final void generateTinCanXMLFile(@NotNull File destinationDirectory, @NotNull String activityName, @NotNull String langCode, @NotNull String fileName, @NotNull String typeText, @NotNull String entityId, @NotNull String description, @NotNull String descLang) throws TransformerException, ParserConfigurationException {
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)typeText, (String)"typeText");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)descLang, (String)"descLang");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        org.w3c.dom.Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElement("tincan");
        Attr xlms = doc.createAttribute("xmlns");
        xlms.setValue("http://projecttincan.com/tincan.xsd");
        rootElement.setAttributeNode(xlms);
        doc.appendChild(rootElement);
        Element activities = doc.createElement("activities");
        rootElement.appendChild(activities);
        Element activityNode = doc.createElement("activity");
        Attr id = doc.createAttribute("id");
        Attr type2 = doc.createAttribute("type");
        id.setValue(entityId);
        type2.setValue(typeText);
        activityNode.setAttributeNode(id);
        activityNode.setAttributeNode(type2);
        activities.appendChild(activityNode);
        Element nameElement = doc.createElement("name");
        nameElement.appendChild(doc.createTextNode(activityName));
        activityNode.appendChild(nameElement);
        Element descElement = doc.createElement("description");
        Attr lang = doc.createAttribute("lang");
        lang.setValue(descLang);
        descElement.setAttributeNode(lang);
        descElement.appendChild(doc.createTextNode(description));
        activityNode.appendChild(descElement);
        Element launchElement = doc.createElement("launch");
        Attr langLaunch = doc.createAttribute("lang");
        langLaunch.setValue(langCode);
        launchElement.setAttributeNode(langLaunch);
        launchElement.appendChild(doc.createTextNode(fileName));
        activityNode.appendChild(launchElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(destinationDirectory, "tincan.xml"));
        transformer.transform(source, result);
    }

    @NotNull
    public final ChromeDriver setupChrome(boolean headless) {
        ChromeOptions option = new ChromeOptions();
        option.setHeadless(headless);
        return new ChromeDriver(option);
    }

    public final void setChromeDriverLocation() {
    }

    public final boolean isFileModified(@NotNull URLConnection conn, @NotNull File destinationDir, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String eTag = conn.getHeaderField("ETag");
        if (eTag != null) {
            CharSequence charSequence = eTag;
            Regex regex = new Regex("\"");
            String string = "";
            eTag = regex.replace(charSequence, string);
            File eTagFile = new File(destinationDir, Intrinsics.stringPlus((String)FilenameUtils.getBaseName((String)fileName), (Object)"etag.txt"));
            return this.isFileContentsUpdated(eTagFile, eTag);
        }
        String lastModified = conn.getHeaderField("Last-Modified");
        File modifiedFile = new File(destinationDir, Intrinsics.stringPlus((String)FilenameUtils.getBaseName((String)fileName), (Object)"last-modified.txt"));
        return lastModified != null ? this.isFileContentsUpdated(modifiedFile, lastModified) : true;
    }

    public final void deleteETagOrModified(@NotNull File destination, @NotNull String fileName) {
        File modifiedFile;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File eTagFile = new File(destination, Intrinsics.stringPlus((String)FilenameUtils.getBaseName((String)fileName), (Object)"etag.txt"));
        if (this.fileHasContent(eTagFile)) {
            this.deleteFile(eTagFile);
        }
        if (this.fileHasContent(modifiedFile = new File(destination, Intrinsics.stringPlus((String)FilenameUtils.getBaseName((String)fileName), (Object)"last-modified.txt")))) {
            this.deleteFile(modifiedFile);
        }
    }

    @NotNull
    public final ContentEntryParentChildJoin insertOrUpdateParentChildJoin(@NotNull ContentEntryParentChildJoinDao dao, @Nullable ContentEntry parentEntry, @NotNull ContentEntry childEntry, int index) {
        ContentEntryParentChildJoin contentEntryParentChildJoin;
        int n;
        long l;
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)childEntry, (String)"childEntry");
        ContentEntryParentChildJoin existingParentChildJoin = dao.findParentByChildUuids(childEntry.getContentEntryUid());
        ContentEntryParentChildJoin newJoin = new ContentEntryParentChildJoin(0L, 0L, 0, 7, null);
        ContentEntry contentEntry = parentEntry;
        newJoin.setCepcjParentContentEntryUid(contentEntry == null ? -4103245208651563007L : (l = contentEntry.getContentEntryUid()));
        newJoin.setCepcjChildContentEntryUid(childEntry.getContentEntryUid());
        if (index == 0) {
            int n2;
            ContentEntryParentChildJoin contentEntryParentChildJoin2 = existingParentChildJoin;
            n = contentEntryParentChildJoin2 == null ? index : (n2 = contentEntryParentChildJoin2.getChildIndex());
        } else {
            n = index;
        }
        newJoin.setChildIndex(n);
        if (existingParentChildJoin == null) {
            newJoin.setCepcjUid(dao.insert((Object)newJoin));
            contentEntryParentChildJoin = newJoin;
        } else {
            newJoin.setCepcjUid(existingParentChildJoin.getCepcjUid());
            if (!Intrinsics.areEqual((Object)newJoin, (Object)existingParentChildJoin)) {
                dao.update((Object)newJoin);
            }
            contentEntryParentChildJoin = newJoin;
        }
        return contentEntryParentChildJoin;
    }

    @NotNull
    public final ContentEntryParentChildJoin insertOrUpdateChildWithMultipleParentsJoin(@NotNull ContentEntryParentChildJoinDao dao, @Nullable ContentEntry parentEntry, @NotNull ContentEntry childEntry, int index) {
        ContentEntryParentChildJoin contentEntryParentChildJoin;
        int n;
        String string;
        long l;
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)childEntry, (String)"childEntry");
        ContentEntry contentEntry = parentEntry;
        long parentUid = contentEntry == null ? -4103245208651563007L : (l = contentEntry.getContentEntryUid());
        ContentEntryParentChildJoin existingParentChildJoin = dao.findJoinByParentChildUuids(parentUid, childEntry.getContentEntryUid());
        StringBuilder stringBuilder = new StringBuilder().append("Joining 2 entries, parent: ");
        ContentEntry contentEntry2 = parentEntry;
        if (contentEntry2 == null) {
            string = "root";
        } else {
            string = contentEntry2.getTitle();
            if (string == null) {
                string = "root";
            }
        }
        Napier.d$default((Napier)Napier.INSTANCE, (String)stringBuilder.append(string).append(" and child ").append((Object)childEntry.getTitle()).toString(), null, (String)"Scraper", (int)2, null);
        ContentEntryParentChildJoin newJoin = new ContentEntryParentChildJoin(0L, 0L, 0, 7, null);
        newJoin.setCepcjParentContentEntryUid(parentUid);
        newJoin.setCepcjChildContentEntryUid(childEntry.getContentEntryUid());
        if (index == 0) {
            int n2;
            ContentEntryParentChildJoin contentEntryParentChildJoin2 = existingParentChildJoin;
            n = contentEntryParentChildJoin2 == null ? index : (n2 = contentEntryParentChildJoin2.getChildIndex());
        } else {
            n = index;
        }
        newJoin.setChildIndex(n);
        if (existingParentChildJoin == null) {
            String string2;
            newJoin.setCepcjUid(dao.insert((Object)newJoin));
            StringBuilder stringBuilder2 = new StringBuilder().append("didnt exist in db, make new one ").append(newJoin.getCepcjUid()).append(" for parent ");
            ContentEntry contentEntry3 = parentEntry;
            if (contentEntry3 == null) {
                string2 = "root";
            } else {
                string2 = contentEntry3.getTitle();
                if (string2 == null) {
                    string2 = "root";
                }
            }
            Napier.d$default((Napier)Napier.INSTANCE, (String)stringBuilder2.append(string2).toString(), null, (String)"Scraper", (int)2, null);
            contentEntryParentChildJoin = newJoin;
        } else {
            String string3;
            newJoin.setCepcjUid(existingParentChildJoin.getCepcjUid());
            if (!Intrinsics.areEqual((Object)newJoin, (Object)existingParentChildJoin)) {
                dao.update((Object)newJoin);
            }
            StringBuilder stringBuilder3 = new StringBuilder().append("updated db with uid ").append(newJoin.getCepcjUid()).append(" for ");
            ContentEntry contentEntry4 = parentEntry;
            if (contentEntry4 == null) {
                string3 = "root";
            } else {
                string3 = contentEntry4.getTitle();
                if (string3 == null) {
                    string3 = "root";
                }
            }
            Napier.d$default((Napier)Napier.INSTANCE, (String)stringBuilder3.append(string3).toString(), null, (String)"Scraper", (int)2, null);
            contentEntryParentChildJoin = newJoin;
        }
        return contentEntryParentChildJoin;
    }

    @NotNull
    public final ContentEntryContentCategoryJoin insertOrUpdateChildWithMultipleCategoriesJoin(@NotNull ContentEntryContentCategoryJoinDao contentEntryCategoryJoinDao, @NotNull ContentCategory category, @NotNull ContentEntry childEntry) {
        Intrinsics.checkNotNullParameter((Object)contentEntryCategoryJoinDao, (String)"contentEntryCategoryJoinDao");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)childEntry, (String)"childEntry");
        ContentEntryContentCategoryJoin categoryToSimulationJoin = contentEntryCategoryJoinDao.findJoinByParentChildUuids(category.getContentCategoryUid(), childEntry.getContentEntryUid());
        if (categoryToSimulationJoin == null) {
            categoryToSimulationJoin = new ContentEntryContentCategoryJoin();
            categoryToSimulationJoin.setCeccjContentCategoryUid(category.getContentCategoryUid());
            categoryToSimulationJoin.setCeccjContentEntryUid(childEntry.getContentEntryUid());
            categoryToSimulationJoin.setCeccjUid(contentEntryCategoryJoinDao.insert((Object)categoryToSimulationJoin));
        } else {
            ContentEntryContentCategoryJoin changedCategoryEntryJoin = new ContentEntryContentCategoryJoin();
            changedCategoryEntryJoin.setCeccjUid(categoryToSimulationJoin.getCeccjUid());
            changedCategoryEntryJoin.setCeccjContentCategoryUid(category.getContentCategoryUid());
            changedCategoryEntryJoin.setCeccjContentEntryUid(childEntry.getContentEntryUid());
            if (!Intrinsics.areEqual((Object)changedCategoryEntryJoin, (Object)categoryToSimulationJoin)) {
                contentEntryCategoryJoinDao.update((Object)changedCategoryEntryJoin);
            }
            categoryToSimulationJoin = changedCategoryEntryJoin;
        }
        return categoryToSimulationJoin;
    }

    @NotNull
    public final ContentCategorySchema insertOrUpdateSchema(@NotNull ContentCategorySchemaDao categorySchemeDao, @NotNull String schemaName, @NotNull String schemaUrl) {
        Intrinsics.checkNotNullParameter((Object)categorySchemeDao, (String)"categorySchemeDao");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Intrinsics.checkNotNullParameter((Object)schemaUrl, (String)"schemaUrl");
        ContentCategorySchema schema = categorySchemeDao.findBySchemaUrl(schemaUrl);
        if (schema == null) {
            schema = new ContentCategorySchema();
            schema.setSchemaName(schemaName);
            schema.setSchemaUrl(schemaUrl);
            schema.setContentCategorySchemaUid(categorySchemeDao.insert((Object)schema));
        } else {
            ContentCategorySchema changedSchema = new ContentCategorySchema();
            changedSchema.setContentCategorySchemaUid(schema.getContentCategorySchemaUid());
            changedSchema.setSchemaName(schemaName);
            changedSchema.setSchemaUrl(schemaUrl);
            if (!Intrinsics.areEqual((Object)changedSchema, (Object)schema)) {
                categorySchemeDao.update((Object)changedSchema);
            }
            schema = changedSchema;
        }
        return schema;
    }

    @NotNull
    public final ContentCategory insertOrUpdateCategoryContent(@NotNull ContentCategoryDao categoryDao, @NotNull ContentCategorySchema schema, @NotNull String categoryName) {
        Intrinsics.checkNotNullParameter((Object)categoryDao, (String)"categoryDao");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)categoryName, (String)"categoryName");
        ContentCategory category = categoryDao.findCategoryBySchemaIdAndName(schema.getContentCategorySchemaUid(), categoryName);
        if (category == null) {
            category = new ContentCategory();
            category.setCtnCatContentCategorySchemaUid(schema.getContentCategorySchemaUid());
            category.setName(categoryName);
            category.setContentCategoryUid(categoryDao.insert((Object)category));
        } else {
            ContentCategory changedCategory = new ContentCategory();
            changedCategory.setContentCategoryUid(category.getContentCategoryUid());
            changedCategory.setCtnCatContentCategorySchemaUid(schema.getContentCategorySchemaUid());
            changedCategory.setName(categoryName);
            if (!Intrinsics.areEqual((Object)changedCategory, (Object)category)) {
                categoryDao.update((Object)changedCategory);
            }
            category = changedCategory;
        }
        return category;
    }

    @NotNull
    public final ContentEntryRelatedEntryJoin insertOrUpdateRelatedContentJoin(@NotNull ContentEntryRelatedEntryJoinDao contentEntryRelatedJoinDao, @NotNull ContentEntry relatedEntry, @NotNull ContentEntry parentEntry, int relatedType) {
        Intrinsics.checkNotNullParameter((Object)contentEntryRelatedJoinDao, (String)"contentEntryRelatedJoinDao");
        Intrinsics.checkNotNullParameter((Object)relatedEntry, (String)"relatedEntry");
        Intrinsics.checkNotNullParameter((Object)parentEntry, (String)"parentEntry");
        ContentEntryRelatedEntryJoin relatedTranslationJoin = contentEntryRelatedJoinDao.findPrimaryByTranslation(relatedEntry.getContentEntryUid());
        if (relatedTranslationJoin == null) {
            relatedTranslationJoin = new ContentEntryRelatedEntryJoin();
            relatedTranslationJoin.setCerejRelLanguageUid(relatedEntry.getPrimaryLanguageUid());
            relatedTranslationJoin.setCerejContentEntryUid(parentEntry.getContentEntryUid());
            relatedTranslationJoin.setCerejRelatedEntryUid(relatedEntry.getContentEntryUid());
            relatedTranslationJoin.setRelType(relatedType);
            relatedTranslationJoin.setCerejUid(contentEntryRelatedJoinDao.insert((Object)relatedTranslationJoin));
        } else {
            ContentEntryRelatedEntryJoin changedRelatedJoin = new ContentEntryRelatedEntryJoin();
            changedRelatedJoin.setCerejUid(relatedTranslationJoin.getCerejUid());
            changedRelatedJoin.setCerejRelLanguageUid(relatedEntry.getPrimaryLanguageUid());
            changedRelatedJoin.setCerejContentEntryUid(parentEntry.getContentEntryUid());
            changedRelatedJoin.setCerejRelatedEntryUid(relatedEntry.getContentEntryUid());
            changedRelatedJoin.setRelType(relatedType);
            if (!Intrinsics.areEqual((Object)changedRelatedJoin, (Object)relatedTranslationJoin)) {
                contentEntryRelatedJoinDao.update(changedRelatedJoin);
            }
            relatedTranslationJoin = changedRelatedJoin;
        }
        return relatedTranslationJoin;
    }

    @NotNull
    public final Language insertOrUpdateLanguageByName(@NotNull LanguageDao languageDao, @NotNull String langName) {
        Language langObj;
        Intrinsics.checkNotNullParameter((Object)languageDao, (String)"languageDao");
        Intrinsics.checkNotNullParameter((Object)langName, (String)"langName");
        String threeLetterCode = "";
        String twoLetterCode = "";
        List langAlpha3List = LanguageAlpha3Code.findByName((String)langName);
        if (!langAlpha3List.isEmpty()) {
            threeLetterCode = ((LanguageAlpha3Code)langAlpha3List.get(0)).name();
            LanguageCode code = LanguageCode.getByCode((String)threeLetterCode);
            String string = twoLetterCode = code != null ? LanguageCode.getByCode((String)threeLetterCode).name() : "";
        }
        if ((langObj = this.getLanguageFromDao(langName, twoLetterCode, languageDao)) == null) {
            langObj = new Language();
            langObj.setName(langName);
            if (!(((CharSequence)threeLetterCode).length() == 0)) {
                langObj.setIso_639_1_standard(twoLetterCode);
                langObj.setIso_639_2_standard(threeLetterCode);
            }
            langObj.setLangUid(languageDao.insert((Object)langObj));
        } else {
            Language changedLang = new Language();
            changedLang.setLangUid(langObj.getLangUid());
            changedLang.setName(langName);
            boolean isChanged = false;
            if (!Intrinsics.areEqual((Object)changedLang.getName(), (Object)langObj.getName())) {
                isChanged = true;
            }
            if (!(((CharSequence)threeLetterCode).length() == 0)) {
                changedLang.setIso_639_1_standard(twoLetterCode);
                changedLang.setIso_639_2_standard(threeLetterCode);
                if (!Intrinsics.areEqual((Object)changedLang.getIso_639_1_standard(), (Object)langObj.getIso_639_1_standard())) {
                    isChanged = true;
                }
                if (!Intrinsics.areEqual((Object)changedLang.getIso_639_2_standard(), (Object)langObj.getIso_639_2_standard())) {
                    isChanged = true;
                }
            }
            if (isChanged) {
                languageDao.update(changedLang);
            }
            langObj = changedLang;
        }
        return langObj;
    }

    private final Language getLanguageFromDao(String langName, String twoLetterCode, LanguageDao dao) {
        Language lang = null;
        if (!(((CharSequence)langName).length() == 0)) {
            lang = dao.findByName(langName);
        }
        return !(((CharSequence)twoLetterCode).length() == 0) && lang == null ? dao.findByTwoCode(twoLetterCode) : lang;
    }

    @NotNull
    public final Language insertOrUpdateLanguageByTwoCode(@NotNull LanguageDao languageDao, @NotNull String langTwoCode) {
        Intrinsics.checkNotNullParameter((Object)languageDao, (String)"languageDao");
        Intrinsics.checkNotNullParameter((Object)langTwoCode, (String)"langTwoCode");
        Language language = languageDao.findByTwoCode(langTwoCode);
        if (language == null) {
            language = new Language();
            language.setIso_639_1_standard(langTwoCode);
            LanguageCode nameOfLang = LanguageCode.getByCode((String)langTwoCode);
            if (nameOfLang != null) {
                language.setName(nameOfLang.getName());
            }
            language.setLangUid(languageDao.insert((Object)language));
        } else {
            Language changedLang = new Language();
            changedLang.setLangUid(language.getLangUid());
            changedLang.setIso_639_1_standard(langTwoCode);
            LanguageCode nameOfLang = LanguageCode.getByCode((String)langTwoCode);
            if (nameOfLang != null) {
                changedLang.setName(nameOfLang.getName());
            }
            boolean isChanged = false;
            if (language.getIso_639_1_standard() == null || !Intrinsics.areEqual((Object)language.getIso_639_1_standard(), (Object)changedLang.getIso_639_1_standard())) {
                isChanged = true;
            }
            if (language.getName() == null || Intrinsics.areEqual((Object)language.getName(), (Object)changedLang.getName())) {
                isChanged = true;
            }
            if (isChanged) {
                languageDao.update(changedLang);
            }
            language = changedLang;
        }
        return language;
    }

    @NotNull
    public final Language insertOrUpdateLanguageByThreeCode(@NotNull LanguageDao langDao, @NotNull String langThreeCode) {
        Intrinsics.checkNotNullParameter((Object)langDao, (String)"langDao");
        Intrinsics.checkNotNullParameter((Object)langThreeCode, (String)"langThreeCode");
        Language language = langDao.findByThreeCode(langThreeCode);
        if (language == null) {
            language = new Language();
            language.setIso_639_3_standard(langThreeCode);
            LanguageCode nameOfLang = LanguageCode.getByCode((String)langThreeCode);
            if (nameOfLang != null) {
                language.setName(nameOfLang.getName());
            } else {
                language.setName(LanguageAlpha3Code.getByCode((String)langThreeCode).getName());
            }
            language.setLangUid(langDao.insert((Object)language));
        } else {
            Language changedLang = new Language();
            changedLang.setLangUid(language.getLangUid());
            changedLang.setIso_639_3_standard(langThreeCode);
            LanguageCode nameOfLang = LanguageCode.getByCode((String)langThreeCode);
            if (nameOfLang != null) {
                changedLang.setName(nameOfLang.getName());
            } else {
                LanguageAlpha3Code code = LanguageAlpha3Code.getByCode((String)langThreeCode);
                if (code != null) {
                    language.setName(LanguageAlpha3Code.getByCode((String)langThreeCode).getName());
                }
            }
            boolean isChanged = false;
            if (language.getIso_639_3_standard() == null || !Intrinsics.areEqual((Object)language.getIso_639_3_standard(), (Object)changedLang.getIso_639_3_standard())) {
                isChanged = true;
            }
            if (language.getName() == null || Intrinsics.areEqual((Object)language.getName(), (Object)changedLang.getName())) {
                isChanged = true;
            }
            if (isChanged) {
                langDao.update(changedLang);
            }
            language = changedLang;
        }
        return language;
    }

    public final boolean isFileContentsUpdated(@NotNull File modifiedFile, @NotNull String data) throws IOException {
        Intrinsics.checkNotNullParameter((Object)modifiedFile, (String)"modifiedFile");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.fileHasContent(modifiedFile)) {
            String text = FileUtils.readFileToString((File)modifiedFile, (String)"UTF-8");
            return !StringsKt.equals((String)data, (String)text, (boolean)true);
        }
        FileUtils.writeStringToFile((File)modifiedFile, (String)data, (String)"UTF-8");
        return true;
    }

    @NotNull
    public final Proxy getDefaultSeleniumProxy(@NotNull BrowserMobProxyServer proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Proxy proxy2 = ClientUtil.createSeleniumProxy((BrowserMobProxy)((BrowserMobProxy)proxy));
        Intrinsics.checkNotNullExpressionValue((Object)proxy2, (String)"createSeleniumProxy(proxy)");
        return proxy2;
    }

    @Deprecated(message="not updated since scrapers")
    @NotNull
    public final Container insertContainer(@NotNull ContainerDao containerDao, @NotNull ContentEntry contentEntry, boolean mobileOptimized, @NotNull String fileType, long lastModified, @NotNull File tmpDir, @NotNull UmAppDatabase db, @NotNull UmAppDatabase repository, @NotNull File containerDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)containerDao, (String)"containerDao");
        Intrinsics.checkNotNullParameter((Object)contentEntry, (String)"contentEntry");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        Container container2 = new Container();
        container2.setMimeType(fileType);
        container2.setCntLastModified(lastModified);
        container2.setContainerContentEntryUid(contentEntry.getContentEntryUid());
        container2.setMobileOptimized(mobileOptimized);
        container2.setContainerUid(containerDao.insert((Object)container2));
        ContainerAddOptions containerAddOptions = new ContainerAddOptions(FileExpectExtKt.toDoorUri((File)containerDir), false, null, null, false, 30, null);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tmpDir, fileType, repository, container2, containerAddOptions, null){
            int label;
            final /* synthetic */ File $tmpDir;
            final /* synthetic */ String $fileType;
            final /* synthetic */ UmAppDatabase $repository;
            final /* synthetic */ Container $container;
            final /* synthetic */ ContainerAddOptions $containerAddOptions;
            {
                this.$tmpDir = $tmpDir;
                this.$fileType = $fileType;
                this.$repository = $repository;
                this.$container = $container;
                this.$containerAddOptions = $containerAddOptions;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$tmpDir.isDirectory() || !Intrinsics.areEqual((Object)this.$fileType, (Object)"application/zip") && !Intrinsics.areEqual((Object)this.$fileType, (Object)"application/epub+zip") && !Intrinsics.areEqual((Object)this.$fileType, (Object)"application/tincan+zip")) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = UmAppDatabaseContainerIoExtKt.addEntriesToContainerFromZip((UmAppDatabase)this.$repository, (long)this.$container.getContainerUid(), (DoorUri)FileExpectExtKt.toDoorUri((File)this.$tmpDir), (ContainerAddOptions)this.$containerAddOptions, (Object)new Object(), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return container2;
    }

    @NotNull
    public final String getMd5(@NotNull File ePubFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ePubFile, (String)"ePubFile");
        FileInputStream fis = new FileInputStream(ePubFile);
        String md5EpubFile = DigestUtils.md5Hex((InputStream)fis);
        fis.close();
        Intrinsics.checkNotNullExpressionValue((Object)md5EpubFile, (String)"md5EpubFile");
        return md5EpubFile;
    }

    @Nullable
    public final LanguageVariant insertOrUpdateLanguageVariant(@NotNull LanguageVariantDao variantDao, @Nullable String variant, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)variantDao, (String)"variantDao");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageVariant languageVariant = null;
        if (variant != null && ((CharSequence)variant).length() > 0) {
            String string = variant.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
            CountryCode countryCode = CountryCode.getByCode((String)string);
            if (countryCode == null) {
                List countryList = CountryCode.findByName((String)variant);
                Intrinsics.checkNotNullExpressionValue((Object)countryList, (String)"countryList");
                if (!((Collection)countryList).isEmpty()) {
                    countryCode = (CountryCode)countryList.get(0);
                }
            }
            if (countryCode != null) {
                String alpha2 = countryCode.getAlpha2();
                String name = countryCode.getName();
                Intrinsics.checkNotNullExpressionValue((Object)alpha2, (String)"alpha2");
                languageVariant = variantDao.findByCode(alpha2);
                if (languageVariant == null) {
                    languageVariant = new LanguageVariant();
                    languageVariant.setCountryCode(alpha2);
                    languageVariant.setName(name);
                    languageVariant.setLangUid(language.getLangUid());
                    languageVariant.setLangVariantUid(variantDao.insert((Object)languageVariant));
                } else {
                    LanguageVariant changedVariant = new LanguageVariant();
                    changedVariant.setLangVariantUid(languageVariant.getLangVariantUid());
                    changedVariant.setCountryCode(alpha2);
                    changedVariant.setName(name);
                    changedVariant.setLangUid(language.getLangUid());
                    if (!Intrinsics.areEqual((Object)changedVariant, (Object)languageVariant)) {
                        variantDao.update((Object)languageVariant);
                    }
                    languageVariant = changedVariant;
                }
            }
        }
        return languageVariant;
    }

    private final ContentEntry checkContentEntryChanges(ContentEntry changedEntry, ContentEntry oldEntry, ContentEntryDao contentEntryDao) {
        changedEntry.setContentEntryUid(oldEntry.getContentEntryUid());
        if (!Intrinsics.areEqual((Object)changedEntry, (Object)oldEntry)) {
            changedEntry.setLastModified(System.currentTimeMillis());
            contentEntryDao.update(changedEntry);
        }
        return changedEntry;
    }

    private final ContentEntry createContentEntryObject(String id, String title, String sourceUrl, String publisher, int licenseType, long primaryLanguage, Long languageVariant, String description, boolean isLeaf, String author, String thumbnailUrl, String licenseName, String licenseUrl, int contentTypeFlag) {
        ContentEntry contentEntry = new ContentEntry();
        contentEntry.setEntryId(id);
        contentEntry.setTitle(title);
        contentEntry.setSourceUrl(sourceUrl);
        contentEntry.setPublisher(publisher);
        contentEntry.setLicenseType(licenseType);
        contentEntry.setPrimaryLanguageUid(primaryLanguage);
        if (languageVariant != null) {
            contentEntry.setLanguageVariantUid(languageVariant.longValue());
        }
        contentEntry.setDescription(description);
        contentEntry.setLeaf(isLeaf);
        contentEntry.setAuthor(author);
        contentEntry.setThumbnailUrl(thumbnailUrl);
        contentEntry.setLicenseName(licenseName);
        contentEntry.setLicenseUrl(licenseUrl);
        contentEntry.setPublik(true);
        contentEntry.setContentTypeFlag(contentTypeFlag);
        contentEntry.setContentFlags(4);
        return contentEntry;
    }

    @NotNull
    public final ContentEntry createOrUpdateContentEntry(@Nullable String id, @Nullable String title, @NotNull String sourceUrl, @NotNull String publisher, int licenseType, long primaryLanguage, @Nullable Long languageVariant, @Nullable String description, boolean isLeaf, @Nullable String author, @Nullable String thumbnailUrl, @NotNull String licenseName, @NotNull String licenseUrl, int contentTypeFlag, @NotNull ContentEntryDao contentEntryDao) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)licenseName, (String)"licenseName");
        Intrinsics.checkNotNullParameter((Object)licenseUrl, (String)"licenseUrl");
        Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
        ContentEntry contentEntry = contentEntryDao.findBySourceUrl(sourceUrl);
        if (contentEntry == null) {
            contentEntry = this.createContentEntryObject(id, title, sourceUrl, publisher, licenseType, primaryLanguage, languageVariant, description, isLeaf, author, thumbnailUrl, licenseName, licenseUrl, contentTypeFlag);
            contentEntry.setLastModified(System.currentTimeMillis());
            contentEntry.setContentEntryUid(contentEntryDao.insert((Object)contentEntry));
        } else {
            ContentEntry changedEntry = this.createContentEntryObject(id, title, sourceUrl, publisher, licenseType, primaryLanguage, languageVariant, description, isLeaf, author, thumbnailUrl, licenseName, licenseUrl, contentTypeFlag);
            contentEntry = this.checkContentEntryChanges(changedEntry, contentEntry, contentEntryDao);
        }
        return contentEntry;
    }

    @Nullable
    public final ScrapeQueueItem createQueueItem(@NotNull ScrapeQueueItemDao queueDao, @NotNull URL subjectUrl, @NotNull ContentEntry subjectEntry, @NotNull File destination, @NotNull String type2, int runId, int itemType) {
        Intrinsics.checkNotNullParameter((Object)queueDao, (String)"queueDao");
        Intrinsics.checkNotNullParameter((Object)subjectUrl, (String)"subjectUrl");
        Intrinsics.checkNotNullParameter((Object)subjectEntry, (String)"subjectEntry");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ScrapeQueueItem item = queueDao.findExistingQueueItem(runId, subjectEntry.getContentEntryUid());
        if (item == null) {
            item = new ScrapeQueueItem();
            item.setDestDir(destination.getPath());
            item.setScrapeUrl(subjectUrl.toString());
            item.setSqiContentEntryParentUid(subjectEntry.getContentEntryUid());
            item.setStatus(1);
            item.setContentType(type2);
            item.setRunId(runId);
            item.setItemType(itemType);
            item.setTimeAdded(System.currentTimeMillis());
            queueDao.insert((Object)item);
        }
        return item;
    }

    @NotNull
    public final LogIndex.IndexEntry createIndexWithResourceFiles(@NotNull String url, @NotNull File directory, @NotNull String mimeType, @NotNull InputStream filePath, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        URL imageUrl = new URL(url);
        File imageFolder = this.createDirectoryFromUrl(directory, imageUrl);
        File imageFile = new File(imageFolder, fileName);
        FileUtils.copyToFile((InputStream)filePath, (File)imageFile);
        String string = imageUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imageUrl.toString()");
        return this.createIndexFromLog(string, mimeType, imageFolder, imageFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final File downloadFileFromLogIndex(@NotNull URL url, @NotNull File destination, @Nullable LogResponse log, @Nullable String cookies) throws IOException {
        File file;
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                String string = url.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.host");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"youtube", (boolean)false, (int)2, null)) {
                    throw new IllegalArgumentException("cannot download youtube");
                }
                String fileName = this.getFileNameFromUrl(url);
                file = new File(destination, fileName);
                if (log == null) break block15;
                LogResponse.Message message = log.getMessage();
                Intrinsics.checkNotNull((Object)message);
                LogResponse.Message.Params params = message.getParams();
                Intrinsics.checkNotNull((Object)params);
                LogResponse.Message.Params.Response response = params.getResponse();
                Intrinsics.checkNotNull((Object)response);
                if (response.getRequestHeaders() != null) break block16;
            }
            if (cookies == null) {
                FileUtils.copyURLToFile((URL)url, (File)file);
                return file;
            }
        }
        HttpURLConnection conn = null;
        try {
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            conn = (HttpURLConnection)uRLConnection;
            LogResponse logResponse = log;
            Intrinsics.checkNotNull((Object)logResponse);
            LogResponse.Message message = logResponse.getMessage();
            Intrinsics.checkNotNull((Object)message);
            LogResponse.Message.Params params = message.getParams();
            Intrinsics.checkNotNull((Object)params);
            LogResponse.Message.Params.Response response = params.getResponse();
            Intrinsics.checkNotNull((Object)response);
            if (response.getRequestHeaders() != null) {
                LogResponse.Message message2 = log.getMessage();
                Intrinsics.checkNotNull((Object)message2);
                LogResponse.Message.Params params2 = message2.getParams();
                Intrinsics.checkNotNull((Object)params2);
                LogResponse.Message.Params.Response response2 = params2.getResponse();
                Intrinsics.checkNotNull((Object)response2);
                Map<String, String> map = response2.getRequestHeaders();
                Intrinsics.checkNotNull(map);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (StringsKt.equals((String)key, (String)"Accept-Encoding", (boolean)true)) continue;
                    CharSequence charSequence = key;
                    Regex regex = new Regex(":");
                    String string = "";
                    conn.addRequestProperty(regex.replace(charSequence, string), value);
                }
            }
            if (cookies != null) {
                conn.addRequestProperty("cookie", cookies);
            }
            FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)file);
            HttpURLConnection httpURLConnection = conn;
            httpURLConnection.disconnect();
            return file;
        }
        catch (IOException e) {
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Error downloading file from log index with url ", (Object)url));
            return file;
        }
        finally {
            HttpURLConnection httpURLConnection = conn;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @NotNull
    public final File createDirectoryFromUrl(@NotNull File destination, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = url.getAuthority();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"url.authority");
        charSequence = charSequence;
        Regex regex = new Regex("[^a-zA-Z0-9\\.\\-]");
        String string = "_";
        File urlFolder = new File(destination, regex.replace(charSequence, string));
        urlFolder.mkdirs();
        return urlFolder;
    }

    @NotNull
    public final LogIndex.IndexEntry createIndexFromLog(@NotNull String urlString, @Nullable String mimeType, @Nullable File urlDirectory, @Nullable File file, @Nullable LogResponse log) {
        String string;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        LogIndex.IndexEntry logIndex = new LogIndex.IndexEntry();
        logIndex.setUrl(urlString);
        logIndex.setMimeType(mimeType);
        if (file != null) {
            StringBuilder stringBuilder = new StringBuilder();
            File file2 = urlDirectory;
            Intrinsics.checkNotNull((Object)file2);
            string = stringBuilder.append(file2.getName()).append('/').append((Object)file.getName()).toString();
        } else {
            string = "";
        }
        logIndex.setPath(string);
        if (log != null) {
            Map<String, String> map;
            Map<String, String> map2;
            Map<String, String> map3;
            LogResponse.Message message = log.getMessage();
            Intrinsics.checkNotNull((Object)message);
            LogResponse.Message.Params params = message.getParams();
            if (params == null) {
                map3 = null;
            } else {
                LogResponse.Message.Params.Response response = params.getResponse();
                map3 = map2 = response == null ? null : response.getHeaders();
            }
            if (map2 == null) {
                LogResponse.Message message2 = log.getMessage();
                Intrinsics.checkNotNull((Object)message2);
                LogResponse.Message.Params params2 = message2.getParams();
                if (params2 == null) {
                    map = null;
                } else {
                    LogResponse.Message.Params.Response response = params2.getRedirectResponse();
                    map = response == null ? null : response.getHeaders();
                }
            } else {
                map = map2;
            }
            logIndex.setHeaders(map);
        }
        return logIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LogIndex.IndexEntry createIndexFromHar(@NotNull String urlString, @Nullable String mimeType, @Nullable File urlDirectory, @Nullable File file, @Nullable List<HarNameValuePair> headers) {
        Map map;
        String string;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        LogIndex.IndexEntry logIndex = new LogIndex.IndexEntry();
        logIndex.setUrl(urlString);
        logIndex.setMimeType(mimeType);
        if (file != null) {
            StringBuilder stringBuilder = new StringBuilder();
            File file2 = urlDirectory;
            Intrinsics.checkNotNull((Object)file2);
            string = stringBuilder.append(file2.getName()).append('/').append((Object)file.getName()).toString();
        } else {
            string = "";
        }
        logIndex.setPath(string);
        LogIndex.IndexEntry indexEntry = logIndex;
        List<HarNameValuePair> list = headers;
        if (list == null) {
            map = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list;
            LogIndex.IndexEntry indexEntry2 = indexEntry;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HarNameValuePair harNameValuePair = (HarNameValuePair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getValue()));
            }
            indexEntry = indexEntry2;
            List list2 = (List)destination$iv$iv;
            map = MapsKt.toMap((Iterable)list2);
        }
        indexEntry.setHeaders(map);
        return logIndex;
    }

    @NotNull
    public final ChromeDriver setupLogIndexChromeDriver() {
        DesiredCapabilities d = new DesiredCapabilities();
        d.setCapability("opera.arguments", "-screenwidth 411 -screenheight 731");
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        d.setCapability("goog:loggingPrefs", (Object)logPrefs);
        return new ChromeDriver((Capabilities)d);
    }

    @NotNull
    public final ChromeDriver setupChromeDriverWithSeleniumProxy(@NotNull Proxy seleniumProxy) {
        Intrinsics.checkNotNullParameter((Object)seleniumProxy, (String)"seleniumProxy");
        DesiredCapabilities d = new DesiredCapabilities();
        d.setCapability("opera.arguments", "-screenwidth 411 -screenheight 731");
        d.setCapability("proxy", (Object)seleniumProxy);
        return new ChromeDriver((Capabilities)d);
    }

    @NotNull
    public final StringBuffer convertMapToStringBuffer(@NotNull Map<String, String> params) throws IOException {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        StringBuffer requestParams = new StringBuffer();
        for (String key : params.keySet()) {
            String value = params.get(key);
            requestParams.append(URLEncoder.encode(key, "UTF-8"));
            requestParams.append("=").append(URLEncoder.encode(value, "UTF-8"));
            requestParams.append("&");
        }
        return requestParams;
    }

    public final void clearChromeConsoleLog(@NotNull ChromeDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        JavascriptExecutor js = (JavascriptExecutor)driver;
        js.executeScript("console.clear()", new Object[0]);
    }

    @NotNull
    public final ChromeDriver loginKhanAcademy() {
        ChromeDriver driver = this.setupLogIndexChromeDriver();
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        this.waitForJSandJQueryToLoad(waitDriver);
        waitDriver.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"div#login-signup-root")));
        CharSequence[] charSequenceArray = new CharSequence[]{"no-reply@ustadmobile.com"};
        driver.findElement(By.cssSelector((String)"div#login-signup-root input[id*=email-or-username]")).sendKeys(charSequenceArray);
        charSequenceArray = new CharSequence[]{"ustadscraper"};
        driver.findElement(By.cssSelector((String)"div#login-signup-root input[id*=text-field-1-password]")).sendKeys(charSequenceArray);
        List elements = driver.findElements(By.cssSelector((String)"div#login-signup-root button div"));
        for (WebElement element : elements) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Log in", (boolean)false, (int)2, null)) continue;
            element.click();
            break;
        }
        waitDriver.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"div.user-info-container")));
        this.clearChromeConsoleLog(driver);
        return driver;
    }

    @NotNull
    public final ChromeDriver loginCK12(@NotNull ChromeDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        CharSequence[] charSequenceArray = new CharSequence[]{"no-reply@ustadmobile.com"};
        driver.findElement(By.cssSelector((String)"div input#username")).sendKeys(charSequenceArray);
        charSequenceArray = new CharSequence[]{"ustadscraper1"};
        driver.findElement(By.cssSelector((String)"div input#password")).sendKeys(charSequenceArray);
        driver.findElement(By.cssSelector((String)"div.loginsubmitwrap input.btn")).click();
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        this.waitForJSandJQueryToLoad(waitDriver);
        this.clearChromeConsoleLog(driver);
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void downloadImagesFromJsonContent(@NotNull Map<String, ItemData.Content.Image> images, @NotNull File destDir, @NotNull String scrapeUrl2, @NotNull List<LogIndex.IndexEntry> indexList) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter(indexList, (String)"indexList");
        for (String imageValue : images.keySet()) {
            CharSequence charSequence;
            HttpURLConnection conn = null;
            try {
                charSequence = imageValue;
                Regex regex = new Regex(" ");
                String string = "";
                Object image = regex.replace(charSequence, string);
                String imageUrlString = image;
                if (StringsKt.contains$default((CharSequence)((CharSequence)image), (CharSequence)"+graphie", (boolean)false, (int)2, null)) {
                    StringBuilder stringBuilder = new StringBuilder().append("https://cdn.kastatic.org/ka-perseus-graphie/");
                    String string2 = ((String)image).substring(StringsKt.lastIndexOf$default((CharSequence)((CharSequence)image), (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    imageUrlString = stringBuilder.append(string2).append(".svg").toString();
                }
                URL imageUrl = new URL(imageUrlString);
                URLConnection uRLConnection = imageUrl.openConnection();
                if (uRLConnection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                conn = (HttpURLConnection)uRLConnection;
                conn.setRequestMethod("HEAD");
                String mimeType = conn.getContentType();
                File imageFile = this.createDirectoryFromUrl(destDir, imageUrl);
                File imageContent = new File(imageFile, FilenameUtils.getName((String)imageUrl.getPath()));
                FileUtils.copyURLToFile((URL)imageUrl, (File)imageContent);
                LogIndex.IndexEntry logIndex = this.createIndexFromLog(imageUrlString, mimeType, imageFile, imageContent, null);
                indexList.add(logIndex);
                image = conn;
                ((HttpURLConnection)image).disconnect();
            }
            catch (MalformedURLException e) {
                charSequence = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logDebug((String)charSequence);
            }
            catch (Exception e2) {
                charSequence = ExceptionUtils.getStackTrace((Throwable)e2);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError((String)charSequence);
                UMLogUtil.INSTANCE.logError("Error downloading an image for index log" + imageValue + " with url " + scrapeUrl2);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) continue;
                httpURLConnection.disconnect();
            }
        }
    }

    @NotNull
    public final List<LogEntry> waitForNewFiles(@NotNull ChromeDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        ArrayList logs = Lists.newArrayList((Iterable)driver.manage().logs().get("performance").getAll());
        boolean hasMore = false;
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ArrayList newLogs = Lists.newArrayList((Iterable)driver.manage().logs().get("performance").getAll());
            hasMore = newLogs.size() > 0;
            UMLogUtil.INSTANCE.logTrace(Intrinsics.stringPlus((String)"size of new logs from driver is", (Object)newLogs.size()));
            logs.addAll(newLogs);
        } while (hasMore);
        Intrinsics.checkNotNullExpressionValue((Object)logs, (String)"logs");
        return logs;
    }

    @NotNull
    public final String createSrtFile(@Nullable List<SrtFormat> srtFormatList, @NotNull File srtFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)srtFile, (String)"srtFile");
        if (srtFormatList == null || srtFormatList.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int count = 1;
        for (SrtFormat format : srtFormatList) {
            int n = count;
            count = n + 1;
            buffer.append(n);
            buffer.append(System.lineSeparator());
            buffer.append(this.formatTimeInMs(format.getStartTime()));
            buffer.append(" --> ");
            buffer.append(this.formatTimeInMs(format.getEndTime()));
            buffer.append(System.lineSeparator());
            buffer.append(format.getText());
            buffer.append(System.lineSeparator());
            buffer.append(System.lineSeparator());
        }
        FileUtils.writeStringToFile((File)srtFile, (String)buffer.toString(), (String)"UTF-8");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public final String formatTimeInMs(long timeMs) {
        long millis = timeMs % (long)1000;
        long second = timeMs / (long)1000 % (long)60;
        long minute = timeMs / (long)60000 % (long)60;
        long hour = timeMs / (long)3600000 % (long)24;
        String string = "%02d:%02d:%02d,%03d";
        Object[] objectArray = new Object[]{hour, minute, second, millis};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    public final void deleteFile(@Nullable File content) {
        if (content != null && !content.delete()) {
            UMLogUtil.INSTANCE.logTrace(Intrinsics.stringPlus((String)"Could not delete: ", (Object)content.getPath()));
        }
    }

    public final void insertOrUpdateLanguageManual(@NotNull LanguageDao langDao, @NotNull String langName, @NotNull String langCode) {
        Intrinsics.checkNotNullParameter((Object)langDao, (String)"langDao");
        Intrinsics.checkNotNullParameter((Object)langName, (String)"langName");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Language lang = langDao.findByName(langName);
        Language newLang = new Language();
        newLang.setName(langName);
        newLang.setIso_639_3_standard(langCode);
        if (lang == null) {
            newLang.setLangUid(langDao.insert((Object)newLang));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String returnListOfCookies(@NotNull String url, @NotNull Set<? extends Cookie> cookieList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookieList, (String)"cookieList");
        Iterable $this$filter$iv = cookieList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Cookie it = (Cookie)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = url;
            String string = it.getDomain();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.domain");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"; ", null, null, (int)0, null, (Function1)returnListOfCookies.2.INSTANCE, (int)30, null);
    }

    @NotNull
    public final ContentEntry insertTempContentEntry(@NotNull ContentEntryDao contentEntryDao, @NotNull String url, long primaryLanguageUid, @NotNull String title) {
        ContentEntry contentEntry;
        Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        ContentEntry contentEntry2 = contentEntryDao.findBySourceUrl(url);
        if (contentEntry2 == null) {
            ContentEntry contentEntry3;
            ContentEntry $this$insertTempContentEntry_u24lambda_u2d14 = contentEntry3 = new ContentEntry();
            boolean bl = false;
            $this$insertTempContentEntry_u24lambda_u2d14.setSourceUrl(url);
            $this$insertTempContentEntry_u24lambda_u2d14.setPrimaryLanguageUid(primaryLanguageUid);
            $this$insertTempContentEntry_u24lambda_u2d14.setTitle(title);
            $this$insertTempContentEntry_u24lambda_u2d14.setLeaf(true);
            $this$insertTempContentEntry_u24lambda_u2d14.setContentEntryUid(contentEntryDao.insert((Object)$this$insertTempContentEntry_u24lambda_u2d14));
            contentEntry = contentEntry3;
        } else {
            contentEntry = contentEntry2;
        }
        return contentEntry;
    }

    @NotNull
    public final ContentEntry insertTempYoutubeContentEntry(@NotNull ContentEntryDao contentEntryDao, @NotNull String url, long primaryLanguageUid, @NotNull String title, @NotNull String publisherText, int license, long langVariant) {
        ContentEntry contentEntry;
        Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)publisherText, (String)"publisherText");
        ContentEntry contentEntry2 = contentEntryDao.findBySourceUrl(url);
        if (contentEntry2 == null) {
            ContentEntry contentEntry3;
            ContentEntry $this$insertTempYoutubeContentEntry_u24lambda_u2d15 = contentEntry3 = new ContentEntry();
            boolean bl = false;
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setSourceUrl(url);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setPrimaryLanguageUid(primaryLanguageUid);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setLanguageVariantUid(langVariant);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setTitle(title);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setPublisher(publisherText);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setLicenseType(license);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setLeaf(true);
            $this$insertTempYoutubeContentEntry_u24lambda_u2d15.setContentEntryUid(contentEntryDao.insert((Object)$this$insertTempYoutubeContentEntry_u24lambda_u2d15));
            contentEntry = contentEntry3;
        } else {
            contentEntry = contentEntry2;
        }
        return contentEntry;
    }

    private static final Object parseServerDate$lambda-2(TemporalAccessor it) {
        return ZonedDateTime.from(it);
    }

    private static final Object parseServerDate$lambda-3(TemporalAccessor it) {
        return LocalDateTime.from(it);
    }

    private static final Object parseServerDate$lambda-4(TemporalAccessor it) {
        return LocalDate.from(it);
    }

    private static final boolean zipDirectory$lambda-7$lambda-5(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]);
    }

    private static final void zipDirectory$lambda-7$lambda-6(Path $sourceDirPath, ZipOutputStream $out, Path path) {
        Intrinsics.checkNotNullParameter((Object)$out, (String)"$out");
        CharSequence charSequence = ((Object)$sourceDirPath.relativize(path)).toString();
        String string = Pattern.quote("\\");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(\"\\\\\")");
        string = new Regex(string);
        String string2 = "/";
        ZipEntry zipEntry = new ZipEntry(string.replace(charSequence, string2));
        try {
            $out.putNextEntry(zipEntry);
            $out.write(Files.readAllBytes(path));
            $out.closeEntry();
        }
        catch (Exception e) {
            System.err.println(e.getCause());
        }
    }

    private static final boolean createContainerFromDirectory$lambda-8(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]);
    }

    private static final void createContainerFromDirectory$lambda-9(Path $sourceDirPath, Map $filemap, Path path) {
        Intrinsics.checkNotNullParameter((Object)$filemap, (String)"$filemap");
        Object object = ((Object)$sourceDirPath.relativize(path)).toString();
        Object object2 = Pattern.quote("\\");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"quote(\"\\\\\")");
        object2 = new Regex((String)object2);
        String string = "/";
        String relativePath = object2.replace((CharSequence)object, string);
        object = $filemap;
        object2 = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"path.toFile()");
        object.put(object2, relativePath);
    }

    private static final Boolean waitForJSandJQueryToLoad$lambda-10(WebDriver driver) {
        boolean bl;
        try {
            WebDriver webDriver = driver;
            if (webDriver == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openqa.selenium.JavascriptExecutor");
            }
            Object object = ((JavascriptExecutor)webDriver).executeScript("return jQuery.active", new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
            }
            bl = (Long)object == 0L;
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }

    private static final Boolean waitForJSandJQueryToLoad$lambda-11(WebDriver driver) {
        WebDriver webDriver = driver;
        if (webDriver == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openqa.selenium.JavascriptExecutor");
        }
        return Intrinsics.areEqual((Object)((JavascriptExecutor)webDriver).executeScript("return document.readyState", new Object[0]).toString(), (Object)"complete");
    }

    static {
        Object[] objectArray = new Pair[6];
        objectArray[0] = TuplesKt.to((Object)CHROME_PATH_KEY, (Object)CollectionsKt.listOf((Object)"/usr/bin/chromedriver"));
        objectArray[1] = TuplesKt.to((Object)FFMPEG_PATH_KEY, (Object)CollectionsKt.listOf((Object)"/usr/bin/ffmpeg"));
        Object[] objectArray2 = new String[]{"/usr/bin/c2enc", "/usr/local/bin/c2enc"};
        objectArray[2] = TuplesKt.to((Object)CODEC2_PATH_KEY, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[3] = TuplesKt.to((Object)WEBP_PATH_KEY, (Object)CollectionsKt.listOf((Object)"/usr/bin/cwebp"));
        objectArray[4] = TuplesKt.to((Object)MOGRIFY_PATH_KEY, (Object)CollectionsKt.listOf((Object)"/usr/bin/mogrify"));
        objectArray[5] = TuplesKt.to((Object)YOUTUBE_DL_PATH_KEY, (Object)CollectionsKt.listOf((Object)"/usr/local/bin/youtube-dl"));
        SEARCH_LOCATIONS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{CHROME_PATH_KEY, FFMPEG_PATH_KEY, CODEC2_PATH_KEY, WEBP_PATH_KEY, YOUTUBE_DL_PATH_KEY};
        driversList = CollectionsKt.listOf((Object[])objectArray);
    }
}

