/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.abztract;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.io.ext.InputStreamExtKt;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import com.ustadmobile.lib.contentscrapers.abztract.YoutubeScraper;
import com.ustadmobile.lib.contentscrapers.util.YoutubeData;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/lib/contentscrapers/abztract/YoutubePlaylistIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentContentEntry", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "gson", "Lcom/google/gson/Gson;", "ytPath", "", "close", "", "indexUrl", "sourceUrl", "lib-content-scrapers"})
public class YoutubePlaylistIndexer
extends Indexer {
    @NotNull
    private final String ytPath;
    @NotNull
    private final Gson gson;

    public YoutubePlaylistIndexer(long parentContentEntry, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntry, runUid, sqiUid, contentEntryUid, endpoint, di);
        ContentScraperUtil.INSTANCE.checkIfPathsToDriversExist();
        String string = System.getProperty("youtube-dl");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(ContentScrap\u2026Util.YOUTUBE_DL_PATH_KEY)");
        this.ytPath = string;
        string = new GsonBuilder().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().disableHtmlEscaping().create()");
        this.gson = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        String string;
        String string2;
        int numberOfFailures;
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        File ytExeFile = new File(this.ytPath);
        if (!ytExeFile.exists()) {
            this.close();
            this.setIndexerDone(false, 230);
            throw new IOException(Intrinsics.stringPlus((String)"Webp executable does not exist: ", (Object)this.ytPath));
        }
        String[] stringArray = new String[]{this.ytPath, "--retries", "1", "-i", "-J", "--flat-playlist", sourceUrl};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        String data = null;
        Lock lock = YoutubeScraper.Companion.getYoutubeLocker();
        lock.lock();
        try {
            boolean $i$a$-withLock-YoutubePlaylistIndexer$indexUrl$23333332 = false;
            UMLogUtil.INSTANCE.logTrace("starting youtube lock playlist");
            boolean retryFlag = true;
            numberOfFailures = 1;
            while (retryFlag) {
                Process process = null;
                try {
                    Thread.sleep(Random.Default.nextLong(10000L, 30000L));
                    Process process2 = process = builder.start();
                    Intrinsics.checkNotNull((Object)process2);
                    process2.waitFor();
                    InputStream inputStream = process.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
                    data = InputStreamExtKt.readString((InputStream)inputStream);
                    int exitValue23333332 = process.exitValue();
                    if (exitValue23333332 != 0) {
                        InputStream inputStream2 = process.getErrorStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
                        String error = InputStreamExtKt.readString((InputStream)inputStream2);
                        UMLogUtil.INSTANCE.logError("Error Stream for src " + sourceUrl + " with error code  " + error);
                        if (StringsKt.contains$default((CharSequence)error, (CharSequence)"429", (boolean)false, (int)2, null)) throw new IOException("Failed " + numberOfFailures + " for  " + sourceUrl);
                        throw new ScraperException(220, Intrinsics.stringPlus((String)"unknown error: ", (Object)error));
                    }
                    retryFlag = false;
                    Process exitValue23333332 = process;
                    exitValue23333332.destroy();
                }
                catch (ScraperException s) {
                    this.setIndexerDone(false, 220);
                    this.close();
                    throw s;
                    catch (Exception e) {
                        if (numberOfFailures > 5) {
                            this.setIndexerDone(false, 210);
                            System.exit(1);
                            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                        }
                        YoutubeScraper.Companion.setLockedUntil((float)Math.pow(10.0f, numberOfFailures) * (float)1000);
                        UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"caught youtube exception with lockedUntil value of ", (Object)((long)YoutubeScraper.Companion.getLockedUntil())));
                        Thread.sleep((long)YoutubeScraper.Companion.getLockedUntil());
                        int error = numberOfFailures;
                        numberOfFailures = error + 1;
                    }
                }
                finally {
                    Process process3 = process;
                    if (process3 == null) continue;
                    process3.destroy();
                }
            }
            Unit $i$a$-withLock-YoutubePlaylistIndexer$indexUrl$23333332 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        UMLogUtil.INSTANCE.logTrace("ending youtube lock playlist");
        if (data == null) {
            this.setIndexerDone(false, 0);
            this.close();
            throw new ScraperException(0, "No Data Found after running youtube-dl");
        }
        YoutubeData youtubeData = (YoutubeData)this.gson.fromJson(data, YoutubeData.class);
        String string3 = youtubeData.getId();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = youtubeData.getTitle();
        Intrinsics.checkNotNull((Object)string4);
        ContentEntry contentEntry = this.getParentContentEntry();
        if (contentEntry == null) {
            string2 = "";
        } else {
            string2 = contentEntry.getPublisher();
            if (string2 == null) {
                string2 = "";
            }
        }
        ContentEntry contentEntry2 = this.getParentContentEntry();
        int n = contentEntry2 == null ? 0 : (numberOfFailures = contentEntry2.getLicenseType());
        ContentEntry contentEntry3 = this.getParentContentEntry();
        long l = contentEntry3 == null ? 0L : (numberOfFailures = contentEntry3.getPrimaryLanguageUid());
        ContentEntry contentEntry4 = this.getParentContentEntry();
        Long l2 = contentEntry4 == null ? 0L : (numberOfFailures = contentEntry4.getLanguageVariantUid());
        String string5 = youtubeData.getDescription();
        if (string5 == null) {
            string5 = "";
        }
        if ((string = youtubeData.getThumbnail()) == null) {
            string = "";
        }
        ContentEntry contentEntry5 = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string3, string4, sourceUrl, string2, n, l, l2, string5, false, "", string, "", "", 0, this.getRepo().getContentEntryDao());
        List<YoutubeData> list = youtubeData.getEntries();
        if (list != null) {
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n2;
                String string6;
                long l3;
                void entry;
                int n3 = index$iv;
                index$iv = n3 + 1;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                YoutubeData youtubeData2 = (YoutubeData)item$iv;
                int counter = n3;
                boolean bl = false;
                if (entry.getUrl() == null) continue;
                String string7 = entry.getUrl();
                Intrinsics.checkNotNull((Object)string7);
                String youtubeUrl = Intrinsics.stringPlus((String)"https://www.youtube.com/watch?v=", (Object)string7);
                ContentEntryDao contentEntryDao = this.getRepo().getContentEntryDao();
                ContentEntry contentEntry6 = this.getParentContentEntry();
                long l4 = contentEntry6 == null ? 0L : (l3 = contentEntry6.getPrimaryLanguageUid());
                String string8 = entry.getTitle();
                Intrinsics.checkNotNull((Object)string8);
                ContentEntry contentEntry7 = this.getParentContentEntry();
                if (contentEntry7 == null) {
                    string6 = "";
                } else {
                    string6 = contentEntry7.getPublisher();
                    if (string6 == null) {
                        string6 = "";
                    }
                }
                ContentEntry contentEntry8 = this.getParentContentEntry();
                ContentEntry contentEntry9 = this.getParentContentEntry();
                ContentEntry youtubeEntry = ContentScraperUtil.INSTANCE.insertTempYoutubeContentEntry(contentEntryDao, youtubeUrl, l4, string8, string6, contentEntry8 == null ? 0 : (n2 = contentEntry8.getLicenseType()), contentEntry9 == null ? 0L : (l3 = contentEntry9.getLanguageVariantUid()));
                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.getRepo().getContentEntryParentChildJoinDao();
                ContentEntry contentEntry10 = this.getParentContentEntry();
                Intrinsics.checkNotNull((Object)contentEntry10);
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, contentEntry10, youtubeEntry, counter);
                Indexer.createQueueItem$default(this, youtubeUrl, youtubeEntry, "youtubeVideoScraper", 2, this.getParentContentEntryUid(), 0, 32, null);
            }
        }
        this.setIndexerDone(true, 0);
    }

    @Override
    public void close() {
    }
}

