/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.ddl;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.ddl.IndexDdlContent;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0016H\u0016R\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ddl/DdlFrontPageIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentContentEntryUid", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "langCount", "getLangCount", "()I", "setLangCount", "(I)V", "close", "", "createLangEntry", "langName", "", "langEntity", "Lcom/ustadmobile/lib/db/entities/Language;", "parentDdl", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "indexUrl", "sourceUrl", "lib-content-scrapers"})
public final class DdlFrontPageIndexer
extends Indexer {
    private int langCount;

    public DdlFrontPageIndexer(long parentContentEntryUid, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntryUid, runUid, sqiUid, contentEntryUid, endpoint, di);
    }

    public final int getLangCount() {
        return this.langCount;
    }

    public final void setLangCount(int n) {
        this.langCount = n;
    }

    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Language farsiLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(this.getRepo().getLanguageDao(), "fa");
        Language pashtoLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(this.getRepo().getLanguageDao(), "ps");
        ContentEntry parentDdl = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(sourceUrl, "Darakht-e Danesh", sourceUrl, IndexDdlContent.Companion.getDDL$lib_content_scrapers(), 1, this.getEnglishLang().getLangUid(), null, "Free and open educational resources for Afghanistan", false, "", "https://ddl.af/storage/files/logo-dd.png", "", "", 0, this.getRepo().getContentEntryDao());
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), this.getParentContentEntry(), parentDdl, 2);
        this.createLangEntry("English", this.getEnglishLang(), parentDdl);
        this.createLangEntry("\u0641\u0627\u0631\u0633\u06cc", farsiLang, parentDdl);
        this.createLangEntry("\u067e\u069a\u062a\u0648", pashtoLang, parentDdl);
        this.setIndexerDone(true, 0);
    }

    private final void createLangEntry(String langName, Language langEntity, ContentEntry parentDdl) {
        String url = "https://www.ddl.af/" + langEntity.getIso_639_1_standard() + "/resources/list";
        ContentEntry langEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(Intrinsics.stringPlus((String)langEntity.getIso_639_1_standard(), (Object)"/resources/list"), langName, url, IndexDdlContent.Companion.getDDL$lib_content_scrapers(), 1, langEntity.getLangUid(), null, "", false, "", "", "", "", 0, this.getRepo().getContentEntryDao());
        int n = this.langCount;
        this.langCount = n + 1;
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), parentDdl, langEntry, n);
        Indexer.createQueueItem$default(this, url, langEntry, "ddlSubjectIndexer", 1, parentDdl.getContentEntryUid(), 0, 32, null);
    }

    @Override
    public void close() {
    }
}

