/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.voa;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.voa.VoaQuiz;
import com.ustadmobile.lib.contentscrapers.voa.VoaResponse;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B/\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J6\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020)H\u0016J\u0006\u0010-\u001a\u00020)R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/ustadmobile/lib/contentscrapers/voa/VoaScraper;", "Ljava/lang/Runnable;", "url", "", "destinationDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "scrapeUrl", "Ljava/net/URL;", "destinationDirectory", "containerDir", "parent", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "sqiUid", "", "(Ljava/net/URL;Ljava/io/File;Ljava/io/File;Lcom/ustadmobile/lib/db/entities/ContentEntry;I)V", "answerUrl", "getAnswerUrl", "()Ljava/lang/String;", "setAnswerUrl", "(Ljava/lang/String;)V", "<set-?>", "", "isContentUpdated", "isContentUpdated$lib_content_scrapers", "()Z", "parentEntry", "scrapUrl", "voaDirectory", "createConnectionForPost", "Ljava/net/HttpURLConnection;", "answersUrl", "requestParams", "Ljava/lang/StringBuffer;", "createParams", "", "quizId", "count", "selectedAnswer", "voted", "removeAllAttributesFromVideoAudio", "", "document", "Lorg/jsoup/nodes/Document;", "run", "scrapeContent", "lib-content-scrapers"})
public final class VoaScraper
implements Runnable {
    private File containerDir;
    private int sqiUid;
    private ContentEntry parentEntry;
    @NotNull
    private URL scrapUrl;
    @NotNull
    private File voaDirectory;
    @NotNull
    private File destinationDir;
    private boolean isContentUpdated;
    @NotNull
    private String answerUrl;

    public final boolean isContentUpdated$lib_content_scrapers() {
        return this.isContentUpdated;
    }

    @NotNull
    public final String getAnswerUrl() {
        return this.answerUrl;
    }

    public final void setAnswerUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.answerUrl = string;
    }

    public VoaScraper(@NotNull String url, @NotNull File destinationDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        this.isContentUpdated = true;
        this.answerUrl = "https://learningenglish.voanews.com/Quiz/Answer";
        this.scrapUrl = new URL(url);
        this.destinationDir = destinationDir;
        URL uRL = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL);
        File file = this.voaDirectory = new File(destinationDir, FilenameUtils.getBaseName((String)uRL.getPath()));
        Intrinsics.checkNotNull((Object)file);
        file.mkdirs();
    }

    public VoaScraper(@NotNull URL scrapeUrl2, @NotNull File destinationDirectory, @NotNull File containerDir, @NotNull ContentEntry parent, int sqiUid) {
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.isContentUpdated = true;
        this.answerUrl = "https://learningenglish.voanews.com/Quiz/Answer";
        this.destinationDir = destinationDirectory;
        this.containerDir = containerDir;
        this.scrapUrl = scrapeUrl2;
        this.parentEntry = parent;
        this.sqiUid = sqiUid;
        URL uRL = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL);
        File file = this.voaDirectory = new File(this.destinationDir, FilenameUtils.getBaseName((String)uRL.getPath()));
        Intrinsics.checkNotNull((Object)file);
        file.mkdirs();
    }

    @Override
    public void run() {
        System.gc();
        UmAppDatabase db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        UmAppDatabase repository = null;
        ContainerDao containerDao = repository.getContainerDao();
        ScrapeQueueItemDao queueDao = db.getScrapeQueueItemDao();
        long startTime = System.currentTimeMillis();
        UMLogUtil.INSTANCE.logInfo("Started scraper url " + this.scrapUrl + " at start time: " + startTime);
        queueDao.setTimeStarted(this.sqiUid, startTime);
        boolean successful = false;
        try {
            this.scrapeContent();
            URL uRL = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL);
            File content = new File(this.destinationDir, FilenameUtils.getBaseName((String)uRL.getPath()));
            successful = true;
            if (this.isContentUpdated) {
                ContentEntry contentEntry = this.parentEntry;
                if (contentEntry == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parentEntry");
                    contentEntry = null;
                }
                long l = content.lastModified();
                File file = this.containerDir;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"containerDir");
                    file = null;
                }
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, contentEntry, true, "application/tincan+zip", l, content, db, repository, file);
            }
        }
        catch (Exception e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logTrace(string);
            URL uRL = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL);
            ContentScraperUtil.INSTANCE.deleteFile(new File(this.destinationDir, Intrinsics.stringPlus((String)FilenameUtils.getBaseName((String)uRL.getPath()), (Object)"last-modified.txt")));
        }
        queueDao.updateSetStatusById(this.sqiUid, successful ? 3 : 4, 0);
        queueDao.setTimeFinished(this.sqiUid, System.currentTimeMillis());
        long duration = System.currentTimeMillis() - startTime;
        UMLogUtil.INSTANCE.logInfo("Ended scrape for url " + this.scrapUrl + " in duration: " + duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scrapeContent() throws IOException {
        String string;
        String voaData;
        String string2;
        boolean element22;
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        ContentScraperUtil.INSTANCE.setChromeDriverLocation();
        ChromeDriver driver = ContentScraperUtil.INSTANCE.setupChrome(true);
        URL uRL = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL);
        driver.get(uRL.toString());
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
        URL uRL2 = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL2);
        String lessonId = FilenameUtils.getBaseName((String)uRL2.getPath());
        File voaDirectory = new File(this.destinationDir, lessonId);
        File modifiedFile = new File(this.destinationDir, Intrinsics.stringPlus((String)lessonId, (Object)"last-modified.txt"));
        voaDirectory.mkdirs();
        boolean isUpdated = false;
        try {
            WebElement element22 = driver.findElement(By.cssSelector((String)"script[type*=json]"));
            Object[] objectArray = new Object[]{element22};
            Object object = driver.executeScript("return arguments[0].innerText;", objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String scriptText = (String)object;
            VoaResponse response = (VoaResponse)gson.fromJson(scriptText, VoaResponse.class);
            String string3 = response.getDateModified();
            Intrinsics.checkNotNull((Object)string3);
            long dateModified = ContentScraperUtil.INSTANCE.parseServerDate(StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"Z", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"T", (boolean)false, (int)4, null));
            element22 = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(dateModified));
        }
        catch (NoSuchElementException ignored) {
            String string4 = driver.findElement(By.cssSelector((String)"time")).getAttribute("datetime");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"driver.findElement(By.cs\u2026.getAttribute(\"datetime\")");
            long modified = ContentScraperUtil.INSTANCE.parseServerDate(string4);
            element22 = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(modified));
        }
        isUpdated = element22;
        if (!isUpdated) {
            this.isContentUpdated = false;
            driver.close();
            driver.quit();
            return;
        }
        if (ContentScraperUtil.INSTANCE.fileHasContent(voaDirectory)) {
            FileUtils.deleteDirectory((File)voaDirectory);
            voaDirectory.mkdirs();
        }
        String quizHref = null;
        String quizAjaxUrl = null;
        try {
            WebElement quizElement = driver.findElement(By.cssSelector((String)"a[data-ajax-url*=Quiz]"));
            quizHref = quizElement.getAttribute("href");
            quizAjaxUrl = quizElement.getAttribute("data-ajax-url");
        }
        catch (NoSuchElementException quizElement) {
            // empty catch block
        }
        URL uRL3 = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL3);
        Document document2 = Jsoup.connect((String)uRL3.toString()).get();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
        this.removeAllAttributesFromVideoAudio(document2);
        File assetDirectory = new File(voaDirectory, "asset");
        assetDirectory.mkdirs();
        driver.close();
        driver.quit();
        if (quizHref != null && !(((CharSequence)quizHref).length() == 0)) {
            VoaQuiz quizResponse = new VoaQuiz();
            String string5 = quizAjaxUrl;
            Intrinsics.checkNotNull((Object)string5);
            String string6 = string5.substring(StringsKt.indexOf$default((CharSequence)quizAjaxUrl, (String)"id=", (int)0, (boolean)false, (int)6, null) + 3, StringsKt.indexOf$default((CharSequence)quizAjaxUrl, (String)"&", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String quizId = string6;
            int quizCount = 12;
            quizResponse.setQuizId(quizId);
            File quizFile = new File(voaDirectory, "questions.json");
            ArrayList<VoaQuiz.Questions> questionList = new ArrayList<VoaQuiz.Questions>();
            for (int i = 1; i <= quizCount; i += 2) {
                Unit unit;
                Unit unit2;
                HttpURLConnection httpURLConnection;
                HttpURLConnection conn = null;
                HttpURLConnection selectedConn = null;
                try {
                    String quizSize;
                    String questionData;
                    URL answersUrl = new URL(this.answerUrl);
                    File urlDirectory = ContentScraperUtil.INSTANCE.createDirectoryFromUrl(voaDirectory, answersUrl);
                    urlDirectory.mkdirs();
                    File questionPage = new File(urlDirectory, i + "question");
                    Map<String, String> params = this.createParams(quizId, i, null, "True");
                    StringBuffer requestParams = ContentScraperUtil.INSTANCE.convertMapToStringBuffer(params);
                    conn = this.createConnectionForPost(answersUrl, requestParams);
                    conn.connect();
                    String string7 = questionData = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
                    Intrinsics.checkNotNull((Object)string7);
                    Document questionDoc = Jsoup.parse((String)string7);
                    Intrinsics.checkNotNullExpressionValue((Object)questionDoc, (String)"questionDoc");
                    this.removeAllAttributesFromVideoAudio(questionDoc);
                    String string8 = quizSize = questionDoc.select("span.caption").text();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"quizSize");
                    String string9 = string8.substring(quizSize.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).substring(startIndex)");
                    quizSize = string9;
                    quizCount = Integer.valueOf(quizSize) * 2;
                    string8 = questionDoc.html();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"questionDoc.html()");
                    questionData = ContentScraperUtil.INSTANCE.downloadAllResources(string8, assetDirectory, this.scrapUrl);
                    Element answerLabel = questionDoc.selectFirst("input[name=SelectedAnswerId]");
                    FileUtils.writeStringToFile((File)questionPage, (String)questionData, (String)"UTF-8");
                    String string10 = questionData;
                    Intrinsics.checkNotNull((Object)string10);
                    Document videoDoc = Jsoup.parse((String)string10);
                    VoaQuiz.Questions question = new VoaQuiz.Questions();
                    Element element = questionDoc.selectFirst("h2.ta-l");
                    question.setQuestionText((String)(element == null ? null : element.text()));
                    try {
                        Element mediaSource;
                        Element element3 = mediaSource = videoDoc.selectFirst("div.quiz__answers-img video,div.quiz__answers-img img");
                        question.setVideoHref(element3 == null ? null : element3.attr("src"));
                    }
                    catch (NoSuchElementException mediaSource) {
                    }
                    catch (NullPointerException mediaSource) {
                        // empty catch block
                    }
                    ArrayList<VoaQuiz.Questions.Choices> choiceList = new ArrayList<VoaQuiz.Questions.Choices>();
                    Elements answerTextList = questionDoc.select("label.quiz__answers-label");
                    for (Element answer : answerTextList) {
                        VoaQuiz.Questions.Choices choices = new VoaQuiz.Questions.Choices();
                        Element element4 = answer.selectFirst("input");
                        choices.setId(element4 == null ? null : element4.attr("value"));
                        Element element5 = answer.selectFirst("span.quiz__answers-item-text");
                        choices.setAnswerText((String)(element5 == null ? null : element5.text()));
                        choiceList.add(choices);
                    }
                    question.setChoices((List<VoaQuiz.Questions.Choices>)choiceList);
                    Element element6 = answerLabel;
                    String answerId = element6 == null ? null : element6.attr("value");
                    Map<String, String> selectedParams = this.createParams(quizId, i + 1, answerId, "False");
                    StringBuffer selectedRequestParams = ContentScraperUtil.INSTANCE.convertMapToStringBuffer(selectedParams);
                    selectedConn = this.createConnectionForPost(answersUrl, selectedRequestParams);
                    File answerPage = new File(urlDirectory, Intrinsics.stringPlus((String)answerId, (Object)"answersIndex"));
                    selectedConn.connect();
                    FileUtils.copyInputStreamToFile((InputStream)selectedConn.getInputStream(), (File)answerPage);
                    Document selectedAnswerDoc = Jsoup.parse((File)answerPage, (String)"UTF-8");
                    Element element7 = selectedAnswerDoc.selectFirst("li.quiz__answers-item--correct input");
                    question.setAnswerId(element7 == null ? null : element7.attr("value"));
                    Element element8 = selectedAnswerDoc.selectFirst("p.p-t-md");
                    question.setAnswer((String)(element8 == null ? null : element8.text()));
                    questionList.add(question);
                    httpURLConnection = conn;
                }
                catch (IOException e) {
                    Unit unit3;
                    Unit unit4;
                    HttpURLConnection httpURLConnection2;
                    try {
                        String string11 = ExceptionUtils.getStackTrace((Throwable)e);
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getStackTrace(e)");
                        UMLogUtil.INSTANCE.logError(string11);
                        httpURLConnection2 = conn;
                    }
                    catch (Throwable throwable) {
                        Unit unit5;
                        Unit unit6;
                        HttpURLConnection httpURLConnection3 = conn;
                        if (httpURLConnection3 == null) {
                            unit6 = null;
                        } else {
                            httpURLConnection3.disconnect();
                            unit6 = Unit.INSTANCE;
                        }
                        HttpURLConnection httpURLConnection4 = selectedConn;
                        if (httpURLConnection4 == null) {
                            unit5 = null;
                        } else {
                            httpURLConnection4.disconnect();
                            unit5 = Unit.INSTANCE;
                        }
                        throw throwable;
                    }
                    if (httpURLConnection2 == null) {
                        unit4 = null;
                    } else {
                        httpURLConnection2.disconnect();
                        unit4 = Unit.INSTANCE;
                    }
                    HttpURLConnection httpURLConnection5 = selectedConn;
                    if (httpURLConnection5 == null) {
                        unit3 = null;
                        continue;
                    }
                    httpURLConnection5.disconnect();
                    unit3 = Unit.INSTANCE;
                    continue;
                }
                if (httpURLConnection == null) {
                    unit2 = null;
                } else {
                    httpURLConnection.disconnect();
                    unit2 = Unit.INSTANCE;
                }
                HttpURLConnection httpURLConnection6 = selectedConn;
                if (httpURLConnection6 == null) {
                    unit = null;
                    continue;
                }
                httpURLConnection6.disconnect();
                unit = Unit.INSTANCE;
                continue;
            }
            quizResponse.setQuestions((List<VoaQuiz.Questions>)questionList);
            FileUtils.writeStringToFile((File)quizFile, (String)gson.toJson((Object)quizResponse), (String)"UTF-8");
        }
        Element element = document2.selectFirst("div#content");
        if (element == null) {
            string2 = "";
        } else {
            string2 = element.html();
            if (string2 == null) {
                string2 = "";
            }
        }
        String string12 = voaData = ContentScraperUtil.INSTANCE.downloadAllResources(string2, assetDirectory, this.scrapUrl);
        Intrinsics.checkNotNull((Object)string12);
        Document finalDoc = Jsoup.parse((String)string12);
        finalDoc.head().append("<link rel=\"stylesheet\" href=\"asset/materialize.min.css\">");
        finalDoc.head().append("<meta charset=\"utf-8\" name=\"viewport\"\n          content=\"width=device-width, initial-scale=1, shrink-to-fit=no,user-scalable=no\">");
        finalDoc.head().append("<link rel=\"stylesheet\" href=\"asset/voa.min.css\">");
        finalDoc.body().append("<script type=\"text/javascript\" src=\"asset/iframeResizer.min.js\"></script>");
        finalDoc.body().append("<script type=\"text/javascript\" src=\"asset/voa.min.js\"></script>");
        finalDoc.body().attr("style", "padding:2%");
        if (quizHref != null) {
            Element element9 = finalDoc.selectFirst("div.quiz__body");
            Element element10 = element9 == null ? null : element9.after("<div class=\"iframe-container\"><iframe id=\"myFrame\" src=\"quiz.html\" frameborder=\"0\" scrolling=\"no\" width=\"100%\"></frame></div>");
        }
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/quiz.html"), (File)new File(voaDirectory, "quiz.html"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/iframeResizer.min.js"), (File)new File(assetDirectory, "iframeResizer.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/iframeResizer.contentWindow.min.js"), (File)new File(assetDirectory, "iframeResizer.contentWindow.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/jquery-3.3.1.min.js"), (File)new File(assetDirectory, "jquery-3.3.1.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/materialize.min.css"), (File)new File(assetDirectory, "materialize.min.css"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/materialize.min.js"), (File)new File(assetDirectory, "materialize.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voa.min.css"), (File)new File(assetDirectory, "voa.min.css"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voa.min.js"), (File)new File(assetDirectory, "voa.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voaquiz.min.js"), (File)new File(assetDirectory, "voaquiz.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voaquiz.min.css"), (File)new File(assetDirectory, "voaquiz.min.css"));
        FileUtils.writeStringToFile((File)new File(voaDirectory, "index.html"), (String)finalDoc.toString(), (String)"UTF-8");
        try {
            URL uRL4 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL4);
            String quizCount = FilenameUtils.getBaseName((String)uRL4.toString());
            Intrinsics.checkNotNullExpressionValue((Object)quizCount, (String)"getBaseName(scrapUrl!!.toString())");
            String string13 = quizCount;
            URL uRL5 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL5);
            quizCount = uRL5.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)quizCount, (String)"scrapUrl!!.path");
            ContentScraperUtil.INSTANCE.generateTinCanXMLFile(voaDirectory, string13, "en", "index.html", "http://activitystrea.ms/schema/1.0/video", quizCount, "", "");
        }
        catch (TransformerException e) {
            string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            URL uRL6 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL6);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"VOA failed to create tin can file for url ", (Object)uRL6));
        }
        catch (ParserConfigurationException e) {
            string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            URL uRL7 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL7);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"VOA failed to create tin can file for url ", (Object)uRL7));
        }
    }

    private final Map<String, String> createParams(String quizId, int count, String selectedAnswer, String voted) {
        String string;
        Map map;
        HashMap selectedParams = new HashMap();
        if (selectedAnswer != null) {
            map = selectedParams;
            string = "SelectedAnswerId";
            map.put(string, selectedAnswer);
        }
        map = selectedParams;
        string = "QuestionVoted";
        map.put(string, voted);
        map = selectedParams;
        string = "quizId";
        map.put(string, quizId);
        map = selectedParams;
        string = "PageIndex";
        String string2 = String.valueOf(count);
        map.put(string, string2);
        map = selectedParams;
        string = "isEmbedded";
        string2 = "True";
        map.put(string, string2);
        return selectedParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpURLConnection createConnectionForPost(URL answersUrl, StringBuffer requestParams) throws IOException {
        DataOutputStream dataOutputStream;
        HttpURLConnection conn = null;
        DataOutputStream out = null;
        try {
            URLConnection uRLConnection = answersUrl.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            conn = (HttpURLConnection)uRLConnection;
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-length", String.valueOf(requestParams.length()));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            URL uRL = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL);
            conn.setRequestProperty("Referer", uRL.toString());
            out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(requestParams.toString());
            dataOutputStream = out;
        }
        catch (Throwable throwable) {
            DataOutputStream dataOutputStream2 = out;
            if (dataOutputStream2 != null) {
                dataOutputStream2.flush();
            }
            DataOutputStream dataOutputStream3 = out;
            if (dataOutputStream3 != null) {
                dataOutputStream3.close();
            }
            throw throwable;
        }
        dataOutputStream.flush();
        dataOutputStream = out;
        dataOutputStream.close();
        return conn;
    }

    private final void removeAllAttributesFromVideoAudio(Document document2) {
        document2.select("div.c-spinner").remove();
        document2.select("div.js-poster").remove();
        document2.select("a.c-mmp__fallback-link").remove();
        document2.select("div#comments").remove();
        document2.select("div.article-share").remove();
        document2.select("div.link-function").remove();
        document2.select("div.media-download").remove();
        document2.select("div.c-mmp__overlay").remove();
        document2.select("button.btn-popout-player").remove();
        document2.select("div.js-cpanel-container").remove();
        document2.select("div.design-top-offset").remove();
        document2.select("div.quiz__main-img").remove();
        document2.select("div.quiz__intro").remove();
        document2.select("div.media-block-wrap").remove();
        document2.select("aside.js-share--horizontal").remove();
        document2.select("div.nav-tabs__inner").remove();
        document2.select("[href]").removeAttr("href");
        Elements linkElements = document2.select("video,audio");
        for (Element link : linkElements) {
            ArrayList<String> keys = new ArrayList<String>();
            Attributes attrList = link.attributes();
            for (Attribute attribute : attrList) {
                Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attrList");
                String key = (String)((Map.Entry)attribute).getKey();
                if (Intrinsics.areEqual((Object)key, (Object)"src")) continue;
                keys.add(key);
            }
            for (String key : keys) {
                link.removeAttr(key);
            }
            link.attr("controls", "controls");
        }
    }
}

