/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.staging.contentscrapers.edraakK12;

import com.google.gson.GsonBuilder;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.core.io.ext.InputStreamExtKt;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.ShrinkerUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.edraakK12.ContentResponse;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B/\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J(\u0010\u001d\u001a\u00020\u00122\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020 H\u0002J\u001d\u0010#\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010$\u001a\u00020 H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020\u0012J\b\u0010'\u001a\u00020\u001aH\u0016J\u0006\u0010(\u001a\u00020\u001aJ\u0018\u0010)\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\u001fH\u0002R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/edraakK12/EdraakK12ContentScraper;", "Ljava/lang/Runnable;", "url", "", "destinationDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "scrapeUrl", "Ljava/net/URL;", "destinationDirectory", "containerDir", "parent", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "sqiUid", "", "(Ljava/net/URL;Ljava/io/File;Ljava/io/File;Lcom/ustadmobile/lib/db/entities/ContentEntry;I)V", "containerDirectory", "contentUpdated", "", "getContentUpdated$lib_content_scrapers", "()Z", "setContentUpdated$lib_content_scrapers", "(Z)V", "parentEntry", "scrapUrl", "checkBeforeCopyToFile", "", "fileToDownload", "locationToSave", "downloadQuestions", "questionsList", "", "Lcom/ustadmobile/lib/contentscrapers/edraakK12/ContentResponse;", "downloadVideo", "children", "getQuestionSet", "response", "getQuestionSet$lib_content_scrapers", "hasContentUpdated", "run", "scrapeContent", "selectVideo", "Lcom/ustadmobile/lib/contentscrapers/edraakK12/ContentResponse$Encoded_videos;", "encoded_videos", "Companion", "lib-content-scrapers"})
public final class EdraakK12ContentScraper
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private File containerDirectory;
    private int sqiUid;
    private ContentEntry parentEntry;
    @Nullable
    private File destinationDirectory;
    private boolean contentUpdated;
    @Nullable
    private URL scrapUrl;

    public final boolean getContentUpdated$lib_content_scrapers() {
        return this.contentUpdated;
    }

    public final void setContentUpdated$lib_content_scrapers(boolean bl) {
        this.contentUpdated = bl;
    }

    public EdraakK12ContentScraper(@NotNull String url, @NotNull File destinationDir) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        this.scrapUrl = new URL(url);
        this.destinationDirectory = destinationDir;
    }

    public EdraakK12ContentScraper(@NotNull URL scrapeUrl2, @NotNull File destinationDirectory, @NotNull File containerDir, @NotNull ContentEntry parent, int sqiUid) {
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.destinationDirectory = destinationDirectory;
        this.containerDirectory = containerDir;
        this.scrapUrl = scrapeUrl2;
        this.parentEntry = parent;
        this.sqiUid = sqiUid;
    }

    @Override
    public void run() {
        System.gc();
        UmAppDatabase db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        UmAppDatabase repository = null;
        ContainerDao containerDao = repository.getContainerDao();
        ScrapeQueueItemDao queueDao = db.getScrapeQueueItemDao();
        long startTime = System.currentTimeMillis();
        UMLogUtil.INSTANCE.logInfo("Started scraper url " + this.scrapUrl + " at start time: " + startTime);
        queueDao.setTimeStarted(this.sqiUid, startTime);
        boolean successful = false;
        try {
            this.scrapeContent();
            successful = true;
            if (this.hasContentUpdated()) {
                ContentEntry contentEntry = this.parentEntry;
                if (contentEntry == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parentEntry");
                    contentEntry = null;
                }
                File file = this.destinationDirectory;
                Intrinsics.checkNotNull((Object)file);
                long l = file.lastModified();
                File file2 = this.destinationDirectory;
                Intrinsics.checkNotNull((Object)file2);
                File file3 = this.containerDirectory;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"containerDirectory");
                    file3 = null;
                }
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, contentEntry, true, "application/zip", l, file2, db, repository, file3);
            }
        }
        catch (Exception e) {
            String string = ExceptionUtils.getMessage((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(e)");
            UMLogUtil.INSTANCE.logError(string);
            string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            File file = this.destinationDirectory;
            Intrinsics.checkNotNull((Object)file);
            File file4 = file.getParentFile();
            File file5 = this.destinationDirectory;
            Intrinsics.checkNotNull((Object)file5);
            File lastModified = new File(file4, Intrinsics.stringPlus((String)file5.getName(), (Object)"last-modified.txt"));
            ContentScraperUtil.INSTANCE.deleteFile(lastModified);
        }
        queueDao.updateSetStatusById(this.sqiUid, successful ? 3 : 4, 0);
        queueDao.setTimeFinished(this.sqiUid, System.currentTimeMillis());
        long duration = System.currentTimeMillis() - startTime;
        UMLogUtil.INSTANCE.logInfo("Ended scrape for url " + this.scrapUrl + " in duration: " + duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void scrapeContent() throws IOException {
        block31: {
            block30: {
                v0 = this.destinationDirectory;
                Intrinsics.checkNotNull((Object)v0);
                v0.mkdirs();
                response = null;
                urlConnection = null;
                try {
                    block29: {
                        block28: {
                            v1 = this.scrapUrl;
                            Intrinsics.checkNotNull((Object)v1);
                            v2 = v1.openConnection();
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                            }
                            urlConnection = (HttpURLConnection)v2;
                            urlConnection.setRequestProperty("Accept", "application/json, text/javascript, */*; q=0.01");
                            var3_3 = new GsonBuilder().create().fromJson(IOUtils.toString((InputStream)urlConnection.getInputStream(), (String)"UTF-8"), ContentResponse.class);
                            Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"GsonBuilder().create().f\u2026tentResponse::class.java)");
                            response = (ContentResponse)var3_3;
                            v3 = this.destinationDirectory;
                            Intrinsics.checkNotNull((Object)v3);
                            v4 = v3.getParentFile();
                            v5 = this.destinationDirectory;
                            Intrinsics.checkNotNull((Object)v5);
                            lastModified = new File(v4, Intrinsics.stringPlus((String)v5.getName(), (Object)"last-modified.txt"));
                            if (response.getUpdated() == null) break block28;
                            v6 = response.getUpdated();
                            Intrinsics.checkNotNull((Object)v6);
                            if (((CharSequence)v6).length() == 0) break block28;
                            v7 = response.getUpdated();
                            v8 = v7;
                            Intrinsics.checkNotNull((Object)v7);
                            break block29;
                        }
                        if (response.getCreated() == null) ** GOTO lbl-1000
                        v9 = response.getCreated();
                        Intrinsics.checkNotNull((Object)v9);
                        if (!(((CharSequence)v9).length() == 0)) {
                            v10 = response.getCreated();
                            v8 = v10;
                            Intrinsics.checkNotNull((Object)v10);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v8 = String.valueOf(System.currentTimeMillis());
                        }
                    }
                    this.contentUpdated = ContentScraperUtil.INSTANCE.isFileContentsUpdated((File)lastModified, v8);
                    if (!this.contentUpdated) {
                        var4_7 = urlConnection;
                        var4_7.disconnect();
                        return;
                    }
                    lastModified = urlConnection;
                    lastModified.disconnect();
                }
                catch (Exception e) {
                    try {
                        UMLogUtil.INSTANCE.logDebug(e.getMessage() + '\n' + e.getStackTrace() + e.getCause());
                        v11 = this.scrapUrl;
                        Intrinsics.checkNotNull((Object)v11);
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"JSON INVALID for url ", (Object)v11), e.getCause());
                    }
                    catch (Throwable e) {
                        v12 = urlConnection;
                        if (v12 != null) {
                            v12.disconnect();
                        }
                        throw e;
                    }
                }
                v13 = response.getComponent_type();
                Intrinsics.checkNotNull((Object)v13);
                if (!ContentScraperUtil.INSTANCE.isImportedComponent(v13)) {
                    v14 = response.getId();
                    Intrinsics.checkNotNull((Object)v14);
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Not an imported content type! for id", (Object)v14));
                }
                if (response.getTarget_component() == null) break block30;
                v15 = response.getTarget_component();
                Intrinsics.checkNotNull((Object)v15);
                if (v15.getChildren() != null) break block31;
            }
            v16 = response.getId();
            Intrinsics.checkNotNull((Object)v16);
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Null target component, or target component children are null for id ", (Object)v16));
        }
        hasVideo = false;
        hasQuestions = false;
        exceptionQuestion = "";
        exceptionVideo = "";
        questionsList = this.getQuestionSet$lib_content_scrapers(response);
        try {
            v17 = this.destinationDirectory;
            Intrinsics.checkNotNull((Object)v17);
            v18 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)v18);
            this.downloadQuestions(questionsList, v17, v18);
            hasQuestions = true;
        }
        catch (IllegalArgumentException e) {
            var9_14 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)var9_14, (String)"getStackTrace(e)");
            exceptionQuestion = var9_14;
            v19 = response.getId();
            Intrinsics.checkNotNull((Object)v19);
            UMLogUtil.INSTANCE.logDebug(Intrinsics.stringPlus((String)"The question set was not available for response id ", (Object)v19));
        }
        v20 = ScraperConstants.ComponentType.ONLINE.getType();
        v21 = response.getTarget_component();
        Intrinsics.checkNotNull((Object)v21);
        v22 = v21.getComponent_type();
        Intrinsics.checkNotNull((Object)v22);
        if (StringsKt.equals((String)v20, (String)v22, (boolean)true)) {
            v23 = response.getTarget_component();
            Intrinsics.checkNotNull((Object)v23);
            v24 = v23.getChildren();
            Intrinsics.checkNotNull(v24);
            for (ContentResponse children : v24) {
                v25 = ScraperConstants.ComponentType.VIDEO.getType();
                v26 = children.getComponent_type();
                Intrinsics.checkNotNull((Object)v26);
                if (!StringsKt.equals((String)v25, (String)v26, (boolean)true)) continue;
                try {
                    this.downloadVideo(children);
                    hasVideo = true;
                }
                catch (IllegalArgumentException e) {
                    var11_20 = ExceptionUtils.getStackTrace((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)var11_20, (String)"getStackTrace(e)");
                    exceptionVideo = var11_20;
                    v27 = response.getId();
                    Intrinsics.checkNotNull((Object)v27);
                    UMLogUtil.INSTANCE.logDebug(Intrinsics.stringPlus((String)"Video was unable to download or had no video for response id", (Object)v27));
                }
            }
        }
        if (!hasVideo && !hasQuestions) {
            throw new IllegalArgumentException(exceptionQuestion + '\n' + exceptionVideo + "\nNo Video or Questions found in this id " + response.getId());
        }
        contentJsonFile = new File(this.destinationDirectory, "content.json");
        if (!ContentScraperUtil.INSTANCE.fileHasContent(contentJsonFile)) {
            gson = new GsonBuilder().disableHtmlEscaping().create();
            jsonString = gson.toJson((Object)response);
            FileUtils.writeStringToFile((File)contentJsonFile, (String)jsonString, (String)"UTF-8");
        }
        try {
            jsonString = this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/edraak/index.html");
            Intrinsics.checkNotNullExpressionValue((Object)jsonString, (String)"javaClass.getResourceAsS\u2026ts.EDRAAK_INDEX_HTML_TAG)");
            index = InputStreamExtKt.readString((InputStream)jsonString);
            doc = Jsoup.parse((String)index, (String)"UTF-8");
            v28 = doc.head().selectFirst("title");
            if (v28 != null) {
                v29 = response.getTitle();
                Intrinsics.checkNotNull((Object)v29);
                v28.text(v29);
            }
            FileUtils.writeStringToFile((File)new File(this.destinationDirectory, "index.html"), (String)doc.toString(), (String)"UTF-8");
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/jquery-3.3.1.min.js", new File(this.destinationDirectory, "jquery-3.3.1.min.js"));
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/materialize.min.css", new File(this.destinationDirectory, "materialize.min.css"));
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/materialize.min.js", new File(this.destinationDirectory, "materialize.min.js"));
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/edraak/DroidNaskh-Regular.woff2", new File(this.destinationDirectory, "DroidNaskh-Regular.woff2"));
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/edraak/DroidNaskh-Bold.woff2", new File(this.destinationDirectory, "DroidNaskh-Bold.woiff2"));
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/edraak/edraak.min.css", new File(this.destinationDirectory, "edraak.min.css"));
            this.checkBeforeCopyToFile("/com/ustadmobile/lib/contentscrapers/edraak/edraak.min.js", new File(this.destinationDirectory, "edraak.min.js"));
            tinCanFile = new File(this.destinationDirectory, "tincan.xml");
            if (!ContentScraperUtil.INSTANCE.fileHasContent(tinCanFile)) {
                v30 = this.destinationDirectory;
                Intrinsics.checkNotNull((Object)v30);
                v31 = response.getTitle();
                Intrinsics.checkNotNull((Object)v31);
                v32 = this.scrapUrl;
                Intrinsics.checkNotNull((Object)v32);
                var12_21 = v32.toString();
                Intrinsics.checkNotNullExpressionValue((Object)var12_21, (String)"scrapUrl!!.toString()");
                v33 = this.scrapUrl;
                Intrinsics.checkNotNull((Object)v33);
                var13_22 = v33.toString();
                Intrinsics.checkNotNullExpressionValue((Object)var13_22, (String)"scrapUrl!!.toString()");
                var14_23 = var12_21.substring(0, StringsKt.indexOf$default((CharSequence)var13_22, (String)"component/", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)var14_23, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                v34 = response.getId();
                Intrinsics.checkNotNull((Object)v34);
                ContentScraperUtil.INSTANCE.generateTinCanXMLFile(v30, v31, "ar", "index.html", "http://adlnet.gov/expapi/activities/module", Intrinsics.stringPlus((String)var14_23, (Object)v34), "", "en");
            }
        }
        catch (IOException e) {
            v35 = response.getId();
            Intrinsics.checkNotNull((Object)v35);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to download the necessary files for response id ", (Object)v35));
            throw new IOException(ExceptionUtils.getCause((Throwable)e));
        }
        catch (TransformerException e) {
            v36 = response.getId();
            Intrinsics.checkNotNull((Object)v36);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to download the necessary files for response id ", (Object)v36));
            throw new IOException(ExceptionUtils.getCause((Throwable)e));
        }
        catch (ParserConfigurationException e) {
            v37 = response.getId();
            Intrinsics.checkNotNull((Object)v37);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to download the necessary files for response id ", (Object)v37));
            throw new IOException(ExceptionUtils.getCause((Throwable)e));
        }
    }

    private final boolean downloadVideo(ContentResponse children) {
        block9: {
            block8: {
                if (children.getVideo_info() == null) break block8;
                ContentResponse.Video_info video_info = children.getVideo_info();
                Intrinsics.checkNotNull((Object)video_info);
                if (video_info.getEncoded_videos() == null) break block8;
                ContentResponse.Video_info video_info2 = children.getVideo_info();
                Intrinsics.checkNotNull((Object)video_info2);
                List<ContentResponse.Encoded_videos> list = video_info2.getEncoded_videos();
                Intrinsics.checkNotNull(list);
                if (!list.isEmpty()) break block9;
            }
            throw new IllegalArgumentException("Component Type was Video but no video found for response id");
        }
        ContentResponse.Video_info video_info = children.getVideo_info();
        Intrinsics.checkNotNull((Object)video_info);
        List<ContentResponse.Encoded_videos> list = video_info.getEncoded_videos();
        Intrinsics.checkNotNull(list);
        ContentResponse.Encoded_videos videoHref = this.selectVideo(list);
        URL videoUrl = null;
        try {
            ContentResponse.Encoded_videos encoded_videos = videoHref;
            Intrinsics.checkNotNull((Object)encoded_videos);
            String string = encoded_videos.getUrl();
            Intrinsics.checkNotNull((Object)string);
            videoUrl = new URL(this.scrapUrl, string);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("video Malformed url for response");
        }
        File videoFile = new File(this.destinationDirectory, "video.mp4");
        File webmFile = new File(this.destinationDirectory, "video.webm");
        String string = videoHref.getModified();
        Intrinsics.checkNotNull((Object)string);
        if (ContentScraperUtil.INSTANCE.isContentUpdated(ContentScraperUtil.INSTANCE.parseServerDate(string), webmFile)) {
            try {
                FileUtils.copyURLToFile((URL)videoUrl, (File)videoFile);
                ShrinkerUtil.INSTANCE.convertVideoToWebM(videoFile, webmFile);
                ContentScraperUtil.INSTANCE.deleteFile(videoFile);
                return true;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Download Video Malformed url for response");
            }
        }
        return false;
    }

    public final boolean hasContentUpdated() {
        return this.contentUpdated;
    }

    private final void checkBeforeCopyToFile(String fileToDownload, File locationToSave) throws IOException {
        if (!ContentScraperUtil.INSTANCE.fileHasContent(locationToSave)) {
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream(fileToDownload), (File)locationToSave);
        }
    }

    @Nullable
    public final List<ContentResponse> getQuestionSet$lib_content_scrapers(@NotNull ContentResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = ScraperConstants.ComponentType.ONLINE.getType();
        ContentResponse contentResponse = response.getTarget_component();
        Intrinsics.checkNotNull((Object)contentResponse);
        String string2 = contentResponse.getComponent_type();
        Intrinsics.checkNotNull((Object)string2);
        if (StringsKt.equals((String)string, (String)string2, (boolean)true)) {
            ContentResponse contentResponse2 = response.getTarget_component();
            Intrinsics.checkNotNull((Object)contentResponse2);
            List<ContentResponse> list = contentResponse2.getChildren();
            Intrinsics.checkNotNull(list);
            for (ContentResponse children : list) {
                if (!ScraperConstants.INSTANCE.getQUESTION_SET_HOLDER_TYPES().contains(children.getComponent_type())) continue;
                ContentResponse contentResponse3 = children.getQuestion_set();
                Intrinsics.checkNotNull((Object)contentResponse3);
                return contentResponse3.getChildren();
            }
        } else {
            String string3 = ScraperConstants.ComponentType.TEST.getType();
            ContentResponse contentResponse4 = response.getTarget_component();
            Intrinsics.checkNotNull((Object)contentResponse4);
            String string4 = contentResponse4.getComponent_type();
            Intrinsics.checkNotNull((Object)string4);
            if (StringsKt.equals((String)string3, (String)string4, (boolean)true)) {
                ContentResponse contentResponse5 = response.getTarget_component();
                Intrinsics.checkNotNull((Object)contentResponse5);
                ContentResponse contentResponse6 = contentResponse5.getQuestion_set();
                Intrinsics.checkNotNull((Object)contentResponse6);
                return contentResponse6.getChildren();
            }
        }
        return null;
    }

    private final boolean downloadQuestions(List<ContentResponse> questionsList, File destinationDir, URL url) {
        if (questionsList == null || questionsList.isEmpty()) {
            throw new IllegalArgumentException("No Questions were found in the question set");
        }
        for (ContentResponse exercise : questionsList) {
            String string = exercise.getId();
            Intrinsics.checkNotNull((Object)string);
            File exerciseDirectory = new File(destinationDir, string);
            exerciseDirectory.mkdirs();
            exercise.setFull_description(ContentScraperUtil.INSTANCE.downloadAllResources(String.valueOf(exercise.getFull_description()), exerciseDirectory, url));
            exercise.setExplanation(ContentScraperUtil.INSTANCE.downloadAllResources(String.valueOf(exercise.getExplanation()), exerciseDirectory, url));
            exercise.setDescription(ContentScraperUtil.INSTANCE.downloadAllResources(String.valueOf(exercise.getDescription()), exerciseDirectory, url));
            String string2 = ScraperConstants.ComponentType.MULTICHOICE.getType();
            String string3 = exercise.getComponent_type();
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.equals((String)string2, (String)string3, (boolean)true)) {
                List<ContentResponse.Choice> list = exercise.getChoices();
                Intrinsics.checkNotNull(list);
                for (ContentResponse.Choice choice : list) {
                    choice.setDescription(ContentScraperUtil.INSTANCE.downloadAllResources(String.valueOf(choice.getDescription()), exerciseDirectory, url));
                }
            }
            List<ContentResponse.Hint> list = exercise.getHints();
            Intrinsics.checkNotNull(list);
            for (ContentResponse.Hint hint : list) {
                hint.setDescription(ContentScraperUtil.INSTANCE.downloadAllResources(String.valueOf(hint.getDescription()), exerciseDirectory, url));
            }
        }
        try {
            ContentScraperUtil.INSTANCE.saveListAsJson(destinationDir, questionsList, "questions.json");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid Questions Json");
        }
        return true;
    }

    private final ContentResponse.Encoded_videos selectVideo(List<ContentResponse.Encoded_videos> encoded_videos) {
        ContentResponse.Encoded_videos selectedVideo = null;
        int videoSize = Integer.MAX_VALUE;
        for (ContentResponse.Encoded_videos videos : encoded_videos) {
            int n = videos.getFile_size();
            boolean bl = 1 <= n ? n < videoSize : false;
            if (!bl) continue;
            selectedVideo = videos;
        }
        return selectedVideo;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0007\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/edraakK12/EdraakK12ContentScraper$Companion;", "", "()V", "generateUrl", "", "baseUrl", "contentId", "programId", "", "main", "", "args", "", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 2) {
                System.err.println("Usage: <edraak k12 json url> <file destination><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 3 ? args[2] : "");
            UMLogUtil.INSTANCE.logInfo(Intrinsics.stringPlus((String)"main url for edraak = ", (Object)args[0]));
            UMLogUtil.INSTANCE.logInfo(Intrinsics.stringPlus((String)"main file destination = ", (Object)args[1]));
            try {
                new EdraakK12ContentScraper(args[0], new File(args[1])).scrapeContent();
            }
            catch (IOException e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                UMLogUtil.INSTANCE.logError("Exception running scrapeContent");
            }
        }

        @NotNull
        public final String generateUrl(@NotNull String baseUrl, @NotNull String contentId, int programId) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)contentId, (String)"contentId");
            return baseUrl + "component/" + contentId + "/?states_program_id=" + programId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

