/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.abztract;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.container.ContainerAddOptions;
import com.ustadmobile.core.controller.VideoContentPresenterCommon;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.io.ext.InputStreamExtKt;
import com.ustadmobile.core.io.ext.UmAppDatabaseContainerIoExtKt;
import com.ustadmobile.door.DoorUri;
import com.ustadmobile.door.ext.FileExpectExtKt;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.abztract.Scraper;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import com.ustadmobile.lib.contentscrapers.util.YoutubeData;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001a\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00132\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0004R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/ustadmobile/lib/contentscrapers/abztract/YoutubeScraper;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Scraper;", "contentEntryUid", "", "sqiUid", "", "parentContentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "getDi", "()Lorg/kodein/di/DI;", "gson", "Lcom/google/gson/Gson;", "tempDir", "Ljava/io/File;", "ytPath", "", "close", "", "getJsonInfo", "Lcom/ustadmobile/lib/contentscrapers/util/YoutubeData;", "sourceUrl", "scrapeUrl", "scrapeYoutubeVideo", "videoQualityOption", "Companion", "lib-content-scrapers"})
public class YoutubeScraper
extends Scraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DI di;
    @NotNull
    private final String ytPath;
    @NotNull
    private final Gson gson;
    @Nullable
    private File tempDir;
    private static float lockedUntil;
    public static final float baseRetry = 10.0f;
    @NotNull
    private static final ReentrantLock youtubeLocker;

    public YoutubeScraper(long contentEntryUid, int sqiUid, long parentContentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(contentEntryUid, sqiUid, parentContentEntryUid, endpoint, di);
        this.di = di;
        ContentScraperUtil.INSTANCE.checkIfPathsToDriversExist();
        String string = System.getProperty("youtube-dl");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(ContentScrap\u2026Util.YOUTUBE_DL_PATH_KEY)");
        this.ytPath = string;
        string = new GsonBuilder().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().disableHtmlEscaping().create()");
        this.gson = string;
    }

    @NotNull
    public DI getDi() {
        return this.di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scrapeYoutubeVideo(@NotNull String sourceUrl, @NotNull String videoQualityOption) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Intrinsics.checkNotNullParameter((Object)videoQualityOption, (String)"videoQualityOption");
        UMLogUtil.INSTANCE.logTrace(Intrinsics.stringPlus((String)"starting youtube scrape for ", (Object)sourceUrl));
        File ytExeFile = new File(this.ytPath);
        if (!ytExeFile.exists()) {
            this.hideContentEntry();
            this.close();
            throw new ScraperException(230, Intrinsics.stringPlus((String)"Webp executable does not exist: ", (Object)this.ytPath));
        }
        this.tempDir = Files.createTempDirectory(StringsKt.substringAfter$default((String)sourceUrl, (String)"=", null, (int)2, null), new FileAttribute[0]).toFile();
        Lock lock = youtubeLocker;
        lock.lock();
        try {
            boolean $i$a$-withLock-YoutubeScraper$scrapeYoutubeVideo$22 = false;
            UMLogUtil.INSTANCE.logTrace("starting youtube lock scraper");
            boolean retryFlag = true;
            int numberOfFailures = 1;
            while (retryFlag) {
                Process process = null;
                try {
                    Thread.sleep(Random.Default.nextLong(10000L, 30000L));
                    String[] stringArray = new String[10];
                    stringArray[0] = this.ytPath;
                    stringArray[1] = "--retries";
                    stringArray[2] = "1";
                    stringArray[3] = "--limit-rate";
                    stringArray[4] = "1M";
                    stringArray[5] = "-f";
                    stringArray[6] = videoQualityOption;
                    stringArray[7] = "-o";
                    File file = this.tempDir;
                    Intrinsics.checkNotNull((Object)file);
                    stringArray[8] = Intrinsics.stringPlus((String)file.getAbsolutePath(), (Object)"/%(id)s.%(ext)s");
                    stringArray[9] = sourceUrl;
                    ProcessBuilder builder = new ProcessBuilder(stringArray);
                    process = builder.start();
                    process.waitFor();
                    int exitValue = process.exitValue();
                    if (exitValue != 0) {
                        InputStream inputStream = process.getErrorStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                        String error = InputStreamExtKt.readString((InputStream)inputStream);
                        UMLogUtil.INSTANCE.logError("Error Stream for src " + sourceUrl + " with error code  " + error);
                        if (!StringsKt.contains$default((CharSequence)error, (CharSequence)"429", (boolean)false, (int)2, null)) {
                            throw new ScraperException(220, Intrinsics.stringPlus((String)"unknown error: ", (Object)error));
                        }
                        throw new IOException("Failed " + numberOfFailures + " for  " + sourceUrl);
                    }
                    retryFlag = false;
                }
                catch (ScraperException s) {
                    this.setScrapeDone(false, 220);
                    this.hideContentEntry();
                    this.close();
                    throw s;
                }
                catch (Exception e) {
                    if (numberOfFailures > 5) {
                        this.setScrapeDone(false, 210);
                        this.hideContentEntry();
                        this.close();
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                    lockedUntil = (float)Math.pow(10.0f, numberOfFailures) * (float)1000;
                    UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"caught youtube exception with lockedUntil value of ", (Object)((long)lockedUntil)));
                    Thread.sleep((long)lockedUntil);
                    int n = numberOfFailures;
                    numberOfFailures = n + 1;
                }
                finally {
                    Process process2 = process;
                    if (process2 == null) continue;
                    process2.destroy();
                }
            }
            Unit $i$a$-withLock-YoutubeScraper$scrapeYoutubeVideo$22 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        UMLogUtil.INSTANCE.logTrace("ending youtube lock scraper");
        File file = this.tempDir;
        Intrinsics.checkNotNull((Object)file);
        File videoFile = file.listFiles()[0];
        String mimetype = Files.probeContentType(videoFile.toPath());
        if (!VideoContentPresenterCommon.Companion.getVIDEO_MIME_MAP().keySet().contains(mimetype)) {
            this.hideContentEntry();
            this.close();
            this.setScrapeDone(false, 100);
            throw new ScraperException(100, Intrinsics.stringPlus((String)"Video type not supported for ", (Object)mimetype));
        }
        Container recentContainer = this.getDb().getContainerDao().getMostRecentContainerForContentEntry(this.getContentEntryUid());
        if (recentContainer != null) {
            boolean isUpdated;
            boolean bl = isUpdated = videoFile.lastModified() > recentContainer.getCntLastModified();
            if (!isUpdated) {
                this.showContentEntry();
                this.setScrapeDone(true, 0);
                this.close();
                return;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)mimetype, (String)"mimetype");
        Container container2 = this.createBaseContainer(mimetype);
        ContainerAddOptions containerAddOptions = new ContainerAddOptions(FileExpectExtKt.toDoorUri((File)this.getContainerFolder()), false, null, null, false, 30, null);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, container2, videoFile, containerAddOptions, null){
            int label;
            final /* synthetic */ YoutubeScraper this$0;
            final /* synthetic */ Container $container;
            final /* synthetic */ File $videoFile;
            final /* synthetic */ ContainerAddOptions $containerAddOptions;
            {
                this.this$0 = $receiver;
                this.$container = $container;
                this.$videoFile = $videoFile;
                this.$containerAddOptions = $containerAddOptions;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        UmAppDatabase umAppDatabase = this.this$0.getRepo();
                        long l = this.$container.getContainerUid();
                        Object object3 = this.$videoFile;
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"videoFile");
                        DoorUri doorUri = FileExpectExtKt.toDoorUri((File)object3);
                        object3 = this.$videoFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"videoFile.name");
                        this.label = 1;
                        Object object4 = UmAppDatabaseContainerIoExtKt.addFileToContainer((UmAppDatabase)umAppDatabase, (long)l, (DoorUri)doorUri, (String)object3, (Object)new Object(), (DI)this.this$0.getDi(), (ContainerAddOptions)this.$containerAddOptions, (Continuation)((Continuation)this));
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.showContentEntry();
        this.setScrapeDone(true, 0);
        this.close();
    }

    public static /* synthetic */ void scrapeYoutubeVideo$default(YoutubeScraper youtubeScraper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrapeYoutubeVideo");
        }
        if ((n & 2) != 0) {
            string2 = "worst[ext=webm]/worst";
        }
        youtubeScraper.scrapeYoutubeVideo(string, string2);
    }

    @Override
    public void scrapeUrl(@NotNull String sourceUrl) {
        long l;
        int n;
        String string;
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Ref.ObjectRef entry = new Ref.ObjectRef();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<ContentEntry>)entry, this, null){
            Object L$0;
            int label;
            final /* synthetic */ Ref.ObjectRef<ContentEntry> $entry;
            final /* synthetic */ YoutubeScraper this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.L$0 = var2_3 = this.$entry;
                        this.label = 1;
                        v0 = this.this$0.getDb().getContentEntryDao().findByUidAsync(this.this$0.getContentEntryUid(), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        var2_3 = (Ref.ObjectRef<ContentEntry>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        var2_3.element = v0;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (entry.element == null) {
            this.close();
            this.hideContentEntry();
            this.setScrapeDone(false, 104);
            throw new ScraperException(104, Intrinsics.stringPlus((String)"entry was not created ", (Object)sourceUrl));
        }
        YoutubeData data = this.getJsonInfo(sourceUrl);
        if (data == null) {
            this.hideContentEntry();
            this.setScrapeDone(false, 0);
            this.close();
            throw new ScraperException(0, "No Data Found after running youtube-dl");
        }
        String string2 = data.getId();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = data.getTitle();
        ContentEntry contentEntry = (ContentEntry)entry.element;
        if (contentEntry == null) {
            string = "";
        } else {
            string = contentEntry.getPublisher();
            if (string == null) {
                string = "";
            }
        }
        ContentEntry contentEntry2 = (ContentEntry)entry.element;
        ContentEntry contentEntry3 = (ContentEntry)entry.element;
        ContentEntry contentEntry4 = (ContentEntry)entry.element;
        ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string2, string3, sourceUrl, string, contentEntry2 == null ? 0 : (n = contentEntry2.getLicenseType()), contentEntry3 == null ? 0L : (l = contentEntry3.getPrimaryLanguageUid()), contentEntry4 == null ? null : Long.valueOf(contentEntry4.getLanguageVariantUid()), data.getDescription(), true, "", data.getThumbnail(), "", "", 4, this.getRepo().getContentEntryDao());
        YoutubeScraper.scrapeYoutubeVideo$default(this, sourceUrl, null, 2, null);
        this.setScrapeDone(true, 0);
        this.showContentEntry();
        UMLogUtil.INSTANCE.logError("end of scrape");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final YoutubeData getJsonInfo(String sourceUrl) {
        File ytExeFile = new File(this.ytPath);
        if (!ytExeFile.exists()) {
            this.hideContentEntry();
            this.close();
            throw new ScraperException(230, Intrinsics.stringPlus((String)"Webp executable does not exist: ", (Object)this.ytPath));
        }
        Lock lock = youtubeLocker;
        lock.lock();
        try {
            boolean bl = false;
            UMLogUtil.INSTANCE.logTrace("starting youtube lock json");
            boolean retryFlag = true;
            int numberOfFailures = 1;
            while (retryFlag) {
                Process process = null;
                try {
                    Thread.sleep(Random.Default.nextLong(10000L, 30000L));
                    String[] stringArray = new String[]{this.ytPath, "--retries", "1", "-i", "-J", "--flat-playlist", sourceUrl};
                    ProcessBuilder builder = new ProcessBuilder(stringArray);
                    process = builder.start();
                    process.waitFor(30L, TimeUnit.SECONDS);
                    InputStream inputStream = process.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
                    String data = InputStreamExtKt.readString((InputStream)inputStream);
                    int exitValue = process.exitValue();
                    if (exitValue != 0) {
                        InputStream inputStream2 = process.getErrorStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
                        String error = InputStreamExtKt.readString((InputStream)inputStream2);
                        UMLogUtil.INSTANCE.logError("Error Stream for src " + sourceUrl + " with error code  " + error);
                        if (!StringsKt.contains$default((CharSequence)error, (CharSequence)"429", (boolean)false, (int)2, null)) {
                            throw new ScraperException(220, Intrinsics.stringPlus((String)"unknown error: ", (Object)error));
                        }
                        throw new IOException("Failed " + numberOfFailures + " for  " + sourceUrl);
                    }
                    retryFlag = false;
                    YoutubeData youtubeData = (YoutubeData)this.gson.fromJson(data, YoutubeData.class);
                    YoutubeData youtubeData2 = youtubeData;
                    return youtubeData2;
                }
                catch (ScraperException s) {
                    this.setScrapeDone(false, 220);
                    this.hideContentEntry();
                    this.close();
                    throw s;
                }
                catch (Exception e) {
                    if (numberOfFailures > 5) {
                        this.setScrapeDone(false, 210);
                        this.hideContentEntry();
                        this.close();
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                    lockedUntil = (float)Math.pow(10.0f, numberOfFailures) * (float)1000;
                    UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"caught youtube exception with lockedUntil value of ", (Object)((long)lockedUntil)));
                    Thread.sleep((long)lockedUntil);
                    int n = numberOfFailures;
                    numberOfFailures = n + 1;
                }
                finally {
                    Process process2 = process;
                    if (process2 != null) {
                        process2.destroy();
                    }
                    UMLogUtil.INSTANCE.logTrace("ending youtube lock json");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        UMLogUtil.INSTANCE.logTrace("ending youtube lock json");
        return null;
    }

    @Override
    public void close() {
        boolean bl;
        File file = this.tempDir;
        boolean deleted = file == null ? false : (bl = FilesKt.deleteRecursively((File)file));
        File file2 = this.tempDir;
        UMLogUtil.INSTANCE.logError("did it delete: " + deleted + " for " + (file2 == null ? null : file2.getName()) + ' ');
    }

    static {
        youtubeLocker = new ReentrantLock();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/lib/contentscrapers/abztract/YoutubeScraper$Companion;", "", "()V", "baseRetry", "", "lockedUntil", "getLockedUntil", "()F", "setLockedUntil", "(F)V", "youtubeLocker", "Ljava/util/concurrent/locks/ReentrantLock;", "getYoutubeLocker", "()Ljava/util/concurrent/locks/ReentrantLock;", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        public final float getLockedUntil() {
            return lockedUntil;
        }

        public final void setLockedUntil(float f) {
            lockedUntil = f;
        }

        @NotNull
        public final ReentrantLock getYoutubeLocker() {
            return youtubeLocker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

