/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.khanacademy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.container.ContainerAddOptions;
import com.ustadmobile.core.contentformats.har.HarExtra;
import com.ustadmobile.core.contentformats.har.HarRegexPair;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao;
import com.ustadmobile.core.io.ext.UmAppDatabaseContainerIoExtKt;
import com.ustadmobile.door.DoorUri;
import com.ustadmobile.door.ext.FileExpectExtKt;
import com.ustadmobile.door.ext.InputStreamExtKt;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.abztract.HarScraper;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import com.ustadmobile.lib.contentscrapers.khanacademy.ArticleResponse;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanArticleScraper;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstantsKt;
import com.ustadmobile.lib.contentscrapers.khanacademy.PropsSubjectResponse;
import com.ustadmobile.lib.contentscrapers.khanacademy.SubjectListResponse;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.core.har.HarEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.kodein.di.DI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/ustadmobile/lib/contentscrapers/khanacademy/KhanArticleScraper;", "Lcom/ustadmobile/lib/contentscrapers/abztract/HarScraper;", "contentEntryUid", "", "sqiUid", "", "parentContentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "getDi", "()Lorg/kodein/di/DI;", "generateArtcleUrl", "", "articleId", "scrapeUrl", "", "sourceUrl", "lib-content-scrapers"})
public final class KhanArticleScraper
extends HarScraper {
    @NotNull
    private final DI di;

    public KhanArticleScraper(long contentEntryUid, int sqiUid, long parentContentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(contentEntryUid, sqiUid, parentContentEntryUid, endpoint, di);
        this.di = di;
    }

    @Override
    @NotNull
    public DI getDi() {
        return this.di;
    }

    @Override
    public void scrapeUrl(@NotNull String sourceUrl) {
        Object v8;
        SubjectListResponse.ComponentData.NavData navData;
        Gson gson;
        Ref.ObjectRef entry;
        block14: {
            SubjectListResponse.ComponentData compProps;
            SubjectListResponse data;
            Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
            entry = new Ref.ObjectRef();
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<ContentEntry>)entry, this, null){
                Object L$0;
                int label;
                final /* synthetic */ Ref.ObjectRef<ContentEntry> $entry;
                final /* synthetic */ KhanArticleScraper this$0;
                {
                    this.$entry = $entry;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.L$0 = var2_3 = this.$entry;
                            this.label = 1;
                            v0 = this.this$0.getDb().getContentEntryDao().findByUidAsync(this.this$0.getContentEntryUid(), (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            var2_3 = (Ref.ObjectRef<ContentEntry>)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            var2_3.element = v0;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            if (entry.element == null) {
                this.close();
                this.hideContentEntry();
                this.setScrapeDone(false, 104);
                throw new ScraperException(104, Intrinsics.stringPlus((String)"Does not have the article data id which we need to scrape the page for url ", (Object)sourceUrl));
            }
            URL url = new URL(sourceUrl);
            String jsonContent = KhanConstantsKt.getJsonContent(url);
            gson = new GsonBuilder().disableHtmlEscaping().create();
            SubjectListResponse subjectListResponse = data = (SubjectListResponse)gson.fromJson(jsonContent, SubjectListResponse.class);
            Intrinsics.checkNotNull((Object)subjectListResponse);
            if (subjectListResponse.getComponentProps() == null) {
                data = ((PropsSubjectResponse)gson.fromJson(jsonContent, PropsSubjectResponse.class)).getProps();
            }
            SubjectListResponse subjectListResponse2 = data;
            Intrinsics.checkNotNull((Object)subjectListResponse2);
            SubjectListResponse.ComponentData componentData = compProps = subjectListResponse2.getComponentProps();
            Intrinsics.checkNotNull((Object)componentData);
            SubjectListResponse.ComponentData.NavData navData2 = componentData.getTutorialNavData();
            if (navData2 == null) {
                navData2 = compProps.getTutorialPageData();
            }
            SubjectListResponse.ComponentData.NavData navData3 = navData = navData2;
            Intrinsics.checkNotNull((Object)navData3);
            List contentList = navData3.getContentModels();
            if (contentList == null || contentList.isEmpty()) {
                contentList = new ArrayList();
                SubjectListResponse.ComponentData.NavData.ContentModel contentModel = navData.getContentModel();
                Intrinsics.checkNotNull((Object)contentModel);
                contentList.add(contentModel);
            }
            if (contentList.isEmpty()) {
                this.close();
                this.hideContentEntry();
                this.setScrapeDone(false, 200);
                throw new ScraperException(200, Intrinsics.stringPlus((String)"Does not have the article data id which we need to scrape the page for url ", (Object)sourceUrl));
            }
            String slugArticle = StringsKt.substringAfterLast$default((String)sourceUrl, (String)"/", null, (int)2, null);
            for (Object t : (Iterable)contentList) {
                SubjectListResponse.ComponentData.NavData.ContentModel it = (SubjectListResponse.ComponentData.NavData.ContentModel)t;
                boolean bl = false;
                CharSequence charSequence = sourceUrl;
                String string = it.getRelativeUrl();
                Intrinsics.checkNotNull((Object)string);
                if (!(StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)it.getSlug(), (Object)slugArticle))) continue;
                v8 = t;
                break block14;
            }
            v8 = null;
        }
        SubjectListResponse.ComponentData.NavData.ContentModel content = v8;
        if (content == null) {
            this.close();
            this.hideContentEntry();
            this.setScrapeDone(false, 200);
            throw new ScraperException(200, Intrinsics.stringPlus((String)"No content found in contentModel for url: ", (Object)sourceUrl));
        }
        String articleId = content.getId();
        String nodeSlug = content.getNodeSlug();
        String articleUrl = this.generateArtcleUrl(articleId);
        ArticleResponse response = (ArticleResponse)gson.fromJson(IOUtils.toString((URL)new URL(articleUrl), (String)"UTF-8"), ArticleResponse.class);
        String string = response.getDate_modified();
        Intrinsics.checkNotNull((Object)string);
        long dateModified = ContentScraperUtil.INSTANCE.parseServerDate(string);
        Container recentContainer = this.getDb().getContainerDao().getMostRecentContainerForContentEntry(this.getContentEntryUid());
        boolean isContentUpdated = recentContainer == null ? true : !Intrinsics.areEqual((Object)recentContainer.getMimeType(), (Object)"application/har+zip") && dateModified > recentContainer.getCntLastModified();
        Object object = entry.element;
        Intrinsics.checkNotNull((Object)object);
        String string2 = ((ContentEntry)object).getSourceUrl();
        Intrinsics.checkNotNull((Object)string2);
        String sourceId = string2;
        String commonSourceUrl = '%' + StringsKt.substringBefore$default((String)sourceId, (String)".", null, (int)2, null) + '%';
        List commonEntryList = this.getDb().getContentEntryDao().findSimilarIdEntryForKhan(commonSourceUrl);
        Iterable $this$forEach$iv = commonEntryList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentEntry it = (ContentEntry)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getSourceUrl(), (Object)sourceId)) continue;
            ContentEntryRelatedEntryJoinDao contentEntryRelatedEntryJoinDao = this.getDb().getContentEntryRelatedEntryJoinDao();
            Object object2 = entry.element;
            Intrinsics.checkNotNull((Object)object2);
            ContentScraperUtil.INSTANCE.insertOrUpdateRelatedContentJoin(contentEntryRelatedEntryJoinDao, it, (ContentEntry)object2, 1);
        }
        if (!isContentUpdated) {
            this.close();
            this.showContentEntry();
            this.setScrapeDone(true, 0);
            return;
        }
        HarExtra harExtra = new HarExtra();
        HarScraper.HarScraperResult scraperResult = null;
        try {
            scraperResult = HarScraper.startHarScrape$default(this, sourceUrl, scrapeUrl.3.INSTANCE, CollectionsKt.listOf((Object)new Function1<HarEntry, HarEntry>(sourceUrl){
                final /* synthetic */ String $sourceUrl;
                {
                    this.$sourceUrl = $sourceUrl;
                    super(1);
                }

                @NotNull
                public final HarEntry invoke(@NotNull HarEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    if (Intrinsics.areEqual((Object)entry.getRequest().getUrl(), (Object)this.$sourceUrl)) {
                        Document doc = Jsoup.parse((String)entry.getResponse().getContent().getText());
                        doc.head().append("<link rel='stylesheet' href='https://www.khanacademy.org/khanscraper.css' type='text/css'/>");
                        doc.head().append("<script> document.cookie = \"fkey=abcde;\" </script>");
                        entry.getResponse().getContent().setText(doc.html());
                    }
                    return entry;
                }
            }), null, false, (Function1)new Function1<BrowserMobProxyServer, Boolean>(this){
                final /* synthetic */ KhanArticleScraper this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BrowserMobProxyServer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    List list = it.getHar().getLog().getEntries();
                    HarScraper harScraper = this.this$0;
                    String string = IOUtils.toString((InputStream)this.this$0.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/khan/khanscraper.css"), (String)"UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(javaClass.getRe\u2026_CSS_LINK), UTF_ENCODING)");
                    list.add(HarScraper.addHarEntry$default(harScraper, string, 0, null, "text/css", "https://www.khanacademy.org/khanscraper.css", null, 38, null));
                    return true;
                }
            }, 24, null);
        }
        catch (Exception e) {
            Object element$iv;
            this.hideContentEntry();
            this.setScrapeDone(false, 0);
            this.close();
            element$iv = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue(element$iv, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError((String)element$iv);
            throw new ScraperException(0, e.getMessage());
        }
        List linksList = new ArrayList();
        List<SubjectListResponse.ComponentData.NavData.ContentModel> navList = navData.getNavItems();
        if (navList != null) {
            for (SubjectListResponse.ComponentData.NavData.ContentModel navItem : navList) {
                if (Intrinsics.areEqual((Object)navItem.getNodeSlug(), (Object)nodeSlug)) continue;
                String string3 = navItem.getNodeSlug();
                Intrinsics.checkNotNull((Object)string3);
                String string4 = Intrinsics.stringPlus((String)"https://((.*).khanacademy.org|cdn.kastatic.org)/(.*)", (Object)string3);
                String string5 = navItem.getId();
                Intrinsics.checkNotNull((Object)string5);
                linksList.add(new HarRegexPair(string4, Intrinsics.stringPlus((String)"content-detail?sourceUrl=khan-id://", (Object)string5)));
            }
        } else {
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Your related items are in another json for url ", (Object)sourceUrl));
        }
        harExtra.setLinks(linksList);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(gson, harExtra, this, scraperResult, null){
            Object L$0;
            int label;
            final /* synthetic */ Gson $gson;
            final /* synthetic */ HarExtra $harExtra;
            final /* synthetic */ KhanArticleScraper this$0;
            final /* synthetic */ HarScraper.HarScraperResult $scraperResult;
            {
                this.$gson = $gson;
                this.$harExtra = $harExtra;
                this.this$0 = $receiver;
                this.$scraperResult = $scraperResult;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        File harExtraFile = File.createTempFile("harextras", "json");
                        String string = this.$gson.toJson((Object)this.$harExtra);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(harExtra)");
                        Object object3 = Charsets.UTF_8;
                        byte[] byArray = string.getBytes((Charset)object3);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(byArray);
                        InputStream inputStream = contentInputStream;
                        Intrinsics.checkNotNullExpressionValue((Object)harExtraFile, (String)"harExtraFile");
                        InputStreamExtKt.writeToFile((InputStream)inputStream, (File)harExtraFile);
                        ContainerAddOptions containerAddOptions = new ContainerAddOptions(FileExpectExtKt.toDoorUri((File)this.this$0.getContainerFolder()), false, null, null, false, 30, null);
                        UmAppDatabase umAppDatabase = this.this$0.getRepo();
                        long l = this.$scraperResult.getContainerUid();
                        DoorUri doorUri = FileExpectExtKt.toDoorUri((File)harExtraFile);
                        object3 = harExtraFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"harExtraFile.name");
                        this.L$0 = harExtraFile;
                        this.label = 1;
                        Object object4 = UmAppDatabaseContainerIoExtKt.addFileToContainer((UmAppDatabase)umAppDatabase, (long)l, (DoorUri)doorUri, (String)object3, (Object)new Object(), (DI)this.this$0.getDi(), (ContainerAddOptions)containerAddOptions, (Continuation)((Continuation)this));
                        if (object4 != object2) return Boxing.boxBoolean((boolean)harExtraFile.delete());
                        return object2;
                    }
                    case 1: {
                        void $result;
                        File harExtraFile = (File)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Boxing.boxBoolean((boolean)harExtraFile.delete());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.setScrapeDone(true, 0);
        this.close();
    }

    private final String generateArtcleUrl(String articleId) {
        String string = articleId;
        Intrinsics.checkNotNull((Object)string);
        return Intrinsics.stringPlus((String)"http://www.khanacademy.org/api/v1/articles/", (Object)string);
    }
}

