/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers;

import com.ustadmobile.core.contentformats.epub.ocf.OcfDocument;
import com.ustadmobile.core.contentformats.epub.ocf.OcfRootFile;
import com.ustadmobile.core.contentformats.epub.opf.OpfDocument;
import com.ustadmobile.core.contentformats.epub.opf.OpfItem;
import com.ustadmobile.core.io.ext.InputStreamExtKt;
import com.ustadmobile.core.util.UMFileUtil;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.port.sharedse.util.UmZipUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001dJ\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0016\u0010$\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0016\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0016\u0010'\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001dH\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001b\u0010+\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0007\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001dJ\u0016\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u000202J\u001a\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001d2\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u0010\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u000208H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u0006:"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ShrinkerUtil;", "", "()V", "HTML_MIME_TYPES", "", "", "getHTML_MIME_TYPES", "()Ljava/util/List;", "IMAGE_MIME_TYPES", "getIMAGE_MIME_TYPES", "STYLE_DROP", "", "STYLE_KEEP", "STYLE_OUTSOURCE_TO_LINKED_CSS", "cwebpPath", "kotlin.jvm.PlatformType", "getCwebpPath", "()Ljava/lang/String;", "setCwebpPath", "(Ljava/lang/String;)V", "ffmpegPath", "getFfmpegPath", "setFfmpegPath", "cleanUpAttributeListWithMultipleSrc", "", "element", "Lorg/jsoup/nodes/Element;", "replacedFiles", "", "Ljava/io/File;", "htmlFile", "cleanXml", "xmlFile", "convertAudioToOpos", "src", "dest", "convertImageToWebp", "convertJpgToPng", "convertKhanVideoToWebMAndCodec2", "convertVideoToWebM", "createTmpFolderForZipAndUnZip", "contentFile", "deleteAllAttributesWithSrc", "main", "args", "", "([Ljava/lang/String;)V", "shrinkEpub", "epub", "options", "Lcom/ustadmobile/lib/contentscrapers/ShrinkerUtil$EpubShrinkerOptions;", "shrinkEpubFiles", "", "directory", "startProcess", "process", "Ljava/lang/Process;", "EpubShrinkerOptions", "lib-content-scrapers"})
public final class ShrinkerUtil {
    @NotNull
    public static final ShrinkerUtil INSTANCE = new ShrinkerUtil();
    @NotNull
    private static final List<String> HTML_MIME_TYPES;
    @NotNull
    private static final List<String> IMAGE_MIME_TYPES;
    private static String cwebpPath;
    private static String ffmpegPath;
    public static final int STYLE_OUTSOURCE_TO_LINKED_CSS = 0;
    public static final int STYLE_KEEP = 1;
    public static final int STYLE_DROP = 2;

    private ShrinkerUtil() {
    }

    @NotNull
    public final List<String> getHTML_MIME_TYPES() {
        return HTML_MIME_TYPES;
    }

    @NotNull
    public final List<String> getIMAGE_MIME_TYPES() {
        return IMAGE_MIME_TYPES;
    }

    public final String getCwebpPath() {
        return cwebpPath;
    }

    public final void setCwebpPath(String string) {
        cwebpPath = string;
    }

    public final String getFfmpegPath() {
        return ffmpegPath;
    }

    public final void setFfmpegPath(String string) {
        ffmpegPath = string;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            System.err.println("Usage:<file location><optional log{trace, debug, info, warn, error, fatal}>");
            System.exit(1);
        }
        UMLogUtil.INSTANCE.setLevel(args.length == 2 ? args[1] : "");
        try {
            File epubFile = new File(args[1]);
            INSTANCE.shrinkEpub(epubFile);
        }
        catch (Exception e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to shrink epub ", (Object)args[1]));
        }
    }

    @NotNull
    public final File shrinkEpub(@NotNull File epub) throws IOException {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        File tmpFolder = null;
        try {
            tmpFolder = this.createTmpFolderForZipAndUnZip(epub);
            this.shrinkEpubFiles(tmpFolder, null);
        }
        catch (IOException e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            throw e;
        }
        return tmpFolder;
    }

    @NotNull
    public final File shrinkEpub(@NotNull File epub, @NotNull EpubShrinkerOptions options) throws IOException {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        File tmpFolder = null;
        try {
            tmpFolder = this.createTmpFolderForZipAndUnZip(epub);
            this.shrinkEpubFiles(tmpFolder, options);
        }
        catch (IOException e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            throw e;
        }
        return tmpFolder;
    }

    private final File createTmpFolderForZipAndUnZip(File contentFile) throws IOException {
        File parentFolder = contentFile.getParentFile();
        String string = contentFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentFile.name");
        File tmpFolder = new File(parentFolder, UMFileUtil.INSTANCE.stripExtensionIfPresent(string));
        UmZipUtils.INSTANCE.unzip(contentFile, tmpFolder);
        return tmpFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanXml(@NotNull File xmlFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Closeable closeable = FileUtils.openInputStream((File)xmlFile);
        Throwable throwable = null;
        try {
            FileInputStream is = (FileInputStream)closeable;
            boolean bl = false;
            Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
            doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
            doc.outputSettings().prettyPrint(false);
            FileUtils.writeStringToFile((File)xmlFile, (String)doc.toString(), (String)"UTF-8");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final boolean shrinkEpubFiles(File directory, EpubShrinkerOptions options) throws IOException {
        block47: {
            Closeable closeable;
            boolean bl;
            HashMap replacedFiles;
            OpfDocument document2;
            File opfFile;
            XmlPullParserFactory xppFactory;
            FileOutputStream opfFileOutputStream;
            FileInputStream ocfFileInputStream;
            FileInputStream opfFileInputStream;
            block46: {
                Object object;
                Closeable closeable2;
                Object htmlFile;
                opfFileInputStream = null;
                ocfFileInputStream = null;
                opfFileOutputStream = null;
                xppFactory = XmlPullParserFactory.newInstance();
                OcfDocument ocfDoc = new OcfDocument();
                String[] stringArray = new String[]{"container.xml"};
                File ocfFile = new File(directory, ((Object)Paths.get("META-INF", stringArray)).toString());
                ocfFileInputStream = new FileInputStream(ocfFile);
                XmlPullParser ocfParser = xppFactory.newPullParser();
                Intrinsics.checkNotNullExpressionValue((Object)ocfParser, (String)"ocfParser");
                ocfDoc.loadFromParser(ocfParser);
                String string = ((OcfRootFile)ocfDoc.getRootFiles().get(0)).getFullPath();
                Intrinsics.checkNotNull((Object)string);
                opfFile = new File(directory, string);
                File opfDir = opfFile.getParentFile();
                this.cleanXml(opfFile);
                document2 = new OpfDocument();
                opfFileInputStream = new FileInputStream(opfFile);
                XmlPullParser xmlPullParser = xppFactory.newPullParser();
                Intrinsics.checkNotNullExpressionValue((Object)xmlPullParser, (String)"xmlPullParser");
                OpfDocument.loadFromOPF$default((OpfDocument)document2, (XmlPullParser)xmlPullParser, (int)0, (int)2, null);
                Map manifestList = document2.getManifestItems();
                replacedFiles = new HashMap();
                HashMap styleMap = new HashMap();
                ArrayList<OpfItem> newOpfItems = new ArrayList<OpfItem>();
                for (Object itemValue : manifestList.values()) {
                    String oldHrefValue;
                    if (!CollectionsKt.contains((Iterable)IMAGE_MIME_TYPES, (Object)itemValue.getMediaType())) continue;
                    String string2 = oldHrefValue = itemValue.getHref();
                    Intrinsics.checkNotNull((Object)string2);
                    String newHref = Intrinsics.stringPlus((String)UMFileUtil.INSTANCE.stripExtensionIfPresent(string2), (Object)".webp");
                    File inputFile = new File(opfDir, oldHrefValue);
                    File outputFile = new File(opfDir, newHref);
                    try {
                        this.convertImageToWebp(inputFile, outputFile);
                    }
                    catch (Exception e) {
                        String string3 = ExceptionUtils.getStackTrace((Throwable)e);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(e)");
                        UMLogUtil.INSTANCE.logError(string3);
                        continue;
                    }
                    ((Map)replacedFiles).put(inputFile, outputFile);
                    if (!ContentScraperUtil.INSTANCE.fileHasContent(outputFile)) continue;
                    itemValue.setHref(newHref);
                    itemValue.setMimeType("image/webp");
                }
                Ref.IntRef countStyle = new Ref.IntRef();
                for (OpfItem opfItem : manifestList.values()) {
                    if (!CollectionsKt.contains((Iterable)HTML_MIME_TYPES, (Object)opfItem.getMediaType())) continue;
                    String string4 = opfItem.getHref();
                    Intrinsics.checkNotNull((Object)string4);
                    htmlFile = new File(opfDir, string4);
                    closeable2 = new FileInputStream((File)htmlFile);
                    object = null;
                    try {
                        String cssToAdd;
                        String string5;
                        CharSequence charSequence;
                        CharSequence pathToStyleFile;
                        CharSequence cssText;
                        Object object2;
                        Document document3;
                        FileInputStream htmlFileInputStream = (FileInputStream)closeable2;
                        boolean bl2 = false;
                        String html = InputStreamExtKt.readString((InputStream)htmlFileInputStream);
                        CharSequence charSequence2 = html;
                        String string6 = "&nbsp;";
                        string6 = new Regex(string6);
                        Object object3 = "&#160;";
                        html = string6.replace(charSequence2, (String)object3);
                        charSequence2 = html;
                        string6 = "\\u2029";
                        string6 = new Regex(string6);
                        object3 = "";
                        html = string6.replace(charSequence2, (String)object3);
                        html = StringsKt.replace$default((String)html, (String)"<!DOCTYPE html[<!ENTITY nbsp \"&#160;\">]>", (String)"<!DOCTYPE html>", (boolean)false, (int)4, null);
                        Document doc = Jsoup.parse((String)html, (String)"", (Parser)Parser.xmlParser());
                        doc.outputSettings().prettyPrint(false);
                        doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
                        EpubShrinkerOptions epubShrinkerOptions = options;
                        if (epubShrinkerOptions == null) {
                            document3 = doc;
                        } else {
                            Function1<Document, Document> function1 = epubShrinkerOptions.getEditor();
                            if (function1 == null) {
                                document3 = doc;
                            } else {
                                Document document4 = doc;
                                Intrinsics.checkNotNullExpressionValue((Object)document4, (String)"doc");
                                document3 = (Document)function1.invoke((Object)document4);
                                if (document3 == null) {
                                    document3 = doc = doc;
                                }
                            }
                        }
                        if (replacedFiles.size() != 0) {
                            Elements elements = doc.select("[src]");
                            for (Element element : elements) {
                                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                                INSTANCE.cleanUpAttributeListWithMultipleSrc(element, replacedFiles, (File)htmlFile);
                            }
                        }
                        Elements styleList = doc.select("style[type=text/css]");
                        for (Element style : styleList) {
                            int styleAction;
                            int n;
                            EpubShrinkerOptions epubShrinkerOptions2 = options;
                            if (epubShrinkerOptions2 == null) {
                                n = 0;
                            } else {
                                Function1<Element, Integer> function1 = epubShrinkerOptions2.getStyleElementHelper();
                                if (function1 == null) {
                                    n = 0;
                                } else {
                                    Intrinsics.checkNotNullExpressionValue((Object)style, (String)"style");
                                    object2 = (Integer)function1.invoke((Object)style);
                                    n = object2 == null ? 0 : (Integer)object2;
                                }
                            }
                            if ((styleAction = n) == 2 || (cssText = style.text()) == null || ((CharSequence)cssText).length() == 0) continue;
                            pathToStyleFile = (String)styleMap.get(cssText);
                            if (pathToStyleFile == null) {
                                ++countStyle.element;
                                File styleFile = new File(((File)htmlFile).getParentFile(), "style_" + countStyle.element + ".css");
                                FileUtils.writeStringToFile((File)styleFile, (String)cssText, (String)"UTF-8");
                                charSequence = ((Object)Paths.get(((File)htmlFile).getParentFile().toURI()).relativize(Paths.get(styleFile.toURI()))).toString();
                                CharSequence charSequence3 = Pattern.quote("\\");
                                Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"quote(\"\\\\\")");
                                charSequence3 = new Regex(charSequence3);
                                Object object4 = "/";
                                pathToStyleFile = charSequence3.replace(charSequence, (String)object4);
                                charSequence3 = ((Object)Paths.get(opfDir.toURI()).relativize(Paths.get(styleFile.toURI()))).toString();
                                object4 = Pattern.quote("\\");
                                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"quote(\"\\\\\")");
                                object4 = new Regex((String)object4);
                                String string7 = "/";
                                String pathFromOpfToStyleFile = object4.replace(charSequence3, string7);
                                OpfItem styleOpf = new OpfItem();
                                styleOpf.setHref(pathFromOpfToStyleFile);
                                styleOpf.setMediaType("text/css");
                                styleOpf.setId(Intrinsics.stringPlus((String)"style_", (Object)countStyle.element));
                                newOpfItems.add(styleOpf);
                                object4 = styleMap;
                                string7 = cssText;
                                object4.put(string7, pathToStyleFile);
                            }
                            doc.head().append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + pathToStyleFile + "\"/>");
                        }
                        EpubShrinkerOptions epubShrinkerOptions3 = options;
                        if (epubShrinkerOptions3 == null) {
                            string5 = null;
                        } else {
                            Function0<String> function0 = epubShrinkerOptions3.getLinkHelper();
                            string5 = cssToAdd = function0 == null ? null : (String)function0.invoke();
                        }
                        if (cssToAdd != null) {
                            File cssFile = new File(((File)htmlFile).getParentFile(), "cssHelper.css");
                            FileUtils.writeStringToFile((File)cssFile, (String)cssToAdd, (String)"UTF-8");
                            cssText = ((Object)Paths.get(((File)htmlFile).getParentFile().toURI()).relativize(Paths.get(cssFile.toURI()))).toString();
                            pathToStyleFile = Pattern.quote("\\");
                            Intrinsics.checkNotNullExpressionValue((Object)pathToStyleFile, (String)"quote(\"\\\\\")");
                            pathToStyleFile = new Regex(pathToStyleFile);
                            object2 = "/";
                            String pathToCss = pathToStyleFile.replace(cssText, (String)object2);
                            pathToStyleFile = ((Object)Paths.get(opfDir.toURI()).relativize(Paths.get(cssFile.toURI()))).toString();
                            object2 = Pattern.quote("\\");
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"quote(\"\\\\\")");
                            object2 = new Regex((String)object2);
                            charSequence = "/";
                            String pathFromOpfToCssFile = object2.replace(pathToStyleFile, (String)charSequence);
                            OpfItem styleOpf = new OpfItem();
                            styleOpf.setHref(pathFromOpfToCssFile);
                            styleOpf.setMediaType("text/css");
                            styleOpf.setId("cssHelper");
                            newOpfItems.add(styleOpf);
                            doc.head().append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + pathToCss + "\"/>");
                            ((Map)styleMap).put(cssToAdd, pathFromOpfToCssFile);
                        }
                        styleList.remove();
                        FileUtils.writeStringToFile((File)htmlFile, (String)doc.toString(), (String)"UTF-8");
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                    }
                }
                for (OpfItem item : newOpfItems) {
                    htmlFile = manifestList;
                    Intrinsics.checkNotNull((Object)item.getId());
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    object = item;
                    htmlFile.put(closeable2, object);
                }
                if (newOpfItems.size() != 0 || replacedFiles.size() != 0 || styleMap.size() != 0) break block46;
                boolean itemValue = false;
                Object object5 = opfFileInputStream;
                ((FileInputStream)object5).close();
                object5 = ocfFileInputStream;
                ((FileInputStream)object5).close();
                return itemValue;
            }
            try {
                XmlSerializer xmlSerializer = xppFactory.newSerializer();
                opfFileOutputStream = new FileOutputStream(opfFile);
                xmlSerializer.setOutput((OutputStream)opfFileOutputStream, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)xmlSerializer, (String)"xmlSerializer");
                document2.serialize(xmlSerializer);
                opfFileOutputStream.flush();
                for (File replacedFile : replacedFiles.keySet()) {
                    Intrinsics.checkNotNullExpressionValue((Object)replacedFile, (String)"replacedFile");
                    if (!ContentScraperUtil.INSTANCE.fileHasContent(replacedFile) || replacedFile.delete()) continue;
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Could not delete: ", (Object)replacedFile));
                }
                bl = true;
                closeable = opfFileInputStream;
            }
            catch (XmlPullParserException e) {
                Unit unit;
                Unit unit2;
                Unit unit3;
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to xmlpullparse for directory ", (Object)directory.getPath()));
                FileInputStream fileInputStream = opfFileInputStream;
                if (fileInputStream == null) {
                    unit3 = null;
                } else {
                    fileInputStream.close();
                    unit3 = Unit.INSTANCE;
                }
                FileOutputStream fileOutputStream = opfFileOutputStream;
                if (fileOutputStream == null) {
                    unit2 = null;
                } else {
                    fileOutputStream.close();
                    unit2 = Unit.INSTANCE;
                }
                FileInputStream fileInputStream2 = ocfFileInputStream;
                if (fileInputStream2 == null) {
                    unit = null;
                } else {
                    fileInputStream2.close();
                    unit = Unit.INSTANCE;
                }
                break block47;
            }
            catch (IOException e2) {
                UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"IO Exception for directory ", (Object)directory.getPath()));
                throw e2;
                {
                    catch (Throwable throwable) {
                        Unit unit;
                        Unit unit4;
                        Unit unit5;
                        FileInputStream fileInputStream = opfFileInputStream;
                        if (fileInputStream == null) {
                            unit5 = null;
                        } else {
                            fileInputStream.close();
                            unit5 = Unit.INSTANCE;
                        }
                        FileOutputStream fileOutputStream = opfFileOutputStream;
                        if (fileOutputStream == null) {
                            unit4 = null;
                        } else {
                            fileOutputStream.close();
                            unit4 = Unit.INSTANCE;
                        }
                        FileInputStream fileInputStream3 = ocfFileInputStream;
                        if (fileInputStream3 == null) {
                            unit = null;
                        } else {
                            fileInputStream3.close();
                            unit = Unit.INSTANCE;
                        }
                        throw throwable;
                    }
                }
            }
            ((FileInputStream)closeable).close();
            closeable = opfFileOutputStream;
            ((FileOutputStream)closeable).close();
            closeable = ocfFileInputStream;
            ((FileInputStream)closeable).close();
            return bl;
        }
        return false;
    }

    public final void cleanUpAttributeListWithMultipleSrc(@NotNull Element element, @NotNull Map<File, ? extends File> replacedFiles, @NotNull File htmlFile) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(replacedFiles, (String)"replacedFiles");
        Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
        List attrList = element.attributes().asList();
        boolean foundReplaced = false;
        for (Attribute attribute : attrList) {
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attrList");
            String key = (String)((Map.Entry)attribute).getKey();
            String srcValue = (String)((Map.Entry)attribute).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            if (!StringsKt.contains$default((CharSequence)key, (CharSequence)"src", (boolean)false, (int)2, null)) continue;
            try {
                File srcFile = new File(htmlFile.getParentFile(), srcValue);
                File file = Paths.get(srcFile.getPath(), new String[0]).normalize().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(srcFile.path).normalize().toFile()");
                srcFile = file;
                File newFile = replacedFiles.get(srcFile);
                if (newFile == null) continue;
                foundReplaced = true;
                CharSequence charSequence = ((Object)Paths.get(htmlFile.getParentFile().toURI()).relativize(Paths.get(newFile.toURI()))).toString();
                String string = Pattern.quote("\\");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(\"\\\\\")");
                string = new Regex(string);
                String string2 = "/";
                String newHref = string.replace(charSequence, string2);
                this.deleteAllAttributesWithSrc(element);
                element.attr("src", newHref);
                break;
            }
            catch (InvalidPathException invalidPathException) {
            }
        }
        if (!foundReplaced) {
            Element element2 = element.selectFirst("[src]");
            UMLogUtil.INSTANCE.logInfo(Intrinsics.stringPlus((String)"Did not find the replacement file for ", (Object)(element2 == null ? null : element2.attr("src"))));
        }
    }

    private final void deleteAllAttributesWithSrc(Element element) {
        List attrList = element.attributes().asList();
        ArrayList<String> attrToDelete = new ArrayList<String>();
        for (Attribute attribute : attrList) {
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attrList");
            String key = (String)((Map.Entry)attribute).getKey();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            if (!StringsKt.contains$default((CharSequence)key, (CharSequence)"src", (boolean)false, (int)2, null)) continue;
            attrToDelete.add(key);
        }
        for (String attr : attrToDelete) {
            element.removeAttr(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void convertImageToWebp(@NotNull File src, @NotNull File dest) throws IOException {
        block18: {
            File file;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            if (!ContentScraperUtil.INSTANCE.fileHasContent(src)) {
                throw new FileNotFoundException("convertImageToWebp: Source file: " + src.getAbsolutePath() + " does not exist");
            }
            File webpExecutableFile = new File(cwebpPath);
            if (!webpExecutableFile.exists()) {
                throw new IOException(Intrinsics.stringPlus((String)"Webp executable does not exist: ", (Object)cwebpPath));
            }
            File pngFile = null;
            Process process = null;
            String[] stringArray = new String[]{cwebpPath, src.getPath(), "-o", dest.getPath()};
            ProcessBuilder builder = new ProcessBuilder(stringArray);
            try {
                Process process2 = process = builder.start();
                Intrinsics.checkNotNull((Object)process2);
                process2.waitFor();
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    StringBuilder stringBuilder = new StringBuilder().append("Error Stream for src ").append((Object)src.getPath());
                    Object object = process.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process.errorStream");
                    Object object2 = Charsets.UTF_8;
                    Object object3 = object;
                    object3 = new InputStreamReader((InputStream)object3, (Charset)object2);
                    int n = 8192;
                    object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                    StringBuilder stringBuilder2 = stringBuilder;
                    UMLogUtil uMLogUtil = UMLogUtil.INSTANCE;
                    object2 = null;
                    try {
                        BufferedReader it = (BufferedReader)object;
                        boolean bl = false;
                        object3 = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                    }
                    Object object4 = object3;
                    uMLogUtil.logError(stringBuilder2.append((String)object4).toString());
                    object = src.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"src.path");
                    pngFile = new File(Intrinsics.stringPlus((String)UMFileUtil.INSTANCE.stripExtensionIfPresent((String)object), (Object)".png"));
                    this.convertJpgToPng(src, pngFile);
                    this.convertImageToWebp(pngFile, dest);
                    pngFile.delete();
                }
                file = pngFile;
            }
            catch (IOException e) {
                throw e;
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                    break block18;
                }
            }
            if (file != null) {
                file.delete();
            }
            Process exitValue = process;
            exitValue.destroy();
            break block18;
            finally {
                File file2 = pngFile;
                if (file2 != null) {
                    file2.delete();
                }
                Process process3 = process;
                if (process3 != null) {
                    process3.destroy();
                }
            }
        }
        if (ContentScraperUtil.INSTANCE.fileHasContent(dest)) return;
        throw new IOException(Intrinsics.stringPlus((String)"convertImaegToWebP: source existed, but output does not ", (Object)dest.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void convertJpgToPng(File src, File dest) throws IOException {
        if (!ContentScraperUtil.INSTANCE.fileHasContent(src)) {
            throw new FileNotFoundException("convertImageToWebp: Source file: " + src.getAbsolutePath() + " does not exist");
        }
        File webpExecutableFile = new File(cwebpPath);
        if (!webpExecutableFile.exists()) {
            throw new IOException(Intrinsics.stringPlus((String)"Webp executable does not exist: ", (Object)cwebpPath));
        }
        Process process = null;
        String[] stringArray = new String[]{"/usr/bin/mogrify", "-format", "png", src.getPath(), dest.getPath()};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        try {
            Process process2 = process = builder.start();
            Intrinsics.checkNotNull((Object)process2);
            process2.waitFor();
            int exitValue23333332 = process.exitValue();
            if (exitValue23333332 != 0) {
                StringBuilder stringBuilder = new StringBuilder().append("Error Stream for src ").append((Object)src.getPath());
                InputStream inputStream = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                UMLogUtil.INSTANCE.logError(stringBuilder.append(InputStreamExtKt.readString((InputStream)inputStream)).toString());
                throw new IOException();
            }
            Process exitValue23333332 = process;
            exitValue23333332.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        finally {
            Process process3 = process;
            if (process3 != null) {
                process3.destroy();
            }
        }
        if (ContentScraperUtil.INSTANCE.fileHasContent(dest)) return;
        throw new IOException(Intrinsics.stringPlus((String)"convertJpegToPng: source existed, but output does not ", (Object)dest.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convertVideoToWebM(@NotNull File src, @NotNull File dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!ContentScraperUtil.INSTANCE.fileHasContent(src)) {
            throw new FileNotFoundException("convertVideoToWebm: Source file: " + src.getAbsolutePath() + " does not exist");
        }
        File webpExecutableFile = new File(ffmpegPath);
        if (!webpExecutableFile.exists()) {
            throw new IOException(Intrinsics.stringPlus((String)"ffmpeg executable does not exist: ", (Object)ffmpegPath));
        }
        String[] stringArray = new String[]{ffmpegPath, "-i", src.getPath(), "-vf", "scale=480x270", "-r", "20", "-c:v", "vp9", "-crf", "40", "-b:v", "0", "-c:a", "libopus", "-b:a", "12000", "-vbr", "on", dest.getPath()};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        builder.redirectErrorStream(true);
        Process process = null;
        try {
            Process process2 = process = builder.start();
            if (process2 != null) {
                InputStream inputStream = process2.getInputStream();
                if (inputStream != null) {
                    ByteStreamsKt.readBytes((InputStream)inputStream);
                }
            }
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                StringBuilder stringBuilder = new StringBuilder().append("Error Stream for src ").append((Object)src.getPath());
                InputStream inputStream = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                UMLogUtil.INSTANCE.logError(stringBuilder.append(InputStreamExtKt.readString((InputStream)inputStream)).toString());
                throw new IOException();
            }
            process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            Process process3 = process;
            if (process3 != null) {
                process3.destroy();
            }
        }
        if (!ContentScraperUtil.INSTANCE.fileHasContent(dest)) {
            throw new IOException(Intrinsics.stringPlus((String)"convertVideoToWebm: source existed, but output does not ", (Object)dest.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convertAudioToOpos(@NotNull File src, @NotNull File dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!ContentScraperUtil.INSTANCE.fileHasContent(src)) {
            throw new FileNotFoundException("convertAudioToOpos: Source file: " + src.getAbsolutePath() + " does not exist");
        }
        File webpExecutableFile = new File(ffmpegPath);
        if (!webpExecutableFile.exists()) {
            throw new IOException(Intrinsics.stringPlus((String)"ffmpeg executable does not exist: ", (Object)ffmpegPath));
        }
        String[] stringArray = new String[]{ffmpegPath, "-i", src.getPath(), "-c:a", "libopus", "-b:a", "12000", "-vbr", "on", dest.getPath()};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        builder.redirectErrorStream(true);
        Process process = null;
        try {
            Process process2 = process = builder.start();
            if (process2 != null) {
                InputStream inputStream = process2.getInputStream();
                if (inputStream != null) {
                    ByteStreamsKt.readBytes((InputStream)inputStream);
                }
            }
            Process process3 = process;
            if (process3 != null) {
                process3.waitFor();
            }
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                StringBuilder stringBuilder = new StringBuilder().append("Error Stream for src ").append((Object)src.getPath());
                InputStream inputStream = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                UMLogUtil.INSTANCE.logError(stringBuilder.append(InputStreamExtKt.readString((InputStream)inputStream)).toString());
            }
            process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            Process process4 = process;
            if (process4 != null) {
                process4.destroy();
            }
        }
        if (!ContentScraperUtil.INSTANCE.fileHasContent(dest)) {
            throw new IOException(Intrinsics.stringPlus((String)"convertAudioToOpos: source existed, but output does not ", (Object)dest.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void convertKhanVideoToWebMAndCodec2(@NotNull File src, @NotNull File dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!ContentScraperUtil.INSTANCE.fileHasContent(src)) {
            throw new FileNotFoundException("convertKhanToWebmAndCodec2: Source file: " + src.getAbsolutePath() + " does not exist");
        }
        File webpExecutableFile = new File(ffmpegPath);
        if (!webpExecutableFile.exists()) {
            throw new IOException(Intrinsics.stringPlus((String)"ffmpeg executable does not exist: ", (Object)ffmpegPath));
        }
        String[] stringArray = new String[]{ffmpegPath, "-i", src.getPath(), "-vf", "scale=480x270", "-r", "5", "-c:v", "vp9", "-b:v", "0", "-crf", "40", "-an", "-y", dest.getPath()};
        ProcessBuilder videoBuilder = new ProcessBuilder(stringArray);
        videoBuilder.redirectErrorStream(true);
        File rawFile = new File(dest.getParentFile(), "audio.raw");
        String[] stringArray2 = new String[]{ffmpegPath, "-i", src.getPath(), "-vn", "-c:a", "pcm_s16le", "-ar", "8000", "-ac", "1", "-f", "s16le", "-y", rawFile.getPath()};
        ProcessBuilder rawBuilder = new ProcessBuilder(stringArray2);
        rawBuilder.redirectErrorStream(true);
        File audioFile = new File(dest.getParentFile(), "audio.c2");
        String[] stringArray3 = new String[]{System.getProperty("codec2"), "3200", rawFile.getPath(), audioFile.getPath()};
        ProcessBuilder audioBuilder = new ProcessBuilder(stringArray3);
        audioBuilder.redirectErrorStream(true);
        Process process = null;
        try {
            Process process2 = process = videoBuilder.start();
            Intrinsics.checkNotNull((Object)process2);
            this.startProcess(process2);
            UMLogUtil.INSTANCE.logTrace("got the webm file");
            Process process3 = process = rawBuilder.start();
            Intrinsics.checkNotNull((Object)process3);
            this.startProcess(process3);
            UMLogUtil.INSTANCE.logTrace("got the raw file");
            Process process4 = process = audioBuilder.start();
            Intrinsics.checkNotNull((Object)process4);
            this.startProcess(process4);
            UMLogUtil.INSTANCE.logTrace("got the c2 file");
            Process process5 = process;
            process5.destroy();
            ContentScraperUtil.INSTANCE.deleteFile(rawFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        finally {
            Process process6 = process;
            if (process6 != null) {
                process6.destroy();
            }
            ContentScraperUtil.INSTANCE.deleteFile(rawFile);
        }
        if (!ContentScraperUtil.INSTANCE.fileHasContent(dest)) {
            throw new IOException(Intrinsics.stringPlus((String)"convertVideoToWebMAndCodec: source existed, but webm output does not ", (Object)dest.getPath()));
        }
        if (ContentScraperUtil.INSTANCE.fileHasContent(audioFile)) return;
        throw new IOException(Intrinsics.stringPlus((String)"convertVideoToWebMAndCodec: source existed, but audio output does not ", (Object)dest.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startProcess(Process process) throws IOException, InterruptedException {
        try {
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            ByteStreamsKt.readBytes((InputStream)inputStream);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                InputStream inputStream2 = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
                UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Error Stream for src ", (Object)InputStreamExtKt.readString((InputStream)inputStream2)));
            }
        }
        finally {
            process.destroy();
        }
    }

    static {
        Object[] objectArray = new String[]{"application/xhtml+xml", "text/html"};
        HTML_MIME_TYPES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"image/jpg", "image/png", "image/jpeg"};
        IMAGE_MIME_TYPES = CollectionsKt.listOf((Object[])objectArray);
        cwebpPath = System.getProperty("webp");
        ffmpegPath = System.getProperty("webm");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ShrinkerUtil$EpubShrinkerOptions;", "", "()V", "editor", "Lkotlin/Function1;", "Lorg/jsoup/nodes/Document;", "getEditor", "()Lkotlin/jvm/functions/Function1;", "setEditor", "(Lkotlin/jvm/functions/Function1;)V", "linkHelper", "Lkotlin/Function0;", "", "getLinkHelper", "()Lkotlin/jvm/functions/Function0;", "setLinkHelper", "(Lkotlin/jvm/functions/Function0;)V", "styleElementHelper", "Lorg/jsoup/nodes/Element;", "", "getStyleElementHelper", "setStyleElementHelper", "lib-content-scrapers"})
    public static final class EpubShrinkerOptions {
        @Nullable
        private Function1<? super Element, Integer> styleElementHelper;
        @Nullable
        private Function0<String> linkHelper;
        @Nullable
        private Function1<? super Document, ? extends Document> editor;

        @Nullable
        public final Function1<Element, Integer> getStyleElementHelper() {
            return this.styleElementHelper;
        }

        public final void setStyleElementHelper(@Nullable Function1<? super Element, Integer> function1) {
            this.styleElementHelper = function1;
        }

        @Nullable
        public final Function0<String> getLinkHelper() {
            return this.linkHelper;
        }

        public final void setLinkHelper(@Nullable Function0<String> function0) {
            this.linkHelper = function0;
        }

        @Nullable
        public final Function1<Document, Document> getEditor() {
            return this.editor;
        }

        public final void setEditor(@Nullable Function1<? super Document, ? extends Document> function1) {
            this.editor = function1;
        }
    }
}

