/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.db.entities;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import com.ustadmobile.door.annotation.LastChangedBy;
import com.ustadmobile.door.annotation.LastChangedTime;
import com.ustadmobile.door.annotation.LocalChangeSeqNum;
import com.ustadmobile.door.annotation.MasterChangeSeqNum;
import com.ustadmobile.door.annotation.ReplicateEntity;
import com.ustadmobile.door.annotation.ReplicationVersionId;
import com.ustadmobile.door.annotation.Trigger;
import com.ustadmobile.door.annotation.Triggers;
import com.ustadmobile.lib.db.entities.Container$;
import com.ustadmobile.lib.db.entities.ContainerReplicate;
import com.ustadmobile.lib.db.entities.ContentEntry;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Triggers(value={@Trigger(name="container_remote_insert", order=Trigger.Order.INSTEAD_OF, events={Trigger.Event.INSERT}, on=Trigger.On.RECEIVEVIEW, sqlStatements={"REPLACE INTO Container(containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, cntLct, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries)\n         SELECT NEW.containerUid, NEW.cntLocalCsn, NEW.cntMasterCsn, NEW.cntLastModBy, NEW.cntLct, NEW.fileSize, NEW.containerContentEntryUid, NEW.cntLastModified, NEW.mimeType, NEW.remarks, NEW.mobileOptimized, NEW.cntNumEntries \n          WHERE NEW.cntLct > \n                (SELECT COALESCE(\n                        (SELECT ContainerInt.cntLct\n                           FROM Container ContainerInt\n                          WHERE ContainerInt.containerUid = NEW.containerUid), 0))\n         /*psql ON CONFLICT (containerUid) DO UPDATE \n         SET cntLocalCsn = EXCLUDED.cntLocalCsn, cntMasterCsn = EXCLUDED.cntMasterCsn, cntLastModBy = EXCLUDED.cntLastModBy, cntLct = EXCLUDED.cntLct, fileSize = EXCLUDED.fileSize, containerContentEntryUid = EXCLUDED.containerContentEntryUid, cntLastModified = EXCLUDED.cntLastModified, mimeType = EXCLUDED.mimeType, remarks = EXCLUDED.remarks, mobileOptimized = EXCLUDED.mobileOptimized, cntNumEntries = EXCLUDED.cntNumEntries\n         */"})})
@Serializable
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 E2\u00020\u0001:\u0002DEB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B}\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0006\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018B\u0005\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010<\u001a\u00020\u0006H\u0016J!\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u00c7\u0001R\u001e\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u000f\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\f\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001e\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!R\u001e\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001f\"\u0004\b+\u0010!R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001f\"\u0004\b/\u0010!R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00101\"\u0004\b9\u00103\u00a8\u0006F\u0080\u00e5\b\u0007\u0080\u00e5\b\t\u0080\u00e5\b\n\u0080\u00e5\b\u000b\u0080\u00e5\b\f\u0080\u00e5\b\r\u0080\u00e5\b\u000e\u0080\u00e5\b\u000f\u0080\u00e5\b\u0010\u0080\u00e5\b\u0012\u0080\u00e5\b\u0013\u0080\u00e5\b\u0015"}, d2={"Lcom/ustadmobile/lib/db/entities/Container;", "", "contentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "(Lcom/ustadmobile/lib/db/entities/ContentEntry;)V", "seen1", "", "containerUid", "", "cntLocalCsn", "cntMasterCsn", "cntLastModBy", "cntLct", "fileSize", "containerContentEntryUid", "cntLastModified", "mimeType", "", "remarks", "mobileOptimized", "", "cntNumEntries", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IJJJIJJJJLjava/lang/String;Ljava/lang/String;ZILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()V", "getCntLastModBy", "()I", "setCntLastModBy", "(I)V", "getCntLastModified", "()J", "setCntLastModified", "(J)V", "getCntLct", "setCntLct", "getCntLocalCsn", "setCntLocalCsn", "getCntMasterCsn", "setCntMasterCsn", "getCntNumEntries", "setCntNumEntries", "getContainerContentEntryUid", "setContainerContentEntryUid", "getContainerUid", "setContainerUid", "getFileSize", "setFileSize", "getMimeType", "()Ljava/lang/String;", "setMimeType", "(Ljava/lang/String;)V", "getMobileOptimized", "()Z", "setMobileOptimized", "(Z)V", "getRemarks", "setRemarks", "equals", "other", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "lib-database-entities_release"})
@Entity(indices={@Index(value={"containerContentEntryUid", "cntLastModified"}, name="cnt_uid_to_most_recent")})
@ReplicateEntity(tableId=51, tracker=ContainerReplicate.class)
public class Container {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @PrimaryKey(autoGenerate=true)
    private long containerUid;
    @LocalChangeSeqNum
    private long cntLocalCsn;
    @MasterChangeSeqNum
    private long cntMasterCsn;
    @LastChangedBy
    private int cntLastModBy;
    @LastChangedTime
    @ReplicationVersionId
    private long cntLct;
    private long fileSize;
    private long containerContentEntryUid;
    @ColumnInfo(index=true)
    private long cntLastModified;
    @Nullable
    private String mimeType;
    @Nullable
    private String remarks;
    private boolean mobileOptimized;
    private int cntNumEntries;
    public static final int TABLE_ID = 51;

    public Container() {
    }

    public final long getContainerUid() {
        return this.containerUid;
    }

    public final void setContainerUid(long l) {
        this.containerUid = l;
    }

    public final long getCntLocalCsn() {
        return this.cntLocalCsn;
    }

    public final void setCntLocalCsn(long l) {
        this.cntLocalCsn = l;
    }

    public final long getCntMasterCsn() {
        return this.cntMasterCsn;
    }

    public final void setCntMasterCsn(long l) {
        this.cntMasterCsn = l;
    }

    public final int getCntLastModBy() {
        return this.cntLastModBy;
    }

    public final void setCntLastModBy(int n) {
        this.cntLastModBy = n;
    }

    public final long getCntLct() {
        return this.cntLct;
    }

    public final void setCntLct(long l) {
        this.cntLct = l;
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    public final void setFileSize(long l) {
        this.fileSize = l;
    }

    public final long getContainerContentEntryUid() {
        return this.containerContentEntryUid;
    }

    public final void setContainerContentEntryUid(long l) {
        this.containerContentEntryUid = l;
    }

    public final long getCntLastModified() {
        return this.cntLastModified;
    }

    public final void setCntLastModified(long l) {
        this.cntLastModified = l;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    public final void setMimeType(@Nullable String string) {
        this.mimeType = string;
    }

    @Nullable
    public final String getRemarks() {
        return this.remarks;
    }

    public final void setRemarks(@Nullable String string) {
        this.remarks = string;
    }

    public final boolean getMobileOptimized() {
        return this.mobileOptimized;
    }

    public final void setMobileOptimized(boolean bl) {
        this.mobileOptimized = bl;
    }

    public final int getCntNumEntries() {
        return this.cntNumEntries;
    }

    public final void setCntNumEntries(int n) {
        this.cntNumEntries = n;
    }

    public Container(@NotNull ContentEntry contentEntry) {
        Intrinsics.checkNotNullParameter((Object)contentEntry, (String)"contentEntry");
        this();
        this.containerContentEntryUid = contentEntry.getContentEntryUid();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Container)) {
            return false;
        }
        if (this.containerUid != ((Container)other).containerUid) {
            return false;
        }
        if (this.cntLocalCsn != ((Container)other).cntLocalCsn) {
            return false;
        }
        if (this.cntMasterCsn != ((Container)other).cntMasterCsn) {
            return false;
        }
        if (this.cntLastModBy != ((Container)other).cntLastModBy) {
            return false;
        }
        if (this.fileSize != ((Container)other).fileSize) {
            return false;
        }
        if (this.containerContentEntryUid != ((Container)other).containerContentEntryUid) {
            return false;
        }
        if (this.cntLastModified != ((Container)other).cntLastModified) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mimeType, (Object)((Container)other).mimeType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.remarks, (Object)((Container)other).remarks)) {
            return false;
        }
        if (this.mobileOptimized != ((Container)other).mobileOptimized) {
            return false;
        }
        return this.cntNumEntries == ((Container)other).cntNumEntries;
    }

    public int hashCode() {
        int n;
        int result = Long.hashCode(this.containerUid);
        result = 31 * result + Long.hashCode(this.cntLocalCsn);
        result = 31 * result + Long.hashCode(this.cntMasterCsn);
        result = 31 * result + this.cntLastModBy;
        result = 31 * result + Long.hashCode(this.fileSize);
        result = 31 * result + Long.hashCode(this.containerContentEntryUid);
        result = 31 * result + Long.hashCode(this.cntLastModified);
        String string = this.mimeType;
        result = 31 * result + (string == null ? 0 : (n = string.hashCode()));
        String string2 = this.remarks;
        result = 31 * result + (string2 == null ? 0 : (n = string2.hashCode()));
        result = 31 * result + Boolean.hashCode(this.mobileOptimized);
        result = 31 * result + this.cntNumEntries;
        return result;
    }

    @JvmStatic
    public static final void write$Self(@NotNull Container self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.containerUid != 0L) {
            output.encodeLongElement(serialDesc, 0, self.containerUid);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.cntLocalCsn != 0L) {
            output.encodeLongElement(serialDesc, 1, self.cntLocalCsn);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.cntMasterCsn != 0L) {
            output.encodeLongElement(serialDesc, 2, self.cntMasterCsn);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.cntLastModBy != 0) {
            output.encodeIntElement(serialDesc, 3, self.cntLastModBy);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.cntLct != 0L) {
            output.encodeLongElement(serialDesc, 4, self.cntLct);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.fileSize != 0L) {
            output.encodeLongElement(serialDesc, 5, self.fileSize);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.containerContentEntryUid != 0L) {
            output.encodeLongElement(serialDesc, 6, self.containerContentEntryUid);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.cntLastModified != 0L) {
            output.encodeLongElement(serialDesc, 7, self.cntLastModified);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.mimeType != null) {
            output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.mimeType);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : self.remarks != null) {
            output.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.remarks);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 10) ? true : self.mobileOptimized) {
            output.encodeBooleanElement(serialDesc, 10, self.mobileOptimized);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 11) ? true : self.cntNumEntries != 0) {
            output.encodeIntElement(serialDesc, 11, self.cntNumEntries);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ Container(int seen1, long containerUid, long cntLocalCsn, long cntMasterCsn, int cntLastModBy, long cntLct, long fileSize, long containerContentEntryUid, long cntLastModified, String mimeType, String remarks, boolean mobileOptimized, int cntNumEntries, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen1) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.containerUid = (seen1 & 1) == 0 ? 0L : containerUid;
        this.cntLocalCsn = (seen1 & 2) == 0 ? 0L : cntLocalCsn;
        this.cntMasterCsn = (seen1 & 4) == 0 ? 0L : cntMasterCsn;
        this.cntLastModBy = (seen1 & 8) == 0 ? 0 : cntLastModBy;
        this.cntLct = (seen1 & 0x10) == 0 ? 0L : cntLct;
        this.fileSize = (seen1 & 0x20) == 0 ? 0L : fileSize;
        this.containerContentEntryUid = (seen1 & 0x40) == 0 ? 0L : containerContentEntryUid;
        this.cntLastModified = (seen1 & 0x80) == 0 ? 0L : cntLastModified;
        this.mimeType = (seen1 & 0x100) == 0 ? null : mimeType;
        this.remarks = (seen1 & 0x200) == 0 ? null : remarks;
        this.mobileOptimized = (seen1 & 0x400) == 0 ? false : mobileOptimized;
        this.cntNumEntries = (seen1 & 0x800) == 0 ? 0 : cntNumEntries;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/lib/db/entities/Container$Companion;", "", "()V", "TABLE_ID", "", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ustadmobile/lib/db/entities/Container;", "lib-database-entities_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Container> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

