// @Triggers(arrayOf(
//     Trigger(
//         name = "chat_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO Chat(chatUid, chatStartDate, chatTitle, chatGroup, chatLct) 
//             VALUES (NEW.chatUid, NEW.chatStartDate, NEW.chatTitle, NEW.chatGroup, NEW.chatLct) 
//             /*psql ON CONFLICT (chatUid) DO UPDATE 
//             SET chatStartDate = EXCLUDED.chatStartDate, chatTitle = EXCLUDED.chatTitle, chatGroup = EXCLUDED.chatGroup, chatLct = EXCLUDED.chatLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO ChatReplicate(chatPk, chatDestination)
//      SELECT Chat.chatUid AS chatPk,
//             :newNodeId AS chatDestination
//        FROM Chat
//       --notpsql 
//       WHERE Chat.chatLct != COALESCE(
//             (SELECT chatVersionId
//                FROM ChatReplicate
//               WHERE chatPk = Chat.chatUid
//                 AND chatDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(chatPk, chatDestination) DO UPDATE
//             SET chatPending = (SELECT Chat.chatLct
//            FROM Chat
//           WHERE Chat.chatUid = EXCLUDED.chatPk ) 
//                 != ChatReplicate.chatVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([Chat::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO ChatReplicate(chatPk, chatDestination)
//  SELECT Chat.chatUid AS chatUid,
//         UserSession.usClientNodeId AS chatDestination
//    FROM ChangeLog
//         JOIN Chat
//             ON ChangeLog.chTableId = ${Chat.TABLE_ID}
//                AND ChangeLog.chEntityPk = Chat.chatUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND Chat.chatLct != COALESCE(
//         (SELECT chatVersionId
//            FROM ChatReplicate
//           WHERE chatPk = Chat.chatUid
//             AND chatDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(chatPk, chatDestination) DO UPDATE
//     SET chatPending = (SELECT Chat.chatLct
//        FROM Chat
//       WHERE ChatchatUid = EXCLUDED.chatPk ) 
//             != Chat.chatVersionId
//  */               
// """)
// @ReplicationRunOnChange([Chat::class])
// @ReplicationCheckPendingNotificationsFor([Chat::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("chatPk", "chatDestination"),
  indices = arrayOf(Index(value = arrayOf("chatPk", "chatDestination", "chatVersionId")),
  Index(value = arrayOf("chatDestination", "chatPending")))

)
@Serializable
public class ChatReplicate {
  @ReplicationEntityForeignKey
  public var chatPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var chatVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var chatDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var chatPending: Boolean = true
}
