// @Triggers(arrayOf(
//     Trigger(
//         name = "contententrypicture_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO ContentEntryPicture(cepUid, cepContentEntryUid, cepUri, cepMd5, cepFileSize, cepTimestamp, cepMimeType, cepActive) 
//             VALUES (NEW.cepUid, NEW.cepContentEntryUid, NEW.cepUri, NEW.cepMd5, NEW.cepFileSize, NEW.cepTimestamp, NEW.cepMimeType, NEW.cepActive) 
//             /*psql ON CONFLICT (cepUid) DO UPDATE 
//             SET cepContentEntryUid = EXCLUDED.cepContentEntryUid, cepUri = EXCLUDED.cepUri, cepMd5 = EXCLUDED.cepMd5, cepFileSize = EXCLUDED.cepFileSize, cepTimestamp = EXCLUDED.cepTimestamp, cepMimeType = EXCLUDED.cepMimeType, cepActive = EXCLUDED.cepActive
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO ContentEntryPictureReplicate(cepPk, cepDestination)
//      SELECT ContentEntryPicture.cepUid AS cepPk,
//             :newNodeId AS cepDestination
//        FROM ContentEntryPicture
//       --notpsql 
//       WHERE ContentEntryPicture.cepTimestamp != COALESCE(
//             (SELECT cepVersionId
//                FROM ContentEntryPictureReplicate
//               WHERE cepPk = ContentEntryPicture.cepUid
//                 AND cepDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cepPk, cepDestination) DO UPDATE
//             SET cepPending = (SELECT ContentEntryPicture.cepTimestamp
//            FROM ContentEntryPicture
//           WHERE ContentEntryPicture.cepUid = EXCLUDED.cepPk ) 
//                 != ContentEntryPictureReplicate.cepVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([ContentEntryPicture::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO ContentEntryPictureReplicate(cepPk, cepDestination)
//  SELECT ContentEntryPicture.cepUid AS cepUid,
//         UserSession.usClientNodeId AS cepDestination
//    FROM ChangeLog
//         JOIN ContentEntryPicture
//             ON ChangeLog.chTableId = ${ContentEntryPicture.TABLE_ID}
//                AND ChangeLog.chEntityPk = ContentEntryPicture.cepUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND ContentEntryPicture.cepTimestamp != COALESCE(
//         (SELECT cepVersionId
//            FROM ContentEntryPictureReplicate
//           WHERE cepPk = ContentEntryPicture.cepUid
//             AND cepDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cepPk, cepDestination) DO UPDATE
//     SET cepPending = (SELECT ContentEntryPicture.cepTimestamp
//        FROM ContentEntryPicture
//       WHERE ContentEntryPicturecepUid = EXCLUDED.cepPk ) 
//             != ContentEntryPicture.cepVersionId
//  */               
// """)
// @ReplicationRunOnChange([ContentEntryPicture::class])
// @ReplicationCheckPendingNotificationsFor([ContentEntryPicture::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cepPk", "cepDestination"),
  indices = arrayOf(Index(value = arrayOf("cepPk", "cepDestination", "cepVersionId")),
  Index(value = arrayOf("cepDestination", "cepPending")))

)
@Serializable
public class ContentEntryPictureReplicate {
  @ReplicationEntityForeignKey
  public var cepPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cepVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cepDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cepPending: Boolean = true
}
