// @Triggers(arrayOf(
//     Trigger(
//         name = "courseblock_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseBlock(cbUid, cbType, cbIndentLevel, cbModuleParentBlockUid, cbTitle, cbDescription, cbCompletionCriteria, cbHideUntilDate, cbDeadlineDate, cbLateSubmissionPenalty, cbGracePeriodDate, cbMaxPoints, cbMinPoints, cbIndex, cbClazzUid, cbActive, cbHidden, cbEntityUid, cbLct) 
//             VALUES (NEW.cbUid, NEW.cbType, NEW.cbIndentLevel, NEW.cbModuleParentBlockUid, NEW.cbTitle, NEW.cbDescription, NEW.cbCompletionCriteria, NEW.cbHideUntilDate, NEW.cbDeadlineDate, NEW.cbLateSubmissionPenalty, NEW.cbGracePeriodDate, NEW.cbMaxPoints, NEW.cbMinPoints, NEW.cbIndex, NEW.cbClazzUid, NEW.cbActive, NEW.cbHidden, NEW.cbEntityUid, NEW.cbLct) 
//             /*psql ON CONFLICT (cbUid) DO UPDATE 
//             SET cbType = EXCLUDED.cbType, cbIndentLevel = EXCLUDED.cbIndentLevel, cbModuleParentBlockUid = EXCLUDED.cbModuleParentBlockUid, cbTitle = EXCLUDED.cbTitle, cbDescription = EXCLUDED.cbDescription, cbCompletionCriteria = EXCLUDED.cbCompletionCriteria, cbHideUntilDate = EXCLUDED.cbHideUntilDate, cbDeadlineDate = EXCLUDED.cbDeadlineDate, cbLateSubmissionPenalty = EXCLUDED.cbLateSubmissionPenalty, cbGracePeriodDate = EXCLUDED.cbGracePeriodDate, cbMaxPoints = EXCLUDED.cbMaxPoints, cbMinPoints = EXCLUDED.cbMinPoints, cbIndex = EXCLUDED.cbIndex, cbClazzUid = EXCLUDED.cbClazzUid, cbActive = EXCLUDED.cbActive, cbHidden = EXCLUDED.cbHidden, cbEntityUid = EXCLUDED.cbEntityUid, cbLct = EXCLUDED.cbLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseBlockReplicate(cbPk, cbDestination)
//      SELECT CourseBlock.cbUid AS cbPk,
//             :newNodeId AS cbDestination
//        FROM CourseBlock
//       --notpsql 
//       WHERE CourseBlock.cbLct != COALESCE(
//             (SELECT cbVersionId
//                FROM CourseBlockReplicate
//               WHERE cbPk = CourseBlock.cbUid
//                 AND cbDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cbPk, cbDestination) DO UPDATE
//             SET cbPending = (SELECT CourseBlock.cbLct
//            FROM CourseBlock
//           WHERE CourseBlock.cbUid = EXCLUDED.cbPk ) 
//                 != CourseBlockReplicate.cbVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseBlock::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseBlockReplicate(cbPk, cbDestination)
//  SELECT CourseBlock.cbUid AS cbUid,
//         UserSession.usClientNodeId AS cbDestination
//    FROM ChangeLog
//         JOIN CourseBlock
//             ON ChangeLog.chTableId = ${CourseBlock.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseBlock.cbUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseBlock.cbLct != COALESCE(
//         (SELECT cbVersionId
//            FROM CourseBlockReplicate
//           WHERE cbPk = CourseBlock.cbUid
//             AND cbDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cbPk, cbDestination) DO UPDATE
//     SET cbPending = (SELECT CourseBlock.cbLct
//        FROM CourseBlock
//       WHERE CourseBlockcbUid = EXCLUDED.cbPk ) 
//             != CourseBlock.cbVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseBlock::class])
// @ReplicationCheckPendingNotificationsFor([CourseBlock::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cbPk", "cbDestination"),
  indices = arrayOf(Index(value = arrayOf("cbPk", "cbDestination", "cbVersionId")),
  Index(value = arrayOf("cbDestination", "cbPending")))

)
@Serializable
public class CourseBlockReplicate {
  @ReplicationEntityForeignKey
  public var cbPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cbVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cbDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cbPending: Boolean = true
}
