// @Triggers(arrayOf(
//     Trigger(
//         name = "coursegroupset_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseGroupSet(cgsUid, cgsName, cgsTotalGroups, cgsActive, cgsClazzUid, cgsLct) 
//             VALUES (NEW.cgsUid, NEW.cgsName, NEW.cgsTotalGroups, NEW.cgsActive, NEW.cgsClazzUid, NEW.cgsLct) 
//             /*psql ON CONFLICT (cgsUid) DO UPDATE 
//             SET cgsName = EXCLUDED.cgsName, cgsTotalGroups = EXCLUDED.cgsTotalGroups, cgsActive = EXCLUDED.cgsActive, cgsClazzUid = EXCLUDED.cgsClazzUid, cgsLct = EXCLUDED.cgsLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseGroupSetReplicate(cgsPk, cgsDestination)
//      SELECT CourseGroupSet.cgsUid AS cgsPk,
//             :newNodeId AS cgsDestination
//        FROM CourseGroupSet
//       --notpsql 
//       WHERE CourseGroupSet.cgsLct != COALESCE(
//             (SELECT cgsVersionId
//                FROM CourseGroupSetReplicate
//               WHERE cgsPk = CourseGroupSet.cgsUid
//                 AND cgsDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cgsPk, cgsDestination) DO UPDATE
//             SET cgsPending = (SELECT CourseGroupSet.cgsLct
//            FROM CourseGroupSet
//           WHERE CourseGroupSet.cgsUid = EXCLUDED.cgsPk ) 
//                 != CourseGroupSetReplicate.cgsVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseGroupSet::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseGroupSetReplicate(cgsPk, cgsDestination)
//  SELECT CourseGroupSet.cgsUid AS cgsUid,
//         UserSession.usClientNodeId AS cgsDestination
//    FROM ChangeLog
//         JOIN CourseGroupSet
//             ON ChangeLog.chTableId = ${CourseGroupSet.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseGroupSet.cgsUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseGroupSet.cgsLct != COALESCE(
//         (SELECT cgsVersionId
//            FROM CourseGroupSetReplicate
//           WHERE cgsPk = CourseGroupSet.cgsUid
//             AND cgsDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cgsPk, cgsDestination) DO UPDATE
//     SET cgsPending = (SELECT CourseGroupSet.cgsLct
//        FROM CourseGroupSet
//       WHERE CourseGroupSetcgsUid = EXCLUDED.cgsPk ) 
//             != CourseGroupSet.cgsVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseGroupSet::class])
// @ReplicationCheckPendingNotificationsFor([CourseGroupSet::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cgsPk", "cgsDestination"),
  indices = arrayOf(Index(value = arrayOf("cgsPk", "cgsDestination", "cgsVersionId")),
  Index(value = arrayOf("cgsDestination", "cgsPending")))

)
@Serializable
public class CourseGroupSetReplicate {
  @ReplicationEntityForeignKey
  public var cgsPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cgsVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cgsDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cgsPending: Boolean = true
}
