// @Triggers(arrayOf(
//     Trigger(
//         name = "courseterminology_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseTerminology(ctUid, ctTitle, ctTerminology, ctLct) 
//             VALUES (NEW.ctUid, NEW.ctTitle, NEW.ctTerminology, NEW.ctLct) 
//             /*psql ON CONFLICT (ctUid) DO UPDATE 
//             SET ctTitle = EXCLUDED.ctTitle, ctTerminology = EXCLUDED.ctTerminology, ctLct = EXCLUDED.ctLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseTerminologyReplicate(ctPk, ctDestination)
//      SELECT CourseTerminology.ctUid AS ctPk,
//             :newNodeId AS ctDestination
//        FROM CourseTerminology
//       --notpsql 
//       WHERE CourseTerminology.ctLct != COALESCE(
//             (SELECT ctVersionId
//                FROM CourseTerminologyReplicate
//               WHERE ctPk = CourseTerminology.ctUid
//                 AND ctDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(ctPk, ctDestination) DO UPDATE
//             SET ctPending = (SELECT CourseTerminology.ctLct
//            FROM CourseTerminology
//           WHERE CourseTerminology.ctUid = EXCLUDED.ctPk ) 
//                 != CourseTerminologyReplicate.ctVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseTerminology::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseTerminologyReplicate(ctPk, ctDestination)
//  SELECT CourseTerminology.ctUid AS ctUid,
//         UserSession.usClientNodeId AS ctDestination
//    FROM ChangeLog
//         JOIN CourseTerminology
//             ON ChangeLog.chTableId = ${CourseTerminology.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseTerminology.ctUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseTerminology.ctLct != COALESCE(
//         (SELECT ctVersionId
//            FROM CourseTerminologyReplicate
//           WHERE ctPk = CourseTerminology.ctUid
//             AND ctDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(ctPk, ctDestination) DO UPDATE
//     SET ctPending = (SELECT CourseTerminology.ctLct
//        FROM CourseTerminology
//       WHERE CourseTerminologyctUid = EXCLUDED.ctPk ) 
//             != CourseTerminology.ctVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseTerminology::class])
// @ReplicationCheckPendingNotificationsFor([CourseTerminology::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("ctPk", "ctDestination"),
  indices = arrayOf(Index(value = arrayOf("ctPk", "ctDestination", "ctVersionId")),
  Index(value = arrayOf("ctDestination", "ctPending")))

)
@Serializable
public class CourseTerminologyReplicate {
  @ReplicationEntityForeignKey
  public var ctPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var ctVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var ctDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var ctPending: Boolean = true
}
