// @Triggers(arrayOf(
//     Trigger(
//         name = "discussionpost_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO DiscussionPost(discussionPostUid, discussionPostTitle, discussionPostMessage, discussionPostStartDate, discussionPostDiscussionTopicUid, discussionPostVisible, discussionPostArchive, discussionPostStartedPersonUid, discussionPostClazzUid, discussionPostLct) 
//             VALUES (NEW.discussionPostUid, NEW.discussionPostTitle, NEW.discussionPostMessage, NEW.discussionPostStartDate, NEW.discussionPostDiscussionTopicUid, NEW.discussionPostVisible, NEW.discussionPostArchive, NEW.discussionPostStartedPersonUid, NEW.discussionPostClazzUid, NEW.discussionPostLct) 
//             /*psql ON CONFLICT (discussionPostUid) DO UPDATE 
//             SET discussionPostTitle = EXCLUDED.discussionPostTitle, discussionPostMessage = EXCLUDED.discussionPostMessage, discussionPostStartDate = EXCLUDED.discussionPostStartDate, discussionPostDiscussionTopicUid = EXCLUDED.discussionPostDiscussionTopicUid, discussionPostVisible = EXCLUDED.discussionPostVisible, discussionPostArchive = EXCLUDED.discussionPostArchive, discussionPostStartedPersonUid = EXCLUDED.discussionPostStartedPersonUid, discussionPostClazzUid = EXCLUDED.discussionPostClazzUid, discussionPostLct = EXCLUDED.discussionPostLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO DiscussionPostReplicate(dpPk, dpDestination)
//      SELECT DiscussionPost.discussionPostUid AS dpPk,
//             :newNodeId AS dpDestination
//        FROM DiscussionPost
//       --notpsql 
//       WHERE DiscussionPost.discussionPostLct != COALESCE(
//             (SELECT dpVersionId
//                FROM DiscussionPostReplicate
//               WHERE dpPk = DiscussionPost.discussionPostUid
//                 AND dpDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(dpPk, dpDestination) DO UPDATE
//             SET dpPending = (SELECT DiscussionPost.discussionPostLct
//            FROM DiscussionPost
//           WHERE DiscussionPost.discussionPostUid = EXCLUDED.dpPk ) 
//                 != DiscussionPostReplicate.dpVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([DiscussionPost::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO DiscussionPostReplicate(dpPk, dpDestination)
//  SELECT DiscussionPost.discussionPostUid AS dpUid,
//         UserSession.usClientNodeId AS dpDestination
//    FROM ChangeLog
//         JOIN DiscussionPost
//             ON ChangeLog.chTableId = ${DiscussionPost.TABLE_ID}
//                AND ChangeLog.chEntityPk = DiscussionPost.discussionPostUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND DiscussionPost.discussionPostLct != COALESCE(
//         (SELECT dpVersionId
//            FROM DiscussionPostReplicate
//           WHERE dpPk = DiscussionPost.discussionPostUid
//             AND dpDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(dpPk, dpDestination) DO UPDATE
//     SET dpPending = (SELECT DiscussionPost.discussionPostLct
//        FROM DiscussionPost
//       WHERE DiscussionPostdiscussionPostUid = EXCLUDED.dpPk ) 
//             != DiscussionPost.dpVersionId
//  */               
// """)
// @ReplicationRunOnChange([DiscussionPost::class])
// @ReplicationCheckPendingNotificationsFor([DiscussionPost::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("dpPk", "dpDestination"),
  indices = arrayOf(Index(value = arrayOf("dpPk", "dpDestination", "dpVersionId")),
  Index(value = arrayOf("dpDestination", "dpPending")))

)
@Serializable
public class DiscussionPostReplicate {
  @ReplicationEntityForeignKey
  public var dpPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var dpVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var dpDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var dpPending: Boolean = true
}
