// @Triggers(arrayOf(
//     Trigger(
//         name = "messageread_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO MessageRead(messageReadUid, messageReadPersonUid, messageReadMessageUid, messageReadEntityUid, messageReadLct) 
//             VALUES (NEW.messageReadUid, NEW.messageReadPersonUid, NEW.messageReadMessageUid, NEW.messageReadEntityUid, NEW.messageReadLct) 
//             /*psql ON CONFLICT (messageReadUid) DO UPDATE 
//             SET messageReadPersonUid = EXCLUDED.messageReadPersonUid, messageReadMessageUid = EXCLUDED.messageReadMessageUid, messageReadEntityUid = EXCLUDED.messageReadEntityUid, messageReadLct = EXCLUDED.messageReadLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO MessageReadReplicate(mrPk, mrDestination)
//      SELECT MessageRead.messageReadUid AS mrPk,
//             :newNodeId AS mrDestination
//        FROM MessageRead
//       --notpsql 
//       WHERE MessageRead.messageReadLct != COALESCE(
//             (SELECT mrVersionId
//                FROM MessageReadReplicate
//               WHERE mrPk = MessageRead.messageReadUid
//                 AND mrDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(mrPk, mrDestination) DO UPDATE
//             SET mrPending = (SELECT MessageRead.messageReadLct
//            FROM MessageRead
//           WHERE MessageRead.messageReadUid = EXCLUDED.mrPk ) 
//                 != MessageReadReplicate.mrVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([MessageRead::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO MessageReadReplicate(mrPk, mrDestination)
//  SELECT MessageRead.messageReadUid AS mrUid,
//         UserSession.usClientNodeId AS mrDestination
//    FROM ChangeLog
//         JOIN MessageRead
//             ON ChangeLog.chTableId = ${MessageRead.TABLE_ID}
//                AND ChangeLog.chEntityPk = MessageRead.messageReadUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND MessageRead.messageReadLct != COALESCE(
//         (SELECT mrVersionId
//            FROM MessageReadReplicate
//           WHERE mrPk = MessageRead.messageReadUid
//             AND mrDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(mrPk, mrDestination) DO UPDATE
//     SET mrPending = (SELECT MessageRead.messageReadLct
//        FROM MessageRead
//       WHERE MessageReadmessageReadUid = EXCLUDED.mrPk ) 
//             != MessageRead.mrVersionId
//  */               
// """)
// @ReplicationRunOnChange([MessageRead::class])
// @ReplicationCheckPendingNotificationsFor([MessageRead::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("mrPk", "mrDestination"),
  indices = arrayOf(Index(value = arrayOf("mrPk", "mrDestination", "mrVersionId")),
  Index(value = arrayOf("mrDestination", "mrPending")))

)
@Serializable
public class MessageReadReplicate {
  @ReplicationEntityForeignKey
  public var mrPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var mrVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var mrDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var mrPending: Boolean = true
}
