// @Triggers(arrayOf(
//     Trigger(
//         name = "persongroupmember_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO PersonGroupMember(groupMemberUid, groupMemberActive, groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy, groupMemberLct) 
//             VALUES (NEW.groupMemberUid, NEW.groupMemberActive, NEW.groupMemberPersonUid, NEW.groupMemberGroupUid, NEW.groupMemberMasterCsn, NEW.groupMemberLocalCsn, NEW.groupMemberLastChangedBy, NEW.groupMemberLct) 
//             /*psql ON CONFLICT (groupMemberUid) DO UPDATE 
//             SET groupMemberActive = EXCLUDED.groupMemberActive, groupMemberPersonUid = EXCLUDED.groupMemberPersonUid, groupMemberGroupUid = EXCLUDED.groupMemberGroupUid, groupMemberMasterCsn = EXCLUDED.groupMemberMasterCsn, groupMemberLocalCsn = EXCLUDED.groupMemberLocalCsn, groupMemberLastChangedBy = EXCLUDED.groupMemberLastChangedBy, groupMemberLct = EXCLUDED.groupMemberLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)
//      SELECT PersonGroupMember.groupMemberUid AS pgmPk,
//             :newNodeId AS pgmDestination
//        FROM PersonGroupMember
//       --notpsql 
//       WHERE PersonGroupMember.groupMemberLct != COALESCE(
//             (SELECT pgmVersionId
//                FROM PersonGroupMemberReplicate
//               WHERE pgmPk = PersonGroupMember.groupMemberUid
//                 AND pgmDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE
//             SET pgmPending = (SELECT PersonGroupMember.groupMemberLct
//            FROM PersonGroupMember
//           WHERE PersonGroupMember.groupMemberUid = EXCLUDED.pgmPk ) 
//                 != PersonGroupMemberReplicate.pgmVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([PersonGroupMember::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)
//  SELECT PersonGroupMember.groupMemberUid AS pgmUid,
//         UserSession.usClientNodeId AS pgmDestination
//    FROM ChangeLog
//         JOIN PersonGroupMember
//             ON ChangeLog.chTableId = ${PersonGroupMember.TABLE_ID}
//                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND PersonGroupMember.groupMemberLct != COALESCE(
//         (SELECT pgmVersionId
//            FROM PersonGroupMemberReplicate
//           WHERE pgmPk = PersonGroupMember.groupMemberUid
//             AND pgmDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE
//     SET pgmPending = (SELECT PersonGroupMember.groupMemberLct
//        FROM PersonGroupMember
//       WHERE PersonGroupMembergroupMemberUid = EXCLUDED.pgmPk ) 
//             != PersonGroupMember.pgmVersionId
//  */               
// """)
// @ReplicationRunOnChange([PersonGroupMember::class])
// @ReplicationCheckPendingNotificationsFor([PersonGroupMember::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("pgmPk", "pgmDestination"),
  indices = arrayOf(Index(value = arrayOf("pgmPk", "pgmDestination", "pgmVersionId")),
  Index(value = arrayOf("pgmDestination", "pgmPending")))

)
@Serializable
public class PersonGroupMemberReplicate {
  @ReplicationEntityForeignKey
  public var pgmPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var pgmVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var pgmDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var pgmPending: Boolean = true
}
