// @Triggers(arrayOf(
//     Trigger(
//         name = "chatmember_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO ChatMember(chatMemberUid, chatMemberChatUid, chatMemberPersonUid, chatMemberJoinedDate, chatMemberLeftDate, chatMemberLct) 
//             VALUES (NEW.chatMemberUid, NEW.chatMemberChatUid, NEW.chatMemberPersonUid, NEW.chatMemberJoinedDate, NEW.chatMemberLeftDate, NEW.chatMemberLct) 
//             /*psql ON CONFLICT (chatMemberUid) DO UPDATE 
//             SET chatMemberChatUid = EXCLUDED.chatMemberChatUid, chatMemberPersonUid = EXCLUDED.chatMemberPersonUid, chatMemberJoinedDate = EXCLUDED.chatMemberJoinedDate, chatMemberLeftDate = EXCLUDED.chatMemberLeftDate, chatMemberLct = EXCLUDED.chatMemberLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO ChatMemberReplicate(cmPk, cmDestination)
//      SELECT ChatMember.chatMemberUid AS cmPk,
//             :newNodeId AS cmDestination
//        FROM ChatMember
//       --notpsql 
//       WHERE ChatMember.chatMemberLct != COALESCE(
//             (SELECT cmVersionId
//                FROM ChatMemberReplicate
//               WHERE cmPk = ChatMember.chatMemberUid
//                 AND cmDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cmPk, cmDestination) DO UPDATE
//             SET cmPending = (SELECT ChatMember.chatMemberLct
//            FROM ChatMember
//           WHERE ChatMember.chatMemberUid = EXCLUDED.cmPk ) 
//                 != ChatMemberReplicate.cmVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([ChatMember::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO ChatMemberReplicate(cmPk, cmDestination)
//  SELECT ChatMember.chatMemberUid AS cmUid,
//         UserSession.usClientNodeId AS cmDestination
//    FROM ChangeLog
//         JOIN ChatMember
//             ON ChangeLog.chTableId = ${ChatMember.TABLE_ID}
//                AND ChangeLog.chEntityPk = ChatMember.chatMemberUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND ChatMember.chatMemberLct != COALESCE(
//         (SELECT cmVersionId
//            FROM ChatMemberReplicate
//           WHERE cmPk = ChatMember.chatMemberUid
//             AND cmDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cmPk, cmDestination) DO UPDATE
//     SET cmPending = (SELECT ChatMember.chatMemberLct
//        FROM ChatMember
//       WHERE ChatMemberchatMemberUid = EXCLUDED.cmPk ) 
//             != ChatMember.cmVersionId
//  */               
// """)
// @ReplicationRunOnChange([ChatMember::class])
// @ReplicationCheckPendingNotificationsFor([ChatMember::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cmPk", "cmDestination"),
  indices = arrayOf(Index(value = arrayOf("cmPk", "cmDestination", "cmVersionId")),
  Index(value = arrayOf("cmDestination", "cmPending")))

)
@Serializable
public class ChatMemberReplicate {
  @ReplicationEntityForeignKey
  public var cmPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cmVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cmDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cmPending: Boolean = true
}
