// @Triggers(arrayOf(
//     Trigger(
//         name = "clazzassignment_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO ClazzAssignment(caUid, caTitle, caDescription, caGroupUid, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caCompletionCriteria, caRequireFileSubmission, caFileType, caSizeLimit, caNumberOfFiles, caSubmissionPolicy, caMarkingType, caRequireTextSubmission, caTextLimitType, caTextLimit, caXObjectUid, caClazzUid, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) 
//             VALUES (NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caGroupUid, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caCompletionCriteria, NEW.caRequireFileSubmission, NEW.caFileType, NEW.caSizeLimit, NEW.caNumberOfFiles, NEW.caSubmissionPolicy, NEW.caMarkingType, NEW.caRequireTextSubmission, NEW.caTextLimitType, NEW.caTextLimit, NEW.caXObjectUid, NEW.caClazzUid, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) 
//             /*psql ON CONFLICT (caUid) DO UPDATE 
//             SET caTitle = EXCLUDED.caTitle, caDescription = EXCLUDED.caDescription, caGroupUid = EXCLUDED.caGroupUid, caActive = EXCLUDED.caActive, caClassCommentEnabled = EXCLUDED.caClassCommentEnabled, caPrivateCommentsEnabled = EXCLUDED.caPrivateCommentsEnabled, caCompletionCriteria = EXCLUDED.caCompletionCriteria, caRequireFileSubmission = EXCLUDED.caRequireFileSubmission, caFileType = EXCLUDED.caFileType, caSizeLimit = EXCLUDED.caSizeLimit, caNumberOfFiles = EXCLUDED.caNumberOfFiles, caSubmissionPolicy = EXCLUDED.caSubmissionPolicy, caMarkingType = EXCLUDED.caMarkingType, caRequireTextSubmission = EXCLUDED.caRequireTextSubmission, caTextLimitType = EXCLUDED.caTextLimitType, caTextLimit = EXCLUDED.caTextLimit, caXObjectUid = EXCLUDED.caXObjectUid, caClazzUid = EXCLUDED.caClazzUid, caLocalChangeSeqNum = EXCLUDED.caLocalChangeSeqNum, caMasterChangeSeqNum = EXCLUDED.caMasterChangeSeqNum, caLastChangedBy = EXCLUDED.caLastChangedBy, caLct = EXCLUDED.caLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO ClazzAssignmentReplicate(caPk, caDestination)
//      SELECT ClazzAssignment.caUid AS caPk,
//             :newNodeId AS caDestination
//        FROM ClazzAssignment
//       --notpsql 
//       WHERE ClazzAssignment.caLct != COALESCE(
//             (SELECT caVersionId
//                FROM ClazzAssignmentReplicate
//               WHERE caPk = ClazzAssignment.caUid
//                 AND caDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(caPk, caDestination) DO UPDATE
//             SET caPending = (SELECT ClazzAssignment.caLct
//            FROM ClazzAssignment
//           WHERE ClazzAssignment.caUid = EXCLUDED.caPk ) 
//                 != ClazzAssignmentReplicate.caVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([ClazzAssignment::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO ClazzAssignmentReplicate(caPk, caDestination)
//  SELECT ClazzAssignment.caUid AS caUid,
//         UserSession.usClientNodeId AS caDestination
//    FROM ChangeLog
//         JOIN ClazzAssignment
//             ON ChangeLog.chTableId = ${ClazzAssignment.TABLE_ID}
//                AND ChangeLog.chEntityPk = ClazzAssignment.caUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND ClazzAssignment.caLct != COALESCE(
//         (SELECT caVersionId
//            FROM ClazzAssignmentReplicate
//           WHERE caPk = ClazzAssignment.caUid
//             AND caDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(caPk, caDestination) DO UPDATE
//     SET caPending = (SELECT ClazzAssignment.caLct
//        FROM ClazzAssignment
//       WHERE ClazzAssignmentcaUid = EXCLUDED.caPk ) 
//             != ClazzAssignment.caVersionId
//  */               
// """)
// @ReplicationRunOnChange([ClazzAssignment::class])
// @ReplicationCheckPendingNotificationsFor([ClazzAssignment::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("caPk", "caDestination"),
  indices = arrayOf(Index(value = arrayOf("caPk", "caDestination", "caVersionId")),
  Index(value = arrayOf("caDestination", "caPending")))

)
@Serializable
public class ClazzAssignmentReplicate {
  @ReplicationEntityForeignKey
  public var caPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var caVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var caDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var caPending: Boolean = true
}
