// @Triggers(arrayOf(
//     Trigger(
//         name = "courseassignmentmark_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseAssignmentMark(camUid, camAssignmentUid, camSubmitterUid, camMark, camPenalty, camLct) 
//             VALUES (NEW.camUid, NEW.camAssignmentUid, NEW.camSubmitterUid, NEW.camMark, NEW.camPenalty, NEW.camLct) 
//             /*psql ON CONFLICT (camUid) DO UPDATE 
//             SET camAssignmentUid = EXCLUDED.camAssignmentUid, camSubmitterUid = EXCLUDED.camSubmitterUid, camMark = EXCLUDED.camMark, camPenalty = EXCLUDED.camPenalty, camLct = EXCLUDED.camLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseAssignmentMarkReplicate(camPk, camDestination)
//      SELECT CourseAssignmentMark.camUid AS camPk,
//             :newNodeId AS camDestination
//        FROM CourseAssignmentMark
//       --notpsql 
//       WHERE CourseAssignmentMark.camLct != COALESCE(
//             (SELECT camVersionId
//                FROM CourseAssignmentMarkReplicate
//               WHERE camPk = CourseAssignmentMark.camUid
//                 AND camDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(camPk, camDestination) DO UPDATE
//             SET camPending = (SELECT CourseAssignmentMark.camLct
//            FROM CourseAssignmentMark
//           WHERE CourseAssignmentMark.camUid = EXCLUDED.camPk ) 
//                 != CourseAssignmentMarkReplicate.camVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseAssignmentMark::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseAssignmentMarkReplicate(camPk, camDestination)
//  SELECT CourseAssignmentMark.camUid AS camUid,
//         UserSession.usClientNodeId AS camDestination
//    FROM ChangeLog
//         JOIN CourseAssignmentMark
//             ON ChangeLog.chTableId = ${CourseAssignmentMark.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseAssignmentMark.camUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseAssignmentMark.camLct != COALESCE(
//         (SELECT camVersionId
//            FROM CourseAssignmentMarkReplicate
//           WHERE camPk = CourseAssignmentMark.camUid
//             AND camDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(camPk, camDestination) DO UPDATE
//     SET camPending = (SELECT CourseAssignmentMark.camLct
//        FROM CourseAssignmentMark
//       WHERE CourseAssignmentMarkcamUid = EXCLUDED.camPk ) 
//             != CourseAssignmentMark.camVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseAssignmentMark::class])
// @ReplicationCheckPendingNotificationsFor([CourseAssignmentMark::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("camPk", "camDestination"),
  indices = arrayOf(Index(value = arrayOf("camPk", "camDestination", "camVersionId")),
  Index(value = arrayOf("camDestination", "camPending")))

)
@Serializable
public class CourseAssignmentMarkReplicate {
  @ReplicationEntityForeignKey
  public var camPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var camVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var camDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var camPending: Boolean = true
}
