// @Triggers(arrayOf(
//     Trigger(
//         name = "courseassignmentsubmissionattachment_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseAssignmentSubmissionAttachment(casaUid, casaSubmissionUid, casaMimeType, casaFileName, casaUri, casaMd5, casaSize, casaTimestamp) 
//             VALUES (NEW.casaUid, NEW.casaSubmissionUid, NEW.casaMimeType, NEW.casaFileName, NEW.casaUri, NEW.casaMd5, NEW.casaSize, NEW.casaTimestamp) 
//             /*psql ON CONFLICT (casaUid) DO UPDATE 
//             SET casaSubmissionUid = EXCLUDED.casaSubmissionUid, casaMimeType = EXCLUDED.casaMimeType, casaFileName = EXCLUDED.casaFileName, casaUri = EXCLUDED.casaUri, casaMd5 = EXCLUDED.casaMd5, casaSize = EXCLUDED.casaSize, casaTimestamp = EXCLUDED.casaTimestamp
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)
//      SELECT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,
//             :newNodeId AS casaDestination
//        FROM CourseAssignmentSubmissionAttachment
//       --notpsql 
//       WHERE CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(
//             (SELECT casaVersionId
//                FROM CourseAssignmentSubmissionAttachmentReplicate
//               WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid
//                 AND casaDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE
//             SET casaPending = (SELECT CourseAssignmentSubmissionAttachment.casaTimestamp
//            FROM CourseAssignmentSubmissionAttachment
//           WHERE CourseAssignmentSubmissionAttachment.casaUid = EXCLUDED.casaPk ) 
//                 != CourseAssignmentSubmissionAttachmentReplicate.casaVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseAssignmentSubmissionAttachment::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)
//  SELECT CourseAssignmentSubmissionAttachment.casaUid AS casaUid,
//         UserSession.usClientNodeId AS casaDestination
//    FROM ChangeLog
//         JOIN CourseAssignmentSubmissionAttachment
//             ON ChangeLog.chTableId = ${CourseAssignmentSubmissionAttachment.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseAssignmentSubmissionAttachment.casaUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(
//         (SELECT casaVersionId
//            FROM CourseAssignmentSubmissionAttachmentReplicate
//           WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid
//             AND casaDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE
//     SET casaPending = (SELECT CourseAssignmentSubmissionAttachment.casaTimestamp
//        FROM CourseAssignmentSubmissionAttachment
//       WHERE CourseAssignmentSubmissionAttachmentcasaUid = EXCLUDED.casaPk ) 
//             != CourseAssignmentSubmissionAttachment.casaVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseAssignmentSubmissionAttachment::class])
// @ReplicationCheckPendingNotificationsFor([CourseAssignmentSubmissionAttachment::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("casaPk", "casaDestination"),
  indices = arrayOf(Index(value = arrayOf("casaPk", "casaDestination", "casaVersionId")),
  Index(value = arrayOf("casaDestination", "casaPending")))

)
@Serializable
public class CourseAssignmentSubmissionAttachmentReplicate {
  @ReplicationEntityForeignKey
  public var casaPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var casaVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var casaDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var casaPending: Boolean = true
}
