// @Triggers(arrayOf(
//     Trigger(
//         name = "courseassignmentsubmission_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseAssignmentSubmission(casUid, casAssignmentUid, casSubmitterUid, casSubmitterPersonUid, casText, casType, casTimestamp) 
//             VALUES (NEW.casUid, NEW.casAssignmentUid, NEW.casSubmitterUid, NEW.casSubmitterPersonUid, NEW.casText, NEW.casType, NEW.casTimestamp) 
//             /*psql ON CONFLICT (casUid) DO UPDATE 
//             SET casAssignmentUid = EXCLUDED.casAssignmentUid, casSubmitterUid = EXCLUDED.casSubmitterUid, casSubmitterPersonUid = EXCLUDED.casSubmitterPersonUid, casText = EXCLUDED.casText, casType = EXCLUDED.casType, casTimestamp = EXCLUDED.casTimestamp
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseAssignmentSubmissionReplicate(casPk, casDestination)
//      SELECT CourseAssignmentSubmission.casUid AS casPk,
//             :newNodeId AS casDestination
//        FROM CourseAssignmentSubmission
//       --notpsql 
//       WHERE CourseAssignmentSubmission.casTimestamp != COALESCE(
//             (SELECT casVersionId
//                FROM CourseAssignmentSubmissionReplicate
//               WHERE casPk = CourseAssignmentSubmission.casUid
//                 AND casDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(casPk, casDestination) DO UPDATE
//             SET casPending = (SELECT CourseAssignmentSubmission.casTimestamp
//            FROM CourseAssignmentSubmission
//           WHERE CourseAssignmentSubmission.casUid = EXCLUDED.casPk ) 
//                 != CourseAssignmentSubmissionReplicate.casVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseAssignmentSubmission::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseAssignmentSubmissionReplicate(casPk, casDestination)
//  SELECT CourseAssignmentSubmission.casUid AS casUid,
//         UserSession.usClientNodeId AS casDestination
//    FROM ChangeLog
//         JOIN CourseAssignmentSubmission
//             ON ChangeLog.chTableId = ${CourseAssignmentSubmission.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseAssignmentSubmission.casUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseAssignmentSubmission.casTimestamp != COALESCE(
//         (SELECT casVersionId
//            FROM CourseAssignmentSubmissionReplicate
//           WHERE casPk = CourseAssignmentSubmission.casUid
//             AND casDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(casPk, casDestination) DO UPDATE
//     SET casPending = (SELECT CourseAssignmentSubmission.casTimestamp
//        FROM CourseAssignmentSubmission
//       WHERE CourseAssignmentSubmissioncasUid = EXCLUDED.casPk ) 
//             != CourseAssignmentSubmission.casVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseAssignmentSubmission::class])
// @ReplicationCheckPendingNotificationsFor([CourseAssignmentSubmission::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("casPk", "casDestination"),
  indices = arrayOf(Index(value = arrayOf("casPk", "casDestination", "casVersionId")),
  Index(value = arrayOf("casDestination", "casPending")))

)
@Serializable
public class CourseAssignmentSubmissionReplicate {
  @ReplicationEntityForeignKey
  public var casPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var casVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var casDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var casPending: Boolean = true
}
