// @Triggers(arrayOf(
//     Trigger(
//         name = "coursediscussion_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseDiscussion(courseDiscussionUid, courseDiscussionTitle, courseDiscussionDesc, courseDiscussionClazzUid, courseDiscussionActive, courseDiscussionLct) 
//             VALUES (NEW.courseDiscussionUid, NEW.courseDiscussionTitle, NEW.courseDiscussionDesc, NEW.courseDiscussionClazzUid, NEW.courseDiscussionActive, NEW.courseDiscussionLct) 
//             /*psql ON CONFLICT (courseDiscussionUid) DO UPDATE 
//             SET courseDiscussionTitle = EXCLUDED.courseDiscussionTitle, courseDiscussionDesc = EXCLUDED.courseDiscussionDesc, courseDiscussionClazzUid = EXCLUDED.courseDiscussionClazzUid, courseDiscussionActive = EXCLUDED.courseDiscussionActive, courseDiscussionLct = EXCLUDED.courseDiscussionLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseDiscussionReplicate(cdPk, cdDestination)
//      SELECT CourseDiscussion.courseDiscussionUid AS cdPk,
//             :newNodeId AS cdDestination
//        FROM CourseDiscussion
//       --notpsql 
//       WHERE CourseDiscussion.courseDiscussionLct != COALESCE(
//             (SELECT cdVersionId
//                FROM CourseDiscussionReplicate
//               WHERE cdPk = CourseDiscussion.courseDiscussionUid
//                 AND cdDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cdPk, cdDestination) DO UPDATE
//             SET cdPending = (SELECT CourseDiscussion.courseDiscussionLct
//            FROM CourseDiscussion
//           WHERE CourseDiscussion.courseDiscussionUid = EXCLUDED.cdPk ) 
//                 != CourseDiscussionReplicate.cdVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseDiscussion::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseDiscussionReplicate(cdPk, cdDestination)
//  SELECT CourseDiscussion.courseDiscussionUid AS cdUid,
//         UserSession.usClientNodeId AS cdDestination
//    FROM ChangeLog
//         JOIN CourseDiscussion
//             ON ChangeLog.chTableId = ${CourseDiscussion.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseDiscussion.courseDiscussionUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseDiscussion.courseDiscussionLct != COALESCE(
//         (SELECT cdVersionId
//            FROM CourseDiscussionReplicate
//           WHERE cdPk = CourseDiscussion.courseDiscussionUid
//             AND cdDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cdPk, cdDestination) DO UPDATE
//     SET cdPending = (SELECT CourseDiscussion.courseDiscussionLct
//        FROM CourseDiscussion
//       WHERE CourseDiscussioncourseDiscussionUid = EXCLUDED.cdPk ) 
//             != CourseDiscussion.cdVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseDiscussion::class])
// @ReplicationCheckPendingNotificationsFor([CourseDiscussion::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cdPk", "cdDestination"),
  indices = arrayOf(Index(value = arrayOf("cdPk", "cdDestination", "cdVersionId")),
  Index(value = arrayOf("cdDestination", "cdPending")))

)
@Serializable
public class CourseDiscussionReplicate {
  @ReplicationEntityForeignKey
  public var cdPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cdVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cdDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cdPending: Boolean = true
}
