// @Triggers(arrayOf(
//     Trigger(
//         name = "coursegroupmember_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CourseGroupMember(cgmUid, cgmSetUid, cgmGroupNumber, cgmPersonUid, cgmLct) 
//             VALUES (NEW.cgmUid, NEW.cgmSetUid, NEW.cgmGroupNumber, NEW.cgmPersonUid, NEW.cgmLct) 
//             /*psql ON CONFLICT (cgmUid) DO UPDATE 
//             SET cgmSetUid = EXCLUDED.cgmSetUid, cgmGroupNumber = EXCLUDED.cgmGroupNumber, cgmPersonUid = EXCLUDED.cgmPersonUid, cgmLct = EXCLUDED.cgmLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CourseGroupMemberReplicate(cgmPk, cgmDestination)
//      SELECT CourseGroupMember.cgmUid AS cgmPk,
//             :newNodeId AS cgmDestination
//        FROM CourseGroupMember
//       --notpsql 
//       WHERE CourseGroupMember.cgmLct != COALESCE(
//             (SELECT cgmVersionId
//                FROM CourseGroupMemberReplicate
//               WHERE cgmPk = CourseGroupMember.cgmUid
//                 AND cgmDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cgmPk, cgmDestination) DO UPDATE
//             SET cgmPending = (SELECT CourseGroupMember.cgmLct
//            FROM CourseGroupMember
//           WHERE CourseGroupMember.cgmUid = EXCLUDED.cgmPk ) 
//                 != CourseGroupMemberReplicate.cgmVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CourseGroupMember::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CourseGroupMemberReplicate(cgmPk, cgmDestination)
//  SELECT CourseGroupMember.cgmUid AS cgmUid,
//         UserSession.usClientNodeId AS cgmDestination
//    FROM ChangeLog
//         JOIN CourseGroupMember
//             ON ChangeLog.chTableId = ${CourseGroupMember.TABLE_ID}
//                AND ChangeLog.chEntityPk = CourseGroupMember.cgmUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CourseGroupMember.cgmLct != COALESCE(
//         (SELECT cgmVersionId
//            FROM CourseGroupMemberReplicate
//           WHERE cgmPk = CourseGroupMember.cgmUid
//             AND cgmDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cgmPk, cgmDestination) DO UPDATE
//     SET cgmPending = (SELECT CourseGroupMember.cgmLct
//        FROM CourseGroupMember
//       WHERE CourseGroupMembercgmUid = EXCLUDED.cgmPk ) 
//             != CourseGroupMember.cgmVersionId
//  */               
// """)
// @ReplicationRunOnChange([CourseGroupMember::class])
// @ReplicationCheckPendingNotificationsFor([CourseGroupMember::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cgmPk", "cgmDestination"),
  indices = arrayOf(Index(value = arrayOf("cgmPk", "cgmDestination", "cgmVersionId")),
  Index(value = arrayOf("cgmDestination", "cgmPending")))

)
@Serializable
public class CourseGroupMemberReplicate {
  @ReplicationEntityForeignKey
  public var cgmPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cgmVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cgmDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cgmPending: Boolean = true
}
