// @Triggers(arrayOf(
//     Trigger(
//         name = "coursepicture_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO CoursePicture(coursePictureUid, coursePictureClazzUid, coursePictureMasterCsn, coursePictureLocalCsn, coursePictureLastChangedBy, coursePictureLct, coursePictureUri, coursePictureMd5, coursePictureFileSize, coursePictureTimestamp, coursePictureMimeType, coursePictureActive) 
//             VALUES (NEW.coursePictureUid, NEW.coursePictureClazzUid, NEW.coursePictureMasterCsn, NEW.coursePictureLocalCsn, NEW.coursePictureLastChangedBy, NEW.coursePictureLct, NEW.coursePictureUri, NEW.coursePictureMd5, NEW.coursePictureFileSize, NEW.coursePictureTimestamp, NEW.coursePictureMimeType, NEW.coursePictureActive) 
//             /*psql ON CONFLICT (coursePictureUid) DO UPDATE 
//             SET coursePictureClazzUid = EXCLUDED.coursePictureClazzUid, coursePictureMasterCsn = EXCLUDED.coursePictureMasterCsn, coursePictureLocalCsn = EXCLUDED.coursePictureLocalCsn, coursePictureLastChangedBy = EXCLUDED.coursePictureLastChangedBy, coursePictureLct = EXCLUDED.coursePictureLct, coursePictureUri = EXCLUDED.coursePictureUri, coursePictureMd5 = EXCLUDED.coursePictureMd5, coursePictureFileSize = EXCLUDED.coursePictureFileSize, coursePictureTimestamp = EXCLUDED.coursePictureTimestamp, coursePictureMimeType = EXCLUDED.coursePictureMimeType, coursePictureActive = EXCLUDED.coursePictureActive
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)
//      SELECT CoursePicture.coursePictureUid AS cpPk,
//             :newNodeId AS cpDestination
//        FROM CoursePicture
//       --notpsql 
//       WHERE CoursePicture.coursePictureLct != COALESCE(
//             (SELECT cpVersionId
//                FROM CoursePictureReplicate
//               WHERE cpPk = CoursePicture.coursePictureUid
//                 AND cpDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE
//             SET cpPending = (SELECT CoursePicture.coursePictureLct
//            FROM CoursePicture
//           WHERE CoursePicture.coursePictureUid = EXCLUDED.cpPk ) 
//                 != CoursePictureReplicate.cpVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([CoursePicture::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)
//  SELECT CoursePicture.coursePictureUid AS cpUid,
//         UserSession.usClientNodeId AS cpDestination
//    FROM ChangeLog
//         JOIN CoursePicture
//             ON ChangeLog.chTableId = ${CoursePicture.TABLE_ID}
//                AND ChangeLog.chEntityPk = CoursePicture.coursePictureUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND CoursePicture.coursePictureLct != COALESCE(
//         (SELECT cpVersionId
//            FROM CoursePictureReplicate
//           WHERE cpPk = CoursePicture.coursePictureUid
//             AND cpDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE
//     SET cpPending = (SELECT CoursePicture.coursePictureLct
//        FROM CoursePicture
//       WHERE CoursePicturecoursePictureUid = EXCLUDED.cpPk ) 
//             != CoursePicture.cpVersionId
//  */               
// """)
// @ReplicationRunOnChange([CoursePicture::class])
// @ReplicationCheckPendingNotificationsFor([CoursePicture::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("cpPk", "cpDestination"),
  indices = arrayOf(Index(value = arrayOf("cpPk", "cpDestination", "cpVersionId")),
  Index(value = arrayOf("cpDestination", "cpPending")))

)
@Serializable
public class CoursePictureReplicate {
  @ReplicationEntityForeignKey
  public var cpPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var cpVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var cpDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var cpPending: Boolean = true
}
