// @Triggers(arrayOf(
//     Trigger(
//         name = "discussiontopic_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO DiscussionTopic(discussionTopicUid, discussionTopicTitle, discussionTopicDesc, discussionTopicStartDate, discussionTopicCourseDiscussionUid, discussionTopicVisible, discussionTopicArchive, discussionTopicIndex, discussionTopicClazzUid, discussionTopicLct) 
//             VALUES (NEW.discussionTopicUid, NEW.discussionTopicTitle, NEW.discussionTopicDesc, NEW.discussionTopicStartDate, NEW.discussionTopicCourseDiscussionUid, NEW.discussionTopicVisible, NEW.discussionTopicArchive, NEW.discussionTopicIndex, NEW.discussionTopicClazzUid, NEW.discussionTopicLct) 
//             /*psql ON CONFLICT (discussionTopicUid) DO UPDATE 
//             SET discussionTopicTitle = EXCLUDED.discussionTopicTitle, discussionTopicDesc = EXCLUDED.discussionTopicDesc, discussionTopicStartDate = EXCLUDED.discussionTopicStartDate, discussionTopicCourseDiscussionUid = EXCLUDED.discussionTopicCourseDiscussionUid, discussionTopicVisible = EXCLUDED.discussionTopicVisible, discussionTopicArchive = EXCLUDED.discussionTopicArchive, discussionTopicIndex = EXCLUDED.discussionTopicIndex, discussionTopicClazzUid = EXCLUDED.discussionTopicClazzUid, discussionTopicLct = EXCLUDED.discussionTopicLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO DiscussionTopicReplicate(dtPk, dtDestination)
//      SELECT DiscussionTopic.discussionTopicUid AS dtPk,
//             :newNodeId AS dtDestination
//        FROM DiscussionTopic
//       --notpsql 
//       WHERE DiscussionTopic.discussionTopicLct != COALESCE(
//             (SELECT dtVersionId
//                FROM DiscussionTopicReplicate
//               WHERE dtPk = DiscussionTopic.discussionTopicUid
//                 AND dtDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(dtPk, dtDestination) DO UPDATE
//             SET dtPending = (SELECT DiscussionTopic.discussionTopicLct
//            FROM DiscussionTopic
//           WHERE DiscussionTopic.discussionTopicUid = EXCLUDED.dtPk ) 
//                 != DiscussionTopicReplicate.dtVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([DiscussionTopic::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO DiscussionTopicReplicate(dtPk, dtDestination)
//  SELECT DiscussionTopic.discussionTopicUid AS dtUid,
//         UserSession.usClientNodeId AS dtDestination
//    FROM ChangeLog
//         JOIN DiscussionTopic
//             ON ChangeLog.chTableId = ${DiscussionTopic.TABLE_ID}
//                AND ChangeLog.chEntityPk = DiscussionTopic.discussionTopicUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND DiscussionTopic.discussionTopicLct != COALESCE(
//         (SELECT dtVersionId
//            FROM DiscussionTopicReplicate
//           WHERE dtPk = DiscussionTopic.discussionTopicUid
//             AND dtDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(dtPk, dtDestination) DO UPDATE
//     SET dtPending = (SELECT DiscussionTopic.discussionTopicLct
//        FROM DiscussionTopic
//       WHERE DiscussionTopicdiscussionTopicUid = EXCLUDED.dtPk ) 
//             != DiscussionTopic.dtVersionId
//  */               
// """)
// @ReplicationRunOnChange([DiscussionTopic::class])
// @ReplicationCheckPendingNotificationsFor([DiscussionTopic::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("dtPk", "dtDestination"),
  indices = arrayOf(Index(value = arrayOf("dtPk", "dtDestination", "dtVersionId")),
  Index(value = arrayOf("dtDestination", "dtPending")))

)
@Serializable
public class DiscussionTopicReplicate {
  @ReplicationEntityForeignKey
  public var dtPk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var dtVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var dtDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var dtPending: Boolean = true
}
