// @Triggers(arrayOf(
//     Trigger(
//         name = "message_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO Message(messageUid, messageSenderPersonUid, messageTableId, messageEntityUid, messageText, messageTimestamp, messageClazzUid, messageLct) 
//             VALUES (NEW.messageUid, NEW.messageSenderPersonUid, NEW.messageTableId, NEW.messageEntityUid, NEW.messageText, NEW.messageTimestamp, NEW.messageClazzUid, NEW.messageLct) 
//             /*psql ON CONFLICT (messageUid) DO UPDATE 
//             SET messageSenderPersonUid = EXCLUDED.messageSenderPersonUid, messageTableId = EXCLUDED.messageTableId, messageEntityUid = EXCLUDED.messageEntityUid, messageText = EXCLUDED.messageText, messageTimestamp = EXCLUDED.messageTimestamp, messageClazzUid = EXCLUDED.messageClazzUid, messageLct = EXCLUDED.messageLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO MessageReplicate(messagePk, messageDestination)
//      SELECT Message.messageUid AS messagePk,
//             :newNodeId AS messageDestination
//        FROM Message
//       --notpsql 
//       WHERE Message.messageLct != COALESCE(
//             (SELECT messageVersionId
//                FROM MessageReplicate
//               WHERE messagePk = Message.messageUid
//                 AND messageDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(messagePk, messageDestination) DO UPDATE
//             SET messagePending = (SELECT Message.messageLct
//            FROM Message
//           WHERE Message.messageUid = EXCLUDED.messagePk ) 
//                 != MessageReplicate.messageVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([Message::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO MessageReplicate(messagePk, messageDestination)
//  SELECT Message.messageUid AS messageUid,
//         UserSession.usClientNodeId AS messageDestination
//    FROM ChangeLog
//         JOIN Message
//             ON ChangeLog.chTableId = ${Message.TABLE_ID}
//                AND ChangeLog.chEntityPk = Message.messageUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND Message.messageLct != COALESCE(
//         (SELECT messageVersionId
//            FROM MessageReplicate
//           WHERE messagePk = Message.messageUid
//             AND messageDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(messagePk, messageDestination) DO UPDATE
//     SET messagePending = (SELECT Message.messageLct
//        FROM Message
//       WHERE MessagemessageUid = EXCLUDED.messagePk ) 
//             != Message.messageVersionId
//  */               
// """)
// @ReplicationRunOnChange([Message::class])
// @ReplicationCheckPendingNotificationsFor([Message::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("messagePk", "messageDestination"),
  indices = arrayOf(Index(value = arrayOf("messagePk", "messageDestination", "messageVersionId")),
  Index(value = arrayOf("messageDestination", "messagePending")))

)
@Serializable
public class MessageReplicate {
  @ReplicationEntityForeignKey
  public var messagePk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var messageVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var messageDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var messagePending: Boolean = true
}
